// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/applicationserver_pubsub.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ApplicationPubSubRegistry_GetFormats_FullMethodName = "/ttn.lorawan.v3.ApplicationPubSubRegistry/GetFormats"
	ApplicationPubSubRegistry_Get_FullMethodName        = "/ttn.lorawan.v3.ApplicationPubSubRegistry/Get"
	ApplicationPubSubRegistry_List_FullMethodName       = "/ttn.lorawan.v3.ApplicationPubSubRegistry/List"
	ApplicationPubSubRegistry_Set_FullMethodName        = "/ttn.lorawan.v3.ApplicationPubSubRegistry/Set"
	ApplicationPubSubRegistry_Delete_FullMethodName     = "/ttn.lorawan.v3.ApplicationPubSubRegistry/Delete"
)

// ApplicationPubSubRegistryClient is the client API for ApplicationPubSubRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationPubSubRegistryClient interface {
	GetFormats(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ApplicationPubSubFormats, error)
	Get(ctx context.Context, in *GetApplicationPubSubRequest, opts ...grpc.CallOption) (*ApplicationPubSub, error)
	List(ctx context.Context, in *ListApplicationPubSubsRequest, opts ...grpc.CallOption) (*ApplicationPubSubs, error)
	Set(ctx context.Context, in *SetApplicationPubSubRequest, opts ...grpc.CallOption) (*ApplicationPubSub, error)
	Delete(ctx context.Context, in *ApplicationPubSubIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type applicationPubSubRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationPubSubRegistryClient(cc grpc.ClientConnInterface) ApplicationPubSubRegistryClient {
	return &applicationPubSubRegistryClient{cc}
}

func (c *applicationPubSubRegistryClient) GetFormats(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ApplicationPubSubFormats, error) {
	out := new(ApplicationPubSubFormats)
	err := c.cc.Invoke(ctx, ApplicationPubSubRegistry_GetFormats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPubSubRegistryClient) Get(ctx context.Context, in *GetApplicationPubSubRequest, opts ...grpc.CallOption) (*ApplicationPubSub, error) {
	out := new(ApplicationPubSub)
	err := c.cc.Invoke(ctx, ApplicationPubSubRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPubSubRegistryClient) List(ctx context.Context, in *ListApplicationPubSubsRequest, opts ...grpc.CallOption) (*ApplicationPubSubs, error) {
	out := new(ApplicationPubSubs)
	err := c.cc.Invoke(ctx, ApplicationPubSubRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPubSubRegistryClient) Set(ctx context.Context, in *SetApplicationPubSubRequest, opts ...grpc.CallOption) (*ApplicationPubSub, error) {
	out := new(ApplicationPubSub)
	err := c.cc.Invoke(ctx, ApplicationPubSubRegistry_Set_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPubSubRegistryClient) Delete(ctx context.Context, in *ApplicationPubSubIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationPubSubRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationPubSubRegistryServer is the server API for ApplicationPubSubRegistry service.
// All implementations must embed UnimplementedApplicationPubSubRegistryServer
// for forward compatibility
type ApplicationPubSubRegistryServer interface {
	GetFormats(context.Context, *emptypb.Empty) (*ApplicationPubSubFormats, error)
	Get(context.Context, *GetApplicationPubSubRequest) (*ApplicationPubSub, error)
	List(context.Context, *ListApplicationPubSubsRequest) (*ApplicationPubSubs, error)
	Set(context.Context, *SetApplicationPubSubRequest) (*ApplicationPubSub, error)
	Delete(context.Context, *ApplicationPubSubIdentifiers) (*emptypb.Empty, error)
	mustEmbedUnimplementedApplicationPubSubRegistryServer()
}

// UnimplementedApplicationPubSubRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedApplicationPubSubRegistryServer struct {
}

func (UnimplementedApplicationPubSubRegistryServer) GetFormats(context.Context, *emptypb.Empty) (*ApplicationPubSubFormats, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFormats not implemented")
}
func (UnimplementedApplicationPubSubRegistryServer) Get(context.Context, *GetApplicationPubSubRequest) (*ApplicationPubSub, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedApplicationPubSubRegistryServer) List(context.Context, *ListApplicationPubSubsRequest) (*ApplicationPubSubs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedApplicationPubSubRegistryServer) Set(context.Context, *SetApplicationPubSubRequest) (*ApplicationPubSub, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Set not implemented")
}
func (UnimplementedApplicationPubSubRegistryServer) Delete(context.Context, *ApplicationPubSubIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedApplicationPubSubRegistryServer) mustEmbedUnimplementedApplicationPubSubRegistryServer() {
}

// UnsafeApplicationPubSubRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationPubSubRegistryServer will
// result in compilation errors.
type UnsafeApplicationPubSubRegistryServer interface {
	mustEmbedUnimplementedApplicationPubSubRegistryServer()
}

func RegisterApplicationPubSubRegistryServer(s grpc.ServiceRegistrar, srv ApplicationPubSubRegistryServer) {
	s.RegisterService(&ApplicationPubSubRegistry_ServiceDesc, srv)
}

func _ApplicationPubSubRegistry_GetFormats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPubSubRegistryServer).GetFormats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPubSubRegistry_GetFormats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPubSubRegistryServer).GetFormats(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPubSubRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationPubSubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPubSubRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPubSubRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPubSubRegistryServer).Get(ctx, req.(*GetApplicationPubSubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPubSubRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationPubSubsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPubSubRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPubSubRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPubSubRegistryServer).List(ctx, req.(*ListApplicationPubSubsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPubSubRegistry_Set_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetApplicationPubSubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPubSubRegistryServer).Set(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPubSubRegistry_Set_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPubSubRegistryServer).Set(ctx, req.(*SetApplicationPubSubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPubSubRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationPubSubIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPubSubRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPubSubRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPubSubRegistryServer).Delete(ctx, req.(*ApplicationPubSubIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// ApplicationPubSubRegistry_ServiceDesc is the grpc.ServiceDesc for ApplicationPubSubRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ApplicationPubSubRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ApplicationPubSubRegistry",
	HandlerType: (*ApplicationPubSubRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFormats",
			Handler:    _ApplicationPubSubRegistry_GetFormats_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ApplicationPubSubRegistry_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ApplicationPubSubRegistry_List_Handler,
		},
		{
			MethodName: "Set",
			Handler:    _ApplicationPubSubRegistry_Set_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ApplicationPubSubRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/applicationserver_pubsub.proto",
}
