// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on ApplicationPubSubIdentifiers with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationPubSubIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSubIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return ApplicationPubSubIdentifiersValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubIdentifiersValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "pub_sub_id":

			if utf8.RuneCountInString(m.GetPubSubId()) > 36 {
				return ApplicationPubSubIdentifiersValidationError{
					field:  "pub_sub_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ApplicationPubSubIdentifiers_PubSubId_Pattern.MatchString(m.GetPubSubId()) {
				return ApplicationPubSubIdentifiersValidationError{
					field:  "pub_sub_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		default:
			return ApplicationPubSubIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSubIdentifiersValidationError is the validation error returned
// by ApplicationPubSubIdentifiers.ValidateFields if the designated
// constraints aren't met.
type ApplicationPubSubIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSubIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSubIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSubIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSubIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSubIdentifiersValidationError) ErrorName() string {
	return "ApplicationPubSubIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSubIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSubIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSubIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSubIdentifiersValidationError{}

var _ApplicationPubSubIdentifiers_PubSubId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationPubSub with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationPubSub) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSubFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ApplicationPubSubValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "format":

			if utf8.RuneCountInString(m.GetFormat()) > 20 {
				return ApplicationPubSubValidationError{
					field:  "format",
					reason: "value length must be at most 20 runes",
				}
			}

			if !_ApplicationPubSub_Format_Pattern.MatchString(m.GetFormat()) {
				return ApplicationPubSubValidationError{
					field:  "format",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "base_topic":

			if utf8.RuneCountInString(m.GetBaseTopic()) > 100 {
				return ApplicationPubSubValidationError{
					field:  "base_topic",
					reason: "value length must be at most 100 runes",
				}
			}

		case "downlink_push":

			if v, ok := interface{}(m.GetDownlinkPush()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_push",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_replace":

			if v, ok := interface{}(m.GetDownlinkReplace()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_replace",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink_message":

			if v, ok := interface{}(m.GetUplinkMessage()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "uplink_message",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink_normalized":

			if v, ok := interface{}(m.GetUplinkNormalized()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "uplink_normalized",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "join_accept":

			if v, ok := interface{}(m.GetJoinAccept()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "join_accept",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_ack":

			if v, ok := interface{}(m.GetDownlinkAck()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_ack",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_nack":

			if v, ok := interface{}(m.GetDownlinkNack()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_nack",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_sent":

			if v, ok := interface{}(m.GetDownlinkSent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_sent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_failed":

			if v, ok := interface{}(m.GetDownlinkFailed()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_failed",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_queued":

			if v, ok := interface{}(m.GetDownlinkQueued()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_queued",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_queue_invalidated":

			if v, ok := interface{}(m.GetDownlinkQueueInvalidated()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "downlink_queue_invalidated",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "location_solved":

			if v, ok := interface{}(m.GetLocationSolved()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "location_solved",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "service_data":

			if v, ok := interface{}(m.GetServiceData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSubValidationError{
						field:  "service_data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "provider":
			if m.Provider == nil {
				return ApplicationPubSubValidationError{
					field:  "provider",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"nats", "mqtt", "aws_iot",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "nats":
					w, ok := m.Provider.(*ApplicationPubSub_Nats)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetNats()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationPubSubValidationError{
								field:  "nats",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "mqtt":
					w, ok := m.Provider.(*ApplicationPubSub_Mqtt)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetMqtt()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationPubSubValidationError{
								field:  "mqtt",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "aws_iot":
					w, ok := m.Provider.(*ApplicationPubSub_AwsIot)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetAwsIot()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationPubSubValidationError{
								field:  "aws_iot",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ApplicationPubSubValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSubValidationError is the validation error returned by
// ApplicationPubSub.ValidateFields if the designated constraints aren't met.
type ApplicationPubSubValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSubValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSubValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSubValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSubValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSubValidationError) ErrorName() string {
	return "ApplicationPubSubValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSubValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSubValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSubValidationError{}

var _ApplicationPubSub_Format_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationPubSubs with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationPubSubs) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSubsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "pubsubs":

			for idx, item := range m.GetPubsubs() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationPubSubsValidationError{
							field:  fmt.Sprintf("pubsubs[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationPubSubsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSubsValidationError is the validation error returned by
// ApplicationPubSubs.ValidateFields if the designated constraints aren't met.
type ApplicationPubSubsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSubsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSubsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSubsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSubsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSubsValidationError) ErrorName() string {
	return "ApplicationPubSubsValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSubsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSubs.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSubsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSubsValidationError{}

// ValidateFields checks the field values on ApplicationPubSubFormats with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationPubSubFormats) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSubFormatsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "formats":
			// no validation rules for Formats
		default:
			return ApplicationPubSubFormatsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSubFormatsValidationError is the validation error returned by
// ApplicationPubSubFormats.ValidateFields if the designated constraints
// aren't met.
type ApplicationPubSubFormatsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSubFormatsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSubFormatsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSubFormatsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSubFormatsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSubFormatsValidationError) ErrorName() string {
	return "ApplicationPubSubFormatsValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSubFormatsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSubFormats.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSubFormatsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSubFormatsValidationError{}

// ValidateFields checks the field values on GetApplicationPubSubRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetApplicationPubSubRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationPubSubRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return GetApplicationPubSubRequestValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationPubSubRequestValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationPubSubRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationPubSubRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationPubSubRequestValidationError is the validation error returned
// by GetApplicationPubSubRequest.ValidateFields if the designated constraints
// aren't met.
type GetApplicationPubSubRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationPubSubRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationPubSubRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationPubSubRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationPubSubRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationPubSubRequestValidationError) ErrorName() string {
	return "GetApplicationPubSubRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationPubSubRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationPubSubRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationPubSubRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationPubSubRequestValidationError{}

// ValidateFields checks the field values on ListApplicationPubSubsRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListApplicationPubSubsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationPubSubsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return ListApplicationPubSubsRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationPubSubsRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationPubSubsRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ListApplicationPubSubsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationPubSubsRequestValidationError is the validation error
// returned by ListApplicationPubSubsRequest.ValidateFields if the designated
// constraints aren't met.
type ListApplicationPubSubsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationPubSubsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListApplicationPubSubsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListApplicationPubSubsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationPubSubsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationPubSubsRequestValidationError) ErrorName() string {
	return "ListApplicationPubSubsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationPubSubsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationPubSubsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationPubSubsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationPubSubsRequestValidationError{}

// ValidateFields checks the field values on SetApplicationPubSubRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *SetApplicationPubSubRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetApplicationPubSubRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "pubsub":

			if m.GetPubsub() == nil {
				return SetApplicationPubSubRequestValidationError{
					field:  "pubsub",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetPubsub()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationPubSubRequestValidationError{
						field:  "pubsub",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationPubSubRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetApplicationPubSubRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetApplicationPubSubRequestValidationError is the validation error returned
// by SetApplicationPubSubRequest.ValidateFields if the designated constraints
// aren't met.
type SetApplicationPubSubRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetApplicationPubSubRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetApplicationPubSubRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetApplicationPubSubRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetApplicationPubSubRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetApplicationPubSubRequestValidationError) ErrorName() string {
	return "SetApplicationPubSubRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetApplicationPubSubRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetApplicationPubSubRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetApplicationPubSubRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetApplicationPubSubRequestValidationError{}

// ValidateFields checks the field values on ApplicationPubSub_NATSProvider
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationPubSub_NATSProvider) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSub_NATSProviderFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "server_url":

			if uri, err := url.Parse(m.GetServerUrl()); err != nil {
				return ApplicationPubSub_NATSProviderValidationError{
					field:  "server_url",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return ApplicationPubSub_NATSProviderValidationError{
					field:  "server_url",
					reason: "value must be absolute",
				}
			}

		default:
			return ApplicationPubSub_NATSProviderValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSub_NATSProviderValidationError is the validation error
// returned by ApplicationPubSub_NATSProvider.ValidateFields if the designated
// constraints aren't met.
type ApplicationPubSub_NATSProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSub_NATSProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSub_NATSProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSub_NATSProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSub_NATSProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSub_NATSProviderValidationError) ErrorName() string {
	return "ApplicationPubSub_NATSProviderValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSub_NATSProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub_NATSProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSub_NATSProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSub_NATSProviderValidationError{}

// ValidateFields checks the field values on ApplicationPubSub_MQTTProvider
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationPubSub_MQTTProvider) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSub_MQTTProviderFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "server_url":

			if uri, err := url.Parse(m.GetServerUrl()); err != nil {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "server_url",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "server_url",
					reason: "value must be absolute",
				}
			}

		case "client_id":

			if utf8.RuneCountInString(m.GetClientId()) > 23 {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "client_id",
					reason: "value length must be at most 23 runes",
				}
			}

		case "username":

			if utf8.RuneCountInString(m.GetUsername()) > 100 {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "username",
					reason: "value length must be at most 100 runes",
				}
			}

		case "password":

			if utf8.RuneCountInString(m.GetPassword()) > 100 {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "password",
					reason: "value length must be at most 100 runes",
				}
			}

		case "subscribe_qos":
			// no validation rules for SubscribeQos
		case "publish_qos":
			// no validation rules for PublishQos
		case "use_tls":
			// no validation rules for UseTls
		case "tls_ca":

			if len(m.GetTlsCa()) > 8192 {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "tls_ca",
					reason: "value length must be at most 8192 bytes",
				}
			}

		case "tls_client_cert":

			if len(m.GetTlsClientCert()) > 8192 {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "tls_client_cert",
					reason: "value length must be at most 8192 bytes",
				}
			}

		case "tls_client_key":

			if len(m.GetTlsClientKey()) > 8192 {
				return ApplicationPubSub_MQTTProviderValidationError{
					field:  "tls_client_key",
					reason: "value length must be at most 8192 bytes",
				}
			}

		case "headers":
			// no validation rules for Headers
		default:
			return ApplicationPubSub_MQTTProviderValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSub_MQTTProviderValidationError is the validation error
// returned by ApplicationPubSub_MQTTProvider.ValidateFields if the designated
// constraints aren't met.
type ApplicationPubSub_MQTTProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSub_MQTTProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSub_MQTTProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSub_MQTTProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSub_MQTTProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSub_MQTTProviderValidationError) ErrorName() string {
	return "ApplicationPubSub_MQTTProviderValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSub_MQTTProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub_MQTTProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSub_MQTTProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSub_MQTTProviderValidationError{}

// ValidateFields checks the field values on ApplicationPubSub_AWSIoTProvider
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationPubSub_AWSIoTProvider) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSub_AWSIoTProviderFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "region":

			if _, ok := _ApplicationPubSub_AWSIoTProvider_Region_InLookup[m.GetRegion()]; !ok {
				return ApplicationPubSub_AWSIoTProviderValidationError{
					field:  "region",
					reason: "value must be in list [af-south-1 ap-east-1 ap-northeast-1 ap-northeast-2 ap-south-1 ap-southeast-1 ap-southeast-2 ca-central-1 eu-central-1 eu-north-1 eu-south-1 eu-west-1 eu-west-2 eu-west-3 me-south-1 sa-east-1 us-east-1 us-east-2 us-west-1 us-west-2]",
				}
			}

		case "access_key":

			if v, ok := interface{}(m.GetAccessKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSub_AWSIoTProviderValidationError{
						field:  "access_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "assume_role":

			if v, ok := interface{}(m.GetAssumeRole()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSub_AWSIoTProviderValidationError{
						field:  "assume_role",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "endpoint_address":

			if utf8.RuneCountInString(m.GetEndpointAddress()) > 128 {
				return ApplicationPubSub_AWSIoTProviderValidationError{
					field:  "endpoint_address",
					reason: "value length must be at most 128 runes",
				}
			}

			if !_ApplicationPubSub_AWSIoTProvider_EndpointAddress_Pattern.MatchString(m.GetEndpointAddress()) {
				return ApplicationPubSub_AWSIoTProviderValidationError{
					field:  "endpoint_address",
					reason: "value does not match regex pattern \"^((([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])|)$\"",
				}
			}

		case "deployment":
			if len(subs) == 0 {
				subs = []string{
					"default",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "default":
					w, ok := m.Deployment.(*ApplicationPubSub_AWSIoTProvider_Default)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDefault()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationPubSub_AWSIoTProviderValidationError{
								field:  "default",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ApplicationPubSub_AWSIoTProviderValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSub_AWSIoTProviderValidationError is the validation error
// returned by ApplicationPubSub_AWSIoTProvider.ValidateFields if the
// designated constraints aren't met.
type ApplicationPubSub_AWSIoTProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSub_AWSIoTProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSub_AWSIoTProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSub_AWSIoTProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSub_AWSIoTProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSub_AWSIoTProviderValidationError) ErrorName() string {
	return "ApplicationPubSub_AWSIoTProviderValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSub_AWSIoTProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub_AWSIoTProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSub_AWSIoTProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSub_AWSIoTProviderValidationError{}

var _ApplicationPubSub_AWSIoTProvider_Region_InLookup = map[string]struct{}{
	"af-south-1":     {},
	"ap-east-1":      {},
	"ap-northeast-1": {},
	"ap-northeast-2": {},
	"ap-south-1":     {},
	"ap-southeast-1": {},
	"ap-southeast-2": {},
	"ca-central-1":   {},
	"eu-central-1":   {},
	"eu-north-1":     {},
	"eu-south-1":     {},
	"eu-west-1":      {},
	"eu-west-2":      {},
	"eu-west-3":      {},
	"me-south-1":     {},
	"sa-east-1":      {},
	"us-east-1":      {},
	"us-east-2":      {},
	"us-west-1":      {},
	"us-west-2":      {},
}

var _ApplicationPubSub_AWSIoTProvider_EndpointAddress_Pattern = regexp.MustCompile("^((([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])|)$")

// ValidateFields checks the field values on ApplicationPubSub_Message with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationPubSub_Message) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSub_MessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "topic":

			if utf8.RuneCountInString(m.GetTopic()) > 100 {
				return ApplicationPubSub_MessageValidationError{
					field:  "topic",
					reason: "value length must be at most 100 runes",
				}
			}

		default:
			return ApplicationPubSub_MessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSub_MessageValidationError is the validation error returned by
// ApplicationPubSub_Message.ValidateFields if the designated constraints
// aren't met.
type ApplicationPubSub_MessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSub_MessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSub_MessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSub_MessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSub_MessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSub_MessageValidationError) ErrorName() string {
	return "ApplicationPubSub_MessageValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSub_MessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub_Message.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSub_MessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSub_MessageValidationError{}

// ValidateFields checks the field values on
// ApplicationPubSub_AWSIoTProvider_AccessKey with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ApplicationPubSub_AWSIoTProvider_AccessKey) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSub_AWSIoTProvider_AccessKeyFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "access_key_id":

			if l := utf8.RuneCountInString(m.GetAccessKeyId()); l < 16 || l > 128 {
				return ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError{
					field:  "access_key_id",
					reason: "value length must be between 16 and 128 runes, inclusive",
				}
			}

			if !_ApplicationPubSub_AWSIoTProvider_AccessKey_AccessKeyId_Pattern.MatchString(m.GetAccessKeyId()) {
				return ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError{
					field:  "access_key_id",
					reason: "value does not match regex pattern \"^[\\\\w]*$\"",
				}
			}

		case "secret_access_key":

			if utf8.RuneCountInString(m.GetSecretAccessKey()) > 40 {
				return ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError{
					field:  "secret_access_key",
					reason: "value length must be at most 40 runes",
				}
			}

		case "session_token":

			if utf8.RuneCountInString(m.GetSessionToken()) > 256 {
				return ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError{
					field:  "session_token",
					reason: "value length must be at most 256 runes",
				}
			}

		default:
			return ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError is the validation
// error returned by ApplicationPubSub_AWSIoTProvider_AccessKey.ValidateFields
// if the designated constraints aren't met.
type ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError) ErrorName() string {
	return "ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub_AWSIoTProvider_AccessKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSub_AWSIoTProvider_AccessKeyValidationError{}

var _ApplicationPubSub_AWSIoTProvider_AccessKey_AccessKeyId_Pattern = regexp.MustCompile("^[\\w]*$")

// ValidateFields checks the field values on
// ApplicationPubSub_AWSIoTProvider_AssumeRole with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ApplicationPubSub_AWSIoTProvider_AssumeRole) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSub_AWSIoTProvider_AssumeRoleFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "arn":

			if !_ApplicationPubSub_AWSIoTProvider_AssumeRole_Arn_Pattern.MatchString(m.GetArn()) {
				return ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError{
					field:  "arn",
					reason: "value does not match regex pattern \"^arn:aws:iam::[0-9]{12}:role\\\\/[A-Za-z0-9_+=,.@-]+$\"",
				}
			}

		case "external_id":

			if utf8.RuneCountInString(m.GetExternalId()) > 1224 {
				return ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError{
					field:  "external_id",
					reason: "value length must be at most 1224 runes",
				}
			}

			if !_ApplicationPubSub_AWSIoTProvider_AssumeRole_ExternalId_Pattern.MatchString(m.GetExternalId()) {
				return ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError{
					field:  "external_id",
					reason: "value does not match regex pattern \"^[\\\\w+=,.@:\\\\/-]*$\"",
				}
			}

		case "session_duration":

			if v, ok := interface{}(m.GetSessionDuration()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError{
						field:  "session_duration",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError is the validation
// error returned by
// ApplicationPubSub_AWSIoTProvider_AssumeRole.ValidateFields if the
// designated constraints aren't met.
type ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError) ErrorName() string {
	return "ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub_AWSIoTProvider_AssumeRole.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSub_AWSIoTProvider_AssumeRoleValidationError{}

var _ApplicationPubSub_AWSIoTProvider_AssumeRole_Arn_Pattern = regexp.MustCompile("^arn:aws:iam::[0-9]{12}:role\\/[A-Za-z0-9_+=,.@-]+$")

var _ApplicationPubSub_AWSIoTProvider_AssumeRole_ExternalId_Pattern = regexp.MustCompile("^[\\w+=,.@:\\/-]*$")

// ValidateFields checks the field values on
// ApplicationPubSub_AWSIoTProvider_DefaultIntegration with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ApplicationPubSub_AWSIoTProvider_DefaultIntegration) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPubSub_AWSIoTProvider_DefaultIntegrationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "stack_name":

			if utf8.RuneCountInString(m.GetStackName()) > 128 {
				return ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError{
					field:  "stack_name",
					reason: "value length must be at most 128 runes",
				}
			}

			if !_ApplicationPubSub_AWSIoTProvider_DefaultIntegration_StackName_Pattern.MatchString(m.GetStackName()) {
				return ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError{
					field:  "stack_name",
					reason: "value does not match regex pattern \"^[A-Za-z][A-Za-z0-9\\\\-]*$\"",
				}
			}

		default:
			return ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError is the
// validation error returned by
// ApplicationPubSub_AWSIoTProvider_DefaultIntegration.ValidateFields if the
// designated constraints aren't met.
type ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError) ErrorName() string {
	return "ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPubSub_AWSIoTProvider_DefaultIntegration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPubSub_AWSIoTProvider_DefaultIntegrationValidationError{}

var _ApplicationPubSub_AWSIoTProvider_DefaultIntegration_StackName_Pattern = regexp.MustCompile("^[A-Za-z][A-Za-z0-9\\-]*$")
