// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/applicationserver_pubsub.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ApplicationPubSub_MQTTProvider_QoS int32

const (
	ApplicationPubSub_MQTTProvider_AT_MOST_ONCE  ApplicationPubSub_MQTTProvider_QoS = 0
	ApplicationPubSub_MQTTProvider_AT_LEAST_ONCE ApplicationPubSub_MQTTProvider_QoS = 1
	ApplicationPubSub_MQTTProvider_EXACTLY_ONCE  ApplicationPubSub_MQTTProvider_QoS = 2
)

// Enum value maps for ApplicationPubSub_MQTTProvider_QoS.
var (
	ApplicationPubSub_MQTTProvider_QoS_name = map[int32]string{
		0: "AT_MOST_ONCE",
		1: "AT_LEAST_ONCE",
		2: "EXACTLY_ONCE",
	}
	ApplicationPubSub_MQTTProvider_QoS_value = map[string]int32{
		"AT_MOST_ONCE":  0,
		"AT_LEAST_ONCE": 1,
		"EXACTLY_ONCE":  2,
	}
)

func (x ApplicationPubSub_MQTTProvider_QoS) Enum() *ApplicationPubSub_MQTTProvider_QoS {
	p := new(ApplicationPubSub_MQTTProvider_QoS)
	*p = x
	return p
}

func (x ApplicationPubSub_MQTTProvider_QoS) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApplicationPubSub_MQTTProvider_QoS) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_enumTypes[0].Descriptor()
}

func (ApplicationPubSub_MQTTProvider_QoS) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_applicationserver_pubsub_proto_enumTypes[0]
}

func (x ApplicationPubSub_MQTTProvider_QoS) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApplicationPubSub_MQTTProvider_QoS.Descriptor instead.
func (ApplicationPubSub_MQTTProvider_QoS) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 1, 0}
}

type ApplicationPubSubIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	PubSubId       string                  `protobuf:"bytes,2,opt,name=pub_sub_id,json=pubSubId,proto3" json:"pub_sub_id,omitempty"`
}

func (x *ApplicationPubSubIdentifiers) Reset() {
	*x = ApplicationPubSubIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSubIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSubIdentifiers) ProtoMessage() {}

func (x *ApplicationPubSubIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSubIdentifiers.ProtoReflect.Descriptor instead.
func (*ApplicationPubSubIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{0}
}

func (x *ApplicationPubSubIdentifiers) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *ApplicationPubSubIdentifiers) GetPubSubId() string {
	if x != nil {
		return x.PubSubId
	}
	return ""
}

type ApplicationPubSub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids       *ApplicationPubSubIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	CreatedAt *timestamppb.Timestamp        `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	UpdatedAt *timestamppb.Timestamp        `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// The format to use for the body.
	// Supported values depend on the Application Server configuration.
	Format string `protobuf:"bytes,4,opt,name=format,proto3" json:"format,omitempty"`
	// The provider for the PubSub.
	//
	// Types that are assignable to Provider:
	//	*ApplicationPubSub_Nats
	//	*ApplicationPubSub_Mqtt
	//	*ApplicationPubSub_AwsIot
	Provider isApplicationPubSub_Provider `protobuf_oneof:"provider"`
	// Base topic name to which the messages topic is appended.
	BaseTopic string `protobuf:"bytes,6,opt,name=base_topic,json=baseTopic,proto3" json:"base_topic,omitempty"`
	// The topic to which the Application Server subscribes for downlink queue push operations.
	DownlinkPush *ApplicationPubSub_Message `protobuf:"bytes,7,opt,name=downlink_push,json=downlinkPush,proto3" json:"downlink_push,omitempty"`
	// The topic to which the Application Server subscribes for downlink queue replace operations.
	DownlinkReplace          *ApplicationPubSub_Message `protobuf:"bytes,8,opt,name=downlink_replace,json=downlinkReplace,proto3" json:"downlink_replace,omitempty"`
	UplinkMessage            *ApplicationPubSub_Message `protobuf:"bytes,9,opt,name=uplink_message,json=uplinkMessage,proto3" json:"uplink_message,omitempty"`
	UplinkNormalized         *ApplicationPubSub_Message `protobuf:"bytes,20,opt,name=uplink_normalized,json=uplinkNormalized,proto3" json:"uplink_normalized,omitempty"`
	JoinAccept               *ApplicationPubSub_Message `protobuf:"bytes,10,opt,name=join_accept,json=joinAccept,proto3" json:"join_accept,omitempty"`
	DownlinkAck              *ApplicationPubSub_Message `protobuf:"bytes,11,opt,name=downlink_ack,json=downlinkAck,proto3" json:"downlink_ack,omitempty"`
	DownlinkNack             *ApplicationPubSub_Message `protobuf:"bytes,12,opt,name=downlink_nack,json=downlinkNack,proto3" json:"downlink_nack,omitempty"`
	DownlinkSent             *ApplicationPubSub_Message `protobuf:"bytes,13,opt,name=downlink_sent,json=downlinkSent,proto3" json:"downlink_sent,omitempty"`
	DownlinkFailed           *ApplicationPubSub_Message `protobuf:"bytes,14,opt,name=downlink_failed,json=downlinkFailed,proto3" json:"downlink_failed,omitempty"`
	DownlinkQueued           *ApplicationPubSub_Message `protobuf:"bytes,15,opt,name=downlink_queued,json=downlinkQueued,proto3" json:"downlink_queued,omitempty"`
	DownlinkQueueInvalidated *ApplicationPubSub_Message `protobuf:"bytes,19,opt,name=downlink_queue_invalidated,json=downlinkQueueInvalidated,proto3" json:"downlink_queue_invalidated,omitempty"`
	LocationSolved           *ApplicationPubSub_Message `protobuf:"bytes,16,opt,name=location_solved,json=locationSolved,proto3" json:"location_solved,omitempty"`
	ServiceData              *ApplicationPubSub_Message `protobuf:"bytes,18,opt,name=service_data,json=serviceData,proto3" json:"service_data,omitempty"`
}

func (x *ApplicationPubSub) Reset() {
	*x = ApplicationPubSub{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub) ProtoMessage() {}

func (x *ApplicationPubSub) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1}
}

func (x *ApplicationPubSub) GetIds() *ApplicationPubSubIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ApplicationPubSub) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *ApplicationPubSub) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *ApplicationPubSub) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (m *ApplicationPubSub) GetProvider() isApplicationPubSub_Provider {
	if m != nil {
		return m.Provider
	}
	return nil
}

func (x *ApplicationPubSub) GetNats() *ApplicationPubSub_NATSProvider {
	if x, ok := x.GetProvider().(*ApplicationPubSub_Nats); ok {
		return x.Nats
	}
	return nil
}

func (x *ApplicationPubSub) GetMqtt() *ApplicationPubSub_MQTTProvider {
	if x, ok := x.GetProvider().(*ApplicationPubSub_Mqtt); ok {
		return x.Mqtt
	}
	return nil
}

func (x *ApplicationPubSub) GetAwsIot() *ApplicationPubSub_AWSIoTProvider {
	if x, ok := x.GetProvider().(*ApplicationPubSub_AwsIot); ok {
		return x.AwsIot
	}
	return nil
}

func (x *ApplicationPubSub) GetBaseTopic() string {
	if x != nil {
		return x.BaseTopic
	}
	return ""
}

func (x *ApplicationPubSub) GetDownlinkPush() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkPush
	}
	return nil
}

func (x *ApplicationPubSub) GetDownlinkReplace() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkReplace
	}
	return nil
}

func (x *ApplicationPubSub) GetUplinkMessage() *ApplicationPubSub_Message {
	if x != nil {
		return x.UplinkMessage
	}
	return nil
}

func (x *ApplicationPubSub) GetUplinkNormalized() *ApplicationPubSub_Message {
	if x != nil {
		return x.UplinkNormalized
	}
	return nil
}

func (x *ApplicationPubSub) GetJoinAccept() *ApplicationPubSub_Message {
	if x != nil {
		return x.JoinAccept
	}
	return nil
}

func (x *ApplicationPubSub) GetDownlinkAck() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkAck
	}
	return nil
}

func (x *ApplicationPubSub) GetDownlinkNack() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkNack
	}
	return nil
}

func (x *ApplicationPubSub) GetDownlinkSent() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkSent
	}
	return nil
}

func (x *ApplicationPubSub) GetDownlinkFailed() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkFailed
	}
	return nil
}

func (x *ApplicationPubSub) GetDownlinkQueued() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkQueued
	}
	return nil
}

func (x *ApplicationPubSub) GetDownlinkQueueInvalidated() *ApplicationPubSub_Message {
	if x != nil {
		return x.DownlinkQueueInvalidated
	}
	return nil
}

func (x *ApplicationPubSub) GetLocationSolved() *ApplicationPubSub_Message {
	if x != nil {
		return x.LocationSolved
	}
	return nil
}

func (x *ApplicationPubSub) GetServiceData() *ApplicationPubSub_Message {
	if x != nil {
		return x.ServiceData
	}
	return nil
}

type isApplicationPubSub_Provider interface {
	isApplicationPubSub_Provider()
}

type ApplicationPubSub_Nats struct {
	Nats *ApplicationPubSub_NATSProvider `protobuf:"bytes,17,opt,name=nats,proto3,oneof"`
}

type ApplicationPubSub_Mqtt struct {
	Mqtt *ApplicationPubSub_MQTTProvider `protobuf:"bytes,25,opt,name=mqtt,proto3,oneof"`
}

type ApplicationPubSub_AwsIot struct {
	AwsIot *ApplicationPubSub_AWSIoTProvider `protobuf:"bytes,101,opt,name=aws_iot,json=awsIot,proto3,oneof"`
}

func (*ApplicationPubSub_Nats) isApplicationPubSub_Provider() {}

func (*ApplicationPubSub_Mqtt) isApplicationPubSub_Provider() {}

func (*ApplicationPubSub_AwsIot) isApplicationPubSub_Provider() {}

type ApplicationPubSubs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Pubsubs []*ApplicationPubSub `protobuf:"bytes,1,rep,name=pubsubs,proto3" json:"pubsubs,omitempty"`
}

func (x *ApplicationPubSubs) Reset() {
	*x = ApplicationPubSubs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSubs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSubs) ProtoMessage() {}

func (x *ApplicationPubSubs) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSubs.ProtoReflect.Descriptor instead.
func (*ApplicationPubSubs) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{2}
}

func (x *ApplicationPubSubs) GetPubsubs() []*ApplicationPubSub {
	if x != nil {
		return x.Pubsubs
	}
	return nil
}

type ApplicationPubSubFormats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format and description.
	Formats map[string]string `protobuf:"bytes,1,rep,name=formats,proto3" json:"formats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ApplicationPubSubFormats) Reset() {
	*x = ApplicationPubSubFormats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSubFormats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSubFormats) ProtoMessage() {}

func (x *ApplicationPubSubFormats) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSubFormats.ProtoReflect.Descriptor instead.
func (*ApplicationPubSubFormats) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{3}
}

func (x *ApplicationPubSubFormats) GetFormats() map[string]string {
	if x != nil {
		return x.Formats
	}
	return nil
}

type GetApplicationPubSubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids       *ApplicationPubSubIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	FieldMask *fieldmaskpb.FieldMask        `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetApplicationPubSubRequest) Reset() {
	*x = GetApplicationPubSubRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApplicationPubSubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApplicationPubSubRequest) ProtoMessage() {}

func (x *GetApplicationPubSubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApplicationPubSubRequest.ProtoReflect.Descriptor instead.
func (*GetApplicationPubSubRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{4}
}

func (x *GetApplicationPubSubRequest) GetIds() *ApplicationPubSubIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *GetApplicationPubSubRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListApplicationPubSubsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	FieldMask      *fieldmaskpb.FieldMask  `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ListApplicationPubSubsRequest) Reset() {
	*x = ListApplicationPubSubsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListApplicationPubSubsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApplicationPubSubsRequest) ProtoMessage() {}

func (x *ListApplicationPubSubsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApplicationPubSubsRequest.ProtoReflect.Descriptor instead.
func (*ListApplicationPubSubsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{5}
}

func (x *ListApplicationPubSubsRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *ListApplicationPubSubsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type SetApplicationPubSubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Pubsub    *ApplicationPubSub     `protobuf:"bytes,1,opt,name=pubsub,proto3" json:"pubsub,omitempty"`
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *SetApplicationPubSubRequest) Reset() {
	*x = SetApplicationPubSubRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetApplicationPubSubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetApplicationPubSubRequest) ProtoMessage() {}

func (x *SetApplicationPubSubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetApplicationPubSubRequest.ProtoReflect.Descriptor instead.
func (*SetApplicationPubSubRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{6}
}

func (x *SetApplicationPubSubRequest) GetPubsub() *ApplicationPubSub {
	if x != nil {
		return x.Pubsub
	}
	return nil
}

func (x *SetApplicationPubSubRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// The NATS provider settings.
type ApplicationPubSub_NATSProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server connection URL.
	ServerUrl string `protobuf:"bytes,1,opt,name=server_url,json=serverUrl,proto3" json:"server_url,omitempty"`
}

func (x *ApplicationPubSub_NATSProvider) Reset() {
	*x = ApplicationPubSub_NATSProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub_NATSProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub_NATSProvider) ProtoMessage() {}

func (x *ApplicationPubSub_NATSProvider) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub_NATSProvider.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub_NATSProvider) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ApplicationPubSub_NATSProvider) GetServerUrl() string {
	if x != nil {
		return x.ServerUrl
	}
	return ""
}

// The MQTT provider settings.
type ApplicationPubSub_MQTTProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServerUrl    string                             `protobuf:"bytes,1,opt,name=server_url,json=serverUrl,proto3" json:"server_url,omitempty"`
	ClientId     string                             `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	Username     string                             `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	Password     string                             `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	SubscribeQos ApplicationPubSub_MQTTProvider_QoS `protobuf:"varint,5,opt,name=subscribe_qos,json=subscribeQos,proto3,enum=ttn.lorawan.v3.ApplicationPubSub_MQTTProvider_QoS" json:"subscribe_qos,omitempty"`
	PublishQos   ApplicationPubSub_MQTTProvider_QoS `protobuf:"varint,6,opt,name=publish_qos,json=publishQos,proto3,enum=ttn.lorawan.v3.ApplicationPubSub_MQTTProvider_QoS" json:"publish_qos,omitempty"`
	UseTls       bool                               `protobuf:"varint,7,opt,name=use_tls,json=useTls,proto3" json:"use_tls,omitempty"`
	// The server Root CA certificate. PEM formatted.
	TlsCa []byte `protobuf:"bytes,8,opt,name=tls_ca,json=tlsCa,proto3" json:"tls_ca,omitempty"`
	// The client certificate. PEM formatted.
	TlsClientCert []byte `protobuf:"bytes,9,opt,name=tls_client_cert,json=tlsClientCert,proto3" json:"tls_client_cert,omitempty"`
	// The client private key. PEM formatted.
	TlsClientKey []byte `protobuf:"bytes,10,opt,name=tls_client_key,json=tlsClientKey,proto3" json:"tls_client_key,omitempty"`
	// HTTP headers to use on MQTT-over-Websocket connections.
	Headers map[string]string `protobuf:"bytes,11,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ApplicationPubSub_MQTTProvider) Reset() {
	*x = ApplicationPubSub_MQTTProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub_MQTTProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub_MQTTProvider) ProtoMessage() {}

func (x *ApplicationPubSub_MQTTProvider) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub_MQTTProvider.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub_MQTTProvider) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 1}
}

func (x *ApplicationPubSub_MQTTProvider) GetServerUrl() string {
	if x != nil {
		return x.ServerUrl
	}
	return ""
}

func (x *ApplicationPubSub_MQTTProvider) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *ApplicationPubSub_MQTTProvider) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *ApplicationPubSub_MQTTProvider) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *ApplicationPubSub_MQTTProvider) GetSubscribeQos() ApplicationPubSub_MQTTProvider_QoS {
	if x != nil {
		return x.SubscribeQos
	}
	return ApplicationPubSub_MQTTProvider_AT_MOST_ONCE
}

func (x *ApplicationPubSub_MQTTProvider) GetPublishQos() ApplicationPubSub_MQTTProvider_QoS {
	if x != nil {
		return x.PublishQos
	}
	return ApplicationPubSub_MQTTProvider_AT_MOST_ONCE
}

func (x *ApplicationPubSub_MQTTProvider) GetUseTls() bool {
	if x != nil {
		return x.UseTls
	}
	return false
}

func (x *ApplicationPubSub_MQTTProvider) GetTlsCa() []byte {
	if x != nil {
		return x.TlsCa
	}
	return nil
}

func (x *ApplicationPubSub_MQTTProvider) GetTlsClientCert() []byte {
	if x != nil {
		return x.TlsClientCert
	}
	return nil
}

func (x *ApplicationPubSub_MQTTProvider) GetTlsClientKey() []byte {
	if x != nil {
		return x.TlsClientKey
	}
	return nil
}

func (x *ApplicationPubSub_MQTTProvider) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

type ApplicationPubSub_AWSIoTProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The AWS region.
	Region string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	// If set, the integration will use an AWS access key.
	AccessKey *ApplicationPubSub_AWSIoTProvider_AccessKey `protobuf:"bytes,2,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	// If set, the integration will assume the given role during operation.
	AssumeRole *ApplicationPubSub_AWSIoTProvider_AssumeRole `protobuf:"bytes,3,opt,name=assume_role,json=assumeRole,proto3" json:"assume_role,omitempty"`
	// The endpoint address to connect to. If the endpoint address is left empty,
	// the integration will try to discover it.
	EndpointAddress string `protobuf:"bytes,4,opt,name=endpoint_address,json=endpointAddress,proto3" json:"endpoint_address,omitempty"`
	// Types that are assignable to Deployment:
	//	*ApplicationPubSub_AWSIoTProvider_Default
	Deployment isApplicationPubSub_AWSIoTProvider_Deployment `protobuf_oneof:"deployment"`
}

func (x *ApplicationPubSub_AWSIoTProvider) Reset() {
	*x = ApplicationPubSub_AWSIoTProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub_AWSIoTProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub_AWSIoTProvider) ProtoMessage() {}

func (x *ApplicationPubSub_AWSIoTProvider) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub_AWSIoTProvider.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub_AWSIoTProvider) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 2}
}

func (x *ApplicationPubSub_AWSIoTProvider) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *ApplicationPubSub_AWSIoTProvider) GetAccessKey() *ApplicationPubSub_AWSIoTProvider_AccessKey {
	if x != nil {
		return x.AccessKey
	}
	return nil
}

func (x *ApplicationPubSub_AWSIoTProvider) GetAssumeRole() *ApplicationPubSub_AWSIoTProvider_AssumeRole {
	if x != nil {
		return x.AssumeRole
	}
	return nil
}

func (x *ApplicationPubSub_AWSIoTProvider) GetEndpointAddress() string {
	if x != nil {
		return x.EndpointAddress
	}
	return ""
}

func (m *ApplicationPubSub_AWSIoTProvider) GetDeployment() isApplicationPubSub_AWSIoTProvider_Deployment {
	if m != nil {
		return m.Deployment
	}
	return nil
}

func (x *ApplicationPubSub_AWSIoTProvider) GetDefault() *ApplicationPubSub_AWSIoTProvider_DefaultIntegration {
	if x, ok := x.GetDeployment().(*ApplicationPubSub_AWSIoTProvider_Default); ok {
		return x.Default
	}
	return nil
}

type isApplicationPubSub_AWSIoTProvider_Deployment interface {
	isApplicationPubSub_AWSIoTProvider_Deployment()
}

type ApplicationPubSub_AWSIoTProvider_Default struct {
	// Enable the default integration. This overrides custom base topic and message topics of the pub/sub integration.
	Default *ApplicationPubSub_AWSIoTProvider_DefaultIntegration `protobuf:"bytes,5,opt,name=default,proto3,oneof"`
}

func (*ApplicationPubSub_AWSIoTProvider_Default) isApplicationPubSub_AWSIoTProvider_Deployment() {}

type ApplicationPubSub_Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The topic on which the Application Server publishes or receives the messages.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *ApplicationPubSub_Message) Reset() {
	*x = ApplicationPubSub_Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub_Message) ProtoMessage() {}

func (x *ApplicationPubSub_Message) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub_Message.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub_Message) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 3}
}

func (x *ApplicationPubSub_Message) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

type ApplicationPubSub_AWSIoTProvider_AccessKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccessKeyId     string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	SecretAccessKey string `protobuf:"bytes,2,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
	SessionToken    string `protobuf:"bytes,3,opt,name=session_token,json=sessionToken,proto3" json:"session_token,omitempty"`
}

func (x *ApplicationPubSub_AWSIoTProvider_AccessKey) Reset() {
	*x = ApplicationPubSub_AWSIoTProvider_AccessKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub_AWSIoTProvider_AccessKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub_AWSIoTProvider_AccessKey) ProtoMessage() {}

func (x *ApplicationPubSub_AWSIoTProvider_AccessKey) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub_AWSIoTProvider_AccessKey.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub_AWSIoTProvider_AccessKey) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 2, 0}
}

func (x *ApplicationPubSub_AWSIoTProvider_AccessKey) GetAccessKeyId() string {
	if x != nil {
		return x.AccessKeyId
	}
	return ""
}

func (x *ApplicationPubSub_AWSIoTProvider_AccessKey) GetSecretAccessKey() string {
	if x != nil {
		return x.SecretAccessKey
	}
	return ""
}

func (x *ApplicationPubSub_AWSIoTProvider_AccessKey) GetSessionToken() string {
	if x != nil {
		return x.SessionToken
	}
	return ""
}

type ApplicationPubSub_AWSIoTProvider_AssumeRole struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Arn             string               `protobuf:"bytes,1,opt,name=arn,proto3" json:"arn,omitempty"`
	ExternalId      string               `protobuf:"bytes,2,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	SessionDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=session_duration,json=sessionDuration,proto3" json:"session_duration,omitempty"`
}

func (x *ApplicationPubSub_AWSIoTProvider_AssumeRole) Reset() {
	*x = ApplicationPubSub_AWSIoTProvider_AssumeRole{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub_AWSIoTProvider_AssumeRole) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub_AWSIoTProvider_AssumeRole) ProtoMessage() {}

func (x *ApplicationPubSub_AWSIoTProvider_AssumeRole) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub_AWSIoTProvider_AssumeRole.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub_AWSIoTProvider_AssumeRole) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 2, 1}
}

func (x *ApplicationPubSub_AWSIoTProvider_AssumeRole) GetArn() string {
	if x != nil {
		return x.Arn
	}
	return ""
}

func (x *ApplicationPubSub_AWSIoTProvider_AssumeRole) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

func (x *ApplicationPubSub_AWSIoTProvider_AssumeRole) GetSessionDuration() *durationpb.Duration {
	if x != nil {
		return x.SessionDuration
	}
	return nil
}

type ApplicationPubSub_AWSIoTProvider_DefaultIntegration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The stack name that is associated with the CloudFormation deployment of The Things Stack Enterprise integration.
	StackName string `protobuf:"bytes,1,opt,name=stack_name,json=stackName,proto3" json:"stack_name,omitempty"`
}

func (x *ApplicationPubSub_AWSIoTProvider_DefaultIntegration) Reset() {
	*x = ApplicationPubSub_AWSIoTProvider_DefaultIntegration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationPubSub_AWSIoTProvider_DefaultIntegration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationPubSub_AWSIoTProvider_DefaultIntegration) ProtoMessage() {}

func (x *ApplicationPubSub_AWSIoTProvider_DefaultIntegration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationPubSub_AWSIoTProvider_DefaultIntegration.ProtoReflect.Descriptor instead.
func (*ApplicationPubSub_AWSIoTProvider_DefaultIntegration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP(), []int{1, 2, 2}
}

func (x *ApplicationPubSub_AWSIoTProvider_DefaultIntegration) GetStackName() string {
	if x != nil {
		return x.StackName
	}
	return ""
}

var File_ttn_lorawan_v3_applicationserver_pubsub_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f, 0x6e,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f,
	0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xca, 0x01,
	0x0a, 0x1c, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62,
	0x53, 0x75, 0x62, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x59,
	0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x75, 0x62,
	0x5f, 0x73, 0x75, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa,
	0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39,
	0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x08, 0x70, 0x75, 0x62, 0x53, 0x75, 0x62, 0x49, 0x64,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22, 0xc1, 0x21, 0x0a, 0x11, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x12, 0x50, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x10, 0xfa, 0x42, 0x05,
	0x8a, 0x01, 0x02, 0x10, 0x01, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x28, 0x01, 0x52, 0x03, 0x69,
	0x64, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10,
	0x00, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x3f, 0x0a, 0x06,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42,
	0x24, 0x72, 0x22, 0x18, 0x14, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29,
	0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x44, 0x0a,
	0x04, 0x6e, 0x61, 0x74, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4e,
	0x41, 0x54, 0x53, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x48, 0x00, 0x52, 0x04, 0x6e,
	0x61, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x04, 0x6d, 0x71, 0x74, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x51, 0x54, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x71, 0x74, 0x74, 0x12, 0x4b, 0x0a, 0x07, 0x61, 0x77, 0x73,
	0x5f, 0x69, 0x6f, 0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x41, 0x57,
	0x53, 0x49, 0x6f, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x48, 0x00, 0x52, 0x06,
	0x61, 0x77, 0x73, 0x49, 0x6f, 0x74, 0x12, 0x26, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72,
	0x02, 0x18, 0x64, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x4e,
	0x0a, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x75, 0x73, 0x68, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x75, 0x73, 0x68, 0x12, 0x54,
	0x0a, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0e, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x56, 0x0a, 0x11, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x75, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x12, 0x4a,
	0x0a, 0x0b, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0a,
	0x6a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x12, 0x4c, 0x0a, 0x0c, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62,
	0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x63, 0x6b, 0x12, 0x4e, 0x0a, 0x0d, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6e, 0x61, 0x63, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x61, 0x63, 0x6b, 0x12, 0x4e, 0x0a, 0x0d, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x53, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0f, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x52, 0x0a, 0x0f,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64,
	0x12, 0x67, 0x0a, 0x1a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x18, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x52, 0x0a, 0x0f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x12, 0x4c, 0x0a,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x1a, 0x41, 0x0a, 0x0c, 0x4e,
	0x41, 0x54, 0x53, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0a, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x88, 0x01, 0x01, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x55, 0x72, 0x6c, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x1a, 0xb4,
	0x09, 0x0a, 0x0c, 0x4d, 0x51, 0x54, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12,
	0x27, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x88, 0x01, 0x01, 0x52, 0x09, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x72, 0x6c, 0x12, 0x24, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x18, 0x17, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x23,
	0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x08,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x57, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x5f, 0x71, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x2e, 0x4d, 0x51, 0x54, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e,
	0x51, 0x6f, 0x53, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x51, 0x6f,
	0x73, 0x12, 0x53, 0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x71, 0x6f, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x51, 0x54, 0x54, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x51, 0x6f, 0x53, 0x52, 0x0a, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x51, 0x6f, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6c,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x75, 0x73, 0x65, 0x54, 0x6c, 0x73, 0x12,
	0xbe, 0x01, 0x0a, 0x06, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0xa6, 0x01, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x40, 0xf2, 0xaa, 0x19, 0x99, 0x01,
	0x1a, 0x4e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65,
	0x54, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x2e, 0x4e, 0x65, 0x77, 0x48, 0x65, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67,
	0x22, 0x47, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65,
	0x54, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x2e, 0x47, 0x65, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x05, 0x74, 0x6c, 0x73, 0x43, 0x61,
	0x12, 0xcf, 0x01, 0x0a, 0x0f, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xa6, 0x01, 0xfa, 0x42, 0x05,
	0x7a, 0x03, 0x18, 0x80, 0x40, 0xf2, 0xaa, 0x19, 0x99, 0x01, 0x1a, 0x4e, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x4e, 0x65, 0x77, 0x48, 0x65,
	0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x47, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x52, 0x0d, 0x74, 0x6c, 0x73, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65,
	0x72, 0x74, 0x12, 0xcd, 0x01, 0x0a, 0x0e, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xa6, 0x01, 0xfa, 0x42,
	0x05, 0x7a, 0x03, 0x18, 0x80, 0x40, 0xf2, 0xaa, 0x19, 0x99, 0x01, 0x1a, 0x4e, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x4e, 0x65, 0x77, 0x48,
	0x65, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x47, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x52, 0x0c, 0x74, 0x6c, 0x73, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b,
	0x65, 0x79, 0x12, 0x55, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x0b, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x4d, 0x51, 0x54, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x44, 0x0a, 0x03, 0x51, 0x6f, 0x53, 0x12, 0x10, 0x0a, 0x0c,
	0x41, 0x54, 0x5f, 0x4d, 0x4f, 0x53, 0x54, 0x5f, 0x4f, 0x4e, 0x43, 0x45, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x0d, 0x41, 0x54, 0x5f, 0x4c, 0x45, 0x41, 0x53, 0x54, 0x5f, 0x4f, 0x4e, 0x43, 0x45, 0x10,
	0x01, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x58, 0x41, 0x43, 0x54, 0x4c, 0x59, 0x5f, 0x4f, 0x4e, 0x43,
	0x45, 0x10, 0x02, 0x1a, 0x06, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19,
	0x04, 0x08, 0x01, 0x10, 0x01, 0x1a, 0x87, 0x0a, 0x0a, 0x0e, 0x41, 0x57, 0x53, 0x49, 0x6f, 0x54,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x9b, 0x02, 0x0a, 0x06, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x82, 0x02, 0xfa, 0x42, 0xfe, 0x01,
	0x72, 0xfb, 0x01, 0x52, 0x0a, 0x61, 0x66, 0x2d, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x2d, 0x31, 0x52,
	0x09, 0x61, 0x70, 0x2d, 0x65, 0x61, 0x73, 0x74, 0x2d, 0x31, 0x52, 0x0e, 0x61, 0x70, 0x2d, 0x6e,
	0x6f, 0x72, 0x74, 0x68, 0x65, 0x61, 0x73, 0x74, 0x2d, 0x31, 0x52, 0x0e, 0x61, 0x70, 0x2d, 0x6e,
	0x6f, 0x72, 0x74, 0x68, 0x65, 0x61, 0x73, 0x74, 0x2d, 0x32, 0x52, 0x0a, 0x61, 0x70, 0x2d, 0x73,
	0x6f, 0x75, 0x74, 0x68, 0x2d, 0x31, 0x52, 0x0e, 0x61, 0x70, 0x2d, 0x73, 0x6f, 0x75, 0x74, 0x68,
	0x65, 0x61, 0x73, 0x74, 0x2d, 0x31, 0x52, 0x0e, 0x61, 0x70, 0x2d, 0x73, 0x6f, 0x75, 0x74, 0x68,
	0x65, 0x61, 0x73, 0x74, 0x2d, 0x32, 0x52, 0x0c, 0x63, 0x61, 0x2d, 0x63, 0x65, 0x6e, 0x74, 0x72,
	0x61, 0x6c, 0x2d, 0x31, 0x52, 0x0c, 0x65, 0x75, 0x2d, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c,
	0x2d, 0x31, 0x52, 0x0a, 0x65, 0x75, 0x2d, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x2d, 0x31, 0x52, 0x0a,
	0x65, 0x75, 0x2d, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x2d, 0x31, 0x52, 0x09, 0x65, 0x75, 0x2d, 0x77,
	0x65, 0x73, 0x74, 0x2d, 0x31, 0x52, 0x09, 0x65, 0x75, 0x2d, 0x77, 0x65, 0x73, 0x74, 0x2d, 0x32,
	0x52, 0x09, 0x65, 0x75, 0x2d, 0x77, 0x65, 0x73, 0x74, 0x2d, 0x33, 0x52, 0x0a, 0x6d, 0x65, 0x2d,
	0x73, 0x6f, 0x75, 0x74, 0x68, 0x2d, 0x31, 0x52, 0x09, 0x73, 0x61, 0x2d, 0x65, 0x61, 0x73, 0x74,
	0x2d, 0x31, 0x52, 0x09, 0x75, 0x73, 0x2d, 0x65, 0x61, 0x73, 0x74, 0x2d, 0x31, 0x52, 0x09, 0x75,
	0x73, 0x2d, 0x65, 0x61, 0x73, 0x74, 0x2d, 0x32, 0x52, 0x09, 0x75, 0x73, 0x2d, 0x77, 0x65, 0x73,
	0x74, 0x2d, 0x31, 0x52, 0x09, 0x75, 0x73, 0x2d, 0x77, 0x65, 0x73, 0x74, 0x2d, 0x32, 0x52, 0x06,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x41, 0x57,
	0x53, 0x49, 0x6f, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65,
	0x79, 0x12, 0x5c, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x41, 0x57, 0x53, 0x49, 0x6f, 0x54,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x41, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x52,
	0x6f, 0x6c, 0x65, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x12,
	0xa3, 0x01, 0x0a, 0x10, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x78, 0xfa, 0x42, 0x75, 0x72,
	0x73, 0x18, 0x80, 0x01, 0x32, 0x6e, 0x5e, 0x28, 0x28, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d,
	0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39,
	0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b,
	0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x5c, 0x2e, 0x29, 0x2a, 0x28,
	0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x41, 0x2d, 0x5a,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d,
	0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x29, 0x7c, 0x29, 0x24, 0x52, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x5f, 0x0a, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x41, 0x57, 0x53, 0x49, 0x6f, 0x54,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x07, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x1a, 0xb2, 0x01, 0x0a, 0x09, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4b, 0x65, 0x79, 0x12, 0x37, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x13, 0xfa, 0x42, 0x10,
	0x72, 0x0e, 0x10, 0x10, 0x18, 0x80, 0x01, 0x32, 0x07, 0x5e, 0x5b, 0x5c, 0x77, 0x5d, 0x2a, 0x24,
	0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x33, 0x0a,
	0x11, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18,
	0x28, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b,
	0x65, 0x79, 0x12, 0x2d, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03,
	0x18, 0x80, 0x02, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x1a, 0xe6, 0x01, 0x0a, 0x0a,
	0x41, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x03, 0x61, 0x72,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xfa, 0x42, 0x36, 0x72, 0x34, 0x32, 0x32,
	0x5e, 0x61, 0x72, 0x6e, 0x3a, 0x61, 0x77, 0x73, 0x3a, 0x69, 0x61, 0x6d, 0x3a, 0x3a, 0x5b, 0x30,
	0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x32, 0x7d, 0x3a, 0x72, 0x6f, 0x6c, 0x65, 0x5c, 0x2f, 0x5b, 0x41,
	0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5f, 0x2b, 0x3d, 0x2c, 0x2e, 0x40, 0x2d, 0x5d,
	0x2b, 0x24, 0x52, 0x03, 0x61, 0x72, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1a, 0xfa, 0x42,
	0x17, 0x72, 0x15, 0x18, 0xc8, 0x09, 0x32, 0x10, 0x5e, 0x5b, 0x5c, 0x77, 0x2b, 0x3d, 0x2c, 0x2e,
	0x40, 0x3a, 0x5c, 0x2f, 0x2d, 0x5d, 0x2a, 0x24, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04,
	0x08, 0x01, 0x10, 0x01, 0x1a, 0x61, 0x0a, 0x12, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22,
	0xfa, 0x42, 0x1f, 0x72, 0x1d, 0x18, 0x80, 0x01, 0x32, 0x18, 0x5e, 0x5b, 0x41, 0x2d, 0x5a, 0x61,
	0x2d, 0x7a, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d,
	0x2a, 0x24, 0x52, 0x09, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x08, 0xf2,
	0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10,
	0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x1a,
	0x32, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02,
	0x18, 0x64, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x01, 0x10, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x42, 0x0f, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0x51,
	0x0a, 0x12, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62,
	0x53, 0x75, 0x62, 0x73, 0x12, 0x3b, 0x0a, 0x07, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x52, 0x07, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x73, 0x22, 0xa7, 0x01, 0x0a, 0x18, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x4f,
	0x0a, 0x07, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x1a,
	0x3a, 0x0a, 0x0c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa2, 0x01, 0x0a, 0x1b,
	0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x03, 0x69,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xbf, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x39, 0x0a,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00,
	0x10, 0x01, 0x22, 0x9d, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x75, 0x62, 0x53, 0x75, 0x62, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x06, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x32, 0xe1, 0x06, 0x0a, 0x19, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x12, 0x6a, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73,
	0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12, 0x2f, 0x61, 0x73, 0x2f, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x2d, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x9f, 0x01, 0x0a,
	0x03, 0x47, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x61,
	0x73, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2f, 0x7b, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x69,
	0x64, 0x73, 0x2e, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x8e,
	0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x73, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x61, 0x73, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2f, 0x7b,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x12,
	0xef, 0x01, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x22, 0x97, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x90,
	0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x61, 0x73, 0x2f, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2f, 0x7b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x69, 0x64,
	0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x7d, 0x1a, 0x4e, 0x2f, 0x61, 0x73, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2f, 0x7b, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x69, 0x64, 0x73, 0x2e, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x69, 0x64,
	0x7d, 0x12, 0x90, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2c, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x61, 0x73, 0x2f,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62,
	0x5f, 0x69, 0x64, 0x7d, 0x1a, 0x20, 0x92, 0x41, 0x1d, 0x12, 0x1b, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x73, 0x2e, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescData = file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDesc
)

func file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDescData
}

var file_ttn_lorawan_v3_applicationserver_pubsub_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_ttn_lorawan_v3_applicationserver_pubsub_proto_goTypes = []interface{}{
	(ApplicationPubSub_MQTTProvider_QoS)(0),                     // 0: ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.QoS
	(*ApplicationPubSubIdentifiers)(nil),                        // 1: ttn.lorawan.v3.ApplicationPubSubIdentifiers
	(*ApplicationPubSub)(nil),                                   // 2: ttn.lorawan.v3.ApplicationPubSub
	(*ApplicationPubSubs)(nil),                                  // 3: ttn.lorawan.v3.ApplicationPubSubs
	(*ApplicationPubSubFormats)(nil),                            // 4: ttn.lorawan.v3.ApplicationPubSubFormats
	(*GetApplicationPubSubRequest)(nil),                         // 5: ttn.lorawan.v3.GetApplicationPubSubRequest
	(*ListApplicationPubSubsRequest)(nil),                       // 6: ttn.lorawan.v3.ListApplicationPubSubsRequest
	(*SetApplicationPubSubRequest)(nil),                         // 7: ttn.lorawan.v3.SetApplicationPubSubRequest
	(*ApplicationPubSub_NATSProvider)(nil),                      // 8: ttn.lorawan.v3.ApplicationPubSub.NATSProvider
	(*ApplicationPubSub_MQTTProvider)(nil),                      // 9: ttn.lorawan.v3.ApplicationPubSub.MQTTProvider
	(*ApplicationPubSub_AWSIoTProvider)(nil),                    // 10: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider
	(*ApplicationPubSub_Message)(nil),                           // 11: ttn.lorawan.v3.ApplicationPubSub.Message
	nil,                                                         // 12: ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.HeadersEntry
	(*ApplicationPubSub_AWSIoTProvider_AccessKey)(nil),          // 13: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.AccessKey
	(*ApplicationPubSub_AWSIoTProvider_AssumeRole)(nil),         // 14: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.AssumeRole
	(*ApplicationPubSub_AWSIoTProvider_DefaultIntegration)(nil), // 15: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.DefaultIntegration
	nil,                            // 16: ttn.lorawan.v3.ApplicationPubSubFormats.FormatsEntry
	(*ApplicationIdentifiers)(nil), // 17: ttn.lorawan.v3.ApplicationIdentifiers
	(*timestamppb.Timestamp)(nil),  // 18: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),  // 19: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),    // 20: google.protobuf.Duration
	(*emptypb.Empty)(nil),          // 21: google.protobuf.Empty
}
var file_ttn_lorawan_v3_applicationserver_pubsub_proto_depIdxs = []int32{
	17, // 0: ttn.lorawan.v3.ApplicationPubSubIdentifiers.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	1,  // 1: ttn.lorawan.v3.ApplicationPubSub.ids:type_name -> ttn.lorawan.v3.ApplicationPubSubIdentifiers
	18, // 2: ttn.lorawan.v3.ApplicationPubSub.created_at:type_name -> google.protobuf.Timestamp
	18, // 3: ttn.lorawan.v3.ApplicationPubSub.updated_at:type_name -> google.protobuf.Timestamp
	8,  // 4: ttn.lorawan.v3.ApplicationPubSub.nats:type_name -> ttn.lorawan.v3.ApplicationPubSub.NATSProvider
	9,  // 5: ttn.lorawan.v3.ApplicationPubSub.mqtt:type_name -> ttn.lorawan.v3.ApplicationPubSub.MQTTProvider
	10, // 6: ttn.lorawan.v3.ApplicationPubSub.aws_iot:type_name -> ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider
	11, // 7: ttn.lorawan.v3.ApplicationPubSub.downlink_push:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 8: ttn.lorawan.v3.ApplicationPubSub.downlink_replace:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 9: ttn.lorawan.v3.ApplicationPubSub.uplink_message:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 10: ttn.lorawan.v3.ApplicationPubSub.uplink_normalized:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 11: ttn.lorawan.v3.ApplicationPubSub.join_accept:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 12: ttn.lorawan.v3.ApplicationPubSub.downlink_ack:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 13: ttn.lorawan.v3.ApplicationPubSub.downlink_nack:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 14: ttn.lorawan.v3.ApplicationPubSub.downlink_sent:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 15: ttn.lorawan.v3.ApplicationPubSub.downlink_failed:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 16: ttn.lorawan.v3.ApplicationPubSub.downlink_queued:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 17: ttn.lorawan.v3.ApplicationPubSub.downlink_queue_invalidated:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 18: ttn.lorawan.v3.ApplicationPubSub.location_solved:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	11, // 19: ttn.lorawan.v3.ApplicationPubSub.service_data:type_name -> ttn.lorawan.v3.ApplicationPubSub.Message
	2,  // 20: ttn.lorawan.v3.ApplicationPubSubs.pubsubs:type_name -> ttn.lorawan.v3.ApplicationPubSub
	16, // 21: ttn.lorawan.v3.ApplicationPubSubFormats.formats:type_name -> ttn.lorawan.v3.ApplicationPubSubFormats.FormatsEntry
	1,  // 22: ttn.lorawan.v3.GetApplicationPubSubRequest.ids:type_name -> ttn.lorawan.v3.ApplicationPubSubIdentifiers
	19, // 23: ttn.lorawan.v3.GetApplicationPubSubRequest.field_mask:type_name -> google.protobuf.FieldMask
	17, // 24: ttn.lorawan.v3.ListApplicationPubSubsRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	19, // 25: ttn.lorawan.v3.ListApplicationPubSubsRequest.field_mask:type_name -> google.protobuf.FieldMask
	2,  // 26: ttn.lorawan.v3.SetApplicationPubSubRequest.pubsub:type_name -> ttn.lorawan.v3.ApplicationPubSub
	19, // 27: ttn.lorawan.v3.SetApplicationPubSubRequest.field_mask:type_name -> google.protobuf.FieldMask
	0,  // 28: ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.subscribe_qos:type_name -> ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.QoS
	0,  // 29: ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.publish_qos:type_name -> ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.QoS
	12, // 30: ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.headers:type_name -> ttn.lorawan.v3.ApplicationPubSub.MQTTProvider.HeadersEntry
	13, // 31: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.access_key:type_name -> ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.AccessKey
	14, // 32: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.assume_role:type_name -> ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.AssumeRole
	15, // 33: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.default:type_name -> ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.DefaultIntegration
	20, // 34: ttn.lorawan.v3.ApplicationPubSub.AWSIoTProvider.AssumeRole.session_duration:type_name -> google.protobuf.Duration
	21, // 35: ttn.lorawan.v3.ApplicationPubSubRegistry.GetFormats:input_type -> google.protobuf.Empty
	5,  // 36: ttn.lorawan.v3.ApplicationPubSubRegistry.Get:input_type -> ttn.lorawan.v3.GetApplicationPubSubRequest
	6,  // 37: ttn.lorawan.v3.ApplicationPubSubRegistry.List:input_type -> ttn.lorawan.v3.ListApplicationPubSubsRequest
	7,  // 38: ttn.lorawan.v3.ApplicationPubSubRegistry.Set:input_type -> ttn.lorawan.v3.SetApplicationPubSubRequest
	1,  // 39: ttn.lorawan.v3.ApplicationPubSubRegistry.Delete:input_type -> ttn.lorawan.v3.ApplicationPubSubIdentifiers
	4,  // 40: ttn.lorawan.v3.ApplicationPubSubRegistry.GetFormats:output_type -> ttn.lorawan.v3.ApplicationPubSubFormats
	2,  // 41: ttn.lorawan.v3.ApplicationPubSubRegistry.Get:output_type -> ttn.lorawan.v3.ApplicationPubSub
	3,  // 42: ttn.lorawan.v3.ApplicationPubSubRegistry.List:output_type -> ttn.lorawan.v3.ApplicationPubSubs
	2,  // 43: ttn.lorawan.v3.ApplicationPubSubRegistry.Set:output_type -> ttn.lorawan.v3.ApplicationPubSub
	21, // 44: ttn.lorawan.v3.ApplicationPubSubRegistry.Delete:output_type -> google.protobuf.Empty
	40, // [40:45] is the sub-list for method output_type
	35, // [35:40] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_applicationserver_pubsub_proto_init() }
func file_ttn_lorawan_v3_applicationserver_pubsub_proto_init() {
	if File_ttn_lorawan_v3_applicationserver_pubsub_proto != nil {
		return
	}
	file_ttn_lorawan_v3_identifiers_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSubIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSubs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSubFormats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApplicationPubSubRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListApplicationPubSubsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetApplicationPubSubRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub_NATSProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub_MQTTProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub_AWSIoTProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub_Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub_AWSIoTProvider_AccessKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub_AWSIoTProvider_AssumeRole); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationPubSub_AWSIoTProvider_DefaultIntegration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ApplicationPubSub_Nats)(nil),
		(*ApplicationPubSub_Mqtt)(nil),
		(*ApplicationPubSub_AwsIot)(nil),
	}
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ApplicationPubSub_AWSIoTProvider_Default)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ttn_lorawan_v3_applicationserver_pubsub_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_applicationserver_pubsub_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_applicationserver_pubsub_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_applicationserver_pubsub_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_applicationserver_pubsub_proto = out.File
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_rawDesc = nil
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_goTypes = nil
	file_ttn_lorawan_v3_applicationserver_pubsub_proto_depIdxs = nil
}
