// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/applicationserver_packages.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ApplicationPackageRegistry_List_FullMethodName                     = "/ttn.lorawan.v3.ApplicationPackageRegistry/List"
	ApplicationPackageRegistry_GetAssociation_FullMethodName           = "/ttn.lorawan.v3.ApplicationPackageRegistry/GetAssociation"
	ApplicationPackageRegistry_ListAssociations_FullMethodName         = "/ttn.lorawan.v3.ApplicationPackageRegistry/ListAssociations"
	ApplicationPackageRegistry_SetAssociation_FullMethodName           = "/ttn.lorawan.v3.ApplicationPackageRegistry/SetAssociation"
	ApplicationPackageRegistry_DeleteAssociation_FullMethodName        = "/ttn.lorawan.v3.ApplicationPackageRegistry/DeleteAssociation"
	ApplicationPackageRegistry_GetDefaultAssociation_FullMethodName    = "/ttn.lorawan.v3.ApplicationPackageRegistry/GetDefaultAssociation"
	ApplicationPackageRegistry_ListDefaultAssociations_FullMethodName  = "/ttn.lorawan.v3.ApplicationPackageRegistry/ListDefaultAssociations"
	ApplicationPackageRegistry_SetDefaultAssociation_FullMethodName    = "/ttn.lorawan.v3.ApplicationPackageRegistry/SetDefaultAssociation"
	ApplicationPackageRegistry_DeleteDefaultAssociation_FullMethodName = "/ttn.lorawan.v3.ApplicationPackageRegistry/DeleteDefaultAssociation"
)

// ApplicationPackageRegistryClient is the client API for ApplicationPackageRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationPackageRegistryClient interface {
	// List returns the available packages for the end device.
	List(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*ApplicationPackages, error)
	// GetAssociation returns the association registered on the FPort of the end device.
	GetAssociation(ctx context.Context, in *GetApplicationPackageAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageAssociation, error)
	// ListAssociations returns all of the associations of the end device.
	ListAssociations(ctx context.Context, in *ListApplicationPackageAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageAssociations, error)
	// SetAssociation updates or creates the association on the FPort of the end device.
	SetAssociation(ctx context.Context, in *SetApplicationPackageAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageAssociation, error)
	// DeleteAssociation removes the association on the FPort of the end device.
	DeleteAssociation(ctx context.Context, in *ApplicationPackageAssociationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// GetDefaultAssociation returns the default association registered on the FPort of the application.
	GetDefaultAssociation(ctx context.Context, in *GetApplicationPackageDefaultAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageDefaultAssociation, error)
	// ListDefaultAssociations returns all of the default associations of the application.
	ListDefaultAssociations(ctx context.Context, in *ListApplicationPackageDefaultAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageDefaultAssociations, error)
	// SetDefaultAssociation updates or creates the default association on the FPort of the application.
	SetDefaultAssociation(ctx context.Context, in *SetApplicationPackageDefaultAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageDefaultAssociation, error)
	// DeleteDefaultAssociation removes the default association on the FPort of the application.
	DeleteDefaultAssociation(ctx context.Context, in *ApplicationPackageDefaultAssociationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type applicationPackageRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationPackageRegistryClient(cc grpc.ClientConnInterface) ApplicationPackageRegistryClient {
	return &applicationPackageRegistryClient{cc}
}

func (c *applicationPackageRegistryClient) List(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*ApplicationPackages, error) {
	out := new(ApplicationPackages)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) GetAssociation(ctx context.Context, in *GetApplicationPackageAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageAssociation, error) {
	out := new(ApplicationPackageAssociation)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_GetAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) ListAssociations(ctx context.Context, in *ListApplicationPackageAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageAssociations, error) {
	out := new(ApplicationPackageAssociations)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_ListAssociations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) SetAssociation(ctx context.Context, in *SetApplicationPackageAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageAssociation, error) {
	out := new(ApplicationPackageAssociation)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_SetAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) DeleteAssociation(ctx context.Context, in *ApplicationPackageAssociationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_DeleteAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) GetDefaultAssociation(ctx context.Context, in *GetApplicationPackageDefaultAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageDefaultAssociation, error) {
	out := new(ApplicationPackageDefaultAssociation)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_GetDefaultAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) ListDefaultAssociations(ctx context.Context, in *ListApplicationPackageDefaultAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageDefaultAssociations, error) {
	out := new(ApplicationPackageDefaultAssociations)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_ListDefaultAssociations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) SetDefaultAssociation(ctx context.Context, in *SetApplicationPackageDefaultAssociationRequest, opts ...grpc.CallOption) (*ApplicationPackageDefaultAssociation, error) {
	out := new(ApplicationPackageDefaultAssociation)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_SetDefaultAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationPackageRegistryClient) DeleteDefaultAssociation(ctx context.Context, in *ApplicationPackageDefaultAssociationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationPackageRegistry_DeleteDefaultAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationPackageRegistryServer is the server API for ApplicationPackageRegistry service.
// All implementations must embed UnimplementedApplicationPackageRegistryServer
// for forward compatibility
type ApplicationPackageRegistryServer interface {
	// List returns the available packages for the end device.
	List(context.Context, *EndDeviceIdentifiers) (*ApplicationPackages, error)
	// GetAssociation returns the association registered on the FPort of the end device.
	GetAssociation(context.Context, *GetApplicationPackageAssociationRequest) (*ApplicationPackageAssociation, error)
	// ListAssociations returns all of the associations of the end device.
	ListAssociations(context.Context, *ListApplicationPackageAssociationRequest) (*ApplicationPackageAssociations, error)
	// SetAssociation updates or creates the association on the FPort of the end device.
	SetAssociation(context.Context, *SetApplicationPackageAssociationRequest) (*ApplicationPackageAssociation, error)
	// DeleteAssociation removes the association on the FPort of the end device.
	DeleteAssociation(context.Context, *ApplicationPackageAssociationIdentifiers) (*emptypb.Empty, error)
	// GetDefaultAssociation returns the default association registered on the FPort of the application.
	GetDefaultAssociation(context.Context, *GetApplicationPackageDefaultAssociationRequest) (*ApplicationPackageDefaultAssociation, error)
	// ListDefaultAssociations returns all of the default associations of the application.
	ListDefaultAssociations(context.Context, *ListApplicationPackageDefaultAssociationRequest) (*ApplicationPackageDefaultAssociations, error)
	// SetDefaultAssociation updates or creates the default association on the FPort of the application.
	SetDefaultAssociation(context.Context, *SetApplicationPackageDefaultAssociationRequest) (*ApplicationPackageDefaultAssociation, error)
	// DeleteDefaultAssociation removes the default association on the FPort of the application.
	DeleteDefaultAssociation(context.Context, *ApplicationPackageDefaultAssociationIdentifiers) (*emptypb.Empty, error)
	mustEmbedUnimplementedApplicationPackageRegistryServer()
}

// UnimplementedApplicationPackageRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedApplicationPackageRegistryServer struct {
}

func (UnimplementedApplicationPackageRegistryServer) List(context.Context, *EndDeviceIdentifiers) (*ApplicationPackages, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) GetAssociation(context.Context, *GetApplicationPackageAssociationRequest) (*ApplicationPackageAssociation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAssociation not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) ListAssociations(context.Context, *ListApplicationPackageAssociationRequest) (*ApplicationPackageAssociations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssociations not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) SetAssociation(context.Context, *SetApplicationPackageAssociationRequest) (*ApplicationPackageAssociation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAssociation not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) DeleteAssociation(context.Context, *ApplicationPackageAssociationIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAssociation not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) GetDefaultAssociation(context.Context, *GetApplicationPackageDefaultAssociationRequest) (*ApplicationPackageDefaultAssociation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultAssociation not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) ListDefaultAssociations(context.Context, *ListApplicationPackageDefaultAssociationRequest) (*ApplicationPackageDefaultAssociations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDefaultAssociations not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) SetDefaultAssociation(context.Context, *SetApplicationPackageDefaultAssociationRequest) (*ApplicationPackageDefaultAssociation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultAssociation not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) DeleteDefaultAssociation(context.Context, *ApplicationPackageDefaultAssociationIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDefaultAssociation not implemented")
}
func (UnimplementedApplicationPackageRegistryServer) mustEmbedUnimplementedApplicationPackageRegistryServer() {
}

// UnsafeApplicationPackageRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationPackageRegistryServer will
// result in compilation errors.
type UnsafeApplicationPackageRegistryServer interface {
	mustEmbedUnimplementedApplicationPackageRegistryServer()
}

func RegisterApplicationPackageRegistryServer(s grpc.ServiceRegistrar, srv ApplicationPackageRegistryServer) {
	s.RegisterService(&ApplicationPackageRegistry_ServiceDesc, srv)
}

func _ApplicationPackageRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndDeviceIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).List(ctx, req.(*EndDeviceIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_GetAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationPackageAssociationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).GetAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_GetAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).GetAssociation(ctx, req.(*GetApplicationPackageAssociationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_ListAssociations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationPackageAssociationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).ListAssociations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_ListAssociations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).ListAssociations(ctx, req.(*ListApplicationPackageAssociationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_SetAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetApplicationPackageAssociationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).SetAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_SetAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).SetAssociation(ctx, req.(*SetApplicationPackageAssociationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_DeleteAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationPackageAssociationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).DeleteAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_DeleteAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).DeleteAssociation(ctx, req.(*ApplicationPackageAssociationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_GetDefaultAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationPackageDefaultAssociationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).GetDefaultAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_GetDefaultAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).GetDefaultAssociation(ctx, req.(*GetApplicationPackageDefaultAssociationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_ListDefaultAssociations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationPackageDefaultAssociationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).ListDefaultAssociations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_ListDefaultAssociations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).ListDefaultAssociations(ctx, req.(*ListApplicationPackageDefaultAssociationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_SetDefaultAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetApplicationPackageDefaultAssociationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).SetDefaultAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_SetDefaultAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).SetDefaultAssociation(ctx, req.(*SetApplicationPackageDefaultAssociationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationPackageRegistry_DeleteDefaultAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationPackageDefaultAssociationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationPackageRegistryServer).DeleteDefaultAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationPackageRegistry_DeleteDefaultAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationPackageRegistryServer).DeleteDefaultAssociation(ctx, req.(*ApplicationPackageDefaultAssociationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// ApplicationPackageRegistry_ServiceDesc is the grpc.ServiceDesc for ApplicationPackageRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ApplicationPackageRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ApplicationPackageRegistry",
	HandlerType: (*ApplicationPackageRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _ApplicationPackageRegistry_List_Handler,
		},
		{
			MethodName: "GetAssociation",
			Handler:    _ApplicationPackageRegistry_GetAssociation_Handler,
		},
		{
			MethodName: "ListAssociations",
			Handler:    _ApplicationPackageRegistry_ListAssociations_Handler,
		},
		{
			MethodName: "SetAssociation",
			Handler:    _ApplicationPackageRegistry_SetAssociation_Handler,
		},
		{
			MethodName: "DeleteAssociation",
			Handler:    _ApplicationPackageRegistry_DeleteAssociation_Handler,
		},
		{
			MethodName: "GetDefaultAssociation",
			Handler:    _ApplicationPackageRegistry_GetDefaultAssociation_Handler,
		},
		{
			MethodName: "ListDefaultAssociations",
			Handler:    _ApplicationPackageRegistry_ListDefaultAssociations_Handler,
		},
		{
			MethodName: "SetDefaultAssociation",
			Handler:    _ApplicationPackageRegistry_SetDefaultAssociation_Handler,
		},
		{
			MethodName: "DeleteDefaultAssociation",
			Handler:    _ApplicationPackageRegistry_DeleteDefaultAssociation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/applicationserver_packages.proto",
}
