// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on ApplicationPackage with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationPackage) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "name":

			if utf8.RuneCountInString(m.GetName()) > 36 {
				return ApplicationPackageValidationError{
					field:  "name",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ApplicationPackage_Name_Pattern.MatchString(m.GetName()) {
				return ApplicationPackageValidationError{
					field:  "name",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "default_f_port":

			if val := m.GetDefaultFPort(); val < 1 || val > 255 {
				return ApplicationPackageValidationError{
					field:  "default_f_port",
					reason: "value must be inside range [1, 255]",
				}
			}

		default:
			return ApplicationPackageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackageValidationError is the validation error returned by
// ApplicationPackage.ValidateFields if the designated constraints aren't met.
type ApplicationPackageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPackageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPackageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackageValidationError) ErrorName() string {
	return "ApplicationPackageValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackageValidationError{}

var _ApplicationPackage_Name_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationPackages with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationPackages) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackagesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "packages":

			for idx, item := range m.GetPackages() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationPackagesValidationError{
							field:  fmt.Sprintf("packages[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationPackagesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackagesValidationError is the validation error returned by
// ApplicationPackages.ValidateFields if the designated constraints aren't met.
type ApplicationPackagesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackagesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPackagesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPackagesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackagesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackagesValidationError) ErrorName() string {
	return "ApplicationPackagesValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackagesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackages.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackagesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackagesValidationError{}

// ValidateFields checks the field values on
// ApplicationPackageAssociationIdentifiers with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ApplicationPackageAssociationIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackageAssociationIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return ApplicationPackageAssociationIdentifiersValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageAssociationIdentifiersValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "f_port":

			if val := m.GetFPort(); val < 1 || val > 255 {
				return ApplicationPackageAssociationIdentifiersValidationError{
					field:  "f_port",
					reason: "value must be inside range [1, 255]",
				}
			}

		default:
			return ApplicationPackageAssociationIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackageAssociationIdentifiersValidationError is the validation
// error returned by ApplicationPackageAssociationIdentifiers.ValidateFields
// if the designated constraints aren't met.
type ApplicationPackageAssociationIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackageAssociationIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPackageAssociationIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPackageAssociationIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackageAssociationIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackageAssociationIdentifiersValidationError) ErrorName() string {
	return "ApplicationPackageAssociationIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackageAssociationIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackageAssociationIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackageAssociationIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackageAssociationIdentifiersValidationError{}

// ValidateFields checks the field values on ApplicationPackageAssociation with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationPackageAssociation) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackageAssociationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ApplicationPackageAssociationValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageAssociationValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageAssociationValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageAssociationValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "package_name":

			if utf8.RuneCountInString(m.GetPackageName()) > 36 {
				return ApplicationPackageAssociationValidationError{
					field:  "package_name",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ApplicationPackageAssociation_PackageName_Pattern.MatchString(m.GetPackageName()) {
				return ApplicationPackageAssociationValidationError{
					field:  "package_name",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "data":

			if v, ok := interface{}(m.GetData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageAssociationValidationError{
						field:  "data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationPackageAssociationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackageAssociationValidationError is the validation error
// returned by ApplicationPackageAssociation.ValidateFields if the designated
// constraints aren't met.
type ApplicationPackageAssociationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackageAssociationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPackageAssociationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPackageAssociationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackageAssociationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackageAssociationValidationError) ErrorName() string {
	return "ApplicationPackageAssociationValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackageAssociationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackageAssociation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackageAssociationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackageAssociationValidationError{}

var _ApplicationPackageAssociation_PackageName_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationPackageAssociations
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationPackageAssociations) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackageAssociationsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "associations":

			for idx, item := range m.GetAssociations() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationPackageAssociationsValidationError{
							field:  fmt.Sprintf("associations[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationPackageAssociationsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackageAssociationsValidationError is the validation error
// returned by ApplicationPackageAssociations.ValidateFields if the designated
// constraints aren't met.
type ApplicationPackageAssociationsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackageAssociationsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPackageAssociationsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPackageAssociationsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackageAssociationsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackageAssociationsValidationError) ErrorName() string {
	return "ApplicationPackageAssociationsValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackageAssociationsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackageAssociations.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackageAssociationsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackageAssociationsValidationError{}

// ValidateFields checks the field values on
// GetApplicationPackageAssociationRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *GetApplicationPackageAssociationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationPackageAssociationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return GetApplicationPackageAssociationRequestValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationPackageAssociationRequestValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationPackageAssociationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationPackageAssociationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationPackageAssociationRequestValidationError is the validation
// error returned by GetApplicationPackageAssociationRequest.ValidateFields if
// the designated constraints aren't met.
type GetApplicationPackageAssociationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationPackageAssociationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationPackageAssociationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationPackageAssociationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationPackageAssociationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationPackageAssociationRequestValidationError) ErrorName() string {
	return "GetApplicationPackageAssociationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationPackageAssociationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationPackageAssociationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationPackageAssociationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationPackageAssociationRequestValidationError{}

// ValidateFields checks the field values on
// ListApplicationPackageAssociationRequest with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ListApplicationPackageAssociationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationPackageAssociationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ListApplicationPackageAssociationRequestValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationPackageAssociationRequestValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListApplicationPackageAssociationRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationPackageAssociationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ListApplicationPackageAssociationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationPackageAssociationRequestValidationError is the validation
// error returned by ListApplicationPackageAssociationRequest.ValidateFields
// if the designated constraints aren't met.
type ListApplicationPackageAssociationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationPackageAssociationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListApplicationPackageAssociationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListApplicationPackageAssociationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationPackageAssociationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationPackageAssociationRequestValidationError) ErrorName() string {
	return "ListApplicationPackageAssociationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationPackageAssociationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationPackageAssociationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationPackageAssociationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationPackageAssociationRequestValidationError{}

// ValidateFields checks the field values on
// SetApplicationPackageAssociationRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *SetApplicationPackageAssociationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetApplicationPackageAssociationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "association":

			if m.GetAssociation() == nil {
				return SetApplicationPackageAssociationRequestValidationError{
					field:  "association",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetAssociation()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationPackageAssociationRequestValidationError{
						field:  "association",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationPackageAssociationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetApplicationPackageAssociationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetApplicationPackageAssociationRequestValidationError is the validation
// error returned by SetApplicationPackageAssociationRequest.ValidateFields if
// the designated constraints aren't met.
type SetApplicationPackageAssociationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetApplicationPackageAssociationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetApplicationPackageAssociationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetApplicationPackageAssociationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetApplicationPackageAssociationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetApplicationPackageAssociationRequestValidationError) ErrorName() string {
	return "SetApplicationPackageAssociationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetApplicationPackageAssociationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetApplicationPackageAssociationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetApplicationPackageAssociationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetApplicationPackageAssociationRequestValidationError{}

// ValidateFields checks the field values on
// ApplicationPackageDefaultAssociationIdentifiers with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ApplicationPackageDefaultAssociationIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackageDefaultAssociationIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return ApplicationPackageDefaultAssociationIdentifiersValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageDefaultAssociationIdentifiersValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "f_port":

			if val := m.GetFPort(); val < 1 || val > 255 {
				return ApplicationPackageDefaultAssociationIdentifiersValidationError{
					field:  "f_port",
					reason: "value must be inside range [1, 255]",
				}
			}

		default:
			return ApplicationPackageDefaultAssociationIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackageDefaultAssociationIdentifiersValidationError is the
// validation error returned by
// ApplicationPackageDefaultAssociationIdentifiers.ValidateFields if the
// designated constraints aren't met.
type ApplicationPackageDefaultAssociationIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackageDefaultAssociationIdentifiersValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ApplicationPackageDefaultAssociationIdentifiersValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ApplicationPackageDefaultAssociationIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackageDefaultAssociationIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackageDefaultAssociationIdentifiersValidationError) ErrorName() string {
	return "ApplicationPackageDefaultAssociationIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackageDefaultAssociationIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackageDefaultAssociationIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackageDefaultAssociationIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackageDefaultAssociationIdentifiersValidationError{}

// ValidateFields checks the field values on
// ApplicationPackageDefaultAssociation with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ApplicationPackageDefaultAssociation) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackageDefaultAssociationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ApplicationPackageDefaultAssociationValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageDefaultAssociationValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageDefaultAssociationValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageDefaultAssociationValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "package_name":

			if utf8.RuneCountInString(m.GetPackageName()) > 36 {
				return ApplicationPackageDefaultAssociationValidationError{
					field:  "package_name",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ApplicationPackageDefaultAssociation_PackageName_Pattern.MatchString(m.GetPackageName()) {
				return ApplicationPackageDefaultAssociationValidationError{
					field:  "package_name",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "data":

			if v, ok := interface{}(m.GetData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationPackageDefaultAssociationValidationError{
						field:  "data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationPackageDefaultAssociationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackageDefaultAssociationValidationError is the validation error
// returned by ApplicationPackageDefaultAssociation.ValidateFields if the
// designated constraints aren't met.
type ApplicationPackageDefaultAssociationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackageDefaultAssociationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPackageDefaultAssociationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPackageDefaultAssociationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackageDefaultAssociationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackageDefaultAssociationValidationError) ErrorName() string {
	return "ApplicationPackageDefaultAssociationValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackageDefaultAssociationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackageDefaultAssociation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackageDefaultAssociationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackageDefaultAssociationValidationError{}

var _ApplicationPackageDefaultAssociation_PackageName_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on
// ApplicationPackageDefaultAssociations with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ApplicationPackageDefaultAssociations) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationPackageDefaultAssociationsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "defaults":

			for idx, item := range m.GetDefaults() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationPackageDefaultAssociationsValidationError{
							field:  fmt.Sprintf("defaults[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationPackageDefaultAssociationsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationPackageDefaultAssociationsValidationError is the validation error
// returned by ApplicationPackageDefaultAssociations.ValidateFields if the
// designated constraints aren't met.
type ApplicationPackageDefaultAssociationsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationPackageDefaultAssociationsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationPackageDefaultAssociationsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationPackageDefaultAssociationsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationPackageDefaultAssociationsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationPackageDefaultAssociationsValidationError) ErrorName() string {
	return "ApplicationPackageDefaultAssociationsValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationPackageDefaultAssociationsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationPackageDefaultAssociations.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationPackageDefaultAssociationsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationPackageDefaultAssociationsValidationError{}

// ValidateFields checks the field values on
// GetApplicationPackageDefaultAssociationRequest with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *GetApplicationPackageDefaultAssociationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationPackageDefaultAssociationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return GetApplicationPackageDefaultAssociationRequestValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationPackageDefaultAssociationRequestValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationPackageDefaultAssociationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationPackageDefaultAssociationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationPackageDefaultAssociationRequestValidationError is the
// validation error returned by
// GetApplicationPackageDefaultAssociationRequest.ValidateFields if the
// designated constraints aren't met.
type GetApplicationPackageDefaultAssociationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationPackageDefaultAssociationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationPackageDefaultAssociationRequestValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e GetApplicationPackageDefaultAssociationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationPackageDefaultAssociationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationPackageDefaultAssociationRequestValidationError) ErrorName() string {
	return "GetApplicationPackageDefaultAssociationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationPackageDefaultAssociationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationPackageDefaultAssociationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationPackageDefaultAssociationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationPackageDefaultAssociationRequestValidationError{}

// ValidateFields checks the field values on
// ListApplicationPackageDefaultAssociationRequest with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ListApplicationPackageDefaultAssociationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationPackageDefaultAssociationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ListApplicationPackageDefaultAssociationRequestValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationPackageDefaultAssociationRequestValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListApplicationPackageDefaultAssociationRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationPackageDefaultAssociationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ListApplicationPackageDefaultAssociationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationPackageDefaultAssociationRequestValidationError is the
// validation error returned by
// ListApplicationPackageDefaultAssociationRequest.ValidateFields if the
// designated constraints aren't met.
type ListApplicationPackageDefaultAssociationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationPackageDefaultAssociationRequestValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ListApplicationPackageDefaultAssociationRequestValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ListApplicationPackageDefaultAssociationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationPackageDefaultAssociationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationPackageDefaultAssociationRequestValidationError) ErrorName() string {
	return "ListApplicationPackageDefaultAssociationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationPackageDefaultAssociationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationPackageDefaultAssociationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationPackageDefaultAssociationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationPackageDefaultAssociationRequestValidationError{}

// ValidateFields checks the field values on
// SetApplicationPackageDefaultAssociationRequest with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *SetApplicationPackageDefaultAssociationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetApplicationPackageDefaultAssociationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "default":

			if m.GetDefault() == nil {
				return SetApplicationPackageDefaultAssociationRequestValidationError{
					field:  "default",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDefault()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationPackageDefaultAssociationRequestValidationError{
						field:  "default",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationPackageDefaultAssociationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetApplicationPackageDefaultAssociationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetApplicationPackageDefaultAssociationRequestValidationError is the
// validation error returned by
// SetApplicationPackageDefaultAssociationRequest.ValidateFields if the
// designated constraints aren't met.
type SetApplicationPackageDefaultAssociationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetApplicationPackageDefaultAssociationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetApplicationPackageDefaultAssociationRequestValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e SetApplicationPackageDefaultAssociationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetApplicationPackageDefaultAssociationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetApplicationPackageDefaultAssociationRequestValidationError) ErrorName() string {
	return "SetApplicationPackageDefaultAssociationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetApplicationPackageDefaultAssociationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetApplicationPackageDefaultAssociationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetApplicationPackageDefaultAssociationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetApplicationPackageDefaultAssociationRequestValidationError{}
