// Copyright © 2020 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/applicationserver_integrations_storage.proto

package ttnpb

import (
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ContinuationTokenPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Limit          *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=limit,proto3" json:"limit,omitempty"`
	After          *timestamppb.Timestamp  `protobuf:"bytes,2,opt,name=after,proto3" json:"after,omitempty"`
	Before         *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=before,proto3" json:"before,omitempty"`
	FPort          *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	Order          string                  `protobuf:"bytes,5,opt,name=order,proto3" json:"order,omitempty"`
	FieldMask      *fieldmaskpb.FieldMask  `protobuf:"bytes,6,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	Last           *durationpb.Duration    `protobuf:"bytes,7,opt,name=last,proto3" json:"last,omitempty"`
	LastReceivedId int64                   `protobuf:"varint,8,opt,name=last_received_id,json=lastReceivedId,proto3" json:"last_received_id,omitempty"`
}

func (x *ContinuationTokenPayload) Reset() {
	*x = ContinuationTokenPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContinuationTokenPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContinuationTokenPayload) ProtoMessage() {}

func (x *ContinuationTokenPayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContinuationTokenPayload.ProtoReflect.Descriptor instead.
func (*ContinuationTokenPayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescGZIP(), []int{0}
}

func (x *ContinuationTokenPayload) GetLimit() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Limit
	}
	return nil
}

func (x *ContinuationTokenPayload) GetAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.After
	}
	return nil
}

func (x *ContinuationTokenPayload) GetBefore() *timestamppb.Timestamp {
	if x != nil {
		return x.Before
	}
	return nil
}

func (x *ContinuationTokenPayload) GetFPort() *wrapperspb.UInt32Value {
	if x != nil {
		return x.FPort
	}
	return nil
}

func (x *ContinuationTokenPayload) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

func (x *ContinuationTokenPayload) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ContinuationTokenPayload) GetLast() *durationpb.Duration {
	if x != nil {
		return x.Last
	}
	return nil
}

func (x *ContinuationTokenPayload) GetLastReceivedId() int64 {
	if x != nil {
		return x.LastReceivedId
	}
	return 0
}

type GetStoredApplicationUpRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Query upstream messages from all end devices of an application. Cannot be used in conjunction with end_device_ids.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// Query upstream messages from a single end device. Cannot be used in conjunction with application_ids.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,2,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Query upstream messages of a specific type. If not set, then all upstream messages are returned.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Limit number of results.
	Limit *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Query upstream messages after this timestamp only. Cannot be used in conjunction with last.
	After *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=after,proto3" json:"after,omitempty"`
	// Query upstream messages before this timestamp only. Cannot be used in conjunction with last.
	Before *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=before,proto3" json:"before,omitempty"`
	// Query uplinks on a specific FPort only.
	FPort *wrapperspb.UInt32Value `protobuf:"bytes,7,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// Order results.
	Order string `protobuf:"bytes,8,opt,name=order,proto3" json:"order,omitempty"`
	// The names of the upstream message fields that should be returned. See the API reference
	// for allowed field names for each type of upstream message.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,9,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Query upstream messages that have arrived in the last minutes or hours. Cannot be used in conjunction with after and before.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/applicationserver_integrations_storage.proto.
	Last *durationpb.Duration `protobuf:"bytes,10,opt,name=last,proto3" json:"last,omitempty"`
	// The continuation token, which is used to retrieve the next page. If provided, other fields are ignored.
	ContinuationToken string `protobuf:"bytes,11,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
}

func (x *GetStoredApplicationUpRequest) Reset() {
	*x = GetStoredApplicationUpRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoredApplicationUpRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoredApplicationUpRequest) ProtoMessage() {}

func (x *GetStoredApplicationUpRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoredApplicationUpRequest.ProtoReflect.Descriptor instead.
func (*GetStoredApplicationUpRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescGZIP(), []int{1}
}

func (x *GetStoredApplicationUpRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *GetStoredApplicationUpRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *GetStoredApplicationUpRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *GetStoredApplicationUpRequest) GetLimit() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Limit
	}
	return nil
}

func (x *GetStoredApplicationUpRequest) GetAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.After
	}
	return nil
}

func (x *GetStoredApplicationUpRequest) GetBefore() *timestamppb.Timestamp {
	if x != nil {
		return x.Before
	}
	return nil
}

func (x *GetStoredApplicationUpRequest) GetFPort() *wrapperspb.UInt32Value {
	if x != nil {
		return x.FPort
	}
	return nil
}

func (x *GetStoredApplicationUpRequest) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

func (x *GetStoredApplicationUpRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/applicationserver_integrations_storage.proto.
func (x *GetStoredApplicationUpRequest) GetLast() *durationpb.Duration {
	if x != nil {
		return x.Last
	}
	return nil
}

func (x *GetStoredApplicationUpRequest) GetContinuationToken() string {
	if x != nil {
		return x.ContinuationToken
	}
	return ""
}

type GetStoredApplicationUpCountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count upstream messages from all end devices of an application. Cannot be used in conjunction with end_device_ids.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// Count upstream messages from a single end device. Cannot be used in conjunction with application_ids.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,2,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Count upstream messages of a specific type. If not set, then all upstream messages are returned.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Count upstream messages after this timestamp only. Cannot be used in conjunction with last.
	After *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=after,proto3" json:"after,omitempty"`
	// Count upstream messages before this timestamp only. Cannot be used in conjunction with last.
	Before *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=before,proto3" json:"before,omitempty"`
	// Count uplinks on a specific FPort only.
	FPort *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// Count upstream messages that have arrived in the last minutes or hours. Cannot be used in conjunction with after and before.
	Last *durationpb.Duration `protobuf:"bytes,7,opt,name=last,proto3" json:"last,omitempty"`
}

func (x *GetStoredApplicationUpCountRequest) Reset() {
	*x = GetStoredApplicationUpCountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoredApplicationUpCountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoredApplicationUpCountRequest) ProtoMessage() {}

func (x *GetStoredApplicationUpCountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoredApplicationUpCountRequest.ProtoReflect.Descriptor instead.
func (*GetStoredApplicationUpCountRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescGZIP(), []int{2}
}

func (x *GetStoredApplicationUpCountRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *GetStoredApplicationUpCountRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *GetStoredApplicationUpCountRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *GetStoredApplicationUpCountRequest) GetAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.After
	}
	return nil
}

func (x *GetStoredApplicationUpCountRequest) GetBefore() *timestamppb.Timestamp {
	if x != nil {
		return x.Before
	}
	return nil
}

func (x *GetStoredApplicationUpCountRequest) GetFPort() *wrapperspb.UInt32Value {
	if x != nil {
		return x.FPort
	}
	return nil
}

func (x *GetStoredApplicationUpCountRequest) GetLast() *durationpb.Duration {
	if x != nil {
		return x.Last
	}
	return nil
}

type GetStoredApplicationUpCountResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of stored messages by end device ID.
	Count map[string]uint32 `protobuf:"bytes,1,rep,name=count,proto3" json:"count,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *GetStoredApplicationUpCountResponse) Reset() {
	*x = GetStoredApplicationUpCountResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoredApplicationUpCountResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoredApplicationUpCountResponse) ProtoMessage() {}

func (x *GetStoredApplicationUpCountResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoredApplicationUpCountResponse.ProtoReflect.Descriptor instead.
func (*GetStoredApplicationUpCountResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescGZIP(), []int{3}
}

func (x *GetStoredApplicationUpCountResponse) GetCount() map[string]uint32 {
	if x != nil {
		return x.Count
	}
	return nil
}

var File_ttn_lorawan_v3_applicationserver_integrations_storage_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x03, 0x0a, 0x18, 0x43, 0x6f, 0x6e,
	0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x32, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x61, 0x66, 0x74,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x61, 0x66, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x06, 0x62,
	0x65, 0x66, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x12,
	0x33, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x66,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2d, 0x0a, 0x04, 0x6c, 0x61, 0x73, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6c, 0x61, 0x73, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e,
	0x6c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x49, 0x64, 0x22, 0xc6,
	0x06, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x73, 0x12, 0x4a, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52,
	0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0xd7, 0x01,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0xc2, 0x01, 0xfa,
	0x42, 0xbe, 0x01, 0x72, 0xbb, 0x01, 0x52, 0x00, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x11, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x0b, 0x6a, 0x6f, 0x69,
	0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x61, 0x63, 0x6b, 0x52, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x6e, 0x61, 0x63, 0x6b, 0x52, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f,
	0x73, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x52, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f,
	0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x52, 0x1a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x64, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x61, 0x66, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a,
	0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72,
	0x65, 0x12, 0x33, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x38, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x42, 0x1f, 0x72, 0x1d, 0x52, 0x00, 0x52, 0x0c,
	0x2d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x52, 0x0b, 0x72, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x31, 0x0a, 0x04, 0x6c,
	0x61, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x6c, 0x61, 0x73, 0x74, 0x12, 0x37,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72,
	0x03, 0x18, 0x80, 0x7d, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd2, 0x04, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f,
	0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52,
	0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12,
	0x4a, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0c, 0x65,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0xc4, 0x01, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0xaf, 0x01, 0xfa, 0x42, 0xab,
	0x01, 0x72, 0xa8, 0x01, 0x52, 0x00, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x63,
	0x6b, 0x52, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6e, 0x61, 0x63, 0x6b,
	0x52, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x52,
	0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x52, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65,
	0x64, 0x52, 0x1a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x52, 0x0f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x52, 0x0c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x2d, 0x0a,
	0x04, 0x6c, 0x61, 0x73, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6c, 0x61, 0x73, 0x74, 0x22, 0xb5, 0x01, 0x0a,
	0x23, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x38, 0x0a, 0x0a, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x32, 0x87, 0x06, 0x0a, 0x14, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0xbc, 0x02,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x12, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x22, 0xd1, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xca, 0x01,
	0x5a, 0x4b, 0x12, 0x49, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x7b, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x12, 0x7b, 0x2f,
	0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2f, 0x7b, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x30, 0x01, 0x12, 0xe7, 0x02, 0x0a,
	0x1b, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x55, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xde, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd7, 0x01, 0x5a,
	0x51, 0x12, 0x4f, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x7b, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x2f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x81, 0x01, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x73, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x7b, 0x74, 0x79, 0x70, 0x65, 0x7d,
	0x2f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x46, 0x92, 0x41, 0x43, 0x12, 0x41, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x75,
	0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x31,
	0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescData = file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDesc
)

func file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDescData
}

var file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_goTypes = []interface{}{
	(*ContinuationTokenPayload)(nil),            // 0: ttn.lorawan.v3.ContinuationTokenPayload
	(*GetStoredApplicationUpRequest)(nil),       // 1: ttn.lorawan.v3.GetStoredApplicationUpRequest
	(*GetStoredApplicationUpCountRequest)(nil),  // 2: ttn.lorawan.v3.GetStoredApplicationUpCountRequest
	(*GetStoredApplicationUpCountResponse)(nil), // 3: ttn.lorawan.v3.GetStoredApplicationUpCountResponse
	nil,                            // 4: ttn.lorawan.v3.GetStoredApplicationUpCountResponse.CountEntry
	(*wrapperspb.UInt32Value)(nil), // 5: google.protobuf.UInt32Value
	(*timestamppb.Timestamp)(nil),  // 6: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),  // 7: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),    // 8: google.protobuf.Duration
	(*ApplicationIdentifiers)(nil), // 9: ttn.lorawan.v3.ApplicationIdentifiers
	(*EndDeviceIdentifiers)(nil),   // 10: ttn.lorawan.v3.EndDeviceIdentifiers
	(*ApplicationUp)(nil),          // 11: ttn.lorawan.v3.ApplicationUp
}
var file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_depIdxs = []int32{
	5,  // 0: ttn.lorawan.v3.ContinuationTokenPayload.limit:type_name -> google.protobuf.UInt32Value
	6,  // 1: ttn.lorawan.v3.ContinuationTokenPayload.after:type_name -> google.protobuf.Timestamp
	6,  // 2: ttn.lorawan.v3.ContinuationTokenPayload.before:type_name -> google.protobuf.Timestamp
	5,  // 3: ttn.lorawan.v3.ContinuationTokenPayload.f_port:type_name -> google.protobuf.UInt32Value
	7,  // 4: ttn.lorawan.v3.ContinuationTokenPayload.field_mask:type_name -> google.protobuf.FieldMask
	8,  // 5: ttn.lorawan.v3.ContinuationTokenPayload.last:type_name -> google.protobuf.Duration
	9,  // 6: ttn.lorawan.v3.GetStoredApplicationUpRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	10, // 7: ttn.lorawan.v3.GetStoredApplicationUpRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	5,  // 8: ttn.lorawan.v3.GetStoredApplicationUpRequest.limit:type_name -> google.protobuf.UInt32Value
	6,  // 9: ttn.lorawan.v3.GetStoredApplicationUpRequest.after:type_name -> google.protobuf.Timestamp
	6,  // 10: ttn.lorawan.v3.GetStoredApplicationUpRequest.before:type_name -> google.protobuf.Timestamp
	5,  // 11: ttn.lorawan.v3.GetStoredApplicationUpRequest.f_port:type_name -> google.protobuf.UInt32Value
	7,  // 12: ttn.lorawan.v3.GetStoredApplicationUpRequest.field_mask:type_name -> google.protobuf.FieldMask
	8,  // 13: ttn.lorawan.v3.GetStoredApplicationUpRequest.last:type_name -> google.protobuf.Duration
	9,  // 14: ttn.lorawan.v3.GetStoredApplicationUpCountRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	10, // 15: ttn.lorawan.v3.GetStoredApplicationUpCountRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	6,  // 16: ttn.lorawan.v3.GetStoredApplicationUpCountRequest.after:type_name -> google.protobuf.Timestamp
	6,  // 17: ttn.lorawan.v3.GetStoredApplicationUpCountRequest.before:type_name -> google.protobuf.Timestamp
	5,  // 18: ttn.lorawan.v3.GetStoredApplicationUpCountRequest.f_port:type_name -> google.protobuf.UInt32Value
	8,  // 19: ttn.lorawan.v3.GetStoredApplicationUpCountRequest.last:type_name -> google.protobuf.Duration
	4,  // 20: ttn.lorawan.v3.GetStoredApplicationUpCountResponse.count:type_name -> ttn.lorawan.v3.GetStoredApplicationUpCountResponse.CountEntry
	1,  // 21: ttn.lorawan.v3.ApplicationUpStorage.GetStoredApplicationUp:input_type -> ttn.lorawan.v3.GetStoredApplicationUpRequest
	2,  // 22: ttn.lorawan.v3.ApplicationUpStorage.GetStoredApplicationUpCount:input_type -> ttn.lorawan.v3.GetStoredApplicationUpCountRequest
	11, // 23: ttn.lorawan.v3.ApplicationUpStorage.GetStoredApplicationUp:output_type -> ttn.lorawan.v3.ApplicationUp
	3,  // 24: ttn.lorawan.v3.ApplicationUpStorage.GetStoredApplicationUpCount:output_type -> ttn.lorawan.v3.GetStoredApplicationUpCountResponse
	23, // [23:25] is the sub-list for method output_type
	21, // [21:23] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_init() }
func file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_init() {
	if File_ttn_lorawan_v3_applicationserver_integrations_storage_proto != nil {
		return
	}
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_messages_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContinuationTokenPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoredApplicationUpRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoredApplicationUpCountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoredApplicationUpCountResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_applicationserver_integrations_storage_proto = out.File
	file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_rawDesc = nil
	file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_goTypes = nil
	file_ttn_lorawan_v3_applicationserver_integrations_storage_proto_depIdxs = nil
}
