// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/applicationserver.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	As_GetLink_FullMethodName          = "/ttn.lorawan.v3.As/GetLink"
	As_SetLink_FullMethodName          = "/ttn.lorawan.v3.As/SetLink"
	As_DeleteLink_FullMethodName       = "/ttn.lorawan.v3.As/DeleteLink"
	As_GetLinkStats_FullMethodName     = "/ttn.lorawan.v3.As/GetLinkStats"
	As_GetConfiguration_FullMethodName = "/ttn.lorawan.v3.As/GetConfiguration"
)

// AsClient is the client API for As service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AsClient interface {
	// Get a link configuration from the Application Server to Network Server.
	// This only contains the configuration. Use GetLinkStats to view statistics and any link errors.
	GetLink(ctx context.Context, in *GetApplicationLinkRequest, opts ...grpc.CallOption) (*ApplicationLink, error)
	// Set a link configuration from the Application Server a Network Server.
	// This call returns immediately after setting the link configuration; it does not wait for a link to establish.
	// To get link statistics or errors, use GetLinkStats.
	// Note that there can only be one Application Server instance linked to a Network Server for a given application at a time.
	SetLink(ctx context.Context, in *SetApplicationLinkRequest, opts ...grpc.CallOption) (*ApplicationLink, error)
	// Delete the link between the Application Server and Network Server for the specified application.
	DeleteLink(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// GetLinkStats returns the link statistics.
	// This call returns a NotFound error code if there is no link for the given application identifiers.
	// This call returns the error code of the link error if linking to a Network Server failed.
	GetLinkStats(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*ApplicationLinkStats, error)
	GetConfiguration(ctx context.Context, in *GetAsConfigurationRequest, opts ...grpc.CallOption) (*GetAsConfigurationResponse, error)
}

type asClient struct {
	cc grpc.ClientConnInterface
}

func NewAsClient(cc grpc.ClientConnInterface) AsClient {
	return &asClient{cc}
}

func (c *asClient) GetLink(ctx context.Context, in *GetApplicationLinkRequest, opts ...grpc.CallOption) (*ApplicationLink, error) {
	out := new(ApplicationLink)
	err := c.cc.Invoke(ctx, As_GetLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *asClient) SetLink(ctx context.Context, in *SetApplicationLinkRequest, opts ...grpc.CallOption) (*ApplicationLink, error) {
	out := new(ApplicationLink)
	err := c.cc.Invoke(ctx, As_SetLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *asClient) DeleteLink(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, As_DeleteLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *asClient) GetLinkStats(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*ApplicationLinkStats, error) {
	out := new(ApplicationLinkStats)
	err := c.cc.Invoke(ctx, As_GetLinkStats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *asClient) GetConfiguration(ctx context.Context, in *GetAsConfigurationRequest, opts ...grpc.CallOption) (*GetAsConfigurationResponse, error) {
	out := new(GetAsConfigurationResponse)
	err := c.cc.Invoke(ctx, As_GetConfiguration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AsServer is the server API for As service.
// All implementations must embed UnimplementedAsServer
// for forward compatibility
type AsServer interface {
	// Get a link configuration from the Application Server to Network Server.
	// This only contains the configuration. Use GetLinkStats to view statistics and any link errors.
	GetLink(context.Context, *GetApplicationLinkRequest) (*ApplicationLink, error)
	// Set a link configuration from the Application Server a Network Server.
	// This call returns immediately after setting the link configuration; it does not wait for a link to establish.
	// To get link statistics or errors, use GetLinkStats.
	// Note that there can only be one Application Server instance linked to a Network Server for a given application at a time.
	SetLink(context.Context, *SetApplicationLinkRequest) (*ApplicationLink, error)
	// Delete the link between the Application Server and Network Server for the specified application.
	DeleteLink(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error)
	// GetLinkStats returns the link statistics.
	// This call returns a NotFound error code if there is no link for the given application identifiers.
	// This call returns the error code of the link error if linking to a Network Server failed.
	GetLinkStats(context.Context, *ApplicationIdentifiers) (*ApplicationLinkStats, error)
	GetConfiguration(context.Context, *GetAsConfigurationRequest) (*GetAsConfigurationResponse, error)
	mustEmbedUnimplementedAsServer()
}

// UnimplementedAsServer must be embedded to have forward compatible implementations.
type UnimplementedAsServer struct {
}

func (UnimplementedAsServer) GetLink(context.Context, *GetApplicationLinkRequest) (*ApplicationLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLink not implemented")
}
func (UnimplementedAsServer) SetLink(context.Context, *SetApplicationLinkRequest) (*ApplicationLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLink not implemented")
}
func (UnimplementedAsServer) DeleteLink(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLink not implemented")
}
func (UnimplementedAsServer) GetLinkStats(context.Context, *ApplicationIdentifiers) (*ApplicationLinkStats, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLinkStats not implemented")
}
func (UnimplementedAsServer) GetConfiguration(context.Context, *GetAsConfigurationRequest) (*GetAsConfigurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfiguration not implemented")
}
func (UnimplementedAsServer) mustEmbedUnimplementedAsServer() {}

// UnsafeAsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AsServer will
// result in compilation errors.
type UnsafeAsServer interface {
	mustEmbedUnimplementedAsServer()
}

func RegisterAsServer(s grpc.ServiceRegistrar, srv AsServer) {
	s.RegisterService(&As_ServiceDesc, srv)
}

func _As_GetLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsServer).GetLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: As_GetLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsServer).GetLink(ctx, req.(*GetApplicationLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _As_SetLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetApplicationLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsServer).SetLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: As_SetLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsServer).SetLink(ctx, req.(*SetApplicationLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _As_DeleteLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsServer).DeleteLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: As_DeleteLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsServer).DeleteLink(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _As_GetLinkStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsServer).GetLinkStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: As_GetLinkStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsServer).GetLinkStats(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _As_GetConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAsConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsServer).GetConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: As_GetConfiguration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsServer).GetConfiguration(ctx, req.(*GetAsConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// As_ServiceDesc is the grpc.ServiceDesc for As service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var As_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.As",
	HandlerType: (*AsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLink",
			Handler:    _As_GetLink_Handler,
		},
		{
			MethodName: "SetLink",
			Handler:    _As_SetLink_Handler,
		},
		{
			MethodName: "DeleteLink",
			Handler:    _As_DeleteLink_Handler,
		},
		{
			MethodName: "GetLinkStats",
			Handler:    _As_GetLinkStats_Handler,
		},
		{
			MethodName: "GetConfiguration",
			Handler:    _As_GetConfiguration_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/applicationserver.proto",
}

const (
	NsAs_HandleUplink_FullMethodName = "/ttn.lorawan.v3.NsAs/HandleUplink"
)

// NsAsClient is the client API for NsAs service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NsAsClient interface {
	// Handle Application uplink messages.
	HandleUplink(ctx context.Context, in *NsAsHandleUplinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type nsAsClient struct {
	cc grpc.ClientConnInterface
}

func NewNsAsClient(cc grpc.ClientConnInterface) NsAsClient {
	return &nsAsClient{cc}
}

func (c *nsAsClient) HandleUplink(ctx context.Context, in *NsAsHandleUplinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, NsAs_HandleUplink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NsAsServer is the server API for NsAs service.
// All implementations must embed UnimplementedNsAsServer
// for forward compatibility
type NsAsServer interface {
	// Handle Application uplink messages.
	HandleUplink(context.Context, *NsAsHandleUplinkRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedNsAsServer()
}

// UnimplementedNsAsServer must be embedded to have forward compatible implementations.
type UnimplementedNsAsServer struct {
}

func (UnimplementedNsAsServer) HandleUplink(context.Context, *NsAsHandleUplinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleUplink not implemented")
}
func (UnimplementedNsAsServer) mustEmbedUnimplementedNsAsServer() {}

// UnsafeNsAsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NsAsServer will
// result in compilation errors.
type UnsafeNsAsServer interface {
	mustEmbedUnimplementedNsAsServer()
}

func RegisterNsAsServer(s grpc.ServiceRegistrar, srv NsAsServer) {
	s.RegisterService(&NsAs_ServiceDesc, srv)
}

func _NsAs_HandleUplink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NsAsHandleUplinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsAsServer).HandleUplink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsAs_HandleUplink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsAsServer).HandleUplink(ctx, req.(*NsAsHandleUplinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NsAs_ServiceDesc is the grpc.ServiceDesc for NsAs service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NsAs_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.NsAs",
	HandlerType: (*NsAsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleUplink",
			Handler:    _NsAs_HandleUplink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/applicationserver.proto",
}

const (
	AppAs_Subscribe_FullMethodName             = "/ttn.lorawan.v3.AppAs/Subscribe"
	AppAs_DownlinkQueuePush_FullMethodName     = "/ttn.lorawan.v3.AppAs/DownlinkQueuePush"
	AppAs_DownlinkQueueReplace_FullMethodName  = "/ttn.lorawan.v3.AppAs/DownlinkQueueReplace"
	AppAs_DownlinkQueueList_FullMethodName     = "/ttn.lorawan.v3.AppAs/DownlinkQueueList"
	AppAs_GetMQTTConnectionInfo_FullMethodName = "/ttn.lorawan.v3.AppAs/GetMQTTConnectionInfo"
	AppAs_SimulateUplink_FullMethodName        = "/ttn.lorawan.v3.AppAs/SimulateUplink"
	AppAs_EncodeDownlink_FullMethodName        = "/ttn.lorawan.v3.AppAs/EncodeDownlink"
	AppAs_DecodeUplink_FullMethodName          = "/ttn.lorawan.v3.AppAs/DecodeUplink"
	AppAs_DecodeDownlink_FullMethodName        = "/ttn.lorawan.v3.AppAs/DecodeDownlink"
)

// AppAsClient is the client API for AppAs service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AppAsClient interface {
	// Subscribe to upstream messages.
	Subscribe(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (AppAs_SubscribeClient, error)
	// Push downlink messages to the end of the downlink queue.
	DownlinkQueuePush(ctx context.Context, in *DownlinkQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Replace the entire downlink queue with the specified messages.
	// This can also be used to empty the queue by specifying no messages.
	DownlinkQueueReplace(ctx context.Context, in *DownlinkQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List the items currently in the downlink queue.
	DownlinkQueueList(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*ApplicationDownlinks, error)
	// Get connection information to connect an MQTT client.
	GetMQTTConnectionInfo(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*MQTTConnectionInfo, error)
	// Simulate an upstream message. This can be used to test integrations.
	SimulateUplink(ctx context.Context, in *ApplicationUp, opts ...grpc.CallOption) (*emptypb.Empty, error)
	EncodeDownlink(ctx context.Context, in *EncodeDownlinkRequest, opts ...grpc.CallOption) (*EncodeDownlinkResponse, error)
	DecodeUplink(ctx context.Context, in *DecodeUplinkRequest, opts ...grpc.CallOption) (*DecodeUplinkResponse, error)
	DecodeDownlink(ctx context.Context, in *DecodeDownlinkRequest, opts ...grpc.CallOption) (*DecodeDownlinkResponse, error)
}

type appAsClient struct {
	cc grpc.ClientConnInterface
}

func NewAppAsClient(cc grpc.ClientConnInterface) AppAsClient {
	return &appAsClient{cc}
}

func (c *appAsClient) Subscribe(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (AppAs_SubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &AppAs_ServiceDesc.Streams[0], AppAs_Subscribe_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &appAsSubscribeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AppAs_SubscribeClient interface {
	Recv() (*ApplicationUp, error)
	grpc.ClientStream
}

type appAsSubscribeClient struct {
	grpc.ClientStream
}

func (x *appAsSubscribeClient) Recv() (*ApplicationUp, error) {
	m := new(ApplicationUp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *appAsClient) DownlinkQueuePush(ctx context.Context, in *DownlinkQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AppAs_DownlinkQueuePush_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appAsClient) DownlinkQueueReplace(ctx context.Context, in *DownlinkQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AppAs_DownlinkQueueReplace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appAsClient) DownlinkQueueList(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*ApplicationDownlinks, error) {
	out := new(ApplicationDownlinks)
	err := c.cc.Invoke(ctx, AppAs_DownlinkQueueList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appAsClient) GetMQTTConnectionInfo(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*MQTTConnectionInfo, error) {
	out := new(MQTTConnectionInfo)
	err := c.cc.Invoke(ctx, AppAs_GetMQTTConnectionInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appAsClient) SimulateUplink(ctx context.Context, in *ApplicationUp, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AppAs_SimulateUplink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appAsClient) EncodeDownlink(ctx context.Context, in *EncodeDownlinkRequest, opts ...grpc.CallOption) (*EncodeDownlinkResponse, error) {
	out := new(EncodeDownlinkResponse)
	err := c.cc.Invoke(ctx, AppAs_EncodeDownlink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appAsClient) DecodeUplink(ctx context.Context, in *DecodeUplinkRequest, opts ...grpc.CallOption) (*DecodeUplinkResponse, error) {
	out := new(DecodeUplinkResponse)
	err := c.cc.Invoke(ctx, AppAs_DecodeUplink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appAsClient) DecodeDownlink(ctx context.Context, in *DecodeDownlinkRequest, opts ...grpc.CallOption) (*DecodeDownlinkResponse, error) {
	out := new(DecodeDownlinkResponse)
	err := c.cc.Invoke(ctx, AppAs_DecodeDownlink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppAsServer is the server API for AppAs service.
// All implementations must embed UnimplementedAppAsServer
// for forward compatibility
type AppAsServer interface {
	// Subscribe to upstream messages.
	Subscribe(*ApplicationIdentifiers, AppAs_SubscribeServer) error
	// Push downlink messages to the end of the downlink queue.
	DownlinkQueuePush(context.Context, *DownlinkQueueRequest) (*emptypb.Empty, error)
	// Replace the entire downlink queue with the specified messages.
	// This can also be used to empty the queue by specifying no messages.
	DownlinkQueueReplace(context.Context, *DownlinkQueueRequest) (*emptypb.Empty, error)
	// List the items currently in the downlink queue.
	DownlinkQueueList(context.Context, *EndDeviceIdentifiers) (*ApplicationDownlinks, error)
	// Get connection information to connect an MQTT client.
	GetMQTTConnectionInfo(context.Context, *ApplicationIdentifiers) (*MQTTConnectionInfo, error)
	// Simulate an upstream message. This can be used to test integrations.
	SimulateUplink(context.Context, *ApplicationUp) (*emptypb.Empty, error)
	EncodeDownlink(context.Context, *EncodeDownlinkRequest) (*EncodeDownlinkResponse, error)
	DecodeUplink(context.Context, *DecodeUplinkRequest) (*DecodeUplinkResponse, error)
	DecodeDownlink(context.Context, *DecodeDownlinkRequest) (*DecodeDownlinkResponse, error)
	mustEmbedUnimplementedAppAsServer()
}

// UnimplementedAppAsServer must be embedded to have forward compatible implementations.
type UnimplementedAppAsServer struct {
}

func (UnimplementedAppAsServer) Subscribe(*ApplicationIdentifiers, AppAs_SubscribeServer) error {
	return status.Errorf(codes.Unimplemented, "method Subscribe not implemented")
}
func (UnimplementedAppAsServer) DownlinkQueuePush(context.Context, *DownlinkQueueRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DownlinkQueuePush not implemented")
}
func (UnimplementedAppAsServer) DownlinkQueueReplace(context.Context, *DownlinkQueueRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DownlinkQueueReplace not implemented")
}
func (UnimplementedAppAsServer) DownlinkQueueList(context.Context, *EndDeviceIdentifiers) (*ApplicationDownlinks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DownlinkQueueList not implemented")
}
func (UnimplementedAppAsServer) GetMQTTConnectionInfo(context.Context, *ApplicationIdentifiers) (*MQTTConnectionInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMQTTConnectionInfo not implemented")
}
func (UnimplementedAppAsServer) SimulateUplink(context.Context, *ApplicationUp) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SimulateUplink not implemented")
}
func (UnimplementedAppAsServer) EncodeDownlink(context.Context, *EncodeDownlinkRequest) (*EncodeDownlinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EncodeDownlink not implemented")
}
func (UnimplementedAppAsServer) DecodeUplink(context.Context, *DecodeUplinkRequest) (*DecodeUplinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DecodeUplink not implemented")
}
func (UnimplementedAppAsServer) DecodeDownlink(context.Context, *DecodeDownlinkRequest) (*DecodeDownlinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DecodeDownlink not implemented")
}
func (UnimplementedAppAsServer) mustEmbedUnimplementedAppAsServer() {}

// UnsafeAppAsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AppAsServer will
// result in compilation errors.
type UnsafeAppAsServer interface {
	mustEmbedUnimplementedAppAsServer()
}

func RegisterAppAsServer(s grpc.ServiceRegistrar, srv AppAsServer) {
	s.RegisterService(&AppAs_ServiceDesc, srv)
}

func _AppAs_Subscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ApplicationIdentifiers)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AppAsServer).Subscribe(m, &appAsSubscribeServer{stream})
}

type AppAs_SubscribeServer interface {
	Send(*ApplicationUp) error
	grpc.ServerStream
}

type appAsSubscribeServer struct {
	grpc.ServerStream
}

func (x *appAsSubscribeServer) Send(m *ApplicationUp) error {
	return x.ServerStream.SendMsg(m)
}

func _AppAs_DownlinkQueuePush_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DownlinkQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).DownlinkQueuePush(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_DownlinkQueuePush_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).DownlinkQueuePush(ctx, req.(*DownlinkQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppAs_DownlinkQueueReplace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DownlinkQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).DownlinkQueueReplace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_DownlinkQueueReplace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).DownlinkQueueReplace(ctx, req.(*DownlinkQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppAs_DownlinkQueueList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndDeviceIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).DownlinkQueueList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_DownlinkQueueList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).DownlinkQueueList(ctx, req.(*EndDeviceIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppAs_GetMQTTConnectionInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).GetMQTTConnectionInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_GetMQTTConnectionInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).GetMQTTConnectionInfo(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppAs_SimulateUplink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationUp)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).SimulateUplink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_SimulateUplink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).SimulateUplink(ctx, req.(*ApplicationUp))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppAs_EncodeDownlink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncodeDownlinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).EncodeDownlink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_EncodeDownlink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).EncodeDownlink(ctx, req.(*EncodeDownlinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppAs_DecodeUplink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecodeUplinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).DecodeUplink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_DecodeUplink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).DecodeUplink(ctx, req.(*DecodeUplinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppAs_DecodeDownlink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecodeDownlinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppAsServer).DecodeDownlink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppAs_DecodeDownlink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppAsServer).DecodeDownlink(ctx, req.(*DecodeDownlinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AppAs_ServiceDesc is the grpc.ServiceDesc for AppAs service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AppAs_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.AppAs",
	HandlerType: (*AppAsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DownlinkQueuePush",
			Handler:    _AppAs_DownlinkQueuePush_Handler,
		},
		{
			MethodName: "DownlinkQueueReplace",
			Handler:    _AppAs_DownlinkQueueReplace_Handler,
		},
		{
			MethodName: "DownlinkQueueList",
			Handler:    _AppAs_DownlinkQueueList_Handler,
		},
		{
			MethodName: "GetMQTTConnectionInfo",
			Handler:    _AppAs_GetMQTTConnectionInfo_Handler,
		},
		{
			MethodName: "SimulateUplink",
			Handler:    _AppAs_SimulateUplink_Handler,
		},
		{
			MethodName: "EncodeDownlink",
			Handler:    _AppAs_EncodeDownlink_Handler,
		},
		{
			MethodName: "DecodeUplink",
			Handler:    _AppAs_DecodeUplink_Handler,
		},
		{
			MethodName: "DecodeDownlink",
			Handler:    _AppAs_DecodeDownlink_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Subscribe",
			Handler:       _AppAs_Subscribe_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ttn/lorawan/v3/applicationserver.proto",
}

const (
	AsEndDeviceRegistry_Get_FullMethodName    = "/ttn.lorawan.v3.AsEndDeviceRegistry/Get"
	AsEndDeviceRegistry_Set_FullMethodName    = "/ttn.lorawan.v3.AsEndDeviceRegistry/Set"
	AsEndDeviceRegistry_Delete_FullMethodName = "/ttn.lorawan.v3.AsEndDeviceRegistry/Delete"
)

// AsEndDeviceRegistryClient is the client API for AsEndDeviceRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AsEndDeviceRegistryClient interface {
	// Get returns the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Get(ctx context.Context, in *GetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error)
	// Set creates or updates the device.
	Set(ctx context.Context, in *SetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error)
	// Delete deletes the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Delete(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type asEndDeviceRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewAsEndDeviceRegistryClient(cc grpc.ClientConnInterface) AsEndDeviceRegistryClient {
	return &asEndDeviceRegistryClient{cc}
}

func (c *asEndDeviceRegistryClient) Get(ctx context.Context, in *GetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error) {
	out := new(EndDevice)
	err := c.cc.Invoke(ctx, AsEndDeviceRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *asEndDeviceRegistryClient) Set(ctx context.Context, in *SetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error) {
	out := new(EndDevice)
	err := c.cc.Invoke(ctx, AsEndDeviceRegistry_Set_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *asEndDeviceRegistryClient) Delete(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AsEndDeviceRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AsEndDeviceRegistryServer is the server API for AsEndDeviceRegistry service.
// All implementations must embed UnimplementedAsEndDeviceRegistryServer
// for forward compatibility
type AsEndDeviceRegistryServer interface {
	// Get returns the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Get(context.Context, *GetEndDeviceRequest) (*EndDevice, error)
	// Set creates or updates the device.
	Set(context.Context, *SetEndDeviceRequest) (*EndDevice, error)
	// Delete deletes the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Delete(context.Context, *EndDeviceIdentifiers) (*emptypb.Empty, error)
	mustEmbedUnimplementedAsEndDeviceRegistryServer()
}

// UnimplementedAsEndDeviceRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedAsEndDeviceRegistryServer struct {
}

func (UnimplementedAsEndDeviceRegistryServer) Get(context.Context, *GetEndDeviceRequest) (*EndDevice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedAsEndDeviceRegistryServer) Set(context.Context, *SetEndDeviceRequest) (*EndDevice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Set not implemented")
}
func (UnimplementedAsEndDeviceRegistryServer) Delete(context.Context, *EndDeviceIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedAsEndDeviceRegistryServer) mustEmbedUnimplementedAsEndDeviceRegistryServer() {}

// UnsafeAsEndDeviceRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AsEndDeviceRegistryServer will
// result in compilation errors.
type UnsafeAsEndDeviceRegistryServer interface {
	mustEmbedUnimplementedAsEndDeviceRegistryServer()
}

func RegisterAsEndDeviceRegistryServer(s grpc.ServiceRegistrar, srv AsEndDeviceRegistryServer) {
	s.RegisterService(&AsEndDeviceRegistry_ServiceDesc, srv)
}

func _AsEndDeviceRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEndDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsEndDeviceRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AsEndDeviceRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsEndDeviceRegistryServer).Get(ctx, req.(*GetEndDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AsEndDeviceRegistry_Set_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetEndDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsEndDeviceRegistryServer).Set(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AsEndDeviceRegistry_Set_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsEndDeviceRegistryServer).Set(ctx, req.(*SetEndDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AsEndDeviceRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndDeviceIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsEndDeviceRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AsEndDeviceRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsEndDeviceRegistryServer).Delete(ctx, req.(*EndDeviceIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// AsEndDeviceRegistry_ServiceDesc is the grpc.ServiceDesc for AsEndDeviceRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AsEndDeviceRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.AsEndDeviceRegistry",
	HandlerType: (*AsEndDeviceRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _AsEndDeviceRegistry_Get_Handler,
		},
		{
			MethodName: "Set",
			Handler:    _AsEndDeviceRegistry_Set_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _AsEndDeviceRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/applicationserver.proto",
}

const (
	AsEndDeviceBatchRegistry_Delete_FullMethodName = "/ttn.lorawan.v3.AsEndDeviceBatchRegistry/Delete"
)

// AsEndDeviceBatchRegistryClient is the client API for AsEndDeviceBatchRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AsEndDeviceBatchRegistryClient interface {
	// Delete a list of devices within the same application.
	// This operation is atomic; either all devices are deleted or none.
	// Devices not found are skipped and no error is returned.
	Delete(ctx context.Context, in *BatchDeleteEndDevicesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type asEndDeviceBatchRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewAsEndDeviceBatchRegistryClient(cc grpc.ClientConnInterface) AsEndDeviceBatchRegistryClient {
	return &asEndDeviceBatchRegistryClient{cc}
}

func (c *asEndDeviceBatchRegistryClient) Delete(ctx context.Context, in *BatchDeleteEndDevicesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AsEndDeviceBatchRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AsEndDeviceBatchRegistryServer is the server API for AsEndDeviceBatchRegistry service.
// All implementations must embed UnimplementedAsEndDeviceBatchRegistryServer
// for forward compatibility
type AsEndDeviceBatchRegistryServer interface {
	// Delete a list of devices within the same application.
	// This operation is atomic; either all devices are deleted or none.
	// Devices not found are skipped and no error is returned.
	Delete(context.Context, *BatchDeleteEndDevicesRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedAsEndDeviceBatchRegistryServer()
}

// UnimplementedAsEndDeviceBatchRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedAsEndDeviceBatchRegistryServer struct {
}

func (UnimplementedAsEndDeviceBatchRegistryServer) Delete(context.Context, *BatchDeleteEndDevicesRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedAsEndDeviceBatchRegistryServer) mustEmbedUnimplementedAsEndDeviceBatchRegistryServer() {
}

// UnsafeAsEndDeviceBatchRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AsEndDeviceBatchRegistryServer will
// result in compilation errors.
type UnsafeAsEndDeviceBatchRegistryServer interface {
	mustEmbedUnimplementedAsEndDeviceBatchRegistryServer()
}

func RegisterAsEndDeviceBatchRegistryServer(s grpc.ServiceRegistrar, srv AsEndDeviceBatchRegistryServer) {
	s.RegisterService(&AsEndDeviceBatchRegistry_ServiceDesc, srv)
}

func _AsEndDeviceBatchRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEndDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsEndDeviceBatchRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AsEndDeviceBatchRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsEndDeviceBatchRegistryServer).Delete(ctx, req.(*BatchDeleteEndDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AsEndDeviceBatchRegistry_ServiceDesc is the grpc.ServiceDesc for AsEndDeviceBatchRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AsEndDeviceBatchRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.AsEndDeviceBatchRegistry",
	HandlerType: (*AsEndDeviceBatchRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _AsEndDeviceBatchRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/applicationserver.proto",
}
