// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on ApplicationLink with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationLink) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationLinkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "default_formatters":

			if v, ok := interface{}(m.GetDefaultFormatters()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationLinkValidationError{
						field:  "default_formatters",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "skip_payload_crypto":

			if v, ok := interface{}(m.GetSkipPayloadCrypto()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationLinkValidationError{
						field:  "skip_payload_crypto",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationLinkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationLinkValidationError is the validation error returned by
// ApplicationLink.ValidateFields if the designated constraints aren't met.
type ApplicationLinkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationLinkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationLinkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationLinkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationLinkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationLinkValidationError) ErrorName() string { return "ApplicationLinkValidationError" }

// Error satisfies the builtin error interface
func (e ApplicationLinkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationLink.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationLinkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationLinkValidationError{}

// ValidateFields checks the field values on GetApplicationLinkRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetApplicationLinkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationLinkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return GetApplicationLinkRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationLinkRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationLinkRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationLinkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationLinkRequestValidationError is the validation error returned by
// GetApplicationLinkRequest.ValidateFields if the designated constraints
// aren't met.
type GetApplicationLinkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationLinkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationLinkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationLinkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationLinkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationLinkRequestValidationError) ErrorName() string {
	return "GetApplicationLinkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationLinkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationLinkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationLinkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationLinkRequestValidationError{}

// ValidateFields checks the field values on SetApplicationLinkRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *SetApplicationLinkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetApplicationLinkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return SetApplicationLinkRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationLinkRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "link":

			if m.GetLink() == nil {
				return SetApplicationLinkRequestValidationError{
					field:  "link",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetLink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationLinkRequestValidationError{
						field:  "link",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationLinkRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetApplicationLinkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetApplicationLinkRequestValidationError is the validation error returned by
// SetApplicationLinkRequest.ValidateFields if the designated constraints
// aren't met.
type SetApplicationLinkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetApplicationLinkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetApplicationLinkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetApplicationLinkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetApplicationLinkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetApplicationLinkRequestValidationError) ErrorName() string {
	return "SetApplicationLinkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetApplicationLinkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetApplicationLinkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetApplicationLinkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetApplicationLinkRequestValidationError{}

// ValidateFields checks the field values on ApplicationLinkStats with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationLinkStats) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationLinkStatsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "linked_at":

			if v, ok := interface{}(m.GetLinkedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationLinkStatsValidationError{
						field:  "linked_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "network_server_address":

			if !_ApplicationLinkStats_NetworkServerAddress_Pattern.MatchString(m.GetNetworkServerAddress()) {
				return ApplicationLinkStatsValidationError{
					field:  "network_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "last_up_received_at":

			if v, ok := interface{}(m.GetLastUpReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationLinkStatsValidationError{
						field:  "last_up_received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "up_count":
			// no validation rules for UpCount
		case "last_downlink_forwarded_at":

			if v, ok := interface{}(m.GetLastDownlinkForwardedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationLinkStatsValidationError{
						field:  "last_downlink_forwarded_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_count":
			// no validation rules for DownlinkCount
		default:
			return ApplicationLinkStatsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationLinkStatsValidationError is the validation error returned by
// ApplicationLinkStats.ValidateFields if the designated constraints aren't met.
type ApplicationLinkStatsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationLinkStatsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationLinkStatsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationLinkStatsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationLinkStatsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationLinkStatsValidationError) ErrorName() string {
	return "ApplicationLinkStatsValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationLinkStatsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationLinkStats.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationLinkStatsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationLinkStatsValidationError{}

var _ApplicationLinkStats_NetworkServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

// ValidateFields checks the field values on AsConfiguration with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *AsConfiguration) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = AsConfigurationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "pubsub":

			if v, ok := interface{}(m.GetPubsub()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return AsConfigurationValidationError{
						field:  "pubsub",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "webhooks":

			if v, ok := interface{}(m.GetWebhooks()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return AsConfigurationValidationError{
						field:  "webhooks",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return AsConfigurationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// AsConfigurationValidationError is the validation error returned by
// AsConfiguration.ValidateFields if the designated constraints aren't met.
type AsConfigurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AsConfigurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AsConfigurationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AsConfigurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AsConfigurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AsConfigurationValidationError) ErrorName() string { return "AsConfigurationValidationError" }

// Error satisfies the builtin error interface
func (e AsConfigurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAsConfiguration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AsConfigurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AsConfigurationValidationError{}

// ValidateFields checks the field values on GetAsConfigurationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetAsConfigurationRequest) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message GetAsConfigurationRequest has no fields, but paths %s were specified", paths)
	}
	return nil
}

// GetAsConfigurationRequestValidationError is the validation error returned by
// GetAsConfigurationRequest.ValidateFields if the designated constraints
// aren't met.
type GetAsConfigurationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetAsConfigurationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetAsConfigurationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetAsConfigurationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetAsConfigurationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetAsConfigurationRequestValidationError) ErrorName() string {
	return "GetAsConfigurationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetAsConfigurationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetAsConfigurationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetAsConfigurationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetAsConfigurationRequestValidationError{}

// ValidateFields checks the field values on GetAsConfigurationResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetAsConfigurationResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetAsConfigurationResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "configuration":

			if v, ok := interface{}(m.GetConfiguration()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetAsConfigurationResponseValidationError{
						field:  "configuration",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetAsConfigurationResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetAsConfigurationResponseValidationError is the validation error returned
// by GetAsConfigurationResponse.ValidateFields if the designated constraints
// aren't met.
type GetAsConfigurationResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetAsConfigurationResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetAsConfigurationResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetAsConfigurationResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetAsConfigurationResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetAsConfigurationResponseValidationError) ErrorName() string {
	return "GetAsConfigurationResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetAsConfigurationResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetAsConfigurationResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetAsConfigurationResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetAsConfigurationResponseValidationError{}

// ValidateFields checks the field values on NsAsHandleUplinkRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *NsAsHandleUplinkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = NsAsHandleUplinkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ups":

			if len(m.GetApplicationUps()) < 1 {
				return NsAsHandleUplinkRequestValidationError{
					field:  "application_ups",
					reason: "value must contain at least 1 item(s)",
				}
			}

			for idx, item := range m.GetApplicationUps() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return NsAsHandleUplinkRequestValidationError{
							field:  fmt.Sprintf("application_ups[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return NsAsHandleUplinkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// NsAsHandleUplinkRequestValidationError is the validation error returned by
// NsAsHandleUplinkRequest.ValidateFields if the designated constraints aren't met.
type NsAsHandleUplinkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NsAsHandleUplinkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NsAsHandleUplinkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NsAsHandleUplinkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NsAsHandleUplinkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NsAsHandleUplinkRequestValidationError) ErrorName() string {
	return "NsAsHandleUplinkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e NsAsHandleUplinkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNsAsHandleUplinkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NsAsHandleUplinkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NsAsHandleUplinkRequestValidationError{}

// ValidateFields checks the field values on EncodeDownlinkRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EncodeDownlinkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EncodeDownlinkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return EncodeDownlinkRequestValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EncodeDownlinkRequestValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EncodeDownlinkRequestValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink":

			if m.GetDownlink() == nil {
				return EncodeDownlinkRequestValidationError{
					field:  "downlink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EncodeDownlinkRequestValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "formatter":

			if _, ok := PayloadFormatter_name[int32(m.GetFormatter())]; !ok {
				return EncodeDownlinkRequestValidationError{
					field:  "formatter",
					reason: "value must be one of the defined enum values",
				}
			}

		case "parameter":
			// no validation rules for Parameter
		default:
			return EncodeDownlinkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EncodeDownlinkRequestValidationError is the validation error returned by
// EncodeDownlinkRequest.ValidateFields if the designated constraints aren't met.
type EncodeDownlinkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EncodeDownlinkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EncodeDownlinkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EncodeDownlinkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EncodeDownlinkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EncodeDownlinkRequestValidationError) ErrorName() string {
	return "EncodeDownlinkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e EncodeDownlinkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEncodeDownlinkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EncodeDownlinkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EncodeDownlinkRequestValidationError{}

// ValidateFields checks the field values on EncodeDownlinkResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EncodeDownlinkResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EncodeDownlinkResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "downlink":

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EncodeDownlinkResponseValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return EncodeDownlinkResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EncodeDownlinkResponseValidationError is the validation error returned by
// EncodeDownlinkResponse.ValidateFields if the designated constraints aren't met.
type EncodeDownlinkResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EncodeDownlinkResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EncodeDownlinkResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EncodeDownlinkResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EncodeDownlinkResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EncodeDownlinkResponseValidationError) ErrorName() string {
	return "EncodeDownlinkResponseValidationError"
}

// Error satisfies the builtin error interface
func (e EncodeDownlinkResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEncodeDownlinkResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EncodeDownlinkResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EncodeDownlinkResponseValidationError{}

// ValidateFields checks the field values on DecodeUplinkRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DecodeUplinkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DecodeUplinkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return DecodeUplinkRequestValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeUplinkRequestValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeUplinkRequestValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink":

			if m.GetUplink() == nil {
				return DecodeUplinkRequestValidationError{
					field:  "uplink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUplink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeUplinkRequestValidationError{
						field:  "uplink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "formatter":

			if _, ok := PayloadFormatter_name[int32(m.GetFormatter())]; !ok {
				return DecodeUplinkRequestValidationError{
					field:  "formatter",
					reason: "value must be one of the defined enum values",
				}
			}

		case "parameter":
			// no validation rules for Parameter
		default:
			return DecodeUplinkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DecodeUplinkRequestValidationError is the validation error returned by
// DecodeUplinkRequest.ValidateFields if the designated constraints aren't met.
type DecodeUplinkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DecodeUplinkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DecodeUplinkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DecodeUplinkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DecodeUplinkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DecodeUplinkRequestValidationError) ErrorName() string {
	return "DecodeUplinkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DecodeUplinkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecodeUplinkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DecodeUplinkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DecodeUplinkRequestValidationError{}

// ValidateFields checks the field values on DecodeUplinkResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DecodeUplinkResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DecodeUplinkResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "uplink":

			if v, ok := interface{}(m.GetUplink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeUplinkResponseValidationError{
						field:  "uplink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return DecodeUplinkResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DecodeUplinkResponseValidationError is the validation error returned by
// DecodeUplinkResponse.ValidateFields if the designated constraints aren't met.
type DecodeUplinkResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DecodeUplinkResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DecodeUplinkResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DecodeUplinkResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DecodeUplinkResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DecodeUplinkResponseValidationError) ErrorName() string {
	return "DecodeUplinkResponseValidationError"
}

// Error satisfies the builtin error interface
func (e DecodeUplinkResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecodeUplinkResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DecodeUplinkResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DecodeUplinkResponseValidationError{}

// ValidateFields checks the field values on DecodeDownlinkRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DecodeDownlinkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DecodeDownlinkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return DecodeDownlinkRequestValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeDownlinkRequestValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeDownlinkRequestValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink":

			if m.GetDownlink() == nil {
				return DecodeDownlinkRequestValidationError{
					field:  "downlink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeDownlinkRequestValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "formatter":

			if _, ok := PayloadFormatter_name[int32(m.GetFormatter())]; !ok {
				return DecodeDownlinkRequestValidationError{
					field:  "formatter",
					reason: "value must be one of the defined enum values",
				}
			}

		case "parameter":
			// no validation rules for Parameter
		default:
			return DecodeDownlinkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DecodeDownlinkRequestValidationError is the validation error returned by
// DecodeDownlinkRequest.ValidateFields if the designated constraints aren't met.
type DecodeDownlinkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DecodeDownlinkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DecodeDownlinkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DecodeDownlinkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DecodeDownlinkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DecodeDownlinkRequestValidationError) ErrorName() string {
	return "DecodeDownlinkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DecodeDownlinkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecodeDownlinkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DecodeDownlinkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DecodeDownlinkRequestValidationError{}

// ValidateFields checks the field values on DecodeDownlinkResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DecodeDownlinkResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DecodeDownlinkResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "downlink":

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodeDownlinkResponseValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return DecodeDownlinkResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DecodeDownlinkResponseValidationError is the validation error returned by
// DecodeDownlinkResponse.ValidateFields if the designated constraints aren't met.
type DecodeDownlinkResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DecodeDownlinkResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DecodeDownlinkResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DecodeDownlinkResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DecodeDownlinkResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DecodeDownlinkResponseValidationError) ErrorName() string {
	return "DecodeDownlinkResponseValidationError"
}

// Error satisfies the builtin error interface
func (e DecodeDownlinkResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecodeDownlinkResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DecodeDownlinkResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DecodeDownlinkResponseValidationError{}

// ValidateFields checks the field values on AsConfiguration_PubSub with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *AsConfiguration_PubSub) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = AsConfiguration_PubSubFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "providers":

			if v, ok := interface{}(m.GetProviders()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return AsConfiguration_PubSubValidationError{
						field:  "providers",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return AsConfiguration_PubSubValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// AsConfiguration_PubSubValidationError is the validation error returned by
// AsConfiguration_PubSub.ValidateFields if the designated constraints aren't met.
type AsConfiguration_PubSubValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AsConfiguration_PubSubValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AsConfiguration_PubSubValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AsConfiguration_PubSubValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AsConfiguration_PubSubValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AsConfiguration_PubSubValidationError) ErrorName() string {
	return "AsConfiguration_PubSubValidationError"
}

// Error satisfies the builtin error interface
func (e AsConfiguration_PubSubValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAsConfiguration_PubSub.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AsConfiguration_PubSubValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AsConfiguration_PubSubValidationError{}

// ValidateFields checks the field values on AsConfiguration_Webhooks with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *AsConfiguration_Webhooks) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = AsConfiguration_WebhooksFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "unhealthy_attempts_threshold":
			// no validation rules for UnhealthyAttemptsThreshold
		case "unhealthy_retry_interval":

			if v, ok := interface{}(m.GetUnhealthyRetryInterval()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return AsConfiguration_WebhooksValidationError{
						field:  "unhealthy_retry_interval",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return AsConfiguration_WebhooksValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// AsConfiguration_WebhooksValidationError is the validation error returned by
// AsConfiguration_Webhooks.ValidateFields if the designated constraints
// aren't met.
type AsConfiguration_WebhooksValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AsConfiguration_WebhooksValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AsConfiguration_WebhooksValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AsConfiguration_WebhooksValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AsConfiguration_WebhooksValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AsConfiguration_WebhooksValidationError) ErrorName() string {
	return "AsConfiguration_WebhooksValidationError"
}

// Error satisfies the builtin error interface
func (e AsConfiguration_WebhooksValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAsConfiguration_Webhooks.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AsConfiguration_WebhooksValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AsConfiguration_WebhooksValidationError{}

// ValidateFields checks the field values on AsConfiguration_PubSub_Providers
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *AsConfiguration_PubSub_Providers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = AsConfiguration_PubSub_ProvidersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "mqtt":
			// no validation rules for Mqtt
		case "nats":
			// no validation rules for Nats
		default:
			return AsConfiguration_PubSub_ProvidersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// AsConfiguration_PubSub_ProvidersValidationError is the validation error
// returned by AsConfiguration_PubSub_Providers.ValidateFields if the
// designated constraints aren't met.
type AsConfiguration_PubSub_ProvidersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AsConfiguration_PubSub_ProvidersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AsConfiguration_PubSub_ProvidersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AsConfiguration_PubSub_ProvidersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AsConfiguration_PubSub_ProvidersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AsConfiguration_PubSub_ProvidersValidationError) ErrorName() string {
	return "AsConfiguration_PubSub_ProvidersValidationError"
}

// Error satisfies the builtin error interface
func (e AsConfiguration_PubSub_ProvidersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAsConfiguration_PubSub_Providers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AsConfiguration_PubSub_ProvidersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AsConfiguration_PubSub_ProvidersValidationError{}
