// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/applicationserver.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AsConfiguration_PubSub_Providers_Status int32

const (
	// No restrictions are in place.
	AsConfiguration_PubSub_Providers_ENABLED AsConfiguration_PubSub_Providers_Status = 0
	// Warnings are being emitted that the provider will be deprecated in the future.
	AsConfiguration_PubSub_Providers_WARNING AsConfiguration_PubSub_Providers_Status = 1
	// New integrations cannot be set up, and old ones do not start.
	AsConfiguration_PubSub_Providers_DISABLED AsConfiguration_PubSub_Providers_Status = 2
)

// Enum value maps for AsConfiguration_PubSub_Providers_Status.
var (
	AsConfiguration_PubSub_Providers_Status_name = map[int32]string{
		0: "ENABLED",
		1: "WARNING",
		2: "DISABLED",
	}
	AsConfiguration_PubSub_Providers_Status_value = map[string]int32{
		"ENABLED":  0,
		"WARNING":  1,
		"DISABLED": 2,
	}
)

func (x AsConfiguration_PubSub_Providers_Status) Enum() *AsConfiguration_PubSub_Providers_Status {
	p := new(AsConfiguration_PubSub_Providers_Status)
	*p = x
	return p
}

func (x AsConfiguration_PubSub_Providers_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AsConfiguration_PubSub_Providers_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_applicationserver_proto_enumTypes[0].Descriptor()
}

func (AsConfiguration_PubSub_Providers_Status) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_applicationserver_proto_enumTypes[0]
}

func (x AsConfiguration_PubSub_Providers_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AsConfiguration_PubSub_Providers_Status.Descriptor instead.
func (AsConfiguration_PubSub_Providers_Status) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{4, 0, 0, 0}
}

type ApplicationLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Default message payload formatters to use when there are no formatters
	// defined on the end device level.
	DefaultFormatters *MessagePayloadFormatters `protobuf:"bytes,3,opt,name=default_formatters,json=defaultFormatters,proto3" json:"default_formatters,omitempty"`
	// Skip decryption of uplink payloads and encryption of downlink payloads.
	// Leave empty for the using the Application Server's default setting.
	SkipPayloadCrypto *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=skip_payload_crypto,json=skipPayloadCrypto,proto3" json:"skip_payload_crypto,omitempty"`
}

func (x *ApplicationLink) Reset() {
	*x = ApplicationLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationLink) ProtoMessage() {}

func (x *ApplicationLink) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationLink.ProtoReflect.Descriptor instead.
func (*ApplicationLink) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{0}
}

func (x *ApplicationLink) GetDefaultFormatters() *MessagePayloadFormatters {
	if x != nil {
		return x.DefaultFormatters
	}
	return nil
}

func (x *ApplicationLink) GetSkipPayloadCrypto() *wrapperspb.BoolValue {
	if x != nil {
		return x.SkipPayloadCrypto
	}
	return nil
}

type GetApplicationLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	FieldMask      *fieldmaskpb.FieldMask  `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetApplicationLinkRequest) Reset() {
	*x = GetApplicationLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApplicationLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApplicationLinkRequest) ProtoMessage() {}

func (x *GetApplicationLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApplicationLinkRequest.ProtoReflect.Descriptor instead.
func (*GetApplicationLinkRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{1}
}

func (x *GetApplicationLinkRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *GetApplicationLinkRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type SetApplicationLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	Link           *ApplicationLink        `protobuf:"bytes,2,opt,name=link,proto3" json:"link,omitempty"`
	FieldMask      *fieldmaskpb.FieldMask  `protobuf:"bytes,3,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *SetApplicationLinkRequest) Reset() {
	*x = SetApplicationLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetApplicationLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetApplicationLinkRequest) ProtoMessage() {}

func (x *SetApplicationLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetApplicationLinkRequest.ProtoReflect.Descriptor instead.
func (*SetApplicationLinkRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{2}
}

func (x *SetApplicationLinkRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *SetApplicationLinkRequest) GetLink() *ApplicationLink {
	if x != nil {
		return x.Link
	}
	return nil
}

func (x *SetApplicationLinkRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// Link stats as monitored by the Application Server.
type ApplicationLinkStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LinkedAt             *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=linked_at,json=linkedAt,proto3" json:"linked_at,omitempty"`
	NetworkServerAddress string                 `protobuf:"bytes,2,opt,name=network_server_address,json=networkServerAddress,proto3" json:"network_server_address,omitempty"`
	// Timestamp when the last upstream message has been received from a Network Server.
	// This can be a join-accept, uplink message or downlink message event.
	LastUpReceivedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_up_received_at,json=lastUpReceivedAt,proto3" json:"last_up_received_at,omitempty"`
	// Number of upstream messages received.
	UpCount uint64 `protobuf:"varint,4,opt,name=up_count,json=upCount,proto3" json:"up_count,omitempty"`
	// Timestamp when the last downlink message has been forwarded to a Network Server.
	LastDownlinkForwardedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_downlink_forwarded_at,json=lastDownlinkForwardedAt,proto3" json:"last_downlink_forwarded_at,omitempty"`
	// Number of downlink messages forwarded.
	DownlinkCount uint64 `protobuf:"varint,6,opt,name=downlink_count,json=downlinkCount,proto3" json:"downlink_count,omitempty"`
}

func (x *ApplicationLinkStats) Reset() {
	*x = ApplicationLinkStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationLinkStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationLinkStats) ProtoMessage() {}

func (x *ApplicationLinkStats) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationLinkStats.ProtoReflect.Descriptor instead.
func (*ApplicationLinkStats) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{3}
}

func (x *ApplicationLinkStats) GetLinkedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LinkedAt
	}
	return nil
}

func (x *ApplicationLinkStats) GetNetworkServerAddress() string {
	if x != nil {
		return x.NetworkServerAddress
	}
	return ""
}

func (x *ApplicationLinkStats) GetLastUpReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpReceivedAt
	}
	return nil
}

func (x *ApplicationLinkStats) GetUpCount() uint64 {
	if x != nil {
		return x.UpCount
	}
	return 0
}

func (x *ApplicationLinkStats) GetLastDownlinkForwardedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDownlinkForwardedAt
	}
	return nil
}

func (x *ApplicationLinkStats) GetDownlinkCount() uint64 {
	if x != nil {
		return x.DownlinkCount
	}
	return 0
}

// Application Server configuration.
type AsConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Pubsub   *AsConfiguration_PubSub   `protobuf:"bytes,1,opt,name=pubsub,proto3" json:"pubsub,omitempty"`
	Webhooks *AsConfiguration_Webhooks `protobuf:"bytes,2,opt,name=webhooks,proto3" json:"webhooks,omitempty"`
}

func (x *AsConfiguration) Reset() {
	*x = AsConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AsConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsConfiguration) ProtoMessage() {}

func (x *AsConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsConfiguration.ProtoReflect.Descriptor instead.
func (*AsConfiguration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{4}
}

func (x *AsConfiguration) GetPubsub() *AsConfiguration_PubSub {
	if x != nil {
		return x.Pubsub
	}
	return nil
}

func (x *AsConfiguration) GetWebhooks() *AsConfiguration_Webhooks {
	if x != nil {
		return x.Webhooks
	}
	return nil
}

type GetAsConfigurationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetAsConfigurationRequest) Reset() {
	*x = GetAsConfigurationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAsConfigurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAsConfigurationRequest) ProtoMessage() {}

func (x *GetAsConfigurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAsConfigurationRequest.ProtoReflect.Descriptor instead.
func (*GetAsConfigurationRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{5}
}

type GetAsConfigurationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Configuration *AsConfiguration `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
}

func (x *GetAsConfigurationResponse) Reset() {
	*x = GetAsConfigurationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAsConfigurationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAsConfigurationResponse) ProtoMessage() {}

func (x *GetAsConfigurationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAsConfigurationResponse.ProtoReflect.Descriptor instead.
func (*GetAsConfigurationResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{6}
}

func (x *GetAsConfigurationResponse) GetConfiguration() *AsConfiguration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

// Container for multiple Application uplink messages.
type NsAsHandleUplinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationUps []*ApplicationUp `protobuf:"bytes,1,rep,name=application_ups,json=applicationUps,proto3" json:"application_ups,omitempty"`
}

func (x *NsAsHandleUplinkRequest) Reset() {
	*x = NsAsHandleUplinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NsAsHandleUplinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NsAsHandleUplinkRequest) ProtoMessage() {}

func (x *NsAsHandleUplinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NsAsHandleUplinkRequest.ProtoReflect.Descriptor instead.
func (*NsAsHandleUplinkRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{7}
}

func (x *NsAsHandleUplinkRequest) GetApplicationUps() []*ApplicationUp {
	if x != nil {
		return x.ApplicationUps
	}
	return nil
}

type EncodeDownlinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds *EndDeviceIdentifiers        `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	VersionIds   *EndDeviceVersionIdentifiers `protobuf:"bytes,2,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	Downlink     *ApplicationDownlink         `protobuf:"bytes,3,opt,name=downlink,proto3" json:"downlink,omitempty"`
	Formatter    PayloadFormatter             `protobuf:"varint,4,opt,name=formatter,proto3,enum=ttn.lorawan.v3.PayloadFormatter" json:"formatter,omitempty"`
	Parameter    string                       `protobuf:"bytes,5,opt,name=parameter,proto3" json:"parameter,omitempty"`
}

func (x *EncodeDownlinkRequest) Reset() {
	*x = EncodeDownlinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncodeDownlinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncodeDownlinkRequest) ProtoMessage() {}

func (x *EncodeDownlinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncodeDownlinkRequest.ProtoReflect.Descriptor instead.
func (*EncodeDownlinkRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{8}
}

func (x *EncodeDownlinkRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *EncodeDownlinkRequest) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *EncodeDownlinkRequest) GetDownlink() *ApplicationDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

func (x *EncodeDownlinkRequest) GetFormatter() PayloadFormatter {
	if x != nil {
		return x.Formatter
	}
	return PayloadFormatter_FORMATTER_NONE
}

func (x *EncodeDownlinkRequest) GetParameter() string {
	if x != nil {
		return x.Parameter
	}
	return ""
}

type EncodeDownlinkResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Downlink *ApplicationDownlink `protobuf:"bytes,1,opt,name=downlink,proto3" json:"downlink,omitempty"`
}

func (x *EncodeDownlinkResponse) Reset() {
	*x = EncodeDownlinkResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncodeDownlinkResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncodeDownlinkResponse) ProtoMessage() {}

func (x *EncodeDownlinkResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncodeDownlinkResponse.ProtoReflect.Descriptor instead.
func (*EncodeDownlinkResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{9}
}

func (x *EncodeDownlinkResponse) GetDownlink() *ApplicationDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

type DecodeUplinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds *EndDeviceIdentifiers        `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	VersionIds   *EndDeviceVersionIdentifiers `protobuf:"bytes,2,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	Uplink       *ApplicationUplink           `protobuf:"bytes,3,opt,name=uplink,proto3" json:"uplink,omitempty"`
	Formatter    PayloadFormatter             `protobuf:"varint,4,opt,name=formatter,proto3,enum=ttn.lorawan.v3.PayloadFormatter" json:"formatter,omitempty"`
	Parameter    string                       `protobuf:"bytes,5,opt,name=parameter,proto3" json:"parameter,omitempty"`
}

func (x *DecodeUplinkRequest) Reset() {
	*x = DecodeUplinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecodeUplinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecodeUplinkRequest) ProtoMessage() {}

func (x *DecodeUplinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecodeUplinkRequest.ProtoReflect.Descriptor instead.
func (*DecodeUplinkRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{10}
}

func (x *DecodeUplinkRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *DecodeUplinkRequest) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *DecodeUplinkRequest) GetUplink() *ApplicationUplink {
	if x != nil {
		return x.Uplink
	}
	return nil
}

func (x *DecodeUplinkRequest) GetFormatter() PayloadFormatter {
	if x != nil {
		return x.Formatter
	}
	return PayloadFormatter_FORMATTER_NONE
}

func (x *DecodeUplinkRequest) GetParameter() string {
	if x != nil {
		return x.Parameter
	}
	return ""
}

type DecodeUplinkResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Uplink *ApplicationUplink `protobuf:"bytes,1,opt,name=uplink,proto3" json:"uplink,omitempty"`
}

func (x *DecodeUplinkResponse) Reset() {
	*x = DecodeUplinkResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecodeUplinkResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecodeUplinkResponse) ProtoMessage() {}

func (x *DecodeUplinkResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecodeUplinkResponse.ProtoReflect.Descriptor instead.
func (*DecodeUplinkResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{11}
}

func (x *DecodeUplinkResponse) GetUplink() *ApplicationUplink {
	if x != nil {
		return x.Uplink
	}
	return nil
}

type DecodeDownlinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds *EndDeviceIdentifiers        `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	VersionIds   *EndDeviceVersionIdentifiers `protobuf:"bytes,2,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	Downlink     *ApplicationDownlink         `protobuf:"bytes,3,opt,name=downlink,proto3" json:"downlink,omitempty"`
	Formatter    PayloadFormatter             `protobuf:"varint,4,opt,name=formatter,proto3,enum=ttn.lorawan.v3.PayloadFormatter" json:"formatter,omitempty"`
	Parameter    string                       `protobuf:"bytes,5,opt,name=parameter,proto3" json:"parameter,omitempty"`
}

func (x *DecodeDownlinkRequest) Reset() {
	*x = DecodeDownlinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecodeDownlinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecodeDownlinkRequest) ProtoMessage() {}

func (x *DecodeDownlinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecodeDownlinkRequest.ProtoReflect.Descriptor instead.
func (*DecodeDownlinkRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{12}
}

func (x *DecodeDownlinkRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *DecodeDownlinkRequest) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *DecodeDownlinkRequest) GetDownlink() *ApplicationDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

func (x *DecodeDownlinkRequest) GetFormatter() PayloadFormatter {
	if x != nil {
		return x.Formatter
	}
	return PayloadFormatter_FORMATTER_NONE
}

func (x *DecodeDownlinkRequest) GetParameter() string {
	if x != nil {
		return x.Parameter
	}
	return ""
}

type DecodeDownlinkResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Downlink *ApplicationDownlink `protobuf:"bytes,1,opt,name=downlink,proto3" json:"downlink,omitempty"`
}

func (x *DecodeDownlinkResponse) Reset() {
	*x = DecodeDownlinkResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecodeDownlinkResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecodeDownlinkResponse) ProtoMessage() {}

func (x *DecodeDownlinkResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecodeDownlinkResponse.ProtoReflect.Descriptor instead.
func (*DecodeDownlinkResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{13}
}

func (x *DecodeDownlinkResponse) GetDownlink() *ApplicationDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

type AsConfiguration_PubSub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Providers *AsConfiguration_PubSub_Providers `protobuf:"bytes,1,opt,name=providers,proto3" json:"providers,omitempty"`
}

func (x *AsConfiguration_PubSub) Reset() {
	*x = AsConfiguration_PubSub{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AsConfiguration_PubSub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsConfiguration_PubSub) ProtoMessage() {}

func (x *AsConfiguration_PubSub) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsConfiguration_PubSub.ProtoReflect.Descriptor instead.
func (*AsConfiguration_PubSub) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{4, 0}
}

func (x *AsConfiguration_PubSub) GetProviders() *AsConfiguration_PubSub_Providers {
	if x != nil {
		return x.Providers
	}
	return nil
}

type AsConfiguration_Webhooks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UnhealthyAttemptsThreshold int64                `protobuf:"varint,1,opt,name=unhealthy_attempts_threshold,json=unhealthyAttemptsThreshold,proto3" json:"unhealthy_attempts_threshold,omitempty"`
	UnhealthyRetryInterval     *durationpb.Duration `protobuf:"bytes,2,opt,name=unhealthy_retry_interval,json=unhealthyRetryInterval,proto3" json:"unhealthy_retry_interval,omitempty"`
}

func (x *AsConfiguration_Webhooks) Reset() {
	*x = AsConfiguration_Webhooks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AsConfiguration_Webhooks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsConfiguration_Webhooks) ProtoMessage() {}

func (x *AsConfiguration_Webhooks) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsConfiguration_Webhooks.ProtoReflect.Descriptor instead.
func (*AsConfiguration_Webhooks) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{4, 1}
}

func (x *AsConfiguration_Webhooks) GetUnhealthyAttemptsThreshold() int64 {
	if x != nil {
		return x.UnhealthyAttemptsThreshold
	}
	return 0
}

func (x *AsConfiguration_Webhooks) GetUnhealthyRetryInterval() *durationpb.Duration {
	if x != nil {
		return x.UnhealthyRetryInterval
	}
	return nil
}

type AsConfiguration_PubSub_Providers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mqtt AsConfiguration_PubSub_Providers_Status `protobuf:"varint,1,opt,name=mqtt,proto3,enum=ttn.lorawan.v3.AsConfiguration_PubSub_Providers_Status" json:"mqtt,omitempty"`
	Nats AsConfiguration_PubSub_Providers_Status `protobuf:"varint,2,opt,name=nats,proto3,enum=ttn.lorawan.v3.AsConfiguration_PubSub_Providers_Status" json:"nats,omitempty"`
}

func (x *AsConfiguration_PubSub_Providers) Reset() {
	*x = AsConfiguration_PubSub_Providers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AsConfiguration_PubSub_Providers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsConfiguration_PubSub_Providers) ProtoMessage() {}

func (x *AsConfiguration_PubSub_Providers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsConfiguration_PubSub_Providers.ProtoReflect.Descriptor instead.
func (*AsConfiguration_PubSub_Providers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *AsConfiguration_PubSub_Providers) GetMqtt() AsConfiguration_PubSub_Providers_Status {
	if x != nil {
		return x.Mqtt
	}
	return AsConfiguration_PubSub_Providers_ENABLED
}

func (x *AsConfiguration_PubSub_Providers) GetNats() AsConfiguration_PubSub_Providers_Status {
	if x != nil {
		return x.Nats
	}
	return AsConfiguration_PubSub_Providers_ENABLED
}

var File_ttn_lorawan_v3_applicationserver_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_applicationserver_proto_rawDesc = []byte{
	0x0a, 0x26, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67,
	0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x74, 0x74, 0x6e,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74,
	0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d,
	0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x74,
	0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x71,
	0x74, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xd2, 0x01, 0x0a, 0x0f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x57, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x52, 0x11, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4a,
	0x0a, 0x13, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04,
	0x08, 0x01, 0x10, 0x01, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03,
	0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x22, 0xb1, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12,
	0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xf0, 0x01, 0x0a, 0x19, 0x53,
	0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x73, 0x12, 0x3d, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x6e, 0x6b, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x04, 0x6c, 0x69,
	0x6e, 0x6b, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xfd, 0x03,
	0x0a, 0x14, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6e,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x41, 0x74, 0x12,
	0xc5, 0x01, 0x0a, 0x16, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x8e, 0x01, 0xfa, 0x42, 0x8a, 0x01, 0x72, 0x87, 0x01, 0x32, 0x84, 0x01, 0x5e, 0x28, 0x3f,
	0x3a, 0x28, 0x3f, 0x3a, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7c,
	0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x41,
	0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a,
	0x30, 0x2d, 0x39, 0x5d, 0x29, 0x5c, 0x2e, 0x29, 0x2a, 0x28, 0x3f, 0x3a, 0x5b, 0x41, 0x2d, 0x5a,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d,
	0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x28, 0x3f, 0x3a,
	0x3a, 0x5b, 0x30, 0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x2c, 0x35, 0x7d, 0x29, 0x3f, 0x24, 0x7c, 0x5e,
	0x24, 0x52, 0x14, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x49, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x75, 0x70, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x41, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x75, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x57, 0x0a,
	0x1a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x17, 0x6c,
	0x61, 0x73, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x65, 0x64, 0x41, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x8b, 0x05,
	0x0a, 0x0f, 0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x52, 0x06, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x12, 0x44, 0x0a, 0x08, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x08, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x1a, 0xc0, 0x02, 0x0a, 0x06, 0x50, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x12, 0x4e, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x73, 0x1a, 0xe5, 0x01, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73,
	0x12, 0x4b, 0x0a, 0x04, 0x6d, 0x71, 0x74, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x04, 0x6d, 0x71, 0x74, 0x74, 0x12, 0x4b, 0x0a,
	0x04, 0x6e, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62,
	0x53, 0x75, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x74, 0x73, 0x22, 0x38, 0x0a, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x1a, 0x06, 0xea, 0xaa,
	0x19, 0x02, 0x18, 0x01, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x1a, 0xae, 0x01, 0x0a, 0x08, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x40, 0x0a, 0x1c, 0x75, 0x6e, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x75,
	0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73,
	0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x53, 0x0a, 0x18, 0x75, 0x6e, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x75, 0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x79, 0x52, 0x65, 0x74, 0x72, 0x79, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x4a, 0x04,
	0x08, 0x03, 0x10, 0x04, 0x52, 0x05, 0x71, 0x75, 0x65, 0x75, 0x65, 0x22, 0x1b, 0x0a, 0x19, 0x47,
	0x65, 0x74, 0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x63, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x41,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a,
	0x17, 0x4e, 0x73, 0x41, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x73, 0x22, 0xee, 0x02, 0x0a, 0x15, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x49, 0x0a, 0x08, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x12, 0x48, 0x0a, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a,
	0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x22, 0x59, 0x0a, 0x16, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x08, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0xe6, 0x02, 0x0a, 0x13, 0x44, 0x65, 0x63, 0x6f, 0x64,
	0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54,
	0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x64, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x48, 0x0a, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x22,
	0x51, 0x0a, 0x14, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x75, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x22, 0xee, 0x02, 0x0a, 0x15, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e,
	0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73,
	0x12, 0x49, 0x0a, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x48, 0x0a, 0x09, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x22, 0x59, 0x0a, 0x16, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a,
	0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x32, 0xf5,
	0x05, 0x0a, 0x02, 0x41, 0x73, 0x12, 0x95, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x3e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x98, 0x01,
	0x0a, 0x07, 0x53, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x74, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a,
	0x1a, 0x36, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x7c, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x2a, 0x26,
	0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x92, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x4c, 0x69,
	0x6e, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a,
	0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6e, 0x6b,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f,
	0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74,
	0x41, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x13, 0x12,
	0x11, 0x2f, 0x61, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x22, 0x92, 0x41, 0x1f, 0x12, 0x1d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20,
	0x61, 0x6e, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x32, 0x97, 0x02, 0x0a, 0x04, 0x4e, 0x73, 0x41, 0x73, 0x12,
	0x4f, 0x0a, 0x0c, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4e, 0x73, 0x41, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x1a, 0xbd, 0x01, 0x92, 0x41, 0xb9, 0x01, 0x12, 0xb6, 0x01, 0x54, 0x68, 0x65, 0x20, 0x4e, 0x73,
	0x41, 0x73, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x69, 0x73, 0x20, 0x75, 0x73,
	0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x54, 0x68, 0x65, 0x20, 0x54, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x20, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x54, 0x68, 0x65, 0x20, 0x54, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x20, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x20, 0x54, 0x68,
	0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x2d, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x6d, 0x65, 0x61, 0x6e,
	0x74, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e,
	0x32, 0x83, 0x0e, 0x0a, 0x05, 0x41, 0x70, 0x70, 0x41, 0x73, 0x12, 0x54, 0x0a, 0x09, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a,
	0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x30, 0x01,
	0x12, 0xcb, 0x01, 0x0a, 0x11, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x50, 0x75, 0x73, 0x68, 0x12, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x72, 0x3a, 0x01, 0x2a, 0x22,
	0x6d, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x2f, 0x70, 0x75, 0x73, 0x68, 0x12, 0xd1,
	0x01, 0x0a, 0x14, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x7b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x75, 0x3a, 0x01, 0x2a,
	0x22, 0x70, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x12, 0xb3, 0x01, 0x0a, 0x11, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x24,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x73, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x61,
	0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x12, 0xa3, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74,
	0x4d, 0x51, 0x54, 0x54, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x22, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x51, 0x54, 0x54,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x3e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x71, 0x74, 0x74, 0x2d, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2d, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0xc3,
	0x01, 0x0a, 0x0e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x12, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x7a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x74,
	0x3a, 0x01, 0x2a, 0x22, 0x6f, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x75, 0x70, 0x2f, 0x73, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x74, 0x3a, 0x01,
	0x2a, 0x22, 0x6f, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x2f, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0xd3, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x12, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x78,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x72, 0x3a, 0x01, 0x2a, 0x22, 0x6d, 0x2f, 0x61, 0x73, 0x2f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x75,
	0x70, 0x2f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x63,
	0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x25, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x63,
	0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x74, 0x3a, 0x01, 0x2a, 0x22, 0x6f, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x2f,
	0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x1a, 0x4e, 0x92, 0x41, 0x4b, 0x12, 0x49, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x72, 0x20,
	0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x6f, 0x20,
	0x61, 0x6e, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x32, 0x9f, 0x05, 0x0a, 0x13, 0x41, 0x73, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x12, 0xb2,
	0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x22, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x12, 0x63,
	0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12, 0x23, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x74,
	0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x22, 0xbe, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xb7, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x4d, 0x3a, 0x01, 0x2a, 0x22, 0x48, 0x2f,
	0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x63, 0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x69, 0x64,
	0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x95, 0x01, 0x0a,
	0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x2a, 0x45, 0x2f,
	0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x7d, 0x1a, 0x32, 0x92, 0x41, 0x2f, 0x12, 0x2d, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x6e,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x32, 0xf3, 0x01, 0x0a, 0x18, 0x41, 0x73, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x12, 0x97, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x12, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a, 0x3f,
	0x2f, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x1a,
	0x3d, 0x92, 0x41, 0x3a, 0x12, 0x38, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x42, 0x31,
	0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_applicationserver_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_applicationserver_proto_rawDescData = file_ttn_lorawan_v3_applicationserver_proto_rawDesc
)

func file_ttn_lorawan_v3_applicationserver_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_applicationserver_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_applicationserver_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_applicationserver_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_applicationserver_proto_rawDescData
}

var file_ttn_lorawan_v3_applicationserver_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ttn_lorawan_v3_applicationserver_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_ttn_lorawan_v3_applicationserver_proto_goTypes = []interface{}{
	(AsConfiguration_PubSub_Providers_Status)(0), // 0: ttn.lorawan.v3.AsConfiguration.PubSub.Providers.Status
	(*ApplicationLink)(nil),                      // 1: ttn.lorawan.v3.ApplicationLink
	(*GetApplicationLinkRequest)(nil),            // 2: ttn.lorawan.v3.GetApplicationLinkRequest
	(*SetApplicationLinkRequest)(nil),            // 3: ttn.lorawan.v3.SetApplicationLinkRequest
	(*ApplicationLinkStats)(nil),                 // 4: ttn.lorawan.v3.ApplicationLinkStats
	(*AsConfiguration)(nil),                      // 5: ttn.lorawan.v3.AsConfiguration
	(*GetAsConfigurationRequest)(nil),            // 6: ttn.lorawan.v3.GetAsConfigurationRequest
	(*GetAsConfigurationResponse)(nil),           // 7: ttn.lorawan.v3.GetAsConfigurationResponse
	(*NsAsHandleUplinkRequest)(nil),              // 8: ttn.lorawan.v3.NsAsHandleUplinkRequest
	(*EncodeDownlinkRequest)(nil),                // 9: ttn.lorawan.v3.EncodeDownlinkRequest
	(*EncodeDownlinkResponse)(nil),               // 10: ttn.lorawan.v3.EncodeDownlinkResponse
	(*DecodeUplinkRequest)(nil),                  // 11: ttn.lorawan.v3.DecodeUplinkRequest
	(*DecodeUplinkResponse)(nil),                 // 12: ttn.lorawan.v3.DecodeUplinkResponse
	(*DecodeDownlinkRequest)(nil),                // 13: ttn.lorawan.v3.DecodeDownlinkRequest
	(*DecodeDownlinkResponse)(nil),               // 14: ttn.lorawan.v3.DecodeDownlinkResponse
	(*AsConfiguration_PubSub)(nil),               // 15: ttn.lorawan.v3.AsConfiguration.PubSub
	(*AsConfiguration_Webhooks)(nil),             // 16: ttn.lorawan.v3.AsConfiguration.Webhooks
	(*AsConfiguration_PubSub_Providers)(nil),     // 17: ttn.lorawan.v3.AsConfiguration.PubSub.Providers
	(*MessagePayloadFormatters)(nil),             // 18: ttn.lorawan.v3.MessagePayloadFormatters
	(*wrapperspb.BoolValue)(nil),                 // 19: google.protobuf.BoolValue
	(*ApplicationIdentifiers)(nil),               // 20: ttn.lorawan.v3.ApplicationIdentifiers
	(*fieldmaskpb.FieldMask)(nil),                // 21: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                // 22: google.protobuf.Timestamp
	(*ApplicationUp)(nil),                        // 23: ttn.lorawan.v3.ApplicationUp
	(*EndDeviceIdentifiers)(nil),                 // 24: ttn.lorawan.v3.EndDeviceIdentifiers
	(*EndDeviceVersionIdentifiers)(nil),          // 25: ttn.lorawan.v3.EndDeviceVersionIdentifiers
	(*ApplicationDownlink)(nil),                  // 26: ttn.lorawan.v3.ApplicationDownlink
	(PayloadFormatter)(0),                        // 27: ttn.lorawan.v3.PayloadFormatter
	(*ApplicationUplink)(nil),                    // 28: ttn.lorawan.v3.ApplicationUplink
	(*durationpb.Duration)(nil),                  // 29: google.protobuf.Duration
	(*DownlinkQueueRequest)(nil),                 // 30: ttn.lorawan.v3.DownlinkQueueRequest
	(*GetEndDeviceRequest)(nil),                  // 31: ttn.lorawan.v3.GetEndDeviceRequest
	(*SetEndDeviceRequest)(nil),                  // 32: ttn.lorawan.v3.SetEndDeviceRequest
	(*BatchDeleteEndDevicesRequest)(nil),         // 33: ttn.lorawan.v3.BatchDeleteEndDevicesRequest
	(*emptypb.Empty)(nil),                        // 34: google.protobuf.Empty
	(*ApplicationDownlinks)(nil),                 // 35: ttn.lorawan.v3.ApplicationDownlinks
	(*MQTTConnectionInfo)(nil),                   // 36: ttn.lorawan.v3.MQTTConnectionInfo
	(*EndDevice)(nil),                            // 37: ttn.lorawan.v3.EndDevice
}
var file_ttn_lorawan_v3_applicationserver_proto_depIdxs = []int32{
	18, // 0: ttn.lorawan.v3.ApplicationLink.default_formatters:type_name -> ttn.lorawan.v3.MessagePayloadFormatters
	19, // 1: ttn.lorawan.v3.ApplicationLink.skip_payload_crypto:type_name -> google.protobuf.BoolValue
	20, // 2: ttn.lorawan.v3.GetApplicationLinkRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	21, // 3: ttn.lorawan.v3.GetApplicationLinkRequest.field_mask:type_name -> google.protobuf.FieldMask
	20, // 4: ttn.lorawan.v3.SetApplicationLinkRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	1,  // 5: ttn.lorawan.v3.SetApplicationLinkRequest.link:type_name -> ttn.lorawan.v3.ApplicationLink
	21, // 6: ttn.lorawan.v3.SetApplicationLinkRequest.field_mask:type_name -> google.protobuf.FieldMask
	22, // 7: ttn.lorawan.v3.ApplicationLinkStats.linked_at:type_name -> google.protobuf.Timestamp
	22, // 8: ttn.lorawan.v3.ApplicationLinkStats.last_up_received_at:type_name -> google.protobuf.Timestamp
	22, // 9: ttn.lorawan.v3.ApplicationLinkStats.last_downlink_forwarded_at:type_name -> google.protobuf.Timestamp
	15, // 10: ttn.lorawan.v3.AsConfiguration.pubsub:type_name -> ttn.lorawan.v3.AsConfiguration.PubSub
	16, // 11: ttn.lorawan.v3.AsConfiguration.webhooks:type_name -> ttn.lorawan.v3.AsConfiguration.Webhooks
	5,  // 12: ttn.lorawan.v3.GetAsConfigurationResponse.configuration:type_name -> ttn.lorawan.v3.AsConfiguration
	23, // 13: ttn.lorawan.v3.NsAsHandleUplinkRequest.application_ups:type_name -> ttn.lorawan.v3.ApplicationUp
	24, // 14: ttn.lorawan.v3.EncodeDownlinkRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	25, // 15: ttn.lorawan.v3.EncodeDownlinkRequest.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	26, // 16: ttn.lorawan.v3.EncodeDownlinkRequest.downlink:type_name -> ttn.lorawan.v3.ApplicationDownlink
	27, // 17: ttn.lorawan.v3.EncodeDownlinkRequest.formatter:type_name -> ttn.lorawan.v3.PayloadFormatter
	26, // 18: ttn.lorawan.v3.EncodeDownlinkResponse.downlink:type_name -> ttn.lorawan.v3.ApplicationDownlink
	24, // 19: ttn.lorawan.v3.DecodeUplinkRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	25, // 20: ttn.lorawan.v3.DecodeUplinkRequest.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	28, // 21: ttn.lorawan.v3.DecodeUplinkRequest.uplink:type_name -> ttn.lorawan.v3.ApplicationUplink
	27, // 22: ttn.lorawan.v3.DecodeUplinkRequest.formatter:type_name -> ttn.lorawan.v3.PayloadFormatter
	28, // 23: ttn.lorawan.v3.DecodeUplinkResponse.uplink:type_name -> ttn.lorawan.v3.ApplicationUplink
	24, // 24: ttn.lorawan.v3.DecodeDownlinkRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	25, // 25: ttn.lorawan.v3.DecodeDownlinkRequest.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	26, // 26: ttn.lorawan.v3.DecodeDownlinkRequest.downlink:type_name -> ttn.lorawan.v3.ApplicationDownlink
	27, // 27: ttn.lorawan.v3.DecodeDownlinkRequest.formatter:type_name -> ttn.lorawan.v3.PayloadFormatter
	26, // 28: ttn.lorawan.v3.DecodeDownlinkResponse.downlink:type_name -> ttn.lorawan.v3.ApplicationDownlink
	17, // 29: ttn.lorawan.v3.AsConfiguration.PubSub.providers:type_name -> ttn.lorawan.v3.AsConfiguration.PubSub.Providers
	29, // 30: ttn.lorawan.v3.AsConfiguration.Webhooks.unhealthy_retry_interval:type_name -> google.protobuf.Duration
	0,  // 31: ttn.lorawan.v3.AsConfiguration.PubSub.Providers.mqtt:type_name -> ttn.lorawan.v3.AsConfiguration.PubSub.Providers.Status
	0,  // 32: ttn.lorawan.v3.AsConfiguration.PubSub.Providers.nats:type_name -> ttn.lorawan.v3.AsConfiguration.PubSub.Providers.Status
	2,  // 33: ttn.lorawan.v3.As.GetLink:input_type -> ttn.lorawan.v3.GetApplicationLinkRequest
	3,  // 34: ttn.lorawan.v3.As.SetLink:input_type -> ttn.lorawan.v3.SetApplicationLinkRequest
	20, // 35: ttn.lorawan.v3.As.DeleteLink:input_type -> ttn.lorawan.v3.ApplicationIdentifiers
	20, // 36: ttn.lorawan.v3.As.GetLinkStats:input_type -> ttn.lorawan.v3.ApplicationIdentifiers
	6,  // 37: ttn.lorawan.v3.As.GetConfiguration:input_type -> ttn.lorawan.v3.GetAsConfigurationRequest
	8,  // 38: ttn.lorawan.v3.NsAs.HandleUplink:input_type -> ttn.lorawan.v3.NsAsHandleUplinkRequest
	20, // 39: ttn.lorawan.v3.AppAs.Subscribe:input_type -> ttn.lorawan.v3.ApplicationIdentifiers
	30, // 40: ttn.lorawan.v3.AppAs.DownlinkQueuePush:input_type -> ttn.lorawan.v3.DownlinkQueueRequest
	30, // 41: ttn.lorawan.v3.AppAs.DownlinkQueueReplace:input_type -> ttn.lorawan.v3.DownlinkQueueRequest
	24, // 42: ttn.lorawan.v3.AppAs.DownlinkQueueList:input_type -> ttn.lorawan.v3.EndDeviceIdentifiers
	20, // 43: ttn.lorawan.v3.AppAs.GetMQTTConnectionInfo:input_type -> ttn.lorawan.v3.ApplicationIdentifiers
	23, // 44: ttn.lorawan.v3.AppAs.SimulateUplink:input_type -> ttn.lorawan.v3.ApplicationUp
	9,  // 45: ttn.lorawan.v3.AppAs.EncodeDownlink:input_type -> ttn.lorawan.v3.EncodeDownlinkRequest
	11, // 46: ttn.lorawan.v3.AppAs.DecodeUplink:input_type -> ttn.lorawan.v3.DecodeUplinkRequest
	13, // 47: ttn.lorawan.v3.AppAs.DecodeDownlink:input_type -> ttn.lorawan.v3.DecodeDownlinkRequest
	31, // 48: ttn.lorawan.v3.AsEndDeviceRegistry.Get:input_type -> ttn.lorawan.v3.GetEndDeviceRequest
	32, // 49: ttn.lorawan.v3.AsEndDeviceRegistry.Set:input_type -> ttn.lorawan.v3.SetEndDeviceRequest
	24, // 50: ttn.lorawan.v3.AsEndDeviceRegistry.Delete:input_type -> ttn.lorawan.v3.EndDeviceIdentifiers
	33, // 51: ttn.lorawan.v3.AsEndDeviceBatchRegistry.Delete:input_type -> ttn.lorawan.v3.BatchDeleteEndDevicesRequest
	1,  // 52: ttn.lorawan.v3.As.GetLink:output_type -> ttn.lorawan.v3.ApplicationLink
	1,  // 53: ttn.lorawan.v3.As.SetLink:output_type -> ttn.lorawan.v3.ApplicationLink
	34, // 54: ttn.lorawan.v3.As.DeleteLink:output_type -> google.protobuf.Empty
	4,  // 55: ttn.lorawan.v3.As.GetLinkStats:output_type -> ttn.lorawan.v3.ApplicationLinkStats
	7,  // 56: ttn.lorawan.v3.As.GetConfiguration:output_type -> ttn.lorawan.v3.GetAsConfigurationResponse
	34, // 57: ttn.lorawan.v3.NsAs.HandleUplink:output_type -> google.protobuf.Empty
	23, // 58: ttn.lorawan.v3.AppAs.Subscribe:output_type -> ttn.lorawan.v3.ApplicationUp
	34, // 59: ttn.lorawan.v3.AppAs.DownlinkQueuePush:output_type -> google.protobuf.Empty
	34, // 60: ttn.lorawan.v3.AppAs.DownlinkQueueReplace:output_type -> google.protobuf.Empty
	35, // 61: ttn.lorawan.v3.AppAs.DownlinkQueueList:output_type -> ttn.lorawan.v3.ApplicationDownlinks
	36, // 62: ttn.lorawan.v3.AppAs.GetMQTTConnectionInfo:output_type -> ttn.lorawan.v3.MQTTConnectionInfo
	34, // 63: ttn.lorawan.v3.AppAs.SimulateUplink:output_type -> google.protobuf.Empty
	10, // 64: ttn.lorawan.v3.AppAs.EncodeDownlink:output_type -> ttn.lorawan.v3.EncodeDownlinkResponse
	12, // 65: ttn.lorawan.v3.AppAs.DecodeUplink:output_type -> ttn.lorawan.v3.DecodeUplinkResponse
	14, // 66: ttn.lorawan.v3.AppAs.DecodeDownlink:output_type -> ttn.lorawan.v3.DecodeDownlinkResponse
	37, // 67: ttn.lorawan.v3.AsEndDeviceRegistry.Get:output_type -> ttn.lorawan.v3.EndDevice
	37, // 68: ttn.lorawan.v3.AsEndDeviceRegistry.Set:output_type -> ttn.lorawan.v3.EndDevice
	34, // 69: ttn.lorawan.v3.AsEndDeviceRegistry.Delete:output_type -> google.protobuf.Empty
	34, // 70: ttn.lorawan.v3.AsEndDeviceBatchRegistry.Delete:output_type -> google.protobuf.Empty
	52, // [52:71] is the sub-list for method output_type
	33, // [33:52] is the sub-list for method input_type
	33, // [33:33] is the sub-list for extension type_name
	33, // [33:33] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_applicationserver_proto_init() }
func file_ttn_lorawan_v3_applicationserver_proto_init() {
	if File_ttn_lorawan_v3_applicationserver_proto != nil {
		return
	}
	file_ttn_lorawan_v3_end_device_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_messages_proto_init()
	file_ttn_lorawan_v3_mqtt_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApplicationLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetApplicationLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationLinkStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AsConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAsConfigurationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAsConfigurationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NsAsHandleUplinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncodeDownlinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncodeDownlinkResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecodeUplinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecodeUplinkResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecodeDownlinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecodeDownlinkResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AsConfiguration_PubSub); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AsConfiguration_Webhooks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AsConfiguration_PubSub_Providers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_applicationserver_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   5,
		},
		GoTypes:           file_ttn_lorawan_v3_applicationserver_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_applicationserver_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_applicationserver_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_applicationserver_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_applicationserver_proto = out.File
	file_ttn_lorawan_v3_applicationserver_proto_rawDesc = nil
	file_ttn_lorawan_v3_applicationserver_proto_goTypes = nil
	file_ttn_lorawan_v3_applicationserver_proto_depIdxs = nil
}
