// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/application_services.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ApplicationRegistry_Create_FullMethodName      = "/ttn.lorawan.v3.ApplicationRegistry/Create"
	ApplicationRegistry_Get_FullMethodName         = "/ttn.lorawan.v3.ApplicationRegistry/Get"
	ApplicationRegistry_List_FullMethodName        = "/ttn.lorawan.v3.ApplicationRegistry/List"
	ApplicationRegistry_Update_FullMethodName      = "/ttn.lorawan.v3.ApplicationRegistry/Update"
	ApplicationRegistry_Delete_FullMethodName      = "/ttn.lorawan.v3.ApplicationRegistry/Delete"
	ApplicationRegistry_Restore_FullMethodName     = "/ttn.lorawan.v3.ApplicationRegistry/Restore"
	ApplicationRegistry_Purge_FullMethodName       = "/ttn.lorawan.v3.ApplicationRegistry/Purge"
	ApplicationRegistry_IssueDevEUI_FullMethodName = "/ttn.lorawan.v3.ApplicationRegistry/IssueDevEUI"
)

// ApplicationRegistryClient is the client API for ApplicationRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationRegistryClient interface {
	// Create a new application. This also sets the given organization or user as
	// first collaborator with all possible rights.
	Create(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Get the application with the given identifiers, selecting the fields specified
	// in the field mask.
	// More or less fields may be returned, depending on the rights of the caller.
	Get(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// List applications where the given user or organization is a direct collaborator.
	// If no user or organization is given, this returns the applications the caller
	// has access to.
	// Similar to Get, this selects the fields given by the field mask.
	// More or less fields may be returned, depending on the rights of the caller.
	List(ctx context.Context, in *ListApplicationsRequest, opts ...grpc.CallOption) (*Applications, error)
	// Update the application, changing the fields specified by the field mask to the provided values.
	Update(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Delete the application. This may not release the application ID for reuse.
	// All end devices must be deleted from the application before it can be deleted.
	Delete(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Restore a recently deleted application.
	//
	// Deployment configuration may specify if, and for how long after deletion,
	// entities can be restored.
	Restore(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Purge the application. This will release the application ID for reuse.
	// All end devices must be deleted from the application before it can be deleted.
	// The application owner is responsible for clearing data from any (external) integrations
	// that may store and expose data by application ID
	Purge(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Request DevEUI from the configured address block for a device inside the application.
	// The maximum number of DevEUI's issued per application can be configured.
	IssueDevEUI(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*IssueDevEUIResponse, error)
}

type applicationRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationRegistryClient(cc grpc.ClientConnInterface) ApplicationRegistryClient {
	return &applicationRegistryClient{cc}
}

func (c *applicationRegistryClient) Create(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, ApplicationRegistry_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationRegistryClient) Get(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, ApplicationRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationRegistryClient) List(ctx context.Context, in *ListApplicationsRequest, opts ...grpc.CallOption) (*Applications, error) {
	out := new(Applications)
	err := c.cc.Invoke(ctx, ApplicationRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationRegistryClient) Update(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, ApplicationRegistry_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationRegistryClient) Delete(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationRegistryClient) Restore(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationRegistry_Restore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationRegistryClient) Purge(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationRegistry_Purge_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationRegistryClient) IssueDevEUI(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*IssueDevEUIResponse, error) {
	out := new(IssueDevEUIResponse)
	err := c.cc.Invoke(ctx, ApplicationRegistry_IssueDevEUI_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationRegistryServer is the server API for ApplicationRegistry service.
// All implementations must embed UnimplementedApplicationRegistryServer
// for forward compatibility
type ApplicationRegistryServer interface {
	// Create a new application. This also sets the given organization or user as
	// first collaborator with all possible rights.
	Create(context.Context, *CreateApplicationRequest) (*Application, error)
	// Get the application with the given identifiers, selecting the fields specified
	// in the field mask.
	// More or less fields may be returned, depending on the rights of the caller.
	Get(context.Context, *GetApplicationRequest) (*Application, error)
	// List applications where the given user or organization is a direct collaborator.
	// If no user or organization is given, this returns the applications the caller
	// has access to.
	// Similar to Get, this selects the fields given by the field mask.
	// More or less fields may be returned, depending on the rights of the caller.
	List(context.Context, *ListApplicationsRequest) (*Applications, error)
	// Update the application, changing the fields specified by the field mask to the provided values.
	Update(context.Context, *UpdateApplicationRequest) (*Application, error)
	// Delete the application. This may not release the application ID for reuse.
	// All end devices must be deleted from the application before it can be deleted.
	Delete(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error)
	// Restore a recently deleted application.
	//
	// Deployment configuration may specify if, and for how long after deletion,
	// entities can be restored.
	Restore(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error)
	// Purge the application. This will release the application ID for reuse.
	// All end devices must be deleted from the application before it can be deleted.
	// The application owner is responsible for clearing data from any (external) integrations
	// that may store and expose data by application ID
	Purge(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error)
	// Request DevEUI from the configured address block for a device inside the application.
	// The maximum number of DevEUI's issued per application can be configured.
	IssueDevEUI(context.Context, *ApplicationIdentifiers) (*IssueDevEUIResponse, error)
	mustEmbedUnimplementedApplicationRegistryServer()
}

// UnimplementedApplicationRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedApplicationRegistryServer struct {
}

func (UnimplementedApplicationRegistryServer) Create(context.Context, *CreateApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedApplicationRegistryServer) Get(context.Context, *GetApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedApplicationRegistryServer) List(context.Context, *ListApplicationsRequest) (*Applications, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedApplicationRegistryServer) Update(context.Context, *UpdateApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedApplicationRegistryServer) Delete(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedApplicationRegistryServer) Restore(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restore not implemented")
}
func (UnimplementedApplicationRegistryServer) Purge(context.Context, *ApplicationIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Purge not implemented")
}
func (UnimplementedApplicationRegistryServer) IssueDevEUI(context.Context, *ApplicationIdentifiers) (*IssueDevEUIResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IssueDevEUI not implemented")
}
func (UnimplementedApplicationRegistryServer) mustEmbedUnimplementedApplicationRegistryServer() {}

// UnsafeApplicationRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationRegistryServer will
// result in compilation errors.
type UnsafeApplicationRegistryServer interface {
	mustEmbedUnimplementedApplicationRegistryServer()
}

func RegisterApplicationRegistryServer(s grpc.ServiceRegistrar, srv ApplicationRegistryServer) {
	s.RegisterService(&ApplicationRegistry_ServiceDesc, srv)
}

func _ApplicationRegistry_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).Create(ctx, req.(*CreateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).Get(ctx, req.(*GetApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).List(ctx, req.(*ListApplicationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationRegistry_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).Update(ctx, req.(*UpdateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).Delete(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationRegistry_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_Restore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).Restore(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationRegistry_Purge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).Purge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_Purge_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).Purge(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationRegistry_IssueDevEUI_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationRegistryServer).IssueDevEUI(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationRegistry_IssueDevEUI_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationRegistryServer).IssueDevEUI(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// ApplicationRegistry_ServiceDesc is the grpc.ServiceDesc for ApplicationRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ApplicationRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ApplicationRegistry",
	HandlerType: (*ApplicationRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _ApplicationRegistry_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ApplicationRegistry_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ApplicationRegistry_List_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ApplicationRegistry_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ApplicationRegistry_Delete_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _ApplicationRegistry_Restore_Handler,
		},
		{
			MethodName: "Purge",
			Handler:    _ApplicationRegistry_Purge_Handler,
		},
		{
			MethodName: "IssueDevEUI",
			Handler:    _ApplicationRegistry_IssueDevEUI_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/application_services.proto",
}

const (
	ApplicationAccess_ListRights_FullMethodName         = "/ttn.lorawan.v3.ApplicationAccess/ListRights"
	ApplicationAccess_CreateAPIKey_FullMethodName       = "/ttn.lorawan.v3.ApplicationAccess/CreateAPIKey"
	ApplicationAccess_ListAPIKeys_FullMethodName        = "/ttn.lorawan.v3.ApplicationAccess/ListAPIKeys"
	ApplicationAccess_GetAPIKey_FullMethodName          = "/ttn.lorawan.v3.ApplicationAccess/GetAPIKey"
	ApplicationAccess_UpdateAPIKey_FullMethodName       = "/ttn.lorawan.v3.ApplicationAccess/UpdateAPIKey"
	ApplicationAccess_DeleteAPIKey_FullMethodName       = "/ttn.lorawan.v3.ApplicationAccess/DeleteAPIKey"
	ApplicationAccess_GetCollaborator_FullMethodName    = "/ttn.lorawan.v3.ApplicationAccess/GetCollaborator"
	ApplicationAccess_SetCollaborator_FullMethodName    = "/ttn.lorawan.v3.ApplicationAccess/SetCollaborator"
	ApplicationAccess_ListCollaborators_FullMethodName  = "/ttn.lorawan.v3.ApplicationAccess/ListCollaborators"
	ApplicationAccess_DeleteCollaborator_FullMethodName = "/ttn.lorawan.v3.ApplicationAccess/DeleteCollaborator"
)

// ApplicationAccessClient is the client API for ApplicationAccess service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationAccessClient interface {
	// List the rights the caller has on this application.
	ListRights(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*Rights, error)
	// Create an API key scoped to this application.
	CreateAPIKey(ctx context.Context, in *CreateApplicationAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error)
	// List the API keys for this application.
	ListAPIKeys(ctx context.Context, in *ListApplicationAPIKeysRequest, opts ...grpc.CallOption) (*APIKeys, error)
	// Get a single API key of this application.
	GetAPIKey(ctx context.Context, in *GetApplicationAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error)
	// Update the rights of an API key of the application.
	// This method can also be used to delete the API key, by giving it no rights.
	// The caller is required to have all assigned or/and removed rights.
	UpdateAPIKey(ctx context.Context, in *UpdateApplicationAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error)
	// Delete a single API key of this application.
	DeleteAPIKey(ctx context.Context, in *DeleteApplicationAPIKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get the rights of a collaborator (member) of the application.
	// Pseudo-rights in the response (such as the "_ALL" right) are not expanded.
	GetCollaborator(ctx context.Context, in *GetApplicationCollaboratorRequest, opts ...grpc.CallOption) (*GetCollaboratorResponse, error)
	// Set the rights of a collaborator (member) on the application.
	// This method can also be used to delete the collaborator, by giving them no rights.
	// The caller is required to have all assigned or/and removed rights.
	SetCollaborator(ctx context.Context, in *SetApplicationCollaboratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List the collaborators on this application.
	ListCollaborators(ctx context.Context, in *ListApplicationCollaboratorsRequest, opts ...grpc.CallOption) (*Collaborators, error)
	// DeleteCollaborator removes a collaborator from an application.
	DeleteCollaborator(ctx context.Context, in *DeleteApplicationCollaboratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type applicationAccessClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationAccessClient(cc grpc.ClientConnInterface) ApplicationAccessClient {
	return &applicationAccessClient{cc}
}

func (c *applicationAccessClient) ListRights(ctx context.Context, in *ApplicationIdentifiers, opts ...grpc.CallOption) (*Rights, error) {
	out := new(Rights)
	err := c.cc.Invoke(ctx, ApplicationAccess_ListRights_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) CreateAPIKey(ctx context.Context, in *CreateApplicationAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error) {
	out := new(APIKey)
	err := c.cc.Invoke(ctx, ApplicationAccess_CreateAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) ListAPIKeys(ctx context.Context, in *ListApplicationAPIKeysRequest, opts ...grpc.CallOption) (*APIKeys, error) {
	out := new(APIKeys)
	err := c.cc.Invoke(ctx, ApplicationAccess_ListAPIKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) GetAPIKey(ctx context.Context, in *GetApplicationAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error) {
	out := new(APIKey)
	err := c.cc.Invoke(ctx, ApplicationAccess_GetAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) UpdateAPIKey(ctx context.Context, in *UpdateApplicationAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error) {
	out := new(APIKey)
	err := c.cc.Invoke(ctx, ApplicationAccess_UpdateAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) DeleteAPIKey(ctx context.Context, in *DeleteApplicationAPIKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationAccess_DeleteAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) GetCollaborator(ctx context.Context, in *GetApplicationCollaboratorRequest, opts ...grpc.CallOption) (*GetCollaboratorResponse, error) {
	out := new(GetCollaboratorResponse)
	err := c.cc.Invoke(ctx, ApplicationAccess_GetCollaborator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) SetCollaborator(ctx context.Context, in *SetApplicationCollaboratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationAccess_SetCollaborator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) ListCollaborators(ctx context.Context, in *ListApplicationCollaboratorsRequest, opts ...grpc.CallOption) (*Collaborators, error) {
	out := new(Collaborators)
	err := c.cc.Invoke(ctx, ApplicationAccess_ListCollaborators_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationAccessClient) DeleteCollaborator(ctx context.Context, in *DeleteApplicationCollaboratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationAccess_DeleteCollaborator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationAccessServer is the server API for ApplicationAccess service.
// All implementations must embed UnimplementedApplicationAccessServer
// for forward compatibility
type ApplicationAccessServer interface {
	// List the rights the caller has on this application.
	ListRights(context.Context, *ApplicationIdentifiers) (*Rights, error)
	// Create an API key scoped to this application.
	CreateAPIKey(context.Context, *CreateApplicationAPIKeyRequest) (*APIKey, error)
	// List the API keys for this application.
	ListAPIKeys(context.Context, *ListApplicationAPIKeysRequest) (*APIKeys, error)
	// Get a single API key of this application.
	GetAPIKey(context.Context, *GetApplicationAPIKeyRequest) (*APIKey, error)
	// Update the rights of an API key of the application.
	// This method can also be used to delete the API key, by giving it no rights.
	// The caller is required to have all assigned or/and removed rights.
	UpdateAPIKey(context.Context, *UpdateApplicationAPIKeyRequest) (*APIKey, error)
	// Delete a single API key of this application.
	DeleteAPIKey(context.Context, *DeleteApplicationAPIKeyRequest) (*emptypb.Empty, error)
	// Get the rights of a collaborator (member) of the application.
	// Pseudo-rights in the response (such as the "_ALL" right) are not expanded.
	GetCollaborator(context.Context, *GetApplicationCollaboratorRequest) (*GetCollaboratorResponse, error)
	// Set the rights of a collaborator (member) on the application.
	// This method can also be used to delete the collaborator, by giving them no rights.
	// The caller is required to have all assigned or/and removed rights.
	SetCollaborator(context.Context, *SetApplicationCollaboratorRequest) (*emptypb.Empty, error)
	// List the collaborators on this application.
	ListCollaborators(context.Context, *ListApplicationCollaboratorsRequest) (*Collaborators, error)
	// DeleteCollaborator removes a collaborator from an application.
	DeleteCollaborator(context.Context, *DeleteApplicationCollaboratorRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedApplicationAccessServer()
}

// UnimplementedApplicationAccessServer must be embedded to have forward compatible implementations.
type UnimplementedApplicationAccessServer struct {
}

func (UnimplementedApplicationAccessServer) ListRights(context.Context, *ApplicationIdentifiers) (*Rights, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRights not implemented")
}
func (UnimplementedApplicationAccessServer) CreateAPIKey(context.Context, *CreateApplicationAPIKeyRequest) (*APIKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAPIKey not implemented")
}
func (UnimplementedApplicationAccessServer) ListAPIKeys(context.Context, *ListApplicationAPIKeysRequest) (*APIKeys, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAPIKeys not implemented")
}
func (UnimplementedApplicationAccessServer) GetAPIKey(context.Context, *GetApplicationAPIKeyRequest) (*APIKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIKey not implemented")
}
func (UnimplementedApplicationAccessServer) UpdateAPIKey(context.Context, *UpdateApplicationAPIKeyRequest) (*APIKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAPIKey not implemented")
}
func (UnimplementedApplicationAccessServer) DeleteAPIKey(context.Context, *DeleteApplicationAPIKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAPIKey not implemented")
}
func (UnimplementedApplicationAccessServer) GetCollaborator(context.Context, *GetApplicationCollaboratorRequest) (*GetCollaboratorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCollaborator not implemented")
}
func (UnimplementedApplicationAccessServer) SetCollaborator(context.Context, *SetApplicationCollaboratorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetCollaborator not implemented")
}
func (UnimplementedApplicationAccessServer) ListCollaborators(context.Context, *ListApplicationCollaboratorsRequest) (*Collaborators, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCollaborators not implemented")
}
func (UnimplementedApplicationAccessServer) DeleteCollaborator(context.Context, *DeleteApplicationCollaboratorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCollaborator not implemented")
}
func (UnimplementedApplicationAccessServer) mustEmbedUnimplementedApplicationAccessServer() {}

// UnsafeApplicationAccessServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationAccessServer will
// result in compilation errors.
type UnsafeApplicationAccessServer interface {
	mustEmbedUnimplementedApplicationAccessServer()
}

func RegisterApplicationAccessServer(s grpc.ServiceRegistrar, srv ApplicationAccessServer) {
	s.RegisterService(&ApplicationAccess_ServiceDesc, srv)
}

func _ApplicationAccess_ListRights_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).ListRights(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_ListRights_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).ListRights(ctx, req.(*ApplicationIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_CreateAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApplicationAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).CreateAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_CreateAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).CreateAPIKey(ctx, req.(*CreateApplicationAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_ListAPIKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationAPIKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).ListAPIKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_ListAPIKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).ListAPIKeys(ctx, req.(*ListApplicationAPIKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_GetAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).GetAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_GetAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).GetAPIKey(ctx, req.(*GetApplicationAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_UpdateAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).UpdateAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_UpdateAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).UpdateAPIKey(ctx, req.(*UpdateApplicationAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_DeleteAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApplicationAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).DeleteAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_DeleteAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).DeleteAPIKey(ctx, req.(*DeleteApplicationAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_GetCollaborator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationCollaboratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).GetCollaborator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_GetCollaborator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).GetCollaborator(ctx, req.(*GetApplicationCollaboratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_SetCollaborator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetApplicationCollaboratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).SetCollaborator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_SetCollaborator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).SetCollaborator(ctx, req.(*SetApplicationCollaboratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_ListCollaborators_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationCollaboratorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).ListCollaborators(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_ListCollaborators_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).ListCollaborators(ctx, req.(*ListApplicationCollaboratorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationAccess_DeleteCollaborator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApplicationCollaboratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationAccessServer).DeleteCollaborator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationAccess_DeleteCollaborator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationAccessServer).DeleteCollaborator(ctx, req.(*DeleteApplicationCollaboratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ApplicationAccess_ServiceDesc is the grpc.ServiceDesc for ApplicationAccess service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ApplicationAccess_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ApplicationAccess",
	HandlerType: (*ApplicationAccessServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRights",
			Handler:    _ApplicationAccess_ListRights_Handler,
		},
		{
			MethodName: "CreateAPIKey",
			Handler:    _ApplicationAccess_CreateAPIKey_Handler,
		},
		{
			MethodName: "ListAPIKeys",
			Handler:    _ApplicationAccess_ListAPIKeys_Handler,
		},
		{
			MethodName: "GetAPIKey",
			Handler:    _ApplicationAccess_GetAPIKey_Handler,
		},
		{
			MethodName: "UpdateAPIKey",
			Handler:    _ApplicationAccess_UpdateAPIKey_Handler,
		},
		{
			MethodName: "DeleteAPIKey",
			Handler:    _ApplicationAccess_DeleteAPIKey_Handler,
		},
		{
			MethodName: "GetCollaborator",
			Handler:    _ApplicationAccess_GetCollaborator_Handler,
		},
		{
			MethodName: "SetCollaborator",
			Handler:    _ApplicationAccess_SetCollaborator_Handler,
		},
		{
			MethodName: "ListCollaborators",
			Handler:    _ApplicationAccess_ListCollaborators_Handler,
		},
		{
			MethodName: "DeleteCollaborator",
			Handler:    _ApplicationAccess_DeleteCollaborator_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/application_services.proto",
}
