// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on Application with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *Application) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ApplicationValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "deleted_at":

			if v, ok := interface{}(m.GetDeletedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationValidationError{
						field:  "deleted_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return ApplicationValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 2000 {
				return ApplicationValidationError{
					field:  "description",
					reason: "value length must be at most 2000 runes",
				}
			}

		case "attributes":

			if len(m.GetAttributes()) > 10 {
				return ApplicationValidationError{
					field:  "attributes",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetAttributes() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return ApplicationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_Application_Attributes_Pattern.MatchString(key) {
					return ApplicationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 200 {
					return ApplicationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 200 runes",
					}
				}

			}

		case "contact_info":

			if len(m.GetContactInfo()) > 10 {
				return ApplicationValidationError{
					field:  "contact_info",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetContactInfo() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationValidationError{
							field:  fmt.Sprintf("contact_info[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "administrative_contact":

			if v, ok := interface{}(m.GetAdministrativeContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationValidationError{
						field:  "administrative_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "technical_contact":

			if v, ok := interface{}(m.GetTechnicalContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationValidationError{
						field:  "technical_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "network_server_address":

			if !_Application_NetworkServerAddress_Pattern.MatchString(m.GetNetworkServerAddress()) {
				return ApplicationValidationError{
					field:  "network_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "application_server_address":

			if !_Application_ApplicationServerAddress_Pattern.MatchString(m.GetApplicationServerAddress()) {
				return ApplicationValidationError{
					field:  "application_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "join_server_address":

			if !_Application_JoinServerAddress_Pattern.MatchString(m.GetJoinServerAddress()) {
				return ApplicationValidationError{
					field:  "join_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "dev_eui_counter":
			// no validation rules for DevEuiCounter
		default:
			return ApplicationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationValidationError is the validation error returned by
// Application.ValidateFields if the designated constraints aren't met.
type ApplicationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationValidationError) ErrorName() string { return "ApplicationValidationError" }

// Error satisfies the builtin error interface
func (e ApplicationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplication.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationValidationError{}

var _Application_Attributes_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _Application_NetworkServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

var _Application_ApplicationServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

var _Application_JoinServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

// ValidateFields checks the field values on Applications with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Applications) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "applications":

			for idx, item := range m.GetApplications() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationsValidationError{
							field:  fmt.Sprintf("applications[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationsValidationError is the validation error returned by
// Applications.ValidateFields if the designated constraints aren't met.
type ApplicationsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationsValidationError) ErrorName() string { return "ApplicationsValidationError" }

// Error satisfies the builtin error interface
func (e ApplicationsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplications.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationsValidationError{}

// ValidateFields checks the field values on IssueDevEUIResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *IssueDevEUIResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = IssueDevEUIResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_eui":

			if len(m.GetDevEui()) > 0 {

				if len(m.GetDevEui()) != 8 {
					return IssueDevEUIResponseValidationError{
						field:  "dev_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		default:
			return IssueDevEUIResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// IssueDevEUIResponseValidationError is the validation error returned by
// IssueDevEUIResponse.ValidateFields if the designated constraints aren't met.
type IssueDevEUIResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e IssueDevEUIResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e IssueDevEUIResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e IssueDevEUIResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e IssueDevEUIResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e IssueDevEUIResponseValidationError) ErrorName() string {
	return "IssueDevEUIResponseValidationError"
}

// Error satisfies the builtin error interface
func (e IssueDevEUIResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sIssueDevEUIResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = IssueDevEUIResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = IssueDevEUIResponseValidationError{}

// ValidateFields checks the field values on GetApplicationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetApplicationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return GetApplicationRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationRequestValidationError is the validation error returned by
// GetApplicationRequest.ValidateFields if the designated constraints aren't met.
type GetApplicationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationRequestValidationError) ErrorName() string {
	return "GetApplicationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationRequestValidationError{}

// ValidateFields checks the field values on ListApplicationsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListApplicationsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "collaborator":

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationsRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationsRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListApplicationsRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListApplicationsRequestValidationError{
					field:  "order",
					reason: "value must be in list [ application_id -application_id name -name created_at -created_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListApplicationsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "deleted":
			// no validation rules for Deleted
		default:
			return ListApplicationsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationsRequestValidationError is the validation error returned by
// ListApplicationsRequest.ValidateFields if the designated constraints aren't met.
type ListApplicationsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListApplicationsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListApplicationsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationsRequestValidationError) ErrorName() string {
	return "ListApplicationsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationsRequestValidationError{}

var _ListApplicationsRequest_Order_InLookup = map[string]struct{}{
	"":                {},
	"application_id":  {},
	"-application_id": {},
	"name":            {},
	"-name":           {},
	"created_at":      {},
	"-created_at":     {},
}

// ValidateFields checks the field values on CreateApplicationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateApplicationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateApplicationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application":

			if m.GetApplication() == nil {
				return CreateApplicationRequestValidationError{
					field:  "application",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplication()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateApplicationRequestValidationError{
						field:  "application",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return CreateApplicationRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateApplicationRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return CreateApplicationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateApplicationRequestValidationError is the validation error returned by
// CreateApplicationRequest.ValidateFields if the designated constraints
// aren't met.
type CreateApplicationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateApplicationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateApplicationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateApplicationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateApplicationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateApplicationRequestValidationError) ErrorName() string {
	return "CreateApplicationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateApplicationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateApplicationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateApplicationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateApplicationRequestValidationError{}

// ValidateFields checks the field values on UpdateApplicationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpdateApplicationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateApplicationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application":

			if m.GetApplication() == nil {
				return UpdateApplicationRequestValidationError{
					field:  "application",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplication()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateApplicationRequestValidationError{
						field:  "application",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateApplicationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateApplicationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateApplicationRequestValidationError is the validation error returned by
// UpdateApplicationRequest.ValidateFields if the designated constraints
// aren't met.
type UpdateApplicationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateApplicationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateApplicationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateApplicationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateApplicationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateApplicationRequestValidationError) ErrorName() string {
	return "UpdateApplicationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateApplicationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateApplicationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateApplicationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateApplicationRequestValidationError{}

// ValidateFields checks the field values on ListApplicationAPIKeysRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListApplicationAPIKeysRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationAPIKeysRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return ListApplicationAPIKeysRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationAPIKeysRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListApplicationAPIKeysRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListApplicationAPIKeysRequestValidationError{
					field:  "order",
					reason: "value must be in list [ api_key_id -api_key_id name -name created_at -created_at expires_at -expires_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListApplicationAPIKeysRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		default:
			return ListApplicationAPIKeysRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationAPIKeysRequestValidationError is the validation error
// returned by ListApplicationAPIKeysRequest.ValidateFields if the designated
// constraints aren't met.
type ListApplicationAPIKeysRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationAPIKeysRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListApplicationAPIKeysRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListApplicationAPIKeysRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationAPIKeysRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationAPIKeysRequestValidationError) ErrorName() string {
	return "ListApplicationAPIKeysRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationAPIKeysRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationAPIKeysRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationAPIKeysRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationAPIKeysRequestValidationError{}

var _ListApplicationAPIKeysRequest_Order_InLookup = map[string]struct{}{
	"":            {},
	"api_key_id":  {},
	"-api_key_id": {},
	"name":        {},
	"-name":       {},
	"created_at":  {},
	"-created_at": {},
	"expires_at":  {},
	"-expires_at": {},
}

// ValidateFields checks the field values on GetApplicationAPIKeyRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetApplicationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return GetApplicationAPIKeyRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationAPIKeyRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return GetApplicationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationAPIKeyRequestValidationError is the validation error returned
// by GetApplicationAPIKeyRequest.ValidateFields if the designated constraints
// aren't met.
type GetApplicationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationAPIKeyRequestValidationError) ErrorName() string {
	return "GetApplicationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on CreateApplicationAPIKeyRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *CreateApplicationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateApplicationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return CreateApplicationAPIKeyRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateApplicationAPIKeyRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return CreateApplicationAPIKeyRequestValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "rights":

			if len(m.GetRights()) < 1 {
				return CreateApplicationAPIKeyRequestValidationError{
					field:  "rights",
					reason: "value must contain at least 1 item(s)",
				}
			}

			_CreateApplicationAPIKeyRequest_Rights_Unique := make(map[Right]struct{}, len(m.GetRights()))

			for idx, item := range m.GetRights() {
				_, _ = idx, item

				if _, exists := _CreateApplicationAPIKeyRequest_Rights_Unique[item]; exists {
					return CreateApplicationAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_CreateApplicationAPIKeyRequest_Rights_Unique[item] = struct{}{}
				}

				if _, ok := Right_name[int32(item)]; !ok {
					return CreateApplicationAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		case "expires_at":

			if t := m.GetExpiresAt(); t != nil {
				ts, err := t.AsTime(), t.CheckValid()
				if err != nil {
					return CreateApplicationAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value is not a valid timestamp",
						cause:  err,
					}
				}

				now := time.Now()

				if ts.Sub(now) <= 0 {
					return CreateApplicationAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value must be greater than now",
					}
				}

			}

		default:
			return CreateApplicationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateApplicationAPIKeyRequestValidationError is the validation error
// returned by CreateApplicationAPIKeyRequest.ValidateFields if the designated
// constraints aren't met.
type CreateApplicationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateApplicationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateApplicationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateApplicationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateApplicationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateApplicationAPIKeyRequestValidationError) ErrorName() string {
	return "CreateApplicationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateApplicationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateApplicationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateApplicationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateApplicationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on UpdateApplicationAPIKeyRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *UpdateApplicationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateApplicationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return UpdateApplicationAPIKeyRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateApplicationAPIKeyRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "api_key":

			if m.GetApiKey() == nil {
				return UpdateApplicationAPIKeyRequestValidationError{
					field:  "api_key",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApiKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateApplicationAPIKeyRequestValidationError{
						field:  "api_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateApplicationAPIKeyRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateApplicationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateApplicationAPIKeyRequestValidationError is the validation error
// returned by UpdateApplicationAPIKeyRequest.ValidateFields if the designated
// constraints aren't met.
type UpdateApplicationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateApplicationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateApplicationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateApplicationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateApplicationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateApplicationAPIKeyRequestValidationError) ErrorName() string {
	return "UpdateApplicationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateApplicationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateApplicationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateApplicationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateApplicationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on DeleteApplicationAPIKeyRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *DeleteApplicationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteApplicationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return DeleteApplicationAPIKeyRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteApplicationAPIKeyRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return DeleteApplicationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteApplicationAPIKeyRequestValidationError is the validation error
// returned by DeleteApplicationAPIKeyRequest.ValidateFields if the designated
// constraints aren't met.
type DeleteApplicationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteApplicationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteApplicationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteApplicationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteApplicationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteApplicationAPIKeyRequestValidationError) ErrorName() string {
	return "DeleteApplicationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteApplicationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteApplicationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteApplicationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteApplicationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on
// ListApplicationCollaboratorsRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ListApplicationCollaboratorsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationCollaboratorsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return ListApplicationCollaboratorsRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationCollaboratorsRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListApplicationCollaboratorsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "order":

			if _, ok := _ListApplicationCollaboratorsRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListApplicationCollaboratorsRequestValidationError{
					field:  "order",
					reason: "value must be in list [ id -id -rights rights]",
				}
			}

		default:
			return ListApplicationCollaboratorsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationCollaboratorsRequestValidationError is the validation error
// returned by ListApplicationCollaboratorsRequest.ValidateFields if the
// designated constraints aren't met.
type ListApplicationCollaboratorsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationCollaboratorsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListApplicationCollaboratorsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListApplicationCollaboratorsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationCollaboratorsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationCollaboratorsRequestValidationError) ErrorName() string {
	return "ListApplicationCollaboratorsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationCollaboratorsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationCollaboratorsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationCollaboratorsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationCollaboratorsRequestValidationError{}

var _ListApplicationCollaboratorsRequest_Order_InLookup = map[string]struct{}{
	"":        {},
	"id":      {},
	"-id":     {},
	"-rights": {},
	"rights":  {},
}

// ValidateFields checks the field values on GetApplicationCollaboratorRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *GetApplicationCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return GetApplicationCollaboratorRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationCollaboratorRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return GetApplicationCollaboratorRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationCollaboratorRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationCollaboratorRequestValidationError is the validation error
// returned by GetApplicationCollaboratorRequest.ValidateFields if the
// designated constraints aren't met.
type GetApplicationCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationCollaboratorRequestValidationError) ErrorName() string {
	return "GetApplicationCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationCollaboratorRequestValidationError{}

// ValidateFields checks the field values on SetApplicationCollaboratorRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *SetApplicationCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetApplicationCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return SetApplicationCollaboratorRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationCollaboratorRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return SetApplicationCollaboratorRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationCollaboratorRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetApplicationCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetApplicationCollaboratorRequestValidationError is the validation error
// returned by SetApplicationCollaboratorRequest.ValidateFields if the
// designated constraints aren't met.
type SetApplicationCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetApplicationCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetApplicationCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetApplicationCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetApplicationCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetApplicationCollaboratorRequestValidationError) ErrorName() string {
	return "SetApplicationCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetApplicationCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetApplicationCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetApplicationCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetApplicationCollaboratorRequestValidationError{}

// ValidateFields checks the field values on
// DeleteApplicationCollaboratorRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *DeleteApplicationCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteApplicationCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return DeleteApplicationCollaboratorRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteApplicationCollaboratorRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator_ids":

			if m.GetCollaboratorIds() == nil {
				return DeleteApplicationCollaboratorRequestValidationError{
					field:  "collaborator_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaboratorIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteApplicationCollaboratorRequestValidationError{
						field:  "collaborator_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return DeleteApplicationCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteApplicationCollaboratorRequestValidationError is the validation error
// returned by DeleteApplicationCollaboratorRequest.ValidateFields if the
// designated constraints aren't met.
type DeleteApplicationCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteApplicationCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteApplicationCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteApplicationCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteApplicationCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteApplicationCollaboratorRequestValidationError) ErrorName() string {
	return "DeleteApplicationCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteApplicationCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteApplicationCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteApplicationCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteApplicationCollaboratorRequestValidationError{}
