// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package provisioning

import (
	"strings"

	"google.golang.org/protobuf/types/known/structpb"
)

// Microchip is the provisioning ID for Microchip devices.
const Microchip = "microchip"

type microchip struct{}

// UniqueID returns the serial number.
func (p *microchip) UniqueID(entry *structpb.Struct) (string, error) {
	if entry == nil {
		return "", errEntry.New()
	}
	sn := entry.Fields["uniqueId"].GetStringValue()
	if sn == "" {
		return "", errEntry.New()
	}
	return strings.ToUpper(sn), nil
}

func init() {
	Register(Microchip, new(microchip))
}
