// Copyright © 2020 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package commands

import (
	"os"

	"github.com/spf13/cobra"
	"go.thethings.network/lorawan-stack/v3/cmd/internal/io"
	"go.thethings.network/lorawan-stack/v3/cmd/ttn-lw-cli/internal/api"
	"go.thethings.network/lorawan-stack/v3/pkg/ttnpb"
)

var authInfo = &cobra.Command{
	Use:    "auth-info",
	Hidden: true,
	Short:  "Get auth info",
	RunE: func(cmd *cobra.Command, args []string) error {
		is, err := api.Dial(ctx, config.IdentityServerGRPCAddress)
		if err != nil {
			return err
		}
		res, err := ttnpb.NewEntityAccessClient(is).AuthInfo(ctx, ttnpb.Empty)
		if err != nil {
			return err
		}

		return io.Write(os.Stdout, config.OutputFormat, res)
	},
}

func init() {
	Root.AddCommand(authInfo)
}
