# Changelog

All notable changes to this project are documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
with the exception that this project **does not** follow Semantic Versioning.

For details about compatibility between different releases, see the **Commitments and Releases** section of our README.

## [Unreleased]

### Added

### Changed

### Deprecated

### Removed

### Fixed

- Enforce default page limit on AS and NS List RPCs if a value is not provided in the request.
- Swapped field order in `RelayNotifyNewEndDeviceReq` MAC command.

### Security

## [3.33.0] - 2024-12-18

### Added

- Support user email notification preferences.
  - This requires an Identity Server database migration (`ttn-lw-stack is-db migrate`).
- Support for managing MAC settings profiles.
  - This feature is experimental and subject to change.
- Support pausing webhook in the edit webhook view in console
- Add more specific rights for user operations.
  - The rights added were for listing and creating rights.
  - Admin validation associated with these operations remains.
- Add purge rights for application, organizations, Oauth clients, gateways and user operations.

### Fixed

- Fix OAuth client authorizations delete request in the Console.
- Consecutive disconnect/reconnect messages in the Live Data view in the Console.

## [3.32.3] - 2024-12-04

## [3.32.2] - 2024-11-18

### Fixed

- Potential leak of end devices of other (owned) applications in the top end devices panel in the application overview of the Console.
- Fix reversed Join Server dev nonce metrics.
- Identity Server's store runs each migration within a transaction, so a migration's changes are only applied if all of its queries are successful.
  - Identity Server's store now marks a migration as successful after all its operations are finished. Previously it was possible to have a successful migration which not all of its queries were processed.
- Enforce default page limit on IS List RPCs if a value is not provided in the request.

## [3.32.1] - 2024-10-24

### Added

- Option to filter out non-gateway related frequency plans.
  - `ListFrequencyPlans` RPC has a new `gateways-only` flag.
- Option to pause application webhooks.
- Endpoint for claiming gateways using a qr code
- Update the GetTemplate endpoint in device repository to check for profile identifiers in the vendor index.
- Support for claiming a gateway via QR code in the Console.

### Fixed

- RX2 and Class C with The Things Industries gateway protocol in dynamic channel plan regions (including `EU868`).
- Filtering the list end points for end devices and gateways using the HTTP API.

## [3.32.0] - 2024-09-05

### Added

- Newly redesigned The Things Stack Console. The most notable changes are as follows:
  - New look and feel
  - New sidebar-based navigation and structure
  - Top entities are automatically stored and displayed for faster access
  - More useful panels in the overviews of gateways, applications and end devices
  - Quick search feature to search globally for any entity
  - New event overlay for better in-context event examination
  - Notifications can now be viewed from within the Console
- Support for managed gateways and claiming through The Things Gateway Controller.
- Support for The Things Industries gateway protocol. This is adds a new pair of ports to Gateway Server: `1889` for Envoy or Traefik terminated TLS mutual authentication, and `8889` for The Things Stack terminated TLS mutual authentication.
- Option to filter the output of the `List` RPCs for end devices and gateways based on when they were updated.
  - `ListGatewaysRequest` and `ListEndDevicesRequest` RPCs have a new `Filter` field that supports an `updated_since` timestamp.
- Preparation for universal rights assigned to users.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`).

### Deprecated

- Experimental RPCs `AuthorizeGateway` and `UnauthorizeGateway` of the Gateway Claiming Server (GCLS).
- `CUPSRedirection` field of `ClaimGatewayRequest`.

### Removed

- `authorize` and `unauthorize` sub-commands of the gateway `claim` command.

### Fixed

- Fix unhandled video stream in QR code scanner

## [3.31.1] - 2024-08-01

### Changed

- Gateway ID and device ID are not autogenerated and prefilled anymore.

## [3.31.0] - 2024-07-04

### Added

- Europe 868.1 MHz single channel frequency plan.
  - This is experimental and may be removed or hidden in the future.

### Changed

- The rate limit key for LoRa Basics Station has changed from `gs:accept:ws` to `gs:accept:semtechws/lbslns`.

### Fixed

- Potential issue with application event stream stopping after showing initial events.
- Storybook compiling issue.
- Issue where an downlink message was scheduled by the Application Layer Clock Synchronization (ALCS) implementation when there is no answer to send (i.e. `AnsRequired` is not set and the difference with what the end device reports falls within the threshold).
- Error log level and reporting when an end device attempts to join that does not have a MAC version set. Instead, the Network Server now publishes a drop join-request event.

## [3.30.2] - 2024-06-11

### Fixed

- Increased the timeout for Basic Station gateways sending HTTP headers. There should now be enough time for embedded devices with little to no hardware acceleration to perform a TLS handshake. In particular, The Things Indoor Gateway can now connect to The Things Stack presenting a ECDSA certificate.
- Reconnect a gateway when the antenna gain is adjusted.
- Fixed length bytes fields, such as EUIs, device addresses or device keys, are no longer considered as being all zero when provided as null values in JSON requests.

## [3.30.1] - 2024-05-13

### Added

- Support fine-grained NbTrans controls while using Dynamic ADR mode in the Console.
- User bookmark listing now supports filtering bookmarks by entity type.
  - This can be specified by setting `entity_types` field in `ListUserBookmarksRequest`.

### Fixed

- Show both AFcntDown and NFcntDown in the Device overview in the Console.
- Fixes the keys displayed in the session information section of overview tab of an End Device in the Console - for LW 1.1.x, replaces NwkSKey with FNwkSIntKey. For LX 1.0.x display only the NwkSKey and AppSKey.

## [3.30.0] - 2024-04-11

### Added

- Fine grained NbTrans overrides for the dynamic ADR mode. See the `--mac-settings.adr.mode.dynamic.overrides.data-rate-[index].min-nb-trans` and `--mac-settings.adr.mode.dynamic.overrides.data-rate-[index].max-nb-trans` family of parameters.
- Support for storing user's bookmarks in the database.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the new `user_bookmarks` table.
- Support for storing user's Console Preferences in the database.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the new `console_preferences` column in the `users` table.

### Changed

- Searching for collaborators displays only accounts that are not already attached to the entity's collaborator list.

## [3.29.2] - 2024-03-26

### Fixed

- Memory leak in components which heavily use HTTP clients, such as the Application Server.

## [3.29.1] - 2024-03-05

### Added

- Option to store rate limits in Redis. When used, the rate limits are applied over the entire cluster instead of per-instance.
- Field `complement_collaborators` was added to `SearchAccounts`. Allows an user to request the accounts that are not already attached to the entity's collaborator list.

## [3.29.0] - 2024-02-06

### Added

- `relays` command to `ttn-lw-cli`, which enables the management of LoRaWAN relays, including their configuration and uplink forwarding rules.

### Changed

- User's primary email address validation is now decoupled from deprecated `ContactInfo` field.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the new `email_validations` table.
- Entities' `ContactInfo` field now returns information regarding the administrative and technical contacts instead of the deprecated `ContactInfo` information.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) due to the removal of old information in the `contact_infos` table.
  - The emails of the administrative and technical contacts are only returned in the `ContactInfo` field if the caller has the appropriate rights.
- Organizations can now opt out from sending administrative and technical notifications to all collaborators.
  - New organizations do not send administrative and technical notifications to all collaborators by default.
  - To alter the behavior update the organization's `fanout_notifications` field.

### Removed

- The `http.client.transport.compression` and `http.server.transport.compression` experimental flags.

### Fixed

- Fix Add collaborator form not validating collaborator on submit in the Console.

## [3.28.2] - 2023-12-20

### Added

- Rate limiting classes for individual HTTP paths.
- Rate limiting keys for HTTP endpoints now contain the caller API key ID when available. The caller IP is still available as a fallback.
- Allow users to set multiple frequency plans only in the same band in the Console.

### Changed

- Server side events replaced with single socket connection using the native WebSocket API.
- Gateways now disconnect if the Gateway Server address has changed.
  - This enables CUPS-enabled gateways to change their LNS before the periodic CUPS lookup occurs.
- The LoRa Basics Station discovery endpoint now verifies the authorization credentials of the caller.
  - This enables the gateways to migrate to another instance gracefully while using CUPS.

### Fixed

- Batch gateway rights assertions when multiple membership chains are available (for example, both via a user and an organization).

## [3.28.1] - 2023-11-27

### Added

- The `http.client.transport.compression` experimental flag. It controls whether the HTTP clients used by the stack support gzip and zstd decompression of server responses. It is enabled by default.
- The `http.server.transport.compression` experimental flag. It controls whether the HTTP servers used by the stack support gzip compression of the server response. It is enabled by default.

### Changed

- The Things Stack is now built with Go 1.21.
- Statistics for gateways are now fetched in a single request.

### Fixed

- Resolve scroll jumps when selecting different tabs of a table in the Console.
- `BatchGetGatewayConnectionStats` RPC rights check in certain cases.

## [3.28.0] - 2023-10-31

### Added

- Locations retrieved from gateway status messages are now be displayed in the gateway map in the Console, even when they are not received through a secure connection.
- The Network Server ID (NSID, EUI-64) used in LoRaWAN Backend Interfaces is now included in the application uplink message network metadata as well as in the Backend Interfaces `HomeNSAns` message that Identity Server returns to clients. The NSID is configurable via `is.network.ns-id`.
- It is now possible to trigger a resending of the email validation email from within the Console. The new action is part of the error screen that users see when they log into the Console without having their contact info validated yet (and the network requires validation before usage).
- Updated Japanese translations for the Console and backend.
- `--grpc.correlation-ids-ignore-methods` configuration option, which allows certain gRPC methods to be skipped from the correlation ID middleware which adds a correlation ID with the name of the gRPC method. Methods bear the format used by `--grpc.log-ignore-methods`, such as `/ttn.lorawan.v3.GsNs/HandleUplink`.
- Support for setting multiple frequency plans for gateways from the Console.
- The `ns-db purge` command to purge unused data from the Network Server database.

### Changed

- Users can now request a new email for the account validation from time to time instead of once per validation, the interval between email requests is determined by `is.user-registration.contact-info-validation.retry-interval` and by default it is an hour.
- Traffic related correlation IDs have been simplified. Previously one correlation ID per component was added as traffic passed through different stack components. Now a singular correlation ID relating to the entry point of the message will be added (such as `gs:uplink:xxx` for uplinks, or `as:downlink:xxx` for downlinks), and subsequent components will no longer add any extra correlation IDs (such as `ns:uplink:xxx` or `as:up:xxx`). The uplink entry points are `pba` and `gs`, while the downlink entry points are `pba`, `ns` and `as`.
- Packet Broker Agent uplink tokens are now serialized in a more efficient manner.
- The Network Server now stores only the most recent uplinks tokens.
- The Application Server webhook health system now records failures only every retry interval while in monitor mode, as opposed to recording every failure.
  - Monitor mode in this context refers to situations in which either `--as.webhooks.unhealthy-attempts-threshold` or `--as.webhooks.unhealthy-retry-interval` are less or equal to zero. In such situations, the Application Server will record failures but will not stop the execution of the webhooks.
  - Using a retry interval of zero and a non zero attempts threshold restores the previous behavior.

### Fixed

- Providing fixed downlink paths to the `ttn-lw-cli devices downlink {push|replace}` commands using the `-class-b-c.gateways` parameter. The gateways IDs are comma separated, and the antenna index `i` can be provided by suffixing the ID with `:i` (i.e. `my-gateway:0` for antenna index 0). The group index `j` can be provided by suffixing the ID with `:j` (i.e. `my-gateway:0:1` for antenna index 0 and group index 1). The antenna index is mandatory if a group index is to be provided, but optional otherwise.
- Gateway registration without gateway EUI not working.
- Listing deleted entities is now fixed for both admin and standard users, which previously returned an `account_not_found` error.
- Update to an user's `PrimaryEmailAddress` via a non admin now invalidates the `PrimaryEmailAddressValidatedAt` as it was intended.
- Negative number support in Cayenne LPP.
- Fix panic in snapcraft CLI deployment, commands will no longer generate a panic error message when telemetry is enabled.

## [3.27.2] - 2023-09-14

### Added

- Locations retrieved from gateway status messages are now be displayed in the gateway map in the Console, even when they are not received through a secure connection.

### Fixed

- Fix gateway connection stats being stuck at `Connecting` until the first uplink is processed in the Console.

## [3.27.1] - 2023-08-29

### Added

- Add support for `administrative_contact` and `technical_contact` in the Console.
- Reimplement move away prompt in payload formatter views in the Console.
- Add telemetry collection for the CLI. A background process was added to the CLI in order to send the following information: Operating System, Architecture, Binary version and Golang version. The message is sent every 24 hours and it contains an unique random number as an identifier. It is enabled by default and in order to disable it, set `telemetry.enable` to false in the CLI configuration. For more information, consult the documentation [here](https://www.thethingsindustries.com/docs/reference/telemetry/cli).
- Add telemetry collection for the IdentityServer. A background task was added in the Identity Server which is responsible for collecting information regarding the amount of each entity in the database, this has the purpose of allowing us to better understand how users are interacting with the system, an example being if tenants are using Organizations or just Users. All information is sent every 24 hours and it contains an identifier composed of the URLs present in the following configuration fields `console.ui.[is|gs|ns|as|js].base-url`. It is enabled by default and in order to disable it, set `telemetry.enable` to false in the Stack configuration. For more information, consult the documentation [here](https://www.thethingsindustries.com/docs/reference/telemetry/identity_server).

### Fixed

- OAuth clients created by an admin no longer trigger an email requesting approval from one of the tenant's admins.
- Broken network routing policy links in the Packet Broker panel of the admin panel in the Console.
- Application Server downlink related events now contain the complete set of end device identifiers, and the received at timestamp is now provided at all times.
- Wrong order of breadcrumbs in the device views of the Console.

## [3.27.0] - 2023-07-31

### Added

- The `as-db purge` command to purge unused data from the Application Server database.
- RPCs and CLI command to delete a batch of end devices within an application.
  - Check `ttn-lw-cli end-devices batch-delete` for more details.
- Add `UserInput` component to the Console to handle user id input fields by implementing an autosuggest.
- The Identity Server configuration has a new optional restriction regarding administrative and technical contacts of entities. This limits the action of an user or organization to set these contacts only to themselves, it is disabled by default but it is possible to enable it by setting `is.collaborator-rights.set-others-as-contacts` as false.
- The Identity Server configuration has a new optional restriction regarding adminstrative and technical contacts of entities. This limits the action of an user or organization to set these contacts only to themselves, it is disabled by default but it is possible to enable it by setting `is.collaborator-rights.set-others-as-contacts` as false.
- The page, tab, search query and sort order is now kept as query parameter and will hence persist throughout navigation. Likewise it is now possible to link to specific table results.

### Changed

- Instead of retrying application downlinks indefinitely, the Application Server now retries them for a configured number of times. Each `ApplicationDownlink` message contains the `attempt` and `max_attempts` fields to indicate the current and maximum number of attempts for a specific `application downlink`.
- The Application Server configuration has the `as.downlinks.confirmation.default-retry-attempts` and `as.downlinks.confirmation.max-retry-attempts` fields that configure the allowed number of retries for application downlinks. The default values are `8` for the `as.downlinks.confirmation.default-retry-attempts` and `32` for the `as.downlinks.confirmation.max-retry-attempts`.
- The `as.downlinks.confirmation.default-retry-attempts` field is used for all application downlinks that were scheduled before this change and for every application downlink that does not have the `max_attempts` field set. On the other hand, the `as.downlinks.confirmation.max-retry-attempts` field ensures that the `max_attempts` field's upper bound is contained and does not exceed its value.
- The number of historical frames considered for the multi-frame query window size in the LoRaCloud Geolocation Services integration. The window size is now limited between 1 and 16 frames with 16 being the default value.
- Packet Broker Agent now subscribes as Home Network to all DevAddr prefixes. This is to support NetID delegation where DevAddr blocks of other NetIDs should be routed to the cluster of a different NetID.

### Deprecated

- The `as.uplink-storage.limit` configuration option.

### Removed

- Command-line interface support for listing QR code formats and generating QR codes. This is considered the responsibility of a LoRaWAN Join Server.

### Fixed

- End device data stream not being closed when navigating away from end device pages, which could cause event streams stopping to work due to too many open connections.

## [3.26.2] - 2023-07-11

### Added

- New Admin Panel in the Console.

### Fixed

- Removing user invitations not working in the user management panel for administrators.
- Fix payload formatter page launching malformed requests in the Console.
- Fix end device claiming issues in the Console and improve error messaging.
- HTTP API routes for parsing QR codes for the QR Generator service. We exercise our right to break compatibility with third party HTTP clients since this is a bug.
  - `/qr-code/end-devices/parse` is changed to `/qr-codes/end-devices/parse`.
  - `/qr-code/end-devices/{format_id}/parse` is changed to `/qr-codes/end-devices/{format_id}/parse`.
- Fixed authenticating with Packet Broker when gRPC dialer schemes are used in the address.

## [3.26.1] - 2023-06-20

### Added

- Support claim in device import in the Console.

## [3.26.0] - 2023-06-06

### Added

- Support for scanning a QR code that only contains the hexadecimal encoded DevEUI.
- Experimental flag `ns.adr.auto_narrow_steer`. When enabled, end devices which do not have an explicit channel steering mode will be steered towards the LoRa narrow channels.

### Fixed

- Console not applying webhook field masks when creating a webhook from a template that has field masks set.
- LoRa Basics Station `PONG` messages will now contain the application payload of the associated `PING`, as required by the WebSockets specification.
  - This fix enables `PING`/`PONG` behavior for non reference implementations of the LNS protocol.
- Fix crash of "Edit webhook" view due to invalid Authorization header encoding in the Console.

## [3.25.2] - 2023-05-16

### Added

- Experimental channel steering API, which allows steering end devices from the wide (250kHz or 500kHz) channels towards the narrow (125kHz) channels.
  - This API is mainly relevant for end devices operating in the US915 and AU915 regions, as they may join via a wide channel, but users may want to steer them towards the narrow channels.
  - The new settings can be found under `mac-settings.adr.mode.dynamic.channel-steering`.
  - `mac-settings.adr.mode.dynamic.channel-steering.mode.lora-narrow` steers the end devices towards the LoRa modulated narrow channels.
  - `mac-settings.adr.mode.dynamic.channel-steering.mode.disabled` does not steer the end devices - end devices are left to operate in their currently active channels, wide or narrow.
  - The default behavior is to avoid steering the end devices, but this is subject to change in future versions. Consider explicitly specifying a certain behavior (`lora-narrow` or `disabled`) if you depend on not steering the end devices.

### Changed

- Uplink and downlink message frequencies are now validated and zero values are dropped.
  - Such traffic would have always been dropped by the Network Server, but it is now dropped in the Gateway Server.
  - Simulated uplink traffic now requires a frequency value as well.

### Fixed

- Multiple ADR algorithm bugs:
  - An off-by-one error which caused the ADR algorithm to not take into consideration the signal qualities of the uplink which confirmed a parameter change. In effect, this fix improves the quality of the link budget estimation.
  - A flip-flop condition which caused the algorithm to swap back and forth between a higher and a lower transmission power index every 20 uplinks. In effect, this fix will cause the algorithm to change the transmission power index less often.
  - A condition mistake which caused the algorithm to avoid increasing the transmission power if it would not completely fix the missing link budget. In effect, this will cause the algorithm to increase the transmission power in situations in which the link budget deteriorates rapidly.
- In fixed channel plans such as US915 and AU915, the the associated wide (500kHz) channel is now enabled by default.

## [3.25.1] - 2023-04-18

### Added

- Fallback end device version identifiers to be used while importing end devices using the Console.

### Changed

- The Things Stack is now built with Go 1.20.

### Deprecated

- `--with-claim-authentication-code` flag for the end device `create` command via the CLI. Users must use a valid claim authentication code that is registered on a Join Server instead of generating one during end device creation.

### Fixed

- Attempting to claim an end device with a generated DevEUI will now result in an error.
- Claiming an end device using command line flags.
- 24 hour stack components deadlock when the default clustering mode is used.

## [3.25.0] - 2023-04-05

### Added

- Optional Network Server database migration that removes obsolete last invalidation keys is now available.
- LoRaWAN Application Layer Clock Synchronization support.
  - It is available using the `alcsync-v1` application package.
  - Can be enabled using the Console by visiting the application settings and ticking the **Use Application Layer Clock Synchronization** checkbox. By default, the package will operate on FPort 202.
- Drop uplink frames with CRC failure.

### Deprecated

- Returning special float values, such as `NaN` and `Infinity` as part of the decoded payloads.
  - While the concepts of `NaN` and `Infinity` are part of JavaScript, JSON does not have a dedicated value for such values.
  - Historically we have rendered them in their string form, i.e. `"NaN"` and `"Infinity"`, but this form is not standard nor accepted by the standard libraries of most programming languages (at least by default).
  - Most usages of `NaN` are actually result of operations with the JavaScript concept of `undefined`, and are not intentional. Mathematical operations that interact with `undefined` return `NaN` - for example `undefined * 5` is `NaN`. It is not hard to reach `undefined` in JavaScript, as array access to undefined indices is `undefined`, and payload decoders generally work by consuming the frame payload bytes.
  - Future The Things Stack versions may not render such values, or may discard the decoded payload completely. The deprecation discussion can be tracked [on GitHub](https://github.com/TheThingsNetwork/lorawan-stack/issues/6128).

### Removed

- Automatic migrations of the Network Server database using `ns-db migrate` from versions prior to v3.24 are removed. Migrating from prior versions should be done through v3.24 instead.

## [3.24.2] - 2023-03-09

### Deprecated

- Device claiming that transfer devices between applications is now deprecated and will be removed in a future version of The Things Stack. Device claiming on Join Servers, including The Things Join Server, remains functional. This deprecates the following components:
  - API for managing application claim authorization (`EndDeviceClaimingServer.AuthorizeApplication` and `EndDeviceClaimingServer.UnauthorizeApplication`)
  - CLI commands to manage application claim settings (`ttn-lw-cli application claim [authorize|unauthorize]`)
  - CLI command to claim end devices (`ttn-lw-cli devices claim`)

### Fixed

- The CLI now continues deleting devices when unclaiming from the Join Server fails. This resembles the behavior in the Console. This no longer stops devices from being deleted if the Join Server is unavailable or the claim is not held.
- Organization API Keys' rights no longer are considered invalid during fetch operations. If the proper right is attached to said API key it is possible to fetch all fields of an entity, previous to this fix only public safe fields were fetchable.
- Fix Sentry issue related to the component requests in the Console.

## [3.24.1] - 2023-02-16

### Added

- Network Server ID (NSID) used for Backend Interfaces interoperability via the `ns.interop.id` and `dcs.edcs.ns-id` configuration options.
  - In the Network Server, `ns.interop.id` acts as a fallback value for `sender-ns-id` in Join Server interoperability configuration.

### Changed

- Key vault cache time-to-live for errors configuration option `key-vault.cache.error-ttl`. This defaults to `key-vault.cache.ttl`.

### Deprecated

- Device Claiming Server configuration option `dcs.edcs.network-server.home-ns-id`. Use `dcs.edcs.ns-id` instead.

### Fixed

- Key unwrap caching.
- Desired RX1 delay and desired beacon frequency not being possible to set for OTAA devices.

### Security

- Fix open redirect vulnerability for Console/Account App logins.

## [3.24.0] - 2023-02-02

### Added

- List of end-devices can now be sorted by `last_seen_at` field. Unseen devices will be shown last.
- End devices now contain `lora_alliance_profile_ids` field.
- Add `source` config option for TLS certificates in LoRaWAN Backend Interfaces interop client and The Things Join Server device claiming configuration. This value can be `file` (existing behavior) or `key-vault`.

### Changed

- `serial_number` field is now moved to the root of the end device structure. `vendor_id` and `vendor_profile_id` are now moved to the `lora_alliance_profile_ids`.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of added columns and views.

### Deprecated

- Configuring certificate authorities per LoRaWAN Backend Interfaces SenderID (`interop.sender-client-ca`) is now deprecated and support will be removed in a future version of The Things Stack.

### Removed

- The device version identifiers no longer have the `serial_number`, `vendor_id` and `vendor_profile_id` fields.

## [3.23.2] - 2023-01-18

### Changed

- Deletion of the last admin user or removal of its admin status via an update operation now returns an error.
- Do not allow to remove the collaborator of an entity if it is the last collaborator (in the Console).

### Fixed

- When searching for end-devices, specifying `last_seen_at` as the field in which the devices will be sorted by no longer returns an error.
- Errors during removal of collaborators the application collaborator form not being forwarded to the user in the Console.
- Importing devices via CSV no longer skips the first header column when BOM bytes are present.

## [3.23.1] - 2022-12-14

### Added

- List of end-devices can now be sorted by `last_seen_at` field. Unseen devices will be shown last.

### Fixed

- It is now allowed to set `0` for ping slot frequency and beacon frequency in the Network Layer Settings of the end device general settings in the Console.
- MAC parameters that have the `desired_` will be hidden from the end device general settings for multicast end devices in the Console.

## [3.23.0] - 2022-11-30

### Added

- The Things Join Server 2.0 (type `ttjsv2`) for claiming with Device Claiming Server.
- All Join Servers with a `/64` JoinEUI prefix are contacted concurrently with LoRaWAN Backend Interfaces interoperability. This should only be used with ambiguous JoinEUIs and when migrating Join Servers.

### Changed

- Gateway EUI is no longer unset when deleting a gateway, meaning it could be recovered if no other gateway claimed it. This requires a schema migration (`ttn-lw-stack is-db migrate`) because of the change in the database's `gateway_eui_index`.
- The new database driver is no longer specific to the Identity Server and is now activated using the `db.pgdriver` feature flag (instead of `is.pgdriver`).

### Removed

- The Things Join Server 1.0 (type `ttjs`) for claiming with Device Claiming Server. Use The Things Join Server 2.0 (type `ttjsv2`) instead.

### Fixed

- Devices with pending session and MAC state may now successfully be imported.
- Client creation with an organization API key will no longer send an email without user information to the admins. Instead, the API key name will be used and if that is empty the API key ID will be the default.
- Allow providing DevEUI for ABP end devices with a LoRaWAN specification lower or equal to 1.0.4 in the end device onboarding screen in the Console.
- Faulty field validation for byte payloads in the uplink payload formatter panel in the Console.
- `serial_number` field is now properly stored.

## [3.22.2] - 2022-11-10

### Added

- The `is.gormstore` experimental flag has been added. Swaps the underlying Identity Server store implementation if set to true.

### Changed

- Class B and C downlinks will no longer be automatically retried indefinitely if none of the gateways are available at the scheduling moment, and the downlink paths come from the last uplink.
  - This was already the behavior for downlinks which had their downlink path provided explicitly using the `class_b_c.gateways` field.
  - The downlinks will be evicted from the downlink queue and a downlink failure event will be generated. The failure event can be observed by the application using the `downlink_failed` message, which is available in all integrations.
- Event history and payload storage TTL has now 1% jitter.
- The underlying store implementation has been changed to be by default based on `bun` instead of `gorm`. The previous store implementation can be reactivated using the `is.gormstore` experimental flag.

### Removed

- The `is.bunstore` experimental flag has been removed.

### Fixed

- Do not require AppKey when skipping Join Server registration in end device onboarding in the Console.
- Fix auto generation of device ID when using DevEUI generator in the Console.
- Fix several device onboarding issues with ABP in the Console.
  - Do not ask for a JoinEUI.
  - Reinitialize form properly when switching between ABP and OTAA.
- Issue with pasting values into byte input at the wrong position in the Console.
- Issue with updating field masks in the webhook edit form in the Console.

## [3.22.1] - 2022-10-19

### Changed

- Option to ignore logs from selected gRPC methods now supports ignoring logs for selected errors on method.
  Examples:
  - `--grpc.log-ignore-methods="/ttn.lorawan.v3.GsNs/HandleUplink"`: log is skipped when no error occurs.
  - `--grpc.log-ignore-methods="/ttn.lorawan.v3.GsNs/HandleUplink:pkg/networkserver:duplicate_uplink;pkg/networkserver:device_not_found"`: log is skipped when either `pkg/networkserver:duplicate_uplink` or `pkg/networkserver:device_not_found` error occurs (but not on success).
  - `--grpc.log-ignore-methods="/ttn.lorawan.v3.GsNs/HandleUplink:;pkg/networkserver:duplicate_uplink"`: log is skipped on success or when `pkg/networkserver:duplicate_uplink` error occurs.
- The Gateway Server now takes into consideration the extra duty cycle checks present in the LoRa Basics Station forwarder. Previously the Gateway Server may accept the scheduling of downlinks which the packet forwarder would silently drop.
  - Note that in some rare cases in which the LoRa Basics Station duty cycle is stricter than the windowed approach used by The Things Stack, the scheduling will fail and this will be visible via `ns.down.data.schedule.fail` events. Note that this is actually a positive outcome - it allows the Network Server to schedule the downlink via another gateway, while previously the downlink would be scheduled but get silently dropped on the gateway.

## [3.22.0] - 2022-10-06

### Added

- Add more specific rights for OAuth clients.

### Changed

- The flow for adding end devices has been updated in the Console.
  - Device QR codes can now be scanned to speed up end device onboarding.
  - Claiming end devices from external Join Servers is now possible seemlessly from the same onboarding flow.
- LoRa coding rate now defined in `DataRate` instead of `Band`.
- The Network Server will now schedule a potentially empty downlink in order to stop end devices from sending sticky MAC commands.
- Factory preset frequencies may now be provided for bands with fixed channel plans, such as US915 or AU915. The factory preset frequencies are interpreted as the only channels which are enabled at boot time.
- `TxParamSetupReq` MAC command priority has been increased.
- `DevStatusReq` MAC command priority has been lowered.

### Removed

- Removed coding rate from `TxSettings` as it is now defined in `DataRate`.

### Fixed

- `--mac-settings.adr.mode.disabled`, `--mac-settings.adr.mode.dynamic` and `--mac-settings.adr.mode.static` flags of the `end-device update` command.
- Pagination in `sessions` and `access tokens` tables in the Console.
- `LinkADRReq` MAC command generation for LoRaWAN 1.0 and 1.0.1 end devices.
- `LinkADRReq` no longer attempts to enable channels which have not yet been negotiated with the end device.
- Downlink path selection for uplinks which are not LoRa modulated.
- Issues with byte inputs in the Console.
  - Pasting values into the input leading to issues in some cases.
  - Values being typed double on android phones.
- Console showing deleted collaborator after successful deletion in application collaborator list.
- Console crashing after deleting an organization.

## [3.21.2] - 2022-09-14

### Added

- New `ListBands` RPC on the `Configuration` service.
  - Added support to CLI. Available via the `end-devices list-bands` command.
- CLI support for listing PHY versions via the `end-devices list-phy-versions` CLI command.
- New `NetID` and `DeviceAddressPrefixes` RPC on the `NS` service.
  - Added support on CLI. Available via the `end-devices get-net-id` and `end-devices get-dev-addr-prefixes` commands.
- Support for loading end device template from Device Repository when importing devices using a CSV file.
- Experimental support for normalized payload.
- Support management of deleted users in the Console.
- Decoded payloads are now visible for downlinks in the Console.
- Support for dynamic ping slot frequencies, as used by the US915 and AU915 bands.
- Support for LoRa Basics Station beaconing.

### Changed

- Deprecated `attributes` from `GatewayAntenna` definition. While it was present in the API it was never stored in the database.
- Absolute time downlinks (such as class B ping slots or class C absolute time downlinks) are now using the native class B downlink API of LoRa Basics Station.
- Only gateways which are guaranteed to be GPS capable may now be used for absolute time downlinks. This ensures that gateways that have an unknown time source are not used for absolute time scheduling.
- The static ADR mode may now steer the end device to use custom data rates such as SF7BW250, FSK and LR-FHSS.
- The Console will try to resolve invalid state errors during login with an automatic refresh.
- Error details are now displayed in a modal instead of within the notification element in the Console.

### Removed

- Experimental support for `LoRa Basics Station` gateway GPS timestamps which use the wrong precision (milliseconds instead of microseconds). Please ensure that your gateway has been updated to the latest firmware.

### Fixed

- The Gateway Server scheduler no longer considers the absolute time of a downlink to be the time of arrival.
- The Network Server now correctly handles the command that may succeed a `LinkADRAns` response.
- LR-FHSS data rate matching.
- Console data rate rendering of non-LoRa modulations.

### Security

- End device network layer form crashing in some situations in the Console device general settings.
- End device overview crashing in some situations in the Console.
- Device import when using Join Server-only deployments.
- QRG can generate QR Codes without the claim authentication code.

## [3.21.1] - 2022-08-24

### Added

- New `SearchAccounts` RPC on the `EntityRegistrySearch` service.
- Prompt user to confirm navigation when changes have not been saved in the payload formatter form to prevent big change-drafts from getting lost.
- Event data pushed by webhooks can now be filtered with field masks.
  - Support for the field mask setup was added for both CLI and Console.

### Changed

- Gateway registration in the Console has been updated to simplify the onboarding experience.

### Fixed

- CLI command `end-device template create` no longer breaks when providing field mask values.
- Device repository services no longer require ApplicationID in its request URL.
- Importing ABP devices via the CSV format now correctly handles the missing session key ID.

## [3.21.0] - 2022-08-11

### Added

- Component selector for Join Server interoperability configuration. This allows administrators to declare separate Network Server and Application Server configuration for the same JoinEUI ranges in the same interoperability configuration. See [documentation](https://www.thethingsindustries.com/docs/reference/interop-repository/).
- `BatchGetGatewayConnectionStats` RPC to fetch Gateway Connection Stats for a batch of gateways.
- The ability to disable the downlink scheduling mechanism for individual end devices (`mac-settings.schedule-downlinks`).
  - This option is useful during a migration procedure in order to force the end device to join the new network. The Network Server will no longer schedule any data downlinks or MAC commands, and will stop answering potential join requests.
- A new implementation of the Identity Server storage layer. In v3.21.0 the new implementation is not yet used by default, but it can be enabled with the `is.bunstore` feature flag. A new database driver can be enabled with the `is.pgdriver` feature flag.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of added columns and views.
- Support for comma-separated (`,`) values in The Things Stack CSV file format for importing end devices.
- Support for the `RxParamSetup`, `RxTimingSetup`, `TxParamSetup`, and `DlChannel` sticky answer mechanism. The commands were supported previously, but subsequent sticky responses would cause the Network Server to drop the MAC command buffer in certain situations.

### Changed

- Deleted users are no longer included in primary email addresses uniqueness checks. This allows a user to create a new account which uses the email address of a deleted account.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) due to updated indices.
- The CLI settings fields `retry-config.enable_metadata` and `retry-config.default_timeout` have been renamed to `retry.enable-metadata` and `retry.default-timeout` for consistency reasons.
- Generated device ID based on a DevEUI from an imported CSV file is now prepended by `eui-`. This is consistent with generated device IDs by the Console.
- The Claim Authentication Code (CAC) field is stored in the Identity Server instead of the Join Server.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
  - CAC values stored currently in the Join Server should be migrated to the Identity Server. One method is to run the following CLI commands on each device with a CAC.
    - Read the current values using `ttn-lw-cli dev get <application-id> <device-id> --claim-authentication-code`. This will fetch the value stored in the Join Server as a fallback.
    - Write back the value read `ttn-lw-cli dev set <application-id> <device-id> --claim-authentication-code.valid_from [xxx] --claim-authentication-code.valid_to [xxx] --claim-authentication-code.value <xxx>`. This will by default write to the Identity Server.
    - Note that this requires a minimum CLI version of 3.21.0.
- Device Repository no longer uses the `ApplicationID` for validating requests. Authentication is still necessary, but the `ApplicationID` field has been deprecated in the Device Repository API.

### Fixed

- Console showing `404 Not Found` errors for pages containing user IDs in the path, when the user ID has a length of two.
- CLI no longer panics when deleting a device without JoinEUI, this scenario only occurred when deleting a device that uses ABP.
- Console crashing when navigating to certain Packet Broker network configuration pages.
- Packet Broker network pages becoming inaccessible until refreshing after a user navigates to a non-existing network.
- The batch update query for `EndDevice.LastSeenAt` field now specifies the data type of the placeholders.
  - This resolves an issue in the Console where `Last activity` values were inconsistent.

## [3.20.2] - 2022-07-20

### Added

- More fields were added to the csv end-device migration procedure. The details on which fields were added can be found [here](https://www.thethingsindustries.com/docs/getting-started/migrating/device-csv/).
- Authorization management in the Account app.
- Gateway remote address to gateway connection statistics.

### Fixed

- Encoding of DevAddr, EUI and similar fields in `text/event-stream` responses.
- GPS time leap second calculations taking a new leap second into consideration for 6th of July 2022.

## [3.20.1] - 2022-06-29

### Added

- Support inviting users in the Console.

### Changed

- In AS923 frequency plans, the Network Server will skip the RX1 window if the data rate is ambiguous.
  - This change occurs in old Regional Parameters versions in which the initial downlink dwell time setting of the end device is not specified. The end device may have the downlink dwell time setting either enabled or disabled, and due to this the data rate of the RX1 window is ambiguous.
  - This ambiguity exists until the Network Server is successful in negotiating the dwell time limitations using the TxParamSetupReq MAC command. This will occur automatically and does not require any external input.
  - If you already know the boot dwell time settings of your end device, you may provide them via the `--mac-settings.downlink-dwell-time` and `--mac-settings.uplink-dwell-time` MAC settings. This will ensure that RX1 transmissions are available from the first uplink of the session.

### Removed

- Sorting on associated rights in the API keys table.

### Fixed

- `last activity` not updating when an end device joins for the first time in the Console.
- A bug that would show the "Status count periodicity"-field in the Console as `200` when actually set to `0`.
- A bug causing map viewports to be set in odd locations when setting end device/gateway locations.
- Console crashing when sorting by associated rights in the API keys table.

## [3.20.0] - 2022-06-15

### Added

- OAuth client management in the account app.
- Support claim protection when claiming end devices on The Things Join Server.
- CLI commands `notifications list` and `notifications set-status` to manage user notifications.
- Support for class B and C downlink transmissions through multiple gateways simultaneously.

### Changed

- Entities are now fully validated when updated in the stores.
  - Previously only the updated paths where validated. This lead to situations in which a partial update could cause the entity as a whole to reach an invalid state.
- Application, gateway, end device and organization-tables in the Console are now sorted by creation time by default (newest first).
- Collaborator and API Key tables can now be sorted in the Console.
- The application table in the Console now shows the amount of end devices.
- The organizations table in the Console now shows the amount of collaborators.
- Table layouts for several entities have been improved on the Console.

### Fixed

- End devices running on MAC versions higher or equal to 1.1 showing network downlink frame counters instead of application downlink frame counters.
- Wrong representation of time values between midnight and 1am (eg. 24:04:11) in the Console in some cases.

## [3.19.2] - 2022-05-25

### Added

- Allow setting an expiry date for API keys in the Console
- New event type `gs.gateway.connection.stats` with connection statistics. A new event is sent at most every `gs.update-connection-stats-debounce-time` time and at least every `gs.update-connection-stats-interval` time.
- Button to export as JSON end device `mac-settings` and `mac-state` in the Console.
- Support for the `FOpts encryption, usage of FCntDwn` LoRaWAN 1.1 erratum.

### Changed

- Event type for `gs.up.receive` event to `GatewayUplinkMessage`.
- Default debounce time for updating connection stats in de Gateway Server (configuration setting `gs.update-connection-stats-debounce-time`) is now 30 seconds.
- Error code when importing CSV file with invalid LoRaWAN or Regional Parameters version.
- Emails sent by the Identity Server now also contain HTML versions.
  - For the images in these emails to work, an absolute `is.email.network.assets-base-url` (and optionally `is.email.network.branding-base-url`) needs to be set in configuration.
- Notification emails are now sent through the Notification Service of the Identity Server.
- "Last activity"-information in the Console is now sourced as a single aggregate from the Identity Server.
- End device overview in the Console.
  - Showing MAC/PHY versions and used frequency plan.
  - Hiding the entity description if not set.
  - Showing information of pending sessions.
  - Automatically updating session info (no refresh necessary to schedule downlinks after a device has joined).
  - Showing session start time.
- The Things Stack is now built with Go 1.18.
- Layout of webhook and Pub/Sub forms to improve UX.
- The Network Server Address used for End Device Claiming is fetched from the configuration instead of client input.

### Removed

- The ability to create custom email templates.

### Fixed

- Support `app_eui` as alias for `join_eui` in CSV file import, per documentation.
- End devices frame counts being displayed as `n/a` when event stream contained historical data message events.
- Gateway general settings (Basic settings) not saving changes in some cases.
- Contact info validation not possible when user is already logged in.
- CLI not allowing devices to be created or updated.
- End device creation no longer errors on missing application info rights.
- Missing success notification when successfully deleting an application in the Console.
- CLI create commands for applications, gateways and clients no longer have their decoded ID emptied when using the `--user-id` flag.
- Metric `ttn_lw_events_channel_dropped_total` not getting updated.
- Dropped events when calling the Stream RPC with a long tail.

### Security

- Security fix for an issue where the description and list of rights of arbitrary API keys could be retrieved by any logged-in user if the 24-bit random API key ID was known.

## [3.19.1] - 2022-05-04

### Changed

- Application Server now decodes downlink if a downlink decoder is present and binary payload is scheduled.

### Fixed

- End devices frame counts being displayed as `n/a` when event stream contained historical data message events.
- Gateway general settings (Basic settings) not saving changes in some cases.

## [3.19.0] - 2022-04-21

### Added

- Session management page in Account App.
- Status page references in the Console.
- Notification Service API that will allow users to receive notifications about their registered entities.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added tables.
- Add `network_server_address`, `application_server_address` and `join_server_address` to applications.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- New ADR settings API, which allows stronger control over the ADR algorithm.
  - The new settings fields can be found under `mac-settings.adr`, and are mutually exclusive with `use-adr` and `adr-margin`. The legacy settings need to be unset before the new API options may be used.
  - `mac-settings.adr.mode.disabled` completely disables the ADR algorithm.
  - `mac-settings.adr.mode.static.data-rate-index`, `mac-settings.adr.mode.static.nb-trans`, `mac-settings.adr.mode.static.tx-power-index` allow the user to provide static ADR parameters to be negotiated with the end device. These options persist over multiple sessions and do not require a session reset in order to be propagated to the current session.
  - `mac-settings.adr.mode.dynamic.min-data-rate-index` and `mac-settings.adr.mode.dynamic.max-data-rate-index` control the data rate index range which the Network Server will attempt to negotiate with the end device. Note that if the provided interval is disjoint with the available data rate indices, no negotiation will take place.
  - `mac-settings.adr.mode.dynamic.min-tx-power-index` and `mac-settings.adr.mode.dynamic.max-tx-power-index` have similar behavior, but for transmission power indices.
  - `mac-settings.adr.mode.dynamic.min-nb-trans` and `mac-settings.adr.mode.dynamic.max-nb-trans` have similar behavior, but for NbTrans.
  - `mac-settings.adr.mode.dynamic.margin` may be used to provide the margin of the ADR algorithm. It replaces the old `adr-margin` setting.
  - `use-adr` and `adr-margin` are still supported, but deprecated. Any future API usage should instead use the `mac-settings.adr` settings.
- Service to parse QR codes and return the data within.

### Changed

- Sortable tables are now sorted by default in the Console

### Fixed

- Console determining gateways as "Other cluster" even though using the same host if server addresses not matching exactly (e.g. due to using different host or scheme).
- Inconsistency in setting gateway's LNS Auth key in the Console.
- CLI no longer informs the user that is using the default JoinEUI when passing its value via flags.
- Generating device ID from a DevEUI when importing a CSV file.
- The `is-db migrate` command that failed when running on databases created by `v3.18`.
- Some error messages being displayed as `error:undefined:undefined` in the Console, e.g. in the live data view.
- Missing `query` flag on CLI search commands.

## [3.18.2] - 2022-03-29

### Added

- Support for importing end devices using a CSV file. See [documentation](https://www.thethingsindustries.com/docs/reference/data-formats/#csv) for the data format.
- Support claiming end devices in an external Join Server (ex: The Things Join Server).
- Support to fetch LoRaWAN end device profiles using numeric identifiers.

### Changed

- Replace `as.down.data.forward` to `as.down.data.receive` in default event filter, so that decrypted and decoded dowlink payload can be examined in the Console.

### Fixed

- Join-accept scheduling if it took more than ~1.2 seconds to process the device activation with default configuration. These slow device activations can be observed when using external Join Servers.
- Fix issues in the webhook forms causing webhooks to be created with all message types enabled and no way of deactivating message types.
- Fix validation issue in the webhook form not detecting message type paths with more than 64 characters.
- Fix "reactivate"-webhook button in the Console.
- Port returned by the LBS LNS discovery message if standard 80/443 ports are used.

## [3.18.1] - 2022-03-09

### Added

- Add HTTP basic authentication configuration to the webhooks form in the Console.
- Show repository formatter code in the payload formatter form in the Console and allow pasting the application and payload formatter code when using the JavaScript option.
- gRPC service to Gateway Configuration Server so that gateway configurations can be obtained via gRPC requests.
- The option to configure the Redis idle connection pool timeout, using the `redis.idle-timeout` setting.
- New RP002 regional parameters as options during device registration in the Console.
- Default gateway visibility configuration in Packet Broker agent in the Console.

### Changed

- The custom webhook option is now shown at the top of the list in the Console when adding new webhooks.
- Wording around webhook statuses to `Healthy`, `Requests failing` and `Pending`.
- The uplink event preview in the Console now shows the highest SNR.
- When scheduling downlink messages with decoded payload, the downlink queued event now contains the encoded, plain binary payload.
- When Application Server forwards downlink messages to Network Server, the event payload now contains the encrypted LoRaWAN `FRMPayload`.
- The Network Server will now match downlink acknowledgements on the `cache` redis cluster (previously the `general` cluster was used).
- Gateway Connection statistics updates are now debounced. The debounce period occurs before the statistics are stored, and can be configured using the `gs.update-connection-stats-debounce-time` setting (default 5 seconds).
- Payload formatter form layout in the Console.
- Event publication when the Redis backend is used may no longer block the hot path. Instead, the events are now asynchronously published, which may render their ordering to change.
  - The events are queued and published using the worker pool mechanism, under the `redis_events_transactions` pool.
  - The length of the queue used by the pool may be configured using the `events.redis.publish.queue-size` setting.
  - The maximum worker count used by the pool may be configured using the `events.redis.publish.max-workers` setting.

### Removed

- Ability to select the `Repository` payload formatter type for end devices that have no Device Repository association or have no associated repository payload formatter.

### Fixed

- Consistent ordering of entities with equal values for the sort field.
- Fix `xtime` sent to LBS gateways for Class C downlinks.

## [3.18.0] - 2022-02-23

### Added

- Retain at most 10 recent session keys in the Join Server. This avoids a slowly growing number of session keys in the Join Server's database.
  - This requires a database migration (`ttn-lw-stack js-db migrate`).
- Add TTL for gateway connection stats. Can be configured with the option `gs.connection-stats-ttl`.
- Add `query` field to search requests, allowing to search for a string in any of ID, Name, Description and EUI (for entities that have EUIs).
- Added fallback values for end device import in the Console.

### Changed

- The minimum required Redis version is now 6.2.
- Applications on other cluster will be hidden in Applications list in the Console.

### Deprecated

- Gateway Server setting `gs.update-connection-stats-debounce-time` is no longer valid.

### Fixed

- Webhook statuses being shown as pending regardless of their actual condition.
- Device activation flow with a LoRaWAN Backend Interfaces 1.1 capable Join Server.
  - Join Servers using Backend Interfaces 1.1 (protocol `BI1.1`) must be configured with a `sender-ns-id` containing the EUI of the Network Server.
- Fix `time.Duration` flags in CLI.
- Gateway Server will no longer leave permanent gateway connection stats data on the registry when crashing.

## [3.17.2] - 2022-01-30

### Added

- Add configurable storage limit to device's DevNonce in the JoinServer. Can be configured using the option `js.dev-nonce-limit`.
- Fix copy button in API key modal in the Console.
- Enable copying and format transformations of byte values in the event previews in the Console.
- Attribute `administrative_contact` on "gateway eui taken" error to help users resolve gateway EUI conflicts.
- Add retry capability for cli requests. Can be configured with the options found in `retry-config`, some of the configuration options are `retry-config.max` and `retry-config.default-timeout`.

### Changed

- Webhook maximum header value length extended to 4096 characters.
- Limited the end device event types that are included in application event streams to only application layer events, errors and warnings. Other end device events can still be received when subscribing to end device device events.
- Several small improvements to the styling, structuring and input logic of forms in the Console.

### Fixed

- CLI Completion and Documentation commands no longer try to make a server connection.
- When an end device has both `NwkKey` and `AppKey` provisioned in the Join Server, `NwkKey` is used for MIC and session key derivation when activating the device in LoRaWAN 1.0.x. This is per LoRaWAN 1.1 specification.
- Gateway Server will no longer report the gateways as being both connected and disconnected at the same time.

## [3.17.1] - 2022-01-12

### Changed

- Gateways are removed from the Packet Broker Mapper API when unsetting the location public setting. This is to remove gateways from the map. Previously, the location was still set, but it did not get updated.

### Fixed

- Rate limiting of cluster authenticated RPCs.
- CLI panic when setting end devices.

## [3.17.0] - 2022-01-07

### Added

- Support reading the Join Server's default JoinEUI and using this in the CLI for end device creation.
  - The Join Server has a new API `GetDefaultJoinEUI`.
  - The default JoinEUI can be configured on the Join Server using the option `--js.default-join-eui`.
- Filtering of end device frequency plans in end device forms based on band id in the Console.
- Showing automatically set entity locations in the Console.
- Applications, OAuth clients, gateways and organizations now have an `administrative_contact` and `technical_contact`.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.

### Deprecated

- The `contact_info` fields of applications, OAuth clients, gateways, organizations and users.

### Fixed

- CLI panic when getting devices.
- Application uplink processing serialization behavior in the Application Server.

## [3.16.2] - 2021-12-17

### Added

- User defined antenna gain for LBS gateways.
- Webhooks now have a health status associated with them. Webhooks that fail successively are now disabled for a period of time.
  - Failure in this context means that the HTTP endpoint returned a non-2xx status code.
  - A successful HTTP request will reset the failure counter.
  - The number of allowed successive failures and cooldown period can be configured using the `--as.webhooks.unhealthy-attempts-threshold` and `--as.webhooks.unhealthy-retry-interval` configuration options.
- Webhook enabled path validation in the Console.

### Changed

- Increased the maximum gRPC message size to 16MB.
- Gateways which have been deleted are now automatically disconnected by the Gateway Server.
- Mark off and hide and restrict access to end devices that are registered on a different cluster in the Console.
- Show more detailed last activity information inside tooltip info in the Console.
- Add a button to allow exporting the event log in the Console.

### Fixed

- Access to application payload formatters for users with `RIGHT_APPLICATION_SETTINGS_BASIC` right.
- End device mac settings handling in the Console.
- Uplink and downlink counters display on end device activity in the Console.
- Join settings handling in JS-only deployments in the Console.
- Configuring Packet Broker listed option when Packet Broker Agent is configured with a Packet Broker tenant API key.
- Contact info validation through the Account app.

## [3.16.1] - 2021-11-26

### Added

- Support for fine timestamps and frequency offsets sent by gateways with SX1303 concentrator using the legacy UDP protocol.
- Support for resetting end device session context and MAC state in the Console.
- The Content-Security-Policy header (that was previously behind the `webui.csp` feature flag) is now enabled by default.
- Default `Cache-Control: no-store` headers.
- `Cache-Control: public, max-age=604800, immutable` headers for hashed static files.
- Experimental support for BasicStation GPS timestamps which use the wrong precision (milliseconds instead of microseconds).
  - The Gateway Server will attempt to determine the correct GPS timestamp from the provided `gpstime` based on the time at which the upstream message has been received.
  - This workaround will be available until the related gateway vendors will release patches for this issue.
- Firmware version of The Things Kickstarter Gateway are written to the gateway attributes upon receiving a valid status message.
- Desired mac settings to end device general settings in the Console.
- Experimental support for Azure Blob Storage. Only authentication via Managed Identity is supported.

### Changed

- Gateway server disconnects LoRa Basics Station gateways that stop sending pongs to server pings. This does not apply to gateways that don't support pongs.
- The new plugin for reading/writing JSON in our API (that was previously behind the `jsonpb.jsonplugin` feature flag) is now enabled by default. All API responses should be equivalent, but in some cases object fields may be in a different order.

### Fixed

- The reported sub-band's `downlink_utilization` in gateway connection stats now represents the utilization of the available duty-cycle time.
- Missing fields when admins list non-owned entities.
- Using the correct timestamp when retreiving the "Last activity" data point for Gateways on initial page loads in the Console.
- Events reappearing in the end device data view after clearing them when navigating back and forth.

## [3.16.0] - 2021-11-12

### Added

- `ttn_lw_as_subscription_sets_publish_success_total` and `ttn_lw_as_subscription_sets_publish_failed_total` metrics to track the number of subscription set publish attempts.
- Application Server advanced distribution settings:
  - `as.distribution.global.individual.subscription-blocks` controls if the Application Server should block while publishing traffic to individual global subscribers (such as MQTT clients).
  - `as.distribution.global.individual.subscription-queue-size` controls how many uplinks the Application Server should buffer for an individual global subscriber. Note that when the buffer is full, the Application Server will drop the uplinks if `--as.distribution.global.individual.subscription-blocks` is not enabled. Use a negative value in order to disable the queue.
  - `as.distribution.local.broadcast.subscription-blocks` controls if the Application Server should block while publishing traffic to broadcast local subscribers (such as webhooks and application packages matching).
  - `as.distribution.local.broadcast.subscription-queue-size` controls how many uplinks the Application Server should buffer for an broadcast local subscriber. Has the same semantics as `--as.distribution.global.individual.subscription-queue-size`.
  - `as.distribution.local.individual.subscription-blocks` controls if the Application Server should block while publishing traffic to individual local subscribers (such as PubSub integrations).
  - `as.distribution.local.individual.subscription-queue-size` controls how many uplinks the Application Server should buffer for an individual local subscriber. Has the same semantics as `--as.distribution.global.individual.subscription-queue-size`.
- `ttn_lw_gs_txack_received_total`, `ttn_lw_gs_txack_forwarded_total` and `ttn_lw_gs_txack_dropped_total` metrics, which track the transmission acknowledgements from gateways.
- `gs.txack.receive`, `gs.txack.drop` and `gs.txack.forward` events, which track the transmission acknowledgements from gateways.
- `ttn-lw-stack as-db migrate` command to migrate the Application Server database. This command records the schema version and only performs migrations if on a newer version.
  - Use the `--force` flag to force perform migrations.
- Server-side event filtering with the `names` field.

### Changed

- Gateway Server default UDP worker count has been increased to 1024, from 16.
- Application Server webhooks and application packages default worker count has been increased to 1024, from 16.
- Application Server no longer sets the end device's `session.started_at` and `pending_session.started_at`. The session start time should be retrieved from the Network Server, per API specification.
  - This requires an Application Server database migration (`ttn-lw-stack as-db migrate`) to clear the `started_at` field in existing (pending) sessions.
- Console changing to server-side event filtering (used to be client-side).

### Removed

- The `ttn_lw_gs_status_failed_total`, `ttn_lw_gs_uplink_failed_total` metrics. `ttn_lw_gs_status_dropped_total` and `ttn_lw_gs_uplink_dropped_total` should be used instead, as they contain the failure cause.
- The `gs.status.fail` and `gs.up.fail` events. `gs.status.drop` and `gs.up.drop` should be used instead, as they contain the failure cause.
- The `data_rate_index` field in uplink message metadata. Observe the fully described data rate in the `data_rate` field instead.
- LoRaWAN data rate index reported to LoRa Cloud DMS.
- Dockerfile doesn't define environmental variables `TTN_LW_BLOB_LOCAL_DIRECTORY`, `TTN_LW_IS_DATABASE_URI` and `TTN_LW_REDIS_ADDRESS` anymore. They need to be set when running the container: please refer to `docker-compose.yml` for example values.
- `CockroachDB` from development tooling as well as config option within `docker-compose.yml`.
  - This also changes the default value of the `--is.database-uri` option, so it can connect to the development Postgres database by default.

### Fixed

- Handling of NaN values in our JSON API.
- Receiver metadata from more than one antenna is now available in messages received from Packet Broker.
- Unhelpful error message when aborting the OIDC Login in the Console.
- Parsing of multi-word description search queries.

## [3.15.3] - 2021-10-26

### Fixed

- Gateway disconnection when location updates from status messages are enabled.
- Table entries not allowing to be opened in new tabs in the Console.
- Right clicking on table entries navigating to respective entity in the Console.

## [3.15.2] - 2021-10-22

### Added

- `tls.cipher-suites` config option to specify used cipher suites.
- Support for enhanced security policies of Packet Broker services.
- Handling of MAC and PHY versions in end device forms based on selected frequency plan in the Console.
- Support for scheduling downlink messages as JSON in the Console.
- Support for Packet Broker authentication through LoRaWAN Backend Interfaces. This adds the following configuration options:
  - `interop.public-tls-address`: public address of the interop server. The audience in the incoming OAuth 2.0 token from Packet Broker is verified against this address to ensure that other networks cannot impersonate as Packet Broker;
  - `interop.packet-broker.enabled`: enable Packet Broker to authenticate;
  - `interop.packet-broker.token-issuer`: the issuer of the incoming OAuth 2.0 token from Packet Broker is verified against this value.
- Support for LoRaWAN Backend Interfaces in Identity Server to obtain an end device's NetID, tenant ID and Network Server address with the use of a vendor-specifc extension (`VSExtension`). This adds the following configuration options:
  - `is.network.net-id`: the NetID of the network. When running a Network Server, make sure that this is the same value as `ns.net-id`.
  - `is.network.tenant-id`: the Tenant ID in the host NetID. Leave blank if the NetID that you use is dedicated for this Identity Server.
- Configuration option `experimental.features` to enable experimental features.
- Tooltip descriptions for "Last activity" values (formerly "Last seen") and uplink/downlink counts in the Console.
- Status pulses being triggered by incoming data in the Console.
- Packet broker page crashing when networks with a NetID of `0` are present.
- Allowing to toggle visibility of sensitive values in text inputs in the Console.
- Webhook failed event.

### Changed

- Searching for entity IDs is now case insensitive.
- Renamed entitie's "Last seen" to "Last activity" in the Console.
- The database queries for determining the rights of users on entities have been rewritten to reduce the number of round-trips to the database.
- The default downlink path expiration timeout for UDP gateway connections has been increased to 90 seconds, and the default connection timeout has been increased to 3 minutes.
  - The original downlink path expiration timeout was based on the fact that the default `PULL_DATA` interval is 5 seconds. In practice we have observed that most gateways actually send a `PULL_DATA` message every 30 seconds instead in order to preserve data transfer costs.
- The default duration for storing (sparse) entity events has been increased to 24 hours.

### Removed

- Option to select targeted stack components during end device import in the Console.

### Fixed

- LoRaWAN Backend Interfaces 1.1 fields that were used in 1.0 (most notably `SenderNSID` and `ReceiverNSID`). Usage of `NSID` is now only supported with LoRaWAN Backend Interfaces 1.1 as specified.
- Connection status not being shown as toast notification.
- Registering and logging in users with 2 character user IDs in the Account App.
- Frequency plan display for the gateway overview page in the Console.
- Profile settings link not being present in the mobile menu in the Console.
- Calculation of "Last activity" values not using all available data in the Console.
- Layout jumps due to length of "Last activity" text.
- Invalid `session` handling in Network Layer settings form in the Console.

### Security

- Network Servers using LoRaWAN Backend Interfaces to interact with the Join Server can now provide a single Network Server address in the X.509 Common Name of the TLS client certificate (the old behavior) or multiple Network Server addresses in the X.509 DNS Subject Alternative Names (SANs). DNS names have precedence over an address in the Common Name.

## [3.15.1] - 2021-10-01

### Added

- Packet Broker gateway visibility management (default settings only). See `ttn-lw-cli packetbroker home-networks gateway-visibilities --help` for more information.

### Changed

- The Gateway Server worker pools may now drop workers if they are idle for too long.
- FPort = 0 uplinks are no longer decoded by the Application Server, and the Network Server no longer provides the frame payload to the Application Server for these messages.

### Fixed

- Emails to admins about requested OAuth clients.
- `session` handling for joined OTAA end devices in the Console.
- Empty Join Server address handling in end device creation form in the Console.
- Data Rate to data rate index matching for uplinks and downlinks.

## [3.15.0] - 2021-09-17

### Added

- RPC to query supported PHY versions for a given Band ID.
- Non-TLS LNS endpoint support.

### Changed

- Update to Go 1.17.
- LBS timestamp rollover threshold.
- Layout of error pages.
- The Application Server worker pools may now drop workers if they are idle for too long.
- Improved error page UX in the Console.

### Fixed

- Entity purge handling for non-admin users in the Console.
- URL field validation in webhook forms in the Console when value is not trimmed.
- Not rendering site header and footer for error pages in some situations.
- Not providing a copy button for error pages in some situations.
- Improved errors for invalid URLs.
- Limit length of search queries within tables in the Console to 50 to comply with API validation.
- External Join Server address handling in end device creation form in the Console.
- Updating `supports_class_b` field in the end device general settings page in the Console.

## [3.14.2] - 2021-08-27

### Added

- CLI warnings about insecure connections.
- CLI warnings about using the `--all` flag.
- Packet Broker network listed switch in the Console.
- Improved errors for invalid command-line flags.
- Validation of entity attributes in the Console, with regards to maximum length for keys and values.
- CLI command to decode raw LoRaWAN frames (`ttn-lw-cli lorawan decode`), useful for debugging purposes.
- Options to restore or purge deleted applications, gateways and organizations in the Console.
- Handling of default mac settings values when manually registering end devices in the Console.
- Add a new `class_b_c_downlink_interval` field that can be configured to set the minimum interval between a network initiated downlink (Class B & Class C) and an arbitrary downlink per device.
- Retrieve count of upstream messages from the Storage Integration by end device.
  - See the new `GetStoredApplicationUpCount` RPC.
  - See the new `ttn-lw-cli applications storage count` and `ttn-lw-cli end-devices storage count` CLI commands.

### Changed

- The Identity Server now returns a validation error when trying to update the EUIs of an end device.
- Network Server no longer accepts RX metadata from Packet Broker if the originating forwarder network equals the current Network Server (by NetID and cluster ID, based on`ns.net-id` and `ns.cluster-id` configuration). This avoids duplicate RX metadata as well as redundant downlink scheduling attempts through Packet Broker after the cluster's Gateway Server already failed to schedule.
- Usability of the end device import function in the Console.
  - Show a per-device report when errors occur.
  - More structural changes to the process to improve UX.

### Removed

- Packet Broker mutual TLS authentication; only OAuth 2.0 is supported now.
- `request_details` from errors in the Console.

### Fixed

- Generated CLI configuration for The Things Stack Community Edition.
- End device access with limited rights in the Console.
- Parsing of ID6 encoded EUIs from Basic Station gateways.
- Warnings about unknown fields when getting or searching for gateways.
- Internal Server Errors from `pkg/identityserver/store`.
- Console rendering blank pages in outdated browsers due to missing or incomplete internationalization API.
- Error in edit user form (Console) when submitting without making any changes.
- `description` field not being fetched in edit user form (admin only) in the Console.
- Ignore invalid configuration when printing configuration with `ttn-lw-cli config` or `ttn-lw-stack config`.
- Emails about API key changes.
- Avoid rendering blank pages in the Console for certain errors.
- Blank page crashes in the Console for certain browsers that do not fully support `Intl` API.
- End device session keys handling in the Console.
- Byte input width in Safari in the Console.

## [3.14.1] - 2021-08-06

### Added

- New config option `--as.packages.timeout` to control the message processing timeout of application packages.
- Option to view and copy error details in full view errors in the Console.
- Metrics for CUPS requests.
- Language chooser in the footer in the Console.
- Japanese language support in the Console.

### Changed

- Cache Root CA for client TLS configuration.
- Identity Server no longer allows removing the `_ALL` right from entity collaborators if that leaves the entity without any collaborator that has the `_ALL` right.
- The Network Server application uplink queue may now be skipped if the Application Server peer is available at enqueue time.
- The interval for updating gateways in Packet Broker is now 10 minutes (was 5 minutes) and the timeout is 5 seconds (was 2 seconds).

### Fixed

- Improved errors when ordering search requests by non-existent fields.
- LNS authentication key handling for gateways in the Console.

## [3.14.0] - 2021-07-23

### Added

- Gateway antenna placement; unknown, indoor or outdoor. This can now be specified with CLI, e.g. for the first antenna: `ttn-lw-cli gateways set <gateway-id> --antenna.index 0 --antenna.placement OUTDOOR`. The antenna placement will be reported to Packet Broker Mapper.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Payload formatter length validation in the Console.
- User session management (listing and deleting) in the Identity Server and the CLI.
- Improved logging for the OAuth server.
- LR-FHSS modulation
  - Additional fields for the Gateway and Rx Metadata API. This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
  - Support for LR-FHSS fields when translating uplink messages with the UDP protocol.
- Network Server now appends network identifiers in forwarded uplink messages. These are populated from the `ns.net-id` and the new `ns.cluster-id` configuration option.
  - See the new `uplink_message.network_identifiers.net_id`, `uplink_message.network_identifiers.cluster_id` and `uplink_message.network_identifiers.tenant_id` fields.
  - This can be useful for HTTP webhooks to determine the Network Server that received and forwarded an uplink message.
- `GetDefaultMACSettings` RPC for requesting the default and desired MAC settings for a Band (Frequency Plan) and LoRaWAN regional parameters version.
- Error handling for missing templates in device repository form in the Console.
- Opt out of Packet Broker for individual gateways, see the new `disable_packet_broker_forwarding` gateway option.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
  - This is only relevant when Packet Broker is enabled and configured by the network operator.
- Gateways are now disconnected when settings affecting the connection with Gateway Server change. Use the `gs.fetch-gateway-interval` and `gs.fetch-interval-jitter` to configure how often the gateway is fetched from the entity registry.
- Small UX improvements to the LoRaCloud DAS forms in the Console.
- End device first activation timestamp in the Identity Server end device store.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- `AppJs` interface for applications to get the LoRaWAN AppSKey directly from the Join Server.
- Console support for DevEUI generation from the configured DevEUI address block.
  - This requires `console.ui.dev-eui-issuing-enabled` and `console.ui.dev-eui-app-limit` to be set with the same values as in the Identity Server configuration.
- Gateway antenna placement selection in the Console.

### Changed

- When a gateway uplink message contains duplicate data uplinks, only the one with the highest RSSI are forwarded.
- The HTTP port now allows HTTP/2 connections over cleartext (h2c).
- `ttn-lw-stack ns-db migrate` command records the schema version and only performs migrations if on a newer version.
  - Use the `--force` flag to force perform migrations.
- Any authenticated user in the network can now list the collaborators of entities in the network.
- The search RPCs no longer require fields to be specified in the field mask when those fields are already specified as filters.
- When generating client configuration with the CLI `use` command, automatically set the correct Identity Server and OAuth Server addresses for The Things Stack Cloud and The Things Stack Community Edition.

### Removed

- The `old` log format.

### Fixed

- Network Server ADR algorithm data rate adjustment behavior on negative margin.
- CLI `gateway set --antenna.remove` command failing to remove gateway antennas in some cases.
- CLI `gateway set --antenna.gain <gain>` command crashing when no gateway antennas are present.
- Webhook template path variable expansion of query parameters.
- LBS LNS Auth Secret displays garbage value when updated.
- Transmit confirmation messages for LoRa Basics Station gateways.
- Instability and frequent crashes when internet connection is lost in the Console.
- Panic in GCS when CUPS rotation is set without a key.
- Rate limiting for `GatewayRegistry.GetGatewayIdentifiersForEUI` is now applied per gateway EUI.
- Network Server ensures that the Band ID in the end device version identifiers match the configured Frequency Plan of the device.

## [3.13.3] - 2021-07-02

### Added

- Email sent to admins when an OAuth client is requested by a non-admin user.
- Packet Broker UI in the Console (admin only).
- New config option `--console.oauth.cross-site-cookie` to control access to OAuth state cookie between origins.
  - This option needs to be set to `true` (default is `false`) in multi-cluster deployments in order to support OAuth clients that use POST callbacks.
- Application Server forwards upstream messages of type `ApplicationDownlinkSent` for application downlink messages that were acknowledged with a TxAck message from the gateway.
  - MQTT clients can subscribe to the topic `v3/{application-id}/devices/{device-id}/down/sent`.
  - For HTTP webhooks, make sure that the **Downlink Sent** messages are enabled.
- Query for the most recent application messages from the Storage Integration API with the new `last` parameter (for example, `?last=10m` or `?last=2h`). See also `--last` argument for the `ttn-lw-cli applications storage get` and `ttn-lw-cli end-devices storage get` commands.
- A location solved message is published automatically by Application Server when the decoded payload contains coordinates (e.g. `latitude` and `longitude`, among other combinations, as well as support for accuracy and altitude).
- Configuration option to include Packet Broker metadata in uplink messages: `pba.home-network.include-hops`. By default, this is now disabled.
- Update gateway identity, status, antennas, frequency plan, location and receive and transmit rates to Packet Broker Mapper. Mapping is enabled when the Forwarder role is enabled. The following new configuration options are introduced to change the default behavior:
  - `gs.packetbroker.update-gateway-interval`: Update gateway interval
  - `gs.packetbroker.update-gateway-jitter`: Jitter (fraction) to apply to the update interval to randomize intervals
  - `gs.packetbroker.online-ttl-margin`: Time to extend the online status before it expires
  - `pba.mapper-address`: Address of Packet Broker Mapper
  - `pba.forwarder.gateway-online-ttl`: Time-to-live of online status reported to Packet Broker

### Changed

- Low-level log messages from the `go-redis` library are printed only when the log level is set to `DEBUG`.
- GS will discard repeated gateway uplink messages (often received due to buggy gateway forwarder implementations). A gateway uplink is considered to be repeated when it has the same payload, frequency and antenna index as the last one.
  - The new `gs_uplink_repeated_total` metric counts how many repeated uplinks have been discarded.
  - A `gs.up.repeat` event is emitted (once per minute maximum) for gateways that are stuck in a loop and forward the same uplink message.
- For ABP sessions, the CLI now requests a DevAddr from the Network Server instead of generating one from the testing NetID.
- Descriptions, tooltips and defaults for checkboxes for public gateway status and location in the Console.
- All HTTP requests made by The Things Stack now contain a `User-Agent` header in the form of `TheThingsStack/{version}`.
- No connection to Packet Broker is being made when neither the Forwarder nor the Home Network role is enabled.
- Increase the default size limit for payload formatter scripts to 40KB (up from 4KB). The maximum size enforced at API level is 40KB (up from 16KB).
  - For more context see [issue #4053](https://github.com/TheThingsNetwork/lorawan-stack/issues/4053) and [issue #4278](https://github.com/TheThingsNetwork/lorawan-stack/issues/4278).

### Fixed

- Parse error in Webhook Templates.
- Application deletion handling in the Console.
- Error when logging into the Console when using connections without TLS.
- Account for antenna gain when the gateway is not authenticated (i.e. UDP gateway).
- Preserve antenna gain when the gateway status message contains GPS coordinates.
- Location map coordinate selection in the Console.
- Rights required for reading scheduled downlinks.

## [3.13.2] - 2021-06-17

### Added

- Configurable log formats with the `log.format` configuration option.
  - The `console` format that prints logs as more human-friendly text. This is the new default.
  - The `json` format that prints logs as JSON. This is the recommended format for production deployments.
  - The `old` format (deprecated). This can be used if you need to adapt your log analysis tooling before v3.14.
- `ttn_lw_gs_ns_uplink_latency_seconds`, `ttn_lw_ns_as_uplink_latency_seconds` and `ttn_lw_gtw_as_uplink_latency_seconds` metrics to track latency of uplink processing.
- Signing of releases.
- Hard delete option to delete applications, gateways and organizations in the Console.

### Changed

- Relaxed the cookie policy for cross-origin requests from Strict to Lax.
- Changed the cookie policy for OAuth state to None.

### Deprecated

- The `old` log format is deprecated and will be removed in v3.14.

### Fixed

- Permissions issue for reading and writing gateway secrets in the Console.
- Current and future rights selection for organization collaborators in the Console.
- Current and future rights selection for user api keys in the Console.
- Low or no throughput of message handling from Packet Broker when the ingress is high when Packet Broker Agent starts.
- Unset ADR bit in downlink messages to multicast devices.

## [3.13.1] - 2021-06-04

### Added

- More contextual tooltips to end device and gateway form fields in the Console.
- Warnings in the Console when changing or revoking your own access to an entity.

### Changed

- Do not print error line logs for rate limited gRPC and HTTP API requests.
- The `ttn_lw_log_log_messages_total` metric was renamed to `ttn_lw_log_messages_total` and has an additional `error_name` label.
- Authenticated users now have access to gateway status and location when those are set to public.
- Cookies are no longer allowed in cross-origin requests to the HTTP API. Applications must instead use Bearer tokens in the Authorization header.

### Fixed

- Downlink queue eviction on FCnt mismatch.
- End device payload formatter view crashing in the Console.
- End device overview frequently crashing in the Console.
- Panic on empty downlink in zero indexed downlink token.

## [3.13.0] - 2021-05-20

### Added

- Searching Packet Broker networks with `--tenant-id-contains` and `--name-contains` flags.
- Listing all listed Packet Broker networks with `ttn-lw-cli packetbroker networks list`.
- Include end device version identifiers in upstream messages (see `uplink_message.version_ids.brand_id`, `uplink_message.version_ids.model_id`, `uplink_message.version_ids.firmware_version`, `uplink_message.version_ids.hardware_version` and `uplink_message.version_ids.band_id` fields).
- Reporting uplink and downlink message delivery state changes to Packet Broker. This will be used for statistical purposes (e.g. which message is processed successfully or why it errored) as well as LoRaWAN roaming (the `XmitDataAns` result code).
- Setting API key expiry via `--api-key-expiry` flag using RFC3339 format.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Events storage in the Redis events backend. This can be enabled with the new `events.redis.store.enable` option. The new options `events.redis.store.ttl`, `events.redis.store.entity-ttl`, `events.redis.store.entity-count` and `events.redis.store.correlation-id-count` can be used to configure retention.
- RPC to find related events by correlation ID.
- CLI command `events find-related`.
- Support for loading Device Repository profiles from different vendors if specified. This allows reusing standard end device profiles from module makers and LoRaWAN end device stack vendors.
- Filtering out verbose events in the event views in the Console.
- The `gs.up.forward` event now includes the host an uplink was forwarded to.
- Previews for `*.update` events in the Console.
- The Console can now show recent historical events in networks that have events storage enabled.
- Add a new `mac_settings.desired_max_eirp` field that can be configured to set the desired MaxEIRP value per device.
- Support loading rate limiting profile configuration from external sources. When set, they will override embedded configuration. See `rate-limiting.config-source`, `rate-limiting.directory`, `rate-limiting.url` and `rate-limiting.blob.*` configuration options.
- `IssueDevEUI` RPC for requesting a DevEUI from a configured IEEE MAC block for devices per application.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added `eui_blocks` table and `dev_eui_counter`
    column in applications table.
  - This requires a new `dev-eui-block` configuration setting.

### Changed

- User IDs now have a minimum length of 2 instead of 3, so that more users coming from v2 can keep their username.
- Disabled device uplink simulation and downlink message sending when skipping payload crypto.
- The UpdateAPIKey RPCs now take a fieldmask.
- The Gateway Server no longer sends `gs.up.drop` event if the Network Server does not handle an uplink message, or if the uplink does not match the DevAddr prefix of an upstream.
- Maximum size for user-defined payload formatter scripts.
  - The default cap is at 4KB, see the new `as.formatters.max-parameter-length` config option.
  - A maximum cap of 16KB per script is set at the API level.
  - This only prevents setting large payload formatter scripts for new devices and applications; it does not remove payload formatters from existing applications and devices. Scripts sourced from the Device Repository are not affected. See [issue #4053](https://github.com/TheThingsNetwork/lorawan-stack/issues/4053) for more context on this change.
- LoRa Basics Station `router_config` message omits hardware specific fields.
- Showing "Last seen" information in end device tables (replacing "Created").

### Removed

- The `gs.status.forward` event.

### Fixed

- OAuth token exchange for OAuth clients that use Basic auth.
- The CLI now properly returns a non-zero exit status code on invalid commands.
- Gateway connection requests with zero EUI are rejected.
- End device payload formatter reset to `FORMATTER_NONE` in the Console.
- Memory issues when importing end devices in the Console.

## [3.12.3] - 2021-05-06

### Changed

- Optimized storage of recent application uplinks in Application Server.

### Fixed

- Validation of OAuth token exchange requests from the CLI.
- Validation of join-request types when using the Crypto Server backend.
- Application Server session recovery functionality for imported devices.
- Fetching AppSKey when the session is rebuilt but the identifier did not change.

## [3.12.2] - 2021-04-30

### Added

- Contextual tooltips to form fields in the Console.
- C-Style uint32_t representation for end device address field.
- Gateway Configuration Server to the cluster package.
  - This introduces a new config option `cluster.gateway-configuration-server` that needs to be set in multi-instance deployments.
- Uplink storage for integrations in the Application Server. The number of uplinks stored per end device may be configured via the config option `as.uplink-storage.limit`.
- LoRaCloud GLS multi frame request support.
- LoRaCloud GNSS request support.
- LoRaCloud WiFi request support.

### Changed

- Allow the LinkADRReq commands to lower the data rate used by the end devices.

### Fixed

- Occasional crashes in the ratelimit middleware.
- Handling of zero EUI CUPS update-info requests.
- Backend validation messages for some forms.
- Gateway downlink message previews not displaying correctly in the event view of the Console.
- Importing end devices from the Console would occasionally ignore some device MAC settings fields.

## [3.12.1] - 2021-04-15

### Added

- Payload formatter testing functionality in the Console.
- Options in the Identity Server to reject passwords that contain the user ID (`is.user-registration.password-requirements.reject-user-id`) or common passwords (`is.user-registration.password-requirements.reject-common`).

### Changed

- Network Server now takes uplink data rate index for ADR.
- Event streams are now closed when the callers rights are revoked.

### Fixed

- It is no longer possible to accidentally create API keys without any rights.
- Application overview page crashing for collaborators without certain rights.
- `mac_settings.factory_preset_frequencies` handling in US-like bands.

### Security

- This release fixes an issue that prevented some request messages from being validated correctly, allowing invalid values in certain fields.

## [3.12.0] - 2021-04-06

### Added

- API and CLI commands for listing, searching for and restoring recently deleted applications, OAuth clients, gateways, organizations and users.
- State Description fields for adding context to the (rejected, flagged, suspended) state of Users and OAuth clients.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Searching for gateways by EUI.
- Searching for users and OAuth clients by state.
- Gateway Server forwards Tx Acknowlegdment packets to the Network Server for scheduled downlinks. These can be used by the Network Server to forward `downlink_ack` upstream messages to the Application Server.
- UDP connection error caching. The duration can be configured via the `gs.udp.connection-error-expires` configuration entry.
- Option to require individual gateways to use authenticated connections.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Login Tokens (magic login links) that can be used for password-less login.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
  - This feature is disabled by default; use the new `is.login-tokens.enabled` option to enable it.
- Packet Broker registration, configuration of routing policies, listing home networks and viewing routing policies set by forwarding networks. See `ttn-lw-cli packetbroker --help` for more information.
- Support LoRa 2.4 GHz with Packet Broker.
- Include gateway identifiers from Packet Broker in metadata.
- Session and MAC state import functionality. This means that devices can be migrated without rejoin.
- Rate limiting for HTTP endpoints, gRPC endpoints, MQTT, UDP and WebSockets connections.
  - Rate limiting is disabled by default. Refer to the `rate-limiting` configuration entry to enable.
- Profile settings link to header dropdown menu.

### Changed

- Changed the pub/sub channels that the Redis backend of the Events system uses.
- Changed the encoding of events transported by the Redis backend of the Events system.
- All external HTTP calls are now using TLS client configuration. This fixes issues where HTTP calls would fail if custom (e.g. self-signed) CAs were used.
- All external HTTP calls are now using a default timeout. This fixes issues where HTTP calls would stall for a long time.
- All value wrappers now are encoded and decoded as the value being wrapped in JSON. That means, that, e.g. format of `mac_settings.rx1_delay` is changed from `{"value": 2}` to just `2`.
- Changed the error that is returned when attempting to validate already validated contact info.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added column.
- Update Go to 1.16
- Network Server now performs more strict validation and will disallow creation and updates of invalid devices.
- DevEUI is not required for multicast devices anymore, regarding of LoRaWAN version.

### Fixed

- Incorrect documentation url for event details data formats.
- Search functionality for applications, gateways and organizations in the Console.
- Error handling of end device template formats for the application overview page in the Console.
- Payload size limits for AU915 data rates 8 and 9, which are now consistent with Regional Parameters RP002-1.0.2.
- Payload size limit calculation in Network Server.
- Occasional panic in Network Server on downlink with corrupted device states.
- Occasional panic in Identity Server on extracting log fields from invalid requests.
- Print an error message stating that the Storage Integration is not available in the open source edition of The Things Stack when trying to execute `ttn-lw-stack storage-db` commands.

## [3.11.3] - 2021-03-19

### Added

- `sentry.environment` configuration option to set the `environment` tag on Sentry reports.
- TR005 QR code format, with ID `tr005`.
- LoRa Cloud Geolocation Services support for TOA/RSSI end device geolocation.

### Changed

- Default value of `gs.udp.addr-change-block` is now 0, which disables the IP firewall for UDP traffic. Deployments that need to enforce the IP check should set a value greater than 0. Note that the new default value makes UDP connections less secure.
- Prevent flooding logs with "Packet Filtered" messages when UDP gateways exceed the maximum rate limit. Only one message per minute will be printed for each gateway.

### Deprecated

- TR005 Draft 2 and 3 QR code formats. Use the final version of the technical recommendation, with ID `tr005`.

### Fixed

- Downlink queue operations on ABP devices not working under specific circumstances.
- NwkKey handling for end devices in the Console.

## [3.11.2] - 2021-03-05

### Added

- Pagination flags for the `users oauth authorizations list` and `users oauth access-tokens list` CLI commands.
- End device ID generation based on DevEUI in The LoRaWAN Device Repository creation form in the Console.
- `remote_ip` and `user_agent` metadata on OAuth events.
- `created_at` and `updated_at` fields to API Keys.
- Telemetry for Packet Broker Agent.
- User rights check for managing API keys in the Console.

### Changed

- `temp` field of the UDP stats message is now type `float32` (pointer).

### Fixed

- Ocassional race condition in uplink matching with replicated Network Server instances.
- Ocassional race condition when matching pending sessions.
- Conflict error when registering an end device via the wizard in the Console.
- Pagination in the `List` and `ListTokens` RPCs of the `OAuthAuthorizationRegistry`.
- Event name on user login.
- Application uplink queue handling in Network Server.
- Application Server session desynchronization with the Network Server. The Application Server will now attempt to synchronize the end device session view on downlink queue operational errors. This fixes the `f_cnt_too_low` and `unknown_session` errors reported on downlink queue push and replace.
- Panic while generating SX1301 config for frequency plans without radio configuration.

## [3.11.1] - 2021-02-18

### Added

- Profile settings view to the Account App.
  - Functionality to change basic profile information, such as name, email address and profile picture.
  - Functionality to update the account password.
  - Functionality to delete the account.

### Changed

- Improved logging.

### Fixed

- Synchronization in Gateway Server scheduler that caused race conditions in scheduling downlink traffic.

## [3.11.0] - 2021-02-10

### Added

- Reset functionality in Network Server, which resets session context and MAC state (see `ttn-lw-cli end-devices reset` command). For OTAA all data is wiped and device must rejoin, for ABP session keys, device address and downlink queue are preserved, while MAC state is reset.
- Store and retrieve Gateway Claim Authentication Code from database.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added column.
  - This uses the same encryption key set using the `is.gateways.encryption-key-id` configuration option.
- Improved handling of connection issues in the Console, as well as automatic reconnects.
- Helpful details for synthetic meta events in the data view of the Console.
- Support field mask paths in Storage Integration API requests.
- CUPS redirection.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Configuration option (`is.user-registration.enabled`) to enable or disable user registrations.
- Missing CLI commands for getting single API keys or collaborators for entities.
- New Account App for authentication, authorization and account related functionality.
  - This introduces various UX improvements and new designs around e.g. user login, registration and the "forgot password" flow.
- Integrate Device Repository.
- Device Repository component to integrate [Device Repository](https://github.com/TheThingsNetwork/lorawan-devices) with The Things Stack. See the `dr` configuration section.
  - The Device Repository database is bundled automatically into Docker release images. See the `ttn-lw-stack dr-db init` command to manually fetch the latest changes.
- Device repository service to the JavaScript SDK.
- Choosing array representation for end device session keys as well as gateway EUI.

### Changed

- Network Server does not store `recent_uplinks`, `recent_adr_uplinks` and `recent_downlinks` anymore.
- Improved Network Server downlink task performance.
- Improved Network Server matching performance.
- Network Server matching mapping in the database.
  - This requires a database migration (`ttn-lw-stack ns-db migrate`).
- Sending a non-empty implicitly specified field disallowed field will now cause RPCs to fail. E.g. if RPC supports paths `A` and `A.B`, sending value with `A.C` non-empty and field mask `A` would result in an error.
- Improved content of emails sent by the Identity Server.
- Stricter validation of the maximum length of string fields, binary fields, lists and maps.
- Frequency plans and webhook templates are now included in Docker images, and used by default, instead of fetching directly from GitHub.
- JavaScript entrypoints changed from `oauth.css` and `oauth.js` to `account.css` and `account.css`. Note: For deployments using custom frontend bundles (e.g. via `--is.oauth.ui.js-file`), the filenames have to be updated accordingly as well.

### Removed

- Application Server linking. The Network Server now pushes data to the cluster Application Server instead.
  - Applications which desire to handle payload decryption within their own domains should disable payload decryption at application or device level and decrypt the payload on their own end.
  - While not backwards compatible, the decision to remove linking was heavily motivated by scalability concerns - the previous linking model scales poorly when taking high availability and load balancing concerns into account.
- The option to disable CUPS per gateway `gcs.basic-station.require-explicit-enable`.

### Fixed

- Network Server DevStatusReq scheduling conditions in relation to frame counter value.
- Missing `authentication`, `remote_ip` and `user_agent` fields in events when using event backends other than `internal`.
- Handling of `DLChannelReq` if dependent `NewChannelReq` was previously rejected.
- Login after user registration leading to dead-end when originally coming from the Console.
- Frame counter display of end devices on initial page load in the Console.
- AU915-928 data rate indexes in Regional Parameter specification versions below 1.0.2b.

## [3.10.6] - 2021-01-12

### Added

- Configuration option `is.admin-rights.all` to grant admins all rights, including `_KEYS` and `_ALL`.
- Configuration option `is.user-registration.contact-info-validation.token-ttl` to customize the validity of contact information validation tokens.
- `ttn-lw-stack` CLI command for creating an API Key with full rights on a user.

### Changed

- Packet Broker API version to `v3.2.0-tts` and routing API to `v1.0.2-tts`.
- Emails with temporary tokens now also show when these tokens expire. Custom email templates can use `{{ .TTL }}` and `{{ .FormatTTL }}` to render the expiry durations.

### Deprecated

- Packet Broker mutual TLS authentication: use OAuth 2.0 client credentials instead; set `pba.authentication-mode` to `oauth2` and configure `pba.oauth2`.
- Packet Broker forwarder blacklist setting `pba.home-network.blacklist-forwarder` has become ineffective.

### Fixed

- Do not initiate new contact info validations when old validations are still pending.

## [3.10.5] - 2020-12-23

### Added

- Support for sending end device uplinks using the CLI (see `ttn-lw-cli simulate application-uplink` command).
- Clients can now perform custom ADR by modifying ADR parameters in `mac-state.desired-parameters` of the device.

### Changed

- Form field layouts in the Console (field labels are now dispayed above the field).
- Small structural changes to the custom webhook form in the Console.
- Renamed experimental command `ttn-lw-cli simulate uplink` to `ttn-lw-cli simulate gateway-uplink`.
- Renamed experimental command `ttn-lw-cli simulate join-request` to `ttn-lw-cli simulate gateway-join-request`.

### Fixed

- Removed misleading warning message for missing package data when setting up the storage integration package association.

## [3.10.4] - 2020-12-08

### Added

- Configure application activation settings from the CLI (see `ttn-lw-cli application activation-settings` commands).
- User API keys management to the Console.
- `Purge` RPC and cli command for entity purge (hard-delete) from the database.
- More password validation rules in the user management form in the Console.
- Support for class B end devices in the Console.
- MAC settings configuration when creating and editing end devices in the Console.
- Support for the LR1110 LTV stream protocol.

### Changed

- Branding (updated TTS Open Source logo, colors, etc).

### Fixed

- Simulated uplinks visibility in webhook messages.
- Retransmission handling.
- RTT recording for LBS gateways. The maximum round trip delay for RTT calculation is configurable via `--gs.basic-station.max-valid-round-trip-delay`.
- Memory leak in GS scheduler.

## [3.10.3] - 2020-12-02

### Added

- Configure application activation settings from the CLI (see `ttn-lw-cli application activation-settings` commands).

### Security

- Fixed an issue with authentication on the `/debug/pprof`, `/healthz` and `/metrics` endpoints.

## [3.10.2] - 2020-11-27

### Added

- gRPC middleware to extract proxy headers from trusted proxies. This adds a configuration `grpc.trusted-proxies` that is similar to the existing `http.trusted-proxies` option.

### Changed

- Log field consistency for HTTP and gRPC request logs.

### Fixed

- Uplink frame counter reset handling.
- Uplink retransmission handling in Network Server.
- DevAddr generation for NetID Type 3 and 4, according to errata.
- HTTP header propagation (such as Request ID) to gRPC services.

## [3.10.1] - 2020-11-19

### Added

- More password validation rules in the user management form in the Console.

### Changed

- Limitation of displayed and stored events in the Console to 2000.
- Application Server will unwrap the AppSKey if it can, even if skipping payload crypto is enabled. This is to avoid upstream applications to receive wrapped keys they cannot unwrap. For end-to-end encryption, configure Join Servers with wrap keys unknown to the Application Server.
- More precise payload labels for event previews in the Console.

### Fixed

- Next button title in the end device wizard in the Console.
- Navigation to the user edit page after creation in the Console.
- The port number of the `http.redirect-to-host` option was ignored when `http.redirect-to-tls` was used. This could lead to situations where the HTTPS server would always redirect to port 443, even if a different one was specified.
  - If the HTTPS server is available on `https://thethings.example.com:8443`, the following flags (or equivalent environment variables or configuration options) are required: `--http.redirect-to-tls --http.redirect-to-host=thethings.example.com:8443`.
- Status display on the error view in the Console.
- Event views in the Console freezing after receiving thousands of events.
- Wrong FPort value displayed for downlink attempt events in the Console.
- Network Server sending duplicate application downlink NACKs.
- Network Server now sends downlink NACK when it assumes confirmed downlink is lost.
- Network Server application uplink drainage.

## [3.10.0] - 2020-11-02

### Added

- Gateway Configuration Server endpoint to download UDP gateway configuration file.
  - In the Console this requires a new `console.ui.gcs.base-url` configuration option to be set.
- Support for sending end device uplinks in the Console.
- PHY version filtering based on LoRaWAN MAC in the Console.
- Meta information and status events in the event views in the Console.
- Support for setting the frame counter width of an end device in the Console.
- Include consumed airtime metadata in uplink messages and join requests (see `uplink_message.consumed_airtime` field).
- Add end device location metadata on forwarded uplink messages (see `uplink_message.locations` field).
- Store and retrieve LBS LNS Secrets from database.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added column.
  - To encrypt the secrets, set the new `is.gateways.encryption-key-id` configuration option.
- Storage Integration API.
- CLI support for Storage Integration (see `ttn-lw-cli end-devices storage` and `ttn-lw-cli applications storage` commands).
- Network Server does not retry rejected `NewChannelReq` data rate ranges or rejected `DLChannelReq` frequencies anymore.
- Functionality to allow admin users to list all organizations in the Console.
- Downlink count for end devices in the Console.
- Support for Application Activation Settings in the Join Server to configure Application Server KEK, ID and Home NetID.
- Downlink queue invalidated message sent upstream by Application Server to support applications to re-encrypt the downlink queue when Application Server skips FRMPayload crypto.
- Navigation to errored step in the end device wizard in the Console.
- Reference available glossary entries for form fields in the Console.

### Changed

- Decoded downlink payloads are now published as part of downlink attempt events.
- Decoded downlink payloads are stored now by Network Server.
- Raw downlink PHY payloads are not stored anymore by Network Server.
- Move documentation to [lorawan-stack-docs](https://github.com/TheThingsIndustries/lorawan-stack-docs).
- Improve LinkADRReq scheduling condition computation and, as a consequence, downlink task efficiency.
- CUPS Server only accepts The Things Stack API Key for token auth.
- Improve MQTT Pub/Sub task restart conditions and error propagation.
- Pausing event streams is not saving up arriving events during the pause anymore.
- Gateway server can now update the gateway location only if the gateway is authenticated.
- Right to manage links on Application Server is now `RIGHT_APPLICATION_SETTINGS_BASIC`.

### Removed

- Join EUI prefixes select on empty prefixes configuration in Join Server.

### Fixed

- Broken link to setting device location in the device map widget.
- Error events causing Console becoming unresponsive and crashing.
- Incorrect entity count in title sections in the Console.
- Incorrect event detail panel open/close behavior for some events in the Console.
- Improved error resilience and stability of the event views in the Console.
- RSSI metadata for MQTT gateways connected with The Things Network Stack V2 protocol.
- Gateway ID usage in upstream connection.
- Last seen counter for applications, end devices and gateways in the Console.
- `Use credentials` option being always checked in Pub/Sub edit form in the Console.
- FPending being set on downlinks, when LinkADRReq is required, but all available TxPower and data rate index combinations are rejected by the device.
- Coding rate for LoRa 2.4 GHz: it's now `4/8LI`.
- End device import in the Console crashing in Firefox.
- Creation of multicast end devices in the Console.
- Overwriting values in the end device wizard in the Console.
- Redirect loops when logging out of the Console if the Console OAuth client had no logout redirect URI(s) set.
- Event selection not working properly when the event stream is paused in the Console.

## [3.9.4] - 2020-09-23

### Changed

- Detail view of events in the Console moved to the side.
- Display the full event object when expanded in the Console (used to be `event.data` only).

### Fixed

- Performance issues of event views in the Console (freezing after some time).
- Gateway Server panic on upstream message handling.
- Incorrect redirects for restricted routes in the Console.
- Validation of MAC settings in the Network Server.
- Network Server panic when RX2 parameters cannot be computed.

## [3.9.3] - 2020-09-15

### Added

- Add `the-things-stack` device template converter, enabled by default. Effectively, this allows importing end devices from the Console.
- Support for binary decoding downlink messages previously encoded with Javascript or CayenneLPP.
- Common CA certificates available in documentation.
- Service data fields to pub/subs and webhooks in the Console.

### Changed

- MAC commands (both requests and responses) are now only scheduled in class A downlink slots in accordance to latest revisions to LoRaWAN specification.
- Scheduling failure events are now emitted on unsuccessful scheduling attempts.
- Default Javascript function signatures to `encodeDownlink()`, `decodeUplink()` and `decodeDownlink()`.
- Default Class B timeout is increased from 1 minute to 10 minutes as was originally intended.
- Update Go to 1.15
- Application, gateway, organization and end device title sections in the Console.
- Network Server downlink queues now have a capacity - by default maximum application downlink queue length is 10000 elements.
- Improve ADR algorithm loss rate computation.

### Deprecated

- Previous Javascript function signatures `Decoder()` and `Encoder()`, although they remain functional until further notice.

### Fixed

- ISM2400 RX2, beacon and ping slot frequencies are now consistent with latest LoRaWAN specification draft.
- CLI login issues when OAuth Server Address explicitly includes the `:443` HTTPS port.
- Documentation link for LoRa Cloud Device & Application Services in the Lora Cloud integration view in the Console.
- Webhooks and Pub/Subs forms in the Console will now let users choose whether they want to overwrite an existing record when the ID already exists (as opposed to overwriting by default).
- Pub/Sub integrations not backing off on internal connection failures.
- Network Server ping slot-related field validation.
- Memory usage of Network Server application uplink queues.
- Incorrect uplink FCnt display in end device title section.
- Service Data messages being routed incorrectly.

## [3.9.1] - 2020-08-19

### Added

- LoRaCloud DAS integration page in the Console.
- User Agent metadata on published events (when available).
- Option to override server name used in TLS handshake with cluster peers (`cluster.tls-server-name`).

### Changed

- Network Server now only publishes payload-related downlink events if scheduling succeeds.
- Moved remote IP event metadata outside authentication.
- Admins can now set the expiration time of temporary passwords of users.
- Application Server links are no longer canceled prematurely for special error codes. Longer back off times are used instead.

### Fixed

- Authentication metadata missing from published events.
- Under some circumstances, CLI would mistakenly import ABP devices as OTAA.
- Gateway Server could include the gateway antenna location on messages forwarded to the Network Server even if the gateway location was not public.

## [3.9.0] - 2020-08-06

### Added

- API Authentication and authorization via session cookie.
  - This requires a database schema migration (`ttn-lw-stack is-db migrate`) because of the added and modified columns.
  - This changes the `AuthInfo` API response.
- Skipping payload crypto on application-level via application link's `skip_payload_crypto` field.
- Authentication method, ID and Remote IP in events metadata.
- Service data messages published by integrations. Can be consumed using the bundled MQTT server, Webhooks or Pub/Sub integrations.
- Application package application-wide associations support.
- LoRaCloud DAS application package server URL overrides support.
- Key vault caching mechanism (see `--key-vault.cache.size` and `--key-vault.cache.ttl` options).
- Generic encryption/decryption to KeyVault.
- Option to ignore log messages for selected gRPC method on success (see `grpc.log-ignore-methods` option).
- CLI auto-completion support (automatically enabled for installable packages, also see `ttn-lw-cli complete` command).
- Options to disable profile picture and end device picture uploads (`is.profile-picture.disable-upload` and `is.end-device-picture.disable-upload`).
- Options to allow/deny non-admin users to create applications, gateways, etc. (the the `is.user-rights.*` options).
- Admins now receive emails about requested user accounts that need approval.
- Support for synchronizing gateway clocks via uplink tokens. UDP gateways may not connect to the same Gateway Server instance.
- Consistent command aliases for CLI commands.
- Laird gateway documentation.
- Option to allow unauthenticated Basic Station connections. Unset `gs.basic-station.allow-unauthenticated` to enforce auth check for production clusters. Please note that unauthenticated connections in existing connections will not be allowed unless this is set.
- Option to require TLS on connections to Redis servers (see `redis.tls.require` and related options).
- Documentation for `cache` options.
- Documentation for the Gateway Server MQTT protocol.
- Add user page in console.
- Troubleshooting guide.
- API to get configuration from the Identity Server (including user registration options and password requirements).
- Synchronize gateway time by uplink token on downstream in case the Gateway Server instance is not handling the upstream gateway connection.
- Work-around for Basic Station gateways sending uplink frames with no `xtime`.
- Document Network Server API Key requirement for Basic Station.

### Changed

- Remove version from hosted documentation paths.
- Gateway connection stats are now stored in a single key.
- The example configuration for deployments with custom certificates now also uses a CA certificate.
- Increase Network Server application uplink buffer queue size.
- `ttn-lw-cli use` command no longer adds default HTTP ports (80/443) to the OAuth Server address.
- Suppress the HTTP server logs from the standard library. This is intended to stop the false positive "unexpected EOF" error logs generated by health checks on the HTTPS ports (for API, BasicStation and Interop servers).
- Automatic collapse and expand of the sidebar navigation in the Console based on screen width.
- The header of the sidebar is now clickable in the Console.
- Overall layout and behavior of the sidebar in the Console improved.
- Improved layout and screen space utilization of event data views in the Console.
- Allow setting all default MAC settings of the Network Server. Support setting enum values using strings where applicable.

### Deprecated

- End device `skip_payload_crypto` field: it gets replaced by `skip_payload_crypto_override`.

### Fixed

- Inconsistent error message responses when retrieving connection stats from GS if the gateway is not connected.
- Empty form validation in the Console.
- CLI crash when listing application package default associations without providing an application ID.
- Decoding of uplinks with frame counters exceeding 16 bits in Application Server.
- Validation of keys for gateway metrics and version fields.
- Read only access for the gateway overview page in the Console.
- Fix an issue that frequently caused event data views crashing in the Console.
- Application Server contacting Join Server via interop for fetching the AppSKey.
- Low color contrast situations in the Console.
- Application Server pub/sub integrations race condition during shutdown.
- Console webhook templates empty headers error.
- Console MQTT URL validation.
- AFCntDown from the application-layer is respected when skipping application payload crypto.
- RTT usage for calculating downlink delta.
- Synchronize concentrator timestamp when uplink messages arrive out-of-order.

## [3.8.6] - 2020-07-10

### Added

- Payload formatter documentation.
- CLI support for setting message payload formatters from a local file. (see `--formatters.down-formatter-parameter-local-file` and `--formatters.up-formatter-parameter-local-file` options).

### Changed

- Gateway connection stats are now stored in a single key.

### Fixed

- Uplink frame counters being limited to 16 bits in Network Server.

## [3.8.5] - 2020-07-06

### Added

- Option to reset end device payload formatters in the Console.
- Service discovery using DNS SRV records for external Application Server linking.
- Functionality to set end device attributes in the Console.
- Event description tooltip to events in the Console.
- CLI support for setting and unsetting end device location (see `--location.latitude`, `--location.longitude`, `--location.altitude` and `--location.accuracy` options).
- Functionality to allow admin users to list all applications and gateways in the Console.
- Ursalink UG8X gateway documentation.
- Intercom, Google Analytics, and Emojicom feedback in documentation.
- LORIX One gateway documentation.
- Display own user name instead of ID in Console if possible.
- Option to hide rarely used fields in the Join Settings step (end device wizard) in the Console.

### Changed

- JSON uplink message doc edited for clarity.
- The CLI snap version uses the `$SNAP_USER_COMMON` directory for config by default, so that it is preserved between revisions.
- Defer events subscriptions until there is actual interest for events.
- End device creation form with wizard in the Console.

### Removed

- Requirement to specify `frequency_plan_id` when creating gateways in the Console.

### Fixed

- Endless authentication refresh loop in the Console in some rare situations.
- Logout operation not working properly in the Console in some rare situations.
- Handling API key deletion event for applications, gateways, organizations and users.
- Organization API key deletion in the Console.
- CLI now only sends relevant end device fields to Identity Server on create.
- Maximum ADR data rate index used in 1.0.2a and earlier versions of AU915 band.
- End device events stream restart in the Console.
- CLI was unable to read input from pipes.
- Timezones issue in claim authentication code form, causing time to reverse on submission.
- Errors during submit of the join settings for end devices in the Console.

## [3.8.4] - 2020-06-12

### Added

- Metrics for log messages, counted per level and namespace.
- Allow suppressing logs on HTTP requests for user-defined paths (see `--http.log-ignore-paths` option).
- Redux state and actions reporting to Sentry
- Serving frontend sourcemaps in production
- Frequency plan documentation.
- LoRa Basics Station documentation.

### Changed

- Suppress a few unexpected EOF errors, in order to reduce noise in the logs for health checks.

### Fixed

- Packet Broker Agent cluster ID is used as subscription group.
- LinkADR handling in 72-channel bands.
- Data uplink metrics reported by Application Server.

## [3.8.3] - 2020-06-05

### Added

- Favicon to documentation pages.
- Draft template for documentation.

### Changed

- Late scheduling algorithm; Gateway Server now takes the 90th percentile of at least the last 5 round-trip times of the last 30 minutes into account to determine whether there's enough time to send the downlink to the gateway. This was the highest round-trip time received while the gateway was connected.

### Fixed

- Downlink scheduling to gateways which had one observed round-trip time that was higher than the available time to schedule. In some occassions, this broke downlink at some point while the gateway was connected.

## [3.8.2] - 2020-06-03

### Added

- Console logout is now propagated to the OAuth provider.
  - This requires a database migration (`ttn-lw-stack is-db migrate`) because of the added columns.
  - To set the `logout-redirect-uris` for existing clients, the CLI client can be used, e.g.: `ttn-lw-cli clients update console --logout-redirect-uris "https://localhost:8885/console" --redirect-uris "http://localhost:1885/console"`.
- Packet Broker Agent to act as Forwarder and Home Network. See `pba` configuration section.
- JavaScript style guide to our `DEVELOPMENT.md` documentation.
- Schedule end device downlinks in the Console.
- Support for repeated `RekeyInd`. (happens when e.g. `RekeyConf` is lost)
- Validate the `DevAddr` when switching session as a result of receiving `RekeyInd`.
- Error details for failed events in the Console.
- `Unknown` and `Other cluster` connection statuses to the gateways table in the Console.
- LoRaWAN 2.4 GHz band `ISM2400`.
- Unset end device fields using the CLI (see `--unset` option)
- Join EUI and Dev EUI columns to the end device table in the Console.
- CLI creates user configuration directory if it does not exist when generating configuration file.
- Upgrading guide in docs.
- Glossary.
- Event details in the Console traffic view.
- Gateway Server events for uplink messages now contain end device identifiers.
- Setting custom gateway attributes in the Console.
- Pub/Sub documentation.
- Return informative well-known errors for standard network and context errors.
- Error notification in list views in the Console.
- Latest "last seen" info and uplink frame counts for end devices in the Console.
- Latest "last seen" info for applications in the Console.

### Changed

- Conformed JavaScript to new code style guide.
- Removed login page of the Console (now redirects straight to the OAuth login).
- Network Server now records `LinkADRReq` rejections and will not retry rejected values.
- Improved `NewChannelReq`, `DLChannelReq` and `LinkADRReq` efficiency.
- For frames carrying only MAC commands, Network Server now attempts to fit them in FOpts omitting FPort, if possible, and sends them in FRMPayload with FPort 0 as usual otherwise.
- Submit buttons are now always enabled in the Console, regardless of the form's validation state.
- Disabled ADR for `ISM2400` band.
- Network Server will attempt RX1 for devices with `Rx1Delay` of 1 second, if possible.
- Network Server will not attempt to schedule MAC-only frames in ping slots or RXC windows.
- Network Server will only attempt to schedule in a ping slot or RXC window after RX2 has passed.
- Network Server will schedule all time-bound network-initiated downlinks at most RX1 delay ahead of time.
- Network Server now uses its own internal clock in `DeviceTimeAns`.
- Troubleshooting section of `DEVELOPMENT.md`
- Change console field labels from `MAC version` and `PHY version` to `LoRaWAN version` and `Regional Parameters version` and add descriptions

### Fixed

- Handling of device unsetting the ADR bit in uplink, after ADR has been started.
- Invalid `oauth-server-address` in CLI config generated by `use` command when config file is already present.
- Network Server now properly handles FPort 0 data uplinks carrying FOpts.
- Data rate 4 in version `1.0.2-a` of AU915.
- Incorrect `TxOffset` values used by Network Server in some bands.
- OAuth authorization page crashing.
- Byte input in scheduling downlink view.
- OAuth client token exchange and refresh issues when using TLS with a RootCA.
- Join Server and Application Server device registries now return an error when deleting keys on `SET` operations. The operation was never supported and caused an error on `GET` instead.
- Clearing end device events list in the Console.
- Some views not being accessible in the OAuth app (e.g. update password).
- `LinkADRReq` scheduling.
- Unsetting NwkKey in Join Server.
- CSRF token validation issues preventing login and logout in some circumstances.
- Typo in Application Server configuration documentation (webhook downlink).
- Unset fields via CLI on Join Server, i.e. `--unset root-keys.nwk-key`.
- Reconnecting UDP gateways that were disconnected by a new gateway connection.
- ADR in US915-like bands.

## [3.7.2] - 2020-04-22

### Added

- CLI can now dump JSON encoded `grpc_payload` field for unary requests (see `--dump-requests` flag).
- Template ID column in the webhook table in the Console.
- Select all field mask paths in CLI get, list and search commands (see `--all` option).
- Create webhooks via webhook templates in the Console.
- `ns.up.data.receive` and `ns.up.join.receive` events, which are triggered when respective uplink is received and matched to a device by Network Server.
- `ns.up.data.forward` and `ns.up.join.accept.forward` events, which are triggered when respective message is forwarded from Network Server to Application Server.
- `ns.up.join.cluster.attempt` and `ns.up.join.interop.attempt` events, which are triggered when the join-request is sent to respective Join Server by the Network Server.
- `ns.up.join.cluster.success` and `ns.up.join.interop.success` events, which are triggered when Network Server's join-request is accepted by respective Join Server.
- `ns.up.join.cluster.fail` and `ns.up.join.interop.fail` events, which are triggered when Network Server's join-request to respective Join Server fails.
- `ns.up.data.process` and `ns.up.join.accept.process` events, which are triggered when respective message is successfully processed by Network Server.
- `ns.down.data.schedule.attempt` and `ns.down.join.schedule.attempt` events, which are triggered when Network Server attempts to schedule a respective downlink on Gateway Server.
- `ns.down.data.schedule.success` and `ns.down.join.schedule.success` events, which are triggered when Network Server successfully schedules a respective downlink on Gateway Server.
- `ns.down.data.schedule.fail` and `ns.down.join.schedule.fail` events, which are triggered when Network Server fails to schedule a respective downlink on Gateway Server.
- Specify gRPC port and OAuth server address when generating a CLI config file with `ttn-lw-cli use` (see `--grpc-port` and `--oauth-server-address` options).
- Guide to connect MikroTik Routerboard

### Changed

- Styling improvements to webhook and pubsub table in Console.
- Gateway location is updated even if no antenna locations had been previously set.
- Renamed `ns.application.begin_link` event to `ns.application.link.begin`.
- Renamed `ns.application.end_link` event to `ns.application.link.end`.
- `ns.up.data.drop` and `ns.up.join.drop` events are now triggered when respective uplink duplicate is dropped by Network Server.
- Network Server now drops FPort 0 data uplinks with non-empty FOpts.
- Frontend asset hashes are loaded dynamically from a manifest file instead of being built into the stack binary.
- Removed `Cache-Control` header for static files.
- Sort events by `time` in the Console.
- Restructure doc folder

### Removed

- `ns.up.merge_metadata` event.
- `ns.up.receive_duplicate` event.
- `ns.up.receive` event.

### Fixed

- End device claim display bug when claim dates not set.
- DeviceModeInd handling for LoRaWAN 1.1 devices.
- Do not perform unnecessary gateway location updates.
- Error display on failed end device import in the Console.
- Update password view not being accessible
- FOpts encryption and decryption for LoRaWAN 1.1 devices.
- Application Server returns an error when trying to delete a device that does not exist.
- Network Server returns an error when trying to delete a device that does not exist.
- Retrieve LNS Trust without LNS Credentials attribute.
- Too strict webhook base URL validation in the Console.
- Webhook and PubSub total count in the Console.
- DevEUI is set when creating ABP devices via CLI.
- CLI now shows all supported enum values for LoraWAN fields.
- Application Server does not crash when retrieving a webhook template that does not exist if no template repository has been configured.
- Application Server does not crash when listing webhook templates if no template repository has been configured.
- Error display on failed end device fetching in the Console.
- Various inconsistencies with Regional Parameters specifications.

## [3.7.0] - 2020-04-02

### Added

- Update gateway antenna location from incoming status message (see `update_location_from_status` gateway field and `--gs.update-gateway-location-debounce-time` option).
  - This requires a database migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Access Tokens are now linked to User Sessions.
  - This requires a database migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Edit application attributes in Application General Settings in the Console
- New `use` CLI command to automatically generate CLI configuration files.
- View/edit `update_location_from_status` gateway property using the Console.

### Changed

- Default DevStatus periodicity is increased, which means that, by default, DevStatusReq will be scheduled less often.
- Default class B and C timeouts are increased, which means that, by default, if the Network Server expects an uplink from the device after a downlink, it will wait longer before rescheduling the downlink.
- In case downlink frame carries MAC requests, Network Server will not force the downlink to be sent confirmed in class B and C.

### Fixed

- Fix organization collaborator view not being accessible in the Console.
- Error display on Data pages in the Console.
- Fix too restrictive MQTT client validation in PubSub form in the Console.
- Fix faulty display of device event stream data for end devices with the same ID in different applications.
- Trailing slashes handling in webhook paths.
- End device location display bug when deleting the location entry in the Console.
- GS could panic when gateway connection stats were updated while updating the registry.
- Local CLI and stack config files now properly override global config.
- Error display on failed end device deletion in the Console.

## [3.6.3] - 2020-03-30

### Fixed

- Limited throughput in upstream handlers in Gateway Server when one gateway's upstream handler is busy.

## [3.6.2] - 2020-03-19

### Fixed

- Entity events subscription release in the Console (Firefox).
- RekeyInd handling for LoRaWAN 1.1 devices.
- Network server deduplication Redis configuration.
- Change the date format in the Console to be unambiguous (`17 Mar, 2020`).
- Handling of uplink frame counters exceeding 65535.
- Gateway events subscription release in the Console.
- Panic when receiving a UDP `PUSH_DATA` frame from a gateway without payload.

### Security

- Admin users that are suspended can no longer create, view or delete other users.

## [3.6.1] - 2020-03-13

### Added

- New `list` and `request-validation` subcommands for the CLI's `contact-info` commands.
- Device Claim Authentication Code page in the Console.
- Gateway Server rate limiting support for the UDP frontend, see (`--gs.udp.rate-limiting` options).
- Uplink deduplication via Redis in Network Server.

### Changed

- Network and Application Servers now maintain application downlink queue per-session.
- Gateway Server skips setting up an upstream if the DevAddr prefixes to forward are empty.
- Gateway connection stats are now cached in Redis (see `--cache.service` and `--gs.update-connections-stats-debounce-time` options).

### Fixed

- Telemetry and events for gateway statuses.
- Handling of downlink frame counters exceeding 65535.
- Creating 1.0.4 ABP end devices via the Console.
- ADR uplink handling.
- Uplink retransmission handling.
- Synchronizing Basic Station concentrator time after reconnect or initial connect after long inactivity.

### Security

- Changing username and password to be not required in pubsub integration.

## [3.6.0] - 2020-02-27

### Added

- Class B support.
- WebSocket Ping-Pong support for Basic Station frontend in the Gateway Server.
- LoRaWAN 1.0.4 support.

### Changed

- Do not use `personal-files` plugin for Snap package.
- Network Server will never attempt RX1 for devices with `Rx1Delay` of 1 second.
- Improved efficiency of ADR MAC commands.
- Gateway Configuration Server will use the default WebSocket TLS port if none is set.

### Fixed

- End device events subscription release in the Console.
- Blocking UDP packet handling while the gateway was still connecting. Traffic is now dropped while the connection is in progress, so that traffic from already connected gateways keep flowing.
- Join-request transmission parameters.
- ADR in 72-channel regions.
- Payload length limits used by Network Server being too low.
- CLI ignores default config files that cannot be read.
- Device creation rollback potentially deleting existing device with same ID.
- Returned values not representing the effective state of the devices in Network Server when deprecated field paths are used.
- Downlink queue operations in Network Server for LoRaWAN 1.1 devices.

## [3.5.3] - 2020-02-14

### Added

- Display of error payloads in console event log.
- Zero coordinate handling in location form in the Console.

### Fixed

- Updating `supports_class_c` field in the Device General Settings Page in the Console.
- Updating MQTT pubsub configuration in the Console
- Handling multiple consequent updates of MQTT pubsub/webhook integrations in the Console.
- Displaying total device count in application overview section when using device search in the Console
- FQDN used for Backend Interfaces interoperability requests.
- Exposing device sensitive fields to unrelated stack components in the Console.
- CLI trying to read input while none available.
- Reconnections of gateways whose previous connection was not cleaned up properly. New connections from the same gateway now actively disconnects existing connections.
- `ttn-lw-stack` and `ttn-lw-cli` file permission errors when installed using snap.
  - You may need to run `sudo snap connect ttn-lw-stack:personal-files`
- Changing username and password to be not required in pubsub integration

## [3.5.2] - 2020-02-06

### Fixed

- Channel mask encoding in LinkADR MAC command.
- Frequency plan validation in Network Server on device update.
- Authentication of Basic Station gateways.

## [3.5.1] - 2020-01-29

### Added

- Responsive side navigation (inside entity views) to the Console.
- Overall responsiveness of the Console.
- Support for configuring Redis connection pool sizes with `redis.pool-size` options.

### Fixed

- Crashes on Gateway Server start when traffic flow started while The Things Stack was still starting.
- Not detecting session change in Application Server when interop Join Server did not provide a `SessionKeyID`.

## [3.5.0] - 2020-01-24

### Added

- Support for releasing gateway EUI after deletion.
- Support in the Application Server for the `X-Downlink-Apikey`, `X-Downlink-Push` and `X-Downlink-Replace` webhook headers. They allow webhook integrations to determine which endpoints to use for downlink queue operations.
- `as.webhooks.downlinks.public-address` and `as.webhooks.downlinks.public-tls-address` configuration options to the Application Server.
- Support for adjusting the time that the Gateway Server schedules class C messages in advance per gateway.
  - This requires a database migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- `end-devices use-external-join-server` CLI subcommand, which disassociates and deletes the device from Join Server.
- `mac_settings.beacon_frequency` end device field, which defines the default frequency of class B beacon in Hz.
- `mac_settings.desired_beacon_frequency` end device field, which defines the desired frequency of class B beacon in Hz that will be configured via MAC commands.
- `mac_settings.desired_ping_slot_data_rate_index` end device field, which defines the desired data rate index of the class B ping slot that will be configured via MAC commands.
- `mac_settings.desired_ping_slot_frequency` end device field, which defines the desired frequency of the class B ping slot that will be configured via MAC commands.
- Mobile navigation menu to the Console.
- View and edit all Gateway settings from the Console.
- `skip_payload_crypto` end device field, which makes the Application Server skip decryption of uplink payloads and encryption of downlink payloads.
- `app_s_key` and `last_a_f_cnt_down` uplink message fields, which are set if the `skip_payload_crypto` end device field is true.
- Support multiple frequency plans for a Gateway.
- Entity search by ID in the Console.

### Changed

- `resets_join_nonces` now applies to pre-1.1 devices as well as 1.1+ devices.
- Empty (`0x0000000000000000`) JoinEUIs are now allowed.

### Fixed

- Respect stack components on different hosts when connected to event sources in the Console.
- Pagination of search results.
- Handling OTAA devices registered on an external Join Server in the Console.
- RxMetadata Location field from Gateway Server.
- Channel mask encoding in LinkADR MAC command.
- Device location and payload formatter form submits in the Console.
- Events processing in the JS SDK.
- Application Server frontends getting stuck after their associated link is closed.

## [3.4.2] - 2020-01-08

### Added

- Forwarding of backend warnings to the Console.
- Auth Info service to the JavaScript SDK.
- Subscribable events to the JavaScript SDK.
- Include `gateway_ID` field in Semtech UDP configuration response from Gateway Configuration Server.
- Sorting feature to entity tables in the Console.

### Changed

- Increase time that class C messages are scheduled in advance from 300 to 500 ms to support higher latency gateway backhauls.

### Fixed

- Fix selection of pseudo wildcard rights being possible (leading to crash) in the Console even when such right cannot be granted.
- Fix loading spinner being stuck infinitely in gateway / application / organization overview when some rights aren't granted to the collaborator.
- Fix deadlock of application add form in the Console when the submit results in an error.
- Fix ttn-lw-cli sometimes refusing to update Gateway EUI.

## [3.4.1] - 2019-12-30

### Added

- Support for ordering in `List` RPCs.
- Detect existing Basic Station time epoch when the gateway was already running long before it (re)connected to the Gateway Server.

### Changed

- Reduce the downlink path expiry window to 15 seconds, i.e. typically missing three `PULL_DATA` frames.
- Reduce the connection expiry window to 1 minute.
- Reduce default UDP address block time from 5 minutes to 1 minute. This allows for faster reconnecting if the gateway changes IP address. The downlink path and connection now expire before the UDP source address is released.

### Fixed

- Fix class A downlink scheduling when an uplink message has been received between the triggering uplink message.

## [3.4.0] - 2019-12-24

### Added

- Downlink queue operation topics in the PubSub integrations can now be configured using the Console.
- `List` RPC in the user registry and related messages.
- User management for admins in the Console.
- `users list` command in the CLI.
- Support for getting Kerlink CPF configurations from Gateway Configuration Server.
- Support for Microchip ATECC608A-TNGLORA-C manifest files in device template conversion.

### Fixed

- Fix the PubSub integration edit page in the Console.
- Fix updating and setting of webhook headers in the Console.
- Fix DevNonce checks for LoRaWAN 1.0.3.

## [3.3.2] - 2019-12-04

### Added

- Support for selecting gateways when queueing downlinks via CLI (see `class-b-c.gateways` option).
- Options `is.oauth.ui.branding-base-url` and `console.ui.branding-base-url` that can be used to customize the branding (logos) of the web UI.
- Email templates can now also be loaded from blob buckets.
- Support for pagination in search APIs.
- Search is now also available to non-admin users.
- Support for searching end devices within an application.
- Notification during login informing users of unapproved user accounts.
- Support maximum EIRP value from frequency plans sub-bands.
- Support duty-cycle value from frequency plans sub-bands.

### Changed

- Allow enqueuing class B/C downlinks regardless of active device class.

### Fixed

- Fix crashing of organization collaborator edit page.
- Avoid validating existing queue on application downlink pushes.
- Correct `AU_915_928` maximum EIRP value to 30 dBm in 915.0 – 928.0 MHz (was 16.15 dBm).
- Correct `US_902_928` maximum EIRP value to 23.15 dBm in 902.3 – 914.9 MHz (was 32.15 dBm) and 28.15 dBm in 923.3 – 927.5 MHz (was 32.15 dBm). This aligns with US915 Hybrid Mode.
- Correct `AS_923` maximum EIRP value to 16 dBm in 923.0 – 923.5 MHz (was 16.15 dBm).

### Security

- Keep session keys separate by `JoinEUI` to avoid conditions where session keys are retrieved only by `DevEUI` and the session key identifier. This breaks retrieving session keys of devices that have been activated on a deployment running a previous version. Since the Application Server instances are currently in-cluster, there is no need for an Application Server to retrieve the `AppSKey` from the Join Server, making this breaking change ineffective.

## [3.3.1] - 2019-11-26

### Added

- Add support for Redis Sentinel (see `redis.failover.enable`, `redis.failover.master-name`, `redis.failover.addresses` options).

### Fixed

- Fix `AppKey` decryption in Join Server.

## [3.3.0] - 2019-11-25

### Added

- Add support for encrypting device keys at rest (see `as.device-kek-label`, `js.device-kek-label` and `ns.device-kek-label` options).
- The Network Server now provides the timestamp at which it received join-accept or data uplink messages.
- Add more details to logs that contain errors.
- Support for end device pictures in the Identity Server.
  - This requires a database migration (`ttn-lw-stack is-db migrate`) because of the added columns.
- Support for end device pictures in the CLI.

### Fixed

- Fix an issue causing unexpected behavior surrounding login, logout and token management in the Console.
- Fix an issue causing the application link page of the Console to load infinitely.

## [3.2.6] - 2019-11-18

### Fixed

- Fix active application link count being limited to 10 per CPU.
- The Application Server now fills the timestamp at which it has received uplinks from the Network Server.

## [3.2.5] - 2019-11-15

### Added

- Support for creating applications and gateway with an organization as the initial owner in the Console.
- Hide views and features in the Console that the user and stack configuration does not meet the necessary requirements for.
- Full range of Join EUI prefixes in the Console.
- Support specifying the source of interoperability server client CA configuration (see `interop.sender-client-ca.source` and related fields).

### Changed

- Reading and writing of session keys in Application and Network server registries now require device key read and write rights respectively.
- Implement redesign of entity overview title sections to improve visual consistency.

### Deprecated

- `--interop.sender-client-cas` in favor of `--interop.sender-client-ca` sub-fields in the stack.

### Fixed

- Fix gateway API key forms being broken in the Console.
- Fix MAC command handling in retransmissions.
- Fix multicast device creation issues.
- Fix device key unwrapping.
- Fix setting gateway locations in the Console.

## [3.2.4] - 2019-11-04

### Added

- Support LoRa Alliance TR005 Draft 3 QR code format.
- Connection indicators in Console's gateway list.
- TLS support for application link in the Console.
- Embedded documentation served at `/assets/doc`.

### Fixed

- Fix device creation rollback potentially deleting existing device with same ID.
- Fix missing transport credentials when using external NS linking.

## [3.2.3] - 2019-10-24

### Added

- Emails when the state of a user or OAuth client changes.
- Option to generate claim authentication codes for devices automatically.
- User invitations can now be sent and redeemed.
- Support for creating organization API keys in the Console.
- Support for deleting organization API keys in the Console.
- Support for editing organization API keys in the Console.
- Support for listing organization API keys in the Console.
- Support for managing organization API keys and rights in the JS SDK.
- Support for removing organization collaborators in the Console.
- Support for editing organization collaborators in the Console.
- Support for listing organization collaborators in the Console.
- Support for managing organization collaborators and rights in the JS SDK.
- MQTT integrations page in the Console.

### Changed

- Rename "bulk device creation" to "import devices".
- Move device import button to the end device tables (and adapt routing accordingly).
- Improve downlink performance.

### Fixed

- Fix issues with device bulk creation in Join Server.
- Fix device import not setting component hosts automatically.
- Fix NewChannelReq scheduling condition.
- Fix publishing events for generated MAC commands.
- Fix saving changes to device general settings in the Console.

## [3.2.2] - 2019-10-14

### Added

- Initial API and CLI support for LoRaWAN application packages and application package associations.
- New documentation design.
- Support for ACME v2.

### Deprecated

- Deprecate the `tls.acme.enable` setting. To use ACME, set `tls.source` to `acme`.

### Fixed

- Fix giving priority to ACME settings to remain backward compatible with configuration for `v3.2.0` and older.

## [3.2.1] - 2019-10-11

### Added

- `support-link` URI config to the Console to show a "Get Support" button.
- Option to explicitly enable TLS for linking of an Application Server on an external Network Server.
- Service to list QR code formats and generate QR codes in PNG format.
- Status message forwarding functions to upstream host/s.
- Support for authorizing device claiming on application level through CLI. See `ttn-lw-cli application claim authorize --help` for more information.
- Support for claiming end devices through CLI. See `ttn-lw-cli end-device claim --help` for more information.
- Support for converting Microchip ATECC608A-TNGLORA manifest files to device templates.
- Support for Crypto Servers that do not expose device root keys.
- Support for generating QR codes for claiming. See `ttn-lw-cli end-device generate-qr --help` for more information.
- Support for storage of frequency plans, device repository and interoperability configurations in AWS S3 buckets or GCP blobs.

### Changed

- Enable the V2 MQTT gateway listener by default on ports 1881/8881.
- Improve handling of API-Key and Collaborator rights in the console.

### Fixed

- Fix bug with logout sometimes not working in the console.
- Fix not respecting `RootCA` and `InsecureSkipVerify` TLS settings when ACME was configured for requesting TLS certificates.
- Fix reading configuration from current, home and XDG directories.

## [3.2.0] - 2019-09-30

### Added

- A map to the overview pages of end devices and gateways.
- API to retrieve MQTT configurations for applications and gateways.
- Application Server PubSub integrations events.
- `mac_settings.desired_max_duty_cycle`, `mac_settings.desired_adr_ack_delay_exponent` and `mac_settings.desired_adr_ack_limit_exponent` device flags.
- PubSub integrations to the console.
- PubSub service to JavaScript SDK.
- Support for updating `mac_state.desired_parameters`.
- `--tls.insecure-skip-verify` to skip certificate chain verification (insecure; for development only).

### Changed

- Change the way API key rights are handled in the `UpdateAPIKey` rpc for Applications, Gateways, Users and Organizations. Users can revoke or add rights to api keys as long as they have these rights.
- Change the way collaborator rights are handled in the `SetCollaborator` rpc for Applications, Gateways, Clients and Organizations. Collaborators can revoke or add rights to other collaborators as long as they have these rights.
- Extend device form in the Console to allow creating OTAA devices without root keys.
- Improve confirmed downlink operation.
- Improve gateway connection status indicators in Console.
- Upgrade Gateway Configuration Server to a first-class cluster role.

### Fixed

- Fix downlink length computation in the Network Server.
- Fix implementation of CUPS update-info endpoint.
- Fix missing CLI in `deb`, `rpm` and Snapcraft packages.

## [3.1.2] - 2019-09-05

### Added

- `http.redirect-to-host` config to redirect all HTTP(S) requests to the same host.
- `http.redirect-to-tls` config to redirect HTTP requests to HTTPS.
- Organization Create page in the Console.
- Organization Data page to the console.
- Organization General Settings page to the console.
- Organization List page.
- Organization Overview page to the console.
- Organizations service to the JS SDK.
- `create` method in the Organization service in the JS SDK.
- `deleteById` method to the Organization service in the JS SDK.
- `getAll` method to the Organizations service.
- `getAll` method to the Organization service in the JS SDK.
- `getById` method to the Organization service in the JS SDK.
- `openStream` method to the Organization service in the JS SDK.
- `updateById` method to the Organization service in the JS SDK.

### Changed

- Improve compatibility with various Class C devices.

### Fixed

- Fix root-relative OAuth flows for the console.

## [3.1.1] - 2019-08-30

### Added

- `--tls.acme.default-host` flag to set a default (fallback) host for connecting clients that do not use TLS-SNI.
- AS-ID to validate the Application Server with through the Common Name of the X.509 Distinguished Name of the TLS client certificate. If unspecified, the Join Server uses the host name from the address.
- Defaults to `ttn-lw-cli clients create` and `ttn-lw-cli users create`.
- KEK labels for Network Server and Application Server to use to wrap session keys by the Join Server. If unspecified, the Join Server uses a KEK label from the address, if present in the key vault.
- MQTT PubSub support in the Application Server. See `ttn-lw-cli app pubsub set --help` for more details.
- Support for external email templates in the Identity Server.
- Support for Join-Server interoperability via Backend Interfaces specification protocol.
- The `generateDevAddress` method in the `Ns` service.
- The `Js` service to the JS SDK.
- The `listJoinEUIPrefixes` method in the `Js` service.
- The `Ns` service to the JS SDK.
- The new The Things Stack branding.
- Web interface for changing password.
- Web interface for requesting temporary password.

### Changed

- Allow admins to create temporary passwords for users.
- CLI-only brew tap formula is now available as `TheThingsNetwork/lorawan-stack/ttn-lw-cli`.
- Improve error handling in OAuth flow.
- Improve getting started guide for a deployment of The Things Stack.
- Optimize the way the Identity Server determines memberships and rights.

### Deprecated

- `--nats-server-url` in favor of `--nats.server-url` in the PubSub CLI support.

### Removed

- `ids.dev_addr` from allowed field masks for `/ttn.lorawan.v3.NsEndDeviceRegistry/Set`.
- Auth from CLI's `forgot-password` command and made it optional on `update-password` command.
- Breadcrumbs from Overview, Application and Gateway top-level views.

### Fixed

- Fix `grants` and `rights` flags of `ttn-lw-cli clients create`.
- Fix a bug that resulted in events streams crashing in the console.
- Fix a bug where uplinks from some Basic Station gateways resulted in the connection to break.
- Fix a security issue where non-admin users could edit admin-only fields of OAuth clients.
- Fix an issue resulting in errors being unnecessarily logged in the console.
- Fix an issue with the `config` command rendering some flags and environment variables incorrectly.
- Fix API endpoints that allowed HTTP methods that are not part of our API specification.
- Fix console handling of configured mount paths other than `/console`.
- Fix handling of `ns.dev-addr-prefixes`.
- Fix incorrect error message in `ttn-lw-cli users oauth` commands.
- Fix propagation of warning headers in API responses.
- Fix relative time display in the Console.
- Fix relative time display in the Console for IE11, Edge and Safari.
- Fix unable to change LoRaWAN MAC and PHY version.
- Resolve flickering display issue in the overview pages of entities in the console.

## [3.1.0] - 2019-07-26

### Added

- `--headers` flag to `ttn-lw-cli applications webhooks set` allowing users to set HTTP headers to add to webhook requests.
- `getByOrganizationId` and `getByUserId` methods to the JS SDK.
- A new documentation system.
- A newline between list items returned from the CLI when using a custom `--output-format` template.
- An `--api-key` flag to `ttn-lw-cli login` that allows users to configure the CLI with a more restricted (Application, Gateway, ...) API key instead of the usual "all rights" OAuth access token.
- API for getting the rights of a single collaborator on (member of) an entity.
- Application Payload Formatters Page in the console.
- Class C and Multicast guide.
- CLI support for enabling/disabling JS, GS, NS and AS through configuration.
- Components overview in documentation.
- Device Templates to create, convert and map templates and assign EUIs to create large amounts of devices.
- Downlink Queue Operations guide.
- End device level payload formatters to console.
- Event streaming views for end devices.
- Events to device registries in the Network Server, Application Server and Join Server.
- Functionality to delete end devices in the console.
- Gateway General Settings Page to the console.
- Getting Started guide for command-line utility (CLI).
- Initial overview page to console.
- Native support to the Basic Station LNS protocol in the Gateway Server.
- NS-JS and AS-JS Backend Interfaces 1.0 and 1.1 draft 3 support.
- Option to revoke user sessions and access tokens on password change.
- Support for NS-JS and AS-JS Backend Interfaces.
- Support for URL templates inside the Webhook paths ! The currently supported fields are `appID`, `appEUI`, `joinEUI`, `devID`, `devEUI` and `devAddr`. They can be used using RFC 6570.
- The `go-cloud` integration to the Application Server. See `ttn-lw-cli applications pubsubs --help` for more details.
- The `go-cloud` integration to the Application Server. This integration enables downlink and uplink messaging using the cloud pub-sub by setting up the `--as.pubsub.publish-urls` and `--as.pubsub.subscribe-urls` parameters. You can specify multiple publish endpoints or subscribe endpoints by repeating the parameter (i.e. `--as.pubsub.publish-urls url1 --as.pubsub.publish-urls url2 --as.pubsub.subscribe-urls url3`).
- The Gateway Data Page to the console.
- View to update the antenna location information of gateways.
- View to update the location information of end devices.
- Views to handle integrations (webhooks) to the console.
- Working with Events guide.

### Changed

- Change database index names for invitation and OAuth models. Existing databases are migrated automatically.
- Change HTTP API for managing webhooks to avoid conflicts with downlink webhook paths.
- Change interpretation of frequency plan's maximum EIRP from a ceiling to a overriding value of any band (PHY) settings.
- Change the prefix of Prometheus metrics from `ttn_` to `ttn_lw_`.
- Rename the label `server_address` of Prometheus metrics `grpc_client_conns_{opened,closed}_total` to `remote_address`
- Resolve an issue where the stack complained about sending credentials on insecure connections.
- The Events endpoint no longer requires the `_ALL` right on requested entities. All events now have explicit visibility rules.

### Deprecated

- `JsEndDeviceRegistry.Provision()` rpc. Please use `EndDeviceTemplateConverter.Convert()` instead.

### Removed

- Remove the address label from Prometheus metric `grpc_server_conns_{opened,closed}_total`.

### Fixed

- Fix Basic Station CUPS LNS credentials blob.
- Fix a leak of entity information in List RPCs.
- Fix an issue that resulted in some event errors not being shown in the console.
- Fix an issue where incorrect error codes were returned from the console's OAuth flow.
- Fix clearing component addresses on updating end devices through CLI.
- Fix CLI panic for invalid attributes.
- Fix crash when running some `ttn-lw-cli organizations` commands without `--user-id` flag.
- Fix dwell-time issues in AS923 and AU915 bands.
- Fix occasional issues with downlink payload length.
- Fix the `x-total-count` header value for API Keys and collaborators.
- Fix the error that is returned when deleting a collaborator fails.

### Security

- Update node packages to fix known vulnerabilities.

## [3.0.4] - 2019-07-10

### Fixed

- Fix rights caching across multiple request contexts.

## [3.0.3] - 2019-05-10

### Added

- Support for getting automatic Let's Encrypt certificates. Add the new config flags `--tls.acme.enable`, `--tls.acme.dir=/path/to/storage`, `--tls.acme.hosts=example.com`, `--tls.acme.email=you@example.com` flags (or their env/config equivalent) to make it work. The `/path/to/storage` dir needs to be `chown`ed to `886:886`. See also `docker-compose.yml`.
- `GetApplicationAPIKey`, `GetGatewayAPIKey`, `GetOrganizationAPIKey`, `GetUserAPIKey` RPCs and related messages.
- "General Settings" view for end devices.
- `--credentials-id` flag to CLI that allows users to be logged in with mulitple credentials and switch between them.
- A check to the Identity Server that prevents users from deleting applications that still contain end devices.
- Application Collaborators management to the console.
- Checking maximum round-trip time for late-detection in downlink scheduling.
- Configuration service to JS SDK.
- Device list page to applications in console.
- Events to the application management pages.
- Round-trip times to Gateway Server connection statistics.
- Support for the value `cloud` for the `--events.backend` flag. When this flag is set, the `--events.cloud.publish-url` and `--events.cloud.subscribe-url` are used to set up a cloud pub-sub for events.
- Support for uplink retransmissions.
- Using median round-trip time value for absolute time scheduling if the gateway does not have GPS time.

### Changed

- Change encoding of keys to hex in device key generation (JS SDK).
- Change interpretation of absolute time in downlink messages from time of transmission to time of arrival.
- Improve ADR algorithm performance.
- Improve ADR performance.
- Make late scheduling default for gateways connected over UDP to avoid overwriting queued downlink.
- Make sure that non-user definable fields of downlink messages get discarded across all Application Server frontends.
- Prevent rpc calls to JS when the device has `supports_join` set to `false` (JS SDK).
- Update the development tooling. If you are a developer, make sure to check the changes in CONTRIBUTING.md and DEVELOPMENT.md.

### Fixed

- Fix `AppAs` not registered for HTTP interfacing while it is documented in the API.
- Fix absolute time scheduling with UDP connected gateways
- Fix authentication of MQTT and gRPC connected gateways
- Fix connecting MQTT V2 gateways
- Fix faulty composition of default values with provided values during device creation (JS SDK)
- Fix preserving user defined priority for application downlink
- Fix UDP downlink format for older forwarders
- Fix usage of `URL` class in browsers (JS SDK)

## [3.0.2] - 2019-04-12

### Changed

- Upgrade Go to 1.12

### Fixed

- Fix streaming events over HTTP with Gzip enabled.
- Fix resetting downlink channels for US, AU and CN end devices.
- Fix rendering of enums in JSON.
- Fix the permissions of our Snap package.

## [3.0.1] - 2019-04-10

### Added

- `dev_addr` to device fetched from the Network Server.
- `received_at` to `ApplicationUp` messages.
- `ttn-lw-cli users oauth` commands.
- Event payload to `as.up.forward`, `as.up.drop`, `as.down.receive`, `as.down.forward` and `as.down.drop` events.
- Event payload to `gs.status.receive`, `gs.up.receive` and `gs.down.send` events.
- OAuth management in the Identity Server.

### Changed

- Document places in the CLI where users can use arguments instead of flags.
- In JSON, LoRaWAN AES keys are now formatted as Hex instead of Base64.
- Make device's `dev_addr` update when the session's `dev_addr` is updated.

### Removed

- Remove end device identifiers from `DownlinkMessage` sent from the Network Server to the Gateway Server.

### Fixed

- Fix `dev_addr` not being present in upstream messages.

<!--
NOTE: These links should respect backports. See https://github.com/TheThingsNetwork/lorawan-stack/pull/1444/files#r333379706.
-->

[unreleased]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.33.0...v3.33
[3.33.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.32.3...v3.33.0
[3.32.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.32.2...v3.32.3
[3.32.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.32.1...v3.32.2
[3.32.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.32.0...v3.32.1
[3.32.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.31.1...v3.32.0
[3.31.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.31.0...v3.31.1
[3.31.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.30.2...v3.31.0
[3.30.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.30.1...v3.30.2
[3.30.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.30.0...v3.30.1
[3.30.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.29.2...v3.30.0
[3.29.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.29.1...v3.29.2
[3.29.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.29.0...v3.29.1
[3.29.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.28.2...v3.29.0
[3.28.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.28.1...v3.28.2
[3.28.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.28.0...v3.28.1
[3.28.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.27.2...v3.28.0
[3.27.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.27.1...v3.27.2
[3.27.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.27.0...v3.27.1
[3.27.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.26.2...v3.27.0
[3.26.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.26.1...v3.26.2
[3.26.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.26.0...v3.26.1
[3.26.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.25.2...v3.26.0
[3.25.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.25.1...v3.25.2
[3.25.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.25.0...v3.25.1
[3.25.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.24.2...v3.25.0
[3.24.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.24.1...v3.24.2
[3.24.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.24.0...v3.24.1
[3.24.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.23.2...v3.24.0
[3.23.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.23.1...v3.23.2
[3.23.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.23.0...v3.23.1
[3.23.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.22.2...v3.23.0
[3.22.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.22.1...v3.22.2
[3.22.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.22.0...v3.22.1
[3.22.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.21.2...v3.22.0
[3.21.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.21.1...v3.21.2
[3.21.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.21.0...v3.21.1
[3.21.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.20.2...v3.21.0
[3.20.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.20.1...v3.20.2
[3.20.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.20.0...v3.20.1
[3.20.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.19.2...v3.20.0
[3.19.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.19.1...v3.19.2
[3.19.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.19.0...v3.19.1
[3.19.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.18.2...v3.19.0
[3.18.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.18.1...v3.18.2
[3.18.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.18.0...v3.18.1
[3.18.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.17.1...v3.18.0
[3.17.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.17.0...v3.17.1
[3.17.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.16.2...v3.17.0
[3.16.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.16.1...v3.16.2
[3.16.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.16.0...v3.16.1
[3.16.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.15.3...v3.16.0
[3.15.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.15.2...v3.15.3
[3.15.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.15.1...v3.15.2
[3.15.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.15.0...v3.15.1
[3.15.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.14.2...v3.15.0
[3.14.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.14.1...v3.14.2
[3.14.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.14.0...v3.14.1
[3.14.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.13.3...v3.14.0
[3.13.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.13.2...v3.13.3
[3.13.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.13.1...v3.13.2
[3.13.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.13.0...v3.13.1
[3.13.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.12.3...v3.13.0
[3.12.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.12.2...v3.12.3
[3.12.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.12.1...v3.12.2
[3.12.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.12.0...v3.12.1
[3.12.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.11.3...v3.12.0
[3.11.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.11.2...v3.11.3
[3.11.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.11.1...v3.11.2
[3.11.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.11.0...v3.11.1
[3.11.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.10.6...v3.11.0
[3.10.6]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.10.5...v3.10.6
[3.10.5]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.10.4...v3.10.5
[3.10.4]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.10.3...v3.10.4
[3.10.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.10.2...v3.10.3
[3.10.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.10.1...v3.10.2
[3.10.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.10.0...v3.10.1
[3.10.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.9.4...v3.10.0
[3.9.4]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.9.3...v3.9.4
[3.9.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.9.1...v3.9.3
[3.9.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.9.0...v3.9.1
[3.9.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.8.6...v3.9.0
[3.8.6]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.8.5...v3.8.6
[3.8.5]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.8.4...v3.8.5
[3.8.4]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.8.3...v3.8.4
[3.8.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.8.2...v3.8.3
[3.8.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.7.2...v3.8.2
[3.7.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.7.0...v3.7.2
[3.7.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.6.0...v3.7.0
[3.6.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.6.2...v3.6.3
[3.6.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.6.1...v3.6.2
[3.6.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.6.0...v3.6.1
[3.6.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.5.3...v3.6.0
[3.5.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.5.2...v3.5.3
[3.5.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.5.1...v3.5.2
[3.5.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.5.0...v3.5.1
[3.5.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.4.2...v3.5.0
[3.4.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.4.1...v3.4.2
[3.4.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.4.0...v3.4.1
[3.4.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.3.2...v3.4.0
[3.3.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.3.1...v3.3.2
[3.3.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.3.0...v3.3.1
[3.3.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.2.6...v3.3.0
[3.2.6]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.2.5...v3.2.6
[3.2.5]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.2.4...v3.2.5
[3.2.4]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.2.3...v3.2.4
[3.2.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.2.2...v3.2.3
[3.2.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.2.1...v3.2.2
[3.2.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.2.0...v3.2.1
[3.2.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.1.2...v3.2.0
[3.1.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.1.1...v3.1.2
[3.1.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.1.0...v3.1.1
[3.1.0]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.0.4...v3.1.0
[3.0.4]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.0.3...v3.0.4
[3.0.3]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.0.2...v3.0.3
[3.0.2]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.0.1...v3.0.2
[3.0.1]: https://github.com/TheThingsNetwork/lorawan-stack/compare/v3.0.0...v3.0.1
