# Reference files

This directory contains reference files you can use to help with decompiling game functions. They are all source code files we wrote by hand before we used Splat to decompile and reassemble the game to a byte-matching executable.

It is organized as follows:
- `include/` contains header files for the game engine Many of the very short structs/enums are correct. The longer ones are probably not correct (missing fields, wrong field types, etc), but they can be used as a reference.
- `src/P2/` contains source code files for the game engine. None of the code is matching, though at the time we tried to make them resemble the original code as closely as possible, so they may help you understand the logic and control flow of certain functions.

## Source files
The following is a list of all known source code file names from a **prototype build** of the game. Some of them are not present in the final game, and the final game has some that are not present here.

```
ac.c
act.c
actseg.c
alarm.c
alo.c
aseg.c
asega.c
barrier.c
bas.c
basic.c
bbmark.c
bez.c
binoc.c
bis.c
bit.c
blend.c
blip.c
bomb.c
bone.c
bq.c
break.c
brx.c
bsp.c
button.c
cache.c
can.c
cat.c
cd.c
chkpnt.c
classes.c
clip.c
clock.c
cm.c
cnvo.c
coin.c
cplcy.c
credit.c
crout.c
crusher.c
crv.c
csc.c
cycle.c
dart.c
dartgun.c
dbg.c
deci2.c
defhandler.c
dialog.c
diei.c
difficulty.c
dl.c
dmas.c
dp-bit.c
dsp.c
dysh.c
dzg.c
eeloadfile.c
emitter.c
evtwalk.c
exit.c
eyes.c
fader.c
filestub.c
find.c
flash.c
fly.c
font.c
fp-bit.c
freeze.c
frm.c
frzg.c
game.c
geom.c
gifs.c
glbs.c
glob.c
glue.c
gomer.c
graphdev.c
gs.c
hg.c
hide.c
hnd.c
hull.c
ik.c
init.c
initsys.c
inl.c
intr.c
iopreset.c
ipuinit.c
jack.c
jlo.c
joy.c
jp.c
jsg.c
jt.c
jump.c
keyhole.c
klib.s
kprintf.c
landing.c
letters.c
lgn.c
libdma.c
libipu.c
libosd.c
libpad.c
libscedemo.c
light.c
lo.c
lookat.c
main.c
map2d.c
map3d.c
mark.c
mat.c
mb.c
mecha.c
memcard.c
memory.c
menu.c
missile.c
mouthgame.c
mpc.c
mpeg.c
mrkv.c
ms.c
murray.c
pack.c
path.c
perf.c
phasemem.c
pipe.c
pnt.c
po.c
pose.c
prog.c
prompt.c
proxy.c
ps2t/buildver.c
ps2t/spaprops.ic
puffer.c
pzo.c
rail.c
rat.c
rchm.c
render.c
rip.c
rog.c
rope.c
rumble.c
rwm.c
sampler.c
sc.c
screen.c
sensor.c
shadow.c
shape.c
shd.c
shdanim.c
shiftjis.c
sifcmd.c
sifrpc.c
sky.c
slotheap.c
sm.c
smartguard.c
so.c
solve.c
sort.c
sound.c
speaker.c
spire.c
splice/bif.cpp
splice/callstack.cpp
splice/error.cpp
splice/eval.cpp
splice/frame.cpp
splice/gc.cpp
splice/method.cpp
splice/pair.cpp
splice/proc.cpp
splice/ref.cpp
splice/serialize.cpp
splice/sidebag.cpp
splice/spliceutils.cpp
splice/splotheap.cpp
splice/vecmat.cpp
splicemap.c
spliceobj.c
sprbuf.c
sqtr.c
squish.c
step.c
stepact.c
stepcane.c
stepguard.c
stephang.c
stephide.c
steppipe.c
steppower.c
steprun.c
stepside.c
stepski.c
stepzap.c
stream.c
suv.c
sw.c
tail.c
tank.c
target.c
text.c
texture.c
thread.c
tlbfunc.c
tlbtrap.s
tn.c
transition.c
tty.c
turret.c
tv.c
ub.c
ui.c
unzip.c
update.c
util.c
var.c
vec.c
version.h
vife.c
vifs.c
vis.c
vu/vu.c
water.c
waypoint.c
wibu_ee.c
wipe.c
wm.c
wr.c
xform.c
zap.c
```
