/*
#     ___  _ _      ___
#    |    | | |    |
# ___|    |   | ___|    PS2DEV Open Source Project.
#----------------------------------------------------------
# Copyright (c) 2002 The FFmpeg Project.
# Licensed (like the original ffmpeg source code) under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation;
# either version 2 of the License, or (at your option) any later version.
#
# Copyright (c) 2007 Eugene Plotnikov (PS2 specific code)
# This code is licensed under Academic Free License version 2.0
# Review ps2sdk README & LICENSE files for further details.
*/
#include "SMS_WMA.h"
#include "SMS_VLC.h"
#include "SMS_DSP.h"
#include "SMS_Locale.h"

#include <malloc.h>
#include <math.h>
#include <string.h>
#include <stdio.h>

extern float PowF     ( float, float         );
extern void  pcm_syn1 ( short*, float**, int );
extern void  pcm_syn2 ( short*, float**, int );

#define sqrtf SMS_sqrtf

#define NB_LSP_COEFS              10
#define VLCBITS                   9
#define BLOCK_MIN_BITS            7
#define BLOCK_MAX_BITS            11
#define BLOCK_NB_SIZES            ( BLOCK_MAX_BITS - BLOCK_MIN_BITS + 1 )
#define BLOCK_MAX_SIZE            ( 1 << BLOCK_MAX_BITS )
#define MAX_CHANNELS              2
#define HIGH_BAND_MAX_SIZE        16
#define MAX_CODED_SUPERFRAME_SIZE 16384
#define NOISE_TAB_SIZE            8192
#define LSP_POW_BITS              7
#define EXPVLCBITS                8
#define EXPMAX                    (  ( 19 + EXPVLCBITS - 1 ) / EXPVLCBITS  )
#define HGAINVLCBITS              9
#define HGAINMAX                  (  ( 13 + HGAINVLCBITS - 1 ) / HGAINVLCBITS  )
#define VLCBITS                   9
#define VLCMAX                    (  ( 22 + VLCBITS - 1 ) / VLCBITS  )

typedef struct CoefVLCTable {
 int                   n;
 const unsigned int*   huffcodes;
 const unsigned char*  huffbits;
 const unsigned short* levels;
} CoefVLCTable;

static const unsigned short wma_critical_freqs[ 25 ] __attribute__(   (  section( ".data" )  )   ) = {
  100,   200,  300, 400,   510,  630,  770,    920,
  1080, 1270, 1480, 1720, 2000, 2320, 2700,   3150,
  3700, 4400, 5300, 6400, 7700, 9500, 12000, 15500,
 24500
};

static const unsigned char exponent_band_22050[ 3 ][ 25 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 10, 4, 8, 4, 8,  8, 12, 20, 24, 24, 16 },
 { 14, 4, 8, 8, 4, 12, 12, 16, 24, 16, 20, 24, 32, 40, 36 },
 { 23, 4, 4, 4, 8,  4,  4,  8,  8,  8,  8,  8, 12, 12, 16, 16, 24, 24, 32, 44, 48, 60, 84, 72 }
};

static const unsigned char exponent_band_32000[ 3 ][ 25 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 11, 4, 4, 8, 4,  4, 12, 16, 24, 20, 28,  4 },
 { 15, 4, 8, 4, 4,  8,  8, 16, 20, 12, 20, 20, 28, 40, 56, 8 },
 { 16, 8, 4, 8, 8, 12, 16, 20, 24, 40, 32, 32, 44, 56, 80, 112, 16 }
};

static const unsigned char exponent_band_44100[ 3 ][ 25 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 12, 4, 4, 4, 4,  4,  8, 8, 8, 12, 16, 20, 36 },
 { 15, 4, 8, 4, 8,  8,  4, 8, 8, 12, 12, 12, 24, 28, 40, 76 },
 { 17, 4, 8, 8, 4, 12, 12, 8, 8, 24, 16, 20, 24, 32, 40, 60,  80, 152 }
};

static const uint16_t hgain_huffcodes[ 37 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00003, 0x002E7, 0x00001, 0x005CD, 0x0005D, 0x005C9, 0x0005E, 0x00003,
 0x00016, 0x0000B, 0x00001, 0x00006, 0x00001, 0x00006, 0x00004, 0x00005,
 0x00004, 0x00007, 0x00003, 0x00007, 0x00004, 0x0000A, 0x0000A, 0x00002,
 0x00003, 0x00000, 0x00005, 0x00002, 0x0005F, 0x00004, 0x00003, 0x00002,
 0x005C8, 0x000B8, 0x005CA, 0x005CB, 0x005CC,
};

static const unsigned char hgain_huffbits[ 37 ] __attribute__(   (  section( ".data" )  )   ) = {
 10, 12, 10, 13,  9, 13,  9,  8, 7,  5,  5,  4,  4,  3,  3,  3,
  4,  3,  4,  4,  5,  5,  6,  8, 7, 10,  8, 10,  9,  8,  9,  9,
 13, 10, 13, 13, 13
};

static const float lsp_codebook[ NB_LSP_COEFS ][ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 {  1.98732877F,  1.97944528F,  1.97179088F,  1.96260549F,  1.95038374F,  1.93336114F,  1.90719232F,  1.86191415F,
    0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F
 },
 {  1.97260000F,  1.96083160F,  1.94982586F,  1.93806164F,  1.92516608F,  1.91010199F,  1.89232331F,  1.87149812F,
    1.84564818F,  1.81358067F,  1.77620070F,  1.73265264F,  1.67907855F,  1.60959081F,  1.50829650F,  1.33120330F
 },
 {  1.90109110F,  1.86482426F,  1.83419671F,  1.80168452F,  1.76650116F,  1.72816320F,  1.68502700F,  1.63738256F,
    1.58501580F,  1.51795181F,  1.43679906F,  1.33950585F,  1.24176208F,  1.12260729F,  0.96749668F,  0.74048265F
 },
 {  1.76943864F,  1.67822463F,  1.59946365F,  1.53560582F,  1.47470796F,  1.41210167F,  1.34509536F,  1.27339507F,
    1.19303814F,  1.09765169F,  0.98818722F,  0.87239446F,  0.74369172F,  0.59768184F,  0.43168630F,  0.17977021F
 },
 {  1.43428349F,  1.32038354F,  1.21074086F,  1.10577988F,  1.00561746F,  0.90335924F,  0.80437489F,  0.70709671F,
    0.60427395F,  0.49814048F,  0.38509539F,  0.27106800F,  0.14407416F,  0.00219910F, -0.16725141F, -0.36936085F
 },
 {  0.99895687F,  0.84188166F,  0.70753739F,  0.57906595F,  0.47055563F,  0.36966965F,  0.26826648F,  0.17163380F,
    0.07208392F, -0.03062936F, -1.40037388F, -0.25128968F, -0.37213937F, -0.51075646F, -0.64887512F, -0.80308031F
 },
 {  0.26515280F,  0.06313551F, -0.08872080F, -0.21103548F, -0.31069678F, -0.39680323F, -0.47223474F, -0.54167135F,
   -0.61444740F, -0.68943343F, -0.76580211F, -0.85170082F, -0.95289061F, -1.06514703F, -1.20510707F, -1.37617746F
 },
 { -0.53940301F, -0.73770929F, -0.88424876F, -1.01117930F, -1.13389091F, -1.26830073F, -1.42041987F, -1.62033919F,
   -1.10158808F, -1.16512566F, -1.23337128F, -1.30414401F, -1.37663312F, -1.46853845F, -1.57625798F, -1.66893638F
 },
 { -0.38601997F, -0.56009350F, -0.66978483F, -0.76028471F, -0.83846064F, -0.90868087F, -0.97408881F, -1.03694962F,
    0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F
 },
 { -1.56144989F, -1.65944032F, -1.72689685F, -1.77857740F, -1.82203011F, -1.86220079F, -1.90283983F, -1.94820479F,
    0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F,  0.00000000F
 }
};

static const unsigned int scale_huffcodes[ 121 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x3FFE8, 0x3FFE6, 0x3FFE7, 0x3FFE5, 0x7FFF5, 0x7FFF1, 0x7FFED, 0x7FFF6,
 0x7FFEE, 0x7FFEF, 0x7FFF0, 0x7FFFC, 0x7FFFD, 0x7FFFF, 0x7FFFE, 0x7FFF7,
 0x7FFF8, 0x7FFFB, 0x7FFF9, 0x3FFE4, 0x7FFFA, 0x3FFE3, 0x1FFEF, 0x1FFF0,
 0x0FFF5, 0x1FFEE, 0x0FFF2, 0x0FFF3, 0x0FFF4, 0x0FFF1, 0x07FF6, 0x07FF7,
 0x03FF9, 0x03FF5, 0x03FF7, 0x03FF3, 0x03FF6, 0x03FF2, 0x01FF7, 0x01FF5,
 0x00FF9, 0x00FF7, 0x00FF6, 0x007F9, 0x00FF4, 0x007F8, 0x003F9, 0x003F7,
 0x003F5, 0x001F8, 0x001F7, 0x000FA, 0x000F8, 0x000F6, 0x00079, 0x0003A,
 0x00038, 0x0001A, 0x0000B, 0x00004, 0x00000, 0x0000A, 0x0000C, 0x0001B,
 0x00039, 0x0003B, 0x00078, 0x0007A, 0x000F7, 0x000F9, 0x001F6, 0x001F9,
 0x003F4, 0x003F6, 0x003F8, 0x007F5, 0x007F4, 0x007F6, 0x007F7, 0x00FF5,
 0x00FF8, 0x01FF4, 0x01FF6, 0x01FF8, 0x03FF8, 0x03FF4, 0x0FFF0, 0x07FF4,
 0x0FFF6, 0x07FF5, 0x3FFE2, 0x7FFD9, 0x7FFDA, 0x7FFDB, 0x7FFDC, 0x7FFDD,
 0x7FFDE, 0x7FFD8, 0x7FFD2, 0x7FFD3, 0x7FFD4, 0x7FFD5, 0x7FFD6, 0x7FFF2,
 0x7FFDF, 0x7FFE7, 0x7FFE8, 0x7FFE9, 0x7FFEA, 0x7FFEB, 0x7FFE6, 0x7FFE0,
 0x7FFE1, 0x7FFE2, 0x7FFE3, 0x7FFE4, 0x7FFE5, 0x7FFD7, 0x7FFEC, 0x7FFF4,
 0x7FFF3
};

static const unsigned char scale_huffbits[ 121 ] __attribute__(   (  section( ".data" )  )   ) = {
 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 18, 19, 18, 17, 17, 16, 17, 16, 16, 16, 16, 15, 15,
 14, 14, 14, 14, 14, 14, 13, 13, 12, 12, 12, 11, 12, 11, 10, 10,
 10,  9,  9,  8,  8,  8,  7,  6,  6,  5,  4,  3,  1,  4,  4,  5,
  6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 10, 11, 11, 11, 11, 12,
 12, 13, 13, 13, 14, 14, 16, 15, 16, 15, 18, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19, 19
};

static const unsigned short levels0[ 60 ] __attribute__(   (  section( ".data" )  )   ) = {
 317, 92, 62, 60, 19, 17, 10, 7, 6, 5, 5, 3, 3, 3, 2, 2,
  2,   2,  2,  2,  2,  1,  2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1,   1,  1,  1,  1,  1,  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1,   1,  1,  1,  1,  1,  1, 1, 1, 1, 1, 1
};

static const unsigned short levels1[ 40 ] __attribute__(   (  section( ".data" )  )   ) = {
 311, 91, 61, 28, 10, 6, 5, 2, 2, 2, 2, 2, 2, 2, 2, 1,
   1,  1,  1,  1,  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   1,  1,  1,  1,  1, 1, 1, 1
};

static const unsigned short levels2[ 340 ] __attribute__(   (  section( ".data" )  )   ) = {
 181, 110, 78, 63, 61, 62, 60, 61, 33, 41, 41, 19, 17, 19, 12, 11,
   9,  11, 10,  6,  8,  7,  6,  4,  5,  5,  4,  4,  3,  4,  3,  5,
   3,   4,  3,  3,  3,  3,  3,  3,  2,  2,  4,  2,  3,  2,  3,  3,
   2,   2,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,  2,  2,  2,  2,
   2,   2,  2,  1,  2,  1,  2,  2,  2,  2,  1,  2,  1,  1,  1,  2,
   2,   1,  2,  1,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
   1,   1,  1,  1
};

static const unsigned short levels3[ 180 ] __attribute__(   (  section( ".data" )  )   ) = {
 351, 122, 76, 61, 41, 42, 24, 30, 22, 19, 11, 9, 10, 8, 5, 5,
   4,   5,  5,  3,  3,  3,  3,  3,  3,  3,  2, 2,  3, 2, 2, 2,
   3,   3,  2,  2,  2,  3,  2,  2,  2,  2,  2, 2,  2, 2, 2, 2,
   2,   2,  2,  2,  2,  2,  1,  1,  2,  2,  1, 2,  1, 2, 2, 2,
   2,   2,  2,  1,  2,  1,  1,  1,  1,  1,  1, 1,  1, 1, 1, 2,
   2,   1,  2,  1,  1,  1,  1,  1,  1,  1,  1, 1,  1, 1, 1, 1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 1,  1, 1, 1, 1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 1,  1, 1, 1, 1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 1,  1, 1, 1, 1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 1,  1, 1, 1, 1,
   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 1,  1, 1, 1, 1,
   1,   1,  1,  1
};

static const unsigned short levels4[ 70 ] __attribute__(   (  section( ".data" )  )   ) = {
 113, 68, 49, 42, 40, 32, 27, 15, 10, 5, 3, 3, 3, 3, 2, 2,
   2,  2,  2,  1,  1,  1,  1,  1,  1, 1, 1, 1, 1, 1, 1, 1,
   1,  1,  1,  1,  1,  1,  1,  1,  1, 1, 1, 1, 1, 1, 1, 1,
   1,  1,  1,  1,  1,  1,  1,  1,  1, 1, 1, 1, 1, 1, 1, 1,
   1,  1,  1,  1,  1,  1
};

static const unsigned short levels5[ 40 ] __attribute__(   (  section( ".data" )  )   ) = {
 214, 72, 42, 40, 18, 4, 4, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 
   1,  1,  1,  1,  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

static const unsigned char coef0_huffbits[ 666 ] __attribute__(   (  section( ".data" )  )   ) = {
 11,  6,  2,  3,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,
  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 10, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 11, 12,
 12, 12, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 13, 13, 12, 12, 12, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 14, 13, 13, 13, 13, 13, 13, 13, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15,
 15, 14, 14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 16,
 16, 16, 15, 16, 15, 15, 16, 16, 16, 16, 15, 16, 16, 16, 15, 16,
 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 16, 16,
 15, 16, 16, 16, 17, 17, 17, 16, 16, 17, 16, 16, 16, 16, 17, 16,
 17, 17, 16, 16, 15, 15, 15, 16, 17, 16, 17, 16, 16, 17, 17, 17,
 17, 17, 17, 16, 17, 17, 17, 16, 17, 17, 16, 17, 17, 17, 16, 17,
 17, 16, 16, 17, 17, 17, 18, 17, 17, 17, 17, 17, 18, 18, 17, 17,
 17, 19, 17, 19, 18, 17, 17, 18, 17, 17, 18, 17, 17, 17, 18, 17,
 17, 18, 17, 17, 17, 17, 17, 16, 17, 17, 17, 17, 18, 16, 17,  4,
  6,  8,  9,  9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 14, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14,
 15, 15, 15, 15, 15, 15, 16, 15, 15, 15, 15, 15, 15, 17, 17, 17,
 16, 18, 16, 17, 17, 16, 16, 17, 17, 18, 17, 16, 17, 17, 17, 16,
 17, 17, 18, 17, 18, 17, 17, 17, 18, 17, 17,  5,  8, 10, 10, 11,
 11, 12, 12, 12, 13, 13, 14, 13, 13, 14, 14, 14, 14, 14, 14, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 15, 16, 16,
 15, 15, 15, 15, 15, 16, 16, 15, 15, 16, 16, 17, 17, 18, 17, 16,
 17, 18, 19, 17, 16, 16, 17, 17, 17,  6,  9, 11, 12, 12, 13, 13,
 13, 14, 14, 14, 15, 15, 15, 16, 15, 15, 15, 15, 15, 15, 16, 16,
 16, 16, 17, 18, 16, 16, 16, 18, 17, 16, 17, 18, 17, 17, 16, 17,
 17, 16, 17, 16, 17, 18, 18, 18, 17, 19, 19, 17, 20, 19, 18, 19,
 20, 18, 16, 18, 17,  7, 10, 12, 13, 13, 14, 14, 14, 15, 15, 16,
 16, 16, 16, 16, 18, 16, 17, 17,  8, 11, 13, 14, 14, 15, 16, 16,
 16, 16, 17, 17, 17, 18, 18, 17, 17,  8, 12, 14, 15, 15, 15, 17,
 17, 18, 17,  9, 12, 14, 15, 16, 16, 17,  9, 13, 15, 16, 16, 17,
  9, 13, 16, 16, 16, 10, 13, 16, 18, 17, 10, 14, 17, 10, 14, 17,
 11, 14, 16, 11, 14, 11, 15, 12, 16, 12, 16, 12, 16, 12, 16, 12,
 17, 13, 13, 17, 13, 17, 13, 13, 14, 14, 14, 14, 14, 14, 14, 15,
 15, 15, 15, 15, 15, 15, 16, 15, 16, 16, 16, 16, 16, 16, 17, 16,
 16, 16, 16, 17, 16, 17, 16, 17, 17, 17
};

static const unsigned char coef1_huffbits[ 555 ] __attribute__(   (  section( ".data" )  )   ) = {
  9,  5,  2,  4,  4,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,  9,  8,  8,  8,  8,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9, 10, 10, 10,  9,  9,  9,  9,
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12, 12, 12, 12,
 13, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 13, 13, 13,
 13, 12, 12, 12, 12, 12, 12, 13, 12, 13, 13, 13, 13, 13, 13, 13,
 14, 14, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 13, 14, 13, 13, 13,
 13, 13, 14, 13, 14, 14, 13, 14, 14, 13, 14, 13, 13, 14, 14, 13,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 14, 14, 14, 14, 15, 15,
 15, 14, 14, 13, 13, 12, 12, 13, 13, 13, 14, 14, 15, 14, 15, 15,
 14, 13, 14, 15, 15, 15, 14, 14, 14, 14, 15, 14, 14, 15, 15, 15,
 14, 15, 14, 14, 14, 14, 14, 15, 15, 16, 15, 15, 15, 14, 15, 15,
 15, 15, 14, 14, 16, 14, 15, 14, 14, 15, 15, 15, 15, 16, 15, 14,
 15, 15, 15, 16, 15, 15, 14, 14, 14,  4,  7,  8,  8,  9,  9,  9,
  9, 10, 10, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 11, 12, 12, 12, 13, 13, 13, 13, 13, 13,
 13, 12, 12, 13, 13, 13, 13, 14, 14, 13, 14, 13, 13, 13, 14, 14,
 15, 15, 14, 13, 13, 13, 14, 14, 15, 15, 15, 16, 14, 15, 17, 17,
 15, 15, 15, 15, 15, 14, 16, 14, 16, 16, 16, 16, 16, 16, 15, 15,
 17, 15, 16, 15,  6,  8, 10, 10, 10, 11, 11, 11, 12, 12, 13, 13,
 13, 13, 14, 13, 14, 13, 14, 14, 14, 14, 14, 15, 15, 14, 14, 14,
 14, 14, 14, 15, 15, 15, 15, 16, 15, 15, 16, 15, 15, 15, 14, 16,
 15, 15, 18, 17, 16, 17, 15, 14, 15, 16, 16, 19, 17, 19, 16, 17,
 15,  7, 10, 11, 12, 12, 12, 12, 13, 13, 13, 14, 15, 14, 15, 15,
 16, 15, 14, 14, 15, 16, 15, 16, 16, 16, 16, 15, 15,  7, 11, 12,
 13, 13, 14, 14, 15, 15, 15,  8, 11, 13, 14, 14, 15,  9, 12, 14,
 14, 15,  9, 13, 10, 13, 10, 14, 10, 14, 11, 15, 11, 15, 11, 14,
 12, 15, 12, 13, 13, 13, 13, 13, 13, 14, 13, 14, 14, 14, 14, 14,
 14, 15, 14, 15, 16, 15, 14, 15, 16, 15, 15
};

static const unsigned char coef2_huffbits[ 1336 ] __attribute__(   (  section( ".data" )  )   ) = {
 11,  9,  2,  3,  4,  4,  5,  6,  6,  7,  7,  8,  8,  8,  9,  9,
  9,  9, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 15, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 17, 17, 17, 17,
 17, 17, 17, 18, 18, 17, 17, 18, 17, 17, 18, 17, 18, 18, 18, 18,
 19, 18, 18, 18, 18, 18, 18, 20, 18, 18, 18, 19, 19, 18, 19, 18,
 19, 19, 18, 19, 19, 18, 19, 19, 19, 19, 18, 19, 19, 19, 19, 19,
 19, 19, 20, 20, 20, 19, 19, 20, 19, 20, 19, 19, 20, 19, 19, 20,
 20, 20, 20, 19, 20, 21, 19,  3,  5,  7,  8,  9,  9, 10, 11, 11,
 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 16, 16, 15, 15, 15, 15, 16, 16, 16, 16,
 17, 16, 17, 17, 16, 17, 17, 17, 17, 17, 17, 16, 17, 17, 17, 17,
 18, 17, 17, 18, 18, 18, 18, 18, 19, 18, 18, 18, 18, 18, 18, 19,
 19, 18, 18, 18, 18, 19, 18, 19, 19, 19, 20, 19, 18, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 20, 20, 19, 20, 19, 20, 19, 20, 19,
 19, 21, 20, 20, 19,  4,  7,  8, 10, 11, 11, 12, 12, 13, 13, 14,
 14, 14, 14, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 17,
 17, 17, 17, 17, 17, 17, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18,
 18, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 18, 18, 18,
 19, 18, 19, 19, 19, 20, 20, 20, 19, 19, 19, 19, 19, 19, 19, 21,
 21, 20, 19,  5,  8, 10, 11, 12, 13, 13, 13, 14, 14, 15, 15, 15,
 15, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 18, 17,
 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 19, 18, 19, 18,
 18, 18, 18, 18, 19, 18, 17, 17, 18, 18, 19, 19, 19, 19, 18, 18,
 18, 19,  6,  9, 11, 12, 13, 13, 14, 14, 14, 15, 15, 16, 16, 16,
 16, 16, 16, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
 18, 17, 18, 18, 17, 18, 18, 18, 18, 18, 18, 19, 19, 18, 18, 18,
 19, 19, 19, 20, 19, 19, 18, 19, 19, 20, 21, 21, 19, 19, 18,  6,
 10, 12, 13, 14, 14, 14, 15, 15, 15, 16, 16, 17, 17, 17, 17, 17,
 17, 17, 18, 18, 19, 18, 18, 18, 19, 18, 18, 18, 19, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18, 19, 20, 20, 19, 19, 19, 19, 20,
 20, 19, 20, 19, 19, 19, 20, 20, 20, 19, 19, 18, 19,  7, 10, 12,
 13, 14, 15, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 18, 18, 18,
 18, 19, 18, 19, 19, 19, 20, 19, 18, 19, 19, 18, 18, 19, 19, 19,
 18, 19, 19, 20, 19, 18, 20, 21, 20, 20, 19, 19, 21, 20, 21, 20,
 20, 20, 19, 19, 20, 20, 21, 20, 19,  7, 11, 13, 14, 15, 15, 15,
 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 18, 19, 20, 19, 19, 20,
 19, 19, 19, 19, 19, 19, 19, 19, 18, 18, 19, 20, 19, 19, 19, 20,
 19, 19, 19, 20, 19, 20, 20, 21, 20, 20, 20, 21, 22, 20, 19, 20,
 20, 21, 20, 21, 20, 19,  8, 11, 13, 14, 15, 16, 16, 16, 17, 17,
 17, 18, 18, 18, 18, 18, 19, 18, 19, 19, 19, 19, 21, 19, 19, 21,
 19, 20, 20, 20, 19, 18, 18,  8, 12, 14, 15, 16, 16, 16, 16, 17,
 17, 17, 19, 18, 18, 19, 19, 20, 19, 18, 20, 19, 20, 20, 19, 19,
 20, 20, 21, 21, 20, 19, 19, 19, 19, 19, 19, 20, 21, 20, 19, 19,
  8, 12, 14, 15, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 19,
 19, 19, 20, 21, 20, 21, 19, 21, 20, 20, 20, 20, 21, 20, 19, 20,
 19, 20, 20, 20, 19, 22, 21, 21, 19,  9, 12, 14, 15, 16, 17, 17,
 17, 18, 18, 18, 19, 19, 19, 19, 20, 19, 19, 19,  9, 13, 15, 16,
 17, 17, 18, 18, 18, 19, 18, 20, 19, 20, 20, 20, 19,  9, 13, 15,
 16, 17, 17, 18, 18, 18, 20, 18, 19, 20, 20, 20, 20, 19, 20, 19,
  9, 13, 15, 16, 17, 18, 18, 18, 19, 19, 19, 19, 10, 14, 16, 17,
 18, 18, 19, 19, 19, 19, 19, 10, 14, 16, 17, 18, 18, 18, 19, 19,
 10, 14, 16, 17, 18, 18, 18, 19, 19, 20, 19, 10, 14, 16, 18, 18,
 18, 19, 20, 19, 19, 10, 14, 17, 18, 18, 18, 10, 15, 17, 18, 19,
 19, 21, 19, 11, 15, 17, 18, 18, 19, 19, 11, 15, 17, 18, 19, 19,
 11, 15, 17, 18, 11, 15, 18, 19, 19, 11, 15, 18, 19, 19, 11, 16,
 18, 19, 11, 15, 18, 19, 11, 16, 18, 12, 16, 18, 19, 12, 16, 19,
 12, 16, 19, 19, 19, 12, 16, 19, 12, 16, 19, 19, 12, 16, 18, 12,
 16, 19, 12, 17, 19, 12, 17, 19, 12, 17, 19, 12, 17, 19, 13, 17,
 13, 17, 13, 17, 19, 19, 13, 17, 13, 17, 19, 13, 17, 13, 18, 19,
 13, 17, 19, 13, 18, 13, 17, 13, 18, 13, 18, 13, 18, 13, 18, 13,
 18, 13, 18, 14, 18, 19, 14, 18, 14, 18, 14, 18, 14, 18, 14, 19,
 14, 19, 14, 18, 14, 18, 14, 18, 14, 19, 14, 14, 18, 14, 14, 19,
 14, 18, 14, 19, 14, 19, 14, 15, 19, 15, 15, 15, 15, 19, 15, 19,
 15, 15, 19, 15, 15, 19, 15, 19, 15, 19, 15, 19, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 16, 15, 15, 15, 16, 16, 16, 15, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 17, 16, 16, 16, 17, 17, 16, 17, 17, 16, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18,
 17, 17, 17, 17, 17, 17, 17, 17, 18, 17, 17, 18, 17, 17, 17, 17,
 18, 18, 17, 17, 17, 17, 17, 17, 17, 18, 17, 18, 18, 17, 17, 17,
 18, 18, 18, 17, 18, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17,
 18, 18, 18, 18, 19, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 19, 18, 18, 19, 18, 18, 18, 19, 18,
 19, 18, 18, 19, 18, 18, 19, 19, 19, 19, 19, 18, 19, 18, 19, 18,
 19, 19, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 18, 19,
 19, 19, 19, 19, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20,
 19, 19, 19, 19, 21, 19, 19, 20, 19, 20, 19, 19, 19, 19, 19, 20,
 20, 20, 19, 19, 19, 20, 19, 19, 19, 20, 20, 19, 20, 19, 19, 21,
 20, 20, 19, 19, 19, 19, 19, 19, 20, 19, 20, 20, 20, 20, 20, 20,
 20, 19, 19, 21, 20, 20, 19, 19
};

static const unsigned char coef3_huffbits[ 1072 ] __attribute__(   (  section( ".data" )  )   ) = {
  9,  7,  2,  3,  4,  4,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
  7,  8,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,  9,  9,  9,  9,
  9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 14, 13, 14, 14, 13, 14, 13, 13, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15,
 14, 14, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 16, 15, 16, 16, 16, 16, 15, 15, 16, 16, 16, 16, 16,
 15, 16, 16, 16, 15, 16, 15, 15, 16, 15, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 16, 17, 16, 17, 17, 16,
 17, 16, 17, 16, 16, 17, 17, 17, 16, 17, 16, 16, 17, 16, 17, 16,
 17, 17, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 16, 17, 17, 16,
 17, 17, 17, 17, 17, 17, 17, 17, 16, 18, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 18, 17, 17, 17, 17, 18, 17, 17, 18,
 19, 17, 17, 17, 18, 17, 17, 17, 18, 18, 18, 17, 17, 17, 18, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 17, 18, 18, 18, 18, 17, 18, 18, 18, 17, 17, 18, 18, 18,
 18, 19, 18, 18, 19, 19, 20, 18, 19, 18, 19, 19, 18, 19, 20, 18,
 19,  4,  6,  7,  8,  9,  9,  9, 10, 10, 10, 11, 11, 11, 11, 12,
 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 16, 15, 15, 15, 15, 16, 16, 15, 16, 16, 15, 16,
 17, 17, 17, 17, 17, 16, 16, 16, 16, 16, 17, 17, 17, 16, 18, 17,
 17, 17, 18, 17, 17, 18, 17, 17, 17, 17, 17, 18, 17, 18, 18, 18,
 17, 17, 18, 19, 18, 18, 17, 17, 18, 18, 18, 18, 19, 17, 17, 18,
 20, 19, 19, 18, 19, 18, 19, 19, 19, 19, 17,  5,  7,  9, 10, 10,
 11, 11, 12, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15,
 14, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 15, 16, 16, 17, 17, 17, 16, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 16, 16, 19, 18, 18, 19, 17, 19, 20,
 17, 18, 18, 18, 18, 18, 18,  6,  8, 10, 11, 12, 12, 12, 13, 13,
 13, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16,
 16, 17, 17, 17, 16, 16, 17, 17, 17, 17, 17, 17, 17, 16, 16, 16,
 17, 18, 18, 18, 17, 19, 19, 18, 18, 17, 18, 19, 18, 17, 18, 18,
 19, 18, 17, 17,  6,  9, 11, 12, 13, 13, 13, 14, 14, 14, 15, 15,
 15, 15, 15, 16, 16, 16, 16, 16, 16, 17, 16, 17, 17, 17, 17, 17,
 17, 17, 18, 17, 18, 17, 17, 18, 18, 19, 19, 17, 17,  7, 10, 12,
 13, 13, 14, 14, 14, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 17, 17, 17, 17, 18, 17, 18, 18, 18, 18, 18, 18, 18, 18, 17,
 17, 18, 18, 18, 18, 18, 18,  7, 10, 12, 13, 14, 15, 15, 15, 15,
 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 17, 17,  8,
 11, 13, 14, 15, 15, 15, 15, 16, 16, 18, 17, 17, 18, 17, 17, 18,
 17, 17, 18, 18, 19, 18, 18, 19, 19, 19, 18, 18, 18,  8, 11, 13,
 14, 15, 16, 16, 16, 16, 17, 17, 17, 18, 17, 18, 19, 18, 18, 18,
 18, 18, 18,  8, 12, 14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 18,
 18, 18, 18, 18, 18, 17,  9, 12, 14, 15, 16, 16, 17, 17, 17, 17,
 18,  9, 12, 14, 15, 16, 17, 17, 17, 18,  9, 13, 15, 16, 17, 17,
 18, 17, 18, 17,  9, 13, 15, 16, 17, 18, 18, 18, 10, 13, 15, 16,
 18, 10, 14, 16, 17, 18, 10, 14, 16, 17, 10, 14, 16, 18, 18, 10,
 14, 16, 18, 18, 11, 15, 16, 11, 15, 17, 11, 15, 17, 11, 15, 17,
 11, 15, 17, 11, 15, 17, 12, 16, 17, 12, 15, 12, 16, 12, 16, 18,
 12, 16, 12, 16, 12, 16, 12, 16, 17, 12, 16, 18, 12, 17, 13, 16,
 13, 16, 13, 16, 18, 13, 16, 13, 17, 13, 17, 13, 17, 13, 17, 13,
 17, 13, 17, 13, 17, 13, 17, 13, 16, 13, 17, 13, 17, 13, 17, 14,
 17, 14, 17, 14, 17, 14, 14, 14, 17, 14, 17, 14, 14, 18, 14, 14,
 18, 14, 18, 14, 18, 14, 17, 14, 17, 14, 17, 14, 14, 18, 14, 15,
 15, 15, 14, 15, 15, 14, 15, 15, 15, 18, 15, 18, 15, 15, 17, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 15, 15, 15, 15, 16,
 16, 16, 16, 16, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 17, 16, 16, 16, 17, 16, 16, 16, 17, 17, 17,
 17, 17, 16, 17, 17, 17, 17, 16, 16, 16, 17, 17, 17, 17, 16, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 17
};

static const unsigned char coef4_huffbits[ 476 ] __attribute__(   (  section( ".data" )  )   ) = {
 12,  6,  2,  3,  4,  4,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,
  7,  7,  7,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,  9,  9,  9,
 10, 10, 10, 10, 10, 10, 10, 11, 10, 11, 11, 11, 11, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13,
 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 16, 16, 16, 15, 15, 15, 15, 15, 16, 16,
 15, 16, 16, 17, 16, 16, 16, 17, 18, 18, 17, 17, 17, 17, 17, 17,
 17, 17, 17,  4,  6,  7,  8,  8,  8,  9,  9, 10, 10, 10, 10, 10,
 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 13, 13, 13, 14, 13, 14, 14, 14, 13, 13, 14, 14, 16, 16, 15,
 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 16, 16,
 16, 16, 17, 17, 17, 18, 16,  5,  8,  9, 10, 10, 10, 11, 11, 12,
 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 13,
 14, 14, 13, 14, 14, 15, 14, 15, 15, 15, 16, 15, 16, 16, 15, 15,
 15, 18, 18, 18, 17, 18, 17, 17,  6,  9, 10, 11, 11, 12, 12, 13,
 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 16, 15,
 15, 15, 15, 15, 15, 16, 16, 15, 16, 16, 16, 16, 17, 18, 17, 16,
 16, 16,  7, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 15, 14, 15,
 15, 15, 16, 15, 15, 15, 15, 16, 16, 16, 17, 16, 17, 16, 15, 16,
 16, 16, 16, 18, 17, 17, 19, 19, 18, 16,  7, 11, 12, 13, 14, 14,
 15, 15, 16, 16, 15, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 17,
 16, 17, 17, 16, 17, 18, 16, 17, 17, 17,  8, 11, 13, 14, 14, 15,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 16, 17, 17, 17, 17,
 18, 18, 18, 17, 17,  8, 12, 14, 14, 15, 15, 16, 17, 17, 16, 16,
 17, 17, 20, 17,  9, 12, 14, 16, 16, 16, 17, 21, 18, 17,  9, 13,
 15, 16, 16, 10, 13, 16, 10, 14, 16, 11, 15, 16, 11, 15, 17, 11,
 15, 12, 15, 12, 16, 12, 16, 13, 16, 13, 13, 13, 14, 14, 13, 14,
 14, 14, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 16, 17, 16, 16,
 16, 16, 17, 16, 17, 16, 18, 17, 17, 17, 16, 17, 17, 16, 18, 17,
 21, 17, 18, 17, 18, 17, 18, 17, 17, 17, 17, 19
};

static const unsigned char coef5_huffbits[ 435 ] __attribute__(   (  section( ".data" )  )   ) = {
 10,  4,  2,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  7,
  7,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  7,  8,  8,
  8,  8,  8,  8,  8,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9, 10,  9, 10, 10, 10, 10, 10,  9, 10, 10, 10, 10, 10, 10,
 10, 10, 11, 11, 10, 10, 11, 11, 10, 11, 11, 11, 11, 11, 12, 12,
 12, 12, 12, 12, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 12, 12, 13, 13, 13, 12,
 12, 12, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 13, 13, 13,
 13, 13, 14, 14, 14, 14, 14, 14, 15, 14, 14, 14, 14, 14, 14, 13,
 14, 14, 14, 14, 14, 14, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15,
 16, 15, 15, 14, 15, 16, 15, 14, 14, 15, 14, 14, 15, 14, 15, 15,
 15, 16, 15, 17, 16, 15, 15, 15, 15, 16, 16, 16, 16, 17, 15, 16,
 14, 16, 16, 17, 16, 16, 16, 16, 16, 15, 15, 15, 16, 16, 16, 16,
 17, 15, 15, 15, 15, 16, 15, 15,  4,  7,  8,  8,  9,  9,  9, 10,
 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12,
 12, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13,
 12, 13, 14, 14, 15, 15, 14, 14, 14, 14, 14, 14, 14, 15, 14, 14,
 14, 15, 15, 15, 14, 14, 15, 15, 15, 16, 16, 18, 17, 15, 15, 15,
  6,  9, 10, 10, 11, 11, 12, 12, 12, 13, 12, 12, 12, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 15,
 15, 15, 14, 14, 15, 16, 15, 14, 14, 15,  7, 10, 11, 12, 13, 13,
 13, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 14, 15,
 16, 15, 15, 16, 15, 15, 15, 16, 15, 16, 18, 17, 15, 15, 16, 16,
 17, 15,  8, 11, 13, 13, 14, 15, 14, 16, 15, 16, 15, 15, 15, 15,
 15, 15, 17, 15,  9, 12, 14, 15, 10, 13, 14, 15, 10, 13, 11, 14,
 11, 14, 11, 15, 12, 15, 12, 12, 13, 15, 13, 14, 13, 14, 14, 14,
 14, 14, 15, 15, 15, 15, 14, 15, 15, 16, 16, 16, 15, 16, 16, 15,
 16, 17, 16
};

static const unsigned int coef0_huffcodes[ 666 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00258, 0x0003D, 0x00000, 0x00005, 0x00008, 0x00008, 0x0000C, 0x0001B,
 0x0001F, 0x00015, 0x00024, 0x00032, 0x0003A, 0x00026, 0x0002C, 0x0002F,
 0x0004A, 0x0004D, 0x00061, 0x00070, 0x00073, 0x00048, 0x00052, 0x0005A,
 0x0005D, 0x0006E, 0x00099, 0x0009E, 0x000C1, 0x000CE, 0x000E4, 0x000F0,
 0x00093, 0x0009E, 0x000A2, 0x000A1, 0x000B8, 0x000D2, 0x000D3, 0x0012E,
 0x00130, 0x000DE, 0x0012D, 0x0019B, 0x001E4, 0x00139, 0x0013A, 0x0013F,
 0x0014F, 0x0016D, 0x001A2, 0x0027C, 0x0027E, 0x00332, 0x0033C, 0x0033F,
 0x0038B, 0x00396, 0x003C5, 0x00270, 0x0027C, 0x0025A, 0x00395, 0x00248,
 0x004BD, 0x004FB, 0x00662, 0x00661, 0x0071B, 0x004E6, 0x004FF, 0x00666,
 0x0071C, 0x0071A, 0x0071F, 0x00794, 0x00536, 0x004E2, 0x0078E, 0x004EE,
 0x00518, 0x00535, 0x004FB, 0x0078D, 0x00530, 0x00680, 0x0068F, 0x005CB,
 0x00965, 0x006A6, 0x00967, 0x0097F, 0x00682, 0x006AE, 0x00CD0, 0x00E28,
 0x00F13, 0x00F1F, 0x009F5, 0x00CD3, 0x00F11, 0x00926, 0x00964, 0x00F32,
 0x00F12, 0x00F30, 0x00966, 0x00D0B, 0x00A68, 0x00B91, 0x009C7, 0x00B73,
 0x012FA, 0x0131D, 0x013F9, 0x01CA0, 0x0199C, 0x01C7A, 0x0198C, 0x01248,
 0x01C74, 0x01C64, 0x0139E, 0x012FD, 0x00A77, 0x012FC, 0x01C7B, 0x012CA,
 0x014CC, 0x014D2, 0x014E3, 0x014DC, 0x012DC, 0x03344, 0x02598, 0x0263C,
 0x0333B, 0x025E6, 0x01A1C, 0x01E3C, 0x014E2, 0x033D4, 0x01A11, 0x03349,
 0x03CCE, 0x014E1, 0x01A34, 0x0273E, 0x02627, 0x0273F, 0x038EE, 0x03971,
 0x03C67, 0x03C61, 0x0333D, 0x038C2, 0x0263F, 0x038CD, 0x02638, 0x02E41,
 0x0351F, 0x03348, 0x03C66, 0x03562, 0x02989, 0x027D5, 0x0333C, 0x02E4F,
 0x0343B, 0x02DDF, 0x04BC8, 0x029C0, 0x02E57, 0x04C72, 0x025B7, 0x03547,
 0x03540, 0x029D3, 0x04C45, 0x025BB, 0x06600, 0x04C73, 0x04BCE, 0x0357B,
 0x029A6, 0x029D2, 0x0263E, 0x0298A, 0x07183, 0x06602, 0x07958, 0x04B66,
 0x0537D, 0x05375, 0x04FE9, 0x04B67, 0x0799F, 0x04BC9, 0x051FE, 0x06A3B,
 0x05BB6, 0x04FA8, 0x0728F, 0x05376, 0x0492C, 0x0537E, 0x0795A, 0x06A3C,
 0x0E515, 0x07887, 0x0683A, 0x051F9, 0x051FD, 0x0CC6A, 0x06A8A, 0x0CC6D,
 0x05BB3, 0x0683B, 0x051FC, 0x05378, 0x0728E, 0x07886, 0x05BB7, 0x0F2A4,
 0x0795B, 0x0683C, 0x09FC1, 0x0683D, 0x0B752, 0x09678, 0x0A3E8, 0x06AC7,
 0x051F0, 0x0B759, 0x06AF3, 0x04B6B, 0x0F2A0, 0x0F2AD, 0x096C3, 0x0E518,
 0x0B75C, 0x0D458, 0x0CC6B, 0x0537C, 0x067AA, 0x04FEA, 0x0343A, 0x0CC71,
 0x0967F, 0x09FC4, 0x096C2, 0x0E516, 0x0F2A1, 0x0D45C, 0x0D45D, 0x0D45E,
 0x12FB9, 0x0967E, 0x1982F, 0x09883, 0x096C4, 0x0B753, 0x12FB8, 0x0F2A8,
 0x1CA21, 0x096C5, 0x0E51A, 0x1CA27, 0x12F3C, 0x0D471, 0x0F2AA, 0x0B75B,
 0x12FBB, 0x0F2A9, 0x0F2AC, 0x0D45A, 0x0B74F, 0x096C8, 0x16E91, 0x096CA,
 0x12FBF, 0x0D0A7, 0x13103, 0x0D516, 0x16E99, 0x12CBD, 0x0A3EA, 0x19829,
 0x0B755, 0x29BA7, 0x1CA28, 0x29BA5, 0x16E93, 0x1982C, 0x19828, 0x25994,
 0x0A3EB, 0x1CA29, 0x16E90, 0x1CA25, 0x1982D, 0x1CA26, 0x16E9B, 0x0B756,
 0x0967C, 0x25997, 0x0B75F, 0x198D3, 0x0B757, 0x19A2A, 0x0D45B, 0x0E517,
 0x1CA24, 0x1CA23, 0x1CA22, 0x0B758, 0x16E97, 0x0CD14, 0x13100, 0x00007,
 0x0003B, 0x0006B, 0x00097, 0x00138, 0x00125, 0x00173, 0x00258, 0x00335,
 0x0028E, 0x004C6, 0x00715, 0x00729, 0x004EF, 0x00519, 0x004ED, 0x00532,
 0x0068C, 0x00686, 0x00978, 0x00E5D, 0x00E31, 0x009F4, 0x00B92, 0x012F8,
 0x00D06, 0x00A67, 0x00D44, 0x00A76, 0x00D59, 0x012CD, 0x01C78, 0x01C75,
 0x0199F, 0x0198F, 0x01C67, 0x014C6, 0x01C79, 0x01C76, 0x00B94, 0x00D1B,
 0x01E32, 0x01E31, 0x01AB0, 0x01A05, 0x01AA1, 0x0333A, 0x025E5, 0x02626,
 0x03541, 0x03544, 0x03421, 0x03546, 0x02E55, 0x02E56, 0x0492D, 0x02DDE,
 0x0299B, 0x02DDC, 0x0357A, 0x0249C, 0x0668B, 0x1C77F, 0x1CA20, 0x0D45F,
 0x09886, 0x16E9A, 0x0F2A7, 0x0B751, 0x0A3EE, 0x0CF59, 0x0CF57, 0x0B754,
 0x0D0A6, 0x16E98, 0x0B760, 0x06AC6, 0x0A3F0, 0x12FBE, 0x13104, 0x0F2A5,
 0x0A3EF, 0x0D472, 0x12CBA, 0x1982E, 0x16E9C, 0x1C77E, 0x198D0, 0x13105,
 0x16E92, 0x0B75D, 0x0D459, 0x0001A, 0x000C0, 0x0016C, 0x003CD, 0x00350,
 0x0067B, 0x0051E, 0x006A9, 0x009F4, 0x00B72, 0x00D09, 0x01249, 0x01E3D,
 0x01CA1, 0x01A1F, 0x01721, 0x01A8A, 0x016E8, 0x03347, 0x01A35, 0x0249D,
 0x0299A, 0x02596, 0x02E4E, 0x0298B, 0x07182, 0x04C46, 0x025BA, 0x02E40,
 0x027D6, 0x04FE8, 0x06607, 0x05310, 0x09884, 0x072E1, 0x06A3D, 0x04B6A,
 0x04C7A, 0x06603, 0x04C7B, 0x03428, 0x06605, 0x09664, 0x09FC0, 0x071DE,
 0x06601, 0x05BB2, 0x09885, 0x0A3E2, 0x1C61F, 0x12CBB, 0x0B750, 0x0CF58,
 0x0967D, 0x25995, 0x668AD, 0x0B75A, 0x09FC2, 0x0537F, 0x0B75E, 0x13FAE,
 0x12FBC, 0x00031, 0x001C4, 0x004C5, 0x005B8, 0x00CF4, 0x0096F, 0x00D46,
 0x01E57, 0x01A04, 0x02625, 0x03346, 0x028F9, 0x04C47, 0x072E0, 0x04B69,
 0x03420, 0x07957, 0x06639, 0x0799E, 0x07959, 0x07881, 0x04B68, 0x09FC3,
 0x09FD6, 0x0CC70, 0x0A3F1, 0x12CBE, 0x0E30E, 0x0E51B, 0x06AF2, 0x12CBC,
 0x1C77D, 0x0F2AB, 0x12FBD, 0x1AA2F, 0x0A3EC, 0x0D473, 0x05377, 0x0A3E9,
 0x1982B, 0x0E300, 0x12F3F, 0x0CF5F, 0x096C0, 0x38C3C, 0x16E94, 0x16E95,
 0x12F3D, 0x29BA4, 0x29BA6, 0x1C77C, 0x6A8BA, 0x3545C, 0x33457, 0x668AC,
 0x6A8BB, 0x16E9D, 0x0E519, 0x25996, 0x12F3E, 0x00036, 0x0033E, 0x006AD,
 0x00D03, 0x012C8, 0x0124A, 0x03C42, 0x03CCD, 0x06606, 0x07880, 0x06852,
 0x06A3A, 0x05BB4, 0x0F2A2, 0x09FC7, 0x12CB9, 0x0CC6C, 0x0A6E8, 0x096C1,
 0x0004A, 0x00355, 0x012F9, 0x014E8, 0x01ABE, 0x025B6, 0x0492E, 0x09FC6,
 0x051FF, 0x0CC6F, 0x096CB, 0x0D071, 0x198D1, 0x12CB8, 0x38C3D, 0x13FAF,
 0x096C9, 0x0009D, 0x00539, 0x012CE, 0x0341F, 0x029C1, 0x04B33, 0x0A3E3,
 0x0D070, 0x16E96, 0x0B763, 0x000A0, 0x009CE, 0x038CC, 0x0343D, 0x051FA,
 0x09888, 0x12FBA, 0x000DF, 0x00A75, 0x029A7, 0x09FC5, 0x0E301, 0x0967B,
 0x001E7, 0x012C9, 0x051FB, 0x09889, 0x0F2A6, 0x0016F, 0x01CB9, 0x0CF5A,
 0x12CBF, 0x09679, 0x00272, 0x01A15, 0x0967A, 0x003CB, 0x025F6, 0x0B762,
 0x0028D, 0x03C60, 0x0CF5E, 0x00352, 0x03CCC, 0x0072F, 0x07186, 0x004EC,
 0x05379, 0x0068E, 0x09887, 0x006A7, 0x06AF1, 0x00E29, 0x0CF5B, 0x00F31,
 0x0D470, 0x009C6, 0x013FB, 0x13102, 0x019A5, 0x13101, 0x01983, 0x01C65,
 0x0124F, 0x014C7, 0x01726, 0x01ABF, 0x03304, 0x02624, 0x03C41, 0x027D7,
 0x02DDD, 0x02E54, 0x0343C, 0x06604, 0x07181, 0x0663A, 0x04FA9, 0x0663B,
 0x05311, 0x0537A, 0x06839, 0x05BB5, 0x0492F, 0x06AF0, 0x096C7, 0x0CC6E,
 0x0537B, 0x0CF5C, 0x0CF56, 0x198D2, 0x0CF5D, 0x0A3ED, 0x0F2A3, 0x1982A,
 0x0B761, 0x096C6
};

static const unsigned int coef1_huffcodes[ 555 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00115, 0x00002, 0x00001, 0x00000, 0x0000D, 0x00007, 0x00013, 0x0001D,
 0x00008, 0x0000C, 0x00023, 0x0002B, 0x0003F, 0x00017, 0x0001B, 0x00043,
 0x00049, 0x00050, 0x00055, 0x00054, 0x00067, 0x00064, 0x0007B, 0x0002D,
 0x00028, 0x0002A, 0x00085, 0x00089, 0x0002B, 0x00035, 0x00090, 0x00091,
 0x00094, 0x00088, 0x000C1, 0x000C6, 0x000F2, 0x000E3, 0x000C5, 0x000E2,
 0x00036, 0x000F0, 0x000A7, 0x000CD, 0x000FB, 0x00059, 0x00116, 0x00103,
 0x00108, 0x0012B, 0x0012D, 0x00188, 0x0012E, 0x0014C, 0x001C3, 0x00187,
 0x001E7, 0x0006F, 0x00094, 0x00069, 0x001E6, 0x001CA, 0x00147, 0x00195,
 0x000A7, 0x00213, 0x00209, 0x00303, 0x00295, 0x00289, 0x0028C, 0x0028D,
 0x00312, 0x00330, 0x0029B, 0x00308, 0x00328, 0x0029A, 0x0025E, 0x003C5,
 0x00384, 0x0039F, 0x00397, 0x00296, 0x0032E, 0x00332, 0x003C6, 0x003E6,
 0x0012D, 0x000D1, 0x00402, 0x000DD, 0x00161, 0x0012B, 0x00127, 0x0045D,
 0x00601, 0x004AB, 0x0045F, 0x00410, 0x004BF, 0x00528, 0x0045C, 0x00424,
 0x00400, 0x00511, 0x00618, 0x0073D, 0x0063A, 0x00614, 0x0073C, 0x007C0,
 0x007CF, 0x00802, 0x00966, 0x00964, 0x00951, 0x008A0, 0x00346, 0x00803,
 0x00A52, 0x0024A, 0x007C1, 0x0063F, 0x00126, 0x00406, 0x00789, 0x008A2,
 0x00960, 0x00967, 0x00C05, 0x00C70, 0x00C79, 0x00A5D, 0x00C26, 0x00C4D,
 0x00372, 0x008A5, 0x00C08, 0x002C5, 0x00F11, 0x00CC4, 0x00F8E, 0x00E16,
 0x00496, 0x00E77, 0x00F9C, 0x00C25, 0x00F1E, 0x00C27, 0x00F1F, 0x00E17,
 0x00CCD, 0x00355, 0x00C09, 0x00C78, 0x00F90, 0x00521, 0x00357, 0x00356,
 0x0068E, 0x00F9D, 0x00C04, 0x00E58, 0x00A20, 0x00A2C, 0x00C4C, 0x0052F,
 0x00F8D, 0x01178, 0x01053, 0x01097, 0x0180F, 0x0180D, 0x012FB, 0x012AA,
 0x0202A, 0x00A40, 0x018ED, 0x01CEB, 0x01455, 0x018E3, 0x012A1, 0x00354,
 0x00353, 0x00F1C, 0x00C7B, 0x00C37, 0x0101D, 0x012CB, 0x01142, 0x0197D,
 0x01095, 0x01E3B, 0x0186B, 0x00588, 0x01C2A, 0x014B8, 0x01E3A, 0x018EC,
 0x01F46, 0x012FA, 0x00A53, 0x01CE8, 0x00A55, 0x01C29, 0x0117B, 0x01052,
 0x012A0, 0x00589, 0x00950, 0x01C2B, 0x00A50, 0x0208B, 0x0180E, 0x02027,
 0x02556, 0x01E20, 0x006E7, 0x01C28, 0x0197A, 0x00684, 0x020A2, 0x01F22,
 0x03018, 0x039CF, 0x03E25, 0x02557, 0x0294C, 0x028A6, 0x00D11, 0x028A9,
 0x02979, 0x00D46, 0x00A56, 0x039CE, 0x030CC, 0x0329A, 0x0149D, 0x0510F,
 0x0451C, 0x02028, 0x03299, 0x01CED, 0x014B9, 0x00F85, 0x00C7A, 0x01800,
 0x00341, 0x012CA, 0x039C8, 0x0329D, 0x00D0D, 0x03E20, 0x05144, 0x00D45,
 0x030D0, 0x0186D, 0x030D5, 0x00D0F, 0x00D40, 0x04114, 0x020A1, 0x0297F,
 0x03E24, 0x032F1, 0x04047, 0x030D4, 0x028A8, 0x00D0E, 0x0451D, 0x04044,
 0x0297E, 0x04042, 0x030D2, 0x030CF, 0x03E21, 0x03E26, 0x028A5, 0x0451A,
 0x00D48, 0x01A16, 0x00D44, 0x04518, 0x0149B, 0x039CA, 0x01498, 0x0403D,
 0x0451B, 0x0149C, 0x032F3, 0x030CB, 0x08073, 0x03E22, 0x0529A, 0x020AA,
 0x039CC, 0x0738A, 0x06530, 0x07389, 0x06193, 0x08071, 0x04043, 0x030CE,
 0x05147, 0x07388, 0x05145, 0x08072, 0x04521, 0x00D47, 0x0297C, 0x030CD,
 0x030CA, 0x0000B, 0x0000C, 0x00083, 0x000E4, 0x00048, 0x00102, 0x001CC,
 0x001F5, 0x00097, 0x0020B, 0x00124, 0x00453, 0x00627, 0x00639, 0x00605,
 0x00517, 0x001B8, 0x00663, 0x00667, 0x007C3, 0x00823, 0x00961, 0x00963,
 0x00E5A, 0x00E59, 0x00A2B, 0x00CBF, 0x00292, 0x00A2D, 0x007D0, 0x00953,
 0x00CC5, 0x00F84, 0x004AB, 0x014A7, 0x0068A, 0x0117A, 0x0052E, 0x01442,
 0x0052C, 0x00C77, 0x00F8F, 0x004AA, 0x01094, 0x01801, 0x012C4, 0x0297B,
 0x00952, 0x01F19, 0x006A5, 0x01149, 0x012C5, 0x01803, 0x022F2, 0x0329B,
 0x04520, 0x0149E, 0x00D13, 0x01F16, 0x01CE9, 0x0101C, 0x006E6, 0x039C9,
 0x06191, 0x07C8E, 0x06192, 0x0CA63, 0x039CD, 0x06190, 0x06884, 0x06885,
 0x07382, 0x00D49, 0x00D41, 0x0450C, 0x0149A, 0x030D1, 0x08077, 0x03E23,
 0x01A15, 0x0E701, 0x0E702, 0x08079, 0x0822A, 0x0A218, 0x07887, 0x0403F,
 0x0520B, 0x0529B, 0x0E700, 0x04519, 0x00007, 0x000E0, 0x000D0, 0x0039B,
 0x003E5, 0x00163, 0x0063E, 0x007C9, 0x00806, 0x00954, 0x01044, 0x01F44,
 0x0197C, 0x01F45, 0x00A51, 0x01F47, 0x00951, 0x0052D, 0x02291, 0x0092F,
 0x00A54, 0x00D12, 0x0297D, 0x00D0C, 0x01499, 0x0329E, 0x032F0, 0x02025,
 0x039C6, 0x00A57, 0x03E46, 0x00D42, 0x0738B, 0x05146, 0x04046, 0x08078,
 0x0510E, 0x07886, 0x02904, 0x04156, 0x04157, 0x06032, 0x030D3, 0x08BCE,
 0x04040, 0x0403E, 0x0A414, 0x10457, 0x08075, 0x06887, 0x07C8F, 0x039C7,
 0x07387, 0x08070, 0x08BCF, 0x1482A, 0x10456, 0x1482B, 0x01A17, 0x06886,
 0x0450D, 0x00013, 0x0006B, 0x00615, 0x0080B, 0x0082B, 0x00952, 0x00E5B,
 0x018E2, 0x0186C, 0x01F18, 0x0329F, 0x00D43, 0x03E29, 0x05140, 0x05141,
 0x0CA62, 0x06033, 0x03C42, 0x03E28, 0x0450F, 0x0A21A, 0x07384, 0x0A219,
 0x0E703, 0x0A21B, 0x01A14, 0x07383, 0x045E6, 0x0007A, 0x0012C, 0x00CCC,
 0x0068F, 0x01802, 0x00A52, 0x00953, 0x04045, 0x01A20, 0x0451F, 0x000A4,
 0x00735, 0x01CEC, 0x02029, 0x020A3, 0x0451E, 0x00069, 0x00C24, 0x02024,
 0x032F2, 0x05142, 0x00196, 0x00523, 0x000A6, 0x0197B, 0x0030B, 0x0092E,
 0x003E9, 0x03E27, 0x00160, 0x05143, 0x00652, 0x04041, 0x00734, 0x028A7,
 0x0080F, 0x01483, 0x0097C, 0x00340, 0x0068B, 0x00522, 0x01054, 0x01096,
 0x01F17, 0x0202B, 0x01CEA, 0x020A0, 0x02978, 0x02026, 0x0297A, 0x039CB,
 0x03E2B, 0x0149F, 0x0329C, 0x07385, 0x08074, 0x0450E, 0x03E2A, 0x05149,
 0x08076, 0x07386, 0x05148
};

static const unsigned int coef2_huffcodes[ 1336 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x003E6,  0x000F6, 0x00000,  0x00002,  0x00006,  0x0000F,  0x0001B,  0x00028,
 0x00039,  0x0003F, 0x0006B,  0x00076,  0x000B7,  0x000E8,  0x000EF,  0x00169,
 0x001A7,  0x001D4, 0x001DC,  0x002C4,  0x00349,  0x00355,  0x00391,  0x003DC,
 0x00581,  0x005B2, 0x00698,  0x0070C,  0x00755,  0x0073A,  0x00774,  0x007CF,
 0x00B0A,  0x00B66, 0x00D2E,  0x00D5E,  0x00E1B,  0x00EAC,  0x00E5A,  0x00F7E,
 0x00FA1,  0x0163E, 0x01A37,  0x01A52,  0x01C39,  0x01AB3,  0x01D5F,  0x01CB6,
 0x01F52,  0x01DD9, 0x02C04,  0x02C2E,  0x02C2D,  0x02C23,  0x03467,  0x034A3,
 0x0351B,  0x03501, 0x03A5D,  0x0351C,  0x03875,  0x03DEA,  0x0397B,  0x039DB,
 0x03DF1,  0x039D8, 0x03BB4,  0x0580A,  0x0584D,  0x05842,  0x05B13,  0x058EA,
 0x0697D,  0x06A06, 0x068CC,  0x06AC7,  0x06A96,  0x072F4,  0x07543,  0x072B4,
 0x07D20,  0x0B003, 0x073B5,  0x07BE6,  0x0D180,  0x07BD1,  0x07CB8,  0x07D06,
 0x07D25,  0x0D2F2, 0x0D19A,  0x0D334,  0x0E1DC,  0x0D529,  0x0D584,  0x0E1D2,
 0x0E5E3,  0x0EEC4, 0x0E564,  0x0FA49,  0x16001,  0x0EEDC,  0x0F7FA,  0x1A32C,
 0x16131,  0x16003, 0x0F9C8,  0x1EF80,  0x1D2A0,  0x1AA4B,  0x0F7CE,  0x1ABFE,
 0x1AA50,  0x1A458, 0x1A816,  0x1CAE4,  0x1D2FE,  0x1D52E,  0x1AA4C,  0x2C245,
 0x1D2A1,  0x1A35D, 0x1CA1B,  0x1D5D8,  0x1F531,  0x1CA1C,  0x1F389,  0x1F4AF,
 0x3A5E7,  0x351FB, 0x2C24B,  0x34BCE,  0x2C24D,  0x2C249,  0x2C24A,  0x72DFC,
 0x357EF,  0x35002, 0x3A5E6,  0x39431,  0x5843B,  0x34A77,  0x58431,  0x3A5F3,
 0x3A5DD,  0x3E5E5, 0x356BD,  0x3976E,  0x6A3D2,  0x3500D,  0x694C4,  0x580BD,
 0x3E5E8,  0x74B95, 0x34A6E,  0x3977C,  0x39432,  0x5B0D2,  0x6A3D8,  0x580B8,
 0x5B0CB,  0x5B0D7, 0x72DEE,  0x72DED,  0x72DEC,  0x74B9C,  0x3977F,  0x72DEA,
 0x74B9E,  0x7BE7D, 0x580BF,  0x5B0D5,  0x7CBA8,  0x74B91,  0x3E5DD,  0xB6171,
 0xD46B3,  0xD46B9, 0x7CBA1,  0x74B9F,  0x72DE1,  0xE59F5,  0x3E5EB,  0x00004,
 0x00015,  0x00038, 0x00075,  0x000E8,  0x001D3,  0x00347,  0x0039C,  0x00690,
 0x0074A,  0x00B60, 0x00E93,  0x00F74,  0x0163D,  0x01A5A,  0x01D24,  0x01CBE,
 0x01F4B,  0x03468, 0x03562,  0x03947,  0x03E82,  0x05804,  0x05B12,  0x05803,
 0x0696D,  0x06A9E, 0x0697C,  0x06978,  0x06AFB,  0x074B2,  0x072F5,  0x073C0,
 0x07541,  0x06944, 0x074B7,  0x070D3,  0x07BA9,  0x0B0B1,  0x0D1AF,  0x0E1DD,
 0x0E5E2,  0x0E1A3, 0x0EEC3,  0x1612F,  0x0E961,  0x0EEDA,  0x0E78E,  0x0FA48,
 0x1612C,  0x0E511, 0x0E565,  0x0E953,  0x1AA4A,  0x0E59D,  0x1D52C,  0x1A811,
 0x1CAE7,  0x1ABFC, 0x1D52D,  0x1CACF,  0x1CF05,  0x2C254,  0x34A72,  0x1F4AC,
 0x3976B,  0x34A71, 0x2C6D9,  0x2D873,  0x34A6A,  0x357E7,  0x3464C,  0x3E5F5,
 0x58433,  0x1F53A, 0x3500A,  0x357EA,  0x34A73,  0x3942F,  0x357E5,  0x39775,
 0x694CD,  0x39772, 0x7CBA5,  0x6A3EF,  0x35483,  0x74B98,  0x5B0C1,  0x39770,
 0x3A5D7,  0x39433, 0x39434,  0x694CE,  0x580BE,  0x3E5FF,  0x6A3EC,  0xB616F,
 0xD46B1,  0x6A3D1, 0x72DE5,  0x74B6E,  0x72DE9,  0x3E700,  0xD46B6,  0x6A3E9,
 0x74B69,  0xE5675, 0xD46B8,  0x7CBAA,  0x3A5D1,  0x0000C,  0x0003C,  0x000EB,
 0x001F1,  0x003A4, 0x006A8,  0x007D5,  0x00D43,  0x00E77,  0x016C5,  0x01CB1,
 0x02C5D,  0x03A55, 0x03A56,  0x03E51,  0x03BB5,  0x05B0A,  0x06A9F,  0x074B8,
 0x07D28,  0x0D187, 0x0D40E,  0x0D52E,  0x0D425,  0x0EAE3,  0x0E1D3,  0x1612E,
 0x0E59E,  0x0EEC2, 0x0E578,  0x0E51A,  0x0E579,  0x0E515,  0x0E960,  0x0D183,
 0x0D220,  0x0D2CB, 0x0E512,  0x16C3E,  0x16002,  0x16C42,  0x1CAE9,  0x3461A,
 0x1D2FA,  0x1A308, 0x1A849,  0x1CF07,  0x1F38F,  0x34B65,  0x2C253,  0x1EF9E,
 0x1CBC3,  0x1CBC1, 0x2C255,  0x1F384,  0x58435,  0x2C5CD,  0x3A5F7,  0x2C252,
 0x3959C,  0x2C6D8, 0x3A5D3,  0x6AD78,  0x6A3F2,  0x7CBA9,  0xB6176,  0x72DEB,
 0x39764,  0x3E5F6, 0x3A5D8,  0x74A8C,  0x6A3E6,  0x694D1,  0x6AD79, 0x1A4592,
 0xE59FB,  0x7CBB3, 0x5B0CD,  0x00017,  0x000B5,  0x002C3,  0x005B7,  0x00B1C,
 0x00E5C,  0x0163F, 0x01AB2,  0x01EFA,  0x0348A,  0x0396E,  0x058DA,  0x06963,
 0x06A30,  0x072CD, 0x073CF,  0x07CE7,  0x0D2CA,  0x0D2D8,  0x0E764,  0x0E794,
 0x16008,  0x16167, 0x1617E,  0x1AA49,  0x1A30B,  0x1A813,  0x2C6DA,  0x1A580,
 0x1CBC2,  0x0F9CA, 0x1617F,  0x1D2FE,  0x0F7FC,  0x16C40,  0x0E513,  0x0EEC5,
 0x0F7C3,  0x1D508, 0x1A81E,  0x1D2FD,  0x39430,  0x35486,  0x3E5FD,  0x2C24C,
 0x2C75A,  0x34A74, 0x3A5F4,  0x3464D,  0x694CA,  0x3A5F1,  0x1D509,  0x1D5C0,
 0x34648,  0x3464E, 0x6A3D5,  0x6A3E8,  0x6A3E7,  0x5B0C3,  0x2C248,  0x1F38A,
 0x3A5F2,  0x6A3E5, 0x00029,  0x00168,  0x0058C,  0x00B67,  0x00F9D,  0x01C3D,
 0x01CBF,  0x02C20, 0x0351D,  0x03DF6,  0x06AF9,  0x072B5,  0x0B1D7,  0x0B0B2,
 0x0D40A,  0x0D52B, 0x0E952,  0x0E797,  0x163C3,  0x1C3A0,  0x1F386,  0x1CA21,
 0x34655,  0x2C247, 0x1F53B,  0x2C250,  0x2C24F,  0x1F385,  0x1EF5D,  0x1CF15,
 0x1CAEA,  0x1AB0A, 0x1CF19,  0x1F53D,  0x1D5C2,  0x1D2FB,  0x1EF58,  0x34A78,
 0x357EC,  0x1F533, 0x3A5E1,  0x694D2,  0x58482,  0x3A5EE,  0x2C6DC,  0x357EB,
 0x5B0C4,  0x39778, 0x6A3E1,  0x7CBB4,  0x3A5E1,  0x74B68,  0x3A5EF,  0x3A5D2,
 0x39424,  0x72DE2, 0xE59F6,  0xE59F7,  0x3E702,  0x3E5EC,  0x1F38B,  0x0003B,
 0x001F0,  0x00777, 0x00FA8,  0x01CB2,  0x02D84,  0x03A57,  0x03DD6,  0x06917,
 0x06A11,  0x07D07, 0x0EAE2,  0x0E796,  0x0F9C9,  0x0F7FB,  0x16166,  0x16160,
 0x1AB1B,  0x1ABFA, 0x2D87B,  0x1D2F7,  0x39768,  0x1F38C,  0x34653,  0x34651,
 0x6A3D9,  0x35001, 0x3ABBD,  0x38742,  0x39426,  0x34A76,  0x3A5EC,  0x34A75,
 0x35000,  0x35488, 0x1CF10,  0x2C6DB,  0x357ED,  0x357E8,  0x357E9,  0x3A5F0,
 0x694C2,  0xB6178, 0x72DF5,  0x39425,  0x3942B,  0x74B6D,  0x74B6F,  0xB6177,
 0xB6179,  0x74B6A, 0xB6172,  0x58487,  0x3E5EE,  0x3E5ED,  0x72DF2,  0x72DF4,
 0x7CBAE,  0x6A3CA, 0x70E86,  0x34BCF,  0x6A3C8,  0x00059,  0x00384,  0x00D5B,
 0x01C38,  0x03560, 0x0395B,  0x0584E,  0x06964,  0x073CD,  0x0B1E7,  0x0E798,
 0x0E78D,  0x0FA43, 0x1A848,  0x1A32F,  0x1AA4E,  0x3464A,  0x1F4AB,  0x1F38D,
 0x3A5EB,  0x3A5D4, 0x3548A,  0x6A3C7,  0x5B0D0,  0x6A3C5,  0x7CBB0,  0x694CB,
 0x3A5E5,  0x3E5E2, 0x3942C,  0x2D872,  0x1F4AE,  0x3A5D5,  0x694D3,  0x58481,
 0x35009,  0x39774, 0x58432,  0xB616C,  0x5B0DB,  0x3548B,  0xB6174, 0x1D5D95,
 0xB004C,  0x7CBB2, 0x3A5E5,  0x74A8F,  0xE59F9,  0x72DF6,  0xE59FD,  0x7CBAD,
 0xD427D,  0x72CFF, 0x3977A,  0x5B0D9,  0xB616D,  0xB616B, 0x1A4593,  0x7CBAF,
 0x5B0DA,  0x00071, 0x003EB,  0x01603,  0x02C6C,  0x03961,  0x068C8,  0x06A31,
 0x072BD,  0x0D2C2, 0x0E51B,  0x0E5E6,  0x1ABFB,  0x1D2FF,  0x1CAE5,  0x1EF5C,
 0x1EF5E,  0x1CF13, 0x34A6D,  0x3976D,  0xB616A,  0x3E5F2,  0x6A3C4,  0xB6169,
 0x3E5DC,  0x580B9, 0x74B99,  0x75764,  0x58434,  0x3A5D9,  0x6945A,  0x69459,
 0x3548C,  0x3A5E9, 0x69457,  0x72DF1,  0x6945E,  0x6A35E,  0x3E701,  0xB6168,
 0x5B0DD,  0x3A5DE, 0x6A3C2,  0xD4278,  0x6A3CC,  0x72DFD,  0xB6165, 0x16009A,
 0x7CBB1,  0xD427C, 0xB6162,  0xE765E, 0x1CECBE,  0x7CBB6,  0x69454,  0xB6160,
 0xD427A, 0x1D5D96, 0xB1D6D,  0xE59F4,  0x72DE8,  0x3A5DB,  0x0007A,  0x006AE,
 0x01C3C,  0x03ABA, 0x058E9,  0x072CC,  0x0D2DD,  0x0D22D,  0x0EEC1,  0x0EEDB,
 0x1D2A2,  0x1EF5B, 0x357E2,  0x3ABBF,  0x1D2F9,  0x35004,  0x3A5DC,  0x351FC,
 0x3976C,  0x6A3C6, 0x6A3CB,  0x3E5EA,  0xE59F3,  0x6A3CE,  0x69452,  0xE59F0,
 0x74B90,  0xD4279, 0xD427B,  0x7CBB5,  0x5B0C5,  0x3A5E3,  0x3A5E2,  0x000D0,
 0x00775,  0x01EFE, 0x03DD5,  0x0728C,  0x07CB9,  0x0E1A2,  0x0EA85,  0x0EED8,
 0x1A30A,  0x1AA4F, 0x3A5DF,  0x35008,  0x3A5E0,  0x3E5F4,  0x3E5F7,  0xB1D6C,
 0x5843E,  0x34A70, 0x72DF8,  0x74B6B,  0xD427F,  0x72DF0,  0x5B0BF,  0x5B0C0,
 0xD46B0,  0x72DEF, 0xE59F8, 0x162E64,  0xB1D6F,  0x3A5E0,  0x39427,  0x69166,
 0x6A3E2,  0x6A3E3, 0x74A8D,  0xD427E, 0x1D5D97,  0xD46B4,  0x5B0D8,  0x6A3D3,
 0x000E0,  0x00B63, 0x034CC,  0x06A33,  0x073C9,  0x0E1A0,  0x0F7FD,  0x0F9CC,
 0x1617D,  0x1CAEB, 0x1F4A9,  0x3ABB3,  0x69450,  0x39420,  0x39777,  0x3E5E0,
 0x6A3D4,  0x6A3ED, 0xB6166,  0xE59F1,  0xB1D6E,  0xE5676,  0x6A3EA,  0xE5674,
 0xB6163,  0xD46B7, 0x7CBA6,  0xD46BA, 0x1D5D94,  0xB6164,  0x6A3F1,  0x7CBA2,
 0x69451,  0x72DFA, 0xD46BB,  0x72DF7,  0x74B94, 0x1CECBF,  0xE59FA, 0x16009B,
 0x6A3E4,  0x000E6, 0x00E94,  0x03876,  0x070EF,  0x0D52A,  0x16015,  0x16014,
 0x1ABF9,  0x1CF17, 0x34A79,  0x34650,  0x3E705,  0x6A3D0,  0x58430,  0x74B9D,
 0x7BE7E,  0x5B0BE, 0x39773,  0x6A3DE,  0x000FB,  0x00F7B,  0x03DD7,  0x07BD0,
 0x0E59C,  0x0F9CD, 0x1CF18,  0x1D2FF,  0x34A7A,  0x39429,  0x3500C,  0x72DE0,
 0x69456,  0x7BE7C, 0xD46B5,  0xD46B2,  0x6A3DD,  0x001A2,  0x0163B,  0x06913,
 0x0B016,  0x0FA42, 0x1A32D,  0x1CF06,  0x34A7C,  0x34A7D,  0xB6161,  0x35481,
 0x3E5FA,  0x7CBA0, 0x7BE7F,  0x7CBA3,  0x7CBA7,  0x5B0D3,  0x72DE6,  0x6A3DC,
 0x001A9,  0x01AB4, 0x06A34,  0x0D46A,  0x16130,  0x1EF5F,  0x1F532,  0x1F536,
 0x3942E,  0x58436, 0x6A3DB,  0x6945B,  0x001C9,  0x01CA0,  0x0728B,  0x0EED9,
 0x1F539,  0x1CA1D, 0x39765,  0x39766,  0x58439,  0x6945D,  0x39767,  0x001D3,
 0x01F2C,  0x07BFC, 0x16161,  0x34652,  0x3A5ED,  0x3548D,  0x58438,  0x6A3DA,
 0x002C1,  0x02C5E, 0x0D335,  0x1AB1A,  0x2D874,  0x35006,  0x35484,  0x5B0CC,
 0x74B9A,  0x72DF3, 0x6A3D6,  0x002DA,  0x034B3,  0x0D5AE,  0x1CAEE,  0x2D871,
 0x357E3,  0x74B97, 0x72DF9,  0x580BA,  0x5B0D4,  0x0034D,  0x0354E,  0x0F750,
 0x1CBC0,  0x3A5E7, 0x3A5E4,  0x00385,  0x03A58,  0x16C41,  0x2C5CF,  0x3E5E1,
 0x74B6C,  0xE5677, 0x6A3DF,  0x00390,  0x03E50,  0x163C2,  0x2D876,  0x35482,
 0x5B0D6,  0x5843A, 0x0039F,  0x0585E,  0x1A583,  0x3500F,  0x74B93,  0x39771,
 0x003E4,  0x06912, 0x16C43,  0x357E1,  0x0058A,  0x0696F,  0x1F538,  0x5B0C9,
 0x6A3CF,  0x005B6, 0x06AF8,  0x1F534,  0x58483,  0x6A3E0,  0x00695,  0x07D02,
 0x1CAE8,  0x58485, 0x006A2,  0x0754A,  0x357EE,  0x3977B,  0x00748,  0x074B2,
 0x34A7B,  0x00729, 0x0B1E0,  0x34649,  0x3E5E3,  0x0073D,  0x0D2C4,  0x3E5E6,
 0x007BB,  0x0B099, 0x39762,  0x5B0CE,  0x6945F,  0x007D1,  0x0D5AB,  0x39779,
 0x007D3,  0x0D52F, 0x39763,  0x6945C,  0x00B1A,  0x0D2C5,  0x35489,  0x00D23,
 0x0EAED,  0x3E5F8, 0x00D32,  0x16016,  0x3E5FB,  0x00D41,  0x0E768,  0x3A5ED,
 0x00E1F,  0x16017, 0x58027,  0x00EAD,  0x0FA07,  0x69455,  0x00E54,  0x1612B,
 0x00E55,  0x1A581, 0x00F78,  0x1A32B,  0x580BC,  0x6A3EE,  0x00F79,  0x1ABFD,
 0x00F95,  0x1AB18, 0x6A3F0,  0x01637,  0x1AA4D,  0x0162D,  0x1F53C,  0x6A3F3,
 0x01A31,  0x1A810, 0x39769,  0x01A50,  0x1CAEF,  0x01A36,  0x1A32E,  0x01A67,
 0x1F38E,  0x01A85, 0x1EF59,  0x01AA6,  0x1EF83,  0x01D51,  0x2C012,  0x01D53,
 0x2D879,  0x01D5E, 0x35005,  0x01CBA,  0x1CF04,  0x69453,  0x01D2D,  0x351FF,
 0x01F2D,  0x2D86F, 0x01F29,  0x35007,  0x02C22,  0x351FA,  0x02C03,  0x3A5EC,
 0x02C5F,  0x3A5EB, 0x02C58,  0x34A6B,  0x03469,  0x356BE,  0x02C59,  0x34A6C,
 0x0346A,  0x3A5EA, 0x034BD,  0x034BF,  0x356BF,  0x0386A,  0x03AB9,  0x5843F,
 0x0386B,  0x3A5F5, 0x03A4B,  0x39421,  0x03AA4,  0x3A5E9,  0x03A5A,  0x03960,
 0x3977E,  0x03DE9, 0x03958,  0x03DF7,  0x039E1,  0x3E5E4,  0x0395F,  0x69458,
 0x03E91,  0x03DF2, 0x39428,  0x058F2,  0x03E80,  0x6A3C3,  0x03E93,  0x694C0,
 0x058B8,  0x5B0CA, 0x0584F,  0x694C1,  0x058F1,  0x068D6,  0x06A10,  0x06AC3,
 0x06A32,  0x070D2, 0x06911,  0x074B1,  0x07494,  0x06AD4,  0x06AD6,  0x072B8,
 0x06AFA,  0x074B3, 0x07540,  0x073CE,  0x0B005,  0x074B3,  0x07495,  0x074B9,
 0x0D336,  0x07BFF, 0x07763,  0x073C8,  0x07D29,  0x0B622,  0x0D221,  0x0D181,
 0x0B1D1,  0x074B8, 0x0B1D0,  0x0D19B,  0x0D2C3,  0x0B172,  0x0D2DC,  0x0B623,
 0x0D5AA,  0x0D426, 0x0D182,  0x0E795,  0x0E1D1,  0x0D337,  0x0E96C,  0x0E5E4,
 0x0E514,  0x0EAEE, 0x16000,  0x0E767,  0x0E1A1,  0x0E78F,  0x16004,  0x0F7C2,
 0x0E799,  0x0E5E7, 0x0E566,  0x0E769,  0x0F751,  0x0EEDE,  0x0FA06,  0x16005,
 0x0FA9F,  0x1A5E6, 0x0E766,  0x1636F,  0x0EEDD,  0x0EEC0,  0x1A309,  0x1CECA,
 0x163CD,  0x0F9CB, 0x0EEDF,  0x1A582,  0x1612D,  0x0E5E5,  0x1ABF8,  0x1A30C,
 0x1CA1F,  0x163CC, 0x1A35C,  0x1CA1E,  0x1AA51,  0x163AC,  0x1A84E,  0x1A53F,
 0x1CF16,  0x1D2FC, 0x1A5B3,  0x1AB19,  0x1A81F,  0x1D5C3,  0x16C3F,  0x1D5C1,
 0x1D2FC,  0x1F4AA, 0x1A812,  0x1F535,  0x1CF12,  0x1A817,  0x1617C,  0x1AB0B,
 0x1D2F8,  0x1EF82, 0x2D87A,  0x1D52F,  0x1F530,  0x1AA48,  0x35487,  0x1D2FD,
 0x1F4AD,  0x1CF11, 0x3461B,  0x35485,  0x1CA20,  0x1CAED,  0x1CAE6,  0x1ABFF,
 0x3464F,  0x34A6F, 0x1EF81,  0x3464B,  0x39D96,  0x1F383,  0x1F537,  0x1CF14,
 0x2C5CE,  0x3500E, 0x2C251,  0x1CAEC,  0x1F387,  0x34654,  0x357E4,  0x2D878,
 0x3500B,  0x35480, 0x3A5E8,  0x3548E,  0x34B64,  0x1F4A8,  0x35003,  0x3E5DF,
 0x2D870,  0x357E6, 0x3E5F0,  0x1EF5A,  0x3A5EA,  0x1F388,  0x3E703,  0x2C24E,
 0x3A5E2,  0x351FD, 0x2C6DD,  0x3E704,  0x351FE,  0x2D875,  0x5B0C7,  0x3976A,
 0x3A5E6,  0x39423, 0x58480,  0x2C246,  0x3A5E3,  0x2D877,  0x3E5F1,  0x3ABBE,
 0x58489,  0x3E5F9, 0x357E0,  0x3ABBC,  0x5B0C6,  0x69167,  0x69165,  0x3E5E9,
 0x39422,  0x3976F, 0x3977D,  0x3E5DE,  0x6A3C9,  0x58B98,  0x3A5F6,  0x3A5D0,
 0x58486,  0x6A3C1, 0x3E5FC,  0x5B0DC,  0x3548F,  0x3942D,  0x694C9,  0x58484,
 0x3A5E8,  0x74B9B, 0x74B96,  0x694D0,  0x58488,  0x3A5E4,  0x3942A,  0x72EC2,
 0x39776,  0x5B0D1, 0x5B0CF,  0x3A5D6,  0xE59FC,  0x5B0C8,  0x3E5E7,  0x7CBB7,
 0x70E87,  0x7CBAB, 0x5B0C2,  0x694C3,  0x74A8E,  0x3E5F3,  0x6A3CD,  0x72DFE,
 0x73B2E,  0x72EC0, 0x694C5,  0x58437,  0x694C8,  0x72DFF,  0x39435,  0x5843D,
 0x6A3D7,  0x72EC1, 0xD22C8,  0x694CF,  0xB6173,  0x3E5FE,  0x580BB,  0xE59F2,
 0xB616E,  0xB6175, 0x3A5DA,  0x5B0BD,  0x694CC,  0x5843C,  0x694C7,  0x74B92,
 0x72EC3,  0x694C6, 0xB6170,  0x7CBAC,  0xB1733,  0x7CBA4,  0xB6167,  0x72DE7,
 0x72DE4,  0x6A3C0, 0x3E5EF, 0x162E65,  0x72DE3,  0x72DFB,  0x6A35F,  0x6A3EB
};

static const unsigned int coef3_huffcodes[ 1072 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x001B2, 0x00069, 0x00000, 0x00004, 0x00006, 0x0000E, 0x00014, 0x00019,
 0x00016, 0x0002B, 0x00030, 0x0003D, 0x0003C, 0x0005A, 0x0005F, 0x0006D,
 0x0007E, 0x0005F, 0x0007F, 0x000B6, 0x000BC, 0x000D8, 0x000F2, 0x000FE,
 0x000BC, 0x000FC, 0x00161, 0x0016E, 0x00174, 0x00176, 0x001A2, 0x001E3,
 0x001F3, 0x00174, 0x0017A, 0x001EA, 0x002A8, 0x002C4, 0x002E6, 0x00314,
 0x00346, 0x00367, 0x003E9, 0x002E5, 0x002EE, 0x003D6, 0x00555, 0x00554,
 0x00557, 0x005C3, 0x005D6, 0x006E0, 0x0062F, 0x006E2, 0x00799, 0x00789,
 0x007FA, 0x005CE, 0x007FE, 0x005EC, 0x007CC, 0x007AF, 0x00AA7, 0x00B19,
 0x00B94, 0x00B85, 0x00B9F, 0x00C48, 0x00C45, 0x00DD8, 0x00C4C, 0x00C4B,
 0x00D99, 0x00D1F, 0x00DC2, 0x00F95, 0x00FA2, 0x00BB5, 0x00B9F, 0x00F5D,
 0x00BBF, 0x00F47, 0x0154A, 0x00FD5, 0x00F45, 0x00F7F, 0x0160D, 0x01889,
 0x01757, 0x01722, 0x018B3, 0x0172D, 0x01A39, 0x01A18, 0x01BB3, 0x01B30,
 0x01E63, 0x0173C, 0x01B35, 0x01723, 0x01E80, 0x01FEE, 0x01761, 0x01FFC,
 0x01F7F, 0x02C7C, 0x01FA1, 0x0177B, 0x01755, 0x0175A, 0x01FA6, 0x02EAB,
 0x0310A, 0x02C69, 0x03669, 0x03127, 0x03103, 0x02E43, 0x03662, 0x03165,
 0x03124, 0x0313B, 0x03111, 0x03668, 0x0343B, 0x03C52, 0x03EFC, 0x02E6C,
 0x03FDA, 0x03EF8, 0x02E7B, 0x03EE2, 0x03CC5, 0x03D72, 0x058C0, 0x03DF8,
 0x02EA9, 0x03E7E, 0x0556D, 0x05C82, 0x03D71, 0x03E7B, 0x03C42, 0x058D7,
 0x03F4E, 0x06200, 0x03D70, 0x05CB2, 0x05C96, 0x05CB0, 0x03F45, 0x05CB1,
 0x02E6D, 0x03110, 0x02F68, 0x05C90, 0x07CA6, 0x07C88, 0x06204, 0x062C8,
 0x078A6, 0x07986, 0x079D5, 0x0B1AD, 0x07989, 0x0B079, 0x05CDD, 0x0AAD4,
 0x05DE8, 0x07DCD, 0x07987, 0x05D67, 0x05D99, 0x0B91D, 0x07CF1, 0x05D9B,
 0x079D7, 0x0B07B, 0x05C85, 0x05D9A, 0x07DCC, 0x07EBF, 0x07DCE, 0x07DFB,
 0x07EC0, 0x07D1A, 0x07A07, 0x05C84, 0x0C471, 0x07CF2, 0x0BAEF, 0x0B9D2,
 0x05DEB, 0x07BD6, 0x0B845, 0x05D98, 0x0B91A, 0x0BAE8, 0x0C4E0, 0x0DC31,
 0x0F93D, 0x0BBCE, 0x0D1D2, 0x0F7A9, 0x0D9B9, 0x0BBCB, 0x0B900, 0x0AAD7,
 0x0BABD, 0x0C4E1, 0x0F46F, 0x0C588, 0x0C58B, 0x160E6, 0x0BBCF, 0x0BAC3,
 0x0F945, 0x0F7A3, 0x0D1C1, 0x0FB8E, 0x0F7A4, 0x0FB8C, 0x0F40C, 0x0C473,
 0x0FD72, 0x0BBCD, 0x0FFFA, 0x0F940, 0x0BBC9, 0x0F7A8, 0x1A1ED, 0x0BBC5,
 0x1F26F, 0x163FD, 0x160C7, 0x1A1F5, 0x0F947, 0x163FC, 0x154B3, 0x0FFF6,
 0x163F6, 0x160E9, 0x1A1F0, 0x0BAB9, 0x0BABA, 0x17086, 0x0B903, 0x0FD75,
 0x0F308, 0x176F3, 0x163FF, 0x0FD7D, 0x1BB78, 0x163FB, 0x188DB, 0x1A1F7,
 0x154B2, 0x172FD, 0x163F4, 0x1BB73, 0x172FF, 0x0BABC, 0x0F97D, 0x1A1F3,
 0x1BB6D, 0x1FFD5, 0x1A1F4, 0x1F272, 0x17380, 0x17382, 0x1FFE7, 0x0BAC8,
 0x0BBC4, 0x188D3, 0x160E0, 0x0FD7B, 0x1725F, 0x172F5, 0x1BB79, 0x1FAD9,
 0x1F269, 0x188D0, 0x0BAC4, 0x0BAC5, 0x31185, 0x188D2, 0x188CC, 0x31187,
 0x3E7FE, 0x188D1, 0x1BB6C, 0x1F268, 0x1FAD2, 0x1FFD9, 0x1A1EA, 0x1BB68,
 0x1FACB, 0x3FDB2, 0x1E81A, 0x188CE, 0x172FB, 0x1A1EF, 0x1FACE, 0x1BB70,
 0x0BAC1, 0x1BB6B, 0x172F8, 0x1BB66, 0x1FFDF, 0x1BB6A, 0x1FFD7, 0x1F266,
 0x176F8, 0x37653, 0x1FA7E, 0x31182, 0x1FAC8, 0x2C7E3, 0x370EE, 0x176EC,
 0x176E9, 0x2E4BC, 0x160C5, 0x3765A, 0x3CE9C, 0x17373, 0x176E8, 0x188D4,
 0x176F1, 0x176EF, 0x37659, 0x1BB7C, 0x1FFDE, 0x176F2, 0x3118B, 0x2C7D4,
 0x37651, 0x5CE9F, 0x37650, 0x31191, 0x3F4F6, 0x3F4F5, 0x7A06C, 0x1FAC1,
 0x5C97B, 0x2C7E0, 0x79D3A, 0x3E7FD, 0x2C7DF, 0x3F4F0, 0x7A06D, 0x376C1,
 0x79D3B, 0x00004, 0x00014, 0x00059, 0x000AB, 0x000B8, 0x00177, 0x001F5,
 0x001F2, 0x00315, 0x003FC, 0x005BD, 0x0062D, 0x006E8, 0x007DD, 0x00B04,
 0x007CD, 0x00B1E, 0x00D1E, 0x00F15, 0x00F3B, 0x00F41, 0x01548, 0x018B0,
 0x0173B, 0x01884, 0x01A1C, 0x01BB4, 0x01F25, 0x017B5, 0x0176D, 0x01EF8,
 0x02E73, 0x03107, 0x03125, 0x03105, 0x02E49, 0x03CE8, 0x03EF9, 0x03E5E,
 0x02E72, 0x03471, 0x03FD9, 0x0623F, 0x078A0, 0x06867, 0x05CB3, 0x06272,
 0x068EC, 0x06E9A, 0x079D4, 0x06E98, 0x0B1AA, 0x06E1A, 0x07985, 0x068EE,
 0x06E9B, 0x05C88, 0x0B1AC, 0x07DFA, 0x05D65, 0x07CF0, 0x07CBF, 0x0C475,
 0x160EB, 0x1BB7E, 0x0F7A6, 0x1FEDD, 0x160E3, 0x0FFFB, 0x0FB8D, 0x0FFF9,
 0x0D1C0, 0x0C58C, 0x1A1E9, 0x0BAB8, 0x0F5CF, 0x0FFF5, 0x376C5, 0x1A1EC,
 0x160ED, 0x1FEDE, 0x1FAC9, 0x1A1EB, 0x1F224, 0x176EE, 0x0FD79, 0x17080,
 0x17387, 0x1BB7A, 0x1FFE9, 0x176F7, 0x17385, 0x17781, 0x2C7D5, 0x17785,
 0x1FFE3, 0x163F5, 0x1FAC2, 0x3E7F9, 0x3118D, 0x3FDB1, 0x1FFE2, 0x1F226,
 0x3118A, 0x2C7D9, 0x31190, 0x3118C, 0x3F4F3, 0x1BB7F, 0x1BB72, 0x31184,
 0xB92F4, 0x3E7FB, 0x6E1D9, 0x1FACA, 0x62300, 0x3FDB8, 0x3D037, 0x3E7FC,
 0x62301, 0x3F4F2, 0x1F26A, 0x0000E, 0x00063, 0x000F8, 0x001EE, 0x00377,
 0x003F7, 0x006E3, 0x005CC, 0x00B05, 0x00DD2, 0x00FD4, 0x0172E, 0x0172A,
 0x01E23, 0x01F2D, 0x01763, 0x01769, 0x0176C, 0x02E75, 0x03104, 0x02EC1,
 0x03E58, 0x0583F, 0x03F62, 0x03F44, 0x058C5, 0x0623C, 0x05CF4, 0x07BD7,
 0x05D9D, 0x0AAD2, 0x05D66, 0x0B1A9, 0x0B078, 0x07CFE, 0x0B918, 0x0C46F,
 0x0B919, 0x0B847, 0x06E1B, 0x0B84B, 0x0AAD8, 0x0FD74, 0x172F4, 0x17081,
 0x0F97C, 0x1F273, 0x0F7A0, 0x0FD7C, 0x172F7, 0x0FD7A, 0x1BB77, 0x172FE,
 0x1F270, 0x0FD73, 0x1BB7B, 0x1A1BC, 0x1BB7D, 0x0BBC3, 0x172F6, 0x0BAEB,
 0x0FB8F, 0x3F4F4, 0x3FDB4, 0x376C8, 0x3E7FA, 0x1FFD0, 0x62303, 0xB92F5,
 0x1F261, 0x31189, 0x3FDB5, 0x2C7DB, 0x376C9, 0x1FAD6, 0x1FAD1, 0x00015,
 0x000F0, 0x002E0, 0x0058E, 0x005D7, 0x00C4D, 0x00FA1, 0x00BDB, 0x01756,
 0x01F70, 0x02C19, 0x0313C, 0x0370F, 0x03CC0, 0x02EA8, 0x058C6, 0x058C7,
 0x02EB7, 0x058D0, 0x07D18, 0x0AA58, 0x0B848, 0x05D9E, 0x05D6C, 0x0B84C,
 0x0C589, 0x0B901, 0x163F8, 0x0BAC9, 0x0B9C5, 0x0F93C, 0x188D8, 0x0BBC7,
 0x160EC, 0x0FD6F, 0x188D9, 0x160EA, 0x0F7A7, 0x0F944, 0x0BAAB, 0x0DC3A,
 0x188CF, 0x176FB, 0x2C7D8, 0x2C7D7, 0x1BB75, 0x5CE9E, 0x62302, 0x370ED,
 0x176F4, 0x1FFD1, 0x370EF, 0x3F4F8, 0x376C7, 0x1FFE1, 0x376C6, 0x176FF,
 0x6E1D8, 0x176F6, 0x17087, 0x0F5CD, 0x00035, 0x001A0, 0x0058B, 0x00AAC,
 0x00B9A, 0x0175F, 0x01E22, 0x01E8C, 0x01FB2, 0x0310B, 0x058D1, 0x0552E,
 0x05C27, 0x0686E, 0x07CA7, 0x0C474, 0x0DC33, 0x07BF2, 0x05DE9, 0x07A35,
 0x0BAAA, 0x0B9EB, 0x0FB95, 0x0B9B8, 0x17381, 0x1F262, 0x188CD, 0x17088,
 0x172FA, 0x0F7A2, 0x1FAD3, 0x0BAC0, 0x3765C, 0x1FEDF, 0x1F225, 0x1FAD4,
 0x2C7DA, 0x5CE9D, 0x3E7F8, 0x1E203, 0x188D7, 0x00054, 0x002C0, 0x007A1,
 0x00F78, 0x01B36, 0x01FA3, 0x0313A, 0x03436, 0x0343A, 0x07D1D, 0x07BD8,
 0x05CDF, 0x0B846, 0x0B189, 0x0D9B8, 0x0FFF8, 0x0D9BE, 0x0C58A, 0x05DEA,
 0x0D1D3, 0x160E4, 0x1F26B, 0x188DA, 0x1E202, 0x2C7D2, 0x163FE, 0x31193,
 0x17782, 0x376C2, 0x2C7D1, 0x3FDB0, 0x3765D, 0x2C7D0, 0x1FAD0, 0x1E201,
 0x188DD, 0x2C7E2, 0x37657, 0x37655, 0x376C4, 0x376C0, 0x176EA, 0x0006F,
 0x003CF, 0x00DD5, 0x01F23, 0x02C61, 0x02ED0, 0x05D54, 0x0552D, 0x07883,
 0x0B1A8, 0x0B91C, 0x0BABF, 0x0B902, 0x0F7AA, 0x0F7A5, 0x1A1E8, 0x1FFD6,
 0x0BABE, 0x1A1BF, 0x163F3, 0x1FFD8, 0x1FAD7, 0x1F275, 0x1FFDC, 0x0007D,
 0x005BC, 0x01549, 0x02A99, 0x03DEF, 0x06273, 0x079D6, 0x07D1B, 0x0AAD3,
 0x0D0FC, 0x2C7DD, 0x188D6, 0x0BAC2, 0x2C7E1, 0x1BB76, 0x1A1BD, 0x31186,
 0x0FD78, 0x1A1BE, 0x31183, 0x3FDB6, 0x3F4F1, 0x37652, 0x1FAD5, 0x3F4F9,
 0x3E7FF, 0x5CE9C, 0x3765B, 0x31188, 0x17372, 0x000BD, 0x0078B, 0x01F21,
 0x03C43, 0x03DED, 0x0AAD6, 0x07EC1, 0x0F942, 0x05C86, 0x17089, 0x0BABB,
 0x1FFE8, 0x2C7DE, 0x1F26E, 0x1FAC4, 0x3F4F7, 0x37656, 0x1FA7D, 0x376C3,
 0x3FDB3, 0x3118F, 0x1FAC6, 0x000F8, 0x007ED, 0x01EFD, 0x03E7A, 0x05C91,
 0x0AAD9, 0x0BAEC, 0x0DC32, 0x0F46E, 0x1E200, 0x176FA, 0x3765E, 0x3FDB7,
 0x2C7D6, 0x3FDB9, 0x37654, 0x37658, 0x3118E, 0x1FFDB, 0x000F6, 0x00C43,
 0x03106, 0x068EF, 0x0B84D, 0x0B188, 0x0BBCC, 0x1F264, 0x1BB69, 0x17386,
 0x1FAC0, 0x00171, 0x00F39, 0x03E41, 0x068ED, 0x0D9BC, 0x0F7A1, 0x1BB67,
 0x1FFDD, 0x176F9, 0x001B9, 0x00F7D, 0x03F63, 0x0D0FD, 0x0B9EA, 0x188DC,
 0x1FAC3, 0x1A1F2, 0x31192, 0x1FFE4, 0x001F6, 0x01754, 0x06865, 0x0F309,
 0x160E5, 0x176F5, 0x3765F, 0x1FACC, 0x001E9, 0x01A1A, 0x06201, 0x0F105,
 0x176F0, 0x002DF, 0x01756, 0x05D6D, 0x163FA, 0x176ED, 0x00342, 0x02E40,
 0x0D0FF, 0x17082, 0x003CD, 0x02A98, 0x0FFFC, 0x2C7DC, 0x1FA7F, 0x003FE,
 0x03764, 0x0FFFD, 0x176FC, 0x1FAC5, 0x002F7, 0x02ED1, 0x0FB97, 0x0058A,
 0x02EDC, 0x0BBC8, 0x005D4, 0x0623D, 0x160E8, 0x0062E, 0x05830, 0x163F9,
 0x006EB, 0x06205, 0x1F274, 0x007DE, 0x062C9, 0x1F265, 0x005C9, 0x05CDE,
 0x1FFD3, 0x005D4, 0x07988, 0x007CE, 0x0B849, 0x00B1B, 0x05C89, 0x1FAC7,
 0x00B93, 0x05C83, 0x00B9E, 0x0F14F, 0x00C4A, 0x0B9C7, 0x00DD4, 0x0C470,
 0x1F271, 0x00F38, 0x0FB96, 0x176EB, 0x00FA0, 0x163F7, 0x00BB2, 0x0B91B,
 0x00BBE, 0x0F102, 0x00F44, 0x0F946, 0x1FACD, 0x00F79, 0x0D9BD, 0x0154D,
 0x0BBC6, 0x00FD2, 0x160E7, 0x0172B, 0x188CB, 0x0175E, 0x0FD76, 0x0175C,
 0x1BB71, 0x0189F, 0x1A1EE, 0x01F24, 0x1A1F6, 0x01BA7, 0x0BBCA, 0x01F7D,
 0x0FFFF, 0x01F2E, 0x1BB65, 0x01BB5, 0x172F9, 0x01FEF, 0x1F26C, 0x01F3E,
 0x0FD77, 0x01762, 0x1BB6E, 0x01EF9, 0x172FC, 0x01FA0, 0x02AB7, 0x02E4A,
 0x1F267, 0x01FB3, 0x1FFDA, 0x02E42, 0x03101, 0x17780, 0x0313D, 0x03475,
 0x17784, 0x03126, 0x1FACF, 0x03C51, 0x17783, 0x03E40, 0x1FFE5, 0x03663,
 0x1FFE0, 0x03E8F, 0x1F26D, 0x0343C, 0x03CC1, 0x176FD, 0x03E45, 0x02EC0,
 0x03F61, 0x03DEE, 0x03FD8, 0x0583E, 0x02E45, 0x03E59, 0x03D02, 0x05CE8,
 0x05568, 0x176FE, 0x02F69, 0x1FAD8, 0x058C1, 0x05C83, 0x1FFE6, 0x06271,
 0x06E1C, 0x062C7, 0x068E1, 0x0552F, 0x06864, 0x06866, 0x06E99, 0x05CBC,
 0x07CA5, 0x078A1, 0x05C82, 0x07DCF, 0x0623B, 0x0623E, 0x068E8, 0x07A36,
 0x05D9C, 0x0B077, 0x07CF3, 0x07A34, 0x07CA4, 0x07D19, 0x079D2, 0x07D1C,
 0x07BD9, 0x0B84A, 0x0FB94, 0x0AAD5, 0x0DC30, 0x07BF3, 0x0BAEE, 0x0B07A,
 0x0C472, 0x0B91E, 0x0D9BA, 0x05D9F, 0x0D0FE, 0x0B9C6, 0x05C87, 0x0F14E,
 0x0BAED, 0x0B92E, 0x0F103, 0x0B9C4, 0x0FB91, 0x0D9BB, 0x0B1AB, 0x0C58D,
 0x0FFFE, 0x0F93B, 0x0F941, 0x0BAEA, 0x0B91F, 0x0F5CC, 0x0D9BF, 0x0F943,
 0x0F104, 0x1F260, 0x0FB92, 0x0F93F, 0x0F3A6, 0x0BAC7, 0x0F7AB, 0x0BAC6,
 0x17383, 0x0FD6D, 0x0BAE9, 0x0FD6E, 0x1E74F, 0x188CA, 0x1F227, 0x0FB93,
 0x0FB90, 0x0FFF7, 0x17085, 0x17083, 0x160E1, 0x17084, 0x0F93E, 0x160E2,
 0x160C6, 0x1A1F1, 0x1BB6F, 0x17384, 0x0FD70, 0x1F263, 0x188D5, 0x173A6,
 0x0F5CE, 0x163F2, 0x0FD71, 0x1FFD2, 0x160C4, 0x1FFD4, 0x2C7D3, 0x1BB74
};

static const unsigned int coef4_huffcodes[ 476 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00F01, 0x0001E, 0x00000, 0x00004, 0x00006, 0x0000D, 0x0000A, 0x00017,
 0x0001D, 0x00017, 0x0002C, 0x00031, 0x00039, 0x0003E, 0x00039, 0x0005A,
 0x00066, 0x00070, 0x0007B, 0x00070, 0x00077, 0x000AF, 0x000C9, 0x000F2,
 0x000F4, 0x000B2, 0x000E3, 0x0015B, 0x0015D, 0x00181, 0x0019D, 0x001E3,
 0x001C5, 0x002B5, 0x002DB, 0x00338, 0x003C3, 0x003CC, 0x003F0, 0x002CD,
 0x003FA, 0x003A1, 0x005B4, 0x00657, 0x007AB, 0x0074D, 0x0074C, 0x00AC1,
 0x00AC5, 0x0076B, 0x00CA8, 0x00F04, 0x00F00, 0x00FE3, 0x00F3C, 0x00F10,
 0x00F39, 0x00FE6, 0x00E26, 0x00E90, 0x016C5, 0x01827, 0x01954, 0x015C5,
 0x01958, 0x01F8A, 0x01C4A, 0x02B0F, 0x02B41, 0x02B0E, 0x033C6, 0x03050,
 0x01C4F, 0x02D88, 0x0305C, 0x03C18, 0x02B4F, 0x02CC2, 0x03A47, 0x05680,
 0x0569D, 0x06442, 0x06443, 0x06446, 0x0656E, 0x06444, 0x07120, 0x0748A,
 0x0C1BA, 0x07E22, 0x07AA6, 0x07F25, 0x07AA7, 0x07E20, 0x0C11B, 0x0C118,
 0x07AA5, 0x0AD0A, 0x0F389, 0x19EBB, 0x0CAAD, 0x0FE42, 0x0FE40, 0x16C34,
 0x2B4E5, 0x33D65, 0x16C30, 0x1E7AE, 0x1E25C, 0x18370, 0x1E703, 0x19EBA,
 0x16C37, 0x0E234, 0x16C6E, 0x00004, 0x0002A, 0x00061, 0x00075, 0x000CB,
 0x000FF, 0x00190, 0x001EB, 0x001D1, 0x002B9, 0x00307, 0x00339, 0x0033F,
 0x003FB, 0x003B4, 0x0060C, 0x00679, 0x00645, 0x0067D, 0x0078A, 0x007E3,
 0x00749, 0x00AC4, 0x00AD2, 0x00AE3, 0x00C10, 0x00C16, 0x00AD1, 0x00CF4,
 0x00FE2, 0x01586, 0x00E9D, 0x019F1, 0x01664, 0x01E26, 0x01D38, 0x02B4D,
 0x033C5, 0x01FC2, 0x01FC3, 0x01D28, 0x03C1D, 0x0598E, 0x0F094, 0x07AA4,
 0x0AD38, 0x0AC0C, 0x0C11A, 0x079EA, 0x0C881, 0x0FE44, 0x0B635, 0x0AC0D,
 0x0B61E, 0x05987, 0x07121, 0x0F382, 0x0F387, 0x0E237, 0x0FE47, 0x0F383,
 0x0F091, 0x0F385, 0x0E233, 0x182EE, 0x19EB8, 0x1663E, 0x0F093, 0x00014,
 0x00058, 0x00159, 0x00167, 0x00300, 0x003D4, 0x005B5, 0x0079D, 0x0076A,
 0x00B67, 0x00B60, 0x00F05, 0x00CF0, 0x00F17, 0x00E95, 0x01822, 0x01913,
 0x016C2, 0x0182F, 0x01959, 0x01FCB, 0x01E27, 0x01C40, 0x033C7, 0x01E7B,
 0x01C49, 0x02D89, 0x01E23, 0x01660, 0x03F12, 0x02CC6, 0x033E1, 0x05B34,
 0x0609A, 0x06569, 0x07488, 0x07E21, 0x0CF5F, 0x0712C, 0x0389D, 0x067CF,
 0x07F28, 0x1663F, 0x33D67, 0x1663D, 0x1E25D, 0x3C1AB, 0x15C44, 0x16C36,
 0x0001F, 0x000EC, 0x00323, 0x005B2, 0x0079F, 0x00AC2, 0x00F16, 0x00E9E,
 0x01956, 0x01E0F, 0x019EA, 0x01666, 0x02B89, 0x02B02, 0x02D8C, 0x03C1B,
 0x03C19, 0x032B5, 0x03F9C, 0x02CCF, 0x03897, 0x05B35, 0x0AD02, 0x07F29,
 0x06441, 0x03884, 0x07888, 0x0784E, 0x06568, 0x0C1BB, 0x05986, 0x067CC,
 0x0FE49, 0x0FE48, 0x0C1BC, 0x0FE41, 0x18371, 0x1663C, 0x0E231, 0x0711E,
 0x0AD09, 0x0F092, 0x0002D, 0x001DB, 0x00781, 0x00C1A, 0x00F55, 0x01580,
 0x01EA8, 0x02D9B, 0x032AF, 0x03F16, 0x03C1C, 0x07834, 0x03C45, 0x0389C,
 0x067CE, 0x06445, 0x0C1B9, 0x07889, 0x07F3A, 0x0784F, 0x07F2B, 0x0AD0B,
 0x0F090, 0x0C11D, 0x0E94E, 0x0711F, 0x0E9F1, 0x0F38E, 0x079E9, 0x0AD03,
 0x0F09B, 0x0CAAE, 0x0FE46, 0x2B4E6, 0x0E9F0, 0x19EB6, 0x67AC1, 0x67AC0,
 0x33D66, 0x0F388, 0x00071, 0x003A0, 0x00CA9, 0x01829, 0x01D39, 0x02B43,
 0x02CC4, 0x06554, 0x0F09A, 0x0B61F, 0x067CD, 0x0711C, 0x0B636, 0x07F2A,
 0x0B634, 0x0C11F, 0x0CF5E, 0x0B61D, 0x0F06B, 0x0CAAB, 0x0C1BE, 0x0E94C,
 0x0F099, 0x182ED, 0x0E94F, 0x0C119, 0x0E232, 0x2B4E4, 0x0F38A, 0x19EB4,
 0x1E25F, 0x0E94D, 0x000B7, 0x00785, 0x016CC, 0x03051, 0x033C4, 0x0656F,
 0x03891, 0x0711D, 0x0CAAF, 0x0F097, 0x07489, 0x0F098, 0x0C880, 0x0CAAA,
 0x0F386, 0x19EB7, 0x16C6F, 0x0F384, 0x182E8, 0x182E9, 0x0E230, 0x1E700,
 0x33D62, 0x33D63, 0x33D64, 0x16C33, 0x0E216, 0x000FD, 0x00C15, 0x01665,
 0x03C4A, 0x07F3B, 0x07896, 0x0C11C, 0x0E215, 0x16C32, 0x0F38B, 0x0F38D,
 0x182EA, 0x1E701, 0x712DF, 0x15C46, 0x00194, 0x00FE0, 0x03F13, 0x0748B,
 0x0F096, 0x0CF80, 0x1E25E, 0xE25BD, 0x33D61, 0x16C31, 0x001F9, 0x01912,
 0x05710, 0x0F3D0, 0x0C1BF, 0x00301, 0x01E24, 0x0AD08, 0x003CD, 0x01C41,
 0x0C1BD, 0x00563, 0x03A52, 0x0F3D1, 0x00570, 0x02CCE, 0x0E217, 0x0067B,
 0x0655D, 0x0074B, 0x06447, 0x00C12, 0x074FB, 0x00F08, 0x0B61C, 0x00E22,
 0x0FE43, 0x016C7, 0x01836, 0x019F2, 0x01C43, 0x01D3F, 0x01FCF, 0x02B4C,
 0x0304C, 0x032B6, 0x03A46, 0x05607, 0x03F17, 0x02CC5, 0x0609B, 0x0655C,
 0x07E23, 0x067C1, 0x07F26, 0x07F27, 0x0F095, 0x0E9F3, 0x0CF81, 0x0C11E,
 0x0CAAC, 0x0F38F, 0x0E9F2, 0x074FA, 0x0E236, 0x0FE45, 0x1C428, 0x0E235,
 0x182EF, 0x19EB5, 0x0F3D6, 0x182EC, 0x16C35, 0x0F38C, 0x2B4E7, 0x15C47,
 0xE25BC, 0x1E702, 0x1C4B6, 0x0E25A, 0x3C1AA, 0x15C45, 0x1C429, 0x19EB9,
 0x1E7AF, 0x182EB, 0x1E0D4, 0x3896E
};

static const unsigned int coef5_huffcodes[ 435 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00347, 0x0000B, 0x00001, 0x00001, 0x0000C, 0x00004, 0x00010, 0x00015,
 0x0001F, 0x0000B, 0x00023, 0x00026, 0x00029, 0x00035, 0x00037, 0x00001,
 0x00015, 0x0001A, 0x0001D, 0x0001C, 0x0001E, 0x0004E, 0x00049, 0x00051,
 0x00078, 0x00004, 0x00000, 0x00008, 0x0000D, 0x0007B, 0x00005, 0x00032,
 0x00095, 0x00091, 0x00096, 0x000A1, 0x000D9, 0x00003, 0x00019, 0x00061,
 0x00066, 0x00060, 0x00017, 0x0000E, 0x00063, 0x001A0, 0x001B7, 0x001E6,
 0x001E7, 0x001B6, 0x00018, 0x001E8, 0x00038, 0x00031, 0x00005, 0x0003D,
 0x00027, 0x001EA, 0x0001A, 0x000C5, 0x000F9, 0x000FF, 0x000DB, 0x00250,
 0x000FC, 0x0025C, 0x00008, 0x00075, 0x003D7, 0x003D3, 0x001B0, 0x0007C,
 0x003CA, 0x00036, 0x00189, 0x004A6, 0x004A2, 0x004FB, 0x000C0, 0x0007F,
 0x0009A, 0x00311, 0x0006E, 0x0009B, 0x0068C, 0x006C0, 0x00484, 0x00012,
 0x000C3, 0x0094F, 0x00979, 0x009F9, 0x00D09, 0x00DA6, 0x00DA8, 0x00901,
 0x000C1, 0x00373, 0x00D08, 0x009FA, 0x00D8B, 0x00D85, 0x00D86, 0x000DF,
 0x006E2, 0x000CE, 0x00F24, 0x009FE, 0x001F7, 0x007C1, 0x000CF, 0x009FC,
 0x009FF, 0x00D89, 0x00DA9, 0x009FD, 0x001F8, 0x01A36, 0x0128C, 0x0129D,
 0x01A37, 0x00196, 0x003EA, 0x00F8B, 0x00D93, 0x01E45, 0x01E58, 0x01E4B,
 0x01E59, 0x013F1, 0x00309, 0x00265, 0x00308, 0x0243A, 0x027E1, 0x00F89,
 0x00324, 0x03CBC, 0x03C86, 0x03695, 0x0243C, 0x0243B, 0x0243E, 0x01E4A,
 0x003A5, 0x03468, 0x03428, 0x03C84, 0x027E0, 0x025E2, 0x01880, 0x00197,
 0x00325, 0x03CB7, 0x0791E, 0x007EC, 0x06C75, 0x004C8, 0x04BC7, 0x004C6,
 0x00983, 0x0481E, 0x01B53, 0x0251B, 0x01B58, 0x00984, 0x04FA8, 0x03CBB,
 0x00F8A, 0x00322, 0x0346A, 0x0243D, 0x00326, 0x03469, 0x0481F, 0x0481D,
 0x00746, 0x09032, 0x01B50, 0x01D13, 0x0D8E4, 0x0481B, 0x06C74, 0x0796B,
 0x07969, 0x00985, 0x0D8E3, 0x00986, 0x00FA2, 0x01301, 0x06C7C, 0x00987,
 0x03CB8, 0x0F4AF, 0x00E88, 0x1B1C0, 0x00FCE, 0x033EB, 0x03F6A, 0x03F69,
 0x00FCF, 0x0791F, 0x004C9, 0x04871, 0x00FCD, 0x00982, 0x00FCC, 0x00FA3,
 0x01D12, 0x0796C, 0x01B47, 0x00321, 0x0796A, 0x0D8E2, 0x04872, 0x04873,
 0x0000E, 0x00014, 0x0000A, 0x000A0, 0x00012, 0x0007D, 0x001A2, 0x0003B,
 0x0025F, 0x000DD, 0x0027C, 0x00343, 0x00368, 0x0036B, 0x0003E, 0x001FA,
 0x00485, 0x001B3, 0x0007F, 0x001B1, 0x0019E, 0x004BA, 0x007AD, 0x00339,
 0x00066, 0x007A4, 0x00793, 0x006C6, 0x0007E, 0x000F1, 0x00372, 0x009FB,
 0x00D83, 0x00D8A, 0x00947, 0x009F4, 0x001D0, 0x01B09, 0x01B4B, 0x007EC,
 0x003E1, 0x000CA, 0x003EC, 0x02539, 0x04FA9, 0x01B57, 0x03429, 0x03D2A,
 0x00D97, 0x003A7, 0x00DC0, 0x00D96, 0x00DC1, 0x007EB, 0x03CBA, 0x00C43,
 0x00C41, 0x01B52, 0x007EF, 0x00323, 0x03CB9, 0x03C83, 0x007D0, 0x007ED,
 0x06C7F, 0x09033, 0x03F6C, 0x36383, 0x1E95D, 0x06C78, 0x00747, 0x01B51,
 0x00022, 0x00016, 0x00039, 0x00252, 0x00079, 0x00486, 0x00338, 0x00369,
 0x00D88, 0x00026, 0x00D87, 0x00F4B, 0x00D82, 0x00027, 0x001E1, 0x01A15,
 0x007C7, 0x012F0, 0x001E0, 0x006D0, 0x01A16, 0x01E44, 0x01E5F, 0x03690,
 0x00D90, 0x00C42, 0x00DAF, 0x00D92, 0x00F80, 0x00CFB, 0x0342F, 0x0487F,
 0x01B46, 0x07968, 0x00D95, 0x00D91, 0x01B55, 0x03F68, 0x04BC6, 0x03CBD,
 0x00F81, 0x00320, 0x00069, 0x000FE, 0x006D5, 0x0033F, 0x000DE, 0x007C6,
 0x01E40, 0x00D94, 0x00F88, 0x03C8E, 0x03694, 0x00DAE, 0x00DAD, 0x00267,
 0x003A6, 0x00327, 0x0487E, 0x007EE, 0x00749, 0x004C7, 0x03692, 0x01B56,
 0x00FD1, 0x07A56, 0x06C77, 0x09031, 0x00748, 0x06C7A, 0x0796D, 0x033EA,
 0x06C76, 0x00FD0, 0x36382, 0x1E417, 0x00745, 0x04FAF, 0x0D8E1, 0x03F6B,
 0x1E95C, 0x04FAD, 0x0009E, 0x004BD, 0x0067C, 0x01B08, 0x003EB, 0x01B45,
 0x03691, 0x0D8E5, 0x07904, 0x00981, 0x007EA, 0x019F4, 0x06C7D, 0x04FAB,
 0x04FAC, 0x06C7E, 0x01300, 0x06C7B, 0x0006F, 0x003F7, 0x03C85, 0x004C4,
 0x0001E, 0x006E1, 0x03693, 0x01B44, 0x00241, 0x01E46, 0x0019D, 0x00266,
 0x004BB, 0x02538, 0x007AC, 0x01B54, 0x00902, 0x04870, 0x00DA7, 0x00900,
 0x00185, 0x06C79, 0x006E3, 0x003E9, 0x01E94, 0x003ED, 0x003F2, 0x0342E,
 0x0346B, 0x0251A, 0x004C5, 0x01881, 0x0481C, 0x01B59, 0x03C87, 0x04FAE,
 0x007E9, 0x03F6D, 0x0F20A, 0x09030, 0x04FAA, 0x0D8E6, 0x03F6F, 0x0481A,
 0x03F6E, 0x1E416, 0x0D8E7
};

static const CoefVLCTable coef_vlcs[ 6 ] __attribute__(   (  section( ".data" )  )   ) = {
 { sizeof ( coef0_huffbits ), coef0_huffcodes, coef0_huffbits, levels0 },
 { sizeof ( coef1_huffbits ), coef1_huffcodes, coef1_huffbits, levels1 },
 { sizeof ( coef2_huffbits ), coef2_huffcodes, coef2_huffbits, levels2 },
 { sizeof ( coef3_huffbits ), coef3_huffcodes, coef3_huffbits, levels3 },
 { sizeof ( coef4_huffbits ), coef4_huffcodes, coef4_huffbits, levels4 },
 { sizeof ( coef5_huffbits ), coef5_huffcodes, coef5_huffbits, levels5 }
};

typedef struct WMADecodeContext {
 SMS_BitContext  gb;
 int             sample_rate;
 int             nb_channels;
 int             bit_rate;
 SMS_VLC         exp_vlc;
 int             exponent_sizes     [ BLOCK_NB_SIZES ];
 unsigned short  exponent_bands     [ BLOCK_NB_SIZES ][ 25 ];
 int             high_band_start    [ BLOCK_NB_SIZES ];
 int             coefs_end          [ BLOCK_NB_SIZES ];
 int             exponent_high_sizes[ BLOCK_NB_SIZES ];
 int             exponent_high_bands[ BLOCK_NB_SIZES ][ HIGH_BAND_MAX_SIZE ];
 int             high_band_coded    [ MAX_CHANNELS ][ HIGH_BAND_MAX_SIZE ];
 int             high_band_values   [ MAX_CHANNELS ][ HIGH_BAND_MAX_SIZE ];
 SMS_VLC         hgain_vlc;
 SMS_VLC         coef_vlc   [ 2 ];
 unsigned short* run_table  [ 2 ];
 unsigned short* level_table[ 2 ];
 unsigned short* int_table  [ 2 ];
 const CoefVLCTable* coef_vlcs[2];
 int             frame_len;
 int             block_len_bits;
 int             next_block_len_bits;
 int             prev_block_len_bits;
 int             block_len;
 int             block_num;
 int             block_pos;
 unsigned char   channel_coded  [ MAX_CHANNELS ];
 int             exponents_bsize[ MAX_CHANNELS ];
 short           coefs1[ MAX_CHANNELS ][ BLOCK_MAX_SIZE ];
 SMS_MDCTContext mdct_ctx[ BLOCK_NB_SIZES ];
 float*          windows [ BLOCK_NB_SIZES ];
 unsigned char   last_superframe[ MAX_CODED_SUPERFRAME_SIZE + 4 ];
 int             last_bitoffset;
 int             last_superframe_len;
 float           noise_mult;
 SMS_ALIGN( float frame_out[ MAX_CHANNELS ][ BLOCK_MAX_SIZE * 2 ], 16 );
 SMS_ALIGN( float exponents[ MAX_CHANNELS ][ BLOCK_MAX_SIZE ],     16 );
 SMS_ALIGN( float coefs    [ MAX_CHANNELS ][ BLOCK_MAX_SIZE ],     16 );
 SMS_ALIGN( float output   [ BLOCK_MAX_SIZE * 2 ],                 16 );
 SMS_ALIGN( float window   [ BLOCK_MAX_SIZE * 2 ],                 16 );
 float           max_exponent[ MAX_CHANNELS ];
 float           lsp_cos_table[ BLOCK_MAX_SIZE ];
 float           lsp_pow_e_table[ 256 ];
 float           lsp_pow_m_table1[ 1 << LSP_POW_BITS ];
 float           lsp_pow_m_table2[ 1 << LSP_POW_BITS ];
 float           noise_table[ NOISE_TAB_SIZE ];
 void            ( *PCMSyn ) ( short*, float**, int );
 short           noise_index;
 short           block_align;
 unsigned char   ms_stereo;
 unsigned char   use_bit_reservoir;
 unsigned char   use_exp_vlc;
 unsigned char   use_variable_block_len;
 unsigned char   version;
 unsigned char   use_noise_coding;
 unsigned char   coefs_start;
 unsigned char   nb_block_sizes;
 unsigned char   byte_offset_bits;
 unsigned char   frame_len_bits;
 unsigned char   reset_block_lengths;
} WMADecodeContext;

static WMADecodeContext s_Ctx;

static void init_coef_vlc (
             SMS_VLC* vlc, uint16_t** prun_table, uint16_t** plevel_table,
             uint16_t** pint_table, const CoefVLCTable* vlc_table
            ) {

 int             n            = vlc_table -> n;
 const uint8_t*  table_bits   = vlc_table -> huffbits;
 const uint32_t* table_codes  = vlc_table -> huffcodes;
 const uint16_t* levels_table = vlc_table -> levels;
 uint16_t*       run_table, *level_table, *int_table;
 int             i, l, j, k, level;

 SMS_VLC_Init (
  vlc, VLCBITS, n, table_bits, 1, 1, table_codes, 4, 4
 );

 run_table   = malloc (  n * sizeof ( uint16_t ) * 3  );
 level_table = run_table   + n;
 int_table   = level_table + n;

 i     = 2;
 level = 1;
 k     = 0;

 while ( i < n ) {
  int_table[ k ] = i;
  l              = levels_table[ k++ ];
  for ( j = 0; j < l; ++j ) {
   run_table  [ i ] = j;
   level_table[ i ] = level;
   ++i;
  }  /* end for */
  ++level;
 }  /* end while */

 *prun_table   = run_table;
 *plevel_table = level_table;
 *pint_table   = int_table;

}  /* end init_coef_vlc */

static void wma_init ( SMS_CodecContext* apCtx, int aFlags ) {

 WMADecodeContext* lpCtx = &s_Ctx;
 int               i;
 float*            window;
 float             bps1, high_freq;
 float             bps;
 int               sample_rate1;
 int               coef_vlc_table;

 lpCtx -> sample_rate = apCtx -> m_SampleRate;
 lpCtx -> nb_channels = apCtx -> m_Channels;
 lpCtx -> bit_rate    = apCtx -> m_BitRate;
 lpCtx -> block_align = apCtx -> m_BlockAlign;

 if ( apCtx -> m_Channels == 1 )
  lpCtx -> PCMSyn = pcm_syn1;
 else lpCtx -> PCMSyn = pcm_syn2;

 lpCtx -> version = apCtx -> m_ID == SMS_CodecID_WMA_V1 ? 1 : 2;

 if ( lpCtx -> sample_rate <= 16000 ) {
  lpCtx -> frame_len_bits = 9;
 } else if (  lpCtx -> sample_rate <= 22050 || ( lpCtx -> sample_rate <= 32000 && lpCtx -> version == 1 )  ) {
  lpCtx -> frame_len_bits = 10;
 } else {
  lpCtx -> frame_len_bits = 11;
 }  /* end else */

 lpCtx -> frame_len = 1 << lpCtx -> frame_len_bits;

 if ( lpCtx -> use_variable_block_len ) {
  int nb_max, nb;
  nb = (  ( aFlags >> 3 ) & 3  ) + 1;
  if (  ( lpCtx -> bit_rate / lpCtx -> nb_channels ) >= 32000  ) nb += 2;
  nb_max = lpCtx -> frame_len_bits - BLOCK_MIN_BITS;
  if ( nb > nb_max ) nb = nb_max;
  lpCtx -> nb_block_sizes = nb + 1;
 } else lpCtx -> nb_block_sizes = 1;

 lpCtx -> use_noise_coding = 1;
 high_freq                 = lpCtx -> sample_rate * 0.5F;
 sample_rate1              = lpCtx -> sample_rate;

 if ( lpCtx -> version == 2 ) {
  if ( sample_rate1 >= 44100 )
   sample_rate1 = 44100;
  else if ( sample_rate1 >= 22050 )
   sample_rate1 = 22050;
  else if ( sample_rate1 >= 16000 )
   sample_rate1 = 16000;
  else if ( sample_rate1 >= 11025 )
   sample_rate1 = 11025;
  else if ( sample_rate1 >=  8000 )
   sample_rate1 = 8000;
 }  /* end if */

 bps = ( float )lpCtx -> bit_rate / ( float )( lpCtx -> nb_channels * lpCtx -> sample_rate );

 lpCtx -> byte_offset_bits = SMS_log2 (
  ( int )( bps * lpCtx -> frame_len / 8.0F + 0.5F )
 ) + 2;

 bps1 = bps;

 if ( lpCtx -> nb_channels == 2) bps1 = bps * 1.6F;

 if ( sample_rate1 == 44100 ) {
  if ( bps1 >= 0.61F )
   lpCtx -> use_noise_coding = 0;
  else high_freq = high_freq * 0.4F;
 } else if ( sample_rate1 == 22050 ) {
  if ( bps1 >= 1.16F )
   lpCtx -> use_noise_coding = 0;
  else if ( bps1 >= 0.72F )
   high_freq = high_freq * 0.7F;
  else high_freq = high_freq * 0.6F;
 } else if ( sample_rate1 == 16000 ) {
  if ( bps > 0.5F )
   high_freq = high_freq * 0.5F;
  else high_freq = high_freq * 0.3F;
 } else if ( sample_rate1 == 11025 ) {
  high_freq = high_freq * 0.7F;
 } else if ( sample_rate1 == 8000 ) {
  if ( bps <= 0.625F ) {
   high_freq = high_freq * 0.5F;
  } else if ( bps > 0.75F ) {
   lpCtx -> use_noise_coding = 0;
  } else {
   high_freq = high_freq * 0.65F;
  }  /* end else */
 } else {
  if ( bps >= 0.8F ) {
   high_freq = high_freq * 0.75F;
  } else if ( bps >= 0.6F ) {
   high_freq = high_freq * 0.6F;
  } else {
   high_freq = high_freq * 0.5F;
  }  /* end else */
 }  /* end else */

 {  /* begin block */
  int            a, b, pos, lpos, k, block_len, i, j, n;
  const uint8_t* table;

  if ( lpCtx -> version == 1 ) {
   lpCtx -> coefs_start = 3;
  } else {
   lpCtx -> coefs_start = 0;
  }  /* end else */

  for ( k = 0; k < lpCtx -> nb_block_sizes; ++k ) {
   block_len = lpCtx -> frame_len >> k;
   if ( lpCtx -> version == 1 ) {
    lpos = 0;
    for ( i = 0; i < 25; ++i ) {
     a   = wma_critical_freqs[ i ];
     b   = lpCtx -> sample_rate;
     pos = (  ( block_len * 2 * a )  + ( b >> 1 )  ) / b;
     if ( pos > block_len ) pos = block_len;
     lpCtx -> exponent_bands[ 0 ][ i ] = pos - lpos;
     if ( pos >= block_len ) {
      ++i;
      break;
     }  /* end if */
     lpos = pos;
    }  /* end for */
    lpCtx -> exponent_sizes[ 0 ] = i;
   } else {
    table = NULL;
    a     = lpCtx -> frame_len_bits - BLOCK_MIN_BITS - k;
    if ( a < 3 ) {
     if ( lpCtx -> sample_rate >= 44100 )
      table = exponent_band_44100[ a ];
     else if ( lpCtx -> sample_rate >= 32000 )
      table = exponent_band_32000[ a ];
     else if ( lpCtx -> sample_rate >= 22050 )
      table = exponent_band_22050[ a ];
    }  /* end if */
    if ( table ) {
     n = *table++;
     for ( i = 0; i < n; ++i ) lpCtx -> exponent_bands[ k ][ i ] = table[ i ];
     lpCtx -> exponent_sizes[ k ] = n;
    } else {
     j    = 0;
     lpos = 0;
     for ( i = 0; i < 25; ++i ) {
      a     = wma_critical_freqs[ i ];
      b     = lpCtx -> sample_rate;
      pos   = (  ( block_len * 2 * a )  + ( b << 1 )  ) / ( 4 * b );
      pos <<= 2;
      if ( pos > block_len  ) pos = block_len;
      if ( pos > lpos       ) lpCtx -> exponent_bands[ k ][ j++ ] = pos - lpos;
      if ( pos >= block_len ) break;
      lpos = pos;
     }  /* end for */
     lpCtx -> exponent_sizes[ k ] = j;
    }  /* end else */
   }  /* end else */
   lpCtx -> coefs_end[ k ] = (
    lpCtx -> frame_len - (  ( lpCtx -> frame_len * 9 ) / 100  )
   ) >> k;
   lpCtx -> high_band_start[ k ] = ( int )(
    ( block_len * 2 * high_freq ) / lpCtx -> sample_rate + 0.5F
   );
   n   = lpCtx -> exponent_sizes[ k ];
   j   = 0;
   pos = 0;
   for ( i = 0; i < n; ++i ) {
    int start, end;
    start = pos;
    pos  += lpCtx -> exponent_bands[ k ][ i ];
    end   = pos;
    if ( start < lpCtx -> high_band_start[ k ] ) start = lpCtx -> high_band_start[ k ];
    if ( end   > lpCtx -> coefs_end      [ k ] ) end   = lpCtx -> coefs_end      [ k ];
    if ( end   > start                         ) lpCtx -> exponent_high_bands[ k ][ j++ ] = end - start;
   }  /* end for */
   lpCtx -> exponent_high_sizes[ k ] = j;
  }  /* end for */
 }  /* end block */

 for ( i = 0; i < lpCtx -> nb_block_sizes; ++i ) {
  int   n, j;
  float alpha;
  n      = 1 << ( lpCtx -> frame_len_bits - i );
  window = malloc (  sizeof ( float ) * n  );
  alpha  = M_PI / ( 2.0F * n );
  for ( j = 0; j < n; ++j ) window[ j ] = sinf (  ( j + 0.5F ) * alpha  );
  lpCtx -> windows[ i ] = window;
 }  /* end for */

 lpCtx -> reset_block_lengths = 1;

 if ( lpCtx -> use_noise_coding ) {
  unsigned int seed;
  float        norm;
  lpCtx -> noise_mult = lpCtx -> use_exp_vlc ? 0.02F : 0.04F;
  seed = 1;
  norm = (   1.0F / ( float )(  SMS_INT64( 1 ) << 31 )   ) * sqrtf ( 3.0F ) * lpCtx -> noise_mult;
  for ( i = 0; i < NOISE_TAB_SIZE; ++i ) {
   seed = seed * 314159 + 1;
   lpCtx -> noise_table[ i ] = ( float )(  ( int )seed  ) * norm;
  }  /* end for */
 }  /* end if */

 coef_vlc_table = 2;

 if ( lpCtx -> sample_rate >= 32000 ) {
  if ( bps1 < 0.72F )
   coef_vlc_table = 0;
  else if ( bps1 < 1.16F ) coef_vlc_table = 1;
 }  /* end if */

 lpCtx -> coef_vlcs[ 0 ]= &coef_vlcs[ coef_vlc_table * 2     ];
 lpCtx -> coef_vlcs[ 1 ]= &coef_vlcs[ coef_vlc_table * 2 + 1 ];

 init_coef_vlc (
  &lpCtx -> coef_vlc[ 0 ], &lpCtx -> run_table[ 0 ],
  &lpCtx -> level_table[ 0 ], &lpCtx -> int_table[ 0 ],
  lpCtx -> coef_vlcs[ 0 ]
 );
 init_coef_vlc (
  &lpCtx -> coef_vlc[ 1 ], &lpCtx -> run_table[ 1 ],
  &lpCtx -> level_table[ 1 ], &lpCtx -> int_table[ 1 ],
  lpCtx -> coef_vlcs[ 1 ]
 );

}  /* end wma_init */

static void wma_lsp_to_curve_init ( int frame_len ) {

 WMADecodeContext* lpCtx = &s_Ctx;
 float             wdel, a, b;
 int               i, e, m;

 wdel = M_PI / frame_len;

 for ( i = 0; i < frame_len;++i ) lpCtx -> lsp_cos_table[ i ] = 2.0F * cosf ( wdel * i );

 for ( i = 0; i < 256; ++i ) {
  e                             = i - 126;
  lpCtx -> lsp_pow_e_table[ i ] = PowF ( 2.0F, e * -0.25F );
 }  /* end for */

 b = 1.0F;

 for (  i = ( 1 << LSP_POW_BITS ) - 1; i >= 0; --i  ) {
  m = ( 1 << LSP_POW_BITS ) + i;
  a = ( float )m * (  0.5F / ( 1 << LSP_POW_BITS )  );
  a = PowF ( a, -0.25F );
  lpCtx -> lsp_pow_m_table1[ i ] = 2 * a - b;
  lpCtx -> lsp_pow_m_table2[ i ] = b - a;
  b = a;
 }  /* end for */

}  /* end wma_lsp_to_curve_init */

static void wma_decode_end ( SMS_CodecContext* apCtx ) {

 WMADecodeContext* lpCtx = &s_Ctx;
 int               i;

 for ( i = 0; i < lpCtx -> nb_block_sizes; ++i ) {
  DSP_MDCTDestroy ( &lpCtx -> mdct_ctx[ i ] );
  if ( lpCtx -> windows[ i ] ) free ( lpCtx -> windows[ i ] ), lpCtx -> windows[ i ] = NULL;
 }  /* emd for */

 if ( lpCtx -> use_exp_vlc      ) SMS_VLC_Free ( &lpCtx -> exp_vlc   );
 if ( lpCtx -> use_noise_coding ) SMS_VLC_Free ( &lpCtx -> hgain_vlc );

 for ( i = 0; i < 2; ++i ) {
  SMS_VLC_Free ( &lpCtx -> coef_vlc[ i ] );
  if ( lpCtx -> run_table[ i ] ) free ( lpCtx -> run_table[ i ] ), lpCtx -> run_table[ i ] = NULL;
 }  /* end for */

 memset (  lpCtx, 0, sizeof ( *lpCtx )  );

}  /* end wma_decode_end */

static int wma_decode_init ( SMS_CodecContext* apCtx ) {

 WMADecodeContext* lpCtx = &s_Ctx;
 int               i, flags1, flags2;
 uint8_t*          extradata;

 wma_decode_end ( apCtx );

 flags1    = 0;
 flags2    = 0;
 extradata = apCtx -> m_pUserData;

 if ( apCtx -> m_ID == SMS_CodecID_WMA_V1 && apCtx -> m_UserDataLen >= 4 ) {
  flags1 = *( short* )&extradata[ 0 ];
  flags2 = *( short* )&extradata[ 2 ];
 } else if ( apCtx -> m_ID == SMS_CodecID_WMA_V2 && apCtx -> m_UserDataLen >= 6 ) {
  flags1 = *( int*   )&extradata[ 0 ];
  flags2 = *( short* )&extradata[ 4 ];
 }  /* end if */

 lpCtx -> use_exp_vlc            = flags2 & 0x0001;
 lpCtx -> use_bit_reservoir      = flags2 & 0x0002;
 lpCtx -> use_variable_block_len = flags2 & 0x0004;

 wma_init ( apCtx, flags2 );

 for ( i = 0; i < lpCtx -> nb_block_sizes; ++i ) DSP_MDCTInit (
  &lpCtx -> mdct_ctx[ i ], lpCtx -> frame_len_bits - i + 1, 1.0F
 );

 if ( lpCtx -> use_noise_coding ) SMS_VLC_Init (
  &lpCtx -> hgain_vlc, HGAINVLCBITS, sizeof ( hgain_huffbits ),
  hgain_huffbits, 1, 1, hgain_huffcodes, 2, 2
 );

 if ( lpCtx -> use_exp_vlc ) {
  SMS_VLC_Init (
   &lpCtx -> exp_vlc, EXPVLCBITS, sizeof ( scale_huffbits ),
   scale_huffbits, 1, 1, scale_huffcodes, 4, 4
  );
 } else wma_lsp_to_curve_init ( lpCtx -> frame_len );

 return 1;

}  /* end wma_decode_init */

static SMS_INLINE float pow_m1_4 ( float x ) {
 union {
  float        f;
  unsigned int v;
 } u, t;
 unsigned int      e, m;
 float             a, b;
 WMADecodeContext* lpCtx = &s_Ctx;
 u.f = x;
 e   = u.v >> 23;
 m   = (  u.v >> ( 23 - LSP_POW_BITS )  ) & (  ( 1 << LSP_POW_BITS ) - 1  );
 t.v = (   ( u.v << LSP_POW_BITS ) & (  ( 1 << 23 ) - 1  )   ) | ( 127 << 23 );
 a   = lpCtx -> lsp_pow_m_table1[ m ];
 b   = lpCtx -> lsp_pow_m_table2[ m ];
 return lpCtx -> lsp_pow_e_table[ e ] * ( a + b * t.f );
}  /* end pow_m1_4 */

static void wma_lsp_to_curve (
             float *out, float *val_max_ptr, int n, float *lsp
            ) {

 WMADecodeContext* lpCtx = &s_Ctx;
 int               i, j;
 float             p, q, w, v, val_max;

 val_max = 0;

 for ( i = 0; i < n; ++i ) {
  p = 0.5F;
  q = 0.5F;
  w = lpCtx -> lsp_cos_table[ i ];
  for ( j = 1; j < NB_LSP_COEFS; j += 2 ) {
   q *= w - lsp[ j - 1 ];
   p *= w - lsp[ j ];
  } /* end for */
  p *= p * ( 2.0F - w );
  q *= q * ( 2.0F + w );
  v  = p + q;
  v  = pow_m1_4 ( v );
  if ( v > val_max ) val_max = v;
  out[ i ] = v;
 }  /* end for */

 *val_max_ptr = val_max;

}  /* end wma_lsp_to_curve */

static void decode_exp_lsp ( int ch ) {

 WMADecodeContext* lpCtx    = &s_Ctx;
 SMS_BitContext*   lpBitCtx = &lpCtx -> gb;
 float             lsp_coefs[ NB_LSP_COEFS ];
 int               val, i;

 for ( i = 0; i < NB_LSP_COEFS; ++i ) {
  if ( i == 0 || i >= 8 )
   val = SMS_GetBits ( lpBitCtx, 3 );
  else val = SMS_GetBits ( lpBitCtx, 4 );
  lsp_coefs[ i ] = lsp_codebook[ i ][ val ];
 }  /* end for */

 wma_lsp_to_curve (
  lpCtx -> exponents[ ch ], &lpCtx -> max_exponent[ ch ],
  lpCtx -> block_len, lsp_coefs
 );

}  /* end decode_exp_lsp */

static int decode_exp_vlc ( int ch ) {

 WMADecodeContext* lpCtx    = &s_Ctx;
 SMS_BitContext*   lpBitCtx = &lpCtx -> gb;
 int               last_exp, n, code;
 const uint16_t*   ptr, *band_ptr;
 float             v, *q, max_scale, *q_end;

 band_ptr  = lpCtx -> exponent_bands[ lpCtx -> frame_len_bits - lpCtx -> block_len_bits ];
 ptr       = band_ptr;
 q         = lpCtx -> exponents[ ch ];
 q_end     = q + lpCtx -> block_len;
 max_scale = 0;

 if ( lpCtx -> version == 1 ) {
  last_exp  = SMS_GetBits ( lpBitCtx, 5 ) + 10;
  v         = PowF (  10, last_exp * ( 1.0F / 16.0F )  );
  max_scale = v;
  n         = *ptr++;
  do {
   *q++ = v;
  } while ( --n );
 } else last_exp = 36;

 while ( q < q_end ) {
  code = SMS_GetVLC2 ( lpBitCtx, lpCtx -> exp_vlc.m_pTable, EXPVLCBITS, EXPMAX );
  if ( code < 0 ) return -1;
  last_exp += code - 60;
  v         = PowF (  10, last_exp * ( 1.0F / 16.0F )  );
  if ( v > max_scale ) max_scale = v;
  n         = *ptr++;
  do {
   *q++ = v;
  } while ( --n );
 }  /* end while */

 lpCtx -> max_exponent[ ch ] = max_scale;

 return 0;

}  /* end decode_exp_vlc */

static void wma_window ( float* out ) {

 WMADecodeContext* lpCtx = &s_Ctx;
 float*            in    = lpCtx -> output;
 int               block_len, bsize, n;

 if ( lpCtx -> block_len_bits <= lpCtx -> prev_block_len_bits) {
  block_len = lpCtx -> block_len;
  bsize     = lpCtx -> frame_len_bits - lpCtx -> block_len_bits;
  DSP_VecMULA ( out, in, lpCtx -> windows[ bsize ], out, block_len );
 } else {
  block_len = 1 << lpCtx -> prev_block_len_bits;
  n         = ( lpCtx -> block_len - block_len ) / 2;
  bsize     = lpCtx -> frame_len_bits - lpCtx -> prev_block_len_bits;
  DSP_VecMULA ( out + n, in + n, lpCtx -> windows[ bsize ], out +n , block_len );
  memcpy (  out + n + block_len, in + n + block_len, n * sizeof ( float )  );
 }  /* end else */

 out += lpCtx -> block_len;
 in  += lpCtx -> block_len;

 if ( lpCtx -> block_len_bits <= lpCtx -> next_block_len_bits ) {
  block_len = lpCtx -> block_len;
  bsize     = lpCtx -> frame_len_bits - lpCtx -> block_len_bits;
  DSP_VecMULR ( out, in, lpCtx -> windows[ bsize ], block_len );
 } else {
  block_len = 1 << lpCtx -> next_block_len_bits;
  n         = ( lpCtx -> block_len - block_len ) / 2;
  bsize     = lpCtx -> frame_len_bits - lpCtx -> next_block_len_bits;
  memcpy (  out, in, n * sizeof ( float )  );
  DSP_VecMULR ( out + n, in + n, lpCtx -> windows[ bsize ], block_len );
  memset (  out + n + block_len, 0, n * sizeof ( float )  );
 }  /* end else */

}  /* end wma_window */

int SMS_INLINE wma_total_gain_to_bits ( int total_gain ){
 if ( total_gain < 15 ) return 13;
 if ( total_gain < 32 ) return 12;
 if ( total_gain < 40 ) return 11;
 if ( total_gain < 45 ) return 10;
 return  9;
}  /* end wma_total_gain_to_bits */

static int wma_decode_block ( void ) {

 WMADecodeContext* lpCtx    = &s_Ctx;
 SMS_BitContext*   lpBitCtx = &lpCtx -> gb;
 int               n, v, a, ch, code, bsize;
 int               coef_nb_bits, total_gain;
 int               nb_coefs[ MAX_CHANNELS ];
 float             mdct_norm;

 if ( lpCtx -> use_variable_block_len ) {
  n = SMS_log2 ( lpCtx -> nb_block_sizes - 1 ) + 1;
  if ( lpCtx -> reset_block_lengths ) {
   lpCtx -> reset_block_lengths = 0;
   v = SMS_GetBits ( lpBitCtx, n );
   if ( v >= lpCtx -> nb_block_sizes ) return -1;
   lpCtx -> prev_block_len_bits = lpCtx -> frame_len_bits - v;
   v = SMS_GetBits ( lpBitCtx, n );
   if ( v >= lpCtx -> nb_block_sizes ) return -1;
   lpCtx -> block_len_bits = lpCtx -> frame_len_bits - v;
  } else {
   lpCtx -> prev_block_len_bits = lpCtx -> block_len_bits;
   lpCtx -> block_len_bits      = lpCtx -> next_block_len_bits;
  }  /* end else */
  v = SMS_GetBits ( lpBitCtx, n );
  if ( v >= lpCtx -> nb_block_sizes ) return -1;
  lpCtx -> next_block_len_bits = lpCtx -> frame_len_bits - v;
 } else {
  lpCtx -> next_block_len_bits = lpCtx -> frame_len_bits;
  lpCtx -> prev_block_len_bits = lpCtx -> frame_len_bits;
  lpCtx -> block_len_bits      = lpCtx -> frame_len_bits;
 }  /* end else */

 lpCtx -> block_len = 1 << lpCtx -> block_len_bits;

 if (  ( lpCtx -> block_pos + lpCtx -> block_len ) > lpCtx -> frame_len  ) return -1;

 if ( lpCtx -> nb_channels == 2 ) lpCtx -> ms_stereo = SMS_GetBit ( lpBitCtx );

 v = 0;

 for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) {
  a                            = SMS_GetBit ( lpBitCtx );
  lpCtx -> channel_coded[ ch ] = a;
  v                           |= a;
 }  /* end for */

 if ( !v ) goto next;

 bsize      = lpCtx -> frame_len_bits - lpCtx -> block_len_bits;
 total_gain = 1;

 while ( 1 ) {
  a           = SMS_GetBits ( lpBitCtx, 7 );
  total_gain += a;
  if ( a != 127 ) break;
 }  /* end while */

 coef_nb_bits = wma_total_gain_to_bits ( total_gain );

 n = lpCtx -> coefs_end[ bsize ] - lpCtx -> coefs_start;

 for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) nb_coefs[ ch ] = n;

 if ( lpCtx -> use_noise_coding ) {

  for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) {
   if ( lpCtx -> channel_coded[ ch ] ) {
    int i, n, a;
    n = lpCtx -> exponent_high_sizes[ bsize ];
    for ( i = 0; i < n; ++i ) {
     a = SMS_GetBit ( lpBitCtx );
     lpCtx -> high_band_coded[ ch ][ i ] = a;
     if ( a ) nb_coefs[ ch ] -= lpCtx -> exponent_high_bands[ bsize ][ i ];
    }  /* end for */
   }  /* end if */
  }  /* end for */

  for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) {
   if ( lpCtx -> channel_coded[ ch ] ) {
    int i, n, val, code;
    n   = lpCtx -> exponent_high_sizes[ bsize ];
    val = ( int )0x80000000;
    for ( i = 0; i < n; ++i ) {
     if ( lpCtx -> high_band_coded[ ch ][ i ] ) {
      if (  val == ( int )0x80000000  ) {
       val = SMS_GetBits ( lpBitCtx, 7 ) - 19;
      } else {
       code = SMS_GetVLC2 (
        lpBitCtx, lpCtx -> hgain_vlc.m_pTable, HGAINVLCBITS, HGAINMAX
       );
       if ( code < 0 ) return -1;
       val += code - 18;
      }  /* end else */
      lpCtx -> high_band_values[ ch ][ i ] = val;
     }  /* end if */
    }  /* en dfor */
   }  /* end if */
  }  /* end for */

 }  /* end if */

 if (  ( lpCtx -> block_len_bits == lpCtx -> frame_len_bits ) || SMS_GetBit ( lpBitCtx )  ) {
  for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) {
   if ( lpCtx -> channel_coded[ ch ] ) {
    if ( lpCtx -> use_exp_vlc ) {
     if (  decode_exp_vlc ( ch ) < 0  ) return -1;
    } else decode_exp_lsp ( ch );
    lpCtx -> exponents_bsize[ch] = bsize;
   }  /* end if */
  }  /* end for */
 }  /* end if */

 for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) {
  if ( lpCtx -> channel_coded[ ch ] ) {
   SMS_VLC*        coef_vlc;
   int             level, run, sign, tindex;
   int16_t*        ptr, *eptr;
   const uint16_t* level_table, *run_table;
   tindex      = ( ch == 1 && lpCtx -> ms_stereo );
   coef_vlc    = &lpCtx -> coef_vlc  [ tindex ];
   run_table   = lpCtx -> run_table  [ tindex ];
   level_table = lpCtx -> level_table[ tindex ];
   ptr         = &lpCtx -> coefs1[ ch ][ 0 ];
   eptr        = ptr + nb_coefs[ ch ];
   memset (  ptr, 0, lpCtx -> block_len * sizeof ( int16_t )  );
   while ( 1 ) {
    code = SMS_GetVLC2 ( lpBitCtx, coef_vlc -> m_pTable, VLCBITS, VLCMAX );
    if ( code < 0  ) return -1;
    if ( code == 1 ) break;
    if ( code == 0 ) {
     level = SMS_GetBits ( lpBitCtx, coef_nb_bits            );
     run   = SMS_GetBits ( lpBitCtx, lpCtx -> frame_len_bits );
    } else {
     run   = run_table  [ code ];
     level = level_table[ code ];
    }  /* end else */
    sign = SMS_GetBit ( lpBitCtx );
    if ( !sign ) level = -level;
    ptr += run;
    if ( ptr >= eptr ) break;
    *ptr++ = level;
    if ( ptr >= eptr ) break;
   }  /* end while */
  }  /* end if */
  if ( lpCtx -> version == 1 && lpCtx->nb_channels >= 2 ) SMS_AlignBits ( lpBitCtx );
 }  /* end for */

 ch        = lpCtx -> block_len / 2;
 mdct_norm = 1.0F / ( float )ch;
 if ( lpCtx -> version == 1 ) mdct_norm *= sqrtf ( ch );

 for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) {
  if ( lpCtx -> channel_coded[ ch ] ) {
   int16_t* coefs1;
   float*   coefs, *exponents, mult, mult1, noise;
   int      i, j, n, n1, last_high_band, esize;
   float    exp_power[ HIGH_BAND_MAX_SIZE ];
   coefs1    = lpCtx -> coefs1         [ ch ];
   exponents = lpCtx -> exponents      [ ch ];
   esize     = lpCtx -> exponents_bsize[ ch ];
   mult      = PowF ( 10, total_gain * 0.05F ) / lpCtx -> max_exponent[ ch ];
   mult     *= mdct_norm;
   coefs     = lpCtx -> coefs[ ch ];
   if ( lpCtx -> use_noise_coding ) {
    mult1 = mult;
    for ( i = 0; i < lpCtx -> coefs_start; ++i ) {
     *coefs++ = lpCtx -> noise_table[ lpCtx -> noise_index ] * exponents[ i << bsize >> esize ] * mult1;
     lpCtx -> noise_index = ( lpCtx -> noise_index + 1 ) & ( NOISE_TAB_SIZE - 1 );
    }  /* end for */
    n1             = lpCtx -> exponent_high_sizes[ bsize ];
    exponents      = lpCtx -> exponents[ ch ] + ( lpCtx -> high_band_start[ bsize ] << bsize );
    last_high_band = 0;
    for ( j = 0; j < n1; ++j ) {
     n = lpCtx -> exponent_high_bands[ lpCtx -> frame_len_bits - lpCtx -> block_len_bits ][ j ];
     if ( lpCtx -> high_band_coded[ ch ][ j ] ) {
      float e2, v;
      e2 = 0;
      for ( i = 0; i < n; ++i ) {
       v   = exponents[ i << bsize >> esize ];
       e2 += v * v;
      }  /* end for */
      exp_power[ j ] = e2 / n;
      last_high_band = j;
     }  /* end if */
     exponents += n << bsize;
    }  /* end for */
    exponents = lpCtx -> exponents[ ch ] + ( lpCtx -> coefs_start << bsize );
    for ( j = -1; j < n1; ++j ) {
     if ( j < 0 ) {
      n = lpCtx -> high_band_start[ bsize ] - lpCtx -> coefs_start;
     } else {
      n = lpCtx -> exponent_high_bands[ lpCtx -> frame_len_bits - lpCtx -> block_len_bits ][ j ];
     }  /* end else */
     if ( j >= 0 && lpCtx -> high_band_coded[ ch ][ j ] ) {
      mult1  = sqrtf ( exp_power[ j ] / exp_power[ last_high_band ] );
      mult1  = mult1 * PowF ( 10, lpCtx->high_band_values[ ch ][ j ] * 0.05F );
      mult1  = mult1 / ( lpCtx -> max_exponent[ ch ] * lpCtx -> noise_mult );
      mult1 *= mdct_norm;
      for ( i = 0;i < n; ++i ) {
       noise = lpCtx -> noise_table[ lpCtx -> noise_index ];
       lpCtx -> noise_index = ( lpCtx -> noise_index + 1 ) & ( NOISE_TAB_SIZE - 1 );
       *coefs++ = noise * exponents[ i << bsize >> esize ] * mult1;
      }  /* end for */
      exponents += n<<bsize;
     } else {
      for ( i = 0; i < n; ++i ) {
       noise = lpCtx -> noise_table[ lpCtx -> noise_index];
       lpCtx -> noise_index = ( lpCtx -> noise_index + 1 ) & ( NOISE_TAB_SIZE - 1 );
       *coefs++ = (  ( *coefs1++ ) + noise  ) * exponents[ i << bsize >> esize ] * mult;
      }  /* end for */
      exponents += n<<bsize;
     }  /* end else */
    }  /* end for */
    n     = lpCtx -> block_len - lpCtx -> coefs_end[ bsize ];
    mult1 = mult * exponents[ (  ( -1 << bsize )  ) >> esize ];
    for ( i = 0; i < n; ++i ) {
     *coefs++ = lpCtx -> noise_table[ lpCtx -> noise_index ] * mult1;
     lpCtx -> noise_index = ( lpCtx -> noise_index + 1 ) & ( NOISE_TAB_SIZE - 1 );
    }  /* end for */
   } else {
    for ( i = 0;i < lpCtx -> coefs_start; ++i ) *coefs++ = 0.0;
    n = nb_coefs[ ch ];
    for ( i = 0;i < n; ++i ) *coefs++ = coefs1[ i ] * exponents[ i << bsize >> esize ] * mult;
    n = lpCtx -> block_len - lpCtx -> coefs_end[ bsize ];
    for ( i = 0; i < n; ++i ) *coefs++ = 0.0;
   }  /* end else */
  }  /* end if */
 }  /* end for */

 if ( lpCtx -> ms_stereo && lpCtx -> channel_coded[ 1 ] ) {
  float a, b;
  int   i;
  if ( !lpCtx -> channel_coded[ 0 ] ) {
   memset (  lpCtx -> coefs[ 0 ], 0, sizeof ( float ) * lpCtx -> block_len  );
   lpCtx -> channel_coded[ 0 ] = 1;
  }  /* end if */
  for ( i = 0; i < lpCtx -> block_len; ++i ) {
   a = lpCtx -> coefs[ 0 ][ i ];
   b = lpCtx -> coefs[ 1 ][ i ];
   lpCtx -> coefs[ 0 ][ i ] = a + b;
   lpCtx -> coefs[ 1 ][ i ] = a - b;
  }  /* end for */
 }  /* end if */

 for ( ch = 0; ch < lpCtx -> nb_channels; ++ch ) {
  if ( lpCtx -> channel_coded[ ch ] ) {
   int n4, index;
   n4 = lpCtx -> block_len >> 1;
   DSP_IMDCT ( &lpCtx -> mdct_ctx[ bsize ], lpCtx -> output, lpCtx -> coefs[ ch ] );
   index = ( lpCtx -> frame_len / 2 ) + lpCtx -> block_pos - n4;
   wma_window ( &lpCtx -> frame_out[ ch ][ index ] );
   if  ( lpCtx -> ms_stereo && !lpCtx -> channel_coded[ 1 ] ) wma_window ( &lpCtx -> frame_out[ 1 ][ index ] );
  }  /* end if */
 }  /* end for */
next:
 ++lpCtx -> block_num;
 lpCtx -> block_pos += lpCtx -> block_len;

 return lpCtx -> block_pos >= lpCtx -> frame_len;

}  /* end wma_decode_block */

static int wma_decode_frame ( SMS_RingBuffer* apOutput ) {

 WMADecodeContext* lpCtx  = &s_Ctx;
 float*            lppPCM[ 2 ];
 int               i, lnParts, lRem, lBlockLen;
 short*            lpSamples;

 lBlockLen = 4096 >> lpCtx -> nb_channels;
 lnParts   = lpCtx -> frame_len / lBlockLen;
 lRem      = lpCtx -> frame_len % lBlockLen;

 lpCtx -> block_num = 0;
 lpCtx -> block_pos = 0;

 lppPCM[ 0 ] = lpCtx -> frame_out[ 0 ];
 lppPCM[ 1 ] = lpCtx -> frame_out[ 1 ];

 while ( 1 ) {
  int lSts = wma_decode_block ();
  if ( lSts < 0 ) return 0;
  if ( lSts     ) break;
 }  /* end while */

 for ( i = 0; i < lnParts; ++i ) {

  lpSamples  = ( short* )SMS_RingBufferAlloc ( apOutput, 4096 + 80 );
  lpSamples += 32;
  *( int* )lpSamples = 4096;
  lpSamples += 8;

  lpCtx -> PCMSyn ( lpSamples, lppPCM, lBlockLen );
  apOutput -> UserCB ( apOutput );

  lppPCM[ 0 ] += lBlockLen;
  lppPCM[ 1 ] += lBlockLen;

  RotateThreadReadyQueue ( SMS_THREAD_PRIORITY );

 }  /* end for */

 if ( lRem ) {

  lnParts    = lRem << lpCtx -> nb_channels;
  lpSamples  = ( short* )SMS_RingBufferAlloc ( apOutput, lnParts + 80 );
  lpSamples += 32;
  *( int* )lpSamples = lnParts;
  lpSamples += 8;

  lpCtx -> PCMSyn ( lpSamples, lppPCM, lRem );
  apOutput -> UserCB ( apOutput );

  lppPCM[ 0 ] += lRem;
  lppPCM[ 1 ] += lRem;

  RotateThreadReadyQueue ( SMS_THREAD_PRIORITY );

 }  /* end if */

 memcpy (  lpCtx -> frame_out[ 0 ], lppPCM[ 0 ], lpCtx -> frame_len * sizeof ( float )  );
 memcpy (  lpCtx -> frame_out[ 1 ], lppPCM[ 1 ], lpCtx -> frame_len * sizeof ( float )  );

 return 1;

}  /* end wma_decode_frame */

static int wma_decode_superframe ( SMS_CodecContext* apCtx, SMS_RingBuffer* apOutput, SMS_RingBuffer* apInput ) {

 WMADecodeContext* lpCtx    = &s_Ctx;
 SMS_BitContext*   lpBitCtx = &lpCtx -> gb;
 SMS_AVPacket*     lpPkt    = ( SMS_AVPacket* )apInput -> m_pOut;
 uint8_t*          lpBuf    = lpPkt -> m_pData;
 int32_t           lBufSize = lpPkt -> m_Size;
 int               lFrmSize = lpCtx -> block_align;
 int               nb_frames, bit_offset, i, pos, len;
 unsigned char*    q;

 while ( lBufSize > 0 ) {

  SMS_InitGetBits ( lpBitCtx, lpBuf, lFrmSize * 8 );

  if ( lpCtx -> use_bit_reservoir ) {

   SMS_SkipBits ( lpBitCtx, 4 );
   nb_frames  = SMS_GetBits ( lpBitCtx, 4 ) - 1;
   bit_offset = SMS_GetBits ( lpBitCtx, lpCtx -> byte_offset_bits + 3 );
   if ( lpCtx -> last_superframe_len > 0 ) {
    if (    (   lpCtx -> last_superframe_len + (  ( bit_offset + 7 ) >> 3  )   ) > MAX_CODED_SUPERFRAME_SIZE    ) goto error;
    q   = lpCtx -> last_superframe + lpCtx -> last_superframe_len;
    len = bit_offset;
    while ( len > 7 ) {
     *q++ = SMS_GetBits ( lpBitCtx, 8 );
     len -= 8;
    }  /* end while */
    if ( len > 0 ) *q++ = SMS_GetBits ( lpBitCtx, len ) << ( 8 - len );
    SMS_InitGetBits ( lpBitCtx, lpCtx -> last_superframe, MAX_CODED_SUPERFRAME_SIZE * 8 );
    if ( lpCtx -> last_bitoffset > 0 ) SMS_SkipBits ( lpBitCtx, lpCtx -> last_bitoffset );
    if (  !wma_decode_frame ( apOutput )  ) goto error;
   }  /* end if */
   pos = bit_offset + 4 + 4 + lpCtx -> byte_offset_bits + 3;
   SMS_InitGetBits (   lpBitCtx, lpBuf + ( pos >> 3 ), (  MAX_CODED_SUPERFRAME_SIZE - ( pos >> 3 )  ) * 8   );
   len = pos & 7;
   if ( len > 0 ) SMS_SkipBits ( lpBitCtx, len );
   lpCtx -> reset_block_lengths = 1;
   for ( i = 0; i < nb_frames; ++i ) if (  !wma_decode_frame ( apOutput )  ) goto error;
   pos = SMS_BitCount ( lpBitCtx ) + (  ( bit_offset + 4 + 4 + lpCtx -> byte_offset_bits + 3 ) & ~7  );
   lpCtx -> last_bitoffset = pos & 7;
   pos >>= 3;
   len = lFrmSize - pos;
   if ( len > MAX_CODED_SUPERFRAME_SIZE || len < 0 ) goto error;
   lpCtx -> last_superframe_len = len;
   memcpy ( lpCtx -> last_superframe, lpBuf + pos, len );

  } else if (  !wma_decode_frame ( apOutput )  ) {
error:
   lpCtx -> last_superframe_len = 0;
   return 0;
  }  /* end if */

  lpBuf    += lFrmSize;
  lBufSize -= lFrmSize;

 }  /* end while */

 return 0;

}  /* end wma_decode_superframe */

void SMS_Codec_WMA_Open ( SMS_CodecContext* apCtx ) {

 apCtx -> m_pCodec = calloc (  1, sizeof ( SMS_Codec )  );

 apCtx -> m_pCodec -> m_pName = g_pWMA;
 apCtx -> m_pCodec -> m_pCtx  = &s_Ctx;
 apCtx -> m_pCodec -> Init    = wma_decode_init;
 apCtx -> m_pCodec -> Decode  = wma_decode_superframe;
 apCtx -> m_pCodec -> Destroy = wma_decode_end;

}  /* end SMS_Codec_WMA_Open */
