/*
#     ___  _ _      ___
#    |    | | |    |
# ___|    |   | ___|    PS2DEV Open Source Project.
#----------------------------------------------------------
# Copyright 1995-2006 by the mpg123 project - free software under the terms of the LGPL 2.1
# initially written by Michael Hipp
# Adopted for SMS in 2006 by Eugene Plotnikov
# Licensed (like the original mpg123 source code) under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation;
# either version 2 of the License, or (at your option) any later version.
#
*/
#include "SMS_MP123.h"
#include "SMS_RingBuffer.h"

#include <malloc.h>
#include <string.h>

#ifndef _WIN32
#include <kernel.h>
#include "SMS_DMA.h"
#endif  /* _WIN32 */

typedef struct _BandInfo {

 int m_LongIdx  [ 23 ];
 int m_LongDiff [ 22 ];
 int m_ShortIdx [ 14 ];
 int m_ShortDiff[ 13 ];

} _BandInfo;

typedef struct _Huff {

 unsigned int m_LinBits;
 short*       m_pTable;

} _Huff;

typedef float ( *CTabArray64 )[ 64 ];

static int32_t MP123_Init    ( SMS_CodecContext*                                   );
static int32_t MP123_Decode  ( SMS_CodecContext*, SMS_RingBuffer*, SMS_RingBuffer* );
static void    MP123_Destroy ( SMS_CodecContext*                                   );

SMS_Codec_MPAContext g_MPACtx;

const uint16_t g_mpa_freq_tab[ 3 ] = { 44100, 48000, 32000 };
const uint16_t g_mpa_bitrate_tab[ 2 ][ 3 ][ 15 ] = {
 {
  { 0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448 },
  { 0, 32, 48, 56,  64,  80,  96, 112, 128, 160, 192, 224, 256, 320, 384 },
  { 0, 32, 40, 48,  56,  64,  80,  96, 112, 128, 160, 192, 224, 256, 320 }
 },
 {
  { 0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256 },
  { 0,  8, 16, 24, 32, 40, 48,  56,  64,  80,  96, 112, 128, 144, 160 },
  { 0,  8, 16, 24, 32, 40, 48,  56,  64,  80,  96, 112, 128, 144, 160 }
 }
};
_BandInfo s_BandInfo[ 9 ] = { 
 {
  {  0,  4,   8,  12,  16,  20,  24,  30,  36,  44,  52, 62,
    74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576
  },
  {  4,  4,  4,  4,  4,  4,  6,  6,  8,  8,  10,
    12, 16, 20, 24, 28, 34, 42, 50, 54, 76, 158
  },
  {   0,  12,  24,  36,  48,  66,  90,
    120, 156, 198, 252, 318, 408, 576
  },
  {  4,  4,  4,  4,  6,  8, 10,
    12, 14, 18, 22, 30, 56
  }
 },
 {
  {  0,  4,   8,  12,  16,  20,  24,  30,  36,  42,  50, 60,
    72, 88, 106, 128, 156, 190, 230, 276, 330, 384, 576
  },
  {  4,  4,  4,  4,  4,  4,  6,  6,  6,  8,  10,
    12, 16, 18, 22, 28, 34, 40, 46, 54, 54, 192
  },
  {   0,  12,  24,  36,  48,  66,  84,
    114, 150, 192, 240, 300, 378, 576
  },
  {  4,  4,  4,  4,  6,  6, 10,
    12, 14, 16, 20, 26, 66
  }
 },
 {
  {  0,   4,   8,  12,  16,  20,  24,  30,  36,  44, 54, 66,
    82, 102, 126, 156, 194, 240, 296, 364, 448, 550, 576
  },
  {  4,  4,  4,  4,  4,  4,  6,  6,  8,  10, 12,
    16, 20, 24, 30, 38, 46, 56, 68, 84, 102, 26
  },
  {   0,  12,  24,  36,  46,  66,  90,
    126, 174, 234, 312, 414, 540, 576
  },
  {  4,  4,  4,  4,  6,  8, 12,
    16, 20, 26, 34, 42, 12
  }
 },
 {
  {   0,   6,  12,  18,  24,  30,  36,  44,  54,  66,  80, 96,
    116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576
  },
  {  6,  6,  6,  6,  6,  6,  8, 10, 12, 14, 16,
    20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54
  },
  {   0,  12,  24,  36,  54,  72,  96,
    126, 168, 222, 300, 396, 522, 576
  },
  {  4,  4,  4,  6,  6,  8, 10,
    14, 18, 26, 32, 42, 18
  }
 },
 {
  {   0,   6,  12,  18,  24,  30,  36,  44,  54,  66,  80, 96,
    114, 136, 162, 194, 232, 278, 330, 394, 464, 540, 576
  },
  {  6,  6,  6,  6,  6,  6,  8, 10, 12, 14, 16,
    18, 22, 26, 32, 38, 46, 52, 64, 70, 76, 36
  },
  {   0,  12,  24,  36,  54,  78, 108,
    144, 186, 240, 312, 408, 540, 576
  },
  {  4,  4,  4,  6,  8, 10, 12,
    14, 18, 24, 32, 44, 12
  }
 },
 {
  {   0,   6,  12,  18,  24,  30,  36,  44,  54,  66,  80, 96,
    116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576
  },
  {  6,  6,  6,  6,  6,  6,  8, 10, 12, 14, 16,
    20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54
  },
  {   0,  12,  24,  36,  54,  78, 108,
    144, 186, 240, 312, 402, 522, 576
  },
  {  4,  4,  4,  6,  8, 10, 12,
    14, 18, 24, 30, 40, 18
  }
 } ,
 {
  {   0,   6,  12,  18,  24,  30,  36,  44,  54,  66,  80, 96,
    116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576
  },
  {  6,  6,  6,  6,  6,  6,  8, 10, 12, 14, 16,
    20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54
  },
  {   0,  12,  24,  36,  54,  78, 108,
    144, 186, 240, 312, 402, 522, 576
  },
  {  4,  4,  4,  6,  8, 10, 12,
    14, 18, 24, 30, 40, 18
  }
 },
 {
  {   0,   6,  12,  18,  24,  30,  36,  44,  54,  66,  80, 96,
    116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576
  },
  {  6,  6,  6,  6,  6,  6,  8, 10, 12, 14, 16,
    20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54
  },
  {   0,  12,  24,  36,  54,  78, 108,
    144, 186, 240, 312, 402, 522, 576
  },
  {  4,  4,  4,  6,  8, 10, 12,
    14, 18, 24, 30, 40, 18
  }
 },
 {
  {   0,  12,  24,  36,  48,  60,  72,  88, 108, 132, 160, 192,
    232, 280, 336, 400, 476, 566, 568, 570, 572, 574, 576
  },
  { 12, 12, 12, 12, 12, 12, 16, 20, 24, 28, 32,
    40, 48, 56, 64, 76, 90,  2,  2,  2,  2,  2
  },
  {   0,  24,  48,  72, 108, 156, 216,
    288, 372, 480, 486, 492, 498, 576
  },
  {  8,  8, 8, 12, 16, 20, 24,
    28, 36, 2,  2,  2, 26
  }
 }
};
static unsigned int s_GainPow2[ 378 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x453504F3, 0x451837F0, 0x45000000, 0x44D744FD,
 0x44B504F3, 0x449837F0, 0x44800000, 0x445744FD,
 0x443504F3, 0x441837F0, 0x44000000, 0x43D744FD,
 0x43B504F3, 0x439837F0, 0x43800000, 0x435744FD,
 0x433504F3, 0x431837F0, 0x43000000, 0x42D744FD,
 0x42B504F3, 0x429837F0, 0x42800000, 0x425744FD,
 0x423504F3, 0x421837F0, 0x42000000, 0x41D744FD,
 0x41B504F3, 0x419837F0, 0x41800000, 0x415744FD,
 0x413504F3, 0x411837F0, 0x41000000, 0x40D744FD,
 0x40B504F3, 0x409837F0, 0x40800000, 0x405744FD,
 0x403504F3, 0x401837F0, 0x40000000, 0x3FD744FD,
 0x3FB504F3, 0x3F9837F0, 0x3F800000, 0x3F5744FD,
 0x3F3504F3, 0x3F1837F0, 0x3F000000, 0x3ED744FD,
 0x3EB504F3, 0x3E9837F0, 0x3E800000, 0x3E5744FD,
 0x3E3504F3, 0x3E1837F0, 0x3E000000, 0x3DD744FD,
 0x3DB504F3, 0x3D9837F0, 0x3D800000, 0x3D5744FD,
 0x3D3504F3, 0x3D1837F0, 0x3D000000, 0x3CD744FD,
 0x3CB504F3, 0x3C9837F0, 0x3C800000, 0x3C5744FD,
 0x3C3504F3, 0x3C1837F0, 0x3C000000, 0x3BD744FD,
 0x3BB504F3, 0x3B9837F0, 0x3B800000, 0x3B5744FD,
 0x3B3504F3, 0x3B1837F0, 0x3B000000, 0x3AD744FD,
 0x3AB504F3, 0x3A9837F0, 0x3A800000, 0x3A5744FD,
 0x3A3504F3, 0x3A1837F0, 0x3A000000, 0x39D744FD,
 0x39B504F3, 0x399837F0, 0x39800000, 0x395744FD,
 0x393504F3, 0x391837F0, 0x39000000, 0x38D744FD,
 0x38B504F3, 0x389837F0, 0x38800000, 0x385744FD,
 0x383504F3, 0x381837F0, 0x38000000, 0x37D744FD,
 0x37B504F3, 0x379837F0, 0x37800000, 0x375744FD,
 0x373504F3, 0x371837F0, 0x37000000, 0x36D744FD,
 0x36B504F3, 0x369837F0, 0x36800000, 0x365744FD,
 0x363504F3, 0x361837F0, 0x36000000, 0x35D744FD,
 0x35B504F3, 0x359837F0, 0x35800000, 0x355744FD,
 0x353504F3, 0x351837F0, 0x35000000, 0x34D744FD,
 0x34B504F3, 0x349837F0, 0x34800000, 0x345744FD,
 0x343504F3, 0x341837F0, 0x34000000, 0x33D744FD,
 0x33B504F3, 0x339837F0, 0x33800000, 0x335744FD,
 0x333504F3, 0x331837F0, 0x33000000, 0x32D744FD,
 0x32B504F3, 0x329837F0, 0x32800000, 0x325744FD,
 0x323504F3, 0x321837F0, 0x32000000, 0x31D744FD,
 0x31B504F3, 0x319837F0, 0x31800000, 0x315744FD,
 0x313504F3, 0x311837F0, 0x31000000, 0x30D744FD,
 0x30B504F3, 0x309837F0, 0x30800000, 0x305744FD,
 0x303504F3, 0x301837F0, 0x30000000, 0x2FD744FD,
 0x2FB504F3, 0x2F9837F0, 0x2F800000, 0x2F5744FD,
 0x2F3504F3, 0x2F1837F0, 0x2F000000, 0x2ED744FD,
 0x2EB504F3, 0x2E9837F0, 0x2E800000, 0x2E5744FD,
 0x2E3504F3, 0x2E1837F0, 0x2E000000, 0x2DD744FD,
 0x2DB504F3, 0x2D9837F0, 0x2D800000, 0x2D5744FD,
 0x2D3504F3, 0x2D1837F0, 0x2D000000, 0x2CD744FD,
 0x2CB504F3, 0x2C9837F0, 0x2C800000, 0x2C5744FD,
 0x2C3504F3, 0x2C1837F0, 0x2C000000, 0x2BD744FD,
 0x2BB504F3, 0x2B9837F0, 0x2B800000, 0x2B5744FD,
 0x2B3504F3, 0x2B1837F0, 0x2B000000, 0x2AD744FD,
 0x2AB504F3, 0x2A9837F0, 0x2A800000, 0x2A5744FD,
 0x2A3504F3, 0x2A1837F0, 0x2A000000, 0x29D744FD,
 0x29B504F3, 0x299837F0, 0x29800000, 0x295744FD,
 0x293504F3, 0x291837F0, 0x29000000, 0x28D744FD,
 0x28B504F3, 0x289837F0, 0x28800000, 0x285744FD,
 0x283504F3, 0x281837F0, 0x28000000, 0x27D744FD,
 0x27B504F3, 0x279837F0, 0x27800000, 0x275744FD,
 0x273504F3, 0x271837F0, 0x27000000, 0x26D744FD,
 0x26B504F3, 0x269837F0, 0x26800000, 0x265744FD,
 0x263504F3, 0x261837F0, 0x26000000, 0x25D744FD,
 0x25B504F3, 0x259837F0, 0x25800000, 0x255744FD,
 0x253504F3, 0x251837F0, 0x25000000, 0x24D744FD,
 0x24B504F3, 0x249837F0, 0x24800000, 0x245744FD,
 0x243504F3, 0x241837F0, 0x24000000, 0x23D744FD,
 0x23B504F3, 0x239837F0, 0x23800000, 0x235744FD,
 0x233504F3, 0x231837F0, 0x23000000, 0x22D744FD,
 0x22B504F3, 0x229837F0, 0x22800000, 0x225744FD,
 0x223504F3, 0x221837F0, 0x22000000, 0x21D744FD,
 0x21B504F3, 0x219837F0, 0x21800000, 0x215744FD,
 0x213504F3, 0x211837F0, 0x21000000, 0x20D744FD,
 0x20B504F3, 0x209837F0, 0x20800000, 0x205744FD,
 0x203504F3, 0x201837F0, 0x20000000, 0x1FD744FD,
 0x1FB504F3, 0x1F9837F0, 0x1F800000, 0x1F5744FD,
 0x1F3504F3, 0x1F1837F0, 0x1F000000, 0x1ED744FD,
 0x1EB504F3, 0x1E9837F0, 0x1E800000, 0x1E5744FD,
 0x1E3504F3, 0x1E1837F0, 0x1E000000, 0x1DD744FD,
 0x1DB504F3, 0x1D9837F0, 0x1D800000, 0x1D5744FD,
 0x1D3504F3, 0x1D1837F0, 0x1D000000, 0x1CD744FD,
 0x1CB504F3, 0x1C9837F0, 0x1C800000, 0x1C5744FD,
 0x1C3504F3, 0x1C1837F0, 0x1C000000, 0x1BD744FD,
 0x1BB504F3, 0x1B9837F0, 0x1B800000, 0x1B5744FD,
 0x1B3504F3, 0x1B1837F0, 0x1B000000, 0x1AD744FD,
 0x1AB504F3, 0x1A9837F0, 0x1A800000, 0x1A5744FD,
 0x1A3504F3, 0x1A1837F0, 0x1A000000, 0x19D744FD,
 0x19B504F3, 0x199837F0, 0x19800000, 0x195744FD,
 0x193504F3, 0x191837F0, 0x19000000, 0x18D744FD,
 0x18B504F3, 0x189837F0, 0x18800000, 0x185744FD,
 0x183504F3, 0x181837F0, 0x18000000, 0x17D744FD,
 0x17B504F3, 0x179837F0, 0x17800000, 0x175744FD,
 0x173504F3, 0x171837F0, 0x17000000, 0x16D744FD,
 0x16B504F3, 0x169837F0, 0x16800000, 0x165744FD,
 0x163504F3, 0x161837F0
};
static unsigned short s_nSLen2[ 512 ] = {
 0x0000,  0x0200,  0x0400,  0x0600,  0x0040,  0x0240,  0x0440,  0x0640,
 0x0080,  0x0280,  0x0480,  0x0680,  0x00C0,  0x02C0,  0x04C0,  0x06C0,
 0x0008,  0x0208,  0x0408,  0x0608,  0x0048,  0x0248,  0x0448,  0x0648,
 0x0088,  0x0288,  0x0488,  0x0688,  0x00C8,  0x02C8,  0x04C8,  0x06C8,
 0x0010,  0x0210,  0x0410,  0x0610,  0x0050,  0x0250,  0x0450,  0x0650,
 0x0090,  0x0290,  0x0490,  0x0690,  0x00D0,  0x02D0,  0x04D0,  0x06D0,
 0x0018,  0x0218,  0x0418,  0x0618,  0x0058,  0x0258,  0x0458,  0x0658,
 0x0098,  0x0298,  0x0498,  0x0698,  0x00D8,  0x02D8,  0x04D8,  0x06D8,
 0x0020,  0x0220,  0x0420,  0x0620,  0x0060,  0x0260,  0x0460,  0x0660,
 0x00A0,  0x02A0,  0x04A0,  0x06A0,  0x00E0,  0x02E0,  0x04E0,  0x06E0,
 0x0001,  0x0201,  0x0401,  0x0601,  0x0041,  0x0241,  0x0441,  0x0641,
 0x0081,  0x0281,  0x0481,  0x0681,  0x00C1,  0x02C1,  0x04C1,  0x06C1,
 0x0009,  0x0209,  0x0409,  0x0609,  0x0049,  0x0249,  0x0449,  0x0649,
 0x0089,  0x0289,  0x0489,  0x0689,  0x00C9,  0x02C9,  0x04C9,  0x06C9,
 0x0011,  0x0211,  0x0411,  0x0611,  0x0051,  0x0251,  0x0451,  0x0651,
 0x0091,  0x0291,  0x0491,  0x0691,  0x00D1,  0x02D1,  0x04D1,  0x06D1,
 0x0019,  0x0219,  0x0419,  0x0619,  0x0059,  0x0259,  0x0459,  0x0659,
 0x0099,  0x0299,  0x0499,  0x0699,  0x00D9,  0x02D9,  0x04D9,  0x06D9,
 0x0021,  0x0221,  0x0421,  0x0621,  0x0061,  0x0261,  0x0461,  0x0661,
 0x00A1,  0x02A1,  0x04A1,  0x06A1,  0x00E1,  0x02E1,  0x04E1,  0x06E1,
 0x0002,  0x0202,  0x0402,  0x0602,  0x0042,  0x0242,  0x0442,  0x0642,
 0x0082,  0x0282,  0x0482,  0x0682,  0x00C2,  0x02C2,  0x04C2,  0x06C2,
 0x000A,  0x020A,  0x040A,  0x060A,  0x004A,  0x024A,  0x044A,  0x064A,
 0x008A,  0x028A,  0x048A,  0x068A,  0x00CA,  0x02CA,  0x04CA,  0x06CA,
 0x0012,  0x0212,  0x0412,  0x0612,  0x0052,  0x0252,  0x0452,  0x0652,
 0x0092,  0x0292,  0x0492,  0x0692,  0x00D2,  0x02D2,  0x04D2,  0x06D2,
 0x001A,  0x021A,  0x041A,  0x061A,  0x005A,  0x025A,  0x045A,  0x065A,
 0x009A,  0x029A,  0x049A,  0x069A,  0x00DA,  0x02DA,  0x04DA,  0x06DA,
 0x0022,  0x0222,  0x0422,  0x0622,  0x0062,  0x0262,  0x0462,  0x0662,
 0x00A2,  0x02A2,  0x04A2,  0x06A2,  0x00E2,  0x02E2,  0x04E2,  0x06E2,
 0x0003,  0x0203,  0x0403,  0x0603,  0x0043,  0x0243,  0x0443,  0x0643,
 0x0083,  0x0283,  0x0483,  0x0683,  0x00C3,  0x02C3,  0x04C3,  0x06C3,
 0x000B,  0x020B,  0x040B,  0x060B,  0x004B,  0x024B,  0x044B,  0x064B,
 0x008B,  0x028B,  0x048B,  0x068B,  0x00CB,  0x02CB,  0x04CB,  0x06CB,
 0x0013,  0x0213,  0x0413,  0x0613,  0x0053,  0x0253,  0x0453,  0x0653,
 0x0093,  0x0293,  0x0493,  0x0693,  0x00D3,  0x02D3,  0x04D3,  0x06D3,
 0x001B,  0x021B,  0x041B,  0x061B,  0x005B,  0x025B,  0x045B,  0x065B,
 0x009B,  0x029B,  0x049B,  0x069B,  0x00DB,  0x02DB,  0x04DB,  0x06DB,
 0x0023,  0x0223,  0x0423,  0x0623,  0x0063,  0x0263,  0x0463,  0x0663,
 0x00A3,  0x02A3,  0x04A3,  0x06A3,  0x00E3,  0x02E3,  0x04E3,  0x06E3,
 0x0004,  0x0204,  0x0404,  0x0604,  0x0044,  0x0244,  0x0444,  0x0644,
 0x0084,  0x0284,  0x0484,  0x0684,  0x00C4,  0x02C4,  0x04C4,  0x06C4,
 0x000C,  0x020C,  0x040C,  0x060C,  0x004C,  0x024C,  0x044C,  0x064C,
 0x008C,  0x028C,  0x048C,  0x068C,  0x00CC,  0x02CC,  0x04CC,  0x06CC,
 0x0014,  0x0214,  0x0414,  0x0614,  0x0054,  0x0254,  0x0454,  0x0654,
 0x0094,  0x0294,  0x0494,  0x0694,  0x00D4,  0x02D4,  0x04D4,  0x06D4,
 0x001C,  0x021C,  0x041C,  0x061C,  0x005C,  0x025C,  0x045C,  0x065C,
 0x009C,  0x029C,  0x049C,  0x069C,  0x00DC,  0x02DC,  0x04DC,  0x06DC,
 0x0024,  0x0224,  0x0424,  0x0624,  0x0064,  0x0264,  0x0464,  0x0664,
 0x00A4,  0x02A4,  0x04A4,  0x06A4,  0x00E4,  0x02E4,  0x04E4,  0x06E4,
 0x1000,  0x1040,  0x1080,  0x10C0,  0x1008,  0x1048,  0x1088,  0x10C8,
 0x1010,  0x1050,  0x1090,  0x10D0,  0x1018,  0x1058,  0x1098,  0x10D8,
 0x1020,  0x1060,  0x10A0,  0x10E0,  0x1001,  0x1041,  0x1081,  0x10C1,
 0x1009,  0x1049,  0x1089,  0x10C9,  0x1011,  0x1051,  0x1091,  0x10D1,
 0x1019,  0x1059,  0x1099,  0x10D9,  0x1021,  0x1061,  0x10A1,  0x10E1,
 0x1002,  0x1042,  0x1082,  0x10C2,  0x100A,  0x104A,  0x108A,  0x10CA,
 0x1012,  0x1052,  0x1092,  0x10D2,  0x101A,  0x105A,  0x109A,  0x10DA,
 0x1022,  0x1062,  0x10A2,  0x10E2,  0x1003,  0x1043,  0x1083,  0x10C3,
 0x100B,  0x104B,  0x108B,  0x10CB,  0x1013,  0x1053,  0x1093,  0x10D3,
 0x101B,  0x105B,  0x109B,  0x10DB,  0x1023,  0x1063,  0x10A3,  0x10E3,
 0x1004,  0x1044,  0x1084,  0x10C4,  0x100C,  0x104C,  0x108C,  0x10CC,
 0x1014,  0x1054,  0x1094,  0x10D4,  0x101C,  0x105C,  0x109C,  0x10DC,
 0x1024,  0x1064,  0x10A4,  0x10E4,  0xA000,  0xA008,  0xA010,  0xA001,
 0xA009,  0xA011,  0xA002,  0xA00A,  0xA012,  0xA003,  0xA00B,  0xA013
};
static unsigned short s_iSLen2[ 256 ] = {
 0x3000,  0x3040,  0x3080, 0x30C0, 0x3100,  0x3140,  0x3008,  0x3048,
 0x3088,  0x30C8,  0x3108, 0x3148, 0x3010,  0x3050,  0x3090,  0x30D0,
 0x3110,  0x3150,  0x3018, 0x3058, 0x3098,  0x30D8,  0x3118,  0x3158,
 0x3020,  0x3060,  0x30A0, 0x30E0, 0x3120,  0x3160,  0x3028,  0x3068,
 0x30A8,  0x30E8,  0x3128, 0x3168, 0x3001,  0x3041,  0x3081,  0x30C1,
 0x3101,  0x3141,  0x3009, 0x3049, 0x3089,  0x30C9,  0x3109,  0x3149,
 0x3011,  0x3051,  0x3091, 0x30D1, 0x3111,  0x3151,  0x3019,  0x3059,
 0x3099,  0x30D9,  0x3119, 0x3159, 0x3021,  0x3061,  0x30A1,  0x30E1,
 0x3121,  0x3161,  0x3029, 0x3069, 0x30A9,  0x30E9,  0x3129,  0x3169,
 0x3002,  0x3042,  0x3082, 0x30C2, 0x3102,  0x3142,  0x300A,  0x304A,
 0x308A,  0x30CA,  0x310A, 0x314A, 0x3012,  0x3052,  0x3092,  0x30D2,
 0x3112,  0x3152,  0x301A, 0x305A, 0x309A,  0x30DA,  0x311A,  0x315A,
 0x3022,  0x3062,  0x30A2, 0x30E2, 0x3122,  0x3162,  0x302A,  0x306A,
 0x30AA,  0x30EA,  0x312A, 0x316A, 0x3003,  0x3043,  0x3083,  0x30C3,
 0x3103,  0x3143,  0x300B, 0x304B, 0x308B,  0x30CB,  0x310B,  0x314B,
 0x3013,  0x3053,  0x3093, 0x30D3, 0x3113,  0x3153,  0x301B,  0x305B,
 0x309B,  0x30DB,  0x311B, 0x315B, 0x3023,  0x3063,  0x30A3,  0x30E3,
 0x3123,  0x3163,  0x302B, 0x306B, 0x30AB,  0x30EB,  0x312B,  0x316B,
 0x3004,  0x3044,  0x3084, 0x30C4, 0x3104,  0x3144,  0x300C,  0x304C,
 0x308C,  0x30CC,  0x310C, 0x314C, 0x3014,  0x3054,  0x3094,  0x30D4,
 0x3114,  0x3154,  0x301C, 0x305C, 0x309C,  0x30DC,  0x311C,  0x315C,
 0x3024,  0x3064,  0x30A4, 0x30E4, 0x3124,  0x3164,  0x302C,  0x306C,
 0x30AC,  0x30EC,  0x312C, 0x316C, 0x4000,  0x4040,  0x4080,  0x40C0,
 0x4008,  0x4048,  0x4088, 0x40C8, 0x4010,  0x4050,  0x4090,  0x40D0,
 0x4018,  0x4058,  0x4098, 0x40D8, 0x4001,  0x4041,  0x4081,  0x40C1,
 0x4009,  0x4049,  0x4089, 0x40C9, 0x4011,  0x4051,  0x4091,  0x40D1,
 0x4019,  0x4059,  0x4099, 0x40D9, 0x4002,  0x4042,  0x4082,  0x40C2,
 0x400A,  0x404A,  0x408A, 0x40CA, 0x4012,  0x4052,  0x4092,  0x40D2,
 0x401A,  0x405A,  0x409A, 0x40DA, 0x4003,  0x4043,  0x4083,  0x40C3,
 0x400B,  0x404B,  0x408B, 0x40CB, 0x4013,  0x4053,  0x4093,  0x40D3,
 0x401B,  0x405B,  0x409B, 0x40DB, 0x5000,  0x5008,  0x5010,  0x5001,
 0x5009,  0x5011,  0x5002, 0x500A, 0x5012,  0x5003,  0x500B,  0x5013
};
static short s_MapBuf0[ 9 ][ 152 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x0002, 0x0000, 0x0003, 0x0000, 0x0002, 0x0004, 0x0003, 0x0001,
   0x0002, 0x0008, 0x0003, 0x0002, 0x0002, 0x000C, 0x0003, 0x0003,
   0x0002, 0x0010, 0x0003, 0x0004, 0x0002, 0x0014, 0x0003, 0x0005,
   0x0003, 0x0018, 0x0003, 0x0006, 0x0003, 0x001E, 0x0003, 0x0007,
   0x0002, 0x0024, 0x0000, 0x0003, 0x0002, 0x0025, 0x0001, 0x0003,
   0x0002, 0x0026, 0x0002, 0x0003, 0x0003, 0x0030, 0x0000, 0x0004,
   0x0003, 0x0031, 0x0001, 0x0004, 0x0003, 0x0032, 0x0002, 0x0004,
   0x0004, 0x0042, 0x0000, 0x0005, 0x0004, 0x0043, 0x0001, 0x0005,
   0x0004, 0x0044, 0x0002, 0x0005, 0x0005, 0x005A, 0x0000, 0x0006,
   0x0005, 0x005B, 0x0001, 0x0006, 0x0005, 0x005C, 0x0002, 0x0006,
   0x0006, 0x0078, 0x0000, 0x0007, 0x0006, 0x0079, 0x0001, 0x0007,
   0x0006, 0x007A, 0x0002, 0x0007, 0x0007, 0x009C, 0x0000, 0x0008,
   0x0007, 0x009D, 0x0001, 0x0008, 0x0007, 0x009E, 0x0002, 0x0008,
   0x0009, 0x00C6, 0x0000, 0x0009, 0x0009, 0x00C7, 0x0001, 0x0009,
   0x0009, 0x00C8, 0x0002, 0x0009, 0x000B, 0x00FC, 0x0000, 0x000A,
   0x000B, 0x00FD, 0x0001, 0x000A, 0x000B, 0x00FE, 0x0002, 0x000A,
   0x000F, 0x013E, 0x0000, 0x000B, 0x000F, 0x013F, 0x0001, 0x000B,
   0x000F, 0x0140, 0x0002, 0x000B, 0x001C, 0x0198, 0x0000, 0x000C,
   0x001C, 0x0199, 0x0001, 0x000C, 0x001C, 0x019A, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0003, 0x0000, 0x0002, 0x0004, 0x0003, 0x0001,
   0x0002, 0x0008, 0x0003, 0x0002, 0x0002, 0x000C, 0x0003, 0x0003,
   0x0002, 0x0010, 0x0003, 0x0004, 0x0002, 0x0014, 0x0003, 0x0005,
   0x0003, 0x0018, 0x0003, 0x0006, 0x0003, 0x001E, 0x0003, 0x0007,
   0x0002, 0x0024, 0x0000, 0x0003, 0x0002, 0x0025, 0x0001, 0x0003,
   0x0002, 0x0026, 0x0002, 0x0003, 0x0003, 0x0030, 0x0000, 0x0004,
   0x0003, 0x0031, 0x0001, 0x0004, 0x0003, 0x0032, 0x0002, 0x0004,
   0x0003, 0x0042, 0x0000, 0x0005, 0x0003, 0x0043, 0x0001, 0x0005,
   0x0003, 0x0044, 0x0002, 0x0005, 0x0005, 0x0054, 0x0000, 0x0006,
   0x0005, 0x0055, 0x0001, 0x0006, 0x0005, 0x0056, 0x0002, 0x0006,
   0x0006, 0x0072, 0x0000, 0x0007, 0x0006, 0x0073, 0x0001, 0x0007,
   0x0006, 0x0074, 0x0002, 0x0007, 0x0007, 0x0096, 0x0000, 0x0008,
   0x0007, 0x0097, 0x0001, 0x0008, 0x0007, 0x0098, 0x0002, 0x0008,
   0x0008, 0x00C0, 0x0000, 0x0009, 0x0008, 0x00C1, 0x0001, 0x0009,
   0x0008, 0x00C2, 0x0002, 0x0009, 0x000A, 0x00F0, 0x0000, 0x000A,
   0x000A, 0x00F1, 0x0001, 0x000A, 0x000A, 0x00F2, 0x0002, 0x000A,
   0x000D, 0x012C, 0x0000, 0x000B, 0x000D, 0x012D, 0x0001, 0x000B,
   0x000D, 0x012E, 0x0002, 0x000B, 0x0021, 0x017A, 0x0000, 0x000C,
   0x0021, 0x017B, 0x0001, 0x000C, 0x0021, 0x017C, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0003, 0x0000, 0x0002, 0x0004, 0x0003, 0x0001,
   0x0002, 0x0008, 0x0003, 0x0002, 0x0002, 0x000C, 0x0003, 0x0003,
   0x0002, 0x0010, 0x0003, 0x0004, 0x0002, 0x0014, 0x0003, 0x0005,
   0x0003, 0x0018, 0x0003, 0x0006, 0x0003, 0x001E, 0x0003, 0x0007,
   0x0002, 0x0024, 0x0000, 0x0003, 0x0002, 0x0025, 0x0001, 0x0003,
   0x0002, 0x0026, 0x0002, 0x0003, 0x0003, 0x0030, 0x0000, 0x0004,
   0x0003, 0x0031, 0x0001, 0x0004, 0x0003, 0x0032, 0x0002, 0x0004,
   0x0004, 0x0042, 0x0000, 0x0005, 0x0004, 0x0043, 0x0001, 0x0005,
   0x0004, 0x0044, 0x0002, 0x0005, 0x0006, 0x005A, 0x0000, 0x0006,
   0x0006, 0x005B, 0x0001, 0x0006, 0x0006, 0x005C, 0x0002, 0x0006,
   0x0008, 0x007E, 0x0000, 0x0007, 0x0008, 0x007F, 0x0001, 0x0007,
   0x0008, 0x0080, 0x0002, 0x0007, 0x000A, 0x00AE, 0x0000, 0x0008,
   0x000A, 0x00AF, 0x0001, 0x0008, 0x000A, 0x00B0, 0x0002, 0x0008,
   0x000D, 0x00EA, 0x0000, 0x0009, 0x000D, 0x00EB, 0x0001, 0x0009,
   0x000D, 0x00EC, 0x0002, 0x0009, 0x0011, 0x0138, 0x0000, 0x000A,
   0x0011, 0x0139, 0x0001, 0x000A, 0x0011, 0x013A, 0x0002, 0x000A,
   0x0015, 0x019E, 0x0000, 0x000B, 0x0015, 0x019F, 0x0001, 0x000B,
   0x0015, 0x01A0, 0x0002, 0x000B, 0x0006, 0x021C, 0x0000, 0x000C,
   0x0006, 0x021D, 0x0001, 0x000C, 0x0006, 0x021E, 0x0002, 0x000C
 },
 { 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0006, 0x0003, 0x0001,
   0x0003, 0x000C, 0x0003, 0x0002, 0x0003, 0x0012, 0x0003, 0x0003,
   0x0003, 0x0018, 0x0003, 0x0004, 0x0003, 0x001E, 0x0003, 0x0005,
   0x0004, 0x0024, 0x0003, 0x0006, 0x0005, 0x002C, 0x0003, 0x0007,
   0x0003, 0x0036, 0x0000, 0x0003, 0x0003, 0x0037, 0x0001, 0x0003,
   0x0003, 0x0038, 0x0002, 0x0003, 0x0003, 0x0048, 0x0000, 0x0004,
   0x0003, 0x0049, 0x0001, 0x0004, 0x0003, 0x004A, 0x0002, 0x0004,
   0x0004, 0x005A, 0x0000, 0x0005, 0x0004, 0x005B, 0x0001, 0x0005,
   0x0004, 0x005C, 0x0002, 0x0005, 0x0005, 0x0072, 0x0000, 0x0006,
   0x0005, 0x0073, 0x0001, 0x0006, 0x0005, 0x0074, 0x0002, 0x0006,
   0x0007, 0x0090, 0x0000, 0x0007, 0x0007, 0x0091, 0x0001, 0x0007,
   0x0007, 0x0092, 0x0002, 0x0007, 0x0009, 0x00BA, 0x0000, 0x0008,
   0x0009, 0x00BB, 0x0001, 0x0008, 0x0009, 0x00BC, 0x0002, 0x0008,
   0x000D, 0x00F0, 0x0000, 0x0009, 0x000D, 0x00F1, 0x0001, 0x0009,
   0x000D, 0x00F2, 0x0002, 0x0009, 0x0010, 0x013E, 0x0000, 0x000A,
   0x0010, 0x013F, 0x0001, 0x000A, 0x0010, 0x0140, 0x0002, 0x000A,
   0x0015, 0x019E, 0x0000, 0x000B, 0x0015, 0x019F, 0x0001, 0x000B,
   0x0015, 0x01A0, 0x0002, 0x000B, 0x0009, 0x021C, 0x0000, 0x000C,
   0x0009, 0x021D, 0x0001, 0x000C, 0x0009, 0x021E, 0x0002, 0x000C
 },
 { 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0006, 0x0003, 0x0001,
   0x0003, 0x000C, 0x0003, 0x0002, 0x0003, 0x0012, 0x0003, 0x0003,
   0x0003, 0x0018, 0x0003, 0x0004, 0x0003, 0x001E, 0x0003, 0x0005,
   0x0004, 0x0024, 0x0003, 0x0006, 0x0005, 0x002C, 0x0003, 0x0007,
   0x0003, 0x0036, 0x0000, 0x0003, 0x0003, 0x0037, 0x0001, 0x0003,
   0x0003, 0x0038, 0x0002, 0x0003, 0x0004, 0x0048, 0x0000, 0x0004,
   0x0004, 0x0049, 0x0001, 0x0004, 0x0004, 0x004A, 0x0002, 0x0004,
   0x0005, 0x0060, 0x0000, 0x0005, 0x0005, 0x0061, 0x0001, 0x0005,
   0x0005, 0x0062, 0x0002, 0x0005, 0x0006, 0x007E, 0x0000, 0x0006,
   0x0006, 0x007F, 0x0001, 0x0006, 0x0006, 0x0080, 0x0002, 0x0006,
   0x0007, 0x00A2, 0x0000, 0x0007, 0x0007, 0x00A3, 0x0001, 0x0007,
   0x0007, 0x00A4, 0x0002, 0x0007, 0x0009, 0x00CC, 0x0000, 0x0008,
   0x0009, 0x00CD, 0x0001, 0x0008, 0x0009, 0x00CE, 0x0002, 0x0008,
   0x000C, 0x0102, 0x0000, 0x0009, 0x000C, 0x0103, 0x0001, 0x0009,
   0x000C, 0x0104, 0x0002, 0x0009, 0x0010, 0x014A, 0x0000, 0x000A,
   0x0010, 0x014B, 0x0001, 0x000A, 0x0010, 0x014C, 0x0002, 0x000A,
   0x0016, 0x01AA, 0x0000, 0x000B, 0x0016, 0x01AB, 0x0001, 0x000B,
   0x0016, 0x01AC, 0x0002, 0x000B, 0x0006, 0x022E, 0x0000, 0x000C,
   0x0006, 0x022F, 0x0001, 0x000C, 0x0006, 0x0230, 0x0002, 0x000C
 },
 { 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0006, 0x0003, 0x0001,
   0x0003, 0x000C, 0x0003, 0x0002, 0x0003, 0x0012, 0x0003, 0x0003,
   0x0003, 0x0018, 0x0003, 0x0004, 0x0003, 0x001E, 0x0003, 0x0005,
   0x0004, 0x0024, 0x0003, 0x0006, 0x0005, 0x002C, 0x0003, 0x0007,
   0x0003, 0x0036, 0x0000, 0x0003, 0x0003, 0x0037, 0x0001, 0x0003,
   0x0003, 0x0038, 0x0002, 0x0003, 0x0004, 0x0048, 0x0000, 0x0004,
   0x0004, 0x0049, 0x0001, 0x0004, 0x0004, 0x004A, 0x0002, 0x0004,
   0x0005, 0x0060, 0x0000, 0x0005, 0x0005, 0x0061, 0x0001, 0x0005,
   0x0005, 0x0062, 0x0002, 0x0005, 0x0006, 0x007E, 0x0000, 0x0006,
   0x0006, 0x007F, 0x0001, 0x0006, 0x0006, 0x0080, 0x0002, 0x0006,
   0x0007, 0x00A2, 0x0000, 0x0007, 0x0007, 0x00A3, 0x0001, 0x0007,
   0x0007, 0x00A4, 0x0002, 0x0007, 0x0009, 0x00CC, 0x0000, 0x0008,
   0x0009, 0x00CD, 0x0001, 0x0008, 0x0009, 0x00CE, 0x0002, 0x0008,
   0x000C, 0x0102, 0x0000, 0x0009, 0x000C, 0x0103, 0x0001, 0x0009,
   0x000C, 0x0104, 0x0002, 0x0009, 0x000F, 0x014A, 0x0000, 0x000A,
   0x000F, 0x014B, 0x0001, 0x000A, 0x000F, 0x014C, 0x0002, 0x000A,
   0x0014, 0x01A4, 0x0000, 0x000B, 0x0014, 0x01A5, 0x0001, 0x000B,
   0x0014, 0x01A6, 0x0002, 0x000B, 0x0009, 0x021C, 0x0000, 0x000C,
   0x0009, 0x021D, 0x0001, 0x000C, 0x0009, 0x021E, 0x0002, 0x000C
 },
 { 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0006, 0x0003, 0x0001,
   0x0003, 0x000C, 0x0003, 0x0002, 0x0003, 0x0012, 0x0003, 0x0003,
   0x0003, 0x0018, 0x0003, 0x0004, 0x0003, 0x001E, 0x0003, 0x0005,
   0x0004, 0x0024, 0x0003, 0x0006, 0x0005, 0x002C, 0x0003, 0x0007,
   0x0003, 0x0036, 0x0000, 0x0003, 0x0003, 0x0037, 0x0001, 0x0003,
   0x0003, 0x0038, 0x0002, 0x0003, 0x0004, 0x0048, 0x0000, 0x0004,
   0x0004, 0x0049, 0x0001, 0x0004, 0x0004, 0x004A, 0x0002, 0x0004,
   0x0005, 0x0060, 0x0000, 0x0005, 0x0005, 0x0061, 0x0001, 0x0005,
   0x0005, 0x0062, 0x0002, 0x0005, 0x0006, 0x007E, 0x0000, 0x0006,
   0x0006, 0x007F, 0x0001, 0x0006, 0x0006, 0x0080, 0x0002, 0x0006,
   0x0007, 0x00A2, 0x0000, 0x0007, 0x0007, 0x00A3, 0x0001, 0x0007,
   0x0007, 0x00A4, 0x0002, 0x0007, 0x0009, 0x00CC, 0x0000, 0x0008,
   0x0009, 0x00CD, 0x0001, 0x0008, 0x0009, 0x00CE, 0x0002, 0x0008,
   0x000C, 0x0102, 0x0000, 0x0009, 0x000C, 0x0103, 0x0001, 0x0009,
   0x000C, 0x0104, 0x0002, 0x0009, 0x000F, 0x014A, 0x0000, 0x000A,
   0x000F, 0x014B, 0x0001, 0x000A, 0x000F, 0x014C, 0x0002, 0x000A,
   0x0014, 0x01A4, 0x0000, 0x000B, 0x0014, 0x01A5, 0x0001, 0x000B,
   0x0014, 0x01A6, 0x0002, 0x000B, 0x0009, 0x021C, 0x0000, 0x000C,
   0x0009, 0x021D, 0x0001, 0x000C, 0x0009, 0x021E, 0x0002, 0x000C
 },
 { 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0006, 0x0003, 0x0001,
   0x0003, 0x000C, 0x0003, 0x0002, 0x0003, 0x0012, 0x0003, 0x0003,
   0x0003, 0x0018, 0x0003, 0x0004, 0x0003, 0x001E, 0x0003, 0x0005,
   0x0004, 0x0024, 0x0003, 0x0006, 0x0005, 0x002C, 0x0003, 0x0007,
   0x0003, 0x0036, 0x0000, 0x0003, 0x0003, 0x0037, 0x0001, 0x0003,
   0x0003, 0x0038, 0x0002, 0x0003, 0x0004, 0x0048, 0x0000, 0x0004,
   0x0004, 0x0049, 0x0001, 0x0004, 0x0004, 0x004A, 0x0002, 0x0004,
   0x0005, 0x0060, 0x0000, 0x0005, 0x0005, 0x0061, 0x0001, 0x0005,
   0x0005, 0x0062, 0x0002, 0x0005, 0x0006, 0x007E, 0x0000, 0x0006,
   0x0006, 0x007F, 0x0001, 0x0006, 0x0006, 0x0080, 0x0002, 0x0006,
   0x0007, 0x00A2, 0x0000, 0x0007, 0x0007, 0x00A3, 0x0001, 0x0007,
   0x0007, 0x00A4, 0x0002, 0x0007, 0x0009, 0x00CC, 0x0000, 0x0008,
   0x0009, 0x00CD, 0x0001, 0x0008, 0x0009, 0x00CE, 0x0002, 0x0008,
   0x000C, 0x0102, 0x0000, 0x0009, 0x000C, 0x0103, 0x0001, 0x0009,
   0x000C, 0x0104, 0x0002, 0x0009, 0x000F, 0x014A, 0x0000, 0x000A,
   0x000F, 0x014B, 0x0001, 0x000A, 0x000F, 0x014C, 0x0002, 0x000A,
   0x0014, 0x01A4, 0x0000, 0x000B, 0x0014, 0x01A5, 0x0001, 0x000B,
   0x0014, 0x01A6, 0x0002, 0x000B, 0x0009, 0x021C, 0x0000, 0x000C,
   0x0009, 0x021D, 0x0001, 0x000C, 0x0009, 0x021E, 0x0002, 0x000C
 },
 { 0x0006, 0x0000, 0x0003, 0x0000, 0x0006, 0x000C, 0x0003, 0x0001,
   0x0006, 0x0018, 0x0003, 0x0002, 0x0006, 0x0024, 0x0003, 0x0003,
   0x0006, 0x0030, 0x0003, 0x0004, 0x0006, 0x003C, 0x0003, 0x0005,
   0x0008, 0x0048, 0x0003, 0x0006, 0x000A, 0x0058, 0x0003, 0x0007,
   0x0006, 0x006C, 0x0000, 0x0003, 0x0006, 0x006D, 0x0001, 0x0003,
   0x0006, 0x006E, 0x0002, 0x0003, 0x0008, 0x0090, 0x0000, 0x0004,
   0x0008, 0x0091, 0x0001, 0x0004, 0x0008, 0x0092, 0x0002, 0x0004,
   0x000A, 0x00C0, 0x0000, 0x0005, 0x000A, 0x00C1, 0x0001, 0x0005,
   0x000A, 0x00C2, 0x0002, 0x0005, 0x000C, 0x00FC, 0x0000, 0x0006,
   0x000C, 0x00FD, 0x0001, 0x0006, 0x000C, 0x00FE, 0x0002, 0x0006,
   0x000E, 0x0144, 0x0000, 0x0007, 0x000E, 0x0145, 0x0001, 0x0007,
   0x000E, 0x0146, 0x0002, 0x0007, 0x0012, 0x0198, 0x0000, 0x0008,
   0x0012, 0x0199, 0x0001, 0x0008, 0x0012, 0x019A, 0x0002, 0x0008,
   0x0001, 0x0204, 0x0000, 0x0009, 0x0001, 0x0205, 0x0001, 0x0009,
   0x0001, 0x0206, 0x0002, 0x0009, 0x0001, 0x020A, 0x0000, 0x000A,
   0x0001, 0x020B, 0x0001, 0x000A, 0x0001, 0x020C, 0x0002, 0x000A,
   0x0001, 0x0210, 0x0000, 0x000B, 0x0001, 0x0211, 0x0001, 0x000B,
   0x0001, 0x0212, 0x0002, 0x000B, 0x000D, 0x0216, 0x0000, 0x000C,
   0x000D, 0x0217, 0x0001, 0x000C, 0x000D, 0x0218, 0x0002, 0x000C
 }
};
static short s_MapBuf1[ 9 ][ 156 ] = {
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0002, 0x0024, 0x0000, 0x0003,
   0x0002, 0x0025, 0x0001, 0x0003, 0x0002, 0x0026, 0x0002, 0x0003,
   0x0003, 0x0030, 0x0000, 0x0004, 0x0003, 0x0031, 0x0001, 0x0004,
   0x0003, 0x0032, 0x0002, 0x0004, 0x0004, 0x0042, 0x0000, 0x0005,
   0x0004, 0x0043, 0x0001, 0x0005, 0x0004, 0x0044, 0x0002, 0x0005,
   0x0005, 0x005A, 0x0000, 0x0006, 0x0005, 0x005B, 0x0001, 0x0006,
   0x0005, 0x005C, 0x0002, 0x0006, 0x0006, 0x0078, 0x0000, 0x0007,
   0x0006, 0x0079, 0x0001, 0x0007, 0x0006, 0x007A, 0x0002, 0x0007,
   0x0007, 0x009C, 0x0000, 0x0008, 0x0007, 0x009D, 0x0001, 0x0008,
   0x0007, 0x009E, 0x0002, 0x0008, 0x0009, 0x00C6, 0x0000, 0x0009,
   0x0009, 0x00C7, 0x0001, 0x0009, 0x0009, 0x00C8, 0x0002, 0x0009,
   0x000B, 0x00FC, 0x0000, 0x000A, 0x000B, 0x00FD, 0x0001, 0x000A,
   0x000B, 0x00FE, 0x0002, 0x000A, 0x000F, 0x013E, 0x0000, 0x000B,
   0x000F, 0x013F, 0x0001, 0x000B, 0x000F, 0x0140, 0x0002, 0x000B,
   0x001C, 0x0198, 0x0000, 0x000C, 0x001C, 0x0199, 0x0001, 0x000C,
   0x001C, 0x019A, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0002, 0x0024, 0x0000, 0x0003,
   0x0002, 0x0025, 0x0001, 0x0003, 0x0002, 0x0026, 0x0002, 0x0003,
   0x0003, 0x0030, 0x0000, 0x0004, 0x0003, 0x0031, 0x0001, 0x0004,
   0x0003, 0x0032, 0x0002, 0x0004, 0x0003, 0x0042, 0x0000, 0x0005,
   0x0003, 0x0043, 0x0001, 0x0005, 0x0003, 0x0044, 0x0002, 0x0005,
   0x0005, 0x0054, 0x0000, 0x0006, 0x0005, 0x0055, 0x0001, 0x0006,
   0x0005, 0x0056, 0x0002, 0x0006, 0x0006, 0x0072, 0x0000, 0x0007,
   0x0006, 0x0073, 0x0001, 0x0007, 0x0006, 0x0074, 0x0002, 0x0007,
   0x0007, 0x0096, 0x0000, 0x0008, 0x0007, 0x0097, 0x0001, 0x0008,
   0x0007, 0x0098, 0x0002, 0x0008, 0x0008, 0x00C0, 0x0000, 0x0009,
   0x0008, 0x00C1, 0x0001, 0x0009, 0x0008, 0x00C2, 0x0002, 0x0009,
   0x000A, 0x00F0, 0x0000, 0x000A, 0x000A, 0x00F1, 0x0001, 0x000A,
   0x000A, 0x00F2, 0x0002, 0x000A, 0x000D, 0x012C, 0x0000, 0x000B,
   0x000D, 0x012D, 0x0001, 0x000B, 0x000D, 0x012E, 0x0002, 0x000B,
   0x0021, 0x017A, 0x0000, 0x000C, 0x0021, 0x017B, 0x0001, 0x000C,
   0x0021, 0x017C, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0002, 0x0024, 0x0000, 0x0003,
   0x0002, 0x0025, 0x0001, 0x0003, 0x0002, 0x0026, 0x0002, 0x0003,
   0x0003, 0x0030, 0x0000, 0x0004, 0x0003, 0x0031, 0x0001, 0x0004,
   0x0003, 0x0032, 0x0002, 0x0004, 0x0004, 0x0042, 0x0000, 0x0005,
   0x0004, 0x0043, 0x0001, 0x0005, 0x0004, 0x0044, 0x0002, 0x0005,
   0x0006, 0x005A, 0x0000, 0x0006, 0x0006, 0x005B, 0x0001, 0x0006,
   0x0006, 0x005C, 0x0002, 0x0006, 0x0008, 0x007E, 0x0000, 0x0007,
   0x0008, 0x007F, 0x0001, 0x0007, 0x0008, 0x0080, 0x0002, 0x0007,
   0x000A, 0x00AE, 0x0000, 0x0008, 0x000A, 0x00AF, 0x0001, 0x0008,
   0x000A, 0x00B0, 0x0002, 0x0008, 0x000D, 0x00EA, 0x0000, 0x0009,
   0x000D, 0x00EB, 0x0001, 0x0009, 0x000D, 0x00EC, 0x0002, 0x0009,
   0x0011, 0x0138, 0x0000, 0x000A, 0x0011, 0x0139, 0x0001, 0x000A,
   0x0011, 0x013A, 0x0002, 0x000A, 0x0015, 0x019E, 0x0000, 0x000B,
   0x0015, 0x019F, 0x0001, 0x000B, 0x0015, 0x01A0, 0x0002, 0x000B,
   0x0006, 0x021C, 0x0000, 0x000C, 0x0006, 0x021D, 0x0001, 0x000C,
   0x0006, 0x021E, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0003, 0x0024, 0x0000, 0x0003,
   0x0003, 0x0025, 0x0001, 0x0003, 0x0003, 0x0026, 0x0002, 0x0003,
   0x0003, 0x0036, 0x0000, 0x0004, 0x0003, 0x0037, 0x0001, 0x0004,
   0x0003, 0x0038, 0x0002, 0x0004, 0x0004, 0x0048, 0x0000, 0x0005,
   0x0004, 0x0049, 0x0001, 0x0005, 0x0004, 0x004A, 0x0002, 0x0005,
   0x0005, 0x0060, 0x0000, 0x0006, 0x0005, 0x0061, 0x0001, 0x0006,
   0x0005, 0x0062, 0x0002, 0x0006, 0x0007, 0x007E, 0x0000, 0x0007,
   0x0007, 0x007F, 0x0001, 0x0007, 0x0007, 0x0080, 0x0002, 0x0007,
   0x0009, 0x00A8, 0x0000, 0x0008, 0x0009, 0x00A9, 0x0001, 0x0008,
   0x0009, 0x00AA, 0x0002, 0x0008, 0x000D, 0x00DE, 0x0000, 0x0009,
   0x000D, 0x00DF, 0x0001, 0x0009, 0x000D, 0x00E0, 0x0002, 0x0009,
   0x0010, 0x012C, 0x0000, 0x000A, 0x0010, 0x012D, 0x0001, 0x000A,
   0x0010, 0x012E, 0x0002, 0x000A, 0x0015, 0x018C, 0x0000, 0x000B,
   0x0015, 0x018D, 0x0001, 0x000B, 0x0015, 0x018E, 0x0002, 0x000B,
   0x0009, 0x020A, 0x0000, 0x000C, 0x0009, 0x020B, 0x0001, 0x000C,
   0x0009, 0x020C, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0003, 0x0024, 0x0000, 0x0003,
   0x0003, 0x0025, 0x0001, 0x0003, 0x0003, 0x0026, 0x0002, 0x0003,
   0x0004, 0x0036, 0x0000, 0x0004, 0x0004, 0x0037, 0x0001, 0x0004,
   0x0004, 0x0038, 0x0002, 0x0004, 0x0005, 0x004E, 0x0000, 0x0005,
   0x0005, 0x004F, 0x0001, 0x0005, 0x0005, 0x0050, 0x0002, 0x0005,
   0x0006, 0x006C, 0x0000, 0x0006, 0x0006, 0x006D, 0x0001, 0x0006,
   0x0006, 0x006E, 0x0002, 0x0006, 0x0007, 0x0090, 0x0000, 0x0007,
   0x0007, 0x0091, 0x0001, 0x0007, 0x0007, 0x0092, 0x0002, 0x0007,
   0x0009, 0x00BA, 0x0000, 0x0008, 0x0009, 0x00BB, 0x0001, 0x0008,
   0x0009, 0x00BC, 0x0002, 0x0008, 0x000C, 0x00F0, 0x0000, 0x0009,
   0x000C, 0x00F1, 0x0001, 0x0009, 0x000C, 0x00F2, 0x0002, 0x0009,
   0x0010, 0x0138, 0x0000, 0x000A, 0x0010, 0x0139, 0x0001, 0x000A,
   0x0010, 0x013A, 0x0002, 0x000A, 0x0016, 0x0198, 0x0000, 0x000B,
   0x0016, 0x0199, 0x0001, 0x000B, 0x0016, 0x019A, 0x0002, 0x000B,
   0x0006, 0x021C, 0x0000, 0x000C, 0x0006, 0x021D, 0x0001, 0x000C,
   0x0006, 0x021E, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0003, 0x0024, 0x0000, 0x0003,
   0x0003, 0x0025, 0x0001, 0x0003, 0x0003, 0x0026, 0x0002, 0x0003,
   0x0004, 0x0036, 0x0000, 0x0004, 0x0004, 0x0037, 0x0001, 0x0004,
   0x0004, 0x0038, 0x0002, 0x0004, 0x0005, 0x004E, 0x0000, 0x0005,
   0x0005, 0x004F, 0x0001, 0x0005, 0x0005, 0x0050, 0x0002, 0x0005,
   0x0006, 0x006C, 0x0000, 0x0006, 0x0006, 0x006D, 0x0001, 0x0006,
   0x0006, 0x006E, 0x0002, 0x0006, 0x0007, 0x0090, 0x0000, 0x0007,
   0x0007, 0x0091, 0x0001, 0x0007, 0x0007, 0x0092, 0x0002, 0x0007,
   0x0009, 0x00BA, 0x0000, 0x0008, 0x0009, 0x00BB, 0x0001, 0x0008,
   0x0009, 0x00BC, 0x0002, 0x0008, 0x000C, 0x00F0, 0x0000, 0x0009,
   0x000C, 0x00F1, 0x0001, 0x0009, 0x000C, 0x00F2, 0x0002, 0x0009,
   0x000F, 0x0138, 0x0000, 0x000A, 0x000F, 0x0139, 0x0001, 0x000A,
   0x000F, 0x013A, 0x0002, 0x000A, 0x0014, 0x0192, 0x0000, 0x000B,
   0x0014, 0x0193, 0x0001, 0x000B, 0x0014, 0x0194, 0x0002, 0x000B,
   0x0009, 0x020A, 0x0000, 0x000C, 0x0009, 0x020B, 0x0001, 0x000C,
   0x0009, 0x020C, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0003, 0x0024, 0x0000, 0x0003,
   0x0003, 0x0025, 0x0001, 0x0003, 0x0003, 0x0026, 0x0002, 0x0003,
   0x0004, 0x0036, 0x0000, 0x0004, 0x0004, 0x0037, 0x0001, 0x0004,
   0x0004, 0x0038, 0x0002, 0x0004, 0x0005, 0x004E, 0x0000, 0x0005,
   0x0005, 0x004F, 0x0001, 0x0005, 0x0005, 0x0050, 0x0002, 0x0005,
   0x0006, 0x006C, 0x0000, 0x0006, 0x0006, 0x006D, 0x0001, 0x0006,
   0x0006, 0x006E, 0x0002, 0x0006, 0x0007, 0x0090, 0x0000, 0x0007,
   0x0007, 0x0091, 0x0001, 0x0007, 0x0007, 0x0092, 0x0002, 0x0007,
   0x0009, 0x00BA, 0x0000, 0x0008, 0x0009, 0x00BB, 0x0001, 0x0008,
   0x0009, 0x00BC, 0x0002, 0x0008, 0x000C, 0x00F0, 0x0000, 0x0009,
   0x000C, 0x00F1, 0x0001, 0x0009, 0x000C, 0x00F2, 0x0002, 0x0009,
   0x000F, 0x0138, 0x0000, 0x000A, 0x000F, 0x0139, 0x0001, 0x000A,
   0x000F, 0x013A, 0x0002, 0x000A, 0x0014, 0x0192, 0x0000, 0x000B,
   0x0014, 0x0193, 0x0001, 0x000B, 0x0014, 0x0194, 0x0002, 0x000B,
   0x0009, 0x020A, 0x0000, 0x000C, 0x0009, 0x020B, 0x0001, 0x000C,
   0x0009, 0x020C, 0x0002, 0x000C
 },
 { 0x0002, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0000,
   0x0002, 0x0002, 0x0002, 0x0000, 0x0002, 0x000C, 0x0000, 0x0001,
   0x0002, 0x000D, 0x0001, 0x0001, 0x0002, 0x000E, 0x0002, 0x0001,
   0x0002, 0x0018, 0x0000, 0x0002, 0x0002, 0x0019, 0x0001, 0x0002,
   0x0002, 0x001A, 0x0002, 0x0002, 0x0003, 0x0024, 0x0000, 0x0003,
   0x0003, 0x0025, 0x0001, 0x0003, 0x0003, 0x0026, 0x0002, 0x0003,
   0x0004, 0x0036, 0x0000, 0x0004, 0x0004, 0x0037, 0x0001, 0x0004,
   0x0004, 0x0038, 0x0002, 0x0004, 0x0005, 0x004E, 0x0000, 0x0005,
   0x0005, 0x004F, 0x0001, 0x0005, 0x0005, 0x0050, 0x0002, 0x0005,
   0x0006, 0x006C, 0x0000, 0x0006, 0x0006, 0x006D, 0x0001, 0x0006,
   0x0006, 0x006E, 0x0002, 0x0006, 0x0007, 0x0090, 0x0000, 0x0007,
   0x0007, 0x0091, 0x0001, 0x0007, 0x0007, 0x0092, 0x0002, 0x0007,
   0x0009, 0x00BA, 0x0000, 0x0008, 0x0009, 0x00BB, 0x0001, 0x0008,
   0x0009, 0x00BC, 0x0002, 0x0008, 0x000C, 0x00F0, 0x0000, 0x0009,
   0x000C, 0x00F1, 0x0001, 0x0009, 0x000C, 0x00F2, 0x0002, 0x0009,
   0x000F, 0x0138, 0x0000, 0x000A, 0x000F, 0x0139, 0x0001, 0x000A,
   0x000F, 0x013A, 0x0002, 0x000A, 0x0014, 0x0192, 0x0000, 0x000B,
   0x0014, 0x0193, 0x0001, 0x000B, 0x0014, 0x0194, 0x0002, 0x000B,
   0x0009, 0x020A, 0x0000, 0x000C, 0x0009, 0x020B, 0x0001, 0x000C,
   0x0009, 0x020C, 0x0002, 0x000C
 },
 { 0x0004, 0x0000, 0x0000, 0x0000, 0x0004, 0x0001, 0x0001, 0x0000,
   0x0004, 0x0002, 0x0002, 0x0000, 0x0004, 0x0018, 0x0000, 0x0001,
   0x0004, 0x0019, 0x0001, 0x0001, 0x0004, 0x001A, 0x0002, 0x0001,
   0x0004, 0x0030, 0x0000, 0x0002, 0x0004, 0x0031, 0x0001, 0x0002,
   0x0004, 0x0032, 0x0002, 0x0002, 0x0006, 0x0048, 0x0000, 0x0003,
   0x0006, 0x0049, 0x0001, 0x0003, 0x0006, 0x004A, 0x0002, 0x0003,
   0x0008, 0x006C, 0x0000, 0x0004, 0x0008, 0x006D, 0x0001, 0x0004,
   0x0008, 0x006E, 0x0002, 0x0004, 0x000A, 0x009C, 0x0000, 0x0005,
   0x000A, 0x009D, 0x0001, 0x0005, 0x000A, 0x009E, 0x0002, 0x0005,
   0x000C, 0x00D8, 0x0000, 0x0006, 0x000C, 0x00D9, 0x0001, 0x0006,
   0x000C, 0x00DA, 0x0002, 0x0006, 0x000E, 0x0120, 0x0000, 0x0007,
   0x000E, 0x0121, 0x0001, 0x0007, 0x000E, 0x0122, 0x0002, 0x0007,
   0x0012, 0x0174, 0x0000, 0x0008, 0x0012, 0x0175, 0x0001, 0x0008,
   0x0012, 0x0176, 0x0002, 0x0008, 0x0001, 0x01E0, 0x0000, 0x0009,
   0x0001, 0x01E1, 0x0001, 0x0009, 0x0001, 0x01E2, 0x0002, 0x0009,
   0x0001, 0x01E6, 0x0000, 0x000A, 0x0001, 0x01E7, 0x0001, 0x000A,
   0x0001, 0x01E8, 0x0002, 0x000A, 0x0001, 0x01EC, 0x0000, 0x000B,
   0x0001, 0x01ED, 0x0001, 0x000B, 0x0001, 0x01EE, 0x0002, 0x000B,
   0x000D, 0x01F2, 0x0000, 0x000C, 0x000D, 0x01F3, 0x0001, 0x000C,
   0x000D, 0x01F4, 0x0002, 0x000C
 }
};
static short s_MapBuf2[ 9 ][ 44 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x0002, 0x0000, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003,
   0x0002, 0x0004, 0x0002, 0x0005, 0x0003, 0x0006, 0x0003, 0x0007,
   0x0004, 0x0008, 0x0004, 0x0009, 0x0005, 0x000A, 0x0006, 0x000B,
   0x0008, 0x000C, 0x000A, 0x000D, 0x000C, 0x000E, 0x000E, 0x000F,
   0x0011, 0x0010, 0x0015, 0x0011, 0x0019, 0x0012, 0x001B, 0x0013,
   0x0026, 0x0014, 0x004F, 0x0015
 },
 { 0x0002, 0x0000, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003,
   0x0002, 0x0004, 0x0002, 0x0005, 0x0003, 0x0006, 0x0003, 0x0007,
   0x0003, 0x0008, 0x0004, 0x0009, 0x0005, 0x000A, 0x0006, 0x000B,
   0x0008, 0x000C, 0x0009, 0x000D, 0x000B, 0x000E, 0x000E, 0x000F,
   0x0011, 0x0010, 0x0014, 0x0011, 0x0017, 0x0012, 0x001B, 0x0013,
   0x001B, 0x0014, 0x0060, 0x0015
 },
 { 0x0002, 0x0000, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003,
   0x0002, 0x0004, 0x0002, 0x0005, 0x0003, 0x0006, 0x0003, 0x0007,
   0x0004, 0x0008, 0x0005, 0x0009, 0x0006, 0x000A, 0x0008, 0x000B,
   0x000A, 0x000C, 0x000C, 0x000D, 0x000F, 0x000E, 0x0013, 0x000F,
   0x0017, 0x0010, 0x001C, 0x0011, 0x0022, 0x0012, 0x002A, 0x0013,
   0x0033, 0x0014, 0x000D, 0x0015
 },
 { 0x0003, 0x0000, 0x0003, 0x0001, 0x0003, 0x0002, 0x0003, 0x0003,
   0x0003, 0x0004, 0x0003, 0x0005, 0x0004, 0x0006, 0x0005, 0x0007,
   0x0006, 0x0008, 0x0007, 0x0009, 0x0008, 0x000A, 0x000A, 0x000B,
   0x000C, 0x000C, 0x000E, 0x000D, 0x0010, 0x000E, 0x0013, 0x000F,
   0x0017, 0x0010, 0x001A, 0x0011, 0x001E, 0x0012, 0x0022, 0x0013,
   0x001D, 0x0014, 0x001B, 0x0015
 },
 { 0x0003, 0x0000, 0x0003, 0x0001, 0x0003, 0x0002, 0x0003, 0x0003,
   0x0003, 0x0004, 0x0003, 0x0005, 0x0004, 0x0006, 0x0005, 0x0007,
   0x0006, 0x0008, 0x0007, 0x0009, 0x0008, 0x000A, 0x0009, 0x000B,
   0x000B, 0x000C, 0x000D, 0x000D, 0x0010, 0x000E, 0x0013, 0x000F,
   0x0017, 0x0010, 0x001A, 0x0011, 0x0020, 0x0012, 0x0023, 0x0013,
   0x0026, 0x0014, 0x0012, 0x0015
 },
 { 0x0003, 0x0000, 0x0003, 0x0001, 0x0003, 0x0002, 0x0003, 0x0003,
   0x0003, 0x0004, 0x0003, 0x0005, 0x0004, 0x0006, 0x0005, 0x0007,
   0x0006, 0x0008, 0x0007, 0x0009, 0x0008, 0x000A, 0x000A, 0x000B,
   0x000C, 0x000C, 0x000E, 0x000D, 0x0010, 0x000E, 0x0013, 0x000F,
   0x0017, 0x0010, 0x001A, 0x0011, 0x001E, 0x0012, 0x0022, 0x0013,
   0x001D, 0x0014, 0x001B, 0x0015
 },
 { 0x0003, 0x0000, 0x0003, 0x0001, 0x0003, 0x0002, 0x0003, 0x0003,
   0x0003, 0x0004, 0x0003, 0x0005, 0x0004, 0x0006, 0x0005, 0x0007,
   0x0006, 0x0008, 0x0007, 0x0009, 0x0008, 0x000A, 0x000A, 0x000B,
   0x000C, 0x000C, 0x000E, 0x000D, 0x0010, 0x000E, 0x0013, 0x000F,
   0x0017, 0x0010, 0x001A, 0x0011, 0x001E, 0x0012, 0x0022, 0x0013,
   0x001D, 0x0014, 0x001B, 0x0015
 },
 { 0x0003, 0x0000, 0x0003, 0x0001, 0x0003, 0x0002, 0x0003, 0x0003,
   0x0003, 0x0004, 0x0003, 0x0005, 0x0004, 0x0006, 0x0005, 0x0007,
   0x0006, 0x0008, 0x0007, 0x0009, 0x0008, 0x000A, 0x000A, 0x000B,
   0x000C, 0x000C, 0x000E, 0x000D, 0x0010, 0x000E, 0x0013, 0x000F,
   0x0017, 0x0010, 0x001A, 0x0011, 0x001E, 0x0012, 0x0022, 0x0013,
   0x001D, 0x0014, 0x001B, 0x0015
 },
 { 0x0006, 0x0000, 0x0006, 0x0001, 0x0006, 0x0002, 0x0006, 0x0003,
   0x0006, 0x0004, 0x0006, 0x0005, 0x0008, 0x0006, 0x000A, 0x0007,
   0x000C, 0x0008, 0x000E, 0x0009, 0x0010, 0x000A, 0x0014, 0x000B,
   0x0018, 0x000C, 0x001C, 0x000D, 0x0020, 0x000E, 0x0026, 0x000F,
   0x002D, 0x0010, 0x0001, 0x0011, 0x0001, 0x0012, 0x0001, 0x0013,
   0x0001, 0x0014, 0x0001, 0x0015
 }
};
short* s_pMap[ 9 ][ 3 ] = {
 { &s_MapBuf0[ 0 ][ 0 ], &s_MapBuf1[ 0 ][ 0 ], &s_MapBuf2[ 0 ][ 0 ] },
 { &s_MapBuf0[ 1 ][ 0 ], &s_MapBuf1[ 1 ][ 0 ], &s_MapBuf2[ 1 ][ 0 ] },
 { &s_MapBuf0[ 2 ][ 0 ], &s_MapBuf1[ 2 ][ 0 ], &s_MapBuf2[ 2 ][ 0 ] },
 { &s_MapBuf0[ 3 ][ 0 ], &s_MapBuf1[ 3 ][ 0 ], &s_MapBuf2[ 3 ][ 0 ] },
 { &s_MapBuf0[ 4 ][ 0 ], &s_MapBuf1[ 4 ][ 0 ], &s_MapBuf2[ 4 ][ 0 ] },
 { &s_MapBuf0[ 5 ][ 0 ], &s_MapBuf1[ 5 ][ 0 ], &s_MapBuf2[ 5 ][ 0 ] },
 { &s_MapBuf0[ 6 ][ 0 ], &s_MapBuf1[ 6 ][ 0 ], &s_MapBuf2[ 6 ][ 0 ] },
 { &s_MapBuf0[ 7 ][ 0 ], &s_MapBuf1[ 7 ][ 0 ], &s_MapBuf2[ 7 ][ 0 ] },
 { &s_MapBuf0[ 8 ][ 0 ], &s_MapBuf1[ 8 ][ 0 ], &s_MapBuf2[ 8 ][ 0 ] }
};
short* s_pMapEnd[ 9 ][ 3 ] = {
 { &s_MapBuf0[ 0 ][ 152 ], &s_MapBuf1[ 0 ][ 156 ], &s_MapBuf2[ 0 ][ 44 ] },
 { &s_MapBuf0[ 1 ][ 152 ], &s_MapBuf1[ 1 ][ 156 ], &s_MapBuf2[ 1 ][ 44 ] },
 { &s_MapBuf0[ 2 ][ 152 ], &s_MapBuf1[ 2 ][ 156 ], &s_MapBuf2[ 2 ][ 44 ] },
 { &s_MapBuf0[ 3 ][ 152 ], &s_MapBuf1[ 3 ][ 156 ], &s_MapBuf2[ 3 ][ 44 ] },
 { &s_MapBuf0[ 4 ][ 152 ], &s_MapBuf1[ 4 ][ 156 ], &s_MapBuf2[ 4 ][ 44 ] },
 { &s_MapBuf0[ 5 ][ 152 ], &s_MapBuf1[ 5 ][ 156 ], &s_MapBuf2[ 5 ][ 44 ] },
 { &s_MapBuf0[ 6 ][ 152 ], &s_MapBuf1[ 6 ][ 156 ], &s_MapBuf2[ 6 ][ 44 ] },
 { &s_MapBuf0[ 7 ][ 152 ], &s_MapBuf1[ 7 ][ 156 ], &s_MapBuf2[ 7 ][ 44 ] },
 { &s_MapBuf0[ 8 ][ 152 ], &s_MapBuf1[ 8 ][ 156 ], &s_MapBuf2[ 8 ][ 44 ] }
};
static short s_Tab0[  1 ] __attribute__(   (  section( ".data" )  )   ) = { 0 };
static short s_Tab1[  7 ] __attribute__(   (  section( ".data" )  )   ) = { -5, -3, -1, 17, 1, 16, 0 };
static short s_Tab2[ 17 ] __attribute__(   (  section( ".data" )  )   ) = {
 -15, -11, -9, -5, -3, -1, 34, 2, 18,
  -1,  33, 32, 17, -1,  1, 16, 0
};
static short s_Tab3[ 17 ] __attribute__(   (  section( ".data" )  )   ) = {
 -13, -11, -9, -5, -3, -1, 34, 2, 18,
  -1,  33, 32, 16, 17, -1,  1, 0
};
static short s_Tab5[ 31 ] __attribute__(   (  section( ".data" )  )   ) = {
 -29, -25, -23, -15, -7, -5, -3, -1,
  51,  35,  50,  49, -3, -1, 19,  3,
  -1,  48,  34,  -3, -1, 18, 33, -1,
   2,  32,  17,  -1,  1, 16,  0
};
static short s_Tab6[ 31 ] __attribute__(   (  section( ".data" )  )   )  = {
 -25, -19, -13, -9, -5, -3, -1, 51,
   3,  35,  -1, 50, 48, -1, 19, 49,
  -3,  -1,  34,  2, 18, -3, -1, 33,
  32,   1,  -1, 17, -1, 16,  0
};
static short s_Tab7[ 71 ] __attribute__(   (  section( ".data" )  )   ) = {
 -69, -65, -57, -39, -29, -17, -11,  -7, -3,  -1,  85,  69,
  -1,  84,  83,  -1,  53,  68,  -3,  -1, 37,  82,  21,  -5,
  -1,  81,  -1,   5,  52,  -1,  80,  -1, 67,  51,  -5,  -3,
  -1,  36,  66,  20,  -1,  65,  64, -11, -7,  -3,  -1,   4,
  35,  -1,  50,   3,  -1,  19,  49,  -3, -1,  48,  34,  18,
  -5,  -1,  33,  -1,   2,  32,  17,  -1,  1,  16,   0
};
static short s_Tab8[ 71 ] __attribute__(   (  section( ".data" )  )   ) = {
 -65, -63, -59, -45, -31, -19, -13, -7, -5, -3, -1,  85,
  84,  69,  83,  -3,  -1,  53,  68, 37, -3, -1, 82,   5,
  21,  -5,  -1,  81,  -1,  52,  67, -3, -1, 80, 51,  36,
  -5,  -3,  -1,  66,  20,  65,  -3, -1,  4, 64, -1,  35,
  50,  -9,  -7,  -3,  -1,  19,  49, -1,  3, 48, 34,  -1,
   2,  32,  -1,  18,  33,  17,  -3, -1,  1, 16,  0
};
static short s_Tab9[ 71 ] __attribute__(   (  section( ".data" )  )   ) = {
 -63, -53, -41, -29, -19, -11, -5, -3, -1, 85, 69, 53,
  -1,  83,  -1,  84,   5,  -3, -1, 68, 37, -1, 82, 21,
  -3,  -1,  81,  52,  -1,  67, -1, 80,  4, -7, -3, -1,
  36,  66,  -1,  51,  64,  -1, 20, 65, -5, -3, -1, 35,
  50,  19,  -1,  49,  -1,   3, 48, -5, -3, -1, 34,  2,
  18,  -1,  33,  32,  -3,  -1, 17,  1, -1, 16,  0
};
static short s_Tab10[ 127 ] __attribute__(   (  section( ".data" )  )   ) = {
 -125, -121, -111, -83, -55, -35, -21, -13, -7,  -3, -1, 119,
  103,   -1,  118,  87,  -3,  -1, 117, 102, 71,  -3, -1, 116,
   86,   -1,  101,  55,  -9,  -3,  -1, 115, 70,  -3, -1,  85,
   84,   99,   -1,  39, 114, -11,  -5,  -3, -1, 100,  7, 112,
   -1,   98,   -1,  69,  53,  -5,  -1,   6, -1,  83, 68,  23,
  -17,   -5,   -1, 113,  -1,  54,  38,  -5, -3,  -1, 37,  82,
   21,   -1,   81,  -1,  52,  67,  -3,  -1, 22,  97, -1,  96,
   -1,    5,   80, -19, -11,  -7,  -3,  -1, 36,  66, -1,  51,
    4,   -1,   20,  65,  -3,  -1,  64,  35, -1,  50,  3,  -3,
   -1,   19,   49,  -1,  48,  34,  -7,  -3, -1,  18, 33,  -1,
    2,   32,   17,  -1,   1,  16,   0
};
static short s_Tab11[ 127 ] __attribute__(   (  section( ".data" )  )   ) = {
 -121, -113, -89, -59, -43, -27, -17,  -7,  -3,  -1, 119, 103,
   -1,  118, 117,  -3,  -1, 102,  71,  -1, 116,  -1,  87,  85,
   -5,   -3,  -1,  86, 101,  55,  -1, 115,  70,  -9,  -7,  -3,
   -1,   69,  84,  -1,  53,  83,  39,  -1, 114,  -1, 100,   7,
   -5,   -1, 113,  -1,  23, 112,  -3,  -1,  54,  99,  -1,  96,
   -1,   68,  37, -13,  -7,  -5,  -3,  -1,  82,   5,  21,  98,
   -3,   -1,  38,   6,  22,  -5,  -1,  97,  -1,  81,  52,  -5,
   -1,   80,  -1,  67,  51,  -1,  36,  66, -15, -11,  -7,  -3,
   -1,   20,  65,  -1,   4,  64,  -1,  35,  50,  -1,  19,  49,
   -5,   -3,  -1,   3,  48,  34,  33,  -5,  -1,  18,  -1,   2,
   32,   17,  -3,  -1,   1,  16,   0
};
static short s_Tab12[ 127 ] __attribute__(   (  section( ".data" )  )   ) = {
 -115, -99, -73, -45, -27, -17,  -9,  -5,  -3,  -1, 119, 103,
  118,  -1,  87, 117,  -3,  -1, 102,  71,  -1, 116, 101,  -3,
   -1,  86,  55,  -3,  -1, 115,  85,  39,  -7,  -3,  -1, 114,
   70,  -1, 100,  23,  -5,  -1, 113,  -1,   7, 112,  -1,  54,
   99, -13,  -9,  -3,  -1,  69,  84,  -1,  68,  -1,   6,   5,
   -1,  38,  98,  -5,  -1,  97,  -1,  22,  96,  -3,  -1,  53,
   83,  -1,  37,  82, -17,  -7,  -3,  -1,  21,  81,  -1,  52,
   67,  -5,  -3,  -1,  80,   4,  36,  -1,  66,  20,  -3,  -1,
   51,  65,  -1,  35,  50, -11,  -7,  -5,  -3,  -1,  64,   3,
   48,  19,  -1,  49,  34,  -1,  18,  33,  -7,  -5,  -3,  -1,
    2,  32,   0,  17,  -1,   1,  16
};
static short s_Tab13[ 511 ] __attribute__(   (  section( ".data" )  )   ) = {
 -509, -503, -475, -405, -333, -265, -205, -153, -115, -83, -53, -35, -21, -13,  -9,
   -7,   -5,   -3,   -1,  254,  252,  253,  237,  255,  -1, 239, 223,  -3,  -1, 238,
  207,   -1,  222,  191,   -9,   -3,   -1,  251,  206,  -1, 220,  -1, 175, 233,  -1,
  236,  221,   -9,   -5,   -3,   -1,  250,  205,  190,  -1, 235, 159,  -3,  -1, 249,
  234,   -1,  189,  219,  -17,   -9,   -3,   -1,  143, 248,  -1, 204,  -1, 174, 158,
   -5,   -1,  142,   -1,  127,  126,  247,   -5,   -1, 218,  -1, 173, 188,  -3,  -1,
  203,  246,  111,  -15,   -7,   -3,   -1,  232,   95,  -1, 157, 217,  -3,  -1, 245,
  231,   -1,  172,  187,   -9,   -3,   -1,   79,  244,  -3,  -1, 202, 230, 243,  -1,
   63,   -1,  141,  216,  -21,   -9,   -3,   -1,   47, 242,  -3,  -1, 110, 156,  15,
   -5,   -3,   -1,  201,   94,  171,   -3,   -1,  125, 215,  78, -11,  -5,  -3,  -1,
  200,  214,   62,   -1,  185,   -1,  155,  170,   -1,  31, 241, -23, -13,  -5,  -1,
  240,   -1,  186,  229,   -3,   -1,  228,  140,   -1, 109, 227,  -5,  -1, 226,  -1,
   46,   14,   -1,   30,  225,  -15,   -7,   -3,   -1, 224,  93,  -1, 213, 124,  -3,
   -1,  199,   77,   -1,  139,  184,   -7,   -3,   -1, 212, 154,  -1, 169, 108,  -1,
  198,   61,  -37,  -21,   -9,   -5,   -3,   -1,  211, 123,  45,  -1, 210,  29,  -5,
   -1,  183,   -1,   92,  197,   -3,   -1,  153,  122, 195,  -7,  -5,  -3,  -1, 167,
  151,   75,  209,   -3,   -1,   13,  208,   -1,  138, 168, -11,  -7,  -3,  -1,  76,
  196,   -1,  107,  182,   -1,   60,   44,   -3,   -1, 194,  91,  -3,  -1, 181, 137,
   28,  -43,  -23,  -11,   -5,   -1,  193,   -1,  152,  12,  -1, 192,  -1, 180, 106,
   -5,   -3,   -1,  166,  121,   59,   -1,  179,   -1, 136,  90, -11,  -5,  -1,  43,
   -1,  165,  105,   -1,  164,   -1,  120,  135,   -5,  -1, 148,  -1, 119, 118, 178,
  -11,   -3,   -1,   27,  177,   -3,   -1,   11,  176,  -1, 150,  74,  -7,  -3,  -1,
   58,  163,   -1,   89,  149,   -1,   42,  162,  -47, -23,  -9,  -3,  -1,  26, 161,
   -3,   -1,   10,  104,  160,   -5,   -3,   -1,  134,  73, 147,  -3,  -1,  57,  88,
   -1,  133,  103,   -9,   -3,   -1,   41,  146,   -3,  -1,  87, 117,  56,  -5,  -1,
  131,   -1,  102,   71,   -3,   -1,  116,   86,   -1, 101, 115, -11,  -3,  -1,  25,
  145,   -3,   -1,    9,  144,   -1,   72,  132,   -7,  -5,  -1, 114,  -1,  70, 100,
   40,   -1,  130,   24,  -41,  -27,  -11,   -5,   -3,  -1,  55,  39,  23,  -1, 113,
   -1,   85,    7,   -7,   -3,   -1,  112,   54,   -1,  99,  69,  -3,  -1,  84,  38,
   -1,   98,   53,   -5,   -1,  129,   -1,    8,  128,  -3,  -1,  22,  97,  -1,   6,
   96,  -13,   -9,   -5,   -3,   -1,   83,   68,   37,  -1,  82,   5,  -1,  21,  81,
   -7,   -3,   -1,   52,   67,   -1,   80,   36,   -3,  -1,  66,  51,  20, -19, -11,
   -5,   -1,   65,   -1,    4,   64,   -3,   -1,   35,  50,  19,  -3,  -1,  49,   3,
   -1,   48,   34,   -3,   -1,   18,   33,   -1,    2,  32,  -3,  -1,  17,   1,  16,
    0
};
static short s_Tab15[ 511 ] __attribute__(   (  section( ".data" )  )   ) = {
 -495, -445, -355, -263, -183, -115, -77, -43, -27, -13,  -7,  -3,  -1, 255, 239,
   -1,  254,  223,   -1,  238,   -1, 253, 207,  -7,  -3,  -1, 252, 222,  -1, 237,
  191,   -1,  251,   -1,  206,  236,  -7,  -3,  -1, 221, 175,  -1, 250, 190,  -3,
   -1,  235,  205,   -1,  220,  159, -15,  -7,  -3,  -1, 249, 234,  -1, 189, 219,
   -3,   -1,  143,  248,   -1,  204, 158,  -7,  -3,  -1, 233, 127,  -1, 247, 173,
   -3,   -1,  218,  188,   -1,  111,  -1, 174,  15, -19, -11,  -3,  -1, 203, 246,
   -3,   -1,  142,  232,   -1,   95, 157,  -3,  -1, 245, 126,  -1, 231, 172,  -9,
   -3,   -1,  202,  187,   -3,   -1, 217, 141,  79,  -3,  -1, 244,  63,  -1, 243,
  216,  -33,  -17,   -9,   -3,   -1, 230,  47,  -1, 242,  -1, 110, 240,  -3,  -1,
   31,  241,   -1,  156,  201,   -7,  -3,  -1,  94, 171,  -1, 186, 229,  -3,  -1,
  125,  215,   -1,   78,  228,  -15,  -7,  -3,  -1, 140, 200,  -1,  62, 109,  -3,
   -1,  214,  227,   -1,  155,  185,  -7,  -3,  -1,  46, 170,  -1, 226,  30,  -5,
   -1,  225,   -1,   14,  224,   -1,  93, 213, -45, -25, -13,  -7,  -3,  -1, 124,
  199,   -1,   77,  139,   -1,  212,  -1, 184, 154,  -7,  -3,  -1, 169, 108,  -1,
  198,   61,   -1,  211,  210,   -9,  -5,  -3,  -1,  45,  13,  29,  -1, 123, 183,
   -5,   -1,  209,   -1,   92,  208,  -1, 197, 138, -17,  -7,  -3,  -1, 168,  76,
   -1,  196,  107,   -5,   -1,  182,  -1, 153,  12,  -1,  60, 195,  -9,  -3,  -1,
  122,  167,   -1,  166,   -1,  192,  11,  -1, 194,  -1,  44,  91, -55, -29, -15,
   -7,   -3,   -1,  181,   28,   -1, 137, 152,  -3,  -1, 193,  75,  -1, 180, 106,
   -5,   -3,   -1,   59,  121,  179,  -3,  -1, 151, 136,  -1,  43,  90, -11,  -5,
   -1,  178,   -1,  165,   27,   -1, 177,  -1, 176, 105,  -7,  -3,  -1, 150,  74,
   -1,  164,  120,   -3,   -1,  135,  58, 163, -17,  -7,  -3,  -1,  89, 149,  -1,
   42,  162,   -3,   -1,   26,  161,  -3,  -1,  10, 160, 104,  -7,  -3,  -1, 134,
   73,   -1,  148,   57,   -5,   -1, 147,  -1, 119,   9,  -1,  88, 133, -53, -29,
  -13,   -7,   -3,   -1,   41,  103,  -1, 118, 146,  -1, 145,  -1,  25, 144,  -7,
   -3,   -1,   72,  132,   -1,   87, 117,  -3,  -1,  56, 131,  -1, 102,  71,  -7,
   -3,   -1,   40,  130,   -1,   24, 129,  -7,  -3,  -1, 116,   8,  -1, 128,  86,
   -3,   -1,  101,   55,   -1,  115,  70, -17,  -7,  -3,  -1,  39, 114,  -1, 100,
   23,   -3,   -1,   85,  113,   -3,  -1,   7, 112,  54,  -7,  -3,  -1,  99,  69,
   -1,   84,   38,   -3,   -1,   98,  22,  -3,  -1,   6,  96,  53, -33, -19,  -9,
   -5,   -1,   97,   -1,   83,   68,  -1,  37,  82,  -3,  -1,  21,  81,  -3,  -1,
    5,   80,   52,   -7,   -3,   -1,  67,  36,  -1,  66,  51,  -1,  65,  -1,  20,
    4,   -9,   -3,   -1,   35,   50,  -3,  -1,  64,   3,  19,  -3,  -1,  49,  48,
   34,   -9,   -7,   -3,   -1,   18,  33,  -1,   2,  32,  17,  -3,  -1,   1,  16,
    0     
};
static short s_Tab16[ 511 ] __attribute__(   (  section( ".data" )  )   ) = {
 -509, -503, -461, -323, -103, -37, -27, -15,  -7,  -3,  -1, 239, 254,  -1, 223,
  253,   -3,   -1,  207,  252,  -1, 191, 251,  -5,  -1, 175,  -1, 250, 159,  -3,
   -1,  249,  248,  143,   -7,  -3,  -1, 127, 247,  -1, 111, 246, 255,  -9,  -5,
   -3,   -1,   95,  245,   79,  -1, 244, 243, -53,  -1, 240,  -1,  63, -29, -19,
  -13,   -7,   -5,   -1,  206,  -1, 236, 221, 222,  -1, 233,  -1, 234, 217,  -1,
  238,   -1,  237,  235,   -3,  -1, 190, 205,  -3,  -1, 220, 219, 174, -11,  -5,
   -1,  204,   -1,  173,  218,  -3,  -1, 126, 172, 202,  -5,  -3,  -1, 201, 125,
   94,  189,  242,  -93,   -5,  -3,  -1,  47,  15,  31,  -1, 241, -49, -25, -13,
   -5,   -1,  158,   -1,  188, 203,  -3,  -1, 142, 232,  -1, 157, 231,  -7,  -3,
   -1,  187,  141,   -1,  216, 110,  -1, 230, 156, -13,  -7,  -3,  -1, 171, 186,
   -1,  229,  215,   -1,   78,  -1, 228, 140,  -3,  -1, 200,  62,  -1, 109,  -1,
  214,  155,  -19,  -11,   -5,  -3,  -1, 185, 170, 225,  -1, 212,  -1, 184, 169,
   -5,   -1,  123,   -1,  183, 208, 227,  -7,  -3,  -1,  14, 224,  -1,  93, 213,
   -3,   -1,  124,  199,   -1,  77, 139, -75, -45, -27, -13,  -7,  -3,  -1, 154,
  108,   -1,  198,   61,   -3,  -1,  92, 197,  13,  -7,  -3,  -1, 138, 168,  -1,
  153,   76,   -3,   -1,  182, 122,  60, -11,  -5,  -3,  -1,  91, 137,  28,  -1,
  192,   -1,  152,  121,   -1, 226,  -1,  46,  30, -15,  -7,  -3,  -1, 211,  45,
   -1,  210,  209,   -5,   -1,  59,  -1, 151, 136,  29,  -7,  -3,  -1, 196, 107,
   -1,  195,  167,   -1,   44,  -1, 194, 181, -23, -13,  -7,  -3,  -1, 193,  12,
   -1,   75,  180,   -3,   -1, 106, 166, 179,  -5,  -3,  -1,  90, 165,  43,  -1,
  178,   27,  -13,   -5,   -1, 177,  -1,  11, 176,  -3,  -1, 105, 150,  -1,  74,
  164,   -5,   -3,   -1,  120, 135, 163,  -3,  -1,  58,  89,  42, -97, -57, -33,
  -19,  -11,   -5,   -3,   -1, 149, 104, 161,  -3,  -1, 134, 119, 148,  -5,  -3,
   -1,   73,   87,  103,  162,  -5,  -1,  26,  -1,  10, 160,  -3,  -1,  57, 147,
   -1,   88,  133,   -9,   -3,  -1,  41, 146,  -3,  -1, 118,   9,  25,  -5,  -1,
  145,   -1,  144,   72,   -3,  -1, 132, 117,  -1,  56, 131, -21, -11,  -5,  -3,
   -1,  102,   40,  130,   -3,  -1,  71, 116,  24,  -3,  -1, 129, 128,  -3,  -1,
    8,   86,   55,   -9,   -5,  -1, 115,  -1, 101,  70,  -1,  39, 114,  -5,  -3,
   -1,  100,   85,    7,   23, -23, -13,  -5,  -1, 113,  -1, 112,  54,  -3,  -1,
   99,   69,   -1,   84,   38,  -3,  -1,  98,  22,  -1,  97,  -1,   6,  96,  -9,
   -5,   -1,   83,   -1,   53,  68,  -1,  37,  82,  -1,  81,  -1,  21,   5, -33,
  -23,  -13,   -7,   -3,   -1,  52,  67,  -1,  80,  36,  -3,  -1,  66,  51,  20,
   -5,   -1,   65,   -1,    4,  64,  -1,  35,  50,  -3,  -1,  19,  49,  -3,  -1,
    3,   48,   34,   -3,   -1,  18,  33,  -1,   2,  32,  -3,  -1,  17,   1,  16,
    0    
};
static short s_Tab24[ 511 ] __attribute__(   (  section( ".data" )  )   ) = {
 -451, -117, -43, -25, -15,  -7,  -3,  -1, 239, 254,  -1, 223, 253,  -3,  -1,
  207,  252,  -1, 191, 251,  -5,  -1, 250,  -1, 175, 159,  -1, 249, 248,  -9,
   -5,   -3,  -1, 143, 127, 247,  -1, 111, 246,  -3,  -1,  95, 245,  -1,  79,
  244,  -71,  -7,  -3,  -1,  63, 243,  -1,  47, 242,  -5,  -1, 241,  -1,  31,
  240,  -25,  -9,  -1,  15,  -3,  -1, 238, 222,  -1, 237, 206,  -7,  -3,  -1,
  236,  221,  -1, 190, 235,  -3,  -1, 205, 220,  -1, 174, 234, -15,  -7,  -3,
   -1,  189, 219,  -1, 204, 158,  -3,  -1, 233, 173,  -1, 218, 188,  -7,  -3,
   -1,  203, 142,  -1, 232, 157,  -3,  -1, 217, 126,  -1, 231, 172, 255,-235,
 -143,  -77, -45, -25, -15,  -7,  -3,  -1, 202, 187,  -1, 141, 216,  -5,  -3,
   -1,   14, 224,  13, 230,  -5,  -3,  -1, 110, 156, 201,  -1,  94, 186,  -9,
   -5,   -1, 229,  -1, 171, 125,  -1, 215, 228,  -3,  -1, 140, 200,  -3,  -1,
   78,   46,  62, -15,  -7,  -3,  -1, 109, 214,  -1, 227, 155,  -3,  -1, 185,
  170,   -1, 226,  30,  -7,  -3,  -1, 225,  93,  -1, 213, 124,  -3,  -1, 199,
   77,   -1, 139, 184, -31, -15,  -7,  -3,  -1, 212, 154,  -1, 169, 108,  -3,
   -1,  198,  61,  -1, 211,  45,  -7,  -3,  -1, 210,  29,  -1, 123, 183,  -3,
   -1,  209,  92,  -1, 197, 138, -17,  -7,  -3,  -1, 168, 153,  -1,  76, 196,
   -3,   -1, 107, 182,  -3,  -1, 208,  12,  60,  -7,  -3,  -1, 195, 122,  -1,
  167,   44,  -3,  -1, 194,  91,  -1, 181,  28, -57, -35, -19,  -7,  -3,  -1,
  137,  152,  -1, 193,  75,  -5,  -3,  -1, 192,  11,  59,  -3,  -1, 176,  10,
   26,   -5,  -1, 180,  -1, 106, 166,  -3,  -1, 121, 151,  -3,  -1, 160,   9,
  144,   -9,  -3,  -1, 179, 136,  -3,  -1,  43,  90, 178,  -7,  -3,  -1, 165,
   27,   -1, 177, 105,  -1, 150, 164, -17,  -9,  -5,  -3,  -1,  74, 120, 135,
   -1,   58, 163,  -3,  -1,  89, 149,  -1,  42, 162,  -7,  -3,  -1, 161, 104,
   -1,  134, 119,  -3,  -1,  73, 148,  -1,  57, 147, -63, -31, -15,  -7,  -3,
   -1,   88, 133,  -1,  41, 103,  -3,  -1, 118, 146,  -1,  25, 145,  -7,  -3,
   -1,   72, 132,  -1,  87, 117,  -3,  -1,  56, 131,  -1, 102,  40, -17,  -7,
   -3,   -1, 130,  24,  -1,  71, 116,  -5,  -1, 129,  -1,   8, 128,  -1,  86,
  101,   -7,  -5,  -1,  23,  -1,   7, 112, 115,  -3,  -1,  55,  39, 114, -15,
   -7,   -3,  -1,  70, 100,  -1,  85, 113,  -3,  -1,  54,  99,  -1,  69,  84,
   -7,   -3,  -1,  38,  98,  -1,  22,  97,  -5,  -3,  -1,   6,  96,  53,  -1,
   83,   68, -51, -37, -23, -15,  -9,  -3,  -1,  37,  82,  -1,  21,  -1,   5,
   80,   -1,  81,  -1,  52,  67,  -3,  -1,  36,  66,  -1,  51,  20,  -9,  -5,
   -1,   65,  -1,   4,  64,  -1,  35,  50,  -1,  19,  49,  -7,  -5,  -3,  -1,
    3,   48,  34,  18,  -1,  33,  -1,   2,  32,  -3,  -1,  17,   1,  -1,  16,
    0 
};
static short s_TabC0[ 31 ] __attribute__(   (  section( ".data" )  )   ) = {
 -29, -21, -13,  -7,  -3,  -1,  11,  15,  -1,  13,  14,  -3,  -1,   7,   5,
   9,  -3,  -1,   6,   3,  -1,  10,  12,  -3,  -1,   2,   1,  -1,   4,   8,
   0
};
static short s_TabC1[ 31 ] __attribute__(   (  section( ".data" )  )   ) = {
 -15,  -7,  -3,  -1,  15,  14,  -1,  13,  12,  -3,  -1,  11,  10,  -1,   9,
   8,  -7,  -3,  -1,   7,   6,  -1,   5,   4,  -3,  -1,   3,   2,  -1,   1,
   0
};
static _Huff s_HuffTbl[ 32 ] = {
 {  0, s_Tab0  },
 {  0, s_Tab1  },
 {  0, s_Tab2  },
 {  0, s_Tab3  },
 {  0, s_Tab0  },
 {  0, s_Tab5  },
 {  0, s_Tab6  },
 {  0, s_Tab7  },
 {  0, s_Tab8  },
 {  0, s_Tab9  },
 {  0, s_Tab10 },
 {  0, s_Tab11 },
 {  0, s_Tab12 },
 {  0, s_Tab13 },
 {  0, s_Tab0  },
 {  0, s_Tab15 },
 {  1, s_Tab16 },
 {  2, s_Tab16 },
 {  3, s_Tab16 },
 {  4, s_Tab16 },
 {  6, s_Tab16 },
 {  8, s_Tab16 },
 { 10, s_Tab16 },
 { 13, s_Tab16 },
 {  4, s_Tab24 },
 {  5, s_Tab24 },
 {  6, s_Tab24 },
 {  7, s_Tab24 },
 {  8, s_Tab24 },
 {  9, s_Tab24 },
 { 11, s_Tab24 },
 { 13, s_Tab24 }
};
static _Huff s_HuffTblC[ 2 ] = {
 { 0 , s_TabC0 },
 { 0 , s_TabC1 }
};
static int s_PreTab1[ 22 ] = {
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0
};
static int s_PreTab2[ 22 ] = {
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static unsigned int s_ISPow[ 8207 ] = {
 0x00000000, 0x3F800000, 0x40214518, 0x408A74BA,
 0x40CB2FF5, 0x4108CC4F, 0x412E718E, 0x41563F90,
 0x41800000, 0x4195C41B, 0x41AC5AD3, 0x41C3B5D3,
 0x41DBC8FF, 0x41F489EF, 0x4206F7CD, 0x4213F904,
 0x42214518, 0x422ED8DF, 0x423CB181, 0x424ACC6C,
 0x42592746, 0x4267BFE8, 0x42769458, 0x4282D161,
 0x428A74BA, 0x4292336D, 0x429A0CBF, 0x42A20000,
 0x42AA0C8A, 0x42B231C3, 0x42BA6F17, 0x42C2C3FE,
 0x42CB2FF5, 0x42D3B280, 0x42DC4B2A, 0x42E4F982,
 0x42EDBD20, 0x42F6959C, 0x42FF8298, 0x430441DB,
 0x4308CC4F, 0x430D607D, 0x4311FE3D, 0x4316A568,
 0x431B55D8, 0x43200F69, 0x4324D1F9, 0x43299D65,
 0x432E718E, 0x43334E55, 0x4338339A, 0x433D2142,
 0x43421730, 0x43471549, 0x434C1B72, 0x43512992,
 0x43563F90, 0x435B5D54, 0x436082C7, 0x4365AFD1,
 0x436AE45E, 0x43702057, 0x437563A8, 0x437AAE3C,
 0x43800000, 0x4382AC70, 0x43855C65, 0x43880FD6,
 0x438AC6BA, 0x438D8108, 0x43903EB7, 0x4392FFC0,
 0x4395C41B, 0x43988BBF, 0x439B56A5, 0x439E24C5,
 0x43A0F618, 0x43A3CA96, 0x43A6A239, 0x43A97CFA,
 0x43AC5AD3, 0x43AF3BBB, 0x43B21FAD, 0x43B506A4,
 0x43B7F097, 0x43BADD82, 0x43BDCD5E, 0x43C0C025,
 0x43C3B5D3, 0x43C6AE60, 0x43C9A9C8, 0x43CCA806,
 0x43CFA913, 0x43D2ACEA, 0x43D5B388, 0x43D8BCE5,
 0x43DBC8FF, 0x43DED7CE, 0x43E1E950, 0x43E4FD7F,
 0x43E81456, 0x43EB2DD2, 0x43EE49ED, 0x43F168A3,
 0x43F489EF, 0x43F7ADCF, 0x43FAD43C, 0x43FDFD34,
 0x44009459, 0x44022B59, 0x4403C399, 0x44055D15,
 0x4406F7CD, 0x440893BE, 0x440A30E6, 0x440BCF45,
 0x440D6ED7, 0x440F0F9C, 0x4410B190, 0x441254B4,
 0x4413F904, 0x44159E80, 0x44174526, 0x4418ECF3,
 0x441A95E7, 0x441C4000, 0x441DEB3C, 0x441F979A,
 0x44214518, 0x4422F3B4, 0x4424A36E, 0x44265444,
 0x44280634, 0x4429B93D, 0x442B6D5D, 0x442D2294,
 0x442ED8DF, 0x4430903D, 0x443248AE, 0x4434022F,
 0x4435BCBF, 0x4437785E, 0x44393509, 0x443AF2C0,
 0x443CB181, 0x443E714C, 0x4440321E, 0x4441F3F6,
 0x4443B6D5, 0x44457AB7, 0x44473F9C, 0x44490584,
 0x444ACC6C, 0x444C9454, 0x444E5D3A, 0x4450271E,
 0x4451F1FF, 0x4453BDDA, 0x44558AB0, 0x4457587F,
 0x44592746, 0x445AF704, 0x445CC7B8, 0x445E9961,
 0x44606BFE, 0x44623F8F, 0x44641411, 0x4465E984,
 0x4467BFE8, 0x4469973A, 0x446B6F7B, 0x446D48AA,
 0x446F22C4, 0x4470FDCA, 0x4472D9BB, 0x4474B695,
 0x44769458, 0x44787302, 0x447A5294, 0x447C330C,
 0x447E1469, 0x447FF6AB, 0x4480ECE8, 0x4481DEEC,
 0x4482D161, 0x4483C446, 0x4484B79C, 0x4485AB61,
 0x44869F96, 0x44879439, 0x4488894B, 0x44897ECC,
 0x448A74BA, 0x448B6B15, 0x448C61DE, 0x448D5913,
 0x448E50B4, 0x448F48C2, 0x4490413A, 0x44913A1E,
 0x4492336D, 0x44932D27, 0x4494274A, 0x449521D7,
 0x44961CCE, 0x4497182D, 0x449813F6, 0x44991027,
 0x449A0CBF, 0x449B09C0, 0x449C0728, 0x449D04F7,
 0x449E032C, 0x449F01C9, 0x44A000CB, 0x44A10033,
 0x44A20000, 0x44A30033, 0x44A400CA, 0x44A501C6,
 0x44A60326, 0x44A704EA, 0x44A80711, 0x44A9099C,
 0x44AA0C8A, 0x44AB0FDB, 0x44AC138E, 0x44AD17A3,
 0x44AE1C1A, 0x44AF20F2, 0x44B0262C, 0x44B12BC7,
 0x44B231C3, 0x44B3381F, 0x44B43EDB, 0x44B545F7,
 0x44B64D72, 0x44B7554D, 0x44B85D87, 0x44B96620,
 0x44BA6F17, 0x44BB786D, 0x44BC8221, 0x44BD8C32,
 0x44BE96A1, 0x44BFA16D, 0x44C0AC96, 0x44C1B81C,
 0x44C2C3FE, 0x44C3D03D, 0x44C4DCD8, 0x44C5E9CE,
 0x44C6F720, 0x44C804CD, 0x44C912D5, 0x44CA2138,
 0x44CB2FF5, 0x44CC3F0D, 0x44CD4E7F, 0x44CE5E4A,
 0x44CF6E70, 0x44D07EEE, 0x44D18FC6, 0x44D2A0F7,
 0x44D3B280, 0x44D4C462, 0x44D5D69C, 0x44D6E92E,
 0x44D7FC18, 0x44D90F5A, 0x44DA22F2, 0x44DB36E3,
 0x44DC4B2A, 0x44DD5FC7, 0x44DE74BC, 0x44DF8A06,
 0x44E09FA7, 0x44E1B59D, 0x44E2CBE9, 0x44E3E28B,
 0x44E4F982, 0x44E610CE, 0x44E7286F, 0x44E84065,
 0x44E958AF, 0x44EA714D, 0x44EB8A3F, 0x44ECA386,
 0x44EDBD20, 0x44EED70D, 0x44EFF14E, 0x44F10BE1,
 0x44F226C8, 0x44F34202, 0x44F45D8E, 0x44F5796C,
 0x44F6959C, 0x44F7B21F, 0x44F8CEF3, 0x44F9EC19,
 0x44FB0990, 0x44FC2759, 0x44FD4572, 0x44FE63DD,
 0x44FF8298, 0x450050D2, 0x4500E080, 0x45017056,
 0x45020054, 0x4502907A, 0x450320C8, 0x4503B13E,
 0x450441DB, 0x4504D2A0, 0x4505638C, 0x4505F4A0,
 0x450685DB, 0x4507173D, 0x4507A8C7, 0x45083A77,
 0x4508CC4F, 0x45095E4D, 0x4509F072, 0x450A82BE,
 0x450B1531, 0x450BA7CA, 0x450C3A8A, 0x450CCD70,
 0x450D607D, 0x450DF3B0, 0x450E8709, 0x450F1A88,
 0x450FAE2D, 0x451041F8, 0x4510D5EA, 0x45116A00,
 0x4511FE3D, 0x4512929F, 0x45132727, 0x4513BBD5,
 0x451450A8, 0x4514E5A0, 0x45157ABD, 0x45161000,
 0x4516A568, 0x45173AF5, 0x4517D0A7, 0x4518667E,
 0x4518FC7A, 0x4519929A, 0x451A28DF, 0x451ABF49,
 0x451B55D8, 0x451BEC8B, 0x451C8363, 0x451D1A5E,
 0x451DB17F, 0x451E48C3, 0x451EE02C, 0x451F77B8,
 0x45200F69, 0x4520A73E, 0x45213F37, 0x4521D753,
 0x45226F93, 0x452307F7, 0x4523A07F, 0x4524392A,
 0x4524D1F9, 0x45256AEB, 0x45260400, 0x45269D39,
 0x45273695, 0x4527D015, 0x452869B7, 0x4529037D,
 0x45299D65, 0x452A3771, 0x452AD19F, 0x452B6BF0,
 0x452C0664, 0x452CA0FB, 0x452D3BB4, 0x452DD690,
 0x452E718E, 0x452F0CAF, 0x452FA7F2, 0x45304358,
 0x4530DEE0, 0x45317A8A, 0x45321656, 0x4532B244,
 0x45334E55, 0x4533EA87, 0x453486DB, 0x45352352,
 0x4535BFE9, 0x45365CA3, 0x4536F97F, 0x4537967C,
 0x4538339A, 0x4538D0DB, 0x45396E3C, 0x453A0BBF,
 0x453AA964, 0x453B472A, 0x453BE511, 0x453C8319,
 0x453D2142, 0x453DBF8D, 0x453E5DF8, 0x453EFC85,
 0x453F9B32, 0x45403A01, 0x4540D8F0, 0x45417800,
 0x45421730, 0x4542B682, 0x454355F3, 0x4543F586,
 0x45449539, 0x4545350C, 0x4545D500, 0x45467514,
 0x45471549, 0x4547B59E, 0x45485613, 0x4548F6A8,
 0x4549975D, 0x454A3832, 0x454AD928, 0x454B7A3D,
 0x454C1B72, 0x454CBCC7, 0x454D5E3C, 0x454DFFD1,
 0x454EA185, 0x454F4359, 0x454FE54C, 0x4550875F,
 0x45512992, 0x4551CBE4, 0x45526E56, 0x455310E7,
 0x4553B397, 0x45545666, 0x4554F955, 0x45559C63,
 0x45563F90, 0x4556E2DC, 0x45578647, 0x455829D2,
 0x4558CD7B, 0x45597143, 0x455A152A, 0x455AB930,
 0x455B5D54, 0x455C0197, 0x455CA5F9, 0x455D4A7A,
 0x455DEF19, 0x455E93D7, 0x455F38B3, 0x455FDDAE,
 0x456082C7, 0x456127FE, 0x4561CD54, 0x456272C8,
 0x4563185A, 0x4563BE0B, 0x456463DA, 0x456509C6,
 0x4565AFD1, 0x456655FA, 0x4566FC41, 0x4567A2A6,
 0x45684929, 0x4568EFC9, 0x45699688, 0x456A3D64,
 0x456AE45E, 0x456B8B76, 0x456C32AB, 0x456CD9FE,
 0x456D816E, 0x456E28FC, 0x456ED0A8, 0x456F7871,
 0x45702057, 0x4570C85B, 0x4571707C, 0x457218BA,
 0x4572C116, 0x4573698F, 0x45741225, 0x4574BAD8,
 0x457563A8, 0x45760C95, 0x4576B59F, 0x45775EC7,
 0x4578080B, 0x4578B16C, 0x45795AEA, 0x457A0485,
 0x457AAE3C, 0x457B5810, 0x457C0201, 0x457CAC0F,
 0x457D5639, 0x457E0080, 0x457EAAE4, 0x457F5564,
 0x45800000, 0x4580555C, 0x4580AAC7, 0x45810040,
 0x458155C7, 0x4581AB5C, 0x458200FF, 0x458256B1,
 0x4582AC70, 0x4583023E, 0x45835819, 0x4583AE03,
 0x458403FB, 0x45845A00, 0x4584B014, 0x45850636,
 0x45855C65, 0x4585B2A3, 0x458608EE, 0x45865F48,
 0x4586B5AF, 0x45870C24, 0x458762A7, 0x4587B938,
 0x45880FD6, 0x45886683, 0x4588BD3D, 0x45891405,
 0x45896ADA, 0x4589C1BE, 0x458A18AF, 0x458A6FAD,
 0x458AC6BA, 0x458B1DD4, 0x458B74FC, 0x458BCC31,
 0x458C2374, 0x458C7AC5, 0x458CD223, 0x458D298F,
 0x458D8108, 0x458DD88F, 0x458E3023, 0x458E87C5,
 0x458EDF74, 0x458F3731, 0x458F8EFB, 0x458FE6D2,
 0x45903EB7, 0x459096AA, 0x4590EEAA, 0x459146B7,
 0x45919ED1, 0x4591F6F9, 0x45924F2E, 0x4592A771,
 0x4592FFC0, 0x4593581D, 0x4593B088, 0x459408FF,
 0x45946184, 0x4594BA16, 0x459512B5, 0x45956B61,
 0x4595C41B, 0x45961CE2, 0x459675B5, 0x4596CE96,
 0x45972784, 0x4597807F, 0x4597D987, 0x4598329D,
 0x45988BBF, 0x4598E4EE, 0x45993E2A, 0x45999774,
 0x4599F0CA, 0x459A4A2D, 0x459AA39D, 0x459AFD1B,
 0x459B56A5, 0x459BB03C, 0x459C09DF, 0x459C6390,
 0x459CBD4E, 0x459D1718, 0x459D70F0, 0x459DCAD4,
 0x459E24C5, 0x459E7EC2, 0x459ED8CD, 0x459F32E4,
 0x459F8D08, 0x459FE739, 0x45A04176, 0x45A09BC1,
 0x45A0F618, 0x45A1507B, 0x45A1AAEB, 0x45A20568,
 0x45A25FF2, 0x45A2BA88, 0x45A3152B, 0x45A36FDA,
 0x45A3CA96, 0x45A4255F, 0x45A48034, 0x45A4DB15,
 0x45A53604, 0x45A590FE, 0x45A5EC06, 0x45A64719,
 0x45A6A239, 0x45A6FD66, 0x45A7589F, 0x45A7B3E5,
 0x45A80F37, 0x45A86A95, 0x45A8C600, 0x45A92177,
 0x45A97CFA, 0x45A9D88A, 0x45AA3427, 0x45AA8FCF,
 0x45AAEB84, 0x45AB4745, 0x45ABA313, 0x45ABFEED,
 0x45AC5AD3, 0x45ACB6C5, 0x45AD12C3, 0x45AD6ECE,
 0x45ADCAE5, 0x45AE2708, 0x45AE8338, 0x45AEDF73,
 0x45AF3BBB, 0x45AF980F, 0x45AFF46F, 0x45B050DB,
 0x45B0AD53, 0x45B109D8, 0x45B16668, 0x45B1C305,
 0x45B21FAD, 0x45B27C62, 0x45B2D923, 0x45B335F0,
 0x45B392C8, 0x45B3EFAD, 0x45B44C9E, 0x45B4A99B,
 0x45B506A4, 0x45B563B8, 0x45B5C0D9, 0x45B61E05,
 0x45B67B3E, 0x45B6D882, 0x45B735D3, 0x45B7932F,
 0x45B7F097, 0x45B84E0B, 0x45B8AB8B, 0x45B90916,
 0x45B966AE, 0x45B9C451, 0x45BA2200, 0x45BA7FBB,
 0x45BADD82, 0x45BB3B54, 0x45BB9932, 0x45BBF71C,
 0x45BC5512, 0x45BCB313, 0x45BD1121, 0x45BD6F39,
 0x45BDCD5E, 0x45BE2B8E, 0x45BE89CA, 0x45BEE811,
 0x45BF4665, 0x45BFA4C3, 0x45C0032E, 0x45C061A4,
 0x45C0C025, 0x45C11EB3, 0x45C17D4B, 0x45C1DBF0,
 0x45C23AA0, 0x45C2995B, 0x45C2F822, 0x45C356F5,
 0x45C3B5D3, 0x45C414BC, 0x45C473B1, 0x45C4D2B2,
 0x45C531BE, 0x45C590D5, 0x45C5EFF8, 0x45C64F27,
 0x45C6AE60, 0x45C70DA5, 0x45C76CF6, 0x45C7CC52,
 0x45C82BB9, 0x45C88B2C, 0x45C8EAAA, 0x45C94A34,
 0x45C9A9C8, 0x45CA0968, 0x45CA6914, 0x45CAC8CB,
 0x45CB288D, 0x45CB885A, 0x45CBE833, 0x45CC4816,
 0x45CCA806, 0x45CD0800, 0x45CD6806, 0x45CDC816,
 0x45CE2833, 0x45CE885A, 0x45CEE88C, 0x45CF48CA,
 0x45CFA913, 0x45D00967, 0x45D069C6, 0x45D0CA30,
 0x45D12AA6, 0x45D18B26, 0x45D1EBB2, 0x45D24C49,
 0x45D2ACEA, 0x45D30D97, 0x45D36E4F, 0x45D3CF13,
 0x45D42FE1, 0x45D490BA, 0x45D4F19E, 0x45D5528D,
 0x45D5B388, 0x45D6148D, 0x45D6759D, 0x45D6D6B9,
 0x45D737DF, 0x45D79910, 0x45D7FA4C, 0x45D85B93,
 0x45D8BCE5, 0x45D91E42, 0x45D97FAA, 0x45D9E11D,
 0x45DA429B, 0x45DAA423, 0x45DB05B7, 0x45DB6755,
 0x45DBC8FF, 0x45DC2AB3, 0x45DC8C72, 0x45DCEE3B,
 0x45DD5010, 0x45DDB1EF, 0x45DE13DA, 0x45DE75CF,
 0x45DED7CE, 0x45DF39D9, 0x45DF9BEE, 0x45DFFE0E,
 0x45E06039, 0x45E0C26F, 0x45E124AF, 0x45E186FA,
 0x45E1E950, 0x45E24BB1, 0x45E2AE1C, 0x45E31092,
 0x45E37312, 0x45E3D59D, 0x45E43833, 0x45E49AD4,
 0x45E4FD7F, 0x45E56035, 0x45E5C2F5, 0x45E625C0,
 0x45E68896, 0x45E6EB76, 0x45E74E61, 0x45E7B156,
 0x45E81456, 0x45E87761, 0x45E8DA76, 0x45E93D96,
 0x45E9A0C0, 0x45EA03F4, 0x45EA6734, 0x45EACA7D,
 0x45EB2DD2, 0x45EB9130, 0x45EBF49A, 0x45EC580D,
 0x45ECBB8B, 0x45ED1F14, 0x45ED82A7, 0x45EDE645,
 0x45EE49ED, 0x45EEAD9F, 0x45EF115C, 0x45EF7523,
 0x45EFD8F4, 0x45F03CD0, 0x45F0A0B7, 0x45F104A7,
 0x45F168A3, 0x45F1CCA8, 0x45F230B8, 0x45F294D2,
 0x45F2F8F6, 0x45F35D25, 0x45F3C15E, 0x45F425A2,
 0x45F489EF, 0x45F4EE47, 0x45F552AA, 0x45F5B716,
 0x45F61B8D, 0x45F6800E, 0x45F6E499, 0x45F7492F,
 0x45F7ADCF, 0x45F81279, 0x45F8772D, 0x45F8DBEB,
 0x45F940B4, 0x45F9A587, 0x45FA0A64, 0x45FA6F4B,
 0x45FAD43C, 0x45FB3938, 0x45FB9E3D, 0x45FC034D,
 0x45FC6867, 0x45FCCD8B, 0x45FD32B9, 0x45FD97F2,
 0x45FDFD34, 0x45FE6281, 0x45FEC7D7, 0x45FF2D38,
 0x45FF92A3, 0x45FFF818, 0x46002ECB, 0x46006190,
 0x46009459, 0x4600C728, 0x4600F9FB, 0x46012CD4,
 0x46015FB1, 0x46019294, 0x4601C57B, 0x4601F868,
 0x46022B59, 0x46025E50, 0x4602914B, 0x4602C44C,
 0x4602F751, 0x46032A5C, 0x46035D6B, 0x4603907F,
 0x4603C399, 0x4603F6B7, 0x460429DA, 0x46045D02,
 0x4604902F, 0x4604C361, 0x4604F698, 0x460529D4,
 0x46055D15, 0x4605905B, 0x4605C3A5, 0x4605F6F5,
 0x46062A4A, 0x46065DA3, 0x46069101, 0x4606C465,
 0x4606F7CD, 0x46072B3A, 0x46075EAC, 0x46079222,
 0x4607C59E, 0x4607F91F, 0x46082CA4, 0x4608602F,
 0x460893BE, 0x4608C752, 0x4608FAEB, 0x46092E89,
 0x4609622B, 0x460995D3, 0x4609C97F, 0x4609FD30,
 0x460A30E6, 0x460A64A1, 0x460A9861, 0x460ACC26,
 0x460AFFEF, 0x460B33BD, 0x460B6790, 0x460B9B68,
 0x460BCF45, 0x460C0326, 0x460C370D, 0x460C6AF8,
 0x460C9EE8, 0x460CD2DC, 0x460D06D6, 0x460D3AD4,
 0x460D6ED7, 0x460DA2DF, 0x460DD6EC, 0x460E0AFD,
 0x460E3F13, 0x460E732E, 0x460EA74E, 0x460EDB72,
 0x460F0F9C, 0x460F43CA, 0x460F77FC, 0x460FAC34,
 0x460FE070, 0x461014B1, 0x461048F7, 0x46107D41,
 0x4610B190, 0x4610E5E4, 0x46111A3D, 0x46114E9A,
 0x461182FC, 0x4611B763, 0x4611EBCF, 0x4612203F,
 0x461254B4, 0x4612892E, 0x4612BDAC, 0x4612F22F,
 0x461326B7, 0x46135B43, 0x46138FD4, 0x4613C46A,
 0x4613F904, 0x46142DA4, 0x46146247, 0x461496F0,
 0x4614CB9D, 0x4615004F, 0x46153505, 0x461569C1,
 0x46159E80, 0x4615D345, 0x4616080E, 0x46163CDC,
 0x461671AE, 0x4616A685, 0x4616DB61, 0x46171041,
 0x46174526, 0x46177A0F, 0x4617AEFD, 0x4617E3F0,
 0x461818E8, 0x46184DE4, 0x461882E4, 0x4618B7E9,
 0x4618ECF3, 0x46192202, 0x46195715, 0x46198C2C,
 0x4619C149, 0x4619F669, 0x461A2B8F, 0x461A60B9,
 0x461A95E7, 0x461ACB1A, 0x461B0052, 0x461B358E,
 0x461B6ACF, 0x461BA014, 0x461BD55E, 0x461C0AAD,
 0x461C4000, 0x461C7558, 0x461CAAB4, 0x461CE014,
 0x461D157A, 0x461D4AE3, 0x461D8052, 0x461DB5C5,
 0x461DEB3C, 0x461E20B8, 0x461E5638, 0x461E8BBD,
 0x461EC147, 0x461EF6D5, 0x461F2C67, 0x461F61FE,
 0x461F979A, 0x461FCD3A, 0x462002DE, 0x46203887,
 0x46206E35, 0x4620A3E7, 0x4620D99D, 0x46210F58,
 0x46214518, 0x46217ADC, 0x4621B0A4, 0x4621E671,
 0x46221C42, 0x46225218, 0x462287F3, 0x4622BDD1,
 0x4622F3B4, 0x4623299C, 0x46235F88, 0x46239579,
 0x4623CB6E, 0x46240167, 0x46243765, 0x46246D68,
 0x4624A36E, 0x4624D97A, 0x46250F89, 0x4625459D,
 0x46257BB6, 0x4625B1D3, 0x4625E7F4, 0x46261E1A,
 0x46265444, 0x46268A73, 0x4626C0A6, 0x4626F6DD,
 0x46272D19, 0x46276359, 0x4627999E, 0x4627CFE7,
 0x46280634, 0x46283C86, 0x462872DC, 0x4628A936,
 0x4628DF95, 0x462915F9, 0x46294C60, 0x462982CC,
 0x4629B93D, 0x4629EFB2, 0x462A262B, 0x462A5CA8,
 0x462A932A, 0x462AC9B0, 0x462B003B, 0x462B36CA,
 0x462B6D5D, 0x462BA3F5, 0x462BDA91, 0x462C1131,
 0x462C47D6, 0x462C7E7F, 0x462CB52C, 0x462CEBDE,
 0x462D2294, 0x462D594E, 0x462D900C, 0x462DC6CF,
 0x462DFD97, 0x462E3462, 0x462E6B32, 0x462EA206,
 0x462ED8DF, 0x462F0FBB, 0x462F469D, 0x462F7D82,
 0x462FB46C, 0x462FEB5A, 0x4630224C, 0x46305942,
 0x4630903D, 0x4630C73C, 0x4630FE40, 0x46313547,
 0x46316C53, 0x4631A363, 0x4631DA78, 0x46321191,
 0x463248AE, 0x46327FCF, 0x4632B6F4, 0x4632EE1E,
 0x4633254C, 0x46335C7E, 0x463393B5, 0x4633CAF0,
 0x4634022F, 0x46343972, 0x463470B9, 0x4634A805,
 0x4634DF55, 0x463516A9, 0x46354E02, 0x4635855E,
 0x4635BCBF, 0x4635F424, 0x46362B8E, 0x463662FB,
 0x46369A6D, 0x4636D1E3, 0x4637095D, 0x463740DB,
 0x4637785E, 0x4637AFE5, 0x4637E770, 0x46381EFF,
 0x46385692, 0x46388E2A, 0x4638C5C5, 0x4638FD65,
 0x46393509, 0x46396CB2, 0x4639A45E, 0x4639DC0F,
 0x463A13C3, 0x463A4B7C, 0x463A8339, 0x463ABAFB,
 0x463AF2C0, 0x463B2A8A, 0x463B6258, 0x463B9A29,
 0x463BD200, 0x463C09DA, 0x463C41B8, 0x463C799B,
 0x463CB181, 0x463CE96C, 0x463D215B, 0x463D594E,
 0x463D9145, 0x463DC941, 0x463E0140, 0x463E3944,
 0x463E714C, 0x463EA957, 0x463EE167, 0x463F197C,
 0x463F5194, 0x463F89B0, 0x463FC1D1, 0x463FF9F5,
 0x4640321E, 0x46406A4A, 0x4640A27B, 0x4640DAB0,
 0x464112E9, 0x46414B26, 0x46418368, 0x4641BBAD,
 0x4641F3F6, 0x46422C44, 0x46426496, 0x46429CEB,
 0x4642D545, 0x46430DA3, 0x46434605, 0x46437E6B,
 0x4643B6D5, 0x4643EF43, 0x464427B5, 0x4644602B,
 0x464498A5, 0x4644D124, 0x464509A6, 0x4645422D,
 0x46457AB7, 0x4645B346, 0x4645EBD8, 0x4646246F,
 0x46465D09, 0x464695A8, 0x4646CE4B, 0x464706F2,
 0x46473F9C, 0x4647784B, 0x4647B0FE, 0x4647E9B5,
 0x46482270, 0x46485B2F, 0x464893F2, 0x4648CCB9,
 0x46490584, 0x46493E53, 0x46497726, 0x4649AFFD,
 0x4649E8D8, 0x464A21B7, 0x464A5A9A, 0x464A9381,
 0x464ACC6C, 0x464B055B, 0x464B3E4E, 0x464B7745,
 0x464BB040, 0x464BE93F, 0x464C2242, 0x464C5B49,
 0x464C9454, 0x464CCD63, 0x464D0676, 0x464D3F8D,
 0x464D78A8, 0x464DB1C6, 0x464DEAE9, 0x464E2410,
 0x464E5D3A, 0x464E9669, 0x464ECF9C, 0x464F08D2,
 0x464F420D, 0x464F7B4B, 0x464FB48E, 0x464FEDD4,
 0x4650271E, 0x4650606D, 0x465099BF, 0x4650D315,
 0x46510C6F, 0x465145CD, 0x46517F2F, 0x4651B895,
 0x4651F1FF, 0x46522B6C, 0x465264DE, 0x46529E54,
 0x4652D7CD, 0x4653114A, 0x46534ACC, 0x46538451,
 0x4653BDDA, 0x4653F767, 0x465430F8, 0x46546A8D,
 0x4654A426, 0x4654DDC3, 0x46551763, 0x46555108,
 0x46558AB0, 0x4655C45C, 0x4655FE0C, 0x465637C0,
 0x46567178, 0x4656AB34, 0x4656E4F4, 0x46571EB7,
 0x4657587F, 0x4657924A, 0x4657CC19, 0x465805EC,
 0x46583FC3, 0x4658799E, 0x4658B37D, 0x4658ED5F,
 0x46592746, 0x46596130, 0x46599B1E, 0x4659D510,
 0x465A0F06, 0x465A4900, 0x465A82FD, 0x465ABCFF,
 0x465AF704, 0x465B310D, 0x465B6B1A, 0x465BA52B,
 0x465BDF3F, 0x465C1958, 0x465C5374, 0x465C8D94,
 0x465CC7B8, 0x465D01E0, 0x465D3C0B, 0x465D763B,
 0x465DB06E, 0x465DEAA5, 0x465E24E0, 0x465E5F1F,
 0x465E9961, 0x465ED3A8, 0x465F0DF2, 0x465F4840,
 0x465F8291, 0x465FBCE7, 0x465FF740, 0x4660319D,
 0x46606BFE, 0x4660A663, 0x4660E0CC, 0x46611B38,
 0x466155A8, 0x4661901C, 0x4661CA94, 0x4662050F,
 0x46623F8F, 0x46627A12, 0x4662B499, 0x4662EF23,
 0x466329B2, 0x46636444, 0x46639EDA, 0x4663D973,
 0x46641411, 0x46644EB2, 0x46648957, 0x4664C400,
 0x4664FEAD, 0x4665395D, 0x46657411, 0x4665AEC9,
 0x4665E984, 0x46662444, 0x46665F07, 0x466699CE,
 0x4666D498, 0x46670F66, 0x46674A38, 0x4667850E,
 0x4667BFE8, 0x4667FAC5, 0x466835A6, 0x4668708B,
 0x4668AB73, 0x4668E660, 0x4669214F, 0x46695C43,
 0x4669973A, 0x4669D236, 0x466A0D34, 0x466A4837,
 0x466A833D, 0x466ABE47, 0x466AF955, 0x466B3466,
 0x466B6F7B, 0x466BAA94, 0x466BE5B1, 0x466C20D1,
 0x466C5BF5, 0x466C971C, 0x466CD248, 0x466D0D77,
 0x466D48AA, 0x466D83E0, 0x466DBF1A, 0x466DFA58,
 0x466E3599, 0x466E70DE, 0x466EAC27, 0x466EE774,
 0x466F22C4, 0x466F5E18, 0x466F9970, 0x466FD4CB,
 0x4670102A, 0x46704B8C, 0x467086F3, 0x4670C25C,
 0x4670FDCA, 0x4671393B, 0x467174B0, 0x4671B029,
 0x4671EBA5, 0x46722725, 0x467262A8, 0x46729E30,
 0x4672D9BB, 0x46731549, 0x467350DB, 0x46738C71,
 0x4673C80A, 0x467403A8, 0x46743F48, 0x46747AED,
 0x4674B695, 0x4674F240, 0x46752DF0, 0x467569A3,
 0x4675A559, 0x4675E113, 0x46761CD1, 0x46765893,
 0x46769458, 0x4676D020, 0x46770BED, 0x467747BC,
 0x46778390, 0x4677BF67, 0x4677FB42, 0x46783720,
 0x46787302, 0x4678AEE8, 0x4678EAD1, 0x467926BE,
 0x467962AE, 0x46799EA2, 0x4679DA9A, 0x467A1695,
 0x467A5294, 0x467A8E96, 0x467ACA9C, 0x467B06A6,
 0x467B42B3, 0x467B7EC4, 0x467BBAD8, 0x467BF6F0,
 0x467C330C, 0x467C6F2B, 0x467CAB4E, 0x467CE774,
 0x467D239E, 0x467D5FCB, 0x467D9BFC, 0x467DD831,
 0x467E1469, 0x467E50A5, 0x467E8CE4, 0x467EC927,
 0x467F056D, 0x467F41B7, 0x467F7E05, 0x467FBA56,
 0x467FF6AB, 0x46801981, 0x468037AF, 0x468055DF,
 0x46807410, 0x46809244, 0x4680B079, 0x4680CEAF,
 0x4680ECE8, 0x46810B22, 0x4681295E, 0x4681479C,
 0x468165DC, 0x4681841D, 0x4681A260, 0x4681C0A5,
 0x4681DEEC, 0x4681FD34, 0x46821B7E, 0x468239CA,
 0x46825818, 0x46827668, 0x468294B9, 0x4682B30C,
 0x4682D161, 0x4682EFB7, 0x46830E0F, 0x46832C6A,
 0x46834AC5, 0x46836923, 0x46838782, 0x4683A5E3,
 0x4683C446, 0x4683E2AB, 0x46840111, 0x46841F79,
 0x46843DE3, 0x46845C4E, 0x46847ABC, 0x4684992B,
 0x4684B79C, 0x4684D60E, 0x4684F483, 0x468512F9,
 0x46853170, 0x46854FEA, 0x46856E65, 0x46858CE2,
 0x4685AB61, 0x4685C9E1, 0x4685E864, 0x468606E8,
 0x4686256D, 0x468643F5, 0x4686627E, 0x46868109,
 0x46869F96, 0x4686BE24, 0x4686DCB4, 0x4686FB46,
 0x468719DA, 0x4687386F, 0x46875706, 0x4687759F,
 0x46879439, 0x4687B2D5, 0x4687D173, 0x4687F013,
 0x46880EB4, 0x46882D58, 0x46884BFC, 0x46886AA3,
 0x4688894B, 0x4688A7F5, 0x4688C6A1, 0x4688E54F,
 0x468903FE, 0x468922AF, 0x46894161, 0x46896016,
 0x46897ECC, 0x46899D83, 0x4689BC3D, 0x4689DAF8,
 0x4689F9B5, 0x468A1874, 0x468A3734, 0x468A55F6,
 0x468A74BA, 0x468A937F, 0x468AB246, 0x468AD10F,
 0x468AEFDA, 0x468B0EA6, 0x468B2D74, 0x468B4C44,
 0x468B6B15, 0x468B89E8, 0x468BA8BD, 0x468BC794,
 0x468BE66C, 0x468C0546, 0x468C2421, 0x468C42FF,
 0x468C61DE, 0x468C80BE, 0x468C9FA1, 0x468CBE85,
 0x468CDD6B, 0x468CFC52, 0x468D1B3B, 0x468D3A26,
 0x468D5913, 0x468D7801, 0x468D96F1, 0x468DB5E3,
 0x468DD4D6, 0x468DF3CB, 0x468E12C2, 0x468E31BA,
 0x468E50B4, 0x468E6FB0, 0x468E8EAD, 0x468EADAD,
 0x468ECCAD, 0x468EEBB0, 0x468F0AB4, 0x468F29BA,
 0x468F48C2, 0x468F67CB, 0x468F86D6, 0x468FA5E2,
 0x468FC4F1, 0x468FE401, 0x46900312, 0x46902225,
 0x4690413A, 0x46906051, 0x46907F69, 0x46909E83,
 0x4690BD9F, 0x4690DCBC, 0x4690FBDB, 0x46911AFC,
 0x46913A1E, 0x46915942, 0x46917868, 0x46919790,
 0x4691B6B9, 0x4691D5E3, 0x4691F510, 0x4692143E,
 0x4692336D, 0x4692529F, 0x469271D2, 0x46929106,
 0x4692B03D, 0x4692CF75, 0x4692EEAE, 0x46930DEA,
 0x46932D27, 0x46934C65, 0x46936BA6, 0x46938AE8,
 0x4693AA2B, 0x4693C970, 0x4693E8B7, 0x46940800,
 0x4694274A, 0x46944696, 0x469465E3, 0x46948533,
 0x4694A483, 0x4694C3D6, 0x4694E32A, 0x46950280,
 0x469521D7, 0x46954130, 0x4695608B, 0x46957FE7,
 0x46959F45, 0x4695BEA5, 0x4695DE06, 0x4695FD69,
 0x46961CCE, 0x46963C34, 0x46965B9C, 0x46967B05,
 0x46969A71, 0x4696B9DD, 0x4696D94C, 0x4696F8BC,
 0x4697182D, 0x469737A1, 0x46975716, 0x4697768C,
 0x46979605, 0x4697B57E, 0x4697D4FA, 0x4697F477,
 0x469813F6, 0x46983376, 0x469852F8, 0x4698727C,
 0x46989201, 0x4698B188, 0x4698D111, 0x4698F09B,
 0x46991027, 0x46992FB4, 0x46994F43, 0x46996ED4,
 0x46998E66, 0x4699ADFA, 0x4699CD8F, 0x4699ED27,
 0x469A0CBF, 0x469A2C5A, 0x469A4BF6, 0x469A6B93,
 0x469A8B33, 0x469AAAD4, 0x469ACA76, 0x469AEA1A,
 0x469B09C0, 0x469B2967, 0x469B4910, 0x469B68BB,
 0x469B8867, 0x469BA815, 0x469BC7C4, 0x469BE775,
 0x469C0728, 0x469C26DC, 0x469C4692, 0x469C6649,
 0x469C8602, 0x469CA5BD, 0x469CC579, 0x469CE537,
 0x469D04F7, 0x469D24B8, 0x469D447B, 0x469D643F,
 0x469D8405, 0x469DA3CC, 0x469DC395, 0x469DE360,
 0x469E032C, 0x469E22FA, 0x469E42CA, 0x469E629B,
 0x469E826E, 0x469EA242, 0x469EC218, 0x469EE1EF,
 0x469F01C9, 0x469F21A3, 0x469F4180, 0x469F615D,
 0x469F813D, 0x469FA11E, 0x469FC101, 0x469FE0E5,
 0x46A000CB, 0x46A020B2, 0x46A0409B, 0x46A06086,
 0x46A08072, 0x46A0A060, 0x46A0C04F, 0x46A0E040,
 0x46A10033, 0x46A12027, 0x46A1401C, 0x46A16014,
 0x46A1800D, 0x46A1A007, 0x46A1C003, 0x46A1E001,
 0x46A20000, 0x46A22001, 0x46A24003, 0x46A26007,
 0x46A2800D, 0x46A2A014, 0x46A2C01C, 0x46A2E027,
 0x46A30033, 0x46A32040, 0x46A3404F, 0x46A3605F,
 0x46A38072, 0x46A3A085, 0x46A3C09B, 0x46A3E0B1,
 0x46A400CA, 0x46A420E4, 0x46A440FF, 0x46A4611D,
 0x46A4813B, 0x46A4A15C, 0x46A4C17D, 0x46A4E1A1,
 0x46A501C6, 0x46A521EC, 0x46A54214, 0x46A5623E,
 0x46A58269, 0x46A5A296, 0x46A5C2C4, 0x46A5E2F4,
 0x46A60326, 0x46A62359, 0x46A6438D, 0x46A663C4,
 0x46A683FB, 0x46A6A435, 0x46A6C46F, 0x46A6E4AC,
 0x46A704EA, 0x46A72529, 0x46A7456A, 0x46A765AD,
 0x46A785F1, 0x46A7A637, 0x46A7C67E, 0x46A7E6C7,
 0x46A80711, 0x46A8275D, 0x46A847AB, 0x46A867FA,
 0x46A8884A, 0x46A8A89D, 0x46A8C8F0, 0x46A8E945,
 0x46A9099C, 0x46A929F5, 0x46A94A4E, 0x46A96AAA,
 0x46A98B07, 0x46A9AB65, 0x46A9CBC5, 0x46A9EC27,
 0x46AA0C8A, 0x46AA2CEF, 0x46AA4D55, 0x46AA6DBD,
 0x46AA8E26, 0x46AAAE91, 0x46AACEFD, 0x46AAEF6B,
 0x46AB0FDB, 0x46AB304C, 0x46AB50BE, 0x46AB7132,
 0x46AB91A8, 0x46ABB21F, 0x46ABD298, 0x46ABF312,
 0x46AC138E, 0x46AC340B, 0x46AC548A, 0x46AC750A,
 0x46AC958C, 0x46ACB60F, 0x46ACD694, 0x46ACF71B,
 0x46AD17A3, 0x46AD382C, 0x46AD58B7, 0x46AD7944,
 0x46AD99D2, 0x46ADBA62, 0x46ADDAF3, 0x46ADFB86,
 0x46AE1C1A, 0x46AE3CB0, 0x46AE5D47, 0x46AE7DE0,
 0x46AE9E7A, 0x46AEBF16, 0x46AEDFB3, 0x46AF0052,
 0x46AF20F2, 0x46AF4194, 0x46AF6238, 0x46AF82DD,
 0x46AFA383, 0x46AFC42B, 0x46AFE4D5, 0x46B00580,
 0x46B0262C, 0x46B046DA, 0x46B0678A, 0x46B0883B,
 0x46B0A8EE, 0x46B0C9A2, 0x46B0EA57, 0x46B10B0E,
 0x46B12BC7, 0x46B14C81, 0x46B16D3D, 0x46B18DFA,
 0x46B1AEB9, 0x46B1CF79, 0x46B1F03B, 0x46B210FE,
 0x46B231C3, 0x46B25289, 0x46B27351, 0x46B2941A,
 0x46B2B4E5, 0x46B2D5B1, 0x46B2F67F, 0x46B3174E,
 0x46B3381F, 0x46B358F1, 0x46B379C5, 0x46B39A9A,
 0x46B3BB71, 0x46B3DC49, 0x46B3FD23, 0x46B41DFE,
 0x46B43EDB, 0x46B45FB9, 0x46B48099, 0x46B4A17A,
 0x46B4C25D, 0x46B4E341, 0x46B50427, 0x46B5250E,
 0x46B545F7, 0x46B566E1, 0x46B587CD, 0x46B5A8BA,
 0x46B5C9A9, 0x46B5EA99, 0x46B60B8A, 0x46B62C7E,
 0x46B64D72, 0x46B66E68, 0x46B68F60, 0x46B6B059,
 0x46B6D154, 0x46B6F250, 0x46B7134E, 0x46B7344D,
 0x46B7554D, 0x46B7764F, 0x46B79753, 0x46B7B858,
 0x46B7D95E, 0x46B7FA66, 0x46B81B70, 0x46B83C7B,
 0x46B85D87, 0x46B87E95, 0x46B89FA5, 0x46B8C0B5,
 0x46B8E1C8, 0x46B902DC, 0x46B923F1, 0x46B94508,
 0x46B96620, 0x46B9873A, 0x46B9A855, 0x46B9C972,
 0x46B9EA90, 0x46BA0BB0, 0x46BA2CD1, 0x46BA4DF3,
 0x46BA6F17, 0x46BA903D, 0x46BAB164, 0x46BAD28C,
 0x46BAF3B6, 0x46BB14E2, 0x46BB360F, 0x46BB573D,
 0x46BB786D, 0x46BB999E, 0x46BBBAD1, 0x46BBDC05,
 0x46BBFD3B, 0x46BC1E72, 0x46BC3FAB, 0x46BC60E5,
 0x46BC8221, 0x46BCA35E, 0x46BCC49C, 0x46BCE5DC,
 0x46BD071E, 0x46BD2861, 0x46BD49A5, 0x46BD6AEB,
 0x46BD8C32, 0x46BDAD7B, 0x46BDCEC5, 0x46BDF011,
 0x46BE115E, 0x46BE32AC, 0x46BE53FC, 0x46BE754E,
 0x46BE96A1, 0x46BEB7F5, 0x46BED94B, 0x46BEFAA3,
 0x46BF1BFB, 0x46BF3D56, 0x46BF5EB1, 0x46BF800E,
 0x46BFA16D, 0x46BFC2CD, 0x46BFE42F, 0x46C00592,
 0x46C026F6, 0x46C0485C, 0x46C069C3, 0x46C08B2C,
 0x46C0AC96, 0x46C0CE02, 0x46C0EF6F, 0x46C110DE,
 0x46C1324E, 0x46C153BF, 0x46C17532, 0x46C196A6,
 0x46C1B81C, 0x46C1D993, 0x46C1FB0C, 0x46C21C86,
 0x46C23E02, 0x46C25F7F, 0x46C280FD, 0x46C2A27D,
 0x46C2C3FE, 0x46C2E581, 0x46C30705, 0x46C3288B,
 0x46C34A12, 0x46C36B9B, 0x46C38D25, 0x46C3AEB0,
 0x46C3D03D, 0x46C3F1CB, 0x46C4135B, 0x46C434EC,
 0x46C4567F, 0x46C47813, 0x46C499A8, 0x46C4BB3F,
 0x46C4DCD8, 0x46C4FE71, 0x46C5200D, 0x46C541A9,
 0x46C56347, 0x46C584E7, 0x46C5A688, 0x46C5C82A,
 0x46C5E9CE, 0x46C60B73, 0x46C62D1A, 0x46C64EC2,
 0x46C6706B, 0x46C69216, 0x46C6B3C3, 0x46C6D570,
 0x46C6F720, 0x46C718D0, 0x46C73A82, 0x46C75C36,
 0x46C77DEB, 0x46C79FA1, 0x46C7C159, 0x46C7E312,
 0x46C804CD, 0x46C82689, 0x46C84846, 0x46C86A05,
 0x46C88BC5, 0x46C8AD87, 0x46C8CF4A, 0x46C8F10F,
 0x46C912D5, 0x46C9349C, 0x46C95665, 0x46C9782F,
 0x46C999FB, 0x46C9BBC8, 0x46C9DD97, 0x46C9FF66,
 0x46CA2138, 0x46CA430A, 0x46CA64DF, 0x46CA86B4,
 0x46CAA88B, 0x46CACA64, 0x46CAEC3D, 0x46CB0E19,
 0x46CB2FF5, 0x46CB51D3, 0x46CB73B3, 0x46CB9593,
 0x46CBB776, 0x46CBD959, 0x46CBFB3F, 0x46CC1D25,
 0x46CC3F0D, 0x46CC60F6, 0x46CC82E1, 0x46CCA4CD,
 0x46CCC6BB, 0x46CCE8A9, 0x46CD0A9A, 0x46CD2C8C,
 0x46CD4E7F, 0x46CD7073, 0x46CD9269, 0x46CDB461,
 0x46CDD659, 0x46CDF853, 0x46CE1A4F, 0x46CE3C4C,
 0x46CE5E4A, 0x46CE804A, 0x46CEA24B, 0x46CEC44E,
 0x46CEE652, 0x46CF0857, 0x46CF2A5E, 0x46CF4C66,
 0x46CF6E70, 0x46CF907B, 0x46CFB287, 0x46CFD495,
 0x46CFF6A4, 0x46D018B4, 0x46D03AC6, 0x46D05CD9,
 0x46D07EEE, 0x46D0A104, 0x46D0C31C, 0x46D0E535,
 0x46D1074F, 0x46D1296B, 0x46D14B88, 0x46D16DA6,
 0x46D18FC6, 0x46D1B1E7, 0x46D1D40A, 0x46D1F62E,
 0x46D21853, 0x46D23A7A, 0x46D25CA2, 0x46D27ECC,
 0x46D2A0F7, 0x46D2C323, 0x46D2E551, 0x46D30780,
 0x46D329B0, 0x46D34BE2, 0x46D36E15, 0x46D3904A,
 0x46D3B280, 0x46D3D4B7, 0x46D3F6F0, 0x46D4192A,
 0x46D43B66, 0x46D45DA3, 0x46D47FE1, 0x46D4A221,
 0x46D4C462, 0x46D4E6A4, 0x46D508E8, 0x46D52B2D,
 0x46D54D74, 0x46D56FBC, 0x46D59205, 0x46D5B450,
 0x46D5D69C, 0x46D5F8E9, 0x46D61B38, 0x46D63D88,
 0x46D65FDA, 0x46D6822D, 0x46D6A481, 0x46D6C6D7,
 0x46D6E92E, 0x46D70B87, 0x46D72DE0, 0x46D7503C,
 0x46D77298, 0x46D794F6, 0x46D7B755, 0x46D7D9B6,
 0x46D7FC18, 0x46D81E7B, 0x46D840E0, 0x46D86346,
 0x46D885AE, 0x46D8A817, 0x46D8CA81, 0x46D8ECED,
 0x46D90F5A, 0x46D931C8, 0x46D95438, 0x46D976A9,
 0x46D9991B, 0x46D9BB8F, 0x46D9DE04, 0x46DA007B,
 0x46DA22F2, 0x46DA456C, 0x46DA67E6, 0x46DA8A62,
 0x46DAACE0, 0x46DACF5E, 0x46DAF1DE, 0x46DB1460,
 0x46DB36E3, 0x46DB5967, 0x46DB7BEC, 0x46DB9E73,
 0x46DBC0FB, 0x46DBE385, 0x46DC0610, 0x46DC289C,
 0x46DC4B2A, 0x46DC6DB9, 0x46DC9049, 0x46DCB2DB,
 0x46DCD56E, 0x46DCF802, 0x46DD1A98, 0x46DD3D2F,
 0x46DD5FC7, 0x46DD8261, 0x46DDA4FC, 0x46DDC799,
 0x46DDEA37, 0x46DE0CD6, 0x46DE2F76, 0x46DE5218,
 0x46DE74BC, 0x46DE9760, 0x46DEBA06, 0x46DEDCAD,
 0x46DEFF56, 0x46DF2200, 0x46DF44AB, 0x46DF6758,
 0x46DF8A06, 0x46DFACB5, 0x46DFCF66, 0x46DFF218,
 0x46E014CC, 0x46E03780, 0x46E05A36, 0x46E07CEE,
 0x46E09FA7, 0x46E0C261, 0x46E0E51C, 0x46E107D9,
 0x46E12A97, 0x46E14D57, 0x46E17018, 0x46E192DA,
 0x46E1B59D, 0x46E1D862, 0x46E1FB28, 0x46E21DF0,
 0x46E240B9, 0x46E26383, 0x46E2864E, 0x46E2A91B,
 0x46E2CBE9, 0x46E2EEB9, 0x46E3118A, 0x46E3345C,
 0x46E35730, 0x46E37A05, 0x46E39CDB, 0x46E3BFB2,
 0x46E3E28B, 0x46E40565, 0x46E42841, 0x46E44B1E,
 0x46E46DFC, 0x46E490DC, 0x46E4B3BC, 0x46E4D69F,
 0x46E4F982, 0x46E51C67, 0x46E53F4D, 0x46E56235,
 0x46E5851E, 0x46E5A808, 0x46E5CAF3, 0x46E5EDE0,
 0x46E610CE, 0x46E633BE, 0x46E656AE, 0x46E679A1,
 0x46E69C94, 0x46E6BF89, 0x46E6E27F, 0x46E70576,
 0x46E7286F, 0x46E74B69, 0x46E76E65, 0x46E79161,
 0x46E7B45F, 0x46E7D75F, 0x46E7FA5F, 0x46E81D61,
 0x46E84065, 0x46E86369, 0x46E8866F, 0x46E8A976,
 0x46E8CC7F, 0x46E8EF89, 0x46E91294, 0x46E935A1,
 0x46E958AF, 0x46E97BBE, 0x46E99ECE, 0x46E9C1E0,
 0x46E9E4F3, 0x46EA0808, 0x46EA2B1D, 0x46EA4E35,
 0x46EA714D, 0x46EA9467, 0x46EAB782, 0x46EADA9E,
 0x46EAFDBC, 0x46EB20DB, 0x46EB43FB, 0x46EB671C,
 0x46EB8A3F, 0x46EBAD64, 0x46EBD089, 0x46EBF3B0,
 0x46EC16D8, 0x46EC3A01, 0x46EC5D2C, 0x46EC8058,
 0x46ECA386, 0x46ECC6B4, 0x46ECE9E4, 0x46ED0D16,
 0x46ED3048, 0x46ED537C, 0x46ED76B1, 0x46ED99E8,
 0x46EDBD20, 0x46EDE059, 0x46EE0393, 0x46EE26CF,
 0x46EE4A0C, 0x46EE6D4A, 0x46EE908A, 0x46EEB3CB,
 0x46EED70D, 0x46EEFA50, 0x46EF1D95, 0x46EF40DB,
 0x46EF6423, 0x46EF876C, 0x46EFAAB6, 0x46EFCE01,
 0x46EFF14E, 0x46F0149C, 0x46F037EB, 0x46F05B3B,
 0x46F07E8D, 0x46F0A1E0, 0x46F0C535, 0x46F0E88A,
 0x46F10BE1, 0x46F12F3A, 0x46F15293, 0x46F175EE,
 0x46F1994A, 0x46F1BCA8, 0x46F1E007, 0x46F20367,
 0x46F226C8, 0x46F24A2B, 0x46F26D8F, 0x46F290F4,
 0x46F2B45B, 0x46F2D7C2, 0x46F2FB2B, 0x46F31E96,
 0x46F34202, 0x46F3656F, 0x46F388DD, 0x46F3AC4C,
 0x46F3CFBD, 0x46F3F32F, 0x46F416A3, 0x46F43A18,
 0x46F45D8E, 0x46F48105, 0x46F4A47D, 0x46F4C7F7,
 0x46F4EB72, 0x46F50EEF, 0x46F5326D, 0x46F555EC,
 0x46F5796C, 0x46F59CED, 0x46F5C070, 0x46F5E3F4,
 0x46F6077A, 0x46F62B01, 0x46F64E89, 0x46F67212,
 0x46F6959C, 0x46F6B928, 0x46F6DCB5, 0x46F70044,
 0x46F723D3, 0x46F74764, 0x46F76AF7, 0x46F78E8A,
 0x46F7B21F, 0x46F7D5B5, 0x46F7F94C, 0x46F81CE5,
 0x46F8407F, 0x46F8641A, 0x46F887B6, 0x46F8AB54,
 0x46F8CEF3, 0x46F8F293, 0x46F91635, 0x46F939D8,
 0x46F95D7C, 0x46F98121, 0x46F9A4C8, 0x46F9C870,
 0x46F9EC19, 0x46FA0FC3, 0x46FA336F, 0x46FA571C,
 0x46FA7ACA, 0x46FA9E7A, 0x46FAC22B, 0x46FAE5DD,
 0x46FB0990, 0x46FB2D45, 0x46FB50FB, 0x46FB74B2,
 0x46FB986A, 0x46FBBC24, 0x46FBDFDF, 0x46FC039B,
 0x46FC2759, 0x46FC4B17, 0x46FC6ED8, 0x46FC9299,
 0x46FCB65B, 0x46FCDA1F, 0x46FCFDE4, 0x46FD21AB,
 0x46FD4572, 0x46FD693B, 0x46FD8D05, 0x46FDB0D1,
 0x46FDD49D, 0x46FDF86B, 0x46FE1C3B, 0x46FE400B,
 0x46FE63DD, 0x46FE87B0, 0x46FEAB84, 0x46FECF5A,
 0x46FEF330, 0x46FF1708, 0x46FF3AE2, 0x46FF5EBC,
 0x46FF8298, 0x46FFA675, 0x46FFCA53, 0x46FFEE33,
 0x4700090A, 0x47001AFB, 0x47002CED, 0x47003EDF,
 0x470050D2, 0x470062C5, 0x470074BA, 0x470086AE,
 0x470098A4, 0x4700AA9A, 0x4700BC91, 0x4700CE88,
 0x4700E080, 0x4700F278, 0x47010472, 0x4701166B,
 0x47012866, 0x47013A61, 0x47014C5D, 0x47015E59,
 0x47017056, 0x47018254, 0x47019452, 0x4701A651,
 0x4701B850, 0x4701CA50, 0x4701DC51, 0x4701EE52,
 0x47020054, 0x47021257, 0x4702245A, 0x4702365E,
 0x47024862, 0x47025A67, 0x47026C6D, 0x47027E73,
 0x4702907A, 0x4702A282, 0x4702B48A, 0x4702C693,
 0x4702D89C, 0x4702EAA6, 0x4702FCB1, 0x47030EBC,
 0x470320C8, 0x470332D5, 0x470344E2, 0x470356EF,
 0x470368FE, 0x47037B0D, 0x47038D1C, 0x47039F2D,
 0x4703B13E, 0x4703C34F, 0x4703D561, 0x4703E774,
 0x4703F987, 0x47040B9B, 0x47041DB0, 0x47042FC5,
 0x470441DB, 0x470453F1, 0x47046608, 0x47047820,
 0x47048A38, 0x47049C51, 0x4704AE6B, 0x4704C085,
 0x4704D2A0, 0x4704E4BB, 0x4704F6D7, 0x470508F4,
 0x47051B11, 0x47052D2F, 0x47053F4D, 0x4705516C,
 0x4705638C, 0x470575AC, 0x470587CD, 0x470599EF,
 0x4705AC11, 0x4705BE34, 0x4705D057, 0x4705E27B,
 0x4705F4A0, 0x470606C5, 0x470618EB, 0x47062B11,
 0x47063D38, 0x47064F60, 0x47066188, 0x470673B1,
 0x470685DB, 0x47069805, 0x4706AA30, 0x4706BC5B,
 0x4706CE87, 0x4706E0B4, 0x4706F2E1, 0x4707050F,
 0x4707173D, 0x4707296C, 0x47073B9C, 0x47074DCC,
 0x47075FFD, 0x4707722F, 0x47078461, 0x47079693,
 0x4707A8C7, 0x4707BAFB, 0x4707CD2F, 0x4707DF64,
 0x4707F19A, 0x470803D0, 0x47081607, 0x4708283F,
 0x47083A77, 0x47084CB0, 0x47085EE9, 0x47087123,
 0x4708835E, 0x47089599, 0x4708A7D5, 0x4708BA12,
 0x4708CC4F, 0x4708DE8C, 0x4708F0CB, 0x4709030A,
 0x47091549, 0x47092789, 0x470939CA, 0x47094C0B,
 0x47095E4D, 0x47097090, 0x470982D3, 0x47099517,
 0x4709A75B, 0x4709B9A0, 0x4709CBE5, 0x4709DE2C,
 0x4709F072, 0x470A02BA, 0x470A1502, 0x470A274A,
 0x470A3994, 0x470A4BDD, 0x470A5E28, 0x470A7073,
 0x470A82BE, 0x470A950B, 0x470AA757, 0x470AB9A5,
 0x470ACBF3, 0x470ADE42, 0x470AF091, 0x470B02E1,
 0x470B1531, 0x470B2782, 0x470B39D4, 0x470B4C26,
 0x470B5E79, 0x470B70CC, 0x470B8320, 0x470B9575,
 0x470BA7CA, 0x470BBA20, 0x470BCC77, 0x470BDECE,
 0x470BF125, 0x470C037E, 0x470C15D7, 0x470C2830,
 0x470C3A8A, 0x470C4CE5, 0x470C5F40, 0x470C719C,
 0x470C83F8, 0x470C9656, 0x470CA8B3, 0x470CBB12,
 0x470CCD70, 0x470CDFD0, 0x470CF230, 0x470D0491,
 0x470D16F2, 0x470D2954, 0x470D3BB6, 0x470D4E19,
 0x470D607D, 0x470D72E1, 0x470D8546, 0x470D97AC,
 0x470DAA12, 0x470DBC78, 0x470DCEE0, 0x470DE147,
 0x470DF3B0, 0x470E0619, 0x470E1883, 0x470E2AED,
 0x470E3D58, 0x470E4FC3, 0x470E622F, 0x470E749C,
 0x470E8709, 0x470E9977, 0x470EABE5, 0x470EBE54,
 0x470ED0C4, 0x470EE334, 0x470EF5A5, 0x470F0816,
 0x470F1A88, 0x470F2CFB, 0x470F3F6E, 0x470F51E2,
 0x470F6456, 0x470F76CB, 0x470F8940, 0x470F9BB7,
 0x470FAE2D, 0x470FC0A5, 0x470FD31D, 0x470FE595,
 0x470FF80E, 0x47100A88, 0x47101D02, 0x47102F7D,
 0x471041F8, 0x47105475, 0x471066F1, 0x4710796E,
 0x47108BEC, 0x47109E6B, 0x4710B0EA, 0x4710C369,
 0x4710D5EA, 0x4710E86A, 0x4710FAEC, 0x47110D6E,
 0x47111FF0, 0x47113273, 0x471144F7, 0x4711577B,
 0x47116A00, 0x47117C86, 0x47118F0C, 0x4711A193,
 0x4711B41A, 0x4711C6A2, 0x4711D92A, 0x4711EBB3,
 0x4711FE3D, 0x471210C7, 0x47122352, 0x471235DE,
 0x47124869, 0x47125AF6, 0x47126D83, 0x47128011,
 0x4712929F, 0x4712A52E, 0x4712B7BE, 0x4712CA4E,
 0x4712DCDF, 0x4712EF70, 0x47130202, 0x47131494,
 0x47132727, 0x471339BB, 0x47134C4F, 0x47135EE4,
 0x47137179, 0x4713840F, 0x471396A6, 0x4713A93D,
 0x4713BBD5, 0x4713CE6D, 0x4713E106, 0x4713F39F,
 0x47140639, 0x471418D4, 0x47142B6F, 0x47143E0B,
 0x471450A8, 0x47146344, 0x471475E2, 0x47148880,
 0x47149B1F, 0x4714ADBE, 0x4714C05E, 0x4714D2FF,
 0x4714E5A0, 0x4714F841, 0x47150AE4, 0x47151D86,
 0x4715302A, 0x471542CE, 0x47155572, 0x47156818,
 0x47157ABD, 0x47158D64, 0x4715A00A, 0x4715B2B2,
 0x4715C55A, 0x4715D803, 0x4715EAAC, 0x4715FD56,
 0x47161000, 0x471622AB, 0x47163556, 0x47164803,
 0x47165AAF, 0x47166D5D, 0x4716800A, 0x471692B9,
 0x4716A568, 0x4716B817, 0x4716CAC8, 0x4716DD78,
 0x4716F02A, 0x471702DC, 0x4717158E, 0x47172841,
 0x47173AF5, 0x47174DA9, 0x4717605E, 0x47177313,
 0x471785C9, 0x47179880, 0x4717AB37, 0x4717BDEF,
 0x4717D0A7, 0x4717E360, 0x4717F619, 0x471808D3,
 0x47181B8E, 0x47182E49, 0x47184105, 0x471853C1,
 0x4718667E, 0x4718793B, 0x47188BF9, 0x47189EB8,
 0x4718B177, 0x4718C437, 0x4718D6F7, 0x4718E9B8,
 0x4718FC7A, 0x47190F3C, 0x471921FE, 0x471934C1,
 0x47194785, 0x47195A4A, 0x47196D0F, 0x47197FD4,
 0x4719929A, 0x4719A561, 0x4719B828, 0x4719CAF0,
 0x4719DDB8, 0x4719F081, 0x471A034B, 0x471A1615,
 0x471A28DF, 0x471A3BAB, 0x471A4E77, 0x471A6143,
 0x471A7410, 0x471A86DD, 0x471A99AC, 0x471AAC7A,
 0x471ABF49, 0x471AD219, 0x471AE4EA, 0x471AF7BB,
 0x471B0A8C, 0x471B1D5E, 0x471B3031, 0x471B4304,
 0x471B55D8, 0x471B68AC, 0x471B7B81, 0x471B8E57,
 0x471BA12D, 0x471BB404, 0x471BC6DB, 0x471BD9B3,
 0x471BEC8B, 0x471BFF64, 0x471C123E, 0x471C2518,
 0x471C37F2, 0x471C4ACD, 0x471C5DA9, 0x471C7086,
 0x471C8363, 0x471C9640, 0x471CA91E, 0x471CBBFD,
 0x471CCEDC, 0x471CE1BC, 0x471CF49C, 0x471D077D,
 0x471D1A5E, 0x471D2D40, 0x471D4023, 0x471D5306,
 0x471D65EA, 0x471D78CE, 0x471D8BB3, 0x471D9E99,
 0x471DB17F, 0x471DC465, 0x471DD74C, 0x471DEA34,
 0x471DFD1C, 0x471E1005, 0x471E22EF, 0x471E35D9,
 0x471E48C3, 0x471E5BAE, 0x471E6E9A, 0x471E8186,
 0x471E9473, 0x471EA760, 0x471EBA4E, 0x471ECD3D,
 0x471EE02C, 0x471EF31B, 0x471F060B, 0x471F18FC,
 0x471F2BEE, 0x471F3EDF, 0x471F51D2, 0x471F64C5,
 0x471F77B8, 0x471F8AAD, 0x471F9DA1, 0x471FB096,
 0x471FC38C, 0x471FD683, 0x471FE97A, 0x471FFC71,
 0x47200F69, 0x47202262, 0x4720355B, 0x47204855,
 0x47205B4F, 0x47206E4A, 0x47208145, 0x47209441,
 0x4720A73E, 0x4720BA3B, 0x4720CD39, 0x4720E037,
 0x4720F336, 0x47210635, 0x47211935, 0x47212C36,
 0x47213F37, 0x47215238, 0x4721653A, 0x4721783D,
 0x47218B40, 0x47219E44, 0x4721B149, 0x4721C44E,
 0x4721D753, 0x4721EA59, 0x4721FD60, 0x47221067,
 0x4722236F, 0x47223677, 0x47224980, 0x47225C89,
 0x47226F93, 0x4722829E, 0x472295A9, 0x4722A8B5,
 0x4722BBC1, 0x4722CECE, 0x4722E1DB, 0x4722F4E9,
 0x472307F7, 0x47231B06, 0x47232E16, 0x47234126,
 0x47235437, 0x47236748, 0x47237A5A, 0x47238D6C,
 0x4723A07F, 0x4723B392, 0x4723C6A6, 0x4723D9BB,
 0x4723ECD0, 0x4723FFE6, 0x472412FC, 0x47242613,
 0x4724392A, 0x47244C42, 0x47245F5A, 0x47247273,
 0x4724858D, 0x472498A7, 0x4724ABC2, 0x4724BEDD,
 0x4724D1F9, 0x4724E515, 0x4724F832, 0x47250B4F,
 0x47251E6D, 0x4725318C, 0x472544AB, 0x472557CB,
 0x47256AEB, 0x47257E0C, 0x4725912D, 0x4725A44F,
 0x4725B771, 0x4725CA94, 0x4725DDB8, 0x4725F0DC,
 0x47260400, 0x47261726, 0x47262A4B, 0x47263D72,
 0x47265098, 0x472663C0, 0x472676E8, 0x47268A10,
 0x47269D39, 0x4726B063, 0x4726C38D, 0x4726D6B8,
 0x4726E9E3, 0x4726FD0F, 0x4727103B, 0x47272368,
 0x47273695, 0x472749C3, 0x47275CF2, 0x47277021,
 0x47278351, 0x47279681, 0x4727A9B2, 0x4727BCE3,
 0x4727D015, 0x4727E347, 0x4727F67A, 0x472809AE,
 0x47281CE2, 0x47283016, 0x4728434B, 0x47285681,
 0x472869B7, 0x47287CEE, 0x47289025, 0x4728A35D,
 0x4728B696, 0x4728C9CF, 0x4728DD08, 0x4728F042,
 0x4729037D, 0x472916B8, 0x472929F4, 0x47293D30,
 0x4729506D, 0x472963AA, 0x472976E8, 0x47298A26,
 0x47299D65, 0x4729B0A5, 0x4729C3E5, 0x4729D725,
 0x4729EA67, 0x4729FDA8, 0x472A10EB, 0x472A242D,
 0x472A3771, 0x472A4AB5, 0x472A5DF9, 0x472A713E,
 0x472A8484, 0x472A97CA, 0x472AAB10, 0x472ABE57,
 0x472AD19F, 0x472AE4E7, 0x472AF830, 0x472B0B79,
 0x472B1EC3, 0x472B320E, 0x472B4559, 0x472B58A4,
 0x472B6BF0, 0x472B7F3D, 0x472B928A, 0x472BA5D8,
 0x472BB926, 0x472BCC75, 0x472BDFC4, 0x472BF314,
 0x472C0664, 0x472C19B5, 0x472C2D07, 0x472C4059,
 0x472C53AB, 0x472C66FE, 0x472C7A52, 0x472C8DA6,
 0x472CA0FB, 0x472CB450, 0x472CC7A6, 0x472CDAFC,
 0x472CEE53, 0x472D01AB, 0x472D1502, 0x472D285B,
 0x472D3BB4, 0x472D4F0E, 0x472D6268, 0x472D75C2,
 0x472D891E, 0x472D9C79, 0x472DAFD6, 0x472DC333,
 0x472DD690, 0x472DE9EE, 0x472DFD4C, 0x472E10AB,
 0x472E240B, 0x472E376B, 0x472E4ACB, 0x472E5E2D,
 0x472E718E, 0x472E84F0, 0x472E9853, 0x472EABB7,
 0x472EBF1A, 0x472ED27F, 0x472EE5E4, 0x472EF949,
 0x472F0CAF, 0x472F2016, 0x472F337D, 0x472F46E4,
 0x472F5A4C, 0x472F6DB5, 0x472F811E, 0x472F9488,
 0x472FA7F2, 0x472FBB5D, 0x472FCEC8, 0x472FE234,
 0x472FF5A1, 0x4730090E, 0x47301C7B, 0x47302FE9,
 0x47304358, 0x473056C7, 0x47306A37, 0x47307DA7,
 0x47309118, 0x4730A489, 0x4730B7FB, 0x4730CB6D,
 0x4730DEE0, 0x4730F253, 0x473105C7, 0x4731193B,
 0x47312CB0, 0x47314026, 0x4731539C, 0x47316713,
 0x47317A8A, 0x47318E01, 0x4731A17A, 0x4731B4F2,
 0x4731C86C, 0x4731DBE5, 0x4731EF60, 0x473202DB,
 0x47321656, 0x473229D2, 0x47323D4E, 0x473250CB,
 0x47326449, 0x473277C7, 0x47328B46, 0x47329EC5,
 0x4732B244, 0x4732C5C5, 0x4732D945, 0x4732ECC6,
 0x47330048, 0x473313CB, 0x4733274D, 0x47333AD1,
 0x47334E55, 0x473361D9, 0x4733755E, 0x473388E4,
 0x47339C6A, 0x4733AFF0, 0x4733C377, 0x4733D6FF,
 0x4733EA87, 0x4733FE10, 0x47341199, 0x47342523,
 0x473438AD, 0x47344C38, 0x47345FC3, 0x4734734F,
 0x473486DB, 0x47349A68, 0x4734ADF6, 0x4734C184,
 0x4734D512, 0x4734E8A1, 0x4734FC31, 0x47350FC1,
 0x47352352, 0x473536E3, 0x47354A74, 0x47355E07,
 0x47357199, 0x4735852D, 0x473598C0, 0x4735AC55,
 0x4735BFE9, 0x4735D37F, 0x4735E715, 0x4735FAAB,
 0x47360E42, 0x473621DA, 0x47363572, 0x4736490A,
 0x47365CA3, 0x4736703D, 0x473683D7, 0x47369772,
 0x4736AB0D, 0x4736BEA8, 0x4736D245, 0x4736E5E1,
 0x4736F97F, 0x47370D1C, 0x473720BB, 0x4737345A,
 0x473747F9, 0x47375B99, 0x47376F39, 0x473782DA,
 0x4737967C, 0x4737AA1E, 0x4737BDC0, 0x4737D163,
 0x4737E507, 0x4737F8AB, 0x47380C50, 0x47381FF5,
 0x4738339A, 0x47384741, 0x47385AE7, 0x47386E8F,
 0x47388236, 0x473895DF, 0x4738A987, 0x4738BD31,
 0x4738D0DB, 0x4738E485, 0x4738F830, 0x47390BDB,
 0x47391F87, 0x47393334, 0x473946E1, 0x47395A8E,
 0x47396E3C, 0x473981EB, 0x4739959A, 0x4739A94A,
 0x4739BCFA, 0x4739D0AA, 0x4739E45B, 0x4739F80D,
 0x473A0BBF, 0x473A1F72, 0x473A3325, 0x473A46D9,
 0x473A5A8D, 0x473A6E42, 0x473A81F8, 0x473A95AD,
 0x473AA964, 0x473ABD1B, 0x473AD0D2, 0x473AE48A,
 0x473AF843, 0x473B0BFC, 0x473B1FB5, 0x473B336F,
 0x473B472A, 0x473B5AE5, 0x473B6EA0, 0x473B825C,
 0x473B9619, 0x473BA9D6, 0x473BBD94, 0x473BD152,
 0x473BE511, 0x473BF8D0, 0x473C0C90, 0x473C2050,
 0x473C3411, 0x473C47D2, 0x473C5B94, 0x473C6F56,
 0x473C8319, 0x473C96DC, 0x473CAAA0, 0x473CBE65,
 0x473CD229, 0x473CE5EF, 0x473CF9B5, 0x473D0D7B,
 0x473D2142, 0x473D350A, 0x473D48D2, 0x473D5C9A,
 0x473D7063, 0x473D842D, 0x473D97F7, 0x473DABC2,
 0x473DBF8D, 0x473DD358, 0x473DE725, 0x473DFAF1,
 0x473E0EBE, 0x473E228C, 0x473E365A, 0x473E4A29,
 0x473E5DF8, 0x473E71C8, 0x473E8598, 0x473E9969,
 0x473EAD3A, 0x473EC10C, 0x473ED4DF, 0x473EE8B1,
 0x473EFC85, 0x473F1059, 0x473F242D, 0x473F3802,
 0x473F4BD7, 0x473F5FAD, 0x473F7384, 0x473F875B,
 0x473F9B32, 0x473FAF0A, 0x473FC2E3, 0x473FD6BC,
 0x473FEA95, 0x473FFE6F, 0x4740124A, 0x47402625,
 0x47403A01, 0x47404DDD, 0x474061B9, 0x47407596,
 0x47408974, 0x47409D52, 0x4740B131, 0x4740C510,
 0x4740D8F0, 0x4740ECD0, 0x474100B1, 0x47411492,
 0x47412874, 0x47413C56, 0x47415039, 0x4741641C,
 0x47417800, 0x47418BE4, 0x47419FC9, 0x4741B3AE,
 0x4741C794, 0x4741DB7A, 0x4741EF61, 0x47420348,
 0x47421730, 0x47422B19, 0x47423F02, 0x474252EB,
 0x474266D5, 0x47427ABF, 0x47428EAA, 0x4742A296,
 0x4742B682, 0x4742CA6E, 0x4742DE5B, 0x4742F248,
 0x47430636, 0x47431A25, 0x47432E14, 0x47434203,
 0x474355F3, 0x474369E4, 0x47437DD5, 0x474391C7,
 0x4743A5B9, 0x4743B9AB, 0x4743CD9E, 0x4743E192,
 0x4743F586, 0x4744097B, 0x47441D70, 0x47443165,
 0x4744455B, 0x47445952, 0x47446D49, 0x47448141,
 0x47449539, 0x4744A932, 0x4744BD2B, 0x4744D124,
 0x4744E51F, 0x4744F919, 0x47450D14, 0x47452110,
 0x4745350C, 0x47454909, 0x47455D06, 0x47457104,
 0x47458502, 0x47459901, 0x4745AD00, 0x4745C100,
 0x4745D500, 0x4745E901, 0x4745FD02, 0x47461104,
 0x47462506, 0x47463909, 0x47464D0C, 0x47466110,
 0x47467514, 0x47468919, 0x47469D1F, 0x4746B124,
 0x4746C52B, 0x4746D932, 0x4746ED39, 0x47470141,
 0x47471549, 0x47472952, 0x47473D5B, 0x47475165,
 0x4747656F, 0x4747797A, 0x47478D86, 0x4747A191,
 0x4747B59E, 0x4747C9AB, 0x4747DDB8, 0x4747F1C6,
 0x474805D4, 0x474819E3, 0x47482DF2, 0x47484202,
 0x47485613, 0x47486A24, 0x47487E35, 0x47489247,
 0x4748A659, 0x4748BA6C, 0x4748CE80, 0x4748E293,
 0x4748F6A8, 0x47490ABD, 0x47491ED2, 0x474932E8,
 0x474946FE, 0x47495B15, 0x47496F2D, 0x47498345,
 0x4749975D, 0x4749AB76, 0x4749BF8F, 0x4749D3A9,
 0x4749E7C4, 0x4749FBDF, 0x474A0FFA, 0x474A2416,
 0x474A3832, 0x474A4C4F, 0x474A606D, 0x474A748B,
 0x474A88A9, 0x474A9CC8, 0x474AB0E7, 0x474AC507,
 0x474AD928, 0x474AED49, 0x474B016A, 0x474B158C,
 0x474B29AE, 0x474B3DD1, 0x474B51F5, 0x474B6619,
 0x474B7A3D, 0x474B8E62, 0x474BA287, 0x474BB6AD,
 0x474BCAD4, 0x474BDEFA, 0x474BF322, 0x474C074A,
 0x474C1B72, 0x474C2F9B, 0x474C43C4, 0x474C57EE,
 0x474C6C19, 0x474C8044, 0x474C946F, 0x474CA89B,
 0x474CBCC7, 0x474CD0F4, 0x474CE521, 0x474CF94F,
 0x474D0D7E, 0x474D21AC, 0x474D35DC, 0x474D4A0C,
 0x474D5E3C, 0x474D726D, 0x474D869E, 0x474D9AD0,
 0x474DAF02, 0x474DC335, 0x474DD768, 0x474DEB9C,
 0x474DFFD1, 0x474E1405, 0x474E283B, 0x474E3C70,
 0x474E50A7, 0x474E64DD, 0x474E7915, 0x474E8D4D,
 0x474EA185, 0x474EB5BE, 0x474EC9F7, 0x474EDE31,
 0x474EF26B, 0x474F06A6, 0x474F1AE1, 0x474F2F1D,
 0x474F4359, 0x474F5795, 0x474F6BD3, 0x474F8010,
 0x474F944F, 0x474FA88D, 0x474FBCCC, 0x474FD10C,
 0x474FE54C, 0x474FF98D, 0x47500DCE, 0x47502210,
 0x47503652, 0x47504A95, 0x47505ED8, 0x4750731B,
 0x4750875F, 0x47509BA4, 0x4750AFE9, 0x4750C42F,
 0x4750D875, 0x4750ECBB, 0x47510102, 0x4751154A,
 0x47512992, 0x47513DDB, 0x47515224, 0x4751666D,
 0x47517AB7, 0x47518F02, 0x4751A34D, 0x4751B798,
 0x4751CBE4, 0x4751E031, 0x4751F47E, 0x475208CB,
 0x47521D19, 0x47523167, 0x475245B6, 0x47525A06,
 0x47526E56, 0x475282A6, 0x475296F7, 0x4752AB48,
 0x4752BF9A, 0x4752D3ED, 0x4752E83F, 0x4752FC93,
 0x475310E7, 0x4753253B, 0x47533990, 0x47534DE5,
 0x4753623B, 0x47537691, 0x47538AE8, 0x47539F3F,
 0x4753B397, 0x4753C7EF, 0x4753DC48, 0x4753F0A1,
 0x475404FB, 0x47541955, 0x47542DB0, 0x4754420B,
 0x47545666, 0x47546AC2, 0x47547F1F, 0x4754937C,
 0x4754A7DA, 0x4754BC38, 0x4754D096, 0x4754E4F6,
 0x4754F955, 0x47550DB5, 0x47552216, 0x47553677,
 0x47554AD8, 0x47555F3A, 0x4755739D, 0x47558800,
 0x47559C63, 0x4755B0C7, 0x4755C52B, 0x4755D990,
 0x4755EDF6, 0x4756025C, 0x475616C2, 0x47562B29,
 0x47563F90, 0x475653F8, 0x47566860, 0x47567CC9,
 0x47569132, 0x4756A59C, 0x4756BA06, 0x4756CE71,
 0x4756E2DC, 0x4756F748, 0x47570BB4, 0x47572021,
 0x4757348E, 0x475748FC, 0x47575D6A, 0x475771D8,
 0x47578647, 0x47579AB7, 0x4757AF27, 0x4757C398,
 0x4757D809, 0x4757EC7A, 0x475800EC, 0x4758155F,
 0x475829D2, 0x47583E45, 0x475852B9, 0x4758672D,
 0x47587BA2, 0x47589018, 0x4758A48E, 0x4758B904,
 0x4758CD7B, 0x4758E1F2, 0x4758F66A, 0x47590AE2,
 0x47591F5B, 0x475933D4, 0x4759484E, 0x47595CC8,
 0x47597143, 0x475985BE, 0x47599A3A, 0x4759AEB6,
 0x4759C333, 0x4759D7B0, 0x4759EC2D, 0x475A00AB,
 0x475A152A, 0x475A29A9, 0x475A3E28, 0x475A52A8,
 0x475A6729, 0x475A7BAA, 0x475A902B, 0x475AA4AD,
 0x475AB930, 0x475ACDB2, 0x475AE236, 0x475AF6BA,
 0x475B0B3E, 0x475B1FC3, 0x475B3448, 0x475B48CE,
 0x475B5D54, 0x475B71DB, 0x475B8662, 0x475B9AEA,
 0x475BAF72, 0x475BC3FB, 0x475BD884, 0x475BED0D,
 0x475C0197, 0x475C1622, 0x475C2AAD, 0x475C3F38,
 0x475C53C4, 0x475C6851, 0x475C7CDE, 0x475C916B,
 0x475CA5F9, 0x475CBA88, 0x475CCF17, 0x475CE3A6,
 0x475CF836, 0x475D0CC6, 0x475D2157, 0x475D35E8,
 0x475D4A7A, 0x475D5F0C, 0x475D739F, 0x475D8832,
 0x475D9CC6, 0x475DB15A, 0x475DC5EE, 0x475DDA83,
 0x475DEF19, 0x475E03AF, 0x475E1846, 0x475E2CDD,
 0x475E4174, 0x475E560C, 0x475E6AA4, 0x475E7F3D,
 0x475E93D7, 0x475EA871, 0x475EBD0B, 0x475ED1A6,
 0x475EE641, 0x475EFADD, 0x475F0F79, 0x475F2416,
 0x475F38B3, 0x475F4D51, 0x475F61EF, 0x475F768D,
 0x475F8B2D, 0x475F9FCC, 0x475FB46C, 0x475FC90D,
 0x475FDDAE, 0x475FF24F, 0x476006F1, 0x47601B93,
 0x47603036, 0x476044DA, 0x4760597E, 0x47606E22,
 0x476082C7, 0x4760976C, 0x4760AC12, 0x4760C0B8,
 0x4760D55F, 0x4760EA06, 0x4760FEAE, 0x47611356,
 0x476127FE, 0x47613CA7, 0x47615151, 0x476165FB,
 0x47617AA5, 0x47618F50, 0x4761A3FC, 0x4761B8A8,
 0x4761CD54, 0x4761E201, 0x4761F6AE, 0x47620B5C,
 0x4762200A, 0x476234B9, 0x47624968, 0x47625E18,
 0x476272C8, 0x47628779, 0x47629C2A, 0x4762B0DB,
 0x4762C58E, 0x4762DA40, 0x4762EEF3, 0x476303A7,
 0x4763185A, 0x47632D0F, 0x476341C4, 0x47635679,
 0x47636B2F, 0x47637FE5, 0x4763949C, 0x4763A953,
 0x4763BE0B, 0x4763D2C3, 0x4763E77C, 0x4763FC35,
 0x476410EF, 0x476425A9, 0x47643A63, 0x47644F1E,
 0x476463DA, 0x47647896, 0x47648D52, 0x4764A20F,
 0x4764B6CC, 0x4764CB8A, 0x4764E048, 0x4764F507,
 0x476509C6, 0x47651E86, 0x47653346, 0x47654807,
 0x47655CC8, 0x4765718A, 0x4765864C, 0x47659B0E,
 0x4765AFD1, 0x4765C495, 0x4765D959, 0x4765EE1D,
 0x476602E2, 0x476617A7, 0x47662C6D, 0x47664134,
 0x476655FA, 0x47666AC2, 0x47667F89, 0x47669451,
 0x4766A91A, 0x4766BDE3, 0x4766D2AD, 0x4766E777,
 0x4766FC41, 0x4767110C, 0x476725D8, 0x47673AA3,
 0x47674F70, 0x4767643D, 0x4767790A, 0x47678DD8,
 0x4767A2A6, 0x4767B775, 0x4767CC44, 0x4767E114,
 0x4767F5E4, 0x47680AB4, 0x47681F85, 0x47683457,
 0x47684929, 0x47685DFB, 0x476872CE, 0x476887A1,
 0x47689C75, 0x4768B14A, 0x4768C61E, 0x4768DAF4,
 0x4768EFC9, 0x476904A0, 0x47691976, 0x47692E4D,
 0x47694325, 0x476957FD, 0x47696CD5, 0x476981AE,
 0x47699688, 0x4769AB62, 0x4769C03C, 0x4769D517,
 0x4769E9F2, 0x4769FECE, 0x476A13AA, 0x476A2887,
 0x476A3D64, 0x476A5242, 0x476A6720, 0x476A7BFE,
 0x476A90DD, 0x476AA5BD, 0x476ABA9D, 0x476ACF7D,
 0x476AE45E, 0x476AF93F, 0x476B0E21, 0x476B2303,
 0x476B37E6, 0x476B4CC9, 0x476B61AD, 0x476B7691,
 0x476B8B76, 0x476BA05B, 0x476BB540, 0x476BCA26,
 0x476BDF0D, 0x476BF3F3, 0x476C08DB, 0x476C1DC3,
 0x476C32AB, 0x476C4794, 0x476C5C7D, 0x476C7166,
 0x476C8651, 0x476C9B3B, 0x476CB026, 0x476CC512,
 0x476CD9FE, 0x476CEEEA, 0x476D03D7, 0x476D18C4,
 0x476D2DB2, 0x476D42A1, 0x476D578F, 0x476D6C7F,
 0x476D816E, 0x476D965E, 0x476DAB4F, 0x476DC040,
 0x476DD532, 0x476DEA24, 0x476DFF16, 0x476E1409,
 0x476E28FC, 0x476E3DF0, 0x476E52E4, 0x476E67D9,
 0x476E7CCE, 0x476E91C4, 0x476EA6BA, 0x476EBBB1,
 0x476ED0A8, 0x476EE59F, 0x476EFA97, 0x476F0F90,
 0x476F2489, 0x476F3982, 0x476F4E7C, 0x476F6376,
 0x476F7871, 0x476F8D6C, 0x476FA268, 0x476FB764,
 0x476FCC60, 0x476FE15D, 0x476FF65B, 0x47700B59,
 0x47702057, 0x47703556, 0x47704A55, 0x47705F55,
 0x47707455, 0x47708956, 0x47709E57, 0x4770B359,
 0x4770C85B, 0x4770DD5D, 0x4770F260, 0x47710764,
 0x47711C68, 0x4771316C, 0x47714671, 0x47715B76,
 0x4771707C, 0x47718582, 0x47719A89, 0x4771AF90,
 0x4771C497, 0x4771D99F, 0x4771EEA8, 0x477203B1,
 0x477218BA, 0x47722DC4, 0x477242CE, 0x477257D9,
 0x47726CE4, 0x477281F0, 0x477296FC, 0x4772AC09,
 0x4772C116, 0x4772D623, 0x4772EB31, 0x47730040,
 0x4773154F, 0x47732A5E, 0x47733F6E, 0x4773547E,
 0x4773698F, 0x47737EA0, 0x477393B1, 0x4773A8C3,
 0x4773BDD6, 0x4773D2E9, 0x4773E7FC, 0x4773FD10,
 0x47741225, 0x47742739, 0x47743C4F, 0x47745164,
 0x4774667A, 0x47747B91, 0x477490A8, 0x4774A5C0,
 0x4774BAD8, 0x4774CFF0, 0x4774E509, 0x4774FA22,
 0x47750F3C, 0x47752456, 0x47753971, 0x47754E8C,
 0x477563A8, 0x477578C4, 0x47758DE0, 0x4775A2FD,
 0x4775B81B, 0x4775CD39, 0x4775E257, 0x4775F776,
 0x47760C95, 0x477621B5, 0x477636D5, 0x47764BF6,
 0x47766117, 0x47767638, 0x47768B5A, 0x4776A07C,
 0x4776B59F, 0x4776CAC3, 0x4776DFE6, 0x4776F50B,
 0x47770A2F, 0x47771F54, 0x4777347A, 0x477749A0,
 0x47775EC7, 0x477773EE, 0x47778915, 0x47779E3D,
 0x4777B365, 0x4777C88E, 0x4777DDB7, 0x4777F2E1,
 0x4778080B, 0x47781D35, 0x47783260, 0x4778478C,
 0x47785CB8, 0x477871E4, 0x47788711, 0x47789C3E,
 0x4778B16C, 0x4778C69A, 0x4778DBC9, 0x4778F0F8,
 0x47790627, 0x47791B57, 0x47793088, 0x477945B8,
 0x47795AEA, 0x4779701C, 0x4779854E, 0x47799A80,
 0x4779AFB4, 0x4779C4E7, 0x4779DA1B, 0x4779EF50,
 0x477A0485, 0x477A19BA, 0x477A2EF0, 0x477A4426,
 0x477A595D, 0x477A6E94, 0x477A83CB, 0x477A9904,
 0x477AAE3C, 0x477AC375, 0x477AD8AE, 0x477AEDE8,
 0x477B0323, 0x477B185D, 0x477B2D99, 0x477B42D4,
 0x477B5810, 0x477B6D4D, 0x477B828A, 0x477B97C7,
 0x477BAD05, 0x477BC244, 0x477BD782, 0x477BECC2,
 0x477C0201, 0x477C1741, 0x477C2C82, 0x477C41C3,
 0x477C5705, 0x477C6C47, 0x477C8189, 0x477C96CC,
 0x477CAC0F, 0x477CC153, 0x477CD697, 0x477CEBDC,
 0x477D0121, 0x477D1666, 0x477D2BAC, 0x477D40F2,
 0x477D5639, 0x477D6B81, 0x477D80C8, 0x477D9611,
 0x477DAB59, 0x477DC0A2, 0x477DD5EC, 0x477DEB36,
 0x477E0080, 0x477E15CB, 0x477E2B16, 0x477E4062,
 0x477E55AE, 0x477E6AFB, 0x477E8048, 0x477E9596,
 0x477EAAE4, 0x477EC032, 0x477ED581, 0x477EEAD0,
 0x477F0020, 0x477F1570, 0x477F2AC1, 0x477F4012,
 0x477F5564, 0x477F6AB6, 0x477F8008, 0x477F955B,
 0x477FAAAE, 0x477FC002, 0x477FD556, 0x477FEAAB,
 0x47800000, 0x47800AAB, 0x47801556, 0x47802001,
 0x47802AAC, 0x47803558, 0x47804004, 0x47804AB0,
 0x4780555C, 0x47806009, 0x47806AB6, 0x47807563,
 0x47808010, 0x47808ABD, 0x4780956B, 0x4780A019,
 0x4780AAC7, 0x4780B575, 0x4780C024, 0x4780CAD3,
 0x4780D582, 0x4780E031, 0x4780EAE0, 0x4780F590,
 0x47810040, 0x47810AF0, 0x478115A0, 0x47812051,
 0x47812B02, 0x478135B3, 0x47814064, 0x47814B15,
 0x478155C7, 0x47816079, 0x47816B2B, 0x478175DD,
 0x47818090, 0x47818B42, 0x478195F5, 0x4781A0A9,
 0x4781AB5C, 0x4781B610, 0x4781C0C4, 0x4781CB78,
 0x4781D62C, 0x4781E0E0, 0x4781EB95, 0x4781F64A,
 0x478200FF, 0x47820BB5, 0x4782166A, 0x47822120,
 0x47822BD6, 0x4782368D, 0x47824143, 0x47824BFA,
 0x478256B1, 0x47826168, 0x47826C1F, 0x478276D7,
 0x4782818F, 0x47828C47, 0x478296FF, 0x4782A1B8,
 0x4782AC70, 0x4782B729, 0x4782C1E2, 0x4782CC9C,
 0x4782D755, 0x4782E20F, 0x4782ECC9, 0x4782F783,
 0x4783023E, 0x47830CF8, 0x478317B3, 0x4783226E,
 0x47832D2A, 0x478337E5, 0x478342A1, 0x47834D5D,
 0x47835819, 0x478362D6, 0x47836D92, 0x4783784F,
 0x4783830C, 0x47838DCA, 0x47839887, 0x4783A345,
 0x4783AE03, 0x4783B8C1, 0x4783C380, 0x4783CE3E,
 0x4783D8FD, 0x4783E3BC, 0x4783EE7B, 0x4783F93B,
 0x478403FB, 0x47840EBB, 0x4784197B, 0x4784243B,
 0x47842EFC, 0x478439BD, 0x4784447E, 0x47844F3F,
 0x47845A00, 0x478464C2, 0x47846F84, 0x47847A46,
 0x47848508, 0x47848FCB, 0x47849A8E, 0x4784A551,
 0x4784B014, 0x4784BAD8, 0x4784C59B, 0x4784D05F,
 0x4784DB23, 0x4784E5E7, 0x4784F0AC, 0x4784FB71,
 0x47850636, 0x478510FB, 0x47851BC0, 0x47852686,
 0x4785314C, 0x47853C12, 0x478546D8, 0x4785519F,
 0x47855C65, 0x4785672C, 0x478571F3, 0x47857CBB,
 0x47858782, 0x4785924A, 0x47859D12, 0x4785A7DA,
 0x4785B2A3, 0x4785BD6B, 0x4785C834, 0x4785D2FD,
 0x4785DDC7, 0x4785E890, 0x4785F35A, 0x4785FE24,
 0x478608EE, 0x478613B9, 0x47861E83, 0x4786294E,
 0x47863419, 0x47863EE4, 0x478649B0, 0x4786547C,
 0x47865F48, 0x47866A14, 0x478674E0, 0x47867FAD,
 0x47868A79, 0x47869546, 0x4786A014, 0x4786AAE1,
 0x4786B5AF, 0x4786C07D, 0x4786CB4B, 0x4786D619,
 0x4786E0E8, 0x4786EBB6, 0x4786F685, 0x47870155,
 0x47870C24, 0x478716F4, 0x478721C3, 0x47872C93,
 0x47873764, 0x47874234, 0x47874D05, 0x478757D6,
 0x478762A7, 0x47876D78, 0x4787784A, 0x4787831B,
 0x47878DED, 0x478798C0, 0x4787A392, 0x4787AE65,
 0x4787B938, 0x4787C40B, 0x4787CEDE, 0x4787D9B1,
 0x4787E485, 0x4787EF59, 0x4787FA2D, 0x47880502,
 0x47880FD6, 0x47881AAB, 0x47882580, 0x47883055,
 0x47883B2B, 0x47884600, 0x478850D6, 0x47885BAC,
 0x47886683, 0x47887159, 0x47887C30, 0x47888707,
 0x478891DE, 0x47889CB5, 0x4788A78D, 0x4788B265,
 0x4788BD3D, 0x4788C815, 0x4788D2ED, 0x4788DDC6,
 0x4788E89F, 0x4788F378, 0x4788FE51, 0x4789092B,
 0x47891405, 0x47891EDF, 0x478929B9, 0x47893493,
 0x47893F6E, 0x47894A48, 0x47895523, 0x47895FFF,
 0x47896ADA, 0x478975B6, 0x47898092, 0x47898B6E,
 0x4789964A, 0x4789A127, 0x4789AC03, 0x4789B6E0,
 0x4789C1BE, 0x4789CC9B, 0x4789D779, 0x4789E256,
 0x4789ED34, 0x4789F813, 0x478A02F1, 0x478A0DD0,
 0x478A18AF, 0x478A238E, 0x478A2E6D, 0x478A394D,
 0x478A442C, 0x478A4F0C, 0x478A59EC, 0x478A64CD,
 0x478A6FAD, 0x478A7A8E, 0x478A856F, 0x478A9050,
 0x478A9B32, 0x478AA614, 0x478AB0F5, 0x478ABBD8,
 0x478AC6BA, 0x478AD19C, 0x478ADC7F, 0x478AE762,
 0x478AF245, 0x478AFD29, 0x478B080C, 0x478B12F0,
 0x478B1DD4, 0x478B28B8, 0x478B339D, 0x478B3E81,
 0x478B4966, 0x478B544B, 0x478B5F30, 0x478B6A16,
 0x478B74FC, 0x478B7FE2, 0x478B8AC8, 0x478B95AE,
 0x478BA095, 0x478BAB7B, 0x478BB662, 0x478BC14A,
 0x478BCC31, 0x478BD719, 0x478BE201, 0x478BECE9,
 0x478BF7D1, 0x478C02B9, 0x478C0DA2, 0x478C188B,
 0x478C2374, 0x478C2E5D, 0x478C3947, 0x478C4431,
 0x478C4F1B, 0x478C5A05, 0x478C64EF, 0x478C6FDA,
 0x478C7AC5, 0x478C85B0, 0x478C909B, 0x478C9B86,
 0x478CA672, 0x478CB15E, 0x478CBC4A, 0x478CC736,
 0x478CD223, 0x478CDD10, 0x478CE7FC, 0x478CF2EA,
 0x478CFDD7, 0x478D08C5, 0x478D13B2, 0x478D1EA0,
 0x478D298F, 0x478D347D, 0x478D3F6C, 0x478D4A5A,
 0x478D5549, 0x478D6039, 0x478D6B28, 0x478D7618,
 0x478D8108, 0x478D8BF8, 0x478D96E8, 0x478DA1D9,
 0x478DACC9, 0x478DB7BA, 0x478DC2AC, 0x478DCD9D,
 0x478DD88F, 0x478DE380, 0x478DEE72, 0x478DF965,
 0x478E0457, 0x478E0F4A, 0x478E1A3C, 0x478E2530,
 0x478E3023, 0x478E3B16, 0x478E460A, 0x478E50FE,
 0x478E5BF2, 0x478E66E6, 0x478E71DB, 0x478E7CD0,
 0x478E87C5, 0x478E92BA, 0x478E9DAF, 0x478EA8A5,
 0x478EB39B, 0x478EBE91, 0x478EC987, 0x478ED47D,
 0x478EDF74, 0x478EEA6B, 0x478EF562, 0x478F0059,
 0x478F0B51, 0x478F1648, 0x478F2140, 0x478F2C38,
 0x478F3731, 0x478F4229, 0x478F4D22, 0x478F581B,
 0x478F6314, 0x478F6E0D, 0x478F7907, 0x478F8401,
 0x478F8EFB, 0x478F99F5, 0x478FA4EF, 0x478FAFEA,
 0x478FBAE5, 0x478FC5E0, 0x478FD0DB, 0x478FDBD7,
 0x478FE6D2, 0x478FF1CE, 0x478FFCCA, 0x479007C7,
 0x479012C3, 0x47901DC0, 0x479028BD, 0x479033BA,
 0x47903EB7, 0x479049B5, 0x479054B3, 0x47905FB1,
 0x47906AAF, 0x479075AD, 0x479080AC, 0x47908BAB,
 0x479096AA, 0x4790A1A9, 0x4790ACA8, 0x4790B7A8,
 0x4790C2A8, 0x4790CDA8, 0x4790D8A8, 0x4790E3A9,
 0x4790EEAA, 0x4790F9AA, 0x479104AC, 0x47910FAD,
 0x47911AAE, 0x479125B0, 0x479130B2, 0x47913BB4,
 0x479146B7, 0x479151B9, 0x47915CBC, 0x479167BF,
 0x479172C2, 0x47917DC6, 0x479188C9, 0x479193CD,
 0x47919ED1, 0x4791A9D5, 0x4791B4DA, 0x4791BFDF,
 0x4791CAE3, 0x4791D5E9, 0x4791E0EE, 0x4791EBF3,
 0x4791F6F9, 0x479201FF, 0x47920D05, 0x4792180B,
 0x47922312, 0x47922E19, 0x47923920, 0x47924427,
 0x47924F2E, 0x47925A36, 0x4792653E, 0x47927046,
 0x47927B4E, 0x47928656, 0x4792915F, 0x47929C68,
 0x4792A771, 0x4792B27A, 0x4792BD83, 0x4792C88D,
 0x4792D397, 0x4792DEA1, 0x4792E9AB, 0x4792F4B6,
 0x4792FFC0, 0x47930ACB, 0x479315D6, 0x479320E2,
 0x47932BED, 0x479336F9, 0x47934205, 0x47934D11,
 0x4793581D, 0x4793632A, 0x47936E37, 0x47937944,
 0x47938451, 0x47938F5E, 0x47939A6C, 0x4793A57A,
 0x4793B088, 0x4793BB96, 0x4793C6A4, 0x4793D1B3,
 0x4793DCC2, 0x4793E7D1, 0x4793F2E0, 0x4793FDF0,
 0x479408FF, 0x4794140F, 0x47941F1F, 0x47942A2F,
 0x47943540, 0x47944051, 0x47944B62, 0x47945673,
 0x47946184, 0x47946C96, 0x479477A7, 0x479482B9,
 0x47948DCB, 0x479498DE, 0x4794A3F0, 0x4794AF03,
 0x4794BA16, 0x4794C529, 0x4794D03C, 0x4794DB50,
 0x4794E664, 0x4794F178, 0x4794FC8C, 0x479507A0,
 0x479512B5, 0x47951DCA, 0x479528DF, 0x479533F4,
 0x47953F0A, 0x47954A1F, 0x47955535, 0x4795604B,
 0x47956B61, 0x47957678, 0x4795818F, 0x47958CA5,
 0x479597BC, 0x4795A2D4, 0x4795ADEB, 0x4795B903,
 0x4795C41B, 0x4795CF33, 0x4795DA4B, 0x4795E564,
 0x4795F07D, 0x4795FB95, 0x479606AF, 0x479611C8,
 0x47961CE2, 0x479627FB, 0x47963315, 0x47963E2F,
 0x4796494A, 0x47965464, 0x47965F7F, 0x47966A9A,
 0x479675B5, 0x479680D1, 0x47968BEC, 0x47969708,
 0x4796A224, 0x4796AD40, 0x4796B85D, 0x4796C379,
 0x4796CE96, 0x4796D9B3, 0x4796E4D0, 0x4796EFEE,
 0x4796FB0C, 0x47970629, 0x47971147, 0x47971C66,
 0x47972784, 0x479732A3, 0x47973DC2, 0x479748E1,
 0x47975400, 0x47975F20, 0x47976A3F, 0x4797755F,
 0x4797807F, 0x47978BA0, 0x479796C0, 0x4797A1E1,
 0x4797AD02, 0x4797B823, 0x4797C344, 0x4797CE66,
 0x4797D987, 0x4797E4A9, 0x4797EFCB, 0x4797FAEE,
 0x47980610, 0x47981133, 0x47981C56, 0x47982779,
 0x4798329D, 0x47983DC0, 0x479848E4, 0x47985408,
 0x47985F2C, 0x47986A50, 0x47987575, 0x4798809A,
 0x47988BBF, 0x479896E4, 0x4798A209, 0x4798AD2F,
 0x4798B855, 0x4798C37B, 0x4798CEA1, 0x4798D9C7,
 0x4798E4EE, 0x4798F015, 0x4798FB3C, 0x47990663,
 0x4799118B, 0x47991CB2, 0x479927DA, 0x47993302,
 0x47993E2A, 0x47994953, 0x4799547C, 0x47995FA4,
 0x47996ACD, 0x479975F7, 0x47998120, 0x47998C4A,
 0x47999774, 0x4799A29E, 0x4799ADC8, 0x4799B8F3,
 0x4799C41D, 0x4799CF48, 0x4799DA73, 0x4799E59E,
 0x4799F0CA, 0x4799FBF6, 0x479A0722, 0x479A124E,
 0x479A1D7A, 0x479A28A6, 0x479A33D3, 0x479A3F00,
 0x479A4A2D, 0x479A555B, 0x479A6088, 0x479A6BB6,
 0x479A76E4, 0x479A8212, 0x479A8D40, 0x479A986F,
 0x479AA39D, 0x479AAECC, 0x479AB9FB, 0x479AC52B,
 0x479AD05A, 0x479ADB8A, 0x479AE6BA, 0x479AF1EA,
 0x479AFD1B, 0x479B084B, 0x479B137C, 0x479B1EAD,
 0x479B29DE, 0x479B350F, 0x479B4041, 0x479B4B73,
 0x479B56A5, 0x479B61D7, 0x479B6D09, 0x479B783C,
 0x479B836E, 0x479B8EA1, 0x479B99D5, 0x479BA508,
 0x479BB03C, 0x479BBB6F, 0x479BC6A3, 0x479BD1D7,
 0x479BDD0C, 0x479BE840, 0x479BF375, 0x479BFEAA,
 0x479C09DF, 0x479C1515, 0x479C204A, 0x479C2B80,
 0x479C36B6, 0x479C41EC, 0x479C4D23, 0x479C5859,
 0x479C6390, 0x479C6EC7, 0x479C79FE, 0x479C8536,
 0x479C906D, 0x479C9BA5, 0x479CA6DD, 0x479CB215,
 0x479CBD4E, 0x479CC886, 0x479CD3BF, 0x479CDEF8,
 0x479CEA31, 0x479CF56B, 0x479D00A4, 0x479D0BDE,
 0x479D1718, 0x479D2252, 0x479D2D8D, 0x479D38C7,
 0x479D4402, 0x479D4F3D, 0x479D5A79, 0x479D65B4,
 0x479D70F0, 0x479D7C2B, 0x479D8767, 0x479D92A4,
 0x479D9DE0, 0x479DA91D, 0x479DB459, 0x479DBF96,
 0x479DCAD4, 0x479DD611, 0x479DE14F, 0x479DEC8D,
 0x479DF7CB, 0x479E0309, 0x479E0E47, 0x479E1986,
 0x479E24C5, 0x479E3004, 0x479E3B43, 0x479E4682,
 0x479E51C2, 0x479E5D02, 0x479E6842, 0x479E7382,
 0x479E7EC2, 0x479E8A03, 0x479E9544, 0x479EA085,
 0x479EABC6, 0x479EB707, 0x479EC249, 0x479ECD8B,
 0x479ED8CD, 0x479EE40F, 0x479EEF51, 0x479EFA94,
 0x479F05D7, 0x479F111A, 0x479F1C5D, 0x479F27A1,
 0x479F32E4, 0x479F3E28, 0x479F496C, 0x479F54B0,
 0x479F5FF5, 0x479F6B39, 0x479F767E, 0x479F81C3,
 0x479F8D08, 0x479F984E, 0x479FA393, 0x479FAED9,
 0x479FBA1F, 0x479FC565, 0x479FD0AC, 0x479FDBF2,
 0x479FE739, 0x479FF280, 0x479FFDC7, 0x47A0090E,
 0x47A01456, 0x47A01F9E, 0x47A02AE6, 0x47A0362E,
 0x47A04176, 0x47A04CBF, 0x47A05808, 0x47A06351,
 0x47A06E9A, 0x47A079E3, 0x47A0852D, 0x47A09077,
 0x47A09BC1, 0x47A0A70B, 0x47A0B255, 0x47A0BDA0,
 0x47A0C8EA, 0x47A0D435, 0x47A0DF81, 0x47A0EACC,
 0x47A0F618, 0x47A10163, 0x47A10CAF, 0x47A117FB,
 0x47A12348, 0x47A12E94, 0x47A139E1, 0x47A1452E,
 0x47A1507B, 0x47A15BC8, 0x47A16716, 0x47A17264,
 0x47A17DB2, 0x47A18900, 0x47A1944E, 0x47A19F9D,
 0x47A1AAEB, 0x47A1B63A, 0x47A1C189, 0x47A1CCD9,
 0x47A1D828, 0x47A1E378, 0x47A1EEC8, 0x47A1FA18,
 0x47A20568, 0x47A210B9, 0x47A21C09, 0x47A2275A,
 0x47A232AB, 0x47A23DFD, 0x47A2494E, 0x47A254A0,
 0x47A25FF2, 0x47A26B44, 0x47A27696, 0x47A281E9,
 0x47A28D3B, 0x47A2988E, 0x47A2A3E1, 0x47A2AF35,
 0x47A2BA88, 0x47A2C5DC, 0x47A2D12F, 0x47A2DC84,
 0x47A2E7D8, 0x47A2F32C, 0x47A2FE81, 0x47A309D6,
 0x47A3152B, 0x47A32080, 0x47A32BD5, 0x47A3372B,
 0x47A34281, 0x47A34DD7, 0x47A3592D, 0x47A36484,
 0x47A36FDA, 0x47A37B31, 0x47A38688, 0x47A391DF,
 0x47A39D37, 0x47A3A88E, 0x47A3B3E6, 0x47A3BF3E,
 0x47A3CA96, 0x47A3D5EF, 0x47A3E147, 0x47A3ECA0,
 0x47A3F7F9, 0x47A40352, 0x47A40EAB, 0x47A41A05,
 0x47A4255F, 0x47A430B9, 0x47A43C13, 0x47A4476D,
 0x47A452C8, 0x47A45E22, 0x47A4697D, 0x47A474D8,
 0x47A48034, 0x47A48B8F, 0x47A496EB, 0x47A4A247,
 0x47A4ADA3, 0x47A4B8FF, 0x47A4C45C, 0x47A4CFB9,
 0x47A4DB15, 0x47A4E673, 0x47A4F1D0, 0x47A4FD2D,
 0x47A5088B, 0x47A513E9, 0x47A51F47, 0x47A52AA5,
 0x47A53604, 0x47A54162, 0x47A54CC1, 0x47A55820,
 0x47A5637F, 0x47A56EDF, 0x47A57A3E, 0x47A5859E,
 0x47A590FE, 0x47A59C5F, 0x47A5A7BF, 0x47A5B320,
 0x47A5BE80, 0x47A5C9E1, 0x47A5D543, 0x47A5E0A4,
 0x47A5EC06, 0x47A5F767, 0x47A602C9, 0x47A60E2B,
 0x47A6198E, 0x47A624F0, 0x47A63053, 0x47A63BB6,
 0x47A64719, 0x47A6527D, 0x47A65DE0, 0x47A66944,
 0x47A674A8, 0x47A6800C, 0x47A68B70, 0x47A696D5,
 0x47A6A239, 0x47A6AD9E, 0x47A6B903, 0x47A6C469,
 0x47A6CFCE, 0x47A6DB34, 0x47A6E69A, 0x47A6F200,
 0x47A6FD66, 0x47A708CD, 0x47A71433, 0x47A71F9A,
 0x47A72B01, 0x47A73668, 0x47A741D0, 0x47A74D37,
 0x47A7589F, 0x47A76407, 0x47A76F6F, 0x47A77AD8,
 0x47A78640, 0x47A791A9, 0x47A79D12, 0x47A7A87B,
 0x47A7B3E5, 0x47A7BF4E, 0x47A7CAB8, 0x47A7D622,
 0x47A7E18C, 0x47A7ECF6, 0x47A7F861, 0x47A803CC,
 0x47A80F37, 0x47A81AA2, 0x47A8260D, 0x47A83179,
 0x47A83CE4, 0x47A84850, 0x47A853BC, 0x47A85F29,
 0x47A86A95, 0x47A87602, 0x47A8816F, 0x47A88CDC,
 0x47A89849, 0x47A8A3B6, 0x47A8AF24, 0x47A8BA92,
 0x47A8C600, 0x47A8D16E, 0x47A8DCDC, 0x47A8E84B,
 0x47A8F3BA, 0x47A8FF29, 0x47A90A98, 0x47A91607,
 0x47A92177, 0x47A92CE7, 0x47A93857, 0x47A943C7,
 0x47A94F37, 0x47A95AA8, 0x47A96618, 0x47A97189,
 0x47A97CFA, 0x47A9886C, 0x47A993DD, 0x47A99F4F,
 0x47A9AAC1, 0x47A9B633, 0x47A9C1A5, 0x47A9CD18,
 0x47A9D88A, 0x47A9E3FD, 0x47A9EF70, 0x47A9FAE3,
 0x47AA0657, 0x47AA11CB, 0x47AA1D3E, 0x47AA28B2,
 0x47AA3427, 0x47AA3F9B, 0x47AA4B10, 0x47AA5684,
 0x47AA61F9, 0x47AA6D6F, 0x47AA78E4, 0x47AA8459,
 0x47AA8FCF, 0x47AA9B45, 0x47AAA6BB, 0x47AAB232,
 0x47AABDA8, 0x47AAC91F, 0x47AAD496, 0x47AAE00D,
 0x47AAEB84, 0x47AAF6FC, 0x47AB0273, 0x47AB0DEB,
 0x47AB1963, 0x47AB24DB, 0x47AB3054, 0x47AB3BCC,
 0x47AB4745, 0x47AB52BE, 0x47AB5E37, 0x47AB69B1,
 0x47AB752A, 0x47AB80A4, 0x47AB8C1E, 0x47AB9798,
 0x47ABA313, 0x47ABAE8D, 0x47ABBA08, 0x47ABC583,
 0x47ABD0FE, 0x47ABDC79, 0x47ABE7F5, 0x47ABF371,
 0x47ABFEED, 0x47AC0A69, 0x47AC15E5, 0x47AC2161,
 0x47AC2CDE, 0x47AC385B, 0x47AC43D8, 0x47AC4F55,
 0x47AC5AD3, 0x47AC6650, 0x47AC71CE, 0x47AC7D4C,
 0x47AC88CA, 0x47AC9449, 0x47AC9FC7, 0x47ACAB46,
 0x47ACB6C5, 0x47ACC244, 0x47ACCDC3, 0x47ACD943,
 0x47ACE4C3, 0x47ACF043, 0x47ACFBC3, 0x47AD0743,
 0x47AD12C3, 0x47AD1E44, 0x47AD29C5, 0x47AD3546,
 0x47AD40C7, 0x47AD4C49, 0x47AD57CA, 0x47AD634C,
 0x47AD6ECE, 0x47AD7A50, 0x47AD85D3, 0x47AD9155,
 0x47AD9CD8, 0x47ADA85B, 0x47ADB3DE, 0x47ADBF62,
 0x47ADCAE5, 0x47ADD669, 0x47ADE1ED, 0x47ADED71,
 0x47ADF8F5, 0x47AE047A, 0x47AE0FFE, 0x47AE1B83,
 0x47AE2708, 0x47AE328E, 0x47AE3E13, 0x47AE4999,
 0x47AE551F, 0x47AE60A5, 0x47AE6C2B, 0x47AE77B1,
 0x47AE8338, 0x47AE8EBF, 0x47AE9A45, 0x47AEA5CD,
 0x47AEB154, 0x47AEBCDC, 0x47AEC863, 0x47AED3EB,
 0x47AEDF73, 0x47AEEAFC, 0x47AEF684, 0x47AF020D,
 0x47AF0D96, 0x47AF191F, 0x47AF24A8, 0x47AF3031,
 0x47AF3BBB, 0x47AF4745, 0x47AF52CF, 0x47AF5E59,
 0x47AF69E3, 0x47AF756E, 0x47AF80F9, 0x47AF8C84,
 0x47AF980F, 0x47AFA39A, 0x47AFAF26, 0x47AFBAB2,
 0x47AFC63D, 0x47AFD1CA, 0x47AFDD56, 0x47AFE8E2,
 0x47AFF46F, 0x47AFFFFC, 0x47B00B89, 0x47B01716,
 0x47B022A4, 0x47B02E31, 0x47B039BF, 0x47B0454D,
 0x47B050DB, 0x47B05C6A, 0x47B067F8, 0x47B07387,
 0x47B07F16, 0x47B08AA5, 0x47B09634, 0x47B0A1C4,
 0x47B0AD53, 0x47B0B8E3, 0x47B0C473, 0x47B0D004,
 0x47B0DB94, 0x47B0E725, 0x47B0F2B6, 0x47B0FE47,
 0x47B109D8, 0x47B11569, 0x47B120FB, 0x47B12C8D,
 0x47B1381F, 0x47B143B1, 0x47B14F43, 0x47B15AD6,
 0x47B16668, 0x47B171FB, 0x47B17D8E, 0x47B18922,
 0x47B194B5, 0x47B1A049, 0x47B1ABDD, 0x47B1B771,
 0x47B1C305, 0x47B1CE99, 0x47B1DA2E, 0x47B1E5C3,
 0x47B1F158, 0x47B1FCED, 0x47B20882, 0x47B21418,
 0x47B21FAD, 0x47B22B43, 0x47B236DA, 0x47B24270,
 0x47B24E06, 0x47B2599D, 0x47B26534, 0x47B270CB,
 0x47B27C62, 0x47B287FA, 0x47B29391, 0x47B29F29,
 0x47B2AAC1, 0x47B2B659, 0x47B2C1F2, 0x47B2CD8A,
 0x47B2D923, 0x47B2E4BC, 0x47B2F055, 0x47B2FBEE,
 0x47B30788, 0x47B31321, 0x47B31EBB, 0x47B32A55,
 0x47B335F0, 0x47B3418A, 0x47B34D25, 0x47B358C0,
 0x47B3645B, 0x47B36FF6, 0x47B37B91, 0x47B3872D,
 0x47B392C8, 0x47B39E64, 0x47B3AA01, 0x47B3B59D,
 0x47B3C139, 0x47B3CCD6, 0x47B3D873, 0x47B3E410,
 0x47B3EFAD, 0x47B3FB4B, 0x47B406E8, 0x47B41286,
 0x47B41E24, 0x47B429C2, 0x47B43561, 0x47B440FF,
 0x47B44C9E, 0x47B4583D, 0x47B463DC, 0x47B46F7B,
 0x47B47B1B, 0x47B486BB, 0x47B4925A, 0x47B49DFB,
 0x47B4A99B, 0x47B4B53B, 0x47B4C0DC, 0x47B4CC7D,
 0x47B4D81E, 0x47B4E3BF, 0x47B4EF60, 0x47B4FB02,
 0x47B506A4, 0x47B51245, 0x47B51DE8, 0x47B5298A,
 0x47B5352C, 0x47B540CF, 0x47B54C72, 0x47B55815,
 0x47B563B8, 0x47B56F5C, 0x47B57AFF, 0x47B586A3,
 0x47B59247, 0x47B59DEB, 0x47B5A990, 0x47B5B534,
 0x47B5C0D9, 0x47B5CC7E, 0x47B5D823, 0x47B5E3C8,
 0x47B5EF6E, 0x47B5FB13, 0x47B606B9, 0x47B6125F,
 0x47B61E05, 0x47B629AC, 0x47B63552, 0x47B640F9,
 0x47B64CA0, 0x47B65847, 0x47B663EF, 0x47B66F96,
 0x47B67B3E, 0x47B686E6, 0x47B6928E, 0x47B69E36,
 0x47B6A9DF, 0x47B6B587, 0x47B6C130, 0x47B6CCD9,
 0x47B6D882, 0x47B6E42C, 0x47B6EFD5, 0x47B6FB7F,
 0x47B70729, 0x47B712D3, 0x47B71E7E, 0x47B72A28,
 0x47B735D3, 0x47B7417E, 0x47B74D29, 0x47B758D4,
 0x47B7647F, 0x47B7702B, 0x47B77BD7, 0x47B78783,
 0x47B7932F, 0x47B79EDB, 0x47B7AA88, 0x47B7B635,
 0x47B7C1E1, 0x47B7CD8F, 0x47B7D93C, 0x47B7E4E9,
 0x47B7F097, 0x47B7FC45, 0x47B807F3, 0x47B813A1,
 0x47B81F4F, 0x47B82AFE, 0x47B836AD, 0x47B8425C,
 0x47B84E0B, 0x47B859BA, 0x47B8656A, 0x47B87119,
 0x47B87CC9, 0x47B88879, 0x47B8942A, 0x47B89FDA,
 0x47B8AB8B, 0x47B8B73C, 0x47B8C2ED, 0x47B8CE9E,
 0x47B8DA4F, 0x47B8E601, 0x47B8F1B2, 0x47B8FD64,
 0x47B90916, 0x47B914C9, 0x47B9207B, 0x47B92C2E,
 0x47B937E1, 0x47B94394, 0x47B94F47, 0x47B95AFA,
 0x47B966AE, 0x47B97262, 0x47B97E16, 0x47B989CA,
 0x47B9957E, 0x47B9A132, 0x47B9ACE7, 0x47B9B89C,
 0x47B9C451, 0x47B9D006, 0x47B9DBBC, 0x47B9E771,
 0x47B9F327, 0x47B9FEDD, 0x47BA0A93, 0x47BA164A,
 0x47BA2200, 0x47BA2DB7, 0x47BA396E, 0x47BA4525,
 0x47BA50DC, 0x47BA5C94, 0x47BA684B, 0x47BA7403,
 0x47BA7FBB, 0x47BA8B73, 0x47BA972C, 0x47BAA2E4,
 0x47BAAE9D, 0x47BABA56, 0x47BAC60F, 0x47BAD1C8,
 0x47BADD82, 0x47BAE93B, 0x47BAF4F5, 0x47BB00AF,
 0x47BB0C69, 0x47BB1824, 0x47BB23DE, 0x47BB2F99,
 0x47BB3B54, 0x47BB470F, 0x47BB52CB, 0x47BB5E86,
 0x47BB6A42, 0x47BB75FE, 0x47BB81BA, 0x47BB8D76,
 0x47BB9932, 0x47BBA4EF, 0x47BBB0AC, 0x47BBBC69,
 0x47BBC826, 0x47BBD3E3, 0x47BBDFA1, 0x47BBEB5E,
 0x47BBF71C, 0x47BC02DA, 0x47BC0E99, 0x47BC1A57,
 0x47BC2616, 0x47BC31D4, 0x47BC3D93, 0x47BC4953,
 0x47BC5512, 0x47BC60D2, 0x47BC6C91, 0x47BC7851,
 0x47BC8411, 0x47BC8FD2, 0x47BC9B92, 0x47BCA753,
 0x47BCB313, 0x47BCBED4, 0x47BCCA96, 0x47BCD657,
 0x47BCE219, 0x47BCEDDA, 0x47BCF99C, 0x47BD055E,
 0x47BD1121, 0x47BD1CE3, 0x47BD28A6, 0x47BD3468,
 0x47BD402B, 0x47BD4BEF, 0x47BD57B2, 0x47BD6376,
 0x47BD6F39, 0x47BD7AFD, 0x47BD86C1, 0x47BD9286,
 0x47BD9E4A, 0x47BDAA0F, 0x47BDB5D4, 0x47BDC199,
 0x47BDCD5E, 0x47BDD923, 0x47BDE4E9, 0x47BDF0AF,
 0x47BDFC74, 0x47BE083B, 0x47BE1401, 0x47BE1FC7,
 0x47BE2B8E, 0x47BE3755, 0x47BE431C, 0x47BE4EE3,
 0x47BE5AAB, 0x47BE6672, 0x47BE723A, 0x47BE7E02,
 0x47BE89CA, 0x47BE9592, 0x47BEA15B, 0x47BEAD23,
 0x47BEB8EC, 0x47BEC4B5, 0x47BED07E, 0x47BEDC48,
 0x47BEE811, 0x47BEF3DB, 0x47BEFFA5, 0x47BF0B6F,
 0x47BF173A, 0x47BF2304, 0x47BF2ECF, 0x47BF3A9A,
 0x47BF4665, 0x47BF5230, 0x47BF5DFB, 0x47BF69C7,
 0x47BF7593, 0x47BF815E, 0x47BF8D2B, 0x47BF98F7,
 0x47BFA4C3, 0x47BFB090, 0x47BFBC5D, 0x47BFC82A,
 0x47BFD3F7, 0x47BFDFC5, 0x47BFEB92, 0x47BFF760,
 0x47C0032E, 0x47C00EFC, 0x47C01ACA, 0x47C02699,
 0x47C03267, 0x47C03E36, 0x47C04A05, 0x47C055D4,
 0x47C061A4, 0x47C06D73, 0x47C07943, 0x47C08513,
 0x47C090E3, 0x47C09CB3, 0x47C0A884, 0x47C0B455,
 0x47C0C025, 0x47C0CBF6, 0x47C0D7C8, 0x47C0E399,
 0x47C0EF6B, 0x47C0FB3C, 0x47C1070E, 0x47C112E0,
 0x47C11EB3, 0x47C12A85, 0x47C13658, 0x47C1422B,
 0x47C14DFE, 0x47C159D1, 0x47C165A4, 0x47C17178,
 0x47C17D4B, 0x47C1891F, 0x47C194F3, 0x47C1A0C8,
 0x47C1AC9C, 0x47C1B871, 0x47C1C446, 0x47C1D01B,
 0x47C1DBF0, 0x47C1E7C5, 0x47C1F39B, 0x47C1FF70,
 0x47C20B46, 0x47C2171C, 0x47C222F3, 0x47C22EC9,
 0x47C23AA0, 0x47C24677, 0x47C2524E, 0x47C25E25,
 0x47C269FC, 0x47C275D4, 0x47C281AB, 0x47C28D83,
 0x47C2995B, 0x47C2A533, 0x47C2B10C, 0x47C2BCE5,
 0x47C2C8BD, 0x47C2D496, 0x47C2E06F, 0x47C2EC49,
 0x47C2F822, 0x47C303FC, 0x47C30FD6, 0x47C31BB0,
 0x47C3278A, 0x47C33364, 0x47C33F3F, 0x47C34B1A,
 0x47C356F5, 0x47C362D0, 0x47C36EAB, 0x47C37A87,
 0x47C38662, 0x47C3923E, 0x47C39E1A, 0x47C3A9F6,
 0x47C3B5D3, 0x47C3C1AF, 0x47C3CD8C, 0x47C3D969,
 0x47C3E546, 0x47C3F123, 0x47C3FD01, 0x47C408DF,
 0x47C414BC, 0x47C4209A, 0x47C42C79, 0x47C43857,
 0x47C44435, 0x47C45014, 0x47C45BF3, 0x47C467D2,
 0x47C473B1, 0x47C47F91, 0x47C48B70, 0x47C49750,
 0x47C4A330, 0x47C4AF10, 0x47C4BAF1, 0x47C4C6D1,
 0x47C4D2B2, 0x47C4DE93, 0x47C4EA74, 0x47C4F655,
 0x47C50236, 0x47C50E18, 0x47C519FA, 0x47C525DC,
 0x47C531BE, 0x47C53DA0, 0x47C54983, 0x47C55565,
 0x47C56148, 0x47C56D2B, 0x47C5790E, 0x47C584F2,
 0x47C590D5, 0x47C59CB9, 0x47C5A89D, 0x47C5B481,
 0x47C5C065, 0x47C5CC4A, 0x47C5D82E, 0x47C5E413,
 0x47C5EFF8, 0x47C5FBDD, 0x47C607C3, 0x47C613A8,
 0x47C61F8E, 0x47C62B74, 0x47C6375A, 0x47C64340,
 0x47C64F27, 0x47C65B0D, 0x47C666F4, 0x47C672DB,
 0x47C67EC2, 0x47C68AA9, 0x47C69691, 0x47C6A278,
 0x47C6AE60, 0x47C6BA48, 0x47C6C631, 0x47C6D219,
 0x47C6DE01, 0x47C6E9EA, 0x47C6F5D3, 0x47C701BC,
 0x47C70DA5, 0x47C7198F, 0x47C72579, 0x47C73162,
 0x47C73D4C, 0x47C74936, 0x47C75521, 0x47C7610B,
 0x47C76CF6, 0x47C778E1, 0x47C784CC, 0x47C790B7,
 0x47C79CA3, 0x47C7A88E, 0x47C7B47A, 0x47C7C066,
 0x47C7CC52, 0x47C7D83E, 0x47C7E42B, 0x47C7F017,
 0x47C7FC04, 0x47C807F1, 0x47C813DE, 0x47C81FCC,
 0x47C82BB9, 0x47C837A7, 0x47C84395, 0x47C84F83,
 0x47C85B71, 0x47C86760, 0x47C8734E, 0x47C87F3D,
 0x47C88B2C, 0x47C8971B, 0x47C8A30B, 0x47C8AEFA,
 0x47C8BAEA, 0x47C8C6DA, 0x47C8D2CA, 0x47C8DEBA,
 0x47C8EAAA, 0x47C8F69B, 0x47C9028B, 0x47C90E7C,
 0x47C91A6D, 0x47C9265F, 0x47C93250, 0x47C93E42,
 0x47C94A34, 0x47C95626, 0x47C96218, 0x47C96E0A,
 0x47C979FD, 0x47C985EF, 0x47C991E2, 0x47C99DD5,
 0x47C9A9C8, 0x47C9B5BC, 0x47C9C1AF, 0x47C9CDA3,
 0x47C9D997, 0x47C9E58B, 0x47C9F17F, 0x47C9FD74,
 0x47CA0968, 0x47CA155D, 0x47CA2152, 0x47CA2D47,
 0x47CA393D, 0x47CA4532, 0x47CA5128, 0x47CA5D1E,
 0x47CA6914, 0x47CA750A, 0x47CA8101, 0x47CA8CF7,
 0x47CA98EE, 0x47CAA4E5, 0x47CAB0DC, 0x47CABCD3,
 0x47CAC8CB, 0x47CAD4C2, 0x47CAE0BA, 0x47CAECB2,
 0x47CAF8AA, 0x47CB04A3, 0x47CB109B, 0x47CB1C94,
 0x47CB288D, 0x47CB3486, 0x47CB407F, 0x47CB4C78,
 0x47CB5872, 0x47CB646C, 0x47CB7066, 0x47CB7C60,
 0x47CB885A, 0x47CB9454, 0x47CBA04F, 0x47CBAC4A,
 0x47CBB845, 0x47CBC440, 0x47CBD03B, 0x47CBDC37,
 0x47CBE833, 0x47CBF42E, 0x47CC002B, 0x47CC0C27,
 0x47CC1823, 0x47CC2420, 0x47CC301C, 0x47CC3C19,
 0x47CC4816, 0x47CC5414, 0x47CC6011, 0x47CC6C0F,
 0x47CC780D, 0x47CC840B, 0x47CC9009, 0x47CC9C07,
 0x47CCA806, 0x47CCB404, 0x47CCC003, 0x47CCCC02,
 0x47CCD801, 0x47CCE401, 0x47CCF000, 0x47CCFC00,
 0x47CD0800, 0x47CD1400, 0x47CD2000, 0x47CD2C01,
 0x47CD3801, 0x47CD4402, 0x47CD5003, 0x47CD5C04,
 0x47CD6806, 0x47CD7407, 0x47CD8009, 0x47CD8C0B,
 0x47CD980D, 0x47CDA40F, 0x47CDB011, 0x47CDBC14,
 0x47CDC816, 0x47CDD419, 0x47CDE01C, 0x47CDEC20,
 0x47CDF823, 0x47CE0427, 0x47CE102A, 0x47CE1C2E,
 0x47CE2833, 0x47CE3437, 0x47CE403B, 0x47CE4C40,
 0x47CE5845, 0x47CE644A, 0x47CE704F, 0x47CE7C54,
 0x47CE885A, 0x47CE945F, 0x47CEA065, 0x47CEAC6B,
 0x47CEB872, 0x47CEC478, 0x47CED07F, 0x47CEDC85,
 0x47CEE88C, 0x47CEF493, 0x47CF009B, 0x47CF0CA2,
 0x47CF18AA, 0x47CF24B1, 0x47CF30B9, 0x47CF3CC2,
 0x47CF48CA, 0x47CF54D2, 0x47CF60DB, 0x47CF6CE4,
 0x47CF78ED, 0x47CF84F6, 0x47CF90FF, 0x47CF9D09,
 0x47CFA913, 0x47CFB51D, 0x47CFC127, 0x47CFCD31,
 0x47CFD93B, 0x47CFE546, 0x47CFF151, 0x47CFFD5C,
 0x47D00967, 0x47D01572, 0x47D0217D, 0x47D02D89,
 0x47D03995, 0x47D045A1, 0x47D051AD, 0x47D05DB9,
 0x47D069C6, 0x47D075D3, 0x47D081DF, 0x47D08DEC,
 0x47D099FA, 0x47D0A607, 0x47D0B215, 0x47D0BE22,
 0x47D0CA30, 0x47D0D63E, 0x47D0E24C, 0x47D0EE5B,
 0x47D0FA69, 0x47D10678, 0x47D11287, 0x47D11E96,
 0x47D12AA6, 0x47D136B5, 0x47D142C5, 0x47D14ED4,
 0x47D15AE4, 0x47D166F5, 0x47D17305, 0x47D17F15,
 0x47D18B26, 0x47D19737, 0x47D1A348, 0x47D1AF59,
 0x47D1BB6B, 0x47D1C77C, 0x47D1D38E, 0x47D1DFA0,
 0x47D1EBB2, 0x47D1F7C4, 0x47D203D6, 0x47D20FE9,
 0x47D21BFC, 0x47D2280F, 0x47D23422, 0x47D24035,
 0x47D24C49, 0x47D2585C, 0x47D26470, 0x47D27084,
 0x47D27C98, 0x47D288AC, 0x47D294C1, 0x47D2A0D6,
 0x47D2ACEA, 0x47D2B8FF, 0x47D2C515, 0x47D2D12A,
 0x47D2DD40, 0x47D2E955, 0x47D2F56B, 0x47D30181,
 0x47D30D97, 0x47D319AE, 0x47D325C4, 0x47D331DB,
 0x47D33DF2, 0x47D34A09, 0x47D35620, 0x47D36238,
 0x47D36E4F, 0x47D37A67, 0x47D3867F, 0x47D39297,
 0x47D39EB0, 0x47D3AAC8, 0x47D3B6E1, 0x47D3C2FA,
 0x47D3CF13, 0x47D3DB2C, 0x47D3E745, 0x47D3F35F,
 0x47D3FF78, 0x47D40B92, 0x47D417AC, 0x47D423C6,
 0x47D42FE1, 0x47D43BFB, 0x47D44816, 0x47D45431,
 0x47D4604C, 0x47D46C67, 0x47D47883, 0x47D4849E,
 0x47D490BA, 0x47D49CD6, 0x47D4A8F2, 0x47D4B50E,
 0x47D4C12B, 0x47D4CD47, 0x47D4D964, 0x47D4E581,
 0x47D4F19E, 0x47D4FDBB, 0x47D509D9, 0x47D515F7,
 0x47D52214, 0x47D52E32, 0x47D53A51, 0x47D5466F,
 0x47D5528D, 0x47D55EAC, 0x47D56ACB, 0x47D576EA,
 0x47D58309, 0x47D58F29, 0x47D59B48, 0x47D5A768,
 0x47D5B388, 0x47D5BFA8, 0x47D5CBC8, 0x47D5D7E8,
 0x47D5E409, 0x47D5F02A, 0x47D5FC4B, 0x47D6086C,
 0x47D6148D, 0x47D620AE, 0x47D62CD0, 0x47D638F2,
 0x47D64514, 0x47D65136, 0x47D65D58, 0x47D6697B,
 0x47D6759D, 0x47D681C0, 0x47D68DE3, 0x47D69A06,
 0x47D6A62A, 0x47D6B24D, 0x47D6BE71, 0x47D6CA95,
 0x47D6D6B9, 0x47D6E2DD, 0x47D6EF01, 0x47D6FB26,
 0x47D7074A, 0x47D7136F, 0x47D71F94, 0x47D72BB9,
 0x47D737DF, 0x47D74404, 0x47D7502A, 0x47D75C50,
 0x47D76876, 0x47D7749C, 0x47D780C3, 0x47D78CE9,
 0x47D79910, 0x47D7A537, 0x47D7B15E, 0x47D7BD85,
 0x47D7C9AD, 0x47D7D5D4, 0x47D7E1FC, 0x47D7EE24,
 0x47D7FA4C, 0x47D80674, 0x47D8129D, 0x47D81EC6,
 0x47D82AEE, 0x47D83717, 0x47D84341, 0x47D84F6A,
 0x47D85B93, 0x47D867BD, 0x47D873E7, 0x47D88011,
 0x47D88C3B, 0x47D89865, 0x47D8A490, 0x47D8B0BB,
 0x47D8BCE5, 0x47D8C910, 0x47D8D53C, 0x47D8E167,
 0x47D8ED93, 0x47D8F9BE, 0x47D905EA, 0x47D91216,
 0x47D91E42, 0x47D92A6F, 0x47D9369B, 0x47D942C8,
 0x47D94EF5, 0x47D95B22, 0x47D9674F, 0x47D9737D,
 0x47D97FAA, 0x47D98BD8, 0x47D99806, 0x47D9A434,
 0x47D9B062, 0x47D9BC91, 0x47D9C8BF, 0x47D9D4EE,
 0x47D9E11D, 0x47D9ED4C, 0x47D9F97C, 0x47DA05AB,
 0x47DA11DB, 0x47DA1E0A, 0x47DA2A3A, 0x47DA366B,
 0x47DA429B, 0x47DA4ECB, 0x47DA5AFC, 0x47DA672D,
 0x47DA735E, 0x47DA7F8F, 0x47DA8BC0, 0x47DA97F2,
 0x47DAA423, 0x47DAB055, 0x47DABC87, 0x47DAC8BA,
 0x47DAD4EC, 0x47DAE11E, 0x47DAED51, 0x47DAF984,
 0x47DB05B7, 0x47DB11EA, 0x47DB1E1E, 0x47DB2A51,
 0x47DB3685, 0x47DB42B9, 0x47DB4EED, 0x47DB5B21,
 0x47DB6755, 0x47DB738A, 0x47DB7FBF, 0x47DB8BF4,
 0x47DB9829, 0x47DBA45E, 0x47DBB093, 0x47DBBCC9,
 0x47DBC8FF, 0x47DBD534, 0x47DBE16B, 0x47DBEDA1,
 0x47DBF9D7, 0x47DC060E, 0x47DC1245, 0x47DC1E7C,
 0x47DC2AB3, 0x47DC36EA, 0x47DC4321, 0x47DC4F59,
 0x47DC5B91, 0x47DC67C9, 0x47DC7401, 0x47DC8039,
 0x47DC8C72, 0x47DC98AA, 0x47DCA4E3, 0x47DCB11C,
 0x47DCBD55, 0x47DCC98E, 0x47DCD5C8, 0x47DCE202,
 0x47DCEE3B, 0x47DCFA75, 0x47DD06B0, 0x47DD12EA,
 0x47DD1F24, 0x47DD2B5F, 0x47DD379A, 0x47DD43D5,
 0x47DD5010, 0x47DD5C4B, 0x47DD6887, 0x47DD74C2,
 0x47DD80FE, 0x47DD8D3A, 0x47DD9977, 0x47DDA5B3,
 0x47DDB1EF, 0x47DDBE2C, 0x47DDCA69, 0x47DDD6A6,
 0x47DDE2E3, 0x47DDEF20, 0x47DDFB5E, 0x47DE079C,
 0x47DE13DA, 0x47DE2018, 0x47DE2C56, 0x47DE3894,
 0x47DE44D3, 0x47DE5111, 0x47DE5D50, 0x47DE698F,
 0x47DE75CF, 0x47DE820E, 0x47DE8E4E, 0x47DE9A8D,
 0x47DEA6CD, 0x47DEB30D, 0x47DEBF4D, 0x47DECB8E,
 0x47DED7CE, 0x47DEE40F, 0x47DEF050, 0x47DEFC91,
 0x47DF08D2, 0x47DF1514, 0x47DF2155, 0x47DF2D97,
 0x47DF39D9, 0x47DF461B, 0x47DF525D, 0x47DF5EA0,
 0x47DF6AE2, 0x47DF7725, 0x47DF8368, 0x47DF8FAB,
 0x47DF9BEE, 0x47DFA832, 0x47DFB475, 0x47DFC0B9,
 0x47DFCCFD, 0x47DFD941, 0x47DFE585, 0x47DFF1CA,
 0x47DFFE0E, 0x47E00A53, 0x47E01698, 0x47E022DD,
 0x47E02F23, 0x47E03B68, 0x47E047AE, 0x47E053F3,
 0x47E06039, 0x47E06C7F, 0x47E078C6, 0x47E0850C,
 0x47E09153, 0x47E09D9A, 0x47E0A9E1, 0x47E0B628,
 0x47E0C26F, 0x47E0CEB6, 0x47E0DAFE, 0x47E0E746,
 0x47E0F38E, 0x47E0FFD6, 0x47E10C1E, 0x47E11867,
 0x47E124AF, 0x47E130F8, 0x47E13D41, 0x47E1498A,
 0x47E155D3, 0x47E1621D, 0x47E16E67, 0x47E17AB0,
 0x47E186FA, 0x47E19344, 0x47E19F8F, 0x47E1ABD9,
 0x47E1B824, 0x47E1C46F, 0x47E1D0BA, 0x47E1DD05,
 0x47E1E950, 0x47E1F59C, 0x47E201E7, 0x47E20E33,
 0x47E21A7F, 0x47E226CB, 0x47E23317, 0x47E23F64,
 0x47E24BB1, 0x47E257FD, 0x47E2644A, 0x47E27098,
 0x47E27CE5, 0x47E28932, 0x47E29580, 0x47E2A1CE,
 0x47E2AE1C, 0x47E2BA6A, 0x47E2C6B8, 0x47E2D307,
 0x47E2DF55, 0x47E2EBA4, 0x47E2F7F3, 0x47E30442,
 0x47E31092, 0x47E31CE1, 0x47E32931, 0x47E33581,
 0x47E341D1, 0x47E34E21, 0x47E35A71, 0x47E366C2,
 0x47E37312, 0x47E37F63, 0x47E38BB4, 0x47E39805,
 0x47E3A456, 0x47E3B0A8, 0x47E3BCFA, 0x47E3C94B,
 0x47E3D59D, 0x47E3E1F0, 0x47E3EE42, 0x47E3FA94,
 0x47E406E7, 0x47E4133A, 0x47E41F8D, 0x47E42BE0,
 0x47E43833, 0x47E44487, 0x47E450DA, 0x47E45D2E,
 0x47E46982, 0x47E475D6, 0x47E4822B, 0x47E48E7F,
 0x47E49AD4, 0x47E4A729, 0x47E4B37E, 0x47E4BFD3,
 0x47E4CC28, 0x47E4D87D, 0x47E4E4D3, 0x47E4F129,
 0x47E4FD7F, 0x47E509D5, 0x47E5162B, 0x47E52282,
 0x47E52ED8, 0x47E53B2F, 0x47E54786, 0x47E553DD,
 0x47E56035, 0x47E56C8C, 0x47E578E4, 0x47E5853C,
 0x47E59194, 0x47E59DEC, 0x47E5AA44, 0x47E5B69D,
 0x47E5C2F5, 0x47E5CF4E, 0x47E5DBA7, 0x47E5E800,
 0x47E5F459, 0x47E600B3, 0x47E60D0C, 0x47E61966,
 0x47E625C0, 0x47E6321A, 0x47E63E75, 0x47E64ACF,
 0x47E6572A, 0x47E66384, 0x47E66FDF, 0x47E67C3B,
 0x47E68896, 0x47E694F1, 0x47E6A14D, 0x47E6ADA9,
 0x47E6BA05, 0x47E6C661, 0x47E6D2BD, 0x47E6DF19,
 0x47E6EB76, 0x47E6F7D3, 0x47E70430, 0x47E7108D,
 0x47E71CEA, 0x47E72948, 0x47E735A5, 0x47E74203,
 0x47E74E61, 0x47E75ABF, 0x47E7671D, 0x47E7737C,
 0x47E77FDA, 0x47E78C39, 0x47E79898, 0x47E7A4F7,
 0x47E7B156, 0x47E7BDB6, 0x47E7CA15, 0x47E7D675,
 0x47E7E2D5, 0x47E7EF35, 0x47E7FB95, 0x47E807F6,
 0x47E81456, 0x47E820B7, 0x47E82D18, 0x47E83979,
 0x47E845DA, 0x47E8523C, 0x47E85E9D, 0x47E86AFF,
 0x47E87761, 0x47E883C3, 0x47E89025, 0x47E89C88,
 0x47E8A8EA, 0x47E8B54D, 0x47E8C1B0, 0x47E8CE13,
 0x47E8DA76, 0x47E8E6D9, 0x47E8F33D, 0x47E8FFA1,
 0x47E90C04, 0x47E91868, 0x47E924CD, 0x47E93131,
 0x47E93D96, 0x47E949FA, 0x47E9565F, 0x47E962C4,
 0x47E96F29, 0x47E97B8F, 0x47E987F4, 0x47E9945A,
 0x47E9A0C0, 0x47E9AD26, 0x47E9B98C, 0x47E9C5F2,
 0x47E9D259, 0x47E9DEBF, 0x47E9EB26, 0x47E9F78D,
 0x47EA03F4, 0x47EA105C, 0x47EA1CC3, 0x47EA292B,
 0x47EA3593, 0x47EA41FB, 0x47EA4E63, 0x47EA5ACB,
 0x47EA6734, 0x47EA739C, 0x47EA8005, 0x47EA8C6E,
 0x47EA98D7, 0x47EAA541, 0x47EAB1AA, 0x47EABE14,
 0x47EACA7D, 0x47EAD6E7, 0x47EAE351, 0x47EAEFBC,
 0x47EAFC26, 0x47EB0891, 0x47EB14FC, 0x47EB2167,
 0x47EB2DD2, 0x47EB3A3D, 0x47EB46A8, 0x47EB5314,
 0x47EB5F80, 0x47EB6BEC, 0x47EB7858, 0x47EB84C4,
 0x47EB9130, 0x47EB9D9D, 0x47EBAA0A, 0x47EBB677,
 0x47EBC2E4, 0x47EBCF51, 0x47EBDBBE, 0x47EBE82C,
 0x47EBF49A, 0x47EC0107, 0x47EC0D76, 0x47EC19E4,
 0x47EC2652, 0x47EC32C1, 0x47EC3F2F, 0x47EC4B9E,
 0x47EC580D, 0x47EC647C, 0x47EC70EC, 0x47EC7D5B,
 0x47EC89CB, 0x47EC963B, 0x47ECA2AB, 0x47ECAF1B,
 0x47ECBB8B, 0x47ECC7FC, 0x47ECD46D, 0x47ECE0DD,
 0x47ECED4E, 0x47ECF9C0, 0x47ED0631, 0x47ED12A2,
 0x47ED1F14, 0x47ED2B86, 0x47ED37F8, 0x47ED446A,
 0x47ED50DC, 0x47ED5D4F, 0x47ED69C1, 0x47ED7634,
 0x47ED82A7, 0x47ED8F1A, 0x47ED9B8D, 0x47EDA801,
 0x47EDB475, 0x47EDC0E8, 0x47EDCD5C, 0x47EDD9D0,
 0x47EDE645, 0x47EDF2B9, 0x47EDFF2E, 0x47EE0BA2,
 0x47EE1817, 0x47EE248C, 0x47EE3102, 0x47EE3D77,
 0x47EE49ED, 0x47EE5662, 0x47EE62D8, 0x47EE6F4E,
 0x47EE7BC4, 0x47EE883B, 0x47EE94B1, 0x47EEA128,
 0x47EEAD9F, 0x47EEBA16, 0x47EEC68D, 0x47EED304,
 0x47EEDF7C, 0x47EEEBF4, 0x47EEF86B, 0x47EF04E3,
 0x47EF115C, 0x47EF1DD4, 0x47EF2A4C, 0x47EF36C5,
 0x47EF433E, 0x47EF4FB7, 0x47EF5C30, 0x47EF68A9,
 0x47EF7523, 0x47EF819C, 0x47EF8E16, 0x47EF9A90,
 0x47EFA70A, 0x47EFB385, 0x47EFBFFF, 0x47EFCC7A,
 0x47EFD8F4, 0x47EFE56F, 0x47EFF1EA, 0x47EFFE66,
 0x47F00AE1, 0x47F0175D, 0x47F023D8, 0x47F03054,
 0x47F03CD0, 0x47F0494D, 0x47F055C9, 0x47F06246,
 0x47F06EC2, 0x47F07B3F, 0x47F087BC, 0x47F09439,
 0x47F0A0B7, 0x47F0AD34, 0x47F0B9B2, 0x47F0C630,
 0x47F0D2AE, 0x47F0DF2C, 0x47F0EBAA, 0x47F0F829,
 0x47F104A7, 0x47F11126, 0x47F11DA5, 0x47F12A24,
 0x47F136A4, 0x47F14323, 0x47F14FA3, 0x47F15C23,
 0x47F168A3, 0x47F17523, 0x47F181A3, 0x47F18E23,
 0x47F19AA4, 0x47F1A725, 0x47F1B3A6, 0x47F1C027,
 0x47F1CCA8, 0x47F1D929, 0x47F1E5AB, 0x47F1F22D,
 0x47F1FEAF, 0x47F20B31, 0x47F217B3, 0x47F22435,
 0x47F230B8, 0x47F23D3A, 0x47F249BD, 0x47F25640,
 0x47F262C4, 0x47F26F47, 0x47F27BCA, 0x47F2884E,
 0x47F294D2, 0x47F2A156, 0x47F2ADDA, 0x47F2BA5E,
 0x47F2C6E3, 0x47F2D367, 0x47F2DFEC, 0x47F2EC71,
 0x47F2F8F6, 0x47F3057C, 0x47F31201, 0x47F31E87,
 0x47F32B0C, 0x47F33792, 0x47F34418, 0x47F3509F,
 0x47F35D25, 0x47F369AC, 0x47F37632, 0x47F382B9,
 0x47F38F40, 0x47F39BC8, 0x47F3A84F, 0x47F3B4D6,
 0x47F3C15E, 0x47F3CDE6, 0x47F3DA6E, 0x47F3E6F6,
 0x47F3F37F, 0x47F40007, 0x47F40C90, 0x47F41919,
 0x47F425A2, 0x47F4322B, 0x47F43EB4, 0x47F44B3E,
 0x47F457C7, 0x47F46451, 0x47F470DB, 0x47F47D65,
 0x47F489EF, 0x47F4967A, 0x47F4A304, 0x47F4AF8F,
 0x47F4BC1A, 0x47F4C8A5, 0x47F4D530, 0x47F4E1BC,
 0x47F4EE47, 0x47F4FAD3, 0x47F5075F, 0x47F513EB,
 0x47F52077, 0x47F52D03, 0x47F53990, 0x47F5461D,
 0x47F552AA, 0x47F55F37, 0x47F56BC4, 0x47F57851,
 0x47F584DF, 0x47F5916C, 0x47F59DFA, 0x47F5AA88,
 0x47F5B716, 0x47F5C3A4, 0x47F5D033, 0x47F5DCC1,
 0x47F5E950, 0x47F5F5DF, 0x47F6026E, 0x47F60EFD,
 0x47F61B8D, 0x47F6281C, 0x47F634AC, 0x47F6413C,
 0x47F64DCC, 0x47F65A5C, 0x47F666ED, 0x47F6737D,
 0x47F6800E, 0x47F68C9F, 0x47F69930, 0x47F6A5C1,
 0x47F6B252, 0x47F6BEE4, 0x47F6CB75, 0x47F6D807,
 0x47F6E499, 0x47F6F12B, 0x47F6FDBE, 0x47F70A50,
 0x47F716E3, 0x47F72376, 0x47F73008, 0x47F73C9C,
 0x47F7492F, 0x47F755C2, 0x47F76256, 0x47F76EEA,
 0x47F77B7D, 0x47F78811, 0x47F794A6, 0x47F7A13A,
 0x47F7ADCF, 0x47F7BA63, 0x47F7C6F8, 0x47F7D38D,
 0x47F7E022, 0x47F7ECB8, 0x47F7F94D, 0x47F805E3,
 0x47F81279, 0x47F81F0F, 0x47F82BA5, 0x47F8383B,
 0x47F844D1, 0x47F85168, 0x47F85DFF, 0x47F86A96,
 0x47F8772D, 0x47F883C4, 0x47F8905C, 0x47F89CF3,
 0x47F8A98B, 0x47F8B623, 0x47F8C2BB, 0x47F8CF53,
 0x47F8DBEB, 0x47F8E884, 0x47F8F51C, 0x47F901B5,
 0x47F90E4E, 0x47F91AE7, 0x47F92781, 0x47F9341A,
 0x47F940B4, 0x47F94D4E, 0x47F959E8, 0x47F96682,
 0x47F9731C, 0x47F97FB6, 0x47F98C51, 0x47F998EC,
 0x47F9A587, 0x47F9B222, 0x47F9BEBD, 0x47F9CB58,
 0x47F9D7F4, 0x47F9E490, 0x47F9F12C, 0x47F9FDC8,
 0x47FA0A64, 0x47FA1700, 0x47FA239D, 0x47FA3039,
 0x47FA3CD6, 0x47FA4973, 0x47FA5610, 0x47FA62AD,
 0x47FA6F4B, 0x47FA7BE9, 0x47FA8886, 0x47FA9524,
 0x47FAA1C2, 0x47FAAE61, 0x47FABAFF, 0x47FAC79E,
 0x47FAD43C, 0x47FAE0DB, 0x47FAED7A, 0x47FAFA19,
 0x47FB06B9, 0x47FB1358, 0x47FB1FF8, 0x47FB2C98,
 0x47FB3938, 0x47FB45D8, 0x47FB5278, 0x47FB5F19,
 0x47FB6BB9, 0x47FB785A, 0x47FB84FB, 0x47FB919C,
 0x47FB9E3D, 0x47FBAADF, 0x47FBB780, 0x47FBC422,
 0x47FBD0C4, 0x47FBDD66, 0x47FBEA08, 0x47FBF6AB,
 0x47FC034D, 0x47FC0FF0, 0x47FC1C93, 0x47FC2936,
 0x47FC35D9, 0x47FC427C, 0x47FC4F20, 0x47FC5BC3,
 0x47FC6867, 0x47FC750B, 0x47FC81AF, 0x47FC8E54,
 0x47FC9AF8, 0x47FCA79D, 0x47FCB441, 0x47FCC0E6,
 0x47FCCD8B, 0x47FCDA31, 0x47FCE6D6, 0x47FCF37B,
 0x47FD0021, 0x47FD0CC7, 0x47FD196D, 0x47FD2613,
 0x47FD32B9, 0x47FD3F60, 0x47FD4C07, 0x47FD58AD,
 0x47FD6554, 0x47FD71FB, 0x47FD7EA3, 0x47FD8B4A,
 0x47FD97F2, 0x47FDA49A, 0x47FDB141, 0x47FDBDEA,
 0x47FDCA92, 0x47FDD73A, 0x47FDE3E3, 0x47FDF08B,
 0x47FDFD34, 0x47FE09DD, 0x47FE1686, 0x47FE2330,
 0x47FE2FD9, 0x47FE3C83, 0x47FE492D, 0x47FE55D7,
 0x47FE6281, 0x47FE6F2B, 0x47FE7BD5, 0x47FE8880,
 0x47FE952B, 0x47FEA1D6, 0x47FEAE81, 0x47FEBB2C,
 0x47FEC7D7, 0x47FED483, 0x47FEE12F, 0x47FEEDDA,
 0x47FEFA86, 0x47FF0733, 0x47FF13DF, 0x47FF208B,
 0x47FF2D38, 0x47FF39E5, 0x47FF4692, 0x47FF533F,
 0x47FF5FEC, 0x47FF6C9A, 0x47FF7947, 0x47FF85F5,
 0x47FF92A3, 0x47FF9F51, 0x47FFABFF, 0x47FFB8AD,
 0x47FFC55C, 0x47FFD20B, 0x47FFDEB9, 0x47FFEB68,
 0x47FFF818, 0x48000263, 0x480008BB, 0x48000F13,
 0x4800156B, 0x48001BC3, 0x4800221B, 0x48002873,
 0x48002ECB, 0x48003523, 0x48003B7C, 0x480041D4,
 0x4800482D, 0x48004E85, 0x480054DE, 0x48005B37,
 0x48006190, 0x480067E9, 0x48006E42, 0x4800749B,
 0x48007AF4, 0x4800814D, 0x480087A6, 0x48008E00,
 0x48009459, 0x48009AB3, 0x4800A10C, 0x4800A766,
 0x4800ADC0, 0x4800B41A, 0x4800BA74, 0x4800C0CE,
 0x4800C728, 0x4800CD82, 0x4800D3DC, 0x4800DA36,
 0x4800E091, 0x4800E6EB, 0x4800ED46, 0x4800F3A0,
 0x4800F9FB, 0x48010056, 0x480106B1, 0x48010D0C,
 0x48011367, 0x480119C2, 0x4801201D, 0x48012678,
 0x48012CD4, 0x4801332F, 0x4801398B, 0x48013FE6,
 0x48014642, 0x48014C9E, 0x480152F9, 0x48015955,
 0x48015FB1, 0x4801660D, 0x48016C69, 0x480172C6,
 0x48017922, 0x48017F7E, 0x480185DB, 0x48018C37,
 0x48019294, 0x480198F0, 0x48019F4D, 0x4801A5AA,
 0x4801AC07, 0x4801B264, 0x4801B8C1, 0x4801BF1E,
 0x4801C57B, 0x4801CBD9, 0x4801D236, 0x4801D893,
 0x4801DEF1, 0x4801E54E, 0x4801EBAC, 0x4801F20A,
 0x4801F868, 0x4801FEC6, 0x48020524, 0x48020B82,
 0x480211E0, 0x4802183E, 0x48021E9C, 0x480224FB,
 0x48022B59, 0x480231B8, 0x48023816, 0x48023E75,
 0x480244D4, 0x48024B33, 0x48025192, 0x480257F1,
 0x48025E50, 0x480264AF, 0x48026B0E, 0x4802716D,
 0x480277CD, 0x48027E2C, 0x4802848C, 0x48028AEC,
 0x4802914B, 0x480297AB, 0x48029E0B, 0x4802A46B,
 0x4802AACB, 0x4802B12B, 0x4802B78B, 0x4802BDEB,
 0x4802C44C, 0x4802CAAC, 0x4802D10D, 0x4802D76D,
 0x4802DDCE, 0x4802E42F, 0x4802EA8F, 0x4802F0F0,
 0x4802F751, 0x4802FDB2, 0x48030413, 0x48030A74,
 0x480310D6, 0x48031737, 0x48031D98, 0x480323FA,
 0x48032A5C, 0x480330BD, 0x4803371F, 0x48033D81,
 0x480343E3, 0x48034A45, 0x480350A7, 0x48035709,
 0x48035D6B, 0x480363CD, 0x48036A30, 0x48037092,
 0x480376F4, 0x48037D57, 0x480383BA, 0x48038A1C,
 0x4803907F, 0x480396E2, 0x48039D45, 0x4803A3A8,
 0x4803AA0B, 0x4803B06E, 0x4803B6D2, 0x4803BD35,
 0x4803C399, 0x4803C9FC, 0x4803D060, 0x4803D6C3,
 0x4803DD27, 0x4803E38B, 0x4803E9EF, 0x4803F053,
 0x4803F6B7, 0x4803FD1B, 0x4804037F, 0x480409E3,
 0x48041048, 0x480416AC, 0x48041D11, 0x48042375,
 0x480429DA, 0x4804303F, 0x480436A4, 0x48043D08,
 0x4804436D, 0x480449D2, 0x48045038, 0x4804569D,
 0x48045D02, 0x48046367, 0x480469CD, 0x48047032,
 0x48047698, 0x48047CFE, 0x48048363, 0x480489C9,
 0x4804902F, 0x48049695, 0x48049CFB, 0x4804A361,
 0x4804A9C8, 0x4804B02E, 0x4804B694, 0x4804BCFB,
 0x4804C361, 0x4804C9C8, 0x4804D02F, 0x4804D695,
 0x4804DCFC, 0x4804E363, 0x4804E9CA, 0x4804F031,
 0x4804F698, 0x4804FCFF, 0x48050367, 0x480509CE,
 0x48051036, 0x4805169D, 0x48051D05, 0x4805236C,
 0x480529D4, 0x4805303C, 0x480536A4, 0x48053D0C,
 0x48054374, 0x480549DC, 0x48055044, 0x480556AD,
 0x48055D15, 0x4805637D, 0x480569E6, 0x4805704F,
 0x480576B7, 0x48057D20, 0x48058389, 0x480589F2,
 0x4805905B, 0x480596C4, 0x48059D2D, 0x4805A396,
 0x4805A9FF, 0x4805B069, 0x4805B6D2, 0x4805BD3C,
 0x4805C3A5, 0x4805CA0F, 0x4805D079, 0x4805D6E3,
 0x4805DD4D, 0x4805E3B7, 0x4805EA21, 0x4805F08B,
 0x4805F6F5, 0x4805FD5F, 0x480603CA, 0x48060A34,
 0x4806109F, 0x48061709, 0x48061D74, 0x480623DF,
 0x48062A4A, 0x480630B4, 0x4806371F, 0x48063D8A,
 0x480643F6, 0x48064A61, 0x480650CC, 0x48065738,
 0x48065DA3, 0x4806640E, 0x48066A7A, 0x480670E6,
 0x48067752, 0x48067DBD, 0x48068429, 0x48068A95,
 0x48069101, 0x4806976D, 0x48069DDA, 0x4806A446,
 0x4806AAB2, 0x4806B11F, 0x4806B78B, 0x4806BDF8,
 0x4806C465, 0x4806CAD1, 0x4806D13E, 0x4806D7AB,
 0x4806DE18, 0x4806E485, 0x4806EAF2, 0x4806F15F,
 0x4806F7CD, 0x4806FE3A, 0x480704A7, 0x48070B15,
 0x48071183, 0x480717F0, 0x48071E5E, 0x480724CC,
 0x48072B3A, 0x480731A8, 0x48073816, 0x48073E84,
 0x480744F2, 0x48074B60, 0x480751CF, 0x4807583D,
 0x48075EAC, 0x4807651A, 0x48076B89, 0x480771F8,
 0x48077866, 0x48077ED5, 0x48078544, 0x48078BB3,
 0x48079222, 0x48079892, 0x48079F01, 0x4807A570,
 0x4807ABE0, 0x4807B24F, 0x4807B8BF, 0x4807BF2E,
 0x4807C59E, 0x4807CC0E, 0x4807D27E, 0x4807D8EE,
 0x4807DF5E, 0x4807E5CE, 0x4807EC3E, 0x4807F2AE,
 0x4807F91F, 0x4807FF8F, 0x48080600, 0x48080C70,
 0x480812E1, 0x48081952, 0x48081FC2, 0x48082633,
 0x48082CA4, 0x48083315, 0x48083986, 0x48083FF8,
 0x48084669, 0x48084CDA, 0x4808534C, 0x480859BD,
 0x4808602F, 0x480866A0, 0x48086D12, 0x48087384,
 0x480879F6, 0x48088068, 0x480886DA, 0x48088D4C,
 0x480893BE, 0x48089A30, 0x4808A0A2, 0x4808A715,
 0x4808AD87, 0x4808B3FA, 0x4808BA6C, 0x4808C0DF,
 0x4808C752, 0x4808CDC5, 0x4808D438, 0x4808DAAB,
 0x4808E11E, 0x4808E791, 0x4808EE04, 0x4808F477,
 0x4808FAEB, 0x4809015E, 0x480907D2, 0x48090E45,
 0x480914B9, 0x48091B2D, 0x480921A1, 0x48092815,
 0x48092E89, 0x480934FD, 0x48093B71, 0x480941E5,
 0x48094859, 0x48094ECE, 0x48095542, 0x48095BB7,
 0x4809622B, 0x480968A0, 0x48096F15, 0x4809758A,
 0x48097BFE, 0x48098273, 0x480988E8, 0x48098F5E,
 0x480995D3, 0x48099C48, 0x4809A2BD, 0x4809A933,
 0x4809AFA8, 0x4809B61E, 0x4809BC94, 0x4809C309,
 0x4809C97F, 0x4809CFF5, 0x4809D66B, 0x4809DCE1,
 0x4809E357, 0x4809E9CD, 0x4809F044, 0x4809F6BA,
 0x4809FD30, 0x480A03A7, 0x480A0A1D, 0x480A1094,
 0x480A170B, 0x480A1D82, 0x480A23F8, 0x480A2A6F,
 0x480A30E6, 0x480A375E, 0x480A3DD5, 0x480A444C,
 0x480A4AC3, 0x480A513B, 0x480A57B2, 0x480A5E2A,
 0x480A64A1, 0x480A6B19, 0x480A7191, 0x480A7809,
 0x480A7E81, 0x480A84F9, 0x480A8B71, 0x480A91E9,
 0x480A9861, 0x480A9ED9, 0x480AA552, 0x480AABCA,
 0x480AB243, 0x480AB8BB, 0x480ABF34, 0x480AC5AD,
 0x480ACC26, 0x480AD29F, 0x480AD918, 0x480ADF91,
 0x480AE60A, 0x480AEC83, 0x480AF2FC, 0x480AF976,
 0x480AFFEF, 0x480B0669, 0x480B0CE2, 0x480B135C,
 0x480B19D6, 0x480B204F, 0x480B26C9, 0x480B2D43,
 0x480B33BD, 0x480B3A37, 0x480B40B2, 0x480B472C,
 0x480B4DA6, 0x480B5421, 0x480B5A9B, 0x480B6116,
 0x480B6790, 0x480B6E0B, 0x480B7486, 0x480B7B01,
 0x480B817C, 0x480B87F7, 0x480B8E72, 0x480B94ED,
 0x480B9B68, 0x480BA1E3, 0x480BA85F, 0x480BAEDA,
 0x480BB556, 0x480BBBD1, 0x480BC24D, 0x480BC8C9,
 0x480BCF45, 0x480BD5C1, 0x480BDC3D, 0x480BE2B9,
 0x480BE935, 0x480BEFB1, 0x480BF62D, 0x480BFCAA,
 0x480C0326, 0x480C09A3, 0x480C101F, 0x480C169C,
 0x480C1D19, 0x480C2396, 0x480C2A13, 0x480C3090,
 0x480C370D, 0x480C3D8A, 0x480C4407, 0x480C4A84,
 0x480C5102, 0x480C577F, 0x480C5DFC, 0x480C647A,
 0x480C6AF8, 0x480C7175, 0x480C77F3, 0x480C7E71,
 0x480C84EF, 0x480C8B6D, 0x480C91EB, 0x480C9869,
 0x480C9EE8, 0x480CA566, 0x480CABE4, 0x480CB263,
 0x480CB8E1, 0x480CBF60, 0x480CC5DF, 0x480CCC5D,
 0x480CD2DC, 0x480CD95B, 0x480CDFDA, 0x480CE659,
 0x480CECD8, 0x480CF358, 0x480CF9D7, 0x480D0056,
 0x480D06D6, 0x480D0D55, 0x480D13D5, 0x480D1A55,
 0x480D20D4, 0x480D2754, 0x480D2DD4, 0x480D3454,
 0x480D3AD4, 0x480D4154, 0x480D47D4, 0x480D4E55,
 0x480D54D5, 0x480D5B55, 0x480D61D6, 0x480D6856,
 0x480D6ED7, 0x480D7558, 0x480D7BD9, 0x480D8259,
 0x480D88DA, 0x480D8F5B, 0x480D95DD, 0x480D9C5E,
 0x480DA2DF, 0x480DA960, 0x480DAFE2, 0x480DB663,
 0x480DBCE5, 0x480DC366, 0x480DC9E8, 0x480DD06A,
 0x480DD6EC, 0x480DDD6E, 0x480DE3EF, 0x480DEA72,
 0x480DF0F4, 0x480DF776, 0x480DFDF8, 0x480E047B,
 0x480E0AFD, 0x480E1180, 0x480E1802, 0x480E1E85,
 0x480E2507, 0x480E2B8A, 0x480E320D, 0x480E3890,
 0x480E3F13, 0x480E4596, 0x480E4C19, 0x480E529D,
 0x480E5920, 0x480E5FA3, 0x480E6627, 0x480E6CAA,
 0x480E732E, 0x480E79B2, 0x480E8036, 0x480E86B9,
 0x480E8D3D, 0x480E93C1, 0x480E9A45, 0x480EA0CA,
 0x480EA74E, 0x480EADD2, 0x480EB457, 0x480EBADB,
 0x480EC15F, 0x480EC7E4, 0x480ECE69, 0x480ED4EE,
 0x480EDB72, 0x480EE1F7, 0x480EE87C, 0x480EEF01,
 0x480EF586, 0x480EFC0C, 0x480F0291, 0x480F0916,
 0x480F0F9C, 0x480F1621, 0x480F1CA7, 0x480F232C,
 0x480F29B2, 0x480F3038, 0x480F36BE, 0x480F3D44,
 0x480F43CA, 0x480F4A50, 0x480F50D6, 0x480F575C,
 0x480F5DE2, 0x480F6469, 0x480F6AEF, 0x480F7176,
 0x480F77FC, 0x480F7E83, 0x480F850A, 0x480F8B91,
 0x480F9217, 0x480F989E, 0x480F9F25, 0x480FA5AD,
 0x480FAC34, 0x480FB2BB, 0x480FB942, 0x480FBFCA,
 0x480FC651, 0x480FCCD9, 0x480FD361, 0x480FD9E8,
 0x480FE070, 0x480FE6F8, 0x480FED80, 0x480FF408,
 0x480FFA90, 0x48100118, 0x481007A0, 0x48100E29,
 0x481014B1, 0x48101B39, 0x481021C2, 0x4810284B,
 0x48102ED3, 0x4810355C, 0x48103BE5, 0x4810426E,
 0x481048F7, 0x48104F80, 0x48105609, 0x48105C92,
 0x4810631B, 0x481069A5, 0x4810702E, 0x481076B8,
 0x48107D41, 0x481083CB, 0x48108A55, 0x481090DE,
 0x48109768, 0x48109DF2, 0x4810A47C, 0x4810AB06,
 0x4810B190, 0x4810B81B, 0x4810BEA5, 0x4810C52F,
 0x4810CBBA, 0x4810D244, 0x4810D8CF, 0x4810DF5A,
 0x4810E5E4, 0x4810EC6F, 0x4810F2FA, 0x4810F985,
 0x48110010, 0x4811069B, 0x48110D26, 0x481113B2,
 0x48111A3D, 0x481120C8, 0x48112754, 0x48112DDF,
 0x4811346B, 0x48113AF7, 0x48114183, 0x4811480E,
 0x48114E9A, 0x48115526, 0x48115BB2, 0x4811623F,
 0x481168CB, 0x48116F57, 0x481175E3, 0x48117C70,
 0x481182FC, 0x48118989, 0x48119016, 0x481196A2,
 0x48119D2F, 0x4811A3BC, 0x4811AA49, 0x4811B0D6,
 0x4811B763, 0x4811BDF0, 0x4811C47E, 0x4811CB0B,
 0x4811D198, 0x4811D826, 0x4811DEB3, 0x4811E541,
 0x4811EBCF, 0x4811F25D, 0x4811F8EA, 0x4811FF78,
 0x48120606, 0x48120C94, 0x48121323, 0x481219B1,
 0x4812203F, 0x481226CD, 0x48122D5C, 0x481233EA,
 0x48123A79, 0x48124108, 0x48124796, 0x48124E25,
 0x481254B4, 0x48125B43, 0x481261D2, 0x48126861,
 0x48126EF0, 0x4812757F, 0x48127C0F, 0x4812829E,
 0x4812892E, 0x48128FBD, 0x4812964D, 0x48129CDC,
 0x4812A36C, 0x4812A9FC, 0x4812B08C, 0x4812B71C,
 0x4812BDAC, 0x4812C43C, 0x4812CACC, 0x4812D15D,
 0x4812D7ED, 0x4812DE7D, 0x4812E50E, 0x4812EB9E,
 0x4812F22F, 0x4812F8C0, 0x4812FF50, 0x481305E1,
 0x48130C72, 0x48131303, 0x48131994, 0x48132025,
 0x481326B7, 0x48132D48, 0x481333D9, 0x48133A6B,
 0x481340FC, 0x4813478E, 0x48134E20, 0x481354B1,
 0x48135B43, 0x481361D5, 0x48136867, 0x48136EF9,
 0x4813758B, 0x48137C1D, 0x481382B0, 0x48138942,
 0x48138FD4, 0x48139667, 0x48139CF9, 0x4813A38C,
 0x4813AA1F, 0x4813B0B1, 0x4813B744, 0x4813BDD7,
 0x4813C46A, 0x4813CAFD, 0x4813D190, 0x4813D823,
 0x4813DEB7, 0x4813E54A, 0x4813EBDD, 0x4813F271,
 0x4813F904, 0x4813FF98, 0x4814062C, 0x48140CC0,
 0x48141353, 0x481419E7, 0x4814207B, 0x4814270F,
 0x48142DA4, 0x48143438, 0x48143ACC, 0x48144160,
 0x481447F5, 0x48144E89, 0x4814551E, 0x48145BB3,
 0x48146247, 0x481468DC, 0x48146F71, 0x48147606,
 0x48147C9B, 0x48148330, 0x481489C5, 0x4814905B,
 0x481496F0, 0x48149D85, 0x4814A41B, 0x4814AAB0,
 0x4814B146, 0x4814B7DC, 0x4814BE71, 0x4814C507,
 0x4814CB9D, 0x4814D233, 0x4814D8C9, 0x4814DF5F,
 0x4814E5F5, 0x4814EC8C, 0x4814F322, 0x4814F9B8,
 0x4815004F, 0x481506E5, 0x48150D7C, 0x48151413,
 0x48151AAA, 0x48152140, 0x481527D7, 0x48152E6E,
 0x48153505, 0x48153B9D, 0x48154234, 0x481548CB,
 0x48154F62, 0x481555FA, 0x48155C91, 0x48156329,
 0x481569C1, 0x48157058, 0x481576F0, 0x48157D88,
 0x48158420, 0x48158AB8, 0x48159150, 0x481597E8,
 0x48159E80, 0x4815A519, 0x4815ABB1, 0x4815B249,
 0x4815B8E2, 0x4815BF7B, 0x4815C613, 0x4815CCAC,
 0x4815D345, 0x4815D9DE, 0x4815E077, 0x4815E710,
 0x4815EDA9, 0x4815F442, 0x4815FADB, 0x48160174,
 0x4816080E, 0x48160EA7, 0x48161541, 0x48161BDA,
 0x48162274, 0x4816290E, 0x48162FA8, 0x48163642,
 0x48163CDC, 0x48164376, 0x48164A10, 0x481650AA,
 0x48165744, 0x48165DDF, 0x48166479, 0x48166B13,
 0x481671AE, 0x48167849, 0x48167EE3, 0x4816857E,
 0x48168C19, 0x481692B4, 0x4816994F, 0x48169FEA,
 0x4816A685, 0x4816AD20, 0x4816B3BB, 0x4816BA57,
 0x4816C0F2, 0x4816C78E, 0x4816CE29, 0x4816D4C5,
 0x4816DB61, 0x4816E1FC, 0x4816E898, 0x4816EF34,
 0x4816F5D0, 0x4816FC6C, 0x48170308, 0x481709A5,
 0x48171041, 0x481716DD, 0x48171D7A, 0x48172416,
 0x48172AB3, 0x4817314F, 0x481737EC, 0x48173E89,
 0x48174526, 0x48174BC3, 0x48175260, 0x481758FD,
 0x48175F9A, 0x48176637, 0x48176CD4, 0x48177372,
 0x48177A0F, 0x481780AD, 0x4817874A, 0x48178DE8,
 0x48179486, 0x48179B24, 0x4817A1C1, 0x4817A85F,
 0x4817AEFD, 0x4817B59C, 0x4817BC3A, 0x4817C2D8,
 0x4817C976, 0x4817D015, 0x4817D6B3, 0x4817DD52,
 0x4817E3F0, 0x4817EA8F, 0x4817F12E, 0x4817F7CC,
 0x4817FE6B, 0x4818050A, 0x48180BA9, 0x48181248,
 0x481818E8, 0x48181F87, 0x48182626, 0x48182CC6,
 0x48183365, 0x48183A05, 0x481840A4, 0x48184744,
 0x48184DE4, 0x48185483, 0x48185B23, 0x481861C3,
 0x48186863, 0x48186F03, 0x481875A4, 0x48187C44,
 0x481882E4, 0x48188985, 0x48189025, 0x481896C6,
 0x48189D66, 0x4818A407, 0x4818AAA8, 0x4818B149,
 0x4818B7E9, 0x4818BE8A, 0x4818C52B, 0x4818CBCD,
 0x4818D26E, 0x4818D90F, 0x4818DFB0, 0x4818E652,
 0x4818ECF3, 0x4818F395, 0x4818FA36, 0x481900D8,
 0x4819077A, 0x48190E1C, 0x481914BE, 0x48191B60,
 0x48192202, 0x481928A4, 0x48192F46, 0x481935E8,
 0x48193C8B, 0x4819432D, 0x481949D0, 0x48195072,
 0x48195715, 0x48195DB7, 0x4819645A, 0x48196AFD,
 0x481971A0, 0x48197843, 0x48197EE6, 0x48198589,
 0x48198C2C, 0x481992D0, 0x48199973, 0x4819A016,
 0x4819A6BA, 0x4819AD5D, 0x4819B401, 0x4819BAA5,
 0x4819C149, 0x4819C7EC, 0x4819CE90, 0x4819D534,
 0x4819DBD8, 0x4819E27D, 0x4819E921, 0x4819EFC5,
 0x4819F669, 0x4819FD0E, 0x481A03B2, 0x481A0A57,
 0x481A10FB, 0x481A17A0, 0x481A1E45, 0x481A24EA,
 0x481A2B8F, 0x481A3234, 0x481A38D9, 0x481A3F7E,
 0x481A4623, 0x481A4CC8, 0x481A536E, 0x481A5A13,
 0x481A60B9, 0x481A675E, 0x481A6E04, 0x481A74AA,
 0x481A7B4F, 0x481A81F5, 0x481A889B, 0x481A8F41,
 0x481A95E7, 0x481A9C8D, 0x481AA334, 0x481AA9DA,
 0x481AB080, 0x481AB727, 0x481ABDCD, 0x481AC474,
 0x481ACB1A, 0x481AD1C1, 0x481AD868, 0x481ADF0F,
 0x481AE5B6, 0x481AEC5D, 0x481AF304, 0x481AF9AB,
 0x481B0052, 0x481B06F9, 0x481B0DA1, 0x481B1448,
 0x481B1AF0, 0x481B2197, 0x481B283F, 0x481B2EE7,
 0x481B358E, 0x481B3C36, 0x481B42DE, 0x481B4986,
 0x481B502E, 0x481B56D6, 0x481B5D7E, 0x481B6427,
 0x481B6ACF, 0x481B7178, 0x481B7820, 0x481B7EC9,
 0x481B8571, 0x481B8C1A, 0x481B92C3, 0x481B996C,
 0x481BA014, 0x481BA6BD, 0x481BAD67, 0x481BB410,
 0x481BBAB9, 0x481BC162, 0x481BC80C, 0x481BCEB5,
 0x481BD55E, 0x481BDC08, 0x481BE2B2, 0x481BE95B,
 0x481BF005, 0x481BF6AF, 0x481BFD59, 0x481C0403,
 0x481C0AAD, 0x481C1157, 0x481C1801, 0x481C1EAC,
 0x481C2556, 0x481C2C00, 0x481C32AB, 0x481C3955,
 0x481C4000, 0x481C46AB, 0x481C4D55, 0x481C5400,
 0x481C5AAB, 0x481C6156, 0x481C6801, 0x481C6EAC,
 0x481C7558, 0x481C7C03, 0x481C82AE, 0x481C895A,
 0x481C9005, 0x481C96B1, 0x481C9D5C, 0x481CA408,
 0x481CAAB4, 0x481CB160, 0x481CB80C, 0x481CBEB7,
 0x481CC564, 0x481CCC10, 0x481CD2BC, 0x481CD968,
 0x481CE014, 0x481CE6C1, 0x481CED6D, 0x481CF41A,
 0x481CFAC7, 0x481D0173, 0x481D0820, 0x481D0ECD,
 0x481D157A, 0x481D1C27, 0x481D22D4, 0x481D2981,
 0x481D302E, 0x481D36DB, 0x481D3D89, 0x481D4436,
 0x481D4AE3, 0x481D5191, 0x481D583F, 0x481D5EEC,
 0x481D659A, 0x481D6C48, 0x481D72F6, 0x481D79A4,
 0x481D8052, 0x481D8700, 0x481D8DAE, 0x481D945C,
 0x481D9B0B, 0x481DA1B9, 0x481DA868, 0x481DAF16,
 0x481DB5C5, 0x481DBC73, 0x481DC322, 0x481DC9D1,
 0x481DD080, 0x481DD72F, 0x481DDDDE, 0x481DE48D,
 0x481DEB3C, 0x481DF1EB, 0x481DF89B, 0x481DFF4A,
 0x481E05F9, 0x481E0CA9, 0x481E1359, 0x481E1A08,
 0x481E20B8, 0x481E2768, 0x481E2E18, 0x481E34C8,
 0x481E3B78, 0x481E4228, 0x481E48D8, 0x481E4F88,
 0x481E5638, 0x481E5CE9, 0x481E6399, 0x481E6A4A,
 0x481E70FA, 0x481E77AB, 0x481E7E5C, 0x481E850C,
 0x481E8BBD, 0x481E926E, 0x481E991F, 0x481E9FD0,
 0x481EA682, 0x481EAD33, 0x481EB3E4, 0x481EBA95,
 0x481EC147, 0x481EC7F8, 0x481ECEAA, 0x481ED55C,
 0x481EDC0D, 0x481EE2BF, 0x481EE971, 0x481EF023,
 0x481EF6D5, 0x481EFD87, 0x481F0439, 0x481F0AEB,
 0x481F119D, 0x481F1850, 0x481F1F02, 0x481F25B5,
 0x481F2C67, 0x481F331A, 0x481F39CD, 0x481F407F,
 0x481F4732, 0x481F4DE5, 0x481F5498, 0x481F5B4B,
 0x481F61FE, 0x481F68B1, 0x481F6F65, 0x481F7618,
 0x481F7CCB, 0x481F837F, 0x481F8A33, 0x481F90E6,
 0x481F979A, 0x481F9E4E, 0x481FA501, 0x481FABB5,
 0x481FB269, 0x481FB91D, 0x481FBFD1, 0x481FC686,
 0x481FCD3A, 0x481FD3EE, 0x481FDAA3, 0x481FE157,
 0x481FE80C, 0x481FEEC0, 0x481FF575, 0x481FFC2A,
 0x482002DE, 0x48200993, 0x48201048, 0x482016FD,
 0x48201DB2, 0x48202467, 0x48202B1D, 0x482031D2,
 0x48203887, 0x48203F3D, 0x482045F2, 0x48204CA8,
 0x4820535E, 0x48205A13, 0x482060C9, 0x4820677F,
 0x48206E35, 0x482074EB, 0x48207BA1, 0x48208257,
 0x4820890D, 0x48208FC4, 0x4820967A, 0x48209D30,
 0x4820A3E7, 0x4820AA9D, 0x4820B154, 0x4820B80B,
 0x4820BEC2, 0x4820C578, 0x4820CC2F, 0x4820D2E6,
 0x4820D99D, 0x4820E054, 0x4820E70C, 0x4820EDC3,
 0x4820F47A, 0x4820FB32, 0x482101E9, 0x482108A1,
 0x48210F58, 0x48211610, 0x48211CC8, 0x48212380,
 0x48212A38, 0x482130EF, 0x482137A8, 0x48213E60,
 0x48214518, 0x48214BD0, 0x48215288, 0x48215941,
 0x48215FF9, 0x482166B2, 0x48216D6A, 0x48217423,
 0x48217ADC, 0x48218195, 0x4821884D, 0x48218F06,
 0x482195BF, 0x48219C78, 0x4821A332
};
static unsigned int s_Tan1_1[ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000000, 0x3E58658C, 0x3EBB67AF, 0x3F000000,
 0x3F224C29, 0x3F49E69D, 0x3F800000, 0x3FAED9EC,
 0x40176CF6, 0x59800000, 0xBFAED9EC, 0xBEBB67AF,
 0xA50D3000, 0x3E58658C, 0x3EBB67AF, 0x3F000000
};
static unsigned int s_Tan2_1[ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x3F800000, 0x3F49E69D, 0x3F224C29, 0x3F000000,
 0x3EBB67AF, 0x3E58658C, 0x248D3000, 0xBEBB67AF,
 0xBFAED9EC, 0xD9800000, 0x40176CF6, 0x3FAED9EC,
 0x3F800000, 0x3F49E69D, 0x3F224C29, 0x3F000000
};
static unsigned int s_Tan1_2[ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000000, 0x3E9903FB, 0x3F0483EE, 0x3F3504F3,
 0x3F6585F8, 0x3F8EC3F4, 0x3FB504F3, 0x3FF746EA,
 0x405625EF, 0x59B504F3, 0xBFF746EA, 0xBF0483EE,
 0xA547AB56, 0x3E9903FB, 0x3F0483EE, 0x3F3504F3
};
static unsigned int s_Tan2_2[ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x3FB504F3, 0x3F8EC3F4, 0x3F6585F8, 0x3F3504F3,
 0x3F0483EE, 0x3E9903FB, 0x24C7AB56, 0xBF0483EE,
 0xBFF746EA, 0xD9B504F3, 0x405625EF, 0x3FF746EA,
 0x3FB504F3, 0x3F8EC3F4, 0x3F6585F8, 0x3F3504F3
};
static unsigned int s_Pow1_1[ 2 ][ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x3F800000, 0x3F5744FD, 0x3F800000, 0x3F3504F3,
   0x3F800000, 0x3F1837F0, 0x3F800000, 0x3F000000,
   0x3F800000, 0x3ED744FD, 0x3F800000, 0x3EB504F3,
   0x3F800000, 0x3E9837F0, 0x3F800000, 0x3E800000
 },
 { 0x3F800000, 0x3F3504F3, 0x3F800000, 0x3F000000,
   0x3F800000, 0x3EB504F3, 0x3F800000, 0x3E800000,
   0x3F800000, 0x3E3504F3, 0x3F800000, 0x3E000000,
   0x3F800000, 0x3DB504F3, 0x3F800000, 0x3D800000
 }
};
static unsigned int s_Pow2_1[ 2 ][ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x3F800000, 0x3F800000, 0x3F5744FD, 0x3F800000,
   0x3F3504F3, 0x3F800000, 0x3F1837F0, 0x3F800000,
   0x3F000000, 0x3F800000, 0x3ED744FD, 0x3F800000,
   0x3EB504F3, 0x3F800000, 0x3E9837F0, 0x3F800000
 },
 { 0x3F800000, 0x3F800000, 0x3F3504F3, 0x3F800000,
   0x3F000000, 0x3F800000, 0x3EB504F3, 0x3F800000,
   0x3E800000, 0x3F800000, 0x3E3504F3, 0x3F800000,
   0x3E000000, 0x3F800000, 0x3DB504F3, 0x3F800000
 }
};
static unsigned int s_Pow1_2[ 2 ][ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x3FB504F3, 0x3F9837F0, 0x3FB504F3, 0x3F800000,
   0x3FB504F3, 0x3F5744FD, 0x3FB504F3, 0x3F3504F3,
   0x3FB504F3, 0x3F1837F0, 0x3FB504F3, 0x3F000000,
   0x3FB504F3, 0x3ED744FD, 0x3FB504F3, 0x3EB504F3
 },
 { 0x3FB504F3, 0x3F800000, 0x3FB504F3, 0x3F3504F3,
   0x3FB504F3, 0x3F000000, 0x3FB504F3, 0x3EB504F3,
   0x3FB504F3, 0x3E800000, 0x3FB504F3, 0x3E3504F3,
   0x3FB504F3, 0x3E000000, 0x3FB504F3, 0x3DB504F3
 }
};
static unsigned int s_Pow2_2[ 2 ][ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x3FB504F3, 0x3FB504F3, 0x3F9837F0, 0x3FB504F3,
   0x3F800000, 0x3FB504F3, 0x3F5744FD, 0x3FB504F3,
   0x3F3504F3, 0x3FB504F3, 0x3F1837F0, 0x3FB504F3,
   0x3F000000, 0x3FB504F3, 0x3ED744FD, 0x3FB504F3
 },
 { 0x3FB504F3, 0x3FB504F3, 0x3F800000, 0x3FB504F3,
   0x3F3504F3, 0x3FB504F3, 0x3F000000, 0x3FB504F3,
   0x3EB504F3, 0x3FB504F3, 0x3E800000, 0x3FB504F3,
   0x3E3504F3, 0x3FB504F3, 0x3E000000, 0x3FB504F3
 }
};
static char s_LongLimit[ 9 ][ 23 ] = {
 { 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03,
   0x03, 0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x08,
   0x0A, 0x0C, 0x0E, 0x11, 0x14, 0x18, 0x20
 },
 { 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03,
   0x03, 0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x08,
   0x0A, 0x0B, 0x0E, 0x10, 0x13, 0x16, 0x20
 },
 { 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03,
   0x03, 0x03, 0x04, 0x05, 0x05, 0x07, 0x08, 0x0A,
   0x0C, 0x0E, 0x11, 0x15, 0x1A, 0x1F, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
   0x04, 0x05, 0x05, 0x06, 0x07, 0x09, 0x0A, 0x0C,
   0x0E, 0x11, 0x14, 0x17, 0x1B, 0x1E, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
   0x04, 0x05, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C,
   0x0E, 0x10, 0x13, 0x17, 0x1B, 0x1F, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
   0x04, 0x05, 0x05, 0x06, 0x07, 0x09, 0x0A, 0x0C,
   0x0E, 0x11, 0x14, 0x17, 0x1B, 0x1E, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
   0x04, 0x05, 0x05, 0x06, 0x07, 0x09, 0x0A, 0x0C,
   0x0E, 0x11, 0x14, 0x17, 0x1B, 0x1E, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
   0x04, 0x05, 0x05, 0x06, 0x07, 0x09, 0x0A, 0x0C,
   0x0E, 0x11, 0x14, 0x17, 0x1B, 0x1E, 0x20
 },
 { 0x01, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06,
   0x07, 0x08, 0x0A, 0x0C, 0x0E, 0x10, 0x14, 0x17,
   0x1B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
 }
};
static char s_ShortLimit[ 9 ][ 14 ] = {
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x07,
   0x09, 0x0B, 0x0E, 0x12, 0x17, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x07,
   0x09, 0x0B, 0x0E, 0x11, 0x15, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x07,
   0x0A, 0x0D, 0x12, 0x17, 0x1E, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x04, 0x06, 0x07,
   0x0A, 0x0D, 0x11, 0x16, 0x1D, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x05, 0x06, 0x08,
   0x0B, 0x0E, 0x12, 0x17, 0x1E, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x05, 0x06, 0x08,
   0x0B, 0x0E, 0x12, 0x17, 0x1D, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x05, 0x06, 0x08,
   0x0B, 0x0E, 0x12, 0x17, 0x1D, 0x20
 },
 { 0x01, 0x01, 0x02, 0x02, 0x03, 0x05, 0x06, 0x08,
   0x0B, 0x0E, 0x12, 0x17, 0x1D, 0x20
 },
 { 0x01, 0x02, 0x03, 0x04, 0x06, 0x09, 0x0C, 0x10,
   0x15, 0x1B, 0x1B, 0x1C, 0x1C, 0x20
 }
};
static unsigned int s_AACA[ 8 ] = {
 0xBF03B5FE, 0xBEF186DA, 0xBEA07302, 0xBE3A4774,
 0xBDC1B01D, 0xBD27CB87, 0xBC68A11D, 0xBB727B46
};
static unsigned int s_AACS[ 8 ] = {
 0x3F5B84A8, 0x3F61B9D8, 0x3F731ADD, 0x3F7BBA81,
 0x3F7EDA41, 0x3F7FC8FD, 0x3F7FF965, 0x3F7FFF8D
};
static unsigned int s_Win[ 4 ][ 36 ] = {
 { 0x3D043A95, 0x3DDB8F02, 0x3E4E3F8B, 0x3EA6B730,
   0x3F000000, 0x3F448CE2, 0x3F9EE064, 0x40153EB0,
   0x40F7D015, 0xC107385A, 0xC0427FED, 0xBFF962DE,
   0xBFBCC8EB, 0xBF9A827A, 0xBF843046, 0xBF6894D6,
   0xBF5076D3, 0xBF3D489D, 0xBF2D724E, 0xBF1FF5CE,
   0xBF142BB2, 0xBF09A043, 0xBF000000, 0xBEEE1832,
   0xBEDD267E, 0xBECCD9DA, 0xBEBCEC3D, 0xBEAD1DA9,
   0xBE9D300C, 0xBE8CE369, 0xBE77E369, 0xBE5413CD,
   0xBE2D92C2, 0xBE036505, 0xBDA87927, 0xBCF254B0
 },
 { 0x3D043A95, 0x3DDB8F02, 0x3E4E3F8B, 0x3EA6B730,
   0x3F000000, 0x3F448CE2, 0x3F9EE064, 0x40153EB0,
   0x40F7D015, 0xC107385A, 0xC0427FED, 0xBFF962DE,
   0xBFBCC8EB, 0xBF9A827A, 0xBF843046, 0xBF6894D6,
   0xBF5076D3, 0xBF3D489D, 0xBF2D9C9B, 0xBF215729,
   0xBF17C4A9, 0xBF104E0D, 0xBF0A8BD4, 0xBF063634,
   0xBF01FC73, 0xBEEE8DD4, 0xBECB4ABD, 0xBE9BFDCC,
   0xBE459FE7, 0xBD88E76C, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000
 },
 { 0x3DDB8F02, 0x3F000000, 0x40153EB0, 0xC0427FED,
   0xBF9A827A, 0xBF5076D3, 0xBF1FF5CE, 0xBF000000,
   0xBECCD9DA, 0xBE9D300C, 0xBE5413CD, 0xBDA87927,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000
 },
 { 0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x3E9A622D, 0x3FBBA375,
   0x40DF4CA5, 0xC1118135, 0xC0627FED, 0xC0129517,
   0xBFD4D526, 0xBFA73D75, 0xBF8A9A83, 0xBF6E3A75,
   0xBF524353, 0xBF3D76C6, 0xBF2D724E, 0xBF1FF5CE,
   0xBF142BB2, 0xBF09A043, 0xBF000000, 0xBEEE1832,
   0xBEDD267E, 0xBECCD9DA, 0xBEBCEC3D, 0xBEAD1DA9,
   0xBE9D300C, 0xBE8CE369, 0xBE77E369, 0xBE5413CD,
   0xBE2D92C2, 0xBE036505, 0xBDA87927, 0xBCF254B0
  }
};
static unsigned int s_Win1[ 4 ][ 36 ] = {
 { 0x3D043A95, 0xBDDB8F02, 0x3E4E3F8B, 0xBEA6B730,
   0x3F000000, 0xBF448CE2, 0x3F9EE064, 0xC0153EB0,
   0x40F7D015, 0x4107385A, 0xC0427FED, 0x3FF962DE,
   0xBFBCC8EB, 0x3F9A827A, 0xBF843046, 0x3F6894D6,
   0xBF5076D3, 0x3F3D489D, 0xBF2D724E, 0x3F1FF5CE,
   0xBF142BB2, 0x3F09A043, 0xBF000000, 0x3EEE1832,
   0xBEDD267E, 0x3ECCD9DA, 0xBEBCEC3D, 0x3EAD1DA9,
   0xBE9D300C, 0x3E8CE369, 0xBE77E369, 0x3E5413CD,
   0xBE2D92C2, 0x3E036505, 0xBDA87927, 0x3CF254B0
 },
 { 0x3D043A95, 0xBDDB8F02, 0x3E4E3F8B, 0xBEA6B730,
   0x3F000000, 0xBF448CE2, 0x3F9EE064, 0xC0153EB0,
   0x40F7D015, 0x4107385A, 0xC0427FED, 0x3FF962DE,
   0xBFBCC8EB, 0x3F9A827A, 0xBF843046, 0x3F6894D6,
   0xBF5076D3, 0x3F3D489D, 0xBF2D9C9B, 0x3F215729,
   0xBF17C4A9, 0x3F104E0D, 0xBF0A8BD4, 0x3F063634,
   0xBF01FC73, 0x3EEE8DD4, 0xBECB4ABD, 0x3E9BFDCC,
   0xBE459FE7, 0x3D88E76C, 0x00000000, 0x80000000,
   0x00000000, 0x80000000, 0x00000000, 0x80000000
 },
 { 0x3DDB8F02, 0xBF000000, 0x40153EB0, 0x40427FED,
   0xBF9A827A, 0x3F5076D3, 0xBF1FF5CE, 0x3F000000,
   0xBECCD9DA, 0x3E9D300C, 0xBE5413CD, 0x3DA87927,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000
 },
 { 0x00000000, 0x80000000, 0x00000000, 0x80000000,
   0x00000000, 0x80000000, 0x3E9A622D, 0xBFBBA375,
   0x40DF4CA5, 0x41118135, 0xC0627FED, 0x40129517,
   0xBFD4D526, 0x3FA73D75, 0xBF8A9A83, 0x3F6E3A75,
   0xBF524353, 0x3F3D76C6, 0xBF2D724E, 0x3F1FF5CE,
   0xBF142BB2, 0x3F09A043, 0xBF000000, 0x3EEE1832,
   0xBEDD267E, 0x3ECCD9DA, 0xBEBCEC3D, 0x3EAD1DA9,
   0xBE9D300C, 0x3E8CE369, 0xBE77E369, 0x3E5413CD,
   0xBE2D92C2, 0x3E036505, 0xBDA87927, 0x3CF254B0
 }
};
static SMS_MP2AllocTable s_Alloc0[ 288 ] __attribute__(   (  section( ".data" )  )   ) = {
 {  4,     0 }, {  5,    3  }, {  3,     -3 }, {  4,     -7 },
 {  5,   -15 }, {  6,  -31  }, {  7,    -63 }, {  8,   -127 },
 {  9,  -255 }, { 10,  -511 }, { 11,  -1023 }, { 12,  -2047 },
 { 13, -4095 }, { 14, -8191 }, { 15, -16383 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  3,     -3 }, {  4,     -7 },
 {  5,   -15 }, {  6,   -31 }, {  7,    -63 }, {  8,   -127 },
 {  9,  -255 }, { 10,  -511 }, { 11,  -1023 }, { 12,  -2047 },
 { 13, -4095 }, { 14, -8191 }, { 15, -16383 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  3,     -3 }, {  4,     -7 },
 {  5,   -15 }, {  6,   -31 }, {  7,    -63 }, {  8,   -127 },
 {  9,  -255 }, { 10,  -511 }, { 11,  -1023 }, { 12,  -2047 },
 { 13, -4095 }, { 14, -8191 }, { 15, -16383 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 }
};
static SMS_MP2AllocTable s_Alloc1[ 300 ] __attribute__(   (  section( ".data" )  )   ) = {
 {  4,     0 }, {  5,     3 }, {  3,     -3 }, { 4,     -7  },
 {  5,   -15 }, {  6,   -31 }, {  7,    -63 }, { 8,    -127 },
 {  9,  -255 }, { 10,  -511 }, { 11,  -1023 }, { 12,  -2047 },
 { 13, -4095 }, { 14, -8191 }, { 15, -16383 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  3,     -3 }, { 4,     -7  },
 {  5,   -15 }, {  6,   -31 }, {  7,    -63 }, { 8,    -127 },
 {  9,  -255 }, { 10,  -511 }, { 11,  -1023 }, { 12,  -2047 },
 { 13, -4095 }, { 14, -8191 }, { 15, -16383 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  3,     -3 }, { 4,     -7  },
 {  5,   -15 }, {  6,   -31 }, {  7,    -63 }, { 8,    -127 },
 {  9,  -255 }, { 10,  -511 }, { 11,  -1023 }, { 12,  -2047 },
 { 13, -4095 }, { 14, -8191 }, { 15, -16383 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  4,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,   -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11, -1023 }, { 12, -2047 }, { 13,  -4095 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  3,     0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,     9 }, {  4,    -7 }, {  5,    -15 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 },
 {  2,     0 }, {  5,     3 }, {  7,      5 }, { 16, -32767 }
};
static SMS_MP2AllocTable s_Alloc2[ 80 ] __attribute__(   (  section( ".data" )  )   ) = {
 {  4,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  8,   -127 }, {  9,  -255 }, { 10,   -511 }, { 11,  -1023 },
 { 12,  -2047 }, { 13, -4095 }, { 14,  -8191 }, { 15, -16383 },
 {  4,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  8,   -127 }, {  9,  -255 }, { 10,   -511 }, { 11,  -1023 },
 { 12,  -2047 }, { 13, -4095 }, { 14,  -8191 }, { 15, -16383 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 }
};
static SMS_MP2AllocTable s_Alloc3[ 112 ] __attribute__(   (  section( ".data" )  )   ) = {
 {  4,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  8,   -127 }, {  9,  -255 }, { 10,   -511 }, { 11,  -1023 },
 { 12,  -2047 }, { 13, -4095 }, { 14,  -8191 }, { 15, -16383 },
 {  4,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  8,   -127 }, {  9,  -255 }, { 10,   -511 }, { 11,  -1023 },
 { 12,  -2047 }, { 13, -4095 }, { 14,  -8191 }, { 15, -16383 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 }
};
static SMS_MP2AllocTable s_Alloc4[ 196 ] __attribute__(   (  section( ".data" )  )   ) = {
 {  4,      0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,      9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,    -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11,  -1023 }, { 12, -2047 }, { 13,  -4095 }, { 14,  -8191 },
 {  4,      0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,      9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,    -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11,  -1023 }, { 12, -2047 }, { 13,  -4095 }, { 14,  -8191 },
 {  4,      0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,      9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,    -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11,  -1023 }, { 12, -2047 }, { 13,  -4095 }, { 14,  -8191 },
 {  4,      0 }, {  5,     3 }, {  7,      5 }, {  3,     -3 },
 { 10,      9 }, {  4,    -7 }, {  5,    -15 }, {  6,    -31 },
 {  7,    -63 }, {  8,  -127 }, {  9,   -255 }, { 10,   -511 },
 { 11,  -1023 }, { 12, -2047 }, { 13,  -4095 }, { 14,  -8191 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  3,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  4,     -7 }, {  5,   -15 }, {  6,    -31 }, {  7,    -63 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 },
 {  2,      0 }, {  5,     3 }, {  7,      5 }, { 10,      9 }
};
static unsigned int s_Muls[ 27 ][ 64 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000,
   0x00000000, 0x00000000, 0x00000000, 0x00000000
 },
 { 0xBFAAAAAB, 0xBF87754E, 0xBF5706CA, 0xBF2AAAAB,
   0xBF07754E, 0xBED706CA, 0xBEAAAAAB, 0xBE87754E,
   0xBE5706CA, 0xBE2AAAAB, 0xBE07754E, 0xBDD706CA,
   0xBDAAAAAB, 0xBD87754E, 0xBD5706CA, 0xBD2AAAAB,
   0xBD07754E, 0xBCD706CA, 0xBCAAAAAB, 0xBC87754E,
   0xBC5706CA, 0xBC2AAAAB, 0xBC07754E, 0xBBD706CA,
   0xBBAAAAAB, 0xBB87754E, 0xBB5706CA, 0xBB2AAAAB,
   0xBB07754E, 0xBAD706CA, 0xBAAAAAAB, 0xBA87754E,
   0xBA5706CA, 0xBA2AAAAB, 0xBA07754E, 0xB9D706CA,
   0xB9AAAAAB, 0xB987754E, 0xB95706CA, 0xB92AAAAB,
   0xB907754E, 0xB8D706CA, 0xB8AAAAAB, 0xB887754E,
   0xB85706CA, 0xB82AAAAB, 0xB807754E, 0xB7D706CA,
   0xB7AAAAAB, 0xB787754E, 0xB75706CA, 0xB72AAAAB,
   0xB707754E, 0xB6D706CA, 0xB6AAAAAB, 0xB687754E,
   0xB65706CA, 0xB62AAAAB, 0xB607754E, 0xB5D706CA,
   0xB5AAAAAB, 0xB587754E, 0xB55706CA, 0x00000000
 },
 { 0x3FAAAAAB, 0x3F87754E, 0x3F5706CA, 0x3F2AAAAB,
   0x3F07754E, 0x3ED706CA, 0x3EAAAAAB, 0x3E87754E,
   0x3E5706CA, 0x3E2AAAAB, 0x3E07754E, 0x3DD706CA,
   0x3DAAAAAB, 0x3D87754E, 0x3D5706CA, 0x3D2AAAAB,
   0x3D07754E, 0x3CD706CA, 0x3CAAAAAB, 0x3C87754E,
   0x3C5706CA, 0x3C2AAAAB, 0x3C07754E, 0x3BD706CA,
   0x3BAAAAAB, 0x3B87754E, 0x3B5706CA, 0x3B2AAAAB,
   0x3B07754E, 0x3AD706CA, 0x3AAAAAAB, 0x3A87754E,
   0x3A5706CA, 0x3A2AAAAB, 0x3A07754E, 0x39D706CA,
   0x39AAAAAB, 0x3987754E, 0x395706CA, 0x392AAAAB,
   0x3907754E, 0x38D706CA, 0x38AAAAAB, 0x3887754E,
   0x385706CA, 0x382AAAAB, 0x3807754E, 0x37D706CA,
   0x37AAAAAB, 0x3787754E, 0x375706CA, 0x372AAAAB,
   0x3707754E, 0x36D706CA, 0x36AAAAAB, 0x3687754E,
   0x365706CA, 0x362AAAAB, 0x3607754E, 0x35D706CA,
   0x35AAAAAB, 0x3587754E, 0x355706CA, 0x00000000
 },
 { 0x3F124925, 0x3EE836CF, 0x3EB84EF7, 0x3E924925,
   0x3E6836CF, 0x3E384EF7, 0x3E124925, 0x3DE836CF,
   0x3DB84EF7, 0x3D924925, 0x3D6836CF, 0x3D384EF7,
   0x3D124925, 0x3CE836CF, 0x3CB84EF7, 0x3C924925,
   0x3C6836CF, 0x3C384EF7, 0x3C124925, 0x3BE836CF,
   0x3BB84EF7, 0x3B924925, 0x3B6836CF, 0x3B384EF7,
   0x3B124925, 0x3AE836CF, 0x3AB84EF7, 0x3A924925,
   0x3A6836CF, 0x3A384EF7, 0x3A124925, 0x39E836CF,
   0x39B84EF7, 0x39924925, 0x396836CF, 0x39384EF7,
   0x39124925, 0x38E836CF, 0x38B84EF7, 0x38924925,
   0x386836CF, 0x38384EF7, 0x38124925, 0x37E836CF,
   0x37B84EF7, 0x37924925, 0x376836CF, 0x37384EF7,
   0x37124925, 0x36E836CF, 0x36B84EF7, 0x36924925,
   0x366836CF, 0x36384EF7, 0x36124925, 0x35E836CF,
   0x35B84EF7, 0x35924925, 0x356836CF, 0x35384EF7,
   0x35124925, 0x34E836CF, 0x34B84EF7, 0x00000000
 },
 { 0x3E888889, 0x3E58BBB0, 0x3E2C056F, 0x3E088889,
   0x3DD8BBB0, 0x3DAC056F, 0x3D888889, 0x3D58BBB0,
   0x3D2C056F, 0x3D088889, 0x3CD8BBB0, 0x3CAC056F,
   0x3C888889, 0x3C58BBB0, 0x3C2C056F, 0x3C088889,
   0x3BD8BBB0, 0x3BAC056F, 0x3B888889, 0x3B58BBB0,
   0x3B2C056F, 0x3B088889, 0x3AD8BBB0, 0x3AAC056F,
   0x3A888889, 0x3A58BBB0, 0x3A2C056F, 0x3A088889,
   0x39D8BBB0, 0x39AC056F, 0x39888889, 0x3958BBB0,
   0x392C056F, 0x39088889, 0x38D8BBB0, 0x38AC056F,
   0x38888889, 0x3858BBB0, 0x382C056F, 0x38088889,
   0x37D8BBB0, 0x37AC056F, 0x37888889, 0x3758BBB0,
   0x372C056F, 0x37088889, 0x36D8BBB0, 0x36AC056F,
   0x36888889, 0x3658BBB0, 0x362C056F, 0x36088889,
   0x35D8BBB0, 0x35AC056F, 0x35888889, 0x3558BBB0,
   0x352C056F, 0x35088889, 0x34D8BBB0, 0x34AC056F,
   0x34888889, 0x3458BBB0, 0x342C056F, 0x00000000
 },
 { 0x3E042108, 0x3DD1BDE4, 0x3DA678DF, 0x3D842108,
   0x3D51BDE4, 0x3D2678DF, 0x3D042108, 0x3CD1BDE4,
   0x3CA678DF, 0x3C842108, 0x3C51BDE4, 0x3C2678DF,
   0x3C042108, 0x3BD1BDE4, 0x3BA678DF, 0x3B842108,
   0x3B51BDE4, 0x3B2678DF, 0x3B042108, 0x3AD1BDE4,
   0x3AA678DF, 0x3A842108, 0x3A51BDE4, 0x3A2678DF,
   0x3A042108, 0x39D1BDE4, 0x39A678DF, 0x39842108,
   0x3951BDE4, 0x392678DF, 0x39042108, 0x38D1BDE4,
   0x38A678DF, 0x38842108, 0x3851BDE4, 0x382678DF,
   0x38042108, 0x37D1BDE4, 0x37A678DF, 0x37842108,
   0x3751BDE4, 0x372678DF, 0x37042108, 0x36D1BDE4,
   0x36A678DF, 0x36842108, 0x3651BDE4, 0x362678DF,
   0x36042108, 0x35D1BDE4, 0x35A678DF, 0x35842108,
   0x3551BDE4, 0x352678DF, 0x35042108, 0x34D1BDE4,
   0x34A678DF, 0x34842108, 0x3451BDE4, 0x342678DF,
   0x34042108, 0x33D1BDE4, 0x33A678DF, 0x00000000
 },
 { 0x3D820821, 0x3D4E699C, 0x3D23D469, 0x3D020821,
   0x3CCE699C, 0x3CA3D469, 0x3C820821, 0x3C4E699C,
   0x3C23D469, 0x3C020821, 0x3BCE699C, 0x3BA3D469,
   0x3B820821, 0x3B4E699C, 0x3B23D469, 0x3B020821,
   0x3ACE699C, 0x3AA3D469, 0x3A820821, 0x3A4E699C,
   0x3A23D469, 0x3A020821, 0x39CE699C, 0x39A3D469,
   0x39820821, 0x394E699C, 0x3923D469, 0x39020821,
   0x38CE699C, 0x38A3D469, 0x38820821, 0x384E699C,
   0x3823D469, 0x38020821, 0x37CE699C, 0x37A3D469,
   0x37820821, 0x374E699C, 0x3723D469, 0x37020821,
   0x36CE699C, 0x36A3D469, 0x36820821, 0x364E699C,
   0x3623D469, 0x36020821, 0x35CE699C, 0x35A3D469,
   0x35820821, 0x354E699C, 0x3523D469, 0x35020821,
   0x34CE699C, 0x34A3D469, 0x34820821, 0x344E699C,
   0x3423D469, 0x34020821, 0x33CE699C, 0x33A3D469,
   0x33820821, 0x334E699C, 0x3323D469, 0x00000000
 },
 { 0x3D010204, 0x3CCCC988, 0x3CA28A2C, 0x3C810204,
   0x3C4CC988, 0x3C228A2C, 0x3C010204, 0x3BCCC988,
   0x3BA28A2C, 0x3B810204, 0x3B4CC988, 0x3B228A2C,
   0x3B010204, 0x3ACCC988, 0x3AA28A2C, 0x3A810204,
   0x3A4CC988, 0x3A228A2C, 0x3A010204, 0x39CCC988,
   0x39A28A2C, 0x39810204, 0x394CC988, 0x39228A2C,
   0x39010204, 0x38CCC988, 0x38A28A2C, 0x38810204,
   0x384CC988, 0x38228A2C, 0x38010204, 0x37CCC988,
   0x37A28A2C, 0x37810204, 0x374CC988, 0x37228A2C,
   0x37010204, 0x36CCC988, 0x36A28A2C, 0x36810204,
   0x364CC988, 0x36228A2C, 0x36010204, 0x35CCC988,
   0x35A28A2C, 0x35810204, 0x354CC988, 0x35228A2C,
   0x35010204, 0x34CCC988, 0x34A28A2C, 0x34810204,
   0x344CC988, 0x34228A2C, 0x34010204, 0x33CCC988,
   0x33A28A2C, 0x33810204, 0x334CC988, 0x33228A2C,
   0x33010204, 0x32CCC988, 0x32A28A2C, 0x00000000
 },
 { 0x3C808081, 0x3C4BFBF1, 0x3C21E6FF, 0x3C008081,
   0x3BCBFBF1, 0x3BA1E6FF, 0x3B808081, 0x3B4BFBF1,
   0x3B21E6FF, 0x3B008081, 0x3ACBFBF1, 0x3AA1E6FF,
   0x3A808081, 0x3A4BFBF1, 0x3A21E6FF, 0x3A008081,
   0x39CBFBF1, 0x39A1E6FF, 0x39808081, 0x394BFBF1,
   0x3921E6FF, 0x39008081, 0x38CBFBF1, 0x38A1E6FF,
   0x38808081, 0x384BFBF1, 0x3821E6FF, 0x38008081,
   0x37CBFBF1, 0x37A1E6FF, 0x37808081, 0x374BFBF1,
   0x3721E6FF, 0x37008081, 0x36CBFBF1, 0x36A1E6FF,
   0x36808081, 0x364BFBF1, 0x3621E6FF, 0x36008081,
   0x35CBFBF1, 0x35A1E6FF, 0x35808081, 0x354BFBF1,
   0x3521E6FF, 0x35008081, 0x34CBFBF1, 0x34A1E6FF,
   0x34808081, 0x344BFBF1, 0x3421E6FF, 0x34008081,
   0x33CBFBF1, 0x33A1E6FF, 0x33808081, 0x334BFBF1,
   0x3321E6FF, 0x33008081, 0x32CBFBF1, 0x32A1E6FF,
   0x32808081, 0x324BFBF1, 0x3221E6FF, 0x00000000
 },
 { 0x3C004020, 0x3BCB95C0, 0x3BA195E3, 0x3B804020,
   0x3B4B95C0, 0x3B2195E3, 0x3B004020, 0x3ACB95C0,
   0x3AA195E3, 0x3A804020, 0x3A4B95C0, 0x3A2195E3,
   0x3A004020, 0x39CB95C0, 0x39A195E3, 0x39804020,
   0x394B95C0, 0x392195E3, 0x39004020, 0x38CB95C0,
   0x38A195E3, 0x38804020, 0x384B95C0, 0x382195E3,
   0x38004020, 0x37CB95C0, 0x37A195E3, 0x37804020,
   0x374B95C0, 0x372195E3, 0x37004020, 0x36CB95C0,
   0x36A195E3, 0x36804020, 0x364B95C0, 0x362195E3,
   0x36004020, 0x35CB95C0, 0x35A195E3, 0x35804020,
   0x354B95C0, 0x352195E3, 0x35004020, 0x34CB95C0,
   0x34A195E3, 0x34804020, 0x344B95C0, 0x342195E3,
   0x34004020, 0x33CB95C0, 0x33A195E3, 0x33804020,
   0x334B95C0, 0x332195E3, 0x33004020, 0x32CB95C0,
   0x32A195E3, 0x32804020, 0x324B95C0, 0x322195E3,
   0x32004020, 0x31CB95C0, 0x31A195E3, 0x00000000
 },
 { 0x3B802008, 0x3B4B62CE, 0x3B216D73, 0x3B002008,
   0x3ACB62CE, 0x3AA16D73, 0x3A802008, 0x3A4B62CE,
   0x3A216D73, 0x3A002008, 0x39CB62CE, 0x39A16D73,
   0x39802008, 0x394B62CE, 0x39216D73, 0x39002008,
   0x38CB62CE, 0x38A16D73, 0x38802008, 0x384B62CE,
   0x38216D73, 0x38002008, 0x37CB62CE, 0x37A16D73,
   0x37802008, 0x374B62CE, 0x37216D73, 0x37002008,
   0x36CB62CE, 0x36A16D73, 0x36802008, 0x364B62CE,
   0x36216D73, 0x36002008, 0x35CB62CE, 0x35A16D73,
   0x35802008, 0x354B62CE, 0x35216D73, 0x35002008,
   0x34CB62CE, 0x34A16D73, 0x34802008, 0x344B62CE,
   0x34216D73, 0x34002008, 0x33CB62CE, 0x33A16D73,
   0x33802008, 0x334B62CE, 0x33216D73, 0x33002008,
   0x32CB62CE, 0x32A16D73, 0x32802008, 0x324B62CE,
   0x32216D73, 0x32002008, 0x31CB62CE, 0x31A16D73,
   0x31802008, 0x314B62CE, 0x31216D73, 0x00000000
 },
 { 0x3B001002, 0x3ACB495E, 0x3AA15943, 0x3A801002,
   0x3A4B495E, 0x3A215943, 0x3A001002, 0x39CB495E,
   0x39A15943, 0x39801002, 0x394B495E, 0x39215943,
   0x39001002, 0x38CB495E, 0x38A15943, 0x38801002,
   0x384B495E, 0x38215943, 0x38001002, 0x37CB495E,
   0x37A15943, 0x37801002, 0x374B495E, 0x37215943,
   0x37001002, 0x36CB495E, 0x36A15943, 0x36801002,
   0x364B495E, 0x36215943, 0x36001002, 0x35CB495E,
   0x35A15943, 0x35801002, 0x354B495E, 0x35215943,
   0x35001002, 0x34CB495E, 0x34A15943, 0x34801002,
   0x344B495E, 0x34215943, 0x34001002, 0x33CB495E,
   0x33A15943, 0x33801002, 0x334B495E, 0x33215943,
   0x33001002, 0x32CB495E, 0x32A15943, 0x32801002,
   0x324B495E, 0x32215943, 0x32001002, 0x31CB495E,
   0x31A15943, 0x31801002, 0x314B495E, 0x31215943,
   0x31001002, 0x30CB495E, 0x30A15943, 0x00000000
 },
 { 0x3A800801, 0x3A4B3CA9, 0x3A214F2D, 0x3A000801,
   0x39CB3CA9, 0x39A14F2D, 0x39800801, 0x394B3CA9,
   0x39214F2D, 0x39000801, 0x38CB3CA9, 0x38A14F2D,
   0x38800801, 0x384B3CA9, 0x38214F2D, 0x38000801,
   0x37CB3CA9, 0x37A14F2D, 0x37800801, 0x374B3CA9,
   0x37214F2D, 0x37000801, 0x36CB3CA9, 0x36A14F2D,
   0x36800801, 0x364B3CA9, 0x36214F2D, 0x36000801,
   0x35CB3CA9, 0x35A14F2D, 0x35800801, 0x354B3CA9,
   0x35214F2D, 0x35000801, 0x34CB3CA9, 0x34A14F2D,
   0x34800801, 0x344B3CA9, 0x34214F2D, 0x34000801,
   0x33CB3CA9, 0x33A14F2D, 0x33800801, 0x334B3CA9,
   0x33214F2D, 0x33000801, 0x32CB3CA9, 0x32A14F2D,
   0x32800801, 0x324B3CA9, 0x32214F2D, 0x32000801,
   0x31CB3CA9, 0x31A14F2D, 0x31800801, 0x314B3CA9,
   0x31214F2D, 0x31000801, 0x30CB3CA9, 0x30A14F2D,
   0x30800801, 0x304B3CA9, 0x30214F2D, 0x00000000
 },
 { 0x3A000400, 0x39CB364F, 0x39A14A22, 0x39800400,
   0x394B364F, 0x39214A22, 0x39000400, 0x38CB364F,
   0x38A14A22, 0x38800400, 0x384B364F, 0x38214A22,
   0x38000400, 0x37CB364F, 0x37A14A22, 0x37800400,
   0x374B364F, 0x37214A22, 0x37000400, 0x36CB364F,
   0x36A14A22, 0x36800400, 0x364B364F, 0x36214A22,
   0x36000400, 0x35CB364F, 0x35A14A22, 0x35800400,
   0x354B364F, 0x35214A22, 0x35000400, 0x34CB364F,
   0x34A14A22, 0x34800400, 0x344B364F, 0x34214A22,
   0x34000400, 0x33CB364F, 0x33A14A22, 0x33800400,
   0x334B364F, 0x33214A22, 0x33000400, 0x32CB364F,
   0x32A14A22, 0x32800400, 0x324B364F, 0x32214A22,
   0x32000400, 0x31CB364F, 0x31A14A22, 0x31800400,
   0x314B364F, 0x31214A22, 0x31000400, 0x30CB364F,
   0x30A14A22, 0x30800400, 0x304B364F, 0x30214A22,
   0x30000400, 0x2FCB364F, 0x2FA14A22, 0x00000000
 },
 { 0x39800200, 0x394B3322, 0x3921479D, 0x39000200,
   0x38CB3322, 0x38A1479D, 0x38800200, 0x384B3322,
   0x3821479D, 0x38000200, 0x37CB3322, 0x37A1479D,
   0x37800200, 0x374B3322, 0x3721479D, 0x37000200,
   0x36CB3322, 0x36A1479D, 0x36800200, 0x364B3322,
   0x3621479D, 0x36000200, 0x35CB3322, 0x35A1479D,
   0x35800200, 0x354B3322, 0x3521479D, 0x35000200,
   0x34CB3322, 0x34A1479D, 0x34800200, 0x344B3322,
   0x3421479D, 0x34000200, 0x33CB3322, 0x33A1479D,
   0x33800200, 0x334B3322, 0x3321479D, 0x33000200,
   0x32CB3322, 0x32A1479D, 0x32800200, 0x324B3322,
   0x3221479D, 0x32000200, 0x31CB3322, 0x31A1479D,
   0x31800200, 0x314B3322, 0x3121479D, 0x31000200,
   0x30CB3322, 0x30A1479D, 0x30800200, 0x304B3322,
   0x3021479D, 0x30000200, 0x2FCB3322, 0x2FA1479D,
   0x2F800200, 0x2F4B3322, 0x2F21479D, 0x00000000
 },
 { 0x39000100, 0x38CB318C, 0x38A1465A, 0x38800100,
   0x384B318C, 0x3821465A, 0x38000100, 0x37CB318C,
   0x37A1465A, 0x37800100, 0x374B318C, 0x3721465A,
   0x37000100, 0x36CB318C, 0x36A1465A, 0x36800100,
   0x364B318C, 0x3621465A, 0x36000100, 0x35CB318C,
   0x35A1465A, 0x35800100, 0x354B318C, 0x3521465A,
   0x35000100, 0x34CB318C, 0x34A1465A, 0x34800100,
   0x344B318C, 0x3421465A, 0x34000100, 0x33CB318C,
   0x33A1465A, 0x33800100, 0x334B318C, 0x3321465A,
   0x33000100, 0x32CB318C, 0x32A1465A, 0x32800100,
   0x324B318C, 0x3221465A, 0x32000100, 0x31CB318C,
   0x31A1465A, 0x31800100, 0x314B318C, 0x3121465A,
   0x31000100, 0x30CB318C, 0x30A1465A, 0x30800100,
   0x304B318C, 0x3021465A, 0x30000100, 0x2FCB318C,
   0x2FA1465A, 0x2F800100, 0x2F4B318C, 0x2F21465A,
   0x2F000100, 0x2ECB318C, 0x2EA1465A, 0x00000000
 },
 { 0x38800080, 0x384B30C0, 0x382145B9, 0x38000080,
   0x37CB30C0, 0x37A145B9, 0x37800080, 0x374B30C0,
   0x372145B9, 0x37000080, 0x36CB30C0, 0x36A145B9,
   0x36800080, 0x364B30C0, 0x362145B9, 0x36000080,
   0x35CB30C0, 0x35A145B9, 0x35800080, 0x354B30C0,
   0x352145B9, 0x35000080, 0x34CB30C0, 0x34A145B9,
   0x34800080, 0x344B30C0, 0x342145B9, 0x34000080,
   0x33CB30C0, 0x33A145B9, 0x33800080, 0x334B30C0,
   0x332145B9, 0x33000080, 0x32CB30C0, 0x32A145B9,
   0x32800080, 0x324B30C0, 0x322145B9, 0x32000080,
   0x31CB30C0, 0x31A145B9, 0x31800080, 0x314B30C0,
   0x312145B9, 0x31000080, 0x30CB30C0, 0x30A145B9,
   0x30800080, 0x304B30C0, 0x302145B9, 0x30000080,
   0x2FCB30C0, 0x2FA145B9, 0x2F800080, 0x2F4B30C0,
   0x2F2145B9, 0x2F000080, 0x2ECB30C0, 0x2EA145B9,
   0x2E800080, 0x2E4B30C0, 0x2E2145B9, 0x00000000
 },
 { 0xBFCCCCCD, 0xBFA28CC4, 0xBF810413, 0xBF4CCCCD,
   0xBF228CC4, 0xBF010413, 0xBECCCCCD, 0xBEA28CC4,
   0xBE810413, 0xBE4CCCCD, 0xBE228CC4, 0xBE010413,
   0xBDCCCCCD, 0xBDA28CC4, 0xBD810413, 0xBD4CCCCD,
   0xBD228CC4, 0xBD010413, 0xBCCCCCCD, 0xBCA28CC4,
   0xBC810413, 0xBC4CCCCD, 0xBC228CC4, 0xBC010413,
   0xBBCCCCCD, 0xBBA28CC4, 0xBB810413, 0xBB4CCCCD,
   0xBB228CC4, 0xBB010413, 0xBACCCCCD, 0xBAA28CC4,
   0xBA810413, 0xBA4CCCCD, 0xBA228CC4, 0xBA010413,
   0xB9CCCCCD, 0xB9A28CC4, 0xB9810413, 0xB94CCCCD,
   0xB9228CC4, 0xB9010413, 0xB8CCCCCD, 0xB8A28CC4,
   0xB8810413, 0xB84CCCCD, 0xB8228CC4, 0xB8010413,
   0xB7CCCCCD, 0xB7A28CC4, 0xB7810413, 0xB74CCCCD,
   0xB7228CC4, 0xB7010413, 0xB6CCCCCD, 0xB6A28CC4,
   0xB6810413, 0xB64CCCCD, 0xB6228CC4, 0xB6010413,
   0xB5CCCCCD, 0xB5A28CC4, 0xB5810413, 0x00000000
 },
 { 0xBF4CCCCD, 0xBF228CC4, 0xBF010413, 0xBECCCCCD,
   0xBEA28CC4, 0xBE810413, 0xBE4CCCCD, 0xBE228CC4,
   0xBE010413, 0xBDCCCCCD, 0xBDA28CC4, 0xBD810413,
   0xBD4CCCCD, 0xBD228CC4, 0xBD010413, 0xBCCCCCCD,
   0xBCA28CC4, 0xBC810413, 0xBC4CCCCD, 0xBC228CC4,
   0xBC010413, 0xBBCCCCCD, 0xBBA28CC4, 0xBB810413,
   0xBB4CCCCD, 0xBB228CC4, 0xBB010413, 0xBACCCCCD,
   0xBAA28CC4, 0xBA810413, 0xBA4CCCCD, 0xBA228CC4,
   0xBA010413, 0xB9CCCCCD, 0xB9A28CC4, 0xB9810413,
   0xB94CCCCD, 0xB9228CC4, 0xB9010413, 0xB8CCCCCD,
   0xB8A28CC4, 0xB8810413, 0xB84CCCCD, 0xB8228CC4,
   0xB8010413, 0xB7CCCCCD, 0xB7A28CC4, 0xB7810413,
   0xB74CCCCD, 0xB7228CC4, 0xB7010413, 0xB6CCCCCD,
   0xB6A28CC4, 0xB6810413, 0xB64CCCCD, 0xB6228CC4,
   0xB6010413, 0xB5CCCCCD, 0xB5A28CC4, 0xB5810413,
   0xB54CCCCD, 0xB5228CC4, 0xB5010413, 0x00000000
 },
 { 0x3F4CCCCD, 0x3F228CC4, 0x3F010413, 0x3ECCCCCD,
   0x3EA28CC4, 0x3E810413, 0x3E4CCCCD, 0x3E228CC4,
   0x3E010413, 0x3DCCCCCD, 0x3DA28CC4, 0x3D810413,
   0x3D4CCCCD, 0x3D228CC4, 0x3D010413, 0x3CCCCCCD,
   0x3CA28CC4, 0x3C810413, 0x3C4CCCCD, 0x3C228CC4,
   0x3C010413, 0x3BCCCCCD, 0x3BA28CC4, 0x3B810413,
   0x3B4CCCCD, 0x3B228CC4, 0x3B010413, 0x3ACCCCCD,
   0x3AA28CC4, 0x3A810413, 0x3A4CCCCD, 0x3A228CC4,
   0x3A010413, 0x39CCCCCD, 0x39A28CC4, 0x39810413,
   0x394CCCCD, 0x39228CC4, 0x39010413, 0x38CCCCCD,
   0x38A28CC4, 0x38810413, 0x384CCCCD, 0x38228CC4,
   0x38010413, 0x37CCCCCD, 0x37A28CC4, 0x37810413,
   0x374CCCCD, 0x37228CC4, 0x37010413, 0x36CCCCCD,
   0x36A28CC4, 0x36810413, 0x364CCCCD, 0x36228CC4,
   0x36010413, 0x35CCCCCD, 0x35A28CC4, 0x35810413,
   0x354CCCCD, 0x35228CC4, 0x35010413, 0x00000000
 },
 { 0x3FCCCCCD, 0x3FA28CC4, 0x3F810413, 0x3F4CCCCD,
   0x3F228CC4, 0x3F010413, 0x3ECCCCCD, 0x3EA28CC4,
   0x3E810413, 0x3E4CCCCD, 0x3E228CC4, 0x3E010413,
   0x3DCCCCCD, 0x3DA28CC4, 0x3D810413, 0x3D4CCCCD,
   0x3D228CC4, 0x3D010413, 0x3CCCCCCD, 0x3CA28CC4,
   0x3C810413, 0x3C4CCCCD, 0x3C228CC4, 0x3C010413,
   0x3BCCCCCD, 0x3BA28CC4, 0x3B810413, 0x3B4CCCCD,
   0x3B228CC4, 0x3B010413, 0x3ACCCCCD, 0x3AA28CC4,
   0x3A810413, 0x3A4CCCCD, 0x3A228CC4, 0x3A010413,
   0x39CCCCCD, 0x39A28CC4, 0x39810413, 0x394CCCCD,
   0x39228CC4, 0x39010413, 0x38CCCCCD, 0x38A28CC4,
   0x38810413, 0x384CCCCD, 0x38228CC4, 0x38010413,
   0x37CCCCCD, 0x37A28CC4, 0x37810413, 0x374CCCCD,
   0x37228CC4, 0x37010413, 0x36CCCCCD, 0x36A28CC4,
   0x36810413, 0x364CCCCD, 0x36228CC4, 0x36010413,
   0x35CCCCCD, 0x35A28CC4, 0x35810413, 0x00000000
 },
 { 0xBFE38E39, 0xBFB49C68, 0xBF8F59DC, 0xBF638E39,
   0xBF349C68, 0xBF0F59DC, 0xBEE38E39, 0xBEB49C68,
   0xBE8F59DC, 0xBE638E39, 0xBE349C68, 0xBE0F59DC,
   0xBDE38E39, 0xBDB49C68, 0xBD8F59DC, 0xBD638E39,
   0xBD349C68, 0xBD0F59DC, 0xBCE38E39, 0xBCB49C68,
   0xBC8F59DC, 0xBC638E39, 0xBC349C68, 0xBC0F59DC,
   0xBBE38E39, 0xBBB49C68, 0xBB8F59DC, 0xBB638E39,
   0xBB349C68, 0xBB0F59DC, 0xBAE38E39, 0xBAB49C68,
   0xBA8F59DC, 0xBA638E39, 0xBA349C68, 0xBA0F59DC,
   0xB9E38E39, 0xB9B49C68, 0xB98F59DC, 0xB9638E39,
   0xB9349C68, 0xB90F59DC, 0xB8E38E39, 0xB8B49C68,
   0xB88F59DC, 0xB8638E39, 0xB8349C68, 0xB80F59DC,
   0xB7E38E39, 0xB7B49C68, 0xB78F59DC, 0xB7638E39,
   0xB7349C68, 0xB70F59DC, 0xB6E38E39, 0xB6B49C68,
   0xB68F59DC, 0xB6638E39, 0xB6349C68, 0xB60F59DC,
   0xB5E38E39, 0xB5B49C68, 0xB58F59DC, 0x00000000
 },
 { 0xBF638E39, 0xBF349C68, 0xBF0F59DC, 0xBEE38E39,
   0xBEB49C68, 0xBE8F59DC, 0xBE638E39, 0xBE349C68,
   0xBE0F59DC, 0xBDE38E39, 0xBDB49C68, 0xBD8F59DC,
   0xBD638E39, 0xBD349C68, 0xBD0F59DC, 0xBCE38E39,
   0xBCB49C68, 0xBC8F59DC, 0xBC638E39, 0xBC349C68,
   0xBC0F59DC, 0xBBE38E39, 0xBBB49C68, 0xBB8F59DC,
   0xBB638E39, 0xBB349C68, 0xBB0F59DC, 0xBAE38E39,
   0xBAB49C68, 0xBA8F59DC, 0xBA638E39, 0xBA349C68,
   0xBA0F59DC, 0xB9E38E39, 0xB9B49C68, 0xB98F59DC,
   0xB9638E39, 0xB9349C68, 0xB90F59DC, 0xB8E38E39,
   0xB8B49C68, 0xB88F59DC, 0xB8638E39, 0xB8349C68,
   0xB80F59DC, 0xB7E38E39, 0xB7B49C68, 0xB78F59DC,
   0xB7638E39, 0xB7349C68, 0xB70F59DC, 0xB6E38E39,
   0xB6B49C68, 0xB68F59DC, 0xB6638E39, 0xB6349C68,
   0xB60F59DC, 0xB5E38E39, 0xB5B49C68, 0xB58F59DC,
   0xB5638E39, 0xB5349C68, 0xB50F59DC, 0x00000000
 },
 { 0xBEE38E39, 0xBEB49C68, 0xBE8F59DC, 0xBE638E39,
   0xBE349C68, 0xBE0F59DC, 0xBDE38E39, 0xBDB49C68,
   0xBD8F59DC, 0xBD638E39, 0xBD349C68, 0xBD0F59DC,
   0xBCE38E39, 0xBCB49C68, 0xBC8F59DC, 0xBC638E39,
   0xBC349C68, 0xBC0F59DC, 0xBBE38E39, 0xBBB49C68,
   0xBB8F59DC, 0xBB638E39, 0xBB349C68, 0xBB0F59DC,
   0xBAE38E39, 0xBAB49C68, 0xBA8F59DC, 0xBA638E39,
   0xBA349C68, 0xBA0F59DC, 0xB9E38E39, 0xB9B49C68,
   0xB98F59DC, 0xB9638E39, 0xB9349C68, 0xB90F59DC,
   0xB8E38E39, 0xB8B49C68, 0xB88F59DC, 0xB8638E39,
   0xB8349C68, 0xB80F59DC, 0xB7E38E39, 0xB7B49C68,
   0xB78F59DC, 0xB7638E39, 0xB7349C68, 0xB70F59DC,
   0xB6E38E39, 0xB6B49C68, 0xB68F59DC, 0xB6638E39,
   0xB6349C68, 0xB60F59DC, 0xB5E38E39, 0xB5B49C68,
   0xB58F59DC, 0xB5638E39, 0xB5349C68, 0xB50F59DC,
   0xB4E38E39, 0xB4B49C68, 0xB48F59DC, 0x00000000
 },
 { 0x3EE38E39, 0x3EB49C68, 0x3E8F59DC, 0x3E638E39,
   0x3E349C68, 0x3E0F59DC, 0x3DE38E39, 0x3DB49C68,
   0x3D8F59DC, 0x3D638E39, 0x3D349C68, 0x3D0F59DC,
   0x3CE38E39, 0x3CB49C68, 0x3C8F59DC, 0x3C638E39,
   0x3C349C68, 0x3C0F59DC, 0x3BE38E39, 0x3BB49C68,
   0x3B8F59DC, 0x3B638E39, 0x3B349C68, 0x3B0F59DC,
   0x3AE38E39, 0x3AB49C68, 0x3A8F59DC, 0x3A638E39,
   0x3A349C68, 0x3A0F59DC, 0x39E38E39, 0x39B49C68,
   0x398F59DC, 0x39638E39, 0x39349C68, 0x390F59DC,
   0x38E38E39, 0x38B49C68, 0x388F59DC, 0x38638E39,
   0x38349C68, 0x380F59DC, 0x37E38E39, 0x37B49C68,
   0x378F59DC, 0x37638E39, 0x37349C68, 0x370F59DC,
   0x36E38E39, 0x36B49C68, 0x368F59DC, 0x36638E39,
   0x36349C68, 0x360F59DC, 0x35E38E39, 0x35B49C68,
   0x358F59DC, 0x35638E39, 0x35349C68, 0x350F59DC,
   0x34E38E39, 0x34B49C68, 0x348F59DC, 0x00000000
 },
 { 0x3F638E39, 0x3F349C68, 0x3F0F59DC, 0x3EE38E39,
   0x3EB49C68, 0x3E8F59DC, 0x3E638E39, 0x3E349C68,
   0x3E0F59DC, 0x3DE38E39, 0x3DB49C68, 0x3D8F59DC,
   0x3D638E39, 0x3D349C68, 0x3D0F59DC, 0x3CE38E39,
   0x3CB49C68, 0x3C8F59DC, 0x3C638E39, 0x3C349C68,
   0x3C0F59DC, 0x3BE38E39, 0x3BB49C68, 0x3B8F59DC,
   0x3B638E39, 0x3B349C68, 0x3B0F59DC, 0x3AE38E39,
   0x3AB49C68, 0x3A8F59DC, 0x3A638E39, 0x3A349C68,
   0x3A0F59DC, 0x39E38E39, 0x39B49C68, 0x398F59DC,
   0x39638E39, 0x39349C68, 0x390F59DC, 0x38E38E39,
   0x38B49C68, 0x388F59DC, 0x38638E39, 0x38349C68,
   0x380F59DC, 0x37E38E39, 0x37B49C68, 0x378F59DC,
   0x37638E39, 0x37349C68, 0x370F59DC, 0x36E38E39,
   0x36B49C68, 0x368F59DC, 0x36638E39, 0x36349C68,
   0x360F59DC, 0x35E38E39, 0x35B49C68, 0x358F59DC,
   0x35638E39, 0x35349C68, 0x350F59DC, 0x00000000
 },
 { 0x3FE38E39, 0x3FB49C68, 0x3F8F59DC, 0x3F638E39,
   0x3F349C68, 0x3F0F59DC, 0x3EE38E39, 0x3EB49C68,
   0x3E8F59DC, 0x3E638E39, 0x3E349C68, 0x3E0F59DC,
   0x3DE38E39, 0x3DB49C68, 0x3D8F59DC, 0x3D638E39,
   0x3D349C68, 0x3D0F59DC, 0x3CE38E39, 0x3CB49C68,
   0x3C8F59DC, 0x3C638E39, 0x3C349C68, 0x3C0F59DC,
   0x3BE38E39, 0x3BB49C68, 0x3B8F59DC, 0x3B638E39,
   0x3B349C68, 0x3B0F59DC, 0x3AE38E39, 0x3AB49C68,
   0x3A8F59DC, 0x3A638E39, 0x3A349C68, 0x3A0F59DC,
   0x39E38E39, 0x39B49C68, 0x398F59DC, 0x39638E39,
   0x39349C68, 0x390F59DC, 0x38E38E39, 0x38B49C68,
   0x388F59DC, 0x38638E39, 0x38349C68, 0x380F59DC,
   0x37E38E39, 0x37B49C68, 0x378F59DC, 0x37638E39,
   0x37349C68, 0x370F59DC, 0x36E38E39, 0x36B49C68,
   0x368F59DC, 0x36638E39, 0x36349C68, 0x360F59DC,
   0x35E38E39, 0x35B49C68, 0x358F59DC, 0x00000000
 }
};
static char s_Grp3[ 96 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x02, 0x01,
 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x02,
 0x00, 0x01, 0x01, 0x02, 0x01, 0x00, 0x02, 0x01,
 0x02, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
 0x00, 0x02, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x02, 0x00,
 0x00, 0x02, 0x00, 0x02, 0x02, 0x00, 0x01, 0x01,
 0x02, 0x00, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01,
 0x00, 0x02, 0x00, 0x00, 0x02, 0x02, 0x00, 0x02,
 0x01, 0x02, 0x02, 0x00, 0x02, 0x02, 0x02, 0x02,
 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static char s_Grp5[ 384 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x11, 0x11, 0x11, 0x12, 0x11, 0x11, 0x00, 0x11,
 0x11, 0x13, 0x11, 0x11, 0x14, 0x11, 0x11, 0x11,
 0x12, 0x11, 0x12, 0x12, 0x11, 0x00, 0x12, 0x11,
 0x13, 0x12, 0x11, 0x14, 0x12, 0x11, 0x11, 0x00,
 0x11, 0x12, 0x00, 0x11, 0x00, 0x00, 0x11, 0x13,
 0x00, 0x11, 0x14, 0x00, 0x11, 0x11, 0x13, 0x11,
 0x12, 0x13, 0x11, 0x00, 0x13, 0x11, 0x13, 0x13,
 0x11, 0x14, 0x13, 0x11, 0x11, 0x14, 0x11, 0x12,
 0x14, 0x11, 0x00, 0x14, 0x11, 0x13, 0x14, 0x11,
 0x14, 0x14, 0x11, 0x11, 0x11, 0x12, 0x12, 0x11,
 0x12, 0x00, 0x11, 0x12, 0x13, 0x11, 0x12, 0x14,
 0x11, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12,
 0x00, 0x12, 0x12, 0x13, 0x12, 0x12, 0x14, 0x12,
 0x12, 0x11, 0x00, 0x12, 0x12, 0x00, 0x12, 0x00,
 0x00, 0x12, 0x13, 0x00, 0x12, 0x14, 0x00, 0x12,
 0x11, 0x13, 0x12, 0x12, 0x13, 0x12, 0x00, 0x13,
 0x12, 0x13, 0x13, 0x12, 0x14, 0x13, 0x12, 0x11,
 0x14, 0x12, 0x12, 0x14, 0x12, 0x00, 0x14, 0x12,
 0x13, 0x14, 0x12, 0x14, 0x14, 0x12, 0x11, 0x11,
 0x00, 0x12, 0x11, 0x00, 0x00, 0x11, 0x00, 0x13,
 0x11, 0x00, 0x14, 0x11, 0x00, 0x11, 0x12, 0x00,
 0x12, 0x12, 0x00, 0x00, 0x12, 0x00, 0x13, 0x12,
 0x00, 0x14, 0x12, 0x00, 0x11, 0x00, 0x00, 0x12,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00,
 0x14, 0x00, 0x00, 0x11, 0x13, 0x00, 0x12, 0x13,
 0x00, 0x00, 0x13, 0x00, 0x13, 0x13, 0x00, 0x14,
 0x13, 0x00, 0x11, 0x14, 0x00, 0x12, 0x14, 0x00,
 0x00, 0x14, 0x00, 0x13, 0x14, 0x00, 0x14, 0x14,
 0x00, 0x11, 0x11, 0x13, 0x12, 0x11, 0x13, 0x00,
 0x11, 0x13, 0x13, 0x11, 0x13, 0x14, 0x11, 0x13,
 0x11, 0x12, 0x13, 0x12, 0x12, 0x13, 0x00, 0x12,
 0x13, 0x13, 0x12, 0x13, 0x14, 0x12, 0x13, 0x11,
 0x00, 0x13, 0x12, 0x00, 0x13, 0x00, 0x00, 0x13,
 0x13, 0x00, 0x13, 0x14, 0x00, 0x13, 0x11, 0x13,
 0x13, 0x12, 0x13, 0x13, 0x00, 0x13, 0x13, 0x13,
 0x13, 0x13, 0x14, 0x13, 0x13, 0x11, 0x14, 0x13,
 0x12, 0x14, 0x13, 0x00, 0x14, 0x13, 0x13, 0x14,
 0x13, 0x14, 0x14, 0x13, 0x11, 0x11, 0x14, 0x12,
 0x11, 0x14, 0x00, 0x11, 0x14, 0x13, 0x11, 0x14,
 0x14, 0x11, 0x14, 0x11, 0x12, 0x14, 0x12, 0x12,
 0x14, 0x00, 0x12, 0x14, 0x13, 0x12, 0x14, 0x14,
 0x12, 0x14, 0x11, 0x00, 0x14, 0x12, 0x00, 0x14,
 0x00, 0x00, 0x14, 0x13, 0x00, 0x14, 0x14, 0x00,
 0x14, 0x11, 0x13, 0x14, 0x12, 0x13, 0x14, 0x00,
 0x13, 0x14, 0x13, 0x13, 0x14, 0x14, 0x13, 0x14,
 0x11, 0x14, 0x14, 0x12, 0x14, 0x14, 0x00, 0x14,
 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static char s_Grp9[ 3072 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x15, 0x15, 0x15, 0x01, 0x15, 0x15, 0x16, 0x15,
 0x15, 0x17, 0x15, 0x15, 0x00, 0x15, 0x15, 0x18,
 0x15, 0x15, 0x19, 0x15, 0x15, 0x02, 0x15, 0x15,
 0x1A, 0x15, 0x15, 0x15, 0x01, 0x15, 0x01, 0x01,
 0x15, 0x16, 0x01, 0x15, 0x17, 0x01, 0x15, 0x00,
 0x01, 0x15, 0x18, 0x01, 0x15, 0x19, 0x01, 0x15,
 0x02, 0x01, 0x15, 0x1A, 0x01, 0x15, 0x15, 0x16,
 0x15, 0x01, 0x16, 0x15, 0x16, 0x16, 0x15, 0x17,
 0x16, 0x15, 0x00, 0x16, 0x15, 0x18, 0x16, 0x15,
 0x19, 0x16, 0x15, 0x02, 0x16, 0x15, 0x1A, 0x16,
 0x15, 0x15, 0x17, 0x15, 0x01, 0x17, 0x15, 0x16,
 0x17, 0x15, 0x17, 0x17, 0x15, 0x00, 0x17, 0x15,
 0x18, 0x17, 0x15, 0x19, 0x17, 0x15, 0x02, 0x17,
 0x15, 0x1A, 0x17, 0x15, 0x15, 0x00, 0x15, 0x01,
 0x00, 0x15, 0x16, 0x00, 0x15, 0x17, 0x00, 0x15,
 0x00, 0x00, 0x15, 0x18, 0x00, 0x15, 0x19, 0x00,
 0x15, 0x02, 0x00, 0x15, 0x1A, 0x00, 0x15, 0x15,
 0x18, 0x15, 0x01, 0x18, 0x15, 0x16, 0x18, 0x15,
 0x17, 0x18, 0x15, 0x00, 0x18, 0x15, 0x18, 0x18,
 0x15, 0x19, 0x18, 0x15, 0x02, 0x18, 0x15, 0x1A,
 0x18, 0x15, 0x15, 0x19, 0x15, 0x01, 0x19, 0x15,
 0x16, 0x19, 0x15, 0x17, 0x19, 0x15, 0x00, 0x19,
 0x15, 0x18, 0x19, 0x15, 0x19, 0x19, 0x15, 0x02,
 0x19, 0x15, 0x1A, 0x19, 0x15, 0x15, 0x02, 0x15,
 0x01, 0x02, 0x15, 0x16, 0x02, 0x15, 0x17, 0x02,
 0x15, 0x00, 0x02, 0x15, 0x18, 0x02, 0x15, 0x19,
 0x02, 0x15, 0x02, 0x02, 0x15, 0x1A, 0x02, 0x15,
 0x15, 0x1A, 0x15, 0x01, 0x1A, 0x15, 0x16, 0x1A,
 0x15, 0x17, 0x1A, 0x15, 0x00, 0x1A, 0x15, 0x18,
 0x1A, 0x15, 0x19, 0x1A, 0x15, 0x02, 0x1A, 0x15,
 0x1A, 0x1A, 0x15, 0x15, 0x15, 0x01, 0x01, 0x15,
 0x01, 0x16, 0x15, 0x01, 0x17, 0x15, 0x01, 0x00,
 0x15, 0x01, 0x18, 0x15, 0x01, 0x19, 0x15, 0x01,
 0x02, 0x15, 0x01, 0x1A, 0x15, 0x01, 0x15, 0x01,
 0x01, 0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x17,
 0x01, 0x01, 0x00, 0x01, 0x01, 0x18, 0x01, 0x01,
 0x19, 0x01, 0x01, 0x02, 0x01, 0x01, 0x1A, 0x01,
 0x01, 0x15, 0x16, 0x01, 0x01, 0x16, 0x01, 0x16,
 0x16, 0x01, 0x17, 0x16, 0x01, 0x00, 0x16, 0x01,
 0x18, 0x16, 0x01, 0x19, 0x16, 0x01, 0x02, 0x16,
 0x01, 0x1A, 0x16, 0x01, 0x15, 0x17, 0x01, 0x01,
 0x17, 0x01, 0x16, 0x17, 0x01, 0x17, 0x17, 0x01,
 0x00, 0x17, 0x01, 0x18, 0x17, 0x01, 0x19, 0x17,
 0x01, 0x02, 0x17, 0x01, 0x1A, 0x17, 0x01, 0x15,
 0x00, 0x01, 0x01, 0x00, 0x01, 0x16, 0x00, 0x01,
 0x17, 0x00, 0x01, 0x00, 0x00, 0x01, 0x18, 0x00,
 0x01, 0x19, 0x00, 0x01, 0x02, 0x00, 0x01, 0x1A,
 0x00, 0x01, 0x15, 0x18, 0x01, 0x01, 0x18, 0x01,
 0x16, 0x18, 0x01, 0x17, 0x18, 0x01, 0x00, 0x18,
 0x01, 0x18, 0x18, 0x01, 0x19, 0x18, 0x01, 0x02,
 0x18, 0x01, 0x1A, 0x18, 0x01, 0x15, 0x19, 0x01,
 0x01, 0x19, 0x01, 0x16, 0x19, 0x01, 0x17, 0x19,
 0x01, 0x00, 0x19, 0x01, 0x18, 0x19, 0x01, 0x19,
 0x19, 0x01, 0x02, 0x19, 0x01, 0x1A, 0x19, 0x01,
 0x15, 0x02, 0x01, 0x01, 0x02, 0x01, 0x16, 0x02,
 0x01, 0x17, 0x02, 0x01, 0x00, 0x02, 0x01, 0x18,
 0x02, 0x01, 0x19, 0x02, 0x01, 0x02, 0x02, 0x01,
 0x1A, 0x02, 0x01, 0x15, 0x1A, 0x01, 0x01, 0x1A,
 0x01, 0x16, 0x1A, 0x01, 0x17, 0x1A, 0x01, 0x00,
 0x1A, 0x01, 0x18, 0x1A, 0x01, 0x19, 0x1A, 0x01,
 0x02, 0x1A, 0x01, 0x1A, 0x1A, 0x01, 0x15, 0x15,
 0x16, 0x01, 0x15, 0x16, 0x16, 0x15, 0x16, 0x17,
 0x15, 0x16, 0x00, 0x15, 0x16, 0x18, 0x15, 0x16,
 0x19, 0x15, 0x16, 0x02, 0x15, 0x16, 0x1A, 0x15,
 0x16, 0x15, 0x01, 0x16, 0x01, 0x01, 0x16, 0x16,
 0x01, 0x16, 0x17, 0x01, 0x16, 0x00, 0x01, 0x16,
 0x18, 0x01, 0x16, 0x19, 0x01, 0x16, 0x02, 0x01,
 0x16, 0x1A, 0x01, 0x16, 0x15, 0x16, 0x16, 0x01,
 0x16, 0x16, 0x16, 0x16, 0x16, 0x17, 0x16, 0x16,
 0x00, 0x16, 0x16, 0x18, 0x16, 0x16, 0x19, 0x16,
 0x16, 0x02, 0x16, 0x16, 0x1A, 0x16, 0x16, 0x15,
 0x17, 0x16, 0x01, 0x17, 0x16, 0x16, 0x17, 0x16,
 0x17, 0x17, 0x16, 0x00, 0x17, 0x16, 0x18, 0x17,
 0x16, 0x19, 0x17, 0x16, 0x02, 0x17, 0x16, 0x1A,
 0x17, 0x16, 0x15, 0x00, 0x16, 0x01, 0x00, 0x16,
 0x16, 0x00, 0x16, 0x17, 0x00, 0x16, 0x00, 0x00,
 0x16, 0x18, 0x00, 0x16, 0x19, 0x00, 0x16, 0x02,
 0x00, 0x16, 0x1A, 0x00, 0x16, 0x15, 0x18, 0x16,
 0x01, 0x18, 0x16, 0x16, 0x18, 0x16, 0x17, 0x18,
 0x16, 0x00, 0x18, 0x16, 0x18, 0x18, 0x16, 0x19,
 0x18, 0x16, 0x02, 0x18, 0x16, 0x1A, 0x18, 0x16,
 0x15, 0x19, 0x16, 0x01, 0x19, 0x16, 0x16, 0x19,
 0x16, 0x17, 0x19, 0x16, 0x00, 0x19, 0x16, 0x18,
 0x19, 0x16, 0x19, 0x19, 0x16, 0x02, 0x19, 0x16,
 0x1A, 0x19, 0x16, 0x15, 0x02, 0x16, 0x01, 0x02,
 0x16, 0x16, 0x02, 0x16, 0x17, 0x02, 0x16, 0x00,
 0x02, 0x16, 0x18, 0x02, 0x16, 0x19, 0x02, 0x16,
 0x02, 0x02, 0x16, 0x1A, 0x02, 0x16, 0x15, 0x1A,
 0x16, 0x01, 0x1A, 0x16, 0x16, 0x1A, 0x16, 0x17,
 0x1A, 0x16, 0x00, 0x1A, 0x16, 0x18, 0x1A, 0x16,
 0x19, 0x1A, 0x16, 0x02, 0x1A, 0x16, 0x1A, 0x1A,
 0x16, 0x15, 0x15, 0x17, 0x01, 0x15, 0x17, 0x16,
 0x15, 0x17, 0x17, 0x15, 0x17, 0x00, 0x15, 0x17,
 0x18, 0x15, 0x17, 0x19, 0x15, 0x17, 0x02, 0x15,
 0x17, 0x1A, 0x15, 0x17, 0x15, 0x01, 0x17, 0x01,
 0x01, 0x17, 0x16, 0x01, 0x17, 0x17, 0x01, 0x17,
 0x00, 0x01, 0x17, 0x18, 0x01, 0x17, 0x19, 0x01,
 0x17, 0x02, 0x01, 0x17, 0x1A, 0x01, 0x17, 0x15,
 0x16, 0x17, 0x01, 0x16, 0x17, 0x16, 0x16, 0x17,
 0x17, 0x16, 0x17, 0x00, 0x16, 0x17, 0x18, 0x16,
 0x17, 0x19, 0x16, 0x17, 0x02, 0x16, 0x17, 0x1A,
 0x16, 0x17, 0x15, 0x17, 0x17, 0x01, 0x17, 0x17,
 0x16, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x17,
 0x17, 0x18, 0x17, 0x17, 0x19, 0x17, 0x17, 0x02,
 0x17, 0x17, 0x1A, 0x17, 0x17, 0x15, 0x00, 0x17,
 0x01, 0x00, 0x17, 0x16, 0x00, 0x17, 0x17, 0x00,
 0x17, 0x00, 0x00, 0x17, 0x18, 0x00, 0x17, 0x19,
 0x00, 0x17, 0x02, 0x00, 0x17, 0x1A, 0x00, 0x17,
 0x15, 0x18, 0x17, 0x01, 0x18, 0x17, 0x16, 0x18,
 0x17, 0x17, 0x18, 0x17, 0x00, 0x18, 0x17, 0x18,
 0x18, 0x17, 0x19, 0x18, 0x17, 0x02, 0x18, 0x17,
 0x1A, 0x18, 0x17, 0x15, 0x19, 0x17, 0x01, 0x19,
 0x17, 0x16, 0x19, 0x17, 0x17, 0x19, 0x17, 0x00,
 0x19, 0x17, 0x18, 0x19, 0x17, 0x19, 0x19, 0x17,
 0x02, 0x19, 0x17, 0x1A, 0x19, 0x17, 0x15, 0x02,
 0x17, 0x01, 0x02, 0x17, 0x16, 0x02, 0x17, 0x17,
 0x02, 0x17, 0x00, 0x02, 0x17, 0x18, 0x02, 0x17,
 0x19, 0x02, 0x17, 0x02, 0x02, 0x17, 0x1A, 0x02,
 0x17, 0x15, 0x1A, 0x17, 0x01, 0x1A, 0x17, 0x16,
 0x1A, 0x17, 0x17, 0x1A, 0x17, 0x00, 0x1A, 0x17,
 0x18, 0x1A, 0x17, 0x19, 0x1A, 0x17, 0x02, 0x1A,
 0x17, 0x1A, 0x1A, 0x17, 0x15, 0x15, 0x00, 0x01,
 0x15, 0x00, 0x16, 0x15, 0x00, 0x17, 0x15, 0x00,
 0x00, 0x15, 0x00, 0x18, 0x15, 0x00, 0x19, 0x15,
 0x00, 0x02, 0x15, 0x00, 0x1A, 0x15, 0x00, 0x15,
 0x01, 0x00, 0x01, 0x01, 0x00, 0x16, 0x01, 0x00,
 0x17, 0x01, 0x00, 0x00, 0x01, 0x00, 0x18, 0x01,
 0x00, 0x19, 0x01, 0x00, 0x02, 0x01, 0x00, 0x1A,
 0x01, 0x00, 0x15, 0x16, 0x00, 0x01, 0x16, 0x00,
 0x16, 0x16, 0x00, 0x17, 0x16, 0x00, 0x00, 0x16,
 0x00, 0x18, 0x16, 0x00, 0x19, 0x16, 0x00, 0x02,
 0x16, 0x00, 0x1A, 0x16, 0x00, 0x15, 0x17, 0x00,
 0x01, 0x17, 0x00, 0x16, 0x17, 0x00, 0x17, 0x17,
 0x00, 0x00, 0x17, 0x00, 0x18, 0x17, 0x00, 0x19,
 0x17, 0x00, 0x02, 0x17, 0x00, 0x1A, 0x17, 0x00,
 0x15, 0x00, 0x00, 0x01, 0x00, 0x00, 0x16, 0x00,
 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
 0x00, 0x00, 0x19, 0x00, 0x00, 0x02, 0x00, 0x00,
 0x1A, 0x00, 0x00, 0x15, 0x18, 0x00, 0x01, 0x18,
 0x00, 0x16, 0x18, 0x00, 0x17, 0x18, 0x00, 0x00,
 0x18, 0x00, 0x18, 0x18, 0x00, 0x19, 0x18, 0x00,
 0x02, 0x18, 0x00, 0x1A, 0x18, 0x00, 0x15, 0x19,
 0x00, 0x01, 0x19, 0x00, 0x16, 0x19, 0x00, 0x17,
 0x19, 0x00, 0x00, 0x19, 0x00, 0x18, 0x19, 0x00,
 0x19, 0x19, 0x00, 0x02, 0x19, 0x00, 0x1A, 0x19,
 0x00, 0x15, 0x02, 0x00, 0x01, 0x02, 0x00, 0x16,
 0x02, 0x00, 0x17, 0x02, 0x00, 0x00, 0x02, 0x00,
 0x18, 0x02, 0x00, 0x19, 0x02, 0x00, 0x02, 0x02,
 0x00, 0x1A, 0x02, 0x00, 0x15, 0x1A, 0x00, 0x01,
 0x1A, 0x00, 0x16, 0x1A, 0x00, 0x17, 0x1A, 0x00,
 0x00, 0x1A, 0x00, 0x18, 0x1A, 0x00, 0x19, 0x1A,
 0x00, 0x02, 0x1A, 0x00, 0x1A, 0x1A, 0x00, 0x15,
 0x15, 0x18, 0x01, 0x15, 0x18, 0x16, 0x15, 0x18,
 0x17, 0x15, 0x18, 0x00, 0x15, 0x18, 0x18, 0x15,
 0x18, 0x19, 0x15, 0x18, 0x02, 0x15, 0x18, 0x1A,
 0x15, 0x18, 0x15, 0x01, 0x18, 0x01, 0x01, 0x18,
 0x16, 0x01, 0x18, 0x17, 0x01, 0x18, 0x00, 0x01,
 0x18, 0x18, 0x01, 0x18, 0x19, 0x01, 0x18, 0x02,
 0x01, 0x18, 0x1A, 0x01, 0x18, 0x15, 0x16, 0x18,
 0x01, 0x16, 0x18, 0x16, 0x16, 0x18, 0x17, 0x16,
 0x18, 0x00, 0x16, 0x18, 0x18, 0x16, 0x18, 0x19,
 0x16, 0x18, 0x02, 0x16, 0x18, 0x1A, 0x16, 0x18,
 0x15, 0x17, 0x18, 0x01, 0x17, 0x18, 0x16, 0x17,
 0x18, 0x17, 0x17, 0x18, 0x00, 0x17, 0x18, 0x18,
 0x17, 0x18, 0x19, 0x17, 0x18, 0x02, 0x17, 0x18,
 0x1A, 0x17, 0x18, 0x15, 0x00, 0x18, 0x01, 0x00,
 0x18, 0x16, 0x00, 0x18, 0x17, 0x00, 0x18, 0x00,
 0x00, 0x18, 0x18, 0x00, 0x18, 0x19, 0x00, 0x18,
 0x02, 0x00, 0x18, 0x1A, 0x00, 0x18, 0x15, 0x18,
 0x18, 0x01, 0x18, 0x18, 0x16, 0x18, 0x18, 0x17,
 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18,
 0x19, 0x18, 0x18, 0x02, 0x18, 0x18, 0x1A, 0x18,
 0x18, 0x15, 0x19, 0x18, 0x01, 0x19, 0x18, 0x16,
 0x19, 0x18, 0x17, 0x19, 0x18, 0x00, 0x19, 0x18,
 0x18, 0x19, 0x18, 0x19, 0x19, 0x18, 0x02, 0x19,
 0x18, 0x1A, 0x19, 0x18, 0x15, 0x02, 0x18, 0x01,
 0x02, 0x18, 0x16, 0x02, 0x18, 0x17, 0x02, 0x18,
 0x00, 0x02, 0x18, 0x18, 0x02, 0x18, 0x19, 0x02,
 0x18, 0x02, 0x02, 0x18, 0x1A, 0x02, 0x18, 0x15,
 0x1A, 0x18, 0x01, 0x1A, 0x18, 0x16, 0x1A, 0x18,
 0x17, 0x1A, 0x18, 0x00, 0x1A, 0x18, 0x18, 0x1A,
 0x18, 0x19, 0x1A, 0x18, 0x02, 0x1A, 0x18, 0x1A,
 0x1A, 0x18, 0x15, 0x15, 0x19, 0x01, 0x15, 0x19,
 0x16, 0x15, 0x19, 0x17, 0x15, 0x19, 0x00, 0x15,
 0x19, 0x18, 0x15, 0x19, 0x19, 0x15, 0x19, 0x02,
 0x15, 0x19, 0x1A, 0x15, 0x19, 0x15, 0x01, 0x19,
 0x01, 0x01, 0x19, 0x16, 0x01, 0x19, 0x17, 0x01,
 0x19, 0x00, 0x01, 0x19, 0x18, 0x01, 0x19, 0x19,
 0x01, 0x19, 0x02, 0x01, 0x19, 0x1A, 0x01, 0x19,
 0x15, 0x16, 0x19, 0x01, 0x16, 0x19, 0x16, 0x16,
 0x19, 0x17, 0x16, 0x19, 0x00, 0x16, 0x19, 0x18,
 0x16, 0x19, 0x19, 0x16, 0x19, 0x02, 0x16, 0x19,
 0x1A, 0x16, 0x19, 0x15, 0x17, 0x19, 0x01, 0x17,
 0x19, 0x16, 0x17, 0x19, 0x17, 0x17, 0x19, 0x00,
 0x17, 0x19, 0x18, 0x17, 0x19, 0x19, 0x17, 0x19,
 0x02, 0x17, 0x19, 0x1A, 0x17, 0x19, 0x15, 0x00,
 0x19, 0x01, 0x00, 0x19, 0x16, 0x00, 0x19, 0x17,
 0x00, 0x19, 0x00, 0x00, 0x19, 0x18, 0x00, 0x19,
 0x19, 0x00, 0x19, 0x02, 0x00, 0x19, 0x1A, 0x00,
 0x19, 0x15, 0x18, 0x19, 0x01, 0x18, 0x19, 0x16,
 0x18, 0x19, 0x17, 0x18, 0x19, 0x00, 0x18, 0x19,
 0x18, 0x18, 0x19, 0x19, 0x18, 0x19, 0x02, 0x18,
 0x19, 0x1A, 0x18, 0x19, 0x15, 0x19, 0x19, 0x01,
 0x19, 0x19, 0x16, 0x19, 0x19, 0x17, 0x19, 0x19,
 0x00, 0x19, 0x19, 0x18, 0x19, 0x19, 0x19, 0x19,
 0x19, 0x02, 0x19, 0x19, 0x1A, 0x19, 0x19, 0x15,
 0x02, 0x19, 0x01, 0x02, 0x19, 0x16, 0x02, 0x19,
 0x17, 0x02, 0x19, 0x00, 0x02, 0x19, 0x18, 0x02,
 0x19, 0x19, 0x02, 0x19, 0x02, 0x02, 0x19, 0x1A,
 0x02, 0x19, 0x15, 0x1A, 0x19, 0x01, 0x1A, 0x19,
 0x16, 0x1A, 0x19, 0x17, 0x1A, 0x19, 0x00, 0x1A,
 0x19, 0x18, 0x1A, 0x19, 0x19, 0x1A, 0x19, 0x02,
 0x1A, 0x19, 0x1A, 0x1A, 0x19, 0x15, 0x15, 0x02,
 0x01, 0x15, 0x02, 0x16, 0x15, 0x02, 0x17, 0x15,
 0x02, 0x00, 0x15, 0x02, 0x18, 0x15, 0x02, 0x19,
 0x15, 0x02, 0x02, 0x15, 0x02, 0x1A, 0x15, 0x02,
 0x15, 0x01, 0x02, 0x01, 0x01, 0x02, 0x16, 0x01,
 0x02, 0x17, 0x01, 0x02, 0x00, 0x01, 0x02, 0x18,
 0x01, 0x02, 0x19, 0x01, 0x02, 0x02, 0x01, 0x02,
 0x1A, 0x01, 0x02, 0x15, 0x16, 0x02, 0x01, 0x16,
 0x02, 0x16, 0x16, 0x02, 0x17, 0x16, 0x02, 0x00,
 0x16, 0x02, 0x18, 0x16, 0x02, 0x19, 0x16, 0x02,
 0x02, 0x16, 0x02, 0x1A, 0x16, 0x02, 0x15, 0x17,
 0x02, 0x01, 0x17, 0x02, 0x16, 0x17, 0x02, 0x17,
 0x17, 0x02, 0x00, 0x17, 0x02, 0x18, 0x17, 0x02,
 0x19, 0x17, 0x02, 0x02, 0x17, 0x02, 0x1A, 0x17,
 0x02, 0x15, 0x00, 0x02, 0x01, 0x00, 0x02, 0x16,
 0x00, 0x02, 0x17, 0x00, 0x02, 0x00, 0x00, 0x02,
 0x18, 0x00, 0x02, 0x19, 0x00, 0x02, 0x02, 0x00,
 0x02, 0x1A, 0x00, 0x02, 0x15, 0x18, 0x02, 0x01,
 0x18, 0x02, 0x16, 0x18, 0x02, 0x17, 0x18, 0x02,
 0x00, 0x18, 0x02, 0x18, 0x18, 0x02, 0x19, 0x18,
 0x02, 0x02, 0x18, 0x02, 0x1A, 0x18, 0x02, 0x15,
 0x19, 0x02, 0x01, 0x19, 0x02, 0x16, 0x19, 0x02,
 0x17, 0x19, 0x02, 0x00, 0x19, 0x02, 0x18, 0x19,
 0x02, 0x19, 0x19, 0x02, 0x02, 0x19, 0x02, 0x1A,
 0x19, 0x02, 0x15, 0x02, 0x02, 0x01, 0x02, 0x02,
 0x16, 0x02, 0x02, 0x17, 0x02, 0x02, 0x00, 0x02,
 0x02, 0x18, 0x02, 0x02, 0x19, 0x02, 0x02, 0x02,
 0x02, 0x02, 0x1A, 0x02, 0x02, 0x15, 0x1A, 0x02,
 0x01, 0x1A, 0x02, 0x16, 0x1A, 0x02, 0x17, 0x1A,
 0x02, 0x00, 0x1A, 0x02, 0x18, 0x1A, 0x02, 0x19,
 0x1A, 0x02, 0x02, 0x1A, 0x02, 0x1A, 0x1A, 0x02,
 0x15, 0x15, 0x1A, 0x01, 0x15, 0x1A, 0x16, 0x15,
 0x1A, 0x17, 0x15, 0x1A, 0x00, 0x15, 0x1A, 0x18,
 0x15, 0x1A, 0x19, 0x15, 0x1A, 0x02, 0x15, 0x1A,
 0x1A, 0x15, 0x1A, 0x15, 0x01, 0x1A, 0x01, 0x01,
 0x1A, 0x16, 0x01, 0x1A, 0x17, 0x01, 0x1A, 0x00,
 0x01, 0x1A, 0x18, 0x01, 0x1A, 0x19, 0x01, 0x1A,
 0x02, 0x01, 0x1A, 0x1A, 0x01, 0x1A, 0x15, 0x16,
 0x1A, 0x01, 0x16, 0x1A, 0x16, 0x16, 0x1A, 0x17,
 0x16, 0x1A, 0x00, 0x16, 0x1A, 0x18, 0x16, 0x1A,
 0x19, 0x16, 0x1A, 0x02, 0x16, 0x1A, 0x1A, 0x16,
 0x1A, 0x15, 0x17, 0x1A, 0x01, 0x17, 0x1A, 0x16,
 0x17, 0x1A, 0x17, 0x17, 0x1A, 0x00, 0x17, 0x1A,
 0x18, 0x17, 0x1A, 0x19, 0x17, 0x1A, 0x02, 0x17,
 0x1A, 0x1A, 0x17, 0x1A, 0x15, 0x00, 0x1A, 0x01,
 0x00, 0x1A, 0x16, 0x00, 0x1A, 0x17, 0x00, 0x1A,
 0x00, 0x00, 0x1A, 0x18, 0x00, 0x1A, 0x19, 0x00,
 0x1A, 0x02, 0x00, 0x1A, 0x1A, 0x00, 0x1A, 0x15,
 0x18, 0x1A, 0x01, 0x18, 0x1A, 0x16, 0x18, 0x1A,
 0x17, 0x18, 0x1A, 0x00, 0x18, 0x1A, 0x18, 0x18,
 0x1A, 0x19, 0x18, 0x1A, 0x02, 0x18, 0x1A, 0x1A,
 0x18, 0x1A, 0x15, 0x19, 0x1A, 0x01, 0x19, 0x1A,
 0x16, 0x19, 0x1A, 0x17, 0x19, 0x1A, 0x00, 0x19,
 0x1A, 0x18, 0x19, 0x1A, 0x19, 0x19, 0x1A, 0x02,
 0x19, 0x1A, 0x1A, 0x19, 0x1A, 0x15, 0x02, 0x1A,
 0x01, 0x02, 0x1A, 0x16, 0x02, 0x1A, 0x17, 0x02,
 0x1A, 0x00, 0x02, 0x1A, 0x18, 0x02, 0x1A, 0x19,
 0x02, 0x1A, 0x02, 0x02, 0x1A, 0x1A, 0x02, 0x1A,
 0x15, 0x1A, 0x1A, 0x01, 0x1A, 0x1A, 0x16, 0x1A,
 0x1A, 0x17, 0x1A, 0x1A, 0x00, 0x1A, 0x1A, 0x18,
 0x1A, 0x1A, 0x19, 0x1A, 0x1A, 0x02, 0x1A, 0x1A,
 0x1A, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static unsigned char s_VU0Mpg0[ 352 ] __attribute__(   (  aligned( 16 ), section( ".data" )  )   ) = {
	0x3c, 0x03, 0x00, 0x80, 0x6c, 0x98, 0xf4, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x42, 0x4a, 0x4a, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x4a, 0x0a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x59, 0x0c, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x21, 0x03, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xa8, 0x98, 0xf4, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x6a, 0x08, 0xe5, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x40, 0x4a, 0x89, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc2, 0x5a, 0x4c, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x5a, 0x87, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc0, 0x12, 0x01, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x10, 0x41, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x41, 0x39, 0x0c, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x00, 0x63, 0x8c, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x10, 0x8b, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc1, 0x59, 0x01, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x08, 0x81, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x02, 0x21, 0x43, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x21, 0x84, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x41, 0x4a, 0x0a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x52, 0x8a, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x01, 0x21, 0x03, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc0, 0x18, 0x83, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc1, 0x5a, 0x2b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x81, 0x10, 0x22, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc2, 0x5a, 0x8b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x82, 0x10, 0x82, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x5a, 0x45, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x10, 0x47, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc3, 0x2a, 0x0c, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x83, 0x38, 0x01, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x01, 0x63, 0x2c, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x41, 0x08, 0x21, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x02, 0x63, 0x8c, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0x08, 0x81, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x00, 0x63, 0x4c, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x08, 0x41, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x43, 0x01, 0x0a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc2, 0x01, 0x09, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x01, 0x02, 0x09, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x43, 0x03, 0x09, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x83, 0x03, 0x0a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc1, 0x03, 0x0a, 0x41, 0x3c, 0x03, 0x00, 0x80, 0x02, 0x04, 0x0a, 0x01
};
static unsigned char s_VU0Mpg1[ 672 ] __attribute__(   (  aligned( 16 ), section( ".data" )  )   ) = {
	0x3c, 0x03, 0x00, 0x80, 0xe8, 0x4d, 0xc8, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x68, 0x3e, 0xc6, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x28, 0x5d, 0xca, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x28, 0x56, 0xc9, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xa8, 0x46, 0xc7, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xe8, 0xb9, 0xd9, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x68, 0xa2, 0xd7, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2a, 0xc5, 0xc3, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xaa, 0xd6, 0xc1, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xea, 0x3d, 0xc1, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xea, 0x48, 0xc3, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x68, 0x30, 0xd4, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x2c, 0xcd, 0xc9, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2c, 0x36, 0xd8, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xa8, 0xc9, 0xc3, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x68, 0x0a, 0xda, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x6a, 0xa6, 0xc2, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2c, 0x0d, 0xda, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x68, 0x30, 0xd7, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xac, 0x36, 0xd7, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xa8, 0xc1, 0xd9, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xec, 0xc5, 0xd9, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x6a, 0x08, 0xc4, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2a, 0xd1, 0xc5, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x06, 0x86, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x80, 0x00, 0x86, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x68, 0x4e, 0xc1, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xa8, 0xa6, 0xc4, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x6c, 0x48, 0xc1, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2c, 0xa1, 0xc4, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x41, 0x02, 0x19, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x01, 0x05, 0x86, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x01, 0x05, 0x1a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x41, 0x02, 0x86, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x00, 0x59, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x00, 0x06, 0x19, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x01, 0x05, 0x59, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x41, 0x02, 0x5a, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc1, 0x00, 0x44, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x01, 0x04, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0x06, 0x1a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x42, 0x01, 0x19, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc1, 0x02, 0x41, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x02, 0x01, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x02, 0x44, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x01, 0x41, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x00, 0x1a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x00, 0x06, 0x5a, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc1, 0x00, 0x97, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x01, 0x97, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x2a, 0xa5, 0xce, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x6a, 0x4a, 0xcf, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0x06, 0x86, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x42, 0x01, 0x86, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc1, 0x02, 0x97, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x02, 0x97, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x02, 0x01, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x01, 0x04, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc1, 0x00, 0x01, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x01, 0x41, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xaa, 0x10, 0xce, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2a, 0xc6, 0xcf, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0x06, 0x59, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc1, 0x02, 0x04, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0x01, 0x5a, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x02, 0x44, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x02, 0x97, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x01, 0x97, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xea, 0x35, 0xcc, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x6a, 0x18, 0xcd, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xaa, 0x59, 0xcc, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2a, 0x51, 0xcd, 0x01, 
	0x3c, 0xa3, 0xda, 0x81, 0xe8, 0x9c, 0xd8, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xa8, 0x94, 0xc2, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x6a, 0x43, 0xcd, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x2a, 0x3e, 0xcc, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xe8, 0xd5, 0xd7, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xaa, 0x2e, 0xcf, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x6a, 0xce, 0xce, 0x01, 0x3c, 0x4b, 0xce, 0x81, 0xe8, 0x9c, 0xc1, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xa8, 0x94, 0xc6, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x68, 0x8c, 0xcd, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x28, 0x84, 0xd8, 0x41, 0x3c, 0x03, 0x00, 0x80, 0x28, 0x76, 0xc4, 0x01
};
static unsigned char s_VU0Mpg2[ 1376 ] __attribute__(   (  aligned( 16 ), section( ".data" )  )   ) = {
	0x3c, 0x1b, 0xeb, 0x80, 0xab, 0x22, 0xe4, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x02, 0x04, 0x01, 
	0x3c, 0x0b, 0xf5, 0x80, 0x80, 0x02, 0x05, 0x01, 0x3c, 0x13, 0xf7, 0x80, 0x40, 0x05, 0x02, 0x01, 
	0x3d, 0x2b, 0x0e, 0x81, 0xc0, 0x05, 0x03, 0x01, 0x3d, 0x5b, 0xed, 0x81, 0xff, 0x02, 0x00, 0x00, 
	0x3d, 0x53, 0xeb, 0x81, 0xff, 0x02, 0x00, 0x00, 0x3d, 0xab, 0xea, 0x81, 0xff, 0x02, 0x00, 0x00, 
	0x3d, 0xbb, 0xf7, 0x81, 0x68, 0x75, 0x05, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x28, 0x6e, 0xe3, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xe8, 0x5a, 0xe4, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xa8, 0x52, 0xe1, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xe8, 0xbd, 0xe2, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x58, 0xc5, 0x3e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x81, 0xc3, 0x8b, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x40, 0x5d, 0x4b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0x5e, 0x18, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x87, 0x0b, 0x15, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0xc3, 0x58, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x83, 0x0d, 0x15, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x45, 0xc6, 0x8b, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x87, 0x73, 0x15, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x58, 0xce, 0x1e, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x06, 0x6e, 0x55, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x5a, 0xcd, 0x9e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x02, 0x6f, 0x55, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x85, 0x73, 0x8a, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x9a, 0xc7, 0x5e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x56, 0x4a, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x43, 0x5d, 0x2a, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x58, 0x76, 0x9d, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x81, 0x53, 0x8b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x53, 0x19, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x5b, 0xad, 0x3d, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x84, 0x52, 0x19, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xdb, 0x72, 0x9e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x82, 0xc5, 0x4d, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x06, 0xe7, 0x58, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x44, 0x56, 0x19, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x42, 0xc3, 0x55, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x59, 0xb5, 0x5e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x18, 0xe7, 0x5d, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x81, 0x53, 0x98, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x1b, 0x6e, 0x5e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0xf3, 0x55, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc2, 0xba, 0x0a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x99, 0x72, 0x9e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x42, 0xad, 0x58, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x86, 0xf2, 0x58, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x42, 0xc0, 0x17, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x81, 0x57, 0x95, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x80, 0xbf, 0x57, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x98, 0xbb, 0x9d, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x80, 0x5a, 0x01, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x83, 0x57, 0x37, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xd8, 0xf5, 0x5d, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x45, 0xad, 0x8e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc5, 0x55, 0x8e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x59, 0x57, 0x1d, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x82, 0x6f, 0x57, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x85, 0xaa, 0x8b, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc1, 0xbd, 0x8b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc4, 0x6d, 0x1d, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x40, 0xef, 0x0d, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x46, 0xab, 0x57, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x86, 0x52, 0x57, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x19, 0xf7, 0x3d, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x47, 0xbb, 0x2b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x83, 0xbf, 0x2b, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x02, 0xae, 0x0b, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x47, 0xb5, 0x1c, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x83, 0xb2, 0x1c, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xda, 0x6d, 0x3d, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x87, 0xf7, 0x2a, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x47, 0xad, 0x15, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x00, 0x5b, 0x18, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x87, 0xb5, 0x17, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x83, 0x52, 0x17, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x05, 0x95, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x81, 0xa8, 0x0a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x43, 0xb5, 0x15, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x40, 0x07, 0x8a, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x85, 0xaa, 0x8a, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x81, 0x52, 0x0e, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x05, 0x95, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x41, 0xad, 0x17, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x45, 0xef, 0x8e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x81, 0x52, 0x1e, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x85, 0xab, 0x97, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x98, 0xf7, 0x3e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x45, 0xef, 0x9e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x1b, 0x63, 0x1d, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x09, 0x18, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x87, 0x71, 0x1e, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x43, 0x71, 0x1e, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x87, 0x75, 0x1e, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc4, 0xb8, 0x0c, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x85, 0x33, 0x19, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc3, 0x2d, 0x1e, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x81, 0xb5, 0x19, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0x19, 0x0a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xc6, 0x18, 0x0a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x6b, 0x0c, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xc4, 0x22, 0x0b, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x1a, 0x29, 0x1a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xda, 0x18, 0x1b, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x44, 0x0b, 0x18, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xd8, 0x5a, 0x1e, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x17, 0x04, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x41, 0x18, 0x0a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x84, 0x57, 0x83, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x04, 0x16, 0x04, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc0, 0x02, 0x5e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x80, 0x02, 0x41, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x41, 0x05, 0x5e, 0x00, 0xfd, 0x03, 0x3d, 0x80, 0x80, 0x05, 0x58, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x84, 0xc8, 0x0b, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x40, 0xce, 0x0b, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x5a, 0x6b, 0x1d, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0xed, 0x38, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc6, 0x10, 0x1c, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x02, 0x11, 0x1c, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0xc8, 0x0b, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x04, 0x66, 0x0d, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xd9, 0x1a, 0x1a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x5b, 0x26, 0x1b, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x18, 0x11, 0x1b, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x06, 0xc3, 0x0d, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x70, 0x0b, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xc4, 0x76, 0x0b, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0xb3, 0x19, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x44, 0xb6, 0x19, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x03, 0x42, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x05, 0x5b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0x02, 0x8e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x40, 0x05, 0x99, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc0, 0x22, 0x17, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x84, 0xbd, 0x04, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x19, 0x63, 0x1b, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x02, 0xc6, 0x0d, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x03, 0x8b, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x00, 0x06, 0x96, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc1, 0x65, 0x0e, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x84, 0x73, 0x8c, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x98, 0xd7, 0x38, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x40, 0xef, 0x0d, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x40, 0x03, 0x57, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x01, 0x06, 0x4e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x43, 0xab, 0x1e, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x07, 0xae, 0x1e, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x42, 0xed, 0x1e, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x46, 0xef, 0x1e, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0xc0, 0x02, 0x8d, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x80, 0x05, 0x98, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x98, 0xae, 0x1a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x58, 0xef, 0x1c, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x80, 0xea, 0x37, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x41, 0xed, 0x2e, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x53, 0x1a, 0x01, 0x3c, 0x03, 0x00, 0x80, 0xc4, 0x55, 0x1a, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x44, 0xee, 0x9d, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x81, 0xea, 0x1d, 0x01, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0x03, 0x8c, 0x00, 0x3c, 0x03, 0x00, 0x80, 0xc0, 0x05, 0x97, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x41, 0x05, 0x19, 0x01, 0x3c, 0x03, 0x00, 0x80, 0x80, 0xeb, 0x9d, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0xc0, 0xea, 0x22, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x80, 0xed, 0x3b, 0x00, 
	0x3c, 0x03, 0x00, 0x80, 0x01, 0xee, 0x3e, 0x00, 0x3c, 0x03, 0x00, 0x80, 0x40, 0xeb, 0x21, 0x40, 
	0x3c, 0x03, 0x00, 0x80, 0x00, 0xeb, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static float s_HyBlock[ 2 ][ 2 ][ 576 ];
static int   s_HyBlc  [ 2 ];

#define MYCTX() (  ( SMS_Codec_MPAContext* )apCtx -> m_pCodec -> m_pCtx  )

extern void MP123_CoreInit ( void );
extern void MP123_IMDCT36  ( float*, float*, float*, float*, float* );
extern void MP123_IMDCT12  ( float*, float*, float*, float*, float* );
extern int  MP123_Synth    ( float*, int, short*, int );

void SMS_Codec_MP123_Open ( SMS_CodecContext* apCtx ) {

 apCtx -> m_pCodec = calloc (  1, sizeof ( SMS_Codec )  );

 apCtx -> m_pCodec -> m_pName = "mp3";
 apCtx -> m_pCodec -> m_pCtx  = &g_MPACtx;
 apCtx -> m_pCodec -> Init    = MP123_Init;
 apCtx -> m_pCodec -> Decode  = MP123_Decode;
 apCtx -> m_pCodec -> Destroy = MP123_Destroy;

 memcpy (  ( void* )0x11000560, s_VU0Mpg0, sizeof ( s_VU0Mpg0 )  );
 memcpy (  ( void* )0x110006C0, s_VU0Mpg1, sizeof ( s_VU0Mpg1 )  );
 memcpy (  ( void* )0x11000960, s_VU0Mpg2, sizeof ( s_VU0Mpg2 )  );

}  /* end SMS_Codec_MP123_Open */

static int32_t MP123_Init ( SMS_CodecContext* apCtx ) {

 memset (  s_HyBlock, 0, sizeof ( s_HyBlock )  );

 s_HyBlc[ 0 ] =
 s_HyBlc[ 1 ] = 0;

 MP123_CoreInit ();

 MYCTX() -> m_InBufIdx         = 0;
 MYCTX() -> m_pInBuf           = &MYCTX() -> m_InBuf[ 0 ][ SMS_BACKSTEP_SIZE ];
 MYCTX() -> m_pInBufPtr        = MYCTX() -> m_pInBuf;
 MYCTX() -> m_Info.m_FrameSize = 0;
 MYCTX() -> m_Len              = 0;

 return 0;

}  /* end MP123_Init */

static void MP123_Destroy ( SMS_CodecContext* apCtx ) {

}  /* end MP123_Destroy */

int MP123_CheckHeader ( uint32_t aHdr ) {

 if (      ( aHdr & 0xFFE00000  ) != 0xFFE00000 ) return 0;
 if (   (  ( aHdr >> 17 ) & 3   ) == 0          ) return 0;
 if (   (  ( aHdr >> 12 ) & 0xF ) == 0xF        ) return 0;
 if (   (  ( aHdr >> 10 ) & 3   ) == 3          ) return 0;

 return 1;

}  /* end MP123_CheckHeader */

static void _mp1_step_one ( unsigned int* apBAlloc, unsigned int aScaleIdx[ 2 ][ 32 ] ) {

 int             i;
 unsigned int*   lpBA     = apBAlloc;
 unsigned int*   lpSCA    = ( unsigned int* )aScaleIdx;
 SMS_BitContext* lpBitCtx = &g_MPACtx.m_BitCtx;

 if ( g_MPACtx.m_Info.m_nChannels == 2 ) {

  int lJSBound = g_MPACtx.m_JSBound;

  for ( i = 0; i < lJSBound; ++i ) { 

   lpBA[ 0 ] = SMS_GetBits ( lpBitCtx, 4 );
   lpBA[ 1 ] = SMS_GetBits ( lpBitCtx, 4 );

   lpBA += 2;

  }  /* end for */

  for ( i = lJSBound; i < 32; ++i ) *lpBA++ = SMS_GetBits ( lpBitCtx, 4 );

  lpBA = apBAlloc;

  for ( i = 0; i < lJSBound; ++i ) {

   if ( *lpBA++ ) *lpSCA++ = SMS_GetBits ( lpBitCtx, 6 );
   if ( *lpBA++ ) *lpSCA++ = SMS_GetBits ( lpBitCtx, 6 );

  }  /* end for */

  for ( i = lJSBound; i < 32; ++i )

   if ( *lpBA++ ) {

    *lpSCA++ = SMS_GetBits ( lpBitCtx, 6 );
    *lpSCA++ = SMS_GetBits ( lpBitCtx, 6 );

   }  /* end if */

 } else {

  for ( i = 0; i < 32; ++i) *lpBA++ = SMS_GetBits ( lpBitCtx, 4 );

  lpBA = apBAlloc;

  for ( i = 0; i < 32; ++i)

   if ( *lpBA++ ) *lpSCA++ = SMS_GetBits ( lpBitCtx, 6 );

 }  /* end else */

}  /* end _mp1_step_one */

static void _mp1_step_two (
             float aFraction[ 2 ][ 32 ], unsigned int aBAlloc[ 64 ],
	         unsigned int aScaleIdx[ 2 ][ 32 ]
            ) {

 int             i, lN;
 int             lSMBP[ 64 ];
 int*            lpSample;
 unsigned int*   lpBA;
 unsigned int*   lpSCA    = ( unsigned int*)aScaleIdx;
 SMS_BitContext* lpBitCtx = &g_MPACtx.m_BitCtx;

 if ( g_MPACtx.m_Info.m_nChannels == 2 ) {

  int    lJSBound = g_MPACtx.m_JSBound;
  float* lpF0     = aFraction[ 0 ];
  float* lpF1     = aFraction[ 1 ];

  lpBA = aBAlloc;

  for ( lpSample = lSMBP, i = 0; i < lJSBound; ++i )  {

   if (  ( lN = *lpBA++ )  ) *lpSample++ = SMS_GetBits ( lpBitCtx, lN + 1 );
   if (  ( lN = *lpBA++ )  ) *lpSample++ = SMS_GetBits ( lpBitCtx, lN + 1 );

  }  /* end for */

  for ( i = lJSBound; i < 32; ++i ) 
   if (  ( lN = *lpBA++ )  ) *lpSample++ = SMS_GetBits ( lpBitCtx, lN + 1 );

  lpBA = aBAlloc;

  for ( lpSample = lSMBP, i = 0; i < lJSBound; ++i ) {

   if (  ( lN = *lpBA++ )  )
    *lpF0++ = ( float )(   (  ( -1 ) << lN  ) + ( *lpSample++ ) + 1   ) * (  ( CTabArray64 )s_Muls  )[ lN + 1 ][ *lpSCA++ ];
   else *lpF0++ = 0.0F;

   if (  ( lN = *lpBA++ )  )
    *lpF1++ = ( float )(   (  ( -1 ) << lN  ) + ( *lpSample++ ) + 1   ) * (  ( CTabArray64 )s_Muls  )[ lN + 1 ][ *lpSCA++ ];
   else *lpF1++ = 0.0F;

  }  /* end for */

  for ( i = lJSBound; i < 32; ++i ) {

   if (  ( lN = *lpBA++ )  ) {

    float lSamp = ( float )(   (  ( -1 ) << lN  ) + ( * lpSample++ ) + 1   );

    *lpF0++ = lSamp * (  ( CTabArray64 )s_Muls  )[ lN + 1 ][ *lpSCA++ ];
    *lpF1++ = lSamp * (  ( CTabArray64 )s_Muls  )[ lN + 1 ][ *lpSCA++ ];

   } else *lpF0++ = *lpF1++ = 0.0F;

  }  /* end for */

 } else {

  float* lpF0 = aFraction[ 0 ];

  lpBA = aBAlloc;

  for ( lpSample = lSMBP, i = 0; i < 32; ++i )
   if (  ( lN = *lpBA++ )  ) *lpSample++ = SMS_GetBits ( lpBitCtx, lN + 1 );

  lpBA = aBAlloc;

  for ( lpSample = lSMBP, i = 0; i < 32; ++i )
   if (  ( lN = *lpBA++ )  )
    *lpF0++ = ( float )(   (  ( -1 ) << lN  ) + ( *lpSample++ ) + 1   ) * (  ( CTabArray64 )s_Muls  )[ lN + 1 ][ *lpSCA++ ];
   else *lpF0++ = 0.0F;

 }  /* end else */

}  /* end _mp1_step_two */

static void _mp1_decode_frame ( SMS_RingBuffer* apRB ) {

 SMS_ALIGN( float lFraction[ 2 ][ 32 ], 16 );

 int          i, lStereo = g_MPACtx.m_Info.m_nChannels;
 unsigned int lBAlloc[ 64 ];
 unsigned int lScaleIdx[ 2 ][ 32 ];
 int          lnAlloc   = lStereo * 768;
 short*       lpSamples = ( short* )SMS_RingBufferAlloc ( apRB, lnAlloc + 80 );

 lpSamples += 32;
 *( int* )lpSamples = lnAlloc;
 lpSamples += 8;

 g_MPACtx.m_JSBound = g_MPACtx.m_Info.m_Mode == SMS_MPA_JSTEREO ?
  ( g_MPACtx.m_Info.m_ModeExt << 2 ) + 4 : 32;

 _mp1_step_one ( lBAlloc, lScaleIdx );

 if ( g_MPACtx.m_Info.m_nChannels == 2 ) for ( i = 0; i < 12; ++i ) {

  _mp1_step_two ( lFraction, lBAlloc, lScaleIdx );

               MP123_Synth (  lFraction[ 0 ], 0, ( void* )lpSamples, 2  );
  lpSamples += MP123_Synth (  lFraction[ 1 ], 1, ( void* )lpSamples, 2  );

 } else for ( i = 0; i < 12; ++i ) {

  _mp1_step_two ( lFraction, lBAlloc, lScaleIdx );

  lpSamples += MP123_Synth (  lFraction[ 0 ], 0, ( void* )lpSamples, 1  );

 }  /* end for */

}  /* end _mp1_decode_frame */

static void _mp2_select_table ( void ) {

 static int sl_Translate[ 3 ][ 2 ][ 16 ] = {
  {
   { 0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 0 },
   { 0, 2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }
  },
  {
   { 0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
   { 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
  },
  {
   { 0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 1, 1, 1, 1, 0 },
   { 0, 3, 3, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }
  }
 };
 static SMS_MP2AllocTable* sl_pTables[ 5 ] = {
  s_Alloc0, s_Alloc1, s_Alloc2, s_Alloc3, s_Alloc4
 };
 static int sl_SBLims[ 5 ] = { 27, 30, 8, 12 , 30 };

 int lTable;

 if ( g_MPACtx.m_Info.m_SampleRateIdx >= 3 )
  lTable= 4;
 else lTable = sl_Translate[ g_MPACtx.m_Info.m_SampleRateIdx ][ 2 - g_MPACtx.m_Info.m_nChannels ][ g_MPACtx.m_Info.m_BitRateIdx ];

 g_MPACtx.m_pAlloc   = sl_pTables[ lTable ];
 g_MPACtx.m_2SBLinit = sl_SBLims [ lTable ];

}  /* end _mp2_select_table */

static void _mp2_step_one ( unsigned int* apBitAlloc, int* apScale ) {

 static unsigned int sl_SCFSI[ 64 ];

 int                lStereo   = g_MPACtx.m_Info.m_nChannels - 1;
 int                lSBLimit  = g_MPACtx.m_2SBLinit;
 int                lJSBbound = g_MPACtx.m_JSBound;
 int                lSBLimit2 = lSBLimit << lStereo;
 SMS_MP2AllocTable* lpAlloc   = g_MPACtx.m_pAlloc;
 SMS_BitContext*    lpBitCtx  = &g_MPACtx.m_BitCtx;

 int           i;
 unsigned int* lpSCFSI, *lpBitA = apBitAlloc;
 int           lSC, lStep;

 if ( lStereo ) {

  for (  i = lJSBbound; i; --i, lpAlloc += ( 1 << lStep )  ) {

   lStep = lpAlloc -> m_Bits;

   lpBitA[ 0 ] = ( char )SMS_GetBits ( lpBitCtx, lStep );
   lpBitA[ 1 ] = ( char )SMS_GetBits ( lpBitCtx, lStep );

   lpBitA += 2;

  }  /* end for */

  for (  i = lSBLimit - lJSBbound; i; --i, lpAlloc += ( 1 << lStep )  ) {

   lStep = lpAlloc -> m_Bits;

   lpBitA[ 0 ] = ( char )SMS_GetBits ( lpBitCtx, lStep );
   lpBitA[ 1 ] = lpBitA[ 0 ];

   lpBitA += 2;

  }  /* end for */

  lpBitA  = apBitAlloc;
  lpSCFSI = sl_SCFSI;

  for ( i = lSBLimit2; i; --i )
   if ( *lpBitA++ ) *lpSCFSI++ = ( char )SMS_GetBits ( lpBitCtx, 2 );

 } else {

  for (  i = lSBLimit; i; --i, lpAlloc += ( 1<< lStep )  ) {

   lStep = lpAlloc -> m_Bits;
   *lpBitA++ = ( char )SMS_GetBits ( lpBitCtx, lStep );

  }  /* end for */

  lpBitA    = apBitAlloc;
  lpSCFSI   = sl_SCFSI;

  for ( i = lSBLimit; i; --i )
   if ( * lpBitA++) *lpSCFSI++ = ( char )SMS_GetBits ( lpBitCtx, 2 );

 }  /* end else */

 lpBitA  = apBitAlloc;
 lpSCFSI = sl_SCFSI;

 for ( i = lSBLimit2; i; --i ) 

  if ( *lpBitA++ ) {

   switch ( *lpSCFSI++ ) {

    case 0: 
     apScale[ 0 ] = SMS_GetBits ( lpBitCtx, 6 );
     apScale[ 1 ] = SMS_GetBits ( lpBitCtx, 6 );
     apScale[ 2 ] = SMS_GetBits ( lpBitCtx, 6 );
    break;

    case 1: 
     apScale[ 0 ] = lSC = SMS_GetBits ( lpBitCtx, 6 );
     apScale[ 1 ] = lSC;
     apScale[ 2 ] = SMS_GetBits ( lpBitCtx, 6 );
    break;

    case 2:
     apScale[ 0 ] = lSC = SMS_GetBits ( lpBitCtx, 6 );
     apScale[ 1 ] = lSC;
     apScale[ 2 ] = lSC;
    break;

    case 3:
     apScale[ 0 ] = SMS_GetBits ( lpBitCtx, 6 );
     apScale[ 1 ] = lSC = SMS_GetBits ( lpBitCtx, 6 );
     apScale[ 2 ] = lSC;
    break;

   }  /* end switch */

   apScale += 3;

  }  /* end if */

}  /* end _mp2_step_one */

static void _mp2_step_two ( unsigned int* apBitAlloc, float aFraction[ 2 ][ 4 ][ 32 ], int* apScale, int aX ) {

 static char* sl_Tab[ 10 ] = {
  NULL, NULL, NULL, s_Grp3, 0, s_Grp5, 0, 0, 0, s_Grp9
 };

 int                i, j, k, lBA;
 int                lStereo   = g_MPACtx.m_Info.m_nChannels;
 int                lSBLimit  = g_MPACtx.m_2SBLinit;
 int                lJSBbound = g_MPACtx.m_JSBound;
 unsigned int*      lpBitA    = apBitAlloc;
 int                lD, lStep;
 SMS_MP2AllocTable* lpAlloc2, *lpAlloc1 = g_MPACtx.m_pAlloc;
 SMS_BitContext*    lpBitCtx  = &g_MPACtx.m_BitCtx;

 for (  i = 0; i < lJSBbound; ++i, lpAlloc1 += ( 1 << lStep )  ) {

  lStep = lpAlloc1 -> m_Bits;

  for ( j = 0; j < lStereo; ++j ) {

   if (  ( lBA = *lpBitA++ )  ) {

    k = ( lpAlloc2 = lpAlloc1 + lBA ) -> m_Bits;

    if (  ( lD = lpAlloc2 ->m_D ) < 0  )  {

     float lCM = (  ( CTabArray64 )s_Muls  )[ k ][  apScale[ aX ]  ];

     aFraction[ j ][ 0 ][ i ] = (  ( float )(  ( int )SMS_GetBits ( lpBitCtx, k ) + lD )  ) * lCM;
     aFraction[ j ][ 1 ][ i ] = (  ( float )(  ( int )SMS_GetBits ( lpBitCtx, k ) + lD )  ) * lCM;
     aFraction[ j ][ 2 ][ i ] = (  ( float )(  ( int )SMS_GetBits ( lpBitCtx, k ) + lD )  ) * lCM;

    } else  {

     unsigned int   lIdx, lM = apScale[ aX ];
     unsigned char* lpTab;

     lIdx  = ( unsigned int   )SMS_GetBits ( lpBitCtx, k );
     lpTab = ( unsigned char* )( sl_Tab[ lD ] + lIdx + lIdx + lIdx );

     aFraction[ j ][ 0 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab++ ][ lM ];
     aFraction[ j ][ 1 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab++ ][ lM ];
     aFraction[ j ][ 2 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab++ ][ lM ];

    }  /* end else */

    apScale += 3;

   } else aFraction[ j ][ 0 ][ i ] =
          aFraction[ j ][ 1 ][ i ] =
          aFraction[ j ][ 2 ][ i ] = 0.0F;
  }  /* end for */

 }  /* end for */

 for (  i = lJSBbound; i < lSBLimit; ++i , lpAlloc1 += ( 1 << lStep )  ) {

  lStep = lpAlloc1 -> m_Bits;
  ++lpBitA;

  if (  ( lBA = *lpBitA++ )  ) {

   k = ( lpAlloc2 = lpAlloc1 + lBA ) -> m_Bits;

   if (  ( lD = lpAlloc2 -> m_D ) < 0  ) {

    float lCM = (  ( CTabArray64 )s_Muls  )[ k ][  apScale[ aX + 3 ]  ];

    aFraction[ 1 ][ 0 ][ i ] = (   aFraction[ 0 ][ 0 ][ i ] = ( float )(  ( int )SMS_GetBits ( lpBitCtx, k ) + lD  )   ) * lCM;
    aFraction[ 1 ][ 1 ][ i ] = (   aFraction[ 0 ][ 1 ][ i ] = ( float )(  ( int )SMS_GetBits ( lpBitCtx, k ) + lD  )   ) * lCM;
    aFraction[ 1 ][ 2 ][ i ] = (   aFraction[ 0 ][ 2 ][ i ] = ( float )(  ( int )SMS_GetBits ( lpBitCtx, k ) + lD  )   ) * lCM;

    lCM = (  ( CTabArray64 )s_Muls  )[ k ][  apScale[ aX ]  ];

    aFraction[ 0 ][ 0 ][ i ] *= lCM;
    aFraction[ 0 ][ 1 ][ i ] *= lCM;
    aFraction[ 0 ][ 2 ][ i ] *= lCM;

   } else {

    unsigned int   lIdx, lM1, lM2;
    unsigned char* lpTab;

    lM1 = apScale[ aX + 0 ];
    lM2 = apScale[ aX + 3 ];

    lIdx  = ( unsigned int   )SMS_GetBits ( lpBitCtx, k );
    lpTab = ( unsigned char* )(  sl_Tab[ lD ] + lIdx + lIdx + lIdx );

    aFraction[ 0 ][ 0 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab   ][ lM1 ];
    aFraction[ 1 ][ 0 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab++ ][ lM2 ];
    aFraction[ 0 ][ 1 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab   ][ lM1 ];
    aFraction[ 1 ][ 1 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab++ ][ lM2 ];
    aFraction[ 0 ][ 2 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab   ][ lM1 ];
    aFraction[ 1 ][ 2 ][ i ] = (  ( CTabArray64 )s_Muls  )[ *lpTab   ][ lM2 ];

   }  /* end else */

   apScale += 6;

  } else aFraction[ 0 ][ 0 ][ i ] =
         aFraction[ 0 ][ 1 ][ i ] =
         aFraction[ 0 ][ 2 ][ i ] =
         aFraction[ 1 ][ 0 ][ i ] =
         aFraction[ 1 ][ 1 ][ i ] =
         aFraction[ 1 ][ 2 ][ i ] = 0.0F;
 }  /* end for */

 if ( lSBLimit > 32 ) lSBLimit = 32;

 for ( i = lSBLimit; i < 32; ++i)

  for ( j = 0; j < lStereo; ++j )

   aFraction[ j ][ 0 ][ i ] =
   aFraction[ j ][ 1 ][ i ] =
   aFraction[ j ][ 2 ][ i ] = 0.0F;

}  /* end _mp2_step_two */

static void _mp2_decode_frame ( SMS_RingBuffer* apRB ) {

 SMS_ALIGN( float lFraction[ 2 ][ 4 ][ 32 ], 16 );

 int            i, j;
 unsigned int   lBitAlloc[ 64 ];
 int            lScale   [ 192 ];
 int            lnAlloc   = g_MPACtx.m_Info.m_nChannels * 2304;
 short*         lpSamples = ( short* )SMS_RingBufferAlloc ( apRB, lnAlloc + 80 );

 lpSamples += 32;
 *( int* )lpSamples = lnAlloc;
 lpSamples += 8;

 _mp2_select_table ();

 g_MPACtx.m_JSBound = g_MPACtx.m_Info.m_Mode == SMS_MPA_JSTEREO ?
  ( g_MPACtx.m_Info.m_ModeExt << 2 ) + 4 : g_MPACtx.m_2SBLinit;

 if ( g_MPACtx.m_JSBound > g_MPACtx.m_2SBLinit ) g_MPACtx.m_JSBound = g_MPACtx.m_2SBLinit;

 _mp2_step_one ( lBitAlloc, lScale );

 if ( g_MPACtx.m_Info.m_nChannels == 2 ) for ( i = 0; i < 12; ++i ) {

  _mp2_step_two ( lBitAlloc, lFraction, lScale, i >> 2 );

  for ( j = 0; j < 3; ++j ) {

                MP123_Synth (  lFraction[ 0 ][ j ], 0, ( void* )lpSamples, 2  );
   lpSamples += MP123_Synth (  lFraction[ 1 ][ j ], 1, ( void* )lpSamples, 2  );

  }  /* end for */

 } else for ( i = 0; i < 12; ++i ) {

  _mp2_step_two ( lBitAlloc, lFraction, lScale, i >> 2 );

  for ( j = 0; j < 3; ++j )

   lpSamples += MP123_Synth (  lFraction[ 0 ][ j ], 0, ( void* )lpSamples, 1  );

 }  /* end for */
 
}  /* end _mp2_decode_frame */

int MP123_DecodeHeader ( uint32_t aHdr, SMS_MPAInfo* apInfo ) {

 int lSampleRate;
 int lFrameSize;
 int lMPEG25;
 int lPadding;
 int lSampleRateIdx;
 int lBitrateIdx;

 if (  aHdr & ( 1 << 20 )  ) {

  apInfo -> m_LSF = (  aHdr & ( 1 << 19 )  ) ? 0 : 1;
  lMPEG25        = 0;

 } else {

  apInfo -> m_LSF = 1;
  lMPEG25         = 1;

 }  /* end else */

 apInfo -> m_Layer = 3 - (  ( aHdr >> 17 ) & 3  );

 lSampleRateIdx  = ( aHdr >> 10 ) & 3;
 lSampleRate     = g_mpa_freq_tab[ lSampleRateIdx ] >> ( apInfo -> m_LSF + lMPEG25 );
 lSampleRateIdx += 3 * ( apInfo -> m_LSF + lMPEG25 );

 apInfo -> m_SampleRateIdx   = lSampleRateIdx;
 apInfo -> m_ErrorProtection = (  ( aHdr >> 16 ) & 1  ) ^ 1;
 apInfo -> m_SampleRate      = lSampleRate;

 lBitrateIdx = ( aHdr >> 12 ) & 0xF;
 lPadding    = ( aHdr >>  9 ) & 0x1;

 apInfo -> m_Mode       = ( aHdr >> 6 ) & 3;
 apInfo -> m_ModeExt    = ( aHdr >> 4 ) & 3;
 apInfo -> m_nChannels  = apInfo -> m_Mode == SMS_MPA_MONO ? 1 : 2;
 apInfo -> m_BitRateIdx = lBitrateIdx;

 if ( lBitrateIdx != 0 ) {

  lFrameSize = g_mpa_bitrate_tab[ apInfo -> m_LSF ][ apInfo -> m_Layer ][ lBitrateIdx ];

  apInfo -> m_BitRate = lFrameSize * 1000;

  switch ( apInfo -> m_Layer ) {

   case 0:
    lFrameSize = ( lFrameSize * 12000 ) / lSampleRate;
    lFrameSize = ( lFrameSize  + lPadding ) * 4;
   break;

   case 1:
    lFrameSize  = ( lFrameSize * 144000 ) / lSampleRate;
    lFrameSize += lPadding;
   break;

   case 2 :
   default:
    lFrameSize  = ( lFrameSize * 144000 ) / ( lSampleRate << apInfo -> m_LSF );
    lFrameSize += lPadding;
   break;

  }  /* end switch */

  apInfo -> m_FrameSize = lFrameSize;

 } else {

  if ( !apInfo -> m_FreeFmtFrameSize ) return 1;

  apInfo -> m_FrameSize = apInfo -> m_FreeFmtFrameSize;

  switch ( apInfo -> m_Layer ) {

   case 0:
    apInfo -> m_FrameSize += lPadding  * 4;
    apInfo -> m_BitRate    = ( apInfo -> m_FrameSize * lSampleRate ) / 48000;
   break;

   case 1:
    apInfo -> m_FrameSize += lPadding;
    apInfo -> m_BitRate    = ( apInfo -> m_FrameSize * lSampleRate ) / 144000;
   break;

   case 2 :
   default:
    apInfo -> m_FrameSize += lPadding;
    apInfo -> m_BitRate    = (  apInfo -> m_FrameSize * ( lSampleRate << apInfo -> m_LSF )  ) / 144000;
   break;

  }  /* end switch */

 }  /* end if */

 return 0;

}  /* end MP123_DecodeHeader */

static void _seek_to_main_data ( unsigned int aBackStep ) {

 uint8_t* lPtr = ( uint8_t* )(   g_MPACtx.m_BitCtx.m_pBuf + (  SMS_BitCount ( &g_MPACtx.m_BitCtx ) >> 3  )   );

 lPtr -= aBackStep;

 memcpy (
  lPtr, g_MPACtx.m_InBuf[ g_MPACtx.m_InBufIdx ^ 1 ] + 
  SMS_BACKSTEP_SIZE + g_MPACtx.m_OldFrameSize - aBackStep, aBackStep
 );

 SMS_InitGetBits (
  &g_MPACtx.m_BitCtx, lPtr, ( g_MPACtx.m_Info.m_FrameSize + aBackStep ) * 8
 );

 g_MPACtx.m_InBufIdx    ^= 1;
 g_MPACtx.m_pInBuf       = &g_MPACtx.m_InBuf [ g_MPACtx.m_InBufIdx ][ SMS_BACKSTEP_SIZE ];
 g_MPACtx.m_OldFrameSize = g_MPACtx.m_Info.m_FrameSize;

}  /* end _seek_to_main_data */

static int _mp3_get_side_info (
            SMS_MP3SideInfo* apSI, int aStereo, int aMStereo, int aSFreq, int aLSF
           ) {

 static const int sl_Tabs[ 2 ][ 5 ] = {
  { 2, 9, 5, 3, 4 },
  { 1, 8, 1, 2, 9 }
 };

 int             lCh, lGr;
 const int*      lpTab    = sl_Tabs[ aLSF ];
 SMS_BitContext* lpBitCtx = &g_MPACtx.m_BitCtx;
   
 apSI -> m_MainDataBegin = SMS_GetBits ( lpBitCtx, lpTab[ 1 ] );
 apSI -> m_PrivBits      = SMS_GetBits ( lpBitCtx, lpTab[ aStereo + 1 ] );

 if ( !aLSF ) for ( lCh = 0; lCh < aStereo; ++lCh ) {
  apSI -> m_Ch[ lCh ].m_GI[ 0 ].m_SCFSI = -1;
  apSI -> m_Ch[ lCh ].m_GI[ 1 ].m_SCFSI = SMS_GetBits ( lpBitCtx, 4 );
 }  /* end for */

 for ( lGr = 0; lGr < lpTab[ 0 ]; ++lGr )

  for ( lCh = 0; lCh < aStereo; ++lCh ) {

   SMS_MP3GranInfo* lpGI = &( apSI -> m_Ch[ lCh ].m_GI[ lGr ] );

   lpGI -> m_Part23Len = SMS_GetBits ( lpBitCtx, 12 );
   lpGI -> m_BigValues = SMS_GetBits ( lpBitCtx,  9 );

   if ( lpGI -> m_BigValues > 288 ) lpGI -> m_BigValues = 288;

   lpGI -> m_pPow2Gain = ( float* )s_GainPow2 + 256 - SMS_GetBits ( lpBitCtx, 8 );

   if ( aMStereo ) lpGI -> m_pPow2Gain += 2;

   lpGI -> m_ScaleFaCompress = SMS_GetBits ( lpBitCtx, lpTab[ 4 ] );

   if (  SMS_GetBit ( lpBitCtx )  ) {

    lpGI -> m_BlockType      = SMS_GetBits ( lpBitCtx, 2 );
    lpGI -> m_fMixedBlock    = SMS_GetBit  ( lpBitCtx    );
    lpGI -> m_TabSelect[ 0 ] = SMS_GetBits ( lpBitCtx, 5 );
    lpGI -> m_TabSelect[ 1 ] = SMS_GetBits ( lpBitCtx, 5 );
    lpGI -> m_TabSelect[ 2 ] = 0;
    lpGI -> m_pFullGain[ 0 ] = lpGI -> m_pPow2Gain + (  SMS_GetBits ( lpBitCtx, 3 ) << 3  );
    lpGI -> m_pFullGain[ 1 ] = lpGI -> m_pPow2Gain + (  SMS_GetBits ( lpBitCtx, 3 ) << 3  );
    lpGI -> m_pFullGain[ 2 ] = lpGI -> m_pPow2Gain + (  SMS_GetBits ( lpBitCtx, 3 ) << 3  );

    if ( !lpGI -> m_BlockType ) return 0;
    
    if ( !aLSF || lpGI -> m_BlockType == 2 )
     lpGI -> m_Reg1Start = 18;
    else {
     if ( aSFreq == 8 )
      lpGI -> m_Reg1Start = 54;
     else lpGI -> m_Reg1Start = 27;
    }  /* end else */

    lpGI -> m_Reg2Start = 288;

   } else {

    int lR0C, lR1C;

    lpGI -> m_TabSelect[ 0 ] = SMS_GetBits ( lpBitCtx, 5 );
    lpGI -> m_TabSelect[ 1 ] = SMS_GetBits ( lpBitCtx, 5 );
    lpGI -> m_TabSelect[ 2 ] = SMS_GetBits ( lpBitCtx, 5 );

    lR0C = SMS_GetBits ( lpBitCtx, 4 ) + 1;
    lR1C = SMS_GetBits ( lpBitCtx, 3 ) + 1;

    lpGI -> m_Reg1Start   = s_BandInfo[ aSFreq ].m_LongIdx[ lR0C        ] >> 1;
    lpGI -> m_Reg2Start   = s_BandInfo[ aSFreq ].m_LongIdx[ lR0C + lR1C ] >> 1;
    lpGI -> m_BlockType   = 0;
    lpGI -> m_fMixedBlock = 0;

   }  /* end else */

   if ( !aLSF ) lpGI -> m_fPre = SMS_GetBit ( lpBitCtx );

   lpGI -> m_ScaleFacScale = SMS_GetBit ( lpBitCtx );
   lpGI -> m_Count1TblSel  = SMS_GetBit ( lpBitCtx );

  }  /* end for */

 return 1;

}  /* end _mp3_get_side_info */

static int _mp3_get_scale_factors_1 (
            int* apSCF, SMS_MP3GranInfo* apGI, int anUnused
           ) {

 static const unsigned char sl_Len[ 2 ][ 16 ] = {
  { 0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4 },
  { 0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3 }
 };

 int             i, lnBits;
 int             lNum0    = sl_Len[ 0 ][ apGI -> m_ScaleFaCompress ];
 int             lNum1    = sl_Len[ 1 ][ apGI -> m_ScaleFaCompress ];
 SMS_BitContext* lpBitCtx = &g_MPACtx.m_BitCtx;

 if ( apGI -> m_BlockType == 2 ) {

  i = 18;

  lnBits = ( lNum0 + lNum1 ) * 18;

  if ( apGI -> m_fMixedBlock ) {

   if ( lNum0 )
    for ( i = 8; i; --i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum0 );
   else for ( i = 8; i; --i ) *apSCF++ = 0;

   i       = 9;
   lnBits -= lNum0;

  }  /* end if */

  if ( lNum0 )
   for ( ; i; --i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum0 );
  else for ( ; i; --i ) *apSCF++ = 0;

  if ( lNum1 )
   for ( i = 18; i; --i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum1 );
  else for ( i = 18; i; --i ) *apSCF++ = 0;

  apSCF[ 0 ] =
  apSCF[ 1 ] =
  apSCF[ 2 ] = 0;

 } else {

  int lSCFSI = apGI -> m_SCFSI;

  if ( lSCFSI < 0 ) {

   if ( lNum0 )
    for ( i = 11; i; --i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum0 );
   else for ( i = 11; i; --i ) *apSCF++ = 0;

   if ( lNum1 )
    for ( i = 10; i; --i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum1 );
   else for ( i = 10; i; --i ) *apSCF++ = 0;

   lnBits = ( lNum0 + lNum1 ) * 10 + lNum0;
   *apSCF = 0;

  } else {

   lnBits = 0;

   if (  !( lSCFSI & 0x8 )  ) {

    if ( lNum0 )
     for ( i = 0; i < 6; ++i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum0 );
    else for ( i = 0; i < 6; ++i ) *apSCF++ = 0;

    lnBits += lNum0 * 6;

   } else apSCF += 6; 

   if (  !( lSCFSI & 0x4 )  ) {

    if ( lNum0 )
     for ( i = 0; i < 5; ++i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum0 );
    else for ( i = 0; i < 5; ++i ) *apSCF++ = 0;

    lnBits += lNum0 * 5;

   } else apSCF += 5;

   if (  ! ( lSCFSI & 0x2 )  ) {

    if ( lNum1 )
     for ( i = 0; i < 5; ++i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum1 );
    else for ( i = 0; i < 5; ++i ) *apSCF++ = 0;

    lnBits += lNum1 * 5;

   } else apSCF += 5; 

   if (  !( lSCFSI & 0x1 )  ) {

    if ( lNum1 )
     for ( i = 0; i < 5; ++i ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum1 );
    else for ( i = 0; i < 5; ++i ) *apSCF++ = 0;

    lnBits += lNum1 * 5;

   } else apSCF += 5;

   *apSCF = 0;

  }  /* end else */

 }  /* end else */

 return lnBits;

}  /* end _mp3_get_scale_factors_1 */

static int _mp3_get_scale_factors_2 ( int* apSCF, SMS_MP3GranInfo* apGI, int aStereo ) {

 static unsigned char sl_STab[ 3 ][ 6 ][ 4 ] = {
  { {  6,  5,  5, 5 }, {  6, 5,  7, 3 }, { 11, 10, 0, 0 },
    {  7,  7,  7, 0 }, {  6, 6,  6, 3 }, {  8,  8, 5, 0 }
  },
  { {  9,  9,  9, 9 }, {  9, 9, 12, 6 }, { 18, 18, 0, 0 },
    { 12, 12, 12, 0 }, { 12, 9,  9, 6 }, { 15, 12, 9, 0 }
  },
  { {  6,  9,  9, 9 }, {  6,  9, 12, 6 }, { 15, 18, 0, 0 },
    {  6, 15, 12, 0 }, {  6, 12,  9, 6 }, {  6, 18, 9, 0 }
  }
 }; 

 unsigned char*  lpPnt;
 int             i, j, lN = 0, lnBits = 0;
 unsigned int    lSLen;
 SMS_BitContext* lpBitCtx = &g_MPACtx.m_BitCtx;

 lSLen = aStereo ? s_iSLen2[ apGI -> m_ScaleFaCompress >> 1 ]
                 : s_nSLen2[ apGI -> m_ScaleFaCompress      ];
 apGI -> m_fPre = ( lSLen >> 15 ) & 0x1;

 if ( apGI -> m_BlockType == 2 ) {
  ++lN;
  if ( apGI -> m_fMixedBlock ) ++lN;
 }  /* end if */

 lpPnt = sl_STab[ lN ][ ( lSLen >> 12 ) & 0x7 ];

 for ( i = 0; i < 4; ++i ) {

  int lNum = lSLen & 0x7;

  lSLen >>= 3;

  if ( lNum ) {

   for ( j = 0; j < ( int )lpPnt[ i ]; ++j ) *apSCF++ = SMS_GetBits ( lpBitCtx, lNum );
   lnBits += lpPnt[ i ] * lNum;

  } else for ( j = 0; j < ( int )lpPnt[ i ]; ++j ) *apSCF++ = 0;

 }  /* end for */
  
 lN = ( lN << 1 ) + 1;

 for ( i = 0; i < lN; ++i ) *apSCF++ = 0;

 return lnBits;

}  /* end _mp3_get_scale_factors_2 */

#define GET_BYTE() *lpData++; lBitIdx += 8
#define REFRESH_MASK() \
 while ( lNum < 24 ) {                   \
  unsigned int lByte = GET_BYTE();       \
  lMask        |= lByte << ( 24 - lNum );\
  lNum         += 8;                     \
  lPart2Remain -= 8;                     \
 }

static int _mp3_dequantize_sample (
            float aXR[ 32 ][ 18 ], int* apSCF,
            SMS_MP3GranInfo* apGI, int aSFreq, int aPart2Bits
           ) {

 int             lShift       = 1 + apGI -> m_ScaleFacScale;
 float*          lpXRPnt      = ( float* )aXR;
 int             lPart2Remain = apGI -> m_Part23Len - aPart2Bits;
 SMS_BitContext* lpBitCtx     = &g_MPACtx.m_BitCtx;
 int             lNum         = -lpBitCtx -> m_Idx & 7;
 int             lMask        = ( int )SMS_GetBits ( lpBitCtx, lNum ) << ( 32 - lNum );
 int             lBitIdx      = lpBitCtx -> m_Idx;
 uint8_t*        lpData       = ( uint8_t* )(  lpBitCtx -> m_pBuf + ( lpBitCtx -> m_Idx >> 3 )  );
 int             lBV          = apGI -> m_BigValues;
 int             lRegion1     = apGI -> m_Reg1Start;
 int             lRegion2     = apGI -> m_Reg2Start;
 int             lL[ 3 ], lL3, lRMax;
 short*          lpME;
 short*          lpVal;

 if ( lRegion1 > lRegion2 ) return 0;

 lPart2Remain -= lNum;
 lL3           = ( 288 - lBV ) >> 1;   

 if ( lBV <= lRegion1 ) {
  lL[ 0 ] = lBV;
  lL[ 1 ] = 0;
  lL[ 2 ] = 0;
 } else {
  lL[ 0 ] = lRegion1;
  if ( lBV <= lRegion2 ) {
   lL[ 1 ] = lBV - lL[ 0 ];
   lL[ 2 ] = 0;
  } else {
   lL[ 1 ] = lRegion2 - lL[ 0 ];
   lL[ 2 ] = lBV - lRegion2;
  }  /* end else */
 }  /* end else */
 
 if ( apGI -> m_BlockType == 2 ) {

  int    i, lMax[ 4 ];
  int    lStep = 0, lWin = 3, lCB = 0, lMC;
  float  lV = 0.0F;
  short* lpM;

  if ( apGI -> m_fMixedBlock ) {
   lMax[ 0 ] =
   lMax[ 1 ] =
   lMax[ 2 ] =  2;
   lMax[ 3 ] = -1;
   lpM  = s_pMap   [ aSFreq ][ 0 ];
   lpME = s_pMapEnd[ aSFreq ][ 0 ];
  } else {
   lMax[ 0 ] =
   lMax[ 1 ] =
   lMax[ 2 ] =
   lMax[ 3 ] = -1;
   lpM  = s_pMap   [ aSFreq ][ 1 ];
   lpME = s_pMapEnd[ aSFreq ][ 1 ];
  }  /* end else */

  lMC = 0;

  for ( i = 0; i < 2; ++i ) {

   int    lLP = lL[ i ];
   _Huff* lpH = s_HuffTbl + apGI -> m_TabSelect[ i ];
   float  lPow;

   for ( ; lLP; --lLP, --lMC ) {

    int   lX, lY;
    float lVal;

    if ( !lMC ) {

     lMC     = lpM[ 0 ];
     lpXRPnt = (  ( float* )aXR  ) + lpM[ 1 ];
     lWin    = lpM[ 2 ];
     lCB     = lpM[ 3 ];
     lpM    += 4;

     if ( lWin == 3 ) {
      lV    = apGI -> m_pPow2Gain[ ( *apSCF++ ) << lShift ];
      lStep = 1;
     } else {
      lV    = apGI -> m_pFullGain[ lWin ][ ( *apSCF++ ) << lShift ];
      lStep = 3;
     }  /* end else */

    }  /* end if */

    lpVal = lpH -> m_pTable;

    REFRESH_MASK();

    while (  ( lY = *lpVal++ ) < 0  ) {
     if ( lMask < 0 ) lpVal -= lY;
     --lNum;
     lMask <<= 1;
    }  /* end while */

    lX  = lY >> 4;
    lY &= 0xF;

    if ( lX == 15 && lpH -> m_LinBits ) {

     lMax[ lWin ] = lCB;

     REFRESH_MASK();

     lX     += (  ( unsigned int )lMask ) >> ( 32 - lpH -> m_LinBits );
     lNum   -= lpH -> m_LinBits + 1;
     lMask <<= lpH -> m_LinBits;
     lPow    = lMask < 0 ? -(  ( float* )s_ISPow  )[ lX ] : (  ( float* )s_ISPow  )[ lX ];
     lMask <<= 1;
     lVal    = lPow * lV;

    } else if ( lX ) {

     lMax[ lWin ] = lCB;
     lPow         = lMask < 0 ? -(  ( float* )s_ISPow  )[ lX ] : (  ( float* )s_ISPow  )[ lX ];
     lMask      <<= 1;
     --lNum;

     lVal = lPow * lV;

    } else lVal = 0.0F;

    *lpXRPnt  = lVal;
     lpXRPnt += lStep;

    if ( lY == 15 && lpH -> m_LinBits ) {

     lMax[ lWin ] = lCB;

     REFRESH_MASK();

     lY     += (  ( unsigned int )lMask  ) >> ( 32 - lpH -> m_LinBits );
     lNum   -= lpH -> m_LinBits + 1;
     lMask <<= lpH -> m_LinBits;
     lPow    = lMask < 0 ? -(  ( float* )s_ISPow  )[ lY ] : (  ( float* )s_ISPow  )[ lY ];
     lMask <<= 1;
     lVal    = lPow * lV;

    } else if ( lY ) {

     lPow         = lMask < 0 ? -(  ( float* )s_ISPow  )[ lY ] : (  ( float* )s_ISPow  )[ lY ];
     lMask      <<= 1;
     lMax[ lWin ] = lCB;
     --lNum;

     lVal = lPow * lV;

    } else lVal = 0.0F;

    *lpXRPnt = lVal;
    lpXRPnt += lStep;

   }  /* end for */

  }  /* end for */

  for (  ; lL3 && lPart2Remain + lNum > 0; --lL3 ) {

   _Huff* lpH   = s_HuffTblC + apGI -> m_Count1TblSel;
   short* lpVal = lpH -> m_pTable;
   short  lA;

   REFRESH_MASK();

   while (  ( lA = *lpVal++ ) < 0  ) {
    if ( lMask < 0 ) lpVal -= lA;
    --lNum;
    lMask <<= 1;
   }  /* end while */

   if ( lPart2Remain + lNum <= 0 ) {
	lNum -= lPart2Remain + lNum;
	break;
   }  /* end if */

   for ( i = 0; i < 4; ++i ) {

    if (  !( i & 1 )  ) {

     if ( !lMC ) {

      lMC     = lpM[ 0 ];
      lpXRPnt = (  ( float* )aXR  ) + lpM[ 1 ];
      lWin    = lpM[ 2 ];
      lCB     = lpM[ 3 ];
      lpM    += 4;

      if ( lWin == 3 ) {
       lV    = apGI -> m_pPow2Gain[ ( *apSCF++ ) << lShift ];
       lStep = 1;
      } else {
       lV    = apGI -> m_pFullGain[ lWin ][ ( *apSCF++ ) << lShift ];
       lStep = 3;
      }  /* end else */

     }  /* end if */

     --lMC;

    }  /* end if */

    if (   (  lA & ( 0x8 >> i )  )   ) {

     lMax[ lWin ] = lCB;

     if ( lPart2Remain + lNum <= 0 ) break;

     *lpXRPnt = lMask < 0 ? -lV : lV;

     --lNum;
     lMask <<= 1;

    } else *lpXRPnt = 0.0F;

    lpXRPnt += lStep;

   }  /* end for */

  }  /* end for */

  if ( lWin < 3 ) {

   while ( 1 ) {

    for (  ; lMC > 0; --lMC ) {
     lpXRPnt[ 0 ] = 0.0F;
     lpXRPnt[ 3 ] = 0.0F;
     lpXRPnt     += 6;
    }  /* end for */

    if ( lpM >= lpME ) break;

    lMC     = *lpM++;
    lpXRPnt = (  ( float* ) aXR  ) + *lpM++;

    if ( *lpM++ == 0 ) break;

    lpM++;

   }  /* end while */

  }  /* end if */

  apGI -> m_MaxBand[ 0 ] = lMax[ 0 ] + 1;
  apGI -> m_MaxBand[ 1 ] = lMax[ 1 ] + 1;
  apGI -> m_MaxBand[ 2 ] = lMax[ 2 ] + 1;
  apGI -> m_MaxBandL     = lMax[ 3 ] + 1;

  lRMax = lMax[ 0 ] > lMax[ 1 ] ? lMax[ 0 ] : lMax[ 1 ];
  lRMax = ( lRMax > lMax[ 2 ] ? lRMax : lMax[ 2 ] ) + 1;

  apGI -> m_MaxB = lRMax ? s_ShortLimit[ aSFreq ][ lRMax ]
                         : s_LongLimit [ aSFreq ][  lMax[ 3 ] + 1  ];
 } else {

  int*   lpPreTab = apGI -> m_fPre ? s_PreTab1 : s_PreTab2;
  int    i, lMax  = -1;
  int    lMC, lCB = 0;
  short* lpM = s_pMap[ aSFreq ][ 2 ];
  float  lV = 0.0F, lPow;

  lMC = 0;

  for ( i = 0; i < 3; ++i ) {

   int    lLP = lL[ i ];
   _Huff* lpH = s_HuffTbl + apGI -> m_TabSelect[ i ];
   short* lpVal;

   for (  ; lLP; --lLP, --lMC ) {

    int   lX, lY;
    float lVal;

    if ( !lMC ) {
     lMC  = lpM[ 0 ];
     lCB  = lpM[ 1 ];
     lpM += 2;
     if ( lCB == 21 )
      lV = 0.0F;
     else lV = apGI -> m_pPow2Gain[ (  ( *apSCF++ ) + ( *lpPreTab++ )  ) << lShift ];
    }  /* end if */

    lpVal = lpH -> m_pTable;

    REFRESH_MASK();

    while (  ( lY = *lpVal++ ) < 0  ) {
     if ( lMask < 0 ) lpVal -= lY;
     --lNum;
     lMask <<= 1;
    }  /* end while */

    lX  = lY >> 4;
    lY &= 0xF;

    if ( lX == 15 && lpH -> m_LinBits ) {

     lMax = lCB;

     REFRESH_MASK();

     lX     += (  ( unsigned int )lMask  ) >> ( 32 - lpH -> m_LinBits );
     lNum   -= lpH -> m_LinBits + 1;
     lMask <<= lpH -> m_LinBits;
     lPow    = lMask < 0 ? -(  ( float* )s_ISPow  )[ lX ] : (  ( float* )s_ISPow  )[ lX ];
     lMask <<= 1;
     lVal    = lPow * lV;

    } else if ( lX ) {

     lMax    = lCB;
     lPow    = lMask < 0 ? -(  ( float* )s_ISPow  )[ lX ] : (  ( float* )s_ISPow  )[ lX ];
     lMask <<= 1;
     --lNum;
     lVal    = lPow * lV;

    } else lVal = 0.0F;

    *lpXRPnt++ = lVal;

    if ( lY == 15 && lpH -> m_LinBits ) {

     lMax = lCB;

     REFRESH_MASK();

     lY     += (  ( unsigned int )lMask  ) >> ( 32 - lpH -> m_LinBits );
     lNum   -= lpH -> m_LinBits + 1;
     lMask <<= lpH -> m_LinBits;
     lPow    = lMask < 0 ? -(  ( float* )s_ISPow  )[ lY ] : (  ( float* )s_ISPow  )[ lY ];
     lMask <<= 1;
     lVal    = lPow * lV;

    } else if ( lY ) {

     lMax    = lCB;
     lPow    = lMask < 0 ? -(  ( float* )s_ISPow  )[ lY ] : (  ( float* )s_ISPow  )[ lY ];
     lMask <<= 1;
     --lNum;
     lVal    = lPow * lV;

    } else lVal = 0.0F;

    *lpXRPnt++ = lVal;

   }  /* end if */

  }  /* end for */

  for (  ; lL3 && ( lPart2Remain + lNum > 0 ); --lL3  ) {

   _Huff* lpH   = s_HuffTblC + apGI -> m_Count1TblSel;
   short* lpVal = lpH -> m_pTable, lA;

   REFRESH_MASK();

   while (  ( lA = *lpVal++ ) < 0  ) {
    if ( lMask < 0 ) lpVal -= lA;
    --lNum;
    lMask <<= 1;
   }  /* end while */
 
   if( lPart2Remain + lNum <= 0 ) {
    lNum -= lPart2Remain + lNum;
    break;
   }  /* end if */

   for ( i = 0; i < 4; ++i ) {

    float lVal;

    if (  !( i & 1 )  ) {

     if ( !lMC ) {

      lMC  = lpM[ 0 ];
      lCB  = lpM[ 1 ];
      lpM += 2;

      if ( lCB == 21 )
       lV = 0.0F;
      else lV = apGI -> m_pPow2Gain[  ( ( *apSCF++ ) + ( *lpPreTab++ )  ) << lShift ];

     }  /* end if */

     --lMC;

    }  /* end if */

    if (   (  lA & ( 0x8 >> i )  )   ) {

     lMax = lCB;
     lVal = lV;

     if ( lPart2Remain + lNum <= 0 ) break;

     if ( lMask < 0 ) lVal = -lVal;

     lMask <<= 1;
     --lNum;

    } else lVal = 0.0F;

    *lpXRPnt++ = lVal;

   }  /* end for */
 
  }  /* end for */

  apGI -> m_MaxBandL = lMax + 1;
  apGI -> m_MaxB     = s_LongLimit[ aSFreq ][ apGI -> m_MaxBandL ];

 }  /* end else */

 lPart2Remain      += lNum;
 lpBitCtx -> m_Idx  = lBitIdx - lNum;
 lNum               = 0;

 while ( lpXRPnt < &aXR[ 32 ][ 0 ] ) *lpXRPnt++ = 0.0F;

 while ( lPart2Remain > 16 ) {
  lpBitCtx -> m_Idx += 16;;
  lPart2Remain -= 16;
 }  /* end while */

 if ( lPart2Remain > 0 )
  lpBitCtx -> m_Idx += lPart2Remain;
 else if ( lPart2Remain < 0 ) return 0;

 return 1;

}  /* end _mp3_dequantize_sample */

static void _mp3_i_stereo (
             float aXRBuf[ 2 ][ 32 ][ 18 ],
             int* apScalFac,
             SMS_MP3GranInfo* apGI,
             int aSFreq,
             int aMStereo,
             int aLSF
            ) {

 static const float* sl_pTabs[ 3 ][ 2 ][ 2 ] = { 
  { { ( float* )s_Tan1_1, ( float* )s_Tan2_1 },
    { ( float* )s_Tan1_2, ( float* )s_Tan2_2 }
  },
  { { ( float* )s_Pow1_1[ 0 ], ( float* )s_Pow2_1[ 0 ] },
    { ( float* )s_Pow1_2[ 0 ], ( float* )s_Pow2_2[ 0 ] }
  },
  { { ( float* )s_Pow1_1[ 1 ], ( float* )s_Pow2_1[ 1 ] },
    { ( float* )s_Pow1_2[ 1 ], ( float* )s_Pow2_2[ 1 ] }
  }
 };

 float ( *lpXR )[ 576 ] = (  float ( * )[ 576 ] )aXRBuf;
 _BandInfo* lpBI        = &s_BandInfo[ aSFreq ];

 const float* lpTab1, *lpTab2;
 int          lTab;

 lTab   = aLSF + ( apGI ->m_ScaleFaCompress & aLSF );
 lpTab1 = sl_pTabs[ lTab ][ aMStereo ][ 0 ];
 lpTab2 = sl_pTabs[ lTab ][ aMStereo ][ 1 ];

 if ( apGI -> m_BlockType == 2 ) {

  int lWin, lDoL = 0;

  if ( apGI -> m_fMixedBlock ) lDoL = 1;

  for ( lWin = 0; lWin < 3; ++lWin ) {

   int lIsP, lSB, lIdx, lSFB = apGI ->m_MaxBand[ lWin ];

   if ( lSFB > 3 ) lDoL = 0;

   for ( ; lSFB < 12; ++lSFB ) {

    lIsP = apScalFac[ lSFB * 3 + lWin - apGI -> m_fMixedBlock ];

    if ( lIsP != 7 ) {

     float lT1, lT2;

     lSB  = lpBI -> m_ShortDiff[ lSFB ];
     lIdx = lpBI -> m_ShortIdx [ lSFB ] + lWin;
     lT1  = lpTab1[ lIsP ];
     lT2  = lpTab2[ lIsP ];

     for ( ; lSB > 0; --lSB, lIdx += 3 ) {

      float lV = lpXR[ 0 ][ lIdx ];

      lpXR[ 0 ][ lIdx ] = lV * lT1;
      lpXR[ 1 ][ lIdx ] = lV * lT2;

     }  /* end for */

    }  /* end if */

   }  /* end for */

   lIsP = apScalFac[ 33 + lWin - apGI -> m_fMixedBlock ];
   lSB  = lpBI -> m_ShortDiff[ 12 ];
   lIdx = lpBI -> m_ShortIdx [ 12 ] + lWin;

   if ( lIsP != 7 ) {

    float lT1, lT2;

    lT1 = lpTab1[ lIsP ];
    lT2 = lpTab2[ lIsP ];

    for ( ; lSB > 0; --lSB, lIdx += 3 ) {  

     float lV = lpXR[ 0 ][ lIdx ];

     lpXR[ 0 ][ lIdx ] = lV * lT1;
     lpXR[ 1 ][ lIdx ] = lV * lT2;

    }  /* end for */

   }  /* end if */

  }  /* end for */

  if ( lDoL ) {

   int lSFB = apGI -> m_MaxBandL;
   int lIdx = lpBI -> m_LongIdx[ lSFB ];

   for ( ; lSFB < 8; ++lSFB ) {

    int lSB  = lpBI -> m_LongDiff[ lSFB ];
    int lIsP = apScalFac [ lSFB ];

    if ( lIsP != 7 ) {

     float lT1, lT2;

     lT1 = lpTab1[ lIsP ];
     lT2 = lpTab2[ lIsP ];

     for ( ; lSB > 0; --lSB, ++lIdx ) {

      float lV = lpXR[ 0 ][ lIdx ];

      lpXR[ 0 ][ lIdx ] = lV * lT1;
      lpXR[ 1 ][ lIdx ] = lV * lT2;

     }  /* end for */

    } else lIdx += lSB;

   }  /* end for */

  }  /* end if */

 } else {

  int lSFB = apGI -> m_MaxBandL;
  int lIsP, lIdx;

  if ( lSFB > 21 ) return;

  lIdx = lpBI -> m_LongIdx[ lSFB ];

  for ( ; lSFB < 21; ++lSFB ) {

   int lSB = lpBI -> m_LongDiff[ lSFB ];

   lIsP = apScalFac[ lSFB ];

   if ( lIsP != 7 ) {

    float lT1, lT2;

    lT1 = lpTab1[ lIsP ];
    lT2 = lpTab2[ lIsP ];

    for ( ; lSB > 0; --lSB, ++lIdx ) {

     float lV = lpXR[ 0 ][ lIdx ];

     lpXR[ 0 ][ lIdx ] = lV * lT1;
     lpXR[ 1 ][ lIdx ] = lV * lT2;

    }  /* end for */

   } else lIdx += lSB;

  }  /* end for */

  lIsP = apScalFac[ 20 ];

  if ( lIsP != 7 ) {

   int   lSB;
   float lT1 = lpTab1[ lIsP ];
   float lT2 = lpTab2[ lIsP ]; 

   for ( lSB = lpBI -> m_LongDiff[ 21 ]; lSB > 0; --lSB, ++lIdx ) {

    float lV = lpXR[ 0 ][ lIdx ];

    lpXR[ 0 ][ lIdx ] = lV * lT1;
    lpXR[ 1 ][ lIdx ] = lV * lT2;

   }  /* end for */

  }  /* end if */

 }  /* end else */

}  /* end _mp3_i_stereo */

static void _mp3_antialias ( float aXR[ 32 ][ 18 ], SMS_MP3GranInfo* apGI ) {

 int    lSBLim;
 int    lSB;
 float* lpXR1;

 if ( apGI ->m_BlockType == 2 ) {

  if ( !apGI -> m_fMixedBlock )  return;

  lSBLim = 1; 

 } else lSBLim = apGI -> m_MaxB - 1;

 lpXR1 = ( float* )aXR[ 1 ];

 for ( lSB = lSBLim; lSB; --lSB, lpXR1 += 10 ) {

  int    lSS;
  float* lpCS  = ( float* )s_AACS;
  float* lpCA  = ( float* )s_AACA;
  float* lpXR2 = lpXR1;

  for ( lSS = 7; lSS >= 0; --lSS ) {

   float lBU = *--lpXR2;
   float lBD = *  lpXR1;

   *lpXR2   = lBU * *lpCS   - lBD * *lpCA;
   *lpXR1++ = lBD * *lpCS++ + lBU * *lpCA++;

  }  /* end for */

 }  /* end for */

}  /* end _mp3_antialias */

static void _mp3_hybrid (
             float aFSIn[ 32 ][ 18 ], float aTSOut[ 18 ][ 32 ],
             int aCh, SMS_MP3GranInfo* apGI
            ) {

 float* lpTSPnt = ( float* )aTSOut;
 float* lpRawOut1, *lpRawOut2;
 int    lBT, lSB = 0;
 int    lB = s_HyBlc[ aCh ];

 lpRawOut1      = s_HyBlock[ lB ][ aCh ];
 lB             = -lB + 1;
 lpRawOut2      = s_HyBlock[ lB ][ aCh ];
 s_HyBlc[ aCh ] = lB;
   
 if ( apGI -> m_fMixedBlock ) {

  lSB = 2;
  MP123_IMDCT36 ( aFSIn[ 0 ], lpRawOut1,      lpRawOut2,      ( float* )s_Win [ 0 ], lpTSPnt     );
  MP123_IMDCT36 ( aFSIn[ 1 ], lpRawOut1 + 18, lpRawOut2 + 18, ( float* )s_Win1[ 0 ], lpTSPnt + 1 );

  lpRawOut1 += 36;
  lpRawOut2 += 36;
  lpTSPnt   += 2;

 }  /* end if */
 
 lBT = apGI -> m_BlockType;

 if ( lBT == 2 )

  for (  ; lSB < ( int )apGI -> m_MaxB;
           lSB += 2, lpTSPnt += 2, lpRawOut1 += 36, lpRawOut2 += 36
  ) {

   MP123_IMDCT12 ( aFSIn[ lSB     ], lpRawOut1,      lpRawOut2,      ( float* )s_Win [ 2 ], lpTSPnt     );
   MP123_IMDCT12 ( aFSIn[ lSB + 1 ], lpRawOut1 + 18, lpRawOut2 + 18, ( float* )s_Win1[ 2 ], lpTSPnt + 1 );

  }  /* end for */

 else for (  ; lSB < ( int )apGI -> m_MaxB;
               lSB += 2, lpTSPnt += 2, lpRawOut1 += 36, lpRawOut2 += 36
      ) {

  MP123_IMDCT36 ( aFSIn[ lSB     ], lpRawOut1,      lpRawOut2,      ( float* )s_Win [ lBT ], lpTSPnt     );
  MP123_IMDCT36 ( aFSIn[ lSB + 1 ], lpRawOut1 + 18, lpRawOut2 + 18, ( float* )s_Win1[ lBT ], lpTSPnt + 1 );

 }  /* end for */

 for ( ; lSB < 32; ++lSB, ++lpTSPnt ) {

  int i;

  for ( i = 0; i < 18; ++i ) {

   lpTSPnt[ i * 32 ] = *lpRawOut1++;
   *lpRawOut2++      = 0.0F;

  }  /* end for */

 }  /* end for */

}  /* end _mp3_hybrid */

static void _mp3_decode_frame ( SMS_RingBuffer* apRB ) {

 static int ( *_mp3_get_scale_factors[ 2 ] ) ( int*, SMS_MP3GranInfo*, int ) = {
  _mp3_get_scale_factors_1,
  _mp3_get_scale_factors_2
 };

 int             lScaleFacs[ 2 ][ 39 ];
 SMS_MP3SideInfo lSI;
 int             lMStereo;
 int             lIStereo;
 int             lnGran;
 int             lGr;
 int             lSFreqIdx = g_MPACtx.m_Info.m_SampleRateIdx;
 int             lnAlloc;
 int             lSS;
 short*          lpSamples;

 if ( g_MPACtx.m_Info.m_Mode == SMS_MPA_JSTEREO ) {
  lMStereo = ( g_MPACtx.m_Info.m_ModeExt & 0x2 ) >> 1;
  lIStereo =   g_MPACtx.m_Info.m_ModeExt & 0x1;
 } else lMStereo = lIStereo = 0;

 lnGran    = g_MPACtx.m_Info.m_LSF ? 1 : 2;
 lnAlloc   = lnGran * g_MPACtx.m_Info.m_nChannels * 1152;
 lpSamples = ( short* )SMS_RingBufferAlloc ( apRB, lnAlloc + 80 );

 lpSamples += 32;
 *( int* )lpSamples = lnAlloc;
 lpSamples += 8;

 if (  !_mp3_get_side_info (
         &lSI, g_MPACtx.m_Info.m_nChannels, lMStereo,
         g_MPACtx.m_Info.m_SampleRateIdx, g_MPACtx.m_Info.m_LSF
        )
 ) {
error:
  memset (   (  ( unsigned char* )apRB -> m_pPtr  ) + 68, 0, lnAlloc  );
  return;

 }  /* end if */

 _seek_to_main_data ( lSI.m_MainDataBegin );

 for ( lGr = 0; lGr < lnGran; ++lGr ) {

  SMS_ALIGN(  float sl_HybridIn [ 2 ][ 32 ][ 18 ], 16  );
  SMS_ALIGN(  float sl_HybridOut[ 2 ][ 18 ][ 32 ], 16  );

  SMS_MP3GranInfo* lpGI       = &lSI.m_Ch[ 0 ].m_GI[ lGr ];
  int              lPart2Bits = _mp3_get_scale_factors[ g_MPACtx.m_Info.m_LSF ] ( lScaleFacs[ 0 ], lpGI, 0 );

  if (  !_mp3_dequantize_sample (
          sl_HybridIn[ 0 ], lScaleFacs[ 0 ], lpGI, lSFreqIdx, lPart2Bits
         )
  ) goto error;

  if ( g_MPACtx.m_Info.m_nChannels == 2 ) {

   lpGI       = &lSI.m_Ch[ 1 ].m_GI[ lGr ];
   lPart2Bits = _mp3_get_scale_factors[ g_MPACtx.m_Info.m_LSF ] ( lScaleFacs[ 1 ], lpGI, lIStereo );

   if (  !_mp3_dequantize_sample (
           sl_HybridIn[ 1 ], lScaleFacs[ 1 ], lpGI, lSFreqIdx, lPart2Bits
          )
   ) goto error;

   if ( lMStereo ) {

    unsigned int i, lMaxB = lSI.m_Ch[ 0 ].m_GI[ lGr ].m_MaxB;

    if ( lSI.m_Ch[ 1 ].m_GI[ lGr].m_MaxB > lMaxB ) lMaxB = lSI.m_Ch[ 1 ].m_GI[ lGr ].m_MaxB;

    lMaxB *= 18;

    for ( i = 0; i < lMaxB; ++i ) {

     float lTmp0 = (  ( float* )sl_HybridIn[ 0 ]  )[ i ];
     float lTmp1 = (  ( float* )sl_HybridIn[ 1 ]  )[ i ];

     (  ( float* )sl_HybridIn[ 0 ]  )[ i ] = lTmp0 + lTmp1;
     (  ( float* )sl_HybridIn[ 1 ]  )[ i ] = lTmp0 - lTmp1;

    }  /* end for */

   }  /* end if */

   if ( lIStereo ) _mp3_i_stereo (
                    sl_HybridIn, lScaleFacs[ 1 ],
                    lpGI, lSFreqIdx, lMStereo, g_MPACtx.m_Info.m_LSF
                   );

   if ( lMStereo || lIStereo ) {

    if ( lpGI -> m_MaxB > lSI.m_Ch[ 0 ].m_GI[ lGr ].m_MaxB ) 
     lSI.m_Ch[ 0 ].m_GI[ lGr ].m_MaxB = lpGI -> m_MaxB;
    else lpGI -> m_MaxB = lSI.m_Ch[ 0 ].m_GI[ lGr ].m_MaxB;

   }  /* end if */

  }  /* end if */

  lpGI = &lSI.m_Ch[ 0 ].m_GI[ lGr ];

  _mp3_antialias ( sl_HybridIn[ 0 ], lpGI );
  _mp3_hybrid    ( sl_HybridIn[ 0 ], sl_HybridOut[ 0 ], 0, lpGI );

  if ( g_MPACtx.m_Info.m_nChannels > 1 ) {

   lpGI = &lSI.m_Ch[ 1 ].m_GI[ lGr ];

   _mp3_antialias ( sl_HybridIn[ 1 ], lpGI );
   _mp3_hybrid    ( sl_HybridIn[ 1 ], sl_HybridOut[ 1 ], 1, lpGI );

   for ( lSS = 0; lSS < 18; ++lSS ) {

                 MP123_Synth (  sl_HybridOut[ 0 ][ lSS ], 0, ( void* )lpSamples, 2  );
    lpSamples += MP123_Synth (  sl_HybridOut[ 1 ][ lSS ], 1, ( void* )lpSamples, 2  );

   }  /* end for */

  } else for ( lSS = 0; lSS < 18; ++lSS )

   lpSamples += MP123_Synth (  sl_HybridOut[ 0 ][ lSS ], 0, ( void* )lpSamples, 1  );

 }  /* end for */

}  /* end _mp3_decode_frame */

int32_t MP123_Decode ( SMS_CodecContext* apCtx, SMS_RingBuffer* apOutput, SMS_RingBuffer* apInput ) {

 static void ( *mpa_decode_frame[ 4 ] ) ( SMS_RingBuffer* ) = {
  _mp1_decode_frame,
  _mp2_decode_frame,
  _mp3_decode_frame,
  _mp3_decode_frame
 };

 SMS_AVPacket* lpPck = ( SMS_AVPacket* )apInput -> m_pOut;
 uint8_t*      lpBuf;
 uint32_t      lHdr;
 int           lLen;
 int           lBufSize;
 int           lnFrames = 0;

 if ( g_MPACtx.m_Len ) {

  lpBuf    = g_MPACtx.m_pPos;
  lBufSize = g_MPACtx.m_Len;

 } else {

  g_MPACtx.m_pPos = lpBuf    = lpPck -> m_pData;
  g_MPACtx.m_Len  = lBufSize = lpPck -> m_Size;

 }  /* end else */

 while ( lBufSize > 0 ) {

  lLen = g_MPACtx.m_pInBufPtr - g_MPACtx.m_pInBuf;

  if ( g_MPACtx.m_Info.m_FrameSize == 0 ) {

   if ( g_MPACtx.m_FreeFmtNextHdr ) {

    g_MPACtx.m_pInBuf[ 0 ] = g_MPACtx.m_FreeFmtNextHdr >> 24;
    g_MPACtx.m_pInBuf[ 1 ] = g_MPACtx.m_FreeFmtNextHdr >> 16;
    g_MPACtx.m_pInBuf[ 2 ] = g_MPACtx.m_FreeFmtNextHdr >>  8;
    g_MPACtx.m_pInBuf[ 3 ] = g_MPACtx.m_FreeFmtNextHdr;

    g_MPACtx.m_pInBufPtr      = g_MPACtx.m_pInBuf + 4;
    g_MPACtx.m_FreeFmtNextHdr = 0;

    goto gotHeader;

   }  /* end if */

   lLen = SMS_HEADER_SIZE - lLen;

   if ( lLen > lBufSize ) lLen = lBufSize;

   if ( lLen > 0 ) {

    memcpy ( g_MPACtx.m_pInBufPtr, lpBuf, lLen );

    lpBuf    += lLen;
    lBufSize -= lLen;

    g_MPACtx.m_pInBufPtr += lLen;

   }  /* end if */

   if (  ( g_MPACtx.m_pInBufPtr - g_MPACtx.m_pInBuf ) >= SMS_HEADER_SIZE  ) {
gotHeader:
    lHdr = ( g_MPACtx.m_pInBuf[ 0 ] << 24 ) |
           ( g_MPACtx.m_pInBuf[ 1 ] << 16 ) |
           ( g_MPACtx.m_pInBuf[ 2 ] <<  8 ) |
           ( g_MPACtx.m_pInBuf[ 3 ] <<  0 );

    if (  !MP123_CheckHeader ( lHdr )  ) {

     memmove ( g_MPACtx.m_pInBuf, g_MPACtx.m_pInBuf + 1, g_MPACtx.m_pInBufPtr - g_MPACtx.m_pInBuf - 1 );
     --g_MPACtx.m_pInBufPtr;
     g_MPACtx.m_Info.m_FreeFmtFrameSize = 0;

    } else {

     if (  MP123_DecodeHeader ( lHdr, &g_MPACtx.m_Info ) == 1  ) g_MPACtx.m_Info.m_FrameSize = -1;

     apCtx -> m_SampleRate = g_MPACtx.m_Info.m_SampleRate;
     apCtx -> m_Channels   = g_MPACtx.m_Info.m_nChannels;
     apCtx -> m_BitRate    = g_MPACtx.m_Info.m_BitRate;

     switch ( g_MPACtx.m_Info.m_Layer ) {

      case 0:
       apCtx -> m_FrameSize = 384;
      break;

      case 1:
       apCtx -> m_FrameSize = 1152;
      break;

      case 2:
       apCtx -> m_FrameSize = g_MPACtx.m_Info.m_LSF ? 576 : 1152;
      break;

     }  /* end switch */

    }  /* end else */

   }  /* end if */

  } else if ( g_MPACtx.m_Info.m_FrameSize == -1 ) {

   lLen = SMS_MPA_MAX_CODED_FRAME_SIZE - lLen;

   if ( lLen > lBufSize ) lLen = lBufSize;

   if ( lLen == 0 ) {

    g_MPACtx.m_Info.m_FrameSize = 0;
    memmove ( g_MPACtx.m_pInBuf, g_MPACtx.m_pInBuf + 1, g_MPACtx.m_pInBufPtr - g_MPACtx.m_pInBuf - 1 );
    --g_MPACtx.m_pInBufPtr;

   } else {

    uint8_t* lPtr, *lPtrEnd;
    uint32_t lHdr1;
    int      lPadding;

    memcpy ( g_MPACtx.m_pInBufPtr, lpBuf, lLen );

    lPtr    = g_MPACtx.m_pInBufPtr - 3;
    lPtrEnd = g_MPACtx.m_pInBufPtr + lLen - 4;

    while ( lPtr <= lPtrEnd ) {

     lHdr  = ( lPtr[ 0 ] << 24 ) |
             ( lPtr[ 1 ] << 16 ) |
             ( lPtr[ 2 ] <<  8 ) |
             ( lPtr[ 3 ] <<  0 );
     lHdr1 = ( g_MPACtx.m_pInBuf[ 0 ] << 24 ) |
             ( g_MPACtx.m_pInBuf[ 1 ] << 16 ) |
             ( g_MPACtx.m_pInBuf[ 2 ] <<  8 ) |
             ( g_MPACtx.m_pInBuf[ 3 ] <<  0 );

     if (   ( lHdr & SMS_SAME_HEADER_MASK ) == ( lHdr1 & SMS_SAME_HEADER_MASK )  ) {

      lLen      = ( lPtr + 4 ) - g_MPACtx.m_pInBufPtr;
      lpBuf    += lLen;
      lBufSize -= lLen;

      g_MPACtx.m_pInBufPtr               = lPtr;
      g_MPACtx.m_FreeFmtNextHdr          = lHdr;
      g_MPACtx.m_Info.m_FreeFmtFrameSize = g_MPACtx.m_pInBufPtr - g_MPACtx.m_pInBuf;

      lPadding = ( lHdr1 >> 9 ) & 1;

      if ( !g_MPACtx.m_Info.m_Layer )
       g_MPACtx.m_Info.m_FreeFmtFrameSize -= lPadding * 4;
      else g_MPACtx.m_Info.m_FreeFmtFrameSize -= lPadding;

      MP123_DecodeHeader ( lHdr1, &g_MPACtx.m_Info );

      goto nextData;

     }  /* end if */

     ++lPtr;

    }  /* end while */

    lpBuf                += lLen;
    g_MPACtx.m_pInBufPtr += lLen;
    lBufSize             -= lLen;

   }  /* end else */

  } else if ( lLen < g_MPACtx.m_Info.m_FrameSize ) {

   if ( g_MPACtx.m_Info.m_FrameSize > SMS_MPA_MAX_CODED_FRAME_SIZE ) g_MPACtx.m_Info.m_FrameSize = SMS_MPA_MAX_CODED_FRAME_SIZE;

   lLen = g_MPACtx.m_Info.m_FrameSize - lLen;

   if ( lLen > lBufSize ) lLen = lBufSize;

   memcpy ( g_MPACtx.m_pInBufPtr, lpBuf, lLen );

   lpBuf                += lLen;
   g_MPACtx.m_pInBufPtr += lLen;
   lBufSize             -= lLen;

  }  // end if
nextData:
  if (  g_MPACtx.m_Info.m_FrameSize > 0 && ( g_MPACtx.m_pInBufPtr - g_MPACtx.m_pInBuf ) >= g_MPACtx.m_Info.m_FrameSize  ) {

   SMS_InitGetBits (
    &g_MPACtx.m_BitCtx, g_MPACtx.m_pInBuf + SMS_HEADER_SIZE, 
    ( g_MPACtx.m_pInBufPtr - g_MPACtx.m_pInBuf - SMS_HEADER_SIZE ) * 8
   );

   if ( g_MPACtx.m_Info.m_ErrorProtection ) SMS_GetBits ( &g_MPACtx.m_BitCtx, 16 );

   mpa_decode_frame[ g_MPACtx.m_Info.m_Layer ] ( apOutput );
   apOutput -> UserCB ( apOutput );

   if (  !( ++lnFrames & 1 )  ) RotateThreadReadyQueue ( SMS_THREAD_PRIORITY );

   g_MPACtx.m_pInBufPtr        = g_MPACtx.m_pInBuf;
   g_MPACtx.m_Info.m_FrameSize = 0;

   break;

  }  /* end if */

 }  /* end while */

 lLen = lpBuf - g_MPACtx.m_pPos;

 g_MPACtx.m_Len  -= lLen;
 g_MPACtx.m_pPos += lLen;

 return g_MPACtx.m_Len;

}  /* end MP123_Decode */

