/*
#     ___  _ _      ___
#    |    | | |    |
# ___|    |   | ___|    PS2DEV Open Source Project.
#----------------------------------------------------------
# (c) 2006 Eugene Plotnikov <e-plotnikov@operamail.com>
# (c) 2003 Marcus R. Brown <mrbrown@0xd6.org>
# (c) 2007 lior e (SMS_ReverseString)
# Licenced under Academic Free License version 2.0
# Review ps2sdk README & LICENSE files for further details.
#
*/
#include "SMS.h"
#include "SMS_EE.h"
#include "SMS_IOP.h"
#include "SMS_DMA.h"
#include "SMS_Locale.h"
#include "SMS_GUI.h"
#include "SMS_Data.h"
#include "SMS_Config.h"
#include "SMS_PAD.h"
#include "SMS_RC.h"
#include "SMS_GS.h"
#include "SMS_VIF.h"
#include "SMS_List.h"
#include "SMS_DMA.h"

#include <lzma2.h>

#include <loadfile.h>

#include <kernel.h>
#include <malloc.h>
#include <limits.h>
#include <string.h>
#include <fileio.h>

unsigned char* g_pSPRTop;
void*          g_pSynthBuffer;
int            g_MCSlot;
int            g_RandSeed = 1;

static char s_pROMVER[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "rom0:ROMVER";

void* SMS_Realloc ( void* apData, unsigned int* apSize, unsigned int aMinSize ) {

 if ( aMinSize < *apSize ) return apData;

 *apSize = 17 * aMinSize / 16 + 32;

 return realloc ( apData, *apSize );

}  /* SMS_Realloc */

extern long MUL64 ( long, long );

long SMS_Rescale ( long anA, long aB, long aC ){

 int           i;
 unsigned long lA0, lA1, lB0, lB1, lT1, lT1a;
 long          lR;

 if ( anA < 0 ) return -SMS_Rescale ( -anA, aB, aC );

 lR = aC >> 1;

 if ( aB <= INT_MAX && aC <= INT_MAX ) {
  if ( anA <= INT_MAX )
   return ( anA * aB + lR ) / aC;
  else return anA / aC * aB + ( anA % aC * aB + lR ) / aC;
 }  /* end if */

 lA0  = anA & 0xFFFFFFFF;
 lA1  = anA >> 32;
 lB0  = aB  & 0xFFFFFFFF;
 lB1  = aB  >> 32;
 lT1  = MUL64 ( lA0, lB1 ) + MUL64 ( lA1, lB0 );
 lT1a = lT1 << 32;
 lA0  = MUL64 ( lA0, lB0 ) + lT1a;
 lA1  = MUL64 ( lA1, lB1 ) + ( lT1 >> 32 ) + ( lA0 < lT1a );
 lA0 += lR;
 lA1 += lA0 < lR;

 for ( i = 63; i >= 0; --i ) {

  lA1 += lA1 + (  ( lA0 >> i ) & 1  );
  lT1 += lT1;

  if ( aC <= lA1 ){
   lA1 -= aC;
   ++lT1;
  }  /* end if */

 }  /* end for */

 return lT1;

}  /* end SMS_Rescale */

static char UTIL_getReversedChar ( char aChr ) {

 switch ( aChr )  {
  case '(': return ')';
  case ')': return '(';
  case '[': return ']';
  case ']': return '[';
  case '{': return '}';
  case '}': return '{';
  case '<': return '>';
  case '>': return '<';
 }  /* end switch */

 return aChr;

}  /* end UTIL_getReversedChar */

char* SMS_ReverseString ( char* apStr, int aLen ) {

 unsigned char lRev[ aLen ];
 unsigned char lEON[ aLen ];
 int           lSrcIdx;
 int           lEONIdx = 0;
 int           lRevIdx = 0;

 for ( lSrcIdx = aLen - 1; lSrcIdx >= 0; --lSrcIdx ) {

  char lChr = apStr[ lSrcIdx ];

  if (  isalnum ( lChr )  )

   lEON[ lEONIdx++ ] = lChr;

  else {

   if ( lEONIdx > 0 ) {

    for ( lEONIdx = lEONIdx - 1; lEONIdx >= 0; --lEONIdx ) lRev[ lRevIdx++ ] = lEON[ lEONIdx ];

    lEONIdx = 0;

   }  /* end if */

   lRev[ lRevIdx++ ] = UTIL_getReversedChar ( lChr );

  }  /* end else */

 }  /* end for */

 if ( lEONIdx > 0 ) for ( lEONIdx = lEONIdx - 1; lEONIdx >= 0; --lEONIdx ) lRev[ lRevIdx++ ] = lEON[ lEONIdx ];

 for ( lRevIdx = 0; lRevIdx < aLen; ++lRevIdx ) apStr[ lRevIdx ] = lRev[ lRevIdx ];

 return apStr;

}  /* end SMS_ReverseString */

void SMS_EEInit ( void ) {

 unsigned char      lROMVer[ 16 ];
 volatile DMACRegs* lpDMAC = DMAC;
 int                lFD;

 lpDMAC -> m_CTRL = DMA_SET_CTRL( 1, D_CTRL_RELE_OFF, D_CTRL_MFD_OFF, D_CTRL_STS_UNSPEC, D_CTRL_STD_OFF, D_CTRL_RCYC_8 );
 lpDMAC -> m_STAT = 0;
 lpDMAC -> m_PCR  = 0;
 lpDMAC -> m_SQWC = 0;
 lpDMAC -> m_RBSR = 0;
 lpDMAC -> m_RBOR = 0;

 VIF1_ERR() |= 2;

 ChangeThreadPriority (  GetThreadId (), SMS_THREAD_PRIORITY  );

 lFD = fioOpen ( s_pROMVER, O_RDONLY );
 fioRead (  lFD, lROMVer, sizeof ( lROMVer )  );
 fioClose ( lFD );

 g_pBXDATASYS[ 6 ] = lROMVer[ 4 ] == 'E' ? 'E' : ( lROMVer[ 4 ] == 'J' ? 'I' : 'A');

 __asm__ __volatile__(
  ".set noreorder\n\t"
  ".set nomacro\n\t"
  ".set noat\n\t"
  "lui      $at, 0x1000\n\t"
  "ori      $at, 0xC000\n\t"
  "mtc0     $at, $10\n\t"
  "sync.p\n\t"
  "tlbp\n\t"
  "mfc0     $v0, $0\n\t"
  "bltz     $v0, 1f\n\t"
  "nop\n\t"
  "mfc0     $at, $6\n\t"
  "slt      $v0, $v0, $at\n\t"
  "beqzl    $v0, 1f\n\t"
  "lui      $v0, 0x8000\n\t"
  "tlbr\n\t"
  "sync.p\n\t"
  "mfc0     $at, $2\n\t"
  "ori      $at, $at, 4\n\t"
  "mtc0     $at, $2\n\t"
  "sync.p\n\t"
  "tlbwi\n\t"
  "sync.p\n\t"
  "1:\n\t"
  ".set at\n\t"
  ".set macro\n\t"
  ".set reorder\n\t"
 );

 SMS_EETlbInit ();

}  /* end SMS_EEInit */
#ifndef EMBEDDED
unsigned char s_Loader[] __attribute__(   (  aligned( 16 ), section( ".data" )  )   ) = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x3c, 0x00, 0x17, 0x42, 0x24, 
	0x00, 0x01, 0x03, 0x3c, 0xe8, 0x33, 0x63, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7c, 0x2b, 0x08, 0x43, 0x00, 0xfa, 0xff, 0x20, 0x14, 
	0x10, 0x00, 0x42, 0x24, 0x00, 0x01, 0x02, 0x3c, 0x44, 0x18, 0x42, 0x24, 0x00, 0x00, 0x44, 0xac, 
	0x01, 0x01, 0x04, 0x3c, 0xf0, 0x96, 0x84, 0x24, 0x00, 0x00, 0x05, 0x3c, 0xff, 0xff, 0xa5, 0x24, 
	0x02, 0x00, 0x06, 0x3c, 0x00, 0x00, 0xc6, 0x24, 0x00, 0x01, 0x07, 0x3c, 0x00, 0x17, 0xe7, 0x24, 
	0x00, 0x01, 0x08, 0x3c, 0x40, 0x01, 0x08, 0x25, 0x2d, 0xe0, 0x80, 0x00, 0x3c, 0x00, 0x03, 0x24, 
	0x0c, 0x00, 0x00, 0x00, 0x2d, 0xe8, 0x40, 0x00, 0x3d, 0x00, 0x03, 0x24, 0x00, 0x01, 0x04, 0x3c, 
	0xe8, 0x33, 0x84, 0x24, 0x00, 0x00, 0x05, 0x3c, 0xff, 0xff, 0xa5, 0x24, 0x0c, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x03, 0x24, 0x2d, 0x20, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0x02, 0x3c, 0x00, 0x17, 0x42, 0x24, 0x00, 0x00, 0x43, 0x8c, 0x07, 0x00, 0x60, 0x14, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x3c, 0x44, 0x18, 0x42, 0x24, 0x00, 0x00, 0x43, 0x8c, 
	0x04, 0x00, 0x60, 0x50, 0x00, 0x00, 0x04, 0x24, 0x04, 0x00, 0x62, 0x24, 0x00, 0x00, 0x44, 0x8c, 
	0x04, 0x00, 0x45, 0x24, 0x38, 0x00, 0x00, 0x42, 0x00, 0x01, 0x02, 0x3c, 0x00, 0x17, 0x42, 0x24, 
	0x00, 0x00, 0x43, 0x8c, 0x07, 0x00, 0x60, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x3c, 
	0x44, 0x18, 0x42, 0x24, 0x00, 0x00, 0x43, 0x8c, 0x04, 0x00, 0x60, 0x50, 0x00, 0x00, 0x04, 0x24, 
	0x04, 0x00, 0x62, 0x24, 0x00, 0x00, 0x44, 0x8c, 0x04, 0x00, 0x45, 0x24, 0x52, 0x00, 0x40, 0x0c, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x3c, 0x44, 0x18, 0x84, 0x24, 0x00, 0x00, 0x85, 0x8c, 
	0x05, 0x00, 0xa0, 0x10, 0x2d, 0x20, 0x40, 0x00, 0x00, 0x00, 0xa6, 0x8c, 0x00, 0x00, 0xc0, 0xac, 
	0x24, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 
	0x23, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xbd, 0x27, 0x30, 0x00, 0xbf, 0xff, 
	0x20, 0x00, 0xb1, 0xff, 0x2d, 0x88, 0x80, 0x00, 0x10, 0x00, 0xb0, 0xff, 0x2d, 0x80, 0xa0, 0x00, 
	0x00, 0x00, 0xa4, 0x8c, 0x94, 0x01, 0x40, 0x0c, 0x2d, 0x28, 0xa0, 0x03, 0x7e, 0x01, 0x40, 0x0c, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0x8f, 0x0a, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 
	0x74, 0x00, 0x40, 0x0c, 0x2d, 0x20, 0x00, 0x00, 0x74, 0x00, 0x40, 0x0c, 0x02, 0x00, 0x04, 0x24, 
	0x04, 0x00, 0xa5, 0x8f, 0x00, 0x00, 0xa4, 0x8f, 0x2d, 0x38, 0x00, 0x02, 0x70, 0x00, 0x40, 0x0c, 
	0x2d, 0x30, 0x20, 0x02, 0x6c, 0x00, 0x40, 0x0c, 0x2d, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x04, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x07, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x64, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x00, 0x82, 0x8c, 0xfe, 0xff, 0x03, 0x24, 0x18, 0x00, 0x80, 0xac, 0x24, 0x10, 0x43, 0x00, 
	0x08, 0x00, 0xe0, 0x03, 0x10, 0x00, 0x82, 0xac, 0xe0, 0xff, 0xbd, 0x27, 0x00, 0x80, 0x02, 0x3c, 
	0x10, 0x00, 0xbf, 0xff, 0x00, 0x80, 0x05, 0x3c, 0x00, 0x00, 0xb0, 0xff, 0x0a, 0x00, 0x42, 0x34, 
	0x09, 0x00, 0xa5, 0x34, 0x20, 0x00, 0x83, 0x8c, 0x15, 0x00, 0x62, 0x10, 0x1c, 0x00, 0x90, 0x8c, 
	0x0d, 0x00, 0x65, 0x50, 0x28, 0x00, 0x82, 0x8c, 0x08, 0x00, 0x02, 0x8e, 0x03, 0x00, 0x40, 0x04, 
	0x2d, 0x20, 0x40, 0x00, 0xc0, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x40, 0x0c, 
	0x00, 0x00, 0x04, 0x8e, 0x10, 0x00, 0xbf, 0xdf, 0x00, 0x00, 0x00, 0xae, 0x00, 0x00, 0xb0, 0xdf, 
	0x08, 0x00, 0xe0, 0x03, 0x20, 0x00, 0xbd, 0x27, 0x24, 0x00, 0x83, 0x8c, 0x14, 0x00, 0x02, 0xae, 
	0x24, 0x00, 0x03, 0xae, 0x2c, 0x00, 0x82, 0x8c, 0xef, 0xff, 0x00, 0x10, 0x18, 0x00, 0x02, 0xae, 
	0x1c, 0x00, 0x02, 0x8e, 0xed, 0xff, 0x40, 0x50, 0x08, 0x00, 0x02, 0x8e, 0x09, 0xf8, 0x40, 0x00, 
	0x20, 0x00, 0x04, 0x8e, 0xe9, 0xff, 0x00, 0x10, 0x08, 0x00, 0x02, 0x8e, 0x00, 0x00, 0x00, 0x00, 
	0x28, 0x00, 0xa6, 0x8c, 0x0e, 0x00, 0xc0, 0x10, 0x2d, 0x28, 0x00, 0x00, 0x08, 0x00, 0xc3, 0x8c, 
	0x08, 0x00, 0x60, 0x50, 0x14, 0x00, 0xc6, 0x8c, 0x00, 0x00, 0x62, 0x8c, 0x08, 0x00, 0x44, 0x10, 
	0x2d, 0x28, 0x60, 0x00, 0x38, 0x00, 0x63, 0x8c, 0xfc, 0xff, 0x60, 0x54, 0x00, 0x00, 0x62, 0x8c, 
	0x14, 0x00, 0xc6, 0x8c, 0xf6, 0xff, 0xc0, 0x54, 0x08, 0x00, 0xc3, 0x8c, 0x2d, 0x28, 0x00, 0x00, 
	0x08, 0x00, 0xe0, 0x03, 0x2d, 0x10, 0xa0, 0x00, 0xc0, 0xff, 0xbd, 0x27, 0x00, 0x00, 0xb0, 0xff, 
	0x2d, 0x80, 0x80, 0x00, 0x2d, 0x20, 0xa0, 0x00, 0x20, 0x00, 0xb2, 0xff, 0x10, 0x00, 0xb1, 0xff, 
	0x30, 0x00, 0xbf, 0xff, 0x88, 0x01, 0x40, 0x0c, 0x2d, 0x88, 0xa0, 0x00, 0x2d, 0x90, 0x40, 0x00, 
	0x14, 0x00, 0x04, 0x8e, 0x00, 0x80, 0x02, 0x3c, 0x1c, 0x00, 0x03, 0x8e, 0x09, 0x00, 0x42, 0x34, 
	0x14, 0x00, 0x44, 0xae, 0x20, 0x00, 0x42, 0xae, 0x2d, 0x28, 0x20, 0x02, 0x1c, 0x00, 0x43, 0xae, 
	0xa4, 0x00, 0x40, 0x0c, 0x20, 0x00, 0x04, 0x8e, 0x15, 0x00, 0x40, 0x50, 0x24, 0x00, 0x40, 0xae, 
	0x08, 0x00, 0x43, 0x8c, 0x24, 0x00, 0x42, 0xae, 0x28, 0x00, 0x43, 0xae, 0x14, 0x00, 0x42, 0x8c, 
	0x2c, 0x00, 0x42, 0xae, 0x00, 0x80, 0x04, 0x3c, 0x2d, 0x28, 0x40, 0x02, 0x08, 0x00, 0x84, 0x34, 
	0x40, 0x00, 0x06, 0x24, 0x2d, 0x38, 0x00, 0x00, 0x2d, 0x40, 0x00, 0x00, 0x28, 0x02, 0x40, 0x0c, 
	0x2d, 0x48, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xdf, 0x30, 0x00, 0xbf, 0xdf, 0x20, 0x00, 0xb2, 0xdf, 
	0x10, 0x00, 0xb1, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x40, 0x00, 0xbd, 0x27, 0x00, 0x00, 0x00, 0x00, 
	0x28, 0x00, 0x40, 0xae, 0xef, 0xff, 0x00, 0x10, 0x2c, 0x00, 0x40, 0xae, 0x00, 0x00, 0x00, 0x00, 
	0xf0, 0xff, 0xbd, 0x27, 0x00, 0x00, 0xbf, 0xff, 0x34, 0x00, 0x86, 0x8c, 0x40, 0x00, 0xc8, 0x8c, 
	0x0c, 0x00, 0x02, 0x8d, 0x20, 0x00, 0x40, 0x10, 0x2d, 0x38, 0x80, 0x00, 0x10, 0x00, 0x02, 0x8d, 
	0x38, 0x00, 0x46, 0xac, 0x20, 0x00, 0xe2, 0x8c, 0x14, 0x00, 0xe3, 0x8c, 0x24, 0x00, 0xc2, 0xac, 
	0x20, 0x00, 0xc3, 0xac, 0x24, 0x00, 0xe2, 0x8c, 0x28, 0x00, 0xe4, 0x8c, 0x0c, 0x00, 0xc2, 0xac, 
	0x1c, 0x00, 0xe5, 0x8c, 0x2c, 0x00, 0xe3, 0x8c, 0x28, 0x00, 0xc4, 0xac, 0x2c, 0x00, 0xc3, 0xac, 
	0x10, 0x00, 0x06, 0xad, 0x30, 0x00, 0xe2, 0x8c, 0x1c, 0x00, 0xc5, 0xac, 0x30, 0x00, 0xc2, 0xac, 
	0x10, 0x00, 0xe3, 0x8c, 0x34, 0x00, 0xc3, 0xac, 0x00, 0x00, 0x04, 0x8d, 0x04, 0x00, 0x80, 0x04, 
	0x00, 0x00, 0xbf, 0xdf, 0x04, 0x00, 0x02, 0x8d, 0x03, 0x00, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00, 
	0x08, 0x00, 0xe0, 0x03, 0x10, 0x00, 0xbd, 0x27, 0xbc, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 
	0xfb, 0xff, 0x00, 0x10, 0x00, 0x00, 0xbf, 0xdf, 0xe2, 0xff, 0x00, 0x10, 0x0c, 0x00, 0x06, 0xad, 
	0xe0, 0xff, 0xbd, 0x27, 0x00, 0x00, 0xb0, 0xff, 0x2d, 0x80, 0x80, 0x00, 0x10, 0x00, 0xbf, 0xff, 
	0x88, 0x01, 0x40, 0x0c, 0x2d, 0x20, 0xa0, 0x00, 0x1c, 0x00, 0x07, 0x8e, 0x14, 0x00, 0x04, 0x8e, 
	0x00, 0x80, 0x03, 0x3c, 0x0c, 0x00, 0x63, 0x34, 0x1c, 0x00, 0x47, 0xac, 0x14, 0x00, 0x44, 0xac, 
	0x40, 0x00, 0x06, 0x24, 0x20, 0x00, 0x43, 0xac, 0x00, 0x80, 0x04, 0x3c, 0x20, 0x00, 0x07, 0x8e, 
	0x2d, 0x28, 0x40, 0x00, 0x28, 0x00, 0x09, 0x8e, 0x08, 0x00, 0x84, 0x34, 0x28, 0x02, 0x40, 0x0c, 
	0x24, 0x00, 0x08, 0x8e, 0x00, 0x00, 0xb0, 0xdf, 0x10, 0x00, 0xbf, 0xdf, 0x08, 0x00, 0xe0, 0x03, 
	0x20, 0x00, 0xbd, 0x27, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xbd, 0x27, 0x00, 0x01, 0x04, 0x3c, 
	0x20, 0x00, 0xbf, 0xff, 0x00, 0x01, 0x02, 0x3c, 0x10, 0x00, 0xb1, 0xff, 0x00, 0x00, 0xb0, 0xff, 
	0xb8, 0x16, 0x42, 0x8c, 0xb0, 0x16, 0x83, 0x8c, 0x03, 0x00, 0x62, 0x10, 0x00, 0x01, 0x03, 0x3c, 
	0xb0, 0x16, 0x82, 0xac, 0xac, 0x16, 0x60, 0xac, 0xac, 0x16, 0x62, 0x8c, 0x06, 0x00, 0x40, 0x10, 
	0x00, 0x01, 0x10, 0x3c, 0x20, 0x00, 0xbf, 0xdf, 0x10, 0x00, 0xb1, 0xdf, 0x00, 0x00, 0xb0, 0xdf, 
	0x08, 0x00, 0xe0, 0x03, 0x30, 0x00, 0xbd, 0x27, 0x01, 0x00, 0x11, 0x24, 0x80, 0x16, 0x10, 0x26, 
	0x44, 0x02, 0x40, 0x0c, 0xac, 0x16, 0x71, 0xac, 0xa0, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 
	0x2d, 0x30, 0x00, 0x02, 0x04, 0x00, 0x08, 0x8e, 0x00, 0x20, 0x02, 0x3c, 0x14, 0x00, 0x07, 0x8e, 
	0x00, 0x80, 0x04, 0x3c, 0x1c, 0x00, 0x03, 0x8e, 0x25, 0x40, 0x02, 0x01, 0x25, 0x38, 0xe2, 0x00, 
	0x04, 0x00, 0x08, 0xae, 0x25, 0x18, 0x62, 0x00, 0x14, 0x00, 0x07, 0xae, 0x1c, 0x00, 0x03, 0xae, 
	0x00, 0x01, 0x05, 0x3c, 0xf8, 0x01, 0xa5, 0x24, 0xe2, 0x02, 0x40, 0x0c, 0x08, 0x00, 0x84, 0x34, 
	0x2d, 0x30, 0x00, 0x02, 0x00, 0x80, 0x04, 0x3c, 0x00, 0x01, 0x05, 0x3c, 0x09, 0x00, 0x84, 0x34, 
	0xe2, 0x02, 0x40, 0x0c, 0xd8, 0x02, 0xa5, 0x24, 0x00, 0x01, 0x05, 0x3c, 0x00, 0x80, 0x04, 0x3c, 
	0x2d, 0x30, 0x00, 0x02, 0x0a, 0x00, 0x84, 0x34, 0xe2, 0x02, 0x40, 0x0c, 0x90, 0x03, 0xa5, 0x24, 
	0x00, 0x01, 0x05, 0x3c, 0x00, 0x80, 0x04, 0x3c, 0x2d, 0x30, 0x00, 0x02, 0x0c, 0x00, 0x84, 0x34, 
	0xe2, 0x02, 0x40, 0x0c, 0x30, 0x04, 0xa5, 0x24, 0xb4, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x80, 0x04, 0x3c, 0xc8, 0x01, 0x40, 0x0c, 0x02, 0x00, 0x84, 0x34, 0xce, 0xff, 0x40, 0x14, 
	0x20, 0x00, 0xbf, 0xdf, 0x00, 0x01, 0x02, 0x3c, 0x00, 0x80, 0x04, 0x3c, 0xc0, 0x18, 0x42, 0x24, 
	0x02, 0x00, 0x84, 0x34, 0x0c, 0x00, 0x51, 0xac, 0x2d, 0x28, 0x40, 0x00, 0x10, 0x00, 0x06, 0x24, 
	0x2d, 0x38, 0x00, 0x00, 0x2d, 0x40, 0x00, 0x00, 0x18, 0x02, 0x40, 0x0c, 0x2d, 0x48, 0x00, 0x00, 
	0xf0, 0x02, 0x40, 0x0c, 0x2d, 0x20, 0x00, 0x00, 0xfd, 0xff, 0x40, 0x10, 0x00, 0x80, 0x04, 0x3c, 
	0x01, 0x00, 0x05, 0x24, 0xc4, 0x01, 0x40, 0x0c, 0x02, 0x00, 0x84, 0x34, 0xba, 0xff, 0x00, 0x10, 
	0x20, 0x00, 0xbf, 0xdf, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xbd, 0x27, 0x00, 0x00, 0xbf, 0xff, 
	0xd4, 0x02, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xdf, 0x00, 0x01, 0x02, 0x3c, 
	0xac, 0x16, 0x40, 0xac, 0x08, 0x00, 0xe0, 0x03, 0x10, 0x00, 0xbd, 0x27, 0x00, 0x00, 0x00, 0x00, 
	0x24, 0x00, 0x85, 0x8c, 0x18, 0x00, 0x82, 0x8c, 0x1a, 0x00, 0xa2, 0x00, 0x01, 0x00, 0x40, 0x50, 
	0xcd, 0x01, 0x00, 0x00, 0x14, 0x00, 0x82, 0x8c, 0x10, 0x18, 0x00, 0x00, 0x80, 0x29, 0x03, 0x00, 
	0x01, 0x00, 0x63, 0x24, 0x21, 0x10, 0x45, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x24, 0x00, 0x83, 0xac, 
	0xe0, 0xff, 0xbd, 0x27, 0x6c, 0x00, 0x02, 0x3c, 0x2d, 0x30, 0xa0, 0x00, 0x61, 0x6c, 0x42, 0x34, 
	0x2d, 0x28, 0xa0, 0x03, 0x01, 0x00, 0x07, 0x24, 0x10, 0x00, 0xbf, 0xff, 0xf6, 0x02, 0x40, 0x0c, 
	0x00, 0x00, 0xa2, 0xaf, 0x10, 0x00, 0xbf, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x20, 0x00, 0xbd, 0x27, 
	0x00, 0x60, 0x03, 0x40, 0x01, 0x00, 0x02, 0x3c, 0x24, 0x18, 0x62, 0x00, 0x2d, 0x20, 0x00, 0x00, 
	0x0c, 0x00, 0x60, 0x10, 0x2b, 0x28, 0x03, 0x00, 0x01, 0x00, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 
	0x39, 0x00, 0x00, 0x42, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x60, 0x03, 0x40, 0x00, 0x00, 0x00, 0x00, 
	0x24, 0x18, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xff, 0x60, 0x14, 0x00, 0x00, 0x00, 0x00, 
	0x2d, 0x20, 0xa0, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x2d, 0x10, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x60, 0x02, 0x40, 0x01, 0x00, 0x03, 0x3c, 0x24, 0x10, 0x43, 0x00, 0x38, 0x00, 0x00, 0x42, 
	0x08, 0x00, 0xe0, 0x03, 0x2b, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xcc, 0xff, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0xbd, 0xff, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x79, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x7a, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x60, 0xff, 0xbd, 0x27, 0x2d, 0x18, 0x00, 0x00, 0x20, 0x00, 0xb0, 0xff, 0xff, 0x00, 0xf0, 0x30, 
	0x71, 0x00, 0x02, 0x2e, 0x80, 0x00, 0xb6, 0xff, 0x70, 0x00, 0xb5, 0xff, 0x2d, 0xb0, 0xa0, 0x00, 
	0x60, 0x00, 0xb4, 0xff, 0x2d, 0xa8, 0x00, 0x01, 0x50, 0x00, 0xb3, 0xff, 0x2d, 0xa0, 0x20, 0x01, 
	0x40, 0x00, 0xb2, 0xff, 0x2d, 0x98, 0x00, 0x00, 0x30, 0x00, 0xb1, 0xff, 0x2d, 0x90, 0x40, 0x01, 
	0x90, 0x00, 0xbf, 0xff, 0x26, 0x00, 0x40, 0x10, 0x2d, 0x88, 0xc0, 0x00, 0x00, 0x12, 0x0a, 0x00, 
	0x04, 0x00, 0xa3, 0x30, 0x25, 0x10, 0x02, 0x02, 0x08, 0x00, 0xc4, 0xac, 0x04, 0x00, 0xc0, 0xac, 
	0x0b, 0x00, 0x40, 0x19, 0x00, 0x00, 0xd0, 0xac, 0x2d, 0x20, 0x00, 0x01, 0x2d, 0x28, 0x40, 0x01, 
	0x00, 0x00, 0xc2, 0xac, 0x01, 0x00, 0x13, 0x24, 0x29, 0x00, 0x60, 0x14, 0x04, 0x00, 0x29, 0xae, 
	0x00, 0x00, 0xb5, 0xaf, 0x04, 0x00, 0xb4, 0xaf, 0x08, 0x00, 0xb2, 0xaf, 0x0c, 0x00, 0xa0, 0xaf, 
	0x00, 0x19, 0x13, 0x00, 0x44, 0x00, 0x02, 0x24, 0x21, 0x18, 0x7d, 0x00, 0x2d, 0x20, 0x20, 0x02, 
	0x0c, 0x00, 0x62, 0xac, 0x2d, 0x28, 0x00, 0x02, 0x00, 0x01, 0x02, 0x3c, 0x08, 0x00, 0x70, 0xac, 
	0xc8, 0x16, 0x46, 0x8c, 0x01, 0x00, 0x73, 0x26, 0x00, 0x00, 0x71, 0xac, 0x88, 0x03, 0x40, 0x0c, 
	0x04, 0x00, 0x66, 0xac, 0x01, 0x00, 0xc2, 0x32, 0x2d, 0x28, 0x60, 0x02, 0x0f, 0x00, 0x40, 0x10, 
	0x2d, 0x20, 0xa0, 0x03, 0x80, 0x03, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x18, 0x40, 0x00, 
	0x90, 0x00, 0xbf, 0xdf, 0x2d, 0x10, 0x60, 0x00, 0x80, 0x00, 0xb6, 0xdf, 0x70, 0x00, 0xb5, 0xdf, 
	0x60, 0x00, 0xb4, 0xdf, 0x50, 0x00, 0xb3, 0xdf, 0x40, 0x00, 0xb2, 0xdf, 0x30, 0x00, 0xb1, 0xdf, 
	0x20, 0x00, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0xa0, 0x00, 0xbd, 0x27, 0x7c, 0x03, 0x40, 0x0c, 
	0x2d, 0x20, 0xa0, 0x03, 0xf2, 0xff, 0x00, 0x10, 0x2d, 0x18, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x88, 0x03, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0x00, 0x10, 0x00, 0x00, 0xb5, 0xaf, 
	0x2d, 0x18, 0xe0, 0x00, 0x2d, 0x58, 0x00, 0x01, 0x2d, 0x10, 0xc0, 0x00, 0xf0, 0xff, 0xbd, 0x27, 
	0x2d, 0x50, 0x20, 0x01, 0x2d, 0x30, 0xa0, 0x00, 0x2d, 0x38, 0x40, 0x00, 0x2d, 0x40, 0x60, 0x00, 
	0x2d, 0x48, 0x60, 0x01, 0x00, 0x00, 0xbf, 0xff, 0xcc, 0x01, 0x40, 0x0c, 0x2d, 0x28, 0x00, 0x00, 
	0x00, 0x00, 0xbf, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x10, 0x00, 0xbd, 0x27, 0x00, 0x00, 0x00, 0x00, 
	0x2d, 0x18, 0xe0, 0x00, 0x2d, 0x58, 0x00, 0x01, 0x2d, 0x10, 0xc0, 0x00, 0xf0, 0xff, 0xbd, 0x27, 
	0x2d, 0x50, 0x20, 0x01, 0x2d, 0x30, 0xa0, 0x00, 0x2d, 0x38, 0x40, 0x00, 0x2d, 0x40, 0x60, 0x00, 
	0x2d, 0x48, 0x60, 0x01, 0x00, 0x00, 0xbf, 0xff, 0xcc, 0x01, 0x40, 0x0c, 0x01, 0x00, 0x05, 0x24, 
	0x00, 0x00, 0xbf, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x10, 0x00, 0xbd, 0x27, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x00, 0x82, 0x8c, 0x08, 0x00, 0xe0, 0x03, 0x08, 0x00, 0xa2, 0xac, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x00, 0x82, 0x8c, 0x1c, 0x00, 0xa6, 0x8c, 0x80, 0x10, 0x02, 0x00, 0x14, 0x00, 0x83, 0x8c, 
	0x21, 0x10, 0x46, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x43, 0xac, 0x00, 0x00, 0x00, 0x00, 
	0xa0, 0xff, 0xbd, 0x27, 0x00, 0x01, 0x04, 0x3c, 0x50, 0x00, 0xbf, 0xff, 0x00, 0x01, 0x02, 0x3c, 
	0x40, 0x00, 0xb2, 0xff, 0x30, 0x00, 0xb1, 0xff, 0x20, 0x00, 0xb0, 0xff, 0xb8, 0x16, 0x42, 0x8c, 
	0xe8, 0x16, 0x83, 0x8c, 0x03, 0x00, 0x62, 0x10, 0x00, 0x01, 0x11, 0x3c, 0xe8, 0x16, 0x82, 0xac, 
	0xe0, 0x16, 0x20, 0xae, 0xe0, 0x16, 0x22, 0x8e, 0x06, 0x00, 0x40, 0x10, 0x50, 0x00, 0xbf, 0xdf, 
	0x40, 0x00, 0xb2, 0xdf, 0x30, 0x00, 0xb1, 0xdf, 0x20, 0x00, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 
	0x60, 0x00, 0xbd, 0x27, 0xa0, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x06, 0x3c, 
	0x00, 0x01, 0x05, 0x3c, 0x1f, 0x00, 0x08, 0x24, 0xc0, 0x16, 0xa4, 0x24, 0xc0, 0x16, 0xa2, 0x8c, 
	0x04, 0x00, 0x83, 0x8c, 0x25, 0x10, 0x46, 0x00, 0x0c, 0x00, 0x87, 0x8c, 0x25, 0x18, 0x66, 0x00, 
	0xc0, 0x16, 0xa2, 0xac, 0x04, 0x00, 0x83, 0xac, 0xff, 0xff, 0x08, 0x25, 0x00, 0x00, 0xe0, 0xac, 
	0x04, 0x00, 0xe0, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xf9, 0xff, 0x01, 0x05, 0x08, 0x00, 0xe7, 0x24, 0x00, 0x01, 0x02, 0x3c, 0x1f, 0x00, 0x08, 0x24, 
	0xdc, 0x16, 0x42, 0x8c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x08, 0x25, 0x00, 0x00, 0x40, 0xac, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xf9, 0xff, 0x01, 0x05, 0x04, 0x00, 0x42, 0x24, 0x00, 0x01, 0x12, 0x3c, 0x00, 0x01, 0x02, 0x3c, 
	0xc0, 0x16, 0x50, 0x26, 0x00, 0x01, 0x03, 0x3c, 0x0c, 0x00, 0x04, 0x8e, 0xf0, 0x08, 0x63, 0x24, 
	0xe0, 0x08, 0x42, 0x24, 0x08, 0x00, 0x83, 0xac, 0x00, 0x00, 0x82, 0xac, 0x0c, 0x00, 0x90, 0xac, 
	0xb4, 0x01, 0x40, 0x0c, 0x04, 0x00, 0x90, 0xac, 0x74, 0x00, 0x40, 0x0c, 0x2d, 0x20, 0x00, 0x00, 
	0x00, 0x10, 0x03, 0x3c, 0x10, 0xe0, 0x63, 0x34, 0x00, 0x00, 0x62, 0x8c, 0x20, 0x00, 0x42, 0x30, 
	0x05, 0x00, 0x40, 0x10, 0x00, 0x10, 0x03, 0x3c, 0x20, 0x00, 0x02, 0x24, 0x01, 0x10, 0x01, 0x3c, 
	0x10, 0xe0, 0x22, 0xac, 0x00, 0x10, 0x03, 0x3c, 0x00, 0xc0, 0x63, 0x34, 0x00, 0x00, 0x62, 0x8c, 
	0x00, 0x01, 0x42, 0x30, 0x39, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x3c, 
	0x2d, 0x30, 0x00, 0x00, 0x88, 0x10, 0xa5, 0x24, 0x68, 0x03, 0x40, 0x0c, 0x05, 0x00, 0x04, 0x24, 
	0x00, 0x01, 0x03, 0x3c, 0x05, 0x00, 0x04, 0x24, 0x2c, 0x03, 0x40, 0x0c, 0xe4, 0x16, 0x62, 0xac, 
	0x01, 0x00, 0x02, 0x24, 0x00, 0x80, 0x04, 0x3c, 0xc8, 0x01, 0x40, 0x0c, 0xe0, 0x16, 0x22, 0xae, 
	0x21, 0x00, 0x40, 0x14, 0x08, 0x00, 0x02, 0xae, 0x02, 0x00, 0x10, 0x3c, 0x00, 0x00, 0x00, 0x00, 
	0xc8, 0x01, 0x40, 0x0c, 0x04, 0x00, 0x04, 0x24, 0x24, 0x10, 0x50, 0x00, 0xfc, 0xff, 0x40, 0x10, 
	0x02, 0x00, 0x04, 0x24, 0xc8, 0x01, 0x40, 0x0c, 0x00, 0x01, 0x11, 0x3c, 0xc0, 0x16, 0x30, 0x26, 
	0x08, 0x00, 0x02, 0xae, 0x2d, 0x28, 0x40, 0x00, 0xc4, 0x01, 0x40, 0x0c, 0x00, 0x80, 0x04, 0x3c, 
	0x2d, 0x28, 0x00, 0x02, 0x00, 0x80, 0x04, 0x3c, 0xc4, 0x01, 0x40, 0x0c, 0x01, 0x00, 0x84, 0x34, 
	0x0c, 0x00, 0xa0, 0xaf, 0xc0, 0x16, 0x22, 0x8e, 0x00, 0x80, 0x04, 0x3c, 0x2d, 0x48, 0x00, 0x00, 
	0x02, 0x00, 0x84, 0x34, 0x10, 0x00, 0xa2, 0xaf, 0x2d, 0x28, 0xa0, 0x03, 0x14, 0x00, 0x06, 0x24, 
	0x2d, 0x38, 0x00, 0x00, 0x2d, 0x40, 0x00, 0x00, 0x18, 0x02, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 
	0x8f, 0xff, 0x00, 0x10, 0x50, 0x00, 0xbf, 0xdf, 0xc0, 0x16, 0x42, 0x8e, 0x00, 0x80, 0x04, 0x3c, 
	0x2d, 0x28, 0xa0, 0x03, 0x14, 0x00, 0x06, 0x24, 0x2d, 0x38, 0x00, 0x00, 0x2d, 0x40, 0x00, 0x00, 
	0x2d, 0x48, 0x00, 0x00, 0xf4, 0xff, 0x00, 0x10, 0x10, 0x00, 0xa2, 0xaf, 0x84, 0x03, 0x40, 0x0c, 
	0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0x00, 0x10, 0x00, 0x01, 0x05, 0x3c, 0x00, 0x00, 0x00, 0x00, 
	0xf0, 0xff, 0xbd, 0x27, 0x00, 0x00, 0xbf, 0xff, 0x4a, 0x03, 0x40, 0x0c, 0x05, 0x00, 0x04, 0x24, 
	0x00, 0x01, 0x02, 0x3c, 0x05, 0x00, 0x04, 0x24, 0x70, 0x03, 0x40, 0x0c, 0xe4, 0x16, 0x45, 0x8c, 
	0x00, 0x00, 0xbf, 0xdf, 0x00, 0x01, 0x03, 0x3c, 0xe0, 0x16, 0x60, 0xac, 0x08, 0x00, 0xe0, 0x03, 
	0x10, 0x00, 0xbd, 0x27, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7f, 0x02, 0x3c, 0x00, 0x01, 0x03, 0x3c, 
	0xff, 0xff, 0x42, 0x34, 0xc0, 0x16, 0x63, 0x24, 0x07, 0x00, 0x81, 0x04, 0x24, 0x10, 0x82, 0x00, 
	0x0c, 0x00, 0x63, 0x8c, 0xc0, 0x10, 0x02, 0x00, 0x21, 0x10, 0x43, 0x00, 0x04, 0x00, 0x46, 0xac, 
	0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x45, 0xac, 0xfa, 0xff, 0x00, 0x10, 0x14, 0x00, 0x63, 0x8c, 
	0x00, 0x01, 0x02, 0x3c, 0x80, 0x20, 0x04, 0x00, 0xdc, 0x16, 0x43, 0x8c, 0x21, 0x20, 0x83, 0x00, 
	0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x82, 0x8c, 0xa0, 0xfd, 0xbd, 0x27, 0x40, 0x02, 0xb3, 0xff, 
	0x2d, 0x98, 0xe0, 0x00, 0x30, 0x02, 0xb2, 0xff, 0x2d, 0x90, 0xc0, 0x00, 0x20, 0x02, 0xb1, 0xff, 
	0x2d, 0x88, 0xa0, 0x00, 0x10, 0x02, 0xb0, 0xff, 0x50, 0x02, 0xbf, 0xff, 0xf8, 0x04, 0x40, 0x0c, 
	0x2d, 0x80, 0x80, 0x00, 0xff, 0xff, 0x03, 0x3c, 0x21, 0x00, 0x40, 0x04, 0xff, 0x29, 0x63, 0x34, 
	0x2d, 0x28, 0x00, 0x02, 0x18, 0x00, 0xa4, 0x27, 0xb4, 0x03, 0x40, 0x0c, 0xfb, 0x00, 0x06, 0x24, 
	0x14, 0x01, 0xa4, 0x27, 0xfb, 0x00, 0x06, 0x24, 0xb4, 0x03, 0x40, 0x0c, 0x2d, 0x28, 0x20, 0x02, 
	0x00, 0x00, 0xa0, 0xaf, 0x10, 0x00, 0xa7, 0x27, 0x00, 0x01, 0x04, 0x3c, 0x2d, 0x58, 0x00, 0x00, 
	0x2d, 0x28, 0x60, 0x02, 0xc0, 0x33, 0x84, 0x24, 0x2d, 0x30, 0x00, 0x00, 0x00, 0x02, 0x08, 0x24, 
	0x2d, 0x48, 0xe0, 0x00, 0x10, 0x00, 0x0a, 0x24, 0x13, 0x01, 0xa0, 0xa3, 0x5a, 0x04, 0x40, 0x0c, 
	0x0f, 0x02, 0xa0, 0xa3, 0xff, 0xff, 0x03, 0x3c, 0x09, 0x00, 0x40, 0x04, 0xed, 0x29, 0x63, 0x34, 
	0x10, 0x00, 0xa4, 0x8f, 0x06, 0x00, 0x80, 0x04, 0x2d, 0x18, 0x80, 0x00, 0x03, 0x00, 0x40, 0x12, 
	0x14, 0x00, 0xa2, 0x8f, 0x00, 0x00, 0x44, 0xae, 0x04, 0x00, 0x42, 0xae, 0x2d, 0x18, 0x00, 0x00, 
	0x50, 0x02, 0xbf, 0xdf, 0x2d, 0x10, 0x60, 0x00, 0x40, 0x02, 0xb3, 0xdf, 0x30, 0x02, 0xb2, 0xdf, 
	0x20, 0x02, 0xb1, 0xdf, 0x10, 0x02, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x60, 0x02, 0xbd, 0x27, 
	0xd0, 0xff, 0xbd, 0x27, 0x10, 0x00, 0xb1, 0xff, 0x2d, 0x88, 0x80, 0x00, 0x20, 0x00, 0xbf, 0xff, 
	0x00, 0x00, 0xb0, 0xff, 0x00, 0x60, 0x10, 0x40, 0x01, 0x00, 0x02, 0x3c, 0x24, 0x80, 0x02, 0x02, 
	0x11, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x74, 0x03, 0x40, 0x0c, 0x2d, 0x20, 0x20, 0x02, 
	0x2d, 0x88, 0x40, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 
	0x2d, 0x10, 0x20, 0x02, 0x20, 0x00, 0xbf, 0xdf, 0x10, 0x00, 0xb1, 0xdf, 0x00, 0x00, 0xb0, 0xdf, 
	0x08, 0x00, 0xe0, 0x03, 0x30, 0x00, 0xbd, 0x27, 0xb4, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 
	0xf8, 0xff, 0x00, 0x10, 0x2d, 0x10, 0x20, 0x02, 0xa0, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 
	0xed, 0xff, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xbd, 0x27, 0x10, 0x00, 0xb1, 0xff, 
	0x2d, 0x88, 0x80, 0x00, 0x20, 0x00, 0xbf, 0xff, 0x00, 0x00, 0xb0, 0xff, 0x00, 0x60, 0x10, 0x40, 
	0x01, 0x00, 0x02, 0x3c, 0x24, 0x80, 0x02, 0x02, 0x11, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 
	0x78, 0x03, 0x40, 0x0c, 0x2d, 0x20, 0x20, 0x02, 0x2d, 0x88, 0x40, 0x00, 0x0f, 0x00, 0x00, 0x00, 
	0x07, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x10, 0x20, 0x02, 0x20, 0x00, 0xbf, 0xdf, 
	0x10, 0x00, 0xb1, 0xdf, 0x00, 0x00, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x30, 0x00, 0xbd, 0x27, 
	0xb4, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x00, 0x10, 0x2d, 0x10, 0x20, 0x02, 
	0xa0, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xed, 0xff, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 
	0x12, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x13, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x16, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x17, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x77, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x89, 0xff, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x78, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0xff, 0xff, 0x19, 0x3c, 0xc0, 0xff, 0x39, 0x37, 0x26, 0x00, 0xa0, 0x18, 0x21, 0x50, 0x85, 0x00, 
	0x24, 0x40, 0x99, 0x00, 0xff, 0xff, 0x4a, 0x25, 0x24, 0x48, 0x59, 0x01, 0x23, 0x50, 0x28, 0x01, 
	0x82, 0x59, 0x0a, 0x00, 0x01, 0x00, 0x6b, 0x25, 0x07, 0x00, 0x69, 0x31, 0x08, 0x00, 0x20, 0x11, 
	0xc2, 0x50, 0x0b, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xbd, 0x0f, 0x00, 0x00, 0x00, 
	0xff, 0xff, 0x29, 0x25, 0x00, 0x00, 0x00, 0x00, 0xfa, 0xff, 0x20, 0x1d, 0x40, 0x00, 0x08, 0x25, 
	0x14, 0x00, 0x40, 0x11, 0xff, 0xff, 0x4a, 0x25, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xbd, 
	0x0f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x18, 0xbd, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x18, 0xbd, 
	0x0f, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x18, 0xbd, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0xbd, 
	0x0f, 0x00, 0x00, 0x00, 0x40, 0x01, 0x18, 0xbd, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x01, 0x18, 0xbd, 
	0x0f, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x18, 0xbd, 0x0f, 0x00, 0x00, 0x00, 0xed, 0xff, 0x40, 0x1d, 
	0x00, 0x02, 0x08, 0x25, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x2d, 0x40, 0x80, 0x00, 0x25, 0x38, 0xa4, 0x00, 0x10, 0x00, 0x0a, 0x24, 0x07, 0x00, 0xe2, 0x30, 
	0x08, 0x00, 0x09, 0x24, 0x54, 0x00, 0x40, 0x14, 0x0f, 0x00, 0xe2, 0x30, 0x0a, 0x48, 0x42, 0x01, 
	0x2c, 0x00, 0x40, 0x14, 0x2b, 0x10, 0xc9, 0x00, 0x4f, 0x00, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00, 
	0x01, 0x01, 0x07, 0x3c, 0x01, 0x01, 0xe7, 0x34, 0x38, 0x3c, 0x07, 0x00, 0x01, 0x01, 0xe7, 0x34, 
	0x38, 0x3c, 0x07, 0x00, 0x01, 0x01, 0xe7, 0x34, 0x00, 0x00, 0xa3, 0x78, 0x89, 0x4b, 0xe7, 0x70, 
	0xe9, 0x1c, 0x03, 0x70, 0x80, 0x80, 0x07, 0x3c, 0x80, 0x80, 0xe7, 0x34, 0x38, 0x3c, 0x07, 0x00, 
	0x80, 0x80, 0xe7, 0x34, 0x38, 0x3c, 0x07, 0x00, 0x80, 0x80, 0xe7, 0x34, 0x48, 0x12, 0x69, 0x70, 
	0x89, 0x53, 0xe7, 0x70, 0x89, 0x14, 0x43, 0x70, 0x89, 0x14, 0x4a, 0x70, 0xa9, 0x1b, 0x44, 0x70, 
	0x25, 0x18, 0x43, 0x00, 0x37, 0x00, 0x60, 0x14, 0x2d, 0x38, 0x00, 0x01, 0x00, 0x00, 0xa3, 0x78, 
	0xf0, 0xff, 0xc6, 0x24, 0x10, 0x00, 0xa5, 0x24, 0x10, 0x00, 0xc2, 0x2c, 0x00, 0x00, 0xe3, 0x7c, 
	0x30, 0x00, 0x40, 0x14, 0x10, 0x00, 0xe7, 0x24, 0x00, 0x00, 0xa2, 0x78, 0xe9, 0x1c, 0x02, 0x70, 
	0x48, 0x12, 0x49, 0x70, 0x89, 0x14, 0x43, 0x70, 0x89, 0x14, 0x4a, 0x70, 0xa9, 0x1b, 0x44, 0x70, 
	0x25, 0x10, 0x43, 0x00, 0x1a, 0x00, 0x40, 0x50, 0x00, 0x00, 0xa3, 0x78, 0x26, 0x00, 0x00, 0x10, 
	0x2d, 0x20, 0xe0, 0x00, 0x24, 0x00, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa3, 0xdc, 
	0x01, 0x01, 0x09, 0x3c, 0x01, 0x01, 0x29, 0x35, 0x38, 0x4c, 0x09, 0x00, 0x01, 0x01, 0x29, 0x35, 
	0x38, 0x4c, 0x09, 0x00, 0x01, 0x01, 0x29, 0x35, 0x80, 0x80, 0x0a, 0x3c, 0x80, 0x80, 0x4a, 0x35, 
	0x38, 0x54, 0x0a, 0x00, 0x80, 0x80, 0x4a, 0x35, 0x38, 0x54, 0x0a, 0x00, 0x80, 0x80, 0x4a, 0x35, 
	0x2f, 0x10, 0x69, 0x00, 0x27, 0x18, 0x03, 0x00, 0x24, 0x10, 0x43, 0x00, 0x24, 0x10, 0x4a, 0x00, 
	0x10, 0x00, 0x40, 0x14, 0x2d, 0x38, 0x00, 0x01, 0x00, 0x00, 0xa3, 0xdc, 0x00, 0x00, 0x00, 0x00, 
	0xf8, 0xff, 0xc6, 0x24, 0x08, 0x00, 0xa5, 0x24, 0x08, 0x00, 0xc2, 0x2c, 0x00, 0x00, 0xe3, 0xfc, 
	0x08, 0x00, 0x40, 0x14, 0x08, 0x00, 0xe7, 0x24, 0x00, 0x00, 0xa2, 0xdc, 0x27, 0x18, 0x02, 0x00, 
	0x2f, 0x10, 0x49, 0x00, 0x24, 0x10, 0x43, 0x00, 0x24, 0x10, 0x4a, 0x00, 0xf4, 0xff, 0x40, 0x50, 
	0x00, 0x00, 0xa3, 0xdc, 0x2d, 0x20, 0xe0, 0x00, 0x10, 0x00, 0xc0, 0x10, 0x2d, 0x10, 0xc0, 0x00, 
	0x00, 0x00, 0xa2, 0x90, 0xff, 0xff, 0xc6, 0x24, 0x01, 0x00, 0xa5, 0x24, 0x00, 0x00, 0x82, 0xa0, 
	0x00, 0x16, 0x02, 0x00, 0xf8, 0xff, 0x40, 0x14, 0x01, 0x00, 0x84, 0x24, 0x2d, 0x10, 0xc0, 0x00, 
	0x06, 0x00, 0x40, 0x10, 0xff, 0xff, 0xc6, 0x24, 0x00, 0x00, 0x80, 0xa0, 0x2d, 0x10, 0xc0, 0x00, 
	0x01, 0x00, 0x84, 0x24, 0xfc, 0xff, 0x40, 0x14, 0xff, 0xff, 0xc6, 0x24, 0x08, 0x00, 0xe0, 0x03, 
	0x2d, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xbd, 0x27, 0x80, 0x00, 0xb0, 0xff, 
	0x90, 0x00, 0xbf, 0xff, 0xb4, 0x01, 0x40, 0x0c, 0x00, 0x01, 0x10, 0x3c, 0xc0, 0x16, 0x06, 0x8e, 
	0x2d, 0x38, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x90, 0x22, 0x00, 0x40, 0x10, 0xc0, 0x16, 0x10, 0x26, 
	0x1e, 0x00, 0x42, 0x24, 0x03, 0x29, 0x02, 0x00, 0x0d, 0x00, 0xa0, 0x10, 0x00, 0x00, 0xc0, 0xac, 
	0xff, 0xff, 0xa5, 0x24, 0xff, 0xff, 0x02, 0x24, 0x09, 0x00, 0xa2, 0x10, 0xff, 0xff, 0x08, 0x24, 
	0x00, 0x11, 0x07, 0x00, 0xff, 0xff, 0xa5, 0x24, 0x21, 0x20, 0x46, 0x00, 0x01, 0x00, 0xe7, 0x24, 
	0x00, 0x00, 0x83, 0x78, 0x21, 0x10, 0x5d, 0x00, 0xf9, 0xff, 0xa8, 0x14, 0x00, 0x00, 0x43, 0x7c, 
	0x3c, 0x05, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0xa4, 0x8f, 0xff, 0x7f, 0x02, 0x3c, 
	0xff, 0xff, 0x42, 0x34, 0x24, 0x10, 0x82, 0x00, 0x20, 0x00, 0x43, 0x28, 0x09, 0x00, 0x60, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x83, 0x04, 0x14, 0x00, 0x03, 0x8e, 0x0c, 0x00, 0x03, 0x8e, 
	0xc0, 0x10, 0x02, 0x00, 0x21, 0x10, 0x43, 0x00, 0x00, 0x00, 0x43, 0x8c, 0x09, 0x00, 0x60, 0x54, 
	0x04, 0x00, 0x45, 0x8c, 0x0f, 0x00, 0x00, 0x00, 0xb4, 0x01, 0x40, 0x0c, 0x00, 0x00, 0x00, 0x00, 
	0x80, 0x00, 0xb0, 0xdf, 0x90, 0x00, 0xbf, 0xdf, 0x2d, 0x10, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 
	0xa0, 0x00, 0xbd, 0x27, 0x09, 0xf8, 0x60, 0x00, 0x2d, 0x20, 0xa0, 0x03, 0xf5, 0xff, 0x00, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xbd, 0x27, 0x30, 0x00, 0xb1, 0xff, 
	0x2d, 0x88, 0x80, 0x00, 0x00, 0x01, 0x04, 0x3c, 0xa0, 0x00, 0xbe, 0xff, 0x80, 0x16, 0x84, 0x24, 
	0x90, 0x00, 0xb7, 0xff, 0x80, 0x00, 0xb6, 0xff, 0x2d, 0xf0, 0x20, 0x01, 0x70, 0x00, 0xb5, 0xff, 
	0x2d, 0xb0, 0xe0, 0x00, 0x60, 0x00, 0xb4, 0xff, 0x2d, 0xa8, 0xc0, 0x00, 0x50, 0x00, 0xb3, 0xff, 
	0x2d, 0xa0, 0xa0, 0x00, 0x40, 0x00, 0xb2, 0xff, 0x2d, 0x98, 0x00, 0x01, 0x20, 0x00, 0xb0, 0xff, 
	0x2d, 0x90, 0x40, 0x01, 0xb0, 0x00, 0xbf, 0xff, 0xc8, 0x04, 0x40, 0x0c, 0x2d, 0xb8, 0x60, 0x01, 
	0xff, 0xff, 0x03, 0x3c, 0x2d, 0x80, 0x40, 0x00, 0x2d, 0x00, 0x40, 0x10, 0xf0, 0x29, 0x63, 0x34, 
	0x18, 0x00, 0x42, 0x8c, 0xff, 0xff, 0x03, 0x24, 0x24, 0x00, 0x24, 0x8e, 0x02, 0x00, 0xa5, 0x32, 
	0x04, 0x00, 0x22, 0xae, 0xc0, 0x00, 0xa2, 0x8f, 0x08, 0x00, 0x23, 0xae, 0x20, 0x00, 0x22, 0xae, 
	0x01, 0x00, 0x02, 0x24, 0x00, 0x00, 0x30, 0xae, 0x20, 0x00, 0x14, 0xae, 0x30, 0x00, 0x02, 0xae, 
	0x34, 0x00, 0x04, 0xae, 0x1c, 0x00, 0x37, 0xae, 0x24, 0x00, 0x13, 0xae, 0x28, 0x00, 0x1e, 0xae, 
	0x2c, 0x00, 0x12, 0xae, 0x14, 0x00, 0x10, 0xae, 0x09, 0x00, 0xa0, 0x14, 0x1c, 0x00, 0x11, 0xae, 
	0x03, 0x00, 0x60, 0x1a, 0x2d, 0x20, 0xc0, 0x02, 0x88, 0x03, 0x40, 0x0c, 0x2d, 0x28, 0x60, 0x02, 
	0x03, 0x00, 0x40, 0x1a, 0x2d, 0x20, 0xc0, 0x03, 0x88, 0x03, 0x40, 0x0c, 0x2d, 0x28, 0x40, 0x02, 
	0x01, 0x00, 0xa2, 0x32, 0x1c, 0x00, 0x40, 0x10, 0x01, 0x00, 0x02, 0x24, 0x01, 0x00, 0xe0, 0x52, 
	0x30, 0x00, 0x00, 0xae, 0x14, 0x00, 0x28, 0x8e, 0x00, 0x80, 0x04, 0x3c, 0x2d, 0x28, 0x00, 0x02, 
	0x2d, 0x38, 0xc0, 0x02, 0x2d, 0x48, 0x60, 0x02, 0x0a, 0x00, 0x84, 0x34, 0x18, 0x02, 0x40, 0x0c, 
	0x40, 0x00, 0x06, 0x24, 0xff, 0xff, 0x03, 0x3c, 0xef, 0x29, 0x63, 0x34, 0x0b, 0x18, 0x02, 0x00, 
	0xb0, 0x00, 0xbf, 0xdf, 0x2d, 0x10, 0x60, 0x00, 0xa0, 0x00, 0xbe, 0xdf, 0x90, 0x00, 0xb7, 0xdf, 
	0x80, 0x00, 0xb6, 0xdf, 0x70, 0x00, 0xb5, 0xdf, 0x60, 0x00, 0xb4, 0xdf, 0x50, 0x00, 0xb3, 0xdf, 
	0x40, 0x00, 0xb2, 0xdf, 0x30, 0x00, 0xb1, 0xdf, 0x20, 0x00, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 
	0xc0, 0x00, 0xbd, 0x27, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x20, 0xa0, 0x03, 0x04, 0x00, 0xa2, 0xaf, 
	0x30, 0x05, 0x40, 0x0c, 0x08, 0x00, 0xa0, 0xaf, 0xff, 0xff, 0x03, 0x3c, 0x08, 0x00, 0x22, 0xae, 
	0xeb, 0xff, 0x40, 0x04, 0xfe, 0x29, 0x63, 0x34, 0x00, 0x80, 0x04, 0x3c, 0x14, 0x00, 0x28, 0x8e, 
	0x2d, 0x28, 0x00, 0x02, 0x2d, 0x38, 0xc0, 0x02, 0x2d, 0x48, 0x60, 0x02, 0x0a, 0x00, 0x84, 0x34, 
	0x18, 0x02, 0x40, 0x0c, 0x40, 0x00, 0x06, 0x24, 0xff, 0xff, 0x03, 0x3c, 0xe0, 0xff, 0x40, 0x10, 
	0xef, 0x29, 0x63, 0x34, 0x38, 0x05, 0x40, 0x0c, 0x08, 0x00, 0x24, 0x8e, 0x34, 0x05, 0x40, 0x0c, 
	0x08, 0x00, 0x24, 0x8e, 0xda, 0xff, 0x00, 0x10, 0x2d, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xc0, 0xff, 0xbd, 0x27, 0x20, 0x00, 0xb2, 0xff, 0x2d, 0x90, 0x80, 0x00, 0x10, 0x00, 0xb1, 0xff, 
	0x2d, 0x88, 0x00, 0x00, 0x30, 0x00, 0xbf, 0xff, 0xa0, 0x01, 0x40, 0x0c, 0x00, 0x00, 0xb0, 0xff, 
	0x08, 0x00, 0x43, 0x8e, 0x21, 0x00, 0x60, 0x18, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x50, 0x8e, 
	0x10, 0x00, 0x02, 0x8e, 0x01, 0x00, 0x42, 0x30, 0x05, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0x31, 0x26, 0x2a, 0x10, 0x23, 0x02, 0xf9, 0xff, 0x40, 0x14, 0x40, 0x00, 0x10, 0x26, 
	0x16, 0x00, 0x23, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x8e, 0x10, 0x00, 0x60, 0x10, 
	0x02, 0x00, 0x02, 0x24, 0x01, 0x00, 0x63, 0x24, 0x00, 0x00, 0x43, 0xae, 0x00, 0x14, 0x11, 0x00, 
	0x18, 0x00, 0x03, 0xae, 0x05, 0x00, 0x42, 0x34, 0x14, 0x00, 0x10, 0xae, 0xb4, 0x01, 0x40, 0x0c, 
	0x10, 0x00, 0x02, 0xae, 0x2d, 0x10, 0x00, 0x02, 0x30, 0x00, 0xbf, 0xdf, 0x20, 0x00, 0xb2, 0xdf, 
	0x10, 0x00, 0xb1, 0xdf, 0x00, 0x00, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x40, 0x00, 0xbd, 0x27, 
	0x01, 0x00, 0x03, 0x24, 0xf1, 0xff, 0x00, 0x10, 0x00, 0x00, 0x42, 0xae, 0xb4, 0x01, 0x40, 0x0c, 
	0x00, 0x00, 0x00, 0x00, 0xf4, 0xff, 0x00, 0x10, 0x2d, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xd0, 0xff, 0xbd, 0x27, 0x00, 0x01, 0x04, 0x3c, 0x20, 0x00, 0xbf, 0xff, 0x00, 0x01, 0x02, 0x3c, 
	0x10, 0x00, 0xb1, 0xff, 0x00, 0x00, 0xb0, 0xff, 0xb8, 0x16, 0x42, 0x8c, 0xf4, 0x16, 0x83, 0x8c, 
	0x03, 0x00, 0x62, 0x10, 0x00, 0x01, 0x11, 0x3c, 0xf4, 0x16, 0x82, 0xac, 0xf0, 0x16, 0x20, 0xae, 
	0xf0, 0x16, 0x22, 0x8e, 0x07, 0x00, 0x40, 0x10, 0x2d, 0x18, 0x00, 0x00, 0x20, 0x00, 0xbf, 0xdf, 
	0x2d, 0x10, 0x60, 0x00, 0x10, 0x00, 0xb1, 0xdf, 0x00, 0x00, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 
	0x30, 0x00, 0xbd, 0x27, 0x26, 0x01, 0x40, 0x0c, 0x2d, 0x20, 0x00, 0x00, 0x00, 0x01, 0x02, 0x3c, 
	0xc0, 0x33, 0x50, 0x24, 0x00, 0x80, 0x05, 0x3c, 0x2d, 0x20, 0x00, 0x02, 0x06, 0x00, 0xa5, 0x34, 
	0x40, 0x05, 0x40, 0x0c, 0x2d, 0x30, 0x00, 0x00, 0xff, 0xff, 0x03, 0x3c, 0xef, 0xff, 0x40, 0x04, 
	0xee, 0x29, 0x63, 0x34, 0x24, 0x00, 0x02, 0x8e, 0x0f, 0x00, 0x03, 0x3c, 0xff, 0xff, 0x63, 0x34, 
	0x0f, 0x00, 0x40, 0x14, 0xfe, 0xff, 0x04, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x63, 0x24, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xf5, 0xff, 0x64, 0x14, 0x00, 0x80, 0x05, 0x3c, 0xe8, 0xff, 0x00, 0x10, 0x2d, 0x20, 0x00, 0x02, 
	0x01, 0x00, 0x02, 0x24, 0x2d, 0x18, 0x00, 0x00, 0xd8, 0xff, 0x00, 0x10, 0xf0, 0x16, 0x22, 0xae, 
	0x40, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x41, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x44, 0x00, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x88, 0xff, 0x03, 0x24, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x90, 0xff, 0xbd, 0x27, 0x30, 0x00, 0xb1, 0xff, 0x2d, 0x88, 0x80, 0x00, 0x00, 0x01, 0x04, 0x3c, 
	0x50, 0x00, 0xb3, 0xff, 0x80, 0x16, 0x84, 0x24, 0x40, 0x00, 0xb2, 0xff, 0x20, 0x00, 0xb0, 0xff, 
	0x2d, 0x98, 0xa0, 0x00, 0x60, 0x00, 0xbf, 0xff, 0xc8, 0x04, 0x40, 0x0c, 0x2d, 0x90, 0xc0, 0x00, 
	0xff, 0xff, 0x03, 0x3c, 0x2d, 0x80, 0x40, 0x00, 0x19, 0x00, 0x40, 0x10, 0xf0, 0x29, 0x63, 0x34, 
	0x10, 0x00, 0x20, 0xae, 0x2d, 0x28, 0x40, 0x00, 0x00, 0x80, 0x04, 0x3c, 0xff, 0xff, 0x03, 0x24, 
	0x18, 0x00, 0x42, 0x8c, 0x01, 0x00, 0x4a, 0x32, 0x08, 0x00, 0x23, 0xae, 0x09, 0x00, 0x84, 0x34, 
	0x04, 0x00, 0x22, 0xae, 0x40, 0x00, 0x06, 0x24, 0x00, 0x00, 0x30, 0xae, 0x2d, 0x38, 0x00, 0x00, 
	0x2d, 0x40, 0x00, 0x00, 0x2d, 0x48, 0x00, 0x00, 0x20, 0x00, 0x13, 0xae, 0x24, 0x00, 0x20, 0xae, 
	0x14, 0x00, 0x10, 0xae, 0x0e, 0x00, 0x40, 0x11, 0x1c, 0x00, 0x11, 0xae, 0x18, 0x02, 0x40, 0x0c, 
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x03, 0x3c, 0xef, 0x29, 0x63, 0x34, 0x0b, 0x18, 0x02, 0x00, 
	0x60, 0x00, 0xbf, 0xdf, 0x2d, 0x10, 0x60, 0x00, 0x50, 0x00, 0xb3, 0xdf, 0x40, 0x00, 0xb2, 0xdf, 
	0x30, 0x00, 0xb1, 0xdf, 0x20, 0x00, 0xb0, 0xdf, 0x08, 0x00, 0xe0, 0x03, 0x70, 0x00, 0xbd, 0x27, 
	0x01, 0x00, 0x02, 0x24, 0x2d, 0x20, 0xa0, 0x03, 0x04, 0x00, 0xa2, 0xaf, 0x30, 0x05, 0x40, 0x0c, 
	0x08, 0x00, 0xa0, 0xaf, 0xff, 0xff, 0x03, 0x3c, 0x08, 0x00, 0x22, 0xae, 0xf0, 0xff, 0x40, 0x04, 
	0xfe, 0x29, 0x63, 0x34, 0x00, 0x80, 0x04, 0x3c, 0x2d, 0x28, 0x00, 0x02, 0x09, 0x00, 0x84, 0x34, 
	0x40, 0x00, 0x06, 0x24, 0x2d, 0x38, 0x00, 0x00, 0x2d, 0x40, 0x00, 0x00, 0x18, 0x02, 0x40, 0x0c, 
	0x2d, 0x48, 0x00, 0x00, 0xff, 0xff, 0x03, 0x3c, 0xe5, 0xff, 0x40, 0x10, 0xef, 0x29, 0x63, 0x34, 
	0x38, 0x05, 0x40, 0x0c, 0x08, 0x00, 0x24, 0x8e, 0x34, 0x05, 0x40, 0x0c, 0x08, 0x00, 0x24, 0x8e, 
	0xdf, 0xff, 0x00, 0x10, 0x2d, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0x00, 0x00, 0x80, 0x18, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x80, 0x28, 0x00, 0x01, 
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x80, 0x30, 0x00, 0x01, 0x00, 0x31, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x40, 0x31, 0x00, 0x01, 
	0x20, 0x00, 0x00, 0x00, 0x40, 0x32, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x40, 0x33, 0x00, 0x01, 
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

void SMS_EExec ( char* apPath ) {
 __asm__(
  ".set noreorder\n\t"
  ".set nomacro\n\t"
  ".set noat\n\t"
  "addiu    $sp, $sp, -16\n\t"
  "sw       $a0, 0($sp)\n\t"
  "jal      SMS_IOPReset\n\t"
  "addiu    $a0, $zero, 1\n\t"
  "jal      SMS_IOPStartUSB\n\t"
  "xor      $a0, $a0, $a0\n\t"
  "lui      $a0, 0x0100\n\t"
  "lui      $a1, %hi( s_Loader )\n\t"
  "addiu    $a2, $zero, 8192\n\t"
  "jal      memcpy\n\t"
  "addiu    $a1, $a1, %lo( s_Loader )\n\t"
  "jal      FlushCache\n\t"
  "xor      $a0, $a0, $a0\n\t"
  "jal      FlushCache\n\t"
  "addiu    $a0, $zero, 2\n\t"
  "jal      SifExitRpc\n\t"
  "nop\n\t"
  ".set reorder\n\t"
  ".set macro\n\t"
  ".set at\n\t"
  "lui      $ra, %hi( ExecPS2 )\n\t"
  "lui      $a0, 0x0100\n\t"
  "addiu    $a2, $zero, 1\n\t"
  "addiu    $ra, $ra, %lo( ExecPS2 )\n\t"
  "addu     $a3, $zero, $sp\n\t"
 );

}  /* end SMS_EExec */

#endif  /* EMBEDDED */
extern int GUI_ReadButtons0 ( void );
extern int GUI_ReadButtons1 ( void );
extern int GUI_ReadButtons2 ( void );

extern unsigned char g_PadBuf1[ 256 ] __attribute__(   (  aligned( 64 ), section( ".data"  )  )   );

void SMS_EEPort2Init ( void ) {

 if ( g_Config.m_NetworkFlags & SMS_DF_GAMEPAD ) {

  PAD_OpenPort ( 1, 0, g_PadBuf1 );
  GUI_ReadButtons = GUI_ReadButtons1;

 } else if (  ( g_Config.m_NetworkFlags & SMS_DF_REMOTE ) && ( g_IOPFlags & SMS_IOPF_RMMAN )  ) {

  RC_Open ( 1 );
  GUI_ReadButtons = GUI_ReadButtons0;

 } else {

  if ( g_IOPFlags & SMS_IOPF_RMMAN2 ) {

   RCX_Open ();
   GUI_ReadButtons = GUI_ReadButtons0;

  } else GUI_ReadButtons = GUI_ReadButtons2;

 }  /* end else */

}  /* end SMS_Port2Init */

void SMS_SetDirButtons ( void ) {

 RC_SetTranslator (
  g_Config.m_BrowserFlags & SMS_BF_DIRB ? RC_TransRC : RC_TransPAD
 );

}  /* end SMS_SetDirButtons */

void SMS_InitBitBlt ( void* apPack, int aCnt, int anY, int aH ) {

 GSLoadImage*  lpPack = UNCACHED_SEG( apPack );
 unsigned long lXYXY  = GS_L2P ( 0, anY, g_GSCtx.m_LWidth, aH );
 int           lX     = ( lXYXY >>  0 ) & 0xFFFF;
 int           lY     = ( lXYXY >> 16 ) & 0xFFFF;
 int           lW     = ( lXYXY >> 32 ) & 0xFFFF;
 int           lH     = ( lXYXY >> 48 ) & 0xFFFF;
 int           lHH    = lH / aCnt;
 int           lYY    = lY;
 int           lFBW   = g_GSCtx.m_DrawCtx[ 0 ].m_FRAMEVal.FBW;
 int           lPSM   = g_GSCtx.m_DrawCtx[ 0 ].m_FRAMEVal.PSM;

 while ( aCnt-- ) {

  void*   lpData = g_GSCtx.m_pDBuf + g_GSCtx.m_LWidth * lYY * g_GSCtx.m_PixSize;
  DMATag* lpDMA  = ( DMATag* )&lpPack -> m_DMATag2[ 0 ];

  GS_InitLoadImage ( lpPack, 0, lFBW, lPSM, lX, lYY, lW, lHH );

  lpDMA -> ADDR = ( unsigned int )lpData;
  lYY          += lHH;

  if ( aCnt ) {
   lpPack -> m_Tag2.EOP = 0;
   lpPack -> m_DMATag3[ 0 ] = DMA_TAG( 0, 0, DMATAG_ID_CNT, 0, 0, 0 );
   lpPack -> m_DMATag3[ 1 ] = 0;
  } else if ( lYY + lHH < lY + lH ) lHH += ( lY + lH ) - ( lYY + lHH );

  ++lpPack;

 }  /* end while */

}  /* end SMS_InitBitBlt */

void* SMS_SyncMalloc ( int aSize ) {

 char* retVal = ( char* )memalign (  64, ( aSize + 63 ) & ~63  );

 SyncDCache ( retVal, retVal + aSize );

 return retVal;

}  /* end SMS_SyncMalloc */

__asm__(
 ".set noreorder\n\t"
 ".globl SMS_SetExecPath\n\t"
 ".text\n\t"
 "SMS_SetExecPath:\n\t"
 "addiu     $v1, $zero, 253\n\t"
 "syscall\n\t"
 "jr        $ra\n\t"
 "nop\n\t"
 ".set reorder\n\t"
);

void SMS_EEScanDir ( const char* apPath, const char* apExt, SMS_List* apList ) {

 fio_dirent_t lEntry;
 int          lDD;

 lDD = fioDopen ( apPath );

 if ( lDD >= 0 ) {

  while (  fioDread ( lDD, &lEntry ) > 0  ) {

   int lLen = strlen ( lEntry.name );

   if ( lLen > 4 ) {

    char* lpPtr = &lEntry.name[ lLen - 4 ];

    if (  !strcmp ( lpPtr, apExt )  ) {

     lpPtr[ 0 ] = '\x00';
     if (  !SMS_ListFind ( apList, lEntry.name )  ) SMS_ListPushBack ( apList, lEntry.name );

    }  /* end if */

   }  /* end if */

  }  /* end while */

  fioDclose ( lDD );

 }  /* end if */

}  /* end SMS_EEScanDir */

__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".globl SMS_EEDIntr\n\t"
 ".globl SMS_EETlbSet\n\t"
 ".globl SMS_EETlbGet\n\t"
 ".globl SMS_EETlbAlloc\n\t"
 ".globl SMS_EETlbFree\n\t"
 ".text\n\t"
 "SMS_EEDIntr:\n\t"
 "_di:\n\t"
 "mfc0  $v1, $12\n\t"
 "lui   $at, 0x0001\n\t"
 "and   $v1, $v1, $at\n\t"
 "beql  $v1, $zero, 1f\n\t"
 "xor   $v0, $v0, $v0\n\t"
 "2:\n\t"
 "di\n\t"
 "sync.p\n\t"
 "mfc0  $v1, $12\n\t"
 "and   $v1, $v1, $at\n\t"
 "bne   $v1, $zero, 2b\n\t"
 "nor   $v0, $zero, $zero\n\t"
 "1:\n\t"
 "jr    $ra\n\t"
 "nop\n\t"
 "SMS_EETlbSet:\n\t"
 "addiu $sp, $sp, -16\n\t"
 "lw    $a2,  0($a1)\n\t"
 "lw    $a3,  4($a1)\n\t"
 "lw    $t0,  8($a1)\n\t"
 "lw    $a1, 12($a1)\n\t"
 "sw    $ra,  0($sp)\n\t"
 "bgezal    $zero, _di\n\t"
 "sll   $a2, $a2, 1\n\t"
 "mtc0  $a0, $0\n\t"
 "mtc0  $a2, $5\n\t"
 "mtc0  $a3, $10\n\t"
 "mtc0  $t0, $2\n\t"
 "mtc0  $a1, $3\n\t"
 "sync.p\n\t"
 "tlbwi\n\t"
 "sync.p\n\t"
 "bnel  $v0, $zero, 1f\n\t"
 "ei\n\t"
 "1:\n\t"
 "lw    $ra, 0($sp)\n\t"
 "jr    $ra\n\t"
 "addiu $sp, $sp, 16\n\t"
 "SMS_EETlbGet:\n\t"
 "addiu $sp, $sp, -16\n\t"
 "sw    $ra, 0($sp)\n\t"
 "bgezal    $zero, _di\n\t"
 "nop\n\t"
 "mfc0  $t2, $10\n\t"
 "mtc0  $a0, $0\n\t"
 "sync.p\n\t"
 "tlbr\n\t"
 "sync.p\n\t"
 "mfc0  $a2, $5\n\t"
 "mfc0  $a3, $10\n\t"
 "mfc0  $t1, $2\n\t"
 "srl   $a2, $a2, 1\n\t"
 "mfc0  $t0, $3\n\t"
 "sw    $a2,  0($a1)\n\t"
 "sw    $a3,  4($a1)\n\t"
 "sw    $t1,  8($a1)\n\t"
 "mtc0  $t2, $10\n\t"
 "sync.p\n\t"
 "bnel  $v0, $zero, 1f\n\t"
 "ei\n\t"
 "1:\n\t"
 "lw    $ra, 0($sp)\n\t"
 "sw    $t0, 12($a1)\n\t"
 "jr    $ra\n\t"
 "addiu $sp, $sp, 16\n\t"
 "SMS_EETlbAlloc:\n\t"
 "addiu $sp, $sp, -16\n\t"
 "sw    $ra, 0($sp)\n\t"
 "bgezal    $zero, _di\n\t"
 "nop\n\t"
 "mfc0  $a2, $6\n\t"
 "mfc0  $a1, $10\n\t"
 "ori   $a3, $zero, 48\n\t"
 "1:\n\t"
 "beql  $a2, $a3, 2f\n\t"
 "nor   $a2, $zero, $zero\n\t"
 "mtc0  $a2, $0\n\t"
 "sync.p\n\t"
 "tlbr\n\t"
 "sync.p\n\t"
 "mfc0  $a0, $2\n\t"
 "andi  $a0, $a0, 2\n\t"
 "beq   $a0, $zero, 3f\n\t"
 "nop\n\t"
 "beq   $zero, $zero, 1b\n\t"
 "addiu $a2, $a2, 1\n\t"
 "3:\n\t"
 "ori   $a0, $zero, 2\n\t"
 "mtc0  $a2, $0\n\t"    /* Index    */
 "mtc0  $zero, $5\n\t"  /* pageMask */
 "mtc0  $a0, $2\n\t"    /* EntryLo0 */
 "mtc0  $a0, $3\n\t"    /* EntryLo1 */
 "mtc0  $a2, $10\n\t"   /* EntryHi  */
 "sync.p\n\t"
 "tlbwi\n\t"
 "sync.p\n\t"
 "2:\n\t"
 "mtc0  $a1, $10\n\t"
 "sync.p\n\t"
 "bnel  $v0, $zero, 1f\n\t"
 "ei\n\t"
 "1:\n\t"
 "lw    $ra, 0($sp)\n\t"
 "or    $v0, $zero, $a2\n\t"
 "jr    $ra\n\t"
 "addiu $sp, $sp, 16\n\t"
 "SMS_EETlbFree:\n\t"
 "addiu $sp, $sp, -16\n\t"
 "sw    $ra, 0($sp)\n\t"
 "bgezal    $zero, _di\n\t"
 "nop\n\t"
 "mfc0  $a1, $10\n\t"
 "mtc0  $a0, $0\n\t"
 "mtc0  $zero, $2\n\t"
 "mtc0  $zero, $3\n\t"
 "mtc0  $a0, $10\n\t"
 "sync.p\n\t"
 "tlbwi\n\t"
 "sync.p\n\t"
 "mtc0  $a1, $10\n\t"
 "lw    $ra, 0($sp)\n\t"
 "sync.p\n\t"
 "bnel  $v0, $zero, 1f\n\t"
 "ei\n\t"
 "1:\n\t"
 "jr    $ra\n\t"
 "addiu $sp, $sp, 16\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

void SMS_EETlbInit ( void ) {

 int            i, lState = SMS_EEDIntr ();
 SMS_EETlbEntry lEntry;

 for ( i = 0; i < 48; ++i ) {
  SMS_EETlbGet ( i, &lEntry );
  if (  !SMS_TLB_VALID( lEntry.m_EntryLo0 )  ) break;
 }  /* end for */

 SMS_EECp0SetWired ( i );

 SMS_EEIntr ( lState );

}  /* end SMS_EETlbInit */

void* SMS_LZMA2Decompress ( SMS_LZMA2Data* apData ) {

 void* retVal = SMS_SyncMalloc ( apData -> m_Size );

 size_t lSize = lzma2_get_uncompressed_size((unsigned char *)apData -> m_pData, apData -> m_PackSize);

 if ( lSize != apData -> m_Size ) {
  free ( retVal );
  retVal = NULL;
 }

 lzma2_uncompress(	(unsigned char *)apData -> m_pData, 
							apData -> m_PackSize, 
							UNCACHED_SEG( retVal ), 
							lSize 
							);

 return retVal;

}  /* end SMS_LZMA2Decompress */

int SMS_InitVU ( volatile DMAChannel* apChan, SMS_LZMA2Data* apData ) {

 void* lpData = SMS_LZMA2Decompress ( apData );

 if ( lpData ) {
  DMA_SendChainT ( apChan, lpData );
  DMA_Wait ( apChan );
  free ( lpData );
 }  /* end if */

 return ( int )lpData;

}  /* end SMS_InitVU */
