/*
#     ___  _ _      ___
#    |    | | |    |
# ___|    |   | ___|    PS2DEV Open Source Project.
#----------------------------------------------------------
# (c) 2005-2009 Eugene Plotnikov <e-plotnikov@operamail.com>
# Licenced under Academic Free License version 2.0
# Review ps2sdk README & LICENSE files for further details.
#
*/
int SMS_TimeZone ( void );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".globl SMS_TimeZone\n\t"
 ".text\n\t"
 "SMS_TimeZone:\n\t"
 "_sms_time_zone:\n\t"
 "addiu     $sp, $sp, -32\n\t"
 "sw        $ra, 16($sp)\n\t"
 "jal       GetOsdConfigParam\n\t"
 "or        $a0, $zero, $sp\n\t"
 "lw        $v0, 0($sp)\n\t"
 "ori       $a0, $zero, 540\n\t"
 "srl       $v1, $v0, 13\n\t"
 "sra       $v0, $v0, 21\n\t"
 "andi      $v1, $v1, 7\n\t"
 "lw        $ra, 16($sp)\n\t"
 "movz      $v0, $a0, $v1\n\t"
 "jr        $ra\n\t"
 "addiu     $sp, $sp, 32\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

int SMS_SummerTime ( void );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".globl SMS_SummerTime\n\t"
 ".text\n\t"
 "SMS_SummerTime:\n\t"
 "_sms_summer_time:\n\t"
 "addiu     $sp, $sp, -32\n\t"
 "sw        $ra, 16($sp)\n\t"
 "jal       GetOsdConfigParam\n\t"
 "or        $a0, $zero, $sp\n\t"
 "lw        $v0, 0($sp)\n\t"
 "srl       $v0, $v0, 13\n\t"
 "andi      $v0, $v0, 7\n\t"
 "bnezl     $v0, 1f\n\t"
 "ori       $a0, $sp, 4\n\t"
 "beql      $zero, $zero, 2f\n\t"
 "xor       $v0, $v0, $v0\n\t"
 "1:\n\t"
 "ori       $a1, $zero, 1\n\t"
 "jal       GetOsdConfigParam2\n\t"
 "ori       $a2, $zero, 1\n\t"
 "lbu       $v1, 4($sp)\n\t"
 "srl       $v1, $v1, 4\n\t"
 "andi      $v0, $v1, 1\n\t"
 "2:\n\t"
 "lw        $ra, 16($sp)\n\t"
 "jr        $ra\n\t"
 "addiu     $sp, $sp, 32\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

int _fromBCD ( int );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_fromBCD:\n\t"
 "andi  $v0, $a0, 255\n\t"
 "srl   $v1, $v0, 4\n\t"
 "ori   $a0, $zero, 6\n\t"
 "mult  $v1, $v1, $a0\n\t"
 "subu  $v0, $v0, $v1\n\t"
 "jr    $ra\n\t"
 "andi  $v0, $v0, 255\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

void _clockFromBCD ( void* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_clockFromBCD:\n\t"
 "pcpyld    $ra, $ra, $ra\n\t"
 "or        $at, $zero, $a0\n\t"
 "bgezal    $zero, _fromBCD\n\t"
 "lbu       $a0, 7($a0)\n\t"
 "lbu       $a0, 6($at)\n\t"
 "bgezal    $zero, _fromBCD\n\t"
 "sb        $v0, 7($at)\n\t"
 "lbu       $a0, 5($at)\n\t"
 "bgezal    $zero, _fromBCD\n\t"
 "sb        $v0, 6($at)\n\t"
 "lbu       $a0, 3($at)\n\t"
 "bgezal    $zero, _fromBCD\n\t"
 "sb        $v0, 5($at)\n\t"
 "lbu       $a0, 2($at)\n\t"
 "bgezal    $zero, _fromBCD\n\t"
 "sb        $v0, 3($at)\n\t"
 "lbu       $a0, 1($at)\n\t"
 "bgezal    $zero, _fromBCD\n\t"
 "sb        $v0, 2($at)\n\t"
 "pcpyud    $ra, $ra, $ra\n\t"
 "jr        $ra\n\t"
 "sb        $v0, 1($at)\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

__asm__(
 ".section .rodata\n\t"
 ".align 3\n\t"
 "s_Const:  .word   0x1E1F1C1F, 0x1F1F1E1F, 0x1F1E1F1E\n\t"
);

void _addDate ( void* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_addDate:\n\t"
 "or    $a1, $zero, $a0\n\t"
 "addiu $sp, $sp, -16\n\t"
 "lbu   $v1, 5($a1)\n\t"
 "lui   $v0, %hi( s_Const )\n\t"
 "lbu   $a0, 7($a1)\n\t"
 "addiu $v1, $v1, 1\n\t"
 "addiu $t1, $v0, %lo( s_Const )\n\t"
 "ld    $a2, 0($t1)\n\t"
 "lw    $a3, 8($t1)\n\t"
 "sd    $a2, 0($sp)\n\t"
 "sw    $a3, 8($sp)\n\t"
 "andi  $a0, $a0, 3\n\t"
 "bnez  $a0, 1f\n\t"
 "sb    $v1, 5($a1)\n\t"
 "ori   $v0, $zero, 29\n\t"
 "sb    $v0, 1($sp)\n\t"
 "1:\n\t"
 "lbu   $v0, 6($a1)\n\t"
 "lbu   $a0, 5($a1)\n\t"
 "addu  $v0, $v0, $sp\n\t"
 "lb    $v1, -1($v0)\n\t"
 "slt   $v1, $v1, $a0\n\t"
 "beqz  $v1, 2f\n\t"
 "ori   $v0, $zero, 1\n\t"
 "lbu   $v1, 6($a1)\n\t"
 "sb    $v0, 5($a1)\n\t"
 "ori   $a0, $zero, 13\n\t"
 "addiu $v1, $v1, 1\n\t"
 "andi  $v0, $v1, 255\n\t"
 "bne   $v0, $a0, 2f\n\t"
 "sb    $v1, 6($a1)\n\t"
 "lbu   $v1, 7($a1)\n\t"
 "ori   $v0, $zero, 99\n\t"
 "bne   $v1, $v0, 3f\n\t"
 "addiu $v0, $v1, 1\n\t"
 "beq   $zero, $zero, 4f\n\t"
 "sb    $zero, 7($a1)\n\t"
 "3:\n\t"
 "sb    $v0, 7($a1)\n\t"
 "4:\n\t"
 "ori   $v0, $zero, 1\n\t"
 "sb    $v0, 6($a1)\n\t"
 "2:\n\t"
 "jr    $ra\n\t"
 "addiu $sp, $sp, 16\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

void _subDate ( void* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_subDate:\n\t"
 "or    $a1, $zero, $a0\n\t"
 "addiu $sp, $sp, -16\n\t"
 "lbu   $v1, 5($a1)\n\t"
 "lui   $v0, %hi( s_Const )\n\t"
 "lbu   $a0, 7($a1)\n\t"
 "addiu $v1, $v1, -1\n\t"
 "addiu $t1, $v0, %lo( s_Const )\n\t"
 "ld    $a2, 0($t1)\n\t"
 "lw    $a3, 8($t1)\n\t"
 "sd    $a2, 0($sp)\n\t"
 "sw    $a3, 8($sp)\n\t"
 "andi  $a0, $a0, 3\n\t"
 "bnez  $a0, 1f\n\t"
 "sb    $v1, 5($a1)\n\t"
 "ori   $v0, $zero, 29\n\t"
 "sb    $v0, 1($sp)\n\t"
 "1:\n\t"
 "lbu   $v0, 5($a1)\n\t"
 "bnez  $v0, 2f\n\t"
 "nop\n\t"
 "lbu   $v0, 6($a1)\n\t"
 "addiu $v0, $v0, -1\n\t"
 "andi  $v1, $v0, 255\n\t"
 "bnez  $v1, 3f\n\t"
 "sb    $v0, 6($a1)\n\t"
 "lbu   $v0, 7($a1)\n\t"
 "bnez  $v0, 4f\n\t"
 "addiu $v0, $v0, -1\n\t"
 "ori   $v0, $zero, 99\n\t"
 "4:\n\t"
 "sb    $v0, 7($a1)\n\t"
 "ori   $v0, $zero, 12\n\t"
 "sb    $v0, 6($a1)\n\t"
 "3:\n\t"
 "lbu   $v0, 6($a1)\n\t"
 "addu  $v0, $v0, $sp\n\t"
 "lbu   $v1, -1($v0)\n\t"
 "sb    $v1, 5($a1)\n\t"
 "2:\n\t"
 "jr    $ra\n\t"
 "addiu $sp, $sp, 16\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

void _addHour ( void* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_addHour:\n\t"
 "or    $a1, $zero, $a0\n\t"
 "ori   $v0, $zero, 24\n\t"
 "lbu   $v1, 3($a1)\n\t"
 "addiu $v1, $v1, 1\n\t"
 "andi  $a0, $v1, 255\n\t"
 "bne   $a0, $v0, 1f\n\t"
 "sb    $v1, 3($a1)\n\t"
 "or    $a0, $zero, $a1\n\t"
 "beq   $zero, $zero, _addDate\n\t"
 "sb    $zero, 3($a1)\n\t"
 "1:\n\t"
 "jr    $ra\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

void _subHour ( void* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_subHour:\n\t"
 "or    $v1, $zero, $a0\n\t"
 "lbu   $v0, 3($v1)\n\t"
 "bnez  $v0, 1f\n\t"
 "addiu $v0, $v0, -1\n\t"
 "ori   $v0, $zero, 23\n\t"
 "beq   $zero, $zero, _subDate\n\t"
 "sb    $v0, 3($v1)\n\t"
 "1:\n\t"
 "jr    $ra\n\t"
 "sb    $v0, 3($v1)\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

void _adjustTime ( void*, int );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_adjustTime:\n\t"
 "addiu     $sp, $sp, -16\n\t"
 "sw        $ra, 0($sp)\n\t"
 "or        $t2, $zero, $a0\n\t"
 "bgezal    $zero, _clockFromBCD\n\t"
 "or        $t3, $zero, $a1\n\t"
 "lbu       $v0, 2($t2)\n\t"
 "addu      $t3, $v0, $t3\n\t"
 "bltzl     $t3, 1f\n\t"
 "addiu     $t3, $t3, 60\n\t"
 "slti      $v0, $t3, 60\n\t"
 "bnezl     $v0, 2f\n\t"
 "sb        $t3, 2($t2)\n\t"
 "or        $a0, $zero, $t2\n\t"
 "nop\n\t"
 "3:\n\t"
 "bgezal    $zero, _addHour\n\t"
 "addiu     $t3, $t3, -60\n\t"
 "slti      $v0, $t3, 60\n\t"
 "beqz      $v0, 3b\n\t"
 "or        $a0, $zero, $t2\n\t"
 "beq       $zero, $zero, 4f\n\t"
 "sb        $t3, 2($t2)\n\t"
 "1:\n\t"
 "bgezal    $zero, _subHour\n\t"
 "or        $a0, $zero, $t2\n\t"
 "bltzl     $t3, 1b\n\t"
 "addiu     $t3, $t3, 60\n\t"
 "sb        $t3, 2($t2)\n\t"
 "2:\n\t"
 "or        $a0, $zero, $t2\n\t"
 "4:\n\t"
 "lw        $ra, 0($sp)\n\t"
 "jr        $ra\n\t"
 "addiu     $sp, $sp, 16\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

void SMS_LocalTime ( void* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".globl SMS_LocalTime\n\t"
 ".text\n\t"
 "SMS_LocalTime:\n\t"
 "addiu     $sp, $sp, -32\n\t"
 "sd        $s0,  0($sp)\n\t"
 "sd        $s1,  8($sp)\n\t"
 "sw        $ra, 16($sp)\n\t"
 "bgezal    $zero, _sms_time_zone\n\t"
 "or        $s0, $zero, $a0\n\t"
 "bgezal    $zero, _sms_summer_time\n\t"
 "or        $s1, $zero, $v0\n\t"
 "ori       $v1, $zero, 60\n\t"
 "or        $a0, $zero, $s0\n\t"
 "mult      $v0, $v0, $v1\n\t"
 "ld        $s0,  0($sp)\n\t"
 "lw        $ra, 16($sp)\n\t"
 "addiu     $v0, $v0, -540\n\t"
 "addu      $a1, $s1, $v0\n\t"
 "ld        $s1,  8($sp)\n\t"
 "beq       $zero, $zero, _adjustTime\n\t"
 "addiu     $sp, $sp, 32\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

int SMS_TimeFormat ( void );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".globl SMS_TimeFormat\n\t"
 ".text\n\t"
 "SMS_TimeFormat:\n\t"
 "addiu     $sp, $sp, -32\n\t"
 "sw        $ra, 16($sp)\n\t"
 "jal       GetOsdConfigParam\n\t"
 "or        $a0, $zero, $sp\n\t"
 "lw        $v0, 0($sp)\n\t"
 "srl       $v0, $v0, 13\n\t"
 "andi      $v0, $v0, 7\n\t"
 "bnez      $v0, 1f\n\t"
 "ori       $a0, $sp, 4\n\t"
 "beql      $zero, $zero, 2f\n\t"
 "xor       $v0, $v0, $v0\n\t"
 "1:\n\t"
 "ori       $a1, $zero, 1\n\t"
 "jal       GetOsdConfigParam2\n\t"
 "ori       $a2, $zero, 1\n\t"
 "lbu       $v1, 4($sp)\n\t"
 "srl       $v1, $v1, 5\n\t"
 "andi      $v0, $v1, 1\n\t"
 "2:\n\t"
 "lw        $ra, 16($sp)\n\t"
 "jr        $ra\n\t"
 "addiu     $sp, $sp, 32\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);
