/*
#     ___  _ _      ___
#    |    | | |    |
# ___|    |   | ___|    PS2DEV Open Source Project.
#----------------------------------------------------------
# Copyright (C) 2004 Gildas Bazin <gbazin@videolan.org>
# This file WAS part of dtsdec, a free DTS Coherent Acoustics stream decoder.
# See http://www.videolan.org/dtsdec.html for updates.
# Licensed (like the original dtsdec source code) under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation;
# either version 2 of the License, or (at your option) any later version.
#
# Adopded for SMS and optimized for Emotion Engine in 2007 by Eugene Plotnikov
#
*/
#include "SMS_DTS.h"
#include "SMS_Config.h"

#include <malloc.h>
#include <string.h>
#include <stdio.h>

#define BUFFER_SIZE 24576
#define HEADER_SIZE 14

#define DTS_PRIM_CHANNELS_MAX  5
#define DTS_ABITS_MAX         32
#define DTS_SUBBANDS          32
#define DTS_SUBSUBFAMES_MAX    4
#define DTS_LFE_MAX            3

#define DTS_LFE          0x80
#define DTS_CHANNEL_MASK 0x3F
#define DTS_CHANNEL_BITS 6

#define DTS_MONO    0
#define DTS_CHANNEL 1
#define DTS_STEREO  2
#define DTS_3F      5
#define DTS_2F1R    6
#define DTS_3F1R    7
#define DTS_2F2R    8
#define DTS_3F2R    9
#define DTS_4F2R    10
#define DTS_DOLBY   101

#define LEVEL_3DB     0.707107F
#define LEVEL_PLUS3DB 1.414214F
#define LEVEL_6DB     0.500000F
#define LEVEL_PLUS6DB 2.000000F

#define DTS_ADJUST_LEVEL 0x100

#define CONVERT( acmod, output ) (   (  ( output ) << DTS_CHANNEL_BITS  ) + ( acmod )   )

#define MUL_C( a, b ) (  ( a ) * ( b )  )
#define MUL_L( a, b ) (  ( a ) * ( b )  )
#define DIV( a, b )   (  ( a ) / ( b )  )
#define LEVEL( x )    ( x )

typedef struct huff_entry_s {
 unsigned char  length;
 unsigned short code;
 unsigned char  value;
} huff_entry_t;

typedef struct dts_state_t {
 float          clev;                            /*  0 */
 float          slev;                            /*  4 */
 float          level;                           /*  8 */
 float          bias;                            /* 12 */
 unsigned int*  buffer_start;                    /* 16 */
 unsigned int   current_word;                    /* 20 */
 unsigned char  bits_left;                       /* 24 */
 unsigned char  word_mode;                       /* 25 */
 unsigned char  bigendian_mode;                  /* 26 */
 unsigned char  prim_channels;                   /* 27 */
 int            dynrnge;                         /* 28 */
 float          dynrng;                          /* 32 */
 void*          dynrngdata;                      /* 36 */
 float          ( *dynrngcall )( float, void* ); /* 40 */
 int            bit_rate;                        /* 44 */
 unsigned char  current_subframe;                /* 48 */
 unsigned char  subframes;                       /* 49 */
 unsigned char  current_subsubframe;             /* 50 */
 unsigned char  subsubframes;                    /* 51 */
 unsigned char  multirate_inter;                 /* 52 */
 unsigned char  lfe;                             /* 53 */
 unsigned char  aspf;                            /* 54 */
 unsigned char  aux_data;                        /* 55 */
 unsigned char  predictor_history;               /* 56 */
 unsigned char  dynrange;                        /* 57 */
 unsigned char  downmix;                         /* 58 */
 unsigned char  timestamp;                       /* 59 */
 unsigned char  crc_present;                     /* 60 */
 unsigned char  sample_blocks;                   /* 61 */
 unsigned char  amode;                           /* 62 */
 char           output;                          /* 63 */
 float          samples             [ 3072 ];    /* 64 */
 float          lfe_data            [ 2 * DTS_SUBSUBFAMES_MAX * DTS_LFE_MAX * 2 ];
 float          subband_samples_hist[ DTS_PRIM_CHANNELS_MAX ][ 4 ][ DTS_SUBBANDS ];
 float          subband_fir_hist    [ DTS_PRIM_CHANNELS_MAX ][ 512 ];
 float          subband_fir_noidea  [ DTS_PRIM_CHANNELS_MAX ][ 64 ];
 float          scalefactor_adj     [ DTS_PRIM_CHANNELS_MAX ][ DTS_ABITS_MAX ];
 int            transition_mode     [ DTS_PRIM_CHANNELS_MAX ][ DTS_SUBBANDS ];
 int            scale_factor        [ DTS_PRIM_CHANNELS_MAX ][ DTS_SUBBANDS ][ 2 ];
 short          prediction_vq       [ DTS_PRIM_CHANNELS_MAX ][ DTS_SUBBANDS ];
 short          high_freq_vq        [ DTS_PRIM_CHANNELS_MAX ][ DTS_SUBBANDS ];
 unsigned char  subband_activity    [ DTS_PRIM_CHANNELS_MAX ];
 unsigned char  vq_start_subband    [ DTS_PRIM_CHANNELS_MAX ];
 unsigned char  joint_intensity     [ DTS_PRIM_CHANNELS_MAX ];
 unsigned char  transient_huffman   [ DTS_PRIM_CHANNELS_MAX ];
 unsigned char  scalefactor_huffman [ DTS_PRIM_CHANNELS_MAX ];
 unsigned char  bitalloc_huffman    [ DTS_PRIM_CHANNELS_MAX ];
 unsigned char  quant_index_huffman [ DTS_PRIM_CHANNELS_MAX ][ DTS_ABITS_MAX ];
 unsigned char  prediction_mode     [ DTS_PRIM_CHANNELS_MAX ][ DTS_SUBBANDS ];
 unsigned char  bitalloc            [ DTS_PRIM_CHANNELS_MAX ][ DTS_SUBBANDS ];
 unsigned char  m_InBuf             [ BUFFER_SIZE ] __attribute__(   (  aligned( 16 )  )   );
 unsigned char* m_pInBuf;
 unsigned char* m_pPos;
 int            m_Len;
 int            m_FrameSize;
 int            m_Flags;
 int            m_nChannels;
} dts_state_t;

static const int dts_sample_rates[ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000000, 0x00001F40, 0x00003E80, 0x00007D00,
 0x00000000, 0x00000000, 0x00002B11, 0x00005622,
 0x0000AC44, 0x00000000, 0x00000000, 0x00002EE0,
 0x00005DC0, 0x0000BB80, 0x00017700, 0x0002EE00
};

static const int dts_bit_rates[ 32 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00007D00, 0x0000DAC0, 0x0000FA00, 0x00017700,
 0x0001B580, 0x0001F400, 0x0002EE00, 0x00036B00,
 0x0003E800, 0x0004E200, 0x0005DC00, 0x0006D600,
 0x0007D000, 0x0008CA00, 0x0009C400, 0x000BB800,
 0x000DAC00, 0x000FA000, 0x00119400, 0x00138800,
 0x00148200, 0x00157C00, 0x00158880, 0x00167600,
 0x00177000, 0x001D4C00, 0x001F4000, 0x002EE000,
 0x003A9800, 0x00000001, 0x00000002, 0x00000003
};

static const unsigned char dts_channels[ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x04,
 0x04, 0x05, 0x06, 0x06, 0x06, 0x07, 0x08, 0x08
};

static const unsigned char dts_bits_per_sample[ 7 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x10, 0x10, 0x14, 0x14, 0x00, 0x18, 0x18
};

static const huff_entry_t bitalloc_a_12[ 13 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x01 }, { 0x02, 0x0002, 0x02 }, { 0x03, 0x0006, 0x03 }, { 0x04, 0x000E, 0x04 },
 { 0x05, 0x001E, 0x05 }, { 0x06, 0x003E, 0x06 }, { 0x08, 0x00FF, 0x07 }, { 0x08, 0x00FE, 0x08 },
 { 0x09, 0x01FB, 0x09 }, { 0x09, 0x01FA, 0x0A }, { 0x09, 0x01F9, 0x0B }, { 0x09, 0x01F8, 0x0C },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_12[ 13 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0001, 0x01 }, { 0x02, 0x0000, 0x02 }, { 0x03, 0x0002, 0x03 }, { 0x05, 0x000F, 0x04 },
 { 0x05, 0x000C, 0x05 }, { 0x06, 0x001D, 0x06 }, { 0x07, 0x0039, 0x07 }, { 0x07, 0x0038, 0x08 },
 { 0x07, 0x0037, 0x09 }, { 0x07, 0x0036, 0x0A }, { 0x07, 0x0035, 0x0B }, { 0x07, 0x0034, 0x0C },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_12[ 13 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0000, 0x01 }, { 0x03, 0x0007, 0x02 }, { 0x03, 0x0005, 0x03 }, { 0x03, 0x0004, 0x04 },
 { 0x03, 0x0002, 0x05 }, { 0x04, 0x000D, 0x06 }, { 0x04, 0x000C, 0x07 }, { 0x04, 0x0006, 0x08 },
 { 0x05, 0x000F, 0x09 }, { 0x06, 0x001D, 0x0A }, { 0x07, 0x0039, 0x0B }, { 0x07, 0x0038, 0x0C },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_d_12[ 13 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0003, 0x01 }, { 0x02, 0x0002, 0x02 }, { 0x02, 0x0000, 0x03 }, { 0x03, 0x0002, 0x04 },
 { 0x04, 0x0006, 0x05 }, { 0x05, 0x000E, 0x06 }, { 0x06, 0x001E, 0x07 }, { 0x07, 0x003E, 0x08 },
 { 0x08, 0x007E, 0x09 }, { 0x09, 0x00FE, 0x0A }, { 0x0A, 0x01FF, 0x0B }, { 0x0A, 0x01FE, 0x0C },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_e_12[ 13 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0001, 0x01 }, { 0x02, 0x0000, 0x02 }, { 0x03, 0x0002, 0x03 }, { 0x04, 0x0006, 0x04 },
 { 0x05, 0x000E, 0x05 }, { 0x07, 0x003F, 0x06 }, { 0x07, 0x003D, 0x07 }, { 0x08, 0x007C, 0x08 },
 { 0x08, 0x0079, 0x09 }, { 0x08, 0x0078, 0x0A }, { 0x09, 0x00FB, 0x0B }, { 0x09, 0x00FA, 0x0C },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t* const bitalloc_12[ 5 ] __attribute__(   (  section( ".data" )  )   ) = {
 bitalloc_a_12, bitalloc_b_12,
 bitalloc_c_12, bitalloc_d_12,
 bitalloc_e_12
};

static const huff_entry_t scales_a_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0001, 0x00 }, { 0x03, 0x0006, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x03, 0x0000, 0x02 },
 { 0x04, 0x000F, 0xFE }, { 0x04, 0x0008, 0x03 }, { 0x04, 0x0003, 0xFD }, { 0x05, 0x001C, 0x04 },
 { 0x05, 0x0013, 0xFC }, { 0x05, 0x0004, 0x05 }, { 0x06, 0x003B, 0xFB }, { 0x06, 0x0024, 0x06 },
 { 0x06, 0x000B, 0xFA }, { 0x07, 0x004B, 0x07 }, { 0x07, 0x004A, 0xF9 }, { 0x08, 0x00E9, 0x08 },
 { 0x08, 0x00E8, 0xF8 }, { 0x08, 0x0029, 0x09 }, { 0x08, 0x0028, 0xF7 }, { 0x09, 0x0057, 0x0A },
 { 0x09, 0x0056, 0xF6 }, { 0x0A, 0x03A9, 0x0B }, { 0x0A, 0x03A8, 0xF5 }, { 0x0B, 0x0755, 0x0C },
 { 0x0B, 0x0754, 0xF4 }, { 0x0B, 0x0155, 0x0D }, { 0x0B, 0x0154, 0xF3 }, { 0x0C, 0x02AE, 0x0E },
 { 0x0C, 0x02AD, 0xF2 }, { 0x0D, 0x055F, 0x0F }, { 0x0D, 0x055E, 0xF1 }, { 0x0D, 0x0559, 0x10 },
 { 0x0D, 0x0558, 0xF0 }, { 0x0D, 0x054F, 0x11 }, { 0x0D, 0x054E, 0xEF }, { 0x0D, 0x054D, 0x12 },
 { 0x0D, 0x054C, 0xEE }, { 0x0D, 0x054B, 0x13 }, { 0x0D, 0x054A, 0xED }, { 0x0D, 0x0549, 0x14 },
 { 0x0D, 0x0548, 0xEC }, { 0x0D, 0x0547, 0x15 }, { 0x0D, 0x0546, 0xEB }, { 0x0D, 0x0545, 0x16 },
 { 0x0D, 0x0544, 0xEA }, { 0x0D, 0x0543, 0x17 }, { 0x0D, 0x0542, 0xE9 }, { 0x0D, 0x0541, 0x18 },
 { 0x0D, 0x0540, 0xE8 }, { 0x0E, 0x3AFF, 0x19 }, { 0x0E, 0x3AFE, 0xE7 }, { 0x0E, 0x3AFD, 0x1A },
 { 0x0E, 0x3AFC, 0xE6 }, { 0x0E, 0x3AFB, 0x1B }, { 0x0E, 0x3AFA, 0xE5 }, { 0x0E, 0x3AF9, 0x1C },
 { 0x0E, 0x3AF8, 0xE4 }, { 0x0E, 0x3AF7, 0x1D }, { 0x0E, 0x3AF6, 0xE3 }, { 0x0E, 0x3AF5, 0x1E },
 { 0x0E, 0x3AF4, 0xE2 }, { 0x0E, 0x3AF3, 0x1F }, { 0x0E, 0x3AF2, 0xE1 }, { 0x0E, 0x3AF1, 0x20 },
 { 0x0E, 0x3AF0, 0xE0 }, { 0x0E, 0x3AEF, 0x21 }, { 0x0E, 0x3AEE, 0xDF }, { 0x0E, 0x3AED, 0x22 },
 { 0x0E, 0x3AEC, 0xDE }, { 0x0E, 0x3AEB, 0x23 }, { 0x0E, 0x3AEA, 0xDD }, { 0x0E, 0x3AE9, 0x24 },
 { 0x0E, 0x3AE8, 0xDC }, { 0x0E, 0x3AE7, 0x25 }, { 0x0E, 0x3AE6, 0xDB }, { 0x0E, 0x3AE5, 0x26 },
 { 0x0E, 0x3AE4, 0xDA }, { 0x0E, 0x3AE3, 0x27 }, { 0x0E, 0x3AE2, 0xD9 }, { 0x0E, 0x3AE1, 0x28 },
 { 0x0E, 0x3AE0, 0xD8 }, { 0x0E, 0x3ADF, 0x29 }, { 0x0E, 0x3ADE, 0xD7 }, { 0x0E, 0x3ADD, 0x2A },
 { 0x0E, 0x3ADC, 0xD6 }, { 0x0E, 0x3ADB, 0x2B }, { 0x0E, 0x3ADA, 0xD5 }, { 0x0E, 0x3AD9, 0x2C },
 { 0x0E, 0x3AD8, 0xD4 }, { 0x0E, 0x3AD7, 0x2D }, { 0x0E, 0x3AD6, 0xD3 }, { 0x0E, 0x3AD5, 0x2E },
 { 0x0E, 0x3AD4, 0xD2 }, { 0x0E, 0x3AD3, 0x2F }, { 0x0E, 0x3AD2, 0xD1 }, { 0x0E, 0x3AD1, 0x30 },
 { 0x0E, 0x3AD0, 0xD0 }, { 0x0E, 0x3ACF, 0x31 }, { 0x0E, 0x3ACE, 0xCF }, { 0x0E, 0x3ACD, 0x32 },
 { 0x0E, 0x3ACC, 0xCE }, { 0x0E, 0x3ACB, 0x33 }, { 0x0E, 0x3ACA, 0xCD }, { 0x0E, 0x3AC9, 0x34 },
 { 0x0E, 0x3AC8, 0xCC }, { 0x0E, 0x3AC7, 0x35 }, { 0x0E, 0x3AC6, 0xCB }, { 0x0E, 0x3AC5, 0x36 },
 { 0x0E, 0x3AC4, 0xCA }, { 0x0E, 0x3AC3, 0x37 }, { 0x0E, 0x3AC2, 0xC9 }, { 0x0E, 0x3AC1, 0x38 },
 { 0x0E, 0x3AC0, 0xC8 }, { 0x0E, 0x3ABF, 0x39 }, { 0x0E, 0x3ABE, 0xC7 }, { 0x0E, 0x3ABD, 0x3A },
 { 0x0E, 0x3ABC, 0xC6 }, { 0x0E, 0x3ABB, 0x3B }, { 0x0E, 0x3ABA, 0xC5 }, { 0x0E, 0x3AB9, 0x3C },
 { 0x0E, 0x3AB8, 0xC4 }, { 0x0E, 0x3AB7, 0x3D }, { 0x0E, 0x3AB6, 0xC3 }, { 0x0E, 0x3AB5, 0x3E },
 { 0x0E, 0x3AB4, 0xC2 }, { 0x0E, 0x3AB3, 0x3F }, { 0x0E, 0x3AB2, 0xC1 }, { 0x0E, 0x3AB1, 0x40 },
 { 0x0E, 0x3AB0, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t scales_b_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0003, 0x00 }, { 0x03, 0x0002, 0x01 }, { 0x03, 0x0001, 0xFF }, { 0x04, 0x000F, 0x02 },
 { 0x04, 0x000E, 0xFE }, { 0x04, 0x000C, 0x03 }, { 0x04, 0x000B, 0xFD }, { 0x04, 0x000A, 0x04 },
 { 0x04, 0x0009, 0xFC }, { 0x04, 0x0000, 0x05 }, { 0x05, 0x001B, 0xFB }, { 0x05, 0x0011, 0x06 },
 { 0x05, 0x0010, 0xFA }, { 0x06, 0x0035, 0x07 }, { 0x06, 0x0034, 0xF9 }, { 0x06, 0x0005, 0x08 },
 { 0x06, 0x0004, 0xF8 }, { 0x07, 0x000D, 0x09 }, { 0x07, 0x000C, 0xF7 }, { 0x08, 0x001D, 0x0A },
 { 0x08, 0x001C, 0xF6 }, { 0x09, 0x003C, 0x0B }, { 0x0A, 0x007F, 0xF5 }, { 0x0B, 0x00FD, 0x0C },
 { 0x0B, 0x00FC, 0xF4 }, { 0x0C, 0x01EB, 0x0D }, { 0x0C, 0x01EA, 0xF3 }, { 0x0D, 0x03D3, 0x0E },
 { 0x0D, 0x03D2, 0xF2 }, { 0x0E, 0x07A3, 0x0F }, { 0x0E, 0x07A2, 0xF1 }, { 0x0E, 0x07A1, 0x10 },
 { 0x0E, 0x07A0, 0xF0 }, { 0x0F, 0x0FBF, 0x11 }, { 0x0F, 0x0FBE, 0xEF }, { 0x0F, 0x0FBD, 0x12 },
 { 0x0F, 0x0FBC, 0xEE }, { 0x0F, 0x0FBB, 0x13 }, { 0x0F, 0x0FBA, 0xED }, { 0x0F, 0x0FB9, 0x14 },
 { 0x0F, 0x0FB8, 0xEC }, { 0x0F, 0x0FB7, 0x15 }, { 0x0F, 0x0FB6, 0xEB }, { 0x0F, 0x0FB5, 0x16 },
 { 0x0F, 0x0FB4, 0xEA }, { 0x0F, 0x0FB3, 0x17 }, { 0x0F, 0x0FB2, 0xE9 }, { 0x0F, 0x0FB1, 0x18 },
 { 0x0F, 0x0FB0, 0xE8 }, { 0x0F, 0x0FAF, 0x19 }, { 0x0F, 0x0FAE, 0xE7 }, { 0x0F, 0x0FAD, 0x1A },
 { 0x0F, 0x0FAC, 0xE6 }, { 0x0F, 0x0FAB, 0x1B }, { 0x0F, 0x0FAA, 0xE5 }, { 0x0F, 0x0FA9, 0x1C },
 { 0x0F, 0x0FA8, 0xE4 }, { 0x0F, 0x0FA7, 0x1D }, { 0x0F, 0x0FA6, 0xE3 }, { 0x0F, 0x0FA5, 0x1E },
 { 0x0F, 0x0FA4, 0xE2 }, { 0x0F, 0x0FA3, 0x1F }, { 0x0F, 0x0FA2, 0xE1 }, { 0x0F, 0x0FA1, 0x20 },
 { 0x0F, 0x0FA0, 0xE0 }, { 0x0F, 0x0F9F, 0x21 }, { 0x0F, 0x0F9E, 0xDF }, { 0x0F, 0x0F9D, 0x22 },
 { 0x0F, 0x0F9C, 0xDE }, { 0x0F, 0x0F9B, 0x23 }, { 0x0F, 0x0F9A, 0xDD }, { 0x0F, 0x0F99, 0x24 },
 { 0x0F, 0x0F98, 0xDC }, { 0x0F, 0x0F97, 0x25 }, { 0x0F, 0x0F96, 0xDB }, { 0x0F, 0x0F95, 0x26 },
 { 0x0F, 0x0F94, 0xDA }, { 0x0F, 0x0F93, 0x27 }, { 0x0F, 0x0F92, 0xD9 }, { 0x0F, 0x0F91, 0x28 },
 { 0x0F, 0x0F90, 0xD8 }, { 0x0F, 0x0F8F, 0x29 }, { 0x0F, 0x0F8E, 0xD7 }, { 0x0F, 0x0F8D, 0x2A },
 { 0x0F, 0x0F8C, 0xD6 }, { 0x0F, 0x0F8B, 0x2B }, { 0x0F, 0x0F8A, 0xD5 }, { 0x0F, 0x0F89, 0x2C },
 { 0x0F, 0x0F88, 0xD4 }, { 0x0F, 0x0F87, 0x2D }, { 0x0F, 0x0F86, 0xD3 }, { 0x0F, 0x0F85, 0x2E },
 { 0x0F, 0x0F84, 0xD2 }, { 0x0F, 0x0F83, 0x2F }, { 0x0F, 0x0F82, 0xD1 }, { 0x0F, 0x0F81, 0x30 },
 { 0x0F, 0x0F80, 0xD0 }, { 0x0F, 0x0F7F, 0x31 }, { 0x0F, 0x0F7E, 0xCF }, { 0x0F, 0x0F7D, 0x32 },
 { 0x0F, 0x0F7C, 0xCE }, { 0x0F, 0x0F7B, 0x33 }, { 0x0F, 0x0F7A, 0xCD }, { 0x0F, 0x0F79, 0x34 },
 { 0x0F, 0x0F78, 0xCC }, { 0x0F, 0x0F77, 0x35 }, { 0x0F, 0x0F76, 0xCB }, { 0x0F, 0x0F75, 0x36 },
 { 0x0F, 0x0F74, 0xCA }, { 0x0F, 0x0F73, 0x37 }, { 0x0F, 0x0F72, 0xC9 }, { 0x0F, 0x0F71, 0x38 },
 { 0x0F, 0x0F70, 0xC8 }, { 0x0F, 0x0F6F, 0x39 }, { 0x0F, 0x0F6E, 0xC7 }, { 0x0F, 0x0F6D, 0x3A },
 { 0x0F, 0x0F6C, 0xC6 }, { 0x0F, 0x0F6B, 0x3B }, { 0x0F, 0x0F6A, 0xC5 }, { 0x0F, 0x0F69, 0x3C },
 { 0x0F, 0x0F68, 0xC4 }, { 0x0F, 0x0F67, 0x3D }, { 0x0F, 0x0F66, 0xC3 }, { 0x0F, 0x0F65, 0x3E },
 { 0x0F, 0x0F64, 0xC2 }, { 0x0F, 0x0F63, 0x3F }, { 0x0F, 0x0F62, 0xC1 }, { 0x0F, 0x0F61, 0x40 },
 { 0x0F, 0x0F60, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t scales_c_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0004, 0x00 }, { 0x03, 0x0001, 0x01 }, { 0x03, 0x0000, 0xFF }, { 0x04, 0x000D, 0x02 },
 { 0x04, 0x000C, 0xFE }, { 0x04, 0x0007, 0x03 }, { 0x04, 0x0006, 0xFD }, { 0x05, 0x001F, 0x04 },
 { 0x05, 0x001E, 0xFC }, { 0x05, 0x0017, 0x05 }, { 0x05, 0x0016, 0xFB }, { 0x05, 0x000B, 0x06 },
 { 0x05, 0x000A, 0xFA }, { 0x06, 0x003B, 0x07 }, { 0x06, 0x003A, 0xF9 }, { 0x06, 0x002B, 0x08 },
 { 0x06, 0x002A, 0xF8 }, { 0x06, 0x0013, 0x09 }, { 0x06, 0x0012, 0xF7 }, { 0x07, 0x0073, 0x0A },
 { 0x07, 0x0072, 0xF6 }, { 0x07, 0x0053, 0x0B }, { 0x07, 0x0052, 0xF5 }, { 0x07, 0x0023, 0x0C },
 { 0x07, 0x0022, 0xF4 }, { 0x08, 0x00E3, 0x0D }, { 0x08, 0x00E2, 0xF3 }, { 0x08, 0x00A2, 0x0E },
 { 0x08, 0x00A1, 0xF2 }, { 0x08, 0x0042, 0x0F }, { 0x08, 0x0041, 0xF1 }, { 0x09, 0x01C2, 0x10 },
 { 0x09, 0x01C1, 0xF0 }, { 0x09, 0x0141, 0x11 }, { 0x09, 0x0140, 0xEF }, { 0x09, 0x0081, 0x12 },
 { 0x09, 0x0080, 0xEE }, { 0x0A, 0x0381, 0x13 }, { 0x0A, 0x0380, 0xED }, { 0x0A, 0x028C, 0x14 },
 { 0x0A, 0x010F, 0xEC }, { 0x0A, 0x010C, 0x15 }, { 0x0B, 0x070F, 0xEB }, { 0x0B, 0x051C, 0x16 },
 { 0x0B, 0x051B, 0xEA }, { 0x0B, 0x021C, 0x17 }, { 0x0B, 0x021B, 0xE9 }, { 0x0C, 0x0E1C, 0x18 },
 { 0x0C, 0x0E1B, 0xE8 }, { 0x0C, 0x0A35, 0x19 }, { 0x0C, 0x0A34, 0xE7 }, { 0x0C, 0x0435, 0x1A },
 { 0x0C, 0x0434, 0xE6 }, { 0x0D, 0x1C3A, 0x1B }, { 0x0D, 0x1C35, 0xE5 }, { 0x0D, 0x0877, 0x1C },
 { 0x0D, 0x0876, 0xE4 }, { 0x0D, 0x0874, 0x1D }, { 0x0E, 0x3877, 0xE3 }, { 0x0E, 0x3869, 0x1E },
 { 0x0E, 0x3868, 0xE2 }, { 0x0E, 0x10EB, 0x1F }, { 0x0E, 0x10EA, 0xE1 }, { 0x0F, 0x70ED, 0x20 },
 { 0x0F, 0x70EC, 0xE0 }, { 0x0F, 0x70CF, 0x21 }, { 0x0F, 0x70CE, 0xDF }, { 0x0F, 0x70CD, 0x22 },
 { 0x0F, 0x70CC, 0xDE }, { 0x0F, 0x70CB, 0x23 }, { 0x0F, 0x70CA, 0xDD }, { 0x0F, 0x70C9, 0x24 },
 { 0x0F, 0x70C8, 0xDC }, { 0x0F, 0x70C7, 0x25 }, { 0x0F, 0x70C6, 0xDB }, { 0x0F, 0x70C5, 0x26 },
 { 0x0F, 0x70C4, 0xDA }, { 0x0F, 0x70C3, 0x27 }, { 0x0F, 0x70C2, 0xD9 }, { 0x0F, 0x70C1, 0x28 },
 { 0x0F, 0x70C0, 0xD8 }, { 0x0F, 0x51FF, 0x29 }, { 0x0F, 0x51FE, 0xD7 }, { 0x0F, 0x51FD, 0x2A },
 { 0x0F, 0x51FC, 0xD6 }, { 0x0F, 0x51FB, 0x2B }, { 0x0F, 0x51FA, 0xD5 }, { 0x0F, 0x51F9, 0x2C },
 { 0x0F, 0x51F8, 0xD4 }, { 0x0F, 0x51F7, 0x2D }, { 0x0F, 0x51F6, 0xD3 }, { 0x0F, 0x51F5, 0x2E },
 { 0x0F, 0x51F4, 0xD2 }, { 0x0F, 0x51F3, 0x2F }, { 0x0F, 0x51F2, 0xD1 }, { 0x0F, 0x51F1, 0x30 },
 { 0x0F, 0x51F0, 0xD0 }, { 0x0F, 0x51EF, 0x31 }, { 0x0F, 0x51EE, 0xCF }, { 0x0F, 0x51ED, 0x32 },
 { 0x0F, 0x51EC, 0xCE }, { 0x0F, 0x51EB, 0x33 }, { 0x0F, 0x51EA, 0xCD }, { 0x0F, 0x51E9, 0x34 },
 { 0x0F, 0x51E8, 0xCC }, { 0x0F, 0x51E7, 0x35 }, { 0x0F, 0x51E6, 0xCB }, { 0x0F, 0x51E5, 0x36 },
 { 0x0F, 0x51E4, 0xCA }, { 0x0F, 0x51E3, 0x37 }, { 0x0F, 0x51E2, 0xC9 }, { 0x0F, 0x51E1, 0x38 },
 { 0x0F, 0x51E0, 0xC8 }, { 0x0F, 0x51DF, 0x39 }, { 0x0F, 0x51DE, 0xC7 }, { 0x0F, 0x51DD, 0x3A },
 { 0x0F, 0x51DC, 0xC6 }, { 0x0F, 0x51DB, 0x3B }, { 0x0F, 0x51DA, 0xC5 }, { 0x0F, 0x51D9, 0x3C },
 { 0x0F, 0x51D8, 0xC4 }, { 0x0F, 0x51D7, 0x3D }, { 0x0F, 0x51D6, 0xC3 }, { 0x0F, 0x51D5, 0x3E },
 { 0x0F, 0x51D4, 0xC2 }, { 0x0F, 0x51D3, 0x3F }, { 0x0F, 0x51D2, 0xC1 }, { 0x0F, 0x51D1, 0x40 },
 { 0x0F, 0x51D0, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t scales_d_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0000, 0x00 }, { 0x03, 0x0005, 0x01 }, { 0x03, 0x0004, 0xFF }, { 0x04, 0x000F, 0x02 },
 { 0x04, 0x000E, 0xFE }, { 0x04, 0x0007, 0x03 }, { 0x04, 0x0006, 0xFD }, { 0x05, 0x001A, 0x04 },
 { 0x05, 0x0019, 0xFC }, { 0x05, 0x000A, 0x05 }, { 0x05, 0x0009, 0xFB }, { 0x06, 0x0036, 0x06 },
 { 0x06, 0x0031, 0xFA }, { 0x06, 0x0016, 0x07 }, { 0x06, 0x0011, 0xF9 }, { 0x07, 0x006E, 0x08 },
 { 0x07, 0x0061, 0xF8 }, { 0x07, 0x002E, 0x09 }, { 0x07, 0x0021, 0xF7 }, { 0x08, 0x00C1, 0x0A },
 { 0x08, 0x00C0, 0xF6 }, { 0x08, 0x0041, 0x0B }, { 0x08, 0x0040, 0xF5 }, { 0x09, 0x01BC, 0x0C },
 { 0x09, 0x00BF, 0xF4 }, { 0x09, 0x00BC, 0x0D }, { 0x0A, 0x037F, 0xF3 }, { 0x0A, 0x037A, 0x0E },
 { 0x0A, 0x017D, 0xF2 }, { 0x0A, 0x017A, 0x0F }, { 0x0B, 0x06FD, 0xF1 }, { 0x0B, 0x02F9, 0x10 },
 { 0x0B, 0x02F8, 0xF0 }, { 0x0C, 0x0DF9, 0x11 }, { 0x0C, 0x0DF8, 0xEF }, { 0x0C, 0x05EF, 0x12 },
 { 0x0C, 0x05EE, 0xEE }, { 0x0C, 0x05EC, 0x13 }, { 0x0D, 0x1BEF, 0xED }, { 0x0D, 0x1BD8, 0x14 },
 { 0x0D, 0x0BDB, 0xEC }, { 0x0E, 0x37DD, 0x15 }, { 0x0E, 0x37DC, 0xEB }, { 0x0E, 0x17B5, 0x16 },
 { 0x0E, 0x17B4, 0xEA }, { 0x0F, 0x6FB7, 0x17 }, { 0x0F, 0x6FB6, 0xE9 }, { 0x0F, 0x6FB5, 0x18 },
 { 0x0F, 0x6FB4, 0xE8 }, { 0x0F, 0x6FB3, 0x19 }, { 0x0F, 0x6FB2, 0xE7 }, { 0x0F, 0x6FB1, 0x1A },
 { 0x0F, 0x6FB0, 0xE6 }, { 0x0F, 0x6FAF, 0x1B }, { 0x0F, 0x6FAE, 0xE5 }, { 0x0F, 0x6FAD, 0x1C },
 { 0x0F, 0x6FAC, 0xE4 }, { 0x0F, 0x6FAB, 0x1D }, { 0x0F, 0x6FAA, 0xE3 }, { 0x0F, 0x6FA9, 0x1E },
 { 0x0F, 0x6FA8, 0xE2 }, { 0x0F, 0x6FA7, 0x1F }, { 0x0F, 0x6FA6, 0xE1 }, { 0x0F, 0x6FA5, 0x20 },
 { 0x0F, 0x6FA4, 0xE0 }, { 0x0F, 0x6FA3, 0x21 }, { 0x0F, 0x6FA2, 0xDF }, { 0x0F, 0x6FA1, 0x22 },
 { 0x0F, 0x6FA0, 0xDE }, { 0x0F, 0x6F9F, 0x23 }, { 0x0F, 0x6F9E, 0xDD }, { 0x0F, 0x6F9D, 0x24 },
 { 0x0F, 0x6F9C, 0xDC }, { 0x0F, 0x6F9B, 0x25 }, { 0x0F, 0x6F9A, 0xDB }, { 0x0F, 0x6F99, 0x26 },
 { 0x0F, 0x6F98, 0xDA }, { 0x0F, 0x6F97, 0x27 }, { 0x0F, 0x6F96, 0xD9 }, { 0x0F, 0x6F95, 0x28 },
 { 0x0F, 0x6F94, 0xD8 }, { 0x0F, 0x6F93, 0x29 }, { 0x0F, 0x6F92, 0xD7 }, { 0x0F, 0x6F91, 0x2A },
 { 0x0F, 0x6F90, 0xD6 }, { 0x0F, 0x6F8F, 0x2B }, { 0x0F, 0x6F8E, 0xD5 }, { 0x0F, 0x6F8D, 0x2C },
 { 0x0F, 0x6F8C, 0xD4 }, { 0x0F, 0x6F8B, 0x2D }, { 0x0F, 0x6F8A, 0xD3 }, { 0x0F, 0x6F89, 0x2E },
 { 0x0F, 0x6F88, 0xD2 }, { 0x0F, 0x6F87, 0x2F }, { 0x0F, 0x6F86, 0xD1 }, { 0x0F, 0x6F85, 0x30 },
 { 0x0F, 0x6F84, 0xD0 }, { 0x0F, 0x6F83, 0x31 }, { 0x0F, 0x6F82, 0xCF }, { 0x0F, 0x6F81, 0x32 },
 { 0x0F, 0x6F80, 0xCE }, { 0x0F, 0x6F7F, 0x33 }, { 0x0F, 0x6F7E, 0xCD }, { 0x0F, 0x6F7D, 0x34 },
 { 0x0F, 0x6F7C, 0xCC }, { 0x0F, 0x6F7B, 0x35 }, { 0x0F, 0x6F7A, 0xCB }, { 0x0F, 0x6F79, 0x36 },
 { 0x0F, 0x6F78, 0xCA }, { 0x0F, 0x6F77, 0x37 }, { 0x0F, 0x6F76, 0xC9 }, { 0x0F, 0x6F75, 0x38 },
 { 0x0F, 0x6F74, 0xC8 }, { 0x0F, 0x6F73, 0x39 }, { 0x0F, 0x6F72, 0xC7 }, { 0x0F, 0x6F71, 0x3A },
 { 0x0F, 0x6F70, 0xC6 }, { 0x0F, 0x6F6F, 0x3B }, { 0x0F, 0x6F6E, 0xC5 }, { 0x0F, 0x6F6D, 0x3C },
 { 0x0F, 0x6F6C, 0xC4 }, { 0x0F, 0x6F6B, 0x3D }, { 0x0F, 0x6F6A, 0xC3 }, { 0x0F, 0x6F69, 0x3E },
 { 0x0F, 0x6F68, 0xC2 }, { 0x0F, 0x6F67, 0x3F }, { 0x0F, 0x6F66, 0xC1 }, { 0x0F, 0x6F65, 0x40 },
 { 0x0F, 0x6F64, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t scales_e_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x000E, 0x00 }, { 0x04, 0x000B, 0x01 }, { 0x04, 0x000A, 0xFF }, { 0x04, 0x0007, 0x02 },
 { 0x04, 0x0006, 0xFE }, { 0x04, 0x0003, 0x03 }, { 0x04, 0x0002, 0xFD }, { 0x05, 0x001F, 0x04 },
 { 0x05, 0x001E, 0xFC }, { 0x05, 0x0019, 0x05 }, { 0x05, 0x0018, 0xFB }, { 0x05, 0x0011, 0x06 },
 { 0x05, 0x0010, 0xFA }, { 0x05, 0x0009, 0x07 }, { 0x05, 0x0008, 0xF9 }, { 0x05, 0x0001, 0x08 },
 { 0x05, 0x0000, 0xF8 }, { 0x06, 0x0035, 0x09 }, { 0x06, 0x0034, 0xF7 }, { 0x06, 0x0025, 0x0A },
 { 0x06, 0x0024, 0xF6 }, { 0x06, 0x0015, 0x0B }, { 0x06, 0x0014, 0xF5 }, { 0x06, 0x0005, 0x0C },
 { 0x06, 0x0004, 0xF4 }, { 0x07, 0x006D, 0x0D }, { 0x07, 0x006C, 0xF3 }, { 0x07, 0x004D, 0x0E },
 { 0x07, 0x004C, 0xF2 }, { 0x07, 0x002D, 0x0F }, { 0x07, 0x002C, 0xF1 }, { 0x07, 0x000D, 0x10 },
 { 0x07, 0x000C, 0xF0 }, { 0x08, 0x00DD, 0x11 }, { 0x08, 0x00DC, 0xEF }, { 0x08, 0x009D, 0x12 },
 { 0x08, 0x009C, 0xEE }, { 0x08, 0x005D, 0x13 }, { 0x08, 0x005C, 0xED }, { 0x08, 0x001D, 0x14 },
 { 0x08, 0x001C, 0xEC }, { 0x09, 0x01BD, 0x15 }, { 0x09, 0x01BC, 0xEB }, { 0x09, 0x013D, 0x16 },
 { 0x09, 0x013C, 0xEA }, { 0x09, 0x00BD, 0x17 }, { 0x09, 0x00BC, 0xE9 }, { 0x09, 0x003D, 0x18 },
 { 0x09, 0x003C, 0xE8 }, { 0x0A, 0x037C, 0x19 }, { 0x0A, 0x027F, 0xE7 }, { 0x0A, 0x027D, 0x1A },
 { 0x0A, 0x027C, 0xE6 }, { 0x0A, 0x017D, 0x1B }, { 0x0A, 0x017C, 0xE5 }, { 0x0A, 0x007D, 0x1C },
 { 0x0A, 0x007C, 0xE4 }, { 0x0B, 0x06FC, 0x1D }, { 0x0B, 0x06FB, 0xE3 }, { 0x0B, 0x04FC, 0x1E },
 { 0x0B, 0x02FF, 0xE2 }, { 0x0B, 0x02FC, 0x1F }, { 0x0B, 0x00FF, 0xE1 }, { 0x0B, 0x00FC, 0x20 },
 { 0x0C, 0x0DFF, 0xE0 }, { 0x0C, 0x0DFB, 0x21 }, { 0x0C, 0x0DFA, 0xDF }, { 0x0C, 0x09FB, 0x22 },
 { 0x0C, 0x09FA, 0xDE }, { 0x0C, 0x05FB, 0x23 }, { 0x0C, 0x05FA, 0xDD }, { 0x0C, 0x01FB, 0x24 },
 { 0x0C, 0x01FA, 0xDC }, { 0x0D, 0x1BF8, 0x25 }, { 0x0D, 0x1BEB, 0xDB }, { 0x0D, 0x1BE8, 0x26 },
 { 0x0D, 0x0BFB, 0xDA }, { 0x0D, 0x0BF9, 0x27 }, { 0x0D, 0x0BF8, 0xD9 }, { 0x0D, 0x03F9, 0x28 },
 { 0x0D, 0x03F8, 0xD8 }, { 0x0E, 0x37FA, 0x29 }, { 0x0E, 0x37F9, 0xD7 }, { 0x0E, 0x37D3, 0x2A },
 { 0x0E, 0x37D2, 0xD6 }, { 0x0E, 0x17F4, 0x2B }, { 0x0E, 0x07F7, 0xD5 }, { 0x0E, 0x07F6, 0x2C },
 { 0x0E, 0x07F5, 0xD4 }, { 0x0F, 0x6FF7, 0x2D }, { 0x0F, 0x6FF6, 0xD3 }, { 0x0F, 0x6FA9, 0x2E },
 { 0x0F, 0x6FA8, 0xD2 }, { 0x0F, 0x2FEB, 0x2F }, { 0x0F, 0x2FEA, 0xD1 }, { 0x0F, 0x0FE9, 0x30 },
 { 0x0F, 0x0FE8, 0xD0 }, { 0x10, 0xDFE3, 0x31 }, { 0x10, 0xDFE2, 0xCF }, { 0x10, 0xDFE1, 0x32 },
 { 0x10, 0xDFE0, 0xCE }, { 0x10, 0xDFDF, 0x33 }, { 0x10, 0xDFDE, 0xCD }, { 0x10, 0xDFDD, 0x34 },
 { 0x10, 0xDFDC, 0xCC }, { 0x10, 0xDFDB, 0x35 }, { 0x10, 0xDFDA, 0xCB }, { 0x10, 0xDFD9, 0x36 },
 { 0x10, 0xDFD8, 0xCA }, { 0x10, 0xDFD7, 0x37 }, { 0x10, 0xDFD6, 0xC9 }, { 0x10, 0xDFD5, 0x38 },
 { 0x10, 0xDFD4, 0xC8 }, { 0x10, 0xDFD3, 0x39 }, { 0x10, 0xDFD2, 0xC7 }, { 0x10, 0xDFD1, 0x3A },
 { 0x10, 0xDFD0, 0xC6 }, { 0x10, 0xDFCF, 0x3B }, { 0x10, 0xDFCE, 0xC5 }, { 0x10, 0xDFCD, 0x3C },
 { 0x10, 0xDFCC, 0xC4 }, { 0x10, 0xDFCB, 0x3D }, { 0x10, 0xDFCA, 0xC3 }, { 0x10, 0xDFC9, 0x3E },
 { 0x10, 0xDFC8, 0xC2 }, { 0x10, 0xDF57, 0x3F }, { 0x10, 0xDF56, 0xC1 }, { 0x10, 0xDF55, 0x40 },
 { 0x10, 0xDF54, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t* const scales_129[ 5 ] __attribute__(   (  section( ".data" )  )   ) = {
 scales_a_129, scales_b_129,
 scales_c_129, scales_d_129,
 scales_e_129
};

static const huff_entry_t bitalloc_a_3[ 4 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x02, 0x0002, 0x01 }, { 0x02, 0x0003, 0xFF }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_4[ 5 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x02, 0x0002, 0x01 }, { 0x03, 0x0006, 0x02 }, { 0x03, 0x0007, 0x03 },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_4[ 5 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0002, 0x00 }, { 0x03, 0x0006, 0x01 }, { 0x03, 0x0007, 0x02 }, { 0x01, 0x0000, 0x03 },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_4[ 5 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0006, 0x00 }, { 0x03, 0x0007, 0x01 }, { 0x01, 0x0000, 0x02 }, { 0x02, 0x0002, 0x03 },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_d_4[ 5 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0000, 0x00 }, { 0x02, 0x0001, 0x01 }, { 0x02, 0x0002, 0x02 }, { 0x02, 0x0003, 0x03 },
 { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t* const tmode[ 4 ] __attribute__(   (  section( ".data" )  )   ) = {
 bitalloc_a_4, bitalloc_b_4,
 bitalloc_c_4, bitalloc_d_4
};

static const huff_entry_t bitalloc_a_5[ 6 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x02, 0x0002, 0x01 }, { 0x03, 0x0006, 0xFF }, { 0x04, 0x000E, 0x02 },
 { 0x04, 0x000F, 0xFE }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_5[ 6 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0002, 0x00 }, { 0x02, 0x0000, 0x01 }, { 0x02, 0x0001, 0xFF }, { 0x03, 0x0006, 0x02 },
 { 0x03, 0x0007, 0xFE }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_5[ 6 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x03, 0x0004, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x03, 0x0006, 0x02 },
 { 0x03, 0x0007, 0xFE }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_7[ 8 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x03, 0x0006, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x03, 0x0004, 0x02 },
 { 0x04, 0x000E, 0xFE }, { 0x05, 0x001F, 0x03 }, { 0x05, 0x001E, 0xFD }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_7[ 8 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0003, 0x00 }, { 0x02, 0x0001, 0x01 }, { 0x02, 0x0000, 0xFF }, { 0x03, 0x0004, 0x02 },
 { 0x04, 0x000B, 0xFE }, { 0x05, 0x0015, 0x03 }, { 0x05, 0x0014, 0xFD }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_7[ 8 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0003, 0x00 }, { 0x02, 0x0002, 0x01 }, { 0x02, 0x0001, 0xFF }, { 0x04, 0x0003, 0x02 },
 { 0x04, 0x0002, 0xFE }, { 0x04, 0x0001, 0x03 }, { 0x04, 0x0000, 0xFD }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_9[ 10 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x03, 0x0007, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x04, 0x000D, 0x02 },
 { 0x04, 0x0009, 0xFE }, { 0x04, 0x0008, 0x03 }, { 0x05, 0x0019, 0xFD }, { 0x06, 0x0031, 0x04 },
 { 0x06, 0x0030, 0xFC }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_9[ 10 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0002, 0x00 }, { 0x02, 0x0000, 0x01 }, { 0x03, 0x0007, 0xFF }, { 0x03, 0x0003, 0x02 },
 { 0x03, 0x0002, 0xFE }, { 0x05, 0x001B, 0x03 }, { 0x05, 0x001A, 0xFD }, { 0x05, 0x0019, 0x04 },
 { 0x05, 0x0018, 0xFC }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_9[ 10 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0002, 0x00 }, { 0x02, 0x0000, 0x01 }, { 0x03, 0x0007, 0xFF }, { 0x03, 0x0006, 0x02 },
 { 0x03, 0x0002, 0xFE }, { 0x04, 0x0006, 0x03 }, { 0x05, 0x000F, 0xFD }, { 0x06, 0x001D, 0x04 },
 { 0x06, 0x001C, 0xFC }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_13[ 14 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x03, 0x0004, 0x01 }, { 0x04, 0x000F, 0xFF }, { 0x04, 0x000D, 0x02 },
 { 0x04, 0x000C, 0xFE }, { 0x04, 0x000A, 0x03 }, { 0x05, 0x001D, 0xFD }, { 0x05, 0x0016, 0x04 },
 { 0x06, 0x0039, 0xFC }, { 0x06, 0x002F, 0x05 }, { 0x06, 0x002E, 0xFB }, { 0x07, 0x0071, 0x06 },
 { 0x07, 0x0070, 0xFA }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_13[ 14 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0000, 0x00 }, { 0x03, 0x0006, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x03, 0x0002, 0x02 },
 { 0x04, 0x000F, 0xFE }, { 0x04, 0x0009, 0x03 }, { 0x04, 0x0007, 0xFD }, { 0x04, 0x0006, 0x04 },
 { 0x05, 0x001D, 0xFC }, { 0x05, 0x0011, 0x05 }, { 0x05, 0x0010, 0xFB }, { 0x06, 0x0039, 0x06 },
 { 0x06, 0x0038, 0xFA }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_13[ 14 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0005, 0x00 }, { 0x03, 0x0004, 0x01 }, { 0x03, 0x0003, 0xFF }, { 0x03, 0x0002, 0x02 },
 { 0x03, 0x0000, 0xFE }, { 0x04, 0x000F, 0x03 }, { 0x04, 0x000E, 0xFD }, { 0x04, 0x000C, 0x04 },
 { 0x04, 0x0003, 0xFC }, { 0x05, 0x001B, 0x05 }, { 0x05, 0x001A, 0xFB }, { 0x05, 0x0005, 0x06 },
 { 0x05, 0x0004, 0xFA }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_17[ 18 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0001, 0x00 }, { 0x03, 0x0007, 0x01 }, { 0x03, 0x0006, 0xFF }, { 0x03, 0x0004, 0x02 },
 { 0x03, 0x0001, 0xFE }, { 0x04, 0x000B, 0x03 }, { 0x04, 0x000A, 0xFD }, { 0x04, 0x0000, 0x04 },
 { 0x05, 0x0003, 0xFC }, { 0x06, 0x0004, 0x05 }, { 0x07, 0x000B, 0xFB }, { 0x08, 0x0014, 0x06 },
 { 0x09, 0x002B, 0xFA }, { 0x0A, 0x0054, 0x07 }, { 0x0B, 0x00AB, 0xF9 }, { 0x0C, 0x0155, 0x08 },
 { 0x0C, 0x0154, 0xF8 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_17[ 18 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0000, 0x00 }, { 0x03, 0x0006, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x03, 0x0002, 0x02 },
 { 0x04, 0x000F, 0xFE }, { 0x04, 0x0009, 0x03 }, { 0x04, 0x0008, 0xFD }, { 0x05, 0x001D, 0x04 },
 { 0x05, 0x001C, 0xFC }, { 0x05, 0x000E, 0x05 }, { 0x05, 0x000D, 0xFB }, { 0x06, 0x001E, 0x06 },
 { 0x06, 0x0019, 0xFA }, { 0x06, 0x0018, 0x07 }, { 0x07, 0x003F, 0xF9 }, { 0x08, 0x007D, 0x08 },
 { 0x08, 0x007C, 0xF8 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_17[ 18 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0006, 0x00 }, { 0x03, 0x0004, 0x01 }, { 0x03, 0x0003, 0xFF }, { 0x03, 0x0000, 0x02 },
 { 0x04, 0x000F, 0xFE }, { 0x04, 0x000B, 0x03 }, { 0x04, 0x000A, 0xFD }, { 0x04, 0x0004, 0x04 },
 { 0x04, 0x0003, 0xFC }, { 0x05, 0x001D, 0x05 }, { 0x05, 0x001C, 0xFB }, { 0x05, 0x000A, 0x06 },
 { 0x05, 0x0005, 0xFA }, { 0x05, 0x0004, 0x07 }, { 0x06, 0x0017, 0xF9 }, { 0x07, 0x002D, 0x08 },
 { 0x07, 0x002C, 0xF8 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_d_17[ 18 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x03, 0x0007, 0x01 }, { 0x03, 0x0006, 0xFF }, { 0x04, 0x000B, 0x02 },
 { 0x04, 0x000A, 0xFE }, { 0x05, 0x0013, 0x03 }, { 0x05, 0x0012, 0xFD }, { 0x06, 0x0023, 0x04 },
 { 0x06, 0x0022, 0xFC }, { 0x07, 0x0043, 0x05 }, { 0x07, 0x0042, 0xFB }, { 0x08, 0x0083, 0x06 },
 { 0x08, 0x0082, 0xFA }, { 0x09, 0x0103, 0x07 }, { 0x09, 0x0102, 0xF9 }, { 0x09, 0x0101, 0x08 },
 { 0x09, 0x0100, 0xF8 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_e_17[ 18 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x01, 0x0000, 0x00 }, { 0x03, 0x0005, 0x01 }, { 0x03, 0x0004, 0xFF }, { 0x04, 0x000C, 0x02 },
 { 0x05, 0x001F, 0xFE }, { 0x05, 0x001C, 0x03 }, { 0x05, 0x001B, 0xFD }, { 0x06, 0x003C, 0x04 },
 { 0x06, 0x003B, 0xFC }, { 0x06, 0x0035, 0x05 }, { 0x06, 0x0034, 0xFB }, { 0x07, 0x007A, 0x06 },
 { 0x07, 0x0075, 0xFA }, { 0x08, 0x00F7, 0x07 }, { 0x08, 0x00F6, 0xF9 }, { 0x08, 0x00E9, 0x08 },
 { 0x08, 0x00E8, 0xF8 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_f_17[ 18 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0006, 0x00 }, { 0x03, 0x0005, 0x01 }, { 0x03, 0x0004, 0xFF }, { 0x03, 0x0002, 0x02 },
 { 0x03, 0x0001, 0xFE }, { 0x04, 0x000F, 0x03 }, { 0x04, 0x000E, 0xFD }, { 0x04, 0x0006, 0x04 },
 { 0x04, 0x0001, 0xFC }, { 0x05, 0x000E, 0x05 }, { 0x05, 0x0001, 0xFB }, { 0x06, 0x001F, 0x06 },
 { 0x06, 0x001E, 0xFA }, { 0x06, 0x0000, 0x07 }, { 0x07, 0x0003, 0xF9 }, { 0x08, 0x0005, 0x08 },
 { 0x08, 0x0004, 0xF8 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_g_17[ 18 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0002, 0x00 }, { 0x03, 0x0007, 0x01 }, { 0x03, 0x0006, 0xFF }, { 0x03, 0x0001, 0x02 },
 { 0x03, 0x0000, 0xFE }, { 0x04, 0x0005, 0x03 }, { 0x04, 0x0004, 0xFD }, { 0x05, 0x000E, 0x04 },
 { 0x05, 0x000D, 0xFC }, { 0x06, 0x001E, 0x05 }, { 0x06, 0x0019, 0xFB }, { 0x07, 0x003E, 0x06 },
 { 0x07, 0x0031, 0xFA }, { 0x08, 0x007F, 0x07 }, { 0x08, 0x007E, 0xF9 }, { 0x08, 0x0061, 0x08 },
 { 0x08, 0x0060, 0xF8 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_25[ 26 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0006, 0x00 }, { 0x03, 0x0004, 0x01 }, { 0x03, 0x0003, 0xFF }, { 0x03, 0x0001, 0x02 },
 { 0x03, 0x0000, 0xFE }, { 0x04, 0x000F, 0x03 }, { 0x04, 0x000E, 0xFD }, { 0x04, 0x0005, 0x04 },
 { 0x04, 0x0004, 0xFC }, { 0x05, 0x0016, 0x05 }, { 0x05, 0x0015, 0xFB }, { 0x06, 0x002F, 0x06 },
 { 0x06, 0x002E, 0xFA }, { 0x07, 0x0053, 0x07 }, { 0x07, 0x0052, 0xF9 }, { 0x08, 0x00A3, 0x08 },
 { 0x08, 0x00A2, 0xF8 }, { 0x08, 0x00A0, 0x09 }, { 0x09, 0x0143, 0xF7 }, { 0x0A, 0x0284, 0x0A },
 { 0x0B, 0x050B, 0xF6 }, { 0x0C, 0x0A14, 0x0B }, { 0x0D, 0x142B, 0xF5 }, { 0x0E, 0x2855, 0x0C },
 { 0x0E, 0x2854, 0xF4 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_25[ 26 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0005, 0x00 }, { 0x03, 0x0002, 0x01 }, { 0x03, 0x0001, 0xFF }, { 0x04, 0x000F, 0x02 },
 { 0x04, 0x000E, 0xFE }, { 0x04, 0x0009, 0x03 }, { 0x04, 0x0008, 0xFD }, { 0x04, 0x0006, 0x04 },
 { 0x04, 0x0001, 0xFC }, { 0x05, 0x001A, 0x05 }, { 0x05, 0x0019, 0xFB }, { 0x05, 0x000F, 0x06 },
 { 0x05, 0x000E, 0xFA }, { 0x06, 0x0037, 0x07 }, { 0x06, 0x0036, 0xF9 }, { 0x06, 0x0031, 0x08 },
 { 0x06, 0x0030, 0xF8 }, { 0x06, 0x0001, 0x09 }, { 0x06, 0x0000, 0xF7 }, { 0x07, 0x0006, 0x0A },
 { 0x07, 0x0005, 0xF6 }, { 0x07, 0x0004, 0x0B }, { 0x08, 0x000F, 0xF5 }, { 0x09, 0x001D, 0x0C },
 { 0x09, 0x001C, 0xF4 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_25[ 26 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0001, 0x00 }, { 0x04, 0x000F, 0x01 }, { 0x04, 0x000E, 0xFF }, { 0x04, 0x000C, 0x02 },
 { 0x04, 0x000B, 0xFE }, { 0x04, 0x0009, 0x03 }, { 0x04, 0x0008, 0xFD }, { 0x04, 0x0006, 0x04 },
 { 0x04, 0x0005, 0xFC }, { 0x04, 0x0001, 0x05 }, { 0x04, 0x0000, 0xFB }, { 0x05, 0x001A, 0x06 },
 { 0x05, 0x0015, 0xFA }, { 0x05, 0x000F, 0x07 }, { 0x05, 0x000E, 0xF9 }, { 0x05, 0x0008, 0x08 },
 { 0x06, 0x0037, 0xF8 }, { 0x06, 0x0029, 0x09 }, { 0x06, 0x0028, 0xF7 }, { 0x06, 0x0012, 0x0A },
 { 0x07, 0x006D, 0xF6 }, { 0x07, 0x006C, 0x0B }, { 0x07, 0x0027, 0xF5 }, { 0x08, 0x004D, 0x0C },
 { 0x08, 0x004C, 0xF4 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_d_25[ 26 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0002, 0x00 }, { 0x03, 0x0007, 0x01 }, { 0x03, 0x0006, 0xFF }, { 0x03, 0x0001, 0x02 },
 { 0x03, 0x0000, 0xFE }, { 0x04, 0x0005, 0x03 }, { 0x04, 0x0004, 0xFD }, { 0x05, 0x000D, 0x04 },
 { 0x05, 0x000C, 0xFC }, { 0x06, 0x001D, 0x05 }, { 0x06, 0x001C, 0xFB }, { 0x07, 0x003E, 0x06 },
 { 0x07, 0x003D, 0xFA }, { 0x08, 0x007E, 0x07 }, { 0x08, 0x0079, 0xF9 }, { 0x09, 0x00FF, 0x08 },
 { 0x09, 0x00FE, 0xF8 }, { 0x0A, 0x01E3, 0x09 }, { 0x0A, 0x01E2, 0xF7 }, { 0x0B, 0x03C3, 0x0A },
 { 0x0B, 0x03C2, 0xF6 }, { 0x0C, 0x0783, 0x0B }, { 0x0C, 0x0782, 0xF5 }, { 0x0C, 0x0781, 0x0C },
 { 0x0C, 0x0780, 0xF4 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_e_25[ 26 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0003, 0x00 }, { 0x03, 0x0003, 0x01 }, { 0x03, 0x0002, 0xFF }, { 0x04, 0x000B, 0x02 },
 { 0x04, 0x000A, 0xFE }, { 0x04, 0x0001, 0x03 }, { 0x04, 0x0000, 0xFD }, { 0x05, 0x0011, 0x04 },
 { 0x05, 0x0010, 0xFC }, { 0x05, 0x0005, 0x05 }, { 0x05, 0x0004, 0xFB }, { 0x06, 0x0026, 0x06 },
 { 0x06, 0x0025, 0xFA }, { 0x06, 0x000E, 0x07 }, { 0x06, 0x000D, 0xF9 }, { 0x07, 0x004F, 0x08 },
 { 0x07, 0x004E, 0xF8 }, { 0x07, 0x0048, 0x09 }, { 0x07, 0x001F, 0xF7 }, { 0x07, 0x0019, 0x0A },
 { 0x07, 0x0018, 0xF6 }, { 0x08, 0x0093, 0x0B }, { 0x08, 0x0092, 0xF5 }, { 0x08, 0x003D, 0x0C },
 { 0x08, 0x003C, 0xF4 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_f_25[ 26 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0001, 0x00 }, { 0x03, 0x0000, 0x01 }, { 0x04, 0x000F, 0xFF }, { 0x04, 0x000E, 0x02 },
 { 0x04, 0x000D, 0xFE }, { 0x04, 0x000B, 0x03 }, { 0x04, 0x000A, 0xFD }, { 0x04, 0x0008, 0x04 },
 { 0x04, 0x0007, 0xFC }, { 0x04, 0x0005, 0x05 }, { 0x04, 0x0004, 0xFB }, { 0x05, 0x0018, 0x06 },
 { 0x05, 0x0013, 0xFA }, { 0x05, 0x000D, 0x07 }, { 0x05, 0x000C, 0xF9 }, { 0x06, 0x0025, 0x08 },
 { 0x06, 0x0024, 0xF8 }, { 0x07, 0x0066, 0x09 }, { 0x07, 0x0065, 0xF7 }, { 0x08, 0x00CF, 0x0A },
 { 0x08, 0x00CE, 0xF6 }, { 0x08, 0x00C8, 0x0B }, { 0x09, 0x0193, 0xF5 }, { 0x0A, 0x0325, 0x0C },
 { 0x0A, 0x0324, 0xF4 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_g_25[ 26 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0001, 0x00 }, { 0x03, 0x0006, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x03, 0x0000, 0x02 },
 { 0x04, 0x000F, 0xFE }, { 0x04, 0x0008, 0x03 }, { 0x04, 0x0003, 0xFD }, { 0x05, 0x001C, 0x04 },
 { 0x05, 0x0013, 0xFC }, { 0x05, 0x0004, 0x05 }, { 0x06, 0x003B, 0xFB }, { 0x06, 0x0024, 0x06 },
 { 0x06, 0x000B, 0xFA }, { 0x07, 0x0074, 0x07 }, { 0x07, 0x004B, 0xF9 }, { 0x07, 0x0015, 0x08 },
 { 0x07, 0x0014, 0xF8 }, { 0x08, 0x0095, 0x09 }, { 0x08, 0x0094, 0xF7 }, { 0x09, 0x01D6, 0x0A },
 { 0x09, 0x01D5, 0xF6 }, { 0x0A, 0x03AF, 0x0B }, { 0x0A, 0x03AE, 0xF5 }, { 0x0A, 0x03A9, 0x0C },
 { 0x0A, 0x03A8, 0xF4 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_33[ 34 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0002, 0x00 }, { 0x03, 0x0001, 0x01 }, { 0x03, 0x0000, 0xFF }, { 0x04, 0x000E, 0x02 },
 { 0x04, 0x000D, 0xFE }, { 0x04, 0x000C, 0x03 }, { 0x04, 0x000B, 0xFD }, { 0x04, 0x0009, 0x04 },
 { 0x04, 0x0008, 0xFC }, { 0x04, 0x0006, 0x05 }, { 0x05, 0x001F, 0xFB }, { 0x05, 0x0014, 0x06 },
 { 0x05, 0x000F, 0xFA }, { 0x06, 0x003D, 0x07 }, { 0x06, 0x003C, 0xF9 }, { 0x06, 0x001D, 0x08 },
 { 0x06, 0x001C, 0xF8 }, { 0x07, 0x0055, 0x09 }, { 0x07, 0x0054, 0xF7 }, { 0x08, 0x00AE, 0x0A },
 { 0x08, 0x00AD, 0xF6 }, { 0x09, 0x015F, 0x0B }, { 0x09, 0x015E, 0xF5 }, { 0x0A, 0x02B3, 0x0C },
 { 0x0A, 0x02B2, 0xF4 }, { 0x0B, 0x0563, 0x0D }, { 0x0B, 0x0562, 0xF3 }, { 0x0C, 0x0AC3, 0x0E },
 { 0x0C, 0x0AC2, 0xF2 }, { 0x0D, 0x1583, 0x0F }, { 0x0D, 0x1582, 0xF1 }, { 0x0D, 0x1581, 0x10 },
 { 0x0D, 0x1580, 0xF0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_33[ 34 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0001, 0x00 }, { 0x04, 0x000F, 0x01 }, { 0x04, 0x000E, 0xFF }, { 0x04, 0x000B, 0x02 },
 { 0x04, 0x000A, 0xFE }, { 0x04, 0x0008, 0x03 }, { 0x04, 0x0007, 0xFD }, { 0x04, 0x0004, 0x04 },
 { 0x04, 0x0001, 0xFC }, { 0x05, 0x001B, 0x05 }, { 0x05, 0x001A, 0xFB }, { 0x05, 0x0013, 0x06 },
 { 0x05, 0x0012, 0xFA }, { 0x05, 0x000C, 0x07 }, { 0x05, 0x000B, 0xF9 }, { 0x05, 0x0001, 0x08 },
 { 0x05, 0x0000, 0xF8 }, { 0x06, 0x0032, 0x09 }, { 0x06, 0x0031, 0xF7 }, { 0x06, 0x001A, 0x0A },
 { 0x06, 0x0015, 0xF6 }, { 0x07, 0x0067, 0x0B }, { 0x07, 0x0066, 0xF5 }, { 0x07, 0x0060, 0x0C },
 { 0x07, 0x0037, 0xF4 }, { 0x07, 0x0029, 0x0D }, { 0x07, 0x0028, 0xF3 }, { 0x08, 0x00C2, 0x0E },
 { 0x08, 0x006D, 0xF2 }, { 0x08, 0x006C, 0x0F }, { 0x09, 0x0187, 0xF1 }, { 0x0A, 0x030D, 0x10 },
 { 0x0A, 0x030C, 0xF0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_33[ 34 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x000D, 0x00 }, { 0x04, 0x000B, 0x01 }, { 0x04, 0x000A, 0xFF }, { 0x04, 0x0008, 0x02 },
 { 0x04, 0x0007, 0xFE }, { 0x04, 0x0004, 0x03 }, { 0x04, 0x0003, 0xFD }, { 0x04, 0x0002, 0x04 },
 { 0x04, 0x0001, 0xFC }, { 0x05, 0x001E, 0x05 }, { 0x05, 0x001D, 0xFB }, { 0x05, 0x0019, 0x06 },
 { 0x05, 0x0018, 0xFA }, { 0x05, 0x0013, 0x07 }, { 0x05, 0x0012, 0xF9 }, { 0x05, 0x000B, 0x08 },
 { 0x05, 0x000A, 0xF8 }, { 0x05, 0x0000, 0x09 }, { 0x06, 0x003F, 0xF7 }, { 0x06, 0x003E, 0x0A },
 { 0x06, 0x0039, 0xF6 }, { 0x06, 0x001B, 0x0B }, { 0x06, 0x001A, 0xF5 }, { 0x06, 0x0018, 0x0C },
 { 0x06, 0x0003, 0xF4 }, { 0x07, 0x0071, 0x0D }, { 0x07, 0x0070, 0xF3 }, { 0x07, 0x0032, 0x0E },
 { 0x07, 0x0005, 0xF2 }, { 0x07, 0x0004, 0x0F }, { 0x08, 0x0067, 0xF1 }, { 0x09, 0x00CD, 0x10 },
 { 0x09, 0x00CC, 0xF0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_d_33[ 34 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0001, 0x00 }, { 0x03, 0x0006, 0x01 }, { 0x03, 0x0005, 0xFF }, { 0x03, 0x0000, 0x02 },
 { 0x04, 0x000F, 0xFE }, { 0x04, 0x0008, 0x03 }, { 0x04, 0x0003, 0xFD }, { 0x05, 0x001C, 0x04 },
 { 0x05, 0x0013, 0xFC }, { 0x05, 0x0004, 0x05 }, { 0x06, 0x003B, 0xFB }, { 0x06, 0x0024, 0x06 },
 { 0x06, 0x000B, 0xFA }, { 0x07, 0x0074, 0x07 }, { 0x07, 0x004B, 0xF9 }, { 0x07, 0x0015, 0x08 },
 { 0x07, 0x0014, 0xF8 }, { 0x08, 0x0095, 0x09 }, { 0x08, 0x0094, 0xF7 }, { 0x09, 0x01D5, 0x0A },
 { 0x09, 0x01D4, 0xF6 }, { 0x0A, 0x03AD, 0x0B }, { 0x0A, 0x03AC, 0xF5 }, { 0x0B, 0x075D, 0x0C },
 { 0x0B, 0x075C, 0xF4 }, { 0x0C, 0x0EBD, 0x0D }, { 0x0C, 0x0EBC, 0xF3 }, { 0x0D, 0x1D7F, 0x0E },
 { 0x0D, 0x1D7E, 0xF2 }, { 0x0E, 0x3AFB, 0x0F }, { 0x0E, 0x3AFA, 0xF1 }, { 0x0E, 0x3AF9, 0x10 },
 { 0x0E, 0x3AF8, 0xF0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_e_33[ 34 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x02, 0x0002, 0x00 }, { 0x03, 0x0002, 0x01 }, { 0x03, 0x0001, 0xFF }, { 0x04, 0x000C, 0x02 },
 { 0x04, 0x0007, 0xFE }, { 0x04, 0x0000, 0x03 }, { 0x05, 0x001F, 0xFD }, { 0x05, 0x001B, 0x04 },
 { 0x05, 0x001A, 0xFC }, { 0x05, 0x0003, 0x05 }, { 0x05, 0x0002, 0xFB }, { 0x06, 0x003B, 0x06 },
 { 0x06, 0x003A, 0xFA }, { 0x06, 0x001B, 0x07 }, { 0x06, 0x001A, 0xF9 }, { 0x07, 0x007B, 0x08 },
 { 0x07, 0x007A, 0xF8 }, { 0x07, 0x0078, 0x09 }, { 0x07, 0x0073, 0xF7 }, { 0x07, 0x0070, 0x0A },
 { 0x07, 0x0033, 0xF6 }, { 0x07, 0x0031, 0x0B }, { 0x07, 0x0030, 0xF5 }, { 0x08, 0x00F2, 0x0C },
 { 0x08, 0x00E5, 0xF4 }, { 0x08, 0x00E3, 0x0D }, { 0x08, 0x00E2, 0xF3 }, { 0x08, 0x0065, 0x0E },
 { 0x08, 0x0064, 0xF2 }, { 0x09, 0x01E7, 0x0F }, { 0x09, 0x01E6, 0xF1 }, { 0x09, 0x01C9, 0x10 },
 { 0x09, 0x01C8, 0xF0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_f_33[ 34 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x000D, 0x00 }, { 0x04, 0x000C, 0x01 }, { 0x04, 0x000B, 0xFF }, { 0x04, 0x0009, 0x02 },
 { 0x04, 0x0008, 0xFE }, { 0x04, 0x0007, 0x03 }, { 0x04, 0x0006, 0xFD }, { 0x04, 0x0004, 0x04 },
 { 0x04, 0x0003, 0xFC }, { 0x04, 0x0001, 0x05 }, { 0x04, 0x0000, 0xFB }, { 0x05, 0x001E, 0x06 },
 { 0x05, 0x001D, 0xFA }, { 0x05, 0x0015, 0x07 }, { 0x05, 0x0014, 0xF9 }, { 0x05, 0x000A, 0x08 },
 { 0x05, 0x0005, 0xF8 }, { 0x06, 0x003F, 0x09 }, { 0x06, 0x003E, 0xF7 }, { 0x06, 0x0038, 0x0A },
 { 0x06, 0x0017, 0xF6 }, { 0x06, 0x0009, 0x0B }, { 0x06, 0x0008, 0xF5 }, { 0x07, 0x002D, 0x0C },
 { 0x07, 0x002C, 0xF4 }, { 0x08, 0x00E6, 0x0D }, { 0x08, 0x00E5, 0xF3 }, { 0x09, 0x01CF, 0x0E },
 { 0x09, 0x01CE, 0xF2 }, { 0x09, 0x01C8, 0x0F }, { 0x0A, 0x0393, 0xF1 }, { 0x0B, 0x0725, 0x10 },
 { 0x0B, 0x0724, 0xF0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_g_33[ 34 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0006, 0x00 }, { 0x03, 0x0003, 0x01 }, { 0x03, 0x0002, 0xFF }, { 0x04, 0x000F, 0x02 },
 { 0x04, 0x000E, 0xFE }, { 0x04, 0x0009, 0x03 }, { 0x04, 0x0008, 0xFD }, { 0x04, 0x0001, 0x04 },
 { 0x04, 0x0000, 0xFC }, { 0x05, 0x0016, 0x05 }, { 0x05, 0x0015, 0xFB }, { 0x05, 0x0006, 0x06 },
 { 0x05, 0x0005, 0xFA }, { 0x06, 0x002E, 0x07 }, { 0x06, 0x0029, 0xF9 }, { 0x06, 0x000E, 0x08 },
 { 0x06, 0x0009, 0xF8 }, { 0x07, 0x005E, 0x09 }, { 0x07, 0x0051, 0xF7 }, { 0x07, 0x001E, 0x0A },
 { 0x07, 0x0011, 0xF6 }, { 0x08, 0x00BF, 0x0B }, { 0x08, 0x00BE, 0xF5 }, { 0x08, 0x003F, 0x0C },
 { 0x08, 0x003E, 0xF4 }, { 0x08, 0x0020, 0x0D }, { 0x09, 0x0143, 0xF3 }, { 0x09, 0x0141, 0x0E },
 { 0x09, 0x0140, 0xF2 }, { 0x09, 0x0043, 0x0F }, { 0x09, 0x0042, 0xF1 }, { 0x0A, 0x0285, 0x10 },
 { 0x0A, 0x0284, 0xF0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_65[ 66 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x0006, 0x00 }, { 0x04, 0x0005, 0x01 }, { 0x04, 0x0004, 0xFF }, { 0x04, 0x0002, 0x02 },
 { 0x04, 0x0001, 0xFE }, { 0x04, 0x0000, 0x03 }, { 0x05, 0x001F, 0xFD }, { 0x05, 0x001D, 0x04 },
 { 0x05, 0x001C, 0xFC }, { 0x05, 0x001B, 0x05 }, { 0x05, 0x001A, 0xFB }, { 0x05, 0x0018, 0x06 },
 { 0x05, 0x0017, 0xFA }, { 0x05, 0x0015, 0x07 }, { 0x05, 0x0014, 0xF9 }, { 0x05, 0x0012, 0x08 },
 { 0x05, 0x0011, 0xF8 }, { 0x05, 0x000E, 0x09 }, { 0x05, 0x0007, 0xF7 }, { 0x05, 0x0006, 0x0A },
 { 0x06, 0x003D, 0xF6 }, { 0x06, 0x0032, 0x0B }, { 0x06, 0x002D, 0xF5 }, { 0x06, 0x0026, 0x0C },
 { 0x06, 0x0021, 0xF4 }, { 0x06, 0x001F, 0x0D }, { 0x06, 0x001E, 0xF3 }, { 0x07, 0x0078, 0x0E },
 { 0x07, 0x0067, 0xF2 }, { 0x07, 0x0059, 0x0F }, { 0x07, 0x0058, 0xF1 }, { 0x07, 0x0041, 0x10 },
 { 0x07, 0x0040, 0xF0 }, { 0x08, 0x00CD, 0x11 }, { 0x08, 0x00CC, 0xEF }, { 0x08, 0x009D, 0x12 },
 { 0x08, 0x009C, 0xEE }, { 0x09, 0x01E6, 0x13 }, { 0x09, 0x01E5, 0xED }, { 0x09, 0x013E, 0x14 },
 { 0x09, 0x013D, 0xEC }, { 0x0A, 0x03CF, 0x15 }, { 0x0A, 0x03CE, 0xEB }, { 0x0A, 0x027F, 0x16 },
 { 0x0A, 0x027E, 0xEA }, { 0x0B, 0x0793, 0x17 }, { 0x0B, 0x0792, 0xE9 }, { 0x0B, 0x0790, 0x18 },
 { 0x0B, 0x04F3, 0xE8 }, { 0x0B, 0x04F0, 0x19 }, { 0x0C, 0x0F23, 0xE7 }, { 0x0C, 0x09E4, 0x1A },
 { 0x0C, 0x09E3, 0xE6 }, { 0x0D, 0x1E45, 0x1B }, { 0x0D, 0x1E44, 0xE5 }, { 0x0D, 0x13C5, 0x1C },
 { 0x0D, 0x13C4, 0xE4 }, { 0x0E, 0x2795, 0x1D }, { 0x0E, 0x2794, 0xE3 }, { 0x0F, 0x4F2D, 0x1E },
 { 0x0F, 0x4F2C, 0xE2 }, { 0x10, 0x9E5F, 0x1F }, { 0x10, 0x9E5E, 0xE1 }, { 0x10, 0x9E5D, 0x20 },
 { 0x10, 0x9E5C, 0xE0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_65[ 66 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x0004, 0x00 }, { 0x04, 0x0002, 0x01 }, { 0x04, 0x0001, 0xFF }, { 0x05, 0x001E, 0x02 },
 { 0x05, 0x001D, 0xFE }, { 0x05, 0x001A, 0x03 }, { 0x05, 0x0019, 0xFD }, { 0x05, 0x0017, 0x04 },
 { 0x05, 0x0016, 0xFC }, { 0x05, 0x0013, 0x05 }, { 0x05, 0x0012, 0xFB }, { 0x05, 0x0010, 0x06 },
 { 0x05, 0x000F, 0xFA }, { 0x05, 0x000C, 0x07 }, { 0x05, 0x000B, 0xF9 }, { 0x05, 0x0007, 0x08 },
 { 0x05, 0x0006, 0xF8 }, { 0x06, 0x003F, 0x09 }, { 0x06, 0x003E, 0xF7 }, { 0x06, 0x0038, 0x0A },
 { 0x06, 0x0037, 0xF6 }, { 0x06, 0x0031, 0x0B }, { 0x06, 0x0030, 0xF5 }, { 0x06, 0x0029, 0x0C },
 { 0x06, 0x0028, 0xF4 }, { 0x06, 0x0022, 0x0D }, { 0x06, 0x001D, 0xF3 }, { 0x06, 0x001A, 0x0E },
 { 0x06, 0x0015, 0xF2 }, { 0x06, 0x0014, 0x0F }, { 0x06, 0x0003, 0xF1 }, { 0x06, 0x0000, 0x10 },
 { 0x07, 0x0073, 0xF0 }, { 0x07, 0x006D, 0x11 }, { 0x07, 0x006C, 0xEF }, { 0x07, 0x0056, 0x12 },
 { 0x07, 0x0055, 0xEE }, { 0x07, 0x0046, 0x13 }, { 0x07, 0x0039, 0xED }, { 0x07, 0x0038, 0x14 },
 { 0x07, 0x0037, 0xEC }, { 0x07, 0x0004, 0x15 }, { 0x07, 0x0003, 0xEB }, { 0x08, 0x00E5, 0x16 },
 { 0x08, 0x00E4, 0xEA }, { 0x08, 0x00AF, 0x17 }, { 0x08, 0x00AE, 0xE9 }, { 0x08, 0x008F, 0x18 },
 { 0x08, 0x008E, 0xE8 }, { 0x08, 0x006C, 0x19 }, { 0x08, 0x000B, 0xE7 }, { 0x08, 0x000A, 0x1A },
 { 0x08, 0x0005, 0xE6 }, { 0x09, 0x0153, 0x1B }, { 0x09, 0x0152, 0xE5 }, { 0x09, 0x0150, 0x1C },
 { 0x09, 0x00DB, 0xE4 }, { 0x09, 0x0009, 0x1D }, { 0x09, 0x0008, 0xE3 }, { 0x0A, 0x02A2, 0x1E },
 { 0x0A, 0x01B5, 0xE2 }, { 0x0A, 0x01B4, 0x1F }, { 0x0B, 0x0547, 0xE1 }, { 0x0C, 0x0A8D, 0x20 },
 { 0x0C, 0x0A8C, 0xE0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_65[ 66 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x05, 0x001C, 0x00 }, { 0x05, 0x0019, 0x01 }, { 0x05, 0x0018, 0xFF }, { 0x05, 0x0017, 0x02 },
 { 0x05, 0x0016, 0xFE }, { 0x05, 0x0013, 0x03 }, { 0x05, 0x0012, 0xFD }, { 0x05, 0x0010, 0x04 },
 { 0x05, 0x000F, 0xFC }, { 0x05, 0x000D, 0x05 }, { 0x05, 0x000C, 0xFB }, { 0x05, 0x000A, 0x06 },
 { 0x05, 0x0009, 0xFA }, { 0x05, 0x0007, 0x07 }, { 0x05, 0x0006, 0xF9 }, { 0x05, 0x0004, 0x08 },
 { 0x05, 0x0003, 0xF8 }, { 0x05, 0x0001, 0x09 }, { 0x05, 0x0000, 0xF7 }, { 0x06, 0x003E, 0x0A },
 { 0x06, 0x003D, 0xF6 }, { 0x06, 0x003B, 0x0B }, { 0x06, 0x003A, 0xF5 }, { 0x06, 0x0036, 0x0C },
 { 0x06, 0x0035, 0xF4 }, { 0x06, 0x002B, 0x0D }, { 0x06, 0x002A, 0xF3 }, { 0x06, 0x0028, 0x0E },
 { 0x06, 0x0023, 0xF2 }, { 0x06, 0x001D, 0x0F }, { 0x06, 0x001C, 0xF1 }, { 0x06, 0x0011, 0x10 },
 { 0x06, 0x0010, 0xF0 }, { 0x06, 0x000B, 0x11 }, { 0x06, 0x000A, 0xEF }, { 0x06, 0x0004, 0x12 },
 { 0x07, 0x007F, 0xEE }, { 0x07, 0x0079, 0x13 }, { 0x07, 0x0078, 0xED }, { 0x07, 0x006E, 0x14 },
 { 0x07, 0x0069, 0xEC }, { 0x07, 0x0053, 0x15 }, { 0x07, 0x0052, 0xEB }, { 0x07, 0x0044, 0x16 },
 { 0x07, 0x002F, 0xEA }, { 0x07, 0x002E, 0x17 }, { 0x07, 0x002D, 0xE9 }, { 0x07, 0x000B, 0x18 },
 { 0x07, 0x000A, 0xE8 }, { 0x08, 0x00FC, 0x19 }, { 0x08, 0x00DF, 0xE7 }, { 0x08, 0x00D1, 0x1A },
 { 0x08, 0x00D0, 0xE6 }, { 0x08, 0x008A, 0x1B }, { 0x08, 0x0059, 0xE5 }, { 0x08, 0x0058, 0x1C },
 { 0x09, 0x01FB, 0xE4 }, { 0x09, 0x01BD, 0x1D }, { 0x09, 0x01BC, 0xE3 }, { 0x09, 0x0116, 0x1E },
 { 0x0A, 0x03F5, 0xE2 }, { 0x0A, 0x03F4, 0x1F }, { 0x0A, 0x022F, 0xE1 }, { 0x0B, 0x045D, 0x20 },
 { 0x0B, 0x045C, 0xE0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_d_65[ 66 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0004, 0x00 }, { 0x03, 0x0001, 0x01 }, { 0x03, 0x0000, 0xFF }, { 0x04, 0x000D, 0x02 },
 { 0x04, 0x000C, 0xFE }, { 0x04, 0x0007, 0x03 }, { 0x04, 0x0006, 0xFD }, { 0x05, 0x001F, 0x04 },
 { 0x05, 0x001E, 0xFC }, { 0x05, 0x0017, 0x05 }, { 0x05, 0x0016, 0xFB }, { 0x05, 0x000B, 0x06 },
 { 0x05, 0x000A, 0xFA }, { 0x06, 0x003B, 0x07 }, { 0x06, 0x003A, 0xF9 }, { 0x06, 0x002B, 0x08 },
 { 0x06, 0x002A, 0xF8 }, { 0x06, 0x0013, 0x09 }, { 0x06, 0x0012, 0xF7 }, { 0x07, 0x0073, 0x0A },
 { 0x07, 0x0072, 0xF6 }, { 0x07, 0x0053, 0x0B }, { 0x07, 0x0052, 0xF5 }, { 0x07, 0x0023, 0x0C },
 { 0x07, 0x0022, 0xF4 }, { 0x08, 0x00E3, 0x0D }, { 0x08, 0x00E2, 0xF3 }, { 0x08, 0x00A3, 0x0E },
 { 0x08, 0x00A2, 0xF2 }, { 0x08, 0x00A0, 0x0F }, { 0x08, 0x0043, 0xF1 }, { 0x08, 0x0040, 0x10 },
 { 0x09, 0x01C3, 0xF0 }, { 0x09, 0x01C0, 0x11 }, { 0x09, 0x0143, 0xEF }, { 0x09, 0x0084, 0x12 },
 { 0x09, 0x0083, 0xEE }, { 0x0A, 0x0384, 0x13 }, { 0x0A, 0x0383, 0xED }, { 0x0A, 0x0284, 0x14 },
 { 0x0A, 0x010B, 0xEC }, { 0x0A, 0x0105, 0x15 }, { 0x0A, 0x0104, 0xEB }, { 0x0B, 0x0705, 0x16 },
 { 0x0B, 0x0704, 0xEA }, { 0x0B, 0x0215, 0x17 }, { 0x0B, 0x0214, 0xE9 }, { 0x0C, 0x0E15, 0x18 },
 { 0x0C, 0x0E14, 0xE8 }, { 0x0C, 0x0A16, 0x19 }, { 0x0C, 0x0A15, 0xE7 }, { 0x0D, 0x1C2F, 0x1A },
 { 0x0D, 0x1C2E, 0xE6 }, { 0x0D, 0x142F, 0x1B }, { 0x0D, 0x142E, 0xE5 }, { 0x0D, 0x1428, 0x1C },
 { 0x0E, 0x385B, 0xE4 }, { 0x0E, 0x2853, 0x1D }, { 0x0E, 0x2852, 0xE3 }, { 0x0F, 0x70B5, 0x1E },
 { 0x0F, 0x70B4, 0xE2 }, { 0x0F, 0x70B3, 0x1F }, { 0x0F, 0x70B2, 0xE1 }, { 0x0F, 0x70B1, 0x20 },
 { 0x0F, 0x70B0, 0xE0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_e_65[ 66 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0004, 0x00 }, { 0x03, 0x0000, 0x01 }, { 0x04, 0x000F, 0xFF }, { 0x04, 0x0007, 0x02 },
 { 0x04, 0x0006, 0xFE }, { 0x05, 0x001D, 0x03 }, { 0x05, 0x001C, 0xFD }, { 0x05, 0x0017, 0x04 },
 { 0x05, 0x0016, 0xFC }, { 0x05, 0x000A, 0x05 }, { 0x05, 0x0009, 0xFB }, { 0x05, 0x0006, 0x06 },
 { 0x05, 0x0005, 0xFA }, { 0x06, 0x0036, 0x07 }, { 0x06, 0x0035, 0xF9 }, { 0x06, 0x0030, 0x08 },
 { 0x06, 0x002B, 0xF8 }, { 0x06, 0x0028, 0x09 }, { 0x06, 0x0017, 0xF7 }, { 0x06, 0x0010, 0x0A },
 { 0x06, 0x000F, 0xF6 }, { 0x06, 0x0009, 0x0B }, { 0x06, 0x0008, 0xF5 }, { 0x07, 0x0069, 0x0C },
 { 0x07, 0x0068, 0xF4 }, { 0x07, 0x0064, 0x0D }, { 0x07, 0x0063, 0xF3 }, { 0x07, 0x0054, 0x0E },
 { 0x07, 0x0053, 0xF2 }, { 0x07, 0x002D, 0x0F }, { 0x07, 0x002C, 0xF1 }, { 0x07, 0x001D, 0x10 },
 { 0x07, 0x001C, 0xF0 }, { 0x08, 0x00DD, 0x11 }, { 0x08, 0x00DC, 0xEF }, { 0x08, 0x00CE, 0x12 },
 { 0x08, 0x00CD, 0xEE }, { 0x08, 0x00CA, 0x13 }, { 0x08, 0x00C5, 0xED }, { 0x08, 0x00AB, 0x14 },
 { 0x08, 0x00AA, 0xEC }, { 0x08, 0x00A4, 0x15 }, { 0x08, 0x0047, 0xEB }, { 0x08, 0x0045, 0x16 },
 { 0x08, 0x0044, 0xEA }, { 0x09, 0x01BE, 0x17 }, { 0x09, 0x01BD, 0xE9 }, { 0x09, 0x019F, 0x18 },
 { 0x09, 0x019E, 0xE8 }, { 0x09, 0x0198, 0x19 }, { 0x09, 0x0197, 0xE7 }, { 0x09, 0x0189, 0x1A },
 { 0x09, 0x0188, 0xE6 }, { 0x09, 0x014B, 0x1B }, { 0x09, 0x014A, 0xE5 }, { 0x09, 0x008D, 0x1C },
 { 0x09, 0x008C, 0xE4 }, { 0x0A, 0x037F, 0x1D }, { 0x0A, 0x037E, 0xE3 }, { 0x0A, 0x0379, 0x1E },
 { 0x0A, 0x0378, 0xE2 }, { 0x0A, 0x0333, 0x1F }, { 0x0A, 0x0332, 0xE1 }, { 0x0A, 0x032D, 0x20 },
 { 0x0A, 0x032C, 0xE0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_f_65[ 66 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x03, 0x0006, 0x00 }, { 0x03, 0x0003, 0x01 }, { 0x03, 0x0002, 0xFF }, { 0x04, 0x000F, 0x02 },
 { 0x04, 0x000E, 0xFE }, { 0x04, 0x0009, 0x03 }, { 0x04, 0x0008, 0xFD }, { 0x04, 0x0001, 0x04 },
 { 0x04, 0x0000, 0xFC }, { 0x05, 0x0015, 0x05 }, { 0x05, 0x0014, 0xFB }, { 0x05, 0x0005, 0x06 },
 { 0x05, 0x0004, 0xFA }, { 0x06, 0x002D, 0x07 }, { 0x06, 0x002C, 0xF9 }, { 0x06, 0x000D, 0x08 },
 { 0x06, 0x000C, 0xF8 }, { 0x07, 0x005D, 0x09 }, { 0x07, 0x005C, 0xF7 }, { 0x07, 0x001D, 0x0A },
 { 0x07, 0x001C, 0xF6 }, { 0x08, 0x00BD, 0x0B }, { 0x08, 0x00BC, 0xF5 }, { 0x08, 0x003D, 0x0C },
 { 0x08, 0x003C, 0xF4 }, { 0x09, 0x017D, 0x0D }, { 0x09, 0x017C, 0xF3 }, { 0x09, 0x007D, 0x0E },
 { 0x09, 0x007C, 0xF2 }, { 0x0A, 0x02FD, 0x0F }, { 0x0A, 0x02FC, 0xF1 }, { 0x0A, 0x00FC, 0x10 },
 { 0x0B, 0x05FF, 0xF0 }, { 0x0B, 0x05FC, 0x11 }, { 0x0B, 0x01FF, 0xEF }, { 0x0B, 0x01FA, 0x12 },
 { 0x0C, 0x0BFD, 0xEE }, { 0x0C, 0x0BFB, 0x13 }, { 0x0C, 0x0BFA, 0xED }, { 0x0C, 0x03F7, 0x14 },
 { 0x0C, 0x03F6, 0xEC }, { 0x0D, 0x17F8, 0x15 }, { 0x0D, 0x07FB, 0xEB }, { 0x0D, 0x07F3, 0x16 },
 { 0x0D, 0x07F2, 0xEA }, { 0x0E, 0x2FF3, 0x17 }, { 0x0E, 0x2FF2, 0xE9 }, { 0x0E, 0x0FF5, 0x18 },
 { 0x0E, 0x0FF4, 0xE8 }, { 0x0E, 0x0FF3, 0x19 }, { 0x0E, 0x0FF2, 0xE7 }, { 0x0E, 0x0FF1, 0x1A },
 { 0x0E, 0x0FF0, 0xE6 }, { 0x0E, 0x0FEF, 0x1B }, { 0x0E, 0x0FEE, 0xE5 }, { 0x0E, 0x0FED, 0x1C },
 { 0x0E, 0x0FEC, 0xE4 }, { 0x0E, 0x0FEB, 0x1D }, { 0x0E, 0x0FEA, 0xE3 }, { 0x0E, 0x0FE9, 0x1E },
 { 0x0E, 0x0FE8, 0xE2 }, { 0x0E, 0x0FE3, 0x1F }, { 0x0E, 0x0FE2, 0xE1 }, { 0x0E, 0x0FE1, 0x20 },
 { 0x0E, 0x0FE0, 0xE0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_g_65[ 66 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x000E, 0x00 }, { 0x04, 0x000B, 0x01 }, { 0x04, 0x000A, 0xFF }, { 0x04, 0x0008, 0x02 },
 { 0x04, 0x0006, 0xFE }, { 0x04, 0x0004, 0x03 }, { 0x04, 0x0003, 0xFD }, { 0x04, 0x0000, 0x04 },
 { 0x05, 0x001F, 0xFC }, { 0x05, 0x001A, 0x05 }, { 0x05, 0x0019, 0xFB }, { 0x05, 0x0012, 0x06 },
 { 0x05, 0x000F, 0xFA }, { 0x05, 0x000A, 0x07 }, { 0x05, 0x0005, 0xF9 }, { 0x05, 0x0002, 0x08 },
 { 0x06, 0x003D, 0xF8 }, { 0x06, 0x0036, 0x09 }, { 0x06, 0x0031, 0xF7 }, { 0x06, 0x0026, 0x0A },
 { 0x06, 0x001D, 0xF6 }, { 0x06, 0x0016, 0x0B }, { 0x06, 0x0009, 0xF5 }, { 0x06, 0x0006, 0x0C },
 { 0x07, 0x0079, 0xF4 }, { 0x07, 0x006E, 0x0D }, { 0x07, 0x0061, 0xF3 }, { 0x07, 0x004E, 0x0E },
 { 0x07, 0x0039, 0xF2 }, { 0x07, 0x002E, 0x0F }, { 0x07, 0x0011, 0xF1 }, { 0x07, 0x000E, 0x10 },
 { 0x08, 0x00F1, 0xF0 }, { 0x08, 0x00DF, 0x11 }, { 0x08, 0x00DE, 0xEF }, { 0x08, 0x009F, 0x12 },
 { 0x08, 0x009E, 0xEE }, { 0x08, 0x005F, 0x13 }, { 0x08, 0x005E, 0xED }, { 0x08, 0x001F, 0x14 },
 { 0x08, 0x001E, 0xEC }, { 0x09, 0x01E0, 0x15 }, { 0x09, 0x0183, 0xEB }, { 0x09, 0x0180, 0x16 },
 { 0x09, 0x00E3, 0xEA }, { 0x09, 0x00E1, 0x17 }, { 0x09, 0x00E0, 0xE9 }, { 0x09, 0x0041, 0x18 },
 { 0x09, 0x0040, 0xE8 }, { 0x0A, 0x03C2, 0x19 }, { 0x0A, 0x0305, 0xE7 }, { 0x0A, 0x0303, 0x1A },
 { 0x0A, 0x0302, 0xE6 }, { 0x0A, 0x01C4, 0x1B }, { 0x0A, 0x0087, 0xE5 }, { 0x0A, 0x0085, 0x1C },
 { 0x0A, 0x0084, 0xE4 }, { 0x0B, 0x0787, 0x1D }, { 0x0B, 0x0786, 0xE3 }, { 0x0B, 0x0609, 0x1E },
 { 0x0B, 0x0608, 0xE2 }, { 0x0B, 0x038B, 0x1F }, { 0x0B, 0x038A, 0xE1 }, { 0x0B, 0x010D, 0x20 },
 { 0x0B, 0x010C, 0xE0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_a_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x0008, 0x00 }, { 0x04, 0x000A, 0x01 }, { 0x04, 0x0009, 0xFF }, { 0x04, 0x0000, 0x02 },
 { 0x05, 0x001F, 0xFE }, { 0x05, 0x0018, 0x03 }, { 0x05, 0x0017, 0xFD }, { 0x05, 0x000C, 0x04 },
 { 0x05, 0x000B, 0xFC }, { 0x05, 0x0005, 0x05 }, { 0x05, 0x0004, 0xFB }, { 0x06, 0x003C, 0x06 },
 { 0x06, 0x003A, 0xFA }, { 0x06, 0x0036, 0x07 }, { 0x06, 0x0035, 0xF9 }, { 0x06, 0x002D, 0x08 },
 { 0x06, 0x002C, 0xF8 }, { 0x06, 0x001C, 0x09 }, { 0x06, 0x001B, 0xF7 }, { 0x06, 0x0013, 0x0A },
 { 0x06, 0x0012, 0xF6 }, { 0x06, 0x000E, 0x0B }, { 0x06, 0x000D, 0xF5 }, { 0x06, 0x0006, 0x0C },
 { 0x06, 0x0005, 0xF4 }, { 0x07, 0x007A, 0x0D }, { 0x07, 0x0077, 0xF3 }, { 0x07, 0x0071, 0x0E },
 { 0x07, 0x0070, 0xF2 }, { 0x07, 0x0068, 0x0F }, { 0x07, 0x0067, 0xF1 }, { 0x07, 0x0064, 0x10 },
 { 0x07, 0x003F, 0xF0 }, { 0x07, 0x003C, 0x11 }, { 0x07, 0x003B, 0xEF }, { 0x07, 0x0034, 0x12 },
 { 0x07, 0x002B, 0xEE }, { 0x07, 0x0028, 0x13 }, { 0x07, 0x0023, 0xED }, { 0x07, 0x0020, 0x14 },
 { 0x07, 0x001F, 0xEC }, { 0x07, 0x000F, 0x15 }, { 0x07, 0x000E, 0xEB }, { 0x08, 0x00F7, 0x16 },
 { 0x08, 0x00F6, 0xEA }, { 0x08, 0x00E7, 0x17 }, { 0x08, 0x00E6, 0xE9 }, { 0x08, 0x00DF, 0x18 },
 { 0x08, 0x00DE, 0xE8 }, { 0x08, 0x00D3, 0x19 }, { 0x08, 0x00D2, 0xE7 }, { 0x08, 0x00CB, 0x1A },
 { 0x08, 0x00CA, 0xE6 }, { 0x08, 0x007B, 0x1B }, { 0x08, 0x007A, 0xE5 }, { 0x08, 0x0074, 0x1C },
 { 0x08, 0x006B, 0xE4 }, { 0x08, 0x0054, 0x1D }, { 0x08, 0x0053, 0xE3 }, { 0x08, 0x0044, 0x1E },
 { 0x08, 0x0043, 0xE2 }, { 0x08, 0x003C, 0x1F }, { 0x08, 0x0033, 0xE1 }, { 0x08, 0x0031, 0x20 },
 { 0x08, 0x0030, 0xE0 }, { 0x08, 0x0011, 0x21 }, { 0x08, 0x0010, 0xDF }, { 0x09, 0x01DA, 0x22 },
 { 0x09, 0x01D9, 0xDE }, { 0x09, 0x01CA, 0x23 }, { 0x09, 0x01C9, 0xDD }, { 0x09, 0x01BA, 0x24 },
 { 0x09, 0x01B9, 0xDC }, { 0x09, 0x019B, 0x25 }, { 0x09, 0x019A, 0xDB }, { 0x09, 0x00FB, 0x26 },
 { 0x09, 0x00FA, 0xDA }, { 0x09, 0x00F8, 0x27 }, { 0x09, 0x00EB, 0xD9 }, { 0x09, 0x00D5, 0x28 },
 { 0x09, 0x00D4, 0xD8 }, { 0x09, 0x00AA, 0x29 }, { 0x09, 0x00A5, 0xD7 }, { 0x09, 0x008B, 0x2A },
 { 0x09, 0x008A, 0xD6 }, { 0x09, 0x0084, 0x2B }, { 0x09, 0x007B, 0xD5 }, { 0x09, 0x0065, 0x2C },
 { 0x09, 0x0064, 0xD4 }, { 0x09, 0x0025, 0x2D }, { 0x09, 0x0024, 0xD3 }, { 0x0A, 0x03B6, 0x2E },
 { 0x0A, 0x03B1, 0xD2 }, { 0x0A, 0x0397, 0x2F }, { 0x0A, 0x0396, 0xD1 }, { 0x0A, 0x0390, 0x30 },
 { 0x0A, 0x0377, 0xD0 }, { 0x0A, 0x0371, 0x31 }, { 0x0A, 0x0370, 0xCF }, { 0x0A, 0x0332, 0x32 },
 { 0x0A, 0x0331, 0xCE }, { 0x0A, 0x01F3, 0x33 }, { 0x0A, 0x01F2, 0xCD }, { 0x0A, 0x01D5, 0x34 },
 { 0x0A, 0x01D4, 0xCC }, { 0x0A, 0x0157, 0x35 }, { 0x0A, 0x0156, 0xCB }, { 0x0A, 0x0149, 0x36 },
 { 0x0A, 0x0148, 0xCA }, { 0x0A, 0x010B, 0x37 }, { 0x0A, 0x010A, 0xC9 }, { 0x0A, 0x00F5, 0x38 },
 { 0x0A, 0x00F4, 0xC8 }, { 0x0A, 0x004F, 0x39 }, { 0x0A, 0x004E, 0xC7 }, { 0x0A, 0x004D, 0x3A },
 { 0x0A, 0x004C, 0xC6 }, { 0x0B, 0x076F, 0x3B }, { 0x0B, 0x076E, 0xC5 }, { 0x0B, 0x0761, 0x3C },
 { 0x0B, 0x0760, 0xC4 }, { 0x0B, 0x0723, 0x3D }, { 0x0B, 0x0722, 0xC3 }, { 0x0B, 0x06ED, 0x3E },
 { 0x0B, 0x06EC, 0xC2 }, { 0x0B, 0x0667, 0x3F }, { 0x0B, 0x0666, 0xC1 }, { 0x0B, 0x0661, 0x40 },
 { 0x0B, 0x0660, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_b_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x05, 0x000A, 0x00 }, { 0x05, 0x0007, 0x01 }, { 0x05, 0x0006, 0xFF }, { 0x05, 0x0004, 0x02 },
 { 0x05, 0x0003, 0xFE }, { 0x05, 0x0000, 0x03 }, { 0x06, 0x003F, 0xFD }, { 0x06, 0x003C, 0x04 },
 { 0x06, 0x003B, 0xFC }, { 0x06, 0x0039, 0x05 }, { 0x06, 0x0038, 0xFB }, { 0x06, 0x0035, 0x06 },
 { 0x06, 0x0034, 0xFA }, { 0x06, 0x0032, 0x07 }, { 0x06, 0x0031, 0xF9 }, { 0x06, 0x002E, 0x08 },
 { 0x06, 0x002D, 0xF8 }, { 0x06, 0x002B, 0x09 }, { 0x06, 0x002A, 0xF7 }, { 0x06, 0x0027, 0x0A },
 { 0x06, 0x0026, 0xF6 }, { 0x06, 0x0023, 0x0B }, { 0x06, 0x0022, 0xF5 }, { 0x06, 0x0020, 0x0C },
 { 0x06, 0x001F, 0xF4 }, { 0x06, 0x001C, 0x0D }, { 0x06, 0x001B, 0xF3 }, { 0x06, 0x0019, 0x0E },
 { 0x06, 0x0018, 0xF2 }, { 0x06, 0x0016, 0x0F }, { 0x06, 0x0013, 0xF1 }, { 0x06, 0x0010, 0x10 },
 { 0x06, 0x000B, 0xF0 }, { 0x06, 0x0005, 0x11 }, { 0x06, 0x0004, 0xEF }, { 0x07, 0x007D, 0x12 },
 { 0x07, 0x007C, 0xEE }, { 0x07, 0x007A, 0x13 }, { 0x07, 0x0075, 0xED }, { 0x07, 0x006E, 0x14 },
 { 0x07, 0x006D, 0xEC }, { 0x07, 0x0067, 0x15 }, { 0x07, 0x0066, 0xEB }, { 0x07, 0x0060, 0x16 },
 { 0x07, 0x005F, 0xEA }, { 0x07, 0x0059, 0x17 }, { 0x07, 0x0058, 0xE9 }, { 0x07, 0x0051, 0x18 },
 { 0x07, 0x0050, 0xE8 }, { 0x07, 0x004A, 0x19 }, { 0x07, 0x0049, 0xE7 }, { 0x07, 0x0042, 0x1A },
 { 0x07, 0x003D, 0xE6 }, { 0x07, 0x003B, 0x1B }, { 0x07, 0x003A, 0xE5 }, { 0x07, 0x0034, 0x1C },
 { 0x07, 0x002F, 0xE4 }, { 0x07, 0x0025, 0x1D }, { 0x07, 0x0024, 0xE3 }, { 0x07, 0x0015, 0x1E },
 { 0x07, 0x0014, 0xE2 }, { 0x07, 0x0006, 0x1F }, { 0x07, 0x0005, 0xE1 }, { 0x08, 0x00F7, 0x20 },
 { 0x08, 0x00F6, 0xE0 }, { 0x08, 0x00DF, 0x21 }, { 0x08, 0x00DE, 0xDF }, { 0x08, 0x00D9, 0x22 },
 { 0x08, 0x00D8, 0xDE }, { 0x08, 0x00BD, 0x23 }, { 0x08, 0x00BC, 0xDD }, { 0x08, 0x00A6, 0x24 },
 { 0x08, 0x00A5, 0xDC }, { 0x08, 0x0097, 0x25 }, { 0x08, 0x0096, 0xDB }, { 0x08, 0x0090, 0x26 },
 { 0x08, 0x0087, 0xDA }, { 0x08, 0x0079, 0x27 }, { 0x08, 0x0078, 0xD9 }, { 0x08, 0x006A, 0x28 },
 { 0x08, 0x005D, 0xD8 }, { 0x08, 0x0047, 0x29 }, { 0x08, 0x0046, 0xD7 }, { 0x08, 0x0044, 0x2A },
 { 0x08, 0x000F, 0xD6 }, { 0x08, 0x0009, 0x2B }, { 0x08, 0x0008, 0xD5 }, { 0x09, 0x01D2, 0x2C },
 { 0x09, 0x01D1, 0xD4 }, { 0x09, 0x0187, 0x2D }, { 0x09, 0x0186, 0xD3 }, { 0x09, 0x0184, 0x2E },
 { 0x09, 0x014F, 0xD2 }, { 0x09, 0x0149, 0x2F }, { 0x09, 0x0148, 0xD1 }, { 0x09, 0x010D, 0x30 },
 { 0x09, 0x010C, 0xD0 }, { 0x09, 0x00D7, 0x31 }, { 0x09, 0x00D6, 0xCF }, { 0x09, 0x00B8, 0x32 },
 { 0x09, 0x008B, 0xCE }, { 0x09, 0x001D, 0x33 }, { 0x09, 0x001C, 0xCD }, { 0x0A, 0x03A6, 0x34 },
 { 0x0A, 0x03A1, 0xCC }, { 0x0A, 0x030B, 0x35 }, { 0x0A, 0x030A, 0xCB }, { 0x0A, 0x029C, 0x36 },
 { 0x0A, 0x0247, 0xCA }, { 0x0A, 0x0246, 0x37 }, { 0x0A, 0x0245, 0xC9 }, { 0x0A, 0x0173, 0x38 },
 { 0x0A, 0x0172, 0xC8 }, { 0x0A, 0x0114, 0x39 }, { 0x0B, 0x074F, 0xC7 }, { 0x0B, 0x0741, 0x3A },
 { 0x0B, 0x0740, 0xC6 }, { 0x0B, 0x053A, 0x3B }, { 0x0B, 0x0489, 0xC5 }, { 0x0B, 0x0488, 0x3C },
 { 0x0B, 0x022B, 0xC4 }, { 0x0C, 0x0E9D, 0x3D }, { 0x0C, 0x0E9C, 0xC3 }, { 0x0C, 0x0A76, 0x3E },
 { 0x0C, 0x0455, 0xC2 }, { 0x0C, 0x0454, 0x3F }, { 0x0D, 0x14EF, 0xC1 }, { 0x0E, 0x29DD, 0x40 },
 { 0x0E, 0x29DC, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_c_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x06, 0x003A, 0x00 }, { 0x06, 0x0037, 0x01 }, { 0x06, 0x0036, 0xFF }, { 0x06, 0x0034, 0x02 },
 { 0x06, 0x0033, 0xFE }, { 0x06, 0x0031, 0x03 }, { 0x06, 0x0030, 0xFD }, { 0x06, 0x002E, 0x04 },
 { 0x06, 0x002D, 0xFC }, { 0x06, 0x002B, 0x05 }, { 0x06, 0x002A, 0xFB }, { 0x06, 0x0028, 0x06 },
 { 0x06, 0x0027, 0xFA }, { 0x06, 0x0025, 0x07 }, { 0x06, 0x0024, 0xF9 }, { 0x06, 0x0022, 0x08 },
 { 0x06, 0x0021, 0xF8 }, { 0x06, 0x001E, 0x09 }, { 0x06, 0x001D, 0xF7 }, { 0x06, 0x001B, 0x0A },
 { 0x06, 0x001A, 0xF6 }, { 0x06, 0x0018, 0x0B }, { 0x06, 0x0017, 0xF5 }, { 0x06, 0x0015, 0x0C },
 { 0x06, 0x0014, 0xF4 }, { 0x06, 0x0012, 0x0D }, { 0x06, 0x0011, 0xF3 }, { 0x06, 0x000E, 0x0E },
 { 0x06, 0x000D, 0xF2 }, { 0x06, 0x000C, 0x0F }, { 0x06, 0x000B, 0xF1 }, { 0x06, 0x0008, 0x10 },
 { 0x06, 0x0007, 0xF0 }, { 0x06, 0x0006, 0x11 }, { 0x06, 0x0005, 0xEF }, { 0x06, 0x0003, 0x12 },
 { 0x06, 0x0002, 0xEE }, { 0x07, 0x007F, 0x13 }, { 0x07, 0x007E, 0xED }, { 0x07, 0x007C, 0x14 },
 { 0x07, 0x007B, 0xEC }, { 0x07, 0x0079, 0x15 }, { 0x07, 0x0078, 0xEB }, { 0x07, 0x0076, 0x16 },
 { 0x07, 0x0073, 0xEA }, { 0x07, 0x0071, 0x17 }, { 0x07, 0x0070, 0xE9 }, { 0x07, 0x006A, 0x18 },
 { 0x07, 0x0065, 0xE8 }, { 0x07, 0x005F, 0x19 }, { 0x07, 0x005E, 0xE7 }, { 0x07, 0x0058, 0x1A },
 { 0x07, 0x0053, 0xE6 }, { 0x07, 0x004D, 0x1B }, { 0x07, 0x004C, 0xE5 }, { 0x07, 0x0046, 0x1C },
 { 0x07, 0x0041, 0xE4 }, { 0x07, 0x0040, 0x1D }, { 0x07, 0x003F, 0xE3 }, { 0x07, 0x0038, 0x1E },
 { 0x07, 0x0033, 0xE2 }, { 0x07, 0x002D, 0x1F }, { 0x07, 0x002C, 0xE1 }, { 0x07, 0x0027, 0x20 },
 { 0x07, 0x0026, 0xE0 }, { 0x07, 0x001F, 0x21 }, { 0x07, 0x001E, 0xDF }, { 0x07, 0x0014, 0x22 },
 { 0x07, 0x0013, 0xDE }, { 0x07, 0x0012, 0x23 }, { 0x07, 0x0009, 0xDD }, { 0x07, 0x0003, 0x24 },
 { 0x07, 0x0002, 0xDC }, { 0x07, 0x0000, 0x25 }, { 0x08, 0x00FB, 0xDB }, { 0x08, 0x00F5, 0x26 },
 { 0x08, 0x00F4, 0xDA }, { 0x08, 0x00EE, 0x27 }, { 0x08, 0x00E5, 0xD9 }, { 0x08, 0x00D7, 0x28 },
 { 0x08, 0x00D6, 0xD8 }, { 0x08, 0x00C8, 0x29 }, { 0x08, 0x00B3, 0xD7 }, { 0x08, 0x00A5, 0x2A },
 { 0x08, 0x00A4, 0xD6 }, { 0x08, 0x008F, 0x2B }, { 0x08, 0x008E, 0xD5 }, { 0x08, 0x007C, 0x2C },
 { 0x08, 0x0073, 0xD4 }, { 0x08, 0x0065, 0x2D }, { 0x08, 0x0064, 0xD3 }, { 0x08, 0x0042, 0x2E },
 { 0x08, 0x0041, 0xD2 }, { 0x08, 0x002B, 0x2F }, { 0x08, 0x002A, 0xD1 }, { 0x08, 0x0011, 0x30 },
 { 0x08, 0x0010, 0xD0 }, { 0x08, 0x0002, 0x31 }, { 0x09, 0x01F5, 0xCF }, { 0x09, 0x01DF, 0x32 },
 { 0x09, 0x01DE, 0xCE }, { 0x09, 0x01C8, 0x33 }, { 0x09, 0x0193, 0xCD }, { 0x09, 0x0165, 0x34 },
 { 0x09, 0x0164, 0xCC }, { 0x09, 0x00FB, 0x35 }, { 0x09, 0x00FA, 0xCB }, { 0x09, 0x00E4, 0x36 },
 { 0x09, 0x0087, 0xCA }, { 0x09, 0x0081, 0x37 }, { 0x09, 0x0080, 0xC9 }, { 0x09, 0x0006, 0x38 },
 { 0x0A, 0x03E9, 0xC8 }, { 0x0A, 0x03E8, 0x39 }, { 0x0A, 0x0393, 0xC7 }, { 0x0A, 0x0325, 0x3A },
 { 0x0A, 0x0324, 0xC6 }, { 0x0A, 0x01CA, 0x3B }, { 0x0A, 0x010D, 0xC5 }, { 0x0A, 0x010C, 0x3C },
 { 0x0A, 0x000F, 0xC4 }, { 0x0B, 0x0725, 0x3D }, { 0x0B, 0x0724, 0xC3 }, { 0x0B, 0x0396, 0x3E },
 { 0x0B, 0x001D, 0xC2 }, { 0x0B, 0x001C, 0x3F }, { 0x0C, 0x072F, 0xC1 }, { 0x0D, 0x0E5D, 0x40 },
 { 0x0D, 0x0E5C, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_d_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x0009, 0x00 }, { 0x04, 0x0006, 0x01 }, { 0x04, 0x0005, 0xFF }, { 0x04, 0x0002, 0x02 },
 { 0x04, 0x0001, 0xFE }, { 0x05, 0x001E, 0x03 }, { 0x05, 0x001D, 0xFD }, { 0x05, 0x001A, 0x04 },
 { 0x05, 0x0019, 0xFC }, { 0x05, 0x0016, 0x05 }, { 0x05, 0x0015, 0xFB }, { 0x05, 0x0010, 0x06 },
 { 0x05, 0x000F, 0xFA }, { 0x05, 0x0008, 0x07 }, { 0x05, 0x0007, 0xF9 }, { 0x05, 0x0000, 0x08 },
 { 0x06, 0x003F, 0xF8 }, { 0x06, 0x0038, 0x09 }, { 0x06, 0x0037, 0xF7 }, { 0x06, 0x0030, 0x0A },
 { 0x06, 0x002F, 0xF6 }, { 0x06, 0x0028, 0x0B }, { 0x06, 0x0023, 0xF5 }, { 0x06, 0x001C, 0x0C },
 { 0x06, 0x0013, 0xF4 }, { 0x06, 0x000C, 0x0D }, { 0x06, 0x0003, 0xF3 }, { 0x07, 0x007C, 0x0E },
 { 0x07, 0x0073, 0xF2 }, { 0x07, 0x006C, 0x0F }, { 0x07, 0x0063, 0xF1 }, { 0x07, 0x005C, 0x10 },
 { 0x07, 0x0053, 0xF0 }, { 0x07, 0x0044, 0x11 }, { 0x07, 0x003B, 0xEF }, { 0x07, 0x0024, 0x12 },
 { 0x07, 0x001B, 0xEE }, { 0x07, 0x0004, 0x13 }, { 0x08, 0x00FB, 0xED }, { 0x08, 0x00E4, 0x14 },
 { 0x08, 0x00DB, 0xEC }, { 0x08, 0x00C4, 0x15 }, { 0x08, 0x00BB, 0xEB }, { 0x08, 0x00A4, 0x16 },
 { 0x08, 0x008B, 0xEA }, { 0x08, 0x0074, 0x17 }, { 0x08, 0x004B, 0xE9 }, { 0x08, 0x0034, 0x18 },
 { 0x08, 0x000B, 0xE8 }, { 0x09, 0x01F5, 0x19 }, { 0x09, 0x01F4, 0xE7 }, { 0x09, 0x01B5, 0x1A },
 { 0x09, 0x01B4, 0xE6 }, { 0x09, 0x0175, 0x1B }, { 0x09, 0x0174, 0xE5 }, { 0x09, 0x0115, 0x1C },
 { 0x09, 0x0114, 0xE4 }, { 0x09, 0x0095, 0x1D }, { 0x09, 0x0094, 0xE3 }, { 0x09, 0x0015, 0x1E },
 { 0x09, 0x0014, 0xE2 }, { 0x0A, 0x0395, 0x1F }, { 0x0A, 0x0394, 0xE1 }, { 0x0A, 0x0315, 0x20 },
 { 0x0A, 0x0314, 0xE0 }, { 0x0A, 0x0295, 0x21 }, { 0x0A, 0x0294, 0xDF }, { 0x0A, 0x01D5, 0x22 },
 { 0x0A, 0x01D4, 0xDE }, { 0x0A, 0x00D6, 0x23 }, { 0x0A, 0x00D5, 0xDD }, { 0x0B, 0x072E, 0x24 },
 { 0x0B, 0x072D, 0xDC }, { 0x0B, 0x062E, 0x25 }, { 0x0B, 0x062D, 0xDB }, { 0x0B, 0x052E, 0x26 },
 { 0x0B, 0x052D, 0xDA }, { 0x0B, 0x03AE, 0x27 }, { 0x0B, 0x03AD, 0xD9 }, { 0x0B, 0x01AF, 0x28 },
 { 0x0B, 0x01AE, 0xD8 }, { 0x0C, 0x0E5F, 0x29 }, { 0x0C, 0x0E5E, 0xD7 }, { 0x0C, 0x0C5F, 0x2A },
 { 0x0C, 0x0C5E, 0xD6 }, { 0x0C, 0x0C58, 0x2B }, { 0x0C, 0x0A5F, 0xD5 }, { 0x0C, 0x0A58, 0x2C },
 { 0x0C, 0x075F, 0xD4 }, { 0x0C, 0x0758, 0x2D }, { 0x0C, 0x0353, 0xD3 }, { 0x0C, 0x0351, 0x2E },
 { 0x0C, 0x0350, 0xD2 }, { 0x0D, 0x1CB2, 0x2F }, { 0x0D, 0x1CB1, 0xD1 }, { 0x0D, 0x18B2, 0x30 },
 { 0x0D, 0x14BD, 0xD0 }, { 0x0D, 0x0EBD, 0x31 }, { 0x0D, 0x0EBC, 0xCF }, { 0x0D, 0x0EB2, 0x32 },
 { 0x0D, 0x06A5, 0xCE }, { 0x0E, 0x3967, 0x33 }, { 0x0E, 0x3966, 0xCD }, { 0x0E, 0x3960, 0x34 },
 { 0x0E, 0x3167, 0xCC }, { 0x0E, 0x2979, 0x35 }, { 0x0E, 0x2978, 0xCB }, { 0x0E, 0x2964, 0x36 },
 { 0x0E, 0x1D67, 0xCA }, { 0x0E, 0x0D49, 0x37 }, { 0x0E, 0x0D48, 0xC9 }, { 0x0F, 0x72C2, 0x38 },
 { 0x0F, 0x62CD, 0xC8 }, { 0x0F, 0x52CB, 0x39 }, { 0x0F, 0x52CA, 0xC7 }, { 0x0F, 0x3ACD, 0x3A },
 { 0x0F, 0x3ACC, 0xC6 }, { 0x10, 0xE587, 0x3B }, { 0x10, 0xE586, 0xC5 }, { 0x10, 0xC599, 0x3C },
 { 0x10, 0xC598, 0xC4 }, { 0x10, 0xA59F, 0x3D }, { 0x10, 0xA59E, 0xC3 }, { 0x10, 0xA59D, 0x3E },
 { 0x10, 0xA59C, 0xC2 }, { 0x10, 0xA59B, 0x3F }, { 0x10, 0xA59A, 0xC1 }, { 0x10, 0xA599, 0x40 },
 { 0x10, 0xA598, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_e_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x05, 0x000C, 0x00 }, { 0x05, 0x000B, 0x01 }, { 0x05, 0x000A, 0xFF }, { 0x05, 0x0009, 0x02 },
 { 0x05, 0x0008, 0xFE }, { 0x05, 0x0007, 0x03 }, { 0x05, 0x0006, 0xFD }, { 0x05, 0x0004, 0x04 },
 { 0x05, 0x0003, 0xFC }, { 0x05, 0x0002, 0x05 }, { 0x05, 0x0001, 0xFB }, { 0x05, 0x0000, 0x06 },
 { 0x06, 0x003F, 0xFA }, { 0x06, 0x003D, 0x07 }, { 0x06, 0x003C, 0xF9 }, { 0x06, 0x003B, 0x08 },
 { 0x06, 0x003A, 0xF8 }, { 0x06, 0x0038, 0x09 }, { 0x06, 0x0037, 0xF7 }, { 0x06, 0x0035, 0x0A },
 { 0x06, 0x0034, 0xF6 }, { 0x06, 0x0033, 0x0B }, { 0x06, 0x0032, 0xF5 }, { 0x06, 0x002F, 0x0C },
 { 0x06, 0x002E, 0xF4 }, { 0x06, 0x002D, 0x0D }, { 0x06, 0x002C, 0xF3 }, { 0x06, 0x002A, 0x0E },
 { 0x06, 0x0029, 0xF2 }, { 0x06, 0x0026, 0x0F }, { 0x06, 0x0025, 0xF1 }, { 0x06, 0x0024, 0x10 },
 { 0x06, 0x0023, 0xF0 }, { 0x06, 0x0020, 0x11 }, { 0x06, 0x001F, 0xEF }, { 0x06, 0x001D, 0x12 },
 { 0x06, 0x001C, 0xEE }, { 0x06, 0x001A, 0x13 }, { 0x06, 0x000B, 0xED }, { 0x07, 0x007D, 0x14 },
 { 0x07, 0x007C, 0xEC }, { 0x07, 0x006D, 0x15 }, { 0x07, 0x006C, 0xEB }, { 0x07, 0x0062, 0x16 },
 { 0x07, 0x0061, 0xEA }, { 0x07, 0x0057, 0x17 }, { 0x07, 0x0056, 0xE9 }, { 0x07, 0x004F, 0x18 },
 { 0x07, 0x004E, 0xE8 }, { 0x07, 0x0044, 0x19 }, { 0x07, 0x0043, 0xE7 }, { 0x07, 0x003C, 0x1A },
 { 0x07, 0x0037, 0xE6 }, { 0x07, 0x0015, 0x1B }, { 0x07, 0x0014, 0xE5 }, { 0x08, 0x00E6, 0x1C },
 { 0x08, 0x00E5, 0xE4 }, { 0x08, 0x00C6, 0x1D }, { 0x08, 0x00C1, 0xE3 }, { 0x08, 0x00A3, 0x1E },
 { 0x08, 0x00A2, 0xE2 }, { 0x08, 0x008B, 0x1F }, { 0x08, 0x008A, 0xE1 }, { 0x08, 0x007B, 0x20 },
 { 0x08, 0x007A, 0xE0 }, { 0x08, 0x006C, 0x21 }, { 0x09, 0x01CF, 0xDF }, { 0x09, 0x01C9, 0x22 },
 { 0x09, 0x01C8, 0xDE }, { 0x09, 0x0181, 0x23 }, { 0x09, 0x0180, 0xDD }, { 0x09, 0x0141, 0x24 },
 { 0x09, 0x0140, 0xDC }, { 0x09, 0x010A, 0x25 }, { 0x09, 0x0109, 0xDB }, { 0x09, 0x00DA, 0x26 },
 { 0x0A, 0x039D, 0xDA }, { 0x0A, 0x031E, 0x27 }, { 0x0A, 0x031D, 0xD9 }, { 0x0A, 0x0286, 0x28 },
 { 0x0A, 0x0285, 0xD8 }, { 0x0A, 0x0217, 0x29 }, { 0x0A, 0x0216, 0xD7 }, { 0x0A, 0x0210, 0x2A },
 { 0x0A, 0x01B7, 0xD6 }, { 0x0B, 0x0738, 0x2B }, { 0x0B, 0x063F, 0xD5 }, { 0x0B, 0x0638, 0x2C },
 { 0x0B, 0x050F, 0xD4 }, { 0x0B, 0x0508, 0x2D }, { 0x0B, 0x0423, 0xD3 }, { 0x0B, 0x036D, 0x2E },
 { 0x0B, 0x036C, 0xD2 }, { 0x0C, 0x0C7D, 0x2F }, { 0x0C, 0x0C7C, 0xD1 }, { 0x0C, 0x0A1D, 0x30 },
 { 0x0C, 0x0A1C, 0xD0 }, { 0x0C, 0x0845, 0x31 }, { 0x0C, 0x0844, 0xCF }, { 0x0D, 0x1CE6, 0x32 },
 { 0x0D, 0x1CE5, 0xCE }, { 0x0D, 0x18E6, 0x33 }, { 0x0D, 0x18E5, 0xCD }, { 0x0D, 0x1426, 0x34 },
 { 0x0D, 0x1425, 0xCC }, { 0x0E, 0x39CF, 0x35 }, { 0x0E, 0x39CE, 0xCB }, { 0x0E, 0x31CF, 0x36 },
 { 0x0E, 0x31CE, 0xCA }, { 0x0E, 0x284E, 0x37 }, { 0x0E, 0x2849, 0xC9 }, { 0x0F, 0x7393, 0x38 },
 { 0x0F, 0x7392, 0xC8 }, { 0x0F, 0x7390, 0x39 }, { 0x0F, 0x6393, 0xC7 }, { 0x0F, 0x5091, 0x3A },
 { 0x0F, 0x5090, 0xC6 }, { 0x10, 0xE723, 0x3B }, { 0x10, 0xE722, 0xC5 }, { 0x10, 0xC724, 0x3C },
 { 0x10, 0xA13D, 0xC4 }, { 0x10, 0xC725, 0x3D }, { 0x10, 0xA13E, 0xC3 }, { 0x10, 0xC722, 0x3E },
 { 0x10, 0xA13F, 0xC2 }, { 0x10, 0xC723, 0x3F }, { 0x10, 0xC720, 0xC1 }, { 0x10, 0xC721, 0x40 },
 { 0x10, 0xA13C, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_f_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x06, 0x0038, 0x00 }, { 0x06, 0x0037, 0x01 }, { 0x06, 0x0036, 0xFF }, { 0x06, 0x0034, 0x02 },
 { 0x06, 0x0033, 0xFE }, { 0x06, 0x0032, 0x03 }, { 0x06, 0x0031, 0xFD }, { 0x06, 0x0030, 0x04 },
 { 0x06, 0x002F, 0xFC }, { 0x06, 0x002E, 0x05 }, { 0x06, 0x002D, 0xFB }, { 0x06, 0x002C, 0x06 },
 { 0x06, 0x002B, 0xFA }, { 0x06, 0x0029, 0x07 }, { 0x06, 0x0028, 0xF9 }, { 0x06, 0x0027, 0x08 },
 { 0x06, 0x0026, 0xF8 }, { 0x06, 0x0024, 0x09 }, { 0x06, 0x0023, 0xF7 }, { 0x06, 0x0022, 0x0A },
 { 0x06, 0x0021, 0xF6 }, { 0x06, 0x001F, 0x0B }, { 0x06, 0x001E, 0xF5 }, { 0x06, 0x001D, 0x0C },
 { 0x06, 0x001C, 0xF4 }, { 0x06, 0x001A, 0x0D }, { 0x06, 0x0019, 0xF3 }, { 0x06, 0x0017, 0x0E },
 { 0x06, 0x0016, 0xF2 }, { 0x06, 0x0015, 0x0F }, { 0x06, 0x0014, 0xF1 }, { 0x06, 0x0012, 0x10 },
 { 0x06, 0x0011, 0xF0 }, { 0x06, 0x000F, 0x11 }, { 0x06, 0x000E, 0xEF }, { 0x06, 0x000C, 0x12 },
 { 0x06, 0x000B, 0xEE }, { 0x06, 0x0009, 0x13 }, { 0x06, 0x0008, 0xED }, { 0x06, 0x0007, 0x14 },
 { 0x06, 0x0006, 0xEC }, { 0x06, 0x0003, 0x15 }, { 0x06, 0x0002, 0xEB }, { 0x06, 0x0001, 0x16 },
 { 0x06, 0x0000, 0xEA }, { 0x07, 0x007D, 0x17 }, { 0x07, 0x007C, 0xE9 }, { 0x07, 0x007B, 0x18 },
 { 0x07, 0x007A, 0xE8 }, { 0x07, 0x0078, 0x19 }, { 0x07, 0x0077, 0xE7 }, { 0x07, 0x0074, 0x1A },
 { 0x07, 0x0073, 0xE6 }, { 0x07, 0x0072, 0x1B }, { 0x07, 0x006B, 0xE5 }, { 0x07, 0x0054, 0x1C },
 { 0x07, 0x004B, 0xE4 }, { 0x07, 0x0041, 0x1D }, { 0x07, 0x0040, 0xE3 }, { 0x07, 0x0036, 0x1E },
 { 0x07, 0x0031, 0xE2 }, { 0x07, 0x0027, 0x1F }, { 0x07, 0x0026, 0xE1 }, { 0x07, 0x001B, 0x20 },
 { 0x07, 0x001A, 0xE0 }, { 0x07, 0x0014, 0x21 }, { 0x07, 0x000B, 0xDF }, { 0x07, 0x000A, 0x22 },
 { 0x07, 0x0009, 0xDE }, { 0x08, 0x00FE, 0x23 }, { 0x08, 0x00FD, 0xDD }, { 0x08, 0x00F3, 0x24 },
 { 0x08, 0x00F2, 0xDC }, { 0x08, 0x00EB, 0x25 }, { 0x08, 0x00EA, 0xDB }, { 0x08, 0x00D5, 0x26 },
 { 0x08, 0x00D4, 0xDA }, { 0x08, 0x0095, 0x27 }, { 0x08, 0x0094, 0xD9 }, { 0x08, 0x006E, 0x28 },
 { 0x08, 0x0061, 0xD8 }, { 0x08, 0x0042, 0x29 }, { 0x08, 0x0041, 0xD7 }, { 0x08, 0x002B, 0x2A },
 { 0x08, 0x002A, 0xD6 }, { 0x08, 0x0010, 0x2B }, { 0x09, 0x01FF, 0xD5 }, { 0x09, 0x01F9, 0x2C },
 { 0x09, 0x01F8, 0xD4 }, { 0x09, 0x01DA, 0x2D }, { 0x09, 0x01D9, 0xD3 }, { 0x09, 0x0157, 0x2E },
 { 0x09, 0x0156, 0xD2 }, { 0x09, 0x0154, 0x2F }, { 0x09, 0x00DF, 0xD1 }, { 0x09, 0x00C0, 0x30 },
 { 0x09, 0x0087, 0xD0 }, { 0x09, 0x0081, 0x31 }, { 0x09, 0x0080, 0xCF }, { 0x09, 0x0022, 0x32 },
 { 0x0A, 0x03FD, 0xCE }, { 0x0A, 0x03B7, 0x33 }, { 0x0A, 0x03B6, 0xCD }, { 0x0A, 0x03B0, 0x34 },
 { 0x0A, 0x02AB, 0xCC }, { 0x0A, 0x01BD, 0x35 }, { 0x0A, 0x01BC, 0xCB }, { 0x0A, 0x010D, 0x36 },
 { 0x0A, 0x010C, 0xCA }, { 0x0A, 0x0047, 0x37 }, { 0x0A, 0x0046, 0xC9 }, { 0x0B, 0x07F8, 0x38 },
 { 0x0B, 0x0763, 0xC8 }, { 0x0B, 0x0554, 0x39 }, { 0x0B, 0x0307, 0xC7 }, { 0x0B, 0x0306, 0x3A },
 { 0x0B, 0x0305, 0xC6 }, { 0x0C, 0x0FF3, 0x3B }, { 0x0C, 0x0FF2, 0xC5 }, { 0x0C, 0x0EC4, 0x3C },
 { 0x0C, 0x0AAB, 0xC4 }, { 0x0C, 0x0609, 0x3D }, { 0x0C, 0x0608, 0xC3 }, { 0x0D, 0x1D8A, 0x3E },
 { 0x0D, 0x1555, 0xC2 }, { 0x0D, 0x1554, 0x3F }, { 0x0E, 0x3B17, 0xC1 }, { 0x0F, 0x762D, 0x40 },
 { 0x0F, 0x762C, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t bitalloc_g_129[ 130 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x04, 0x0000, 0x00 }, { 0x05, 0x001D, 0x01 }, { 0x05, 0x001C, 0xFF }, { 0x05, 0x0019, 0x02 },
 { 0x05, 0x0018, 0xFE }, { 0x05, 0x0015, 0x03 }, { 0x05, 0x0014, 0xFD }, { 0x05, 0x0011, 0x04 },
 { 0x05, 0x0010, 0xFC }, { 0x05, 0x000D, 0x05 }, { 0x05, 0x000C, 0xFB }, { 0x05, 0x0009, 0x06 },
 { 0x05, 0x0008, 0xFA }, { 0x05, 0x0005, 0x07 }, { 0x05, 0x0004, 0xF9 }, { 0x06, 0x003F, 0x08 },
 { 0x06, 0x003E, 0xF8 }, { 0x06, 0x0037, 0x09 }, { 0x06, 0x0036, 0xF7 }, { 0x06, 0x002F, 0x0A },
 { 0x06, 0x002E, 0xF6 }, { 0x06, 0x0027, 0x0B }, { 0x06, 0x0026, 0xF5 }, { 0x06, 0x001F, 0x0C },
 { 0x06, 0x001E, 0xF4 }, { 0x06, 0x0017, 0x0D }, { 0x06, 0x0016, 0xF3 }, { 0x06, 0x000F, 0x0E },
 { 0x06, 0x000E, 0xF2 }, { 0x06, 0x0007, 0x0F }, { 0x06, 0x0006, 0xF1 }, { 0x07, 0x007B, 0x10 },
 { 0x07, 0x007A, 0xF0 }, { 0x07, 0x006B, 0x11 }, { 0x07, 0x006A, 0xEF }, { 0x07, 0x005B, 0x12 },
 { 0x07, 0x005A, 0xEE }, { 0x07, 0x004B, 0x13 }, { 0x07, 0x004A, 0xED }, { 0x07, 0x003B, 0x14 },
 { 0x07, 0x003A, 0xEC }, { 0x07, 0x002B, 0x15 }, { 0x07, 0x002A, 0xEB }, { 0x07, 0x001B, 0x16 },
 { 0x07, 0x001A, 0xEA }, { 0x07, 0x000B, 0x17 }, { 0x07, 0x000A, 0xE9 }, { 0x07, 0x0008, 0x18 },
 { 0x08, 0x00F3, 0xE8 }, { 0x08, 0x00F0, 0x19 }, { 0x08, 0x00D3, 0xE7 }, { 0x08, 0x00D0, 0x1A },
 { 0x08, 0x00B3, 0xE6 }, { 0x08, 0x00B0, 0x1B }, { 0x08, 0x0093, 0xE5 }, { 0x08, 0x0090, 0x1C },
 { 0x08, 0x0073, 0xE4 }, { 0x08, 0x0070, 0x1D }, { 0x08, 0x0053, 0xE3 }, { 0x08, 0x0050, 0x1E },
 { 0x08, 0x0033, 0xE2 }, { 0x08, 0x0030, 0x1F }, { 0x08, 0x0013, 0xE1 }, { 0x09, 0x01E4, 0x20 },
 { 0x09, 0x01E3, 0xE0 }, { 0x09, 0x01A5, 0x21 }, { 0x09, 0x01A4, 0xDF }, { 0x09, 0x0165, 0x22 },
 { 0x09, 0x0164, 0xDE }, { 0x09, 0x0125, 0x23 }, { 0x09, 0x0124, 0xDD }, { 0x09, 0x00E5, 0x24 },
 { 0x09, 0x00E4, 0xDC }, { 0x09, 0x00E2, 0x25 }, { 0x09, 0x00A5, 0xDB }, { 0x09, 0x00A2, 0x26 },
 { 0x09, 0x0065, 0xDA }, { 0x09, 0x0062, 0x27 }, { 0x09, 0x0025, 0xD9 }, { 0x0A, 0x03CA, 0x28 },
 { 0x0A, 0x03C5, 0xD8 }, { 0x0A, 0x0347, 0x29 }, { 0x0A, 0x0346, 0xD7 }, { 0x0A, 0x02C7, 0x2A },
 { 0x0A, 0x02C6, 0xD6 }, { 0x0A, 0x02C4, 0x2B }, { 0x0A, 0x0247, 0xD5 }, { 0x0A, 0x0244, 0x2C },
 { 0x0A, 0x01C7, 0xD4 }, { 0x0A, 0x0149, 0x2D }, { 0x0A, 0x0148, 0xD3 }, { 0x0A, 0x00C9, 0x2E },
 { 0x0A, 0x00C8, 0xD2 }, { 0x0A, 0x00C6, 0x2F }, { 0x0A, 0x0049, 0xD1 }, { 0x0B, 0x0796, 0x30 },
 { 0x0B, 0x0789, 0xD0 }, { 0x0B, 0x068B, 0x31 }, { 0x0B, 0x068A, 0xCF }, { 0x0B, 0x0688, 0x32 },
 { 0x0B, 0x058B, 0xCE }, { 0x0B, 0x048D, 0x33 }, { 0x0B, 0x048C, 0xCD }, { 0x0B, 0x048A, 0x34 },
 { 0x0B, 0x038D, 0xCC }, { 0x0B, 0x028F, 0x35 }, { 0x0B, 0x028E, 0xCB }, { 0x0B, 0x028C, 0x36 },
 { 0x0B, 0x018F, 0xCA }, { 0x0B, 0x0091, 0x37 }, { 0x0B, 0x0090, 0xC9 }, { 0x0C, 0x0F2E, 0x38 },
 { 0x0C, 0x0F11, 0xC8 }, { 0x0C, 0x0D13, 0x39 }, { 0x0C, 0x0D12, 0xC7 }, { 0x0C, 0x0B15, 0x3A },
 { 0x0C, 0x0B14, 0xC6 }, { 0x0C, 0x0917, 0x3B }, { 0x0C, 0x0916, 0xC5 }, { 0x0C, 0x0719, 0x3C },
 { 0x0C, 0x0718, 0xC4 }, { 0x0C, 0x051B, 0x3D }, { 0x0C, 0x051A, 0xC3 }, { 0x0C, 0x031D, 0x3E },
 { 0x0C, 0x031C, 0xC2 }, { 0x0D, 0x1E5F, 0x3F }, { 0x0D, 0x1E5E, 0xC1 }, { 0x0D, 0x1E21, 0x40 },
 { 0x0D, 0x1E20, 0xC0 }, { 0x00, 0x0000, 0x00 }
};

static const huff_entry_t* const bitalloc_select[ 11 ][ 8 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0 },
 { bitalloc_a_3, 0 },
 { bitalloc_a_5,  bitalloc_b_5,  bitalloc_c_5,  0 },
 { bitalloc_a_7,  bitalloc_b_7,  bitalloc_c_7,  0 },
 { bitalloc_a_9,  bitalloc_b_9,  bitalloc_c_9,  0 },
 { bitalloc_a_13, bitalloc_b_13, bitalloc_c_13, 0 },
 {
   bitalloc_a_17, bitalloc_b_17, bitalloc_c_17, bitalloc_d_17,
   bitalloc_e_17, bitalloc_f_17, bitalloc_g_17, 0
 },
 {
   bitalloc_a_25, bitalloc_b_25, bitalloc_c_25, bitalloc_d_25,
   bitalloc_e_25, bitalloc_f_25, bitalloc_g_25, 0
 },
 {
   bitalloc_a_33, bitalloc_b_33, bitalloc_c_33, bitalloc_d_33,
   bitalloc_e_33, bitalloc_f_33, bitalloc_g_33, 0
 },
 { bitalloc_a_65, bitalloc_b_65, bitalloc_c_65, bitalloc_d_65,
   bitalloc_e_65, bitalloc_f_65, bitalloc_g_65, 0
 },
 { bitalloc_a_129, bitalloc_b_129, bitalloc_c_129, bitalloc_d_129,
   bitalloc_e_129, bitalloc_f_129, bitalloc_g_129, 0
 },
};

static const int scale_factor_quant6[ 64 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000001, 0x00000002, 0x00000002, 0x00000003,
 0x00000003, 0x00000004, 0x00000006, 0x00000007,
 0x0000000A, 0x0000000C, 0x00000010, 0x00000014,
 0x0000001A, 0x00000022, 0x0000002C, 0x00000038,
 0x00000048, 0x0000005D, 0x00000078, 0x0000009B,
 0x000000C8, 0x00000101, 0x0000014B, 0x000001AB,
 0x00000226, 0x000002C4, 0x00000390, 0x00000497,
 0x000005EA, 0x0000079E, 0x000009D0, 0x00000CA4,
 0x00001049, 0x000014FA, 0x00001B06, 0x000022D1,
 0x00002CDA, 0x000039C7, 0x00004A6F, 0x00005FE3,
 0x00007B87, 0x00009F22, 0x0000CD01, 0x00010818,
 0x00015438, 0x0001B64A, 0x000234A0, 0x0002D761,
 0x0003A90B, 0x0004B726, 0x0006131B, 0x0007D35D,
 0x000A14D5, 0x000CFCC2, 0x0010BB1E, 0x00158DBA,
 0x001BC435, 0x0023C525, 0x002E14B0, 0x003B5D13,
 0x004C79A0, 0x006284DE, 0x007EEAC6, 0x00000000
};

static const int scale_factor_quant7[ 128 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000001, 0x00000001, 0x00000002, 0x00000002,
 0x00000002, 0x00000002, 0x00000003, 0x00000003,
 0x00000003, 0x00000004, 0x00000004, 0x00000005,
 0x00000006, 0x00000007, 0x00000007, 0x00000008,
 0x0000000A, 0x0000000B, 0x0000000C, 0x0000000E,
 0x00000010, 0x00000012, 0x00000014, 0x00000017,
 0x0000001A, 0x0000001E, 0x00000022, 0x00000026,
 0x0000002C, 0x00000032, 0x00000038, 0x00000040,
 0x00000048, 0x00000052, 0x0000005D, 0x0000006A,
 0x00000078, 0x00000088, 0x0000009B, 0x000000B0,
 0x000000C8, 0x000000E2, 0x00000101, 0x00000124,
 0x0000014B, 0x00000178, 0x000001AB, 0x000001E4,
 0x00000226, 0x00000270, 0x000002C4, 0x00000324,
 0x00000390, 0x0000040B, 0x00000497, 0x00000536,
 0x000005EA, 0x000006B6, 0x0000079E, 0x000008A5,
 0x000009D0, 0x00000B23, 0x00000CA4, 0x00000E59,
 0x00001049, 0x0000127C, 0x000014FA, 0x000017CF,
 0x00001B06, 0x00001EAC, 0x000022D1, 0x00002784,
 0x00002CDA, 0x000032E8, 0x000039C7, 0x00004194,
 0x00004A6F, 0x0000547B, 0x00005FE3, 0x00006CD5,
 0x00007B87, 0x00008C34, 0x00009F22, 0x0000B49E,
 0x0000CD01, 0x0000E8AE, 0x00010818, 0x00012BC0,
 0x00015438, 0x00018227, 0x0001B64A, 0x0001F176,
 0x000234A0, 0x000280DB, 0x0002D761, 0x00033995,
 0x0003A90B, 0x0004278E, 0x0004B726, 0x00055A20,
 0x0006131B, 0x0006E510, 0x0007D35D, 0x0008E1D7,
 0x000A14D5, 0x000B7146, 0x000CFCC2, 0x000EBDA3,
 0x0010BB1E, 0x0012FD63, 0x00158DBA, 0x001876AD,
 0x001BC435, 0x001F83E4, 0x0023C525, 0x00289975,
 0x002E14B0, 0x00344D5E, 0x003B5D13, 0x004360D8,
 0x004C79A0, 0x0056CCD1, 0x006284DE, 0x006FD1F5,
 0x007EEAC6, 0x00000000, 0x00000000, 0x00000000
};

static const int lossy_quant[ 32 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000000, 0x00666666, 0x00400000, 0x00333333,
 0x0025C28F, 0x00200000, 0x001AE148, 0x0015C28F,
 0x000C28F6, 0x00070A3D, 0x0003D70A, 0x00023D71,
 0x0001374C, 0x0000B439, 0x00006A7F, 0x00004189,
 0x000028F6, 0x000016F0, 0x00000D1B, 0x0000075F,
 0x000004EA, 0x000002C9, 0x00000150, 0x000000A8,
 0x00000054, 0x0000002A, 0x00000015, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

static const unsigned int lossy_quant_d[ 32 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000000, 0x3FCCCCCD, 0x3F800000, 0x3F4CCCCD,
 0x3F170A3D, 0x3F000000, 0x3ED70A3D, 0x3EAE147B,
 0x3E428F5C, 0x3DE147AE, 0x3D75C28F, 0x3D0F5C29,
 0x3C9BA5E3, 0x3C343958, 0x3BD4FDF4, 0x3B83126F,
 0x3B23D70A, 0x3AB78034, 0x3A51B717, 0x39EBEDFA,
 0x399D4952, 0x39324207, 0x38A7C5AC, 0x3827C5AC,
 0x37A7C5AC, 0x3727C5AC, 0x36A7C5AC, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

static const int lossless_quant[ 32 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000000, 0x00400000, 0x00200000, 0x00151EB8,
 0x00100000, 0x000A9FBE, 0x00080000, 0x00054FDF,
 0x00040000, 0x00020000, 0x0000FF97, 0x00008102,
 0x00004042, 0x00002010, 0x00001004, 0x00000801,
 0x00000400, 0x00000200, 0x00000100, 0x00000080,
 0x00000040, 0x00000020, 0x00000010, 0x00000008,
 0x00000004, 0x00000002, 0x00000001, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

static const unsigned int lossless_quant_d[ 32 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x00000000, 0x3F800000, 0x3F000000, 0x3EA8F5C3,
 0x3E800000, 0x3E29FBE7, 0x3E000000, 0x3DA9FBE7,
 0x3D800000, 0x3D000000, 0x3C7F9724, 0x3C0101F3,
 0x3B80841F, 0x3B004103, 0x3A801F75, 0x3A000EAE,
 0x398007F8, 0x390007F8, 0x3880029A, 0x3800029A,
 0x3780029A, 0x36FFFC9C, 0x3680029A, 0x35FFF405,
 0x358000E2, 0x34FFFAE5, 0x347FFAE5, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

static const unsigned short adpcm_vb[ 4096 ][ 4 ] __attribute__(   (  section( ".data" )  )   ) = {
 { 0x26C8, 0xF5C6, 0xFBBB, 0xFB11 }, { 0x2B45, 0xF4C4, 0xF92D, 0xFECC },
 { 0x2907, 0xFBC6, 0xFA6E, 0xFB71 }, { 0x2479, 0xF69D, 0xFA29, 0x0112 },
 { 0x29CA, 0xF61F, 0xFDEC, 0xFB9E }, { 0x2880, 0xF07A, 0xFB10, 0xFD12 },
 { 0x2756, 0xF1AD, 0x015A, 0x035F }, { 0x2826, 0xF3EB, 0x0137, 0xFDC0 },
 { 0x26A6, 0xFACE, 0xFA6C, 0xFCA4 }, { 0x2930, 0xF87D, 0xFBDE, 0xFC35 },
 { 0x2AF4, 0xF9A0, 0xFCB7, 0xFA84 }, { 0x2E38, 0xF277, 0x067A, 0xF83A },
 { 0x2A64, 0xFD50, 0xF59E, 0xFE0D }, { 0x2932, 0xF92B, 0xFF6D, 0xF93B },
 { 0x2A31, 0xFC14, 0xFD3C, 0xFA53 }, { 0x295C, 0xFE47, 0xF7BF, 0xFC48 },
 { 0x279D, 0xF2FD, 0xFDBA, 0xFA68 }, { 0x2588, 0xF5E2, 0x017F, 0x0102 },
 { 0x2C9E, 0xF33F, 0x00E5, 0xF9F8 }, { 0x28DC, 0xFAC6, 0xFD37, 0xF9E0 },
 { 0x2842, 0xF947, 0xF984, 0xFDA5 }, { 0x256C, 0xF8EC, 0xFB2D, 0xFBDB },
 { 0x2CCF, 0xF713, 0xF9AF, 0xFDA1 }, { 0x2761, 0xF74F, 0xFA80, 0xFC9C },
 { 0x29DB, 0xF5C0, 0xFAA9, 0xFD40 }, { 0x2978, 0xF8B1, 0xF52E, 0xFFDD },
 { 0x2488, 0xF6DC, 0xFC00, 0xF9E2 }, { 0x2B39, 0xFA4E, 0xF87A, 0xFD21 },
 { 0x2C46, 0xF7F8, 0xFBEF, 0xFB88 }, { 0x2661, 0xF800, 0xFCE6, 0xFA00 },
 { 0x2E4A, 0xF579, 0xFB9D, 0xFC9D }, { 0x299E, 0xF74E, 0xF89D, 0xFE8B },
 { 0x2728, 0xF9EB, 0xFCD8, 0xFBD3 }, { 0x2B86, 0xFB0E, 0xF35A, 0x0080 },
 { 0x2DD1, 0xF32E, 0xFDFE, 0xFC0D }, { 0x2C8A, 0xF7D2, 0xF6E1, 0xFF43 },
 { 0x27D3, 0xF1B6, 0x00B5, 0xF8AD }, { 0x2CA7, 0xF5BE, 0xFE6C, 0xFA9F },
 { 0x2AF9, 0xF0E4, 0xFD95, 0xFBCB }, { 0x2A8E, 0xF601, 0x0112, 0xF922 },
 { 0x25A1, 0xFA36, 0xF733, 0xFCFB }, { 0x2BED, 0xF307, 0x033E, 0xF84C },
 { 0x2628, 0xF573, 0xFF39, 0xF8BD }, { 0x2904, 0xF806, 0x020D, 0xF805 },
 { 0x2D95, 0xF01B, 0x0125, 0xFA44 }, { 0x23E8, 0xF839, 0xFDB9, 0xFFC3 },
 { 0x2749, 0xF36C, 0xF821, 0xFE27 }, { 0x2519, 0xF6F5, 0xF646, 0xFE2D },
 { 0x28D7, 0xF403, 0xFB56, 0xFC11 }, { 0x270A, 0xF870, 0xFFC4, 0xFB37 },
 { 0x244F, 0xF794, 0xF91F, 0xFB92 }, { 0x2765, 0xF15C, 0xFBFE, 0x00C5 },
 { 0x2476, 0xF6C8, 0x0324, 0xFEA1 }, { 0x2D29, 0xF607, 0x0548, 0xF6F7 },
 { 0x3225, 0xF062, 0x04AB, 0xF85A }, { 0x2782, 0xFBB4, 0xF692, 0xFE76 },
 { 0x247D, 0xF61E, 0x013B, 0x02F3 }, { 0x2793, 0xF3A4, 0x0583, 0xFD5E },
 { 0x253F, 0xFC77, 0xF9F1, 0x0243 }, { 0x2DC5, 0xFA11, 0xF415, 0x005B },
 { 0x2660, 0xF4A1, 0xF529, 0x00C0 }, { 0x25BE, 0xF48A, 0xFDCF, 0x05AA },
 { 0x2B4D, 0xF2C0, 0xFAEE, 0xFD6D }, { 0x22FB, 0xF7CA, 0xF895, 0x02BF },
 { 0x219F, 0xF932, 0xEF04, 0x032E }, { 0x1DD8, 0xF7F1, 0xF1DF, 0x0034 },
 { 0x1BA2, 0xFCC6, 0xEF1B, 0x1117 }, { 0x1E22, 0x0248, 0xEF72, 0x0787 },
 { 0x18D3, 0xFC48, 0xECD0, 0x0C37 }, { 0x1B9D, 0xFD6C, 0xE6F3, 0x0FF7 },
 { 0x2079, 0xFF7C, 0xF46C, 0xFC94 }, { 0x1B28, 0xFA72, 0xF086, 0xFFE8 },
 { 0x2453, 0xFD22, 0xF3F0, 0xFEF9 }, { 0x250C, 0xFDC2, 0xEE5F, 0x01D2 },
 { 0x1C4E, 0xFFA5, 0xF169, 0xFD40 }, { 0x2085, 0xFA77, 0xF3EE, 0xFDEE },
 { 0x1945, 0xFB36, 0xED6B, 0x033D }, { 0x19FC, 0xFE90, 0xE9CE, 0x0571 },
 { 0x1F23, 0xFB02, 0xF714, 0x04B5 }, { 0x1C3D, 0xFD45, 0xF21C, 0x0730 },
 { 0x1F3A, 0x0504, 0xF557, 0x02DC }, { 0x232D, 0xFD46, 0xEE56, 0x088D },
 { 0x1B33, 0x00C5, 0xF559, 0x017C }, { 0x214F, 0x0087, 0xF069, 0xFF2B },
 { 0x2288, 0x03A6, 0xF43A, 0xFDC9 }, { 0x278D, 0x01A2, 0xF32C, 0xFE8D },
 { 0x18DF, 0x0169, 0xF6F2, 0x09FA }, { 0x1ED4, 0x00AC, 0xEB81, 0x1241 },
 { 0x1A12, 0x0183, 0xEAD0, 0x112E }, { 0x1860, 0x02AC, 0xF031, 0x04C3 },
 { 0x2BA2, 0xFCE6, 0xEC27, 0x04AB }, { 0x2DF5, 0xFD78, 0xE787, 0x0804 },
 { 0x2A5D, 0xFCF9, 0xF103, 0x016E }, { 0x30D0, 0xFD4F, 0xDFBC, 0x0DEA },
 { 0x1ED5, 0xFB72, 0xEC94, 0x03DC }, { 0x2190, 0x041C, 0xE89E, 0x0C0F },
 { 0x1C6D, 0x0752, 0xE9CB, 0x0DFB }, { 0x1AF4, 0x07E0, 0xED37, 0x0DA3 },
 { 0x2152, 0xF69B, 0xF34E, 0x07C2 }, { 0x24D2, 0x01EE, 0xE465, 0x13AE },
 { 0x282D, 0x0234, 0xDFEE, 0x14FA }, { 0x222D, 0xF761, 0xF074, 0x0B24 },
 { 0x25B5, 0xF582, 0xEF34, 0x0578 }, { 0x262A, 0xF712, 0xE9E1, 0x1089 },
 { 0x212A, 0xFFFC, 0xE478, 0x1190 }, { 0x1E11, 0xFB47, 0xEB30, 0x0C6F },
 { 0x1933, 0x0321, 0xEF1C, 0xFDD6 }, { 0x1CDB, 0x070E, 0xEB6F, 0x0221 },
 { 0x1D1A, 0xF702, 0xEEA3, 0x058A }, { 0x2271, 0xFAA6, 0xE93D, 0x0878 },
 { 0x2854, 0xF69A, 0xEA03, 0x0A13 }, { 0x229F, 0xF5EE, 0xF22F, 0x01D3 },
 { 0x1AF5, 0xF9A8, 0xF39F, 0x0D40 }, { 0x1EA6, 0x009C, 0xE4DC, 0x0D35 },
 { 0x1EF8, 0xFBA5, 0xE8AC, 0x12D0 }, { 0x17C9, 0xFDA9, 0xEEF0, 0xFEC0 },
 { 0x1E99, 0x04DE, 0xF088, 0xFD93 }, { 0x22E3, 0x09D9, 0xE590, 0x0804 },
 { 0x22C4, 0x0798, 0xEFE2, 0x0028 }, { 0x1DED, 0xFFDE, 0xF4D9, 0x09B0 },
 { 0x16F1, 0x01DA, 0xF342, 0x0E80 }, { 0x1D6F, 0xFF16, 0xEDA5, 0x00D8 },
 { 0x16E0, 0x008F, 0xEBEA, 0x0049 }, { 0x22F0, 0xFF96, 0xE90E, 0x0E4F },
 { 0x1BDE, 0x01AA, 0xE909, 0x0B4F }, { 0x27D7, 0x03F3, 0xED66, 0x0171 },
 { 0x2106, 0x0108, 0xE8AD, 0x050B }, { 0x1E8E, 0xF66F, 0xEF13, 0x11BC },
 { 0x1838, 0xF53A, 0xF5B8, 0x05D9 }, { 0x17B6, 0xEF25, 0xF575, 0x019E },
 { 0x1B87, 0xF165, 0xF376, 0x0424 }, { 0x162B, 0xF127, 0xF563, 0xFE69 },
 { 0x12B5, 0xF021, 0xF5BC, 0xFD18 }, { 0x0FB7, 0xF2DA, 0xF3C3, 0xFD2A },
 { 0x10C8, 0xF699, 0xF2CB, 0xFDFF }, { 0x1124, 0xF48D, 0xF4FC, 0x05E8 },
 { 0x11CF, 0xEF77, 0xF86B, 0x07B8 }, { 0x1A2E, 0xF378, 0xF925, 0x0690 },
 { 0x1140, 0xF23F, 0xFBE4, 0x0BA8 }, { 0x1BF2, 0xEF56, 0xFB4D, 0x0E94 },
 { 0x0E29, 0xEF6E, 0xF354, 0x0573 }, { 0x1976, 0xF4D8, 0xFAE8, 0x0B47 },
 { 0x181A, 0xF863, 0xF43A, 0x0F85 }, { 0x1445, 0xF66D, 0xF04C, 0x0D95 },
 { 0x184A, 0xF454, 0xF87F, 0x0F04 }, { 0x12DB, 0xF198, 0xF878, 0x0D0F },
 { 0x1A0C, 0xF069, 0xF50B, 0x0C17 }, { 0x14B1, 0xF3D5, 0xF19C, 0x0956 },
 { 0x14EA, 0xEDFA, 0xF59A, 0x05E0 }, { 0x1064, 0xF3ED, 0xEFCD, 0x046F },
 { 0x0DD4, 0xF4B3, 0xF059, 0x0064 }, { 0x15C1, 0xF9BE, 0xF059, 0x0775 },
 { 0x10F5, 0xF7D5, 0xEF50, 0x00FC }, { 0x15B7, 0xF4C2, 0xF108, 0x01F2 },
 { 0x11C4, 0xEE81, 0xF4AE, 0xFFE5 }, { 0x1438, 0xF642, 0xEDE5, 0x05C4 },
 { 0x0CDE, 0xF263, 0xF166, 0x02CC }, { 0x1338, 0xFB33, 0xEF9D, 0xFE93 },
 { 0x0CB9, 0xF242, 0xF2EB, 0x0B2E }, { 0x14A6, 0xF864, 0xF263, 0xFCF6 },
 { 0x1966, 0xF415, 0xFF68, 0x0B26 }, { 0x16E8, 0xEFA0, 0xFBCC, 0x0D7B },
 { 0x1230, 0xF3CE, 0xF288, 0x00B3 }, { 0x1713, 0xFD0E, 0xF9C4, 0x0C2C },
 { 0x1C3D, 0xF1A0, 0xF9CA, 0x0B4C }, { 0x13F3, 0xF0D0, 0xF2DC, 0x0326 },
 { 0x1A6C, 0xF5B5, 0xF286, 0x0086 }, { 0x148A, 0xF4F5, 0xF4E4, 0xFBE4 },
 { 0x16A6, 0xF943, 0xEF2F, 0x00CD }, { 0x151C, 0xFB43, 0xF2DE, 0x01C1 },
 { 0x1850, 0xF54E, 0xF41A, 0xFDBB }, { 0x107F, 0xF67A, 0xF55B, 0x0EA1 },
 { 0x128F, 0xF2AD, 0xF7B5, 0x0074 }, { 0x0F1C, 0xF448, 0xF08E, 0x08F9 },
 { 0x1AA3, 0xF4AD, 0xEF4B, 0x0B09 }, { 0x106F, 0xED6E, 0xF508, 0x0361 },
 { 0x12C4, 0xFA2A, 0xF833, 0x1250 }, { 0x14A2, 0xF75B, 0xFDDC, 0x0DE7 },
 { 0x15CC, 0xF888, 0xFDCA, 0x1112 }, { 0x1818, 0xF4D7, 0xFD60, 0x0FD5 },
 { 0x19B7, 0xEE5D, 0xF4DE, 0x0686 }, { 0x196F, 0xF3EB, 0xF06C, 0x058D },
 { 0x1226, 0xF902, 0xFA5D, 0x0E42 }, { 0x171B, 0xFC64, 0xF81C, 0x0380 },
 { 0x1E86, 0xEFAB, 0xF3B0, 0x07D7 }, { 0x182E, 0xF742, 0xED2F, 0x08E7 },
 { 0x1281, 0xF03E, 0xF328, 0x072B }, { 0x1FE1, 0xF1CF, 0xF2A1, 0x0C41 },
 { 0x1CF7, 0xF6D1, 0xF7D8, 0x10C2 }, { 0x100A, 0xF62B, 0xFFC2, 0x0B59 },
 { 0x132D, 0xF3B7, 0xFD9A, 0x1010 }, { 0x134A, 0xF32F, 0xFE73, 0x044C },
 { 0xFF53, 0x0397, 0x0635, 0xEB0D }, { 0xFFF3, 0x031C, 0xFED9, 0xE601 },
 { 0xF8BC, 0xFCC3, 0x0475, 0xEE35 }, { 0x08FA, 0xFCBA, 0xFD68, 0xEC73 },
 { 0xFC8C, 0xFBB7, 0x081A, 0xEDFB }, { 0xFF9B, 0x0119, 0x0B1E, 0xEE49 },
 { 0x048E, 0x01C5, 0x097D, 0xE8EA }, { 0x036F, 0xFD68, 0x0942, 0xEAB4 },
 { 0x0587, 0xFE8E, 0xF95D, 0xED89 }, { 0xFA7B, 0x04FD, 0xFD63, 0xE607 },
 { 0x0855, 0x0130, 0xFC38, 0xEDF0 }, { 0x017C, 0x024A, 0xF7D9, 0xECE4 },
 { 0x0538, 0x0113, 0xFFAE, 0xE963 }, { 0xF665, 0x0421, 0xFFDE, 0xEAD8 },
 { 0x08E6, 0xF922, 0x0362, 0xE9EB }, { 0x0799, 0xF709, 0xFF6B, 0xEB4A },
 { 0x0507, 0xF23B, 0x03E4, 0xEB79 }, { 0x08F9, 0x0323, 0x0499, 0xE84D },
 { 0x00BB, 0xFF4C, 0xFD95, 0xE7C6 }, { 0xFCE7, 0xF617, 0x0612, 0xEC3F },
 { 0xF571, 0xFF34, 0xFD8B, 0xE923 }, { 0xFC11, 0xFF6E, 0x0139, 0xEA32 },
 { 0x033E, 0x0165, 0x0365, 0xE725 }, { 0xFF1C, 0xFDC1, 0xF397, 0xEEAF },
 { 0xFC17, 0xF9EF, 0xFF72, 0xE9B4 }, { 0xF994, 0x0693, 0x06B9, 0xEE4B },
 { 0x037D, 0x0784, 0xFFF1, 0xE961 }, { 0x0893, 0x080D, 0xFEFA, 0xEAA1 },
 { 0x0BD7, 0x010E, 0x0137, 0xEC18 }, { 0x0778, 0x0666, 0xFA0D, 0xEDBB },
 { 0xF3BA, 0xFFC9, 0x00FD, 0xECCE }, { 0x0164, 0xF970, 0x0157, 0xE815 },
 { 0xF73F, 0xF93A, 0xFC30, 0xE8CD }, { 0xF76C, 0xF4B3, 0x0223, 0xECB6 },
 { 0xFB23, 0x007E, 0xF884, 0xEAD5 }, { 0xFF07, 0xF155, 0xFA72, 0xEA26 },
 { 0x023F, 0xF585, 0xF87A, 0xEE2A }, { 0xFD06, 0x075D, 0x00C0, 0xE908 },
 { 0xFCD5, 0xF5FE, 0xFBD4, 0xE883 }, { 0xF728, 0xF3F2, 0xFC30, 0xED59 },
 { 0x0046, 0xFB41, 0x0B40, 0xEEC6 }, { 0x02CA, 0xF150, 0x0B64, 0xEDAD },
 { 0xFF0C, 0xF2B4, 0x06CC, 0xEE73 }, { 0x02AC, 0xEBEF, 0xFEB8, 0xEA18 },
 { 0xFDEF, 0xF10F, 0xF906, 0xEE49 }, { 0xFD37, 0xED79, 0xFBA2, 0xEA56 },
 { 0x0A9E, 0xF134, 0x0706, 0xE9B4 }, { 0xF999, 0xF1A1, 0xF9E4, 0xE831 },
 { 0x069D, 0xF5AE, 0xFA93, 0xEE45 }, { 0x01F9, 0xF9DB, 0xF98D, 0xECF2 },
 { 0xFCBD, 0xF730, 0xF86B, 0xEB18 }, { 0x05B8, 0xFE65, 0x07C9, 0xE6D7 },
 { 0x01ED, 0xF390, 0xFF6F, 0xE7FC }, { 0xFA7B, 0x01F3, 0xF9AF, 0xE6B1 },
 { 0xFEDA, 0x06BA, 0xFA75, 0xE9A3 }, { 0xF487, 0xFA08, 0xFF51, 0xEDF0 },
 { 0xFDAE, 0xE8E9, 0xFFC8, 0xE7FE }, { 0xFED4, 0xEF4D, 0x0484, 0xE8C5 },
 { 0x0228, 0xF5AD, 0x0A6D, 0xF089 }, { 0x0389, 0xEFC2, 0x06FD, 0xE94F },
 { 0x0538, 0xF827, 0x083C, 0xE8F1 }, { 0x0613, 0xF1F0, 0x0456, 0xE599 },
 { 0xFAF2, 0xF278, 0x004D, 0xE83C }, { 0xFB8D, 0xF05A, 0xFB0A, 0xEFAB },
 { 0xEC1A, 0xF320, 0x0444, 0xF4E1 }, { 0xEA81, 0xF4BD, 0x07C0, 0xF7ED },
 { 0xEDC1, 0xEF86, 0xFA77, 0xEFDC }, { 0xF14D, 0xF116, 0x04EE, 0xF3F6 },
 { 0xEBF4, 0xF29A, 0x0B70, 0xFD28 }, { 0xE8BB, 0xF4C3, 0x04E3, 0xF672 },
 { 0xEEB7, 0xF6F1, 0xFF2C, 0xEF4C }, { 0xE7C7, 0xF837, 0x06EE, 0xF77A },
 { 0xEA84, 0xF104, 0x0899, 0xFA8C }, { 0xE4EA, 0xF6E2, 0x093E, 0xFAF3 },
 { 0xE814, 0xEFD4, 0x0539, 0xF847 }, { 0xE667, 0xEFA6, 0x06DC, 0xFAD3 },
 { 0xEBFA, 0xFB16, 0x02E8, 0xF1B8 }, { 0xEBD1, 0xFA92, 0x062D, 0xF4B1 },
 { 0xEE53, 0xF2BA, 0x097D, 0xF8B7 }, { 0xF014, 0xF391, 0x07EB, 0xF632 },
 { 0xE7D1, 0xF336, 0x072E, 0xF8EA }, { 0xEE9A, 0xF53F, 0x0AA3, 0xFB5F },
 { 0xE601, 0xED43, 0x00FB, 0xF5DD }, { 0xE744, 0xF748, 0x0728, 0x00D9 },
 { 0xE913, 0xF95E, 0x0086, 0x0154 }, { 0xE62A, 0xFBEB, 0x084E, 0xF874 },
 { 0xED05, 0xF7C5, 0x07DA, 0xF67D }, { 0xE77E, 0xF9AA, 0x0AF8, 0xFAA2 },
 { 0xF3D1, 0xF377, 0x0209, 0xF06C }, { 0xE9D4, 0xF7DE, 0xFE5C, 0xF569 },
 { 0xE45F, 0xF1D9, 0x02B8, 0xF6D9 }, { 0xE89E, 0xEF80, 0x023C, 0xF66A },
 { 0xEF0C, 0xEE57, 0x0372, 0xF52D }, { 0xE7DE, 0xF873, 0x0217, 0xFA5C },
 { 0xECC5, 0xEFBD, 0x06D0, 0xF7EE }, { 0xE6F6, 0xFA11, 0x0422, 0xF585 },
 { 0xEC2B, 0xFB5F, 0x0358, 0xF758 }, { 0xE44D, 0xF674, 0x02AF, 0xF5DB },
 { 0xEB5C, 0xF78B, 0x0CA7, 0xFC1F }, { 0xED65, 0xFA27, 0x00C5, 0xF395 },
 { 0xEFE0, 0xECA2, 0xFE74, 0xF206 }, { 0xEC42, 0xF0DA, 0xFD79, 0xF590 },
 { 0xE4A3, 0xF2EC, 0x068F, 0xF9D5 }, { 0xE979, 0xFC07, 0x0A16, 0xF885 },
 { 0xE463, 0xF51D, 0x0533, 0xF7EA }, { 0xEA64, 0xF708, 0x02C2, 0xF47A },
 { 0xEC3D, 0xF229, 0xFCCB, 0xF1CB }, { 0xE611, 0xF8D5, 0x03F8, 0xFD48 },
 { 0xEA15, 0xEB9C, 0xFD4A, 0xF2D5 }, { 0xE896, 0xF50D, 0x0B75, 0xFD27 },
 { 0xE8C4, 0xFD95, 0x063C, 0xF58C }, { 0xEA92, 0xEEBD, 0x0099, 0xF33F },
 { 0xEF17, 0xF290, 0x066E, 0xFA61 }, { 0xF00D, 0xF076, 0x00B1, 0xF20F },
 { 0xEF3F, 0xF5D9, 0x04C8, 0xF3FD }, { 0xE9B5, 0xF34B, 0x0778, 0xFD09 },
 { 0xE632, 0xF293, 0x0A02, 0xFDC5 }, { 0xEB7A, 0xF674, 0x0301, 0xFEA0 },
 { 0xE66F, 0xF3AE, 0x0246, 0xFBB1 }, { 0xEB30, 0xF73F, 0x0A06, 0xF911 },
 { 0xE3D0, 0xF870, 0x0602, 0xF841 }, { 0xF16E, 0xF66D, 0x01AA, 0xF0E3 },
 { 0xEC0A, 0xFA97, 0x07EF, 0xFB6F }, { 0xE6BA, 0xF565, 0x010D, 0xF3CD },
 { 0xE952, 0xF650, 0xFF9F, 0xF108 }, { 0xF19D, 0xECCC, 0xFE16, 0xEF16 },
 { 0xE73B, 0xF7DD, 0xFD63, 0xFF8D }, { 0xECCF, 0xF011, 0xFCBB, 0xEDBF },
 { 0xF336, 0xF63F, 0x091E, 0xF5A4 }, { 0xFAFA, 0xF93D, 0x09F6, 0xF154 },
 { 0xF2D1, 0xFC93, 0x039E, 0xF077 }, { 0xF623, 0xF7E1, 0x0B3F, 0xF5BF },
 { 0xEB44, 0xFE08, 0x0C27, 0xF9B9 }, { 0xECD8, 0x01CC, 0x0FFD, 0xFB30 },
 { 0xF837, 0x0650, 0x1230, 0xF887 }, { 0xF267, 0xFB68, 0x0C2F, 0xF744 },
 { 0xEFDC, 0xFA22, 0x0923, 0xF60F }, { 0xF612, 0x047F, 0x0DF1, 0xF60A },
 { 0xEEE3, 0x01AE, 0x0C4B, 0xF7DE }, { 0xF0D0, 0x0363, 0x0F3B, 0xF987 },
 { 0xF4D3, 0x050A, 0x106A, 0xF845 }, { 0xF0CB, 0xFF03, 0x093B, 0xF534 },
 { 0xF957, 0x02B0, 0x0EF3, 0xF495 }, { 0xF751, 0x0908, 0x0E74, 0xF3B4 },
 { 0xF83E, 0xFD30, 0x139D, 0xFCE5 }, { 0xF397, 0x00F2, 0x07A0, 0xF2E8 },
 { 0xF8C2, 0x05E5, 0x09E0, 0xF119 }, { 0xF39B, 0x0061, 0x139B, 0xFD3E },
 { 0xF57F, 0xFF6F, 0x055F, 0xF0B5 }, { 0xED1A, 0xFE7F, 0x09B8, 0xF685 },
 { 0xEE33, 0xFE9D, 0x0643, 0xF40C }, { 0xF23E, 0x0728, 0x0CDC, 0xF58E },
 { 0xF147, 0x030C, 0x094A, 0xF570 }, { 0xEF1D, 0xF874, 0x0D56, 0xFB6F },
 { 0xF54C, 0x0486, 0x0AA9, 0xF337 }, { 0xF1C1, 0x00D2, 0x05B8, 0xF4B4 },
 { 0xF6DA, 0xF7CF, 0x05E9, 0xF171 }, { 0xEEBA, 0xFB26, 0x0C3A, 0xF8D7 },
 { 0xFAE4, 0xFBF1, 0x10C2, 0xF8AD }, { 0xF926, 0xF619, 0x0CE2, 0xF6F6 },
 { 0xEFFA, 0xFF46, 0x0FC5, 0xFBBA }, { 0xFC10, 0x0622, 0x0CDA, 0x00AB },
 { 0xF306, 0xF5C3, 0x0AE7, 0xFA00 }, { 0xF615, 0xF5DB, 0x0D72, 0xF978 },
 { 0xF2AD, 0xF821, 0x0E56, 0xFB6A }, { 0xF7CF, 0x02DA, 0x15CD, 0xFA89 },
 { 0xFA1A, 0xFFB6, 0x12D4, 0xF82C }, { 0xF00A, 0xFC9C, 0x1149, 0xFCFD },
 { 0xFC44, 0xFC26, 0x0E38, 0xF493 }, { 0xF7D9, 0xFB1E, 0x0D88, 0xF666 },
 { 0xF314, 0xF695, 0x0536, 0xF1AD }, { 0xF728, 0xFE7B, 0x0FA4, 0xF8C2 },
 { 0xFD58, 0x00EF, 0x0FDA, 0xF2C4 }, { 0xFAB3, 0x001E, 0x0BB1, 0xF1B6 },
 { 0xF1EF, 0xFDD8, 0x0499, 0xFB90 }, { 0xF5AF, 0x01BA, 0x1116, 0xF9A7 },
 { 0xF623, 0x0302, 0x0668, 0xF0C9 }, { 0xF39C, 0xFC85, 0x0F35, 0xF9B8 },
 { 0xF44C, 0x000D, 0x0CCD, 0xF692 }, { 0xFC7D, 0x041F, 0x1176, 0xF63B },
 { 0xFE5A, 0xFDB8, 0x0D93, 0xF135 }, { 0xF846, 0xFDAF, 0x0A06, 0xF2A9 },
 { 0xF3B2, 0xFB00, 0x093A, 0xF419 }, { 0xF1F8, 0x00E0, 0x0402, 0xF0A4 },
 { 0xED18, 0xFB5B, 0x0E31, 0xFC91 }, { 0xF090, 0xF731, 0x0B64, 0xF8DE },
 { 0xF961, 0x001C, 0x0712, 0xFEA3 }, { 0xFD17, 0xF64C, 0x0CEC, 0xF323 },
 { 0xFC08, 0x061B, 0x14F5, 0xF8E1 }, { 0xF784, 0xF905, 0x10AA, 0xFAF9 },
 { 0xFB27, 0xF861, 0x0F8E, 0xF693 }, { 0xF827, 0xF5B1, 0x091A, 0xF268 },
 { 0x13F1, 0xF9AE, 0xF5E4, 0xF821 }, { 0x1961, 0xFA0D, 0xF36E, 0xFC72 },
 { 0x197E, 0xF6FF, 0xF813, 0xF902 }, { 0x14A9, 0xFF9D, 0xF294, 0xFE70 },
 { 0x1695, 0xF9A9, 0xF9D7, 0xF5C7 }, { 0x148B, 0xFD62, 0xF3CB, 0xF95C },
 { 0x18C7, 0xFB18, 0xFEB5, 0xF36A }, { 0x1F1F, 0xFD5A, 0xF76D, 0xFA4A },
 { 0x17E7, 0xFD49, 0xF454, 0xF9FE }, { 0x17DC, 0x01EE, 0xF2E1, 0xF9F4 },
 { 0x13CB, 0x03C9, 0xF6E8, 0xF56D }, { 0x1DAB, 0xFE4D, 0xFA27, 0xF7F8 },
 { 0x1B11, 0xFD31, 0xF68C, 0xF97F }, { 0x1446, 0x0248, 0xF45A, 0xF7C9 },
 { 0x17DA, 0xFE44, 0xFA7D, 0xF54D }, { 0x15D0, 0x0121, 0xF8F4, 0xF50D },
 { 0x149C, 0x00E3, 0xFB64, 0xF2DF }, { 0x1D78, 0xFA0B, 0xF8D6, 0xF943 },
 { 0x1762, 0xFA42, 0xF5D2, 0xF95B }, { 0x13E8, 0xFD03, 0xF950, 0xF442 },
 { 0x152F, 0xFF6B, 0xF0A3, 0xFB7B }, { 0x1DE3, 0x001A, 0xF673, 0xFA1D },
 { 0x1289, 0xFE30, 0xF939, 0xF6C6 }, { 0x14E8, 0xFC0D, 0xFBBA, 0xF831 },
 { 0x189C, 0xFD60, 0xFDE2, 0xF862 }, { 0x1A13, 0xFC04, 0xFADA, 0xFBDD },
 { 0x1C32, 0xF80C, 0xFDA5, 0xF662 }, { 0x1E4B, 0xFA16, 0xF682, 0xFB33 },
 { 0x13B1, 0x01C1, 0xFBE0, 0xF69B }, { 0x1A36, 0xF71B, 0xFAC0, 0xF714 },
 { 0x1AA8, 0xFABD, 0xF732, 0x00FB }, { 0x17B4, 0xF8BF, 0xFC29, 0xFADC },
 { 0x15E3, 0xF77F, 0xF556, 0xFA3B }, { 0x16CE, 0xFBDD, 0xF1EC, 0xFC36 },
 { 0x13D4, 0xFCEB, 0xFEB1, 0xF693 }, { 0x182F, 0xF99E, 0xF830, 0xF7AF },
 { 0x13E4, 0xFAF4, 0xF611, 0xFBF6 }, { 0x14B9, 0x01B3, 0xF952, 0xF8C6 },
 { 0x17FC, 0x0231, 0xF780, 0xF6B4 }, { 0x1A60, 0x015C, 0xF640, 0xF89E },
 { 0x1905, 0x0111, 0xFBB6, 0xF526 }, { 0x1B1E, 0xFAC4, 0xFE10, 0xFA9B },
 { 0x1476, 0xFD51, 0xF66A, 0xF6D3 }, { 0x1B2F, 0xFC8E, 0xF8D7, 0xF7F3 },
 { 0x1894, 0xFF03, 0xF7B3, 0xF769 }, { 0x16CE, 0xFDC2, 0xFD09, 0xF371 },
 { 0x1B2A, 0xFA34, 0xFD80, 0xF52D }, { 0x1D4A, 0xF956, 0xFB46, 0xF796 },
 { 0x1A74, 0xFC15, 0xFB2D, 0xF61C }, { 0x177E, 0x00E4, 0xF796, 0xFBAC },
 { 0x1B1F, 0xF77E, 0xF5AC, 0xFB9E }, { 0x1C5E, 0xFD05, 0xF410, 0xFBBE },
 { 0x1881, 0xFA3A, 0xFBD0, 0x00B1 }, { 0x127E, 0x01A9, 0xF4A0, 0x0165 },
 { 0x1BD9, 0x00A8, 0xF9FF, 0xF6E9 }, { 0x1C24, 0xFE4E, 0xFD16, 0xF59C },
 { 0x1ADF, 0x0039, 0xF3F1, 0xFAE2 }, { 0x120F, 0xFD9E, 0xFD32, 0xF27D },
 { 0x19A5, 0xFDE1, 0xF832, 0xFEAD }, { 0x1290, 0xFEEB, 0xF7EE, 0xFA83 },
 { 0x1D0B, 0xFA78, 0xF890, 0xFE07 }, { 0x0FEC, 0x0096, 0xFB3A, 0xF21C },
 { 0x1BAA, 0xFFE4, 0xFA50, 0xFB6A }, { 0x1735, 0xFE42, 0xFAD2, 0xFB7A },
 { 0x0F1E, 0xF990, 0xF656, 0xF5E3 }, { 0x035A, 0x0025, 0xF2C5, 0xF177 },
 { 0x0DE5, 0xFA21, 0xF980, 0xF2C9 }, { 0x0D08, 0xF84C, 0xF3F9, 0xF758 },
 { 0x0C72, 0x003C, 0xEFA7, 0xFCA1 }, { 0x0D80, 0xFCFB, 0xF406, 0xF667 },
 { 0x1023, 0xFC6F, 0xF7F4, 0xF5D7 }, { 0x114F, 0xFD4D, 0xEFEE, 0xFC34 },
 { 0x0D85, 0xFEB2, 0xF1A0, 0xF929 }, { 0x07D6, 0xFE35, 0xF75A, 0xF10D },
 { 0x052A, 0x0020, 0xF500, 0xF37D }, { 0x1149, 0xF897, 0xF519, 0xF866 },
 { 0x1198, 0x0017, 0xF2A3, 0xF88B }, { 0x0C12, 0xFC8B, 0xF6C2, 0xF340 },
 { 0x0C89, 0xF6C5, 0xF16E, 0xFCBE }, { 0x0CF0, 0xFA41, 0xF1C7, 0xF9D5 },
 { 0x1058, 0xF97B, 0xF305, 0xFB20 }, { 0x088E, 0xFC5D, 0xF31A, 0xF480 },
 { 0x0B83, 0xFF1B, 0xED49, 0xFB55 }, { 0x07E4, 0xF9A6, 0xF574, 0xF3CB },
 { 0x08A6, 0xFEBA, 0xEF00, 0xF96D }, { 0x0CD6, 0xF5C5, 0xF694, 0xF666 },
 { 0x03E8, 0xF5F5, 0xEFDF, 0xF792 }, { 0x09C0, 0xF5BD, 0xF1E5, 0xFA67 },
 { 0x07FB, 0xF771, 0xF789, 0xF10D }, { 0x0A0B, 0xF610, 0xF885, 0xF36A },
 { 0x07E6, 0xFA23, 0xF0F0, 0xF78B }, { 0x0A7D, 0xFB64, 0xFA4B, 0xF03A },
 { 0x064A, 0xF6F7, 0xEED9, 0xFB6B }, { 0x0924, 0xF646, 0xEF89, 0xFDFC },
 { 0x06CE, 0xF5C9, 0xF1D0, 0xF79E }, { 0x020B, 0xFAF3, 0xEF6A, 0xF676 },
 { 0x0E8D, 0xF55D, 0xF43A, 0xF9D8 }, { 0x0DE2, 0xFA9B, 0xEF98, 0xFCC8 },
 { 0x050B, 0xF9C6, 0xED57, 0xFA6A }, { 0x05AC, 0x0203, 0xF470, 0xF10A },
 { 0x10A8, 0xFC82, 0xF317, 0xF8DE }, { 0x0A2E, 0xFA54, 0xEE56, 0xFC3A },
 { 0x04AC, 0xFCC2, 0xED39, 0xF8E8 }, { 0x041E, 0xFCF9, 0xF5C8, 0xF019 },
 { 0x106E, 0x019F, 0xEF08, 0xFB94 }, { 0x0BE4, 0x01EB, 0xEFE2, 0xF872 },
 { 0x03DC, 0xFC7B, 0xF2E7, 0xF28D }, { 0x06C1, 0xF409, 0xF725, 0xF2D6 },
 { 0x0F4B, 0x0390, 0xF453, 0xF6AD }, { 0x0EC5, 0x012C, 0xF667, 0xF416 },
 { 0x0A98, 0x039C, 0xFABA, 0xFB4A }, { 0x1086, 0x0195, 0xF6D9, 0x0299 },
 { 0x0756, 0xFC97, 0xFF1F, 0xFFE3 }, { 0x0DB6, 0x0038, 0xFACA, 0xF2A4 },
 { 0x0B22, 0x05A7, 0xF5A5, 0xF3B2 }, { 0x05E6, 0xFD3E, 0xEFE3, 0xF64D },
 { 0x0C2B, 0x0319, 0xF964, 0xF0CA }, { 0x0A6B, 0x00D5, 0xF463, 0xF51E },
 { 0x04A0, 0xF6B0, 0xF415, 0xF39B }, { 0x085B, 0x031C, 0xF7E1, 0xF18F },
 { 0x05B8, 0xFA35, 0xF172, 0xF53E }, { 0x0967, 0xFB84, 0xF0B5, 0xF9DF },
 { 0x0A34, 0xF90D, 0xF36F, 0xF721 }, { 0x0966, 0xF4CA, 0xF487, 0xF640 },
 { 0x085C, 0x007E, 0xF1C2, 0xF53A }, { 0x0B88, 0xFBF4, 0x010C, 0xFA71 },
 { 0x005D, 0xF875, 0xF0FF, 0xF231 }, { 0x0185, 0xF477, 0xF2C9, 0xF2F1 },
 { 0x21CC, 0xEA79, 0xF982, 0x0235 }, { 0x1D03, 0xF519, 0xF619, 0xFCB6 },
 { 0x215D, 0xEF63, 0xFA81, 0xFC24 }, { 0x1F52, 0xF37D, 0xF44A, 0x0069 },
 { 0x1C3F, 0xF0AA, 0xFC42, 0x051C }, { 0x1CA3, 0xF196, 0xFE95, 0x0A1A },
 { 0x1A93, 0xF1C2, 0xF74E, 0xFC79 }, { 0x1FE3, 0xF505, 0xFE23, 0xF745 },
 { 0x248C, 0xF116, 0xF96B, 0xFD54 }, { 0x2112, 0xF4DA, 0xFED2, 0xFD46 },
 { 0x210A, 0xF368, 0x0205, 0x0117 }, { 0x1F8A, 0xF5C5, 0xFAD2, 0x0A24 },
 { 0x224B, 0xF537, 0xF621, 0xFE47 }, { 0x1985, 0xF4B9, 0xFC7D, 0xFD48 },
 { 0x1CE2, 0xF6FF, 0xF996, 0xFF88 }, { 0x2059, 0xF13C, 0xFFEA, 0x0519 },
 { 0x23C6, 0xEEC3, 0xFCF5, 0x0385 }, { 0x2347, 0xEB88, 0xFBAB, 0x068E },
 { 0x220D, 0xF1BE, 0x019A, 0xFBCD }, { 0x1C95, 0xF383, 0xFCCE, 0xF728 },
 { 0x1EFE, 0xF6AF, 0xFB42, 0xF8A2 }, { 0x2040, 0xEEA7, 0xFEDD, 0xFDB5 },
 { 0x1CBE, 0xF2BD, 0x0442, 0xFEF2 }, { 0x24E6, 0xECD2, 0xFAC1, 0xFE27 },
 { 0x1FFB, 0xED8A, 0xFCD8, 0x048E }, { 0x1D50, 0xF0FB, 0xFFD1, 0x010B },
 { 0x1F5D, 0xF79E, 0xFAFD, 0xFE81 }, { 0x1D25, 0xF56F, 0xFCAB, 0x030F },
 { 0x2497, 0xF1CC, 0xFD7B, 0xFE9E }, { 0x22FB, 0xF26F, 0xFECC, 0xF865 },
 { 0x21E4, 0xF585, 0xF7CD, 0x05CD }, { 0x1D39, 0xF445, 0xFC99, 0xFE44 },
 { 0x1F4F, 0xF4E9, 0xF977, 0x0497 }, { 0x1B23, 0xEDDD, 0xFA09, 0xFBE9 },
 { 0x1DC6, 0xF5F1, 0xFF77, 0xFC40 }, { 0x24AC, 0xEF49, 0xFD3D, 0xFAD6 },
 { 0x20BE, 0xEB75, 0xFAFD, 0xFDCB }, { 0x1AC8, 0xEFD6, 0xFBFA, 0x0276 },
 { 0x21D3, 0xF5F5, 0xFB9C, 0xF97E }, { 0x223B, 0xF121, 0xFDE7, 0x09EF },
 { 0x1F71, 0xF206, 0xF776, 0xFDA4 }, { 0x2050, 0xF6D1, 0xF83F, 0xFB42 },
 { 0x1AC7, 0xF12C, 0xFA09, 0xF9A1 }, { 0x1C0A, 0xF4B0, 0xF9C0, 0xF924 },
 { 0x1B80, 0xF4B8, 0xFFA7, 0xF9CE }, { 0x1875, 0xF2B5, 0xFEF8, 0x03E6 },
 { 0x1E4C, 0xEDA5, 0xF9F9, 0xFCBE }, { 0x1E02, 0xEDF2, 0xFD0A, 0xF947 },
 { 0x2287, 0xEF78, 0xF48C, 0x07A7 }, { 0x2493, 0xEDB9, 0xF85C, 0x0027 },
 { 0x1ECB, 0xF1E0, 0xFA7A, 0xFA68 }, { 0x227C, 0xF38C, 0xFAB4, 0xFAE0 },
 { 0x1E42, 0xF06D, 0xFF87, 0xF688 }, { 0x242E, 0xF348, 0xFD4B, 0x0332 },
 { 0x1DF6, 0xF2A4, 0xFF6C, 0x0DB0 }, { 0x1CB0, 0xF391, 0x0260, 0x063B },
 { 0x2310, 0xEFD5, 0xF8C8, 0x0518 }, { 0x1A34, 0xEFDD, 0x0021, 0xFCAC },
 { 0x1EA0, 0xEEB3, 0xF71D, 0x004F }, { 0x2314, 0xF0EE, 0xF4EA, 0x01C5 },
 { 0x1E87, 0xEE04, 0xF5FD, 0x03B0 }, { 0x20B4, 0xEEBA, 0xF909, 0x0BFF },
 { 0x21AF, 0xEBF8, 0xF926, 0x0B48 }, { 0x1D26, 0xF32F, 0x0379, 0x0398 },
 { 0x20E0, 0xFFC5, 0xFAD8, 0xF8DF }, { 0x1EF8, 0xFA30, 0xFE62, 0xF63D },
 { 0x1FAE, 0xFC2F, 0xFBE9, 0xF806 }, { 0x2056, 0xFD51, 0xF9C3, 0xF9F2 },
 { 0x1F34, 0xFF52, 0xFC2F, 0xF7C6 }, { 0x21A1, 0xF9F5, 0xF9A4, 0xFA09 },
 { 0x2328, 0xF8FA, 0xFC4E, 0xF91F }, { 0x22FA, 0xFC98, 0xFA84, 0xF9C6 },
 { 0x22EB, 0x01D2, 0xFD14, 0xFB44 }, { 0x254D, 0xFEB7, 0xFF4F, 0xFAB0 },
 { 0x24C3, 0xFFEE, 0xFB9A, 0xF9E0 }, { 0x229B, 0xFCF2, 0xFE18, 0xFAC6 },
 { 0x22FB, 0xFF26, 0xFFD5, 0xFB47 }, { 0x23AB, 0xFFBB, 0xFE3B, 0xFC17 },
 { 0x236D, 0xFA11, 0xFBBD, 0xFB51 }, { 0x241F, 0xFAE3, 0xFDCA, 0xFB86 },
 { 0x2150, 0xF9AF, 0xFEE1, 0xFADF }, { 0x1E53, 0xFD17, 0xFF6B, 0xF808 },
 { 0x2066, 0xFEA9, 0x0101, 0xF5B7 }, { 0x27A5, 0xFC83, 0xFDD8, 0xF98F },
 { 0x24B6, 0xFC6D, 0x00DA, 0xF806 }, { 0x25E7, 0xFB56, 0xFD5D, 0xF9C8 },
 { 0x2572, 0xFD44, 0xFE55, 0xF952 }, { 0x22E2, 0x01F1, 0xFA5B, 0xFB3E },
 { 0x2445, 0xFAD5, 0xFF5D, 0xF9F0 }, { 0x20EF, 0xFAF7, 0xFC27, 0xFA84 },
 { 0x2305, 0xFD71, 0x028D, 0xFA35 }, { 0x2546, 0xFC17, 0xFC49, 0xFB98 },
 { 0x23F5, 0xFD79, 0xFFDB, 0xFC8E }, { 0x219B, 0xFFC8, 0x0202, 0xF8FF },
 { 0x2454, 0xFFF4, 0xFAD4, 0xFDC9 }, { 0x2245, 0x00EE, 0xFF48, 0xFA50 },
 { 0x26D5, 0xFAE6, 0xFFBB, 0xF900 }, { 0x2490, 0x0117, 0xFE88, 0xF881 },
 { 0x23DC, 0xFEE3, 0x005F, 0xF786 }, { 0x26C2, 0xFE0B, 0xFC36, 0xF9DE },
 { 0x2095, 0xFA2B, 0xFCA8, 0xF7D4 }, { 0x224C, 0xFC2B, 0xFCAE, 0xFC0A },
 { 0x25F9, 0xFDDC, 0xFA20, 0xFBBA }, { 0x26F5, 0xFA2B, 0x01E2, 0xF7C7 },
 { 0x2203, 0xFEB3, 0xFBFD, 0xFBC1 }, { 0x238A, 0xFE2B, 0xFEC5, 0xF945 },
 { 0x22AF, 0xFBE6, 0xFD6B, 0xF81C }, { 0x2299, 0x025A, 0xFC9E, 0xF882 },
 { 0x22F1, 0xFBFF, 0xF796, 0xFBD1 }, { 0x2124, 0xF876, 0xFE2C, 0xF77D },
 { 0x23D9, 0xF891, 0xFF20, 0xF7C0 }, { 0x21CC, 0xFF77, 0xF7CF, 0xFB42 },
 { 0x2367, 0xFC33, 0xFA83, 0xFCFC }, { 0x2470, 0xFE38, 0x0296, 0xF65B },
 { 0x2775, 0xFD47, 0x007F, 0xF7BF }, { 0x25D5, 0x032B, 0xF6C9, 0xFC00 },
 { 0x218A, 0xFFA2, 0xFE34, 0xF842 }, { 0x1EF4, 0xFF73, 0xFE03, 0xF62F },
 { 0x1E5D, 0xFD63, 0xFF95, 0xF4ED }, { 0x21BC, 0xFBD8, 0xFFD2, 0xF697 },
 { 0x2614, 0x0254, 0xF8E9, 0xFABB }, { 0x22DC, 0x0130, 0x0223, 0xF5CA },
 { 0x24E2, 0x02EA, 0xFB7F, 0xF971 }, { 0x24EE, 0xFEEA, 0xFDEF, 0xF848 },
 { 0x2128, 0x0231, 0xFFE0, 0xF790 }, { 0x2763, 0xFFC1, 0xF9F8, 0xFAAC },
 { 0x24AE, 0xFB02, 0x0238, 0xFB95 }, { 0x260C, 0xFFCF, 0xF733, 0xFC72 },
 { 0x0E34, 0xF6A9, 0xFBA5, 0xF1E2 }, { 0x177E, 0xF37C, 0xF892, 0xF8F0 },
 { 0x169B, 0xF257, 0xFBA4, 0xF5E2 }, { 0x110D, 0xF41A, 0xF9A0, 0xF594 },
 { 0x127D, 0xF770, 0xF813, 0xF65C }, { 0x1524, 0xF53F, 0xF99F, 0xF660 },
 { 0x1167, 0xF2D1, 0xFD01, 0xF2B9 }, { 0x1168, 0xF994, 0xFC29, 0xF4E7 },
 { 0x0FC7, 0xF625, 0x0026, 0xF081 }, { 0x0D4E, 0xF59A, 0x0048, 0xED6B },
 { 0x10B7, 0xF82B, 0x041F, 0xEED1 }, { 0x10E1, 0xFA9F, 0xFCA4, 0xF136 },
 { 0x0E9F, 0xE995, 0xFD75, 0xF419 }, { 0x0DC8, 0xEA7A, 0x0169, 0xF024 },
 { 0x1960, 0xECEA, 0xFF78, 0xF57F }, { 0x11A1, 0xEB7A, 0x0227, 0xF056 },
 { 0x199D, 0xF2AB, 0xFFA4, 0xF409 }, { 0x105A, 0xF7F5, 0x00BB, 0x002F },
 { 0x1842, 0xEFEB, 0xFB18, 0xF83F }, { 0x1796, 0xEF09, 0x015F, 0xF7B4 },
 { 0x10D1, 0xED54, 0xF7E3, 0xF897 }, { 0x1180, 0xF119, 0xF74C, 0xFA03 },
 { 0x15CE, 0xF197, 0x04C5, 0xF29B }, { 0x159C, 0xECF6, 0x04AB, 0xF533 },
 { 0x1976, 0xF4DB, 0xFC77, 0xF5F8 }, { 0x155B, 0xF770, 0x01D6, 0xEFED },
 { 0x102B, 0xF9D7, 0x00F0, 0xF25B }, { 0x14A1, 0xF87A, 0xFD27, 0xF2F4 },
 { 0x145E, 0xF4CA, 0x054F, 0xEF3F }, { 0x0BE6, 0xF24A, 0xFA00, 0xF372 },
 { 0x1539, 0xF4BF, 0xFB32, 0xFB60 }, { 0x12FD, 0xF0A4, 0xFBD1, 0xF519 },
 { 0x163D, 0xEF76, 0xF88E, 0xFA22 }, { 0x0FA4, 0xF0A1, 0xF8F4, 0xF6B1 },
 { 0x0E90, 0xF130, 0x02A9, 0xED5B }, { 0x0E25, 0xF42A, 0xF861, 0xF5DA },
 { 0x140D, 0xF0C1, 0x002C, 0xF18C }, { 0x0DE9, 0xF285, 0x049F, 0xEB4B },
 { 0x13A2, 0xF536, 0xF6DB, 0xF90C }, { 0x16D1, 0xF644, 0xFE2D, 0xF376 },
 { 0x15D7, 0xF901, 0x01F1, 0xF658 }, { 0x13BE, 0xF0C6, 0xF8E2, 0xF7CF },
 { 0x16B5, 0xF518, 0x0053, 0xFA43 }, { 0x1150, 0xEE6F, 0x0686, 0xEBB7 },
 { 0x14DA, 0xEDD3, 0xFBAB, 0xF768 }, { 0x0CA7, 0xEECF, 0xFD78, 0xF1B9 },
 { 0x0863, 0xF1F2, 0xFB50, 0xEF6E }, { 0x1141, 0xF721, 0xF9F0, 0xF376 },
 { 0x195E, 0xEEF8, 0x0354, 0xF213 }, { 0x0959, 0xE72A, 0xFCA8, 0xEE54 },
 { 0x135F, 0xEF9C, 0xFCB1, 0xFA85 }, { 0x133C, 0xEAC2, 0xFF1E, 0xF42E },
 { 0x109E, 0xEB49, 0xFAE6, 0xF688 }, { 0x1019, 0xF3CA, 0xF6E2, 0xF843 },
 { 0x0D6D, 0xEEA5, 0xFA48, 0xF477 }, { 0x0C83, 0xF27D, 0xFDEF, 0xEF0D },
 { 0x1708, 0xE8C7, 0x021F, 0xF352 }, { 0x07C3, 0xED83, 0xFF24, 0xED01 },
 { 0x1106, 0xEEB1, 0xFDFE, 0xF3F7 }, { 0x11E7, 0xF690, 0xFE14, 0xF711 },
 { 0x0B7F, 0xEC55, 0x01A3, 0xECC1 }, { 0x14EE, 0xEBF7, 0x03DB, 0xEF2B },
 { 0x116C, 0xF2C0, 0x06D8, 0xE9FE }, { 0x0D57, 0xEDE7, 0x05E3, 0xE8C7 },
 { 0x032B, 0xEDAC, 0xFE43, 0x091D }, { 0x03F1, 0xEA13, 0xF8BF, 0x0550 },
 { 0x053A, 0xF568, 0xF560, 0x0BDC }, { 0x03EA, 0xF156, 0xF5EA, 0x0928 },
 { 0x02EE, 0xEE00, 0xF6E2, 0x02CA }, { 0x07FB, 0xF379, 0xF4FA, 0x087D },
 { 0xFF74, 0xEDD2, 0xF477, 0x0165 }, { 0xFFCA, 0xF046, 0xF6B8, 0x0A87 },
 { 0x0742, 0xEC62, 0xFD33, 0x08EF }, { 0x0810, 0xF0CA, 0xFD2E, 0x0CB7 },
 { 0x0AA7, 0xEE32, 0xFEB4, 0x0A2B }, { 0x0712, 0xEAFE, 0x011B, 0x0722 },
 { 0x0F5F, 0xEF1A, 0x02FA, 0x0D37 }, { 0xFD01, 0xEDA7, 0xF632, 0x0782 },
 { 0x0862, 0xEF28, 0xF3EE, 0x0669 }, { 0x0036, 0xE907, 0xF7BE, 0x0399 },
 { 0x07C8, 0xE97A, 0xFD80, 0x0626 }, { 0x04B0, 0xEB05, 0xFBA6, 0x0724 },
 { 0x0B9D, 0xEB27, 0x0022, 0x08DA }, { 0x05FB, 0xEC66, 0xF4FF, 0x04A8 },
 { 0x0C06, 0xEE26, 0x0075, 0x07C6 }, { 0x039C, 0xEF42, 0xFA94, 0x0A99 },
 { 0x008E, 0xEC3E, 0xF4E0, 0x05CF }, { 0xFF96, 0xE7DC, 0xFC8F, 0x034A },
 { 0x02A1, 0xEAC7, 0xFF1B, 0x063C }, { 0x030F, 0xE9B2, 0xF520, 0x0232 },
 { 0x078F, 0xE99F, 0xF827, 0x0358 }, { 0xFE66, 0xF2D1, 0xF302, 0x0AAE },
 { 0x00EA, 0xF448, 0xF5BC, 0x0CBC }, { 0x02DD, 0xF2B3, 0xF122, 0x0635 },
 { 0x0303, 0xEF43, 0xF228, 0x0522 }, { 0x04A8, 0xF215, 0xF088, 0x0882 },
 { 0x00CE, 0xEA4D, 0xFB1E, 0x060A }, { 0xFF7E, 0xF119, 0xFB46, 0x0BE1 },
 { 0x0286, 0xF09C, 0xFE77, 0x0BB0 }, { 0xFF48, 0xECBD, 0xF919, 0x0785 },
 { 0x0ABA, 0xEC00, 0xF71D, 0x05B8 }, { 0x0988, 0xF16D, 0xF2E8, 0x0AA9 },
 { 0xFE16, 0xECB2, 0xF13D, 0x03E5 }, { 0x0044, 0xF5B4, 0xEFB9, 0x0EC2 },
 { 0x0030, 0xF06E, 0xEFEA, 0x083A }, { 0xFC2E, 0xEA92, 0xFAC8, 0x056E },
 { 0x0466, 0xEB4F, 0xFCA9, 0x0280 }, { 0xFE28, 0xF079, 0xF1DA, 0x0615 },
 { 0x0998, 0xEB20, 0xFA0D, 0x0670 }, { 0xFCFA, 0xE9EC, 0xF68F, 0x047B },
 { 0x03E3, 0xE816, 0xFCD4, 0x046C }, { 0x0CD2, 0xEE25, 0xF91D, 0x087F },
 { 0x0E47, 0xF0EA, 0xFD5C, 0x0DF0 }, { 0x0BDE, 0xF1C1, 0xF978, 0x0D35 },
 { 0x0A23, 0xF46C, 0xF52C, 0x0CBF }, { 0x1050, 0xF2E7, 0xFB84, 0x1102 },
 { 0x0643, 0xF28E, 0xFA24, 0x0D74 }, { 0x033C, 0xE7AE, 0xF909, 0x02A6 },
 { 0x058D, 0xF2FB, 0xF3F8, 0x0D4B }, { 0x0461, 0xED89, 0xF87C, 0x07C0 },
 { 0xFF46, 0xEC25, 0xFD56, 0x0704 }, { 0x0333, 0xF526, 0xF260, 0x0212 },
 { 0x01A5, 0xF4C7, 0xF108, 0x0A24 }, { 0x0874, 0xEF59, 0xF9BB, 0x08EA },
 { 0x0249, 0xEEAB, 0xFD56, 0xFE15 }, { 0xFD7C, 0xEE9C, 0xFB7B, 0x0915 },
 { 0x07C7, 0xEF35, 0x00D2, 0x0B12 }, { 0x0857, 0xF1D0, 0xF7BF, 0x0299 },
 { 0xE2C6, 0xF55C, 0xF59A, 0xFA9C }, { 0xE4B9, 0xF78A, 0xF154, 0xF24B },
 { 0xE453, 0xFA61, 0xF6A3, 0xF3D8 }, { 0xE1B0, 0xF417, 0xF309, 0xF4FA },
 { 0xDF23, 0xF538, 0xEECA, 0xF31E }, { 0xE895, 0xF099, 0xFB14, 0xF15A },
 { 0xE139, 0xF9EE, 0xF278, 0xF5D2 }, { 0xE756, 0xF80E, 0xF0DA, 0xF96F },
 { 0xDD6F, 0xF7DC, 0xFA89, 0xFB31 }, { 0xE40F, 0xF5D6, 0xFA98, 0xFCCF },
 { 0xE097, 0xF5F5, 0xFE69, 0xF51F }, { 0xE3B2, 0xF747, 0xF9D6, 0x0104 },
 { 0xE358, 0xF0D5, 0xF023, 0xFAC2 }, { 0xE23D, 0xF0BC, 0xF6DA, 0x017E },
 { 0xDE14, 0xF174, 0xF982, 0xFD29 }, { 0xE156, 0xF496, 0xF916, 0xF287 },
 { 0xE592, 0xF80E, 0xFAF3, 0xF83C }, { 0xE511, 0xF7BC, 0xFC38, 0xF160 },
 { 0xE420, 0xEBE5, 0xF5C6, 0xF507 }, { 0xDFE0, 0xF174, 0xF629, 0xF9CB },
 { 0xE5C9, 0xF542, 0xF433, 0xFF25 }, { 0xE085, 0xF99A, 0xFBB2, 0xF399 },
 { 0xDDFA, 0xED19, 0xF085, 0xF3B9 }, { 0xDB6D, 0xEC9B, 0xF347, 0xFC16 },
 { 0xE82D, 0xF929, 0xF3AB, 0xFE75 }, { 0xE6CB, 0xF370, 0xEE0B, 0xFE1D },
 { 0xE139, 0xEA9B, 0xFCB9, 0xF5B2 }, { 0xE3DE, 0xF03A, 0xFDF2, 0xF4D8 },
 { 0xE0AA, 0xFB34, 0xF88A, 0xF992 }, { 0xDC63, 0xFA8F, 0xF9D2, 0xF619 },
 { 0xDC79, 0xF57B, 0xFD84, 0xF5D3 }, { 0xDC8C, 0xF5EC, 0xF267, 0xF629 },
 { 0xDF79, 0xED05, 0xF68A, 0x0053 }, { 0xDF50, 0xF7AF, 0xF6EC, 0xF783 },
 { 0xDE96, 0xEE2D, 0xF0FE, 0xF829 }, { 0xD722, 0xEF5B, 0xF872, 0xF7DC },
 { 0xDA0B, 0xF38D, 0xF70A, 0xF898 }, { 0xDA67, 0xF0CF, 0xF434, 0xF368 },
 { 0xD97F, 0xECA5, 0xEF71, 0xF778 }, { 0xD9E8, 0xF6D1, 0xF71B, 0xF3C7 },
 { 0xE3CD, 0xFAEA, 0xF5B1, 0xF9BD }, { 0xE2CB, 0xEEF8, 0xF17A, 0xFDD1 },
 { 0xE9D0, 0xF80F, 0xF6EA, 0xF3FA }, { 0xD832, 0xEA54, 0xEDDD, 0xF1EF },
 { 0xDB29, 0xEFE7, 0xFC91, 0xF651 }, { 0xDF53, 0xEAB6, 0xF81C, 0xFA61 },
 { 0xE76F, 0xEBC6, 0xF9BB, 0xF0FB }, { 0xDF81, 0xF0E6, 0xFD51, 0xF518 },
 { 0xE03D, 0xFBF9, 0xF1E8, 0xF095 }, { 0xD6F2, 0xF600, 0xFB51, 0xF7DE },
 { 0xD4F9, 0xF1C8, 0xF544, 0xF41F }, { 0xDDC6, 0xEC62, 0xEB91, 0xFB76 },
 { 0xD857, 0xF565, 0xEDD8, 0xED05 }, { 0xE106, 0xEBAB, 0xF894, 0xF1F0 },
 { 0xDAA7, 0xF224, 0xED34, 0xF176 }, { 0xE211, 0xED9B, 0xFB64, 0xFA3D },
 { 0xDC8F, 0xE9B5, 0xF8E9, 0xF45C }, { 0xDE66, 0xF6C5, 0xF58D, 0xF146 },
 { 0xD911, 0xEA12, 0xF209, 0xF102 }, { 0xDF7C, 0xFC13, 0xF7AD, 0xF34A },
 { 0xD7A5, 0xE997, 0xF60A, 0xF484 }, { 0xDFD6, 0xF2E6, 0xF2DF, 0xEE81 },
 { 0xE034, 0xF861, 0xEE52, 0xEE3F }, { 0xE5E9, 0xF59A, 0xF714, 0xEFAA },
 { 0xFB9E, 0xFA16, 0xE6E5, 0xFF2C }, { 0x0036, 0xF984, 0xEAD0, 0xFA84 },
 { 0x00FE, 0xF526, 0xEB9A, 0x034E }, { 0xFEF5, 0xF983, 0xE64F, 0x032E },
 { 0xFECF, 0xF81B, 0xE981, 0x05CC }, { 0xF901, 0xF672, 0xE52D, 0xFFAA },
 { 0xF48F, 0xF3AA, 0xE635, 0xF8F9 }, { 0xFA91, 0xF38B, 0xEA4B, 0xFBE3 },
 { 0xF9BE, 0xFC8C, 0xE591, 0xFB43 }, { 0xFE97, 0xFEC2, 0xE7B5, 0xFFD4 },
 { 0xF012, 0xF5B5, 0xEA6D, 0xFE4F }, { 0xFC44, 0x01DE, 0xEEE2, 0x05BE },
 { 0xF31C, 0xF662, 0xE87B, 0xF55F }, { 0x02C4, 0xF67E, 0xEC23, 0xFDE4 },
 { 0xF67D, 0xF1E9, 0xE9F1, 0xF7C2 }, { 0xFE15, 0xFB92, 0xEDB7, 0xF4BA },
 { 0x0057, 0xF295, 0xEDDF, 0xFB56 }, { 0xFDB6, 0xF491, 0xED50, 0x016E },
 { 0xFA8E, 0xF6EA, 0xE87B, 0x015E }, { 0x0061, 0xF629, 0xEDBA, 0xF7B8 },
 { 0xF9F5, 0xF88D, 0xEC33, 0xF44F }, { 0x010C, 0xF174, 0xED91, 0x007F },
 { 0xFCC5, 0xFB5A, 0xE8E8, 0x0478 }, { 0xF089, 0xF6EE, 0xE50E, 0xF84A },
 { 0xF558, 0xF74C, 0xE6E6, 0xFDCE }, { 0xFE38, 0xFD66, 0xE967, 0xF9B7 },
 { 0x0213, 0xFBB8, 0xE99D, 0xFD70 }, { 0xF20F, 0xFD50, 0xF0B5, 0x006E },
 { 0xED70, 0xF943, 0xEED7, 0xFE87 }, { 0xF376, 0xF30D, 0xE4D0, 0xFCB8 },
 { 0xFD50, 0xF2A8, 0xEC95, 0x04C5 }, { 0xF8D7, 0x004D, 0xE6A5, 0xF67E },
 { 0xFF11, 0xFF01, 0xE53E, 0xFC8A }, { 0xF7C0, 0xFA2E, 0xE76D, 0xF57F },
 { 0xF9F8, 0xEE1D, 0xEBB2, 0xFB13 }, { 0xF52D, 0xF052, 0xEA70, 0x02AB },
 { 0xF99D, 0xF4F3, 0xEA78, 0x04BE }, { 0xFC42, 0xF5EA, 0xED29, 0x0938 },
 { 0xF7E3, 0xEE2A, 0xEDDE, 0x016D }, { 0xF3D8, 0xEF8A, 0xE8B8, 0xFCC9 },
 { 0xF65D, 0xF632, 0xED06, 0x05BB }, { 0xF9E7, 0xF2B9, 0xE942, 0x00D3 },
 { 0xFCF9, 0xFBC7, 0xEEB8, 0x0A4C }, { 0xFB11, 0x0019, 0xE716, 0xFA90 },
 { 0xF26C, 0xFE92, 0xEAD7, 0xFA8F }, { 0xF398, 0xFA3C, 0xEFCB, 0x05BA },
 { 0xF651, 0x0206, 0xEEA0, 0xFEFF }, { 0xF450, 0x009E, 0xEDCC, 0xFB01 },
 { 0xFAD8, 0xF0E0, 0xEE81, 0x047B }, { 0xFA3D, 0xFEC8, 0xEB3A, 0x021B },
 { 0xF239, 0xF971, 0xE91C, 0xF96F }, { 0xF2BB, 0xF292, 0xEA27, 0x074A },
 { 0xF007, 0xF679, 0xED65, 0x04FB }, { 0xFD14, 0xEE5F, 0xEDB1, 0xFFD0 },
 { 0xF78A, 0xEE4D, 0xEDAD, 0xF4D8 }, { 0xF6AF, 0xFCAB, 0xE86D, 0xFD8D },
 { 0xFB56, 0xF005, 0xEE88, 0xF855 }, { 0xFD56, 0xF35E, 0xF00C, 0xF427 },
 { 0xF349, 0xEC69, 0xEB30, 0xFFF4 }, { 0xF6F7, 0xF294, 0xEE07, 0xFF65 },
 { 0xF518, 0xFBF2, 0xE4DD, 0xF81D }, { 0xFB24, 0xFA0A, 0xE975, 0xF8A6 },
 { 0xEDB9, 0xF16D, 0xEA7E, 0x011B }, { 0xF40A, 0xFFBE, 0xF21A, 0xFD0A },
 { 0xECE1, 0xFB5D, 0x128F, 0x0E90 }, { 0xE250, 0xF540, 0x0CF8, 0x1205 },
 { 0xE9B9, 0xF461, 0x0F68, 0x0A63 }, { 0xEC94, 0xFB17, 0xFF0A, 0x0B88 },
 { 0xEF83, 0xF649, 0x06A6, 0x10C7 }, { 0xF4AC, 0xFA07, 0x099A, 0x1347 },
 { 0xEC3B, 0x0197, 0x0970, 0x0FD2 }, { 0xE4ED, 0xF26A, 0x0AC9, 0x08A5 },
 { 0xE86B, 0xF0AF, 0x0C78, 0x074A }, { 0xE81F, 0xFCD5, 0x0967, 0x0EC6 },
 { 0xE90A, 0xF94C, 0x04B7, 0x0D96 }, { 0xE8BF, 0xF4DB, 0x089F, 0x0A98 },
 { 0xE569, 0xF369, 0x0ABD, 0x0E0B }, { 0xF338, 0xF3AB, 0x056D, 0x0ECC },
 { 0xEB08, 0xF890, 0x07BC, 0x13D5 }, { 0xE3BD, 0xFA8A, 0x0C03, 0x11C4 },
 { 0xED63, 0xF261, 0x0AC3, 0x0AEC }, { 0xE216, 0xEEAD, 0x0A86, 0x0A16 },
 { 0xE4AB, 0xEF46, 0x01C8, 0x0EF8 }, { 0xEA45, 0xF3D5, 0xFFC1, 0x0E81 },
 { 0xEF6C, 0xEF84, 0x05AA, 0x0ACF }, { 0xF127, 0xF76E, 0x00BE, 0x10CF },
 { 0xEAAE, 0xEFE9, 0x07A6, 0x08E2 }, { 0xE37C, 0xF273, 0x0DBA, 0x0C79 },
 { 0xEE0E, 0xF7ED, 0x0307, 0x1290 }, { 0xF2C3, 0xF98A, 0x05B8, 0x1524 },
 { 0xED13, 0xF265, 0x03C4, 0x0D6D }, { 0xE889, 0xF4FE, 0x0682, 0x1233 },
 { 0xDDFB, 0xEC71, 0x06DD, 0x0CD7 }, { 0xE937, 0xEEDB, 0x0401, 0x0C63 },
 { 0xE964, 0xF90C, 0x0F68, 0x0E4D }, { 0xEEB2, 0xFC68, 0x0792, 0x1291 },
 { 0xE466, 0xF8BF, 0x11EF, 0x11BA }, { 0xF223, 0xFDFF, 0x0593, 0x14C5 },
 { 0xE2A3, 0xFB3C, 0x0B43, 0x0BE9 }, { 0xE24B, 0xF581, 0x0752, 0x0AAF },
 { 0xDDF2, 0xF03D, 0x0A74, 0x0E92 }, { 0xE0CA, 0xF0BD, 0x04A1, 0x0A2F },
 { 0xE856, 0xF930, 0x0D15, 0x1425 }, { 0xE8BE, 0x0235, 0x0C59, 0x0CB2 },
 { 0xE6B2, 0xFD9C, 0x078A, 0x08DF }, { 0xE679, 0xFA5B, 0xFFFE, 0x0652 },
 { 0xDCFD, 0xEFC9, 0x04A8, 0x0FCC }, { 0xE3C5, 0xF20E, 0x0640, 0x108A },
 { 0xEDBE, 0x004F, 0x0253, 0x0BC7 }, { 0xF07A, 0x01AE, 0x0AA7, 0x1411 },
 { 0xEB4D, 0x0009, 0x0E82, 0x12AB }, { 0xE585, 0xF575, 0xFFF8, 0x0984 },
 { 0xE498, 0xFB87, 0x050D, 0x0906 }, { 0xE4D5, 0xF310, 0x05FE, 0x0709 },
 { 0xF047, 0x02E4, 0x073A, 0x0FD6 }, { 0xDA8B, 0xF27C, 0x103A, 0x1496 },
 { 0xEECC, 0xFB63, 0x10CA, 0x1435 }, { 0xE344, 0xEE19, 0xFFEE, 0x0A54 },
 { 0xE68C, 0xFB2D, 0x1157, 0x185A }, { 0xF283, 0xFED3, 0x10F8, 0x1170 },
 { 0xEDDD, 0x05FA, 0x0CF3, 0x10F4 }, { 0xEE21, 0xF603, 0x0EAA, 0x0E62 },
 { 0xF1C5, 0xF253, 0x0803, 0x0BB5 }, { 0xEADC, 0xF655, 0x08FD, 0x062B },
 { 0xE92A, 0x0103, 0x0550, 0x092C }, { 0xEB76, 0xFAB2, 0x041A, 0x0346 },
 { 0xEA5A, 0xFF25, 0x18E9, 0x1676 }, { 0xE9AF, 0xF478, 0x039A, 0x0383 },
 { 0xF7FF, 0xFB91, 0x1456, 0x0409 }, { 0xF963, 0xF8A2, 0x12E3, 0xFF96 },
 { 0xF6D8, 0xF250, 0x1088, 0xFFF3 }, { 0xF655, 0xF6E2, 0x13B3, 0x0466 },
 { 0xFCED, 0xF60B, 0x0F28, 0x085A }, { 0xF3A9, 0xF6DB, 0x12DE, 0x0B47 },
 { 0xF90C, 0xFC0F, 0x1860, 0x080D }, { 0xEF19, 0xF2DD, 0x0B02, 0x0376 },
 { 0xF2D0, 0xF549, 0x1008, 0x00CF }, { 0xF34E, 0xEDE0, 0x0A9E, 0x05DA },
 { 0xFE82, 0xFBCD, 0x111E, 0x0D84 }, { 0xF690, 0xEFB8, 0x0DCA, 0x0330 },
 { 0xF924, 0xF56C, 0x12FD, 0x026E }, { 0xF8A9, 0xF7CF, 0x1424, 0x0B49 },
 { 0xF640, 0xF68E, 0x0E8A, 0x0A6F }, { 0xF563, 0xF34C, 0x0D0D, 0x0798 },
 { 0xF021, 0xF005, 0x0CEA, 0x010B }, { 0xF223, 0xF120, 0x0EA3, 0x034A },
 { 0xF5B5, 0x0222, 0x16A2, 0x0766 }, { 0xF8BF, 0xFB9F, 0x111F, 0x0F7C },
 { 0xF74E, 0xF78A, 0x0DA1, 0x0E5E }, { 0xF25C, 0xFD6C, 0x14CB, 0x0427 },
 { 0xF427, 0xF3C6, 0x111E, 0x0724 }, { 0xF571, 0xFD8F, 0x18E1, 0x0B23 },
 { 0xF988, 0xF4E6, 0x11E8, 0xFDF0 }, { 0xED53, 0xF5C2, 0x1126, 0x0831 },
 { 0xFE63, 0xF803, 0x13D9, 0x0BDB }, { 0xF11E, 0xF59A, 0x11B4, 0x0447 },
 { 0xF3B8, 0xF8BE, 0x145F, 0x0758 }, { 0xF216, 0xF8FD, 0x1340, 0x029E },
 { 0xED40, 0xFA1B, 0x1445, 0x0743 }, { 0xFBC3, 0xF108, 0x1049, 0x0384 },
 { 0xF84F, 0xF33A, 0x0B29, 0x0B3E }, { 0xEF55, 0xEFD4, 0x0C68, 0x070D },
 { 0xEBE7, 0xF171, 0x0DC4, 0x0490 }, { 0xFABE, 0xF8AC, 0x157D, 0x06D4 },
 { 0xEC7A, 0xF47F, 0x0E73, 0x0152 }, { 0xF27E, 0xF3E8, 0x0D4E, 0xFD85 },
 { 0xF929, 0xF377, 0x0DB4, 0x018B }, { 0xF635, 0x00AA, 0x1763, 0x02C1 },
 { 0xF154, 0xFBD0, 0x160F, 0x0DD0 }, { 0xF4CA, 0xFA61, 0x13A2, 0x0C8C },
 { 0xF0B7, 0xF367, 0x0E55, 0x0860 }, { 0xF165, 0x00E2, 0x1673, 0x02FC },
 { 0xF7FC, 0xFCCC, 0x1492, 0x0C15 }, { 0xF372, 0xF114, 0x0969, 0x0957 },
 { 0xEED2, 0xF5E4, 0x0DAD, 0xFF26 }, { 0xEE7C, 0xF91D, 0x1054, 0xFF3A },
 { 0xF2D8, 0xFA0B, 0x110A, 0xFF7A }, { 0xF699, 0x00E0, 0x1329, 0x0DCD },
 { 0xFAA7, 0xF487, 0x1278, 0x06FC }, { 0xED10, 0xF955, 0x103F, 0x0353 },
 { 0xF282, 0xF92B, 0x10B9, 0x0C9E }, { 0xF83A, 0xF0F3, 0x0D9F, 0x06C7 },
 { 0xF3D3, 0x005C, 0x180B, 0x0FEB }, { 0xF58C, 0xF658, 0x0FEE, 0xFDB3 },
 { 0xF9F5, 0xF824, 0x0A42, 0x072B }, { 0xEF4D, 0xFDB4, 0x12D8, 0x02D5 },
 { 0xFDA7, 0xF737, 0x0E98, 0x0DDC }, { 0xF024, 0xFFC3, 0x14D5, 0x0C19 },
 { 0xEF31, 0x0007, 0x1997, 0x0BEE }, { 0xEC75, 0xFBFB, 0x169A, 0x0CF7 },
 { 0xF506, 0xFD28, 0x1510, 0x00C7 }, { 0xFB30, 0xFF38, 0x146C, 0x0C31 },
 { 0x0A3D, 0x00A5, 0xE791, 0x012A }, { 0x0E55, 0x0219, 0xE544, 0x061C },
 { 0x063E, 0xFB5A, 0xE7A5, 0x09DB }, { 0x0874, 0xFFE0, 0xE512, 0x0567 },
 { 0x0355, 0xF9C3, 0xE84B, 0x05A9 }, { 0x0561, 0xF983, 0xEB6E, 0x006C },
 { 0x0A64, 0x0030, 0xEBCC, 0xFDFB }, { 0x076F, 0xFE79, 0xE9D3, 0x03F2 },
 { 0x0ED0, 0x00CE, 0xEB66, 0xFFF5 }, { 0x04D7, 0x0AD8, 0xF48F, 0x0AA1 },
 { 0x0FE7, 0x0095, 0xE3A5, 0x0C35 }, { 0x059C, 0xFE20, 0xE7F4, 0xFF3C },
 { 0x055D, 0xF858, 0xEC73, 0x0C32 }, { 0x0D55, 0xFB09, 0xEBC8, 0x0CD3 },
 { 0x0BF4, 0xFFBC, 0xE6A1, 0x08BE }, { 0x0A8C, 0xF7E5, 0xEDB7, 0x005B },
 { 0x0B70, 0xF940, 0xEBD0, 0x0742 }, { 0x1148, 0x033C, 0xEE89, 0x0058 },
 { 0x0A70, 0xF5D4, 0xF03A, 0x0AC1 }, { 0x1467, 0xFF85, 0xE5A3, 0x08F7 },
 { 0x108D, 0xFE5C, 0xEA5E, 0x0549 }, { 0x1288, 0xFAFF, 0xEFFF, 0x1264 },
 { 0x044F, 0xF534, 0xED71, 0x07E8 }, { 0x0EA3, 0xF887, 0xF0B9, 0x0F78 },
 { 0x09A6, 0xFA78, 0xEA5A, 0x0267 }, { 0x12EF, 0xFAB6, 0xEB2A, 0x06C5 },
 { 0x14D8, 0x0058, 0xE257, 0x0FA7 }, { 0x0954, 0xF4C0, 0xED39, 0x040D },
 { 0x118F, 0x056F, 0xE9CB, 0xFF75 }, { 0x1485, 0x0665, 0xE6CE, 0x05FD },
 { 0x04AF, 0x031B, 0xEA75, 0x04ED }, { 0x0575, 0xFB15, 0xEF64, 0x0EFE },
 { 0x02EA, 0x0046, 0xE610, 0x025C }, { 0x0630, 0x00A6, 0xEC94, 0x0C00 },
 { 0x017C, 0xFC19, 0xEAEB, 0x08DB }, { 0x0B9E, 0x06AB, 0xF356, 0x14F0 },
 { 0x1452, 0xFE6D, 0xEAB3, 0x0B10 }, { 0x0E86, 0xF93D, 0xED68, 0x02CA },
 { 0x1036, 0xFC31, 0xED48, 0x003D }, { 0x0B6D, 0xFCCE, 0xED17, 0x000F },
 { 0x14B5, 0x0241, 0xF05A, 0x0CBB }, { 0x1491, 0x07C2, 0xE9D1, 0x0BD4 },
 { 0x0EA8, 0x0788, 0xEE63, 0x0E91 }, { 0x0CCE, 0x0785, 0xE71E, 0x04DF },
 { 0x13F3, 0x06B9, 0xED0B, 0x0C37 }, { 0x0CCF, 0x0BA6, 0xF62D, 0x0FA5 },
 { 0x120E, 0x029C, 0xE7C4, 0x02F7 }, { 0x1792, 0x013D, 0xE97D, 0x12D2 },
 { 0xFDD2, 0x0039, 0xF137, 0x0B01 }, { 0x117C, 0x0650, 0xF083, 0x11B8 },
 { 0x1741, 0x0808, 0xDFE9, 0x0A9B }, { 0x1123, 0x0A35, 0xE2D9, 0x0364 },
 { 0x16CA, 0x0440, 0xED80, 0x133C }, { 0x1949, 0xFCA8, 0xE4B1, 0x104C },
 { 0x135F, 0xFEDB, 0xEBD6, 0x004C }, { 0x0AAB, 0xFCB5, 0xE819, 0x0F07 },
 { 0x0CAD, 0x04B2, 0xE54F, 0x0268 }, { 0x09F9, 0x0567, 0xF10B, 0x0F13 },
 { 0x10EC, 0x0833, 0xF268, 0x0E26 }, { 0x083E, 0x0A7B, 0xF558, 0x0F96 },
 { 0x036C, 0x048F, 0xF326, 0x0D8A }, { 0x0F97, 0x06AD, 0xF696, 0x0FED },
 { 0x13F1, 0x03AB, 0xF5E8, 0x0CB8 }, { 0x126F, 0x02B0, 0xF9E2, 0x0BE0 },
 { 0xF1D0, 0x10EF, 0x04F2, 0xF319 }, { 0xECA4, 0x0C87, 0x0520, 0xF50A },
 { 0xEDC3, 0x0A43, 0x0A67, 0xF67D }, { 0xEF46, 0x0E7C, 0x08FF, 0xF422 },
 { 0xEE48, 0x08F9, 0xFF51, 0xF2EA }, { 0xEB8E, 0x09C7, 0xFF75, 0xFC90 },
 { 0xF076, 0x05E8, 0x0444, 0xF1DD }, { 0xEE59, 0x1229, 0x0553, 0xF669 },
 { 0xEC02, 0x0C3C, 0x07A9, 0xF9D7 }, { 0xEBB4, 0x0D33, 0xFF4A, 0xFA9E },
 { 0xE6EC, 0x1186, 0x095D, 0xF837 }, { 0xEC5A, 0x13B6, 0x050C, 0xFBA2 },
 { 0xEE31, 0x0A0D, 0xFC61, 0xFA82 }, { 0xF253, 0x0E92, 0x02B3, 0xECBE },
 { 0xEEF4, 0x0AC6, 0x03EF, 0xF0BB }, { 0xF046, 0x0B17, 0xF9E9, 0xF6DC },
 { 0xEC53, 0x0FD5, 0x0344, 0xF9DD }, { 0xED89, 0x1410, 0x0456, 0xF1FC },
 { 0xEB83, 0x0AEF, 0xFC19, 0xF78C }, { 0xECA6, 0x05DD, 0x01A6, 0xF085 },
 { 0xE896, 0x0AA6, 0x05B6, 0xF4EF }, { 0xEA0B, 0x1427, 0x07F6, 0xF630 },
 { 0xEC81, 0x08F3, 0x077D, 0xF3B1 }, { 0xEAA3, 0x111E, 0xFF6C, 0xF45E },
 { 0xE91E, 0x07BF, 0x0327, 0xF560 }, { 0xED9B, 0x0DE4, 0x03B8, 0xFE2D },
 { 0xF647, 0x093A, 0x06B2, 0xEF7A }, { 0xED93, 0x138C, 0xFB64, 0xF1A8 },
 { 0xE8E6, 0x0E45, 0x054F, 0xFADB }, { 0xEA7E, 0x0BB3, 0x030C, 0xFBDD },
 { 0xEB59, 0x0F69, 0x09B0, 0xF70B }, { 0xF0F7, 0x1106, 0x0142, 0xF916 },
 { 0xF0B9, 0x0DF2, 0x00FC, 0xF38F }, { 0xF1B4, 0x1408, 0x009E, 0xF179 },
 { 0xEE09, 0x0CCD, 0xFE09, 0xF559 }, { 0xF1A7, 0x0EB0, 0xFB1C, 0xF2F5 },
 { 0xEBD7, 0x0921, 0x0184, 0xF869 }, { 0xF237, 0x08A8, 0x086C, 0xF3F8 },
 { 0xEF2B, 0x10EB, 0x0710, 0xFA4C }, { 0xED52, 0x0EEC, 0x01E0, 0xF638 },
 { 0xEFBA, 0x0DD8, 0xFE86, 0xF9E1 }, { 0xEA3C, 0x09A2, 0xFE5E, 0xF4A3 },
 { 0xE830, 0x0B72, 0x0077, 0xF8AA }, { 0xE8B5, 0x0DE2, 0x03F3, 0xF747 },
 { 0xE6DF, 0x10EF, 0x03A7, 0xF48E }, { 0xEC74, 0x0CF2, 0xFAB8, 0xF29A },
 { 0xE866, 0x0D87, 0xFC10, 0xF09C }, { 0xEDC1, 0x08A6, 0xFD80, 0xEC50 },
 { 0xF515, 0x0EAF, 0x0584, 0xF125 }, { 0xF1C1, 0x1154, 0x02D9, 0xFDFD },
 { 0xF1F6, 0x0409, 0x0038, 0xEFCC }, { 0xF4A4, 0x0BD3, 0x0B49, 0xF263 },
 { 0xF2F6, 0x08BA, 0x0139, 0xEF43 }, { 0xF10F, 0x1191, 0xFDCF, 0xF5B6 },
 { 0xE7E9, 0x0BC4, 0xFFD0, 0xF3B3 }, { 0xED24, 0x0DBB, 0xFC37, 0xEE85 },
 { 0xE963, 0x0AC5, 0xFDE5, 0xEFB3 }, { 0xF66C, 0x0BFB, 0x0234, 0xEF67 },
 { 0xECC7, 0x054E, 0x0533, 0xF4B7 }, { 0xF3C9, 0x108F, 0xFBEB, 0xFA0D },
 { 0xED54, 0x0916, 0xFBA2, 0xF28A }, { 0xF0BC, 0x15AA, 0x0098, 0xF5C2 },
 { 0xE4C4, 0x0BA0, 0x0151, 0xF507 }, { 0xED19, 0x1205, 0xFFDD, 0xF013 },
 { 0xFA80, 0x12D6, 0xFB83, 0xEC7B }, { 0xFC2B, 0x1373, 0xFC70, 0xE760 },
 { 0xF7CE, 0x1639, 0xFC88, 0xF4C2 }, { 0xF2F1, 0x12CE, 0xFD6F, 0xEEAE },
 { 0xF663, 0x0E11, 0xFC39, 0xECFB }, { 0xF5A4, 0x0F68, 0x0057, 0xEA70 },
 { 0xFBB0, 0x17BC, 0x00AE, 0xE6F9 }, { 0x0163, 0x14FA, 0xF947, 0xE913 },
 { 0x04DA, 0x1191, 0xFBAD, 0xEC1D }, { 0xFFA7, 0x0FA2, 0xFA2D, 0xEBC2 },
 { 0x0423, 0x163D, 0xF9C9, 0xECD7 }, { 0x052B, 0x124A, 0xF7E2, 0xED60 },
 { 0x0332, 0x0F9C, 0xFDDB, 0xEAA4 }, { 0xFEE1, 0x11B1, 0x03A1, 0xEA59 },
 { 0xFC69, 0x158F, 0xF519, 0xF4E4 }, { 0xFA81, 0x162F, 0xF327, 0xF07A },
 { 0xFF43, 0x1982, 0xF225, 0xF05E }, { 0xFC7C, 0x1B7F, 0xF2D5, 0xED09 },
 { 0xF459, 0x1C2B, 0xFE95, 0xED1D }, { 0xFCD2, 0x1967, 0xFF98, 0xEC0E },
 { 0xF6AE, 0x1AF0, 0x0329, 0xECC9 }, { 0x034D, 0x118C, 0x0160, 0xE623 },
 { 0xF832, 0x1C45, 0xF992, 0xEF79 }, { 0xF2CC, 0x186B, 0x01D7, 0xEE1F },
 { 0xF88C, 0x1B93, 0x0054, 0xE9A2 }, { 0xFEAC, 0x18CA, 0xFCDD, 0xE787 },
 { 0xF719, 0x16CA, 0xFFD1, 0xEDE7 }, { 0xFA04, 0x14A6, 0xF92C, 0xF893 },
 { 0xF53B, 0x182C, 0xFE3B, 0xF2A9 }, { 0xFB19, 0x1905, 0xF805, 0xE72B },
 { 0x0396, 0x15CD, 0xFF87, 0xE9DD }, { 0x0730, 0x14D8, 0xFCCB, 0xEC56 },
 { 0xF655, 0x1380, 0xF8DF, 0xF3E0 }, { 0xF693, 0x15E6, 0xF903, 0xEF36 },
 { 0x0084, 0x1408, 0xF6AB, 0xEEA6 }, { 0x00DF, 0x1900, 0xF5A3, 0xED7A },
 { 0xFD5F, 0x1394, 0x02A8, 0xEE1A }, { 0xF987, 0x19E0, 0xFEA3, 0xF1F4 },
 { 0xFD0D, 0x1891, 0xF8BC, 0xF076 }, { 0xFDC4, 0x1AEE, 0xF866, 0xEBA9 },
 { 0xFB8B, 0x1294, 0xF597, 0xEA2E }, { 0xFBCF, 0x10AD, 0xFE51, 0xF042 },
 { 0x00BA, 0x1681, 0x0394, 0xE914 }, { 0xF88D, 0x12E4, 0x03F9, 0xEC0E },
 { 0xFC3D, 0x0D23, 0xFB20, 0xE734 }, { 0xF342, 0x12A6, 0xF8E6, 0xE91E },
 { 0x034F, 0x0EE4, 0xF616, 0xEF32 }, { 0xFB39, 0x170F, 0x0550, 0xEA99 },
 { 0xFBBA, 0x1B0B, 0xFB24, 0xF6B3 }, { 0x010B, 0x1884, 0xFD3B, 0xF4E2 },
 { 0xFF63, 0x16D0, 0x0464, 0xEF56 }, { 0x0379, 0x0C86, 0xFC72, 0xEB47 },
 { 0xF938, 0x0D10, 0x0246, 0xED1A }, { 0xF6CB, 0x162C, 0xF579, 0xE77B },
 { 0xF884, 0x1AF5, 0xFC26, 0xEAEB }, { 0xF40A, 0x178C, 0xFD49, 0xE9C9 },
 { 0x072C, 0x0DEE, 0xFAB3, 0xEB96 }, { 0xF780, 0x134A, 0x0286, 0xF0E0 },
 { 0xF769, 0x0BEF, 0xFF30, 0xE814 }, { 0xFF14, 0x0BD8, 0xFCCB, 0xEB33 },
 { 0xF06B, 0x1C6D, 0xFDCB, 0xF0C5 }, { 0xFDAD, 0x110A, 0x004A, 0xE8A9 },
 { 0x02AC, 0x16F2, 0xFCB7, 0xEEB8 }, { 0xF555, 0x18A1, 0xF6AB, 0xEAA7 },
 { 0xE971, 0x052D, 0xFFC8, 0xF620 }, { 0xE48B, 0xFDEA, 0xF89E, 0xF332 },
 { 0xE95A, 0xFFF1, 0xF552, 0xF75E }, { 0xEA80, 0xFB52, 0xFE9F, 0xF1B5 },
 { 0xEC29, 0x03C0, 0xFC82, 0xEF10 }, { 0xE847, 0xFFDC, 0xFF7B, 0xF43A },
 { 0xE96A, 0xFEFD, 0xFBFF, 0xF06E }, { 0xE545, 0x04EE, 0xFCD9, 0xF999 },
 { 0xEB71, 0xFC6A, 0xF326, 0xFDBD }, { 0xED18, 0x01CD, 0xF792, 0xFDEB },
 { 0xE882, 0xFFCE, 0xFD94, 0x01F8 }, { 0xE92D, 0x00F1, 0xFAB1, 0xFEE6 },
 { 0xE8F6, 0x0241, 0x0301, 0xF339 }, { 0xE54F, 0xFC4E, 0xFE2E, 0xF2ED },
 { 0xE876, 0x05B3, 0xFE00, 0xFD27 }, { 0xE33F, 0x02EB, 0xFE7C, 0xFBAA },
 { 0xE709, 0x085E, 0xFB78, 0xF62F }, { 0xE4AD, 0x0130, 0x01F2, 0xF58F },
 { 0xE59B, 0x02A7, 0xFE7E, 0xFE4F }, { 0xEB9A, 0x0698, 0xFBBB, 0xFBF8 },
 { 0xEC65, 0x023F, 0x00B8, 0xF1D5 }, { 0xEF73, 0x0274, 0xF24D, 0xFB25 },
 { 0xE2C9, 0xFE38, 0xF946, 0xFA32 }, { 0xE6C0, 0x02C9, 0xFB07, 0xFB7F },
 { 0xE791, 0x0692, 0xFDA2, 0xF1E9 }, { 0xE487, 0x05D9, 0xFFB9, 0xF85D },
 { 0xE5DA, 0x0614, 0xF947, 0xF372 }, { 0xE81E, 0xFE9C, 0x032D, 0xF5F1 },
 { 0xEB44, 0x0278, 0xF8C5, 0xF99C }, { 0xE992, 0xFC71, 0xF93B, 0x017F },
 { 0xE83D, 0xFE7D, 0xF6F7, 0xFC91 }, { 0xE679, 0xFDEE, 0xFA1F, 0xF7DD },
 { 0xECE0, 0x04C7, 0xF542, 0xF8E8 }, { 0xE708, 0xFE31, 0xF351, 0xF7D3 },
 { 0xEB03, 0x04F0, 0xF56E, 0xF41E }, { 0xF0CA, 0xFA92, 0xFC04, 0xFC85 },
 { 0xE7DD, 0x0490, 0xF852, 0xF87E }, { 0xEBD6, 0x0684, 0xF9AF, 0xF884 },
 { 0xE6CB, 0x0398, 0xFB6F, 0xF680 }, { 0xE80E, 0x07D5, 0xFDE8, 0xFA11 },
 { 0xE668, 0xFF9E, 0xFDFA, 0xF86E }, { 0xE298, 0x0163, 0xFBB3, 0xF914 },
 { 0xE98F, 0x0262, 0xFF09, 0xFAB0 }, { 0xE4A5, 0x00B1, 0xF7F0, 0xF85A },
 { 0xE4D4, 0xFDC6, 0xF754, 0xEF7F }, { 0xE16A, 0x0317, 0xFA8E, 0xF52A },
 { 0xE22E, 0x01E0, 0xF39D, 0xEF80 }, { 0xE117, 0x0482, 0xFEA2, 0xF6B3 },
 { 0xEC39, 0x06A8, 0xF8F4, 0xF45F }, { 0xECE9, 0xFDF4, 0xF571, 0x00BC },
 { 0xEA51, 0x0196, 0xF9AC, 0xF409 }, { 0xE43B, 0x053E, 0x017D, 0xF433 },
 { 0xE542, 0x0277, 0xFE36, 0xF2BA }, { 0xEE02, 0xFDA3, 0x000B, 0xF0A6 },
 { 0xE03A, 0xFF1F, 0xF936, 0xF5A8 }, { 0xE47D, 0x0192, 0xF552, 0xF40D },
 { 0xE307, 0x0721, 0xF60F, 0xEEDB }, { 0xE4C5, 0xFF14, 0xFBF9, 0xFD67 },
 { 0xE988, 0x083F, 0xF9A0, 0xF120 }, { 0xE214, 0xFFB2, 0xFD90, 0xF3C1 },
 { 0xE72A, 0x026B, 0xF861, 0xF0B9 }, { 0xE03A, 0x0198, 0xF871, 0xF191 },
 { 0xE741, 0x0777, 0xF6C0, 0xEE67 }, { 0xE434, 0x0873, 0xFEA8, 0xF53F },
 { 0x0935, 0x1188, 0x08AC, 0xE9CE }, { 0x0569, 0x0C86, 0x08FC, 0xEB47 },
 { 0x058B, 0x09FD, 0x1453, 0xF244 }, { 0x0106, 0x10DB, 0x0F50, 0xF8C9 },
 { 0x0CF4, 0x0C73, 0x064C, 0xEA17 }, { 0x06C1, 0x092E, 0x0689, 0xE84C },
 { 0x0643, 0x17EE, 0x05BB, 0xF4E9 }, { 0xFAC5, 0x0CF4, 0x0E6B, 0xF236 },
 { 0xFDCD, 0x120A, 0x0C6C, 0xEE3C }, { 0x01CF, 0x1210, 0x0C27, 0xEA12 },
 { 0x04DE, 0x154F, 0x0D1C, 0xE9A8 }, { 0x01E0, 0x0865, 0x152E, 0xF4B3 },
 { 0x06E8, 0x12DB, 0x0391, 0xEA35 }, { 0xFF6B, 0x1505, 0x110E, 0xF31F },
 { 0x03D9, 0x0E58, 0x0A54, 0xFFA4 }, { 0xFEFE, 0x0B5F, 0x16B9, 0xF75B },
 { 0x0D64, 0x0CD9, 0x0D17, 0xF22B }, { 0xFD66, 0x0CDF, 0x1277, 0xF4CB },
 { 0x0023, 0x19F1, 0x1040, 0xF02C }, { 0x026F, 0x1A83, 0x0C54, 0xEE30 },
 { 0x0A5E, 0x1108, 0x1244, 0xEDE8 }, { 0x056A, 0x147E, 0x12E2, 0xEE6F },
 { 0x0DA0, 0x11DE, 0x0F10, 0xE8C6 }, { 0x017F, 0x1181, 0x1048, 0xEFF2 },
 { 0x06D9, 0x0E44, 0x10C0, 0xF302 }, { 0x0540, 0x1329, 0x09CC, 0xEDCC },
 { 0x062C, 0x100A, 0x0C20, 0xF750 }, { 0x07EB, 0x13AE, 0x0693, 0xF9EE },
 { 0x01BE, 0x0E73, 0x16F0, 0xF43B }, { 0x121D, 0x0FF7, 0x0DFA, 0xEC66 },
 { 0x0A45, 0x0DE8, 0x14D3, 0xECDC }, { 0x05F7, 0x1A12, 0x09DB, 0xEFDD },
 { 0xFA63, 0x0AF4, 0x09E0, 0xEE90 }, { 0xFF1B, 0x0D1B, 0x07E0, 0xEA5F },
 { 0x0E52, 0x0D5A, 0x1116, 0xEE1B }, { 0x04A8, 0x0ED7, 0x039B, 0xE63C },
 { 0x07F8, 0x0B8C, 0x01C0, 0xEB36 }, { 0x09A4, 0x1688, 0x0FBD, 0xE913 },
 { 0x0D6E, 0x1974, 0x0DC9, 0xE5F5 }, { 0x0AB1, 0x1577, 0x02A8, 0xEA61 },
 { 0x0F38, 0x165F, 0x0709, 0xECA2 }, { 0x137C, 0x135D, 0x0E08, 0xE68A },
 { 0xFDE2, 0x1140, 0x16A2, 0xF51D }, { 0x1028, 0x1102, 0x0810, 0xEDA8 },
 { 0x0BFB, 0x1730, 0x04B7, 0xF2BC }, { 0x0AE5, 0x1366, 0x0965, 0xF0F2 },
 { 0x06C3, 0x0CC6, 0x0CB3, 0xFBD9 }, { 0x06E7, 0x15A1, 0x0824, 0xF6D3 },
 { 0x01D1, 0x0C2C, 0x11B4, 0xFCBB }, { 0x05DB, 0x0A43, 0x1202, 0xF75C },
 { 0x007A, 0x0C17, 0x0E3A, 0xF220 }, { 0x09EE, 0x0B32, 0x0A91, 0xE6FE },
 { 0x0C3E, 0x10E3, 0x02BA, 0xED4F }, { 0x02DB, 0x0743, 0x0C28, 0xEB86 },
 { 0x09F9, 0x0BA4, 0x0CA9, 0xED12 }, { 0x0531, 0x14BE, 0x0647, 0xE620 },
 { 0x09A4, 0x0742, 0x0D94, 0xFBF6 }, { 0xFF54, 0x1384, 0x07D0, 0xEA46 },
 { 0x0A3D, 0x107C, 0x0626, 0xF2C6 }, { 0xFEB3, 0x0728, 0x0D22, 0xEFEB },
 { 0x0879, 0x1A6A, 0x0BF9, 0xE7AF }, { 0x0B1C, 0x1598, 0x0C97, 0xED63 },
 { 0x020E, 0x1437, 0x066C, 0xEF55 }, { 0x0B6A, 0x114A, 0x096E, 0xF5CE },
 { 0x01C4, 0x0577, 0xEE5C, 0xF5B4 }, { 0x0B38, 0x06B8, 0xEDC5, 0xFA65 },
 { 0x04FF, 0x02BE, 0xEAD0, 0xF840 }, { 0x088B, 0x0366, 0xEC63, 0xFAC3 },
 { 0x0247, 0xFF70, 0xEDEC, 0xF660 }, { 0x0003, 0x08BD, 0xEB5C, 0xF4F5 },
 { 0xFFED, 0x03ED, 0xEAAC, 0xF8E5 }, { 0x0B51, 0x0824, 0xE903, 0xFDFD },
 { 0xFE70, 0x0D2A, 0xEA69, 0xF47D }, { 0x05E1, 0x0A21, 0xEA72, 0xF8F6 },
 { 0x053D, 0x11B6, 0xEC1A, 0xF895 }, { 0x0CA9, 0x0E56, 0xEA8B, 0xFB1C },
 { 0xFAF9, 0x0399, 0xE896, 0xF975 }, { 0x0273, 0x0198, 0xE604, 0xFE94 },
 { 0xFEFC, 0x0467, 0xED0F, 0xF351 }, { 0x0173, 0x0D48, 0xE8A8, 0xF713 },
 { 0x05FD, 0x061E, 0xE71B, 0xFD9E }, { 0x099E, 0x10B2, 0xE7D8, 0xFB1A },
 { 0x06F6, 0x0D23, 0xE7B2, 0xFA9B }, { 0x023C, 0x122A, 0xE9D7, 0xF53E },
 { 0x0A72, 0x0D56, 0xEE94, 0xF796 }, { 0x0E1E, 0x0EEC, 0xE51D, 0xFE72 },
 { 0x0470, 0xFFFF, 0xEA79, 0xFBA8 }, { 0xF913, 0x0471, 0xE9F1, 0xF6B7 },
 { 0xFD0F, 0x0838, 0xE83B, 0xF5FB }, { 0xFF34, 0x0BD1, 0xED85, 0xFA76 },
 { 0xFA32, 0x059E, 0xEEE4, 0xFF28 }, { 0x012E, 0x035A, 0xE966, 0xFEF8 },
 { 0x0D9E, 0x05D7, 0xEB8E, 0xFCF1 }, { 0x0378, 0x0917, 0xF2A1, 0xF178 },
 { 0xFEFD, 0x0304, 0xE63C, 0xFAE1 }, { 0xFB53, 0x0819, 0xEBCA, 0xF8DE },
 { 0x05DC, 0x0D8E, 0xEE92, 0xF5AB }, { 0x0C00, 0x07A8, 0xF333, 0xF728 },
 { 0x0731, 0x03B8, 0xEF1C, 0xF6DC }, { 0x07CA, 0x0898, 0xF09C, 0xF495 },
 { 0xF90A, 0x06A3, 0xEDC5, 0xFBCD }, { 0xFA48, 0x0B5A, 0xF274, 0xFE89 },
 { 0x016E, 0x094C, 0xF15D, 0x05BB }, { 0xFDDF, 0x066D, 0xEDF5, 0x0178 },
 { 0x06BC, 0x092E, 0xF6BA, 0xF248 }, { 0x0C70, 0x0A44, 0xF44C, 0xF335 },
 { 0x02DE, 0x07DA, 0xE7A1, 0xFA39 }, { 0x020C, 0x0EAC, 0xEE70, 0xF341 },
 { 0x05D4, 0x0DF2, 0xF25A, 0xF1F0 }, { 0xFC5C, 0x026A, 0xEAF3, 0xF4B2 },
 { 0xFF7B, 0x0871, 0xF00D, 0xF33D }, { 0x0312, 0x0306, 0xF331, 0xF16D },
 { 0x0436, 0x0323, 0xF0FD, 0xF441 }, { 0xFEB4, 0x0D4D, 0xF2ED, 0x0028 },
 { 0xFFEF, 0x0006, 0xF05B, 0xF196 }, { 0xFF43, 0x1114, 0xEE78, 0xF5FF },
 { 0xFE3E, 0x0F06, 0xF132, 0xFAA6 }, { 0x016A, 0x08A4, 0xEB68, 0xFFF1 },
 { 0xFA07, 0x0317, 0xE56E, 0xF708 }, { 0x0861, 0x1091, 0xEE86, 0x0178 },
 { 0x0715, 0x097A, 0xF48C, 0xF55A }, { 0xFDE2, 0x11CD, 0xF3BC, 0xFBC8 },
 { 0x04A8, 0x0EC8, 0xEEED, 0xFFEC }, { 0x0AE0, 0x1444, 0xE701, 0xFA8E },
 { 0x01AF, 0x11D1, 0xF1A7, 0xFA8A }, { 0x0566, 0x0C18, 0xF00D, 0x04E5 },
 { 0x04B9, 0x1080, 0xF48E, 0x05DC }, { 0x0AEE, 0x0A7C, 0xE5EC, 0xFDA2 },
 { 0xF6A4, 0x05E6, 0xEAFB, 0xF567 }, { 0xF5BF, 0x09EE, 0xF040, 0xF4C0 },
 { 0xFB31, 0x0F7F, 0xEFFE, 0xF4BA }, { 0xFA8F, 0x0946, 0xF0EA, 0xEE53 },
 { 0xF641, 0x0681, 0xF99B, 0xEABB }, { 0xF0F2, 0x06DF, 0xF92A, 0xECB0 },
 { 0xF6BB, 0x0684, 0xF4D8, 0xE795 }, { 0xF594, 0x07BD, 0xFC8A, 0xEE33 },
 { 0xF491, 0x114B, 0xF285, 0xE7E4 }, { 0xF87B, 0x0A24, 0xEDA8, 0xF621 },
 { 0xF37E, 0x0B1F, 0xF0A8, 0xE8F8 }, { 0xF2FC, 0x0681, 0xEC5F, 0xF2AC },
 { 0xF374, 0x0C2B, 0xEFC5, 0xF022 }, { 0xFC0B, 0x0C85, 0xEBF3, 0xF159 },
 { 0xF81A, 0x11F3, 0xF095, 0xEA15 }, { 0xF21C, 0x06DB, 0xF17D, 0xF704 },
 { 0xF908, 0x1012, 0xF55D, 0xF913 }, { 0xF1FE, 0x0FF1, 0xF553, 0xECB2 },
 { 0xF9B8, 0x0E65, 0xEFC6, 0xEE23 }, { 0xF2D8, 0x0FCA, 0xEE9C, 0xE7AD },
 { 0xFA81, 0x0F29, 0xE99F, 0xF179 }, { 0xF541, 0x0CD1, 0xEC2B, 0xEC79 },
 { 0xF131, 0x096A, 0xECD6, 0xEB58 }, { 0xFD26, 0x08FF, 0xEF87, 0xF155 },
 { 0xF8EC, 0x0907, 0xEA8C, 0xF183 }, { 0xFD9E, 0x10F0, 0xF0B5, 0xF139 },
 { 0xF4E7, 0x10F1, 0xEF4A, 0xEEB2 }, { 0xF982, 0x123A, 0xEDCB, 0xF084 },
 { 0xFDB3, 0x1459, 0xECC5, 0xF19E }, { 0xEFC5, 0x08BA, 0xF014, 0xEF86 },
 { 0xF091, 0x0AD2, 0xF597, 0xF50B }, { 0xF702, 0x0C9C, 0xF17B, 0xF88C },
 { 0xF3C7, 0x1115, 0xF728, 0xF4DD }, { 0xFE41, 0x0553, 0xF206, 0xEF1D },
 { 0xF5A8, 0x108D, 0xF3A9, 0xF401 }, { 0xF018, 0x0CA9, 0xF22B, 0xEE03 },
 { 0xEE65, 0x0D82, 0xF6DD, 0xF102 }, { 0xF992, 0x03E5, 0xECC2, 0xF07E },
 { 0xF42F, 0x064E, 0xF09C, 0xFB26 }, { 0xFAC7, 0x06DC, 0xF3A5, 0xEA67 },
 { 0xF37D, 0x0749, 0xF32E, 0xEEFE }, { 0xF992, 0x0846, 0xF765, 0xE87E },
 { 0x00AE, 0x074F, 0xF56D, 0xEDE1 }, { 0xF5D1, 0x05CD, 0xED56, 0xED72 },
 { 0xF769, 0x0F97, 0xF3C2, 0xECF1 }, { 0xF46E, 0x0CFB, 0xF500, 0xF68D },
 { 0xEB5A, 0x09BF, 0xEE3C, 0xEAED }, { 0xF506, 0x0E7E, 0xF71E, 0xEF8D },
 { 0xFEB6, 0x0BBE, 0xF44F, 0xEDBA }, { 0xFB5D, 0x096B, 0xF549, 0xEBB4 },
 { 0xFD68, 0x0FC1, 0xF3E3, 0xE9F7 }, { 0xFA4E, 0x0E12, 0xF500, 0xEB05 },
 { 0xEFEC, 0x133B, 0xF307, 0xEA02 }, { 0xEFBB, 0x09E0, 0xF5E0, 0xED42 },
 { 0xF539, 0x0C08, 0xF6E3, 0xE9A9 }, { 0xEBDB, 0x0BC3, 0xEA6A, 0xE734 },
 { 0xF3E9, 0x084E, 0xE907, 0xEF76 }, { 0xEEE7, 0x0F09, 0xF1F0, 0xE82D },
 { 0xF836, 0x1353, 0xEB8D, 0xED6F }, { 0xFBD5, 0x0258, 0xF346, 0xEBF3 },
 { 0xEC80, 0x0CE6, 0xF760, 0xEC45 }, { 0xF2CF, 0x0BA5, 0xF989, 0xED31 },
 { 0xF303, 0x098E, 0xF905, 0xE81C }, { 0xF6DB, 0x0AB1, 0xF358, 0xE735 },
 { 0xF72E, 0xF16C, 0x0E7E, 0xFB2D }, { 0xF9EA, 0xF0F7, 0x0A86, 0xF43C },
 { 0xFDA9, 0xED1B, 0x0BEA, 0xF479 }, { 0xF73A, 0xEAC7, 0x0AEE, 0xF88A },
 { 0xF731, 0xEC83, 0x0CBC, 0x010E }, { 0xF42E, 0xEB17, 0x0A85, 0xFBF4 },
 { 0xFB81, 0xE82F, 0x0449, 0xF13A }, { 0xF2C1, 0xE884, 0x0852, 0xFAE9 },
 { 0xF4DE, 0xEEBA, 0x0D2F, 0xFE20 }, { 0xFB8E, 0xF13D, 0x05D3, 0xEFBE },
 { 0xFDD9, 0xF0CC, 0x0ECB, 0xF7DE }, { 0xF36B, 0xF1A4, 0x0C48, 0xFB4E },
 { 0xF431, 0xEBB4, 0x0A5A, 0x025D }, { 0xF924, 0xE99F, 0x0A56, 0x0141 },
 { 0xF57B, 0xEEC7, 0x01EE, 0xED43 }, { 0xF887, 0xEE23, 0x0D2C, 0xF93E },
 { 0xFB03, 0xF1EC, 0x0FDD, 0xFC1F }, { 0xFE5C, 0xEC7F, 0x0547, 0xED44 },
 { 0xF414, 0xEB2B, 0x059B, 0xFB26 }, { 0xFDA6, 0xEC56, 0x0F1D, 0xFB8B },
 { 0xF67C, 0xEDB8, 0x0681, 0xF435 }, { 0xF59F, 0xF1B6, 0x05B3, 0xF2C1 },
 { 0xFB3C, 0xE79A, 0x0ABD, 0xFDF3 }, { 0xF102, 0xED14, 0x08D9, 0xF939 },
 { 0xFB21, 0xE9D1, 0x0D1C, 0xFA77 }, { 0xFC6B, 0xEAB8, 0x0D0E, 0x0069 },
 { 0xF924, 0xE549, 0x08E4, 0xF6D2 }, { 0xFE64, 0xEBAA, 0x06E4, 0xF22D },
 { 0xFA61, 0xE4FD, 0x05A2, 0xF15A }, { 0xFA9B, 0xEEA9, 0x0F17, 0xFEE6 },
 { 0xF266, 0xECA7, 0x0AA6, 0xFEB0 }, { 0xFAA0, 0xE8D5, 0x06B2, 0xF83D },
 { 0xF94C, 0xEECB, 0x0A30, 0x0069 }, { 0xF9CA, 0xEBB9, 0x0A5C, 0xF570 },
 { 0xF79B, 0xE6D6, 0x0995, 0xFB11 }, { 0xF29E, 0xF108, 0x091E, 0xF8DB },
 { 0xF545, 0xE8C4, 0x093A, 0xFF53 }, { 0xF67D, 0xF33D, 0x0B96, 0xF952 },
 { 0xF075, 0xEF46, 0x0A91, 0xFCF9 }, { 0xFE9C, 0xEF72, 0x09F0, 0xEF09 },
 { 0xFAAD, 0xE6B9, 0x0B01, 0xF8D4 }, { 0xF4C2, 0xEC03, 0x00DA, 0xF3B3 },
 { 0xF22D, 0xEBB4, 0x06AE, 0xF6CC }, { 0xF4B8, 0xEE47, 0x0ABA, 0xF95B },
 { 0xF8B2, 0xEEA9, 0x05D8, 0xEFE7 }, { 0xFA32, 0xF2C4, 0x0D15, 0xF79F },
 { 0xF2FB, 0xEFD6, 0x05BB, 0xF4C4 }, { 0xFEA7, 0xEB24, 0x03F4, 0xFB5A },
 { 0xF978, 0xEC80, 0x08F1, 0xFBFB }, { 0xF79E, 0xEA68, 0x0BDE, 0xFD85 },
 { 0xFEC4, 0xF1B8, 0x0D62, 0xF3B0 }, { 0xF579, 0xE94C, 0x0920, 0xF7FE },
 { 0xF7ED, 0xE85C, 0x02E1, 0xF346 }, { 0xF598, 0xEF93, 0xFEA2, 0xFB0E },
 { 0xFD97, 0xEAE2, 0x0050, 0xED0B }, { 0xF68E, 0xF10F, 0x073D, 0xFAD2 },
 { 0xF857, 0xEF0D, 0x0247, 0xEF25 }, { 0xFA29, 0xEBEB, 0xFF7B, 0xEBAB },
 { 0xF378, 0xE6D8, 0x069B, 0xF7EB }, { 0xF5B8, 0xF1CF, 0x0915, 0xF537 },
 { 0xF5C0, 0xE9DA, 0x04E4, 0xF1A4 }, { 0xF199, 0xEA18, 0x02AF, 0xF4EF },
 { 0xF308, 0xE9B5, 0x0010, 0xF0DB }, { 0xF54E, 0xE820, 0x0054, 0xEBF1 },
 { 0x08E5, 0xE9E3, 0x0C04, 0x034B }, { 0x0613, 0xE977, 0x0B05, 0xEB8C },
 { 0x0218, 0xE713, 0x025B, 0xECD2 }, { 0x02DE, 0xEDFF, 0x0CF2, 0xF004 },
 { 0x072C, 0xEE3D, 0x0CC3, 0xEF1E }, { 0xFFF3, 0xE8A8, 0x0EA8, 0xF9B9 },
 { 0x058F, 0xE752, 0x0920, 0x018E }, { 0x016D, 0xE19D, 0x05DA, 0xFDEA },
 { 0x0838, 0xDF52, 0x0B82, 0xFABF }, { 0x008F, 0xEA57, 0x076A, 0xF154 },
 { 0x028F, 0xE53C, 0x0596, 0x0094 }, { 0x0004, 0xE603, 0x095D, 0xFFC5 },
 { 0x092A, 0xE894, 0x11D2, 0xFC5A }, { 0x04CD, 0xE440, 0x0B93, 0xFDAA },
 { 0xFDF0, 0xE478, 0x0B47, 0xF902 }, { 0x05AB, 0xE537, 0x0F3C, 0xF99B },
 { 0x022A, 0xE87E, 0x0D08, 0x0009 }, { 0x0CCE, 0xE982, 0x0FC2, 0x0081 },
 { 0x0DD5, 0xE417, 0x1329, 0xF9D9 }, { 0x0923, 0xE505, 0x0D88, 0xFED3 },
 { 0x0AD7, 0xE37B, 0x0683, 0xF0CA }, { 0x021B, 0xE131, 0x03DF, 0xEFC4 },
 { 0x0843, 0xE303, 0x0C3B, 0xF3FD }, { 0x0AF3, 0xDE9E, 0x0A04, 0xE934 },
 { 0x0B35, 0xE937, 0x0654, 0xEE2F }, { 0x0A1F, 0xE38F, 0x0C8F, 0xED91 },
 { 0xFB34, 0xDEE3, 0x02C2, 0xED52 }, { 0x07AF, 0xEB85, 0x12CD, 0xF86C },
 { 0x02BD, 0xE49E, 0x08E1, 0xF0CB }, { 0x0393, 0xDEEA, 0x077E, 0xEA0C },
 { 0xFFA2, 0xE5C5, 0x009C, 0xF0DF }, { 0x0432, 0xEA19, 0x1125, 0xFC07 },
 { 0x0AB3, 0xE669, 0x04CB, 0xF23F }, { 0x02D5, 0xE165, 0x0A8D, 0xFAF5 },
 { 0xFE13, 0xE2CD, 0x08D7, 0xFBCD }, { 0xFE64, 0xE694, 0x0BA8, 0xFD18 },
 { 0x0299, 0xEAB5, 0x0E8D, 0xF57C }, { 0x05DB, 0xE03F, 0x0DEC, 0xF7E8 },
 { 0x0B36, 0xE743, 0x1187, 0xF7C4 }, { 0x02C2, 0xEC71, 0x0F47, 0xFF68 },
 { 0xFE1E, 0xDE2C, 0x05CB, 0xF4AC }, { 0x09B1, 0xE63C, 0x09D6, 0xF94D },
 { 0x057B, 0xE6F2, 0x0576, 0xEAF5 }, { 0x028C, 0xE785, 0x0247, 0xE8CA },
 { 0x02B6, 0xE28C, 0x0286, 0xE780 }, { 0x08E3, 0xE242, 0x0100, 0xEC69 },
 { 0x0588, 0xDA01, 0x076C, 0xF3AF }, { 0x0AC8, 0xE6DF, 0x0F23, 0xF145 },
 { 0x0915, 0xD444, 0x0886, 0xEBDD }, { 0x04C7, 0xD4CB, 0x0561, 0xEC17 },
 { 0x006C, 0xD695, 0x0133, 0xECA8 }, { 0xFF8A, 0xDFB4, 0x0672, 0xF9DC },
 { 0x072F, 0xE0F9, 0x06DB, 0xFD9C }, { 0x09C5, 0xDCA0, 0x03D5, 0xF467 },
 { 0x0B56, 0xDEE4, 0x05D3, 0xE96C }, { 0x07CB, 0xD459, 0x0631, 0xF1C5 },
 { 0x02B8, 0xDFEC, 0x033C, 0xF656 }, { 0x05F6, 0xDE37, 0x0564, 0xFB46 },
 { 0x01CD, 0xE3AB, 0x0C96, 0xF74B }, { 0x0B96, 0xDE3F, 0x1019, 0xF339 },
 { 0x0341, 0xE869, 0x0939, 0xFBC2 }, { 0x0DED, 0xE370, 0x07BC, 0xEACD },
 { 0x0B22, 0xDE21, 0x0EB0, 0xF8CA }, { 0x0A53, 0xE38F, 0x0873, 0xFF53 },
 { 0x0D87, 0xF186, 0xF3C4, 0xFC65 }, { 0x0523, 0xF10F, 0xF28D, 0x0002 },
 { 0x0A22, 0xF00D, 0xF119, 0x029E }, { 0x0722, 0xEF3D, 0xF54B, 0xFF65 },
 { 0x0364, 0xF15B, 0xEFB1, 0xFED6 }, { 0x07D8, 0xEF73, 0xF0C7, 0xFDFB },
 { 0x04DA, 0xF25B, 0xEF11, 0xFAC9 }, { 0xFFA8, 0xEFD2, 0xF2C2, 0xFA07 },
 { 0x0880, 0xF260, 0xF112, 0xFC31 }, { 0x06AA, 0xEBBC, 0xF2A9, 0xFD83 },
 { 0x0A9D, 0xE7F1, 0xF6E3, 0xFC8E }, { 0x04FC, 0xF076, 0xEEF7, 0x0219 },
 { 0x09A7, 0xEA4C, 0xF4CE, 0xFF30 }, { 0x031F, 0xEDBF, 0xF00A, 0x0038 },
 { 0x076D, 0xED4E, 0xF233, 0x010E }, { 0x0BDC, 0xF0C2, 0xF1EA, 0xFEB3 },
 { 0x08C9, 0xF30B, 0xEF21, 0xFF70 }, { 0x0A22, 0xEF91, 0xF7C7, 0xF48E },
 { 0x0FA8, 0xED5A, 0xF5BE, 0xFC7A }, { 0x040E, 0xF1B5, 0xF258, 0xF66A },
 { 0x0AA5, 0xF1F3, 0xF31E, 0xFA01 }, { 0x067E, 0xE955, 0xF503, 0x00AF },
 { 0x02C1, 0xF153, 0xF28F, 0xFA34 }, { 0x0744, 0xE89D, 0xF4FB, 0xFC8A },
 { 0x0ECA, 0xECCA, 0xF769, 0xF877 }, { 0x0E63, 0xEF75, 0xF60D, 0xFAF9 },
 { 0x09E3, 0xECE0, 0xF474, 0xF9C7 }, { 0x03ED, 0xEA2F, 0xF304, 0xFF4C },
 { 0x0659, 0xEB93, 0xF924, 0xF1C6 }, { 0x05D6, 0xEC4F, 0xF453, 0xF583 },
 { 0x0A9E, 0xEDD1, 0xF368, 0xFC9D }, { 0x0946, 0xE610, 0xF92F, 0xF461 },
 { 0x0855, 0xE6DC, 0xF653, 0xFA25 }, { 0x0729, 0xEEBE, 0xF23D, 0xFA18 },
 { 0x0468, 0xECD2, 0xF59E, 0xFBAE }, { 0x02B1, 0xED57, 0xF4F1, 0xF7DB },
 { 0x0E09, 0xEB60, 0xF5BD, 0xFEC5 }, { 0x0CC0, 0xF145, 0xF58F, 0xF8BB },
 { 0x0C82, 0xEA1E, 0xF697, 0x0192 }, { 0x0228, 0xEDF6, 0xF753, 0xF446 },
 { 0x0C17, 0xEB14, 0xF596, 0xFBC5 }, { 0x0D49, 0xEDFF, 0xF3B6, 0x002D },
 { 0x0BEB, 0xEDCA, 0xF770, 0xF748 }, { 0x0AEE, 0xEA50, 0xF662, 0xF86B },
 { 0x0932, 0xE949, 0xF751, 0xF5C5 }, { 0x00C0, 0xF184, 0xF509, 0xF59E },
 { 0x075E, 0xEF7E, 0xF8BA, 0xF237 }, { 0x09DE, 0xF078, 0xF4FD, 0xF6E4 },
 { 0x0629, 0xF0E2, 0xF569, 0xF50A }, { 0x0508, 0xEA2C, 0xF2CA, 0xFA85 },
 { 0x0A97, 0xEAE9, 0xF9E4, 0xF34B }, { 0x05B3, 0xEA8C, 0xF752, 0xFEBE },
 { 0x0B07, 0xEC1D, 0xF4BA, 0x0308 }, { 0x0DE7, 0xE943, 0xF7C3, 0xFAB0 },
 { 0x0633, 0xE745, 0xF538, 0xF88B }, { 0x085B, 0xEBA3, 0xF4C6, 0xF7B8 },
 { 0x0526, 0xEF0F, 0xF191, 0xF7CE }, { 0x0335, 0xEE89, 0xF8C7, 0xFDCB },
 { 0x0D01, 0xED52, 0xF943, 0xFFA7 }, { 0x0246, 0xECCE, 0xEFF7, 0xFBA1 },
 { 0x01A1, 0xEFD0, 0xF018, 0xF61F }, { 0xFF39, 0xF125, 0xF533, 0xF036 },
 { 0x0AAB, 0xEF45, 0xF7A1, 0x0001 }, { 0x0B5F, 0xE7D5, 0xF861, 0xF7BC },
 { 0x0625, 0xE832, 0xFE13, 0xF4EA }, { 0x0821, 0xE4F1, 0xFCA0, 0xF375 },
 { 0x0422, 0xE16E, 0x004F, 0xFE94 }, { 0x0C4B, 0xEA3E, 0xFD54, 0xFC2E },
 { 0x0DF4, 0xE920, 0x0424, 0x0720 }, { 0x0477, 0xE5D2, 0xFA3A, 0x0152 },
 { 0x0925, 0xE3CC, 0xFFA8, 0x0104 }, { 0x0E37, 0xE533, 0x029C, 0x032F },
 { 0x08B3, 0xE784, 0xF956, 0x01BE }, { 0x0D3E, 0xE83E, 0xFE9F, 0x0516 },
 { 0x0463, 0xE27C, 0xFB2B, 0xFE52 }, { 0x06C1, 0xE1C2, 0x02D9, 0xFF26 },
 { 0x05B1, 0xE58A, 0x024B, 0x0243 }, { 0x01F9, 0xE4F9, 0xFDC7, 0x0173 },
 { 0x0452, 0xE3B3, 0x004E, 0x009E }, { 0x0AC3, 0xE5A7, 0xFB9E, 0x0152 },
 { 0x0BFD, 0xE868, 0xFA79, 0x03DA }, { 0x087E, 0xE468, 0xFA6A, 0xFEE5 },
 { 0x056E, 0xDE4E, 0xFE42, 0xF429 }, { 0x0DCE, 0xE516, 0xFE51, 0x0223 },
 { 0x08DB, 0xDA6E, 0x01DB, 0xF44E }, { 0x0E58, 0xE207, 0x004B, 0xFF8D },
 { 0x0853, 0xE278, 0xFB4A, 0xFD12 }, { 0x0B9C, 0xE2CB, 0xFD53, 0xFEFA },
 { 0x0644, 0xE613, 0xFD60, 0x02BB }, { 0x0682, 0xE267, 0xFDBF, 0xFF10 },
 { 0x0637, 0xE666, 0xF792, 0xFFA2 }, { 0x092C, 0xE772, 0xFE9F, 0x0463 },
 { 0x07E1, 0xDD96, 0xFE64, 0xF8F3 }, { 0x0B4C, 0xE5C7, 0xF91B, 0xFDD6 },
 { 0x09C4, 0xE554, 0xF835, 0xFB53 }, { 0x0F25, 0xE611, 0xFF20, 0xF989 },
 { 0x0958, 0xE140, 0xFFA5, 0xFEB3 }, { 0x0DEA, 0xE336, 0xFDEC, 0xF4EC },
 { 0x09F8, 0xE242, 0x00A4, 0xF8F3 }, { 0x03DE, 0xE828, 0x00DA, 0x01B6 },
 { 0x038E, 0xE14B, 0x0138, 0xFB55 }, { 0x05C0, 0xE749, 0x0174, 0xFD80 },
 { 0x0628, 0xE419, 0xF841, 0xFCB5 }, { 0x01A6, 0xE237, 0xFE37, 0xFEEA },
 { 0x0705, 0xDEAC, 0x0195, 0xFC0D }, { 0x0440, 0xE31C, 0xFF12, 0xF71B },
 { 0x0C89, 0xE59F, 0xFA69, 0xF7E8 }, { 0x0A39, 0xE549, 0x0064, 0xF5F3 },
 { 0x0A0F, 0xDE83, 0xFE7D, 0xF38C }, { 0x0E22, 0xE4C5, 0xFB5A, 0xFEBF },
 { 0x089D, 0xE33F, 0xF961, 0xF828 }, { 0x0BA9, 0xE767, 0x05B8, 0x049B },
 { 0x0AF4, 0xE372, 0x041D, 0x0152 }, { 0x0552, 0xE846, 0xFB75, 0xFCB8 },
 { 0x0D08, 0xE74B, 0xF8FE, 0x0015 }, { 0x0B14, 0xE053, 0x0332, 0xFEB7 },
 { 0x0AE7, 0xE909, 0x0230, 0x060A }, { 0x0958, 0xE850, 0x0087, 0x0064 },
 { 0x072E, 0xE7CE, 0x0254, 0x043D }, { 0x0786, 0xE2A5, 0xFE62, 0xECDB },
 { 0x0C99, 0xE37E, 0xFB4E, 0xFB5B }, { 0x0F78, 0xE27A, 0xFD6D, 0xFD31 },
 { 0x0D72, 0xE609, 0xF964, 0xFBB9 }, { 0x0D35, 0xE6D7, 0x0106, 0xFC8A },
 { 0x0597, 0xE02A, 0xFB5E, 0xFA82 }, { 0x0154, 0xDECE, 0xFF6A, 0xFC7D },
 { 0x0BBC, 0xE02B, 0xFEFC, 0xFC47 }, { 0x0ABD, 0xE62D, 0x0233, 0x0369 },
 { 0xE609, 0xFAD3, 0xEE5B, 0xEDAD }, { 0xE88B, 0xF987, 0xF007, 0xF12B },
 { 0xF3AB, 0x024C, 0xEBA3, 0xF404 }, { 0xF311, 0xFA6F, 0xE747, 0xF172 },
 { 0xE916, 0xFCCD, 0xF0EF, 0xF548 }, { 0xEC77, 0xF8F9, 0xFBCD, 0xEDF3 },
 { 0xEB2E, 0xF5A6, 0xF590, 0xEDC8 }, { 0xECBE, 0xFDE5, 0xF6C5, 0xF056 },
 { 0xF458, 0x000A, 0xF0E9, 0xE98B }, { 0xFBE1, 0xF7C6, 0xF17F, 0xEF55 },
 { 0xEA9C, 0xFE0A, 0xEF49, 0xE698 }, { 0xEB91, 0xF9F9, 0xEC66, 0xE6E7 },
 { 0xEBF2, 0xFE95, 0xF3A3, 0xEC0B }, { 0xF08F, 0xFCFD, 0xEFF5, 0xE707 },
 { 0xF791, 0xFDCD, 0xF1BC, 0xEB22 }, { 0xF0D0, 0xF6EF, 0xFC69, 0xEC3F },
 { 0xFB2C, 0xFDAB, 0xEF75, 0xEF9F }, { 0xF02B, 0x02A3, 0xF3F5, 0xE7E2 },
 { 0xF517, 0xFBBF, 0xEAEC, 0xF27C }, { 0xF448, 0xFFD4, 0xF75F, 0xE651 },
 { 0xF2F8, 0xFA05, 0xEF27, 0xEBD8 }, { 0xF7B1, 0x0080, 0xED0D, 0xF194 },
 { 0xF307, 0x0088, 0xF7ED, 0xE9E4 }, { 0xEBA1, 0x057C, 0xEEEA, 0xEEFC },
 { 0xF545, 0x0190, 0xE73C, 0xF195 }, { 0xF0AA, 0xFDA9, 0xEB0F, 0xEC72 },
 { 0xF4C5, 0xF5E0, 0xEBE9, 0xF004 }, { 0xEC81, 0xF85A, 0xEB36, 0xECE5 },
 { 0xEC9B, 0xFADA, 0xE604, 0xEB2B }, { 0xECC8, 0xF965, 0xF2C4, 0xEA47 },
 { 0xF1C4, 0xF2E6, 0xF580, 0xE8A2 }, { 0xEC2C, 0xFC69, 0xEE2D, 0xF458 },
 { 0xE81E, 0x00FA, 0xF0D4, 0xF0B5 }, { 0xF052, 0x02E8, 0xF07B, 0xF87C },
 { 0xEA59, 0xFBEF, 0xEA4B, 0xF0F9 }, { 0xED99, 0xFAB8, 0xE9EF, 0xF5D5 },
 { 0xF2DE, 0x0307, 0xEB47, 0xECF1 }, { 0xEC77, 0x006B, 0xF21E, 0xF4B8 },
 { 0xE78E, 0xF98D, 0xE72C, 0xE65A }, { 0xEE4F, 0x0197, 0xEC75, 0xF0E7 },
 { 0xEBDE, 0x0226, 0xEB62, 0xEAA7 }, { 0xEF9D, 0xFE2D, 0xF89A, 0xF3C7 },
 { 0xEC62, 0x0467, 0xF2EB, 0xF30E }, { 0xE845, 0x04E2, 0xEF27, 0xE9F7 },
 { 0xF58B, 0xF715, 0xF6F8, 0xE8F1 }, { 0xEFEF, 0x00C1, 0xFB55, 0xED1F },
 { 0xF09C, 0xFBE8, 0xFA93, 0xEC29 }, { 0xF189, 0x0395, 0xF035, 0xEE9D },
 { 0xF2DA, 0xEF79, 0xFA02, 0xEA90 }, { 0xF302, 0xF201, 0xF7D5, 0xECD9 },
 { 0xEBE8, 0x04E6, 0xF61C, 0xECAB }, { 0xE8A2, 0xFC9A, 0xF60F, 0xEE35 },
 { 0xF0AB, 0xFF63, 0xEB09, 0xF717 }, { 0xE6ED, 0xFD16, 0xE9DC, 0xEEED },
 { 0xE965, 0x0206, 0xE448, 0xE953 }, { 0xEF5E, 0x03BA, 0xE6CB, 0xEF1F },
 { 0xED5D, 0xFD49, 0xEFC2, 0xF999 }, { 0xE45A, 0xFD08, 0xEBB5, 0xE90B },
 { 0xE34C, 0x0053, 0xEFFB, 0xEE16 }, { 0xF682, 0x00B8, 0xF4C6, 0xF971 },
 { 0xF714, 0xF099, 0xF494, 0xEC56 }, { 0xF8F4, 0xF907, 0xF446, 0xED9A },
 { 0xEED1, 0xF52C, 0xF8E9, 0xEDE3 }, { 0xE73C, 0xF5BE, 0xF4F8, 0xEBB9 },
 { 0xEC7A, 0xEBD0, 0xF268, 0x0771 }, { 0xF08A, 0xEA8C, 0xF9C1, 0x062B },
 { 0xF659, 0xF155, 0xFEEC, 0x0C6E }, { 0xF427, 0xE96D, 0xFBD9, 0x0612 },
 { 0xF488, 0xED23, 0xFAF6, 0x0952 }, { 0xF8D5, 0xEC2F, 0xF415, 0x0513 },
 { 0xF944, 0xF145, 0xF0A1, 0x0914 }, { 0xEC32, 0xF60A, 0xF194, 0x0300 },
 { 0xEF1A, 0xEB2B, 0xFED7, 0x0756 }, { 0xF270, 0xEA0D, 0xF3EA, 0x03E0 },
 { 0xF42D, 0xEEE0, 0xF422, 0x08D9 }, { 0xF37F, 0xEB2C, 0x0043, 0x0898 },
 { 0xF96F, 0xEEEB, 0xF865, 0x099D }, { 0xF36B, 0xF2FF, 0xEF72, 0x0A04 },
 { 0xFB12, 0xF468, 0xF49D, 0x0C9B }, { 0xF2A5, 0xF8AA, 0xF2D3, 0x083E },
 { 0xF73C, 0xEA31, 0xF824, 0x0508 }, { 0xF84D, 0xEB6E, 0xFC22, 0x0714 },
 { 0xF461, 0xF526, 0xFE3C, 0x0FDF }, { 0xF76A, 0xFB73, 0xF31E, 0x0B95 },
 { 0xED52, 0xECE2, 0xED61, 0x0298 }, { 0xE88E, 0xF092, 0xF50A, 0x07E9 },
 { 0xF3BA, 0xF3A6, 0xF4D5, 0x0CDF }, { 0xF342, 0xF2F4, 0xEFE5, 0x063C },
 { 0xF052, 0xF0B2, 0xF85D, 0x0D21 }, { 0xF95C, 0xF279, 0xFABE, 0x0D79 },
 { 0xEF6B, 0xEEA3, 0xED79, 0x066C }, { 0xEFAC, 0xF07F, 0xFE6F, 0x0CD1 },
 { 0xF522, 0xEB88, 0xEFEB, 0x0484 }, { 0xE990, 0xF038, 0xFA61, 0x0D8E },
 { 0xEC39, 0xEDC9, 0xFEBD, 0x0C64 }, { 0xEE4D, 0xF309, 0xFCB4, 0x0F94 },
 { 0xE7AE, 0xEBFB, 0xF7F0, 0x0BA0 }, { 0xF3D5, 0xF33D, 0xFA05, 0x0F3A },
 { 0xEDEC, 0xEEBB, 0xF4D0, 0x0AF8 }, { 0xEE31, 0xF453, 0xF28E, 0x07E8 },
 { 0xF911, 0xEE79, 0xFD70, 0x09AD }, { 0xF598, 0xF8B7, 0xF8A4, 0x0FF1 },
 { 0xF8DC, 0xF5F1, 0xF0CA, 0x0D32 }, { 0xE6D7, 0xF1A3, 0xF817, 0x068D },
 { 0xEFD3, 0xF794, 0xFB59, 0x0D92 }, { 0xED3E, 0xF9A9, 0xF941, 0x0870 },
 { 0xEA9E, 0xF547, 0xFA3D, 0x09C2 }, { 0xF1B0, 0xFBE0, 0xF849, 0x09BB },
 { 0xEDC0, 0xF40A, 0xF745, 0x0B75 }, { 0xEF93, 0xE8B8, 0xF4DF, 0x05ED },
 { 0xEC7D, 0xE9B4, 0xF935, 0x070D }, { 0xECE4, 0xE840, 0xED47, 0x0368 },
 { 0xEF52, 0xEFB4, 0xEF59, 0x0889 }, { 0xEDB1, 0xFA42, 0xF4A7, 0x03FF },
 { 0xE6D2, 0xEC67, 0xF0B1, 0x03E8 }, { 0xE862, 0xEA5E, 0xF099, 0x07D6 },
 { 0xE874, 0xF15A, 0xF08F, 0x0303 }, { 0xE8B9, 0xEE1A, 0xEC60, 0x0338 },
 { 0xE946, 0xF5F0, 0xF737, 0x052E }, { 0xE9E5, 0xEB1F, 0xFBA1, 0x09C4 },
 { 0xF2EE, 0xEFC5, 0x025E, 0x0ABD }, { 0xE9D0, 0xED25, 0xF63B, 0x072E },
 { 0xE7CF, 0xF611, 0xFAF1, 0x0348 }, { 0xE529, 0xECC3, 0xF248, 0x0709 },
 { 0xEA1B, 0xF904, 0xF899, 0x030B }, { 0xF0AE, 0xE9B0, 0xEDDC, 0x01FE },
 { 0xED77, 0xF0E3, 0xEE4B, 0x0063 }, { 0xF458, 0xECD5, 0xFE71, 0x05D9 },
 { 0x0737, 0xFE22, 0x0BF5, 0xE94C }, { 0x1162, 0xFBA4, 0x0E19, 0xE656 },
 { 0x0C43, 0x0063, 0x0BBF, 0xEA64 }, { 0x0A1E, 0xF13A, 0x0C42, 0xED5E },
 { 0x0759, 0x04B4, 0x1692, 0xF2B4 }, { 0x0E2F, 0x080C, 0x15BE, 0xEC52 },
 { 0x0D85, 0x07A9, 0x142F, 0xF128 }, { 0x0B83, 0x0111, 0x11B8, 0xEEDB },
 { 0x1165, 0xF93E, 0x169C, 0xEEEE }, { 0x0FC0, 0x070D, 0x0A6A, 0xEE4A },
 { 0x0D9F, 0xFC50, 0x0909, 0xE874 }, { 0x0521, 0x0022, 0x1072, 0xF01D },
 { 0x1600, 0xFA22, 0x16C1, 0xE921 }, { 0x1E38, 0xFDDD, 0x130F, 0xEA9C },
 { 0x132A, 0xFA18, 0x1298, 0xE980 }, { 0x0F03, 0x01BF, 0x0443, 0xECA2 },
 { 0x0BA6, 0xFB91, 0x1542, 0xEEDE }, { 0x0DFB, 0x010F, 0x0BD7, 0xE58E },
 { 0x0F5C, 0xFF2D, 0x1250, 0xEA7D }, { 0x113B, 0x06B8, 0x0953, 0xEA30 },
 { 0x1503, 0xFE21, 0x11DF, 0xE778 }, { 0x0E1D, 0xFE96, 0x07DC, 0xECEB },
 { 0x0EA0, 0xF823, 0x118D, 0xEC2F }, { 0x163D, 0x006D, 0x111B, 0xF2DE },
 { 0x1563, 0xFD93, 0x14C5, 0xF06F }, { 0x190B, 0xFD5F, 0x164C, 0xED70 },
 { 0x1345, 0xFCE4, 0x1C5E, 0xEF3E }, { 0x0AF4, 0x01BC, 0x1884, 0xF1B9 },
 { 0x1018, 0xFDFB, 0x17BE, 0xEE4D }, { 0x13FF, 0x0349, 0x0D9E, 0xF0BA },
 { 0x1282, 0x0603, 0x0DC5, 0xF466 }, { 0x13DE, 0x0172, 0x1707, 0xE9F8 },
 { 0x108B, 0x0A9C, 0x11ED, 0xEC4C }, { 0x0E6B, 0x02AA, 0x1837, 0xEDA4 },
 { 0x17DF, 0xFDC6, 0x187F, 0xE680 }, { 0x0A33, 0x04FD, 0x0EAC, 0xED3E },
 { 0x112B, 0x03CA, 0x0EDF, 0xE909 }, { 0x1469, 0x08FB, 0x0CAA, 0xEF13 },
 { 0x1418, 0x06F2, 0x1352, 0xEA57 }, { 0x0BAD, 0xF438, 0x0CAF, 0xEA89 },
 { 0x0BA7, 0x0398, 0x0817, 0xE855 }, { 0x1496, 0xFC79, 0x1152, 0xF6D2 },
 { 0x190F, 0xFDB7, 0x0F82, 0xF21E }, { 0x0F1A, 0xFF3B, 0x1460, 0xF4BC },
 { 0x0EB7, 0xFAEE, 0x1A2E, 0xF30D }, { 0x189B, 0x0A3C, 0x14A4, 0xE558 },
 { 0x19FE, 0x0286, 0x0E45, 0xECC1 }, { 0x12A2, 0x0BE7, 0x1428, 0xE771 },
 { 0x14F4, 0x01B2, 0x0B67, 0xEBA9 }, { 0x0BB6, 0x0540, 0x12C1, 0xF668 },
 { 0x0F38, 0x03F5, 0x0EBD, 0xF8B8 }, { 0x0843, 0x028F, 0x0BB7, 0xE738 },
 { 0x1432, 0xFC2B, 0x0B21, 0xEE90 }, { 0x0AAF, 0xF791, 0x0A9D, 0xE970 },
 { 0x097E, 0xF860, 0x1128, 0xEE31 }, { 0x17FF, 0xFB64, 0x0E4B, 0xED76 },
 { 0x1372, 0xFA35, 0x06BE, 0xECF5 }, { 0x0D9E, 0xF6B1, 0x0CEA, 0xEF33 },
 { 0x059A, 0xFAA4, 0x104B, 0xED5E }, { 0x0D1A, 0xF5BD, 0x05F5, 0xEC1B },
 { 0x1A86, 0x0952, 0x0F9B, 0xE8EB }, { 0x05C3, 0xF58E, 0x0D7B, 0xEF94 },
 { 0x07CF, 0xF25A, 0x0E6D, 0xEA4C }, { 0x129C, 0xF4E0, 0x0B28, 0xEA2B },
 { 0xF1A3, 0x140B, 0x0B0B, 0xF48A }, { 0xF4E4, 0x1BA6, 0x0B24, 0xF204 },
 { 0xF0C2, 0x1922, 0x1016, 0xF889 }, { 0xF917, 0x1D6A, 0x0DA4, 0xF22B },
 { 0xF86F, 0x162F, 0xFE41, 0xFB99 }, { 0xF668, 0x1248, 0x1064, 0xF699 },
 { 0xF526, 0x2031, 0x06A2, 0xEF40 }, { 0xF4C4, 0x17D8, 0x143E, 0xF6AD },
 { 0xF50E, 0x1CAD, 0x116F, 0xF486 }, { 0xFBFF, 0x187B, 0x1290, 0xF37F },
 { 0xF6D3, 0x1525, 0x07F9, 0xF12E }, { 0xF734, 0x2021, 0x0B28, 0xEF53 },
 { 0xFA47, 0x1367, 0x1370, 0xF63C }, { 0xFD84, 0x1D8D, 0x0DBD, 0xEF77 },
 { 0xF88F, 0x15F2, 0x0F40, 0xF482 }, { 0xFED2, 0x1AA0, 0x0D0F, 0xF30C },
 { 0xF75E, 0x103C, 0x0B01, 0xF249 }, { 0xFD33, 0x19A8, 0x0747, 0xF479 },
 { 0xF0DF, 0x1632, 0x0874, 0xFDC1 }, { 0xF4C2, 0x16CB, 0x01B8, 0xF5DB },
 { 0xF364, 0x1E15, 0x0A32, 0xF62E }, { 0xF1E8, 0x22B8, 0x0D31, 0xF65C },
 { 0xF5EA, 0x25F5, 0x09D7, 0xF3CA }, { 0xEB8A, 0x183A, 0x0B32, 0xF4F1 },
 { 0xF29C, 0x1CCA, 0x0BF0, 0xFEB1 }, { 0xF96F, 0x2284, 0x04BA, 0xF826 },
 { 0xF334, 0x1A44, 0x0484, 0xF0A6 }, { 0xFC82, 0x1FD5, 0x033B, 0xFB16 },
 { 0xF46B, 0x21B7, 0x09F5, 0xFAD8 }, { 0xF087, 0x1AF6, 0x0DFD, 0x0037 },
 { 0xF89A, 0x1E41, 0x06D6, 0xFCB7 }, { 0xFCCB, 0x1ABC, 0x0352, 0xFD5C },
 { 0xFDA0, 0x1B24, 0xFFFC, 0xFAA0 }, { 0x0267, 0x197C, 0x0441, 0xFB85 },
 { 0xF464, 0x1624, 0x0443, 0xFE17 }, { 0xFF63, 0x1229, 0x0B58, 0xFE63 },
 { 0x02A1, 0x1401, 0x05DA, 0xFFBE }, { 0xFE7A, 0x170E, 0x064B, 0xFF0B },
 { 0xF6D3, 0x1566, 0x12A4, 0xFAD8 }, { 0x0058, 0x1A8E, 0x07B4, 0xF8BD },
 { 0xFB43, 0x1400, 0x0BAF, 0x00C8 }, { 0xF6D5, 0x1798, 0x0B17, 0x0178 },
 { 0xFDBE, 0x1758, 0x0D24, 0xF8FC }, { 0xFA91, 0x16F0, 0x0BBA, 0xFC3B },
 { 0xFDCC, 0x1190, 0x0F6A, 0xFB5E }, { 0xF705, 0x18F2, 0x0C3F, 0xF780 },
 { 0xF7AD, 0x1609, 0x07DB, 0x04C7 }, { 0xFCFC, 0x16AF, 0x0464, 0x037F },
 { 0xF4EB, 0x1A66, 0x08F9, 0xFD1C }, { 0xF3ED, 0x189A, 0x0587, 0xF7B2 },
 { 0xEF9B, 0x1794, 0x0733, 0xF432 }, { 0xFFD7, 0x193B, 0x005C, 0x0158 },
 { 0xF73F, 0x1ACC, 0x082F, 0xEED4 }, { 0xF875, 0x1BB0, 0x0845, 0xF7A9 },
 { 0xF6B9, 0x1146, 0x0698, 0xF39F }, { 0xF932, 0x1A12, 0x0602, 0xFF89 },
 { 0xED2E, 0x1E45, 0x1060, 0xF9D7 }, { 0xF82C, 0x1628, 0x00C1, 0xFE52 },
 { 0xF10F, 0x179A, 0x0850, 0xF896 }, { 0xFBAC, 0x1F61, 0x0847, 0xF43B },
 { 0xF6BE, 0x154D, 0x06B9, 0x010A }, { 0xF9DE, 0x1BDE, 0x0266, 0xF5B2 },
 { 0xFA11, 0x2230, 0x0DAF, 0xEF16 }, { 0xF7FE, 0x0F05, 0x0B5B, 0xFB9A },
 { 0x13DD, 0x113C, 0xFEB1, 0xF87D }, { 0x0E22, 0x058F, 0xFD9B, 0xF054 },
 { 0x1181, 0x0E91, 0x024D, 0xEDE9 }, { 0x10AE, 0x0C90, 0xF91D, 0xF3A0 },
 { 0x1091, 0x0704, 0xF95B, 0xF514 }, { 0x12B3, 0x0922, 0xFE19, 0xF1C9 },
 { 0x0B63, 0x0D65, 0xFD93, 0xED6F }, { 0x1437, 0x067C, 0xFB0F, 0xF369 },
 { 0x10B8, 0x0FD9, 0xFD54, 0xF011 }, { 0x1374, 0x1143, 0xFA51, 0xF561 },
 { 0x153C, 0x09A0, 0x0183, 0xEF9B }, { 0x119B, 0x0FB2, 0x0461, 0xF30E },
 { 0x1784, 0x0961, 0xFE63, 0xF37F }, { 0x1068, 0x0ECD, 0xFEB3, 0xF503 },
 { 0x146D, 0x09BD, 0xFB56, 0xF8AA }, { 0x16DB, 0x0A87, 0xFE14, 0xF70C },
 { 0x166F, 0x0CD8, 0xFD47, 0xFB3B }, { 0x163C, 0x0A34, 0x03D3, 0xF74D },
 { 0x13DD, 0x0813, 0x0416, 0xFB42 }, { 0x0C5B, 0x08C0, 0xF7CE, 0xF295 },
 { 0x146C, 0x076A, 0x0091, 0xF6A3 }, { 0x16E4, 0x0F88, 0xFE5E, 0xF4C8 },
 { 0x1778, 0x0D47, 0x0403, 0xF24E }, { 0x101E, 0x07F3, 0x0749, 0xFC83 },
 { 0x14FF, 0x0E0C, 0x01FF, 0xF6C6 }, { 0x0791, 0x05D5, 0xFCAC, 0xFF86 },
 { 0x0D91, 0x12F1, 0x0223, 0xF5D5 }, { 0x1217, 0x0BA1, 0x0475, 0xF918 },
 { 0x1805, 0x0BEA, 0xFFB9, 0xF8A2 }, { 0x0FE5, 0x1101, 0xFEDF, 0xFA6B },
 { 0x0B44, 0x04C9, 0xFA94, 0x016D }, { 0x156D, 0x09D6, 0xFF15, 0xFDC5 },
 { 0x04C0, 0x1117, 0x05A3, 0x018E }, { 0x137C, 0x0C22, 0x006B, 0xFA65 },
 { 0x119F, 0x0AF1, 0x0133, 0xFE44 }, { 0x0CA3, 0x1122, 0x0147, 0xFD5C },
 { 0x0807, 0x0E7C, 0x0679, 0xFECF }, { 0x16CF, 0x0946, 0x0122, 0xFA97 },
 { 0x13F6, 0x0CE9, 0x0790, 0xEF92 }, { 0x1910, 0x0B68, 0x0152, 0xF550 },
 { 0x0D16, 0x0B08, 0xFB0B, 0xF0D7 }, { 0x12E8, 0x0717, 0x01D0, 0x00BA },
 { 0x095F, 0x0D04, 0x00EE, 0x04D6 }, { 0x0DBC, 0x0553, 0x062E, 0x02B0 },
 { 0x0DFE, 0x0752, 0x009A, 0xED5E }, { 0x0CBD, 0x0B3E, 0x0376, 0x011B },
 { 0x0F25, 0x0A62, 0xFEB9, 0x0374 }, { 0x1037, 0x0D6C, 0x087D, 0xF495 },
 { 0x0E08, 0x0E5A, 0x0501, 0xFAF1 }, { 0x11D1, 0x0E92, 0xFBA6, 0xF92D },
 { 0x11F3, 0x0E29, 0xFDD2, 0xFDC1 }, { 0x0A11, 0x092C, 0x08DB, 0x0078 },
 { 0x147A, 0x0CE3, 0x0020, 0xF2AC }, { 0x10A8, 0x0E35, 0x02C5, 0xF6F0 },
 { 0x199C, 0x0DF2, 0xFCBA, 0xF658 }, { 0x1671, 0x0FAE, 0xFC54, 0xF84B },
 { 0x15FD, 0x117B, 0x01DD, 0xF300 }, { 0x1495, 0x0C7F, 0x0692, 0xF3F3 },
 { 0x1150, 0x0970, 0x0479, 0xF31D }, { 0x1171, 0x09C9, 0x0872, 0xF776 },
 { 0x1223, 0x134D, 0xFFA8, 0xF4BB }, { 0x11D8, 0x146F, 0x0228, 0xF0B5 },
 { 0x1623, 0x0C03, 0xFA82, 0xF46D }, { 0x152A, 0x148B, 0xFCFD, 0xF4FE },
 { 0xFF00, 0xE13D, 0x01FF, 0xFE29 }, { 0xF8EB, 0xE0DD, 0xFE58, 0xFE74 },
 { 0xFECE, 0xE4A2, 0x035E, 0x011A }, { 0xF6FE, 0xE6EA, 0xFA60, 0x01FC },
 { 0xFF0B, 0xE57D, 0x0177, 0xFF9C }, { 0xFAE3, 0xE84F, 0xFFEC, 0x030B },
 { 0xF988, 0xE861, 0xFD7F, 0x051B }, { 0xFA28, 0xE686, 0x03C4, 0x02D6 },
 { 0xF70D, 0xE644, 0xFF36, 0x031B }, { 0xFD06, 0xE29E, 0x05AE, 0xFDD2 },
 { 0xF722, 0xE4A4, 0xFCBE, 0xFDBC }, { 0xFB8D, 0xE45A, 0x0103, 0x016A },
 { 0xF619, 0xE270, 0xFBF0, 0x0031 }, { 0xF136, 0xE390, 0x03A6, 0xFE24 },
 { 0xF2F8, 0xE720, 0x025E, 0x0420 }, { 0xF1EE, 0xE4F4, 0x0034, 0x02CA },
 { 0xF71A, 0xE66A, 0x068A, 0x00CC }, { 0xF4D9, 0xE97B, 0x03A2, 0x05FA },
 { 0xF4B7, 0xE363, 0xFF29, 0x0131 }, { 0xF543, 0xE840, 0xFF13, 0x05AC },
 { 0xFC27, 0xE5F5, 0x0629, 0x0190 }, { 0xF80C, 0xE83D, 0x017C, 0x04F3 },
 { 0xF7E3, 0xE2DC, 0x017C, 0xFFE2 }, { 0xF911, 0xE3F9, 0x0604, 0xFE7E },
 { 0xF407, 0xE4F1, 0x03DD, 0x00A8 }, { 0xF4EC, 0xE24E, 0x0075, 0xF2C0 },
 { 0xFBDE, 0xE704, 0x0251, 0xF3FA }, { 0xFCB4, 0xE852, 0x03E7, 0xFF14 },
 { 0xF343, 0xE4D9, 0x05D3, 0xFD30 }, { 0xF776, 0xDEDC, 0x004B, 0xFAF9 },
 { 0xF4BE, 0xE1B4, 0x01C8, 0xFE02 }, { 0xF8F8, 0xE521, 0x03C0, 0xFB61 },
 { 0xF606, 0xE3B7, 0x064E, 0xFA3E }, { 0xF5D0, 0xEB47, 0x0188, 0x0353 },
 { 0xF463, 0xE65E, 0xFCA5, 0x035A }, { 0xF5B0, 0xE89B, 0x0407, 0xFE60 },
 { 0xFC2F, 0xDF52, 0x02C1, 0xFA66 }, { 0xFB43, 0xE30F, 0xFFB3, 0xFA92 },
 { 0xFAC9, 0xE5FF, 0x084D, 0xFF85 }, { 0xF610, 0xE532, 0x073C, 0xFD1F },
 { 0xF35D, 0xE6EA, 0x06D8, 0xFF99 }, { 0xFAEC, 0xE27B, 0x03AB, 0xFEA4 },
 { 0xF26C, 0xE265, 0x00CA, 0xFF93 }, { 0xF64E, 0xE654, 0x02F1, 0x026B },
 { 0xF606, 0xE038, 0xFD78, 0xFE53 }, { 0xFC0C, 0xE142, 0xFFFD, 0xFE5B },
 { 0xF1EC, 0xE799, 0x0020, 0xF3E2 }, { 0xFA32, 0xE399, 0x07DD, 0xFC03 },
 { 0xFDBE, 0xE571, 0xFDF5, 0x0195 }, { 0xF4E7, 0xE8C4, 0x066C, 0x038F },
 { 0xF695, 0xE2CF, 0x043C, 0xFE1C }, { 0xF742, 0xE86F, 0x0126, 0xFBDD },
 { 0xF27D, 0xE6BA, 0xFF37, 0xFCEA }, { 0xF815, 0xE887, 0x0729, 0x0325 },
 { 0xFA67, 0xE091, 0x05FB, 0xF926 }, { 0xF346, 0xE134, 0x02FB, 0xFA72 },
 { 0xF9F8, 0xE4F0, 0xFD27, 0x01DE }, { 0xF6F6, 0xDF21, 0x004A, 0xF153 },
 { 0xF37F, 0xE9CC, 0x005F, 0xF75A }, { 0xF689, 0xDE0A, 0x02D5, 0xF1D1 },
 { 0xF227, 0xE461, 0x048A, 0xF8FA }, { 0xFEDA, 0xDA42, 0x0193, 0xF71E },
 { 0xF70E, 0xEAAC, 0x04AC, 0x0192 }, { 0xF9BD, 0xE5C7, 0x0387, 0xF6C5 },
 { 0x1019, 0x09BB, 0xF3BA, 0xF64E }, { 0x1194, 0x0CE9, 0xF1A9, 0xF9E1 },
 { 0x1755, 0x0C64, 0xFABC, 0xFDEA }, { 0x12DE, 0x0D33, 0xF9F3, 0x0283 },
 { 0x145E, 0x0F62, 0xF5AF, 0xF702 }, { 0x121F, 0x12DA, 0xEA64, 0xFCB1 },
 { 0x1607, 0x0AAB, 0xF786, 0xFC3D }, { 0x17C4, 0x0D9F, 0xF23B, 0xFABE },
 { 0x1753, 0x0C52, 0xF772, 0xF6F4 }, { 0x15F2, 0x1301, 0xE4F1, 0x0074 },
 { 0x14E1, 0x0DF0, 0xE321, 0x02C5 }, { 0x1535, 0x13D6, 0xF11D, 0xFA0C },
 { 0x1B30, 0x07F5, 0xF245, 0xFBB8 }, { 0x1BB4, 0x09E3, 0xEE33, 0xFDB4 },
 { 0x17AD, 0x1097, 0xE9ED, 0xFE22 }, { 0x11F3, 0x0E64, 0xECD5, 0xFCC5 },
 { 0x1D49, 0x0C8D, 0xF418, 0xFE58 }, { 0x176C, 0x0859, 0xF3E6, 0xF92F },
 { 0x1836, 0x144F, 0xF751, 0xF71E }, { 0x1AE8, 0x0B23, 0xF530, 0xF975 },
 { 0x17E2, 0x1072, 0xF6F4, 0xFC46 }, { 0x1BD7, 0x1092, 0xF41F, 0xFA80 },
 { 0x17EE, 0x0E54, 0xFA13, 0xFA6D }, { 0x1865, 0x17F1, 0xEF7F, 0xFB5E },
 { 0x1AA0, 0x0C8D, 0xF7CB, 0xFC3C }, { 0x14E1, 0x149C, 0xF5AD, 0xFCB1 },
 { 0x19C0, 0x1239, 0xEF0E, 0x01E4 }, { 0x1A5A, 0x0EA7, 0xF28D, 0x007C },
 { 0x154D, 0x07BC, 0xF54E, 0x0A2E }, { 0x1236, 0x0883, 0xEF7E, 0xFBDD },
 { 0x15C3, 0x0C88, 0xF21E, 0x00AE }, { 0x1488, 0x115F, 0xF8E9, 0xFA37 },
 { 0x1518, 0x0A0A, 0xFB46, 0x00EB }, { 0x1B90, 0x09F5, 0xF58E, 0x013E },
 { 0x11DE, 0x10F4, 0xF4B4, 0xFF7E }, { 0x183B, 0x11EB, 0xF337, 0xFECF },
 { 0x13EF, 0x0785, 0xF565, 0xF7A7 }, { 0x0F41, 0x10C8, 0xF95C, 0x00F7 },
 { 0x1145, 0x11FD, 0xF31D, 0x032B }, { 0x1627, 0x04F9, 0xF0E2, 0xFC64 },
 { 0x156E, 0x070D, 0xECDB, 0x0085 }, { 0x1925, 0x0A12, 0xF8DC, 0xFF96 },
 { 0x159A, 0x1485, 0xEC3E, 0x04C7 }, { 0x12D0, 0x07E9, 0xFB41, 0x05A3 },
 { 0x0D81, 0x0DC5, 0xF668, 0x0C91 }, { 0x0CF4, 0x0A23, 0xFBAC, 0x099B },
 { 0x0BFC, 0x0EE2, 0xF761, 0x0786 }, { 0x18CF, 0x153C, 0xE6BA, 0x0258 },
 { 0x18B4, 0x1090, 0xEB0B, 0x0970 }, { 0x12F3, 0x12A6, 0xF015, 0x0756 },
 { 0x1324, 0x0E5F, 0xEBB2, 0x0436 }, { 0x209B, 0x0E31, 0xEE2B, 0xFF55 },
 { 0x147C, 0x1656, 0xF0F3, 0x00AD }, { 0x0F78, 0x0DA4, 0xF485, 0x0839 },
 { 0x17B6, 0x0D91, 0xF6D1, 0x00A1 }, { 0x2024, 0x0BDA, 0xF2E0, 0xFC7B },
 { 0x1B5E, 0x0F91, 0xF86C, 0xF87A }, { 0x1BD3, 0x1249, 0xEF33, 0xFC92 },
 { 0x1402, 0x1001, 0xF8C5, 0xFE3F }, { 0x1838, 0x080C, 0xF735, 0x0419 },
 { 0x1BC2, 0x0F04, 0xE3D7, 0x0A41 }, { 0x1BC4, 0x0D2A, 0xE5B2, 0x0215 },
 { 0x1ACB, 0x0B21, 0xF068, 0x0550 }, { 0x1552, 0x08E6, 0xF34B, 0x046B },
 { 0xFBD0, 0xF7C3, 0x12AF, 0xFBCF }, { 0xFEC1, 0xF5D4, 0x10A1, 0xF68E },
 { 0x09A2, 0x0514, 0x0D94, 0xFEC6 }, { 0x0B1F, 0xFA22, 0x14B0, 0xFF73 },
 { 0x0683, 0xFB07, 0x15B7, 0xF55B }, { 0x0B3D, 0xF2B6, 0x1922, 0x00CC },
 { 0x0035, 0xF5B3, 0x149B, 0xFB63 }, { 0x0443, 0xF759, 0x16AB, 0xF9F3 },
 { 0x095D, 0xFC66, 0x10E7, 0x049E }, { 0x00DB, 0xF15D, 0x1227, 0xF9E4 },
 { 0xFFE3, 0xF56F, 0x12CC, 0x04FD }, { 0x05DB, 0xF5D0, 0x1610, 0x057F },
 { 0x085B, 0xF6A1, 0x106A, 0x0AE7 }, { 0xFE56, 0xF7F0, 0x1598, 0x0097 },
 { 0x0A00, 0xF50D, 0x1823, 0xF50A }, { 0x11B9, 0xF651, 0x0ED5, 0x0447 },
 { 0x0378, 0xF2E3, 0x14DD, 0xFE61 }, { 0x116C, 0xF8EA, 0x150C, 0xFB35 },
 { 0x0F50, 0xF33C, 0x18DC, 0xFD41 }, { 0x0D0F, 0xEDA6, 0x113A, 0x0310 },
 { 0x0135, 0xF897, 0x18A2, 0x04C7 }, { 0x03BE, 0xF30A, 0x109E, 0xF3A1 },
 { 0xFF9D, 0x063C, 0x1782, 0xF841 }, { 0xFE53, 0xFCAB, 0x1907, 0x036E },
 { 0x0492, 0xFAD6, 0x1892, 0xFE5F }, { 0x08F0, 0xFE07, 0x189F, 0xF831 },
 { 0x0CF0, 0xF976, 0x1A5D, 0xF642 }, { 0xFE61, 0xF2B7, 0x1271, 0xFE8D },
 { 0xFF43, 0xFB46, 0x12EC, 0xF82E }, { 0x0378, 0xEFD2, 0x1119, 0x0082 },
 { 0x09A5, 0xEEE3, 0x1516, 0xF644 }, { 0x0B3F, 0xF4A0, 0x13E6, 0xF5DA },
 { 0xFD33, 0xFD97, 0x1612, 0xFD53 }, { 0x05BE, 0xF0E9, 0x14E8, 0xF96C },
 { 0x0F5F, 0xFFA0, 0x0EEF, 0xFD26 }, { 0x0EB9, 0xFE52, 0x0C60, 0x02B6 },
 { 0x09FC, 0x0181, 0x0DD3, 0x0200 }, { 0x004D, 0xFA79, 0x13F7, 0x0A5F },
 { 0x0AA4, 0xF792, 0x1A3B, 0xFCCA }, { 0x0728, 0x03E9, 0x1509, 0xF894 },
 { 0x0384, 0x0896, 0x1170, 0xFDD1 }, { 0x01B9, 0x0045, 0x1721, 0xF931 },
 { 0xFB77, 0x02E2, 0x1A4C, 0xFECC }, { 0x0101, 0x07F3, 0x0FFB, 0x02E0 },
 { 0x0647, 0x0508, 0x1103, 0xFFE9 }, { 0xFFF3, 0x0524, 0x1054, 0x0688 },
 { 0x05E7, 0x0538, 0x0BF1, 0x059B }, { 0x088D, 0xF11B, 0x11B2, 0x03AB },
 { 0x0E30, 0xFD3E, 0x0A56, 0x055F }, { 0x10AA, 0xF14F, 0x1091, 0x0435 },
 { 0x0C1D, 0xFE55, 0x1499, 0xFB4E }, { 0x08F5, 0x0114, 0x12CA, 0xFEC7 },
 { 0x0D66, 0xF8C5, 0x0C1D, 0x07FD }, { 0x0D7D, 0xF45D, 0x1416, 0x03AE },
 { 0x0693, 0xF32F, 0x12C2, 0x07D2 }, { 0x0F72, 0xED95, 0x15EB, 0x0242 },
 { 0x04F8, 0xFF65, 0x13DD, 0x01C6 }, { 0x0080, 0xFF3E, 0x13E7, 0x0581 },
 { 0x0334, 0x0370, 0x16A5, 0xF59E }, { 0xFBB9, 0x0290, 0x168E, 0x0447 },
 { 0x032D, 0xF97B, 0x10E0, 0xF34D }, { 0xFF89, 0x0206, 0x18E4, 0xFD75 },
 { 0x0B6A, 0xEF35, 0x17E3, 0xFC93 }, { 0x106D, 0xEF4F, 0x0FA4, 0x0A52 },
 { 0xFB45, 0xF0CC, 0x00E0, 0x0C37 }, { 0xFFDE, 0xEEED, 0x0529, 0x090E },
 { 0x004D, 0xE74A, 0x04B1, 0x033C }, { 0x0F9B, 0xF141, 0x07A6, 0x0CA1 },
 { 0x00B2, 0xF31B, 0x07C1, 0x0CF6 }, { 0x091A, 0xF127, 0x0409, 0x0C7B },
 { 0x0585, 0xEA60, 0x033A, 0x06AD }, { 0x09A4, 0xF255, 0x0E45, 0x0E2F },
 { 0x02E5, 0xEDF7, 0x06BB, 0x07D8 }, { 0x04DE, 0xF41D, 0x0BA2, 0x0F6D },
 { 0xFEA9, 0xEF2C, 0x08D2, 0x088D }, { 0xFD56, 0xEDE0, 0x01C6, 0x08E0 },
 { 0x04D4, 0xED23, 0x09BB, 0x066A }, { 0xFE00, 0xF14A, 0x049E, 0x0BEC },
 { 0x0077, 0xF09D, 0x0E80, 0x03CB }, { 0xFB87, 0xEDF0, 0x0550, 0x08E9 },
 { 0x0065, 0xED76, 0x0B32, 0x04E7 }, { 0xFA24, 0xEAB1, 0x021B, 0x0665 },
 { 0xFC37, 0xE8EB, 0x0586, 0x0468 }, { 0xFB13, 0xECB5, 0xFF19, 0x07E6 },
 { 0xFF1E, 0xEB1F, 0x04B7, 0x02C1 }, { 0x0A98, 0xEC0B, 0x0C85, 0x074A },
 { 0xFE24, 0xE8E7, 0x0111, 0x04B8 }, { 0xF809, 0xEE90, 0x0270, 0x09F1 },
 { 0xF6D1, 0xF0A6, 0x07E3, 0x0A71 }, { 0xF58D, 0xED0F, 0x05F2, 0x07C6 },
 { 0xFA0C, 0xF27B, 0x05A6, 0x0C84 }, { 0x01DD, 0xEB3E, 0x06AE, 0x0629 },
 { 0x0290, 0xF16F, 0x092A, 0x09CF }, { 0x0226, 0xE8E3, 0x07B7, 0x0410 },
 { 0x06C0, 0xEDA0, 0x0BFB, 0x0422 }, { 0xFFF7, 0xEB81, 0x01FA, 0x06E0 },
 { 0xFDC2, 0xEBF1, 0x068B, 0x0688 }, { 0x0851, 0xF13B, 0x0D74, 0x0909 },
 { 0x0478, 0xEEA9, 0x08A6, 0x09E1 }, { 0x050C, 0xEFC0, 0x0C71, 0x0729 },
 { 0x098D, 0xF342, 0x09E6, 0x0C9B }, { 0x08DA, 0xEECF, 0x07E7, 0x0960 },
 { 0xFDB5, 0xF1EE, 0x0D50, 0x0813 }, { 0xFC8B, 0xECA9, 0x0C9C, 0x0496 },
 { 0xFD28, 0xF569, 0x0AF7, 0x0DE0 }, { 0x03FB, 0xF41D, 0x0C7B, 0x0B8A },
 { 0x0760, 0xEDF9, 0x0474, 0x0996 }, { 0x0294, 0xEA10, 0x02F2, 0x0320 },
 { 0xF849, 0xEB05, 0x0671, 0x0631 }, { 0xF9F8, 0xEAC4, 0x0976, 0x0439 },
 { 0xFE5A, 0xE906, 0x0956, 0x02EE }, { 0x0538, 0xEA4B, 0x0989, 0x04CE },
 { 0x0088, 0xF05F, 0x010B, 0x0B26 }, { 0xFDF6, 0xF327, 0x08B2, 0x0AA8 },
 { 0xFC35, 0xEE1C, 0x09A7, 0x02C4 }, { 0x02C0, 0xEB46, 0x0CE4, 0x03E9 },
 { 0x0145, 0xF278, 0x0DE3, 0x095E }, { 0x031A, 0xF19A, 0x0350, 0x0C61 },
 { 0x0294, 0xF437, 0x11E8, 0x0CAA }, { 0xFA32, 0xF076, 0x087A, 0x066C },
 { 0xF9B1, 0xEDD6, 0x0A80, 0x0734 }, { 0x02EE, 0xEE1E, 0x021A, 0x08BF },
 { 0x0684, 0xE927, 0x05AF, 0x0407 }, { 0x0D9E, 0xEDB7, 0x07EE, 0x0887 },
 { 0x0A52, 0xEACB, 0x06A0, 0x06E1 }, { 0x118B, 0xEE6A, 0x0DD2, 0x0ACF },
 { 0x0DD9, 0xEE50, 0x0DBA, 0x0BA6 }, { 0x0CC5, 0xF1A4, 0x0AC6, 0x0F7E },
 { 0x15C4, 0x047A, 0x00D1, 0xF2CD }, { 0x1D23, 0x041D, 0x0251, 0xF898 },
 { 0x1180, 0x00C8, 0xFECA, 0xEF5D }, { 0x15C9, 0xFC55, 0x00F2, 0xF068 },
 { 0x1FCE, 0x01BA, 0x04E9, 0xF3F5 }, { 0x1542, 0x04ED, 0x0590, 0xF35C },
 { 0x1874, 0xFF49, 0x0C35, 0xF61C }, { 0x1C0B, 0x0379, 0x0652, 0xF60C },
 { 0x1910, 0x03A4, 0x094B, 0xF649 }, { 0x1BB6, 0x0A00, 0x03C1, 0xF2C0 },
 { 0x1C9A, 0x01CF, 0x0AAC, 0xF169 }, { 0x19E8, 0x0629, 0x0778, 0xF338 },
 { 0x18A8, 0x0545, 0x0BD4, 0xF27C }, { 0x17D9, 0x0182, 0x04BD, 0xFC2F },
 { 0x1566, 0x0486, 0x045A, 0xFE1A }, { 0x195D, 0x019A, 0x0696, 0xF77C },
 { 0x18EA, 0x0759, 0x0535, 0xF740 }, { 0x164F, 0x032C, 0x07A6, 0xFAEC },
 { 0x1ABC, 0x036D, 0x02DA, 0xFB5B }, { 0x1AA8, 0xFF0B, 0x08C9, 0xF830 },
 { 0x1D5B, 0x05F1, 0x04E3, 0xF40E }, { 0x1A29, 0x041B, 0x0514, 0xF92B },
 { 0x194C, 0x0591, 0x032B, 0xF52B }, { 0x1CB6, 0x01D1, 0xFFB4, 0xF4DF },
 { 0x1B3F, 0x082F, 0x0237, 0xF644 }, { 0x1253, 0x06C8, 0x0A64, 0xF70F },
 { 0x1E9D, 0x05B0, 0x0154, 0xF531 }, { 0x1EFA, 0x01FB, 0x0346, 0xF7E6 },
 { 0x17DA, 0x05DE, 0x02FE, 0xFBAA }, { 0x131B, 0xFD6D, 0x0343, 0xF08E },
 { 0x1C52, 0x008D, 0x0559, 0xFA0D }, { 0x1DE3, 0x0043, 0x0673, 0xF706 },
 { 0x1CC4, 0xFECF, 0x0259, 0xF3C4 }, { 0x1C0B, 0x00C1, 0x09BB, 0xF4C9 },
 { 0x1968, 0xFEF0, 0x0877, 0xFAD6 }, { 0x1168, 0x03D7, 0x08FC, 0xFE5B },
 { 0x12D1, 0x01C9, 0x069F, 0x0173 }, { 0x1B02, 0x022B, 0x0352, 0xF3A9 },
 { 0x1710, 0x0406, 0x00CA, 0xF859 }, { 0x1872, 0x0370, 0x08B9, 0xEE69 },
 { 0x178D, 0x000A, 0x0852, 0xF1F0 }, { 0x1931, 0x03D9, 0x0469, 0xF085 },
 { 0x19D8, 0xFFEE, 0xFF91, 0xF32B }, { 0x1190, 0x0307, 0x0331, 0xEF4C },
 { 0x17F6, 0x0922, 0x05BE, 0xF463 }, { 0x1AFF, 0x0098, 0x01AE, 0xF866 },
 { 0x0FD5, 0x03DF, 0x0C92, 0xFB57 }, { 0x153B, 0x0505, 0x0C34, 0xF694 },
 { 0x1583, 0x072C, 0x078F, 0xF83C }, { 0x1478, 0x02B1, 0x088D, 0xF592 },
 { 0x19EE, 0x06B7, 0x025E, 0xF8F9 }, { 0x15B4, 0xFF4C, 0x0081, 0xF5DD },
 { 0x160C, 0x077E, 0x0501, 0xEF24 }, { 0x190A, 0x0440, 0xFEE6, 0xF3D3 },
 { 0x1967, 0x0731, 0x0138, 0xF246 }, { 0x1B23, 0x0014, 0x054E, 0xF0D2 },
 { 0x1558, 0x083D, 0x095E, 0xF386 }, { 0x15F0, 0xFE69, 0x085C, 0xFE0E },
 { 0x17E9, 0x0A93, 0x094B, 0xF000 }, { 0x1C87, 0x0736, 0x08DA, 0xF001 },
 { 0x1544, 0x01D6, 0x0A9E, 0xF9EF }, { 0x16B9, 0xFD7B, 0x0CD5, 0xFABB },
 { 0x15F9, 0x0593, 0x044F, 0xF839 }, { 0x1799, 0xFCDA, 0x04AC, 0xF481 },
 { 0x0BEA, 0xE9A6, 0x0FE6, 0xEAAC }, { 0x0D5C, 0xEEDE, 0x0FEE, 0xEBDD },
 { 0x1784, 0xF072, 0x1C64, 0xF57F }, { 0x1D4E, 0xEF23, 0x1ED6, 0xF07B },
 { 0x103C, 0xF21A, 0x147F, 0xEF24 }, { 0x1275, 0xEECF, 0x1C7A, 0xF9FC },
 { 0x1A20, 0xEBFE, 0x2018, 0xF376 }, { 0x23D8, 0xE650, 0x243C, 0xEC9D },
 { 0x2202, 0xE9B4, 0x1F33, 0xEDF3 }, { 0x1B94, 0xF231, 0x1984, 0xF314 },
 { 0x15E0, 0xF561, 0x14F3, 0xF9E0 }, { 0x1235, 0xF50D, 0x1877, 0xED94 },
 { 0x0E59, 0xF1CC, 0x1803, 0xF297 }, { 0x14B9, 0xF5E7, 0x17B9, 0xF5B2 },
 { 0x1DBE, 0xF856, 0x17BF, 0xEB6E }, { 0x1A68, 0xF2DA, 0x1CD6, 0xEF1E },
 { 0x18F1, 0xF0D5, 0x12BD, 0xFAB7 }, { 0x1FF6, 0xEC00, 0x10CA, 0xEDDF },
 { 0x23AA, 0xE7CA, 0x136F, 0xF409 }, { 0x1CFD, 0xEAC4, 0x15C8, 0xF17F },
 { 0x0D9B, 0xECDE, 0x1543, 0xF547 }, { 0x132B, 0xE9F5, 0x18F6, 0xEFF7 },
 { 0x1FB7, 0xE4A0, 0x1F38, 0xE594 }, { 0x1980, 0xE816, 0x1B37, 0xEA2A },
 { 0x1702, 0xEFA2, 0x19E0, 0xE9C8 }, { 0x1A9F, 0xE102, 0x1C6B, 0xEAB0 },
 { 0x153A, 0xEF2E, 0x1431, 0xEAFE }, { 0x110C, 0xE6DC, 0x1500, 0xF5D4 },
 { 0x1FD8, 0xF2B4, 0x1719, 0xEC48 }, { 0x1F2F, 0xED01, 0x10A6, 0xF663 },
 { 0x1F57, 0xE7D4, 0x185E, 0xEC3A }, { 0x1A61, 0xF194, 0x0F5F, 0xF175 },
 { 0x1AAA, 0xED68, 0x0CD4, 0xF02D }, { 0x1C38, 0xE301, 0x118C, 0xF0DD },
 { 0x1AF8, 0xF5E2, 0x19BB, 0xE798 }, { 0x17DA, 0xF868, 0x1CB1, 0xEA7E },
 { 0x135C, 0xF452, 0x1E80, 0xF3B6 }, { 0x1AFC, 0xE51B, 0x173D, 0xFAF8 },
 { 0x1BFA, 0xE856, 0x0D5B, 0xF2B7 }, { 0x1B67, 0xE458, 0x1AFB, 0xF436 },
 { 0x1B3B, 0xE550, 0x160E, 0xF337 }, { 0x1F4E, 0xEA56, 0x155F, 0xF9F8 },
 { 0x1A88, 0xF754, 0x13F1, 0xF4C1 }, { 0x212E, 0xF07A, 0x1138, 0xF061 },
 { 0x2577, 0xECFE, 0x178B, 0xEE32 }, { 0x1490, 0xEBD7, 0x17D5, 0xFD1E },
 { 0x16AB, 0xE803, 0x144D, 0xEB91 }, { 0x1231, 0xE55A, 0x0CA0, 0xEBBB },
 { 0x12B7, 0xEBF1, 0x0EE1, 0xEDC7 }, { 0x17DC, 0xEC11, 0x094B, 0xF0DF },
 { 0x1248, 0xF0BB, 0x0CA2, 0xEC1B }, { 0x16AA, 0xF0F3, 0x0ED3, 0xEC88 },
 { 0x1108, 0xE2C5, 0x12C2, 0xF0DB }, { 0x1535, 0xE2A3, 0x1717, 0xF17B },
 { 0x1AD2, 0xF718, 0x1310, 0xEDE6 }, { 0x2793, 0xEDEC, 0x113E, 0xF004 },
 { 0x2A3B, 0xEBBB, 0x1E42, 0xEB27 }, { 0x161F, 0xDD13, 0x14A7, 0xE9D0 },
 { 0x1F57, 0xE899, 0x1CEB, 0xF514 }, { 0x25C5, 0xE4F9, 0x197D, 0xECBC },
 { 0x1C6B, 0xF12C, 0x1362, 0xF60D }, { 0x2290, 0xED3A, 0x162D, 0xF3F8 },
 { 0x1FC0, 0xEF2C, 0x1E45, 0xE657 }, { 0x0FC0, 0xEBB4, 0x08EA, 0xE7A1 },
 { 0x19C1, 0x02BC, 0xFF1B, 0x0130 }, { 0x2044, 0x021B, 0xFFBE, 0xFB15 },
 { 0x19CD, 0x00B0, 0xFCD2, 0xFF93 }, { 0x1F79, 0x0000, 0xFFFF, 0xFF78 },
 { 0x1CD6, 0xFFDA, 0xFE1C, 0xFB97 }, { 0x20B5, 0xFC5F, 0x02AA, 0xFE3A },
 { 0x1DFA, 0x02B2, 0xFB02, 0x0222 }, { 0x1C9E, 0xFDFB, 0x0196, 0xFAFD },
 { 0x1DBC, 0xF94D, 0xFB71, 0x0497 }, { 0x218E, 0x01B9, 0xFCF2, 0xFD3A },
 { 0x217C, 0xFB4E, 0xFEDD, 0x0104 }, { 0x1C8C, 0xFF6D, 0xF907, 0x019E },
 { 0x1A83, 0xFE9F, 0xFD60, 0x03A6 }, { 0x1439, 0xFF7B, 0x00B3, 0x0052 },
 { 0x1041, 0xFFDE, 0x01BF, 0x05D9 }, { 0x176D, 0xFC7A, 0x05FD, 0xFF87 },
 { 0x165F, 0xFC99, 0xFAA6, 0x03B1 }, { 0x20C2, 0xFF04, 0x0125, 0xFCC9 },
 { 0x19AD, 0xFAB6, 0x02AA, 0x0268 }, { 0x1DE2, 0xF7D0, 0x02D5, 0x01C9 },
 { 0x1FBA, 0x004E, 0x027C, 0xFA88 }, { 0x20E5, 0x01AC, 0xF9AC, 0x0083 },
 { 0x1CAD, 0xFAF4, 0xFD33, 0x00BA }, { 0x1F3E, 0xFFCF, 0xFD30, 0x010A },
 { 0x1763, 0xFEA1, 0x029D, 0x034C }, { 0x1C92, 0xF9AC, 0x00FA, 0xFDA5 },
 { 0x1C33, 0xF9E6, 0xFDC4, 0x07CA }, { 0x21EA, 0xFE9A, 0xFEDE, 0xFE7C },
 { 0x16B2, 0x009B, 0xFF4E, 0x04AF }, { 0x1C4E, 0xFFF4, 0x0412, 0xFCEE },
 { 0x1CBD, 0xFC65, 0x05BC, 0xFE25 }, { 0x1E79, 0x026D, 0xFF2C, 0xFD2C },
 { 0x14E2, 0xFDFE, 0x04BA, 0x054C }, { 0x210B, 0x0024, 0xFF81, 0xFCF5 },
 { 0x1ADE, 0xF683, 0x0356, 0x06D6 }, { 0x1C70, 0xFA87, 0xFAB7, 0x0B1D },
 { 0x1D9B, 0xF79C, 0xFA49, 0x0827 }, { 0x19ED, 0x03B2, 0xFC98, 0x02EE },
 { 0x12C7, 0xFBB4, 0x0509, 0x0A2A }, { 0x118F, 0x00DB, 0x060F, 0x0468 },
 { 0x1DD7, 0x01FA, 0x01BE, 0xFBAD }, { 0x18D7, 0x00BC, 0x03F1, 0xFF8D },
 { 0x19F1, 0xF8E4, 0x0677, 0x02D3 }, { 0x1512, 0xF6B2, 0x0644, 0x09EE },
 { 0x1785, 0xF5AC, 0x095C, 0x057F }, { 0x125A, 0x0372, 0x00F5, 0x05F5 },
 { 0x1FA7, 0x023D, 0xFCE2, 0xFEA3 }, { 0x1F6D, 0xFDF9, 0x03E5, 0xFBBC },
 { 0x1D93, 0xFF86, 0x00E3, 0xFEAE }, { 0x14E3, 0xFB50, 0x0276, 0x06B6 },
 { 0x1B9E, 0x0316, 0x00DA, 0xFDE0 }, { 0x1D10, 0x02D8, 0xFDF1, 0xFFEC },
 { 0x1902, 0xFE9D, 0x00C5, 0xFD20 }, { 0x0FBF, 0x0303, 0x0362, 0x0767 },
 { 0x1779, 0x0380, 0x01BD, 0xFFE1 }, { 0x1428, 0x044A, 0xFCA8, 0x06F8 },
 { 0x1F2C, 0xFC8A, 0xFAF3, 0x0574 }, { 0x18AE, 0xFAAF, 0x0977, 0x00FC },
 { 0x1D7B, 0xFD45, 0x0085, 0x01FA }, { 0x2172, 0xF6D8, 0x03AC, 0x0108 },
 { 0x1702, 0x04A3, 0xFA6F, 0x0892 }, { 0x199E, 0xFD7B, 0xFAE1, 0x0A3D },
 { 0x121A, 0xF979, 0x081B, 0x0657 }, { 0x15EE, 0x0069, 0xFCD0, 0x0948 },
 { 0x19F6, 0x0616, 0xFAAB, 0x0276 }, { 0x1B56, 0x047E, 0xF7BB, 0xFC22 },
 { 0x199B, 0x0907, 0xFBBB, 0xF909 }, { 0x1A1A, 0x0596, 0xF6A9, 0xF86C },
 { 0x1EB5, 0x0613, 0xF45F, 0xFB5C }, { 0x1A59, 0x06BB, 0xFE35, 0xF7DB },
 { 0x1D50, 0x04CD, 0xF97E, 0xF7F4 }, { 0x1F01, 0x029F, 0xF7B0, 0xFA07 },
 { 0x1BE3, 0x03DF, 0xFD21, 0xF5B8 }, { 0x1AD3, 0x0638, 0xFAE9, 0xF6EC },
 { 0x1901, 0x08B6, 0xF93C, 0xF634 }, { 0x1C21, 0x0888, 0xF787, 0xF83C },
 { 0x19EC, 0x088E, 0xFC1D, 0xF4E8 }, { 0x1DC4, 0x0902, 0xF7D7, 0xFD75 },
 { 0x1DA0, 0x0753, 0xFA62, 0xFD89 }, { 0x23FE, 0x0619, 0xF660, 0xFB8D },
 { 0x180A, 0x0526, 0xFB2B, 0xF49B }, { 0x1EED, 0x0B1F, 0xF8FB, 0xF9C1 },
 { 0x2075, 0x07ED, 0xF605, 0xFE2F }, { 0x200C, 0x0502, 0xFDB8, 0xF69B },
 { 0x20F8, 0x040B, 0xFB85, 0xFB8F }, { 0x1BC3, 0x0742, 0xFFC4, 0xF9E0 },
 { 0x1A7D, 0x0B60, 0xFC97, 0xFA49 }, { 0x1DB3, 0x0524, 0xFEC1, 0xFB1F },
 { 0x1E99, 0x0537, 0xFFB2, 0xF8C7 }, { 0x1EFA, 0x0475, 0xFC08, 0xFD49 },
 { 0x1ECB, 0x064A, 0xFC07, 0xFADE }, { 0x1F85, 0x0581, 0xF8ED, 0xFF3C },
 { 0x207F, 0x0407, 0xFDBA, 0xF9CA }, { 0x173C, 0x0601, 0xF797, 0xF6BB },
 { 0x21EC, 0x0493, 0xF8B1, 0xFCAE }, { 0x20A5, 0x09B4, 0xF695, 0xFAF4 },
 { 0x1974, 0x082C, 0xFF3F, 0xFB71 }, { 0x17E0, 0x06A1, 0x0016, 0xFDF3 },
 { 0x1BF9, 0x02BF, 0xFDA6, 0xF8A9 }, { 0x179F, 0x092F, 0xFCD9, 0xFF25 },
 { 0x1F88, 0x073E, 0xF8E7, 0xF9EF }, { 0x1B2C, 0x0518, 0x004C, 0xFC0D },
 { 0x19CF, 0x05C9, 0xFDE0, 0xFF5E }, { 0x1B2E, 0x09ED, 0xFEF7, 0xF86E },
 { 0x1910, 0x09D2, 0xFCF7, 0xFCAE }, { 0x1C68, 0x083E, 0xFC7D, 0xFB6D },
 { 0x1E3D, 0x0869, 0xFEE5, 0xF5CA }, { 0x1952, 0x07F9, 0xF922, 0xFB3B },
 { 0x1A6A, 0x03AC, 0xF8BA, 0xF717 }, { 0x15EA, 0x04AA, 0xF965, 0xF9E7 },
 { 0x1E99, 0x0874, 0xFCC9, 0xF860 }, { 0x1554, 0x059E, 0xFCB0, 0x04A5 },
 { 0x177B, 0x0561, 0xFCFD, 0xF9EB }, { 0x1DFF, 0x0220, 0xFB92, 0xF75A },
 { 0x1C29, 0x050C, 0xF566, 0xF9E4 }, { 0x15BF, 0x04B0, 0xFE6C, 0xFF57 },
 { 0x16DD, 0x05B5, 0xFA47, 0xFDFA }, { 0x1A7E, 0x02B1, 0xFCB4, 0xFCA4 },
 { 0x1CA2, 0x0539, 0xFB80, 0xFFB9 }, { 0x1C15, 0x05E2, 0xFD73, 0xFD53 },
 { 0x1ACC, 0x0844, 0xFA85, 0xFF10 }, { 0x2264, 0x05EC, 0xFA91, 0xF920 },
 { 0x1C2A, 0x0A81, 0xFA26, 0xFC23 }, { 0x1B76, 0x0BCE, 0xFA5F, 0xF7DD },
 { 0x1611, 0x072C, 0xFE69, 0x020D }, { 0x1D1B, 0x0C1B, 0xFD33, 0xF660 },
 { 0x1CD8, 0x0678, 0xF829, 0x018E }, { 0x1968, 0x02C3, 0xF881, 0xFF7A },
 { 0xF8C5, 0x0E37, 0xF719, 0xFD49 }, { 0xF03B, 0x066C, 0xFFB3, 0x0531 },
 { 0xF047, 0x07A8, 0xF9E3, 0xFDC9 }, { 0xF29A, 0x09BF, 0xFCE5, 0x0170 },
 { 0xED5D, 0x09B0, 0x03E1, 0x02F4 }, { 0xF299, 0x080A, 0xF615, 0xFC35 },
 { 0xF126, 0x0D5A, 0x017C, 0x00D9 }, { 0xF3FE, 0x0D16, 0xF98C, 0xFBE0 },
 { 0xF187, 0x0146, 0xF98E, 0x05FF }, { 0xF3CE, 0x0501, 0xFB58, 0x0647 },
 { 0xEE07, 0x0557, 0xFC38, 0x0035 }, { 0xF120, 0x03BE, 0x002C, 0x0A00 },
 { 0xF7E1, 0x09E2, 0xFA33, 0x048E }, { 0xF185, 0x0157, 0xF4B7, 0x00B4 },
 { 0xEB7F, 0x0597, 0xFFE1, 0x02B0 }, { 0xEC82, 0x007D, 0xFD40, 0x04F6 },
 { 0xF52D, 0x0536, 0xF672, 0x02EA }, { 0xF70C, 0x03E2, 0xFA09, 0x0A46 },
 { 0xFB13, 0x0BFE, 0xF629, 0x010C }, { 0xF610, 0x0F32, 0xFBDF, 0xFDD8 },
 { 0xEEBB, 0x00FF, 0xF844, 0x0212 }, { 0xF479, 0x01C6, 0xFFF3, 0x0E3B },
 { 0xF72A, 0x0717, 0xFE8E, 0x0B40 }, { 0xF6B1, 0x0E49, 0xFD77, 0x0240 },
 { 0xF22B, 0xFF5F, 0xFA93, 0x09F6 }, { 0xEF6F, 0x0627, 0x052D, 0x0A01 },
 { 0xF531, 0x0FC5, 0x04C5, 0x062A }, { 0xF15C, 0x0A89, 0x047C, 0x0709 },
 { 0xEDB2, 0x0951, 0xFF24, 0x0000 }, { 0xFA05, 0x066D, 0xF541, 0x052F },
 { 0xFFD3, 0x0FC0, 0xFCE1, 0x08FA }, { 0xF49D, 0x08E8, 0x02C5, 0x09BF },
 { 0xFB51, 0x0CCE, 0xFE6A, 0x092A }, { 0xF659, 0x0074, 0xF56E, 0x080C },
 { 0xF678, 0x087D, 0xF4B2, 0xFEA8 }, { 0xF2D1, 0x08EF, 0x06F5, 0x0C9A },
 { 0xF797, 0x0DF0, 0x0723, 0x0B66 }, { 0xFCA2, 0x08DB, 0xF9A6, 0x09DF },
 { 0xF576, 0x046F, 0x012D, 0x108F }, { 0xF6C4, 0x084B, 0x03F2, 0x0E7E },
 { 0xF671, 0x0CD1, 0xFFAF, 0x0580 }, { 0xF59C, 0x127F, 0x01D8, 0x0102 },
 { 0xFBE3, 0x0C19, 0x0A7A, 0x095E }, { 0xF2DA, 0xFBF3, 0xFB80, 0xFC9C },
 { 0xFD7D, 0x1092, 0x08A4, 0x04EB }, { 0x03CB, 0x0F97, 0x03A6, 0x0283 },
 { 0xF9AF, 0x07D2, 0x085B, 0x0893 }, { 0xECDF, 0x03CC, 0x0310, 0x06B7 },
 { 0xFB05, 0x0BB0, 0x040F, 0x0EED }, { 0xFE78, 0x136D, 0xFF2F, 0x071D },
 { 0xFBFC, 0x126E, 0xFA39, 0xFF77 }, { 0x0032, 0x0F4A, 0x0229, 0x08A2 },
 { 0x02A6, 0x110C, 0x0167, 0x0517 }, { 0xFDBA, 0x132F, 0x0202, 0x0687 },
 { 0x04FC, 0x0F4A, 0xFB1C, 0x0B76 }, { 0xFA28, 0x0F90, 0x0359, 0x091A },
 { 0x0304, 0x1288, 0xFD71, 0x091C }, { 0xFCE1, 0x14A3, 0xFE49, 0x0270 },
 { 0x053D, 0x0B79, 0x028A, 0x07EB }, { 0xF935, 0x131C, 0x04FB, 0x06A6 },
 { 0xFC84, 0x0A24, 0xFF69, 0x0F6F }, { 0xF234, 0x0442, 0x050C, 0x0020 },
 { 0x0141, 0x0C4A, 0x0A57, 0x05C3 }, { 0x0108, 0x1067, 0xF9C9, 0x0525 },
 { 0xFE3C, 0xF6CB, 0x08DA, 0x1060 }, { 0x0BCE, 0xFBF7, 0xF6AB, 0x162E },
 { 0xFB76, 0xFAC2, 0x0DD7, 0x137E }, { 0xFE26, 0xFA3B, 0xFB39, 0x1398 },
 { 0xFD45, 0xF4D7, 0x0384, 0x0EFB }, { 0xFE33, 0xF731, 0xFF8B, 0x1212 },
 { 0x04B4, 0xF7F2, 0xFB45, 0x1133 }, { 0x0890, 0xF425, 0xFEAF, 0x0F7E },
 { 0x006C, 0xFCC1, 0x0117, 0x160B }, { 0x05B1, 0xFD94, 0xF4A4, 0x149C },
 { 0xF621, 0xFFB2, 0x043D, 0x1554 }, { 0xF846, 0xF882, 0xFC4B, 0x127D },
 { 0x0020, 0x016F, 0xF890, 0x142E }, { 0x0762, 0xF97F, 0x01B8, 0x1290 },
 { 0xFDFA, 0xFEA4, 0x0B00, 0x131B }, { 0x0E6F, 0xF646, 0xFAA2, 0x11FB },
 { 0x00F6, 0xF853, 0x0DDD, 0x0F81 }, { 0x044C, 0xF3D9, 0x0290, 0x0E99 },
 { 0xFA9D, 0x0366, 0xFE62, 0x11DF }, { 0x0274, 0xFE9B, 0xFB35, 0x1823 },
 { 0xFB97, 0xFADA, 0xF667, 0x11E0 }, { 0xFE57, 0xFF9E, 0xFFB7, 0x18C0 },
 { 0x016F, 0xFC89, 0x0BAE, 0x106F }, { 0x082B, 0xFB1D, 0x098C, 0x0DE5 },
 { 0xF921, 0xF9B6, 0x07FE, 0x1499 }, { 0x0C8A, 0x0586, 0xFFEC, 0x0A38 },
 { 0x0CE7, 0xF5B4, 0x03ED, 0x108D }, { 0xFEB9, 0xF3DD, 0xFD80, 0x0E67 },
 { 0xFF3B, 0x02FC, 0x023C, 0x156E }, { 0x0286, 0xFD01, 0x056C, 0x1558 },
 { 0x0068, 0x0AB6, 0xFF1C, 0x0F43 }, { 0xFF14, 0x0725, 0xFDBD, 0x11E9 },
 { 0xF79A, 0xFE26, 0xFA0B, 0x0FA6 }, { 0xFFE9, 0xF5B8, 0xF6A0, 0x0F34 },
 { 0xFFF4, 0xF935, 0xF4A2, 0x1303 }, { 0xF6FA, 0xFE90, 0xFF9A, 0x11E7 },
 { 0xF839, 0xF7F3, 0x0215, 0x11B3 }, { 0x0F2C, 0xFA5A, 0xFF67, 0x1129 },
 { 0x0620, 0x000E, 0xFEDF, 0x1494 }, { 0xFAA0, 0xFF03, 0xF513, 0x0D59 },
 { 0x0C79, 0xF5EF, 0x09AB, 0x0DEE }, { 0x0D5A, 0x0269, 0x0546, 0x0741 },
 { 0x0ED0, 0xFFE8, 0xFEF0, 0x0D2A }, { 0x0099, 0x0487, 0x0B5A, 0x0B3D },
 { 0x01FF, 0x0872, 0x060C, 0x0AB5 }, { 0x0106, 0x0333, 0xF519, 0x0E96 },
 { 0x1088, 0xF821, 0x05CE, 0x0D95 }, { 0x0B7F, 0xFBAA, 0xFC0A, 0x1568 },
 { 0x0B1A, 0x0171, 0x02BF, 0x0D94 }, { 0x0BC3, 0x0662, 0xFC5B, 0x0DE1 },
 { 0x113C, 0xF9F4, 0xFC52, 0x139D }, { 0xFA83, 0x0251, 0x0944, 0x1493 },
 { 0x082D, 0x0851, 0x0380, 0x093D }, { 0x12ED, 0xF844, 0x0000, 0x0EEF },
 { 0xF7A4, 0x0051, 0x0CCE, 0x1605 }, { 0x05CC, 0x0A69, 0xFEBC, 0x0E45 },
 { 0x000A, 0x00C0, 0x0654, 0x14AB }, { 0x0868, 0x02E2, 0xF723, 0x1388 },
 { 0x0836, 0x0ABC, 0xF98C, 0x1263 }, { 0x0B27, 0xF7AD, 0xFE7D, 0x1444 },
 { 0x0495, 0x02A4, 0x053A, 0x0CCD }, { 0x0924, 0xF6E7, 0xF7F0, 0x0FFF },
 { 0x035D, 0xF818, 0x0510, 0x13BF }, { 0x088D, 0x0C99, 0xFD49, 0x0A42 },
 { 0x1834, 0xE459, 0x0797, 0xFCCA }, { 0x11C3, 0xED33, 0x0CBD, 0x0740 },
 { 0x1093, 0xE508, 0x0D73, 0x01C0 }, { 0x11E5, 0xE2B1, 0x03B2, 0x01FA },
 { 0x19E2, 0xE1B6, 0x0D63, 0x01D6 }, { 0x0D4F, 0xDC80, 0x0CC5, 0xFA28 },
 { 0x0FEF, 0xE6C0, 0x0900, 0x0309 }, { 0x15F5, 0xDB88, 0x0A7C, 0xFD00 },
 { 0x14E7, 0xE6C0, 0x1476, 0xFF2A }, { 0x1749, 0xE0B9, 0x06BC, 0xF3ED },
 { 0x1075, 0xE07D, 0x025B, 0xFF0A }, { 0x1C28, 0xE315, 0x0C60, 0xF936 },
 { 0x17D2, 0xE1EC, 0x0149, 0xFA9D }, { 0x197D, 0xE5B1, 0x1098, 0xFBD0 },
 { 0x17B9, 0xE79F, 0x0877, 0xF6B6 }, { 0x1201, 0xDBFE, 0x0BEB, 0xFBF7 },
 { 0x1A9D, 0xE38D, 0x062D, 0xF897 }, { 0x17EE, 0xE77D, 0x0AE5, 0x02A9 },
 { 0x1147, 0xE676, 0x0655, 0xF964 }, { 0x1880, 0xDF96, 0x0C5F, 0xF8C1 },
 { 0x181C, 0xDE92, 0x1192, 0xFB6F }, { 0x12EC, 0xDE74, 0x066F, 0xFE92 },
 { 0x1841, 0xDD99, 0x062D, 0xFE8F }, { 0x150D, 0xE085, 0x0226, 0xFF40 },
 { 0x19FE, 0xD9D1, 0x09C8, 0xFBD9 }, { 0x1BBF, 0xE0C2, 0x0326, 0x0212 },
 { 0x161E, 0xE5B0, 0x061D, 0xF1DC }, { 0x1045, 0xDAA4, 0x105F, 0xF7AD },
 { 0x11AE, 0xE3F3, 0x0240, 0xF4C5 }, { 0x1219, 0xDE51, 0x0AF7, 0xED7A },
 { 0x0E7D, 0xE18E, 0x0717, 0x0022 }, { 0x0E32, 0xDE52, 0x0909, 0xFCC6 },
 { 0x1B4F, 0xDF01, 0x080F, 0xF382 }, { 0x1E4D, 0xDAF2, 0x08CF, 0xFDD2 },
 { 0x1035, 0xE19E, 0x1278, 0xF960 }, { 0x1687, 0xE2FD, 0x0459, 0x02C3 },
 { 0x11F0, 0xE78B, 0x0919, 0x0748 }, { 0x0C57, 0xD6FE, 0x068D, 0xEF4F },
 { 0x0DCE, 0xDCCE, 0x0985, 0xF213 }, { 0x117F, 0xD5BB, 0x0A9B, 0xECB2 },
 { 0x0C87, 0xD9B3, 0x0BEE, 0xF0D2 }, { 0x1213, 0xE003, 0x0BCA, 0xF6CE },
 { 0x1597, 0xD6BA, 0x0CAC, 0xF543 }, { 0x10FA, 0xD871, 0x0D07, 0xF3F4 },
 { 0x17F4, 0xD89B, 0x0CF4, 0xFAE4 }, { 0x15FD, 0xDA18, 0x0882, 0xF40E },
 { 0x0E13, 0xDEA6, 0x04DE, 0xFD90 }, { 0x0E99, 0xDED8, 0x018B, 0xF3A1 },
 { 0x1559, 0xD36A, 0x0AFA, 0xEDE0 }, { 0x14BA, 0xE1BF, 0x0AA1, 0xF06C },
 { 0x1B58, 0xDC69, 0x069F, 0xFA7F }, { 0x1A07, 0xE1C3, 0x09A2, 0xF011 },
 { 0x0FF3, 0xE3F9, 0x072C, 0xED21 }, { 0x0E1D, 0xD93A, 0x053E, 0xF281 },
 { 0x19BC, 0xE09F, 0x01C9, 0xFEFE }, { 0x1270, 0xE05A, 0x0011, 0xFB47 },
 { 0x1CF6, 0xDDFB, 0x050E, 0xFEA8 }, { 0x153D, 0xD8D2, 0x0FCB, 0xF958 },
 { 0x12FE, 0xDBBF, 0x0616, 0xFA69 }, { 0x1A90, 0xE6FD, 0x13F9, 0x035E },
 { 0x120F, 0xDFCE, 0x0A6B, 0xFF1C }, { 0x171F, 0xEC25, 0x0D14, 0x0857 },
 { 0x1761, 0xDD47, 0x0AAD, 0xEC0F }, { 0x13A5, 0xE979, 0x1137, 0x02CF },
 { 0x0162, 0xE7F2, 0xFCBA, 0xF447 }, { 0x015F, 0xE8C9, 0xF7C8, 0xFA02 },
 { 0xFD87, 0xE3EA, 0xFFE7, 0xED42 }, { 0xF9C5, 0xE3BD, 0xF11C, 0xFA88 },
 { 0x0067, 0xE7CB, 0xF48B, 0xFFB2 }, { 0xF946, 0xEC64, 0xF28F, 0xEF13 },
 { 0xF855, 0xE9F4, 0xEEF3, 0xFEF2 }, { 0xFCB2, 0xE991, 0xF26B, 0x00C4 },
 { 0xFF41, 0xEB1C, 0xF02A, 0xFE2B }, { 0xF62D, 0xE1B6, 0xF259, 0xFCCE },
 { 0xF7D6, 0xE5CA, 0xF573, 0x0075 }, { 0xFDDE, 0xE484, 0xFA8A, 0x00A3 },
 { 0xFEEA, 0xE44D, 0xF59A, 0xFDE8 }, { 0xFD92, 0xE0E6, 0xF555, 0xFA48 },
 { 0xF9ED, 0xE04A, 0xF1E4, 0xF7F7 }, { 0xFBBA, 0xE778, 0xF6F6, 0x01F9 },
 { 0xF604, 0xDEA6, 0xF048, 0xF739 }, { 0x006D, 0xE422, 0xF3DD, 0xF8E1 },
 { 0xFC7C, 0xE4D6, 0xF2F4, 0xFD33 }, { 0xFDA3, 0xE437, 0xF1B8, 0xF796 },
 { 0x0345, 0xE789, 0xF375, 0xF77F }, { 0xFE5F, 0xE94E, 0xF0E1, 0xFA43 },
 { 0xFADA, 0xE9EF, 0xEF91, 0xF382 }, { 0x019D, 0xE593, 0xF7DE, 0xFFDF },
 { 0xF3E3, 0xE6CE, 0xEEF6, 0xFD02 }, { 0x02F3, 0xE6A7, 0xF469, 0xFCB2 },
 { 0x045D, 0xE43E, 0xF66C, 0xFAB8 }, { 0xFB4E, 0xDF3D, 0xF400, 0xF4AF },
 { 0xFE93, 0xECE2, 0xF217, 0xF487 }, { 0xF6BC, 0xDDB8, 0xFEF7, 0xEEA7 },
 { 0xFB38, 0xDE1A, 0xFC80, 0xEC2E }, { 0xFD0D, 0xD890, 0xFDA8, 0xE621 },
 { 0x012C, 0xDFF2, 0xFF1F, 0xEE28 }, { 0xFB68, 0xE558, 0xF5B7, 0xF239 },
 { 0xF82A, 0xEABD, 0xFA0A, 0xE927 }, { 0xFBA5, 0xEA5C, 0xF6C5, 0xED4F },
 { 0x0423, 0xE564, 0xF611, 0xF5A2 }, { 0xF848, 0xE533, 0xF40A, 0xEA7C },
 { 0xFE85, 0xEB30, 0xF6EF, 0xF1D8 }, { 0xF7C4, 0xE91C, 0xEE5A, 0xF885 },
 { 0xFE85, 0xE133, 0xFACF, 0xFDAE }, { 0x0306, 0xEAF3, 0xFDBB, 0xEBA3 },
 { 0xF5D7, 0xEC25, 0xF8C7, 0xECC7 }, { 0xFF50, 0xEA34, 0x004A, 0xEC2D },
 { 0xFF34, 0xE584, 0xFF42, 0xE7A8 }, { 0x01A2, 0xE256, 0xF83D, 0xFCCC },
 { 0xF8AF, 0xDEAF, 0xF492, 0xF9B7 }, { 0x053C, 0xE726, 0xFC69, 0xEC91 },
 { 0x0241, 0xE0CA, 0xF804, 0xF8AF }, { 0xF5F4, 0xE30B, 0xF92F, 0xF750 },
 { 0xF80B, 0xE48A, 0xFA4B, 0xE41E }, { 0xF601, 0xDDCC, 0xF809, 0xE934 },
 { 0xF7E1, 0xE594, 0xFB47, 0xE9DB }, { 0xF9B3, 0xE187, 0xF82A, 0xFD53 },
 { 0xF8B7, 0xE649, 0xFD2E, 0xF237 }, { 0xFDB3, 0xE72A, 0xFA9F, 0xFC15 },
 { 0xFDE4, 0xE2A6, 0xFACD, 0xF22A }, { 0x01A3, 0xE7D0, 0xF973, 0xECC1 },
 { 0xF51E, 0xDDC5, 0xF46A, 0xEC37 }, { 0xF784, 0xDF25, 0xF942, 0xEDBD },
 { 0xF2CA, 0xD997, 0xF257, 0xE9A6 }, { 0xF67F, 0xD847, 0xF7E3, 0xE971 },
 { 0xFE58, 0xDB15, 0xFBB8, 0xF1B6 }, { 0xFDE7, 0xDEB6, 0xFC72, 0xF897 },
 { 0xEA52, 0x0AF7, 0x0693, 0xFD4B }, { 0xE705, 0x027B, 0x0DF5, 0xFB22 },
 { 0xE288, 0x08E8, 0x085C, 0x002C }, { 0xDDD1, 0x0470, 0x0B87, 0xFCE6 },
 { 0xEA1B, 0x0A95, 0x0804, 0x0394 }, { 0xE21E, 0x028E, 0x0365, 0x0087 },
 { 0xE4E5, 0x03C7, 0x0581, 0x0366 }, { 0xE166, 0x084B, 0x0CEE, 0x03CE },
 { 0xE4E9, 0x0B02, 0x04FA, 0xF972 }, { 0xEA1B, 0x08B9, 0x03F5, 0x01D7 },
 { 0xE449, 0x0739, 0x0670, 0x00C6 }, { 0xE614, 0x0662, 0x02C8, 0xFFDB },
 { 0xE391, 0x03D2, 0x0128, 0xFEC5 }, { 0xE210, 0x0DB0, 0x0CDC, 0xFF28 },
 { 0xE164, 0x04B9, 0x04C5, 0xFEFF }, { 0xE117, 0x0899, 0x06E5, 0xFA07 },
 { 0xE45B, 0x0EC7, 0x0A48, 0xFA81 }, { 0xEA43, 0x066D, 0x0582, 0xFD92 },
 { 0xE6A2, 0x0B3F, 0x049D, 0xFD09 }, { 0xE45F, 0x0C41, 0x0BC2, 0x0226 },
 { 0xE3AF, 0x072F, 0x034F, 0xFCDB }, { 0xE61A, 0x0895, 0x011A, 0xFBB8 },
 { 0xDD7C, 0x0625, 0x07C4, 0xFBBE }, { 0xE17F, 0x04FA, 0x0344, 0xFB52 },
 { 0xE129, 0x0B9A, 0x0DB7, 0xFBB7 }, { 0xE4D0, 0x0680, 0x054C, 0xF676 },
 { 0xE64A, 0x0B32, 0x08E1, 0x0133 }, { 0xE3CB, 0x0335, 0x0B23, 0xFA65 },
 { 0xE881, 0x06A7, 0x07D1, 0xF6C1 }, { 0xE06E, 0x040A, 0x0837, 0x00EF },
 { 0xE8C0, 0x0778, 0x012D, 0xFE2F }, { 0xE82D, 0x0349, 0x017B, 0x0237 },
 { 0xE739, 0x0032, 0x01EE, 0x0292 }, { 0xE646, 0x03D7, 0x024F, 0xFC83 },
 { 0xEA84, 0x0365, 0x088B, 0xF651 }, { 0xE6AE, 0x003C, 0x0609, 0xFC2D },
 { 0xE5CF, 0x0203, 0x07B6, 0xFFCB }, { 0xE6C4, 0x06DB, 0x052D, 0xFB05 },
 { 0xE833, 0x0A39, 0x09A1, 0xFD91 }, { 0xE35E, 0x0871, 0x0252, 0xF7BD },
 { 0xE364, 0x02FA, 0x0639, 0xF82C }, { 0xE70F, 0x02A7, 0x05E6, 0xF62E },
 { 0xE7F1, 0x00F1, 0x0BA0, 0xF9A1 }, { 0xDE79, 0x0BD6, 0x0FCD, 0xFF5E },
 { 0xE765, 0x0042, 0x08A1, 0xF7C9 }, { 0xEACC, 0x04FF, 0x0CC3, 0xF8CA },
 { 0xE6DA, 0x0537, 0x0AA8, 0xF9A1 }, { 0xE0B4, 0x042E, 0x097C, 0xFB81 },
 { 0xE7C7, 0x0ADD, 0x092D, 0xF882 }, { 0xE8E2, 0x0473, 0x0C31, 0xFF6C },
 { 0xE756, 0x09B1, 0x0C41, 0xF8F0 }, { 0xE3F4, 0x06BA, 0x0983, 0xF9BE },
 { 0xE5A2, 0x0725, 0x0EB3, 0xFB87 }, { 0xE5C7, 0x06F1, 0x08AD, 0x04BC },
 { 0xE2C9, 0x072B, 0x0E2B, 0xFE21 }, { 0xE37D, 0x000A, 0x0966, 0xF9C7 },
 { 0xDFC7, 0x0C39, 0x03E4, 0xF4CA }, { 0xDF4A, 0x05FE, 0x0535, 0xF8A6 },
 { 0xE2AD, 0x0D19, 0x063E, 0xF705 }, { 0xE32D, 0x0A8D, 0x0916, 0xFB71 },
 { 0xDF08, 0x08E4, 0x0AEC, 0xFDE2 }, { 0xD794, 0x05F7, 0x0A59, 0xFB73 },
 { 0xE008, 0x0E1E, 0x0A0E, 0xF936 }, { 0xEA5D, 0x0626, 0x06C5, 0x0472 },
 { 0x24BC, 0xE21C, 0x0043, 0x004F }, { 0x21CE, 0xF07C, 0x054E, 0xFFC4 },
 { 0x21A9, 0xED46, 0x0075, 0x090E }, { 0x1ECE, 0xEE67, 0x06F8, 0x04B0 },
 { 0x21BC, 0xE813, 0x0F27, 0xFC15 }, { 0x25B6, 0xE54C, 0x0718, 0x00CD },
 { 0x249E, 0xE667, 0x0391, 0x0753 }, { 0x1F54, 0xE7FA, 0x046E, 0x0956 },
 { 0x1E6A, 0xEC96, 0x081E, 0xF8BF }, { 0x21F3, 0xE819, 0x02C7, 0x02C4 },
 { 0x234F, 0xEA40, 0x0B80, 0xF892 }, { 0x26E3, 0xEC48, 0x0599, 0xFDA7 },
 { 0x1F99, 0xE4F1, 0x0C15, 0xF4E2 }, { 0x2127, 0xE490, 0x096F, 0x0013 },
 { 0x24AC, 0xEB59, 0x0DF9, 0xF5A1 }, { 0x218F, 0xE335, 0x08FC, 0xFC1C },
 { 0x2390, 0xED65, 0x05AD, 0xF602 }, { 0x1DBF, 0xEAAF, 0x0254, 0x00A4 },
 { 0x2684, 0xE479, 0x0D69, 0xFD9A }, { 0x2234, 0xEECC, 0x08BB, 0xFC3C },
 { 0x24F6, 0xEDCC, 0x012B, 0xF8E2 }, { 0x2787, 0xEA52, 0x0A81, 0xFB07 },
 { 0x2AA3, 0xE2D1, 0x0A91, 0xFC11 }, { 0x2CA9, 0xE44E, 0x0582, 0xFB52 },
 { 0x269A, 0xE2F9, 0x0B95, 0xF899 }, { 0x1DCC, 0xEB9D, 0x0301, 0xF59B },
 { 0x1FE9, 0xEB3A, 0x08D6, 0x0046 }, { 0x228E, 0xE750, 0x0793, 0xFD0E },
 { 0x1BEB, 0xEA27, 0x04E0, 0xFC35 }, { 0x299C, 0xEA93, 0x03A7, 0x0089 },
 { 0x1E62, 0xE67B, 0x0A04, 0xF874 }, { 0x22AE, 0xEBCB, 0x04BE, 0xFE97 },
 { 0x2664, 0xECB1, 0x011A, 0x01FE }, { 0x273A, 0xE80A, 0x0F37, 0xF886 },
 { 0x1F1D, 0xE61A, 0x0DEE, 0xFE4F }, { 0x217D, 0xEE6A, 0x0DF6, 0xFB47 },
 { 0x20CE, 0xED3F, 0x0407, 0xFABD }, { 0x2798, 0xE1A4, 0x0A34, 0x060B },
 { 0x26A2, 0xE390, 0x06E8, 0xFBC5 }, { 0x20D7, 0xE647, 0xFD3E, 0xFFC6 },
 { 0x1F28, 0xE262, 0x00E5, 0xFF7D }, { 0x28F1, 0xDD5E, 0x048E, 0xFF6D },
 { 0x2AA2, 0xEF0A, 0x0C75, 0xF694 }, { 0x28C8, 0xEBB2, 0xFF98, 0xFBAB },
 { 0x2BDB, 0xE67E, 0x094D, 0xF66F }, { 0x2127, 0xE080, 0x043E, 0x00E6 },
 { 0x26F7, 0xE815, 0xFCA7, 0xFF7A }, { 0x2093, 0xE69E, 0x04D0, 0xF6DF },
 { 0x2B22, 0xEE66, 0x045F, 0xF7CE }, { 0x3113, 0xEA28, 0x072D, 0xF7F2 },
 { 0x2E19, 0xEA2A, 0x0278, 0xFAF0 }, { 0x27A8, 0xEA0F, 0x05E7, 0xF883 },
 { 0x1E78, 0xE6B7, 0x0033, 0xFAC7 }, { 0x1F05, 0xEA48, 0x0986, 0xF33A },
 { 0x199A, 0xF106, 0x0834, 0x05C4 }, { 0x2369, 0xEA70, 0xFF1E, 0xFBA0 },
 { 0x2A2A, 0xE430, 0xFF0D, 0x007A }, { 0x28BD, 0xE4C8, 0x0110, 0xFCDA },
 { 0x22EE, 0xDD2E, 0x05A2, 0xFE78 }, { 0x26F1, 0xEC45, 0x07F1, 0xF477 },
 { 0x1C6B, 0xEFC8, 0x0BF2, 0xFFC0 }, { 0x2B77, 0xEA90, 0x11ED, 0xF365 },
 { 0x259A, 0xE5F6, 0x0AB3, 0xF472 }, { 0x1B1F, 0xEB0E, 0x1176, 0x03F0 },
 { 0xE2E0, 0xFC39, 0x0B78, 0xFC16 }, { 0xDE52, 0xFEB3, 0x1B32, 0x0A2E },
 { 0xE2C2, 0xF2C0, 0x0E54, 0x0507 }, { 0xE08B, 0xFCC5, 0x141C, 0x0449 },
 { 0xE62E, 0x01C6, 0x1358, 0x0060 }, { 0xE1EB, 0xF842, 0x0C59, 0xFE2C },
 { 0xE375, 0xFB94, 0x0FE7, 0xFFDC }, { 0xE043, 0xFEF1, 0x144F, 0x0F16 },
 { 0xDC22, 0xF862, 0x0AFD, 0x0756 }, { 0xD981, 0xFC48, 0x12BA, 0x0BC2 },
 { 0xE3B7, 0x0597, 0x106A, 0x09A4 }, { 0xDA52, 0x009D, 0x129E, 0x0416 },
 { 0xDB65, 0x04CE, 0x1779, 0x0B8E }, { 0xD306, 0xFFC0, 0x21B6, 0x1480 },
 { 0xE592, 0x0235, 0x0ACE, 0x085C }, { 0xDF16, 0xFFF7, 0x0B24, 0x04F7 },
 { 0xD3E5, 0xFBA7, 0x13DF, 0x0B79 }, { 0xDF97, 0x082C, 0x118F, 0x04F0 },
 { 0xD901, 0x02DF, 0x0EE1, 0xFFCD }, { 0xDCA8, 0xFC18, 0x0C77, 0xFECC },
 { 0xE35D, 0xF83D, 0x0A5F, 0x056F }, { 0xE418, 0xFFEB, 0x10ED, 0x0871 },
 { 0xE870, 0xF9FC, 0x0DD7, 0x0380 }, { 0xE0CD, 0xFBF4, 0x07C1, 0x05F9 },
 { 0xDBD0, 0x07D4, 0x144A, 0x0122 }, { 0xD3D4, 0xFCB8, 0x167A, 0x0676 },
 { 0xDC56, 0xF6A2, 0x10C4, 0x0B9D }, { 0xE798, 0x0346, 0x0DEB, 0x04C7 },
 { 0xE55D, 0xF538, 0x0DB7, 0x0077 }, { 0xE3D3, 0xF82A, 0x110C, 0x02FA },
 { 0xEAC9, 0xFBE9, 0x11B5, 0x00A6 }, { 0xE446, 0xFD7F, 0x07E5, 0x027F },
 { 0xDE4C, 0xF737, 0x0E04, 0x018F }, { 0xE730, 0xFA26, 0x0DE8, 0xFD78 },
 { 0xE487, 0xF772, 0x1306, 0x0A02 }, { 0xE313, 0xFFD2, 0x0EBC, 0xFDBB },
 { 0xE828, 0x031C, 0x1417, 0x07AD }, { 0xE965, 0x03AF, 0x1698, 0x0BD6 },
 { 0xDF51, 0x05B9, 0x1C18, 0x1001 }, { 0xDFBD, 0x0315, 0x163E, 0x07AB },
 { 0xD68A, 0xF895, 0x1674, 0x0A55 }, { 0xDFBE, 0xFCDB, 0x0E72, 0x08E3 },
 { 0xE523, 0xFC34, 0x191F, 0x0C58 }, { 0xE6AD, 0x016B, 0x1B6A, 0x0C39 },
 { 0xE775, 0xFAB2, 0x1447, 0x05F4 }, { 0xDD6B, 0xF3AB, 0x1017, 0x06CD },
 { 0xE83A, 0xFEF5, 0x0F2B, 0xFCBD }, { 0xE3AA, 0x0408, 0x19D5, 0x0FB1 },
 { 0xD332, 0xF2EA, 0x1229, 0x0D62 }, { 0xE5A9, 0x01E1, 0x1804, 0x04D7 },
 { 0xEAEE, 0xFF5A, 0x14BD, 0x0C5D }, { 0xE0EA, 0x042C, 0x10AC, 0xFF10 },
 { 0xD6E8, 0x08D0, 0x1EEC, 0x0B0C }, { 0xEBF4, 0xFFFC, 0x166B, 0x0498 },
 { 0xDE3D, 0x0078, 0x0CB7, 0xFD8B }, { 0xDA61, 0x07B6, 0x22A6, 0x110A },
 { 0xD659, 0xFB3B, 0x0E95, 0x024D }, { 0xDFE0, 0xF8CD, 0x16AE, 0x0A5F },
 { 0xDFA6, 0x04E7, 0x21C7, 0x0D96 }, { 0xCFE9, 0xFA1F, 0x2353, 0x1870 },
 { 0xD3D0, 0xFCA8, 0x1BE0, 0x1249 }, { 0xD158, 0xFD2E, 0x1F05, 0x0CED },
 { 0xE144, 0xFE31, 0x1ABE, 0x1064 }, { 0xDE19, 0xFF0F, 0x1CF2, 0x14E3 },
 { 0x1A67, 0xEDB8, 0xFE04, 0x04C4 }, { 0x1438, 0xE821, 0x03B0, 0x0079 },
 { 0x1ABB, 0xE9DD, 0xFAA8, 0xFDEB }, { 0x15F0, 0xE904, 0xFA41, 0xFD49 },
 { 0x178E, 0xEC1F, 0xF8F0, 0xFC54 }, { 0x1D14, 0xEAA9, 0xFFCC, 0x0759 },
 { 0x106F, 0xE841, 0xFE06, 0x0623 }, { 0x1A81, 0xEEC6, 0xFD77, 0x0C0C },
 { 0x12E6, 0xEBA2, 0x07EA, 0x0BB6 }, { 0x1069, 0xE962, 0x0285, 0x0713 },
 { 0x1B12, 0xEBF7, 0xF86C, 0x06A2 }, { 0x18BC, 0xEDED, 0x02B4, 0x0BD3 },
 { 0x188D, 0xEF26, 0xFF96, 0x0E3C }, { 0x186F, 0xEAB6, 0xF849, 0x02E6 },
 { 0x1067, 0xEDBC, 0xFE35, 0x0704 }, { 0x15D8, 0xEA84, 0x0541, 0x0514 },
 { 0x1106, 0xEA4C, 0xF744, 0x0072 }, { 0x120C, 0xE90D, 0xF9E5, 0x0378 },
 { 0x131C, 0xE282, 0xFEB9, 0xFE5D }, { 0x127E, 0xE453, 0x0007, 0x0265 },
 { 0x0F2B, 0xEA46, 0xF84F, 0x0438 }, { 0x15EA, 0xEC82, 0xFF34, 0x0342 },
 { 0x1015, 0xE6AE, 0xFB09, 0x0155 }, { 0x19B9, 0xEC0D, 0x037C, 0x0491 },
 { 0x19E8, 0xF19D, 0x012E, 0x0BBA }, { 0x18B6, 0xEB19, 0xFC29, 0xFB1E },
 { 0x111E, 0xE3E8, 0xFD26, 0xFF62 }, { 0x146B, 0xE674, 0xFE3D, 0x0463 },
 { 0x155C, 0xE6B8, 0xFC9A, 0xFA41 }, { 0x1447, 0xE6FE, 0xFAAB, 0xFF81 },
 { 0x1CEF, 0xE753, 0xFC33, 0xFEB0 }, { 0x1203, 0xE67E, 0xFCCC, 0xF844 },
 { 0x1363, 0xEBD9, 0xF7FE, 0xFC3A }, { 0x113E, 0xE9C5, 0xFF2D, 0xFC1A },
 { 0x1742, 0xE90F, 0x02EE, 0xF92B }, { 0x112A, 0xED44, 0xFB0C, 0x00FE },
 { 0x1BF9, 0xE7BA, 0xFC0E, 0x02B1 }, { 0x1365, 0xF1F2, 0x0944, 0x06AF },
 { 0x1868, 0xE7DC, 0x03D5, 0x0360 }, { 0x1949, 0xEB28, 0x020D, 0xFDA8 },
 { 0x11EF, 0xE530, 0xFB95, 0xFC7C }, { 0x18AA, 0xE6D8, 0xFC03, 0xFE89 },
 { 0x16CE, 0xE7BF, 0xFB51, 0x03B0 }, { 0x14BC, 0xEB5D, 0xF7CC, 0x04F3 },
 { 0x10F6, 0xE91C, 0xF99B, 0xFAB4 }, { 0x1630, 0xEEDC, 0xFB35, 0xFF98 },
 { 0x1324, 0xEFFE, 0x05A9, 0x0FCE }, { 0x1245, 0xEF44, 0xFF96, 0x0C76 },
 { 0x1D96, 0xE7E3, 0xFCB0, 0x0743 }, { 0x195D, 0xE3D9, 0xFF7D, 0x02D6 },
 { 0x1589, 0xEB73, 0xF7BB, 0x0004 }, { 0x182F, 0xE348, 0xFF3F, 0xFE07 },
 { 0x16FD, 0xEF13, 0x0144, 0xFF7A }, { 0x1812, 0xE83F, 0xFEC8, 0xF804 },
 { 0x1078, 0xE7C8, 0xF8EE, 0xFDC4 }, { 0x1614, 0xE485, 0xFD48, 0xFF3B },
 { 0x1BDB, 0xE3EB, 0xFE92, 0xFFC4 }, { 0x13A8, 0xED3D, 0xFA16, 0x0B10 },
 { 0x1CDA, 0xEDFE, 0xFDA2, 0x0DA1 }, { 0x1073, 0xEC59, 0x04C5, 0x0BE7 },
 { 0x0FD2, 0xEDD3, 0x0630, 0x05BD }, { 0x1AC4, 0xEB4A, 0xF8BB, 0x00CE },
 { 0x1E38, 0xED30, 0xF8FE, 0x0D1F }, { 0x1892, 0xF291, 0x05F2, 0x0996 },
 { 0x06E8, 0x1766, 0xEA48, 0xF5DE }, { 0x0F3F, 0x14CE, 0xFA06, 0xFA23 },
 { 0x09A8, 0x0E9A, 0xF7BB, 0xEF70 }, { 0x0CBC, 0x1548, 0xFC78, 0xED83 },
 { 0x059B, 0x1C81, 0xF1A4, 0xEFFA }, { 0x1000, 0x173F, 0xFD70, 0xF310 },
 { 0x0882, 0x1779, 0xF3B6, 0xF174 }, { 0x0ECB, 0x1575, 0xEA9F, 0xF99F },
 { 0x0BB6, 0x1C76, 0xF2FA, 0xF20D }, { 0x0B4E, 0x19B0, 0xED9C, 0xF50C },
 { 0x033E, 0x1813, 0xEF42, 0xF2EC }, { 0x1293, 0x15C1, 0xF93E, 0xF54D },
 { 0x11FC, 0x17B1, 0xF216, 0xF5D3 }, { 0x0ABD, 0x1415, 0xF06E, 0xF529 },
 { 0x0F66, 0x130B, 0xF7A1, 0xF2F4 }, { 0x0B03, 0x2145, 0xF82C, 0xF55C },
 { 0x0862, 0x189A, 0xFD4F, 0xF3EB }, { 0x144C, 0x1968, 0xF2BF, 0xFA3D },
 { 0x073B, 0x20C2, 0xF92C, 0xFA74 }, { 0x0D92, 0x217C, 0xF232, 0xF580 },
 { 0x1197, 0x1D88, 0xF217, 0xF73B }, { 0x1151, 0x184B, 0xF6A7, 0xF9D9 },
 { 0x0DB2, 0x1C50, 0xF71D, 0xF847 }, { 0x0DA2, 0x1CF1, 0xF3B5, 0xFDA4 },
 { 0x1076, 0x192F, 0xF240, 0x0204 }, { 0x026B, 0x1B7A, 0xFCC3, 0xF957 },
 { 0x06C4, 0x1CE3, 0xFE9C, 0xF760 }, { 0x04CA, 0x1454, 0xF322, 0xF16C },
 { 0x07EB, 0x15F3, 0xF8EB, 0xEFCE }, { 0x0C06, 0x16F5, 0x002F, 0xF5A5 },
 { 0x0676, 0x1552, 0x01A8, 0xFD56 }, { 0x0C5B, 0x1558, 0xF816, 0xFEF2 },
 { 0x0B44, 0x14FF, 0xFD53, 0xFDEE }, { 0x0B86, 0x1C76, 0xFFDD, 0xF469 },
 { 0x07C2, 0x13CA, 0xFDAB, 0x01E2 }, { 0x0D83, 0x10D4, 0xF0FB, 0xF6E3 },
 { 0x0C53, 0x1B7D, 0xFABE, 0xEF07 }, { 0x0891, 0x1A28, 0xFD33, 0xFAD9 },
 { 0x0E5D, 0x13E1, 0xF0CC, 0xFE19 }, { 0x088A, 0x1410, 0xEFA6, 0xFA2C },
 { 0x0305, 0x16A4, 0xFC6B, 0x0331 }, { 0x09B9, 0x1992, 0xF20E, 0xF7BB },
 { 0x04C7, 0x1945, 0xFAAE, 0xFFDF }, { 0x010F, 0x17AD, 0xFA46, 0xF943 },
 { 0x09EC, 0x1433, 0xF8C9, 0x0408 }, { 0x09F4, 0x1483, 0xF577, 0x068D },
 { 0x0303, 0x1DB0, 0xFD00, 0xFD88 }, { 0x1266, 0x19F7, 0xED80, 0xFB05 },
 { 0x0559, 0x171D, 0xF465, 0xFBE0 }, { 0x00A3, 0x1477, 0xF255, 0xF71D },
 { 0x0838, 0x10BD, 0xF375, 0xF32A }, { 0x0453, 0x1CF3, 0xF84C, 0xF979 },
 { 0x0894, 0x1C5E, 0xF6FA, 0xF87A }, { 0xFF0C, 0x1927, 0xF92F, 0xFCB9 },
 { 0x0CDD, 0x0EF8, 0xF4B6, 0xF448 }, { 0x01A3, 0x192B, 0xFE85, 0xFE69 },
 { 0x0C05, 0x1342, 0xFB7C, 0xF4CB }, { 0x0853, 0x16F2, 0xF6E6, 0x00E0 },
 { 0x02B2, 0x198A, 0xF75C, 0xF4E7 }, { 0x0642, 0x1145, 0xF62D, 0x0606 },
 { 0x0CF6, 0x249D, 0xF428, 0xF26B }, { 0x160E, 0x1D26, 0xEBDF, 0xFA49 },
 { 0x102B, 0x1BE1, 0xF9FD, 0xF307 }, { 0x0D99, 0x2375, 0xF993, 0xF1BB },
 { 0xE1BD, 0x0177, 0xFF96, 0xFDE1 }, { 0xDE75, 0xFA9D, 0xFDB6, 0xFE33 },
 { 0xD85E, 0xFC84, 0x082E, 0x02B6 }, { 0xE059, 0x017E, 0x01F8, 0xFEBB },
 { 0xDE9C, 0xFFA4, 0x005E, 0xFD70 }, { 0xE2DC, 0x0026, 0x0098, 0x0184 },
 { 0xDFB6, 0xFEF1, 0xFE35, 0xFC8D }, { 0xE101, 0xFD68, 0xFBFE, 0xFCDE },
 { 0xDF6B, 0xFF93, 0x0355, 0x00A1 }, { 0xDD9E, 0xFAB5, 0x044B, 0x0276 },
 { 0xDD03, 0xFFFA, 0x0454, 0xFD63 }, { 0xE3A4, 0xFA10, 0xFFD5, 0xFE69 },
 { 0xE27D, 0xFF52, 0x029C, 0xF5FE }, { 0xDCCA, 0xFF82, 0x00E3, 0xFB59 },
 { 0xE008, 0x0301, 0x0122, 0xFAA1 }, { 0xDAFC, 0x0037, 0x03C2, 0xFA08 },
 { 0xDE19, 0x021D, 0x02F3, 0xFBFA }, { 0xD98E, 0xF9A6, 0x0346, 0xF9CC },
 { 0xDEBF, 0xFD42, 0x0314, 0xF832 }, { 0xD88B, 0xF9EA, 0xFE92, 0xF8CF },
 { 0xE039, 0x004E, 0x05C7, 0xF8EB }, { 0xDC58, 0xFE3A, 0x0139, 0xF906 },
 { 0xE27E, 0xFBC4, 0x033F, 0xF676 }, { 0xE268, 0xFD43, 0x0814, 0xF97F },
 { 0xE191, 0xFA37, 0x0633, 0xF8F0 }, { 0xE5D3, 0xFDAC, 0xFF9F, 0x0322 },
 { 0xE306, 0xFFF1, 0x02AC, 0xFC3D }, { 0xE429, 0xFE23, 0xFF75, 0xFE56 },
 { 0xE05F, 0xFF92, 0xFFDC, 0xFEF8 }, { 0xE23C, 0xF87E, 0xFDB2, 0xFF9B },
 { 0xE221, 0xFB4F, 0x0117, 0x0294 }, { 0xE150, 0xF84A, 0x02F6, 0xF721 },
 { 0xDED0, 0xFF59, 0x08B8, 0xFB89 }, { 0xDEC6, 0xFAB1, 0x0270, 0xFD1C },
 { 0xE396, 0xFBE4, 0x0426, 0xFF75 }, { 0xE188, 0xFF27, 0x005B, 0xF8FE },
 { 0xE48A, 0xF962, 0xFC45, 0x0267 }, { 0xDCC4, 0xF8B8, 0x0065, 0xF77A },
 { 0xDB48, 0xFD1C, 0x0256, 0xFD65 }, { 0xDF00, 0xFB60, 0x07E8, 0xFB08 },
 { 0xDD94, 0xFDC6, 0xFC7F, 0xF6B0 }, { 0xD6C1, 0xFAFA, 0x021A, 0xFA00 },
 { 0xDDE8, 0xFC88, 0xFBBF, 0xFA8B }, { 0xE458, 0xFB5F, 0x027C, 0xFB1C },
 { 0xD968, 0x00E9, 0x0928, 0xFCF2 }, { 0xE0F0, 0xFAD2, 0xFE86, 0xF865 },
 { 0xE3D9, 0xFE86, 0x0580, 0xF743 }, { 0xDEED, 0xF9F7, 0x0386, 0xF83D },
 { 0xDC35, 0xFA3E, 0x039C, 0xF935 }, { 0xE021, 0xFC20, 0xFFB3, 0xF548 },
 { 0xDF69, 0x0094, 0xFE59, 0xF9DB }, { 0xDC6F, 0xFD77, 0xFF02, 0xFB42 },
 { 0xDD15, 0x01C8, 0x0119, 0xF88F }, { 0xDD7B, 0x00B3, 0xFE76, 0xF5B6 },
 { 0xDC47, 0x02F5, 0x060B, 0xFAD9 }, { 0xD9D1, 0xFD2D, 0x01B9, 0xF970 },
 { 0xDD32, 0xFD52, 0x05F9, 0xFA0B }, { 0xDAEC, 0xFB92, 0x0810, 0xFC56 },
 { 0xE821, 0xFC51, 0x02A5, 0xFFE1 }, { 0xE30D, 0xFD9B, 0xFCD2, 0x002E },
 { 0xDAF9, 0xFC66, 0xFE52, 0xF7F3 }, { 0xD3DE, 0xFB0C, 0x0526, 0xFBA3 },
 { 0xE002, 0x0340, 0x029F, 0xF75A }, { 0xD72B, 0xFDDA, 0x0688, 0xFC8A },
 { 0x0414, 0x2489, 0xF98D, 0xEAD1 }, { 0x040A, 0x1FD5, 0xFE39, 0xE7EA },
 { 0x02F9, 0x2065, 0xF372, 0xED1A }, { 0x03AA, 0x1F8D, 0x00A4, 0xEBF6 },
 { 0x050F, 0x21E1, 0x0A16, 0xEA8E }, { 0xFEC6, 0x1F25, 0xF6A5, 0xEB91 },
 { 0xFE05, 0x2334, 0xF63F, 0xE971 }, { 0x095C, 0x207A, 0xFC02, 0xEDBF },
 { 0xFA14, 0x2135, 0x079E, 0xEC97 }, { 0xFECC, 0x1CE9, 0x060D, 0xECFE },
 { 0xFF90, 0x2094, 0x0BBB, 0xECC8 }, { 0xFFCE, 0x2463, 0x055B, 0xE9DE },
 { 0xFD6D, 0x24E9, 0x09C0, 0xEA55 }, { 0x0A0D, 0x23BC, 0xF722, 0xED51 },
 { 0x033E, 0x1BC0, 0xFE4A, 0xF0BD }, { 0x020A, 0x29B0, 0xFD5B, 0xE6AD },
 { 0xFB5A, 0x277C, 0xFE02, 0xE68A }, { 0xFE55, 0x204F, 0xFDBD, 0xE755 },
 { 0x0642, 0x1FB1, 0xF879, 0xEEBE }, { 0xF726, 0x1FF4, 0x01C0, 0xEBBA },
 { 0xF99F, 0x2270, 0xFF1E, 0xE975 }, { 0x02F7, 0x2509, 0xFF97, 0xE94B },
 { 0x08CE, 0x1A17, 0xFE2E, 0xE9E2 }, { 0xFFA8, 0x1B22, 0x037F, 0xE8BA },
 { 0xF957, 0x2719, 0x0572, 0xEA3A }, { 0x02EC, 0x1F07, 0x021C, 0xE5DC },
 { 0x0583, 0x1B61, 0x00E8, 0xE7FF }, { 0x02B9, 0x1C7A, 0xFB3B, 0xEB22 },
 { 0xF91C, 0x2954, 0x0798, 0xF073 }, { 0xFACA, 0x23A4, 0x04AB, 0xF0C1 },
 { 0xFC77, 0x2753, 0x027B, 0xEC51 }, { 0x0298, 0x29B8, 0x0031, 0xEDEF },
 { 0x055E, 0x2540, 0xFCF7, 0xF1F9 }, { 0x00FC, 0x25E2, 0xFDAB, 0xF48D },
 { 0x0338, 0x23CC, 0xFC0A, 0xF7A0 }, { 0x0986, 0x2949, 0xF70F, 0xEEB8 },
 { 0x0835, 0x1BBE, 0x01FB, 0xF1E2 }, { 0x0126, 0x1F73, 0xFE50, 0xFA12 },
 { 0xFD67, 0x2861, 0x0223, 0xF4DC }, { 0x0490, 0x2ED5, 0xFE14, 0xEACD },
 { 0x0540, 0x1910, 0x012E, 0xEC3B }, { 0xF941, 0x2FE8, 0x05E3, 0xEE41 },
 { 0x02A2, 0x2A89, 0xFC7A, 0xF1EB }, { 0xFDBA, 0x2520, 0x012C, 0xF1DE },
 { 0x0281, 0x1DE6, 0x02B1, 0xF7C3 }, { 0x0811, 0x241B, 0x01FC, 0xEEF1 },
 { 0x041F, 0x20B5, 0x02B0, 0xF3B8 }, { 0xFD7F, 0x1FF9, 0x03DA, 0xF315 },
 { 0x0460, 0x1D02, 0x06F9, 0xF153 }, { 0x067C, 0x1F86, 0xFDAF, 0xF3E0 },
 { 0x07D2, 0x24FB, 0xF946, 0xF26D }, { 0x0939, 0x20B0, 0x0064, 0xF183 },
 { 0xFCFC, 0x1EA5, 0xFD9B, 0xEC84 }, { 0x05CD, 0x1D06, 0x0768, 0xE811 },
 { 0xFE50, 0x1E8F, 0xFC4D, 0xF4BE }, { 0x0139, 0x2B72, 0xFD08, 0xECF9 },
 { 0x019C, 0x20DC, 0xFEE5, 0xEF79 }, { 0x0631, 0x28A2, 0xF8A4, 0xF33D },
 { 0x0141, 0x1B28, 0x0305, 0xF438 }, { 0xFF97, 0x2336, 0x0079, 0xF737 },
 { 0x0631, 0x2849, 0xFC2F, 0xED34 }, { 0x0653, 0x2E5D, 0x051A, 0xE524 },
 { 0xFB70, 0x22B6, 0xFFAF, 0xF63C }, { 0xFE75, 0x2A86, 0x02DD, 0xE6A6 },
 { 0xECAB, 0x10B2, 0x0F98, 0xFBE2 }, { 0xEF6F, 0x14B3, 0x10A6, 0xF9D0 },
 { 0xF56A, 0x0F16, 0x11C8, 0xF977 }, { 0xEE00, 0x09A8, 0x0E58, 0xF94D },
 { 0xF4E5, 0x0B00, 0x0FA3, 0xF6EA }, { 0xEB93, 0x0B94, 0x1604, 0x005A },
 { 0xECC4, 0x0D72, 0x1397, 0xFBB8 }, { 0xFAFF, 0x0CF1, 0x15A1, 0xF7EE },
 { 0xF120, 0x0793, 0x10FF, 0xFC69 }, { 0xF885, 0x0A19, 0x134B, 0xF9B2 },
 { 0xF272, 0x0733, 0x15BA, 0xFD56 }, { 0xF128, 0x0366, 0x16C3, 0x0090 },
 { 0xEC87, 0x05AC, 0x1278, 0xFD3B }, { 0xF15F, 0x0ABE, 0x1C34, 0x0103 },
 { 0xF8AD, 0x076C, 0x1972, 0xFCC6 }, { 0xEF17, 0x0626, 0x1C18, 0x0518 },
 { 0xEAE0, 0x05A4, 0x1840, 0x0277 }, { 0xF301, 0x14C0, 0x164B, 0xF9FB },
 { 0xE4CA, 0x0D06, 0x0FC2, 0x0404 }, { 0xE2C4, 0x1095, 0x107A, 0xFF2C },
 { 0xE659, 0x16CF, 0x11BB, 0xFE00 }, { 0xE9AD, 0x172F, 0x0EA3, 0xFB5E },
 { 0xE6F6, 0x1311, 0x0D1C, 0xF9B6 }, { 0xEBE6, 0x0A1E, 0x0B22, 0x087C },
 { 0xEBB4, 0x0FFF, 0x0A09, 0xFE8B }, { 0xEC4D, 0x1789, 0x10DE, 0x02B4 },
 { 0xEA6B, 0x1314, 0x0DB9, 0x0172 }, { 0xE56C, 0x1D6D, 0x16B4, 0xFE18 },
 { 0xE9E7, 0x09B0, 0x0FDD, 0x04D2 }, { 0xF3AD, 0x05C0, 0x17B7, 0x04A4 },
 { 0xF29D, 0x1461, 0x0D72, 0x035A }, { 0xEDA6, 0x0BC5, 0x158D, 0x0A1A },
 { 0xEE9F, 0x08B2, 0x152A, 0x0DFC }, { 0xE705, 0x0DDB, 0x156F, 0x07EC },
 { 0xF254, 0x139B, 0x12B3, 0x0001 }, { 0xF03A, 0x0A12, 0x0C01, 0x0C4F },
 { 0xF542, 0x07A3, 0x1175, 0x0F10 }, { 0xE9C0, 0x067B, 0x17E6, 0x09A5 },
 { 0xEF02, 0x04D9, 0x1AB8, 0x0C36 }, { 0xEA43, 0x13C2, 0x144C, 0x0522 },
 { 0xF996, 0x105E, 0x0F6C, 0x025F }, { 0xFB2F, 0x100C, 0x12F2, 0xFD80 },
 { 0xFC1B, 0x0D64, 0x0CA7, 0x0562 }, { 0xE6A8, 0x0AB5, 0x1B0E, 0x0AE8 },
 { 0xEFA4, 0x0EB3, 0x108B, 0x07E2 }, { 0xF376, 0x0C98, 0x160E, 0x0593 },
 { 0xEA6A, 0x1AFD, 0x13CE, 0xFD8D }, { 0xF501, 0x0F9A, 0x0D61, 0x076F },
 { 0xF78D, 0x0AAE, 0x152F, 0x0091 }, { 0xEFCB, 0x1097, 0x0933, 0x02DE },
 { 0xFE66, 0x09D9, 0x102A, 0xFFF0 }, { 0xF695, 0x0951, 0x133F, 0x0839 },
 { 0xE843, 0x0E07, 0x0C2A, 0x0252 }, { 0xEFA6, 0x12E2, 0x1726, 0xFC14 },
 { 0xE36D, 0x0D29, 0x174E, 0x01C0 }, { 0xE47E, 0x1659, 0x168B, 0x00EE },
 { 0xEE8E, 0x0F43, 0x0DCF, 0xF929 }, { 0xF7BC, 0x0F82, 0x1813, 0xFA90 },
 { 0xE3B9, 0x085F, 0x20D7, 0x0E2E }, { 0xEAC9, 0x1186, 0x1956, 0xFFD6 },
 { 0xF8AE, 0x0651, 0x18BD, 0x0207 }, { 0xE6B2, 0x0A45, 0x121A, 0xFE07 },
 { 0xE198, 0x0926, 0x1C30, 0x0555 }, { 0xFB7E, 0x0598, 0x12DF, 0x0608 },
 { 0xEC9C, 0xE957, 0x0705, 0x01FA }, { 0xEEAC, 0xE507, 0x0423, 0xFB2B },
 { 0xEAE8, 0xE51A, 0x0374, 0xFEDE }, { 0xE78D, 0xE441, 0x020B, 0xFF1D },
 { 0xED2D, 0xE6CE, 0x0584, 0xFE3E }, { 0xF028, 0xE7BB, 0x06BD, 0xFC51 },
 { 0xE9F6, 0xE835, 0x054D, 0x025D }, { 0xEF9C, 0xE9D2, 0x088B, 0xFF53 },
 { 0xED8A, 0xEBFA, 0x09A6, 0x0141 }, { 0xE60E, 0xEC1D, 0x05E3, 0xFC13 },
 { 0xEB48, 0xEB7E, 0x0798, 0x062B }, { 0xE3F5, 0xEA70, 0x05BC, 0xFE57 },
 { 0xE86F, 0xECE1, 0x0754, 0xFC45 }, { 0xE63D, 0xEBE9, 0x089F, 0x050B },
 { 0xEF80, 0xECB1, 0x0736, 0x0700 }, { 0xE428, 0xE4DA, 0x021B, 0x02D4 },
 { 0xEEEF, 0xECDB, 0x0A1E, 0x044F }, { 0xE30B, 0xE9C0, 0x06B0, 0x05A0 },
 { 0xE903, 0xE55B, 0x01A2, 0x0367 }, { 0xE554, 0xEA21, 0x02C6, 0xF9E5 },
 { 0xE815, 0xE947, 0x054E, 0x065F }, { 0xEB55, 0xEA0A, 0x0242, 0x085A },
 { 0xE3FD, 0xE88C, 0x015B, 0x08A0 }, { 0xE83D, 0xEB7D, 0x0854, 0x01A9 },
 { 0xEF17, 0xE9A7, 0x0197, 0xF44F }, { 0xEB32, 0xEC40, 0x045F, 0xF8D3 },
 { 0xEA93, 0xE920, 0x00B9, 0xF6AB }, { 0xE67F, 0xEBC6, 0x0193, 0xFD47 },
 { 0xE5C1, 0xEEC4, 0x0AA6, 0x0367 }, { 0xEBFA, 0xEA03, 0x072B, 0xFCFD },
 { 0xEA0A, 0xEEF7, 0x0B9D, 0x035A }, { 0xEB5E, 0xE8F9, 0x002D, 0xFEB1 },
 { 0xEEFB, 0xE9E8, 0x06A0, 0xF9EA }, { 0xE41D, 0xE5FD, 0x0273, 0xFE67 },
 { 0xEEC1, 0xE748, 0x0023, 0x051A }, { 0xE229, 0xE822, 0x046E, 0x00C5 },
 { 0xF1D6, 0xEA28, 0x07E3, 0x0385 }, { 0xF225, 0xEC38, 0x0498, 0x06CA },
 { 0xEC2D, 0xF0C5, 0x0827, 0x010A }, { 0xF00A, 0xE759, 0x05C7, 0x0168 },
 { 0xE7BE, 0xEB9C, 0xFF39, 0xFA3B }, { 0xF0BA, 0xEC39, 0x054C, 0xFFF1 },
 { 0xE240, 0xEC8F, 0x01CD, 0x0961 }, { 0xE81A, 0xE80D, 0x04EA, 0xFDCD },
 { 0xE811, 0xEC98, 0x0506, 0xFFE5 }, { 0xEFE7, 0xE924, 0x0459, 0x05C4 },
 { 0xEBDB, 0xECEF, 0x048A, 0xFD6A }, { 0xEDE3, 0xEC59, 0x049B, 0x02C5 },
 { 0xEA7B, 0xEAB4, 0xFE73, 0x04C8 }, { 0xEE0B, 0xE533, 0x0286, 0x01D3 },
 { 0xE799, 0xF035, 0x01D4, 0x0116 }, { 0xEB28, 0xE6BF, 0x036A, 0xFA40 },
 { 0xE4AA, 0xE736, 0x004E, 0xF8FA }, { 0xECCD, 0xEE4E, 0x0AC4, 0xFF35 },
 { 0xE860, 0xEEEB, 0x05BC, 0x041C }, { 0xEF4F, 0xE444, 0x03AE, 0xFEBD },
 { 0xE668, 0xEF41, 0x092F, 0x0045 }, { 0xE4D6, 0xEDFB, 0x02D2, 0x05F1 },
 { 0xEF97, 0xEB0F, 0x02FB, 0xF9E6 }, { 0xE51F, 0xEA24, 0xFD14, 0x029D },
 { 0xE5D9, 0xF225, 0xFFDE, 0x0513 }, { 0xF073, 0xE9A0, 0x0054, 0x006F },
 { 0xEDC9, 0xED37, 0x087D, 0xFBF9 }, { 0xE639, 0xE843, 0x0517, 0x0100 },
 { 0xE254, 0xEF57, 0xE961, 0xEFD4 }, { 0xE62E, 0xF53A, 0xEB58, 0xF0A0 },
 { 0xE908, 0xF0E7, 0xE65D, 0xF3F0 }, { 0xE3C4, 0xEA7A, 0xE203, 0xF0B8 },
 { 0xDD6A, 0xE667, 0xDF82, 0xEB0F }, { 0xDB6E, 0xEB7F, 0xE6F3, 0xEF21 },
 { 0xEEBE, 0xF3DA, 0xE720, 0xEEFA }, { 0xEA58, 0xEF95, 0xE531, 0xEC6B },
 { 0xF410, 0xEF24, 0xEA41, 0xF393 }, { 0xF3FA, 0xE891, 0xEC45, 0xF59F },
 { 0xE904, 0xE76C, 0xE984, 0xF053 }, { 0xED27, 0xEE3B, 0xEA61, 0xF02B },
 { 0xEEA5, 0xE812, 0xEB3C, 0xFAA8 }, { 0xF07C, 0xE73B, 0xE82E, 0xF582 },
 { 0xE989, 0xF523, 0xEAEA, 0xE7AA }, { 0xEE8E, 0xE809, 0xEA3E, 0xF1A1 },
 { 0xEF3D, 0xE898, 0xF214, 0xEBBB }, { 0xE3EB, 0xEEB3, 0xE391, 0xE83E },
 { 0xEC2C, 0xEEAF, 0xF544, 0xEB0A }, { 0xE7AF, 0xF4F7, 0xE54F, 0xE9E1 },
 { 0xF453, 0xED48, 0xF088, 0xEE74 }, { 0xE164, 0xE1A3, 0xE1D6, 0xE993 },
 { 0xE661, 0xE9B9, 0xE92C, 0xEA2B }, { 0xE244, 0xEAC2, 0xEFD8, 0xF142 },
 { 0xEF86, 0xEFB0, 0xE641, 0xF6E3 }, { 0xED1B, 0xEC39, 0xE64B, 0x0142 },
 { 0xE642, 0xE89A, 0xF45C, 0xF0F9 }, { 0xEA4A, 0xF465, 0xEA8F, 0xF874 },
 { 0xE4A7, 0xEB35, 0xEC91, 0xF95F }, { 0xEDAA, 0xF580, 0xE508, 0xF41C },
 { 0xDEC1, 0xEAFD, 0xE979, 0xF60B }, { 0xE284, 0xEADC, 0xE686, 0xF5F4 },
 { 0xE63B, 0xEC93, 0xE6E9, 0xFB06 }, { 0xE6F1, 0xF04A, 0xEBD0, 0xFBD0 },
 { 0xEA68, 0xEA66, 0xE3CE, 0xF6D7 }, { 0xED13, 0xED3B, 0xE8C9, 0xFB35 },
 { 0xE85F, 0xE412, 0xE5A8, 0xF78F }, { 0xDC9B, 0xE37D, 0xDEA2, 0xEEE9 },
 { 0xEC6E, 0xEA56, 0xEAD8, 0xFFAE }, { 0xEFD9, 0xEF93, 0xEC0B, 0xF2D3 },
 { 0xF311, 0xE913, 0xF059, 0xEC3B }, { 0xE897, 0xE6B8, 0xF086, 0xED92 },
 { 0xF46A, 0xE938, 0xF4FB, 0xE75F }, { 0xED0D, 0xEBE0, 0xF7ED, 0xF0A6 },
 { 0xF1DC, 0xEEA7, 0xF2DE, 0xE934 }, { 0xEE8B, 0xEB9B, 0xEE4A, 0xEA28 },
 { 0xF04A, 0xE741, 0xEF1F, 0xE825 }, { 0xECDD, 0xEE69, 0xF3F4, 0xF173 },
 { 0xEE76, 0xDFAC, 0xEDF4, 0xE7A4 }, { 0xE641, 0xEF0A, 0xE33B, 0xF021 },
 { 0xE69E, 0xEC3F, 0xEA4F, 0x01E5 }, { 0xE854, 0xF566, 0xE44B, 0xEFD0 },
 { 0xE7C9, 0xE1A2, 0xE44A, 0xF027 }, { 0xE290, 0xE6E8, 0xE6F1, 0xEF57 },
 { 0xE2F1, 0xF66A, 0xE734, 0xED25 }, { 0xEB2B, 0xE273, 0xEEBF, 0xEDE1 },
 { 0xEEFF, 0xE441, 0xEF9B, 0xF57F }, { 0xEB93, 0xE66B, 0xEBF7, 0xE56C },
 { 0xE80F, 0xE1EB, 0xEB8C, 0xED1C }, { 0xE573, 0xF071, 0xF0D4, 0xEECA },
 { 0xE620, 0xEE8D, 0xED77, 0xEC44 }, { 0xF304, 0xE254, 0xF560, 0xE667 },
 { 0xEA9F, 0xE774, 0xF958, 0xEE61 }, { 0xEFDD, 0xE3A1, 0xF394, 0xEBB4 },
 { 0xE434, 0xEA43, 0xF273, 0x02AD }, { 0xE88E, 0xE87B, 0xF0EE, 0x0240 },
 { 0xF3B8, 0xDFF5, 0xFAF5, 0xFE4E }, { 0xE830, 0xE48D, 0xF05C, 0x0549 },
 { 0xF099, 0xE1E3, 0xF6D8, 0xFFDC }, { 0xEE62, 0xE591, 0xF5AE, 0x0277 },
 { 0xF1B7, 0xD2EB, 0xF5F6, 0xF070 }, { 0xE8B9, 0xDD6A, 0xFACB, 0xFC9D },
 { 0xE5D5, 0xDD5E, 0xF9BA, 0xFEA8 }, { 0xF104, 0xE0E7, 0xF6E2, 0xF814 },
 { 0xF29A, 0xE093, 0xF423, 0xFD60 }, { 0xF0E4, 0xDC20, 0xF1CD, 0xF8E5 },
 { 0xEF5E, 0xDC9C, 0xF5C3, 0xFC10 }, { 0xF1F5, 0xDE0B, 0xF81A, 0xFD10 },
 { 0xEE23, 0xE090, 0xF3A2, 0xF5C2 }, { 0xED0C, 0xE121, 0xFA83, 0x0100 },
 { 0xEE11, 0xE46F, 0xF9E8, 0x03C5 }, { 0xE4CD, 0xE219, 0xFC2C, 0x0328 },
 { 0xEBC5, 0xE60F, 0xF2E4, 0x04AC }, { 0xE442, 0xE4E3, 0xF512, 0x084B },
 { 0xE52D, 0xE936, 0xF308, 0xFCFE }, { 0xE8A7, 0xE337, 0xF63C, 0xFCF6 },
 { 0xE7F0, 0xE700, 0xFC5A, 0xF611 }, { 0xE5AB, 0xE248, 0xFE9D, 0xFAF7 },
 { 0xE538, 0xE6BE, 0xFA67, 0xF995 }, { 0xED4E, 0xE76C, 0xEC96, 0x0178 },
 { 0xEAE1, 0xDD5E, 0xF731, 0xFE70 }, { 0xF11A, 0xE696, 0xFA95, 0xF1DC },
 { 0xEC7A, 0xE807, 0xFB50, 0xF004 }, { 0xEBFD, 0xDAAB, 0xF4DF, 0xFAE6 },
 { 0xEF5D, 0xE6D4, 0xEED5, 0xFEAE }, { 0xEB9B, 0xE566, 0xFC8D, 0x04C9 },
 { 0xE807, 0xE7B9, 0xF78B, 0x022A }, { 0xF0C9, 0xE663, 0xF398, 0xF8DB },
 { 0xF0D2, 0xE004, 0xFFA9, 0xFC46 }, { 0xE3B5, 0xE5CD, 0xF758, 0xFEC4 },
 { 0xEA28, 0xE24A, 0x0055, 0xFE50 }, { 0xF08B, 0xE0F7, 0xFE08, 0xFF70 },
 { 0xEDF7, 0xE238, 0x00DA, 0xFEC8 }, { 0xED43, 0xDDDF, 0xFCB4, 0xFBE5 },
 { 0xEE82, 0xDEBC, 0xFA87, 0xFE3A }, { 0xEE33, 0xE46E, 0xFED2, 0xF6E4 },
 { 0xE621, 0xE1C8, 0xFEF1, 0xFFCE }, { 0xF3AB, 0xE294, 0xFBA9, 0xF761 },
 { 0xF1FA, 0xE37C, 0xFB09, 0x0205 }, { 0xEEA6, 0xE376, 0xFE05, 0x024E },
 { 0xE6C6, 0xE29C, 0xF509, 0x029A }, { 0xEC81, 0xDEEE, 0xF2DD, 0xFCEF },
 { 0xE2CE, 0xE28B, 0xFBE0, 0xF8D1 }, { 0xE2B3, 0xDF84, 0xFC56, 0xFF4C },
 { 0xEB2F, 0xE1C5, 0xFDBD, 0xF6DB }, { 0xEE3B, 0xE469, 0xFF50, 0xF22D },
 { 0xEBB9, 0xDE5C, 0xFA20, 0xEF66 }, { 0xF3F5, 0xE46E, 0xF735, 0x0020 },
 { 0xF05D, 0xE47D, 0xFBBB, 0xFCE9 }, { 0xEA6D, 0xE063, 0xFD5A, 0xFF8E },
 { 0xF432, 0xD7E7, 0xF7EA, 0xF3DB }, { 0xF0BF, 0xE77E, 0xFF4A, 0xF1BC },
 { 0xF33B, 0xDBFF, 0xFDD9, 0xF5A6 }, { 0xF3BE, 0xDB9E, 0xF942, 0xF958 },
 { 0xEEBC, 0xD79D, 0xF930, 0xF27D }, { 0xEFBD, 0xDE5F, 0xF706, 0xEFEF },
 { 0xEA42, 0xE697, 0xFB27, 0xFE31 }, { 0xF3C6, 0xD9EE, 0xF6D0, 0xECEC },
 { 0xE16F, 0xF291, 0x05AB, 0xFA44 }, { 0xDEFD, 0xF30A, 0x0938, 0xFE4D },
 { 0xDEF2, 0xEFDE, 0x059E, 0xFC00 }, { 0xDB2F, 0xEE2C, 0x0530, 0xFD4F },
 { 0xD4FA, 0xF37E, 0x08E6, 0x0820 }, { 0xDFB3, 0xF537, 0xFF6E, 0xFE48 },
 { 0xE2B7, 0xF5C6, 0xFF5A, 0x019D }, { 0xDFC6, 0xF40C, 0x020A, 0xF7AB },
 { 0xDF53, 0xEB0A, 0x0543, 0xFE3D }, { 0xDE73, 0xF075, 0x0B7F, 0x02CA },
 { 0xE051, 0xF5F4, 0x04F8, 0xF92C }, { 0xE16A, 0xEBB7, 0x025D, 0xFA34 },
 { 0xE049, 0xED80, 0x085D, 0x0100 }, { 0xE1D4, 0xED5F, 0x05B7, 0xFCD4 },
 { 0xE33D, 0xF0B9, 0x09EC, 0x0004 }, { 0xE0DA, 0xF2BB, 0x093B, 0x0556 },
 { 0xE341, 0xEF94, 0x06D8, 0xFC42 }, { 0xE23A, 0xF24F, 0x0294, 0x0394 },
 { 0xD932, 0xF1AF, 0x0C5D, 0x033C }, { 0xDDEF, 0xEFBE, 0x003E, 0x06B6 },
 { 0xDB27, 0xED60, 0x0AA2, 0x04D2 }, { 0xE0E8, 0xEE70, 0x008A, 0x05F8 },
 { 0xDFFA, 0xF282, 0xFE45, 0x0277 }, { 0xE1B4, 0xF73A, 0x028F, 0x0471 },
 { 0xDD77, 0xF3B7, 0x0459, 0x033D }, { 0xE177, 0xF31E, 0x04E3, 0x00E6 },
 { 0xDB3B, 0xF553, 0x0143, 0xF8BA }, { 0xDB40, 0xEFB8, 0x04F6, 0x060D },
 { 0xDCB3, 0xF0CC, 0xFC52, 0x011B }, { 0xDFC1, 0xF0F7, 0x0515, 0x06E2 },
 { 0xDC9F, 0xF06D, 0xFFD7, 0xFD56 }, { 0xDB1F, 0xEFA5, 0x07E3, 0xFF91 },
 { 0xD9F4, 0xF396, 0x0642, 0xFC99 }, { 0xDF68, 0xF656, 0x05B5, 0x05E2 },
 { 0xD9E8, 0xF493, 0x07CC, 0x04DB }, { 0xDC11, 0xF12C, 0x00B4, 0x0219 },
 { 0xDC9C, 0xF69B, 0x0474, 0xF9E6 }, { 0xDB7C, 0xF6B8, 0x0135, 0xFF5E },
 { 0xD5DE, 0xF392, 0xFFFB, 0xFA24 }, { 0xE032, 0xEE44, 0xFE4E, 0xFCC6 },
 { 0xE298, 0xF6DB, 0x0450, 0xFFB7 }, { 0xDB70, 0xF59E, 0x0BF6, 0x0038 },
 { 0xDFB5, 0xF6E1, 0x07D0, 0xFB57 }, { 0xD077, 0xF3AE, 0x0507, 0xFD80 },
 { 0xD37A, 0xF7B8, 0x03B2, 0xFB75 }, { 0xDD14, 0xEE31, 0x0148, 0xF960 },
 { 0xD4EF, 0xEF8B, 0x0AFD, 0x0348 }, { 0xDBF8, 0xF203, 0x08B0, 0x07F7 },
 { 0xDD11, 0xF2F7, 0x04E0, 0xFAEE }, { 0xE124, 0xF036, 0x01E5, 0xF7E0 },
 { 0xDBFB, 0xF865, 0x088F, 0xFC90 }, { 0xD5F6, 0xF8F8, 0x09D4, 0xFEBC },
 { 0xD891, 0xF742, 0x03D5, 0xFAC9 }, { 0xD17C, 0xF508, 0x0CB7, 0x0285 },
 { 0xD670, 0xEFF7, 0x0503, 0xFDAD }, { 0xE211, 0xF4D1, 0x09A3, 0xFCE3 },
 { 0xD628, 0xF0F2, 0x0E7E, 0x0602 }, { 0xD5B9, 0xF4B3, 0x0580, 0xFCDF },
 { 0xD96E, 0xF108, 0x0100, 0xF99A }, { 0xD766, 0xF2C1, 0x090B, 0xFFA2 },
 { 0xD2FB, 0xF011, 0x1039, 0x084A }, { 0xDAB6, 0xF7D8, 0x0605, 0x01E1 },
 { 0xDDE5, 0xF67F, 0x0412, 0x0870 }, { 0xE154, 0xF077, 0xFAA6, 0x068D },
 { 0x1BA0, 0xF2A4, 0x0576, 0xF933 }, { 0x1824, 0xF848, 0x0500, 0xF21B },
 { 0x1E0C, 0xF8FF, 0x0B1C, 0xF95C }, { 0x20AB, 0xF913, 0x0C20, 0xF589 },
 { 0x23FD, 0xF33E, 0x0EAC, 0xF22A }, { 0x25B2, 0xF5AC, 0x0592, 0xFADA },
 { 0x1E20, 0xF514, 0x0E66, 0xF849 }, { 0x1C94, 0xF243, 0x0B05, 0xFD92 },
 { 0x1D0A, 0xF5DE, 0x0901, 0xF728 }, { 0x1C45, 0xF8FB, 0x00FF, 0xF3D6 },
 { 0x21D7, 0xF841, 0x053A, 0xF410 }, { 0x19D8, 0xFC48, 0x0FDB, 0xF5A4 },
 { 0x2277, 0xFAD1, 0x0552, 0xFAB4 }, { 0x26D2, 0xF946, 0x0507, 0xF6C6 },
 { 0x1C27, 0xFBDF, 0x0779, 0xFADD }, { 0x1D54, 0xF9CF, 0x0366, 0xF842 },
 { 0x2019, 0xF1A0, 0x0589, 0xF39E }, { 0x2089, 0xF613, 0x0694, 0xFDB7 },
 { 0x1F7E, 0xF6E1, 0x00FC, 0xF510 }, { 0x200C, 0xEFF4, 0x0C19, 0xF5F7 },
 { 0x1E15, 0xF2D9, 0x0240, 0xF440 }, { 0x1CB6, 0xFCEE, 0x096E, 0xF7AF },
 { 0x1B24, 0xF5F8, 0x0647, 0xFF1F }, { 0x1E04, 0xF6AD, 0x051C, 0xF287 },
 { 0x2072, 0xF27E, 0x095A, 0xFA52 }, { 0x20F6, 0xF523, 0x0413, 0xFAAE },
 { 0x23D7, 0xF7E4, 0x0860, 0xF83D }, { 0x209B, 0xF56B, 0x0DA1, 0xEF33 },
 { 0x1640, 0xF6B7, 0x0B36, 0x0353 }, { 0x2279, 0xFB25, 0x08AB, 0xF5D5 },
 { 0x2261, 0xF9B2, 0x0248, 0xF62F }, { 0x20DD, 0xFE80, 0x058D, 0xF73C },
 { 0x240C, 0xF416, 0x0CCF, 0xF78C }, { 0x18C6, 0xF576, 0x0DDB, 0xFF95 },
 { 0x2745, 0xF654, 0x0B15, 0xF3A0 }, { 0x1D0F, 0xFDA4, 0x0C69, 0xF069 },
 { 0x1E45, 0xFBD8, 0x10E9, 0xED09 }, { 0x21CF, 0xF77F, 0x08CC, 0xF241 },
 { 0x212A, 0xFF1C, 0x07A6, 0xF35F }, { 0x2911, 0xF468, 0x0777, 0xF6DC },
 { 0x1FD2, 0xFCA2, 0x075C, 0xF945 }, { 0x1E6C, 0xFD66, 0x0BBC, 0xF4B5 },
 { 0x1E69, 0xF9AC, 0x1025, 0xF2A7 }, { 0x2816, 0xF16D, 0x0D7F, 0xF465 },
 { 0x217A, 0xFC77, 0x11A7, 0xEDD7 }, { 0x23A9, 0xF5FE, 0x01CF, 0xF65F },
 { 0x24EB, 0xF1FD, 0x0770, 0xF410 }, { 0x1995, 0xF744, 0x0BC2, 0xEE55 },
 { 0x1C07, 0xF584, 0x0B97, 0xF27E }, { 0x2690, 0xF332, 0x041E, 0xF658 },
 { 0x23C1, 0xFC5D, 0x04C1, 0xF5FB }, { 0x2255, 0xF273, 0x02F1, 0xF5F8 },
 { 0x1A1B, 0xF131, 0x0705, 0xF080 }, { 0x1A91, 0xF847, 0x0907, 0xFE3C },
 { 0x18C0, 0xF9DC, 0x0A34, 0xF340 }, { 0x1F3C, 0xFC10, 0x02DA, 0xF46C },
 { 0x1D61, 0xFBDD, 0x0625, 0xF192 }, { 0x1FD4, 0xF07B, 0x0A28, 0xF20C },
 { 0x1E55, 0xFA04, 0x09E0, 0xF0F0 }, { 0x1CEC, 0xF0B2, 0x1178, 0xFF71 },
 { 0x22BE, 0xFA8A, 0x0CE3, 0xF19B }, { 0x1688, 0xF807, 0x05CF, 0xFD83 },
 { 0x140B, 0xF4CF, 0x099F, 0xFCD5 }, { 0x1927, 0xF9E0, 0x0DAC, 0xF9F2 },
 { 0xDD52, 0xE572, 0xEB39, 0xFA54 }, { 0xE744, 0xDA0F, 0xF3D8, 0xFC22 },
 { 0xDF04, 0xE754, 0xF192, 0xFD51 }, { 0xE815, 0xD5A8, 0xF1CB, 0xEEFA },
 { 0xED50, 0xDA94, 0xEE1F, 0xF5EB }, { 0xE824, 0xD6ED, 0xED05, 0xF624 },
 { 0xE24B, 0xE2A2, 0xF6E9, 0xF513 }, { 0xDA42, 0xDDB9, 0xF65D, 0xF826 },
 { 0xE6A2, 0xE29D, 0xED95, 0xFF8A }, { 0xDF9E, 0xDCEA, 0xF978, 0xFEC3 },
 { 0xDDA2, 0xD4D5, 0xF0D0, 0xFA6E }, { 0xE77F, 0xE621, 0xE579, 0xFF72 },
 { 0xDF87, 0xE20C, 0xF7A3, 0xFB05 }, { 0xE6CB, 0xDF24, 0xF1FB, 0xEFFA },
 { 0xE5A5, 0xE1BA, 0xE9C6, 0xF63E }, { 0xE17A, 0xE5DB, 0xF39A, 0xF672 },
 { 0xD771, 0xD86E, 0xF0A5, 0xF6C4 }, { 0xD692, 0xDEED, 0xEA5D, 0xF52C },
 { 0xDAFD, 0xE5F1, 0xF317, 0xF721 }, { 0xDCEA, 0xDB0F, 0xE9FD, 0xF05B },
 { 0xD881, 0xE0E3, 0xE68D, 0xEFAC }, { 0xE37B, 0xE6B1, 0xEB0C, 0x02D0 },
 { 0xDAB9, 0xDCD9, 0xE10F, 0xFC70 }, { 0xDAC2, 0xDE8E, 0xF273, 0xFE80 },
 { 0xE24F, 0xD798, 0xF37B, 0xFB99 }, { 0xE068, 0xDE54, 0xECA6, 0xF4B8 },
 { 0xDFF6, 0xDF2A, 0xE482, 0xF141 }, { 0xE370, 0xDF7C, 0xF2FA, 0xF911 },
 { 0xDE8A, 0xDBD2, 0xE079, 0xEFB2 }, { 0xE464, 0xD3DC, 0xEA3B, 0xF4A5 },
 { 0xDF99, 0xDD08, 0xEEF2, 0xF9F8 }, { 0xD4A0, 0xD81E, 0xF713, 0xFE80 },
 { 0xEBA3, 0xE2A0, 0xEC70, 0xFAC5 }, { 0xE8FF, 0xE0FC, 0xE89D, 0xFA97 },
 { 0xD5C0, 0xDFF7, 0xEFC7, 0xFA33 }, { 0xD7DB, 0xDD29, 0xE755, 0xF98C },
 { 0xE900, 0xD7B0, 0xF113, 0xF93B }, { 0xD6FF, 0xE3F3, 0xE83D, 0xF428 },
 { 0xE1D7, 0xDA04, 0xE641, 0xEB28 }, { 0xE9C8, 0xE12A, 0xF262, 0xF608 },
 { 0xD8E2, 0xD6FC, 0xF351, 0xFCCC }, { 0xE763, 0xDDC3, 0xEE66, 0xF495 },
 { 0xDFBB, 0xE159, 0xE7BB, 0xF9F0 }, { 0xD81C, 0xE2C7, 0xE04F, 0xF08E },
 { 0xE4E6, 0xD586, 0xE846, 0xEDA1 }, { 0xE3F1, 0xD528, 0xEEA2, 0xF913 },
 { 0xE430, 0xDC17, 0xF852, 0xF633 }, { 0xE7A6, 0xDBD1, 0xF6F7, 0xEF44 },
 { 0xDEC9, 0xD97F, 0xF683, 0xFDA0 }, { 0xDB64, 0xE15C, 0xDF39, 0xF7B8 },
 { 0xE0F1, 0xE40B, 0xE679, 0xFFF5 }, { 0xE3A8, 0xDAFF, 0xF784, 0xFD6C },
 { 0xD8B1, 0xDA74, 0xF62D, 0xFFF1 }, { 0xE5E4, 0xDC52, 0xE823, 0xEF92 },
 { 0xDFF4, 0xD164, 0xEB9C, 0xF6FE }, { 0xDA12, 0xE5CE, 0xEFED, 0xF335 },
 { 0xE539, 0xE45A, 0xF697, 0xEEA1 }, { 0xE350, 0xE207, 0xEE81, 0xEFEC },
 { 0xDD6D, 0xE546, 0xECC1, 0xF47C }, { 0xDD21, 0xD72C, 0xE9FF, 0xF76E },
 { 0xDE4D, 0xDCD6, 0xE3F8, 0xF9D9 }, { 0xDFEF, 0xDA06, 0xE493, 0xF304 },
 { 0xF146, 0xD7F7, 0xF1D9, 0xED30 }, { 0xE009, 0xE2D7, 0xF006, 0x0286 },
 { 0xE01D, 0xE413, 0x00C8, 0x01F2 }, { 0xDF9F, 0xE786, 0x02AE, 0xFF32 },
 { 0xD8D2, 0xE79F, 0xFBF8, 0xF8B8 }, { 0xDDA7, 0xDF79, 0xFCFB, 0xFF57 },
 { 0xDC43, 0xE7B9, 0x03C9, 0xFFF1 }, { 0xDF91, 0xE91D, 0xFFF9, 0x07D6 },
 { 0xDA2E, 0xE38D, 0x00FF, 0x052A }, { 0xDBB3, 0xE3C5, 0x0047, 0xFF19 },
 { 0xDEB3, 0xE7B9, 0x011F, 0xFCBB }, { 0xD713, 0xEAFD, 0x0487, 0x05A9 },
 { 0xD61A, 0xE150, 0xFF7E, 0x0066 }, { 0xDE0A, 0xE2DB, 0xFB46, 0x02B2 },
 { 0xDB69, 0xEB34, 0x044F, 0x0C62 }, { 0xD642, 0xE089, 0xFCC1, 0x0661 },
 { 0xDC0F, 0xE527, 0xF570, 0x08D2 }, { 0xDF1B, 0xEB12, 0xFA83, 0x00E2 },
 { 0xDC96, 0xE93A, 0xFECD, 0xF9DD }, { 0xD472, 0xE32B, 0xF546, 0xFC7C },
 { 0xD906, 0xE8DB, 0xF82A, 0xFE4B }, { 0xDB08, 0xED7B, 0xFEEF, 0x0425 },
 { 0xD6D1, 0xE5E4, 0xFBA7, 0x067C }, { 0xD8A7, 0xEA38, 0x043B, 0xFEF3 },
 { 0xDD86, 0xE97D, 0x0640, 0x05CE }, { 0xD733, 0xDC91, 0xFB1B, 0xFFC0 },
 { 0xD0CB, 0xE959, 0x0002, 0x0301 }, { 0xCD75, 0xE5F9, 0x0672, 0x059D },
 { 0xD54C, 0xE6DE, 0xFB1C, 0xFD77 }, { 0xD27E, 0xE16E, 0xF7FB, 0x02C6 },
 { 0xD0A6, 0xE5B3, 0xF89F, 0xFD25 }, { 0xDC7B, 0xE831, 0xF661, 0xFCB6 },
 { 0xD51F, 0xEEF4, 0x01D5, 0x01A4 }, { 0xD320, 0xE504, 0xFDF7, 0x037D },
 { 0xDA3B, 0xEA9A, 0xFCB6, 0x0151 }, { 0xD692, 0xEBAD, 0xFD88, 0xFAAF },
 { 0xD82A, 0xE774, 0x067E, 0x04FD }, { 0xD869, 0xEB54, 0x0983, 0x0DA5 },
 { 0xD4ED, 0xE65F, 0x028F, 0x0038 }, { 0xD51F, 0xEC5A, 0x0467, 0xFE9A },
 { 0xCE22, 0xF06E, 0x0544, 0xFEB1 }, { 0xC85C, 0xE1CD, 0x0108, 0x013D },
 { 0xC4EC, 0xD7BB, 0xFE04, 0x05A7 }, { 0xCDEB, 0xDE42, 0xFDA0, 0x0089 },
 { 0xCCEC, 0xDE0B, 0xF4DC, 0xFE51 }, { 0xD46C, 0xEA56, 0xF734, 0xF9C0 },
 { 0xDE0C, 0xE33A, 0xFCCD, 0xFB39 }, { 0xCF25, 0xD9A8, 0xF94E, 0xFF87 },
 { 0xD628, 0xE5F6, 0x0220, 0x0D15 }, { 0xCF52, 0xE8FE, 0xF645, 0xF6F2 },
 { 0xCF4C, 0xE3C6, 0x01B5, 0x00E8 }, { 0xD3DC, 0xEB96, 0x0814, 0x02AF },
 { 0xD126, 0xDF80, 0xFD8E, 0x0AA8 }, { 0xD042, 0xEA9C, 0x0476, 0x0012 },
 { 0xD7DB, 0xE046, 0xF68E, 0x07D3 }, { 0xCB96, 0xE81D, 0xF215, 0xF50E },
 { 0xC659, 0xD996, 0xFB25, 0x0015 }, { 0xCA7D, 0xE9DF, 0x05F5, 0x01FB },
 { 0xC073, 0xDAFC, 0xFD43, 0x00A3 }, { 0xCE7B, 0xEAC3, 0xFF09, 0xFC05 },
 { 0xD1CD, 0xEF39, 0xFF4B, 0xFB25 }, { 0xCDD1, 0xEE70, 0x0BA8, 0x0463 },
 { 0xC9DC, 0xE115, 0xFB72, 0xFDDD }, { 0xD00C, 0xE02F, 0xF70E, 0xFA09 },
 { 0xD367, 0xED22, 0x0BA7, 0x073E }, { 0xD1EF, 0xE88E, 0x048B, 0x0794 },
 { 0x2CB3, 0xECC8, 0xF35D, 0x0C4F }, { 0x2C24, 0xE628, 0xFA1E, 0x0497 },
 { 0x23EE, 0xEDEC, 0xF7F4, 0x0956 }, { 0x2924, 0xF045, 0xFD7D, 0x0390 },
 { 0x26AE, 0xF20B, 0xF9BA, 0x052F }, { 0x25B5, 0xF230, 0xF740, 0x074D },
 { 0x26DC, 0xEBCD, 0xFE59, 0x0A66 }, { 0x301C, 0xF05C, 0xF83B, 0x0119 },
 { 0x2F5D, 0xED40, 0xFB0F, 0xFF5D }, { 0x299A, 0xF5C7, 0xF6DF, 0x05B6 },
 { 0x26B5, 0xEC98, 0xF6B8, 0x0394 }, { 0x3290, 0xEDD9, 0xF85A, 0x01CC },
 { 0x32BC, 0xEB5D, 0xFB8B, 0x0029 }, { 0x3021, 0xF49D, 0xF1DB, 0x0401 },
 { 0x2CB9, 0xF4B2, 0xF558, 0x015F }, { 0x2F37, 0xF41F, 0xF82E, 0xFFE0 },
 { 0x2D26, 0xF041, 0xFAC1, 0xFE71 }, { 0x32B7, 0xF164, 0xF244, 0x04DD },
 { 0x2F43, 0xF62D, 0xF540, 0x00E1 }, { 0x30E3, 0xF277, 0xF573, 0x0226 },
 { 0x395B, 0xEC62, 0xEB68, 0x0BB4 }, { 0x2FE4, 0xF2C9, 0xFB41, 0xFDF0 },
 { 0x35F2, 0xEAD2, 0xF675, 0x048E }, { 0x346D, 0xEAFE, 0xF8A2, 0x02D1 },
 { 0x32A1, 0xEF5D, 0xF5DE, 0x031C }, { 0x2FEA, 0xF7C8, 0xED60, 0x0637 },
 { 0x34D3, 0xED9A, 0xF41B, 0x053E }, { 0x3095, 0xF7CD, 0xEA16, 0x0845 },
 { 0x2E4A, 0xF779, 0xF257, 0x0295 }, { 0x2FF3, 0xF0A0, 0xFDAB, 0xFD47 },
 { 0x30AB, 0xEB7B, 0xFDFB, 0xFDE0 }, { 0x3223, 0xF002, 0xFAD6, 0xFF58 },
 { 0x3818, 0xE9D3, 0xF317, 0x0743 }, { 0x3651, 0xEE38, 0xEF2B, 0x0845 },
 { 0x2D27, 0xF2AC, 0xF8C9, 0xFFAF }, { 0x3443, 0xF3A1, 0xE97C, 0x0ABA },
 { 0x2E86, 0xF99E, 0xEF0A, 0x041C }, { 0x3176, 0xED7A, 0x0047, 0xFC32 },
 { 0x3301, 0xF34A, 0xEEB8, 0x06A9 }, { 0x3AC6, 0xE9B6, 0xED0D, 0x0BCB },
 { 0x3752, 0xEFD2, 0xEA76, 0x0B1B }, { 0x31DC, 0xF8CB, 0xE5E4, 0x0B48 },
 { 0x3592, 0xF6BA, 0xE162, 0x0F11 }, { 0x33EF, 0xF981, 0xDF9B, 0x0FE9 },
 { 0x2730, 0xEFC8, 0xF2B5, 0x058D }, { 0x2ABE, 0xEAF6, 0xF752, 0x03B6 },
 { 0x2924, 0xE70F, 0xF92A, 0x0785 }, { 0x2821, 0xE8AC, 0xFA02, 0x0283 },
 { 0x296D, 0xED52, 0xF961, 0x001B }, { 0x2AEC, 0xEBDF, 0xFB9D, 0xFEAB },
 { 0x2D6D, 0xE904, 0xFBDC, 0x0030 }, { 0x28C9, 0xF033, 0xF681, 0x0137 },
 { 0x2A24, 0xF1F5, 0xEFB5, 0x070F }, { 0x2F4E, 0xE9CA, 0xF7B1, 0x03D0 },
 { 0x2DE2, 0xED5B, 0xF5B1, 0x037B }, { 0x2D15, 0xEB4D, 0xF429, 0x06C4 },
 { 0x2C98, 0xF601, 0xEB11, 0x0896 }, { 0x2D3F, 0xEB00, 0xFD40, 0x02A5 },
 { 0x28B0, 0xF372, 0xF244, 0x0368 }, { 0x25B3, 0xEAC5, 0xF9AE, 0x0CB7 },
 { 0x26F5, 0xEBF3, 0xFC1C, 0x0F53 }, { 0x2DBB, 0xEDDD, 0xFE52, 0xFCE4 },
 { 0x2AF2, 0xF56B, 0xF1FD, 0x08FE }, { 0x29DC, 0xEC02, 0xFD7B, 0x010E },
 { 0x3714, 0xD7B6, 0x0447, 0x05FB }, { 0x3290, 0xE08F, 0x0451, 0xFD1B },
 { 0x33DC, 0xE485, 0xFE01, 0x0112 }, { 0x36B8, 0xE3AA, 0xFEE5, 0x008B },
 { 0x2D4A, 0xE678, 0xFFA5, 0x0687 }, { 0x2DD4, 0xDE3B, 0x02EA, 0x000F },
 { 0x3915, 0xE453, 0xF9D6, 0x049F }, { 0x331B, 0xE7B0, 0xFD12, 0xFFFC },
 { 0x36A4, 0xE790, 0xF9C8, 0x0334 }, { 0x3956, 0xDE15, 0x01B9, 0x007E },
 { 0x3CD3, 0xDD58, 0xFDF7, 0x0473 }, { 0x3D1A, 0xDAC3, 0x0155, 0x02B9 },
 { 0x3E58, 0xDA8E, 0xFF58, 0x0461 }, { 0x3C68, 0xD801, 0x0599, 0xFFFF },
 { 0x3A56, 0xE131, 0xFBEA, 0x0438 }, { 0x3B94, 0xE232, 0xF895, 0x065C },
 { 0x3C7D, 0xDF40, 0xFB2E, 0x05CC }, { 0x3E5A, 0xDE42, 0xF8E9, 0x078B },
 { 0x4075, 0xD658, 0x018E, 0x048F }, { 0x3F12, 0xD85F, 0x019B, 0x0396 },
 { 0x38ED, 0xE2CD, 0xFD47, 0x0259 }, { 0x37DE, 0xE0C4, 0x001C, 0x0101 },
 { 0x39B1, 0xE578, 0xF712, 0x0626 }, { 0x3740, 0xE807, 0xF787, 0x04E9 },
 { 0x39B2, 0xE781, 0xF3D9, 0x078D }, { 0x371E, 0xDF88, 0x043B, 0xFDED },
 { 0x3B83, 0xE4B1, 0xF44F, 0x087E }, { 0x33A6, 0xE953, 0x0223, 0xFC85 },
 { 0x39CC, 0xDDC6, 0x04E6, 0xFF0A }, { 0x3EA8, 0xDC23, 0xFC13, 0x060F },
 { 0x4067, 0xD89A, 0xFE8B, 0x058C }, { 0x3AE5, 0xDAF9, 0x03C6, 0x0033 },
 { 0x32E2, 0xE6BC, 0x03A4, 0xFBC8 }, { 0x319F, 0xE7F8, 0xFFDF, 0xFDC3 },
 { 0x3D19, 0xE566, 0xEFE0, 0x0B3A }, { 0x33E2, 0xE207, 0x062F, 0xFAFD },
 { 0x3055, 0xE412, 0x05E8, 0xFC6B }, { 0x32C0, 0xE1B9, 0xFD5A, 0x030F },
 { 0x2A9B, 0xE536, 0xFEC7, 0x0A25 }, { 0x32E2, 0xDCFD, 0x007D, 0x0868 },
 { 0x31E2, 0xD926, 0x07A5, 0xFE07 }, { 0x30C2, 0xE53F, 0xFB0C, 0x0341 },
 { 0x35DE, 0xE7DB, 0xFF76, 0xFEE9 }, { 0x31A5, 0xDF42, 0x07FC, 0x00E3 },
 { 0x2FD4, 0xE61A, 0x00CB, 0xFE37 }, { 0x3781, 0xE560, 0xFBF8, 0x0278 },
 { 0x3B1E, 0xDFB5, 0xFEE0, 0x0280 }, { 0x3533, 0xE7F3, 0xFBBE, 0x0164 },
 { 0x36DC, 0xE30B, 0x02D5, 0xFE1C }, { 0x329E, 0xE1B7, 0x0A19, 0xF844 },
 { 0x3384, 0xDF34, 0x0902, 0xF9EA }, { 0x382B, 0xD904, 0x0854, 0xFD50 },
 { 0x37C3, 0xD97F, 0x048A, 0x00B3 }, { 0x357A, 0xDE38, 0x0655, 0xFC87 },
 { 0x2DFA, 0xE553, 0xFD16, 0x0116 }, { 0x31BC, 0xDFF6, 0x011E, 0x005A },
 { 0x353E, 0xD85E, 0x074B, 0xFF31 }, { 0x2F28, 0xDDDC, 0x0513, 0xFD7B },
 { 0x3234, 0xDAEC, 0x04CA, 0x003E }, { 0x2E10, 0xE32A, 0xFFCA, 0xFF8C },
 { 0x35D3, 0xDCCA, 0x01E7, 0x015F }, { 0x2EAF, 0xE1CF, 0x0079, 0x0342 },
 { 0x2EC2, 0xD9CB, 0x08E4, 0xFFFC }, { 0x3188, 0xE0D0, 0x0AE3, 0xFCED },
 { 0x33F4, 0xC768, 0x1908, 0xF879 }, { 0x3543, 0xC405, 0x23C1, 0xF3FF },
 { 0x3204, 0xCB02, 0x158D, 0xF9A7 }, { 0x40F0, 0xD59A, 0x069A, 0x001C },
 { 0x4FA3, 0xB79C, 0x1812, 0xFEFB }, { 0x4083, 0xCE9E, 0x0D40, 0xFDF9 },
 { 0x3DB8, 0xD4A9, 0x0867, 0xFF36 }, { 0x41B8, 0xD1F2, 0x0673, 0x0257 },
 { 0x44C4, 0xCC63, 0x0A03, 0x021A }, { 0x45E4, 0xC89F, 0x0DEA, 0x0093 },
 { 0x425B, 0xD379, 0x0365, 0x041C }, { 0x426B, 0xCF58, 0x098A, 0x0109 },
 { 0x5499, 0xAAD2, 0x23EE, 0xFB1E }, { 0x41B9, 0xCBE3, 0x0F8C, 0xFD52 },
 { 0x4475, 0xCE56, 0x075F, 0x0325 }, { 0x4023, 0xD4E6, 0x04C0, 0x0269 },
 { 0x51C3, 0xB21D, 0x1D2D, 0xFD54 }, { 0x4814, 0xC3E2, 0x11DD, 0xFF41 },
 { 0x39BA, 0xD8A3, 0x0B19, 0xFB47 }, { 0x43FA, 0xCBF9, 0x0BE2, 0x00A0 },
 { 0x4BA5, 0xB9FE, 0x1BAF, 0xFBDB }, { 0x3FAA, 0xD15B, 0x0AFA, 0xFEA1 },
 { 0x4A8F, 0xC0D0, 0x12A7, 0xFFAC }, { 0x4502, 0xCFFF, 0x03AA, 0x04C8 },
 { 0x4895, 0xC1EA, 0x140C, 0xFE52 }, { 0x4D6F, 0xBEB3, 0x102E, 0x0221 },
 { 0x4DF8, 0xB421, 0x20D0, 0xFA2C }, { 0x4A1D, 0xBE4F, 0x1712, 0xFDAE },
 { 0x4A87, 0xC3B9, 0x0DC8, 0x01F7 }, { 0x411B, 0xCF3B, 0x1173, 0xFAEA },
 { 0x4D4F, 0xBA7B, 0x1834, 0xFDEF }, { 0x4E25, 0xBB3A, 0x14EA, 0xFFEC },
 { 0x4E9B, 0xB759, 0x1AE6, 0xFD28 }, { 0x4A7C, 0xC62B, 0x095A, 0x0451 },
 { 0x386B, 0xCA65, 0x15FF, 0xF813 }, { 0x398A, 0xC869, 0x15FF, 0xFA56 },
 { 0x3ED9, 0xC1A9, 0x1C67, 0xF813 }, { 0x34A1, 0xD440, 0x0CA4, 0xFC64 },
 { 0x384D, 0xD56A, 0x092B, 0xFEF5 }, { 0x4502, 0xB71A, 0x2C75, 0xF258 },
 { 0x399D, 0xD4DE, 0x0CE9, 0xFEED }, { 0x3BC8, 0xD70A, 0x074D, 0xFF10 },
 { 0x39D9, 0xD0A2, 0x0D29, 0xFD98 }, { 0x4200, 0xBF4F, 0x1C8B, 0xF8CB },
 { 0x3DA6, 0xC800, 0x1504, 0xFB10 }, { 0x400B, 0xC360, 0x190F, 0xF9CC },
 { 0x3571, 0xD496, 0x0A18, 0xFEC0 }, { 0x37A4, 0xCFDA, 0x1180, 0xF9A0 },
 { 0x3B8F, 0xCCC1, 0x10A9, 0xFC7E }, { 0x36A3, 0xD0C5, 0x0D8D, 0xFDAB },
 { 0x3675, 0xCE1E, 0x1090, 0xFCB9 }, { 0x35CB, 0xCAC5, 0x1484, 0xFA98 },
 { 0x3AA2, 0xC136, 0x1DA8, 0xF737 }, { 0x3DEC, 0xBCB6, 0x21AB, 0xF5A1 },
 { 0x49E9, 0xBDEC, 0x1ADB, 0xFA23 }, { 0x3A3D, 0xD262, 0x0AD0, 0xFED9 },
 { 0x4A2C, 0xB84F, 0x20E8, 0xF7EA }, { 0x3C61, 0xC518, 0x184A, 0xFA17 },
 { 0x3A44, 0xC368, 0x1B25, 0xF8A5 }, { 0x46BC, 0xC692, 0x1249, 0xFD43 },
 { 0x44C0, 0xC28B, 0x15F0, 0xFCF9 }, { 0x36F6, 0xCA8D, 0x1948, 0xF5BE },
 { 0x3608, 0xD176, 0x1451, 0xF748 }, { 0x499E, 0xB5BF, 0x23E8, 0xF857 },
 { 0xD133, 0xD50E, 0xE74C, 0xF728 }, { 0xD520, 0xDCA9, 0xE66E, 0xF10C },
 { 0xD3E8, 0xD6DC, 0xE49A, 0xEFA1 }, { 0xD865, 0xD833, 0xE189, 0xF580 },
 { 0xD6C5, 0xD8FC, 0xDC23, 0xF808 }, { 0xD2B4, 0xD3B5, 0xD8DA, 0xF56D },
 { 0xCBA8, 0xCBAD, 0xD3D6, 0xEF92 }, { 0xD9D2, 0xD007, 0xE2D6, 0xEFDB },
 { 0xD5A6, 0xCCBB, 0xDDB7, 0xECA4 }, { 0xD144, 0xC516, 0xD9CD, 0xEC19 },
 { 0xDB5A, 0xD834, 0xDCA3, 0xECC1 }, { 0xD2D6, 0xD3E0, 0xF1BD, 0xFC27 },
 { 0xDBB9, 0xD89D, 0xE112, 0xF01B }, { 0xCDEB, 0xBF54, 0xD36E, 0xE7CD },
 { 0xCEAC, 0xDD01, 0xEE57, 0xFBA7 }, { 0xC9EB, 0xD2C3, 0xF1BF, 0xFD57 },
 { 0xCE73, 0xD7E3, 0xEA95, 0xFB05 }, { 0xC574, 0xCDB6, 0xEC0D, 0xFB5B },
 { 0xCA3F, 0xD399, 0xE7C6, 0xF8F4 }, { 0xCC57, 0xD40F, 0xE174, 0xF2E6 },
 { 0xC627, 0xD128, 0xF37E, 0xFEC8 }, { 0xC2FC, 0xC361, 0xD81E, 0xF297 },
 { 0xCD66, 0xD828, 0xF3BD, 0xFD9D }, { 0xD2F0, 0xD903, 0xEB5C, 0xFC65 },
 { 0xCD16, 0xCF7F, 0xEDFC, 0xFBB6 }, { 0xBDF1, 0xC36F, 0xE815, 0xFAB8 },
 { 0xBC0C, 0xBAEB, 0xDF76, 0xF785 }, { 0xC8D8, 0xD5F4, 0xF727, 0xFF9D },
 { 0xCECA, 0xE339, 0xEAE2, 0xF236 }, { 0xC8C1, 0xCE07, 0xD563, 0xEB96 },
 { 0xC69C, 0xBE19, 0xD296, 0xEA4E }, { 0xCEDB, 0xD443, 0xDC16, 0xF103 },
 { 0xBE90, 0xBEAA, 0xD9EE, 0xF508 }, { 0xD698, 0xD78A, 0xE660, 0xFB35 },
 { 0xC713, 0xCC00, 0xDD03, 0xF2BF }, { 0xD844, 0xDEF1, 0xDE7D, 0xF2C5 },
 { 0xD366, 0xCF7B, 0xEA6E, 0xF8CE }, { 0xD1B1, 0xC884, 0xE5F3, 0xF5BF },
 { 0xCC04, 0xE001, 0xF09B, 0xF76E }, { 0xD8E9, 0xD016, 0xEC62, 0xF8ED },
 { 0xCB24, 0xC265, 0xDAE7, 0xF399 }, { 0xD210, 0xD474, 0xD79D, 0xEA67 },
 { 0xD08B, 0xCE25, 0xD442, 0xF18F }, { 0xD103, 0xD0A9, 0xDE95, 0xF900 },
 { 0xBD9D, 0xB20B, 0xD349, 0xF271 }, { 0xCCA8, 0xC758, 0xD8FC, 0xF389 },
 { 0xD92E, 0xD4C8, 0xE805, 0xF3A6 }, { 0xDD57, 0xD2E2, 0xDF9A, 0xE66A },
 { 0xDBA9, 0xCD2E, 0xE7FA, 0xF569 }, { 0xC399, 0xD71B, 0xF91A, 0xFF56 },
 { 0xC18F, 0xD253, 0xF441, 0xFD76 }, { 0xBD0A, 0xD651, 0xFA66, 0x002F },
 { 0xC141, 0xC9DE, 0xED2F, 0xFBDE }, { 0xB40A, 0xB371, 0xDA86, 0xF660 },
 { 0xB194, 0xB6C8, 0xDF87, 0xF89F }, { 0xC539, 0xC12B, 0xE25A, 0xF736 },
 { 0xCB57, 0xC0BD, 0xDE98, 0xF44A }, { 0xC9FB, 0xC5EB, 0xE5D0, 0xF874 },
 { 0xC01B, 0xB7CC, 0xD9B6, 0xF471 }, { 0xD6C9, 0xDF37, 0xDBA9, 0xEC32 },
 { 0xD3AF, 0xDC3C, 0xE9F7, 0xF3DD }, { 0xCC5F, 0xCB77, 0xDBCA, 0xEE43 },
 { 0xD12C, 0xCA5C, 0xD8F5, 0xE71A }, { 0xD501, 0xDAD1, 0xEBD0, 0xEFF5 },
 { 0x26CA, 0xE14E, 0x1F7D, 0xEEE9 }, { 0x2052, 0xE145, 0x1768, 0xF7D0 },
 { 0x25DC, 0xDA35, 0x1DC5, 0xF1AA }, { 0x2575, 0xE052, 0x196D, 0xF43E },
 { 0x3149, 0xD138, 0x278A, 0xEB10 }, { 0x2E5B, 0xDD41, 0x1F0C, 0xEB35 },
 { 0x2894, 0xD70E, 0x2412, 0xEF1C }, { 0x1FFC, 0xDFE4, 0x1E82, 0xF54F },
 { 0x28A7, 0xDDAD, 0x12C6, 0xF876 }, { 0x286C, 0xDD73, 0x2411, 0xE62A },
 { 0x24CE, 0xE44D, 0x12D4, 0xF4C2 }, { 0x261E, 0xD9BC, 0x15D0, 0xF730 },
 { 0x27CC, 0xE0C6, 0x14E3, 0xF2F1 }, { 0x2B7D, 0xE2E1, 0x0FAF, 0xF6FE },
 { 0x29B4, 0xD608, 0x17CD, 0xF5BB }, { 0x2D02, 0xD068, 0x1EA8, 0xF2D1 },
 { 0x2265, 0xD965, 0x14C5, 0xF401 }, { 0x251A, 0xDA4A, 0x199B, 0xF1F8 },
 { 0x28F8, 0xE0B8, 0x0FE2, 0xFB1C }, { 0x2BFD, 0xDD1E, 0x17B4, 0xF54E },
 { 0x2F94, 0xD763, 0x13A3, 0xFA05 }, { 0x23B2, 0xDEAD, 0x0E11, 0xF859 },
 { 0x1FAB, 0xDF44, 0x136A, 0xF7F3 }, { 0x2609, 0xCC40, 0x1926, 0xF5C7 },
 { 0x2BAA, 0xD749, 0x0A3E, 0xFDF6 }, { 0x2564, 0xCFAC, 0x144F, 0xF81D },
 { 0x2F19, 0xD090, 0x1033, 0xFBB5 }, { 0x2357, 0xD93B, 0x09D4, 0xFD67 },
 { 0x2A26, 0xE0A2, 0x16FA, 0xEEDE }, { 0x1C1F, 0xDF16, 0x18C1, 0xF4E7 },
 { 0x1E62, 0xDFA3, 0x0DC9, 0xF28E }, { 0x1D87, 0xD6B7, 0x0D9C, 0xFACC },
 { 0x24BC, 0xE04D, 0x1D3C, 0xEA5B }, { 0x1E70, 0xD138, 0x15AA, 0xF5F3 },
 { 0x2461, 0xD7E8, 0x1DED, 0xEBB5 }, { 0x1A2D, 0xD61B, 0x1112, 0xF908 },
 { 0x1336, 0xD39F, 0x119B, 0xEE51 }, { 0x141B, 0xCFEF, 0x0F8A, 0xEA4C },
 { 0x197D, 0xD955, 0x1181, 0xF3C7 }, { 0x1D72, 0xCDC9, 0x17AC, 0xED26 },
 { 0x21D3, 0xD0B1, 0x1BF7, 0xEEB2 }, { 0x20F8, 0xD3D8, 0x11C3, 0xF92D },
 { 0x2400, 0xD55A, 0x0DB3, 0xFB55 }, { 0x1815, 0xDBDA, 0x12A3, 0xEDBB },
 { 0x23CB, 0xD4F5, 0x1605, 0xECB9 }, { 0x3481, 0xD30B, 0x1A14, 0xF67E },
 { 0x1EE8, 0xDB4A, 0x1A07, 0xF030 }, { 0x2DCB, 0xCA4F, 0x1FC3, 0xEFCC },
 { 0x17B1, 0xD7EF, 0x138D, 0xE749 }, { 0x2D62, 0xCF7F, 0x14D8, 0xF89A },
 { 0x22BB, 0xC99C, 0x20D7, 0xE80D }, { 0x2596, 0xCEED, 0x1EE4, 0xEC0B },
 { 0x2CD7, 0xD7B5, 0x209D, 0xF069 }, { 0x2D9C, 0xC8E9, 0x19D3, 0xF6E6 },
 { 0x2EAF, 0xDD07, 0x0EF5, 0xF9F2 }, { 0x28F6, 0xE094, 0x28FD, 0xE8E0 },
 { 0x2E19, 0xD5EF, 0x2623, 0xEB47 }, { 0x17DD, 0xDE1C, 0x16C3, 0xFABE },
 { 0x1B76, 0xDA75, 0x15F8, 0xE97F }, { 0x3208, 0xCDAA, 0x21EB, 0xEFCC },
 { 0x339D, 0xD720, 0x18ED, 0xF38B }, { 0x2E14, 0xCA8F, 0x29CF, 0xE845 },
 { 0x25A7, 0xE0F3, 0x2599, 0xF098 }, { 0x215A, 0xE4AB, 0x14BD, 0x01C5 }
};

static const unsigned int s_FIR32Bands[ 1024 ] __attribute__(   (  section( ".data" ), aligned( 16 )  )   ) = {
 0x2EF9CE48, 0xB521A9F3, 0x3582C489, 0x2E9A582B,
 0xB531EC97, 0x3591A826, 0xB28A2928, 0xB53B721D,
 0x359C15F2, 0xB35A5335, 0xB53C7588, 0x35A0573F,
 0xB425B62E, 0xB535AC3D, 0x359E4463, 0xB4D4B50F,
 0xB5281A82, 0x358AB445, 0xB5451790, 0xB5155C7B,
 0x357DB7D8, 0xB4D523B0, 0x353BFF76, 0x36048FD0,
 0xB4FE89B1, 0x356205A4, 0x359FC750, 0x350C8312,
 0x33897F05, 0xB5C55EB3, 0x34585308, 0xB30B6D0E,
 0xB5F8C8EA, 0x33A84017, 0xB323A229, 0x35413855,
 0x33B51EED, 0x364F27D0, 0xB0383BFF, 0x338A3FC0,
 0x36CC2B93, 0xB0DDBA70, 0x359FA0A0, 0x37206882,
 0xB1385ABA, 0x362795D0, 0x375BB881, 0xB1699C84,
 0x3672BE2F, 0x37BDDD2D, 0x3261D030, 0x3653E104,
 0x37EED82B, 0x3200F6D3, 0x361BAA9E, 0x380F42FD,
 0x32EF8CCC, 0x37040688, 0x38258602, 0x341B25A1,
 0x3724DC48, 0x3839A0FC, 0x34A82B31, 0x37457C6E,
 0x384AF953, 0x35BBE0B3, 0x37676EDB, 0x385921F6,
 0x36085F86, 0x3783D22C, 0x3863BCE6, 0x36363395,
 0x37923A92, 0x386AB170, 0x3667C887, 0x379E0F10,
 0x36A4F772, 0x368CC31A, 0x37A6B081, 0x371C0516,
 0x36A44C91, 0x37AB6073, 0x37638811, 0x36B9195B,
 0xB803E379, 0x3792F50A, 0x36C9D683, 0xB80BE0B9,
 0x37AFA6F3, 0x36D5742D, 0xB811242F, 0x37C62F5C,
 0x370655BE, 0xB81377D8, 0x37D4D385, 0x3707B08C,
 0xB8129B69, 0x37DBA00D, 0x37053BE2, 0xB80E842D,
 0x37D648AC, 0x36FDF7CA, 0xB80748F7, 0x37FD3B2B,
 0x36EA6CB8, 0xB7F9E567, 0x37D7A839, 0x36D0E097,
 0xB7E09667, 0x37A6875C, 0x36B25F8D, 0xB7979333,
 0x3747DFC7, 0x3694A05C, 0xB7950827, 0x36297DD3,
 0x365FA5A2, 0xB78B6749, 0xB77F38D2, 0x35623772,
 0xB74A8066, 0xB787B4F2, 0x34E9151B, 0xB6EAA81F,
 0x37A7278A, 0x33CB1F2F, 0xB5173B98, 0x3794DF72,
 0x32FF9091, 0xB58603FA, 0x3841F773, 0x386B5264,
 0xBA1632D3, 0x39DE87EE, 0x3889BDB0, 0xBA26B159,
 0x396752E2, 0x389D9309, 0xBA38132D, 0xB491FF53,
 0x38B072A8, 0xBA49CEB9, 0xB979DF99, 0x38B7A8B7,
 0xBA5BD128, 0xBA015EF0, 0x38C796E3, 0xBA6DFFDB,
 0xBA48C5A9, 0x38D60DC5, 0xBA801FE8, 0xBA8A5430,
 0x38E36C59, 0xBA8939A9, 0xBAB275F3, 0x38EF328E,
 0xBA923D43, 0xBADCCA30, 0x38F91F73, 0xBA9B1B56,
 0xBB04A2F9, 0x390072C7, 0xBAA435FE, 0xBB1BEDEF,
 0x3903196B, 0xBAAC8405, 0xBB343EAA, 0x39045549,
 0xBAB46E16, 0xBB4D8C9E, 0x39009B96, 0xBABBDF0C,
 0xBB67CE0A, 0x38FE815A, 0xBAC2C1C1, 0xBB817BEB,
 0x38F7AB63, 0xBAC90066, 0xBB8F7F04, 0x38EC3270,
 0xBACE84B2, 0xBB9DE93A, 0x38DB9D80, 0xBAD3378D,
 0xBBACB46D, 0x38C57DAC, 0xBAD7025C, 0xBBBBD6CC,
 0x38A96A85, 0xBAD9BF95, 0xBBCB4A77, 0x388735A1,
 0xBADB7B55, 0xBBDB04A2, 0x383C6372, 0xBADBFE4A,
 0xBBEAF25E, 0x37CF41F8, 0xBADB41CD, 0xBBFB22D4,
 0xB5E614EA, 0xBAD91EF4, 0xBC05BD19, 0xB805EFE1,
 0xBAD62BBD, 0xBC0DF7A7, 0xB88930B6, 0xBAD0DB4A,
 0xBC164001, 0xB8D6C8FB, 0x3ACA1FA4, 0xBC1E8A23,
 0xB9099833, 0x3AC1E626, 0xBC26D33D, 0xB93A0781,
 0x3AB6E9EF, 0xBC2F159C, 0xB96A3932, 0x3AAACD58,
 0xBC374C08, 0xB98C9E5A, 0x3A9CC8FD, 0xBC3F70CE,
 0xB9AF832C, 0x3A8CBD51, 0xBC477C41, 0xB9CCCFE9,
 0x3A7556EE, 0xBC4F6955, 0xB9EB6B88, 0x3A4CECCF,
 0xBC573205, 0xBA05B10D, 0x3A204787, 0xBC5ED064,
 0xBC663E94, 0x3C80D157, 0x3A015EF0, 0xBC6D76C9,
 0x3C7B2EB1, 0x3979DF99, 0xBC747356, 0x3C747356,
 0x3491FF53, 0xBC7B2EB1, 0x3C6D76C9, 0xB96752E2,
 0xBC80D157, 0x3C663E94, 0xB9DE87EE, 0xBC83E5DF,
 0x3C5ED064, 0xBA204787, 0xBC86D202, 0x3C573205,
 0xBA4CECCF, 0xBC899364, 0x3C4F6955, 0xBA7556EE,
 0xBC8C27C1, 0x3C477C41, 0xBA8CBD51, 0xBC8E8CF8,
 0x3C3F70CE, 0xBA9CC8FD, 0xBC90C10B, 0x3C374C08,
 0xBAAACD58, 0xBC92C226, 0x3C2F159C, 0xBAB6E9EF,
 0xBC948E95, 0x3C26D33D, 0xBAC1E626, 0xBC96250C,
 0x3C1E8A23, 0xBACA1FA4, 0xBC9783CA, 0x3C164001,
 0x3AD0DB4A, 0xBC98A9D7, 0x3C0DF7A7, 0x3AD62BBD,
 0xBC99962E, 0x3C05BD19, 0x3AD91EF4, 0xBC9A4839,
 0x3BFB22D4, 0x3ADB41CD, 0xBC9ABFC2, 0x3BEAF25E,
 0x3ADBFE4A, 0xBC9AFB33, 0x3BDB04A2, 0x3ADB7B55,
 0x3C9AFB33, 0x3BCB4A77, 0x3AD9BF95, 0x3C9ABFC2,
 0x3BBBD6CC, 0x3AD7025C, 0x3C9A4839, 0x3BACB46D,
 0x3AD3378D, 0x3C99962E, 0x3B9DE93A, 0x3ACE84B2,
 0x3C98A9D7, 0x3B8F7F04, 0x3AC90066, 0x3C9783CA,
 0x3B817BEB, 0x3AC2C1C1, 0x3C96250C, 0x3B67CE0A,
 0x3ABBDF0C, 0x3C948E95, 0x3B4D8C9E, 0x3AB46E16,
 0x3C92C226, 0x3B343EAA, 0x3AAC8405, 0x3C90C10B,
 0x3B1BEDEF, 0x3AA435FE, 0x3C8E8CF8, 0x3B04A2F9,
 0x3A9B1B56, 0x3C8C27C1, 0x3ADCCA30, 0x3A923D43,
 0x3C899364, 0x3AB275F3, 0x3A8939A9, 0x3C86D202,
 0x3A8A5430, 0x3A801FE8, 0x3C83E5DF, 0x3A48C5A9,
 0x3A6DFFDB, 0x3A5BD128, 0xB8B7A8B7, 0xB6CC2B93,
 0x3A49CEB9, 0xB8B072A8, 0xB64F27D0, 0x3A38132D,
 0xB89D9309, 0xB5413855, 0x3A26B159, 0xB889BDB0,
 0x35F8C8EA, 0x3A1632D3, 0xB86B5264, 0x35C55EB3,
 0x3A05B10D, 0xB841F773, 0x358603FA, 0x39EB6B88,
 0xB794DF72, 0x35173B98, 0x39CCCFE9, 0xB7A7278A,
 0x36EAA81F, 0x39AF832C, 0x3787B4F2, 0x374A8066,
 0x398C9E5A, 0x377F38D2, 0x378B6749, 0x396A3932,
 0xB6297DD3, 0x37950827, 0x393A0781, 0xB747DFC7,
 0x37979333, 0x39099833, 0xB7A6875C, 0x37E09667,
 0x38D6C8FB, 0xB7D7A839, 0x37F9E567, 0x388930B6,
 0xB7FD3B2B, 0x380748F7, 0x3805EFE1, 0xB7D648AC,
 0x380E842D, 0x35E614EA, 0xB7DBA00D, 0x38129B69,
 0xB7CF41F8, 0xB7D4D385, 0x381377D8, 0xB83C6372,
 0xB7C62F5C, 0x3811242F, 0xB88735A1, 0xB7AFA6F3,
 0x380BE0B9, 0xB8A96A85, 0xB792F50A, 0x3803E379,
 0xB8C57DAC, 0xB7638811, 0xB7AB6073, 0xB8DB9D80,
 0xB71C0516, 0xB7A6B081, 0xB8EC3270, 0xB6A4F772,
 0xB79E0F10, 0xB8F7AB63, 0xB86AB170, 0xB7923A92,
 0xB8FE815A, 0xB863BCE6, 0xB783D22C, 0xB9009B96,
 0xB85921F6, 0xB7676EDB, 0xB9045549, 0xB84AF953,
 0xB7457C6E, 0xB903196B, 0xB839A0FC, 0xB724DC48,
 0xB90072C7, 0xB8258602, 0xB7040688, 0xB8F91F73,
 0xB80F42FD, 0xB61BAA9E, 0xB8EF328E, 0xB7EED82B,
 0xB653E104, 0xB8E36C59, 0xB7BDDD2D, 0xB672BE2F,
 0xB8D60DC5, 0xB75BB881, 0xB62795D0, 0xB8C796E3,
 0xB7206882, 0xB59FA0A0, 0xB38A3FC0, 0xB68CC31A,
 0xB5A0573F, 0xB3B51EED, 0xB667C887, 0xB59C15F2,
 0x3323A229, 0xB6363395, 0xB591A826, 0x330B6D0E,
 0xB6085F86, 0xB582C489, 0xB3897F05, 0xB5BBE0B3,
 0xB56205A4, 0xB2FF9091, 0xB4A82B31, 0xB53BFF76,
 0xB3CB1F2F, 0xB41B25A1, 0x35155C7B, 0xB4E9151B,
 0xB2EF8CCC, 0x35281A82, 0xB5623772, 0xB200F6D3,
 0x3535AC3D, 0xB65FA5A2, 0xB261D030, 0x353C7588,
 0xB694A05C, 0x31699C84, 0x353B721D, 0xB6B25F8D,
 0x31385ABA, 0x3531EC97, 0xB6D0E097, 0x30DDBA70,
 0x3521A9F3, 0xB6EA6CB8, 0x30383BFF, 0x34FE89B1,
 0xB6FDF7CA, 0xB3A84017, 0x34D523B0, 0xB7053BE2,
 0xB4585308, 0x35451790, 0xB707B08C, 0xB50C8312,
 0x34D4B50F, 0xB70655BE, 0xB59FC750, 0x3425B62E,
 0xB6D5742D, 0xB6048FD0, 0x335A5335, 0xB6C9D683,
 0xB57DB7D8, 0x328A2928, 0xB6B9195B, 0xB58AB445,
 0xAE9A582B, 0xB6A44C91, 0xB59E4463, 0xAEF9CE48,
 0xB415454D, 0xB435DD22, 0xB45A0AD7, 0xB481139A,
 0xB4974C45, 0xB4AFEA79, 0xB4CB313D, 0xB4E96C78,
 0xB5057939, 0xB518126A, 0xB52CB859, 0xB543A7D6,
 0xB55D243C, 0xB57977E0, 0xB58C7A2D, 0xB59DF966,
 0xB5B16A19, 0xB5C70089, 0xB5DEF504, 0xB5F983EC,
 0xB60B76B8, 0xB61BBAC3, 0xB62DB1ED, 0xB64181A6,
 0xB65750E8, 0xB66F480B, 0xB684C845, 0xB6932A6A,
 0xB6A2DFFA, 0xB6B3FE94, 0xB6C69BC6, 0xB6DACCDE,
 0xB6F0A6B5, 0xB7041EB3, 0xB710D201, 0xB71E762F,
 0xB72D135B, 0xB73CB0AD, 0xB74D542F, 0xB75F0298,
 0xB771BF1F, 0xB782C5A5, 0xB78D335D, 0xB798277F,
 0xB7A39FA8, 0xB7AF9836, 0xB7BC0C2D, 0xB7C8F518,
 0xB7D64AF4, 0xB7E40414, 0xB7F21509, 0xB8003846,
 0xB80783B3, 0xB80EE42C, 0xB816500C, 0xB81DBC95,
 0xB8251DF6, 0xB82C6738, 0xB8338A46, 0xB83A77E4,
 0xB8411FB2, 0xB847702D, 0xB84D56B2, 0xB852BF87,
 0x385795E0, 0x385BC3E8, 0x385F32D9, 0x3861CB00,
 0x386373DA, 0x38641425, 0x386391FC, 0x3861D2F2,
 0x385EBC2F, 0x385A3296, 0x38541AE7, 0x384C59E9,
 0x3842D493, 0x38377039, 0x382A12C0, 0x381AA2CF,
 0x38090801, 0x37EA564A, 0x37BDECDF, 0x378CAB73,
 0x372CDAF3, 0x365894B5, 0xB6960273, 0xB756C531,
 0xB7B6A3E3, 0xB803A766, 0xB82EB373, 0xB85C7443,
 0xB8867211, 0xB89FFCA1, 0xB8BAD2C1, 0xB8D6EB1A,
 0xB8F439F4, 0xB9095890, 0xB9191FEF, 0xB9296966,
 0xB93A29E8, 0xB94B5508, 0xB95CDCEE, 0xB96EB257,
 0xB9806248, 0xB98980BA, 0xB992AABA, 0xB99BD5C6,
 0xB9A4F6AC, 0xB9AE0188, 0xB9B6E9CC, 0xB9BFA245,
 0xB9C81D21, 0xB9D04BFA, 0xB9D81FDD, 0xB9DF8957,
 0xB9E67880, 0xB9ECDD07, 0xB9F2A646, 0xB9F7C34F,
 0xB9FC22F6, 0xB9FFB3F3, 0xBA013274, 0xBA02123D,
 0xBA027100, 0xBA0245A1, 0xBA018806, 0xBA002FF8,
 0x39FC6B06, 0x39F721ED, 0x39F075F8, 0x39E85949,
 0x39DEBEE3, 0x39D39AC8, 0x39C6E21C, 0x39B88B39,
 0x39A88DCF, 0x3996E2FC, 0x3983856E, 0x395CE2F0,
 0x392F4A59, 0x38FC81E5, 0x389394F7, 0x378F7639,
 0xB8251871, 0xB8CF876F, 0xB929750B, 0xB96E405D,
 0xB99B039D, 0xB9C0531B, 0xB9E6FA7A, 0xBA077181,
 0xBA1BF9B5, 0xBA3107F1, 0xBA468CFD, 0xBA5C7860,
 0xBA72B855, 0xBA849CEB, 0xBA8FF451, 0xBA9B579E,
 0xBAA6BB80, 0xBAB2140F, 0xBABD54D9, 0xBAC870E3,
 0xBAD35AB5, 0xBADE045D, 0xBAE85F7D, 0xBAF25D51,
 0xBAFBEEB9, 0xBB028224, 0xBB06C723, 0xBB0ABE65,
 0xBB0E5FDE, 0xBB11A372, 0xBB1480FE, 0xBB16F05E,
 0xBB18E975, 0xBB1A6432, 0xBB1B589D, 0xBB1BBED8,
 0xBB1B8F31, 0xBB1AC21D, 0xBB19504C, 0xBB1732AB,
 0xBB14626F, 0xBB10D91A, 0xBB0C9087, 0xBB0782EF,
 0xBB01AAF1, 0xBAF60738, 0xBAE710EB, 0xBAD66AFD,
 0x3AC40E79, 0x3AAFF57E, 0x3A9A1B50, 0x3A827C5B,
 0x3A522C90, 0x3A1BCFFD, 0x39C3C6C5, 0x3911A733,
 0xB8E4B83A, 0xB9C22D3A, 0xBA2909B1, 0xBA746233,
 0xBAA1879D, 0xBACA7E8B, 0xBAF50A9A, 0xBB108F8F,
 0xBB275702, 0xBB3ED3ED, 0xBB56FDE7, 0xBB6FCBE2,
 0xBB849A12, 0xBB91962B, 0xBB9ED4C4, 0xBBAC5017,
 0xBBBA0217, 0xBBC7E478, 0xBBD5F0A9, 0xBBE41FE0,
 0xBBF26B1C, 0xBC006595, 0xBC079C53, 0xBC0ED606,
 0xBC160ED7, 0xBC1D42E2, 0xBC246E38, 0xBC2B8CDF,
 0xBC329ADA, 0xBC39942A, 0xBC4074CD, 0xBC4738C8,
 0xBC4DDC25, 0xBC545AF8, 0xBC5AB165, 0xBC60DB9D,
 0xBC66D5E6, 0xBC6C9C9A, 0xBC722C32, 0xBC77813E,
 0xBC7C9870, 0xBC80B74E, 0xBC83005C, 0xBC8525F3,
 0xBC8726B8, 0xBC890163, 0xBC8AB4C9, 0xBC8C3FD2,
 0xBC8DA182, 0xBC8ED8F5, 0xBC8FE563, 0xBC90C623,
 0xBC917A9B, 0xBC92025C, 0xBC925D0E, 0xBC928A76,
 0x3C928A76, 0x3C925D0E, 0x3C92025C, 0x3C917A9B,
 0x3C90C623, 0x3C8FE563, 0x3C8ED8F5, 0x3C8DA182,
 0x3C8C3FD2, 0x3C8AB4C9, 0x3C890163, 0x3C8726B8,
 0x3C8525F3, 0x3C83005C, 0x3C80B74E, 0x3C7C9870,
 0x3C77813E, 0x3C722C32, 0x3C6C9C9A, 0x3C66D5E6,
 0x3C60DB9D, 0x3C5AB165, 0x3C545AF8, 0x3C4DDC25,
 0x3C4738C8, 0x3C4074CD, 0x3C39942A, 0x3C329ADA,
 0x3C2B8CDF, 0x3C246E38, 0x3C1D42E2, 0x3C160ED7,
 0x3C0ED606, 0x3C079C53, 0x3C006595, 0x3BF26B1C,
 0x3BE41FE0, 0x3BD5F0A9, 0x3BC7E478, 0x3BBA0217,
 0x3BAC5017, 0x3B9ED4C4, 0x3B91962B, 0x3B849A12,
 0x3B6FCBE2, 0x3B56FDE7, 0x3B3ED3ED, 0x3B275702,
 0x3B108F8F, 0x3AF50A9A, 0x3ACA7E8B, 0x3AA1879D,
 0x3A746233, 0x3A2909B1, 0x39C22D3A, 0x38E4B83A,
 0xB911A733, 0xB9C3C6C5, 0xBA1BCFFD, 0xBA522C90,
 0xBA827C5B, 0xBA9A1B50, 0xBAAFF57E, 0xBAC40E79,
 0x3AD66AFD, 0x3AE710EB, 0x3AF60738, 0x3B01AAF1,
 0x3B0782EF, 0x3B0C9087, 0x3B10D91A, 0x3B14626F,
 0x3B1732AB, 0x3B19504C, 0x3B1AC21D, 0x3B1B8F31,
 0x3B1BBED8, 0x3B1B589D, 0x3B1A6432, 0x3B18E975,
 0x3B16F05E, 0x3B1480FE, 0x3B11A372, 0x3B0E5FDE,
 0x3B0ABE65, 0x3B06C723, 0x3B028224, 0x3AFBEEB9,
 0x3AF25D51, 0x3AE85F7D, 0x3ADE045D, 0x3AD35AB5,
 0x3AC870E3, 0x3ABD54D9, 0x3AB2140F, 0x3AA6BB80,
 0x3A9B579E, 0x3A8FF451, 0x3A849CEB, 0x3A72B855,
 0x3A5C7860, 0x3A468CFD, 0x3A3107F1, 0x3A1BF9B5,
 0x3A077181, 0x39E6FA7A, 0x39C0531B, 0x399B039D,
 0x396E405D, 0x3929750B, 0x38CF876F, 0x38251871,
 0xB78F7639, 0xB89394F7, 0xB8FC81E5, 0xB92F4A59,
 0xB95CE2F0, 0xB983856E, 0xB996E2FC, 0xB9A88DCF,
 0xB9B88B39, 0xB9C6E21C, 0xB9D39AC8, 0xB9DEBEE3,
 0xB9E85949, 0xB9F075F8, 0xB9F721ED, 0xB9FC6B06,
 0x3A002FF8, 0x3A018806, 0x3A0245A1, 0x3A027100,
 0x3A02123D, 0x3A013274, 0x39FFB3F3, 0x39FC22F6,
 0x39F7C34F, 0x39F2A646, 0x39ECDD07, 0x39E67880,
 0x39DF8957, 0x39D81FDD, 0x39D04BFA, 0x39C81D21,
 0x39BFA245, 0x39B6E9CC, 0x39AE0188, 0x39A4F6AC,
 0x399BD5C6, 0x3992AABA, 0x398980BA, 0x39806248,
 0x396EB257, 0x395CDCEE, 0x394B5508, 0x393A29E8,
 0x39296966, 0x39191FEF, 0x39095890, 0x38F439F4,
 0x38D6EB1A, 0x38BAD2C1, 0x389FFCA1, 0x38867211,
 0x385C7443, 0x382EB373, 0x3803A766, 0x37B6A3E3,
 0x3756C531, 0x36960273, 0xB65894B5, 0xB72CDAF3,
 0xB78CAB73, 0xB7BDECDF, 0xB7EA564A, 0xB8090801,
 0xB81AA2CF, 0xB82A12C0, 0xB8377039, 0xB842D493,
 0xB84C59E9, 0xB8541AE7, 0xB85A3296, 0xB85EBC2F,
 0xB861D2F2, 0xB86391FC, 0xB8641425, 0xB86373DA,
 0xB861CB00, 0xB85F32D9, 0xB85BC3E8, 0xB85795E0,
 0x3852BF87, 0x384D56B2, 0x3847702D, 0x38411FB2,
 0x383A77E4, 0x38338A46, 0x382C6738, 0x38251DF6,
 0x381DBC95, 0x3816500C, 0x380EE42C, 0x380783B3,
 0x38003846, 0x37F21509, 0x37E40414, 0x37D64AF4,
 0x37C8F518, 0x37BC0C2D, 0x37AF9836, 0x37A39FA8,
 0x3798277F, 0x378D335D, 0x3782C5A5, 0x3771BF1F,
 0x375F0298, 0x374D542F, 0x373CB0AD, 0x372D135B,
 0x371E762F, 0x3710D201, 0x37041EB3, 0x36F0A6B5,
 0x36DACCDE, 0x36C69BC6, 0x36B3FE94, 0x36A2DFFA,
 0x36932A6A, 0x3684C845, 0x366F480B, 0x365750E8,
 0x364181A6, 0x362DB1ED, 0x361BBAC3, 0x360B76B8,
 0x35F983EC, 0x35DEF504, 0x35C70089, 0x35B16A19,
 0x359DF966, 0x358C7A2D, 0x357977E0, 0x355D243C,
 0x3543A7D6, 0x352CB859, 0x3518126A, 0x35057939,
 0x34E96C78, 0x34CB313D, 0x34AFEA79, 0x34974C45,
 0x3481139A, 0x345A0AD7, 0x3435DD22, 0x3415454D
};

static const unsigned int lfe_fir_64[ 512 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x398B60E7, 0x38AB88A2, 0x38C5F4FC, 0x38E2F293,
 0x39015410, 0x39128979, 0x3925404D, 0x393996FE,
 0x394FCCE4, 0x3967EDD3, 0x3980FCAA, 0x398EED4F,
 0x399E0363, 0x39AE80F8, 0x39BFD626, 0x39D2AC76,
 0x39E6C8F9, 0x39FC53FD, 0x3A09B0A9, 0x3A15FCF5,
 0x3A231C02, 0x3A31177F, 0x3A3FFF88, 0x3A4FD760,
 0x3A60A90A, 0x3A7283B3, 0x3A82BDC7, 0x3A8CC31F,
 0x3A976429, 0x3AA29E35, 0x3AAE7DA3, 0x3ABB069D,
 0x3AC84176, 0x3AD6330A, 0x3AE4E507, 0x3AF45E21,
 0x3B02533E, 0x3B0AE178, 0x3B13DF6F, 0x3B1D5097,
 0x3B273831, 0x3B319BD2, 0x3B3C7E78, 0x3B47E513,
 0x3B53D489, 0x3B6050AB, 0x3B6D5E87, 0x3B7B0245,
 0x3B84A0E2, 0x3B8C1069, 0x3B93D25A, 0x3B9BE919,
 0x3BA4577B, 0x3BAD1F66, 0x3BB64456, 0x3BBFC7E0,
 0x3BC9AD78, 0x3BD3F751, 0x3BDEA886, 0x3BE9C357,
 0x3BF54AE9, 0x3C00A0EB, 0x3C06D593, 0x3C0D44A3,
 0x3C13EFC2, 0x3C1AD82C, 0x3C21FF6F, 0x3C2966FC,
 0x3C311033, 0x3C38FC8E, 0x3C412D93, 0x3C49A4A6,
 0x3C52634F, 0x3C5B6AE6, 0x3C64BD0E, 0x3C6E5B1A,
 0x3C784699, 0x3C814078, 0x3C8685D1, 0x3C8BF404,
 0x3C918BE5, 0x3C974E09, 0x3C9D3B47, 0x3CA3543A,
 0x3CA999AD, 0x3CB00C3E, 0x3CB6ACAF, 0x3CBD7BA0,
 0x3CC479CB, 0x3CCBA7CC, 0x3CD30658, 0x3CDA9604,
 0x3CE2577D, 0x3CEA4B5F, 0x3CF27241, 0x3CFACCBD,
 0x3D01ADB4, 0x3D060F68, 0x3D0A8BC2, 0x3D0F2305,
 0x3D13D575, 0x3D18A34D, 0x3D1D8CD2, 0x3D229239,
 0x3D27B3BB, 0x3D2CF18E, 0x3D324BE9, 0x3D37C2F4,
 0x3D3D56E4, 0x3D4307DC, 0x3D48D608, 0x3D4EC188,
 0x3D54CA80, 0x3D5AF109, 0x3D61353F, 0x3D679737,
 0x3D6E1705, 0x3D74B4B7, 0x3D7B7058, 0x3D8124F7,
 0x3D84A0BD, 0x3D882B82, 0x3D8BC540, 0x3D8F6DF2,
 0x3D932593, 0x3D96EC1B, 0x3D9AC17D, 0x3D9EA5AD,
 0x3DA2989B, 0x3DA69A37, 0x3DAAAA6B, 0x3DAEC922,
 0x3DB2F643, 0x3DB731B3, 0x3DBB7B56, 0x3DBFD30B,
 0x3DC438AF, 0x3DC8AC1E, 0x3DCD2D33, 0x3DD1BBC3,
 0x3DD657A1, 0x3DDB00A1, 0x3DDFB691, 0x3DE4793D,
 0x3DE94870, 0x3DEE23F2, 0x3DF30B89, 0x3DF7FEF6,
 0x3DFCFDFB, 0x3E01042A, 0x3E038EDE, 0x3E061EF6,
 0x3E08B44E, 0x3E0B4EC0, 0x3E0DEE25, 0x3E109254,
 0x3E133B22, 0x3E15E868, 0x3E1899F6, 0x3E1B4FA2,
 0x3E1E093B, 0x3E20C694, 0x3E23877C, 0x3E264BC1,
 0x3E291331, 0x3E2BDD98, 0x3E2EAAC0, 0x3E317A75,
 0x3E344C81, 0x3E3720AA, 0x3E39F6BA, 0x3E3CCE76,
 0x3E3FA7A5, 0x3E428209, 0x3E455D67, 0x3E483985,
 0x3E4B1622, 0x3E4DF303, 0x3E50CFE5, 0x3E53AC8A,
 0x3E5688B3, 0x3E59641C, 0x3E5C3E87, 0x3E5F17B0,
 0x3E61EF53, 0x3E64C530, 0x3E679902, 0x3E6A6A85,
 0x3E6D3974, 0x3E70058C, 0x3E72CE88, 0x3E759422,
 0x3E785615, 0x3E7B141B, 0x3E7DCDF0, 0x3E8041A7,
 0x3E8199F8, 0x3E82EFC6, 0x3E8442F1, 0x3E859355,
 0x3E86E0CF, 0x3E882B3F, 0x3E89727F, 0x3E8AB670,
 0x3E8BF6ED, 0x3E8D33D5, 0x3E8E6D06, 0x3E8FA260,
 0x3E90D3C2, 0x3E920107, 0x3E932A12, 0x3E944EC2,
 0x3E956EF6, 0x3E968A90, 0x3E97A16E, 0x3E98B374,
 0x3E99C07F, 0x3E9AC877, 0x3E9BCB3B, 0x3E9CC8AD,
 0x3E9DC0B3, 0x3E9EB32F, 0x3E9FA004, 0x3EA0871C,
 0x3EA16857, 0x3EA2439E, 0x3EA318D7, 0x3EA3E7EA,
 0x3EA4B0BF, 0x3EA5733E, 0x3EA62F50, 0x3EA6E4E1,
 0x3EA793DA, 0x3EA83C26, 0x3EA8DDB3, 0x3EA9786F,
 0x3EAA0C45, 0x3EAA9924, 0x3EAB1EFD, 0x3EAB9DC0,
 0x3EAC155B, 0x3EAC85C3, 0x3EACEEEB, 0x3EAD50C4,
 0x3EADAB43, 0x3EADFE5E, 0x3EAE4A0B, 0x3EAE8E40,
 0x3EAECAF6, 0x3EAF0025, 0x3EAF2DC7, 0x3EAF53D6,
 0x3EAF724E, 0x3EAF892C, 0x3EAF986B, 0x3EAFA00C,
 0x3EAFA00C, 0x3EAF986B, 0x3EAF892C, 0x3EAF724E,
 0x3EAF53D6, 0x3EAF2DC7, 0x3EAF0025, 0x3EAECAF6,
 0x3EAE8E40, 0x3EAE4A0B, 0x3EADFE5E, 0x3EADAB43,
 0x3EAD50C4, 0x3EACEEEB, 0x3EAC85C3, 0x3EAC155B,
 0x3EAB9DC0, 0x3EAB1EFD, 0x3EAA9924, 0x3EAA0C45,
 0x3EA9786F, 0x3EA8DDB3, 0x3EA83C26, 0x3EA793DA,
 0x3EA6E4E1, 0x3EA62F50, 0x3EA5733E, 0x3EA4B0BF,
 0x3EA3E7EA, 0x3EA318D7, 0x3EA2439E, 0x3EA16857,
 0x3EA0871C, 0x3E9FA004, 0x3E9EB32F, 0x3E9DC0B3,
 0x3E9CC8AD, 0x3E9BCB3B, 0x3E9AC877, 0x3E99C07F,
 0x3E98B374, 0x3E97A16E, 0x3E968A90, 0x3E956EF6,
 0x3E944EC2, 0x3E932A12, 0x3E920107, 0x3E90D3C2,
 0x3E8FA260, 0x3E8E6D06, 0x3E8D33D5, 0x3E8BF6ED,
 0x3E8AB670, 0x3E89727F, 0x3E882B3F, 0x3E86E0CF,
 0x3E859355, 0x3E8442F1, 0x3E82EFC6, 0x3E8199F8,
 0x3E8041A7, 0x3E7DCDF0, 0x3E7B141B, 0x3E785615,
 0x3E759422, 0x3E72CE88, 0x3E70058C, 0x3E6D3974,
 0x3E6A6A85, 0x3E679902, 0x3E64C530, 0x3E61EF53,
 0x3E5F17B0, 0x3E5C3E87, 0x3E59641C, 0x3E5688B3,
 0x3E53AC8A, 0x3E50CFE5, 0x3E4DF303, 0x3E4B1622,
 0x3E483985, 0x3E455D67, 0x3E428209, 0x3E3FA7A5,
 0x3E3CCE76, 0x3E39F6BA, 0x3E3720AA, 0x3E344C81,
 0x3E317A75, 0x3E2EAAC0, 0x3E2BDD98, 0x3E291331,
 0x3E264BC1, 0x3E23877C, 0x3E20C694, 0x3E1E093B,
 0x3E1B4FA2, 0x3E1899F6, 0x3E15E868, 0x3E133B22,
 0x3E109254, 0x3E0DEE25, 0x3E0B4EC0, 0x3E08B44E,
 0x3E061EF6, 0x3E038EDE, 0x3E01042A, 0x3DFCFDFB,
 0x3DF7FEF6, 0x3DF30B89, 0x3DEE23F2, 0x3DE94870,
 0x3DE4793D, 0x3DDFB691, 0x3DDB00A1, 0x3DD657A1,
 0x3DD1BBC3, 0x3DCD2D33, 0x3DC8AC1E, 0x3DC438AF,
 0x3DBFD30B, 0x3DBB7B56, 0x3DB731B3, 0x3DB2F643,
 0x3DAEC922, 0x3DAAAA6B, 0x3DA69A37, 0x3DA2989B,
 0x3D9EA5AD, 0x3D9AC17D, 0x3D96EC1B, 0x3D932593,
 0x3D8F6DF2, 0x3D8BC540, 0x3D882B82, 0x3D84A0BD,
 0x3D8124F7, 0x3D7B7058, 0x3D74B4B7, 0x3D6E1705,
 0x3D679737, 0x3D61353F, 0x3D5AF109, 0x3D54CA80,
 0x3D4EC188, 0x3D48D608, 0x3D4307DC, 0x3D3D56E4,
 0x3D37C2F4, 0x3D324BE9, 0x3D2CF18E, 0x3D27B3BB,
 0x3D229239, 0x3D1D8CD2, 0x3D18A34D, 0x3D13D575,
 0x3D0F2305, 0x3D0A8BC2, 0x3D060F68, 0x3D01ADB4,
 0x3CFACCBD, 0x3CF27241, 0x3CEA4B5F, 0x3CE2577D,
 0x3CDA9604, 0x3CD30658, 0x3CCBA7CC, 0x3CC479CB,
 0x3CBD7BA0, 0x3CB6ACAF, 0x3CB00C3E, 0x3CA999AD,
 0x3CA3543A, 0x3C9D3B47, 0x3C974E09, 0x3C918BE5,
 0x3C8BF404, 0x3C8685D1, 0x3C814078, 0x3C784699,
 0x3C6E5B1A, 0x3C64BD0E, 0x3C5B6AE6, 0x3C52634F,
 0x3C49A4A6, 0x3C412D93, 0x3C38FC8E, 0x3C311033,
 0x3C2966FC, 0x3C21FF6F, 0x3C1AD82C, 0x3C13EFC2,
 0x3C0D44A3, 0x3C06D593, 0x3C00A0EB, 0x3BF54AE9,
 0x3BE9C357, 0x3BDEA886, 0x3BD3F751, 0x3BC9AD78,
 0x3BBFC7E0, 0x3BB64456, 0x3BAD1F66, 0x3BA4577B,
 0x3B9BE919, 0x3B93D25A, 0x3B8C1069, 0x3B84A0E2,
 0x3B7B0245, 0x3B6D5E87, 0x3B6050AB, 0x3B53D489,
 0x3B47E513, 0x3B3C7E78, 0x3B319BD2, 0x3B273831,
 0x3B1D5097, 0x3B13DF6F, 0x3B0AE178, 0x3B02533E,
 0x3AF45E21, 0x3AE4E507, 0x3AD6330A, 0x3AC84176,
 0x3ABB069D, 0x3AAE7DA3, 0x3AA29E35, 0x3A976429,
 0x3A8CC31F, 0x3A82BDC7, 0x3A7283B3, 0x3A60A90A,
 0x3A4FD760, 0x3A3FFF88, 0x3A31177F, 0x3A231C02,
 0x3A15FCF5, 0x3A09B0A9, 0x39FC53FD, 0x39E6C8F9,
 0x39D2AC76, 0x39BFD626, 0x39AE80F8, 0x399E0363,
 0x398EED4F, 0x3980FCAA, 0x3967EDD3, 0x394FCCE4,
 0x393996FE, 0x3925404D, 0x39128979, 0x39015410,
 0x38E2F293, 0x38C5F4FC, 0x38AB88A2, 0x398B60E7
};

static const unsigned int lfe_fir_128[ 512 ] __attribute__(   (  section( ".data" )  )   ) = {
 0x3A0B60D3, 0x392B8887, 0x3945F4E1, 0x3962F276,
 0x39815400, 0x39928966, 0x39A54037, 0x39B996E5,
 0x39CFCCC8, 0x39E7EDB5, 0x3A00FC99, 0x3A0EED3C,
 0x3A1E034E, 0x3A2E80DF, 0x3A3FD60D, 0x3A52AC5A,
 0x3A66C8D9, 0x3A7C53D9, 0x3A89B097, 0x3A95FCE1,
 0x3AA31BEB, 0x3AB11767, 0x3ABFFF6F, 0x3ACFD744,
 0x3AE0A8EC, 0x3AF28393, 0x3B02BDB6, 0x3B0CC30D,
 0x3B176415, 0x3B229E20, 0x3B2E7D8B, 0x3B3B0684,
 0x3B48415B, 0x3B5632EE, 0x3B64E4E7, 0x3B745DFF,
 0x3B82532D, 0x3B8AE165, 0x3B93DF5B, 0x3B9D5081,
 0x3BA73819, 0x3BB19BB9, 0x3BBC7E5F, 0x3BC7E4F8,
 0x3BD3D46D, 0x3BE0508D, 0x3BED5E66, 0x3BFB0221,
 0x3C04A0CF, 0x3C0C1055, 0x3C13D246, 0x3C1BE904,
 0x3C245765, 0x3C2D1F4E, 0x3C36443D, 0x3C3FC7C6,
 0x3C49AD5D, 0x3C53F735, 0x3C5EA867, 0x3C69C336,
 0x3C754ACA, 0x3C80A0DA, 0x3C86D580, 0x3C8D448F,
 0x3C93EFAE, 0x3C9AD817, 0x3CA1FF58, 0x3CA966E5,
 0x3CB1101B, 0x3CB8FC74, 0x3CC12D7B, 0x3CC9A48C,
 0x3CD26332, 0x3CDB6AC7, 0x3CE4BCF0, 0x3CEE5AF9,
 0x3CF84677, 0x3D014065, 0x3D0685BF, 0x3D0BF3F2,
 0x3D118BD1, 0x3D174DF6, 0x3D1D3B31, 0x3D235423,
 0x3D299996, 0x3D300C27, 0x3D36AC96, 0x3D3D7B87,
 0x3D4479B0, 0x3D4BA7B0, 0x3D53063B, 0x3D5A95E6,
 0x3D625760, 0x3D6A4B40, 0x3D727220, 0x3D7ACC9A,
 0x3D81ADA1, 0x3D860F55, 0x3D8A8BAF, 0x3D8F22F1,
 0x3D93D560, 0x3D98A338, 0x3D9D8CBD, 0x3DA29223,
 0x3DA7B3A5, 0x3DACF177, 0x3DB24BD2, 0x3DB7C2DC,
 0x3DBD56CC, 0x3DC307C1, 0x3DC8D5ED, 0x3DCEC16C,
 0x3DD4CA63, 0x3DDAF0EC, 0x3DE13520, 0x3DE79718,
 0x3DEE16E7, 0x3DF4B495, 0x3DFB7035, 0x3E0124E5,
 0x3E04A0AD, 0x3E082B6F, 0x3E0BC52C, 0x3E0F6DDE,
 0x3E132580, 0x3E16EC07, 0x3E1AC168, 0x3E1EA598,
 0x3E229886, 0x3E269A21, 0x3E2AAA54, 0x3E2EC90B,
 0x3E32F62C, 0x3E37319C, 0x3E3B7B3E, 0x3E3FD2F1,
 0x3E443895, 0x3E48AC02, 0x3E4D2D17, 0x3E51BBA6,
 0x3E565784, 0x3E5B0084, 0x3E5FB673, 0x3E64791F,
 0x3E694851, 0x3E6E23D2, 0x3E730B69, 0x3E77FED5,
 0x3E7CFDD6, 0x3E810417, 0x3E838ECB, 0x3E861EE4,
 0x3E88B43C, 0x3E8B4EAD, 0x3E8DEE11, 0x3E90923F,
 0x3E933B0E, 0x3E95E853, 0x3E9899E1, 0x3E9B4F8C,
 0x3E9E0925, 0x3EA0C67F, 0x3EA38766, 0x3EA64BAA,
 0x3EA91319, 0x3EABDD80, 0x3EAEAAA8, 0x3EB17A5D,
 0x3EB44C69, 0x3EB72092, 0x3EB9F6A0, 0x3EBCCE5D,
 0x3EBFA78A, 0x3EC281EE, 0x3EC55D4D, 0x3EC83969,
 0x3ECB1607, 0x3ECDF2E6, 0x3ED0CFC7, 0x3ED3AC6D,
 0x3ED68895, 0x3ED96400, 0x3EDC3E68, 0x3EDF1791,
 0x3EE1EF34, 0x3EE4C512, 0x3EE798E3, 0x3EEA6A64,
 0x3EED3954, 0x3EF0056C, 0x3EF2CE66, 0x3EF59401,
 0x3EF855F3, 0x3EFB13F9, 0x3EFDCDCF, 0x3F004196,
 0x3F0199E6, 0x3F02EFB5, 0x3F0442DF, 0x3F059343,
 0x3F06E0BE, 0x3F082B2D, 0x3F09726D, 0x3F0AB65C,
 0x3F0BF6D9, 0x3F0D33C2, 0x3F0E6CF4, 0x3F0FA24D,
 0x3F10D3AD, 0x3F1200F3, 0x3F1329FD, 0x3F144EAE,
 0x3F156EE2, 0x3F168A7B, 0x3F17A15A, 0x3F18B35E,
 0x3F19C06B, 0x3F1AC863, 0x3F1BCB25, 0x3F1CC898,
 0x3F1DC09D, 0x3F1EB318, 0x3F1F9FEF, 0x3F208706,
 0x3F216841, 0x3F224388, 0x3F2318C1, 0x3F23E7D4,
 0x3F24B0A8, 0x3F257327, 0x3F262F39, 0x3F26E4CA,
 0x3F2793C2, 0x3F283C10, 0x3F28DD9D, 0x3F297857,
 0x3F2A0C2D, 0x3F2A990D, 0x3F2B1EE6, 0x3F2B9DA8,
 0x3F2C1544, 0x3F2C85AC, 0x3F2CEED4, 0x3F2D50AC,
 0x3F2DAB2B, 0x3F2DFE46, 0x3F2E49F3, 0x3F2E8E29,
 0x3F2ECADE, 0x3F2F000D, 0x3F2F2DAF, 0x3F2F53BE,
 0x3F2F7237, 0x3F2F8914, 0x3F2F9853, 0x3F2F9FF4,
 0x3F2F9FF4, 0x3F2F9853, 0x3F2F8914, 0x3F2F7237,
 0x3F2F53BE, 0x3F2F2DAF, 0x3F2F000D, 0x3F2ECADE,
 0x3F2E8E29, 0x3F2E49F3, 0x3F2DFE46, 0x3F2DAB2B,
 0x3F2D50AC, 0x3F2CEED4, 0x3F2C85AC, 0x3F2C1544,
 0x3F2B9DA8, 0x3F2B1EE6, 0x3F2A990D, 0x3F2A0C2D,
 0x3F297857, 0x3F28DD9D, 0x3F283C10, 0x3F2793C2,
 0x3F26E4CA, 0x3F262F39, 0x3F257327, 0x3F24B0A8,
 0x3F23E7D4, 0x3F2318C1, 0x3F224388, 0x3F216841,
 0x3F208706, 0x3F1F9FEF, 0x3F1EB318, 0x3F1DC09D,
 0x3F1CC898, 0x3F1BCB25, 0x3F1AC863, 0x3F19C06B,
 0x3F18B35E, 0x3F17A15A, 0x3F168A7B, 0x3F156EE2,
 0x3F144EAE, 0x3F1329FD, 0x3F1200F3, 0x3F10D3AD,
 0x3F0FA24D, 0x3F0E6CF4, 0x3F0D33C2, 0x3F0BF6D9,
 0x3F0AB65C, 0x3F09726D, 0x3F082B2D, 0x3F06E0BE,
 0x3F059343, 0x3F0442DF, 0x3F02EFB5, 0x3F0199E6,
 0x3F004196, 0x3EFDCDCF, 0x3EFB13F9, 0x3EF855F3,
 0x3EF59401, 0x3EF2CE66, 0x3EF0056C, 0x3EED3954,
 0x3EEA6A64, 0x3EE798E3, 0x3EE4C512, 0x3EE1EF34,
 0x3EDF1791, 0x3EDC3E68, 0x3ED96400, 0x3ED68895,
 0x3ED3AC6D, 0x3ED0CFC7, 0x3ECDF2E6, 0x3ECB1607,
 0x3EC83969, 0x3EC55D4D, 0x3EC281EE, 0x3EBFA78A,
 0x3EBCCE5D, 0x3EB9F6A0, 0x3EB72092, 0x3EB44C69,
 0x3EB17A5D, 0x3EAEAAA8, 0x3EABDD80, 0x3EA91319,
 0x3EA64BAA, 0x3EA38766, 0x3EA0C67F, 0x3E9E0925,
 0x3E9B4F8C, 0x3E9899E1, 0x3E95E853, 0x3E933B0E,
 0x3E90923F, 0x3E8DEE11, 0x3E8B4EAD, 0x3E88B43C,
 0x3E861EE4, 0x3E838ECB, 0x3E810417, 0x3E7CFDD6,
 0x3E77FED5, 0x3E730B69, 0x3E6E23D2, 0x3E694851,
 0x3E64791F, 0x3E5FB673, 0x3E5B0084, 0x3E565784,
 0x3E51BBA6, 0x3E4D2D17, 0x3E48AC02, 0x3E443895,
 0x3E3FD2F1, 0x3E3B7B3E, 0x3E37319C, 0x3E32F62C,
 0x3E2EC90B, 0x3E2AAA54, 0x3E269A21, 0x3E229886,
 0x3E1EA598, 0x3E1AC168, 0x3E16EC07, 0x3E132580,
 0x3E0F6DDE, 0x3E0BC52C, 0x3E082B6F, 0x3E04A0AD,
 0x3E0124E5, 0x3DFB7035, 0x3DF4B495, 0x3DEE16E7,
 0x3DE79718, 0x3DE13520, 0x3DDAF0EC, 0x3DD4CA63,
 0x3DCEC16C, 0x3DC8D5ED, 0x3DC307C1, 0x3DBD56CC,
 0x3DB7C2DC, 0x3DB24BD2, 0x3DACF177, 0x3DA7B3A5,
 0x3DA29223, 0x3D9D8CBD, 0x3D98A338, 0x3D93D560,
 0x3D8F22F1, 0x3D8A8BAF, 0x3D860F55, 0x3D81ADA1,
 0x3D7ACC9A, 0x3D727220, 0x3D6A4B40, 0x3D625760,
 0x3D5A95E6, 0x3D53063B, 0x3D4BA7B0, 0x3D4479B0,
 0x3D3D7B87, 0x3D36AC96, 0x3D300C27, 0x3D299996,
 0x3D235423, 0x3D1D3B31, 0x3D174DF6, 0x3D118BD1,
 0x3D0BF3F2, 0x3D0685BF, 0x3D014065, 0x3CF84677,
 0x3CEE5AF9, 0x3CE4BCF0, 0x3CDB6AC7, 0x3CD26332,
 0x3CC9A48C, 0x3CC12D7B, 0x3CB8FC74, 0x3CB1101B,
 0x3CA966E5, 0x3CA1FF58, 0x3C9AD817, 0x3C93EFAE,
 0x3C8D448F, 0x3C86D580, 0x3C80A0DA, 0x3C754ACA,
 0x3C69C336, 0x3C5EA867, 0x3C53F735, 0x3C49AD5D,
 0x3C3FC7C6, 0x3C36443D, 0x3C2D1F4E, 0x3C245765,
 0x3C1BE904, 0x3C13D246, 0x3C0C1055, 0x3C04A0CF,
 0x3BFB0221, 0x3BED5E66, 0x3BE0508D, 0x3BD3D46D,
 0x3BC7E4F8, 0x3BBC7E5F, 0x3BB19BB9, 0x3BA73819,
 0x3B9D5081, 0x3B93DF5B, 0x3B8AE165, 0x3B82532D,
 0x3B745DFF, 0x3B64E4E7, 0x3B5632EE, 0x3B48415B,
 0x3B3B0684, 0x3B2E7D8B, 0x3B229E20, 0x3B176415,
 0x3B0CC30D, 0x3B02BDB6, 0x3AF28393, 0x3AE0A8EC,
 0x3ACFD744, 0x3ABFFF6F, 0x3AB11767, 0x3AA31BEB,
 0x3A95FCE1, 0x3A89B097, 0x3A7C53D9, 0x3A66C8D9,
 0x3A52AC5A, 0x3A3FD60D, 0x3A2E80DF, 0x3A1E034E,
 0x3A0EED3C, 0x3A00FC99, 0x39E7EDB5, 0x39CFCCC8,
 0x39B996E5, 0x39A54037, 0x39928966, 0x39815400,
 0x3962F276, 0x3945F4E1, 0x392B8887, 0x3A0B60D3
};

static const unsigned char high_freq_vq[ 1024 ][ 32 ] __attribute__(   (  section( ".data" )  )   ) = {
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0xFC, 0xFE, 0x02, 0x01, 0xF0, 0xF6, 0x01, 0x03,
  0x01, 0x00, 0x06, 0x01, 0xFD, 0x07, 0x01, 0xEA,
  0x02, 0xFC, 0xFD, 0x0B, 0x0E, 0x06, 0xFF, 0x01,
  0xF3, 0x1D, 0xE4, 0x0A, 0x0A, 0xF8, 0x00, 0xF7
 },
 {
  0xF8, 0x08, 0xF9, 0x0A, 0xFD, 0xF4, 0xFB, 0xF8,
  0x01, 0xFE, 0x09, 0xFE, 0xFB, 0xEE, 0x01, 0x09,
  0xF8, 0xF8, 0x03, 0x29, 0x07, 0xF7, 0xF7, 0x16,
  0xD6, 0xE3, 0x0E, 0xEE, 0xF2, 0xE0, 0x01, 0xF1
 },
 {
  0xF0, 0x08, 0x0F, 0x10, 0xF0, 0x05, 0x02, 0x07,
  0xFA, 0xF0, 0xF9, 0x01, 0x01, 0xFD, 0xFE, 0x00,
  0x08, 0x14, 0xE6, 0xF5, 0x02, 0xEF, 0x00, 0xFD,
  0xDE, 0xDB, 0x0A, 0x2C, 0xFE, 0x16, 0x02, 0xFC
 },
 {
  0x07, 0x0E, 0x05, 0x06, 0x0F, 0xFF, 0x03, 0xFD,
  0xF7, 0xE9, 0xFB, 0xF2, 0x08, 0xFF, 0xF2, 0xFA,
  0xFB, 0xF8, 0x36, 0x1F, 0xFA, 0x12, 0x02, 0xED,
  0xFE, 0xF5, 0xE2, 0xFA, 0xED, 0x02, 0xFE, 0xF2
 },
 {
  0x01, 0x02, 0xFE, 0xFF, 0xFD, 0xFD, 0x01, 0xFB,
  0x01, 0xFD, 0xFC, 0xF8, 0x05, 0xFC, 0x00, 0x01,
  0x03, 0x07, 0xFB, 0xFC, 0xFD, 0xF4, 0x03, 0xFE,
  0xFD, 0x0C, 0xCB, 0xCD, 0x06, 0xFF, 0x06, 0x08
 },
 {
  0x00, 0xFF, 0x05, 0x01, 0xFA, 0xF8, 0x07, 0x05,
  0xEE, 0xFC, 0xFF, 0x01, 0x00, 0xFD, 0xFD, 0xF2,
  0xFF, 0xFA, 0x00, 0xF2, 0xFF, 0xFF, 0x05, 0xFD,
  0xF5, 0x01, 0xEC, 0x0A, 0x02, 0x13, 0xFE, 0xFE
 },
 {
  0x02, 0x04, 0x03, 0x00, 0x05, 0x00, 0x03, 0x01,
  0xFE, 0x00, 0xFA, 0xFD, 0xFC, 0xFB, 0xFD, 0xFD,
  0xF9, 0x00, 0xDE, 0x04, 0xD5, 0x11, 0x00, 0xCB,
  0xF3, 0xF9, 0x18, 0x0E, 0x05, 0xEE, 0x09, 0xEC
 },
 {
  0x01, 0x00, 0xFD, 0x02, 0x03, 0xFB, 0xFE, 0x07,
  0xEB, 0x05, 0xE7, 0x17, 0x0B, 0xE4, 0x02, 0x01,
  0xF5, 0x09, 0x0D, 0xFA, 0xF4, 0x05, 0x07, 0x02,
  0x04, 0xF5, 0xFA, 0xFF, 0x08, 0x00, 0x01, 0xFE
 },
 {
  0x02, 0xFC, 0xFA, 0xFC, 0x00, 0xFB, 0xE3, 0x0D,
  0xFA, 0xEA, 0xFD, 0xD5, 0x0C, 0xD7, 0x05, 0x18,
  0x12, 0xF7, 0xDC, 0xFA, 0x04, 0xF9, 0xFC, 0x0D,
  0x04, 0xF1, 0xFF, 0xFB, 0x01, 0x02, 0xFB, 0x04
 },
 {
  0x00, 0xFF, 0x0D, 0xFA, 0xFB, 0x01, 0x00, 0xFD,
  0x01, 0xFB, 0x13, 0xEA, 0x1F, 0xE5, 0x04, 0xF1,
  0xFA, 0x0F, 0x09, 0xF3, 0x01, 0xF7, 0x0A, 0xEF,
  0x04, 0xFF, 0xFF, 0x04, 0x02, 0x00, 0xFD, 0xFB
 },
 {
  0xF9, 0x03, 0xF8, 0x0D, 0x13, 0xF4, 0x08, 0xED,
  0xFD, 0xFE, 0xE8, 0x1F, 0x0E, 0x00, 0x07, 0xF3,
  0xEE, 0x00, 0x03, 0x06, 0x0D, 0xFE, 0x01, 0xF4,
  0xEB, 0x09, 0xFE, 0x1E, 0x15, 0xF2, 0x02, 0xF2
 },
 {
  0xFD, 0xF9, 0x08, 0xFF, 0xFE, 0xF7, 0x06, 0x01,
  0xF9, 0x07, 0x0D, 0x03, 0xFF, 0xF6, 0x1E, 0x04,
  0xF6, 0x0C, 0x05, 0x06, 0xF3, 0xF9, 0xFC, 0xFE,
  0xFE, 0x07, 0xFD, 0xFA, 0x03, 0x04, 0x01, 0x02
 },
 {
  0xF8, 0x09, 0x02, 0xFD, 0xFB, 0x02, 0x00, 0x09,
  0x03, 0x07, 0xFC, 0xF0, 0xF3, 0x03, 0x17, 0xE5,
  0x12, 0x2E, 0xDA, 0x06, 0x04, 0x2B, 0xFF, 0x00,
  0x08, 0xF9, 0xFC, 0xFF, 0x0B, 0xF9, 0x06, 0xFD
 },
 {
  0x01, 0x01, 0x12, 0xF8, 0xFA, 0x00, 0x03, 0x04,
  0x16, 0xFD, 0xFC, 0xFE, 0xFC, 0xF5, 0x28, 0xF9,
  0xFD, 0xF3, 0xF2, 0xF9, 0xF6, 0x0E, 0x07, 0x05,
  0xF2, 0x0B, 0xFB, 0x07, 0x15, 0xFE, 0x09, 0xFD
 },
 {
  0x00, 0x00, 0xFE, 0x04, 0xFE, 0x00, 0x02, 0x00,
  0xFF, 0x02, 0xFF, 0x00, 0x00, 0x02, 0x02, 0x02,
  0xFF, 0x01, 0xFD, 0xFF, 0xF1, 0xFE, 0xC1, 0xE5,
  0xEB, 0xD1, 0xF2, 0x01, 0xF2, 0x0A, 0x00, 0x02
 },
 {
  0x01, 0x00, 0xFC, 0x00, 0xFD, 0xF7, 0x04, 0x02,
  0x06, 0xFA, 0x00, 0xFB, 0x0B, 0xF9, 0xF1, 0x06,
  0xF9, 0xFA, 0x03, 0x07, 0xF1, 0xFB, 0x17, 0xF3,
  0xFA, 0x0C, 0xF8, 0x09, 0x02, 0xFD, 0x03, 0x04
 },
 {
  0x06, 0x00, 0x03, 0x00, 0xFE, 0xFC, 0x02, 0x01,
  0x01, 0xFF, 0x01, 0xFE, 0xFF, 0xFC, 0xEA, 0xF1,
  0xD2, 0xBE, 0x0A, 0x14, 0x02, 0xEF, 0x0C, 0xFA,
  0x01, 0xFE, 0xFE, 0x00, 0x01, 0xFB, 0x01, 0x02
 },
 {
  0xFF, 0x00, 0x00, 0x01, 0x00, 0xFC, 0x00, 0x01,
  0xF6, 0xFD, 0xF8, 0x05, 0x07, 0xF5, 0x02, 0xF5,
  0x1D, 0xE7, 0x0B, 0x0A, 0x00, 0xFF, 0x05, 0xF9,
  0xFE, 0xFB, 0xFE, 0x04, 0x04, 0xFD, 0x05, 0xFE
 },
 {
  0x01, 0xFF, 0xFF, 0xFD, 0xFE, 0x01, 0xF8, 0xFD,
  0x02, 0xFE, 0x04, 0xFB, 0xFF, 0xF9, 0xFE, 0x01,
  0xF2, 0xF9, 0x03, 0xE2, 0xF1, 0xF2, 0x03, 0xFC,
  0xFF, 0x03, 0xF3, 0xFF, 0xFD, 0x01, 0x02, 0x03
 },
 {
  0xFF, 0xFE, 0xFD, 0x02, 0x02, 0xFD, 0x03, 0x01,
  0xFD, 0x02, 0x00, 0xFC, 0x06, 0x05, 0xFB, 0x0A,
  0xC7, 0x03, 0x16, 0xCE, 0x01, 0xFE, 0xFB, 0xFA,
  0xFF, 0x05, 0x01, 0x02, 0x02, 0x01, 0xFE, 0x02
 },
 {
  0x02, 0x00, 0xFF, 0xF9, 0x02, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0xFE, 0x03, 0xFD, 0x04, 0xFC,
  0x18, 0xDD, 0xFD, 0x26, 0xFA, 0xFB, 0x0F, 0x14,
  0x03, 0x10, 0xF9, 0xFB, 0x00, 0xFC, 0xFB, 0x00
 },
 {
  0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x01, 0xFF, 0x01, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0xFF, 0xFB, 0xFE, 0xD5, 0xFD,
  0x2E, 0xCC, 0xF6, 0x07, 0xF8, 0x0B, 0xFE, 0xFF
 },
 {
  0x00, 0x00, 0xFF, 0x00, 0xFF, 0x02, 0xD7, 0x21,
  0xD4, 0xD0, 0xF1, 0xE6, 0xF7, 0x06, 0x03, 0x03,
  0xFD, 0x02, 0x02, 0x02, 0x02, 0xFF, 0xFF, 0xFE,
  0x01, 0x03, 0x00, 0x00, 0x05, 0x02, 0x03, 0x01
 },
 {
  0xFC, 0x01, 0x06, 0x01, 0xFA, 0xFF, 0xFE, 0x01,
  0xF2, 0xFC, 0x00, 0xFB, 0xFE, 0x02, 0xFE, 0x00,
  0xFA, 0x01, 0x00, 0x08, 0xEB, 0x20, 0xFD, 0xDC,
  0xFA, 0xFE, 0xFF, 0xF9, 0x03, 0x00, 0x01, 0xFA
 },
 {
  0xFD, 0xFE, 0x03, 0x00, 0x02, 0x02, 0x08, 0xFC,
  0xFC, 0x06, 0x02, 0x01, 0x03, 0xFA, 0x04, 0x03,
  0x0D, 0x00, 0xF4, 0xFF, 0x19, 0xEC, 0xFE, 0xE9,
  0xF1, 0x07, 0xFD, 0xF5, 0xFD, 0x06, 0xFF, 0x00
 },
 {
  0x00, 0x00, 0xFD, 0xFF, 0x00, 0x00, 0xFE, 0xFF,
  0xFE, 0xFE, 0x01, 0xFF, 0x00, 0x00, 0x0A, 0x03,
  0xFE, 0x03, 0x03, 0xF9, 0xFA, 0xFB, 0x00, 0xFC,
  0xC4, 0xF0, 0xFA, 0x26, 0x05, 0x06, 0xFB, 0x00
 },
 {
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xFF, 0xFF, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0xFF, 0x00, 0xF8, 0x02, 0xF7, 0x0A,
  0x28, 0x1F, 0xC8, 0xEB, 0x04, 0x14, 0xFC, 0x07
 },
 {
  0xFE, 0xFE, 0x00, 0x04, 0xFD, 0xFF, 0x07, 0x03,
  0x01, 0x03, 0xF8, 0x00, 0x03, 0x01, 0x02, 0x05,
  0x01, 0xFE, 0x0E, 0x05, 0x04, 0x05, 0x05, 0x05,
  0xFB, 0x09, 0xBE, 0x00, 0xEC, 0xFE, 0xF8, 0x04
 },
 {
  0xFE, 0xFF, 0x04, 0xFF, 0xF8, 0xFE, 0xFC, 0xFF,
  0xFD, 0xFD, 0x02, 0xF9, 0xFD, 0x05, 0x07, 0xFE,
  0x2D, 0x1F, 0xEF, 0xF0, 0xFE, 0xFE, 0xFF, 0xEA,
  0x01, 0xFF, 0xFD, 0x03, 0x05, 0xFD, 0x05, 0xFF
 },
 {
  0xFC, 0x00, 0x07, 0x05, 0x08, 0x07, 0x02, 0x09,
  0xF7, 0xF7, 0xF9, 0xF5, 0xFD, 0xF8, 0x11, 0xFC,
  0x22, 0x20, 0x12, 0x16, 0x01, 0x02, 0x01, 0xF9,
  0xFB, 0x06, 0xFF, 0x06, 0x04, 0x0A, 0xFE, 0xF9
 },
 {
  0x06, 0x00, 0x0E, 0x09, 0x06, 0xFF, 0xFE, 0xFD,
  0x04, 0xFA, 0xF8, 0x04, 0x07, 0xFF, 0x1C, 0x26,
  0x0F, 0xFF, 0x10, 0xF5, 0x05, 0x08, 0x04, 0xF6,
  0x03, 0xF6, 0xEF, 0x05, 0x03, 0x03, 0x03, 0x01
 },
 {
  0x01, 0x01, 0x02, 0xFF, 0x02, 0x01, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0xFE, 0x01, 0xFD, 0x00, 0x01,
  0x02, 0xFE, 0xFC, 0xFE, 0x00, 0xFF, 0x01, 0xFD,
  0x01, 0x01, 0x01, 0xFF, 0x08, 0x08, 0x42, 0x21
 },
 {
  0xFB, 0x02, 0xFD, 0xF9, 0x02, 0xF8, 0xFC, 0x0A,
  0x11, 0xEE, 0xF9, 0x04, 0xFC, 0xF9, 0xFA, 0xFA,
  0xFB, 0x05, 0xF4, 0x02, 0x00, 0x06, 0x08, 0xFE,
  0x01, 0x04, 0xF5, 0x02, 0x01, 0x08, 0x1F, 0x13
 },
 {
  0x06, 0x09, 0x10, 0xFA, 0xFA, 0xFF, 0xFE, 0xFD,
  0xF5, 0xFE, 0x07, 0x07, 0x11, 0x03, 0x04, 0x0A,
  0x02, 0x05, 0xF3, 0x08, 0x07, 0x01, 0x04, 0x05,
  0x07, 0x06, 0x07, 0xF8, 0x09, 0xF8, 0x21, 0x06
 },
 {
  0x03, 0xFF, 0x01, 0x00, 0xF9, 0xFB, 0x00, 0x0E,
  0xF9, 0x01, 0xF9, 0x01, 0x02, 0xFC, 0x07, 0x0A,
  0xF0, 0x0C, 0x01, 0xFA, 0x03, 0x08, 0xFF, 0x0A,
  0xF3, 0xFA, 0xF4, 0xE9, 0x0C, 0xFD, 0x1E, 0x0E
 },
 {
  0xFE, 0xF1, 0x00, 0x08, 0x03, 0xED, 0x05, 0xFD,
  0x02, 0x03, 0x0D, 0x07, 0x0E, 0xFD, 0xF6, 0x00,
  0x08, 0x05, 0xFA, 0xF0, 0xF8, 0xF8, 0x0E, 0x02,
  0xFF, 0x01, 0xF7, 0xF5, 0x0B, 0xFB, 0x1B, 0x09
 },
 {
  0xF8, 0x06, 0xFC, 0x04, 0xFC, 0xFF, 0x05, 0x04,
  0x01, 0xF9, 0xFB, 0xFC, 0xF1, 0x01, 0x09, 0x00,
  0x08, 0x04, 0x01, 0xEF, 0x0B, 0xFE, 0xED, 0xFF,
  0xFA, 0xF8, 0x03, 0xF4, 0x03, 0xEF, 0x21, 0xF6
 },
 {
  0xFD, 0xFF, 0x02, 0x07, 0x07, 0xFE, 0x09, 0x08,
  0xEE, 0xFF, 0xF3, 0xF6, 0xFD, 0xFD, 0x0B, 0x08,
  0xFE, 0xF4, 0xF8, 0x01, 0x04, 0x09, 0x0E, 0x0A,
  0xFD, 0x00, 0x02, 0x01, 0xFE, 0x03, 0x1F, 0x0A
 },
 {
  0xFD, 0xF6, 0x08, 0xFF, 0xFB, 0xF5, 0x07, 0xFB,
  0x03, 0x06, 0x01, 0x04, 0xF0, 0x0A, 0x05, 0xFC,
  0xFE, 0xF6, 0xFF, 0x0D, 0x06, 0xFB, 0xF9, 0x0C,
  0x07, 0xFD, 0xEF, 0x01, 0x0C, 0xFC, 0x1D, 0x08
 },
 {
  0x01, 0x02, 0x05, 0x02, 0xFA, 0xF9, 0x00, 0xFF,
  0x06, 0xFF, 0x0A, 0x06, 0xFC, 0x05, 0x02, 0x02,
  0xFE, 0xF8, 0xFA, 0xF5, 0x0E, 0xF3, 0x1B, 0x03,
  0xFE, 0xF4, 0x05, 0xF0, 0x02, 0xE6, 0x14, 0x0F
 },
 {
  0xFF, 0xFD, 0xFB, 0xFD, 0xFD, 0x06, 0xFF, 0x03,
  0xFB, 0x01, 0x07, 0x02, 0x01, 0x00, 0xFF, 0xFF,
  0x00, 0xFF, 0x09, 0x07, 0xFA, 0xFD, 0x04, 0xFB,
  0xFC, 0x08, 0xF8, 0xE7, 0xF8, 0xFC, 0x22, 0x17
 },
 {
  0xFF, 0xFE, 0x01, 0x01, 0xFF, 0xFE, 0xFF, 0x01,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x01,
  0x00, 0x02, 0x01, 0xFF, 0x04, 0x00, 0x00, 0x01,
  0xFF, 0x00, 0x05, 0x03, 0x0C, 0xF7, 0x44, 0xF0
 },
 {
  0x0A, 0x00, 0xF8, 0x0E, 0xFA, 0x01, 0xF4, 0x00,
  0x00, 0xFD, 0xFB, 0xF5, 0xFA, 0x0C, 0x09, 0xF6,
  0xFD, 0x05, 0x00, 0x07, 0x0B, 0x02, 0x04, 0xFD,
  0xF8, 0xFD, 0x07, 0x04, 0x03, 0xFD, 0x22, 0x04
 },
 {
  0xF4, 0x0D, 0xFB, 0x07, 0xF5, 0xFE, 0xFF, 0x01,
  0xFC, 0xF2, 0xEB, 0x03, 0xFD, 0xFD, 0xFC, 0xF9,
  0xF7, 0xFC, 0x03, 0xEF, 0xFE, 0xF3, 0x0A, 0xFE,
  0x0C, 0xFC, 0x00, 0xF7, 0x01, 0xFB, 0x1F, 0x0A
 },
 {
  0xF6, 0x06, 0x05, 0x06, 0x04, 0xF9, 0x0A, 0x00,
  0xE4, 0xFD, 0x00, 0xF5, 0xFF, 0xFB, 0x10, 0xF6,
  0xF0, 0x07, 0x14, 0x02, 0xFC, 0x02, 0xFB, 0x00,
  0x0F, 0x06, 0x05, 0xF6, 0x07, 0xF7, 0x14, 0x04
 },
 {
  0x01, 0xF9, 0xFE, 0xF9, 0x04, 0xFD, 0xFE, 0xF9,
  0xFF, 0xF2, 0x06, 0xF0, 0x04, 0xFB, 0xFC, 0xFA,
  0xFB, 0x00, 0xFE, 0x02, 0xFA, 0x09, 0xFB, 0x04,
  0xEE, 0x08, 0xF6, 0x08, 0x0F, 0x00, 0x20, 0x01
 },
 {
  0xFB, 0x07, 0xFD, 0x07, 0x0F, 0xFC, 0x00, 0xF0,
  0x09, 0x05, 0xFB, 0x05, 0x04, 0xFD, 0xF4, 0xF7,
  0xEE, 0x0A, 0x02, 0x02, 0xFD, 0x07, 0x03, 0xFF,
  0x06, 0xF7, 0xF6, 0x03, 0x0F, 0xFC, 0x23, 0xF9
 },
 {
  0xFF, 0xF6, 0x02, 0x02, 0xFC, 0xFE, 0x0A, 0x02,
  0xFF, 0x02, 0xFE, 0x01, 0xFF, 0xF2, 0xF5, 0x03,
  0xF8, 0x05, 0xF8, 0xFE, 0x06, 0xFF, 0xF9, 0x01,
  0x07, 0x05, 0x07, 0x08, 0x1E, 0xFC, 0x1E, 0x0E
 },
 {
  0x02, 0xFE, 0x01, 0x02, 0x03, 0xF8, 0x03, 0x00,
  0xFE, 0x00, 0xF7, 0x02, 0x01, 0x04, 0xFA, 0xFF,
  0xFE, 0x05, 0x00, 0x01, 0xFE, 0x0C, 0x06, 0xFD,
  0x09, 0xFD, 0x04, 0xF4, 0x15, 0xD9, 0x18, 0xFE
 },
 {
  0x03, 0x05, 0x01, 0xFE, 0xFE, 0xFE, 0xFD, 0x06,
  0xF8, 0xFE, 0xF5, 0xF8, 0xFF, 0x04, 0x02, 0x02,
  0xFC, 0xF6, 0x0C, 0xFB, 0xF5, 0x01, 0xF1, 0xDE,
  0xF5, 0xF9, 0xF5, 0xFF, 0x07, 0xF2, 0x26, 0xFF
 },
 {
  0xFC, 0x04, 0x08, 0x09, 0x08, 0x01, 0xFB, 0xF7,
  0x04, 0xFE, 0x0F, 0xFC, 0x0B, 0xF1, 0x14, 0xFF,
  0xFF, 0xFD, 0x04, 0xF7, 0xFE, 0xFE, 0xFE, 0x08,
  0x06, 0x0C, 0xFB, 0x00, 0x0B, 0xF4, 0x1B, 0xFC
 },
 {
  0x00, 0x08, 0xFC, 0x03, 0xF5, 0x06, 0xF5, 0x02,
  0x03, 0x00, 0x05, 0xF8, 0xF9, 0xFA, 0xF7, 0xEB,
  0x04, 0xF5, 0xFF, 0xF0, 0xF9, 0x10, 0xFD, 0x07,
  0xF9, 0x04, 0xFB, 0x00, 0x0B, 0xF9, 0x1F, 0x03
 },
 {
  0x01, 0x03, 0x04, 0x0B, 0xF5, 0xFE, 0xFD, 0xFA,
  0x06, 0x05, 0x00, 0x03, 0xF7, 0xFA, 0x04, 0xFC,
  0x00, 0x04, 0xF8, 0x0D, 0xFA, 0xF3, 0xFF, 0xFB,
  0xFF, 0x04, 0x00, 0x00, 0x09, 0xEA, 0x18, 0x12
 },
 {
  0xF9, 0x03, 0x0A, 0xF3, 0xFA, 0x06, 0xFA, 0x06,
  0x16, 0x01, 0x00, 0xF2, 0x02, 0x03, 0x07, 0xFF,
  0x08, 0x14, 0xFF, 0x05, 0xFC, 0x0D, 0x09, 0xF7,
  0xF7, 0x06, 0x00, 0xFC, 0x00, 0xF8, 0x1F, 0xFC
 },
 {
  0xFD, 0xFC, 0x00, 0x01, 0x07, 0x03, 0xF9, 0x00,
  0x05, 0xFE, 0x01, 0x03, 0x03, 0x01, 0xFB, 0xFE,
  0x05, 0x02, 0xF5, 0x04, 0x00, 0xFF, 0x0C, 0x00,
  0xFD, 0xF3, 0x0F, 0x08, 0xFA, 0xE5, 0x22, 0x00
 },
 {
  0xFD, 0xFD, 0x0A, 0xFC, 0x02, 0xFF, 0xFD, 0x00,
  0xFF, 0xFF, 0xFC, 0x02, 0x06, 0xFE, 0x0C, 0x01,
  0x03, 0xFA, 0xF9, 0xFA, 0xFB, 0x04, 0xED, 0xFA,
  0xF8, 0xDE, 0xFC, 0xF8, 0x0A, 0xF9, 0x17, 0x0A
 },
 {
  0xF9, 0x00, 0xFF, 0xFA, 0x08, 0x04, 0xFC, 0x02,
  0xFB, 0xF8, 0xF9, 0xF7, 0xF8, 0x05, 0x09, 0x07,
  0xFA, 0x01, 0xF4, 0xF4, 0xFF, 0xF0, 0x05, 0x00,
  0x10, 0x03, 0xF9, 0xF8, 0x1B, 0xFC, 0x17, 0x0F
 },
 {
  0xF8, 0x04, 0x08, 0x05, 0x06, 0x0B, 0xFD, 0x05,
  0x03, 0xFF, 0xF5, 0x06, 0xFB, 0x00, 0x02, 0xFA,
  0xFD, 0xFA, 0x04, 0xFF, 0x05, 0xFB, 0xF4, 0xFA,
  0x07, 0xFB, 0x09, 0x03, 0x06, 0xF9, 0x1D, 0x01
 },
 {
  0x01, 0x03, 0xFE, 0xFE, 0xFA, 0xFE, 0x01, 0x06,
  0xFA, 0xFD, 0x01, 0x02, 0x03, 0x04, 0x01, 0x05,
  0xFF, 0x00, 0x04, 0x02, 0x0B, 0x06, 0x02, 0xFD,
  0x0D, 0xF7, 0xED, 0x12, 0xF1, 0xF6, 0x24, 0x15
 },
 {
  0xFD, 0xFD, 0x02, 0xFF, 0xF9, 0x06, 0xFC, 0x01,
  0xFD, 0xFF, 0xFE, 0x02, 0x03, 0xF9, 0xFD, 0x00,
  0xFE, 0x00, 0xFE, 0x06, 0xED, 0x03, 0xF8, 0x02,
  0xFA, 0x07, 0xFF, 0x00, 0x1D, 0xFA, 0x1C, 0xF6
 },
 {
  0xFB, 0x01, 0xFD, 0xF9, 0xF4, 0xFC, 0x01, 0x01,
  0xFF, 0x0D, 0xF6, 0xFF, 0xF7, 0xFB, 0xF3, 0x06,
  0x0D, 0x03, 0xFC, 0x02, 0x03, 0x0B, 0x02, 0x06,
  0xE7, 0xF0, 0xFA, 0x00, 0x0E, 0xFF, 0x1B, 0x10
 },
 {
  0xFA, 0xFF, 0xF9, 0xFB, 0xFE, 0xFB, 0xFB, 0xFF,
  0x09, 0x01, 0x00, 0x03, 0xF8, 0xF4, 0xFA, 0x05,
  0xFA, 0x05, 0x03, 0xF7, 0x01, 0x04, 0xF9, 0xF6,
  0xF7, 0xF9, 0xEF, 0xFB, 0xF1, 0xE9, 0x19, 0x03
 },
 {
  0xF8, 0xFE, 0x09, 0xFD, 0xFC, 0x03, 0xFF, 0x08,
  0xF9, 0xF9, 0xFB, 0xFC, 0xFE, 0x09, 0x04, 0xFF,
  0xF9, 0xFC, 0xFB, 0xF0, 0x03, 0xFA, 0x12, 0xF3,
  0xF7, 0x10, 0xF1, 0x08, 0x0F, 0xF6, 0x18, 0x05
 },
 {
  0x01, 0xDA, 0x02, 0x22, 0x09, 0x0A, 0x0B, 0x02,
  0x02, 0xFA, 0x03, 0x02, 0xFE, 0x05, 0x04, 0xF9,
  0xFF, 0x01, 0x04, 0x00, 0x03, 0x01, 0xF8, 0xFF,
  0xFA, 0x05, 0x04, 0x02, 0xFC, 0x05, 0x02, 0xFF
 },
 {
  0x01, 0xEA, 0x0F, 0x12, 0xFE, 0x0A, 0xF0, 0xF7,
  0xF8, 0xF5, 0x08, 0x04, 0x00, 0x07, 0xF2, 0xFB,
  0xFF, 0xF9, 0x0C, 0x11, 0x09, 0x05, 0xF9, 0xFC,
  0xF4, 0xFA, 0x07, 0x00, 0x07, 0x02, 0xFE, 0x01
 },
 {
  0xF5, 0xE3, 0x07, 0x0A, 0x13, 0xFF, 0xF8, 0xF7,
  0x07, 0x01, 0x09, 0x06, 0x08, 0xF9, 0xF2, 0x08,
  0xFD, 0xF5, 0xF3, 0x00, 0xF9, 0xE9, 0xFE, 0xF8,
  0x0C, 0x09, 0x02, 0x0E, 0x13, 0x01, 0xFF, 0x05
 },
 {
  0xE8, 0xE5, 0xF5, 0x24, 0x02, 0x06, 0xFD, 0x04,
  0xFA, 0x08, 0x00, 0x0C, 0xFF, 0xFC, 0xFA, 0x03,
  0x04, 0xFF, 0x02, 0xFD, 0xFE, 0x03, 0x02, 0xFF,
  0xFE, 0xFC, 0x00, 0xFF, 0xFE, 0x07, 0x02, 0x03
 },
 {
  0xF7, 0xE8, 0x0B, 0x0D, 0xF6, 0xF4, 0x0C, 0xFE,
  0x07, 0x04, 0x08, 0x0D, 0xFD, 0xFD, 0x02, 0x09,
  0xFD, 0xFC, 0x04, 0x0D, 0x05, 0x0D, 0xFA, 0xFD,
  0x01, 0x0F, 0x07, 0xFD, 0x00, 0x13, 0xFE, 0xF7
 },
 {
  0xF8, 0xF1, 0x07, 0x0E, 0xFC, 0xFB, 0x02, 0xEE,
  0xED, 0xFE, 0x02, 0x11, 0x10, 0x06, 0xF6, 0x0A,
  0xF7, 0x0E, 0xFF, 0xFB, 0xFF, 0xFA, 0xF9, 0x02,
  0x09, 0x0B, 0x0D, 0x06, 0xFB, 0xF4, 0x03, 0x02
 },
 {
  0xF6, 0xDB, 0x0D, 0x01, 0x03, 0xF2, 0x00, 0xEC,
  0x04, 0xFD, 0x08, 0x02, 0xFE, 0xFD, 0xF7, 0xFB,
  0xFD, 0xEF, 0xFF, 0x0D, 0xF5, 0x02, 0xFA, 0x04,
  0x04, 0x00, 0x03, 0x01, 0xF7, 0xFC, 0xFB, 0xFC
 },
 {
  0xFE, 0xEA, 0xFB, 0x2E, 0xF8, 0x05, 0x09, 0xF5,
  0x08, 0x07, 0x07, 0xFF, 0xFF, 0xFE, 0xF9, 0x02,
  0xFD, 0x03, 0xFF, 0xFE, 0x07, 0x00, 0x02, 0xFF,
  0x01, 0xFE, 0xFE, 0xFD, 0x06, 0x00, 0xFC, 0xFA
 },
 {
  0xF0, 0xE5, 0x0F, 0x10, 0xFC, 0x0E, 0xF9, 0xE6,
  0x02, 0xFE, 0x06, 0x05, 0xFD, 0x0B, 0x00, 0x02,
  0x03, 0x09, 0xF9, 0xFF, 0x02, 0xFC, 0xFC, 0xFF,
  0x06, 0x0A, 0x01, 0x01, 0xFD, 0xFE, 0x03, 0x00
 },
 {
  0xFD, 0xEA, 0x0A, 0x1A, 0x01, 0x02, 0xFD, 0x03,
  0x11, 0xFD, 0xF9, 0x09, 0x01, 0xEB, 0xFC, 0x05,
  0x03, 0x00, 0xF9, 0xFA, 0x03, 0x03, 0xF8, 0xF9,
  0xF7, 0x03, 0x07, 0x01, 0xF8, 0x0C, 0x06, 0xF9
 },
 {
  0xF7, 0xE7, 0x03, 0x12, 0x09, 0xFA, 0xF5, 0x00,
  0xFB, 0xF4, 0x09, 0xF8, 0xF9, 0xFA, 0xFA, 0x16,
  0x02, 0xFA, 0xFD, 0x0F, 0x03, 0x02, 0xFE, 0x09,
  0x0E, 0xF6, 0xF9, 0x0F, 0x0D, 0x06, 0xFE, 0x0B
 },
 {
  0x05, 0xEC, 0xFB, 0x1C, 0x0B, 0x0A, 0xFC, 0xFC,
  0x00, 0xF9, 0x03, 0x05, 0x02, 0xFB, 0xF8, 0x02,
  0x06, 0x0A, 0x09, 0xF7, 0xEE, 0x03, 0x0E, 0x01,
  0x03, 0xFD, 0xFF, 0xFA, 0x07, 0x07, 0x02, 0xFF
 },
 {
  0xF8, 0xE2, 0x07, 0x0C, 0x0A, 0x08, 0x07, 0xF3,
  0xF0, 0x00, 0x01, 0xFF, 0xFA, 0xF5, 0xF1, 0x04,
  0x01, 0xFE, 0x0A, 0xF1, 0x01, 0x0B, 0xFE, 0x08,
  0x09, 0xF9, 0xF9, 0x09, 0xFB, 0x02, 0x07, 0xEE
 },
 {
  0xF6, 0xE0, 0x0A, 0x0B, 0x03, 0xFF, 0x03, 0xFB,
  0x05, 0x02, 0x0E, 0xFA, 0x03, 0x01, 0x05, 0xF1,
  0xF5, 0x06, 0x14, 0x04, 0x00, 0xF4, 0xF9, 0x03,
  0x01, 0xFF, 0x0A, 0x06, 0xFF, 0xF7, 0xFC, 0xFF
 },
 {
  0x01, 0xE7, 0xF2, 0x0C, 0xF5, 0x09, 0x09, 0xF0,
  0xE8, 0xEF, 0x16, 0xF7, 0x0B, 0xE2, 0xFD, 0xFC,
  0x06, 0xF9, 0x09, 0x02, 0xFF, 0xFB, 0xFA, 0x02,
  0xFF, 0xFF, 0x0A, 0x01, 0xFD, 0x03, 0x04, 0x08
 },
 {
  0xF2, 0xE6, 0xFA, 0x09, 0x08, 0x11, 0xF5, 0xE8,
  0xF9, 0xFC, 0xF8, 0xFE, 0x0A, 0x02, 0x02, 0xFF,
  0x02, 0x0D, 0x0C, 0xF9, 0x04, 0xFA, 0xF6, 0x06,
  0x06, 0xF3, 0xF5, 0xF9, 0xF0, 0x00, 0xFE, 0x05
 },
 {
  0xFC, 0xE2, 0xF3, 0x0C, 0x10, 0xFA, 0x0C, 0xF0,
  0xF3, 0x05, 0x0F, 0xFE, 0xFE, 0xF6, 0xF9, 0x07,
  0x0B, 0xFF, 0xFC, 0xFE, 0xFC, 0x07, 0x04, 0xF8,
  0x01, 0x03, 0x00, 0x0B, 0x03, 0xFE, 0xFB, 0x04
 },
 {
  0xFC, 0xEB, 0x14, 0x16, 0x02, 0x14, 0xF8, 0x01,
  0xF4, 0xFB, 0xF7, 0x04, 0xF6, 0xEF, 0xFD, 0xF8,
  0xFD, 0x03, 0xF4, 0x01, 0xFD, 0x00, 0x07, 0x04,
  0x07, 0x07, 0xFD, 0x07, 0x05, 0x03, 0x01, 0xFB
 },
 {
  0xF4, 0xEC, 0x02, 0x1D, 0x0B, 0xFA, 0x09, 0xF9,
  0xFA, 0xFC, 0x00, 0x06, 0x11, 0xF3, 0xFE, 0xF6,
  0xEF, 0xFF, 0xEE, 0x02, 0x00, 0x0E, 0xFA, 0x01,
  0x00, 0x03, 0x02, 0xF6, 0x01, 0xFB, 0xFE, 0x05
 },
 {
  0x10, 0xDB, 0xFF, 0x1A, 0xFE, 0xF2, 0x01, 0xFB,
  0xF2, 0x02, 0x02, 0x03, 0x06, 0x01, 0x01, 0x04,
  0x00, 0xFF, 0x00, 0xFE, 0xFE, 0x04, 0x09, 0xFA,
  0x00, 0xFE, 0x0A, 0xF9, 0xFE, 0x04, 0x01, 0x00
 },
 {
  0xF7, 0xE8, 0xF4, 0x05, 0x05, 0x03, 0xEF, 0xF2,
  0x04, 0x03, 0x02, 0xFC, 0x0A, 0xEA, 0xF8, 0xFD,
  0x06, 0x01, 0x0C, 0xF8, 0x04, 0x01, 0x09, 0xFF,
  0x12, 0xFD, 0x06, 0x05, 0x03, 0xFB, 0x09, 0xFB
 },
 {
  0xF2, 0xDF, 0xFE, 0x14, 0xF3, 0xF6, 0x02, 0xF9,
  0xFF, 0x0B, 0xF7, 0xF8, 0x12, 0xFD, 0x01, 0x08,
  0x00, 0xFE, 0x0A, 0x07, 0xFE, 0xF3, 0x09, 0xFD,
  0xFC, 0x05, 0xFE, 0xFE, 0xFF, 0xFB, 0x01, 0xF9
 },
 {
  0xF6, 0xE9, 0x08, 0x0E, 0x01, 0x07, 0x01, 0xFD,
  0xF9, 0x04, 0x01, 0x01, 0x08, 0xF9, 0x0F, 0xF2,
  0x0D, 0x0E, 0x02, 0x05, 0xF3, 0xFB, 0xF8, 0xFF,
  0x06, 0x03, 0x06, 0x09, 0x06, 0x0F, 0x0E, 0x05
 },
 {
  0xF3, 0xE7, 0xF6, 0x0D, 0xEF, 0xE8, 0xF9, 0xF3,
  0xFA, 0xF6, 0xF8, 0x02, 0x00, 0xF3, 0xF6, 0xFC,
  0xF8, 0x04, 0xF7, 0x09, 0xFC, 0x04, 0xFD, 0xFD,
  0x03, 0x03, 0xFB, 0xF7, 0x01, 0xFE, 0x0B, 0x02
 },
 {
  0xF4, 0xE9, 0x01, 0x12, 0xF5, 0xFE, 0x05, 0x09,
  0xFB, 0x05, 0x0E, 0xF7, 0xFD, 0xFE, 0xFA, 0x02,
  0xFE, 0x0B, 0xF3, 0x01, 0xFD, 0x0B, 0xF7, 0xFC,
  0xFE, 0xFA, 0x08, 0x0A, 0x01, 0x04, 0x02, 0x01
 },
 {
  0xFB, 0xEE, 0x10, 0x16, 0x02, 0x00, 0x08, 0xFA,
  0xF7, 0xF9, 0x0A, 0xF0, 0x17, 0x0A, 0xF5, 0xFF,
  0x07, 0x02, 0x07, 0x02, 0x01, 0xFB, 0x06, 0x01,
  0x00, 0xFC, 0x09, 0x02, 0xFD, 0x01, 0x00, 0xFC
 },
 {
  0xFD, 0xE6, 0x0E, 0x0B, 0x02, 0xF7, 0x11, 0xFE,
  0xFF, 0xFB, 0xF0, 0xF7, 0xFB, 0x0A, 0xF3, 0x01,
  0x06, 0x0C, 0x0A, 0x0B, 0x00, 0x00, 0xFD, 0xF2,
  0x06, 0xFE, 0x00, 0x04, 0xFB, 0xFF, 0xF9, 0xFF
 },
 {
  0xF6, 0xDF, 0x01, 0x08, 0x0B, 0xFB, 0x01, 0xFA,
  0x07, 0x04, 0x05, 0x06, 0x01, 0xFE, 0xF6, 0xFB,
  0xFA, 0x0C, 0xF5, 0x05, 0xF6, 0x04, 0x0C, 0xFF,
  0xFF, 0xFD, 0x04, 0xFF, 0x09, 0x00, 0x10, 0xEF
 },
 {
  0xF2, 0xDB, 0x07, 0x07, 0xFE, 0x05, 0xF8, 0xF5,
  0x02, 0xF3, 0x04, 0xED, 0x01, 0x08, 0x08, 0x04,
  0xF7, 0x02, 0xFC, 0x03, 0x0C, 0x02, 0x04, 0xFC,
  0xF8, 0x08, 0x01, 0x04, 0x08, 0xFF, 0x06, 0xFE
 },
 {
  0xFA, 0xE2, 0x12, 0x11, 0x01, 0xEA, 0xFD, 0x04,
  0xF9, 0xF6, 0x07, 0x00, 0xF8, 0x08, 0xFF, 0x04,
  0x02, 0x08, 0x06, 0xFE, 0x02, 0x07, 0x04, 0x04,
  0x03, 0xFA, 0x02, 0x01, 0xFD, 0x01, 0xFF, 0xFB
 },
 {
  0xEF, 0xEE, 0xFD, 0x16, 0xF8, 0x01, 0x09, 0xFE,
  0xEF, 0x14, 0xFB, 0xFB, 0xF4, 0xFB, 0x04, 0xFB,
  0xF7, 0x08, 0xFE, 0x10, 0xFD, 0x00, 0x13, 0xF8,
  0x08, 0x01, 0x02, 0xFC, 0x00, 0x0B, 0x00, 0xFD
 },
 {
  0xF7, 0xE9, 0x03, 0x0A, 0x04, 0x04, 0xFD, 0xFE,
  0xFE, 0xFE, 0x01, 0xEA, 0x0B, 0x00, 0xFE, 0x05,
  0xFE, 0x0E, 0xF7, 0xF5, 0xFC, 0x07, 0x05, 0x20,
  0x01, 0xFD, 0xF9, 0x00, 0x15, 0xF7, 0x07, 0xFA
 },
 {
  0x00, 0x00, 0x00, 0x02, 0xFF, 0x01, 0x00, 0x01,
  0x03, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
  0xFD, 0x00, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFD,
  0xFF, 0x01, 0xFC, 0x01, 0xFF, 0xFB, 0xBB, 0xED
 },
 {
  0xFD, 0xFB, 0xF8, 0xF4, 0x04, 0xFD, 0xED, 0xF5,
  0xFB, 0x00, 0xF2, 0x07, 0x12, 0xFA, 0x07, 0x16,
  0x08, 0x0E, 0x0F, 0x0A, 0x03, 0xFF, 0xFD, 0x05,
  0xFF, 0x07, 0xF9, 0x01, 0xFA, 0x03, 0xE6, 0xF5
 },
 {
  0xFF, 0xFA, 0x04, 0xFC, 0xFB, 0xF0, 0x00, 0xFA,
  0xFD, 0x0B, 0x01, 0x00, 0x09, 0x05, 0x10, 0x03,
  0xFC, 0xDF, 0xFC, 0x04, 0xF9, 0x00, 0x01, 0x06,
  0xF5, 0xFE, 0xF3, 0xFE, 0xEE, 0x14, 0xE7, 0xF0
 },
 {
  0x04, 0x00, 0xFF, 0x00, 0xFB, 0x01, 0x00, 0x02,
  0x00, 0x0B, 0xF6, 0x04, 0xF6, 0x07, 0x10, 0x02,
  0x10, 0x0F, 0x02, 0xFF, 0x02, 0x09, 0x02, 0x08,
  0xFD, 0xFB, 0xFE, 0x00, 0xFD, 0x00, 0xDF, 0xFE
 },
 {
  0xFD, 0xF1, 0x0A, 0x0A, 0xF7, 0xFF, 0x07, 0x03,
  0x05, 0xFB, 0xF8, 0xF8, 0xFD, 0x0F, 0xF7, 0x04,
  0x0C, 0x0D, 0xF3, 0xF2, 0x0A, 0xFA, 0x09, 0x16,
  0xE5, 0x17, 0xFF, 0x05, 0xE8, 0x02, 0xE2, 0x05
 },
 {
  0x00, 0xFE, 0x07, 0xFB, 0xFB, 0x03, 0x05, 0x03,
  0xFD, 0xFB, 0x02, 0x01, 0xFC, 0x03, 0xFD, 0xFF,
  0x01, 0xFE, 0x0A, 0x16, 0xFD, 0xFC, 0xFE, 0xFE,
  0xF9, 0x03, 0x08, 0x01, 0x0E, 0x04, 0xDB, 0x09
 },
 {
  0xFD, 0xFC, 0xFF, 0x01, 0xFC, 0x00, 0x06, 0x02,
  0x06, 0xF9, 0xF6, 0xF6, 0xFF, 0xFC, 0x0B, 0xFD,
  0x07, 0xFA, 0x04, 0xF4, 0xFF, 0x05, 0x01, 0xF9,
  0x0A, 0xFA, 0x11, 0xFC, 0x08, 0x03, 0xD8, 0x0D
 },
 {
  0x02, 0x0C, 0x04, 0xF9, 0x0E, 0xFD, 0x10, 0xFE,
  0x12, 0x02, 0x0D, 0x05, 0x05, 0x01, 0x0B, 0xFF,
  0x00, 0x09, 0x02, 0xFA, 0xFF, 0x02, 0xFA, 0x02,
  0xFB, 0x03, 0x05, 0x01, 0xFF, 0x01, 0xE0, 0xF9
 },
 {
  0xF0, 0x0B, 0x07, 0xFC, 0x02, 0xFB, 0xF7, 0x09,
  0x0B, 0x0B, 0x0F, 0xF3, 0xF5, 0x0B, 0x09, 0x04,
  0x03, 0xF8, 0xF6, 0x0C, 0x0C, 0x00, 0x00, 0xF0,
  0xF7, 0x0D, 0x02, 0x09, 0x04, 0xF3, 0xDF, 0x03
 },
 {
  0x06, 0x04, 0x05, 0x04, 0x03, 0xFF, 0x05, 0x06,
  0x04, 0x02, 0xF5, 0xFF, 0xF1, 0xF5, 0xFF, 0x01,
  0x0B, 0xFD, 0xFE, 0x18, 0xFC, 0xFA, 0xE7, 0xF6,
  0xF1, 0xF8, 0x00, 0x00, 0xFB, 0x04, 0xE2, 0x02
 },
 {
  0x0A, 0xFD, 0xFA, 0x01, 0xF7, 0xFB, 0x06, 0x09,
  0xF6, 0xFD, 0x08, 0xFF, 0x04, 0xFF, 0x0B, 0xF5,
  0x03, 0x09, 0x0B, 0xFD, 0x06, 0xEF, 0x05, 0xF8,
  0xDF, 0x09, 0xF3, 0x13, 0xFE, 0x09, 0xE7, 0x02
 },
 {
  0x00, 0x00, 0xFF, 0xFD, 0x00, 0xFE, 0x01, 0x00,
  0x00, 0x02, 0x01, 0x00, 0xFE, 0x00, 0xFF, 0x02,
  0x00, 0xFF, 0x04, 0xFF, 0x02, 0xFD, 0x04, 0xFE,
  0x03, 0x03, 0x01, 0x00, 0xF1, 0x0C, 0xC1, 0x1B
 },
 {
  0xFE, 0x0E, 0x09, 0xFF, 0x03, 0x00, 0x01, 0x01,
  0xED, 0x0F, 0x03, 0x04, 0x00, 0xF6, 0x01, 0xFB,
  0x03, 0x00, 0xFB, 0xF6, 0x02, 0xF0, 0xFC, 0x08,
  0xF4, 0xFA, 0x07, 0xFB, 0xF6, 0xFF, 0xDF, 0xFC
 },
 {
  0x00, 0x03, 0x01, 0x03, 0x01, 0x02, 0x04, 0x04,
  0x09, 0xFA, 0xF8, 0xFB, 0x01, 0xF4, 0x03, 0x08,
  0xF6, 0x06, 0xFF, 0x01, 0x0D, 0xFB, 0xFB, 0x02,
  0xFC, 0x0D, 0xEE, 0xF6, 0xF9, 0xF7, 0xDF, 0x0A
 },
 {
  0xFA, 0xFD, 0xF4, 0x05, 0xFF, 0x0B, 0xFA, 0x00,
  0xFE, 0x01, 0x02, 0xF9, 0x03, 0x01, 0x03, 0xFE,
  0x01, 0x08, 0xF6, 0x07, 0xFF, 0xFD, 0x03, 0x00,
  0x0D, 0x01, 0x06, 0x07, 0xF0, 0xF9, 0xD9, 0x08
 },
 {
  0xFA, 0xFF, 0x0B, 0x06, 0xFD, 0x08, 0x03, 0xFB,
  0x03, 0x00, 0xFB, 0xFE, 0xFA, 0xFD, 0xFC, 0x02,
  0xFD, 0x0D, 0xF5, 0x01, 0x07, 0x05, 0x13, 0xFB,
  0xFD, 0xF1, 0xFF, 0x07, 0xFF, 0x06, 0xDF, 0x08
 },
 {
  0xF9, 0x03, 0xFC, 0xFD, 0xFC, 0x01, 0x06, 0xFB,
  0xFB, 0x06, 0xF8, 0xFF, 0xF9, 0x04, 0xFF, 0xFA,
  0xFE, 0x01, 0x07, 0x00, 0x01, 0x01, 0xFB, 0x02,
  0xFE, 0x00, 0xF3, 0xFE, 0xE1, 0xF2, 0xD9, 0xF4
 },
 {
  0xF6, 0x09, 0x00, 0xFD, 0x01, 0xFF, 0xFF, 0x00,
  0x01, 0xFB, 0xFF, 0xFC, 0xFE, 0x05, 0x02, 0xF9,
  0x12, 0xF8, 0xFE, 0xED, 0xF9, 0xF9, 0xF4, 0xF2,
  0xF5, 0xFF, 0xF7, 0xF3, 0xF9, 0xF4, 0xE1, 0xF7
 },
 {
  0xFD, 0xF0, 0x0A, 0x09, 0x01, 0xF6, 0xF4, 0x02,
  0xFE, 0x02, 0x07, 0xFD, 0xFD, 0x01, 0xFC, 0xFB,
  0xF7, 0x05, 0x07, 0x03, 0xFF, 0x04, 0xF5, 0xF8,
  0x04, 0x0D, 0xF6, 0x0D, 0x0A, 0xFC, 0xDC, 0x01
 },
 {
  0xF9, 0xF4, 0x04, 0xEC, 0xF9, 0xF9, 0x02, 0x0B,
  0xFF, 0xFE, 0x03, 0xF4, 0x01, 0x00, 0xFA, 0xF9,
  0x06, 0x04, 0x0D, 0x03, 0xFD, 0x04, 0x03, 0xFA,
  0xF4, 0x05, 0xFB, 0xEA, 0xF3, 0xF8, 0xDB, 0xFA
 },
 {
  0xF9, 0x05, 0x03, 0x05, 0x07, 0x09, 0xF2, 0xFD,
  0x0A, 0x11, 0xFF, 0x01, 0xF4, 0x05, 0xFA, 0x00,
  0xFC, 0xF7, 0x00, 0xF5, 0xF2, 0x03, 0x0D, 0x06,
  0xE7, 0xF8, 0xF4, 0x04, 0xF6, 0x12, 0xE2, 0xFF
 },
 {
  0xF6, 0x06, 0xF6, 0x06, 0x06, 0x01, 0xF6, 0x00,
  0xF9, 0x05, 0xFE, 0x11, 0xEE, 0xFC, 0x00, 0xFD,
  0xF0, 0xFA, 0xFD, 0xF8, 0x05, 0x01, 0xFC, 0x06,
  0xF9, 0x10, 0x06, 0x0A, 0xFF, 0x00, 0xE0, 0xF5
 },
 {
  0xFF, 0x09, 0x09, 0xFB, 0x04, 0x09, 0x06, 0x09,
  0xFC, 0xFE, 0x07, 0x0B, 0x04, 0x02, 0xFB, 0xFC,
  0xFA, 0x00, 0x02, 0xFD, 0xFF, 0x05, 0x0A, 0x00,
  0x0C, 0xF6, 0xEE, 0xFD, 0xFF, 0x0E, 0xDF, 0x02
 },
 {
  0x04, 0xF8, 0xEE, 0xFC, 0xFB, 0xF5, 0x04, 0xF6,
  0xFC, 0x09, 0x0D, 0xF4, 0x01, 0xFA, 0x01, 0x02,
  0x04, 0xF7, 0x08, 0x03, 0xFA, 0x15, 0x0D, 0xFF,
  0xFE, 0x01, 0xFE, 0x06, 0xF9, 0x00, 0xE2, 0x01
 },
 {
  0x06, 0xFF, 0x02, 0xFD, 0xFF, 0xFC, 0x06, 0xFC,
  0x00, 0x04, 0x02, 0x02, 0xF7, 0x02, 0x06, 0x03,
  0xFE, 0x04, 0xFF, 0x09, 0xFA, 0x00, 0x07, 0xF8,
  0x05, 0x13, 0xFE, 0x09, 0xFB, 0x02, 0xDF, 0xF8
 },
 {
  0x02, 0x01, 0x0C, 0xFB, 0xF8, 0x08, 0x03, 0xFE,
  0xFC, 0x01, 0xFE, 0x05, 0xFC, 0xF7, 0xF8, 0xF8,
  0x07, 0xF5, 0xFC, 0x06, 0xF6, 0x07, 0xFF, 0xFF,
  0xFE, 0xFF, 0x10, 0x20, 0xF9, 0x14, 0xDF, 0xFA
 },
 {
  0xEE, 0x02, 0x06, 0x0D, 0x09, 0x09, 0xFF, 0x03,
  0xEF, 0x18, 0xFE, 0xFA, 0x1C, 0x08, 0xFE, 0x06,
  0x03, 0xF6, 0xDE, 0xF0, 0xF3, 0xFC, 0xF1, 0xF5,
  0xF4, 0xFD, 0xF6, 0x04, 0xF8, 0x04, 0xE1, 0xFC
 },
 {
  0xF5, 0x00, 0x12, 0x02, 0xF0, 0xF7, 0xF3, 0xFE,
  0xFE, 0xF4, 0xFD, 0xEA, 0x1E, 0x00, 0x08, 0x03,
  0x09, 0xFC, 0xF0, 0x01, 0x00, 0xF5, 0x0F, 0xFE,
  0xFC, 0x06, 0xFB, 0x06, 0x01, 0x02, 0xE7, 0xF4
 },
 {
  0x0E, 0xFF, 0x05, 0x07, 0x03, 0xF1, 0xF8, 0x01,
  0x05, 0xFE, 0x0C, 0x0D, 0x0B, 0xE7, 0x03, 0x01,
  0x00, 0xFE, 0xFC, 0xF0, 0xE9, 0x00, 0xFB, 0xEF,
  0x07, 0x05, 0xF7, 0x06, 0xFB, 0x02, 0xE0, 0xF9
 },
 {
  0x03, 0xFF, 0x06, 0x0E, 0x02, 0xF4, 0xF7, 0xF7,
  0x04, 0x07, 0x04, 0x06, 0x05, 0xF8, 0x04, 0x02,
  0x04, 0x05, 0xFE, 0x08, 0x08, 0xFA, 0x00, 0x0A,
  0xEC, 0xFF, 0x03, 0xFF, 0x08, 0x17, 0xDF, 0xFB
 },
 {
  0xFD, 0x0B, 0xFA, 0x03, 0xFC, 0x05, 0x07, 0x03,
  0x04, 0x05, 0xFE, 0x03, 0xFF, 0x1E, 0x06, 0x01,
  0x08, 0xFA, 0x00, 0x00, 0xF7, 0x06, 0xF7, 0x04,
  0x02, 0x09, 0xFA, 0x01, 0xF4, 0x00, 0xDE, 0x12
 },
 {
  0xEF, 0x0D, 0x00, 0x01, 0x09, 0xFC, 0xF5, 0x00,
  0x07, 0x00, 0xF6, 0xFC, 0xFF, 0x06, 0xFA, 0x04,
  0x01, 0x06, 0xF7, 0x03, 0xFB, 0xFA, 0xF5, 0x02,
  0xFC, 0x0E, 0x17, 0xFD, 0x02, 0x05, 0xE2, 0x0C
 },
 {
  0xF2, 0x05, 0xE5, 0x02, 0x00, 0x07, 0x01, 0x04,
  0x1E, 0x08, 0x07, 0x05, 0x01, 0xFF, 0x00, 0x05,
  0x08, 0xF6, 0x30, 0xF5, 0x0C, 0x21, 0x06, 0x08,
  0xF1, 0x14, 0xFE, 0xFB, 0x20, 0x05, 0xED, 0x0A
 },
 {
  0xF0, 0xFC, 0xF4, 0xF9, 0xFE, 0x00, 0x08, 0xFA,
  0xEC, 0xEE, 0x10, 0xFD, 0x00, 0x1F, 0xFE, 0x0B,
  0x02, 0xF7, 0x31, 0xED, 0xF4, 0xE9, 0x0A, 0x1A,
  0x10, 0xFE, 0x04, 0xEB, 0xF2, 0x0D, 0xF5, 0xF7
 },
 {
  0xFB, 0xF7, 0xFF, 0x03, 0xFB, 0xEB, 0x02, 0x0A,
  0x00, 0x00, 0x0A, 0xEB, 0xF9, 0x07, 0xE6, 0xF7,
  0x16, 0x20, 0x3A, 0x0B, 0xFD, 0x0B, 0xFB, 0xF8,
  0xF3, 0x06, 0xFB, 0xF7, 0x01, 0x0A, 0x0E, 0xF8
 },
 {
  0x07, 0x07, 0x0A, 0x03, 0xFE, 0xFF, 0xF5, 0xF5,
  0xFA, 0xD5, 0xFD, 0x0E, 0xED, 0xEE, 0x13, 0x12,
  0xE0, 0x0A, 0x2D, 0xFA, 0x06, 0x15, 0xEC, 0xF4,
  0x02, 0x04, 0x06, 0x06, 0xFC, 0x03, 0x03, 0x01
 },
 {
  0x15, 0x16, 0xFD, 0xFE, 0xF5, 0xFA, 0xFF, 0xFE,
  0x08, 0x08, 0x20, 0xEB, 0x07, 0x1C, 0xFC, 0xFA,
  0xFD, 0xFE, 0x32, 0x02, 0x02, 0x1B, 0xFB, 0xF8,
  0x0C, 0x07, 0xFB, 0xFF, 0xFC, 0xEF, 0x1B, 0x06
 },
 {
  0x0D, 0x07, 0x02, 0xFA, 0xF4, 0x02, 0xF6, 0xFB,
  0xEF, 0x0B, 0x04, 0x11, 0xF4, 0xFE, 0x05, 0xEF,
  0x25, 0xF0, 0x30, 0xF2, 0xEE, 0x1D, 0x08, 0x18,
  0x0B, 0xFB, 0xF7, 0x0B, 0xFF, 0x01, 0xF3, 0xFD
 },
 {
  0x01, 0x01, 0xFF, 0x02, 0x00, 0x00, 0x00, 0xFF,
  0x01, 0xFF, 0x07, 0x02, 0xFD, 0x03, 0x00, 0x06,
  0x02, 0x0A, 0x36, 0xE7, 0x07, 0x36, 0xFB, 0xFA,
  0xFF, 0xF1, 0x09, 0x0D, 0xE8, 0xF1, 0xF4, 0x03
 },
 {
  0x15, 0x05, 0x08, 0x03, 0xFD, 0xFC, 0xFE, 0xFC,
  0x03, 0xF5, 0xFB, 0xF8, 0x09, 0x10, 0x08, 0xF7,
  0xF6, 0xFD, 0x2E, 0xD2, 0x02, 0x01, 0xF6, 0x0A,
  0x11, 0x0B, 0xEC, 0xDC, 0x0A, 0x0E, 0x00, 0xFB
 },
 {
  0x07, 0xF3, 0xFA, 0xF7, 0xE8, 0x2D, 0x02, 0x08,
  0x08, 0x00, 0x11, 0x14, 0x0C, 0xE8, 0x01, 0xF9,
  0xF1, 0xFD, 0x2E, 0xF3, 0xFE, 0x14, 0x01, 0xF3,
  0xF5, 0xF3, 0x02, 0x0F, 0x01, 0x0A, 0xFF, 0x03
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFE, 0xFF,
  0xF0, 0xF7, 0x1F, 0xBB, 0xDE, 0x1A, 0x07, 0x11,
  0xFF, 0xFA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
  0xFB, 0xEC, 0x12, 0xAE, 0x16, 0x03, 0xF9, 0x09,
  0x04, 0x06, 0x02, 0xFC, 0xFF, 0x00, 0xFE, 0x02
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0xFF,
  0x0F, 0xFB, 0x3E, 0xDC, 0x04, 0x34, 0xF9, 0x05,
  0x00, 0x06, 0x01, 0x02, 0x01, 0x01, 0xFF, 0x00
 },
 {
  0x03, 0xED, 0x13, 0xEC, 0x0D, 0xFC, 0xF5, 0x08,
  0x08, 0xF0, 0x0A, 0x01, 0xF2, 0x1E, 0x01, 0xDF,
  0x0A, 0xF5, 0x2D, 0xE2, 0x03, 0xFC, 0xFD, 0xF3,
  0x07, 0x0C, 0x03, 0xEA, 0x03, 0xFE, 0xFC, 0xFE
 },
 {
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x01,
  0x0B, 0x08, 0x46, 0x30, 0xF6, 0x15, 0x04, 0x09,
  0xF7, 0xF7, 0xFC, 0xFA, 0x00, 0xFF, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x02, 0xFF, 0x50, 0x02, 0xF1, 0xDC, 0xF6, 0xFB,
  0xFE, 0x08, 0xFE, 0x02, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x0A, 0x08, 0xF8, 0xF8, 0xE8, 0x0C, 0xFF, 0x00,
  0x14, 0x09, 0xFF, 0xFE, 0x02, 0xFE, 0x0C, 0xF6,
  0xFE, 0xF3, 0x23, 0xD5, 0x2C, 0x0F, 0xF6, 0xE7,
  0x04, 0x0A, 0xFD, 0xFB, 0xFB, 0x07, 0xFF, 0x03
 },
 {
  0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF,
  0xEE, 0x09, 0x31, 0xB8, 0x07, 0xF8, 0x07, 0xFB,
  0x02, 0x03, 0x02, 0xFE, 0x01, 0xFE, 0xFD, 0x01
 },
 {
  0xFF, 0x04, 0xFD, 0x0A, 0x13, 0x04, 0x03, 0x14,
  0x06, 0xE8, 0x06, 0x09, 0x08, 0x0F, 0x12, 0x12,
  0xDC, 0x13, 0x39, 0xF5, 0x04, 0xFD, 0x08, 0x07,
  0x02, 0xFD, 0xFE, 0xF7, 0xF1, 0xFE, 0x0C, 0xFC
 },
 {
  0x14, 0x03, 0x0B, 0xF7, 0xFC, 0x16, 0x2A, 0xE7,
  0x01, 0x05, 0xF6, 0xED, 0x00, 0x09, 0xF0, 0x05,
  0x02, 0x0A, 0x2C, 0xE3, 0x11, 0xFD, 0xF7, 0xFE,
  0xFF, 0x08, 0x0E, 0xF9, 0xFF, 0x10, 0xFB, 0x01
 },
 {
  0xF9, 0x10, 0xF5, 0x0C, 0x06, 0x21, 0xF1, 0x0E,
  0xE9, 0x02, 0xE6, 0x08, 0x02, 0x0A, 0x00, 0xFB,
  0x08, 0xF8, 0x26, 0xDA, 0xFC, 0x05, 0x05, 0x05,
  0x01, 0x16, 0xF1, 0x07, 0x06, 0x00, 0x04, 0x1C
 },
 {
  0xFF, 0xF4, 0x02, 0x0A, 0xFE, 0x00, 0x07, 0x11,
  0x0C, 0x16, 0xFC, 0x0A, 0x19, 0x1D, 0x05, 0x12,
  0x04, 0x01, 0x1B, 0xD9, 0x1F, 0x11, 0x02, 0x02,
  0x16, 0xE9, 0x0D, 0x10, 0x01, 0xF9, 0xFC, 0xFB
 },
 {
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xF2, 0x00,
  0xF9, 0xF5, 0x31, 0xEA, 0xFC, 0x13, 0x11, 0xD9,
  0x04, 0xE3, 0x0A, 0x02, 0x24, 0xFC, 0x17, 0xFF
 },
 {
  0xFE, 0xFE, 0xFE, 0xFE, 0x01, 0x0F, 0xFB, 0xF9,
  0xF0, 0xF8, 0xED, 0x10, 0xFD, 0xEC, 0x24, 0xF7,
  0xFD, 0x14, 0x27, 0xEC, 0x00, 0x02, 0x1B, 0xF0,
  0x0A, 0x0A, 0xF2, 0xEA, 0xF0, 0xFD, 0x0D, 0xF8
 },
 {
  0x05, 0xF7, 0x06, 0xE7, 0x07, 0x25, 0x0D, 0xF6,
  0xFB, 0x03, 0xFB, 0x07, 0x12, 0xEA, 0xF9, 0x09,
  0xFB, 0xFC, 0x32, 0xF5, 0xFC, 0xFB, 0xFB, 0x08,
  0xFC, 0xFE, 0xFC, 0xE5, 0x0E, 0x14, 0x07, 0xF7
 },
 {
  0x00, 0xF2, 0xF6, 0xE5, 0xF2, 0xEF, 0xFA, 0x1A,
  0x0A, 0x02, 0x0E, 0xF4, 0xFB, 0x00, 0x08, 0x09,
  0x00, 0xE4, 0x37, 0xF9, 0xF4, 0xF9, 0x04, 0xF6,
  0x0A, 0x07, 0xF4, 0x0B, 0x03, 0x05, 0x09, 0xF8
 },
 {
  0x02, 0x17, 0x04, 0xFE, 0xFF, 0xEC, 0xFE, 0x0E,
  0x0A, 0xF7, 0xF7, 0xE8, 0x0A, 0x00, 0x0B, 0xF4,
  0x0C, 0x0B, 0x31, 0xE7, 0xFE, 0x1D, 0x07, 0xF3,
  0x15, 0xF6, 0x0B, 0xEF, 0x03, 0x01, 0xF8, 0x05
 },
 {
  0x03, 0x00, 0xF2, 0xFA, 0x12, 0xFE, 0x11, 0xF7,
  0xED, 0x09, 0xFB, 0x09, 0x0E, 0x06, 0x13, 0xFD,
  0x1B, 0x01, 0x29, 0xEB, 0x14, 0xF1, 0x21, 0x00,
  0x1A, 0x0E, 0x07, 0x0A, 0x03, 0x14, 0xFD, 0xF4
 },
 {
  0xFF, 0x10, 0x0F, 0xF8, 0x03, 0xF8, 0xF8, 0x15,
  0xFB, 0xF0, 0xE3, 0x04, 0x01, 0xFA, 0xFC, 0xE4,
  0x02, 0x1F, 0x25, 0xE6, 0xFE, 0x0D, 0x18, 0x08,
  0xF7, 0xFA, 0xE3, 0x0A, 0x07, 0x02, 0x07, 0x08
 },
 {
  0xF6, 0xF6, 0x0B, 0x0D, 0xE0, 0x02, 0x10, 0x09,
  0x0E, 0x17, 0xF1, 0xF3, 0x18, 0x0D, 0x04, 0xE5,
  0x0E, 0x0C, 0x1F, 0xEE, 0x11, 0x17, 0xFE, 0xF9,
  0xF2, 0x09, 0xEF, 0xFA, 0xF6, 0x14, 0x09, 0x06
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x05, 0x01, 0x59, 0x08, 0x0A, 0xFA, 0x02, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFF,
  0x04, 0xF9, 0x40, 0xCE, 0x07, 0x25, 0x02, 0x05,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0xFE, 0x05, 0x03, 0xFC, 0xFC, 0xFD, 0x02, 0xFD,
  0x03, 0xFD, 0x05, 0x04, 0x01, 0xFA, 0xFF, 0x01,
  0x06, 0xFE, 0x32, 0xDD, 0xF9, 0x2B, 0x07, 0xF9,
  0xFB, 0xE6, 0x18, 0x15, 0x03, 0xF1, 0x05, 0x06
 },
 {
  0xF8, 0x15, 0xED, 0x21, 0xF8, 0x16, 0xF5, 0x11,
  0x03, 0x00, 0x00, 0xFE, 0x01, 0xFD, 0x06, 0xFF,
  0x0A, 0xF8, 0x04, 0xF5, 0xFC, 0xFB, 0x00, 0x08,
  0xFC, 0x03, 0x01, 0xFC, 0x04, 0x02, 0x08, 0x04
 },
 {
  0xF9, 0x05, 0xEC, 0x09, 0xEA, 0x03, 0xF2, 0x01,
  0x06, 0x0D, 0x17, 0xFE, 0xFC, 0xF9, 0x02, 0x00,
  0x0B, 0x04, 0x06, 0x03, 0xF9, 0xF5, 0xF9, 0x04,
  0x05, 0x05, 0xF4, 0x08, 0x02, 0x04, 0x07, 0xFD
 },
 {
  0xF9, 0x06, 0xFC, 0x14, 0xEC, 0x10, 0xFE, 0x07,
  0x06, 0x10, 0x0B, 0x0C, 0xF9, 0xF9, 0x05, 0x03,
  0xF7, 0xFC, 0x01, 0x02, 0x05, 0x02, 0x01, 0xF7,
  0xFE, 0xEF, 0xFC, 0x06, 0xF6, 0x07, 0xF9, 0xFA
 },
 {
  0xF7, 0x12, 0xEF, 0x0C, 0xE8, 0x01, 0xFF, 0x04,
  0x0E, 0x09, 0x04, 0x03, 0x02, 0x08, 0xF4, 0xF2,
  0x04, 0xF8, 0xFC, 0x07, 0x07, 0x06, 0xFF, 0x0D,
  0xF7, 0xFC, 0xFF, 0x01, 0x00, 0xFC, 0x0F, 0x08
 },
 {
  0xE7, 0x02, 0xF5, 0x06, 0xFB, 0x18, 0xE4, 0xFB,
  0x08, 0x0C, 0xFE, 0x06, 0x08, 0xFD, 0x08, 0xF7,
  0xFF, 0xFB, 0xFF, 0xFB, 0x06, 0xFF, 0xFF, 0xFF,
  0xFC, 0x08, 0xF4, 0xFE, 0xF3, 0x07, 0x02, 0x01
 },
 {
  0xF2, 0x0E, 0xEE, 0x14, 0xF6, 0x0C, 0xFE, 0x09,
  0x01, 0x00, 0x0C, 0xFE, 0x0F, 0xF6, 0x1A, 0xEF,
  0x10, 0xF5, 0x0A, 0xF6, 0x09, 0xFE, 0x04, 0xF8,
  0x02, 0xFD, 0x04, 0x04, 0x02, 0xFD, 0xFB, 0x01
 },
 {
  0xEE, 0x0C, 0xEE, 0x15, 0xFA, 0x0C, 0xFA, 0x0D,
  0xE7, 0x12, 0x01, 0x0B, 0xF7, 0xFB, 0x00, 0x0A,
  0xFB, 0x03, 0xFD, 0x08, 0xF7, 0x07, 0x04, 0x02,
  0xF7, 0x00, 0x05, 0x00, 0x02, 0xFD, 0x09, 0xF8
 },
 {
  0xFC, 0x10, 0x01, 0x12, 0xE2, 0x09, 0x01, 0x06,
  0xF8, 0x0D, 0x0D, 0xF4, 0xFA, 0xFF, 0x0D, 0x07,
  0x06, 0x02, 0xF1, 0xFD, 0x05, 0x05, 0x01, 0xFA,
  0x01, 0xFB, 0x00, 0x02, 0xF0, 0x00, 0x03, 0xFC
 },
 {
  0xEB, 0x01, 0xFE, 0x06, 0xD5, 0x12, 0xFF, 0x05,
  0xFF, 0x04, 0x06, 0xFE, 0xFF, 0xFD, 0xFF, 0xFD,
  0x00, 0x01, 0x02, 0xF7, 0x00, 0xFF, 0x00, 0xFE,
  0x00, 0xFF, 0xFF, 0xFE, 0x06, 0x00, 0x01, 0xFE
 },
 {
  0xE9, 0x0A, 0x04, 0x07, 0xE0, 0xF5, 0xEE, 0x02,
  0xFE, 0xF9, 0xFA, 0xFD, 0xFD, 0xF4, 0x13, 0x03,
  0xFB, 0xFA, 0x10, 0xFA, 0x10, 0x02, 0x10, 0x10,
  0x08, 0xFE, 0x0D, 0x08, 0xF1, 0xF5, 0x02, 0x0A
 },
 {
  0xF8, 0x02, 0xF3, 0x02, 0xE3, 0x18, 0xEC, 0x13,
  0x01, 0x0A, 0xFC, 0x0A, 0x01, 0x02, 0xF7, 0x0B,
  0xFF, 0xFE, 0x09, 0xFB, 0x13, 0xF9, 0x10, 0xF7,
  0xFE, 0xEE, 0x0B, 0x01, 0x01, 0x00, 0x07, 0xFD
 },
 {
  0xFA, 0x03, 0x04, 0x0D, 0xE6, 0x0A, 0xF6, 0x1C,
  0xF9, 0x1C, 0x01, 0x07, 0x00, 0xF2, 0x05, 0x07,
  0x04, 0xFC, 0x03, 0xFE, 0x03, 0x03, 0xF5, 0x07,
  0x06, 0x04, 0x00, 0xFF, 0x02, 0xFF, 0xFD, 0x02
 },
 {
  0xFA, 0x10, 0xE1, 0x0D, 0xF6, 0x11, 0xFA, 0x04,
  0xF2, 0x04, 0x04, 0xFF, 0xF6, 0x0C, 0xFB, 0x01,
  0xF2, 0x0F, 0x00, 0xF8, 0x01, 0xFB, 0x03, 0x03,
  0x09, 0xFB, 0x07, 0xEC, 0x07, 0x04, 0x0B, 0xFB
 },
 {
  0xED, 0x03, 0xEF, 0x0E, 0xF4, 0x10, 0xEA, 0x12,
  0x0E, 0x08, 0xFE, 0x04, 0x0A, 0x0C, 0xF2, 0x04,
  0xFD, 0x02, 0x03, 0x07, 0xF9, 0x07, 0xFA, 0x02,
  0xFE, 0xFC, 0xFB, 0x00, 0xFB, 0xFE, 0x02, 0x01
 },
 {
  0xF7, 0xF9, 0xF5, 0x18, 0xDC, 0xF7, 0xF5, 0x05,
  0x07, 0xF4, 0xF3, 0x12, 0xFE, 0x14, 0x01, 0xFC,
  0xFF, 0xF6, 0x0F, 0xFA, 0x0E, 0x01, 0x00, 0x02,
  0x01, 0x02, 0xF7, 0xF0, 0xF5, 0x07, 0x0D, 0x00
 },
 {
  0xE8, 0x18, 0xEE, 0x12, 0xEA, 0x0E, 0xF5, 0x0D,
  0xF4, 0x0B, 0xF6, 0x0B, 0xF9, 0x0B, 0xFB, 0xFC,
  0xFF, 0x01, 0x05, 0x02, 0x03, 0xFF, 0x01, 0xFB,
  0x07, 0xFC, 0x05, 0xFA, 0x08, 0xF9, 0x08, 0xFA
 },
 {
  0xFA, 0x12, 0xEA, 0x16, 0x05, 0x0B, 0xFF, 0x06,
  0x13, 0x16, 0x08, 0x04, 0xF8, 0x14, 0xFE, 0x0F,
  0xFA, 0xEE, 0x00, 0xDF, 0xF7, 0xF4, 0xFF, 0x06,
  0x05, 0x02, 0x05, 0x05, 0xFB, 0xEF, 0xFD, 0xFD
 },
 {
  0x01, 0x0B, 0xF0, 0x09, 0xEE, 0x0B, 0xFC, 0x12,
  0x14, 0x1A, 0xF6, 0x08, 0x01, 0xF5, 0x08, 0xFC,
  0x00, 0x07, 0x03, 0x05, 0x02, 0x02, 0x0A, 0xFE,
  0xFC, 0x04, 0xFC, 0xFE, 0x01, 0xFC, 0xFB, 0xFF
 },
 {
  0xF6, 0x06, 0xFF, 0x12, 0xEF, 0x1B, 0xFD, 0x0A,
  0xFE, 0x0C, 0xF9, 0xF7, 0x01, 0x01, 0xFF, 0x07,
  0xF4, 0xFF, 0xF9, 0xFA, 0xFF, 0x08, 0x03, 0xF1,
  0x08, 0x09, 0x03, 0xF9, 0x04, 0xFF, 0x01, 0xFF
 },
 {
  0xF2, 0x06, 0xF0, 0x16, 0x02, 0x05, 0x00, 0x05,
  0xEE, 0x0B, 0x06, 0xFD, 0x16, 0xEC, 0xF7, 0xFD,
  0x06, 0xFA, 0xF9, 0xF1, 0x01, 0x0F, 0xF8, 0x0B,
  0x08, 0xFD, 0xF8, 0x01, 0xF8, 0x02, 0x06, 0xFE
 },
 {
  0xEB, 0x05, 0xED, 0x13, 0xF9, 0x04, 0xF9, 0x00,
  0xF8, 0x06, 0x0C, 0x05, 0xFD, 0xEA, 0xF3, 0xFA,
  0xFF, 0xFD, 0xFE, 0xF2, 0x06, 0xFD, 0x01, 0xF8,
  0xF9, 0xFB, 0xFA, 0x0B, 0xFD, 0xF6, 0xFB, 0x02
 },
 {
  0xFF, 0x09, 0xF4, 0x0F, 0xFA, 0x06, 0xED, 0x0E,
  0xF7, 0x0B, 0x03, 0x0C, 0xEF, 0xFD, 0x08, 0xFC,
  0xFD, 0xFC, 0x01, 0xFB, 0x04, 0x05, 0xF9, 0xF1,
  0xF9, 0x0F, 0xFA, 0xFB, 0x01, 0xFB, 0xFD, 0x01
 },
 {
  0xF4, 0x14, 0xF1, 0x14, 0xF2, 0x03, 0xF2, 0x09,
  0xFA, 0x21, 0xF3, 0x06, 0xFE, 0x08, 0xFA, 0x07,
  0xFB, 0xFA, 0xFD, 0xFD, 0x00, 0x08, 0xFD, 0xFD,
  0x01, 0xFE, 0x02, 0x02, 0x06, 0xFB, 0xFB, 0xFE
 },
 {
  0xF9, 0x0C, 0xEE, 0x0C, 0xEE, 0x0A, 0xFC, 0x08,
  0x02, 0x04, 0x08, 0x09, 0x00, 0x03, 0xF8, 0x03,
  0x06, 0xF4, 0xFC, 0x01, 0x19, 0xFB, 0xF7, 0x06,
  0xF9, 0x00, 0xF7, 0xF9, 0x03, 0xFB, 0xFC, 0xFC
 },
 {
  0xEE, 0x0C, 0xF6, 0x0B, 0xEA, 0x00, 0xF1, 0x05,
  0xFE, 0x02, 0xFD, 0x06, 0xFC, 0xFC, 0xFD, 0xF1,
  0xFE, 0xFD, 0x15, 0x06, 0xF4, 0xF5, 0x13, 0x03,
  0x03, 0xF2, 0x07, 0x00, 0xF5, 0xEA, 0xF6, 0x00
 },
 {
  0xF1, 0x02, 0xE2, 0x0F, 0xEF, 0x0D, 0xF0, 0x08,
  0xF9, 0x0A, 0xF8, 0x02, 0x0B, 0x03, 0x0A, 0xF9,
  0x07, 0xEA, 0x0C, 0xF6, 0x03, 0xF4, 0x06, 0xF6,
  0x0C, 0xF6, 0x07, 0xF8, 0x05, 0x02, 0x09, 0x01
 },
 {
  0xF7, 0x0B, 0xF2, 0x06, 0xF6, 0x15, 0x05, 0x0C,
  0xFB, 0x05, 0x07, 0x15, 0x06, 0x02, 0xFE, 0xFF,
  0xFF, 0x04, 0x02, 0xEC, 0xEE, 0xFF, 0xF2, 0x03,
  0xFF, 0x04, 0xF9, 0x0A, 0x01, 0x0B, 0x04, 0xFC
 },
 {
  0xEA, 0x08, 0xE2, 0x0D, 0xEB, 0xFC, 0x04, 0xFF,
  0x0C, 0x09, 0xFE, 0xFD, 0x02, 0xFA, 0x04, 0xF3,
  0xFE, 0x08, 0x08, 0x01, 0xF9, 0x03, 0xFC, 0xFB,
  0xFF, 0xF9, 0xFE, 0x08, 0x08, 0x07, 0x08, 0x00
 },
 {
  0xFA, 0xFC, 0xDD, 0x10, 0xF3, 0x0F, 0xF5, 0x0E,
  0xF9, 0x09, 0xFF, 0x0B, 0x07, 0x00, 0x0D, 0x0A,
  0xFF, 0x08, 0x01, 0x01, 0xFE, 0x08, 0xFF, 0x02,
  0x02, 0x03, 0xF6, 0xFF, 0x07, 0xF3, 0xFD, 0xF9
 },
 {
  0xF1, 0x07, 0xF0, 0x0E, 0xEE, 0x11, 0xFA, 0x0E,
  0x03, 0x04, 0x07, 0xFD, 0x0A, 0xEA, 0x05, 0xF1,
  0x04, 0xFC, 0xF5, 0x0F, 0xF1, 0x0B, 0xF5, 0x14,
  0x01, 0x00, 0x02, 0x01, 0x0B, 0xFD, 0x0B, 0xF9
 },
 {
  0xF4, 0x03, 0x05, 0x10, 0xDB, 0xFF, 0x0F, 0x0F,
  0xF1, 0x0A, 0x03, 0xF6, 0x01, 0x0F, 0x07, 0xF1,
  0xF3, 0x08, 0x09, 0xFD, 0x02, 0x0C, 0xF8, 0x02,
  0xFB, 0x00, 0xFD, 0x04, 0x05, 0xF7, 0xFC, 0x05
 },
 {
  0xF0, 0x1A, 0xFC, 0x0E, 0xEA, 0x1A, 0x06, 0xFD,
  0xF8, 0x04, 0x15, 0x06, 0x10, 0xFC, 0xF5, 0x07,
  0xF6, 0x03, 0x03, 0x07, 0xFC, 0x02, 0xF7, 0x08,
  0xFE, 0x02, 0x05, 0xFE, 0xFC, 0xFE, 0x07, 0xFF
 },
 {
  0xF9, 0xF6, 0x04, 0x03, 0x02, 0xFC, 0xF4, 0xF6,
  0xFC, 0xFB, 0x10, 0x13, 0xF0, 0x01, 0x02, 0xF7,
  0xF6, 0x00, 0x09, 0x07, 0xF8, 0x03, 0x0C, 0x08,
  0xFA, 0xF5, 0xF3, 0xFF, 0xFD, 0xEC, 0x06, 0xFB
 },
 {
  0xF2, 0xEF, 0x03, 0xFB, 0x0E, 0xF4, 0xF4, 0x08,
  0xFA, 0xE7, 0x15, 0x15, 0x0A, 0xF8, 0xF4, 0x04,
  0x0A, 0xFC, 0x03, 0xF7, 0x0B, 0x09, 0x00, 0x04,
  0x02, 0xF1, 0x01, 0xF2, 0x04, 0x01, 0x00, 0xFC
 },
 {
  0xFC, 0xF7, 0xFD, 0xFF, 0x06, 0x03, 0xFA, 0x06,
  0xF6, 0xFC, 0x0E, 0x08, 0x02, 0xFD, 0xF4, 0xED,
  0x00, 0x0B, 0xEC, 0x01, 0x06, 0xFE, 0xE5, 0xFA,
  0x0A, 0xEF, 0xF2, 0xEF, 0xF7, 0x08, 0xF8, 0x03
 },
 {
  0xF4, 0xF3, 0x10, 0xFC, 0xFE, 0x0C, 0xF9, 0xF5,
  0x02, 0xF3, 0x03, 0x07, 0xF0, 0xEE, 0xFF, 0xF4,
  0xFE, 0x01, 0xF4, 0xF7, 0xFE, 0xFA, 0x02, 0x09,
  0xEA, 0xFD, 0xFC, 0xF2, 0xF9, 0x07, 0xFF, 0x02
 },
 {
  0xF9, 0xF8, 0xF8, 0x0F, 0x0F, 0x12, 0x0F, 0x10,
  0xFC, 0xDB, 0x0B, 0x0F, 0xF4, 0xFF, 0xFD, 0x03,
  0x06, 0x06, 0x00, 0xFB, 0xFD, 0xFB, 0x09, 0x01,
  0x01, 0xF5, 0xFF, 0xF8, 0xFA, 0x02, 0x03, 0x00
 },
 {
  0xFA, 0x07, 0xFB, 0xF4, 0x0D, 0x0A, 0xEE, 0xFC,
  0xFD, 0xEB, 0x06, 0x10, 0xF1, 0xF9, 0xF4, 0xF7,
  0x01, 0xF4, 0xFF, 0x0A, 0xFE, 0xFF, 0xFD, 0x04,
  0xFC, 0x01, 0xF0, 0xFF, 0x0C, 0xF7, 0x05, 0x09
 },
 {
  0xF2, 0xFB, 0x09, 0x03, 0x04, 0x1A, 0xE4, 0x03,
  0xFA, 0xE8, 0x04, 0x05, 0x03, 0x0D, 0x05, 0xFF,
  0x03, 0xFF, 0x03, 0x01, 0x01, 0xFB, 0x03, 0x00,
  0xF9, 0xF8, 0xF9, 0xFD, 0x03, 0xFB, 0x04, 0x00
 },
 {
  0xFC, 0x02, 0xF6, 0xFA, 0x19, 0x1A, 0xFA, 0x0A,
  0xFA, 0xF8, 0x0F, 0x0B, 0xFA, 0xFD, 0x02, 0xF9,
  0x05, 0x0E, 0x09, 0xFF, 0x00, 0xF4, 0x04, 0xFC,
  0xF6, 0x01, 0xFD, 0x03, 0xFE, 0xFE, 0xFA, 0xFF
 },
 {
  0xF6, 0x08, 0xF1, 0xF6, 0x13, 0x11, 0xF8, 0x00,
  0xFD, 0xF9, 0x07, 0x05, 0xF3, 0xFF, 0x07, 0xF9,
  0x01, 0x0D, 0xF4, 0xF3, 0x11, 0xF4, 0x01, 0x1A,
  0xEE, 0xFD, 0xFB, 0xFA, 0x04, 0x05, 0x08, 0x01
 },
 {
  0x02, 0xFB, 0x03, 0x00, 0x00, 0x00, 0x02, 0xFD,
  0xFE, 0xFB, 0x07, 0x0D, 0xFC, 0x09, 0x00, 0xFB,
  0x04, 0xFF, 0xF5, 0xF8, 0xFC, 0x00, 0xF3, 0x02,
  0xD1, 0xE9, 0xF8, 0xF5, 0xFC, 0x04, 0xFE, 0xFD
 },
 {
  0xEE, 0xFC, 0x04, 0x05, 0xFF, 0x11, 0xF4, 0xF8,
  0x01, 0xF4, 0x07, 0x14, 0xF4, 0x03, 0xFE, 0xF5,
  0x10, 0x0C, 0xFA, 0x01, 0xF3, 0xF0, 0xFA, 0xFD,
  0xFD, 0xFB, 0x04, 0xF4, 0xFB, 0xF7, 0x0A, 0x01
 },
 {
  0xF5, 0x00, 0x04, 0x07, 0x07, 0x08, 0x03, 0xFF,
  0x03, 0xED, 0x20, 0x08, 0xED, 0xF8, 0x02, 0x04,
  0xF4, 0x0F, 0xF0, 0x03, 0x01, 0x09, 0xFE, 0x01,
  0xFE, 0x08, 0x05, 0x06, 0xFC, 0xFF, 0x0B, 0xF8
 },
 {
  0x03, 0xFF, 0x04, 0xFE, 0x0E, 0x20, 0xF7, 0xE9,
  0xF6, 0xF4, 0x16, 0x0F, 0xFF, 0xFE, 0x0A, 0x00,
  0x04, 0x06, 0xF8, 0x04, 0xF1, 0xFE, 0xFF, 0xFC,
  0x00, 0xF8, 0x04, 0x01, 0xF8, 0x03, 0x04, 0x01
 },
 {
  0xEF, 0xF4, 0x06, 0xF8, 0x10, 0x0D, 0xEC, 0xF8,
  0xFF, 0xF0, 0x0A, 0x15, 0xED, 0x0B, 0xF7, 0xFB,
  0x07, 0x12, 0xFA, 0x07, 0xF9, 0xEE, 0x0D, 0x02,
  0xFE, 0x08, 0xF4, 0xF7, 0x02, 0x04, 0xFB, 0x10
 },
 {
  0x04, 0x00, 0x11, 0xF5, 0x0C, 0x07, 0xF4, 0x05,
  0xFF, 0xE7, 0x1E, 0xF8, 0xF9, 0xFA, 0xFC, 0xF9,
  0x09, 0x08, 0x07, 0x03, 0x03, 0xF0, 0x08, 0x00,
  0xFE, 0xFE, 0xEE, 0xFD, 0xFC, 0xFB, 0x01, 0x04
 },
 {
  0xFD, 0xFA, 0x06, 0xF0, 0x11, 0x06, 0xFD, 0x02,
  0xF7, 0xEF, 0x0C, 0x0B, 0x0B, 0x02, 0xEC, 0x08,
  0x01, 0x01, 0x00, 0x02, 0xFE, 0xFA, 0xEB, 0xF3,
  0xF7, 0xF1, 0xFF, 0xF8, 0xFA, 0xF8, 0x00, 0xFE
 },
 {
  0xF5, 0xF9, 0x06, 0xF7, 0x03, 0x06, 0x08, 0x10,
  0x04, 0xFB, 0x17, 0x1A, 0xF6, 0xFD, 0x04, 0x00,
  0x02, 0x02, 0xFC, 0x04, 0xFE, 0xF4, 0x0C, 0x0A,
  0xF5, 0x00, 0xF6, 0xF0, 0x03, 0x00, 0x00, 0xF6
 },
 {
  0xFB, 0xF0, 0x0A, 0xFA, 0x1B, 0x0D, 0xFD, 0x04,
  0xFE, 0xF3, 0x0F, 0x05, 0x02, 0x05, 0x03, 0xFC,
  0x0D, 0x0C, 0xF5, 0xF9, 0x00, 0x01, 0x0B, 0x0C,
  0x02, 0x0D, 0xF1, 0xF8, 0x09, 0xFE, 0x03, 0x08
 },
 {
  0xFB, 0xF8, 0x04, 0x03, 0x09, 0x03, 0xF5, 0x0A,
  0x0E, 0xE7, 0x0E, 0x08, 0xFE, 0x05, 0xF4, 0xEB,
  0x02, 0x0A, 0xF9, 0x02, 0xFD, 0x02, 0x00, 0x02,
  0xFF, 0xFD, 0xFB, 0xFA, 0xFF, 0xF0, 0x02, 0x08
 },
 {
  0xFF, 0x05, 0x01, 0xF5, 0x05, 0x09, 0xF9, 0x08,
  0xF3, 0xF4, 0x04, 0x0C, 0xFC, 0x01, 0xFF, 0xFF,
  0x1B, 0x1D, 0x0A, 0x0F, 0x02, 0xFA, 0xFD, 0x04,
  0xEB, 0x0A, 0xF7, 0xF5, 0xFA, 0xFF, 0xF7, 0xFD
 },
 {
  0xFA, 0xFD, 0xFF, 0xFA, 0x0B, 0xFB, 0x00, 0xFE,
  0xFB, 0xE1, 0x0B, 0x03, 0xFF, 0x05, 0xFD, 0x04,
  0x05, 0x07, 0xF6, 0x05, 0xF6, 0xF3, 0x04, 0x0C,
  0xF1, 0xFE, 0x02, 0xF9, 0x01, 0xF7, 0xFD, 0xF6
 },
 {
  0xFD, 0xF9, 0x11, 0xF8, 0xFB, 0x24, 0x08, 0xF9,
  0xF8, 0xEC, 0x0C, 0x08, 0x01, 0xFF, 0x03, 0x00,
  0x01, 0x04, 0xF6, 0x03, 0x01, 0x04, 0xFE, 0xFD,
  0xFE, 0xFD, 0xF6, 0x04, 0xFF, 0xF9, 0x03, 0x02
 },
 {
  0xF3, 0xFD, 0xFB, 0x09, 0x16, 0x06, 0xE9, 0x03,
  0xF6, 0xF9, 0x11, 0x11, 0x12, 0xF2, 0xF8, 0xF8,
  0x02, 0x04, 0xF8, 0x02, 0xFD, 0xF8, 0x06, 0x04,
  0xFF, 0x07, 0x00, 0x00, 0xFD, 0x00, 0xF4, 0xFD
 },
 {
  0xFD, 0xF6, 0xF1, 0xFD, 0x09, 0x03, 0xE9, 0xF7,
  0xF3, 0xEE, 0x0C, 0x0D, 0xFE, 0x00, 0x01, 0x08,
  0xFF, 0x02, 0xF9, 0xF4, 0xFB, 0x0E, 0x02, 0x01,
  0xEA, 0x06, 0xF6, 0xF8, 0xF7, 0x1C, 0xF9, 0xF2
 },
 {
  0xFD, 0x01, 0x02, 0xFF, 0x0D, 0x07, 0xFE, 0xF9,
  0x01, 0xFD, 0x06, 0x09, 0xFD, 0xFE, 0x04, 0xFE,
  0x02, 0x01, 0xF6, 0xFE, 0xFE, 0xEA, 0xFE, 0xF9,
  0xF6, 0xFB, 0xF5, 0xE5, 0xF4, 0xF0, 0x04, 0xF9
 },
 {
  0x02, 0xFA, 0xFD, 0x01, 0x08, 0x00, 0xFE, 0x0C,
  0xFD, 0xFC, 0x3A, 0x0F, 0xF6, 0xFC, 0xFE, 0x02,
  0xFE, 0x00, 0xFE, 0xFA, 0x02, 0x04, 0xFF, 0x01,
  0xFC, 0x01, 0xFF, 0xFB, 0xFC, 0xFD, 0x03, 0x01
 },
 {
  0x0A, 0xFF, 0x00, 0x05, 0x15, 0x07, 0xF2, 0x06,
  0xFD, 0xF0, 0x0F, 0x11, 0xF0, 0x0D, 0x03, 0xFA,
  0xFC, 0x06, 0xF4, 0xFB, 0x01, 0xFC, 0xF9, 0xF8,
  0x02, 0x03, 0xFA, 0x06, 0xFF, 0xF8, 0x05, 0x04
 },
 {
  0xFA, 0xFE, 0xF8, 0xF5, 0x0F, 0x0A, 0x00, 0x08,
  0xFA, 0xF1, 0x21, 0x08, 0xFE, 0x12, 0xF1, 0xF5,
  0x05, 0xFF, 0x00, 0x0F, 0xF1, 0xFC, 0xFC, 0xFF,
  0x0A, 0x07, 0xF3, 0x04, 0xFC, 0x00, 0x08, 0x03
 },
 {
  0xF9, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0xFC, 0xFB,
  0xF2, 0xF0, 0x0C, 0x26, 0x07, 0x0C, 0x06, 0xFC,
  0x00, 0xFF, 0x00, 0x03, 0xFE, 0xFA, 0x00, 0x02,
  0xF7, 0x01, 0x00, 0xFF, 0x00, 0xFE, 0x04, 0x01
 },
 {
  0xF8, 0xFC, 0x12, 0x01, 0x0E, 0x05, 0xF4, 0xFD,
  0x14, 0xEF, 0x05, 0x13, 0xF5, 0xF8, 0x0B, 0xFD,
  0x03, 0x09, 0xF9, 0xF8, 0x09, 0xEF, 0x02, 0x0F,
  0xF6, 0xF5, 0x05, 0xFB, 0x07, 0x0F, 0xFA, 0xFE
 },
 {
  0xF9, 0x02, 0x26, 0x05, 0x13, 0x10, 0xFB, 0x04,
  0xF3, 0xEC, 0x00, 0x04, 0xFC, 0x06, 0x04, 0x02,
  0xF9, 0x06, 0xF8, 0xFE, 0xFB, 0xF9, 0x06, 0x03,
  0xFC, 0xFD, 0xFE, 0xFD, 0x07, 0xFA, 0xFC, 0x00
 },
 {
  0xF5, 0xF4, 0x08, 0xF1, 0xFD, 0x0E, 0xF9, 0xEA,
  0xF5, 0x02, 0x16, 0x0E, 0xED, 0x02, 0xED, 0xFA,
  0x01, 0x03, 0xEE, 0x0E, 0x02, 0xFA, 0xFE, 0xF8,
  0xFD, 0xFA, 0x05, 0xF9, 0xF8, 0xFC, 0x01, 0x01
 },
 {
  0x08, 0x07, 0x19, 0xEB, 0x0C, 0xFA, 0xFB, 0xFC,
  0xF6, 0x06, 0x00, 0x0A, 0x01, 0xF4, 0x12, 0xFB,
  0xF1, 0x04, 0x01, 0x0E, 0xFF, 0x05, 0x08, 0xF9,
  0x01, 0xF9, 0xFD, 0x09, 0x0A, 0x01, 0xFF, 0x00
 },
 {
  0x09, 0x0A, 0x20, 0xF1, 0x08, 0x02, 0x0B, 0xF9,
  0xEE, 0xF8, 0x02, 0xFA, 0xF7, 0xF0, 0xFD, 0x03,
  0xFF, 0x03, 0x01, 0xFB, 0x04, 0xFE, 0x01, 0xF8,
  0x00, 0xFA, 0xFD, 0xF5, 0x01, 0x05, 0x00, 0x00
 },
 {
  0x0E, 0x00, 0x17, 0xE7, 0x16, 0x03, 0x07, 0x0A,
  0x00, 0xFE, 0x07, 0x08, 0x00, 0x0A, 0x00, 0x00,
  0x03, 0x02, 0x03, 0xF6, 0x00, 0x0A, 0x00, 0xF9,
  0x00, 0x0A, 0xFF, 0xFB, 0xF9, 0x01, 0xFF, 0x02
 },
 {
  0x0C, 0x00, 0x19, 0xEE, 0xFB, 0xFC, 0x0D, 0xF6,
  0x03, 0xFA, 0x07, 0x15, 0x00, 0xF0, 0x03, 0xF6,
  0xFA, 0x05, 0xF9, 0xFD, 0x02, 0x05, 0x03, 0xFA,
  0x04, 0x09, 0xF8, 0x0C, 0xFE, 0x03, 0x02, 0x04
 },
 {
  0x1F, 0x0F, 0x1B, 0xEC, 0x0A, 0xF9, 0x0F, 0xF6,
  0x09, 0xF8, 0x04, 0xFB, 0x03, 0xFD, 0x05, 0x06,
  0x0B, 0xFE, 0xF4, 0xFE, 0x06, 0xFE, 0x01, 0x02,
  0xFF, 0xFF, 0x01, 0x01, 0x03, 0x01, 0x01, 0x02
 },
 {
  0x0C, 0xFC, 0x0D, 0xE9, 0x0C, 0xFA, 0x02, 0x04,
  0xFD, 0x0D, 0x06, 0xF9, 0x05, 0xED, 0xF9, 0x12,
  0x01, 0xF9, 0x07, 0x01, 0x10, 0xF9, 0x03, 0x00,
  0x03, 0x00, 0xF4, 0x08, 0xF5, 0x09, 0x04, 0x07
 },
 {
  0x1D, 0x01, 0x03, 0xEA, 0xFB, 0x06, 0x00, 0x0C,
  0xF2, 0x0B, 0x01, 0x06, 0xFD, 0x04, 0x06, 0xFE,
  0x04, 0xF3, 0x0C, 0x01, 0x01, 0x03, 0xF5, 0x09,
  0xF6, 0xFF, 0xF9, 0x10, 0xF5, 0xFF, 0x03, 0x09
 },
 {
  0x04, 0x04, 0x24, 0xE9, 0xFB, 0xF8, 0xF1, 0x01,
  0xFA, 0x03, 0x0D, 0xFF, 0xFB, 0xF9, 0x04, 0x09,
  0x02, 0xF5, 0xFD, 0x05, 0x01, 0x03, 0xFA, 0xFF,
  0xFC, 0xFC, 0xFE, 0x02, 0x03, 0xFF, 0xFB, 0xFE
 },
 {
  0x13, 0x0A, 0x06, 0xEF, 0x02, 0xFC, 0xFE, 0xFC,
  0xFD, 0x0D, 0x02, 0x02, 0xF3, 0xF9, 0xFD, 0xF5,
  0x09, 0xFA, 0x01, 0xF7, 0xFB, 0x04, 0xFB, 0xF7,
  0xEE, 0xF9, 0xF5, 0x09, 0x04, 0xF5, 0x08, 0x04
 },
 {
  0x10, 0xFD, 0x09, 0xF0, 0x12, 0xFE, 0xF4, 0xF0,
  0xF5, 0x0B, 0xEE, 0x10, 0xF3, 0x06, 0x02, 0x08,
  0x03, 0x08, 0xFC, 0xF0, 0x0A, 0xF5, 0xFF, 0xFD,
  0xF8, 0x05, 0xF7, 0xFC, 0x09, 0xFC, 0x00, 0xFD
 },
 {
  0x0E, 0x0F, 0x03, 0xE9, 0xFB, 0x07, 0xF8, 0xFA,
  0x02, 0x11, 0x02, 0x0C, 0xF8, 0xF4, 0x0D, 0xFF,
  0xF7, 0x03, 0x01, 0x01, 0x13, 0x0F, 0x04, 0xFF,
  0x01, 0x02, 0xFD, 0x02, 0xFD, 0x01, 0x05, 0x03
 },
 {
  0x20, 0x05, 0xF6, 0xD1, 0xFB, 0xFF, 0x04, 0x0B,
  0xF9, 0x00, 0x02, 0xFE, 0x01, 0xF9, 0x06, 0xFC,
  0x06, 0x02, 0xFC, 0xFE, 0x02, 0xFE, 0x00, 0xFC,
  0x01, 0xFA, 0xFB, 0x02, 0xFE, 0xFF, 0xFD, 0xFC
 },
 {
  0x14, 0x08, 0x0A, 0xEB, 0xF9, 0xF7, 0xF0, 0x0C,
  0x01, 0x04, 0x06, 0xFB, 0x09, 0xF5, 0xF9, 0x04,
  0xF5, 0x1C, 0xFD, 0x02, 0x04, 0xFA, 0x0A, 0xF8,
  0xFB, 0xFB, 0xF7, 0x09, 0xFE, 0xFF, 0x06, 0xFB
 },
 {
  0x26, 0x03, 0x17, 0xE7, 0xFA, 0xEE, 0x03, 0xF6,
  0xF8, 0x06, 0xF6, 0x01, 0xF6, 0x02, 0x02, 0x00,
  0xF9, 0x02, 0xFC, 0x05, 0xFF, 0x08, 0xFD, 0x00,
  0x03, 0x03, 0xFF, 0x01, 0x00, 0xFC, 0xFC, 0x00
 },
 {
  0x14, 0x05, 0x10, 0xEA, 0x18, 0xEE, 0x02, 0xF4,
  0xF2, 0xF9, 0xFD, 0x0A, 0x02, 0x07, 0xF6, 0x02,
  0xF8, 0x01, 0x08, 0xFF, 0x04, 0x01, 0x04, 0xFE,
  0x05, 0xF7, 0xEE, 0xF8, 0xF3, 0x05, 0xF5, 0x0A
 },
 {
  0x0E, 0x08, 0xF4, 0xF0, 0x09, 0xF5, 0xFD, 0xFA,
  0xE7, 0xF9, 0x06, 0x05, 0xF9, 0xF0, 0x0A, 0x02,
  0xF9, 0xFF, 0xF7, 0xFD, 0x10, 0x04, 0x03, 0x03,
  0xFD, 0xFD, 0xF1, 0x0D, 0xFD, 0x04, 0x0D, 0xF9
 },
 {
  0x10, 0xF7, 0x13, 0xE9, 0x07, 0xED, 0xFD, 0xFB,
  0xF1, 0x0B, 0xEB, 0x15, 0xF0, 0x12, 0xFF, 0x06,
  0x0A, 0xF6, 0x12, 0xF2, 0x10, 0xF1, 0x06, 0xFB,
  0xF7, 0x05, 0xEF, 0x0D, 0xF6, 0x0D, 0x00, 0x0A
 },
 {
  0x08, 0xFC, 0x04, 0xE8, 0x08, 0xEB, 0xEE, 0x09,
  0xF5, 0x04, 0xFA, 0x11, 0x05, 0xF7, 0xFE, 0xFE,
  0x02, 0x0F, 0xFE, 0xFD, 0xFE, 0x01, 0x07, 0xF3,
  0x0F, 0xF6, 0xF8, 0xF5, 0x03, 0x03, 0xFF, 0xFF
 },
 {
  0x0E, 0x11, 0x06, 0xE0, 0x05, 0xEF, 0xFE, 0x00,
  0x0F, 0xFF, 0xFB, 0x10, 0x01, 0xFB, 0xFE, 0x09,
  0xFD, 0x08, 0x04, 0xFE, 0xFE, 0xFC, 0xFD, 0x01,
  0x00, 0x07, 0xFD, 0x04, 0xFB, 0x00, 0xF9, 0x02
 },
 {
  0x18, 0x06, 0x16, 0xF4, 0x08, 0x03, 0xF2, 0x04,
  0xF9, 0x08, 0x06, 0x05, 0x06, 0x01, 0x06, 0xF4,
  0x0F, 0x0A, 0x04, 0x0B, 0x09, 0x06, 0xF9, 0xFC,
  0x0A, 0xF7, 0x02, 0xFF, 0xFB, 0x0B, 0x0F, 0x03
 },
 {
  0x11, 0x0C, 0x03, 0xE9, 0x05, 0xFF, 0xFE, 0x01,
  0xF7, 0xFF, 0xFD, 0x01, 0x08, 0x01, 0xFB, 0x11,
  0x0B, 0x00, 0xFE, 0xF5, 0x07, 0x04, 0x00, 0xE5,
  0xF9, 0x01, 0x02, 0xF8, 0x09, 0x07, 0x05, 0x03
 },
 {
  0x0C, 0x0A, 0x0C, 0xF6, 0xFC, 0x05, 0xFF, 0x02,
  0xE8, 0x05, 0xF8, 0x02, 0x06, 0xEF, 0x13, 0x05,
  0x0C, 0xFE, 0x10, 0xF9, 0xFA, 0xF2, 0x04, 0x01,
  0xFD, 0x0D, 0xF0, 0x05, 0xFF, 0x04, 0x01, 0x01
 },
 {
  0x1F, 0x09, 0x0B, 0xEF, 0x0A, 0xFD, 0xF9, 0x07,
  0x01, 0x02, 0x02, 0x04, 0xFD, 0xFF, 0x0B, 0x04,
  0xFB, 0xF8, 0x01, 0x04, 0x0F, 0xFA, 0xE4, 0x01,
  0x08, 0x03, 0xFA, 0x05, 0x11, 0xFE, 0x02, 0xFC
 },
 {
  0x0B, 0x13, 0x10, 0xE6, 0x00, 0xF9, 0xF9, 0x02,
  0xF3, 0xF1, 0xF4, 0x09, 0xFD, 0x1B, 0x08, 0x04,
  0xFA, 0x01, 0x04, 0xFA, 0x0B, 0xFF, 0xFA, 0xF9,
  0xFD, 0x00, 0xFA, 0x04, 0xFA, 0xF9, 0xFD, 0xFF
 },
 {
  0x0A, 0x12, 0x10, 0xE0, 0x13, 0xF7, 0xFC, 0xFD,
  0xF9, 0x08, 0x08, 0xFD, 0xF5, 0xFE, 0xFA, 0xF0,
  0x0D, 0x0D, 0xFA, 0xFF, 0x0A, 0xFE, 0xFE, 0xF7,
  0x00, 0xFD, 0x09, 0x04, 0x0B, 0xFE, 0xFA, 0x06
 },
 {
  0x09, 0x04, 0x13, 0xDF, 0x04, 0x07, 0xF4, 0x24,
  0xFD, 0xFF, 0x08, 0xFE, 0x02, 0xF8, 0xF7, 0xFC,
  0xF8, 0x00, 0x01, 0xFF, 0x00, 0xFC, 0xFC, 0x03,
  0x00, 0x03, 0x06, 0x00, 0xFA, 0x02, 0x00, 0xFE
 },
 {
  0x19, 0x07, 0x0F, 0xF4, 0x02, 0xE8, 0xFF, 0x18,
  0xFC, 0x04, 0x09, 0x00, 0xFE, 0xF7, 0x04, 0x06,
  0x03, 0x0D, 0xFD, 0x01, 0x05, 0xFF, 0xFD, 0xFB,
  0xFF, 0x07, 0xFE, 0x03, 0x04, 0x04, 0x01, 0x00
 },
 {
  0x13, 0x06, 0x08, 0xEC, 0x09, 0xF7, 0x05, 0xFC,
  0xF3, 0x07, 0x0B, 0xFD, 0x05, 0xF3, 0xF7, 0x06,
  0xF5, 0xFF, 0x00, 0x04, 0x0B, 0x1A, 0x03, 0x06,
  0xF9, 0x0C, 0x06, 0xFD, 0x01, 0xF7, 0x07, 0x01
 },
 {
  0x0F, 0x06, 0x13, 0xE9, 0xFD, 0xF7, 0x03, 0x10,
  0xFA, 0xFC, 0x06, 0xFB, 0xF6, 0x01, 0x10, 0xF2,
  0x02, 0x00, 0x02, 0xF3, 0xFD, 0x08, 0xFA, 0x03,
  0x01, 0x01, 0x02, 0xFB, 0x0C, 0xFC, 0xF8, 0xFD
 },
 {
  0x0E, 0x04, 0x10, 0xEC, 0x01, 0x0C, 0x00, 0x06,
  0xFD, 0x09, 0x04, 0x10, 0x0A, 0xF0, 0x05, 0x07,
  0x05, 0xFC, 0xFC, 0xEE, 0xFD, 0xF5, 0xFC, 0x04,
  0xF9, 0x03, 0x0D, 0x07, 0x03, 0x03, 0x02, 0xF9
 },
 {
  0x16, 0x03, 0xFF, 0xE2, 0x12, 0xFD, 0xF7, 0x09,
  0xFE, 0x0B, 0xF0, 0xFE, 0xF2, 0x0C, 0x00, 0x04,
  0xFB, 0x04, 0xFF, 0x03, 0xEC, 0x0C, 0x04, 0xF6,
  0xFE, 0xFE, 0xF4, 0xF4, 0x0A, 0x06, 0x0B, 0xFD
 },
 {
  0x0F, 0x07, 0x02, 0xEB, 0x05, 0x04, 0x09, 0xF7,
  0xDF, 0x07, 0x07, 0x03, 0xFA, 0xF2, 0xF8, 0x0A,
  0x0C, 0x00, 0x02, 0xFF, 0x05, 0x04, 0xFE, 0x00,
  0xF9, 0x00, 0x02, 0x04, 0x00, 0x01, 0xFD, 0x08
 },
 {
  0xF9, 0x00, 0x0C, 0x03, 0x00, 0xFA, 0x08, 0xFC,
  0x00, 0x02, 0x0E, 0xF1, 0x02, 0xF9, 0xE1, 0xFD,
  0x0E, 0x00, 0x0E, 0xF1, 0xFF, 0xFC, 0xF1, 0x0A,
  0x01, 0xFD, 0x01, 0x02, 0x05, 0x02, 0xF8, 0x01
 },
 {
  0xFE, 0x05, 0x01, 0x00, 0xFD, 0x03, 0x03, 0xFA,
  0xFF, 0x02, 0xFC, 0x01, 0xED, 0x00, 0xF5, 0x12,
  0x0B, 0x0A, 0x15, 0x05, 0x06, 0x02, 0x0A, 0x03,
  0xFA, 0x00, 0xFE, 0x0D, 0x05, 0xFF, 0xFE, 0x09
 },
 {
  0xF7, 0x01, 0xFB, 0x00, 0x00, 0xF1, 0x08, 0x04,
  0x08, 0x03, 0x08, 0x0C, 0xF3, 0xFE, 0xD9, 0xFE,
  0x04, 0xFC, 0x05, 0xFD, 0xFC, 0x03, 0xFD, 0x03,
  0x0A, 0x05, 0x03, 0x02, 0xFD, 0x05, 0xFE, 0x08
 },
 {
  0xF7, 0x06, 0x06, 0xF8, 0x0C, 0xF4, 0x17, 0xEE,
  0x04, 0xF1, 0xFB, 0x02, 0xEC, 0x0D, 0xF9, 0x07,
  0x07, 0xF4, 0x0E, 0xF4, 0x06, 0x01, 0x01, 0xFD,
  0xF8, 0x09, 0x00, 0x01, 0xF9, 0x03, 0x07, 0xFA
 },
 {
  0xEE, 0x0D, 0x04, 0x03, 0xF6, 0xE2, 0xF6, 0xFA,
  0xF2, 0x01, 0xF9, 0xFC, 0xDD, 0x05, 0xE7, 0x0B,
  0x09, 0x08, 0x13, 0xFC, 0xF9, 0xFD, 0xEE, 0xF8,
  0x01, 0x05, 0x0A, 0xFC, 0xF2, 0xF7, 0x03, 0xFC
 },
 {
  0xFA, 0xFF, 0x04, 0xF7, 0xF7, 0x04, 0x14, 0x00,
  0x00, 0x03, 0x0B, 0x07, 0xF0, 0xEF, 0xEC, 0x0B,
  0xFA, 0xF2, 0x01, 0x04, 0x13, 0x02, 0xF8, 0x06,
  0xF1, 0x03, 0x06, 0xFB, 0xF2, 0x03, 0x07, 0x02
 },
 {
  0x01, 0x06, 0xFE, 0xF8, 0xFB, 0xFD, 0x03, 0xF8,
  0x15, 0x01, 0x03, 0x10, 0xF2, 0xFE, 0xF7, 0xFC,
  0x0D, 0xFE, 0x12, 0x0E, 0x0E, 0x13, 0xF3, 0x05,
  0xF6, 0x02, 0xFD, 0x03, 0x05, 0x05, 0x01, 0xFF
 },
 {
  0xFF, 0xFB, 0xFA, 0xFE, 0xF5, 0xF9, 0x05, 0xFC,
  0x05, 0xFF, 0x00, 0x03, 0xFD, 0x02, 0xED, 0x12,
  0x10, 0x04, 0x0E, 0xEA, 0xFE, 0xF5, 0xEA, 0x01,
  0xFF, 0x0B, 0x01, 0x02, 0x0B, 0xF6, 0x07, 0xF4
 },
 {
  0x01, 0x04, 0x05, 0xFF, 0xF7, 0xFB, 0x01, 0x0C,
  0x05, 0x06, 0x0C, 0x09, 0xE8, 0x17, 0x01, 0x14,
  0x0E, 0xF5, 0x0D, 0x05, 0xFE, 0xFE, 0x05, 0x06,
  0x02, 0x01, 0xF7, 0x06, 0x0A, 0x05, 0xFC, 0x0B
 },
 {
  0xFF, 0xFF, 0x01, 0x07, 0xFD, 0xFC, 0x08, 0xF0,
  0x0F, 0xFF, 0xF9, 0x09, 0xEA, 0xF5, 0xF5, 0x0A,
  0x10, 0x09, 0xFE, 0x04, 0x0D, 0x0A, 0x06, 0x10,
  0x04, 0x07, 0x01, 0xF8, 0xF9, 0xF2, 0xF9, 0x04
 },
 {
  0x01, 0x03, 0xFA, 0x00, 0x0F, 0xF7, 0xFC, 0x00,
  0x04, 0x06, 0x0C, 0x09, 0xFA, 0xFB, 0xEA, 0x11,
  0x07, 0xF5, 0x0F, 0xFB, 0x01, 0x03, 0xED, 0x00,
  0xF1, 0xFD, 0x10, 0x05, 0x05, 0xF9, 0xF5, 0x0C
 },
 {
  0xFE, 0xFF, 0x0D, 0x02, 0x04, 0xE8, 0x25, 0xFB,
  0xFE, 0xFA, 0x0C, 0x07, 0xFE, 0xE9, 0xFC, 0x09,
  0x02, 0xFD, 0x03, 0x02, 0x03, 0x03, 0xF2, 0x0B,
  0x00, 0xFC, 0xFE, 0xFE, 0x03, 0x0A, 0xF6, 0x04
 },
 {
  0x02, 0x09, 0x08, 0xFA, 0xE4, 0x0E, 0x1C, 0xF5,
  0x12, 0xF5, 0x00, 0x02, 0xFE, 0x04, 0xF4, 0x03,
  0x06, 0x00, 0x07, 0xF9, 0xFA, 0x02, 0x05, 0xFF,
  0xFF, 0xFF, 0x05, 0x02, 0x03, 0x00, 0xFD, 0x09
 },
 {
  0xF9, 0x0E, 0x05, 0xF6, 0xFD, 0x07, 0x04, 0xFB,
  0x07, 0xF8, 0xF9, 0x04, 0xF4, 0x0E, 0xF0, 0x19,
  0x03, 0x00, 0x01, 0xFB, 0x0C, 0xF6, 0x00, 0xF6,
  0x00, 0x0C, 0x0C, 0x11, 0x0C, 0x0A, 0xFF, 0x00
 },
 {
  0xFC, 0xFE, 0x05, 0xFE, 0xEF, 0xFD, 0x05, 0xFB,
  0x07, 0xEF, 0x01, 0x05, 0xFC, 0x04, 0xEC, 0x00,
  0x0B, 0xF1, 0x0D, 0xF8, 0x0A, 0x01, 0x01, 0x05,
  0xF4, 0x09, 0xF8, 0x00, 0x06, 0xFF, 0xF5, 0x04
 },
 {
  0xFD, 0x0C, 0x0D, 0xF1, 0xF9, 0xF9, 0x00, 0x05,
  0x21, 0x03, 0x03, 0xFA, 0xF3, 0xF9, 0xF1, 0x0A,
  0x03, 0x03, 0x03, 0xFB, 0x02, 0x07, 0xFF, 0x00,
  0xF4, 0x02, 0x0B, 0xFA, 0xF7, 0x00, 0x05, 0x0B
 },
 {
  0xF8, 0x05, 0x0A, 0xF9, 0xF2, 0xFC, 0x0D, 0x00,
  0x12, 0xFD, 0xFA, 0x07, 0x01, 0xFA, 0x00, 0x15,
  0x08, 0xF9, 0x0A, 0xF8, 0xFD, 0x11, 0xF7, 0x00,
  0xFB, 0x01, 0x04, 0x08, 0xFD, 0x0B, 0xFB, 0x00
 },
 {
  0xF8, 0x08, 0xFD, 0xF8, 0x08, 0xF5, 0x10, 0xF0,
  0x11, 0x00, 0x08, 0x10, 0xEF, 0x0A, 0xF0, 0x0A,
  0xF8, 0x06, 0x0B, 0x00, 0x0A, 0x07, 0x04, 0x05,
  0x07, 0xFB, 0xFB, 0xFA, 0xF9, 0xFB, 0xFF, 0x10
 },
 {
  0xFA, 0x00, 0x06, 0x01, 0xF8, 0xF8, 0x08, 0xF9,
  0xFB, 0xF6, 0xF5, 0x08, 0xED, 0x06, 0xF9, 0x0D,
  0x05, 0xFD, 0x04, 0xF8, 0x07, 0xFF, 0xEE, 0x09,
  0x00, 0xFB, 0x06, 0x1A, 0x03, 0x08, 0x02, 0x04
 },
 {
  0xFE, 0xFE, 0x17, 0xFE, 0xEC, 0x02, 0x07, 0xF9,
  0xFA, 0xF1, 0x03, 0x09, 0xED, 0xFE, 0xF6, 0x07,
  0xFE, 0x07, 0x09, 0x0B, 0x00, 0x04, 0xFC, 0x06,
  0x09, 0xFE, 0x04, 0xFD, 0x04, 0x03, 0x02, 0x08
 },
 {
  0xFA, 0x0C, 0x0A, 0xF6, 0xF9, 0x04, 0x11, 0x0B,
  0xFA, 0x01, 0x0C, 0x0B, 0xEE, 0x08, 0xF4, 0x04,
  0x01, 0x0D, 0x06, 0xF3, 0x17, 0x09, 0xFB, 0x08,
  0xFE, 0xFB, 0x01, 0x03, 0x00, 0xFE, 0xFC, 0x04
 },
 {
  0x07, 0x01, 0x07, 0xEF, 0xF8, 0x08, 0xFF, 0xF9,
  0x05, 0xFA, 0x04, 0xFD, 0xF0, 0x09, 0xE8, 0x12,
  0xFD, 0x0A, 0x0D, 0xF5, 0xFA, 0xF5, 0xFC, 0x0A,
  0x00, 0x0B, 0x08, 0x02, 0x06, 0xFB, 0xF5, 0x04
 },
 {
  0xFC, 0x01, 0xFB, 0xF6, 0x00, 0xFD, 0x09, 0xFE,
  0x04, 0xFF, 0x01, 0x05, 0xD7, 0xF6, 0xF9, 0x04,
  0xFD, 0x03, 0x01, 0x00, 0xF4, 0x04, 0xFD, 0x00,
  0x02, 0xFF, 0xFE, 0xFB, 0x03, 0x02, 0xF9, 0x05
 },
 {
  0xFE, 0x01, 0x04, 0x04, 0xFD, 0xFA, 0x01, 0x00,
  0x0C, 0xFB, 0x0B, 0x00, 0xEF, 0xFD, 0xFF, 0x0B,
  0x04, 0x01, 0x1B, 0xF4, 0x00, 0xF2, 0x02, 0xF1,
  0xFD, 0xF7, 0x00, 0xF9, 0xFD, 0x0F, 0xF8, 0x06
 },
 {
  0xFA, 0x04, 0x09, 0x02, 0x04, 0x03, 0x07, 0xF6,
  0x1C, 0x01, 0xFE, 0x30, 0x07, 0x00, 0xF6, 0x0A,
  0x01, 0xF7, 0x02, 0xFF, 0x00, 0x03, 0xFB, 0x05,
  0xFC, 0xFE, 0x07, 0x07, 0x01, 0x03, 0x02, 0x05
 },
 {
  0xFD, 0x03, 0xFF, 0x03, 0xF7, 0x00, 0xFF, 0x03,
  0x02, 0xFA, 0x27, 0xF2, 0xF4, 0x05, 0xED, 0x15,
  0x07, 0xFA, 0x04, 0xFF, 0xFC, 0x00, 0xFC, 0x01,
  0x00, 0xF7, 0x01, 0x0A, 0x00, 0xFE, 0x00, 0x07
 },
 {
  0x04, 0x02, 0xE3, 0x0C, 0x05, 0xFD, 0x10, 0xFA,
  0x0F, 0xF3, 0xFC, 0xFF, 0xF3, 0x16, 0xF0, 0x11,
  0x10, 0x04, 0x09, 0xFC, 0x04, 0xFA, 0xFC, 0x0B,
  0xF8, 0x07, 0x08, 0x04, 0x03, 0xFD, 0xF9, 0xF3
 },
 {
  0x00, 0x03, 0x03, 0xFA, 0xFC, 0x00, 0x09, 0x00,
  0x05, 0x00, 0x0A, 0x0A, 0x04, 0xF3, 0xF4, 0x10,
  0x17, 0xFC, 0xF4, 0xFA, 0xFC, 0x14, 0x02, 0x00,
  0xFC, 0x17, 0x01, 0x08, 0x0B, 0xFC, 0xFB, 0x0F
 },
 {
  0xFA, 0x04, 0xF1, 0xF7, 0xFF, 0xED, 0x0C, 0xE2,
  0xEF, 0xFC, 0x01, 0xF3, 0xF3, 0x04, 0xFD, 0x1A,
  0x05, 0xE7, 0x0B, 0xF2, 0xFA, 0xF3, 0x00, 0xF9,
  0x09, 0x02, 0x08, 0xFF, 0xF8, 0x01, 0xF8, 0x0D
 },
 {
  0x01, 0x06, 0x01, 0xFC, 0xFC, 0x01, 0x02, 0x00,
  0xFD, 0x02, 0x0A, 0x06, 0xFA, 0xFE, 0xF5, 0x04,
  0x20, 0x0F, 0x0F, 0xD1, 0xF8, 0x03, 0xF4, 0x04,
  0xFB, 0x04, 0xFF, 0x00, 0xFB, 0x05, 0x01, 0xF9
 },
 {
  0x02, 0xFF, 0x00, 0x00, 0xFF, 0xFA, 0x00, 0xFA,
  0x04, 0xFC, 0x05, 0x09, 0xFB, 0x01, 0xFD, 0x33,
  0x04, 0xFB, 0x04, 0xF2, 0xFF, 0xFC, 0xFD, 0x01,
  0xFC, 0xFF, 0x00, 0x02, 0xF8, 0x00, 0x01, 0x02
 },
 {
  0x00, 0x04, 0xFE, 0xF9, 0xFE, 0xF7, 0x06, 0xF8,
  0x0B, 0xFD, 0xFA, 0x03, 0xF5, 0xF8, 0xF4, 0x08,
  0x0B, 0x05, 0x13, 0x03, 0xE8, 0x13, 0xF2, 0x0B,
  0xFB, 0xEE, 0xF8, 0xF4, 0xFB, 0xFC, 0xFF, 0x04
 },
 {
  0x10, 0x09, 0x0A, 0x0E, 0xEE, 0xFE, 0xEE, 0xE5,
  0x0A, 0xFB, 0x0C, 0x0E, 0x04, 0x00, 0xFE, 0xFA,
  0xF4, 0xF9, 0xFF, 0x03, 0x04, 0x07, 0x0B, 0x0A,
  0x05, 0xFB, 0xF9, 0xF0, 0xFD, 0xFA, 0x06, 0x09
 },
 {
  0x07, 0x0F, 0xF7, 0x0A, 0xED, 0x04, 0xFB, 0xDB,
  0xFE, 0xFC, 0x08, 0x02, 0x04, 0xFF, 0x01, 0x09,
  0xFB, 0xFB, 0xF4, 0x01, 0xFF, 0xF8, 0x03, 0xFD,
  0x04, 0x06, 0x09, 0x03, 0x03, 0xFF, 0x02, 0x04
 },
 {
  0x0D, 0x11, 0x03, 0x09, 0xF9, 0xF9, 0xF1, 0xEF,
  0xF8, 0xF3, 0xFC, 0xF8, 0x13, 0x02, 0x10, 0x19,
  0x07, 0x0F, 0x02, 0x10, 0xFB, 0xFA, 0xF6, 0xF7,
  0xF9, 0xFA, 0xFE, 0xF9, 0x07, 0x02, 0x04, 0x05
 },
 {
  0x18, 0x07, 0x09, 0x08, 0xF3, 0xFE, 0x00, 0xFC,
  0x01, 0xF3, 0x03, 0x06, 0x07, 0x0A, 0xFC, 0x0F,
  0x05, 0x07, 0xFC, 0x05, 0xFB, 0x03, 0x0D, 0xF9,
  0x05, 0x0F, 0xF5, 0xFE, 0x07, 0x05, 0x08, 0x06
 },
 {
  0x11, 0x06, 0xF1, 0x17, 0xFE, 0xFF, 0xFA, 0xFE,
  0x00, 0xFC, 0x0B, 0xFD, 0x0C, 0x0F, 0x06, 0xF8,
  0xF1, 0x0A, 0xF7, 0x07, 0xFF, 0xF5, 0x02, 0xF8,
  0xFC, 0x03, 0x04, 0xF6, 0x04, 0x04, 0x0B, 0x01
 },
 {
  0x15, 0x0C, 0xFD, 0x06, 0xF8, 0x08, 0xF5, 0xF8,
  0xFB, 0xFB, 0x03, 0x07, 0xFF, 0xFB, 0x0C, 0x0F,
  0xF6, 0xF5, 0x03, 0x0F, 0x08, 0x04, 0x02, 0xF1,
  0x00, 0x0E, 0x01, 0xF8, 0xFF, 0x03, 0x0A, 0xF9
 },
 {
  0x10, 0x0C, 0x05, 0x0D, 0xFA, 0x0F, 0xE9, 0x00,
  0xEF, 0xF7, 0x00, 0x04, 0xF7, 0x0D, 0x06, 0x12,
  0x00, 0x00, 0xFC, 0xFF, 0x00, 0x0E, 0x05, 0xFF,
  0x08, 0xFC, 0xF8, 0xFA, 0x05, 0xFE, 0xFE, 0x00
 },
 {
  0x0E, 0x10, 0xFF, 0x0C, 0xF1, 0xF7, 0xFA, 0xEC,
  0x04, 0x06, 0x08, 0x09, 0x03, 0x01, 0xF7, 0xFC,
  0xFF, 0xF5, 0x09, 0x0B, 0xF4, 0x01, 0xF2, 0xF9,
  0x02, 0xF8, 0x0B, 0x09, 0xFC, 0x0A, 0x04, 0xF0
 },
 {
  0x0D, 0x0A, 0x03, 0x07, 0x00, 0xF8, 0xDF, 0xFA,
  0x04, 0xFC, 0x13, 0xFE, 0x0E, 0x06, 0x05, 0x07,
  0x06, 0xFD, 0xFF, 0xF6, 0xF6, 0xF7, 0x04, 0xFD,
  0x05, 0x09, 0x02, 0x02, 0x0A, 0x09, 0xFE, 0xFD
 },
 {
  0x0B, 0x0A, 0x19, 0x12, 0xFF, 0xFA, 0xEB, 0xEB,
  0xF5, 0xF0, 0x06, 0x05, 0x0E, 0x04, 0x08, 0x07,
  0x00, 0xF6, 0xF9, 0xF7, 0xFB, 0xFC, 0x03, 0xFF,
  0x01, 0x06, 0xFF, 0x06, 0xFE, 0x02, 0xFD, 0xF7
 },
 {
  0x0F, 0x09, 0x05, 0x16, 0xEF, 0x0F, 0xF7, 0x07,
  0x07, 0xF7, 0x0D, 0x09, 0x0A, 0xFF, 0x08, 0xFD,
  0xFE, 0x06, 0x01, 0x11, 0x08, 0xF2, 0x07, 0xFD,
  0x0C, 0x09, 0x01, 0x00, 0x01, 0xFB, 0x11, 0xEE
 },
 {
  0x19, 0x13, 0xEF, 0x0C, 0xFC, 0xF6, 0x01, 0xF3,
  0xED, 0xF9, 0xFD, 0x09, 0x06, 0xFE, 0x03, 0x01,
  0x04, 0xFE, 0xF5, 0xF2, 0xFF, 0xF9, 0xFB, 0xF7,
  0x07, 0xFF, 0xFD, 0x04, 0xFB, 0x01, 0x00, 0xFF
 },
 {
  0x14, 0x08, 0xFD, 0xF6, 0xE8, 0x03, 0xFA, 0xFE,
  0x00, 0xF4, 0x0E, 0x06, 0x07, 0x0B, 0x04, 0x07,
  0xF4, 0xFB, 0xF8, 0xF6, 0x05, 0xFF, 0xFC, 0x04,
  0x10, 0x07, 0xF2, 0x06, 0xFF, 0xFE, 0xF9, 0xF5
 },
 {
  0x10, 0x12, 0x11, 0x01, 0xF1, 0xFA, 0xFB, 0xFD,
  0xFF, 0xED, 0x08, 0xFE, 0x02, 0x08, 0x0C, 0xED,
  0xF4, 0x08, 0x00, 0xFD, 0xFF, 0xFF, 0x04, 0xF2,
  0x09, 0xFF, 0xF4, 0xFF, 0xF9, 0x0A, 0xFD, 0x05
 },
 {
  0x12, 0x0C, 0xF9, 0x07, 0x00, 0xFD, 0xF3, 0x00,
  0xFF, 0xFC, 0x09, 0xFE, 0x06, 0xFF, 0x00, 0x01,
  0x0F, 0xEB, 0x01, 0xF8, 0x19, 0xED, 0x0D, 0xF7,
  0x02, 0x0C, 0x05, 0xF9, 0xFD, 0xFF, 0xFD, 0x01
 },
 {
  0x0D, 0x10, 0xFC, 0x09, 0xFE, 0x02, 0xFF, 0xED,
  0xF9, 0xFC, 0x12, 0xFA, 0x0E, 0x12, 0xFB, 0x04,
  0xFA, 0xFD, 0xED, 0xF2, 0xFF, 0xF4, 0x0A, 0x06,
  0x07, 0x11, 0xF4, 0xF3, 0xF6, 0xFC, 0x05, 0x04
 },
 {
  0x1B, 0x11, 0x04, 0x0E, 0xF7, 0xFE, 0xFC, 0xF8,
  0x00, 0xFA, 0x0E, 0xF5, 0xF9, 0x02, 0xFD, 0xFD,
  0xFE, 0xFD, 0xF3, 0x0C, 0x10, 0x01, 0xFB, 0xF7,
  0xF6, 0xF5, 0xFE, 0x03, 0xF9, 0x05, 0x0B, 0xF9
 },
 {
  0x07, 0x11, 0xF0, 0xFE, 0xF2, 0xE4, 0xF9, 0xF8,
  0x0F, 0xF6, 0x07, 0x0F, 0x08, 0x11, 0x0D, 0xFF,
  0x04, 0xF9, 0xF4, 0xF5, 0x00, 0x00, 0x02, 0x03,
  0xFD, 0x07, 0xFA, 0x06, 0x01, 0xF0, 0x01, 0xFE
 },
 {
  0x17, 0x0B, 0xF7, 0x0F, 0xE9, 0xFC, 0xFA, 0xFC,
  0x02, 0xF7, 0xF9, 0x09, 0xF8, 0x03, 0xF3, 0xFC,
  0x08, 0x12, 0xFA, 0xFE, 0x01, 0xFB, 0x06, 0xF2,
  0xFB, 0xFE, 0xFA, 0xFB, 0xFD, 0xFE, 0x04, 0xFB
 },
 {
  0x0C, 0x0D, 0x12, 0x12, 0xDD, 0x02, 0x07, 0xEF,
  0x03, 0xF5, 0x06, 0x09, 0xFD, 0xFE, 0x0A, 0xFC,
  0x03, 0x03, 0xFE, 0xF9, 0x00, 0x02, 0xFC, 0x00,
  0xFC, 0x00, 0xFA, 0x05, 0x0A, 0x04, 0xFD, 0xFF
 },
 {
  0x13, 0x0B, 0x01, 0x14, 0xF2, 0x04, 0xF7, 0xF3,
  0xFE, 0x0B, 0x00, 0x11, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFB, 0xF8, 0x00, 0x05, 0xFF, 0xF8, 0x05, 0xFF,
  0x03, 0x02, 0xF4, 0x15, 0xFE, 0xE8, 0x05, 0x07
 },
 {
  0x0F, 0x0F, 0xF1, 0x11, 0xF2, 0xEA, 0x03, 0xFC,
  0xF5, 0xFD, 0xF9, 0x01, 0x12, 0x0A, 0x01, 0x0A,
  0xFA, 0xFD, 0x08, 0x02, 0xF9, 0x00, 0xFE, 0x01,
  0x01, 0x02, 0xF7, 0xFE, 0x01, 0x02, 0xFD, 0x04
 },
 {
  0x2D, 0x0D, 0x08, 0x11, 0xFB, 0x02, 0xF0, 0x02,
  0x08, 0xFE, 0x08, 0xF1, 0x04, 0x05, 0xFF, 0x07,
  0xFA, 0xFE, 0xFA, 0x02, 0xFD, 0x00, 0x00, 0xF7,
  0xFF, 0x07, 0x02, 0x03, 0xFD, 0xFD, 0xFF, 0x05
 },
 {
  0x01, 0x12, 0xF8, 0x12, 0xF4, 0xF6, 0x03, 0x04,
  0xEA, 0xF4, 0x14, 0x08, 0xFD, 0x09, 0x02, 0x0A,
  0xF6, 0xFD, 0x09, 0x03, 0x06, 0xFD, 0x0A, 0xFF,
  0xFD, 0x02, 0xFE, 0x04, 0x02, 0x03, 0xFD, 0xEE
 },
 {
  0x09, 0x0A, 0xFB, 0x09, 0xDD, 0xEB, 0xEE, 0xF0,
  0xFF, 0xF4, 0xFA, 0xF9, 0xF1, 0xED, 0x0C, 0x04,
  0x04, 0x09, 0xF9, 0x02, 0x0E, 0x01, 0x04, 0x00,
  0xFF, 0x06, 0xF9, 0x02, 0x01, 0x01, 0xFC, 0x04
 },
 {
  0x1F, 0x08, 0xEF, 0x23, 0xF8, 0x01, 0xFB, 0xFA,
  0xF9, 0xFA, 0x0A, 0xFE, 0xFD, 0x06, 0x09, 0x03,
  0xFA, 0xFE, 0x03, 0x03, 0x05, 0xFD, 0x00, 0x06,
  0x00, 0x01, 0xFB, 0xFD, 0xFE, 0xFC, 0xFF, 0x00
 },
 {
  0x12, 0x04, 0xF8, 0x07, 0xF8, 0xF1, 0xFF, 0xF0,
  0x0C, 0x12, 0x03, 0x13, 0x02, 0x04, 0x08, 0x08,
  0x00, 0xFB, 0xF8, 0xF4, 0x0A, 0xFB, 0x00, 0x01,
  0x00, 0x04, 0xFD, 0x10, 0x0B, 0x0B, 0xFE, 0xFA
 },
 {
  0x1B, 0x0F, 0xEF, 0xF6, 0xE9, 0xEA, 0xFF, 0xF2,
  0xFC, 0xF9, 0x14, 0xFE, 0xF9, 0x06, 0x0F, 0xFB,
  0x20, 0x04, 0x09, 0xF5, 0xFD, 0xF8, 0x0B, 0xFC,
  0xFF, 0xFC, 0xF8, 0xFA, 0xFC, 0xFB, 0xFE, 0xF9
 },
 {
  0x16, 0x04, 0xF9, 0x02, 0xF1, 0xF5, 0xEF, 0xF6,
  0x02, 0x00, 0x0F, 0x0B, 0x07, 0x0C, 0xF8, 0x06,
  0xF6, 0xEE, 0xFA, 0xF4, 0x07, 0x03, 0x16, 0x03,
  0xF9, 0x0E, 0xFB, 0xFE, 0xF3, 0xF9, 0xFF, 0xF9
 },
 {
  0x12, 0x0D, 0x09, 0x18, 0xFC, 0xED, 0xF7, 0xF5,
  0x0D, 0x08, 0x02, 0x04, 0xFF, 0x08, 0x0E, 0x0A,
  0xF4, 0x00, 0x00, 0x05, 0x0A, 0x05, 0x04, 0xFF,
  0x05, 0x01, 0xFF, 0x0B, 0x02, 0xFC, 0x00, 0xF7
 },
 {
  0x0F, 0x13, 0xFB, 0x01, 0xFC, 0xF6, 0xF8, 0xE5,
  0x06, 0x08, 0x05, 0x0A, 0x04, 0x0B, 0x05, 0xFB,
  0xF5, 0x00, 0xF5, 0xF2, 0xFC, 0xF7, 0xF8, 0xF8,
  0x06, 0xF7, 0x04, 0xFB, 0xFF, 0x01, 0x05, 0xFC
 },
 {
  0x12, 0x01, 0xF3, 0x0E, 0xF2, 0x09, 0xF1, 0xF9,
  0x0C, 0x01, 0x0D, 0xFC, 0xEC, 0x0C, 0x0A, 0x0C,
  0xF4, 0x07, 0x01, 0xF3, 0x0A, 0xFA, 0x05, 0xFD,
  0x04, 0x08, 0x0A, 0xF3, 0xFD, 0xFA, 0x09, 0xFD
 },
 {
  0x13, 0xF2, 0x05, 0xF8, 0xFA, 0x02, 0xFB, 0x05,
  0xFD, 0xFF, 0xE4, 0x0B, 0x12, 0xFA, 0xFC, 0xFE,
  0x0B, 0x0E, 0xD5, 0xD6, 0x09, 0x02, 0x14, 0xE9,
  0x06, 0x20, 0x00, 0x05, 0x00, 0x06, 0x09, 0x05
 },
 {
  0x08, 0x0B, 0xF2, 0xFF, 0x07, 0x0C, 0xF9, 0x02,
  0xF0, 0x02, 0x0A, 0xFD, 0xFF, 0xF9, 0xF9, 0xFF,
  0x01, 0xF6, 0xC4, 0xE9, 0xEE, 0x2A, 0xF3, 0x09,
  0x12, 0xF5, 0x00, 0x01, 0x00, 0x02, 0xFB, 0x01
 },
 {
  0xFB, 0xFF, 0x02, 0x00, 0x03, 0xFD, 0x03, 0xFE,
  0xFA, 0x00, 0xFD, 0xFD, 0x07, 0x02, 0x00, 0xFE,
  0xFE, 0x03, 0xDE, 0xF1, 0x25, 0x2F, 0x0A, 0x14,
  0x09, 0x01, 0x03, 0xEB, 0xE7, 0xDF, 0xF2, 0x08
 },
 {
  0x05, 0x06, 0x02, 0xFE, 0xFE, 0xFE, 0x06, 0x05,
  0xFB, 0x07, 0xFD, 0x01, 0xFB, 0xF3, 0x09, 0x03,
  0xEF, 0xED, 0xFE, 0xB1, 0xF4, 0xF9, 0xF8, 0xFA,
  0xFE, 0xFE, 0xFF, 0xFF, 0xF9, 0xF3, 0x06, 0xFF
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0x00, 0x03, 0x04, 0xA9, 0x06, 0xF5, 0x10, 0xF7,
  0xFF, 0x08, 0x00, 0x05, 0x00, 0x01, 0x02, 0x01
 },
 {
  0xFB, 0x06, 0x02, 0xE8, 0x05, 0xF7, 0xF9, 0x00,
  0x07, 0x03, 0xFD, 0x10, 0xF2, 0xF0, 0x00, 0x12,
  0x0F, 0xF7, 0xF2, 0xE4, 0xEF, 0x35, 0x0E, 0xFA,
  0xE4, 0xFF, 0xFD, 0xF6, 0xF9, 0xF2, 0x13, 0xF1
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x00,
  0xF3, 0x00, 0xCB, 0x03, 0xEA, 0x3F, 0x13, 0x10,
  0x01, 0xF5, 0x00, 0xFD, 0x00, 0xFD, 0x00, 0x01
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFA, 0xD5, 0xD5, 0xFE, 0x41, 0xF3, 0xFC,
  0x09, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00, 0x01
 },
 {
  0x00, 0x01, 0x00, 0x00, 0xFF, 0x00, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x02, 0xFF, 0xFF, 0xFD, 0xFF,
  0xE9, 0x01, 0xC3, 0xC9, 0x03, 0xE4, 0xFA, 0xFC,
  0xFC, 0x08, 0x02, 0x01, 0x01, 0xFF, 0x00, 0x00
 },
 {
  0x00, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00,
  0x01, 0xFF, 0x00, 0x01, 0xFF, 0x00, 0xF7, 0xFC,
  0xD0, 0xED, 0xCC, 0xD2, 0x0B, 0xF4, 0x05, 0xF2,
  0x00, 0xF6, 0x00, 0x00, 0xFF, 0xFE, 0xFF, 0x00
 },
 {
  0x00, 0xFD, 0xFF, 0xFC, 0x02, 0xFF, 0xF9, 0x03,
  0x01, 0x03, 0xFF, 0x01, 0xFD, 0x00, 0xF9, 0x00,
  0x03, 0xF9, 0xC3, 0xCD, 0xFC, 0xEB, 0xF0, 0xEB,
  0xF5, 0x0E, 0xF9, 0x08, 0x03, 0xFB, 0x01, 0x02
 },
 {
  0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x09, 0xFD,
  0x38, 0xF5, 0xFA, 0xBD, 0xFF, 0x0D, 0x00, 0x07,
  0x01, 0xF7, 0xFF, 0xFF, 0x00, 0x00, 0x01, 0x00
 },
 {
  0x0E, 0x09, 0xFE, 0x0E, 0xF6, 0xF6, 0x09, 0xFB,
  0x01, 0xF8, 0xE9, 0x1E, 0x08, 0xF9, 0x17, 0x08,
  0x02, 0x0A, 0xFF, 0xE5, 0xEF, 0x39, 0x16, 0x04,
  0xFB, 0x02, 0xF4, 0xFA, 0x02, 0xF9, 0xFC, 0xF7
 },
 {
  0x01, 0x05, 0x0C, 0xFE, 0xFE, 0xFD, 0x02, 0xFD,
  0x06, 0x00, 0x04, 0xFE, 0xF8, 0xFA, 0x00, 0x10,
  0xF1, 0x1D, 0xC9, 0xE3, 0xE8, 0x1D, 0x03, 0x0A,
  0x06, 0x0D, 0x0A, 0xFB, 0x15, 0x0B, 0xF2, 0x05
 },
 {
  0x04, 0x02, 0x1A, 0xFA, 0x0A, 0x0B, 0xE9, 0xF6,
  0xE5, 0xEC, 0x03, 0xE8, 0xF5, 0xF6, 0xF3, 0x19,
  0xF6, 0x05, 0xF7, 0xDC, 0xF9, 0x2B, 0x03, 0xF3,
  0x06, 0x0D, 0xFE, 0x00, 0x01, 0x03, 0xFD, 0xFC
 },
 {
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x01, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x01,
  0xF4, 0x0C, 0xE6, 0xC0, 0xF1, 0x1D, 0x25, 0xF9,
  0xFD, 0xF4, 0xFB, 0x0E, 0x08, 0xF8, 0xF6, 0xFE
 },
 {
  0x13, 0xFC, 0xF5, 0xF0, 0x08, 0x0E, 0x05, 0x13,
  0x03, 0x16, 0xF5, 0xEB, 0xFF, 0xFA, 0xF5, 0x0B,
  0x0A, 0xE8, 0xE9, 0xD8, 0xF8, 0x14, 0x11, 0x05,
  0x0D, 0xFA, 0x03, 0x0E, 0xEC, 0xF8, 0x03, 0x1C
 },
 {
  0x02, 0xF4, 0x0A, 0xF2, 0xEE, 0x1A, 0xEA, 0x04,
  0xFE, 0x05, 0xEB, 0x08, 0x03, 0x01, 0x13, 0x00,
  0xF4, 0x18, 0xF2, 0xD8, 0x0F, 0x1D, 0xF1, 0x06,
  0x0F, 0x01, 0xED, 0x02, 0x04, 0x07, 0xF4, 0xFD
 },
 {
  0x00, 0x11, 0x0D, 0x07, 0xFB, 0xF5, 0x02, 0xED,
  0x03, 0x26, 0xEB, 0xFD, 0xFA, 0xFC, 0x07, 0x01,
  0x01, 0xFB, 0xD8, 0xF6, 0xFE, 0x23, 0x08, 0x08,
  0xF6, 0xF8, 0xF7, 0x21, 0x04, 0x04, 0x00, 0xFE
 },
 {
  0xFE, 0xF4, 0x07, 0x1D, 0xE8, 0x02, 0x10, 0xFF,
  0xF9, 0x10, 0x0A, 0xFE, 0xFE, 0xFE, 0x0D, 0xFE,
  0xDB, 0x0F, 0xEA, 0xD8, 0xF5, 0x21, 0x0A, 0xFF,
  0x08, 0x0A, 0x06, 0x08, 0x09, 0x00, 0xF4, 0x02
 },
 {
  0x0F, 0xF8, 0xF7, 0xFE, 0x07, 0xEF, 0x07, 0x13,
  0x0E, 0x04, 0x0C, 0x1B, 0x0B, 0x0A, 0x04, 0x0B,
  0xF1, 0x0E, 0xF3, 0xD0, 0x05, 0x12, 0x00, 0xF7,
  0xDC, 0xF5, 0x02, 0x04, 0x05, 0x05, 0xF1, 0xF4
 },
 {
  0xF4, 0x00, 0x03, 0x04, 0x07, 0xFB, 0x05, 0xF2,
  0xE8, 0xEE, 0xFA, 0xF1, 0xF8, 0xEC, 0x01, 0xF9,
  0xDF, 0xE4, 0xD8, 0xDA, 0xEE, 0xF6, 0xFB, 0x11,
  0xF4, 0x04, 0x03, 0xFB, 0x05, 0xF3, 0x04, 0xF9
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFD, 0xF7, 0xCF, 0xC4, 0xFB, 0x2D, 0xFF, 0x06,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFD, 0xF7, 0xCF, 0xC4, 0xFB, 0x2D, 0xFF, 0x06,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x03, 0xFE, 0x09, 0xE3, 0xF5, 0x37, 0x08, 0x20,
  0xDC, 0xF3, 0xF9, 0x25, 0x04, 0x0B, 0x00, 0x03
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xFF, 0xD9, 0xFC, 0xE2, 0x3F, 0x1C, 0xEF,
  0xFA, 0x0A, 0x07, 0xF2, 0xF7, 0x0B, 0x09, 0x07
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x0D, 0xFE, 0xCE, 0xE0, 0x16, 0x33, 0x04, 0x07,
  0x06, 0x0B, 0xEC, 0xF3, 0x09, 0xFB, 0x15, 0xFC
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFD, 0xF7, 0xCF, 0xC4, 0xFB, 0x2D, 0xFF, 0x06,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFD, 0xF7, 0xCF, 0xC4, 0xFB, 0x2D, 0xFF, 0x06,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x03, 0xFE, 0x09, 0xE3, 0xF5, 0x37, 0x08, 0x20,
  0xDC, 0xF3, 0xF9, 0x25, 0x04, 0x0B, 0x00, 0x03
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xFF, 0xD9, 0xFC, 0xE2, 0x3F, 0x1C, 0xEF,
  0xFA, 0x0A, 0x07, 0xF2, 0xF7, 0x0B, 0x09, 0x07
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x0D, 0xFE, 0xCE, 0xE0, 0x16, 0x33, 0x04, 0x07,
  0x06, 0x0B, 0xEC, 0xF3, 0x09, 0xFB, 0x15, 0xFC
 },
 {
  0xF8, 0x02, 0x01, 0x16, 0xE1, 0xFA, 0xE7, 0xFD,
  0xFD, 0x01, 0xF1, 0xF5, 0xFE, 0xFD, 0x04, 0xF3,
  0xF7, 0x0F, 0xEE, 0x25, 0xF9, 0xDB, 0x0C, 0xF3,
  0xF5, 0xE7, 0xF6, 0xF5, 0xEA, 0x07, 0x10, 0x07
 },
 {
  0x0E, 0x0A, 0x04, 0xF6, 0xFF, 0xFB, 0xF9, 0xFD,
  0x10, 0x0D, 0xFB, 0xF1, 0x05, 0x0B, 0xFF, 0x08,
  0xE5, 0x07, 0xF4, 0x31, 0x11, 0xEA, 0x09, 0xFE,
  0xF7, 0xFF, 0x02, 0xF1, 0xFF, 0x29, 0xEE, 0xEF
 },
 {
  0xFC, 0xF7, 0xF1, 0xFD, 0x03, 0x04, 0x04, 0x02,
  0x07, 0xFD, 0xF9, 0xF8, 0xFB, 0x11, 0xED, 0xF9,
  0x24, 0xF7, 0xDA, 0x11, 0x01, 0xD0, 0x0B, 0xEE,
  0xF3, 0xFE, 0xF8, 0x04, 0xF6, 0xFB, 0x15, 0x0B
 },
 {
  0x0F, 0xF3, 0x04, 0x02, 0x01, 0xFB, 0xFE, 0x01,
  0xF6, 0x07, 0xFF, 0x03, 0xFA, 0x00, 0x0B, 0xF5,
  0x08, 0x14, 0xEF, 0x33, 0xEF, 0xD7, 0x02, 0x0F,
  0x04, 0x08, 0xFE, 0x10, 0xE0, 0xFF, 0x11, 0x06
 },
 {
  0xF8, 0x08, 0xEE, 0xFB, 0x04, 0x06, 0xFD, 0x08,
  0x00, 0xFC, 0x02, 0x00, 0xFF, 0xFC, 0x05, 0x08,
  0x1E, 0x1E, 0xF8, 0x46, 0x02, 0x08, 0x02, 0x00,
  0x07, 0x01, 0x0D, 0xFF, 0xFA, 0xF9, 0xF5, 0x02
 },
 {
  0xF8, 0xF9, 0x09, 0xF6, 0xF3, 0x06, 0xF5, 0xF2,
  0x0D, 0x19, 0xE6, 0x05, 0x02, 0xFB, 0xFB, 0x05,
  0xF8, 0x04, 0x00, 0x21, 0x0C, 0xDA, 0xFC, 0x06,
  0x0D, 0x06, 0x19, 0x22, 0xFF, 0x19, 0xED, 0xFB
 },
 {
  0x12, 0x03, 0xEF, 0x04, 0xF8, 0x07, 0x14, 0x01,
  0xFF, 0x05, 0xFB, 0xFE, 0xF8, 0x08, 0xDD, 0x0F,
  0x18, 0x2B, 0xFB, 0x33, 0x05, 0xF4, 0xFD, 0x01,
  0xFE, 0x03, 0xFD, 0xFD, 0xF7, 0x08, 0xF7, 0x02
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x02, 0x0A, 0x18, 0x4C, 0xFE, 0xEA, 0x0B, 0xFF,
  0x04, 0x21, 0x04, 0x01, 0xFF, 0x01, 0x02, 0x00
 },
 {
  0x00, 0xFF, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00,
  0x18, 0x0D, 0x20, 0x46, 0x1A, 0x05, 0xEB, 0xF7,
  0xFA, 0xF1, 0x02, 0xFE, 0x02, 0x04, 0x01, 0x01
 },
 {
  0x05, 0xFC, 0xF5, 0x04, 0xFC, 0x16, 0x0A, 0xFE,
  0x0D, 0xF5, 0xFC, 0xEB, 0xEF, 0x00, 0xF9, 0x04,
  0x0A, 0xDE, 0x0B, 0x34, 0x02, 0xD2, 0xFB, 0x00,
  0x00, 0xFF, 0x02, 0x04, 0xF7, 0x01, 0x01, 0xF9
 },
 {
  0x00, 0x01, 0x01, 0x00, 0xFF, 0x00, 0x01, 0x00,
  0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0xFD, 0x01,
  0xF8, 0x09, 0xFF, 0x40, 0xF3, 0xC3, 0xFD, 0x03,
  0xFB, 0x0A, 0x01, 0x03, 0xFF, 0xFF, 0xFF, 0xFF
 },
 {
  0x00, 0x01, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x01,
  0x0A, 0xFE, 0xE1, 0x4F, 0xF6, 0x1B, 0x00, 0xFF,
  0x03, 0x08, 0x01, 0x01, 0x00, 0xFF, 0x00, 0xFF
 },
 {
  0x03, 0x0C, 0x0A, 0x1A, 0xED, 0x0A, 0xF7, 0x06,
  0xFC, 0xF1, 0x0A, 0x03, 0xF0, 0x06, 0x0B, 0xED,
  0x03, 0x0A, 0x12, 0x2C, 0x05, 0xE2, 0x05, 0xF7,
  0x15, 0x04, 0x14, 0x0A, 0x0E, 0xE7, 0x08, 0xEF
 },
 {
  0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, 0xFF, 0x00,
  0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0xFA, 0xFE,
  0x08, 0xF8, 0x0D, 0x45, 0x1A, 0xED, 0xE7, 0xEF,
  0x10, 0x06, 0xF4, 0x16, 0x02, 0xFA, 0x09, 0x05
 },
 {
  0x00, 0xFF, 0x00, 0x01, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x01, 0xFE, 0x01, 0x00, 0x00, 0xFC, 0xFF,
  0xDE, 0xF1, 0xDF, 0x38, 0x09, 0xD6, 0x09, 0x0A,
  0x06, 0x09, 0xF8, 0xF5, 0x00, 0xFA, 0x0F, 0x05
 },
 {
  0x0A, 0x02, 0xF2, 0xFD, 0xF1, 0xDD, 0xFF, 0x07,
  0xEE, 0x0E, 0x08, 0xFF, 0xF1, 0xE6, 0x06, 0xF1,
  0xEE, 0x16, 0x09, 0x21, 0x00, 0xE0, 0xF7, 0x03,
  0xF5, 0x07, 0x04, 0xFF, 0x05, 0x1E, 0x09, 0x01
 },
 {
  0x04, 0x0F, 0x00, 0x06, 0xFB, 0xF5, 0x09, 0x06,
  0x06, 0x06, 0x0E, 0x02, 0xFF, 0x0A, 0xE8, 0xE7,
  0xFE, 0xFC, 0xFF, 0x25, 0x02, 0xE3, 0x0E, 0xF7,
  0x16, 0x11, 0xFE, 0x21, 0x0A, 0xE7, 0x0B, 0xF5
 },
 {
  0x00, 0x05, 0x02, 0x12, 0xF4, 0x15, 0x16, 0x21,
  0xF9, 0x15, 0xF7, 0xF9, 0x07, 0xF1, 0xF9, 0x10,
  0x07, 0x00, 0xF2, 0x2C, 0x0A, 0xE7, 0x05, 0xFC,
  0x0F, 0xF8, 0x0A, 0xFC, 0x05, 0x09, 0xFF, 0x10
 },
 {
  0x03, 0x0D, 0x0C, 0x0C, 0x08, 0x19, 0xE9, 0x08,
  0xEA, 0xFD, 0xEE, 0xF8, 0x0F, 0x0C, 0x09, 0x13,
  0x00, 0x00, 0xF7, 0x31, 0xE5, 0xF1, 0xF7, 0xF1,
  0x0C, 0xF8, 0xF0, 0xF9, 0x0D, 0x05, 0x0D, 0x02
 },
 {
  0x0C, 0xFA, 0x07, 0xFE, 0x14, 0xF7, 0xF2, 0x0C,
  0x0D, 0xFB, 0xEF, 0x16, 0xF8, 0xFC, 0x02, 0x07,
  0xF3, 0xFE, 0xF1, 0x2B, 0xFB, 0xE2, 0x1B, 0x04,
  0x0A, 0xE5, 0x05, 0x1B, 0xF6, 0xF6, 0xEE, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0x0A, 0xEE, 0x46, 0xFE, 0xCC, 0xFF, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0x0A, 0xEE, 0x46, 0xFE, 0xCC, 0xFF, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x0F, 0xF3, 0xEC, 0x10, 0x02, 0x0D, 0x05, 0xF5,
  0xF8, 0xFB, 0xFD, 0x02, 0x18, 0xE9, 0x1E, 0xF9,
  0x0B, 0x1E, 0xF1, 0x2B, 0x05, 0xF1, 0x0F, 0xFD,
  0xF2, 0x01, 0xE9, 0x08, 0x03, 0x09, 0x04, 0xF5
 },
 {
  0x00, 0xFF, 0x00, 0x01, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x01, 0xFE, 0x01, 0x00, 0x00, 0xFC, 0xFF,
  0xDE, 0xF1, 0xDF, 0x38, 0x09, 0xD6, 0x09, 0x0A,
  0x06, 0x09, 0xF8, 0xF5, 0x00, 0xFA, 0x0F, 0x05
 },
 {
  0x0A, 0x02, 0xF2, 0xFD, 0xF1, 0xDD, 0xFF, 0x07,
  0xEE, 0x0E, 0x08, 0xFF, 0xF1, 0xE6, 0x06, 0xF1,
  0xEE, 0x16, 0x09, 0x21, 0x00, 0xE0, 0xF7, 0x03,
  0xF5, 0x07, 0x04, 0xFF, 0x05, 0x1E, 0x09, 0x01
 },
 {
  0x04, 0x0F, 0x00, 0x06, 0xFB, 0xF5, 0x09, 0x06,
  0x06, 0x06, 0x0E, 0x02, 0xFF, 0x0A, 0xE8, 0xE7,
  0xFE, 0xFC, 0xFF, 0x25, 0x02, 0xE3, 0x0E, 0xF7,
  0x16, 0x11, 0xFE, 0x21, 0x0A, 0xE7, 0x0B, 0xF5
 },
 {
  0x00, 0x05, 0x02, 0x12, 0xF4, 0x15, 0x16, 0x21,
  0xF9, 0x15, 0xF7, 0xF9, 0x07, 0xF1, 0xF9, 0x10,
  0x07, 0x00, 0xF2, 0x2C, 0x0A, 0xE7, 0x05, 0xFC,
  0x0F, 0xF8, 0x0A, 0xFC, 0x05, 0x09, 0xFF, 0x10
 },
 {
  0x03, 0x0D, 0x0C, 0x0C, 0x08, 0x19, 0xE9, 0x08,
  0xEA, 0xFD, 0xEE, 0xF8, 0x0F, 0x0C, 0x09, 0x13,
  0x00, 0x00, 0xF7, 0x31, 0xE5, 0xF1, 0xF7, 0xF1,
  0x0C, 0xF8, 0xF0, 0xF9, 0x0D, 0x05, 0x0D, 0x02
 },
 {
  0x0C, 0xFA, 0x07, 0xFE, 0x14, 0xF7, 0xF2, 0x0C,
  0x0D, 0xFB, 0xEF, 0x16, 0xF8, 0xFC, 0x02, 0x07,
  0xF3, 0xFE, 0xF1, 0x2B, 0xFB, 0xE2, 0x1B, 0x04,
  0x0A, 0xE5, 0x05, 0x1B, 0xF6, 0xF6, 0xEE, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0x0A, 0xEE, 0x46, 0xFE, 0xCC, 0xFF, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0x0A, 0xEE, 0x46, 0xFE, 0xCC, 0xFF, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x0F, 0xF3, 0xEC, 0x10, 0x02, 0x0D, 0x05, 0xF5,
  0xF8, 0xFB, 0xFD, 0x02, 0x18, 0xE9, 0x1E, 0xF9,
  0x0B, 0x1E, 0xF1, 0x2B, 0x05, 0xF1, 0x0F, 0xFD,
  0xF2, 0x01, 0xE9, 0x08, 0x03, 0x09, 0x04, 0xF5
 },
 {
  0x10, 0xEE, 0x07, 0xFC, 0x1F, 0xF1, 0xF7, 0xF3,
  0x14, 0xF4, 0xFA, 0x00, 0x0C, 0xFA, 0xFE, 0x04,
  0x03, 0xFD, 0xFF, 0x00, 0x01, 0x03, 0x03, 0xFE,
  0x01, 0x06, 0x04, 0x00, 0xFD, 0x02, 0xFB, 0x01
 },
 {
  0x26, 0xFB, 0xF3, 0xFC, 0x08, 0xF1, 0x0B, 0x01,
  0x02, 0xFC, 0xFF, 0x09, 0x0D, 0x04, 0xF4, 0xF9,
  0x00, 0xFE, 0x07, 0x02, 0xFA, 0xFE, 0xFD, 0xFE,
  0x03, 0xFC, 0x06, 0x0F, 0x01, 0x01, 0xF5, 0xFE
 },
 {
  0x2F, 0xEA, 0x09, 0xE6, 0x03, 0xFB, 0x02, 0xF9,
  0x04, 0xFE, 0x02, 0xFE, 0x03, 0x00, 0x03, 0xFC,
  0x03, 0xFD, 0x02, 0xFD, 0x07, 0xFD, 0xFF, 0x01,
  0x01, 0xFB, 0x05, 0x00, 0x02, 0xFB, 0xFD, 0xFE
 },
 {
  0x0E, 0xF0, 0x02, 0xFA, 0x07, 0xFE, 0xF9, 0xFC,
  0xFC, 0xF9, 0x0E, 0xFD, 0x07, 0xED, 0xF2, 0xEF,
  0xE3, 0x06, 0x1A, 0x10, 0xFB, 0x0D, 0xFC, 0xFF,
  0x15, 0x0E, 0x01, 0x03, 0xFA, 0x00, 0xF9, 0xFF
 },
 {
  0x1D, 0xF5, 0x05, 0xFD, 0x04, 0x0B, 0x04, 0xF6,
  0x01, 0xEA, 0xFD, 0xF6, 0x05, 0x04, 0x02, 0x08,
  0xFE, 0xF9, 0xF4, 0xF4, 0xF8, 0xFD, 0xEE, 0xFE,
  0xF7, 0xFB, 0xFF, 0xFD, 0x02, 0xF2, 0xF2, 0x07
 },
 {
  0x1C, 0xF4, 0x05, 0x03, 0x09, 0xF9, 0x00, 0xFE,
  0x02, 0x01, 0x04, 0x00, 0xF9, 0xFD, 0xFE, 0x04,
  0x04, 0x0E, 0x08, 0xFF, 0xFC, 0x0E, 0xF9, 0x11,
  0xFE, 0xFE, 0xF7, 0x02, 0x13, 0xF9, 0x09, 0xF8
 },
 {
  0x1F, 0xEE, 0xEA, 0x08, 0x0F, 0xFB, 0xF6, 0xF1,
  0x01, 0x0A, 0x06, 0x07, 0x06, 0xF8, 0x02, 0xFF,
  0x0C, 0xFD, 0x03, 0xFF, 0x01, 0x05, 0xFA, 0xFC,
  0x00, 0x01, 0x07, 0xF6, 0xFE, 0x04, 0xFD, 0xFC
 },
 {
  0x35, 0xE2, 0xFC, 0x0C, 0x02, 0x03, 0xFD, 0xFD,
  0x00, 0x01, 0x06, 0x05, 0xFB, 0xFC, 0xF9, 0x01,
  0x00, 0x02, 0x01, 0x03, 0x01, 0x05, 0x00, 0x02,
  0x02, 0xFF, 0x00, 0x04, 0x02, 0x00, 0xFE, 0x00
 },
 {
  0x1B, 0xEE, 0xFD, 0xFE, 0x04, 0xF8, 0x03, 0xFE,
  0xF5, 0x02, 0x0A, 0xF8, 0xF8, 0xFC, 0x00, 0xFE,
  0x08, 0x00, 0x09, 0x00, 0xF0, 0x0B, 0x01, 0xFA,
  0x0D, 0xFD, 0xF6, 0xF3, 0xF1, 0x19, 0x01, 0x00
 },
 {
  0x23, 0xFB, 0xFF, 0xF8, 0x17, 0x0B, 0xF2, 0xFD,
  0x02, 0xFE, 0x08, 0xFA, 0x11, 0xFE, 0x07, 0x00,
  0xFE, 0x0A, 0xEF, 0x0D, 0xFE, 0xFE, 0x0B, 0x0B,
  0xF2, 0x02, 0xFE, 0xFD, 0xF8, 0xFF, 0xF4, 0xFB
 },
 {
  0x1D, 0xF7, 0x07, 0x03, 0x02, 0xF6, 0x00, 0x03,
  0x09, 0x00, 0xFD, 0x05, 0x01, 0xF6, 0x0A, 0xFB,
  0x03, 0x06, 0xEC, 0xF7, 0xFA, 0xFC, 0x01, 0x00,
  0x0C, 0x11, 0xF8, 0x09, 0x03, 0xFF, 0xF7, 0x00
 },
 {
  0x0F, 0xF0, 0x12, 0xED, 0x10, 0xF1, 0x11, 0xEE,
  0x0D, 0xF0, 0x11, 0xF2, 0x0F, 0xF7, 0x0D, 0xEF,
  0x09, 0xF9, 0x04, 0xFB, 0x03, 0xFC, 0xFD, 0x00,
  0xFA, 0x07, 0xF7, 0x07, 0xFE, 0x07, 0xF7, 0x09
 },
 {
  0x15, 0xF6, 0x07, 0xFE, 0x0C, 0xF9, 0x0D, 0xEF,
  0x0B, 0xFE, 0x14, 0x03, 0x05, 0xF5, 0xFA, 0xFA,
  0xF1, 0x00, 0xF7, 0x05, 0xF5, 0x07, 0xFF, 0x07,
  0x08, 0xF6, 0xF7, 0x03, 0xFB, 0x09, 0xF8, 0xFE
 },
 {
  0x17, 0xEA, 0x0F, 0xFB, 0x10, 0xFC, 0xFD, 0xF4,
  0x09, 0x03, 0xFF, 0xFE, 0xF8, 0x02, 0xFE, 0xF0,
  0x03, 0x04, 0xFE, 0xFA, 0xF9, 0x0C, 0xF8, 0x02,
  0xF2, 0x02, 0xF9, 0x0B, 0xFE, 0x06, 0xFC, 0xFF
 },
 {
  0x22, 0xEF, 0xFC, 0x08, 0x04, 0xFA, 0x01, 0x08,
  0x04, 0x10, 0x03, 0x06, 0x0C, 0xFF, 0xFF, 0xF1,
  0x06, 0x04, 0xF9, 0xFA, 0x06, 0x00, 0x02, 0x01,
  0xFE, 0x02, 0x03, 0x03, 0xFD, 0xFE, 0x08, 0xFA
 },
 {
  0x12, 0xEE, 0x02, 0xFE, 0x0A, 0x01, 0x12, 0xE9,
  0xFD, 0xF6, 0x00, 0x04, 0x14, 0xED, 0xFD, 0xFC,
  0x02, 0x08, 0x06, 0x01, 0xFD, 0x01, 0x01, 0x03,
  0x05, 0xFF, 0xF5, 0x03, 0xF9, 0x05, 0xFF, 0x01
 },
 {
  0x0F, 0xF2, 0x02, 0x03, 0x0A, 0xF8, 0x0C, 0xF3,
  0x0D, 0xF1, 0x06, 0xF8, 0xFC, 0xF6, 0x0E, 0xF7,
  0x18, 0x02, 0xF9, 0xEE, 0x0D, 0xF5, 0x08, 0x0E,
  0xFA, 0xFE, 0x03, 0xFF, 0xFC, 0x07, 0xF9, 0xFC
 },
 {
  0x14, 0xF4, 0x0D, 0x05, 0xFF, 0xF6, 0x0F, 0xFA,
  0x08, 0xFF, 0xFD, 0xF6, 0x11, 0x00, 0xFA, 0xED,
  0x02, 0xFF, 0x08, 0xFD, 0xF0, 0x00, 0xFD, 0x02,
  0xFE, 0x00, 0x08, 0xF7, 0x00, 0x01, 0xF6, 0xF7
 },
 {
  0x20, 0x00, 0xF7, 0xFB, 0xFF, 0x05, 0x0D, 0xF5,
  0x08, 0x03, 0x0B, 0xF5, 0x00, 0xF8, 0xFE, 0xF2,
  0x07, 0x0A, 0x06, 0xFB, 0x01, 0x0A, 0x02, 0x0C,
  0xF6, 0x04, 0x04, 0x06, 0x04, 0x00, 0xF9, 0xF6
 },
 {
  0x10, 0xF2, 0x0A, 0xF9, 0x0B, 0xF5, 0x0B, 0xF5,
  0x12, 0xF3, 0x08, 0xF1, 0x10, 0xF5, 0x0D, 0xF7,
  0x08, 0xF9, 0x0C, 0xF5, 0x07, 0xFA, 0x03, 0xFB,
  0x09, 0xFB, 0x04, 0xFF, 0x07, 0xFC, 0x08, 0xFD
 },
 {
  0x18, 0xE5, 0xFF, 0x05, 0x08, 0xFB, 0x0C, 0x07,
  0x04, 0xFD, 0x03, 0xFF, 0xF7, 0xF5, 0xF3, 0xFB,
  0x0A, 0x00, 0xF3, 0x07, 0x01, 0xFB, 0x04, 0xF7,
  0x07, 0xFD, 0x0D, 0x02, 0xFB, 0xFD, 0xEF, 0xFE
 },
 {
  0x17, 0xED, 0x0F, 0x01, 0xF6, 0xEE, 0xF4, 0xFA,
  0x08, 0xFD, 0x0C, 0x00, 0xF4, 0xF6, 0xFC, 0xFC,
  0x08, 0xF6, 0x04, 0x02, 0xFE, 0xF8, 0x0D, 0xFD,
  0xFE, 0xFA, 0x02, 0xFD, 0x05, 0xFE, 0x02, 0x0B
 },
 {
  0x19, 0xF4, 0x04, 0x02, 0x18, 0xFD, 0x03, 0xFA,
  0x0E, 0x0B, 0x00, 0xEB, 0xFD, 0xFD, 0x01, 0xF8,
  0x07, 0x00, 0x00, 0x03, 0x03, 0xFA, 0xF9, 0x06,
  0x02, 0x01, 0xFC, 0x05, 0xFF, 0x0A, 0xFE, 0x09
 },
 {
  0x18, 0xF8, 0xFA, 0x07, 0x10, 0xF4, 0x0D, 0xFF,
  0x0B, 0xEB, 0x02, 0xFA, 0x03, 0xF4, 0x00, 0x09,
  0x04, 0x0B, 0xF9, 0x01, 0x04, 0x01, 0xF8, 0x03,
  0x03, 0xFA, 0x03, 0x03, 0x00, 0xF8, 0x08, 0x04
 },
 {
  0x19, 0xEB, 0x0D, 0x0E, 0x0D, 0xEE, 0x04, 0xFD,
  0x00, 0xFB, 0xFC, 0x05, 0xFD, 0x00, 0x04, 0x0C,
  0x07, 0x03, 0x05, 0xFB, 0x02, 0xFE, 0x03, 0xF6,
  0x02, 0xF7, 0xF1, 0x06, 0x01, 0x07, 0xFB, 0x01
 },
 {
  0x17, 0xF0, 0xFE, 0x0A, 0x04, 0xFF, 0x03, 0x01,
  0x20, 0x03, 0xFB, 0xFE, 0x09, 0x0A, 0xFF, 0xFC,
  0xFA, 0x02, 0x09, 0xFF, 0x0E, 0x0C, 0xFA, 0xFF,
  0xEF, 0xFE, 0xFC, 0xF7, 0xF9, 0xFA, 0xF8, 0x03
 },
 {
  0x32, 0xF8, 0x05, 0x02, 0xF5, 0x0A, 0x00, 0x00,
  0x06, 0xFD, 0x07, 0x00, 0xFD, 0xFE, 0xFD, 0x00,
  0x06, 0xFC, 0x02, 0xFB, 0xF7, 0x00, 0x03, 0x0A,
  0x01, 0xF9, 0xFE, 0xFD, 0xFA, 0xF7, 0x01, 0xFE
 },
 {
  0x1C, 0xEF, 0x00, 0xFE, 0x02, 0xF7, 0x01, 0x05,
  0xFC, 0xFF, 0x00, 0x00, 0x13, 0xE5, 0x05, 0xF4,
  0x07, 0xF2, 0xFD, 0xFA, 0x0A, 0xFE, 0xFC, 0xFE,
  0x04, 0xFB, 0xFE, 0xF9, 0x01, 0x07, 0xF7, 0x04
 },
 {
  0x16, 0xED, 0xFA, 0xFA, 0x03, 0xEA, 0x03, 0x05,
  0x14, 0xF8, 0xF2, 0xFB, 0x01, 0x01, 0x14, 0x02,
  0x10, 0x06, 0x03, 0x0E, 0x04, 0x03, 0x05, 0x01,
  0x05, 0xF9, 0xF6, 0xFA, 0x03, 0xFA, 0x01, 0xF2
 },
 {
  0x1D, 0xF2, 0xF8, 0x0D, 0x08, 0xF6, 0xFA, 0x04,
  0x04, 0xFA, 0x05, 0xF9, 0x01, 0x0C, 0x0E, 0x0B,
  0xF9, 0x01, 0x02, 0xF7, 0xF5, 0xF7, 0x00, 0x04,
  0xFF, 0x07, 0x0A, 0x04, 0x04, 0x14, 0xFF, 0xF5
 },
 {
  0x12, 0xF7, 0x04, 0x01, 0x07, 0xE3, 0x0C, 0x01,
  0xFF, 0xF7, 0xFE, 0xFF, 0xFE, 0x02, 0x09, 0xF8,
  0xF3, 0x05, 0x04, 0xF3, 0xFC, 0x02, 0xFB, 0xF9,
  0xFA, 0x0E, 0xF6, 0xDE, 0xFD, 0x01, 0xFD, 0xF3
 },
 {
  0x26, 0xF7, 0x18, 0x08, 0x0B, 0x04, 0xFA, 0xF5,
  0xFE, 0xF4, 0x01, 0x01, 0xF5, 0xF8, 0xFB, 0xFE,
  0xF1, 0xF8, 0x08, 0x00, 0x01, 0xF9, 0x05, 0x04,
  0xFF, 0x08, 0xFE, 0x0B, 0xFD, 0xFF, 0xFB, 0xFB
 },
 {
  0xEC, 0x0B, 0xFC, 0x18, 0xF5, 0x01, 0x0F, 0x04,
  0x00, 0xE4, 0xF6, 0xFF, 0x0A, 0x0A, 0xFA, 0x05,
  0xFA, 0x02, 0x07, 0xFE, 0x01, 0xFE, 0xFA, 0xFD,
  0xF9, 0x01, 0x02, 0x0C, 0xFF, 0x07, 0x00, 0xFE
 },
 {
  0xF7, 0x0A, 0xE9, 0x1B, 0xFC, 0xEF, 0x14, 0xFA,
  0x0E, 0xEF, 0x05, 0xFF, 0x05, 0xF7, 0xF9, 0x05,
  0xFA, 0x04, 0xFE, 0x09, 0x00, 0x08, 0x00, 0x01,
  0xFD, 0xFD, 0xFB, 0xF8, 0x05, 0xFE, 0xFE, 0x0C
 },
 {
  0xF6, 0x13, 0x04, 0x09, 0x01, 0xF0, 0x11, 0xFE,
  0x09, 0xE3, 0xF0, 0xF5, 0xFC, 0x07, 0xFB, 0x04,
  0xFF, 0xFD, 0x03, 0x02, 0x03, 0xFC, 0x05, 0xF4,
  0xFE, 0x06, 0x05, 0xFC, 0x04, 0x01, 0x04, 0x0A
 },
 {
  0xEC, 0x0A, 0xE8, 0x0E, 0xFB, 0x0B, 0x09, 0x00,
  0x10, 0xEC, 0x0A, 0xFB, 0xFA, 0xFA, 0xFF, 0x02,
  0xFC, 0x05, 0xF0, 0x08, 0xFE, 0x05, 0x05, 0xF5,
  0x09, 0xF5, 0x04, 0xF5, 0xFF, 0xFF, 0x04, 0x03
 },
 {
  0xF7, 0x0B, 0x03, 0x13, 0x18, 0x04, 0x05, 0xF2,
  0x1E, 0xEF, 0xFC, 0xFE, 0xEF, 0x07, 0x02, 0x03,
  0x01, 0x03, 0xF9, 0xFC, 0x02, 0xFD, 0x01, 0x04,
  0xFF, 0xFF, 0x03, 0xF4, 0xFE, 0x03, 0xFD, 0x0A
 },
 {
  0xED, 0x12, 0x0B, 0x13, 0x13, 0x13, 0x0A, 0x04,
  0x0D, 0x06, 0x05, 0x04, 0x08, 0x03, 0xFE, 0x0C,
  0xFA, 0xFE, 0x07, 0xFA, 0x0F, 0x0C, 0x10, 0x10,
  0x12, 0xFD, 0xFC, 0xEC, 0x00, 0x0A, 0xF7, 0xFD
 },
 {
  0xEB, 0x09, 0x14, 0x0C, 0x00, 0xFD, 0x05, 0xF7,
  0x0F, 0xF3, 0x05, 0xFB, 0xFA, 0x18, 0x02, 0x09,
  0xFB, 0x02, 0xF9, 0x02, 0x05, 0x07, 0xFB, 0x02,
  0x0F, 0x03, 0x01, 0xFF, 0xFC, 0xFE, 0x07, 0x00
 },
 {
  0xEE, 0x10, 0x0D, 0x0F, 0x02, 0xF6, 0x0E, 0xF5,
  0x04, 0xF5, 0x05, 0x0C, 0x0C, 0x14, 0x08, 0x1E,
  0x02, 0x0B, 0xF7, 0x07, 0x00, 0xFD, 0xF0, 0xFB,
  0xFA, 0x05, 0xFC, 0xEB, 0x00, 0x05, 0x06, 0x01
 },
 {
  0xE6, 0x08, 0xF3, 0x09, 0x06, 0xF6, 0x02, 0xF5,
  0x07, 0xFC, 0x06, 0xED, 0xF5, 0xFA, 0xF4, 0x10,
  0x00, 0x05, 0xF9, 0x08, 0x05, 0x06, 0x11, 0xF7,
  0x0A, 0xF6, 0x05, 0xFD, 0xF5, 0x02, 0x04, 0x0A
 },
 {
  0xF5, 0x11, 0xFD, 0x16, 0xFB, 0x12, 0x03, 0x01,
  0x04, 0xFB, 0x0E, 0xE5, 0x05, 0xF9, 0xFC, 0xFB,
  0xF6, 0x0B, 0x01, 0x0F, 0x01, 0x01, 0xFA, 0xFB,
  0x0A, 0xEA, 0xF9, 0xF9, 0xF1, 0x0D, 0xFC, 0x05
 },
 {
  0xEF, 0x0E, 0xF9, 0x0D, 0x03, 0x00, 0x0D, 0xFA,
  0x09, 0xF2, 0xEA, 0xFF, 0x01, 0x13, 0x0E, 0xFD,
  0x04, 0xF3, 0xF3, 0x02, 0xFC, 0x08, 0xFE, 0xFE,
  0x0D, 0xF4, 0x0D, 0xF4, 0xF9, 0xFB, 0xFD, 0x06
 },
 {
  0xEF, 0x11, 0xFF, 0x21, 0x06, 0x03, 0x09, 0xF0,
  0x03, 0xF2, 0xF8, 0x06, 0xEF, 0x08, 0x03, 0x0D,
  0x08, 0xFA, 0x03, 0x01, 0xFE, 0x00, 0xFE, 0x08,
  0x04, 0x09, 0x0D, 0xF6, 0x04, 0xEF, 0x00, 0xFA
 },
 {
  0xEC, 0x07, 0x07, 0x15, 0x01, 0xFD, 0x07, 0xFD,
  0xFE, 0xF4, 0x09, 0xF9, 0x02, 0xFD, 0x0E, 0x01,
  0xFF, 0xF9, 0x0C, 0xF6, 0x05, 0xEC, 0x0B, 0xFE,
  0x00, 0xE8, 0xEF, 0x06, 0x06, 0xFC, 0x03, 0xFF
 },
 {
  0xF8, 0x0A, 0x06, 0x07, 0xFF, 0xFA, 0x1C, 0xFA,
  0x0A, 0xDF, 0x01, 0xEC, 0x00, 0xF4, 0x0A, 0x01,
  0xFA, 0x08, 0xFD, 0xFF, 0xF6, 0x08, 0x05, 0x00,
  0x0A, 0xFE, 0x08, 0x10, 0xFB, 0xFD, 0xF9, 0x04
 },
 {
  0xEF, 0x0D, 0x03, 0x0F, 0x01, 0xFB, 0x1B, 0xFB,
  0x06, 0xFA, 0x0C, 0x02, 0xFC, 0x08, 0xFF, 0xFD,
  0xFE, 0x0C, 0xF1, 0x03, 0x04, 0x01, 0x02, 0xF7,
  0x00, 0xF0, 0xEB, 0x02, 0xFC, 0x10, 0xF9, 0x04
 },
 {
  0xF1, 0x14, 0x08, 0x11, 0x05, 0xF2, 0x0F, 0xF5,
  0x15, 0xF5, 0x0D, 0xF3, 0x02, 0xF1, 0xF3, 0x01,
  0xFB, 0x05, 0x02, 0x0A, 0xF7, 0x04, 0xFF, 0x03,
  0x02, 0xFC, 0x0D, 0xFB, 0x01, 0xFC, 0x05, 0xFD
 },
 {
  0xEB, 0x08, 0x02, 0x10, 0xFF, 0x02, 0x0F, 0xF0,
  0x0D, 0xF4, 0xF4, 0xF9, 0xF8, 0x02, 0xF9, 0x0B,
  0xF8, 0x05, 0x02, 0xF9, 0x10, 0xFC, 0x01, 0xF9,
  0x03, 0xF1, 0x06, 0xFB, 0xF8, 0x02, 0xF8, 0x05
 },
 {
  0xF1, 0x11, 0xFA, 0x03, 0xFD, 0x03, 0x09, 0xF9,
  0x0E, 0xE9, 0x0B, 0x01, 0xFF, 0x04, 0x07, 0x06,
  0xFF, 0xF2, 0x07, 0x06, 0xF8, 0x05, 0x01, 0xF1,
  0x0A, 0xF7, 0x02, 0xFD, 0xFF, 0x04, 0xF6, 0xFC
 },
 {
  0xF6, 0x12, 0x03, 0x0B, 0x01, 0x04, 0x0E, 0xF2,
  0x07, 0xFC, 0x0F, 0xF6, 0x0A, 0xF5, 0x0A, 0xFC,
  0x05, 0xF2, 0x0A, 0x04, 0x0F, 0xF4, 0x0F, 0xF3,
  0x14, 0xF1, 0x0E, 0xF1, 0x08, 0xF5, 0x04, 0xFA
 },
 {
  0xF9, 0x17, 0x02, 0x14, 0x07, 0x08, 0x13, 0xFB,
  0x09, 0xF0, 0xF8, 0xEF, 0xFB, 0x01, 0x05, 0xFA,
  0xF8, 0x01, 0xFA, 0xFC, 0x0A, 0x06, 0x06, 0x02,
  0xF5, 0xFC, 0x00, 0x02, 0x04, 0x07, 0x09, 0xFC
 },
 {
  0xF1, 0x14, 0xFB, 0x16, 0x0B, 0xF8, 0x09, 0xFB,
  0x0A, 0xF3, 0xF8, 0x08, 0x02, 0xFE, 0xFD, 0x07,
  0x06, 0x0A, 0x01, 0x02, 0xFB, 0xF7, 0x01, 0x0A,
  0x10, 0xEA, 0xF9, 0x00, 0x07, 0x07, 0x06, 0x01
 },
 {
  0xE6, 0x13, 0xFB, 0x03, 0x05, 0x19, 0x12, 0xFB,
  0x09, 0xF2, 0xF8, 0xFA, 0xFE, 0xFA, 0x02, 0x03,
  0xF8, 0xFE, 0xF9, 0x07, 0xFD, 0x07, 0x03, 0x04,
  0xF8, 0x00, 0x01, 0xF8, 0xFC, 0xFE, 0xFE, 0x01
 },
 {
  0xEC, 0x0E, 0xF6, 0x06, 0xFD, 0x07, 0x08, 0xE0,
  0xFE, 0xF9, 0xFE, 0xF6, 0x10, 0xF4, 0xF7, 0x0F,
  0xFE, 0xFB, 0xFA, 0x02, 0xF9, 0x05, 0x09, 0x01,
  0x06, 0xF9, 0xFF, 0x00, 0xFE, 0xFC, 0xF9, 0x03
 },
 {
  0xF2, 0x10, 0x04, 0x0B, 0xF8, 0x01, 0x17, 0xFC,
  0x11, 0xF3, 0xF6, 0x01, 0x0C, 0x09, 0x0C, 0xFC,
  0x07, 0xFF, 0xFF, 0x05, 0xF8, 0xFA, 0x03, 0x03,
  0xFA, 0xFD, 0xEE, 0x00, 0x12, 0x14, 0x04, 0xFE
 },
 {
  0xDF, 0x13, 0xF6, 0x1E, 0x0F, 0x02, 0xFD, 0xFF,
  0xFC, 0xF2, 0x07, 0xF9, 0xFF, 0x07, 0xF8, 0x09,
  0xFF, 0xFD, 0xFB, 0x02, 0x02, 0x04, 0x00, 0x05,
  0x00, 0x00, 0x02, 0x03, 0x03, 0xFD, 0xFD, 0x04
 },
 {
  0xFA, 0x14, 0x00, 0x05, 0x11, 0xF6, 0x12, 0xEF,
  0x09, 0xF0, 0x04, 0xF3, 0xFA, 0x02, 0xF2, 0x0E,
  0xE4, 0x09, 0xF4, 0x19, 0xFC, 0x07, 0x07, 0xF8,
  0x06, 0xFA, 0xFE, 0xF6, 0x02, 0xF5, 0xFF, 0x02
 },
 {
  0xF4, 0x0E, 0x0C, 0x34, 0xFD, 0x05, 0xFB, 0x04,
  0x08, 0xF3, 0x02, 0xFB, 0xFC, 0x02, 0xFE, 0xFF,
  0xFE, 0x03, 0x03, 0x05, 0x02, 0x03, 0x00, 0x01,
  0xFB, 0x02, 0xFC, 0xFD, 0x01, 0xFB, 0xFE, 0x00
 },
 {
  0xF3, 0x06, 0x09, 0x18, 0x00, 0x08, 0x0E, 0xF1,
  0x12, 0xF7, 0xF5, 0xF8, 0x03, 0x0F, 0xFE, 0xFC,
  0xF7, 0x04, 0xFD, 0x0C, 0x0E, 0xF3, 0x0B, 0xFC,
  0x02, 0xFC, 0x00, 0xFA, 0xFA, 0xFA, 0xF2, 0xFF
 },
 {
  0xF6, 0x1C, 0x03, 0x0C, 0x09, 0x03, 0x0B, 0xE4,
  0x06, 0xF5, 0xF9, 0x04, 0x00, 0x07, 0x08, 0xF7,
  0x00, 0xFA, 0x00, 0xF0, 0x04, 0x07, 0x04, 0x04,
  0x07, 0x03, 0x04, 0xF9, 0x00, 0xFD, 0xF6, 0x06
 },
 {
  0xF5, 0x0E, 0xFE, 0x13, 0xFF, 0xFF, 0x07, 0x09,
  0xFE, 0xE5, 0x0A, 0xF2, 0x0F, 0xFC, 0x0C, 0xFC,
  0x02, 0xFE, 0xFA, 0x0C, 0xFA, 0x00, 0xFB, 0xFC,
  0xFB, 0x01, 0x03, 0xF5, 0x05, 0xF7, 0x03, 0xF8
 },
 {
  0xEE, 0x07, 0x0D, 0x10, 0xFC, 0x03, 0x09, 0xF6,
  0x0A, 0xF6, 0xFD, 0xEA, 0xFC, 0xF4, 0x03, 0xF0,
  0x00, 0xFD, 0xF0, 0x08, 0xF5, 0x01, 0x0A, 0xF9,
  0x0F, 0x03, 0x00, 0xFF, 0xF3, 0x08, 0x01, 0x06
 },
 {
  0xEC, 0x0A, 0xF6, 0x0A, 0x08, 0xFF, 0x06, 0x00,
  0x10, 0xF4, 0x09, 0xF6, 0xFF, 0xFB, 0xFC, 0xF3,
  0x0D, 0x10, 0xF8, 0x0C, 0xFE, 0x0E, 0x12, 0x0D,
  0x00, 0xF0, 0x02, 0xFB, 0xFB, 0xFB, 0xFC, 0x03
 },
 {
  0xF2, 0x05, 0xF9, 0xEF, 0x05, 0xF3, 0x17, 0x14,
  0xFC, 0xFF, 0x01, 0xFA, 0x0D, 0x05, 0xFF, 0x04,
  0xF2, 0xFE, 0xF9, 0x08, 0x03, 0x02, 0x02, 0xF9,
  0x02, 0xFF, 0x04, 0x07, 0x03, 0xF7, 0xFF, 0xFB
 },
 {
  0xED, 0x03, 0xE8, 0xE4, 0xF7, 0xF9, 0x13, 0x03,
  0x02, 0x13, 0x07, 0x05, 0xF3, 0x08, 0xF1, 0xEF,
  0x03, 0xF5, 0x04, 0x0D, 0x03, 0x02, 0xFF, 0xFD,
  0xFC, 0xFC, 0x02, 0x00, 0xFB, 0xFA, 0x06, 0x02
 },
 {
  0xEF, 0x12, 0xE2, 0xEC, 0xFE, 0xFD, 0x01, 0x0F,
  0xFF, 0xF5, 0x06, 0xFC, 0x0B, 0x0B, 0xFC, 0xFB,
  0xF6, 0x00, 0x00, 0x01, 0x03, 0xF9, 0x08, 0x02,
  0x05, 0x01, 0x05, 0xFB, 0x01, 0x06, 0x04, 0x01
 },
 {
  0xFA, 0x01, 0xE2, 0xE7, 0xFF, 0xF8, 0xFE, 0xF7,
  0xEF, 0x10, 0x03, 0xFF, 0xFE, 0xF7, 0xFA, 0xF9,
  0xFD, 0x0C, 0x06, 0xFC, 0xF6, 0x00, 0x0A, 0xF8,
  0xFA, 0xFB, 0xFD, 0xF5, 0xFC, 0x00, 0xFF, 0xFD
 },
 {
  0xFF, 0xFF, 0xDE, 0xE4, 0x01, 0xF6, 0x02, 0x09,
  0x04, 0x10, 0x02, 0x06, 0x0E, 0x11, 0x00, 0x07,
  0xFC, 0x04, 0x04, 0x04, 0x00, 0x01, 0xFF, 0xFB,
  0x08, 0x01, 0xFC, 0x01, 0xF7, 0xFE, 0x05, 0x06
 },
 {
  0xF5, 0x0E, 0x01, 0xE1, 0xF9, 0xE8, 0x09, 0x07,
  0x06, 0x05, 0xF3, 0x01, 0xFF, 0x03, 0x04, 0xFF,
  0xFE, 0xF8, 0xFA, 0x03, 0x05, 0xFC, 0xFA, 0x07,
  0xFE, 0x05, 0x03, 0x03, 0x00, 0x00, 0xFB, 0x02
 },
 {
  0xE7, 0x08, 0xF5, 0xEE, 0x01, 0xFC, 0x08, 0xFD,
  0xFC, 0x0F, 0x06, 0xFB, 0x08, 0x02, 0x03, 0x04,
  0xFC, 0x05, 0x06, 0x08, 0xF9, 0x06, 0x01, 0xF5,
  0xF1, 0xF3, 0x09, 0xFC, 0xF2, 0x0A, 0x0C, 0x07
 },
 {
  0xEC, 0x0B, 0xF1, 0xE7, 0x03, 0x04, 0x12, 0x0D,
  0xFC, 0xFB, 0xF7, 0xFF, 0xFB, 0xFE, 0xFE, 0xF9,
  0x10, 0x05, 0xFC, 0xFB, 0xF9, 0xFE, 0xFD, 0xF7,
  0x0B, 0xFE, 0x00, 0xF9, 0xEF, 0xFA, 0xF5, 0x06
 },
 {
  0xF5, 0x12, 0xFB, 0xEC, 0xF1, 0xFD, 0x09, 0x0B,
  0xEC, 0x0C, 0x05, 0x05, 0x0B, 0xFD, 0x07, 0x01,
  0x0A, 0xFA, 0xFD, 0xFD, 0x03, 0x03, 0x0E, 0xF9,
  0x0A, 0xEF, 0x09, 0xF5, 0xFE, 0xFA, 0x07, 0xF4
 },
 {
  0xEC, 0x08, 0xF2, 0xEF, 0xF7, 0xF3, 0xFD, 0x00,
  0xE5, 0xF2, 0xFD, 0xF2, 0x04, 0x03, 0x06, 0xFA,
  0x07, 0x04, 0x17, 0x09, 0x0B, 0x09, 0x03, 0xFC,
  0x09, 0x02, 0x04, 0xFF, 0xFA, 0x01, 0xF8, 0xF5
 },
 {
  0xF7, 0x0E, 0x02, 0xDB, 0xF9, 0x0D, 0x06, 0xF5,
  0xFA, 0x09, 0x12, 0xF5, 0xFA, 0x02, 0x0C, 0x04,
  0xFF, 0x03, 0x01, 0xFE, 0xFE, 0x01, 0xF7, 0xFC,
  0xFE, 0xFD, 0x03, 0x05, 0xFA, 0x00, 0xFE, 0xF8
 },
 {
  0xE3, 0x08, 0xFF, 0xF3, 0xFE, 0x08, 0x17, 0x02,
  0xF6, 0x07, 0x0D, 0xFA, 0xFB, 0x0B, 0x0D, 0x00,
  0xF6, 0xF3, 0x0B, 0xF4, 0xF6, 0x06, 0x04, 0x06,
  0x04, 0x03, 0x06, 0xFB, 0xF7, 0xFE, 0xFF, 0x03
 },
 {
  0xEE, 0x06, 0xF6, 0xC9, 0xFC, 0xF5, 0xFE, 0x00,
  0x01, 0xFD, 0xF7, 0xFA, 0x03, 0xFE, 0xFF, 0x06,
  0x03, 0xFF, 0x03, 0x01, 0xFC, 0xF9, 0xFE, 0x06,
  0x03, 0xFE, 0xFF, 0xFD, 0xFE, 0x00, 0x04, 0x01
 },
 {
  0xF2, 0x05, 0x03, 0xEB, 0xF8, 0xF0, 0xFC, 0xFE,
  0xF5, 0x1B, 0x0F, 0xEC, 0x03, 0x00, 0x01, 0x01,
  0x02, 0xFB, 0xFB, 0x04, 0x01, 0xF7, 0x05, 0xFD,
  0x03, 0x00, 0xFC, 0xFE, 0xF5, 0xFC, 0xFD, 0x07
 },
 {
  0xEF, 0xFF, 0xF7, 0xEF, 0xF8, 0xEE, 0x0C, 0xF3,
  0xF7, 0x0D, 0xFD, 0x03, 0x03, 0xFD, 0x01, 0xFE,
  0x00, 0x10, 0xF7, 0x06, 0x0C, 0x09, 0x05, 0x0B,
  0x02, 0xF1, 0x01, 0xFC, 0xF0, 0x07, 0xFC, 0xF4
 },
 {
  0xEE, 0x08, 0xFA, 0xF5, 0xF8, 0xF9, 0x0D, 0x07,
  0x01, 0x06, 0x08, 0xFF, 0x15, 0xFC, 0x0E, 0x0F,
  0x12, 0xFC, 0xFD, 0x0F, 0x00, 0x09, 0x04, 0x07,
  0x03, 0xFF, 0x09, 0xFE, 0x00, 0x07, 0xF8, 0x02
 },
 {
  0xF6, 0x07, 0xEE, 0xE3, 0x03, 0x0C, 0x0C, 0x09,
  0x0B, 0x04, 0xFF, 0xF1, 0x01, 0xFF, 0x08, 0xFE,
  0xFE, 0x0A, 0xF1, 0xFF, 0x00, 0x06, 0x0C, 0xFA,
  0xFF, 0x0A, 0xFA, 0xFD, 0xF5, 0xFC, 0x09, 0xFA
 },
 {
  0xF2, 0x0E, 0xF7, 0xEB, 0xF4, 0xFE, 0xFF, 0xF9,
  0xFB, 0xF6, 0x05, 0xF8, 0x00, 0x06, 0x09, 0xF5,
  0x0B, 0xFD, 0xFB, 0x03, 0x08, 0x0F, 0xFE, 0xFC,
  0xEA, 0x04, 0xFA, 0x0C, 0x02, 0x0D, 0x06, 0xF9
 },
 {
  0xF4, 0x0B, 0xFB, 0xE3, 0xE7, 0x04, 0x0C, 0xF3,
  0xF5, 0xF9, 0x04, 0x02, 0x02, 0xFB, 0x05, 0x08,
  0x07, 0xFB, 0xFB, 0x06, 0x03, 0xF6, 0x01, 0xFA,
  0x06, 0xFA, 0xFB, 0xFF, 0xFE, 0xFC, 0x07, 0x06
 },
 {
  0xF1, 0x0B, 0xFB, 0xF0, 0x00, 0xF3, 0x1A, 0xE9,
  0xFA, 0xFD, 0x05, 0xFE, 0xFE, 0x15, 0xFA, 0xFD,
  0xFB, 0xFF, 0x06, 0xFF, 0x00, 0xF3, 0x02, 0xFD,
  0xF7, 0xFF, 0xFC, 0xFD, 0x05, 0xFC, 0x0C, 0xF0
 },
 {
  0xF7, 0x09, 0xFF, 0xEF, 0xFD, 0xFA, 0x0C, 0x06,
  0xEE, 0xFE, 0x0B, 0xF2, 0xFA, 0x03, 0x0E, 0xF4,
  0xF5, 0xFB, 0x0E, 0x02, 0x05, 0xF8, 0xFC, 0xF5,
  0x02, 0xFB, 0x10, 0x06, 0xF9, 0xFC, 0x08, 0x0D
 },
 {
  0xF3, 0x05, 0x03, 0xE4, 0xF2, 0x00, 0x06, 0x17,
  0x05, 0x04, 0xFF, 0xEF, 0x01, 0xFD, 0x00, 0x00,
  0x05, 0x04, 0x00, 0xEE, 0x0E, 0x0A, 0x04, 0x02,
  0x05, 0xFE, 0x04, 0xFD, 0x02, 0x00, 0x02, 0x00
 },
 {
  0xF1, 0x04, 0xF3, 0xF0, 0xFD, 0xF4, 0xFE, 0x02,
  0x07, 0x0A, 0x09, 0x03, 0x0B, 0x04, 0x17, 0x0E,
  0x09, 0x10, 0x04, 0x01, 0xF4, 0xFD, 0x04, 0xF9,
  0xF1, 0xF9, 0xF6, 0xF2, 0xFA, 0xF8, 0xFF, 0xFA
 },
 {
  0xF9, 0x0A, 0xFB, 0xF6, 0xFD, 0xF3, 0x10, 0xFF,
  0xF4, 0x07, 0xFD, 0xF4, 0x02, 0x0D, 0x0D, 0x02,
  0x11, 0x0F, 0xF3, 0x01, 0xFB, 0xFE, 0x03, 0xFF,
  0x01, 0xFD, 0x06, 0xFD, 0xF4, 0xF0, 0x07, 0xF9
 },
 {
  0xF5, 0xFB, 0xF4, 0xE2, 0xFA, 0xEA, 0x01, 0x04,
  0xFA, 0xFD, 0x0C, 0x06, 0x07, 0x00, 0x10, 0x06,
  0xFE, 0x00, 0xEA, 0xFE, 0xF7, 0x02, 0xF3, 0x08,
  0x06, 0xF8, 0x04, 0xF9, 0xFF, 0xFA, 0x04, 0x06
 },
 {
  0xF2, 0x05, 0x01, 0xE5, 0xFC, 0x02, 0x01, 0x0E,
  0xF5, 0xF9, 0xF8, 0xFC, 0x01, 0x08, 0x00, 0xFA,
  0xF3, 0x0B, 0xF4, 0xF9, 0xFB, 0x01, 0x0A, 0x07,
  0x03, 0xFE, 0x00, 0x06, 0xF8, 0x02, 0x0A, 0xFF
 },
 {
  0xF6, 0x0A, 0xE7, 0xF3, 0xEC, 0xFC, 0x13, 0x03,
  0x0D, 0x05, 0x05, 0x07, 0xF8, 0x02, 0x04, 0x02,
  0x03, 0xFF, 0xFF, 0xF7, 0x0E, 0x0A, 0x09, 0x0E,
  0x03, 0x03, 0xFA, 0x00, 0xFB, 0x04, 0x01, 0xFF
 },
 {
  0xF7, 0x0F, 0xEE, 0xEF, 0x04, 0xF5, 0x06, 0x07,
  0xF4, 0x08, 0xFF, 0xF5, 0x02, 0x03, 0x07, 0x10,
  0xFD, 0xF7, 0x07, 0xF4, 0x17, 0x00, 0x06, 0x07,
  0xF2, 0xF7, 0x08, 0x01, 0xFE, 0x06, 0xFE, 0xFF
 },
 {
  0xFA, 0x09, 0xF0, 0xE6, 0xF2, 0xF5, 0x09, 0xFA,
  0x05, 0xFE, 0x0D, 0x11, 0x15, 0x07, 0x12, 0xED,
  0x06, 0xE9, 0xFE, 0xF1, 0xFE, 0x02, 0xF6, 0xF8,
  0x02, 0x01, 0xFE, 0x04, 0xFD, 0xFC, 0xFB, 0xFC
 },
 {
  0x00, 0x06, 0xFB, 0xE4, 0xEF, 0xE0, 0x02, 0xF6,
  0x0B, 0x03, 0xFB, 0x09, 0x0A, 0x03, 0x0B, 0x0B,
  0xFD, 0x0C, 0xFE, 0x02, 0x04, 0xFA, 0x09, 0xFC,
  0xFC, 0xFC, 0xFC, 0xF7, 0x02, 0x00, 0x02, 0x04
 },
 {
  0x00, 0xF8, 0xEE, 0xDE, 0xF7, 0xF9, 0xFC, 0xF5,
  0x0A, 0x0F, 0x0B, 0xFF, 0xF8, 0x0F, 0x06, 0xF3,
  0x09, 0x02, 0xFC, 0xF4, 0x00, 0xFF, 0x13, 0x0C,
  0x06, 0x05, 0x00, 0xFD, 0xF6, 0xF4, 0x03, 0xFB
 },
 {
  0xF6, 0x06, 0xF7, 0xEF, 0xF4, 0xF5, 0x09, 0xFA,
  0x0B, 0x0B, 0x12, 0xF9, 0x00, 0x10, 0x04, 0x02,
  0xFA, 0x03, 0xF4, 0xFF, 0x00, 0x01, 0xFB, 0xEA,
  0xFE, 0xF4, 0x00, 0x06, 0x11, 0x05, 0x05, 0x06
 },
 {
  0x0C, 0xFB, 0x07, 0x01, 0xFB, 0xFE, 0xFF, 0x02,
  0x02, 0xFC, 0xFD, 0xFD, 0xFD, 0xFE, 0xE3, 0x0B,
  0x05, 0xF3, 0xB7, 0x18, 0x0C, 0x04, 0xF2, 0xF6,
  0x05, 0x01, 0x00, 0xF5, 0xF9, 0xF9, 0x07, 0x03
 },
 {
  0x0A, 0xFD, 0xFF, 0xFD, 0x04, 0xF5, 0xFB, 0xFE,
  0xF8, 0x07, 0x09, 0x02, 0xF8, 0xFA, 0x06, 0x07,
  0x15, 0x11, 0xCA, 0x2F, 0xF2, 0xF6, 0x0E, 0x13,
  0x0D, 0x15, 0xFC, 0x03, 0x01, 0x02, 0xFC, 0x02
 },
 {
  0xF4, 0x04, 0xF0, 0xF4, 0x05, 0xF7, 0xFC, 0x13,
  0xF9, 0xEA, 0xEA, 0xEF, 0x03, 0x00, 0xFA, 0x08,
  0x17, 0xFC, 0xC9, 0xE4, 0x02, 0xE6, 0x02, 0x01,
  0x04, 0x00, 0xF3, 0x06, 0x00, 0x0A, 0xF9, 0xF5
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF,
  0x23, 0xFF, 0xBD, 0xDD, 0xE8, 0xE8, 0xFA, 0x02,
  0x02, 0xFE, 0x01, 0x03, 0x02, 0x00, 0xFF, 0x01
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x00,
  0x29, 0xFC, 0xB7, 0xF1, 0x12, 0x04, 0x11, 0x08,
  0xFF, 0xF0, 0xFF, 0xFE, 0x01, 0x00, 0x00, 0x00
 },
 {
  0xFC, 0xFC, 0x04, 0x06, 0xFF, 0x02, 0xF0, 0xF6,
  0xF1, 0xF6, 0x15, 0xFE, 0xFA, 0xFE, 0x0E, 0xF9,
  0x0A, 0xFB, 0xC9, 0x22, 0xF4, 0x0B, 0xF3, 0xFE,
  0x02, 0x1C, 0xE6, 0x00, 0x07, 0x04, 0x15, 0xF9
 },
 {
  0x02, 0x01, 0x0F, 0xEA, 0x0A, 0xFD, 0x0E, 0xFA,
  0xFE, 0x0F, 0xFE, 0xF9, 0x14, 0x06, 0xF1, 0xF9,
  0x17, 0x0A, 0xC4, 0x08, 0xFC, 0x1D, 0xEA, 0x02,
  0xF3, 0x09, 0xF6, 0x0C, 0xFF, 0xFD, 0x04, 0x07
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0xFF, 0xFE, 0x0B, 0xFB,
  0xEB, 0xF5, 0xC4, 0xE5, 0xEF, 0xD9, 0x06, 0x24,
  0x00, 0xF8, 0x02, 0x02, 0x00, 0x00, 0xFE, 0x03
 },
 {
  0x02, 0xFB, 0x09, 0xEF, 0xFF, 0x02, 0xFD, 0xFA,
  0x08, 0x0C, 0x07, 0xFA, 0xDF, 0xF5, 0xF2, 0xD8,
  0x0A, 0x24, 0xD2, 0x00, 0xED, 0x05, 0x00, 0xF6,
  0x03, 0x0C, 0xFA, 0xF8, 0x06, 0xF4, 0xF9, 0x01
 },
 {
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x01, 0x00, 0xFE, 0x00,
  0x04, 0xFE, 0xA9, 0xFD, 0xFE, 0x02, 0xFE, 0x14,
  0x02, 0x06, 0xFF, 0x06, 0x00, 0x00, 0x02, 0xFF
 },
 {
  0x01, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x01,
  0x01, 0x07, 0xB4, 0x29, 0xF9, 0xE8, 0x00, 0xFA,
  0x03, 0x06, 0x00, 0xFE, 0xFF, 0x01, 0x00, 0x00
 },
 {
  0x00, 0xFD, 0x04, 0x02, 0x03, 0x02, 0x02, 0x00,
  0x03, 0xFF, 0x04, 0x00, 0xFF, 0x04, 0xFE, 0xFC,
  0xE0, 0xF5, 0xC0, 0xE3, 0xF7, 0xD5, 0x02, 0xF5,
  0xFF, 0xF9, 0x00, 0xFC, 0xFE, 0xFE, 0xFE, 0x02
 },
 {
  0x0A, 0xEC, 0x03, 0xFD, 0x0D, 0x0D, 0x00, 0xFC,
  0x02, 0x07, 0xF8, 0x07, 0xFE, 0x02, 0xEC, 0xEC,
  0xED, 0x03, 0xD1, 0xEE, 0xF0, 0xFA, 0xF1, 0xD6,
  0xEF, 0x0E, 0xFA, 0x08, 0x0C, 0xF6, 0x0B, 0xF4
 },
 {
  0xFD, 0xFE, 0xFE, 0xFF, 0xFF, 0x04, 0xFD, 0xFF,
  0xFA, 0xFE, 0x03, 0x02, 0xFD, 0x06, 0xFF, 0xF7,
  0x0A, 0x0D, 0xBC, 0xF7, 0x1A, 0x03, 0x05, 0x03,
  0xEB, 0x0A, 0xF1, 0x15, 0xEA, 0x13, 0x0B, 0xF2
 },
 {
  0x01, 0x05, 0x12, 0xED, 0xE3, 0xF3, 0xFE, 0x12,
  0xF6, 0x14, 0x02, 0x0A, 0xF6, 0x0B, 0x01, 0x08,
  0xF0, 0xEF, 0xD7, 0x0A, 0xF2, 0xE7, 0x00, 0xF2,
  0xED, 0x11, 0x07, 0xF4, 0x0E, 0xF5, 0x0E, 0x05
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xD5, 0x05,
  0x06, 0xF4, 0xD0, 0x13, 0x08, 0xDA, 0xF8, 0xFD,
  0x16, 0xEB, 0xF6, 0x0F, 0x14, 0xF7, 0xFB, 0x08
 },
 {
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFD,
  0x16, 0xF2, 0xB9, 0xE8, 0xFE, 0xDF, 0x17, 0x07,
  0xF8, 0x07, 0xFD, 0x02, 0xFC, 0x01, 0xF8, 0xFE
 },
 {
  0x01, 0x00, 0xFF, 0x02, 0x00, 0xFE, 0x00, 0x00,
  0xFF, 0x00, 0x04, 0x00, 0x1A, 0xFF, 0x0A, 0xF5,
  0xEF, 0xE0, 0xC6, 0x0E, 0xF2, 0xF5, 0xFE, 0x0F,
  0x02, 0xF8, 0x0C, 0x0A, 0xF7, 0x0D, 0xDF, 0xF2
 },
 {
  0x0F, 0xEF, 0xED, 0x07, 0xF8, 0xF1, 0xE0, 0xEA,
  0x07, 0x0C, 0x12, 0x00, 0x00, 0xF1, 0xFC, 0x10,
  0x25, 0xFE, 0xD2, 0x0B, 0x02, 0xF8, 0xF6, 0xF8,
  0x0E, 0x09, 0xFC, 0x05, 0x07, 0xEF, 0x04, 0x03
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00,
  0xFB, 0x03, 0xAB, 0x17, 0xF7, 0xEF, 0xFE, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00,
  0xFB, 0x03, 0xAB, 0x17, 0xF7, 0xEF, 0xFE, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x01, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x01,
  0x01, 0x07, 0xB4, 0x29, 0xF9, 0xE8, 0x00, 0xFA,
  0x03, 0x06, 0x00, 0xFE, 0xFF, 0x01, 0x00, 0x00
 },
 {
  0x00, 0xFD, 0x04, 0x02, 0x03, 0x02, 0x02, 0x00,
  0x03, 0xFF, 0x04, 0x00, 0xFF, 0x04, 0xFE, 0xFC,
  0xE0, 0xF5, 0xC0, 0xE3, 0xF7, 0xD5, 0x02, 0xF5,
  0xFF, 0xF9, 0x00, 0xFC, 0xFE, 0xFE, 0xFE, 0x02
 },
 {
  0x0A, 0xEC, 0x03, 0xFD, 0x0D, 0x0D, 0x00, 0xFC,
  0x02, 0x07, 0xF8, 0x07, 0xFE, 0x02, 0xEC, 0xEC,
  0xED, 0x03, 0xD1, 0xEE, 0xF0, 0xFA, 0xF1, 0xD6,
  0xEF, 0x0E, 0xFA, 0x08, 0x0C, 0xF6, 0x0B, 0xF4
 },
 {
  0xFD, 0xFE, 0xFE, 0xFF, 0xFF, 0x04, 0xFD, 0xFF,
  0xFA, 0xFE, 0x03, 0x02, 0xFD, 0x06, 0xFF, 0xF7,
  0x0A, 0x0D, 0xBC, 0xF7, 0x1A, 0x03, 0x05, 0x03,
  0xEB, 0x0A, 0xF1, 0x15, 0xEA, 0x13, 0x0B, 0xF2
 },
 {
  0x01, 0x05, 0x12, 0xED, 0xE3, 0xF3, 0xFE, 0x12,
  0xF6, 0x14, 0x02, 0x0A, 0xF6, 0x0B, 0x01, 0x08,
  0xF0, 0xEF, 0xD7, 0x0A, 0xF2, 0xE7, 0x00, 0xF2,
  0xED, 0x11, 0x07, 0xF4, 0x0E, 0xF5, 0x0E, 0x05
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xD5, 0x05,
  0x06, 0xF4, 0xD0, 0x13, 0x08, 0xDA, 0xF8, 0xFD,
  0x16, 0xEB, 0xF6, 0x0F, 0x14, 0xF7, 0xFB, 0x08
 },
 {
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFD,
  0x16, 0xF2, 0xB9, 0xE8, 0xFE, 0xDF, 0x17, 0x07,
  0xF8, 0x07, 0xFD, 0x02, 0xFC, 0x01, 0xF8, 0xFE
 },
 {
  0x01, 0x00, 0xFF, 0x02, 0x00, 0xFE, 0x00, 0x00,
  0xFF, 0x00, 0x04, 0x00, 0x1A, 0xFF, 0x0A, 0xF5,
  0xEF, 0xE0, 0xC6, 0x0E, 0xF2, 0xF5, 0xFE, 0x0F,
  0x02, 0xF8, 0x0C, 0x0A, 0xF7, 0x0D, 0xDF, 0xF2
 },
 {
  0x0F, 0xEF, 0xED, 0x07, 0xF8, 0xF1, 0xE0, 0xEA,
  0x07, 0x0C, 0x12, 0x00, 0x00, 0xF1, 0xFC, 0x10,
  0x25, 0xFE, 0xD2, 0x0B, 0x02, 0xF8, 0xF6, 0xF8,
  0x0E, 0x09, 0xFC, 0x05, 0x07, 0xEF, 0x04, 0x03
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00,
  0xFB, 0x03, 0xAB, 0x17, 0xF7, 0xEF, 0xFE, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00,
  0xFB, 0x03, 0xAB, 0x17, 0xF7, 0xEF, 0xFE, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 },
 {
  0x10, 0x41, 0xFE, 0xFE, 0x04, 0x03, 0x00, 0xF9,
  0x03, 0x01, 0x03, 0x01, 0x00, 0x05, 0x01, 0xFB,
  0x00, 0x02, 0xFF, 0x03, 0x00, 0x00, 0xFF, 0xFE,
  0x06, 0x00, 0xFE, 0x00, 0x00, 0xFF, 0x01, 0x01
 },
 {
  0x05, 0x25, 0xFC, 0x08, 0xFC, 0xFF, 0x09, 0x11,
  0x06, 0xF9, 0x05, 0xFF, 0x0B, 0x06, 0xFC, 0x07,
  0xFE, 0x04, 0x01, 0xFD, 0x0B, 0x03, 0x03, 0xF7,
  0x06, 0x00, 0xFE, 0xFC, 0xFB, 0x04, 0xF4, 0xF5
 },
 {
  0x0F, 0x18, 0xF2, 0x02, 0x06, 0x11, 0x1A, 0x05,
  0x08, 0x0B, 0xF7, 0xF9, 0xFA, 0xF8, 0x03, 0xFB,
  0x09, 0x0A, 0xFD, 0x0A, 0x00, 0x01, 0x04, 0xF7,
  0x04, 0x09, 0x03, 0x00, 0x04, 0x00, 0xFB, 0x03
 },
 {
  0x09, 0x24, 0xF7, 0xF8, 0x07, 0x07, 0x04, 0x03,
  0xFF, 0xF0, 0xFE, 0x07, 0xFB, 0xFA, 0x06, 0x0C,
  0xF5, 0xF4, 0x09, 0xFF, 0xFD, 0xF7, 0x0C, 0x06,
  0xFA, 0x02, 0x02, 0x05, 0x00, 0x05, 0x06, 0xFA
 },
 {
  0x19, 0x27, 0xFB, 0x18, 0x03, 0x0A, 0x03, 0xFA,
  0x0D, 0xF8, 0x03, 0xF9, 0x02, 0xF6, 0xFB, 0x02,
  0xFE, 0x03, 0x05, 0xFE, 0x01, 0x05, 0xFE, 0x03,
  0xFC, 0x01, 0xFB, 0xFC, 0x00, 0x01, 0xFE, 0x00
 },
 {
  0x10, 0x1B, 0xFF, 0x00, 0xF2, 0x06, 0x04, 0xFB,
  0x07, 0xFE, 0xFA, 0x00, 0xFD, 0xFB, 0x02, 0xFF,
  0xFF, 0xED, 0x05, 0xF8, 0x00, 0x0B, 0x0C, 0x05,
  0x00, 0x03, 0x0A, 0x06, 0xF2, 0x0E, 0xF3, 0xF1
 },
 {
  0x0C, 0x17, 0xF2, 0x02, 0x01, 0x04, 0xFD, 0x10,
  0x07, 0xF8, 0x02, 0xF8, 0x08, 0x06, 0xF8, 0xF9,
  0xFD, 0x00, 0x02, 0x08, 0xF3, 0x07, 0x0D, 0xFA,
  0xFC, 0x06, 0xF3, 0xF0, 0x0E, 0x0B, 0xF9, 0x05
 },
 {
  0x10, 0x1C, 0xF9, 0xFF, 0x06, 0xFD, 0x09, 0x00,
  0xF9, 0x03, 0x00, 0x03, 0xF4, 0x14, 0x08, 0x09,
  0x08, 0x17, 0x08, 0xF3, 0xFE, 0x04, 0x09, 0x03,
  0xFB, 0x0D, 0x05, 0xFE, 0x0C, 0x0E, 0x05, 0xFF
 },
 {
  0x13, 0x25, 0x13, 0x05, 0x07, 0x05, 0x0A, 0x05,
  0x13, 0x0A, 0x0E, 0x00, 0x02, 0x05, 0x01, 0xFC,
  0xFC, 0x02, 0x02, 0xFB, 0xFE, 0xFF, 0x02, 0xFA,
  0xFC, 0xFC, 0xFB, 0xFD, 0x02, 0xFE, 0xFE, 0xFE
 },
 {
  0x18, 0x15, 0x01, 0xF5, 0xF6, 0x11, 0xF2, 0x0E,
  0x06, 0xFF, 0xFA, 0xFF, 0x00, 0xF3, 0xFF, 0xF4,
  0xFE, 0xFB, 0x06, 0xFC, 0xF4, 0x0E, 0x05, 0xFE,
  0xF8, 0xF8, 0x0F, 0xF9, 0xE2, 0xF4, 0x04, 0x00
 },
 {
  0x0B, 0x1A, 0xFD, 0x03, 0x05, 0xFF, 0xFE, 0x03,
  0xFE, 0x0A, 0x0F, 0xFC, 0x0A, 0xE4, 0x0A, 0xEF,
  0xF8, 0x01, 0x02, 0xF9, 0xFF, 0xFA, 0xF1, 0xFF,
  0x04, 0x05, 0xF9, 0x09, 0x00, 0xFB, 0xFC, 0x04
 },
 {
  0x12, 0x20, 0x01, 0x02, 0xF9, 0x04, 0x0F, 0x02,
  0xF7, 0xFE, 0x0C, 0xF5, 0x07, 0x0B, 0x0D, 0x02,
  0x00, 0x05, 0x09, 0xF6, 0x10, 0x03, 0xFD, 0x05,
  0xF7, 0xE9, 0x02, 0xFE, 0xFF, 0x05, 0x02, 0x0B
 },
 {
  0x23, 0x18, 0xEC, 0x02, 0x04, 0xFF, 0x05, 0x0E,
  0xF6, 0xF7, 0x08, 0xF9, 0x00, 0x05, 0xF9, 0xF9,
  0x0B, 0x01, 0x05, 0x03, 0x02, 0x00, 0xFE, 0x03,
  0x00, 0x01, 0x04, 0x00, 0xFE, 0xF8, 0x00, 0xFC
 },
 {
  0x09, 0x23, 0xFF, 0x02, 0xFF, 0xED, 0xFD, 0x0C,
  0xFF, 0x08, 0x08, 0xF3, 0xFF, 0xFE, 0x02, 0x05,
  0xF8, 0xFF, 0x0D, 0xFE, 0x0B, 0x01, 0x00, 0xF6,
  0x00, 0xFD, 0xF9, 0x02, 0x01, 0xF4, 0x03, 0x0C
 },
 {
  0x14, 0x1B, 0xF4, 0xF4, 0x07, 0x04, 0xFF, 0xF3,
  0xFF, 0xF7, 0x02, 0x0D, 0xF5, 0x05, 0x07, 0xF7,
  0x09, 0x01, 0x01, 0x08, 0xF7, 0x00, 0xFA, 0x07,
  0x04, 0x02, 0xFE, 0x07, 0x03, 0xFE, 0x01, 0xF7
 },
 {
  0x08, 0x25, 0xEC, 0xFB, 0x00, 0xEB, 0x0A, 0xF8,
  0x03, 0x13, 0xF7, 0x07, 0xFD, 0xF8, 0x0A, 0xFE,
  0x00, 0x05, 0x06, 0xFC, 0xFE, 0xFF, 0x00, 0xF9,
  0x06, 0x01, 0x00, 0x04, 0xFB, 0x06, 0xF8, 0x02
 },
 {
  0x08, 0x1B, 0x01, 0xFD, 0xFB, 0x01, 0x06, 0x00,
  0x0F, 0x02, 0x11, 0xFF, 0x03, 0xEF, 0x0A, 0x05,
  0x05, 0xFA, 0xFA, 0x06, 0xF6, 0x12, 0xFB, 0x00,
  0x00, 0x0D, 0x07, 0x0A, 0xFB, 0xFA, 0xFE, 0xFC
 },
 {
  0x0E, 0x1D, 0xEC, 0xFC, 0xFD, 0x01, 0xFB, 0xFF,
  0x02, 0x0C, 0xF6, 0xFD, 0x04, 0xEE, 0x04, 0x0E,
  0xFC, 0xFF, 0xF7, 0x0F, 0xFE, 0x02, 0xFB, 0xFD,
  0x02, 0x09, 0xFE, 0xF2, 0xFD, 0x04, 0xFC, 0xF9
 },
 {
  0x17, 0x17, 0xE9, 0xF5, 0x1B, 0x04, 0x04, 0xFF,
  0x07, 0x00, 0xFB, 0x09, 0x02, 0xF5, 0x03, 0x07,
  0xFE, 0xFB, 0x02, 0xF9, 0xF9, 0x0D, 0xFD, 0xFA,
  0x02, 0x03, 0x03, 0xFC, 0xFF, 0xF8, 0x05, 0xFE
 },
 {
  0x10, 0x1A, 0xFA, 0x08, 0xF7, 0xFF, 0xFE, 0xFF,
  0xF8, 0x04, 0xFE, 0x00, 0xF4, 0x09, 0xFF, 0x00,
  0xEF, 0xF7, 0x1E, 0xFB, 0xF1, 0xF0, 0xF3, 0x00,
  0x0A, 0xF5, 0xF9, 0xFD, 0xFF, 0x00, 0xF5, 0xFE
 },
 {
  0x0C, 0x20, 0xFC, 0xFB, 0x0A, 0x13, 0xF6, 0x04,
  0xF4, 0x05, 0xFA, 0x09, 0xF4, 0xFA, 0xFA, 0xF8,
  0x04, 0x01, 0x03, 0x00, 0x08, 0x00, 0xFD, 0xFC,
  0xF9, 0xFC, 0x0A, 0x08, 0x06, 0x05, 0xFF, 0x04
 },
 {
  0x2E, 0x2A, 0xFD, 0xF2, 0xFE, 0xFA, 0x06, 0xFE,
  0xFB, 0xFF, 0xFD, 0xFD, 0x01, 0xFF, 0x03, 0x01,
  0x01, 0x04, 0xFF, 0x02, 0x03, 0x01, 0xFE, 0x06,
  0x00, 0xFF, 0xFE, 0x04, 0xFE, 0xFF, 0x02, 0x02
 },
 {
  0x09, 0x21, 0xF3, 0x04, 0xF5, 0x03, 0xF8, 0x16,
  0x0C, 0xFE, 0x04, 0x00, 0xF0, 0x05, 0x04, 0xFF,
  0x07, 0xFA, 0xF7, 0x01, 0x07, 0x05, 0x00, 0xFB,
  0x05, 0xFF, 0x0A, 0x03, 0xFE, 0xFF, 0x03, 0xFE
 },
 {
  0x09, 0x1E, 0x06, 0xFD, 0x06, 0x01, 0xF9, 0x05,
  0x0B, 0x0E, 0x07, 0x01, 0x00, 0x02, 0x02, 0xFF,
  0x08, 0x07, 0xFA, 0xF3, 0xF6, 0xFE, 0x01, 0xFA,
  0x0A, 0x07, 0x06, 0x05, 0xFE, 0xFB, 0xFF, 0xF0
 },
 {
  0x09, 0x1C, 0xF5, 0xF6, 0x09, 0xF6, 0x0F, 0x08,
  0x04, 0x09, 0xFC, 0xF9, 0x00, 0xFB, 0x09, 0x08,
  0xF9, 0x02, 0xF1, 0xE9, 0x04, 0xFC, 0x04, 0x10,
  0xF8, 0xFD, 0x00, 0xF8, 0x0E, 0x05, 0xFD, 0x0F
 },
 {
  0x11, 0x1A, 0xFB, 0xFB, 0xFF, 0xF8, 0x14, 0x12,
  0xF9, 0xFE, 0x04, 0xF9, 0xF8, 0xFB, 0xFC, 0x10,
  0x00, 0x00, 0xF9, 0xFE, 0xF3, 0xFB, 0xFE, 0x03,
  0x0C, 0x01, 0x03, 0xFB, 0x02, 0x02, 0x00, 0xFF
 },
 {
  0x0B, 0x25, 0x07, 0xE9, 0x06, 0xFF, 0x0F, 0x0D,
  0x04, 0xF7, 0x07, 0x05, 0x03, 0xFD, 0xFB, 0xF8,
  0xFE, 0x03, 0xFB, 0xFF, 0xF8, 0x07, 0x02, 0x0D,
  0x01, 0x03, 0x00, 0xFD, 0xFF, 0x02, 0x00, 0xFE
 },
 {
  0x15, 0x21, 0x07, 0x14, 0x15, 0xF6, 0x06, 0xFB,
  0xFB, 0xFA, 0xF7, 0x02, 0x0A, 0x00, 0x08, 0xFC,
  0x0A, 0x02, 0xFE, 0xFE, 0x00, 0xF6, 0xFA, 0xFE,
  0x00, 0xFB, 0x03, 0xF5, 0x03, 0xF7, 0xFD, 0x01
 },
 {
  0x06, 0x1E, 0xF1, 0xF8, 0x10, 0x01, 0x04, 0x06,
  0x04, 0x05, 0x08, 0xFD, 0x08, 0xF7, 0xFF, 0xFA,
  0x08, 0x02, 0xFE, 0x04, 0xFE, 0x05, 0x0B, 0xEB,
  0x03, 0xF6, 0x10, 0xF5, 0x18, 0x0A, 0x0E, 0xFA
 },
 {
  0x0F, 0x24, 0xFD, 0xF7, 0xEC, 0x0C, 0x00, 0xF9,
  0xEE, 0xFC, 0xF8, 0xF7, 0x09, 0xF9, 0xFD, 0xFF,
  0x02, 0x07, 0xFB, 0xF8, 0x06, 0x02, 0x02, 0xFF,
  0x07, 0x01, 0x01, 0xFD, 0x03, 0xFC, 0xF8, 0x01
 },
 {
  0x10, 0x22, 0x15, 0x03, 0xF7, 0x0A, 0x07, 0x09,
  0xF9, 0x01, 0xFC, 0xF7, 0xFC, 0xFB, 0xFB, 0x03,
  0x03, 0xED, 0x01, 0x05, 0x04, 0xFE, 0xFA, 0xFB,
  0xF6, 0xF5, 0xF8, 0xFE, 0x02, 0xFB, 0xF8, 0xF9
 },
 {
  0x1C, 0x1D, 0xFD, 0x12, 0xFE, 0x00, 0xFA, 0x0C,
  0xFE, 0x0A, 0xF5, 0xFC, 0xF3, 0xF4, 0xFA, 0xFC,
  0x00, 0x04, 0xFF, 0xF8, 0x06, 0x04, 0x0C, 0x0B,
  0x0A, 0x0A, 0xFD, 0xFA, 0x01, 0x02, 0x01, 0x07
 },
 {
  0x03, 0x08, 0x16, 0xF8, 0x03, 0x24, 0xF8, 0xFF,
  0x09, 0x06, 0xF3, 0xF2, 0x08, 0xFF, 0x01, 0x02,
  0xFE, 0xF8, 0x00, 0x03, 0x01, 0x02, 0xFF, 0x05,
  0xFF, 0xF8, 0x00, 0xFE, 0x02, 0x02, 0xFF, 0x01
 },
 {
  0x00, 0x06, 0x00, 0x00, 0x04, 0x0D, 0xF9, 0xF0,
  0xFA, 0x0F, 0xF2, 0xEB, 0xF7, 0xF6, 0xF6, 0xFA,
  0xEB, 0x05, 0x04, 0x02, 0x0C, 0x04, 0x0C, 0x0B,
  0xFC, 0xFA, 0xFA, 0xF6, 0xF9, 0xEE, 0x01, 0x04
 },
 {
  0xFF, 0x03, 0x0A, 0x01, 0xFF, 0x0F, 0x04, 0xF9,
  0xF0, 0x03, 0x00, 0xEA, 0x0A, 0x02, 0xFD, 0xFE,
  0x0D, 0x05, 0xF8, 0x10, 0xFB, 0x04, 0x00, 0xF5,
  0xF6, 0xEA, 0x00, 0xFC, 0xEF, 0x05, 0x02, 0x01
 },
 {
  0x0C, 0x08, 0xFC, 0xF7, 0x0E, 0x28, 0xEB, 0x00,
  0x01, 0xF1, 0xF6, 0xF4, 0x0C, 0x06, 0xF6, 0x02,
  0x08, 0x06, 0xF4, 0xF6, 0xF5, 0x01, 0x00, 0xF5,
  0x02, 0x01, 0x0D, 0x00, 0x06, 0x03, 0x08, 0x04
 },
 {
  0xF6, 0x03, 0x05, 0xFC, 0xFD, 0x03, 0x00, 0xF7,
  0x02, 0x08, 0xEA, 0xE9, 0x11, 0x08, 0xEF, 0xFD,
  0x0E, 0xF8, 0xFC, 0x01, 0xF8, 0x03, 0x00, 0x05,
  0xFF, 0xFD, 0xFE, 0xFC, 0x01, 0xF6, 0x00, 0xFE
 },
 {
  0x00, 0xFF, 0x05, 0xF9, 0x04, 0x0C, 0xFE, 0x00,
  0xF9, 0x02, 0xF0, 0xF1, 0x0C, 0x15, 0xF9, 0xFC,
  0x07, 0xF9, 0xF5, 0xF1, 0xF9, 0xF7, 0xFB, 0xF8,
  0x00, 0xFA, 0x08, 0xFD, 0xF8, 0x16, 0xF9, 0xF7
 },
 {
  0x07, 0x13, 0x04, 0xF7, 0x18, 0x16, 0x02, 0xFA,
  0x08, 0x0D, 0xF2, 0xEC, 0xFC, 0x0B, 0x08, 0xFC,
  0xFF, 0x02, 0x00, 0xF9, 0x05, 0xEF, 0xFD, 0x03,
  0xFA, 0x05, 0x03, 0x04, 0xFB, 0xF9, 0xFD, 0x0E
 },
 {
  0xFE, 0x06, 0x02, 0x08, 0xFE, 0x05, 0xFC, 0xFE,
  0xF6, 0x03, 0xD3, 0xE2, 0xFD, 0xFD, 0xF4, 0xFC,
  0xFD, 0xFD, 0xFF, 0x09, 0xFA, 0xFA, 0x05, 0xFC,
  0x00, 0x05, 0xFF, 0xFE, 0xFF, 0x00, 0xFA, 0xFF
 },
 {
  0xFD, 0x0E, 0xF0, 0xF6, 0x0A, 0x00, 0xFE, 0xD8,
  0xF7, 0x0C, 0x02, 0xED, 0x0F, 0xFC, 0x04, 0x03,
  0x03, 0xFC, 0x07, 0x01, 0xFC, 0xFB, 0x00, 0x04,
  0xFF, 0x00, 0xF7, 0xFE, 0xFC, 0xFF, 0xFE, 0x00
 },
 {
  0x07, 0x10, 0x02, 0xF9, 0x08, 0x02, 0x00, 0x01,
  0x05, 0x15, 0xF6, 0xE6, 0x07, 0x02, 0xF7, 0xF9,
  0xFD, 0xF0, 0x08, 0x05, 0x05, 0xFA, 0x0A, 0x04,
  0xF2, 0xFA, 0x05, 0x03, 0xFE, 0xFE, 0xFC, 0x01
 },
 {
  0xF7, 0x0E, 0xFF, 0x03, 0x03, 0x0B, 0x01, 0xFB,
  0xFD, 0x0D, 0xF0, 0xEE, 0x14, 0x06, 0xFB, 0x00,
  0xFD, 0x02, 0x08, 0x04, 0xED, 0xF7, 0x0C, 0x00,
  0xF8, 0x02, 0x02, 0x01, 0x06, 0x0D, 0xF9, 0xF5
 },
 {
  0x02, 0x05, 0x10, 0xFC, 0x13, 0x0F, 0x04, 0x00,
  0xF5, 0x07, 0xF6, 0xF6, 0xF0, 0x12, 0xF5, 0xF4,
  0xF7, 0xFC, 0x07, 0xFC, 0xFC, 0xEF, 0x01, 0x01,
  0xF8, 0xFD, 0xFD, 0x05, 0xFE, 0xFA, 0xF5, 0xFB
 },
 {
  0x02, 0x0C, 0x00, 0xF7, 0xF6, 0x0E, 0x06, 0x02,
  0xFD, 0x02, 0xF4, 0xE4, 0x0C, 0x01, 0xFF, 0x02,
  0x00, 0xFD, 0xFC, 0x07, 0x10, 0x05, 0xF9, 0x08,
  0xFC, 0xFD, 0xFF, 0x03, 0xF4, 0x04, 0xEF, 0xFB
 },
 {
  0xFC, 0x07, 0x0B, 0x06, 0x01, 0x0E, 0xFC, 0xFA,
  0x05, 0x05, 0xFA, 0xE8, 0x17, 0xF7, 0xF1, 0x0D,
  0xF9, 0xF7, 0xF1, 0x0A, 0xFF, 0x08, 0xFB, 0x01,
  0x0C, 0x06, 0x02, 0x00, 0x04, 0xFE, 0x09, 0xF6
 },
 {
  0x01, 0x05, 0x0B, 0x03, 0x06, 0x0C, 0xFD, 0x08,
  0xEB, 0x05, 0xF9, 0xEC, 0x0C, 0xFE, 0xF7, 0xFD,
  0x11, 0xF9, 0xF8, 0xF7, 0xF2, 0x03, 0xF3, 0x12,
  0xF8, 0x09, 0x02, 0xF8, 0x04, 0xF8, 0xFB, 0xFE
 },
 {
  0xFD, 0xFD, 0xFF, 0x05, 0xFE, 0x0F, 0x03, 0x02,
  0x01, 0xF8, 0x01, 0xD9, 0xFA, 0x0D, 0xF3, 0x00,
  0xFE, 0xFB, 0xFA, 0xFD, 0x00, 0xFB, 0xFE, 0x0F,
  0xF7, 0x05, 0xFD, 0xFA, 0xFE, 0x07, 0x00, 0xF3
 },
 {
  0x02, 0x08, 0x05, 0xF4, 0xF3, 0x16, 0x08, 0xF0,
  0x0B, 0x05, 0xFE, 0xE0, 0xFE, 0xFC, 0x0B, 0x05,
  0x05, 0xFA, 0x01, 0x03, 0x01, 0x05, 0x03, 0x06,
  0xFB, 0x04, 0x04, 0xF8, 0x08, 0x04, 0x01, 0x03
 },
 {
  0x0D, 0x09, 0x05, 0xFC, 0x09, 0x12, 0xF5, 0x02,
  0xFF, 0x0F, 0xF6, 0xED, 0xFE, 0x0E, 0x00, 0xF6,
  0x01, 0x01, 0xEE, 0x03, 0x02, 0xFA, 0xF8, 0x14,
  0x07, 0xF8, 0x10, 0x09, 0x09, 0xF3, 0xFD, 0xFE
 },
 {
  0xF3, 0x0B, 0x0B, 0xF7, 0xF6, 0x0D, 0xFD, 0xEE,
  0x02, 0x0A, 0x05, 0xEB, 0x06, 0x0F, 0xF5, 0xEB,
  0x03, 0x0E, 0x00, 0xF4, 0x09, 0xFF, 0xFE, 0xFC,
  0x03, 0xFD, 0xF7, 0xF8, 0xFB, 0xFE, 0xF8, 0x02
 },
 {
  0x03, 0x03, 0x0B, 0x04, 0x00, 0x0D, 0x01, 0xF8,
  0x0A, 0x0D, 0xFA, 0xE6, 0x02, 0x0C, 0xFD, 0xFB,
  0x0C, 0xFE, 0x01, 0x08, 0xF9, 0xEF, 0xED, 0x05,
  0x0A, 0x07, 0xFD, 0x02, 0xFD, 0x00, 0x05, 0x00
 },
 {
  0x05, 0x00, 0x03, 0xFD, 0xF7, 0x05, 0xF1, 0xFB,
  0xFB, 0x11, 0xFB, 0xE1, 0x00, 0x0D, 0x0D, 0x05,
  0xFF, 0xFA, 0xF2, 0x07, 0xF8, 0x09, 0xF2, 0xFE,
  0xF0, 0xFC, 0xFC, 0xFA, 0x06, 0xFA, 0xF6, 0x06
 },
 {
  0x0D, 0x03, 0x01, 0x07, 0xFD, 0x04, 0xFF, 0xFE,
  0xFF, 0x04, 0xF8, 0xE0, 0xFF, 0xFC, 0x00, 0x03,
  0xF6, 0x07, 0x0A, 0xF6, 0x04, 0xFF, 0x06, 0x02,
  0xF0, 0xF7, 0x04, 0x03, 0x0D, 0xE9, 0xFD, 0xFC
 },
 {
  0x04, 0x0B, 0xFC, 0xF7, 0x04, 0x0B, 0xF4, 0xF4,
  0xF4, 0x06, 0x01, 0xE4, 0xFD, 0x0E, 0x12, 0xFE,
  0xF4, 0x07, 0x0F, 0xFD, 0xFB, 0xF9, 0xFD, 0x02,
  0xFA, 0x04, 0x04, 0xFE, 0xFB, 0xFD, 0x02, 0xF3
 },
 {
  0x08, 0x07, 0xF9, 0x00, 0x0D, 0x07, 0xF8, 0xF9,
  0x08, 0x24, 0xF6, 0xEA, 0x03, 0x17, 0xFD, 0xF6,
  0xFD, 0x0B, 0x01, 0xF9, 0x03, 0x03, 0xFF, 0xF9,
  0xFC, 0x02, 0x03, 0x02, 0x05, 0x03, 0xFC, 0xFF
 },
 {
  0xFF, 0x01, 0x0D, 0x01, 0xFA, 0xFF, 0xFA, 0xF7,
  0xEE, 0x11, 0xFB, 0xDB, 0xFF, 0xFF, 0xFA, 0xFC,
  0x01, 0xFA, 0xF1, 0x02, 0x11, 0xF7, 0x00, 0xFD,
  0x00, 0x04, 0x00, 0xFB, 0x00, 0x04, 0x01, 0xFB
 },
 {
  0x00, 0x0E, 0x05, 0x00, 0xF9, 0x02, 0xFA, 0x11,
  0xFA, 0xF7, 0x07, 0xF0, 0xFB, 0x17, 0xF2, 0xF3,
  0x08, 0xF1, 0x0B, 0x0A, 0xF5, 0xF3, 0xDF, 0xFB,
  0xFE, 0x01, 0x06, 0x08, 0x00, 0xF3, 0xF7, 0x05
 },
 {
  0x0B, 0x07, 0xFE, 0xF8, 0x09, 0x0B, 0x19, 0xF2,
  0x07, 0x03, 0xFF, 0xDF, 0x0E, 0x08, 0xFA, 0xED,
  0x03, 0x03, 0x02, 0xFF, 0xFD, 0xFF, 0xFE, 0xF6,
  0xFD, 0x01, 0x02, 0x01, 0x04, 0x02, 0xFD, 0x04
 },
 {
  0xFE, 0x08, 0x04, 0xFE, 0x09, 0x0D, 0xFC, 0xFE,
  0xF1, 0xFD, 0x13, 0xDB, 0x09, 0x19, 0xF7, 0x02,
  0xFB, 0xFE, 0xFE, 0xFC, 0x04, 0x02, 0x02, 0x00,
  0x03, 0x03, 0x03, 0x05, 0xFE, 0xFD, 0xFC, 0xFD
 },
 {
  0x0A, 0x0D, 0xFF, 0xF1, 0x04, 0x06, 0xEE, 0xFC,
  0x19, 0x01, 0xE9, 0xEF, 0x0F, 0x0D, 0xF8, 0xF8,
  0x07, 0x04, 0xFB, 0x03, 0x06, 0x09, 0xF9, 0x06,
  0x00, 0xFB, 0x08, 0x00, 0xFA, 0xFF, 0xFE, 0xFE
 },
 {
  0x01, 0x03, 0x09, 0xFB, 0x1B, 0x0F, 0xF7, 0xE1,
  0xFF, 0x17, 0xFE, 0xF7, 0x01, 0x08, 0xFF, 0xF9,
  0xFE, 0xF8, 0xFC, 0xFC, 0xFE, 0xFF, 0x03, 0x05,
  0x00, 0x00, 0xFF, 0x01, 0xF9, 0x07, 0xFD, 0xFD
 },
 {
  0xF8, 0x07, 0x03, 0xFA, 0x08, 0x03, 0xF5, 0xFE,
  0x24, 0x0E, 0x01, 0xE2, 0x06, 0x0A, 0xF4, 0xFA,
  0xFA, 0xFE, 0xFC, 0xFD, 0xFB, 0x00, 0x09, 0x04,
  0xFB, 0xFB, 0xF8, 0x0C, 0x04, 0xFD, 0x01, 0xF8
 },
 {
  0xFE, 0x09, 0x21, 0x00, 0x0C, 0xFD, 0xF9, 0xFC,
  0xFC, 0xFF, 0x06, 0xE7, 0x0B, 0xFA, 0xF7, 0xF5,
  0xFE, 0xFC, 0xFE, 0x06, 0xFF, 0xFD, 0xFA, 0x0F,
  0xFA, 0x03, 0x0A, 0xFC, 0x01, 0x00, 0x05, 0x08
 },
 {
  0xEA, 0xEB, 0xF7, 0xED, 0xFB, 0xF9, 0xF4, 0xF1,
  0xF8, 0x09, 0xED, 0x0E, 0xF9, 0xFC, 0x05, 0xF8,
  0xFE, 0x07, 0x01, 0xFD, 0x04, 0xFC, 0x06, 0x0B,
  0x02, 0x06, 0xFD, 0xFB, 0x02, 0xFE, 0x00, 0xFD
 },
 {
  0xE0, 0xF3, 0x03, 0xE8, 0x03, 0xF8, 0x04, 0x01,
  0xF6, 0x0E, 0xF1, 0x00, 0x04, 0x06, 0xFF, 0x06,
  0x07, 0xFF, 0x06, 0x04, 0xFD, 0xEF, 0x01, 0x04,
  0xFA, 0xFF, 0x01, 0x00, 0x03, 0x03, 0xF9, 0xFC
 },
 {
  0xE0, 0xF5, 0x07, 0xF8, 0xF4, 0x0D, 0xFB, 0xEA,
  0xFC, 0x0C, 0xF0, 0x02, 0x00, 0x04, 0x00, 0x01,
  0x00, 0x06, 0xFB, 0xF8, 0x02, 0x06, 0x05, 0x00,
  0xFD, 0xFA, 0x05, 0x06, 0x05, 0x05, 0x0D, 0xFC
 },
 {
  0xD4, 0xDF, 0x06, 0xFC, 0x02, 0x00, 0xF7, 0x0A,
  0x03, 0x04, 0x07, 0x00, 0xFF, 0x07, 0x05, 0x01,
  0x01, 0xFD, 0x01, 0x06, 0xFF, 0x00, 0x02, 0x03,
  0xFC, 0x00, 0x00, 0x01, 0x00, 0xFF, 0xFE, 0xFF
 },
 {
  0xE2, 0xEE, 0xE8, 0xF8, 0x05, 0x00, 0xFE, 0x0E,
  0x07, 0x00, 0x01, 0x0C, 0x06, 0x04, 0xF7, 0x07,
  0x05, 0x07, 0xF5, 0xFB, 0x01, 0xF8, 0xFF, 0x02,
  0x02, 0xF7, 0x07, 0xFF, 0x07, 0x05, 0x06, 0x06
 },
 {
  0xEA, 0xEC, 0xF3, 0xF7, 0x14, 0xFD, 0x0A, 0xF8,
  0x06, 0xFC, 0x02, 0xF9, 0x0A, 0x08, 0x00, 0xFF,
  0x02, 0xFD, 0x06, 0xED, 0x02, 0x04, 0x03, 0x03,
  0xF9, 0x02, 0xFF, 0xFA, 0x01, 0x01, 0x06, 0xFE
 },
 {
  0xE5, 0xF8, 0xFF, 0x03, 0xFF, 0xF5, 0x18, 0x04,
  0xFF, 0x01, 0xF8, 0x08, 0x05, 0xF5, 0x0F, 0xFD,
  0xF1, 0xFF, 0xFF, 0xF3, 0xFF, 0x01, 0xFB, 0x05,
  0x02, 0x03, 0xF7, 0x00, 0x04, 0x03, 0xF9, 0x06
 },
 {
  0xDF, 0xF0, 0xFF, 0xF8, 0x0A, 0xE9, 0x06, 0x0D,
  0xFF, 0xFD, 0xF7, 0x00, 0x05, 0xF9, 0xFB, 0xF4,
  0xFE, 0x03, 0x03, 0x06, 0xFE, 0xFD, 0x02, 0xFD,
  0x09, 0xFA, 0xFD, 0xFE, 0x00, 0x05, 0xFD, 0xFC
 },
 {
  0xEA, 0xEF, 0x0B, 0xFD, 0x03, 0x01, 0xFF, 0xFB,
  0x11, 0x02, 0xF1, 0xFE, 0x0A, 0xF7, 0x06, 0x0E,
  0xF0, 0xF4, 0x14, 0xFF, 0xF9, 0x06, 0xFD, 0xF4,
  0x01, 0x0A, 0xF6, 0xFF, 0x07, 0xFD, 0xFF, 0x0A
 },
 {
  0xE4, 0xF3, 0x01, 0xFD, 0xFF, 0xFF, 0x00, 0x03,
  0x03, 0x05, 0x01, 0x0A, 0xF6, 0xFD, 0x07, 0x02,
  0x04, 0x13, 0xFF, 0xFF, 0x0A, 0x05, 0xF8, 0x01,
  0x0B, 0xF1, 0xFC, 0xFD, 0xFB, 0x04, 0xF3, 0x03
 },
 {
  0xEA, 0xF3, 0x2A, 0xEC, 0x05, 0xF3, 0x07, 0xF5,
  0x01, 0x01, 0xFF, 0x01, 0x06, 0x03, 0x06, 0xF5,
  0x03, 0x03, 0xFE, 0x00, 0xFC, 0x04, 0xFD, 0xFF,
  0xFB, 0x02, 0x00, 0x00, 0xF7, 0xFF, 0x04, 0x04
 },
 {
  0xE6, 0xF1, 0xFE, 0xFA, 0xFC, 0xFE, 0x10, 0x08,
  0x15, 0x08, 0x01, 0xFD, 0xF6, 0x07, 0xF8, 0xF4,
  0xFB, 0x0C, 0xF7, 0x03, 0xFE, 0xFD, 0x12, 0x01,
  0xF4, 0xF1, 0xFC, 0x05, 0xFD, 0x00, 0x0C, 0x07
 },
 {
  0xE6, 0xF0, 0x05, 0x06, 0x0E, 0xFD, 0x0F, 0x06,
  0x01, 0xF9, 0xF3, 0x10, 0xF1, 0x05, 0x0B, 0xFE,
  0x09, 0xF9, 0xFC, 0xFE, 0x00, 0x00, 0xFE, 0x07,
  0xF8, 0xFA, 0xFB, 0x02, 0x07, 0xFD, 0x02, 0x0C
 },
 {
  0xE1, 0xEF, 0xF8, 0xE2, 0x04, 0x0E, 0x06, 0xFA,
  0x06, 0xF5, 0x00, 0x03, 0xFC, 0x00, 0x00, 0xFC,
  0x00, 0xFC, 0x01, 0x04, 0x03, 0x04, 0x00, 0xFB,
  0x03, 0x02, 0x02, 0x00, 0x02, 0x01, 0x03, 0x05
 },
 {
  0xC3, 0xF6, 0x04, 0x0A, 0x04, 0x07, 0x00, 0xFD,
  0x00, 0x01, 0x00, 0xFD, 0x00, 0x01, 0x00, 0xFE,
  0xFF, 0x01, 0x02, 0xFE, 0x04, 0xFD, 0x01, 0x01,
  0xFF, 0x01, 0xFE, 0xFC, 0xFC, 0x04, 0x00, 0x00
 },
 {
  0xE4, 0xF3, 0xF8, 0xFC, 0x03, 0xFD, 0x02, 0x01,
  0x0B, 0x0E, 0x03, 0x09, 0x01, 0x0D, 0x03, 0x05,
  0xFD, 0xFE, 0xFE, 0xF4, 0xF2, 0xF7, 0xF5, 0xF1,
  0xF4, 0xFB, 0xFC, 0xF4, 0x03, 0xFD, 0x00, 0xFB
 },
 {
  0xD7, 0x00, 0x0C, 0xE8, 0x0D, 0x04, 0x05, 0x10,
  0xFB, 0xFC, 0x00, 0x00, 0x0D, 0xFC, 0x01, 0xF7,
  0x09, 0xFA, 0xFF, 0x06, 0xFE, 0x05, 0x02, 0x09,
  0x06, 0xF7, 0xF8, 0x08, 0xFE, 0xFD, 0xFA, 0xFC
 },
 {
  0xE6, 0xED, 0xFE, 0xF1, 0x04, 0xF2, 0x06, 0x00,
  0x1A, 0x14, 0x08, 0x09, 0x09, 0x03, 0xFC, 0xFB,
  0xF8, 0x01, 0x00, 0xFF, 0x05, 0x09, 0x03, 0x04,
  0x04, 0x07, 0x01, 0x03, 0xFE, 0xFE, 0xF6, 0x00
 },
 {
  0xE3, 0xEE, 0x09, 0xFC, 0x01, 0xFB, 0xF2, 0xF4,
  0x05, 0xF6, 0xFB, 0x04, 0xFB, 0x00, 0xFF, 0xFF,
  0x04, 0xFB, 0x07, 0xF0, 0xF5, 0x02, 0x07, 0xF1,
  0x02, 0xFC, 0x06, 0xFC, 0xFA, 0x07, 0xFD, 0x07
 },
 {
  0xE5, 0xF0, 0x09, 0xF2, 0x03, 0xF8, 0x09, 0x00,
  0x07, 0xFC, 0xFD, 0xF9, 0x00, 0xF6, 0xFF, 0x02,
  0x01, 0xFE, 0x0F, 0xF6, 0x0E, 0x07, 0x06, 0x11,
  0x03, 0xFC, 0x03, 0xF6, 0x08, 0xF8, 0x03, 0x0B
 },
 {
  0xEB, 0xEC, 0xF8, 0xF8, 0x04, 0x05, 0xFD, 0xFE,
  0x00, 0xFB, 0x0E, 0xF6, 0x0B, 0xFC, 0x0D, 0x00,
  0x05, 0xF5, 0x13, 0xEE, 0x12, 0x03, 0xFB, 0xFD,
  0xFC, 0xF8, 0x0B, 0xF6, 0x0A, 0x03, 0x04, 0xF7
 },
 {
  0xDD, 0xF1, 0x0D, 0xF4, 0x04, 0x00, 0xFE, 0xFC,
  0xF4, 0xFD, 0xF8, 0xE8, 0xF9, 0x01, 0x07, 0x08,
  0xFD, 0x00, 0xFE, 0xFF, 0x03, 0xFE, 0xFE, 0xFA,
  0x08, 0x01, 0x00, 0x01, 0xFA, 0xFF, 0x02, 0xFA
 },
 {
  0xED, 0xF2, 0x0D, 0xF6, 0x09, 0xFF, 0x01, 0x03,
  0xF4, 0x05, 0xF0, 0x07, 0x0D, 0x09, 0x04, 0xFC,
  0x06, 0xFB, 0x04, 0x09, 0xFD, 0x11, 0xFC, 0x0C,
  0xF5, 0xFA, 0xFB, 0xFA, 0x0D, 0x02, 0x07, 0xF7
 },
 {
  0xDE, 0xF8, 0xFC, 0x01, 0x02, 0xFF, 0x03, 0x06,
  0xEC, 0xF5, 0x08, 0xFF, 0x04, 0x02, 0xF7, 0x04,
  0xFC, 0xFB, 0x10, 0x0A, 0xFC, 0x0E, 0xF3, 0x01,
  0xFA, 0x00, 0x02, 0xF6, 0x00, 0xFD, 0xFD, 0x07
 },
 {
  0xDC, 0xF6, 0xF8, 0xFD, 0x02, 0xFE, 0x0E, 0xFC,
  0xFF, 0xF9, 0xFC, 0x0A, 0xFF, 0xFD, 0x0F, 0xF5,
  0x00, 0x02, 0x03, 0xFF, 0x04, 0x00, 0x08, 0xFF,
  0x00, 0x12, 0xF5, 0xFB, 0x0F, 0xFB, 0x0D, 0xF4
 },
 {
  0xEA, 0xF3, 0x0E, 0xEC, 0x0F, 0x19, 0x10, 0x0A,
  0x08, 0xFE, 0xF6, 0xFB, 0xFF, 0xF8, 0x0B, 0x08,
  0xFF, 0xFE, 0xFC, 0x01, 0x02, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0xFD, 0x00, 0x02, 0xFF, 0x00, 0x02
 },
 {
  0xE1, 0xEA, 0x07, 0x06, 0xFE, 0x05, 0xEC, 0x0E,
  0xFA, 0x07, 0x00, 0x0E, 0x03, 0xF9, 0x03, 0xFA,
  0xFE, 0x01, 0xFD, 0xFB, 0x01, 0xF6, 0x01, 0xE8,
  0x06, 0xFE, 0x03, 0xF9, 0x01, 0xF9, 0x08, 0x07
 },
 {
  0xE7, 0xEC, 0xFD, 0xF7, 0x0A, 0x06, 0x0C, 0x07,
  0x05, 0x04, 0xFD, 0x06, 0xFF, 0xFB, 0xFA, 0xF8,
  0x03, 0x05, 0x06, 0x05, 0xF6, 0x0A, 0xFC, 0xF1,
  0xF1, 0xFE, 0xF7, 0x02, 0x12, 0x01, 0x08, 0x0C
 },
 {
  0xE8, 0xED, 0xFE, 0xFC, 0xF9, 0x0B, 0x06, 0x09,
  0x10, 0x02, 0xF9, 0x12, 0x06, 0xF9, 0x06, 0x06,
  0xFE, 0xF7, 0x03, 0x0C, 0xFE, 0x03, 0xFF, 0x06,
  0x07, 0x08, 0x00, 0x08, 0xF5, 0x08, 0x04, 0x02
 },
 {
  0xE6, 0xEC, 0xF4, 0xF4, 0xFE, 0xFD, 0x01, 0xFB,
  0xFF, 0xFE, 0x00, 0x03, 0x07, 0x09, 0xFE, 0x02,
  0x09, 0x16, 0x0D, 0x04, 0xFC, 0xFF, 0xFE, 0xF2,
  0x05, 0x0F, 0xF8, 0xFB, 0xF9, 0xF5, 0xF2, 0xFA
 },
 {
  0xEB, 0xEE, 0xFF, 0xFC, 0x00, 0x03, 0x07, 0xFE,
  0x0A, 0x08, 0xF8, 0xFF, 0x0F, 0x01, 0xF7, 0x03,
  0x01, 0x03, 0xFB, 0xFE, 0x02, 0x04, 0x00, 0xFF,
  0x0A, 0x02, 0xED, 0xF8, 0x08, 0x1E, 0xF9, 0x08
 },
 {
  0xE7, 0xFA, 0x1A, 0x04, 0xF8, 0x04, 0xFE, 0x15,
  0x05, 0xFC, 0xF0, 0x05, 0x0D, 0x04, 0xF6, 0xFF,
  0xFA, 0xFE, 0x02, 0xF6, 0xF3, 0x01, 0x03, 0xFD,
  0xFA, 0xF8, 0x02, 0x0B, 0x01, 0xF9, 0x00, 0x05
 },
 {
  0x00, 0xFF, 0xFE, 0x13, 0xF4, 0xD0, 0xFA, 0x0B,
  0x08, 0xFE, 0xFC, 0xFE, 0xF9, 0x05, 0xFD, 0x02,
  0xFE, 0xFF, 0xFF, 0xF9, 0x00, 0xFD, 0xFD, 0xFC,
  0xFC, 0x04, 0x01, 0x03, 0xFD, 0xFF, 0xFE, 0xFB
 },
 {
  0xF5, 0xF8, 0xE4, 0x12, 0x10, 0xE8, 0xF8, 0x13,
  0x04, 0x08, 0xF4, 0x09, 0xFC, 0xFE, 0x04, 0xF9,
  0x06, 0x02, 0x03, 0x03, 0xFC, 0x00, 0x01, 0xFA,
  0xFC, 0xFE, 0x02, 0x06, 0x00, 0xFD, 0x01, 0xF0
 },
 {
  0xF7, 0xFB, 0xE6, 0x07, 0xFD, 0xDB, 0xF0, 0xFE,
  0x02, 0xF9, 0x04, 0xF3, 0x00, 0xFC, 0xFA, 0xFB,
  0xFA, 0xFC, 0x00, 0x03, 0x04, 0xFD, 0xFC, 0xFC,
  0x04, 0xFD, 0x09, 0xFC, 0xFE, 0x02, 0x07, 0xFC
 },
 {
  0x02, 0x09, 0xEE, 0x07, 0x1D, 0xE8, 0xFF, 0x07,
  0x0E, 0x0A, 0x03, 0xFD, 0xFE, 0xFB, 0x06, 0xF6,
  0xFA, 0xFD, 0xF8, 0x00, 0x05, 0x01, 0x04, 0x03,
  0xF4, 0x02, 0x06, 0x01, 0x03, 0x04, 0x01, 0xFD
 },
 {
  0xEC, 0x02, 0x08, 0x14, 0xF7, 0xE8, 0xFC, 0x12,
  0x03, 0x0B, 0xFF, 0xF5, 0x06, 0x09, 0xFF, 0xFD,
  0x01, 0xFF, 0xF1, 0x03, 0x0F, 0x09, 0x03, 0x02,
  0xF3, 0x02, 0xF8, 0x08, 0x01, 0xFF, 0x01, 0xF8
 },
 {
  0xF4, 0x05, 0xF5, 0x06, 0x13, 0xE6, 0xEF, 0xFA,
  0x04, 0x0E, 0x06, 0xF8, 0x09, 0x05, 0xFA, 0xFB,
  0x02, 0xFF, 0x14, 0x01, 0xF5, 0xF6, 0xEE, 0x14,
  0xF9, 0x00, 0xFD, 0x04, 0x02, 0x00, 0x0A, 0x04
 },
 {
  0xF1, 0x01, 0xFE, 0x0D, 0xF8, 0xEB, 0xEA, 0x04,
  0x04, 0x03, 0x03, 0xF9, 0xE1, 0x04, 0xF6, 0xF2,
  0x00, 0x08, 0x04, 0x05, 0x08, 0x0B, 0x02, 0xF8,
  0x06, 0x07, 0x00, 0xFE, 0x06, 0x08, 0x08, 0x07
 },
 {
  0xF3, 0xF6, 0xF7, 0x0C, 0x13, 0xF0, 0xFD, 0xFE,
  0x09, 0x02, 0x0B, 0xE3, 0xFF, 0x09, 0x04, 0xFD,
  0x01, 0xF6, 0xF6, 0x10, 0x01, 0x07, 0xF9, 0xFA,
  0xFC, 0xFF, 0xFB, 0x03, 0x06, 0x00, 0x03, 0x01
 },
 {
  0xEF, 0xFF, 0xFB, 0x13, 0x0C, 0xF7, 0xEB, 0xFB,
  0x02, 0x0C, 0xF9, 0xF9, 0xFD, 0x08, 0x07, 0xFE,
  0x06, 0xF7, 0xF7, 0x01, 0xFC, 0x01, 0x01, 0x03,
  0xF2, 0x02, 0xF8, 0x00, 0x0A, 0x01, 0xF4, 0xFA
 },
 {
  0xF3, 0xFB, 0x08, 0x0F, 0x00, 0xEC, 0xFE, 0x14,
  0x08, 0xF8, 0x08, 0xED, 0x0C, 0x0A, 0x02, 0xF5,
  0x00, 0x0C, 0x01, 0xF5, 0x00, 0xF5, 0xF1, 0x05,
  0xF5, 0x02, 0x04, 0xFC, 0xF5, 0x05, 0xFC, 0xFB
 },
 {
  0x03, 0xF5, 0xF9, 0x08, 0x00, 0xEF, 0xE6, 0x0F,
  0x13, 0xF9, 0x0A, 0xF7, 0xFB, 0xFB, 0x0E, 0xE7,
  0x00, 0xF8, 0x02, 0xF7, 0xFD, 0x09, 0x01, 0xFA,
  0x04, 0xFC, 0x03, 0xF7, 0xFF, 0x06, 0x02, 0x02
 },
 {
  0xF4, 0x05, 0x05, 0x09, 0x0E, 0xEE, 0xED, 0x04,
  0x02, 0x10, 0x0E, 0xEB, 0xF1, 0xF7, 0xFF, 0x10,
  0x0C, 0xF5, 0xF6, 0xFB, 0xF9, 0x04, 0x0F, 0xF8,
  0xFB, 0xFF, 0x01, 0x0E, 0x0D, 0xF9, 0xFF, 0xFC
 },
 {
  0xF6, 0xFB, 0xFF, 0x08, 0x07, 0xE9, 0xF6, 0x0E,
  0x06, 0x0B, 0x0A, 0xF0, 0xFD, 0x10, 0x06, 0x00,
  0x00, 0x09, 0x06, 0xFE, 0xF9, 0x01, 0x16, 0x05,
  0x03, 0xF8, 0x00, 0x03, 0xFE, 0xF6, 0x03, 0x00
 },
 {
  0xFE, 0xF2, 0x02, 0x10, 0x0F, 0xEF, 0xEF, 0x06,
  0x13, 0x04, 0xF6, 0xF1, 0xFF, 0x0F, 0x0B, 0xF2,
  0xF8, 0x05, 0x08, 0x08, 0xFE, 0xF8, 0xF5, 0x0A,
  0x0A, 0xF8, 0xF2, 0x02, 0x0D, 0x04, 0xFE, 0xF4
 },
 {
  0xF6, 0x03, 0x06, 0x04, 0x13, 0xE9, 0xED, 0x01,
  0x04, 0xF7, 0xE2, 0x03, 0xFA, 0x12, 0x00, 0x02,
  0x00, 0xF5, 0x00, 0x03, 0x07, 0xFE, 0x08, 0x05,
  0x02, 0xFD, 0x06, 0xF7, 0x01, 0xFC, 0x07, 0xFA
 },
 {
  0x09, 0x05, 0xFE, 0x15, 0x14, 0xDF, 0xF3, 0x07,
  0xF6, 0x08, 0x08, 0xF1, 0xFA, 0xFC, 0x01, 0x05,
  0x03, 0x07, 0xFE, 0xF7, 0xFF, 0x04, 0xFA, 0x01,
  0x00, 0x09, 0xFF, 0xFB, 0x02, 0x01, 0xFD, 0x03
 },
 {
  0xF7, 0xFD, 0x03, 0x0F, 0xFD, 0xE2, 0xF9, 0xF9,
  0xE7, 0x06, 0x02, 0xFA, 0x01, 0x13, 0x01, 0xF4,
  0x01, 0xF8, 0xF3, 0x09, 0x0D, 0x01, 0x08, 0x02,
  0x05, 0x0F, 0xFE, 0x03, 0xF7, 0x00, 0xFC, 0x04
 },
 {
  0xFA, 0xF4, 0xEF, 0x19, 0x16, 0xF3, 0xF6, 0x09,
  0x02, 0x0B, 0xF9, 0xF0, 0x04, 0x06, 0x01, 0x00,
  0x00, 0x12, 0xFC, 0xFB, 0x04, 0xFE, 0xFF, 0xFB,
  0x00, 0xFC, 0x06, 0x01, 0x06, 0xFF, 0x07, 0x00
 },
 {
  0xFF, 0x00, 0xF6, 0x08, 0x08, 0xE5, 0x00, 0xFE,
  0x1D, 0x10, 0xFE, 0xFC, 0x09, 0xFF, 0x02, 0x00,
  0x06, 0x0A, 0x06, 0x04, 0x02, 0xF9, 0x09, 0xEE,
  0x03, 0x03, 0x03, 0xF6, 0x11, 0x0A, 0x09, 0xFA
 },
 {
  0xFD, 0xF4, 0xFA, 0x0B, 0x14, 0xE0, 0x05, 0x15,
  0x03, 0xFC, 0xF7, 0x02, 0xF6, 0x01, 0x07, 0xFC,
  0x05, 0x00, 0x00, 0xFF, 0xF8, 0xF7, 0xF9, 0x04,
  0xF6, 0x05, 0x00, 0x02, 0xFB, 0x04, 0x09, 0x01
 },
 {
  0xFB, 0xFF, 0xFB, 0x01, 0x02, 0xED, 0xF3, 0x01,
  0x06, 0x0C, 0x02, 0xF0, 0xEF, 0x0B, 0x0A, 0x0D,
  0x10, 0xF4, 0xF5, 0x03, 0xFA, 0x00, 0x06, 0x04,
  0xFD, 0x01, 0x08, 0x02, 0x05, 0xF5, 0x03, 0xF2
 },
 {
  0xED, 0x05, 0x0A, 0x0B, 0x02, 0xE9, 0xF7, 0x10,
  0xFE, 0x07, 0x00, 0xF5, 0xF9, 0x0A, 0x06, 0xF9,
  0x1A, 0xF1, 0xFC, 0x08, 0x06, 0xFC, 0x07, 0xF7,
  0xF1, 0x01, 0x08, 0xFC, 0x04, 0x02, 0xF4, 0x10
 },
 {
  0xF5, 0x01, 0x0B, 0xFC, 0x01, 0xE1, 0xF3, 0xFF,
  0x08, 0x05, 0x04, 0xFE, 0x00, 0x0D, 0x07, 0xEF,
  0x07, 0xF6, 0xFA, 0x01, 0x04, 0xFF, 0x02, 0xF7,
  0xFC, 0x09, 0x03, 0x03, 0xFC, 0xFB, 0x03, 0x04
 },
 {
  0xFD, 0x01, 0x0A, 0xFF, 0x00, 0xF1, 0xEA, 0x04,
  0x28, 0xF5, 0xFC, 0xFD, 0xF2, 0x09, 0x0B, 0xFF,
  0x09, 0xFF, 0xFA, 0x06, 0x03, 0xFA, 0x00, 0x00,
  0xF4, 0x07, 0xFE, 0x00, 0x09, 0x03, 0x01, 0x03
 },
 {
  0xFF, 0xFF, 0xFF, 0x0E, 0x08, 0xE8, 0xF2, 0xF8,
  0x05, 0x08, 0x05, 0xF4, 0xEF, 0x08, 0x02, 0x07,
  0x0A, 0xF8, 0x00, 0x04, 0xFA, 0xFA, 0xF6, 0x08,
  0x04, 0xF4, 0x03, 0xF7, 0xF4, 0x05, 0x04, 0xFD
 },
 {
  0xFB, 0x01, 0xF5, 0x08, 0x09, 0xE8, 0x00, 0x02,
  0x02, 0x0E, 0xF4, 0xF3, 0x01, 0x06, 0x07, 0x00,
  0x07, 0xFA, 0x09, 0x1A, 0x0B, 0xF2, 0x08, 0x0A,
  0x01, 0x09, 0x00, 0x0B, 0xFE, 0x06, 0x02, 0xF6
 },
 {
  0xF3, 0x01, 0x04, 0x22, 0x13, 0xEF, 0xF1, 0x00,
  0x03, 0xFE, 0xF9, 0xFF, 0x00, 0xFD, 0xFD, 0xFF,
  0x01, 0xFF, 0xF6, 0x08, 0x05, 0x00, 0xF8, 0x04,
  0xEF, 0x09, 0xFE, 0x00, 0x00, 0x06, 0x02, 0xFD
 },
 {
  0xFA, 0xFC, 0x01, 0x02, 0x02, 0xF2, 0xE3, 0x00,
  0x09, 0x22, 0xFD, 0xFB, 0xF2, 0x06, 0xF6, 0xF7,
  0xFB, 0xFF, 0x00, 0x03, 0x03, 0x00, 0x01, 0xFF,
  0xFE, 0xFF, 0xFF, 0xFD, 0xFD, 0xFC, 0x03, 0xFD
 },
 {
  0xFC, 0x06, 0x03, 0x0E, 0x0E, 0xF8, 0xE3, 0x1F,
  0x0B, 0x0E, 0xFC, 0xFB, 0xFA, 0x0A, 0x06, 0xF7,
  0xFF, 0xF5, 0xF9, 0x01, 0x07, 0x04, 0x01, 0xFA,
  0x04, 0x00, 0x0A, 0xF9, 0xFB, 0xFF, 0x02, 0x04
 },
 {
  0xFC, 0xFC, 0xFE, 0x0E, 0x06, 0xE0, 0xFA, 0xF2,
  0x0E, 0xFB, 0xF5, 0x0A, 0xEE, 0xFC, 0x06, 0xF8,
  0x09, 0x05, 0xFC, 0x01, 0xFC, 0x05, 0xFE, 0xF7,
  0x03, 0x05, 0x02, 0xF6, 0xFA, 0xEF, 0x03, 0x11
 },
 {
  0xF0, 0x09, 0x15, 0x13, 0x04, 0xEC, 0xEF, 0x0E,
  0x09, 0x0F, 0xFA, 0xEF, 0xFF, 0x01, 0x06, 0xFD,
  0x01, 0x01, 0x08, 0xFD, 0xFA, 0x06, 0x09, 0x04,
  0x09, 0xF7, 0xFB, 0x01, 0xFF, 0x00, 0xFF, 0x02
 },
 {
  0xF9, 0xFB, 0x03, 0x13, 0x01, 0xEC, 0xF7, 0x0E,
  0x15, 0xF9, 0xEE, 0xF7, 0x1A, 0xF9, 0xEF, 0xF9,
  0x0C, 0x06, 0x00, 0xF7, 0xFA, 0x0E, 0x09, 0xF7,
  0xF8, 0x04, 0x0F, 0xF9, 0xF7, 0xFF, 0x09, 0x01
 },
 {
  0xEC, 0x1E, 0xFA, 0x0B, 0x18, 0xFC, 0x00, 0xFA,
  0xFE, 0x08, 0xFC, 0x0C, 0xF8, 0xEF, 0x00, 0x05,
  0xFC, 0x01, 0xFF, 0x03, 0xFD, 0x05, 0x03, 0x03,
  0x07, 0xFE, 0xFD, 0xFE, 0x04, 0x00, 0x00, 0xFF
 },
 {
  0xDD, 0x11, 0x06, 0x01, 0xF7, 0xFF, 0xF0, 0x03,
  0xEC, 0xF3, 0x08, 0x07, 0xFC, 0xF9, 0xFC, 0xEC,
  0x07, 0x0C, 0xFB, 0x05, 0xFB, 0xF5, 0x0C, 0xFF,
  0x0F, 0xF7, 0xFA, 0x10, 0xFC, 0xF7, 0xF3, 0x04
 },
 {
  0xEB, 0x24, 0xED, 0x09, 0x00, 0xF9, 0xF8, 0x09,
  0xFC, 0xFD, 0x03, 0x00, 0x07, 0xF8, 0xFE, 0xFE,
  0xF5, 0x0D, 0xFF, 0x05, 0xFD, 0x07, 0x02, 0x03,
  0xFF, 0xFE, 0xFB, 0x01, 0xFF, 0xFE, 0xFB, 0xFD
 },
 {
  0xF4, 0x21, 0xFC, 0x01, 0xF4, 0xF7, 0x00, 0xF3,
  0xFF, 0x02, 0xF8, 0x04, 0xF6, 0x06, 0xF0, 0xF9,
  0xFF, 0xFC, 0xF6, 0x0F, 0xFF, 0x00, 0xFB, 0xF8,
  0x05, 0x05, 0xFD, 0x00, 0x02, 0xF9, 0x01, 0xF9
 },
 {
  0xF2, 0x20, 0x05, 0xF9, 0xF1, 0x03, 0xFB, 0x08,
  0x0E, 0x05, 0x09, 0x0D, 0x03, 0x12, 0xFD, 0x07,
  0x04, 0xF6, 0xF6, 0x0A, 0xFF, 0x02, 0x00, 0xFE,
  0xF5, 0x05, 0xFD, 0xFC, 0x02, 0x02, 0x07, 0x04
 },
 {
  0xF2, 0x22, 0x01, 0x14, 0xFF, 0xF4, 0x00, 0xFD,
  0xF9, 0xFC, 0x07, 0x12, 0x09, 0xFD, 0x0E, 0xF9,
  0xF7, 0xEC, 0xF9, 0xFC, 0xF3, 0x0C, 0x01, 0x0C,
  0x05, 0xFA, 0x02, 0xFC, 0x00, 0xF1, 0x01, 0x03
 },
 {
  0xEB, 0x17, 0x07, 0xF8, 0x03, 0xF3, 0xFD, 0x00,
  0xFA, 0xFE, 0xF9, 0x06, 0xF4, 0x09, 0xFA, 0xFE,
  0xFE, 0xFC, 0xFF, 0x06, 0x09, 0x05, 0xF7, 0x0F,
  0x00, 0x08, 0xF8, 0x07, 0x06, 0xF1, 0x03, 0xFB
 },
 {
  0xE5, 0x20, 0xFF, 0xFC, 0xFE, 0x04, 0xF6, 0x0C,
  0xFD, 0x08, 0x0D, 0x07, 0x00, 0xF1, 0x04, 0xFE,
  0x03, 0x05, 0x07, 0xFC, 0x09, 0xF4, 0xFF, 0xFE,
  0xFF, 0xFC, 0x00, 0xFC, 0x02, 0xFB, 0x06, 0xFA
 },
 {
  0xEF, 0x1D, 0x0F, 0x00, 0xFF, 0xFC, 0xF6, 0x0D,
  0x0C, 0xFF, 0xF8, 0xF6, 0xF6, 0x04, 0x07, 0xFE,
  0x06, 0xFB, 0xF3, 0x13, 0x06, 0x01, 0xF9, 0x02,
  0xF7, 0xFE, 0x0C, 0xFC, 0xF8, 0xFD, 0x02, 0x04
 },
 {
  0xDA, 0x1B, 0x10, 0xF1, 0xFA, 0x03, 0xF9, 0xFC,
  0x00, 0xFF, 0x06, 0xFE, 0xFD, 0xFA, 0x06, 0xFA,
  0xFD, 0x00, 0x02, 0x00, 0xFC, 0x06, 0x01, 0xFF,
  0x00, 0x04, 0xFF, 0x03, 0x04, 0x01, 0xFE, 0x05
 },
 {
  0xDF, 0x28, 0xFC, 0x02, 0x01, 0x00, 0x00, 0xF6,
  0xF2, 0x00, 0xF9, 0x04, 0xFF, 0x03, 0xFE, 0x05,
  0x07, 0x06, 0xFF, 0x04, 0x01, 0x03, 0x01, 0xF9,
  0x01, 0xFC, 0x05, 0x07, 0x00, 0x04, 0x03, 0xFC
 },
 {
  0xEC, 0x19, 0x0C, 0xFC, 0x10, 0xFC, 0x02, 0x02,
  0xF2, 0xFE, 0xFD, 0x1D, 0xFF, 0x01, 0x03, 0x01,
  0x09, 0xFB, 0x02, 0xF8, 0xFD, 0x01, 0xF9, 0xFE,
  0xF9, 0x01, 0x00, 0x04, 0x10, 0xFE, 0xFF, 0xFF
 },
 {
  0xF6, 0x1E, 0x11, 0x03, 0xFB, 0xFE, 0x00, 0xFB,
  0xEA, 0x04, 0x05, 0x05, 0xFD, 0xEE, 0xFA, 0x0A,
  0xFB, 0xF9, 0x02, 0x08, 0x07, 0xF9, 0xF5, 0xFE,
  0x00, 0xFD, 0x03, 0x02, 0x0B, 0xFC, 0x04, 0xFC
 },
 {
  0xF5, 0x1E, 0x0B, 0x04, 0xFD, 0xF8, 0x01, 0xFE,
  0x04, 0x12, 0x03, 0x01, 0xFF, 0x00, 0xF8, 0xFC,
  0xFD, 0x0A, 0x0D, 0x0E, 0x05, 0xFB, 0x01, 0x01,
  0xF6, 0x02, 0x0F, 0x04, 0x09, 0xFF, 0xFB, 0xFD
 },
 {
  0xEF, 0x20, 0x12, 0xEE, 0xFD, 0xFB, 0x06, 0x0A,
  0x01, 0xF1, 0xFB, 0x09, 0x08, 0xF4, 0xF6, 0xFA,
  0x0B, 0x09, 0xFB, 0xF8, 0xF9, 0x0A, 0x05, 0xF6,
  0xF2, 0xFC, 0xFD, 0x01, 0x09, 0xF5, 0x02, 0x01
 },
 {
  0xF3, 0x1C, 0xF5, 0xFF, 0x02, 0xF0, 0xFE, 0x07,
  0xE8, 0x00, 0x03, 0x06, 0x03, 0xFF, 0xF8, 0xF9,
  0xF4, 0x02, 0x02, 0xEC, 0x0A, 0x04, 0x00, 0xF3,
  0xFE, 0xFE, 0x01, 0x08, 0xF2, 0x00, 0x04, 0x01
 },
 {
  0xF2, 0x17, 0x0C, 0x08, 0x08, 0xE6, 0x02, 0xFC,
  0xF2, 0x0D, 0xF2, 0x0F, 0x03, 0xF7, 0xFF, 0xF3,
  0xF6, 0xFE, 0xF6, 0x06, 0xF0, 0x0C, 0x08, 0x00,
  0x09, 0xF6, 0xF9, 0xFC, 0xFC, 0x07, 0xF8, 0x08
 },
 {
  0xEC, 0x2D, 0x0A, 0xF2, 0x04, 0x10, 0x08, 0xF7,
  0x01, 0xF8, 0x0A, 0x05, 0xF9, 0xFE, 0x02, 0xFB,
  0xFF, 0x00, 0xFB, 0x04, 0xFA, 0xFE, 0x04, 0x01,
  0x03, 0x04, 0xFC, 0x02, 0xFE, 0xFE, 0x05, 0x01
 },
 {
  0xEC, 0x1A, 0xFC, 0x01, 0x07, 0x04, 0xF8, 0x01,
  0xFB, 0xF3, 0x02, 0x0D, 0xF9, 0xFD, 0x06, 0xFA,
  0x16, 0x00, 0x05, 0x0B, 0xFC, 0xF5, 0x08, 0xF7,
  0x02, 0xFE, 0xFC, 0xFE, 0x02, 0xF3, 0xFC, 0xF8
 },
 {
  0xE4, 0x12, 0x11, 0x03, 0xF8, 0xE9, 0xF0, 0xFA,
  0x05, 0xF6, 0x0E, 0x0A, 0x05, 0xFF, 0xF8, 0x04,
  0xFE, 0x0D, 0xFD, 0xFE, 0x03, 0x04, 0x03, 0xFE,
  0xFD, 0xFC, 0x00, 0x01, 0x03, 0x04, 0x00, 0x04
 },
 {
  0xF4, 0x20, 0xFA, 0xF0, 0x12, 0x0C, 0xF0, 0x00,
  0x07, 0x0D, 0xFC, 0x05, 0xF8, 0xFF, 0xFD, 0x04,
  0x06, 0xFE, 0xFF, 0xF3, 0x04, 0xFF, 0x03, 0x0C,
  0xFD, 0xF6, 0x01, 0x06, 0x08, 0xF5, 0xFE, 0x04
 },
 {
  0xEE, 0x1A, 0x02, 0x05, 0x00, 0xF7, 0xEF, 0x0E,
  0x05, 0x01, 0x07, 0xFD, 0xF8, 0xFD, 0x0B, 0x07,
  0xFB, 0xF4, 0xF8, 0x07, 0x00, 0xF9, 0x02, 0xF4,
  0xF7, 0x0D, 0xF5, 0x09, 0x06, 0xF5, 0xFB, 0x0B
 },
 {
  0xE8, 0x16, 0xF1, 0xF7, 0x08, 0x01, 0xF9, 0xF4,
  0xF7, 0x03, 0x0B, 0x0F, 0x0E, 0xF5, 0x0C, 0xF1,
  0xFB, 0x07, 0xFE, 0x00, 0xF8, 0x03, 0x03, 0xFF,
  0x02, 0x0B, 0xF5, 0x0E, 0xFA, 0x0D, 0x01, 0xFA
 },
 {
  0xEC, 0x1C, 0x12, 0xFC, 0xFA, 0xFB, 0x0C, 0x0E,
  0x02, 0x0A, 0xF3, 0xFA, 0xF8, 0xFA, 0xF3, 0xFF,
  0xE6, 0x16, 0xFD, 0xF2, 0x06, 0x00, 0x0A, 0xF1,
  0xF3, 0xF7, 0x06, 0xF9, 0x01, 0xFB, 0xFC, 0xFF
 },
 {
  0xED, 0x1A, 0xF8, 0xFD, 0xF2, 0xFA, 0xF7, 0xFC,
  0xF8, 0x0F, 0xF8, 0x03, 0xF4, 0xFC, 0xFE, 0xF9,
  0xFB, 0x03, 0x0D, 0xFD, 0xFC, 0xE7, 0x04, 0xFF,
  0x05, 0xF4, 0xFF, 0xF3, 0x05, 0x02, 0x00, 0x06
 },
 {
  0xEE, 0x2B, 0x0E, 0xF8, 0x01, 0xE9, 0xFE, 0xFE,
  0x01, 0x03, 0xF9, 0x00, 0x00, 0x08, 0xFF, 0xFD,
  0xFB, 0x01, 0x05, 0x02, 0x00, 0xFE, 0xFE, 0xFE,
  0x01, 0xFF, 0xFF, 0xF9, 0x00, 0x03, 0xFD, 0x09
 },
 {
  0xF5, 0x1E, 0x0A, 0xF2, 0x03, 0x01, 0x0A, 0xF5,
  0x01, 0xF9, 0xFC, 0x0E, 0x02, 0x01, 0xF7, 0x01,
  0xF5, 0xFE, 0xF9, 0x05, 0xF5, 0x01, 0x03, 0x0E,
  0x01, 0xF0, 0xF8, 0x03, 0xFB, 0x07, 0xFC, 0x04
 },
 {
  0xEE, 0x18, 0x06, 0x03, 0x08, 0x07, 0xEA, 0xF9,
  0xF9, 0x03, 0xF8, 0x04, 0x17, 0x09, 0x03, 0xFF,
  0x03, 0x06, 0x07, 0xFF, 0xF9, 0x06, 0x04, 0x01,
  0xFD, 0x01, 0xFA, 0xFF, 0x02, 0xF9, 0x03, 0x03
 },
 {
  0xF1, 0x26, 0xF9, 0xFF, 0xF5, 0x02, 0xEF, 0xE8,
  0x18, 0x08, 0x07, 0xFC, 0xFB, 0x02, 0x02, 0xF9,
  0x01, 0x04, 0x00, 0xF7, 0x05, 0x00, 0xFF, 0x01,
  0xFF, 0xFB, 0xFA, 0x03, 0x00, 0x07, 0x08, 0xFD
 },
 {
  0xF2, 0x16, 0x01, 0xFB, 0x09, 0xF4, 0xF7, 0xFB,
  0xFA, 0x05, 0x07, 0x08, 0xFF, 0xFC, 0xF7, 0xFD,
  0xDF, 0xF0, 0xF7, 0xFF, 0x0C, 0xF5, 0x11, 0xF9,
  0xFD, 0xFF, 0xF9, 0x03, 0x02, 0xFD, 0x10, 0xFC
 },
 {
  0xF2, 0x14, 0x06, 0x04, 0xF6, 0xFC, 0xFC, 0xFC,
  0x01, 0xF9, 0x02, 0x06, 0x08, 0xF4, 0x04, 0x01,
  0xFF, 0x0C, 0x0A, 0x03, 0xF2, 0xF6, 0xFD, 0x12,
  0xFE, 0x21, 0xFB, 0xEF, 0x11, 0xFB, 0x09, 0x07
 },
 {
  0xF4, 0x17, 0x0D, 0x00, 0xF5, 0xF8, 0xF5, 0x0C,
  0xFB, 0xF7, 0xF0, 0x0B, 0x06, 0x04, 0x0C, 0xFB,
  0x05, 0xF3, 0x07, 0xF4, 0xFD, 0x01, 0x02, 0x0C,
  0x01, 0xFC, 0xFF, 0x05, 0x04, 0x0B, 0xF4, 0xFD
 },
 {
  0x0F, 0x02, 0x0E, 0x07, 0x01, 0x02, 0x01, 0x0C,
  0x0A, 0x17, 0x04, 0x06, 0xEC, 0xF6, 0x04, 0x1A,
  0xFA, 0x0D, 0x04, 0x03, 0x02, 0xF5, 0x05, 0xF9,
  0xF6, 0x04, 0x09, 0x01, 0x0A, 0xFC, 0x0B, 0x04
 },
 {
  0x11, 0x0F, 0x1F, 0x11, 0x12, 0x10, 0x0B, 0x18,
  0x02, 0x04, 0x02, 0x03, 0xF8, 0xFD, 0x07, 0xFD,
  0xFB, 0xF9, 0xFE, 0xFA, 0xFC, 0xFB, 0xFC, 0xFF,
  0xFC, 0xFE, 0xFB, 0xFA, 0x02, 0xFF, 0x04, 0xFE
 },
 {
  0x10, 0x08, 0x0F, 0x0E, 0x03, 0x07, 0x15, 0x09,
  0x08, 0x0F, 0x15, 0x06, 0x08, 0x0C, 0x05, 0xFB,
  0x07, 0xFD, 0x0A, 0x02, 0xFD, 0x08, 0x06, 0x00,
  0x05, 0x05, 0x06, 0xFD, 0x02, 0x04, 0x00, 0xFB
 },
 {
  0x05, 0xFC, 0x06, 0x0C, 0x06, 0x0D, 0x18, 0x11,
  0xFB, 0x11, 0xFF, 0xFA, 0xF9, 0xF6, 0xF8, 0xEE,
  0x03, 0xFE, 0x02, 0x07, 0xF1, 0xF5, 0x0C, 0xFD,
  0xFE, 0xFE, 0xFC, 0xF9, 0x02, 0x00, 0x05, 0x05
 },
 {
  0x0A, 0xFA, 0x08, 0x0B, 0x0C, 0x14, 0x16, 0xF5,
  0xFD, 0x0F, 0xFD, 0x0F, 0xFE, 0xFE, 0x00, 0x02,
  0x05, 0xF8, 0x04, 0xFB, 0xF7, 0xFC, 0xFF, 0x02,
  0xFF, 0xFD, 0x01, 0x03, 0x0D, 0xFF, 0x09, 0x07
 },
 {
  0xFB, 0x08, 0x05, 0x0B, 0x0E, 0xFB, 0x0E, 0xF7,
  0x02, 0x23, 0x08, 0x0F, 0x01, 0xFE, 0x02, 0xFE,
  0x04, 0xF7, 0xFD, 0xF2, 0xF4, 0xFE, 0xFE, 0xFC,
  0xFE, 0xF8, 0xFD, 0x01, 0xFA, 0x03, 0x0A, 0x00
 },
 {
  0x10, 0x00, 0xFA, 0x0F, 0xFD, 0x04, 0x04, 0x03,
  0x03, 0x14, 0x05, 0xFC, 0x0A, 0x09, 0xF7, 0xFD,
  0xF6, 0xFE, 0xF9, 0x0B, 0xF5, 0xF6, 0x11, 0xFF,
  0x03, 0xF1, 0x02, 0x09, 0xF1, 0xF6, 0x10, 0x0A
 },
 {
  0x0E, 0x04, 0xF9, 0x13, 0x03, 0x00, 0x13, 0x08,
  0x10, 0x22, 0xF7, 0x06, 0xF3, 0xFF, 0x06, 0x05,
  0xFF, 0xFE, 0x04, 0x03, 0x02, 0x01, 0x01, 0xFF,
  0x00, 0xF9, 0x02, 0xFF, 0x01, 0x00, 0x06, 0xFF
 },
 {
  0x01, 0x06, 0x09, 0x0D, 0x09, 0x0A, 0x0F, 0x10,
  0x0A, 0x12, 0x0D, 0x11, 0x03, 0xFF, 0xF9, 0x02,
  0xF1, 0xF5, 0xF6, 0xFC, 0xF3, 0xFA, 0xEF, 0xF3,
  0xFA, 0xF2, 0x01, 0xF6, 0x06, 0x04, 0xFF, 0xFF
 },
 {
  0x0D, 0x01, 0x07, 0x0A, 0x0E, 0x0D, 0xF9, 0x05,
  0x05, 0x1C, 0x0E, 0x0E, 0xFE, 0x02, 0x03, 0xFD,
  0xF3, 0xFC, 0x0A, 0xF7, 0x13, 0xFC, 0xFD, 0x04,
  0xFB, 0xFB, 0x00, 0x05, 0xFB, 0x00, 0x03, 0xFC
 },
 {
  0x01, 0x00, 0x06, 0x16, 0x09, 0x12, 0x12, 0xFD,
  0x05, 0x0A, 0x0C, 0xFE, 0x01, 0xFD, 0xF8, 0xF4,
  0x09, 0xF6, 0xF9, 0x01, 0xFF, 0x13, 0x00, 0x02,
  0xF8, 0xF5, 0xF6, 0x09, 0x06, 0x0B, 0x00, 0x03
 },
 {
  0x0A, 0x0B, 0x13, 0x2C, 0x00, 0x0E, 0x01, 0xF9,
  0x06, 0x16, 0x02, 0xFF, 0x09, 0x02, 0x00, 0xFC,
  0x04, 0x00, 0xFA, 0xFA, 0x03, 0x00, 0x00, 0xFE,
  0x02, 0xFB, 0x01, 0xFE, 0x00, 0x01, 0x01, 0x01
 },
 {
  0x05, 0x07, 0x00, 0x20, 0x1E, 0x1A, 0x05, 0x04,
  0xF9, 0xFD, 0x0F, 0xFA, 0x03, 0xF6, 0x07, 0x06,
  0xF8, 0xF9, 0x02, 0xF3, 0xFB, 0xFF, 0xFD, 0x07,
  0x03, 0xFE, 0xF8, 0x00, 0x06, 0x04, 0x05, 0x00
 },
 {
  0x09, 0x08, 0xFE, 0x04, 0x02, 0x0B, 0x04, 0x1D,
  0xFB, 0x0E, 0x08, 0xFB, 0xF2, 0x08, 0x00, 0x09,
  0x08, 0xF6, 0x05, 0xF1, 0xFA, 0xF7, 0x09, 0xFF,
  0x12, 0xF0, 0x09, 0xEB, 0xFD, 0xF3, 0xFE, 0x08
 },
 {
  0x19, 0x07, 0xF7, 0x17, 0x14, 0x12, 0x06, 0x10,
  0xF7, 0x08, 0x08, 0xFB, 0x0B, 0x0D, 0xF8, 0x07,
  0x04, 0x0A, 0xFE, 0xFF, 0xF9, 0xF7, 0xF9, 0xF7,
  0xFC, 0x01, 0x01, 0xFB, 0xF6, 0x08, 0x04, 0xFB
 },
 {
  0x09, 0x02, 0x10, 0x0E, 0xFB, 0x0E, 0x01, 0x00,
  0xEB, 0x11, 0xFF, 0x09, 0x0C, 0xFD, 0xFD, 0x04,
  0xFC, 0x0E, 0x0A, 0x03, 0x00, 0xF6, 0x07, 0x04,
  0x04, 0xF5, 0x02, 0x04, 0xFF, 0xFD, 0x09, 0xFF
 },
 {
  0x11, 0x08, 0x0B, 0x1A, 0x0F, 0xFD, 0x0E, 0xFF,
  0x0C, 0x09, 0x0A, 0xF8, 0x08, 0xEE, 0xF5, 0xFD,
  0xF2, 0xF9, 0x07, 0xFD, 0xFD, 0xFC, 0x01, 0xF9,
  0xFD, 0x02, 0xFD, 0x10, 0x0A, 0x00, 0x09, 0x06
 },
 {
  0x09, 0x08, 0x03, 0x08, 0x12, 0x0E, 0x0B, 0x01,
  0x0A, 0x06, 0x01, 0xFC, 0xF0, 0xFE, 0x0E, 0xFE,
  0x01, 0x08, 0x0C, 0x0E, 0x03, 0xFD, 0x08, 0x08,
  0x0C, 0xF1, 0x03, 0xFD, 0x03, 0xFE, 0x0E, 0x0A
 },
 {
  0x16, 0xFD, 0xF5, 0x0D, 0xF9, 0x0B, 0x04, 0x0B,
  0x03, 0x0E, 0x00, 0xFA, 0xFE, 0xF7, 0x04, 0x02,
  0xFE, 0x00, 0xFB, 0xE5, 0xF6, 0x03, 0xFF, 0x05,
  0x08, 0xE8, 0xFD, 0xF5, 0xFD, 0x02, 0x0B, 0xFF
 },
 {
  0x13, 0x02, 0x08, 0x24, 0x05, 0xFA, 0x03, 0x0F,
  0xFD, 0xFC, 0xFB, 0x0E, 0xF6, 0x01, 0xF4, 0xF6,
  0xFD, 0xFC, 0x03, 0xFE, 0x01, 0xF8, 0x04, 0x03,
  0x05, 0xFD, 0x00, 0x04, 0x08, 0xFE, 0x08, 0x04
 },
 {
  0x08, 0x0E, 0x0F, 0x09, 0xFC, 0x0A, 0x05, 0x0B,
  0x09, 0x0A, 0x08, 0x09, 0xF1, 0x0F, 0x06, 0xF8,
  0xF6, 0xF3, 0x05, 0xF8, 0xEC, 0xF3, 0xFA, 0xF5,
  0xFF, 0xFD, 0xFA, 0xFC, 0xFF, 0x00, 0x0D, 0x0F
 },
 {
  0xFE, 0xFF, 0x09, 0x0C, 0x02, 0x02, 0x0D, 0x03,
  0xE9, 0x21, 0x0F, 0x02, 0xFC, 0xFF, 0x03, 0x08,
  0x08, 0x06, 0x06, 0xF9, 0x08, 0x06, 0x09, 0xFF,
  0x03, 0xF8, 0x00, 0xFC, 0x01, 0xF8, 0x0B, 0xFF
 },
 {
  0x06, 0x05, 0xFA, 0x10, 0x02, 0xFD, 0x1F, 0x15,
  0xF7, 0x0C, 0x00, 0xFF, 0xFC, 0x01, 0xF4, 0x03,
  0xF3, 0xEE, 0x02, 0xF5, 0xF7, 0x02, 0xF8, 0xFA,
  0x0B, 0xFD, 0xFF, 0x00, 0xFF, 0x00, 0x0D, 0x05
 },
 {
  0x05, 0xFF, 0x02, 0x00, 0x19, 0x05, 0x0A, 0x10,
  0xFB, 0x15, 0x0E, 0x0C, 0x0D, 0x02, 0xFB, 0x05,
  0x05, 0xFD, 0xFE, 0xF2, 0x00, 0xF4, 0x07, 0x0B,
  0xFF, 0xF9, 0x13, 0xFF, 0xFF, 0xFF, 0x08, 0xFF
 },
 {
  0x0A, 0x07, 0x03, 0x0B, 0x00, 0x08, 0x16, 0x03,
  0x03, 0x13, 0xFC, 0x0C, 0x0F, 0x09, 0x05, 0x0F,
  0x02, 0x01, 0x02, 0xF6, 0xF6, 0x00, 0x02, 0xFF,
  0x00, 0x01, 0xF4, 0xFF, 0x15, 0x10, 0x09, 0xF9
 },
 {
  0x0B, 0xFC, 0xFB, 0x18, 0xF9, 0x0B, 0x14, 0x0B,
  0xF1, 0x12, 0x05, 0xF3, 0xF1, 0x00, 0xFB, 0x09,
  0x01, 0x00, 0xFF, 0xF7, 0x04, 0xF8, 0x06, 0xF8,
  0x01, 0xFE, 0xF9, 0x14, 0x09, 0x03, 0x09, 0x03
 },
 {
  0x14, 0x00, 0xF4, 0xFA, 0x09, 0x1F, 0x09, 0x0C,
  0x08, 0x1B, 0x0F, 0x07, 0xF0, 0x05, 0xFD, 0xF9,
  0xFF, 0xF7, 0xFE, 0xF9, 0xFD, 0x04, 0xF8, 0xFD,
  0x03, 0xFA, 0xFE, 0xFE, 0xFD, 0xFA, 0xFF, 0x02
 },
 {
  0x06, 0xFA, 0x30, 0x08, 0xFD, 0x13, 0x0C, 0x0B,
  0xF9, 0x02, 0x03, 0x00, 0xFF, 0x01, 0x08, 0xFC,
  0x04, 0xFA, 0x00, 0xFC, 0xFC, 0xFD, 0x03, 0x06,
  0x03, 0xF3, 0xF8, 0x05, 0xFD, 0xF9, 0x08, 0x05
 },
 {
  0x07, 0xFE, 0x06, 0x0B, 0x0C, 0x02, 0x0E, 0x04,
  0xFB, 0x0C, 0x02, 0x09, 0x04, 0x02, 0x00, 0xFF,
  0x02, 0x00, 0xF1, 0xF7, 0xF0, 0xFE, 0x08, 0xEF,
  0xFB, 0xEA, 0xED, 0xFB, 0xFF, 0xF6, 0x01, 0xFE
 },
 {
  0x0B, 0xF7, 0x03, 0x0C, 0x06, 0x06, 0x01, 0x11,
  0xFA, 0x13, 0x0E, 0x07, 0xF9, 0xFF, 0xFF, 0xF7,
  0x09, 0xF5, 0xEF, 0x00, 0xFA, 0x10, 0x00, 0x01,
  0x09, 0xE8, 0x03, 0x03, 0xF7, 0xFD, 0x03, 0xFE
 },
 {
  0x09, 0x00, 0x01, 0x08, 0x01, 0x07, 0x02, 0xFB,
  0xFD, 0x08, 0xFF, 0x07, 0x02, 0x06, 0xFD, 0xFA,
  0x05, 0xFE, 0x06, 0xFE, 0xFC, 0xFD, 0x00, 0xFD,
  0x0D, 0xCE, 0x01, 0xFE, 0x02, 0x04, 0x04, 0x03
 },
 {
  0x07, 0x00, 0x1A, 0x15, 0xFC, 0x02, 0x11, 0x08,
  0x07, 0x0B, 0xF9, 0x01, 0xFF, 0xF1, 0xFF, 0xF1,
  0xF5, 0xFC, 0xEF, 0xFC, 0x01, 0xF9, 0x03, 0x06,
  0x03, 0xF7, 0x02, 0x03, 0x06, 0x0A, 0x06, 0x0C
 },
 {
  0x01, 0xFE, 0x02, 0xFF, 0xF6, 0xFC, 0x06, 0xFD,
  0xFB, 0xFE, 0xF8, 0x02, 0x02, 0x02, 0x08, 0x00,
  0x01, 0x01, 0x06, 0x00, 0x0B, 0x0D, 0x03, 0x04,
  0x00, 0xF4, 0x0B, 0xFB, 0x13, 0x14, 0x02, 0x05
 },
 {
  0x05, 0x03, 0xF3, 0xFE, 0x01, 0xF4, 0x0B, 0xF9,
  0xF4, 0x07, 0x0A, 0x00, 0x07, 0x00, 0xFE, 0x04,
  0xFA, 0xF7, 0xF5, 0xF4, 0xE9, 0x0C, 0x0A, 0xFD,
  0x00, 0x06, 0x13, 0xFF, 0x18, 0x12, 0x09, 0x0C
 },
 {
  0x06, 0xFD, 0x02, 0x05, 0x02, 0x02, 0xFE, 0xFB,
  0xF8, 0xF5, 0xFC, 0x03, 0xF8, 0xFC, 0x05, 0xFD,
  0xF0, 0xFC, 0x03, 0xF4, 0xFC, 0x03, 0x20, 0x07,
  0x02, 0x08, 0x20, 0xEE, 0xFF, 0x0C, 0x01, 0x07
 },
 {
  0x00, 0xF8, 0xFF, 0x00, 0xF8, 0x07, 0xF8, 0xFF,
  0xFF, 0x04, 0xF4, 0xFF, 0x03, 0x00, 0x01, 0xEE,
  0x08, 0x08, 0xF2, 0xF6, 0xF5, 0x13, 0x09, 0x05,
  0xF9, 0x06, 0x08, 0xFC, 0x1A, 0x0C, 0xFF, 0x06
 },
 {
  0x03, 0x05, 0xF2, 0x07, 0x0E, 0x08, 0x14, 0xF3,
  0xF0, 0xF6, 0xFE, 0x11, 0xF9, 0x04, 0xF8, 0xF7,
  0x0E, 0xFB, 0x03, 0xFC, 0xF4, 0x07, 0x0E, 0xF6,
  0xED, 0xEC, 0x23, 0x08, 0x0D, 0x0E, 0xFE, 0x09
 },
 {
  0xFE, 0xFC, 0xFF, 0x01, 0xFD, 0x00, 0xFF, 0x01,
  0x02, 0x02, 0x06, 0x00, 0x00, 0x04, 0x05, 0xFE,
  0x03, 0x03, 0x03, 0xFE, 0xF9, 0xFD, 0xFD, 0xFF,
  0x06, 0xFE, 0x1D, 0x16, 0x0D, 0x22, 0x00, 0x0E
 },
 {
  0xFD, 0xF7, 0x03, 0x01, 0x05, 0xFC, 0x02, 0x00,
  0x07, 0xF7, 0x00, 0x02, 0xFB, 0xFD, 0x00, 0x06,
  0xFF, 0xFF, 0xFF, 0x02, 0x02, 0x04, 0x08, 0x07,
  0x14, 0xFA, 0x07, 0x10, 0x21, 0x14, 0x06, 0xFF
 },
 {
  0xF5, 0x01, 0xFD, 0xFD, 0xF5, 0x03, 0xF7, 0xE7,
  0xFF, 0xF0, 0x04, 0xF8, 0x0F, 0x01, 0xFE, 0x07,
  0x08, 0x17, 0x02, 0x12, 0xF3, 0x10, 0x03, 0xF9,
  0x06, 0x03, 0x10, 0xF8, 0x0C, 0x10, 0x03, 0x04
 },
 {
  0x00, 0x05, 0x05, 0xFB, 0x01, 0xFF, 0x02, 0xFD,
  0xFE, 0x01, 0xF3, 0x02, 0x02, 0x0A, 0x06, 0x07,
  0x12, 0x12, 0x07, 0x09, 0x08, 0x09, 0x15, 0x0E,
  0x07, 0x0C, 0x0F, 0x0E, 0x0F, 0x0C, 0x0B, 0x05
 },
 {
  0x01, 0xFB, 0x0B, 0xFE, 0x11, 0x08, 0x03, 0x00,
  0xFF, 0x06, 0x0B, 0xF9, 0x06, 0x06, 0x07, 0x05,
  0xF1, 0x0E, 0x01, 0x0B, 0x04, 0x0A, 0x0C, 0x01,
  0x02, 0x04, 0x1E, 0x01, 0x0B, 0x01, 0x06, 0x0D
 },
 {
  0x02, 0x04, 0x03, 0xF9, 0x05, 0x08, 0xF5, 0x07,
  0xFB, 0x09, 0xF6, 0x06, 0x08, 0xF6, 0xFD, 0x0A,
  0x01, 0xE3, 0xFC, 0xE6, 0x05, 0xF8, 0x0D, 0x04,
  0x03, 0x06, 0x23, 0x01, 0x03, 0x06, 0x03, 0x00
 },
 {
  0xFE, 0x01, 0x00, 0x00, 0xFF, 0xFD, 0xF9, 0xFD,
  0xF7, 0xFD, 0xFF, 0xFA, 0x03, 0x04, 0x04, 0x00,
  0x05, 0xFF, 0xFE, 0xFE, 0xFF, 0xFC, 0xF6, 0x08,
  0x00, 0xFA, 0x0A, 0xFC, 0x2E, 0x0C, 0x02, 0x1C
 },
 {
  0x04, 0xFF, 0x04, 0x01, 0x00, 0x04, 0xFE, 0xFE,
  0xFE, 0xFF, 0x02, 0xFC, 0x01, 0x05, 0x00, 0xFD,
  0x01, 0x01, 0xFE, 0x00, 0x01, 0xFE, 0xFF, 0xFF,
  0x03, 0xFA, 0x23, 0xF5, 0x0D, 0x35, 0xFD, 0xFF
 },
 {
  0xFB, 0xFE, 0x00, 0xF3, 0xF0, 0x05, 0xF4, 0xF5,
  0x01, 0xE2, 0x03, 0xEE, 0xE8, 0xF8, 0xFB, 0xED,
  0x01, 0xFD, 0xF8, 0x07, 0xF9, 0xF8, 0x0F, 0xED,
  0x04, 0x0A, 0x1E, 0x18, 0x06, 0x01, 0xF7, 0x0A
 },
 {
  0xFC, 0x08, 0xF9, 0xFC, 0xFA, 0x0C, 0xFF, 0xF7,
  0xFC, 0x02, 0xF7, 0x03, 0x02, 0xFE, 0x04, 0x02,
  0x16, 0x09, 0x04, 0xFB, 0x00, 0x05, 0xFE, 0xF7,
  0xFD, 0x01, 0x12, 0xF4, 0x12, 0x10, 0x04, 0x10
 },
 {
  0xFB, 0xF8, 0xFD, 0xFB, 0xFD, 0x06, 0xF9, 0xFD,
  0xFE, 0xFB, 0xFD, 0x01, 0x02, 0x02, 0x04, 0xFA,
  0x0A, 0x03, 0x0C, 0xFD, 0x14, 0x00, 0x1B, 0xFC,
  0x10, 0x05, 0x12, 0xFD, 0x17, 0x04, 0x0C, 0x0B
 },
 {
  0x00, 0x01, 0x00, 0x01, 0xFE, 0x01, 0x02, 0x01,
  0xFF, 0x00, 0xFE, 0x02, 0xFE, 0xFC, 0x01, 0xFE,
  0xFE, 0xFF, 0xFB, 0xFE, 0x00, 0x00, 0xFE, 0x02,
  0x09, 0x07, 0x3F, 0x05, 0x0C, 0xFF, 0x01, 0x00
 },
 {
  0x04, 0xFD, 0xF9, 0xFB, 0xF5, 0xFB, 0xF4, 0xF6,
  0xF6, 0xF4, 0xF1, 0xF4, 0xF2, 0xF2, 0x01, 0x01,
  0x0A, 0xF6, 0x10, 0x06, 0x02, 0x09, 0x0B, 0x09,
  0x09, 0x08, 0x0C, 0xFF, 0x0D, 0x0C, 0x06, 0x03
 },
 {
  0x07, 0xFD, 0xFE, 0x04, 0x06, 0xF8, 0x02, 0xFD,
  0xF4, 0xFB, 0xF7, 0xF8, 0xF6, 0x0F, 0xFE, 0xFC,
  0x08, 0x09, 0x07, 0xF3, 0xEE, 0x22, 0xFB, 0x07,
  0x0C, 0x16, 0x10, 0xF5, 0x0D, 0x19, 0xF1, 0xF5
 },
 {
  0xFD, 0xFE, 0x00, 0xFC, 0x01, 0x00, 0xFD, 0xF3,
  0xF9, 0x0D, 0x0C, 0xF9, 0xF6, 0x0D, 0x13, 0x06,
  0x10, 0x0F, 0xF4, 0xF1, 0xFD, 0x22, 0x01, 0x05,
  0x01, 0xF7, 0x0B, 0x15, 0x08, 0x11, 0xFB, 0xFA
 },
 {
  0x03, 0xFB, 0x00, 0xFC, 0x00, 0x04, 0xF5, 0x04,
  0xF9, 0xFD, 0xFF, 0xF8, 0x03, 0xFE, 0x02, 0x01,
  0x0B, 0x05, 0x06, 0x0E, 0xFD, 0x02, 0xFC, 0xF9,
  0x00, 0x1F, 0x0F, 0xFE, 0x18, 0x0B, 0x05, 0x04
 },
 {
  0xFF, 0xFC, 0xF7, 0x05, 0xF8, 0xEE, 0xFC, 0xF7,
  0xEC, 0xEE, 0x07, 0xF2, 0xF0, 0x03, 0x08, 0xFD,
  0x1D, 0x0B, 0xF3, 0xF3, 0x07, 0x01, 0x11, 0x06,
  0x06, 0x15, 0x0B, 0x01, 0x0E, 0xF8, 0x02, 0x05
 },
 {
  0xFD, 0x08, 0xF6, 0xFA, 0x0C, 0x02, 0x01, 0x03,
  0x03, 0x03, 0x03, 0xFA, 0xF8, 0xF2, 0x0F, 0xFB,
  0x10, 0x04, 0x10, 0x00, 0x07, 0xFF, 0x00, 0x10,
  0x02, 0x01, 0x16, 0x04, 0x13, 0x0D, 0xF5, 0x01
 },
 {
  0x02, 0xFD, 0x0A, 0x14, 0xFC, 0xFF, 0xF8, 0x05,
  0xF8, 0xF7, 0xFA, 0xFE, 0xFC, 0xF9, 0x08, 0xF6,
  0x00, 0x08, 0xFA, 0x01, 0xF8, 0x0E, 0x0D, 0x05,
  0x11, 0xFA, 0x1A, 0xFF, 0x07, 0xFF, 0x00, 0x0C
 },
 {
  0xFC, 0xF9, 0xE1, 0xFE, 0xF9, 0xFF, 0x05, 0xFB,
  0xFB, 0xF4, 0x04, 0xF9, 0xFA, 0x03, 0x0F, 0xFE,
  0x05, 0xFE, 0x07, 0xFF, 0x0A, 0x07, 0x08, 0xFF,
  0x0E, 0x14, 0x0E, 0x09, 0x10, 0x10, 0x08, 0x18
 },
 {
  0xF9, 0x00, 0xFD, 0xFA, 0x01, 0x03, 0xF3, 0xFA,
  0xFC, 0xFC, 0xFB, 0xF7, 0xFF, 0xF6, 0xFC, 0xF8,
  0x02, 0x00, 0xFF, 0x01, 0x18, 0x18, 0x15, 0x1F,
  0x05, 0x02, 0x0B, 0x0C, 0x07, 0x04, 0x03, 0x06
 },
 {
  0xFD, 0xFB, 0x06, 0xFC, 0xFD, 0xFF, 0x02, 0xFF,
  0xFE, 0x01, 0x00, 0xF8, 0xFF, 0x02, 0x00, 0xFC,
  0x06, 0x16, 0xFF, 0xFB, 0x08, 0x0C, 0xFF, 0xFE,
  0x1C, 0x1B, 0x14, 0xE5, 0x0E, 0x01, 0x02, 0xFD
 },
 {
  0x01, 0xFB, 0xFE, 0xFE, 0x06, 0xFE, 0x09, 0x01,
  0xFE, 0xFB, 0x03, 0x04, 0x0B, 0x05, 0x02, 0x08,
  0xFD, 0xFF, 0x01, 0xFE, 0xFD, 0xFB, 0x05, 0x08,
  0x31, 0x0C, 0x08, 0xFD, 0x09, 0x14, 0x0C, 0x11
 },
 {
  0xFA, 0x00, 0x01, 0x07, 0x00, 0x09, 0xFE, 0xFC,
  0x08, 0x00, 0xFE, 0xF6, 0x00, 0x07, 0x15, 0xFF,
  0x00, 0x01, 0x11, 0xF9, 0xFB, 0x02, 0x04, 0x10,
  0xFE, 0x11, 0x0E, 0xEC, 0x0F, 0x0E, 0x04, 0x0F
 },
 {
  0x00, 0x03, 0xFC, 0x09, 0xFC, 0x00, 0x06, 0x04,
  0xFA, 0xFA, 0xFB, 0xF9, 0x02, 0xF7, 0xF6, 0xFE,
  0xFB, 0x00, 0xFD, 0xEB, 0x09, 0x0E, 0xF5, 0x0D,
  0x1D, 0x02, 0x19, 0x04, 0x16, 0xFF, 0x02, 0xFD
 },
 {
  0x02, 0x0C, 0xF5, 0x02, 0x10, 0x09, 0xFC, 0x07,
  0x01, 0xF6, 0xF1, 0x0B, 0xFC, 0x03, 0xFE, 0x04,
  0x04, 0xFB, 0xF6, 0x01, 0x04, 0x13, 0xF1, 0x06,
  0xFC, 0xFE, 0x1E, 0xF9, 0x0B, 0x15, 0xF4, 0x05
 },
 {
  0xFE, 0xFD, 0xFE, 0x04, 0xFF, 0xFB, 0xFD, 0xF9,
  0xFB, 0x01, 0x00, 0xFA, 0x01, 0xFA, 0x07, 0x00,
  0x08, 0xF9, 0xFD, 0xFE, 0x02, 0x0E, 0x02, 0xFD,
  0xE6, 0xFF, 0x1A, 0x16, 0x20, 0x01, 0xFE, 0x06
 },
 {
  0x01, 0xDA, 0xFF, 0xEC, 0xFE, 0xFD, 0xFA, 0xFC,
  0x02, 0x02, 0x07, 0x00, 0x03, 0x05, 0x03, 0x0A,
  0x06, 0x01, 0xFD, 0xFB, 0x07, 0x05, 0xFB, 0xFC,
  0x08, 0x03, 0x01, 0xF2, 0xFF, 0xF7, 0xFB, 0xFC
 },
 {
  0xFB, 0xE6, 0xF9, 0xED, 0xF6, 0xFB, 0xF5, 0x05,
  0xF5, 0xE7, 0xF8, 0xF2, 0xF7, 0xF0, 0xF8, 0xFA,
  0xEF, 0xF2, 0xFF, 0xFF, 0x06, 0x02, 0x02, 0x02,
  0x03, 0x00, 0x02, 0x08, 0xF8, 0x03, 0x00, 0xFD
 },
 {
  0x11, 0xCF, 0xFD, 0xE9, 0xFF, 0x0B, 0x07, 0x03,
  0x04, 0xFC, 0x00, 0x00, 0xFF, 0x04, 0x02, 0x04,
  0xFE, 0xFC, 0x02, 0xFE, 0xFF, 0xFE, 0x02, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00
 },
 {
  0x04, 0xDE, 0xFA, 0xF7, 0x01, 0x15, 0xF9, 0x03,
  0xFE, 0xFF, 0xFD, 0x12, 0x02, 0xF0, 0x07, 0xFD,
  0x08, 0x07, 0xFB, 0x07, 0x02, 0x04, 0x08, 0xFA,
  0xF9, 0xFE, 0xFB, 0xFF, 0x04, 0x01, 0x02, 0xFC
 },
 {
  0x05, 0xE3, 0x0D, 0xFE, 0xF2, 0x03, 0x01, 0x12,
  0xF1, 0x04, 0xF8, 0x08, 0xF6, 0x08, 0x02, 0x01,
  0xF8, 0x0F, 0x03, 0xF6, 0xFC, 0xFC, 0xFE, 0x00,
  0xFD, 0xFC, 0x02, 0xFD, 0xFC, 0xFD, 0x0C, 0xFA
 },
 {
  0x0D, 0xEC, 0x03, 0xEE, 0xEF, 0x04, 0xF2, 0x0D,
  0x1C, 0x0B, 0xF8, 0xFA, 0x10, 0x06, 0x00, 0x0A,
  0x03, 0x04, 0xF7, 0x0D, 0x05, 0xF9, 0x0C, 0xFB,
  0x00, 0xF9, 0x05, 0x01, 0x03, 0x03, 0x02, 0x01
 },
 {
  0x03, 0xE5, 0xFB, 0xF5, 0xEB, 0xF5, 0xF4, 0x00,
  0xFB, 0x07, 0xEA, 0x01, 0x03, 0x05, 0x00, 0xFB,
  0x08, 0x07, 0x01, 0xFB, 0xF9, 0x02, 0xFB, 0x04,
  0x01, 0x03, 0xF8, 0xFE, 0x00, 0x04, 0xFE, 0x06
 },
 {
  0x1F, 0xD3, 0x00, 0xFF, 0xF4, 0x01, 0x02, 0xFA,
  0x04, 0x03, 0xFF, 0x03, 0x03, 0x00, 0x05, 0x03,
  0xFB, 0x0C, 0x04, 0x06, 0x02, 0x01, 0xFE, 0x01,
  0x03, 0x02, 0x05, 0x02, 0x02, 0x02, 0x03, 0xFF
 },
 {
  0x09, 0xD3, 0x06, 0x05, 0xFF, 0xEF, 0xFE, 0x12,
  0xFD, 0x02, 0x00, 0x01, 0x00, 0xFF, 0x0A, 0x08,
  0xF9, 0xFE, 0xFB, 0xF8, 0x06, 0xFF, 0x00, 0x04,
  0x06, 0xFD, 0x0C, 0xFF, 0xFE, 0x00, 0x05, 0xF9
 },
 {
  0x03, 0xE6, 0xFE, 0xF4, 0xF4, 0x02, 0xF6, 0x10,
  0xFD, 0x0C, 0x04, 0x05, 0x0B, 0x08, 0xF0, 0xEF,
  0xFE, 0xFD, 0xFD, 0x02, 0x05, 0xF7, 0x0D, 0x01,
  0x0A, 0x0B, 0x03, 0x05, 0xFE, 0x02, 0x02, 0xF9
 },
 {
  0x08, 0xE6, 0x20, 0xF9, 0xFB, 0x16, 0x02, 0x0E,
  0xF6, 0xF8, 0xF9, 0x03, 0x03, 0x07, 0x00, 0xFB,
  0x00, 0xFF, 0xFD, 0x00, 0x08, 0x04, 0xFB, 0xF9,
  0x06, 0xFF, 0x04, 0x08, 0x01, 0x01, 0x07, 0xFA
 },
 {
  0x04, 0xE1, 0x02, 0xF2, 0x02, 0x00, 0x01, 0x08,
  0xFA, 0xFF, 0x11, 0xFD, 0x0D, 0xFA, 0x05, 0xF6,
  0xFE, 0xF6, 0xFE, 0xF6, 0xFD, 0x07, 0x01, 0x05,
  0xF8, 0x08, 0xF2, 0xFD, 0xF1, 0x07, 0xF6, 0xFA
 },
 {
  0x10, 0xE5, 0x0D, 0xFC, 0xE9, 0x07, 0xF7, 0x06,
  0xF9, 0x05, 0x04, 0x02, 0xFF, 0xFD, 0x17, 0xEE,
  0x07, 0x00, 0xFD, 0x04, 0xFD, 0x09, 0xFA, 0xFE,
  0xFF, 0x08, 0xFA, 0x02, 0x06, 0xFD, 0x02, 0xFE
 },
 {
  0xFF, 0xDD, 0xFE, 0xF8, 0x0B, 0xFF, 0xF9, 0xFD,
  0xFE, 0x0B, 0x07, 0x06, 0xFA, 0xF6, 0x09, 0x06,
  0xFD, 0xFB, 0xFA, 0xFD, 0x09, 0x10, 0xF0, 0xF7,
  0xEC, 0x0C, 0x03, 0x05, 0xFD, 0x01, 0xF7, 0x04
 },
 {
  0x02, 0xE8, 0x01, 0xF4, 0xF0, 0x05, 0xFC, 0x03,
  0xFC, 0xFF, 0xF5, 0xF5, 0xF8, 0xF2, 0x0E, 0x0A,
  0xF8, 0x14, 0x08, 0xFD, 0xF5, 0x01, 0x01, 0xFC,
  0xFC, 0xF9, 0xFD, 0x0F, 0x02, 0xFA, 0xFE, 0x07
 },
 {
  0x09, 0xEB, 0x02, 0xED, 0xF9, 0xFB, 0xF8, 0x19,
  0x03, 0x11, 0x05, 0xFD, 0x09, 0xF4, 0x08, 0x02,
  0xFC, 0x03, 0x03, 0x01, 0x0B, 0xF7, 0xFC, 0xFD,
  0x04, 0x03, 0xEA, 0x06, 0x04, 0x06, 0x0B, 0xFB
 },
 {
  0x10, 0xE9, 0x0D, 0xEF, 0xEB, 0xF4, 0x05, 0x09,
  0xEC, 0x07, 0x06, 0xFA, 0x00, 0x02, 0xF7, 0x06,
  0xFA, 0xF3, 0xF9, 0xFF, 0x05, 0xFD, 0x05, 0xF9,
  0xF6, 0x01, 0x00, 0x08, 0xF7, 0x0B, 0x00, 0xF8
 },
 {
  0x0A, 0xE6, 0xF7, 0xF9, 0xED, 0xFC, 0x06, 0x10,
  0xF9, 0x05, 0xFC, 0x04, 0x08, 0x00, 0x04, 0xFF,
  0x06, 0xF9, 0x01, 0xF8, 0xF5, 0x0A, 0xF2, 0x00,
  0xF0, 0x06, 0xFD, 0x05, 0xFF, 0x0E, 0x0C, 0x01
 },
 {
  0x08, 0xE5, 0x0C, 0xF2, 0xFF, 0xFF, 0xED, 0x0A,
  0xF5, 0x15, 0xF2, 0x09, 0xF8, 0xFD, 0x08, 0xFF,
  0x0C, 0xF3, 0x03, 0xFC, 0xFE, 0x00, 0xF7, 0x00,
  0xF9, 0x02, 0xFD, 0x0C, 0x01, 0xFD, 0x03, 0x01
 },
 {
  0x12, 0xEC, 0xF2, 0xF2, 0xF0, 0xFD, 0xE8, 0x06,
  0xEF, 0x02, 0xFD, 0xF5, 0x02, 0xFD, 0x0C, 0x0A,
  0x0A, 0x01, 0x0A, 0x07, 0x08, 0x05, 0x05, 0x04,
  0xFF, 0x07, 0x02, 0x02, 0x00, 0x04, 0x07, 0x00
 },
 {
  0x00, 0xE2, 0x09, 0xF0, 0xEE, 0x0F, 0x0C, 0xFD,
  0x04, 0xFC, 0xFB, 0xF5, 0xFC, 0xF4, 0xF6, 0x00,
  0x02, 0xFE, 0xFC, 0xFF, 0x02, 0x00, 0xFF, 0xFA,
  0x02, 0xFD, 0x04, 0xFB, 0x07, 0x03, 0x05, 0x07
 },
 {
  0x19, 0xE8, 0xFF, 0xFA, 0xF7, 0x06, 0xF3, 0xFE,
  0x03, 0x0F, 0xFD, 0x0B, 0x04, 0xF8, 0xF5, 0x02,
  0x00, 0xF7, 0xFE, 0x07, 0x04, 0x08, 0x05, 0xF8,
  0x05, 0x06, 0xFF, 0xF5, 0xF1, 0xFB, 0x00, 0x0B
 },
 {
  0x00, 0xDE, 0xF9, 0xF5, 0xF9, 0x09, 0xFD, 0x13,
  0x04, 0xF8, 0x03, 0xF5, 0x0B, 0xFD, 0xF7, 0x0C,
  0x09, 0x09, 0x02, 0x01, 0xF9, 0x01, 0xFD, 0x00,
  0xFA, 0xFE, 0xFF, 0x03, 0x00, 0xF9, 0xFE, 0xFB
 },
 {
  0x06, 0xDE, 0xFC, 0xFB, 0xFD, 0xF7, 0x02, 0x09,
  0xFF, 0x09, 0xFB, 0xFD, 0xE6, 0xF4, 0x08, 0xFA,
  0xF9, 0x0B, 0xF8, 0x04, 0x04, 0x01, 0xFF, 0x00,
  0x08, 0x09, 0xFC, 0x07, 0xFF, 0x01, 0xFD, 0xFF
 },
 {
  0x03, 0xE2, 0x05, 0x06, 0xF6, 0x03, 0xF9, 0x06,
  0x03, 0x03, 0xE6, 0xED, 0xFD, 0x01, 0x07, 0x05,
  0xFC, 0xFB, 0x06, 0x0A, 0x0D, 0xF6, 0x04, 0xF9,
  0xFC, 0x05, 0xFD, 0x09, 0xFA, 0x03, 0x09, 0x05
 },
 {
  0x04, 0xE8, 0x09, 0xED, 0x02, 0xFC, 0xFB, 0x08,
  0xFD, 0x02, 0x00, 0xF1, 0xFF, 0x09, 0xFC, 0x16,
  0x06, 0x09, 0x03, 0x07, 0x0B, 0xF7, 0x00, 0xFD,
  0x04, 0x05, 0xFB, 0x0A, 0xF8, 0x05, 0xF9, 0xFD
 },
 {
  0x08, 0xE5, 0x07, 0xFD, 0xFF, 0x02, 0xF7, 0x0D,
  0x07, 0x0C, 0xFC, 0xFA, 0xFA, 0x05, 0x00, 0x07,
  0x05, 0x01, 0x0F, 0xFD, 0xFC, 0x00, 0xFB, 0xFE,
  0x07, 0xFB, 0xF9, 0x01, 0xFE, 0x0D, 0xF8, 0x0D
 },
 {
  0x11, 0xEA, 0xF1, 0xF5, 0xF8, 0x10, 0xF2, 0x12,
  0x02, 0xFF, 0x0E, 0xF9, 0x0E, 0xFA, 0xFA, 0xF9,
  0xF8, 0x11, 0x06, 0x04, 0x04, 0xF9, 0xFB, 0xF7,
  0xF2, 0xFA, 0xFF, 0x09, 0xFD, 0x01, 0x06, 0xFB
 },
 {
  0x19, 0xE2, 0x02, 0xF4, 0xF3, 0x12, 0xEE, 0x10,
  0x08, 0xFD, 0x0A, 0xF8, 0xFD, 0xFF, 0xFA, 0x03,
  0xFB, 0xF9, 0x04, 0x06, 0x07, 0x01, 0x01, 0xF5,
  0xFB, 0x06, 0x02, 0xFC, 0x09, 0xFF, 0xFB, 0xFE
 },
 {
  0x07, 0xE9, 0x07, 0xF1, 0xFF, 0xFD, 0xFF, 0x00,
  0xF6, 0x0C, 0x02, 0x05, 0xFC, 0x00, 0x04, 0x06,
  0xFF, 0x05, 0xF7, 0xFF, 0xFF, 0xF9, 0x01, 0x11,
  0x09, 0xEF, 0xF0, 0x08, 0x04, 0xF2, 0x0B, 0x0E
 },
 {
  0x00, 0xE1, 0x07, 0xF3, 0x03, 0xF5, 0xF9, 0x06,
  0x01, 0xF5, 0x08, 0xF9, 0x0F, 0xFD, 0x10, 0xF5,
  0xFF, 0xF1, 0x10, 0xFD, 0x05, 0x00, 0xFE, 0xFE,
  0xFA, 0x0B, 0x05, 0x06, 0x05, 0xFB, 0x06, 0x03
 },
 {
  0x0D, 0xE8, 0xFE, 0xEC, 0xF6, 0x07, 0xFD, 0xFF,
  0x0F, 0x02, 0x06, 0xFB, 0xF9, 0xF6, 0xEC, 0x01,
  0xFC, 0x0E, 0x08, 0xFE, 0x03, 0xF3, 0xFD, 0x01,
  0xFC, 0x01, 0xFD, 0x02, 0x08, 0xF9, 0x10, 0xFC
 },
 {
  0x01, 0xFE, 0xFE, 0xFD, 0xFC, 0xF9, 0x00, 0x03,
  0x06, 0x07, 0x03, 0x02, 0x01, 0xFE, 0xFF, 0x00,
  0xFA, 0x04, 0x02, 0xFC, 0xFD, 0xFC, 0x05, 0x09,
  0x05, 0x00, 0xFD, 0xFD, 0xFC, 0xF9, 0xE1, 0xCE
 },
 {
  0xFF, 0xFD, 0x07, 0x02, 0xFF, 0x02, 0x04, 0x06,
  0x00, 0x0A, 0xFE, 0x00, 0xEC, 0xFA, 0xFD, 0x09,
  0xEC, 0xEA, 0xFF, 0xFF, 0x0F, 0x09, 0xF4, 0x0A,
  0xF3, 0xEC, 0x0C, 0x03, 0x05, 0x06, 0xF9, 0xE6
 },
 {
  0x00, 0x04, 0xFE, 0xF2, 0xF4, 0x06, 0xF3, 0x0B,
  0xF6, 0x03, 0x16, 0x06, 0x10, 0xFE, 0xFB, 0x01,
  0xFD, 0xF5, 0x00, 0xF9, 0x05, 0xFB, 0x00, 0x01,
  0xFF, 0xFA, 0x08, 0x08, 0x0A, 0x09, 0xFB, 0xE5
 },
 {
  0xFB, 0x0A, 0xFE, 0x07, 0x09, 0xF7, 0x05, 0xF7,
  0x05, 0x04, 0xF1, 0x0E, 0x01, 0x03, 0xF6, 0x05,
  0x00, 0xFE, 0x07, 0x03, 0xF3, 0x06, 0x09, 0xFA,
  0x05, 0xF2, 0xEF, 0xFF, 0x0B, 0x0E, 0xFE, 0xE6
 },
 {
  0x00, 0x06, 0xFD, 0x00, 0xF8, 0x06, 0x00, 0x01,
  0x04, 0xF8, 0x02, 0xFB, 0x04, 0x07, 0x0F, 0x0B,
  0x09, 0x13, 0xFE, 0x0E, 0xF8, 0x07, 0xFF, 0x03,
  0xFD, 0xFD, 0xF6, 0xFE, 0x0C, 0xFE, 0xF4, 0xE3
 },
 {
  0xF4, 0xFB, 0x00, 0xFD, 0xFE, 0x06, 0x03, 0xFD,
  0x02, 0xFE, 0x01, 0x0B, 0x02, 0xF9, 0x05, 0x01,
  0x02, 0xFE, 0xF2, 0x00, 0xFF, 0xFB, 0x03, 0x08,
  0xE4, 0xE6, 0x06, 0xFA, 0x03, 0x08, 0xF6, 0xE5
 },
 {
  0xFF, 0xFD, 0x06, 0x02, 0x04, 0x0F, 0x01, 0x00,
  0x02, 0xFE, 0xFE, 0x0D, 0x03, 0x06, 0x00, 0x06,
  0xFF, 0xFC, 0xFF, 0xFB, 0x08, 0xFF, 0x05, 0xFB,
  0xF1, 0x0B, 0xF8, 0xFB, 0x0E, 0xFA, 0xF2, 0xE3
 },
 {
  0xFB, 0xFA, 0x00, 0x01, 0x00, 0x06, 0xFD, 0x02,
  0xFB, 0xFF, 0x05, 0xFD, 0x02, 0xF6, 0x03, 0x04,
  0x03, 0x00, 0x0D, 0xFD, 0xFF, 0x04, 0xFC, 0xFA,
  0x02, 0x09, 0x08, 0x02, 0xFD, 0x1C, 0xF5, 0xE1
 },
 {
  0x01, 0xFC, 0xF6, 0xF7, 0xFC, 0xFD, 0xF1, 0xFA,
  0x01, 0x05, 0xFD, 0xFA, 0x05, 0xFA, 0xEA, 0x1B,
  0xF3, 0x05, 0x03, 0xF9, 0xFC, 0x14, 0xF9, 0xF4,
  0xFF, 0xE8, 0xFC, 0xF3, 0xF8, 0xF5, 0xF1, 0xEB
 },
 {
  0xFA, 0xFC, 0x13, 0xFA, 0x02, 0x0B, 0xFA, 0x01,
  0xFD, 0xF6, 0x09, 0xF7, 0x0C, 0xF6, 0x02, 0x01,
  0xF7, 0x01, 0x0F, 0x07, 0xFB, 0x05, 0xE3, 0xDD,
  0x04, 0xE2, 0x09, 0x09, 0x13, 0x11, 0x02, 0xEF
 },
 {
  0xFD, 0x03, 0xFD, 0x01, 0x02, 0x05, 0xFF, 0x05,
  0xFE, 0xFD, 0x01, 0xFD, 0xF8, 0x03, 0xFC, 0xFE,
  0xFC, 0xFF, 0x0C, 0x00, 0x02, 0xF8, 0xFA, 0xFC,
  0x10, 0xFF, 0xF2, 0xFE, 0x19, 0xFA, 0xF1, 0xDC
 },
 {
  0x00, 0xFF, 0x03, 0xFC, 0xFC, 0xFF, 0x07, 0xFC,
  0x08, 0x00, 0x0A, 0x09, 0xFC, 0x01, 0x0A, 0xFF,
  0xFD, 0xF3, 0xFB, 0xFC, 0xFF, 0xFC, 0x08, 0x0B,
  0x0E, 0xF9, 0xFB, 0x10, 0x0C, 0x0D, 0xFF, 0xE4
 },
 {
  0x01, 0xFE, 0x02, 0xFD, 0xF8, 0x0A, 0x04, 0x09,
  0x0C, 0x03, 0x05, 0x00, 0x08, 0xFD, 0xFA, 0x02,
  0x10, 0xF5, 0x0B, 0x00, 0x01, 0x06, 0x01, 0x12,
  0xF6, 0xF0, 0xFF, 0xFC, 0x05, 0xF2, 0xF1, 0xEC
 },
 {
  0x01, 0xF4, 0x05, 0x04, 0xF9, 0x08, 0xFF, 0xEF,
  0xFE, 0xF7, 0xF2, 0xF5, 0x06, 0xF7, 0x05, 0xFC,
  0x03, 0xFE, 0x07, 0x12, 0xFB, 0x05, 0x06, 0xFF,
  0xF5, 0xFE, 0xF6, 0xFD, 0x08, 0xFD, 0xFE, 0xE0
 },
 {
  0xF4, 0x05, 0x14, 0xFB, 0xFA, 0xF5, 0xFA, 0xFA,
  0xF3, 0x04, 0xFA, 0x13, 0xF8, 0x02, 0x03, 0xF7,
  0xFC, 0xFC, 0xFF, 0x09, 0xFF, 0x15, 0xFF, 0x07,
  0x0F, 0xF6, 0xFF, 0xFD, 0x09, 0xFD, 0x02, 0xE8
 },
 {
  0x00, 0xFD, 0x02, 0xFA, 0x04, 0xFF, 0xF7, 0xFE,
  0xFF, 0xFD, 0x06, 0xFF, 0xFB, 0xFA, 0xFB, 0xF8,
  0x00, 0xFE, 0xFA, 0x09, 0xFC, 0x03, 0x02, 0xF3,
  0x01, 0xF9, 0x17, 0xF3, 0x04, 0xFD, 0xF1, 0xDF
 },
 {
  0xF9, 0x02, 0xF1, 0x0B, 0xF6, 0x0E, 0x00, 0xF5,
  0x03, 0xFF, 0x0C, 0xFC, 0xFC, 0x09, 0x0B, 0xF3,
  0xF3, 0xFD, 0xF2, 0x01, 0x03, 0x06, 0xFB, 0x08,
  0x00, 0x05, 0x05, 0xF6, 0x04, 0x05, 0xFA, 0xE2
 },
 {
  0xFA, 0x04, 0x00, 0xFB, 0x04, 0x01, 0xFF, 0xFF,
  0x03, 0x06, 0x05, 0xFE, 0xFB, 0x00, 0xFE, 0x05,
  0xFC, 0xFE, 0xFC, 0xFE, 0x04, 0x07, 0xF9, 0xFF,
  0x01, 0xFC, 0xFD, 0xED, 0x25, 0x0C, 0x0A, 0xD8
 },
 {
  0xF9, 0x02, 0xF9, 0xF4, 0x11, 0x0B, 0xF9, 0x02,
  0x02, 0x03, 0x01, 0xFF, 0x03, 0x04, 0xFE, 0xFB,
  0x09, 0xF7, 0x06, 0x04, 0x09, 0x0C, 0x0B, 0xFB,
  0x02, 0xFF, 0x00, 0x09, 0x05, 0xF9, 0xFE, 0xE8
 },
 {
  0xF9, 0x06, 0x01, 0x03, 0x01, 0x00, 0x06, 0x00,
  0x04, 0xF4, 0xFE, 0xFE, 0x01, 0xF7, 0x0A, 0xFE,
  0x0B, 0xFF, 0x15, 0xF4, 0x0F, 0xFB, 0x0A, 0xFB,
  0x05, 0xFB, 0x0E, 0xFA, 0x05, 0xF9, 0xFD, 0xE3
 },
 {
  0xFE, 0x00, 0xFB, 0xFE, 0xFD, 0x01, 0xFD, 0x00,
  0x04, 0x02, 0x03, 0x00, 0x02, 0xFE, 0x07, 0xFE,
  0x03, 0xFB, 0x02, 0xFF, 0x06, 0xFC, 0x00, 0xFD,
  0x08, 0xF5, 0x13, 0xF8, 0x16, 0xDE, 0x0D, 0xDD
 },
 {
  0xFF, 0xFD, 0xFF, 0x09, 0x0B, 0xFD, 0xFD, 0xFF,
  0x07, 0x12, 0x0B, 0xFB, 0x02, 0xF4, 0xF5, 0x12,
  0x09, 0xFB, 0x01, 0xFA, 0xF7, 0x0C, 0x01, 0xFD,
  0xFD, 0xF7, 0xF2, 0x09, 0x09, 0x08, 0xFA, 0xE6
 },
 {
  0x00, 0x05, 0xFB, 0xFF, 0xFF, 0xFE, 0x04, 0x06,
  0x08, 0x02, 0xFF, 0xFE, 0x05, 0x01, 0xFB, 0xFC,
  0x01, 0x01, 0x12, 0x01, 0x07, 0xF6, 0x03, 0xFE,
  0x0C, 0xFF, 0xF1, 0x09, 0x0C, 0xF2, 0x0D, 0xDA
 },
 {
  0x03, 0x00, 0xF8, 0xFF, 0x00, 0x08, 0xF7, 0xFD,
  0xF8, 0x10, 0x03, 0x10, 0xFB, 0xF7, 0x00, 0xFF,
  0xF9, 0xFF, 0xFC, 0x0D, 0x07, 0x00, 0x01, 0x02,
  0xFF, 0xF0, 0x00, 0xFE, 0x01, 0x08, 0xF8, 0xE4
 },
 {
  0x07, 0x09, 0xFB, 0xFD, 0xFE, 0x02, 0x00, 0x03,
  0x0B, 0xFA, 0xFC, 0xFE, 0xFE, 0xFB, 0x1C, 0xEE,
  0xFA, 0x02, 0x0F, 0xF6, 0xF1, 0xF6, 0xFE, 0x00,
  0xFE, 0xFE, 0x04, 0xFD, 0x07, 0x0B, 0x05, 0xE2
 },
 {
  0x09, 0x00, 0xF9, 0xFF, 0xFC, 0xF9, 0x02, 0x02,
  0x09, 0xFE, 0x02, 0x03, 0xF8, 0xFA, 0xFA, 0x03,
  0xF6, 0x04, 0x0A, 0x05, 0x15, 0xFC, 0x0E, 0xEE,
  0x01, 0x03, 0xF6, 0xFE, 0x06, 0x0E, 0xF8, 0xE6
 },
 {
  0xF2, 0xFF, 0x02, 0x03, 0xFD, 0x07, 0x01, 0xEA,
  0xFF, 0xFF, 0x00, 0x01, 0x0C, 0xF2, 0x03, 0xFB,
  0x00, 0x0A, 0xFD, 0x01, 0xFB, 0x0C, 0xFD, 0x0A,
  0xF8, 0xEA, 0xF5, 0xF3, 0xF9, 0xF6, 0xF3, 0xE7
 },
 {
  0xFE, 0xFB, 0xFC, 0xFC, 0xF7, 0xEE, 0x09, 0xFD,
  0xFB, 0x11, 0x0D, 0x05, 0x06, 0x0B, 0x03, 0x08,
  0x14, 0x04, 0x02, 0x09, 0x08, 0x05, 0x06, 0x01,
  0x07, 0xF9, 0xFA, 0xFE, 0xF9, 0x00, 0xEF, 0xE9
 },
 {
  0xFB, 0xFB, 0x02, 0x00, 0x06, 0x02, 0xFE, 0x02,
  0xFD, 0x04, 0x04, 0x00, 0xFB, 0xFE, 0xFC, 0x06,
  0x08, 0x0A, 0xFF, 0x01, 0xFB, 0x05, 0xF2, 0xFE,
  0xF5, 0x08, 0x06, 0x19, 0x07, 0xFF, 0x00, 0xD5
 },
 {
  0xFC, 0x00, 0x04, 0xFE, 0x07, 0x00, 0x03, 0x11,
  0x05, 0x02, 0xFB, 0x01, 0x15, 0x03, 0xFE, 0xF6,
  0xF0, 0xF7, 0x07, 0xF4, 0x09, 0xF8, 0x02, 0x05,
  0xFB, 0xF6, 0xFE, 0xF5, 0xFB, 0xFF, 0xF7, 0xE2
 },
 {
  0xFE, 0x03, 0x01, 0xFC, 0xFF, 0x00, 0x08, 0x01,
  0x0C, 0x04, 0xFF, 0xFF, 0x03, 0xEF, 0x0D, 0x09,
  0x00, 0x07, 0xFA, 0xFB, 0x09, 0x01, 0x05, 0x04,
  0xF6, 0xEE, 0x00, 0x0E, 0x0B, 0xFC, 0xF0, 0xE4
 },
 {
  0xFF, 0x00, 0x02, 0xFF, 0x04, 0x01, 0xFF, 0x01,
  0xFF, 0xFE, 0xFF, 0xFE, 0x03, 0x00, 0x00, 0xFF,
  0xFF, 0x01, 0x02, 0xFE, 0x03, 0x03, 0xFE, 0x04,
  0xFE, 0xFF, 0xFA, 0x01, 0xFF, 0xFF, 0x06, 0xBA
 },
 {
  0x07, 0x03, 0xF5, 0xFF, 0x0C, 0xFC, 0xF2, 0x04,
  0x04, 0xFC, 0x04, 0xFE, 0x02, 0xF4, 0xFC, 0x0F,
  0xEF, 0xFC, 0xFD, 0x06, 0x08, 0xFB, 0x16, 0xEA,
  0x05, 0xF5, 0x0F, 0xFC, 0x04, 0xFF, 0xEB, 0xFF
 },
 {
  0x0A, 0xFE, 0xF3, 0x0B, 0x04, 0x0E, 0x04, 0x09,
  0x08, 0x08, 0x13, 0x0F, 0x0E, 0x0F, 0x05, 0x0A,
  0x08, 0x0F, 0xFB, 0x04, 0x0E, 0xF8, 0x01, 0x01,
  0x02, 0x01, 0xFF, 0xFD, 0x15, 0x08, 0xE3, 0x0D
 },
 {
  0xFA, 0x00, 0xFA, 0x06, 0xFF, 0x02, 0x08, 0xFC,
  0xFB, 0x04, 0xFC, 0xFB, 0x00, 0xFE, 0xFC, 0x00,
  0x09, 0xFE, 0x01, 0xFE, 0x1A, 0xED, 0x15, 0xF6,
  0x04, 0x01, 0xF8, 0x05, 0x16, 0xF6, 0xF3, 0x0F
 },
 {
  0x0B, 0xFB, 0x01, 0x00, 0x06, 0x03, 0x07, 0xFE,
  0xFE, 0xFD, 0xFB, 0xFF, 0xFE, 0xFA, 0x01, 0x01,
  0xF8, 0xFB, 0xF3, 0x0D, 0xFE, 0xFD, 0xFF, 0xF7,
  0xE4, 0x04, 0x02, 0xF5, 0x12, 0xEC, 0xE8, 0x09
 },
 {
  0x07, 0x04, 0xFD, 0x06, 0x06, 0xFA, 0xF9, 0xFB,
  0xF9, 0xFC, 0xFC, 0x00, 0xF9, 0xFB, 0xFA, 0xFB,
  0x02, 0xF3, 0xF4, 0x02, 0x00, 0x05, 0x12, 0x0F,
  0xF3, 0xF9, 0x0D, 0xEC, 0x10, 0xF6, 0xED, 0x06
 },
 {
  0x05, 0xF8, 0xFF, 0x05, 0x0A, 0x02, 0xFF, 0xF6,
  0xF5, 0x17, 0x08, 0xFB, 0xF8, 0x04, 0xFB, 0xFC,
  0xFB, 0xFB, 0xF5, 0xF8, 0x05, 0x01, 0x07, 0xF7,
  0xF7, 0xFA, 0x0C, 0x0E, 0x11, 0xF4, 0xEA, 0x03
 },
 {
  0xFB, 0xF8, 0xFD, 0x03, 0x0C, 0xFF, 0x00, 0xFC,
  0xFB, 0x01, 0x01, 0x06, 0x01, 0x05, 0xFB, 0x07,
  0xFE, 0x07, 0x01, 0x06, 0x06, 0x02, 0x00, 0xFB,
  0x11, 0xFC, 0xFB, 0xE8, 0x0D, 0xEC, 0xE5, 0x0E
 },
 {
  0xFF, 0x02, 0xFD, 0x01, 0xFD, 0x01, 0xFD, 0x00,
  0xFE, 0x03, 0xFE, 0x01, 0x02, 0xFF, 0xFE, 0xFF,
  0xFE, 0xFB, 0x05, 0xFE, 0x00, 0xF9, 0x01, 0xFA,
  0x08, 0x08, 0x0B, 0xFB, 0x18, 0xD5, 0xF3, 0x02
 },
 {
  0xFE, 0x04, 0x07, 0xFD, 0xFC, 0x04, 0x0D, 0xFC,
  0x00, 0x00, 0xFE, 0x09, 0x00, 0xFD, 0xFA, 0x01,
  0xF9, 0x01, 0xFF, 0x0A, 0x00, 0x05, 0xFF, 0xE8,
  0x19, 0xF1, 0x07, 0x02, 0x16, 0xF6, 0xEB, 0x00
 },
 {
  0xFB, 0x02, 0x06, 0xFE, 0x0D, 0x03, 0x05, 0xF4,
  0xF5, 0x10, 0x06, 0x0A, 0xFB, 0x00, 0xFD, 0x06,
  0x05, 0xFB, 0xFB, 0x0A, 0x0C, 0x0A, 0x0B, 0xF9,
  0x08, 0xF2, 0x02, 0xF1, 0x0D, 0xF2, 0xF8, 0xFD
 },
 {
  0x05, 0x06, 0xF9, 0xFB, 0x05, 0x02, 0x09, 0x05,
  0x00, 0xFF, 0xFC, 0x02, 0x08, 0x00, 0x03, 0x05,
  0xF4, 0x03, 0xFD, 0xFA, 0x02, 0xFF, 0xFB, 0x0E,
  0x0B, 0xEC, 0xEB, 0xE7, 0x18, 0xFF, 0xF6, 0x06
 },
 {
  0xFB, 0x05, 0xFE, 0x09, 0x04, 0xFC, 0xFF, 0xFA,
  0x0B, 0xFA, 0x05, 0x00, 0x02, 0xFD, 0x06, 0xFF,
  0xEF, 0xEE, 0xFC, 0xF3, 0x09, 0xFF, 0x09, 0xF9,
  0xFC, 0xF8, 0x02, 0xFD, 0x0C, 0xE1, 0xEE, 0x05
 },
 {
  0xF9, 0xF5, 0x06, 0xF8, 0x04, 0xFD, 0xF4, 0x00,
  0xFF, 0xFA, 0xFD, 0x00, 0x05, 0x09, 0x07, 0x02,
  0x01, 0xF8, 0xFA, 0x08, 0x02, 0xFB, 0x07, 0xFF,
  0x10, 0xF6, 0x10, 0xF4, 0x12, 0xFF, 0xE7, 0xF4
 },
 {
  0x03, 0xF4, 0x01, 0x02, 0xFE, 0xEE, 0xF8, 0xF1,
  0xF6, 0xF7, 0x02, 0xF9, 0x0B, 0xF5, 0x02, 0xFF,
  0xFF, 0xFF, 0xF7, 0xFA, 0x03, 0xF2, 0xFE, 0xFF,
  0x02, 0xF3, 0xF9, 0xF7, 0x13, 0xFB, 0xEF, 0x02
 },
 {
  0x07, 0x01, 0xF8, 0x07, 0x11, 0xF3, 0xF6, 0x05,
  0x07, 0x01, 0xFA, 0x04, 0x09, 0xFC, 0x00, 0x03,
  0x08, 0x01, 0xF2, 0xF7, 0x04, 0x07, 0xF7, 0x00,
  0x06, 0xFB, 0xF4, 0xFE, 0x19, 0xFE, 0xED, 0x01
 },
 {
  0x07, 0xFD, 0x06, 0xFD, 0x01, 0x06, 0xF9, 0x00,
  0x0A, 0x00, 0x04, 0xFB, 0xEF, 0xFC, 0x04, 0xFF,
  0x00, 0xFD, 0xF9, 0x13, 0x18, 0xFF, 0x15, 0x08,
  0x0A, 0x09, 0x08, 0xFF, 0x17, 0xFE, 0xEE, 0xFE
 },
 {
  0x03, 0xFD, 0x00, 0x05, 0x08, 0xFE, 0xF7, 0x02,
  0x09, 0x06, 0x13, 0x08, 0x02, 0x06, 0xF7, 0xFE,
  0xFC, 0xFD, 0xF8, 0x07, 0xF9, 0xF8, 0x05, 0x04,
  0x1A, 0xFA, 0x07, 0x12, 0x18, 0x00, 0xF3, 0x04
 },
 {
  0x00, 0xF3, 0xF5, 0xFF, 0x03, 0xF7, 0x05, 0x04,
  0xF9, 0x03, 0x00, 0x02, 0xFF, 0x04, 0xFB, 0x02,
  0x09, 0xFE, 0xF5, 0x0F, 0x01, 0xEB, 0x01, 0xFF,
  0x00, 0x04, 0xF2, 0xFC, 0x18, 0xF0, 0xF3, 0x01
 },
 {
  0x01, 0xF7, 0xF8, 0x00, 0x00, 0xFC, 0x0B, 0xFF,
  0x0E, 0x10, 0x00, 0x11, 0xFE, 0xF7, 0xF4, 0x00,
  0xFF, 0xF2, 0xF7, 0xF2, 0x00, 0xFE, 0x13, 0x04,
  0x06, 0x04, 0x04, 0xF5, 0x08, 0xEF, 0xED, 0xFB
 },
 {
  0xFD, 0x01, 0x02, 0x0C, 0xFC, 0xEE, 0xFF, 0xFC,
  0xF9, 0x0E, 0xFD, 0x02, 0x00, 0xF9, 0xF8, 0x0C,
  0xFB, 0xF7, 0x0E, 0x0C, 0xF7, 0xFE, 0x04, 0xFA,
  0x04, 0x12, 0xFF, 0xE7, 0x16, 0x02, 0xE9, 0xFB
 },
 {
  0xFE, 0x00, 0x00, 0x00, 0x01, 0x03, 0x05, 0xFF,
  0x05, 0xFE, 0xFE, 0x02, 0xFD, 0x00, 0x01, 0x02,
  0x00, 0xFF, 0x02, 0xFF, 0xF7, 0xFA, 0xF9, 0xFC,
  0xFE, 0x04, 0xF9, 0xFB, 0x40, 0xFD, 0xE7, 0x04
 },
 {
  0x0C, 0xFE, 0xFD, 0x00, 0x08, 0xF7, 0x0D, 0xF9,
  0x06, 0xFD, 0xF4, 0x0C, 0x0F, 0xF7, 0xFC, 0x02,
  0x09, 0xFC, 0xF4, 0x03, 0x0E, 0x01, 0x07, 0xF1,
  0x0F, 0x00, 0xFA, 0xF4, 0x00, 0xFD, 0xEC, 0x06
 },
 {
  0x02, 0xFF, 0xFC, 0x05, 0x09, 0x06, 0xF9, 0x02,
  0xFE, 0xF9, 0xFE, 0x00, 0xFF, 0xEE, 0xFC, 0xFA,
  0xF1, 0xFB, 0x0B, 0x05, 0xF6, 0xFF, 0x02, 0x07,
  0x0C, 0xED, 0xF9, 0x08, 0x15, 0xFC, 0xF1, 0x04
 },
 {
  0x04, 0x02, 0x05, 0x05, 0xFB, 0x01, 0x03, 0x02,
  0xF8, 0x0D, 0x00, 0xFB, 0xFE, 0xF2, 0xF5, 0x06,
  0x02, 0x11, 0x08, 0xF3, 0x1A, 0xFE, 0x05, 0xF1,
  0xFC, 0xF2, 0x0C, 0xF7, 0x0D, 0xEB, 0xE9, 0xFC
 },
 {
  0x02, 0xFD, 0xFE, 0xFD, 0x03, 0xFE, 0x06, 0x09,
  0xF7, 0x0D, 0x04, 0x02, 0x0C, 0xFD, 0xFD, 0x01,
  0xEF, 0xEA, 0xFD, 0x04, 0x03, 0xFE, 0x01, 0xF7,
  0x01, 0xFA, 0x0B, 0xF3, 0x0E, 0x00, 0xF1, 0x06
 },
 {
  0xF0, 0xFC, 0x11, 0xFE, 0xEC, 0xF5, 0x0B, 0x0A,
  0x05, 0xF8, 0x10, 0x02, 0xEF, 0xF2, 0x0B, 0x0B,
  0xFA, 0xF5, 0xF9, 0x0C, 0x0C, 0xF6, 0xFA, 0x05,
  0x08, 0xFC, 0xFE, 0xFB, 0x1C, 0x03, 0xF3, 0x04
 },
 {
  0x00, 0xFD, 0x03, 0xF9, 0x06, 0x08, 0xF4, 0x14,
  0xED, 0x12, 0xF5, 0x0A, 0xFB, 0x00, 0xF7, 0x0B,
  0x03, 0x00, 0xFE, 0x09, 0xF9, 0xFB, 0x12, 0x03,
  0xFE, 0xF0, 0x01, 0x06, 0x0C, 0xF9, 0xF0, 0x01
 },
 {
  0x04, 0x01, 0x05, 0xFB, 0x0F, 0x02, 0xF8, 0x03,
  0x05, 0xF5, 0x0F, 0xFD, 0x08, 0xF8, 0xFF, 0x07,
  0x04, 0x07, 0xFE, 0x06, 0xF7, 0x05, 0x0C, 0x02,
  0x21, 0xFE, 0xFA, 0xEE, 0x04, 0x00, 0xEE, 0x0B
 },
 {
  0x03, 0xFF, 0x01, 0xFF, 0x00, 0x01, 0x04, 0xFF,
  0xFB, 0x00, 0x01, 0x00, 0x04, 0x02, 0xFF, 0x04,
  0xFD, 0x02, 0x00, 0xFE, 0x04, 0x06, 0xFF, 0x06,
  0x2A, 0x13, 0xFC, 0xDB, 0x13, 0x01, 0xF1, 0xFC
 },
 {
  0x02, 0x00, 0xFB, 0x00, 0x0A, 0x00, 0x00, 0xFB,
  0x03, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0x02, 0xFC,
  0xF6, 0x02, 0xFA, 0x04, 0x04, 0x01, 0x1B, 0xF9,
  0x11, 0xDE, 0x05, 0xF7, 0x0F, 0xF0, 0xF9, 0xFB
 },
 {
  0xFE, 0x07, 0x07, 0xFE, 0x09, 0xFE, 0xF1, 0x0B,
  0x0B, 0x07, 0x05, 0x01, 0x0F, 0x01, 0xF7, 0x1F,
  0x02, 0xF1, 0x02, 0x04, 0x03, 0x04, 0xFF, 0xF8,
  0x02, 0xF9, 0x06, 0xEF, 0x0B, 0xF2, 0xF5, 0x02
 },
 {
  0x01, 0x01, 0xF5, 0x09, 0x09, 0xFA, 0xF2, 0xF5,
  0xF6, 0x08, 0xFD, 0x0B, 0x10, 0xF7, 0xF8, 0xF3,
  0xF8, 0x09, 0x00, 0x06, 0x06, 0xFE, 0x0D, 0xF8,
  0xFE, 0x03, 0x0D, 0xFD, 0x0A, 0xFA, 0xEF, 0x04
 },
 {
  0x0E, 0x05, 0x04, 0xFA, 0xF4, 0x0A, 0xF9, 0x08,
  0x15, 0xF8, 0xE2, 0x0F, 0xFE, 0x01, 0x0B, 0xF7,
  0xFB, 0x01, 0x00, 0xFF, 0xFF, 0xFA, 0xFE, 0x03,
  0xFB, 0x07, 0x09, 0x05, 0xFB, 0x02, 0x00, 0x01
 },
 {
  0xFF, 0x02, 0x14, 0xEF, 0xF1, 0x03, 0x03, 0x07,
  0x0B, 0xEF, 0xF3, 0xFA, 0xFD, 0x12, 0x11, 0xF1,
  0xFC, 0xFC, 0xFB, 0x16, 0x0E, 0xF2, 0xFE, 0xF6,
  0xF9, 0x0B, 0x08, 0xF9, 0xFD, 0x00, 0xF9, 0x0B
 },
 {
  0x07, 0xF5, 0xF9, 0xF8, 0xF2, 0x16, 0x05, 0x02,
  0x06, 0x0D, 0xF4, 0xFE, 0x0A, 0x03, 0x00, 0xEB,
  0xFC, 0x14, 0x03, 0x0A, 0x15, 0xF6, 0xF4, 0x08,
  0x0B, 0x02, 0xFB, 0x02, 0x01, 0x03, 0xFF, 0x0F
 },
 {
  0xFF, 0xFE, 0xFF, 0xFE, 0xF3, 0x08, 0xFC, 0x00,
  0x07, 0xFE, 0xEF, 0x08, 0x12, 0x05, 0x03, 0x08,
  0xF8, 0xFE, 0x03, 0xFC, 0x0E, 0xEE, 0xF3, 0x0E,
  0x0F, 0xF3, 0xFF, 0xFE, 0x04, 0x0B, 0x01, 0x0C
 },
 {
  0x0D, 0xFA, 0xFC, 0xF0, 0xEF, 0x10, 0x15, 0xFE,
  0x05, 0xF5, 0xF7, 0x13, 0x15, 0xEF, 0xFD, 0xEF,
  0x03, 0x0C, 0x08, 0xF4, 0xFA, 0x01, 0xF9, 0x09,
  0x09, 0xF9, 0xFB, 0xFF, 0xFD, 0x05, 0xFA, 0xFC
 },
 {
  0x0B, 0x05, 0x0C, 0xEC, 0xFA, 0x0A, 0x04, 0x0C,
  0x08, 0xFB, 0xF6, 0x0F, 0x0D, 0x0E, 0x0A, 0xF1,
  0xF3, 0x01, 0x06, 0x0E, 0x0F, 0xEF, 0xF3, 0x04,
  0xFB, 0x0A, 0x07, 0xFA, 0xF8, 0xFD, 0xFC, 0x0C
 },
 {
  0x19, 0xFF, 0x07, 0xFB, 0xF9, 0x0B, 0x01, 0x11,
  0x0D, 0xF1, 0xF2, 0xFC, 0x05, 0x03, 0x08, 0xFD,
  0xFE, 0x02, 0x00, 0x06, 0x10, 0xF4, 0xFA, 0xFC,
  0x04, 0xFD, 0x07, 0xF6, 0xFD, 0xF9, 0xF3, 0x07
 },
 {
  0xF8, 0x0A, 0xFD, 0xF3, 0x05, 0x02, 0x04, 0x09,
  0x09, 0xEF, 0xF3, 0x02, 0x0B, 0x01, 0x06, 0xFC,
  0x08, 0xF6, 0x04, 0x01, 0x13, 0xF1, 0xFC, 0x0C,
  0x1F, 0x07, 0xFB, 0xEF, 0xFC, 0x09, 0xFE, 0x07
 },
 {
  0x0E, 0xFA, 0xFA, 0xFA, 0xF2, 0x0D, 0x11, 0xFB,
  0x04, 0xF2, 0xF7, 0x07, 0x07, 0xF7, 0x03, 0xF0,
  0xF1, 0x0B, 0x0B, 0x06, 0x04, 0xF5, 0xED, 0x03,
  0x05, 0x08, 0x0D, 0xF2, 0xF2, 0x03, 0xFC, 0x0C
 },
 {
  0xFE, 0xFC, 0x0A, 0xFC, 0xF9, 0xFF, 0x1B, 0x05,
  0x02, 0xF0, 0xEE, 0x04, 0x0C, 0xFE, 0xFD, 0xFE,
  0xFF, 0x01, 0xF8, 0xF4, 0x03, 0xFC, 0x08, 0x0F,
  0x02, 0x04, 0x09, 0xF3, 0xF2, 0x09, 0xF9, 0x05
 },
 {
  0x04, 0x02, 0xF6, 0xFB, 0xF9, 0x02, 0x01, 0x04,
  0xFF, 0xFA, 0xF1, 0x06, 0x01, 0x0A, 0x05, 0xF6,
  0xF7, 0xFF, 0x0D, 0xFD, 0x05, 0xEB, 0xF5, 0x08,
  0x08, 0x05, 0x1B, 0xEB, 0xEE, 0xFB, 0xFF, 0x0F
 },
 {
  0x0B, 0x01, 0xF0, 0xF8, 0xF5, 0x00, 0x05, 0xF8,
  0xF4, 0xF3, 0xEF, 0x16, 0x04, 0xFA, 0xFF, 0xEE,
  0xF6, 0x00, 0x13, 0x02, 0xFE, 0xF8, 0xF9, 0xFD,
  0x02, 0xFE, 0xF7, 0xEF, 0xFB, 0x04, 0x04, 0x0A
 },
 {
  0x08, 0xFA, 0xED, 0xFB, 0xFC, 0x0C, 0x0E, 0x0F,
  0x0A, 0xF7, 0xFF, 0xF7, 0x13, 0x0C, 0x00, 0xFF,
  0x02, 0x04, 0x07, 0x09, 0x10, 0xF0, 0xF2, 0x09,
  0xFC, 0x03, 0x01, 0x00, 0xFE, 0x0A, 0xFF, 0xFF
 },
 {
  0x0C, 0xF8, 0x0C, 0xF7, 0x00, 0x19, 0x07, 0x09,
  0x02, 0xE1, 0xF7, 0xFC, 0x0F, 0x04, 0xFB, 0x01,
  0xF6, 0x0B, 0x08, 0x0A, 0x00, 0xFA, 0x05, 0x0B,
  0xFF, 0xFA, 0x04, 0xF6, 0xF7, 0x06, 0x04, 0x05
 },
 {
  0x0E, 0x06, 0xEF, 0xFE, 0x11, 0x0C, 0xF7, 0x02,
  0x00, 0xE7, 0xF2, 0x05, 0x14, 0x0E, 0x08, 0xEC,
  0x05, 0x02, 0xFE, 0xFD, 0x09, 0xF3, 0xFD, 0xFF,
  0xFA, 0x03, 0x07, 0xFA, 0x00, 0x02, 0x03, 0x01
 },
 {
  0x08, 0x04, 0xF1, 0xFD, 0x0A, 0x12, 0xFC, 0x0D,
  0x08, 0xEA, 0xF6, 0x09, 0x13, 0xF1, 0x07, 0xFB,
  0xF3, 0x0C, 0xFC, 0x09, 0x02, 0xF7, 0xFA, 0x00,
  0x02, 0x01, 0xF7, 0xFA, 0x06, 0x01, 0xFF, 0x0B
 },
 {
  0x04, 0x01, 0x04, 0xFB, 0xF6, 0x12, 0x07, 0x02,
  0xFC, 0xF7, 0xF5, 0x00, 0x20, 0xF9, 0x04, 0xF0,
  0xFF, 0x00, 0x06, 0x03, 0x06, 0xFD, 0xF2, 0x10,
  0x09, 0xFE, 0x07, 0xFF, 0x00, 0xFB, 0x05, 0xFD
 },
 {
  0xFD, 0x02, 0x03, 0xF8, 0xFA, 0x04, 0x06, 0x02,
  0x04, 0xF4, 0xF1, 0x02, 0x08, 0x08, 0x09, 0xFD,
  0xEE, 0x06, 0x22, 0x0B, 0x0C, 0xF1, 0xFF, 0x02,
  0x09, 0x02, 0xFC, 0xFC, 0x02, 0x04, 0x02, 0xFD
 },
 {
  0x12, 0xFA, 0xF4, 0xF8, 0xFF, 0x0F, 0x14, 0xFC,
  0xFF, 0xF5, 0xFB, 0x06, 0x06, 0xF5, 0xF1, 0xF9,
  0x03, 0x07, 0x0A, 0x02, 0x08, 0xF6, 0xFB, 0x08,
  0x0F, 0xFB, 0x05, 0xEF, 0xF3, 0x0D, 0x0B, 0x07
 },
 {
  0x08, 0xFC, 0xFA, 0xFF, 0xF2, 0xFD, 0x06, 0xFE,
  0x01, 0xFB, 0xFF, 0x0A, 0x0A, 0xF1, 0x05, 0x00,
  0xF6, 0xFC, 0xFD, 0x07, 0xFC, 0xED, 0xF1, 0x1B,
  0x0B, 0x12, 0x03, 0xED, 0xFE, 0x06, 0x00, 0x0C
 },
 {
  0x0C, 0x00, 0xFB, 0x00, 0x04, 0xFB, 0x01, 0x05,
  0x0A, 0xF9, 0xF5, 0x15, 0x1D, 0x01, 0xFE, 0x01,
  0xFC, 0xF5, 0xFF, 0x0D, 0x0B, 0xEC, 0xFF, 0x04,
  0x04, 0x04, 0xFB, 0x06, 0xF3, 0xFE, 0x0B, 0x09
 },
 {
  0x02, 0xF9, 0xF9, 0xFD, 0xF6, 0xFF, 0x14, 0x0C,
  0x01, 0xED, 0xED, 0xFF, 0x05, 0x04, 0xF9, 0xE7,
  0x0E, 0x01, 0xFD, 0x02, 0x0C, 0xFC, 0xFD, 0xFD,
  0xFE, 0x06, 0x01, 0x00, 0x03, 0x02, 0x05, 0xFF
 },
 {
  0x0C, 0xF8, 0x03, 0xF4, 0xF6, 0x0A, 0x0D, 0x00,
  0x17, 0xF2, 0xEE, 0x0A, 0x00, 0x0F, 0x03, 0xF4,
  0xFD, 0xFB, 0x05, 0xFC, 0x02, 0xF2, 0xF6, 0x08,
  0x02, 0x09, 0xFF, 0xF5, 0xFD, 0x05, 0x0D, 0x02
 },
 {
  0x09, 0xFA, 0x07, 0xF9, 0xE2, 0x11, 0x06, 0x0D,
  0x01, 0xF2, 0x00, 0xFF, 0x06, 0xF7, 0x08, 0x03,
  0xFC, 0x00, 0xFF, 0xF9, 0xFB, 0xF3, 0xED, 0xFD,
  0xFC, 0x04, 0xFA, 0xFE, 0xF3, 0x01, 0xFE, 0x03
 },
 {
  0x0A, 0x01, 0x03, 0xEE, 0xE6, 0x11, 0x04, 0xF0,
  0x04, 0xFD, 0xF3, 0xFC, 0xFA, 0xF5, 0xFC, 0xEB,
  0x07, 0x08, 0x02, 0x05, 0x0D, 0xFA, 0x01, 0x05,
  0x08, 0x07, 0x09, 0xFA, 0xFA, 0x01, 0xFF, 0x02
 },
 {
  0xFD, 0xFF, 0x00, 0xFE, 0xFE, 0x00, 0xFF, 0x03,
  0x04, 0xF2, 0xF8, 0xF7, 0x0D, 0x02, 0x32, 0xE9,
  0xF8, 0x08, 0x07, 0x0B, 0x10, 0x03, 0xF9, 0x00,
  0xFE, 0x06, 0x05, 0xFF, 0x01, 0xFE, 0x04, 0x03
 },
 {
  0x01, 0x03, 0x01, 0x01, 0xFA, 0x03, 0x06, 0x06,
  0x02, 0xFE, 0xFD, 0x0A, 0x02, 0xF8, 0xFB, 0xFB,
  0x05, 0x04, 0x04, 0xFE, 0x0A, 0xF8, 0xD8, 0xFF,
  0x15, 0x08, 0x03, 0xFC, 0xFF, 0x0D, 0x04, 0x07
 },
 {
  0x02, 0x00, 0xFC, 0xF8, 0x05, 0x02, 0x07, 0xFB,
  0x05, 0xF8, 0xFC, 0xFF, 0x0C, 0x02, 0x0C, 0xF3,
  0xF7, 0x00, 0x01, 0xF4, 0x09, 0xD5, 0x01, 0xFB,
  0x0C, 0x01, 0x03, 0x06, 0x01, 0xFF, 0x03, 0xFE
 },
 {
  0x06, 0xFE, 0xFF, 0x01, 0x00, 0x04, 0x08, 0x0E,
  0x04, 0xF9, 0xE9, 0xFB, 0x17, 0xEF, 0xFA, 0xF1,
  0xF8, 0x07, 0x0A, 0xFF, 0x07, 0xF0, 0x04, 0xFA,
  0x02, 0x03, 0xFD, 0xFD, 0xFF, 0x08, 0xFF, 0x04
 },
 {
  0x0A, 0x04, 0xFC, 0x01, 0x07, 0xFD, 0x02, 0x0B,
  0x04, 0xFA, 0xFD, 0x08, 0x05, 0x04, 0x01, 0xD3,
  0xFA, 0xFC, 0x04, 0x02, 0x01, 0xF2, 0xF6, 0x01,
  0x01, 0x06, 0x02, 0xF8, 0xFF, 0xFD, 0x03, 0x03
 },
 {
  0x01, 0xFF, 0x02, 0xFD, 0xF8, 0x09, 0x03, 0x03,
  0xFE, 0xFB, 0xF8, 0x08, 0x07, 0xF9, 0xFC, 0xFA,
  0x05, 0xF7, 0x0B, 0xFE, 0x2E, 0xFB, 0xFF, 0x09,
  0xFE, 0x00, 0x03, 0xFB, 0xFD, 0xFB, 0x07, 0x00
 },
 {
  0xFC, 0x01, 0xFE, 0xFF, 0xF5, 0x0B, 0x08, 0xFD,
  0xFE, 0xF6, 0x00, 0x04, 0x09, 0x09, 0xEF, 0xEF,
  0xDE, 0xFC, 0xFB, 0xF9, 0xFD, 0xF4, 0xFD, 0x0B,
  0x12, 0x03, 0xFE, 0xFB, 0xEE, 0xFB, 0xFD, 0x06
 },
 {
  0x07, 0xFB, 0xFD, 0x01, 0xFC, 0xFD, 0xFB, 0xFF,
  0x02, 0x05, 0xFE, 0x03, 0xF6, 0x0C, 0xEE, 0xFB,
  0xF6, 0x0C, 0xF7, 0x04, 0xFA, 0x02, 0x00, 0x10,
  0xEF, 0x0F, 0x0E, 0xF4, 0xF6, 0xFE, 0xF7, 0xFF
 },
 {
  0x04, 0xFB, 0xFD, 0xFB, 0xFD, 0xFF, 0x07, 0x12,
  0xF9, 0x0C, 0x03, 0x05, 0xF8, 0xFC, 0xEC, 0x01,
  0xE7, 0x01, 0xF8, 0x0D, 0xF6, 0x08, 0xED, 0xFF,
  0xF8, 0x0A, 0x06, 0xF7, 0xFF, 0x00, 0x0C, 0x04
 },
 {
  0xFC, 0x05, 0x00, 0xFF, 0x02, 0x05, 0xF8, 0xFE,
  0xFA, 0x04, 0xF8, 0x09, 0x03, 0x02, 0xF9, 0x04,
  0xE7, 0x0D, 0xE9, 0x0A, 0x0E, 0x0F, 0xF5, 0x03,
  0xEE, 0x04, 0x10, 0xFC, 0x01, 0xF6, 0xF6, 0x03
 },
 {
  0x05, 0xFD, 0xFF, 0xFD, 0x04, 0x01, 0xFD, 0xFC,
  0xFB, 0x01, 0xF4, 0x0E, 0xF9, 0x0B, 0xF1, 0x06,
  0xFA, 0x18, 0xFC, 0x0D, 0xFF, 0x0F, 0xF3, 0x08,
  0x03, 0x07, 0xFB, 0x02, 0x02, 0x00, 0x03, 0xF9
 },
 {
  0xFD, 0x01, 0x00, 0x08, 0x06, 0xFF, 0x06, 0x05,
  0xFB, 0xFE, 0xF4, 0x04, 0x00, 0xFE, 0xFD, 0x05,
  0xFA, 0x00, 0xF8, 0x09, 0xF6, 0x04, 0xE4, 0x0C,
  0xEC, 0x0B, 0xF3, 0x07, 0xEE, 0x01, 0xF5, 0x01
 },
 {
  0x01, 0xFC, 0xF1, 0x05, 0x00, 0xF3, 0xFB, 0x0D,
  0xF5, 0x04, 0xFC, 0xFB, 0x05, 0xF2, 0xF0, 0x00,
  0xF2, 0x05, 0xEC, 0x0C, 0x0A, 0xF9, 0xFB, 0x06,
  0x06, 0x16, 0x06, 0xFC, 0xFE, 0x03, 0x08, 0x0B
 },
 {
  0x0D, 0xF5, 0xFE, 0x10, 0x10, 0xF9, 0x00, 0x14,
  0xF9, 0xFF, 0x00, 0x05, 0xF7, 0x0C, 0xFE, 0xFB,
  0xEA, 0x05, 0xF6, 0x0C, 0xFA, 0x0B, 0x09, 0x15,
  0xF8, 0x0F, 0x04, 0x00, 0xF8, 0xFC, 0xFC, 0x0A
 },
 {
  0x12, 0xFC, 0xF3, 0x00, 0x01, 0xF1, 0xFF, 0xFD,
  0x02, 0x0A, 0xFF, 0x06, 0x01, 0xFC, 0xEC, 0xFB,
  0xF8, 0x06, 0xF8, 0x11, 0xFB, 0x05, 0xF6, 0x08,
  0xEA, 0x06, 0xFB, 0xFE, 0x08, 0xEF, 0x08, 0x02
 },
 {
  0x01, 0xFE, 0xF7, 0x06, 0xE1, 0xF8, 0xF8, 0x08,
  0x00, 0x05, 0xF7, 0xFC, 0x02, 0x03, 0xF4, 0x0B,
  0xEE, 0x0A, 0xFB, 0x03, 0xF5, 0x0D, 0xFA, 0x0B,
  0xFD, 0x0C, 0xF9, 0x03, 0xF7, 0xFF, 0x02, 0x0B
 },
 {
  0xF7, 0xFA, 0x15, 0xF8, 0xF1, 0x04, 0xF5, 0x0C,
  0xF5, 0x11, 0xFF, 0x02, 0xFA, 0x00, 0xF1, 0x0D,
  0xF4, 0x13, 0x00, 0x02, 0xFA, 0xFD, 0xF7, 0x0A,
  0x03, 0x11, 0xFE, 0x05, 0xF6, 0xFD, 0x00, 0x01
 },
 {
  0x04, 0xFA, 0x05, 0xF6, 0x01, 0xFB, 0x01, 0x00,
  0x00, 0x00, 0x02, 0x07, 0xFE, 0x02, 0xFE, 0x00,
  0xFC, 0x03, 0xFC, 0x01, 0xF4, 0x06, 0xCF, 0x10,
  0xF6, 0x0D, 0x00, 0xFE, 0x08, 0x06, 0x01, 0x08
 },
 {
  0x05, 0xF8, 0xF9, 0x09, 0x0D, 0xFB, 0x07, 0x00,
  0x0A, 0x0B, 0xFC, 0xFD, 0xFF, 0x0D, 0xF2, 0x06,
  0xF1, 0xFA, 0xF2, 0x10, 0x0F, 0x01, 0xEE, 0xFC,
  0xEC, 0x14, 0xF9, 0xFF, 0xF7, 0xFE, 0xF6, 0x0A
 },
 {
  0xF4, 0x04, 0x00, 0x0A, 0x00, 0x03, 0x08, 0x04,
  0xE5, 0xFF, 0xFE, 0x13, 0xFC, 0x02, 0xF3, 0x03,
  0x01, 0x09, 0xF4, 0x01, 0xEA, 0x13, 0xFB, 0x04,
  0xF7, 0x0C, 0x02, 0xF7, 0xF8, 0x0B, 0xFD, 0x07
 },
 {
  0x04, 0xFB, 0x0B, 0xFA, 0x11, 0xEF, 0x05, 0xFC,
  0xFE, 0xFA, 0x01, 0xFB, 0x02, 0x04, 0xF2, 0x06,
  0xEC, 0x13, 0xEC, 0x0C, 0xEB, 0x05, 0xF2, 0x0D,
  0xFE, 0x0B, 0x04, 0xFD, 0x00, 0xF6, 0xFC, 0xFE
 },
 {
  0xFE, 0xFF, 0xFD, 0x08, 0xF7, 0xF9, 0xEA, 0xFD,
  0xE8, 0x0D, 0xFE, 0x0A, 0xF1, 0x05, 0xF7, 0x04,
  0xF9, 0x00, 0xFB, 0x0F, 0xF8, 0x0B, 0xF3, 0x06,
  0xFC, 0x13, 0xF8, 0x0C, 0xFC, 0x06, 0x09, 0x07
 },
 {
  0x02, 0xFD, 0x02, 0xFF, 0x00, 0x03, 0x01, 0x02,
  0x01, 0xFC, 0xFE, 0xFD, 0x01, 0x05, 0xF4, 0x06,
  0xF0, 0x0E, 0xE9, 0x0A, 0xF2, 0x11, 0xF1, 0x10,
  0xFE, 0x09, 0xE7, 0x09, 0xF6, 0x10, 0x04, 0x09
 },
 {
  0xFD, 0x07, 0xF8, 0xFD, 0x02, 0x02, 0xFC, 0xF8,
  0xF7, 0x0A, 0x03, 0xF5, 0x19, 0xF6, 0xE4, 0x1B,
  0xF7, 0x07, 0xF3, 0x09, 0xFE, 0x04, 0xF4, 0xF8,
  0xF2, 0x06, 0x07, 0xF6, 0x03, 0x03, 0xFD, 0x05
 },
 {
  0xF8, 0xFD, 0x01, 0xF6, 0x08, 0xFD, 0xF7, 0xFC,
  0x0D, 0x07, 0x02, 0x04, 0xF6, 0x04, 0x03, 0x07,
  0xEE, 0x02, 0xEA, 0x0F, 0x04, 0x14, 0xF9, 0x05,
  0xFA, 0x0D, 0xFF, 0x04, 0xF9, 0xFA, 0x06, 0x0D
 },
 {
  0xFE, 0x03, 0x00, 0x02, 0xFC, 0xFE, 0x00, 0x00,
  0x01, 0x02, 0xFE, 0xFB, 0x00, 0x01, 0xFC, 0x00,
  0xFE, 0xFD, 0x01, 0x02, 0xFF, 0x02, 0xF8, 0xFF,
  0xE8, 0x44, 0xFD, 0x08, 0x03, 0x03, 0xFF, 0xFF
 },
 {
  0xF1, 0xFE, 0xF7, 0xF9, 0xFF, 0x08, 0xF2, 0x08,
  0x03, 0x06, 0x00, 0xFF, 0xF8, 0x08, 0xE9, 0x02,
  0xF2, 0x11, 0xF1, 0x08, 0xFC, 0x07, 0xEE, 0x00,
  0xF8, 0xFD, 0xFF, 0xFC, 0xF6, 0x04, 0xFF, 0x04
 },
 {
  0x08, 0x00, 0x02, 0xF9, 0x00, 0x05, 0x01, 0x03,
  0xF5, 0x04, 0xF8, 0x0E, 0x03, 0x14, 0x01, 0x1A,
  0xF5, 0x0D, 0xF3, 0x14, 0xFE, 0x00, 0xF8, 0x02,
  0xFA, 0x06, 0xFF, 0x09, 0x03, 0xFA, 0xFD, 0x0A
 },
 {
  0x05, 0x00, 0xFF, 0xF9, 0x0A, 0x01, 0xFD, 0x05,
  0x04, 0x07, 0xFB, 0xFF, 0xFD, 0xFF, 0x0C, 0xFD,
  0xF1, 0x07, 0xF7, 0x16, 0xED, 0x08, 0xF7, 0x04,
  0xE9, 0x0D, 0xF2, 0x06, 0xFA, 0xF2, 0xFC, 0x07
 },
 {
  0x0E, 0xFB, 0xF8, 0xF6, 0x19, 0x03, 0xE9, 0xF9,
  0xE4, 0x00, 0xFF, 0xF7, 0x04, 0x01, 0xF3, 0x14,
  0xF8, 0x0A, 0xF0, 0x08, 0x0C, 0xF3, 0xEB, 0x05,
  0xF3, 0x0B, 0xFE, 0x01, 0x0C, 0xF9, 0x02, 0xF6
 },
 {
  0xFB, 0xFC, 0x09, 0x05, 0xFA, 0x23, 0xF9, 0x08,
  0x0F, 0x02, 0xFF, 0xF7, 0xFA, 0x02, 0xEE, 0x07,
  0xF1, 0x06, 0xFD, 0x02, 0x08, 0x0C, 0xE2, 0x07,
  0xFC, 0x14, 0x02, 0x06, 0x0D, 0xFA, 0xFC, 0x00
 },
 {
  0x01, 0x08, 0xF7, 0x09, 0xFB, 0x0C, 0xF7, 0x10,
  0xF7, 0x10, 0xEF, 0x0E, 0xF3, 0x0F, 0xEE, 0x0E,
  0xF1, 0x11, 0xF4, 0x0E, 0xF3, 0x07, 0xF0, 0x0D,
  0xF7, 0x05, 0xF5, 0x0A, 0xF7, 0x06, 0xF4, 0x0D
 },
 {
  0xF6, 0xFC, 0x05, 0x03, 0x01, 0x06, 0x08, 0xF2,
  0xFB, 0x0F, 0x07, 0x04, 0x08, 0x07, 0xEA, 0x08,
  0xF9, 0xF8, 0xF1, 0x1A, 0x01, 0x0D, 0xFD, 0x11,
  0xFB, 0x09, 0xFE, 0x04, 0xFA, 0x03, 0xF8, 0x09
 },
 {
  0x08, 0xFD, 0x02, 0x03, 0x03, 0x01, 0xFE, 0xFF,
  0xF5, 0x08, 0xFC, 0x00, 0xFA, 0xFB, 0xFF, 0x0D,
  0xDB, 0x09, 0x01, 0xFA, 0xF6, 0xFE, 0xF6, 0x0B,
  0x08, 0x0D, 0xFD, 0xFE, 0xFA, 0x08, 0xFC, 0x0D
 },
 {
  0x03, 0x02, 0xFD, 0xFC, 0xFC, 0x07, 0xF8, 0x09,
  0xF8, 0x09, 0xEC, 0x0C, 0xED, 0x0F, 0xEE, 0x11,
  0xF1, 0x07, 0xFF, 0x14, 0xF5, 0x06, 0xFA, 0x03,
  0x01, 0x09, 0x02, 0xF2, 0xFE, 0xFE, 0x02, 0x01
 },
 {
  0xF9, 0x01, 0xFF, 0xFD, 0xFA, 0x04, 0x04, 0xFD,
  0x03, 0xFF, 0x05, 0xFC, 0x03, 0x02, 0xFF, 0x09,
  0xC5, 0x05, 0xFC, 0x1E, 0x03, 0x03, 0xFE, 0xFD,
  0xFF, 0x02, 0x02, 0x01, 0xFF, 0xFF, 0xFE, 0x01
 },
 {
  0x00, 0xFD, 0x02, 0x00, 0xFF, 0xF8, 0x00, 0x02,
  0xFD, 0x04, 0xFC, 0x01, 0x0A, 0x06, 0xFA, 0x08,
  0xF9, 0x04, 0x0A, 0x0B, 0xD7, 0x1B, 0xEC, 0x03,
  0xFD, 0x08, 0x01, 0x0B, 0xFB, 0xF8, 0x00, 0x04
 },
 {
  0x05, 0x01, 0x04, 0xFE, 0x01, 0x02, 0xFF, 0x06,
  0xF9, 0x02, 0x0B, 0x04, 0x00, 0x00, 0xF8, 0x07,
  0xF6, 0x00, 0x00, 0x08, 0x02, 0x0A, 0xFF, 0x01,
  0xFE, 0x2C, 0xFE, 0xEB, 0xF4, 0xFD, 0xFF, 0x02
 },
 {
  0xFC, 0x04, 0xFE, 0xFE, 0x06, 0xF8, 0x02, 0x01,
  0xF6, 0x0E, 0x08, 0x06, 0x05, 0x01, 0xFE, 0x04,
  0xF3, 0x04, 0x02, 0x05, 0x0A, 0xFE, 0xEB, 0x20,
  0xFD, 0x12, 0x09, 0xFA, 0xF7, 0xF7, 0x0A, 0x02
 },
 {
  0x09, 0xF0, 0xFA, 0xFE, 0x01, 0x04, 0x16, 0x02,
  0xFE, 0x01, 0xFD, 0xFE, 0xF7, 0x03, 0x10, 0x13,
  0xE8, 0xFA, 0xFA, 0xFB, 0xF8, 0xF9, 0x08, 0xF9,
  0xFF, 0xF4, 0x05, 0xFD, 0x00, 0x04, 0x02, 0xFD
 },
 {
  0x0A, 0x03, 0xF0, 0xFC, 0xFF, 0x0D, 0x04, 0x04,
  0x01, 0xFD, 0x01, 0xFA, 0xF2, 0x12, 0x03, 0x08,
  0xF8, 0xE4, 0xF0, 0x04, 0x04, 0x02, 0x0C, 0x07,
  0x09, 0xFC, 0xFC, 0x05, 0xFF, 0xFF, 0x02, 0x02
 },
 {
  0xFB, 0xF3, 0xEA, 0xFD, 0xF8, 0x15, 0xFE, 0xF7,
  0x15, 0xFC, 0xF7, 0x05, 0xF8, 0x0F, 0x05, 0x01,
  0xFB, 0xF7, 0xF9, 0xFE, 0xFB, 0xFB, 0xFF, 0xFB,
  0xFB, 0xFB, 0x03, 0x0A, 0xFC, 0x00, 0xF9, 0xFE
 },
 {
  0x05, 0xF6, 0xEE, 0x02, 0x14, 0x04, 0x0D, 0xF6,
  0x08, 0xF1, 0xF5, 0xFD, 0xFF, 0x10, 0x0A, 0x09,
  0xF8, 0x06, 0x07, 0xFB, 0x06, 0x0B, 0x05, 0x11,
  0xFC, 0x07, 0xF5, 0x05, 0xFD, 0xFA, 0x02, 0x01
 },
 {
  0x03, 0xFB, 0xED, 0x01, 0x01, 0xFD, 0xFE, 0xE7,
  0xF5, 0xEF, 0x00, 0xF3, 0xFC, 0x0A, 0x0A, 0x02,
  0xFB, 0x04, 0x00, 0x03, 0xFD, 0xFB, 0xF6, 0xFE,
  0x0D, 0xEA, 0x00, 0x03, 0xF5, 0xFB, 0x07, 0xFF
 },
 {
  0x0C, 0xF2, 0xE3, 0x06, 0xFF, 0x0A, 0x07, 0xEF,
  0xF4, 0x0E, 0x03, 0x09, 0xF7, 0x09, 0x07, 0x06,
  0xFD, 0xF3, 0x00, 0x05, 0x03, 0xFF, 0xFA, 0xFF,
  0x00, 0x02, 0x04, 0xF4, 0xFB, 0xFF, 0x02, 0x0B
 },
 {
  0x0C, 0xF1, 0xF9, 0xFE, 0xF4, 0x11, 0x14, 0xF0,
  0xFE, 0xF4, 0xFA, 0x0F, 0xFA, 0x0C, 0x0B, 0x09,
  0x07, 0xFA, 0x07, 0xFC, 0xED, 0x06, 0x02, 0x02,
  0x03, 0xF5, 0xF6, 0xFC, 0xFB, 0xFD, 0x03, 0x02
 },
 {
  0x0B, 0xEA, 0xFA, 0x00, 0x08, 0x12, 0x03, 0xF5,
  0xFC, 0xF9, 0xF1, 0xEF, 0xF4, 0x06, 0x10, 0x04,
  0xF7, 0x04, 0xFB, 0x03, 0x06, 0xF0, 0x0A, 0xF9,
  0xF9, 0xFD, 0x05, 0x00, 0x01, 0xF1, 0xFC, 0x05
 },
 {
  0x0C, 0xEA, 0xF0, 0x05, 0xFA, 0x08, 0x0C, 0xFC,
  0xF7, 0xEF, 0xF5, 0x03, 0x05, 0x08, 0xEF, 0x00,
  0x0B, 0xFC, 0xF3, 0xFA, 0x02, 0xFF, 0xFF, 0x03,
  0x03, 0xF5, 0xF4, 0xFF, 0x01, 0x01, 0x0C, 0xFE
 },
 {
  0x08, 0xF6, 0xDF, 0xFB, 0xFD, 0xFA, 0x01, 0xF9,
  0xF8, 0xFC, 0xFA, 0xFF, 0x05, 0xFC, 0xFA, 0xF4,
  0xF0, 0xF8, 0x0B, 0x08, 0xF2, 0x07, 0x0C, 0x0B,
  0x04, 0xF2, 0xFD, 0x06, 0xF9, 0xFB, 0xFD, 0x03
 },
 {
  0x00, 0xF8, 0xF9, 0x02, 0xFC, 0x18, 0x02, 0xF7,
  0xF5, 0xFD, 0xF9, 0x0B, 0xF4, 0x11, 0x01, 0xFF,
  0x03, 0xFB, 0xF9, 0x0C, 0x04, 0x0B, 0x00, 0x03,
  0x02, 0xEE, 0xFD, 0x04, 0x07, 0xFA, 0x03, 0x0F
 },
 {
  0x0A, 0xF1, 0xF0, 0xFE, 0xFC, 0xF7, 0x07, 0xF1,
  0xFA, 0x02, 0xF0, 0x0D, 0xF8, 0x07, 0x13, 0xEB,
  0xFC, 0xF4, 0xF7, 0xFD, 0xFD, 0x06, 0x0B, 0xFD,
  0xFF, 0xED, 0x03, 0xF9, 0xF7, 0xFC, 0x03, 0xFA
 },
 {
  0xFB, 0xF6, 0xEB, 0x00, 0xFD, 0xF9, 0x12, 0xEB,
  0x0F, 0xFB, 0xF4, 0xFC, 0xF3, 0x02, 0x06, 0xF7,
  0xF7, 0xF5, 0xFC, 0x0D, 0xFD, 0x06, 0x04, 0xFF,
  0x07, 0xF7, 0xFC, 0x09, 0x05, 0x02, 0x06, 0x03
 },
 {
  0x0F, 0xFF, 0xE5, 0xFE, 0x0A, 0x03, 0x07, 0xF8,
  0x09, 0xFE, 0x07, 0x01, 0xFE, 0xFB, 0x12, 0x09,
  0xF5, 0xEF, 0xFE, 0x07, 0xF7, 0x0B, 0x0A, 0x00,
  0xF8, 0x06, 0xF0, 0xFD, 0x02, 0xF9, 0x03, 0x0B
 },
 {
  0x04, 0xF7, 0xD9, 0x13, 0x06, 0xF3, 0x0D, 0xFB,
  0xFB, 0xF1, 0xFE, 0x09, 0x00, 0x04, 0x0E, 0x06,
  0xF6, 0xFC, 0xFB, 0x02, 0xFC, 0xFE, 0x05, 0xF5,
  0x03, 0x03, 0xFE, 0xFE, 0xF9, 0x09, 0x07, 0xF6
 },
 {
  0x05, 0xF5, 0xF8, 0x0A, 0xFE, 0x0C, 0x10, 0x00,
  0x0C, 0xFE, 0xFA, 0x08, 0x0E, 0x08, 0x07, 0x01,
  0x12, 0xE2, 0x04, 0x0A, 0xFC, 0xFA, 0x02, 0xF5,
  0x09, 0xF6, 0xF8, 0x05, 0x00, 0x00, 0xF9, 0x06
 },
 {
  0xFF, 0xF0, 0xF6, 0x0B, 0x00, 0x0D, 0x0C, 0xFC,
  0xFC, 0xFB, 0xEB, 0x0C, 0x04, 0x0D, 0x0E, 0xF9,
  0x06, 0xF0, 0xF3, 0x08, 0x02, 0x09, 0x0F, 0xF4,
  0x01, 0xF7, 0xEA, 0x0A, 0xF7, 0x09, 0x09, 0xF9
 },
 {
  0x04, 0xF4, 0xE5, 0x01, 0xFE, 0x0B, 0x0F, 0x03,
  0x0E, 0xF2, 0xF7, 0x00, 0xF7, 0x10, 0x16, 0x0A,
  0x10, 0xF6, 0x05, 0xFB, 0xF7, 0x01, 0x01, 0x06,
  0x06, 0xFC, 0x02, 0xEF, 0xFB, 0xFA, 0xF1, 0xFF
 },
 {
  0x07, 0xF4, 0xEF, 0x01, 0xF7, 0x05, 0x14, 0xF9,
  0x03, 0x17, 0xF8, 0xF8, 0xF8, 0xFF, 0x0D, 0x11,
  0xF9, 0xF3, 0x04, 0xFC, 0x07, 0x0E, 0x08, 0x0B,
  0xFD, 0xFD, 0x04, 0x00, 0x04, 0x06, 0xFF, 0xF7
 },
 {
  0x07, 0xF1, 0xF1, 0xFC, 0x0A, 0x0C, 0x03, 0xF3,
  0x06, 0x0E, 0x09, 0xF8, 0xF1, 0x0E, 0x17, 0xFB,
  0xF6, 0xFB, 0x01, 0x0F, 0xF6, 0xF9, 0x01, 0x09,
  0x04, 0xF3, 0xF6, 0x0A, 0x07, 0xFD, 0x02, 0x03
 },
 {
  0x04, 0xF6, 0xF2, 0x00, 0x03, 0x04, 0x00, 0xF7,
  0xFD, 0xFC, 0xF5, 0x02, 0xEF, 0x08, 0x02, 0x0F,
  0x06, 0xF4, 0xF4, 0x0F, 0xFB, 0x11, 0x12, 0x03,
  0xFD, 0xFD, 0xFC, 0xFA, 0xF8, 0x0D, 0x04, 0x0A
 },
 {
  0xFE, 0xEE, 0xE6, 0x0A, 0xFC, 0x0A, 0x0D, 0x04,
  0xFC, 0xF0, 0xF9, 0xEF, 0xFD, 0x05, 0xFC, 0x02,
  0xF1, 0xF6, 0xFF, 0xF8, 0xF9, 0xFD, 0x02, 0x02,
  0x08, 0xF6, 0xF9, 0x02, 0x02, 0xFC, 0x04, 0xFF
 },
 {
  0x04, 0xED, 0xFB, 0xFF, 0xFF, 0xFA, 0x02, 0xF8,
  0x0A, 0xF0, 0xE4, 0xFA, 0x08, 0xFF, 0x0B, 0x1C,
  0x02, 0xF6, 0xFC, 0x06, 0xFA, 0x06, 0x0B, 0x0F,
  0xFC, 0xFE, 0x07, 0x03, 0x07, 0xF9, 0x04, 0x01
 },
 {
  0xFD, 0xFA, 0xF6, 0xFB, 0x0D, 0x12, 0x0A, 0xF1,
  0xFB, 0xFD, 0xF3, 0x05, 0x01, 0x02, 0x12, 0xFB,
  0xF6, 0xF6, 0xF9, 0x04, 0x02, 0x01, 0x05, 0x04,
  0x02, 0x05, 0x04, 0x08, 0xF7, 0xEF, 0x07, 0x07
 },
 {
  0x14, 0xF4, 0xFE, 0xFC, 0x05, 0x0E, 0x07, 0xF5,
  0xFF, 0xF0, 0xFA, 0xFC, 0xF5, 0x11, 0x0E, 0x00,
  0xF8, 0xF6, 0xF8, 0x0A, 0x03, 0x05, 0x0A, 0xF0,
  0x03, 0xF8, 0xF2, 0x0A, 0x03, 0x09, 0x00, 0x03
 },
 {
  0x0C, 0xF6, 0xDC, 0x00, 0x07, 0x0F, 0x02, 0xF0,
  0x02, 0xFF, 0x00, 0xFF, 0x05, 0x04, 0x05, 0xFD,
  0x01, 0xF6, 0x05, 0xFF, 0xF1, 0xFD, 0xF4, 0x0C,
  0x02, 0x05, 0xFF, 0x05, 0x06, 0xFD, 0xFE, 0x02
 },
 {
  0x11, 0xF1, 0xE1, 0x17, 0xFC, 0x0F, 0xFE, 0xFD,
  0x06, 0xF9, 0xFB, 0x01, 0xF4, 0x04, 0x06, 0x08,
  0xF6, 0x08, 0x03, 0x05, 0xFC, 0x01, 0x05, 0x03,
  0xFF, 0xFC, 0xFD, 0x01, 0x0A, 0xFC, 0xFE, 0xFE
 },
 {
  0x06, 0xEE, 0xFB, 0x0C, 0x0A, 0x0C, 0x0E, 0xF5,
  0x0F, 0x02, 0xF7, 0xFA, 0xFB, 0xFE, 0xF7, 0x04,
  0xFB, 0xE4, 0xFC, 0x0E, 0x00, 0xF0, 0x09, 0x0E,
  0xFF, 0x03, 0xFC, 0xFC, 0x02, 0x01, 0x00, 0x04
 },
 {
  0xFB, 0xF2, 0xE1, 0x08, 0x10, 0x07, 0x0D, 0xF3,
  0x05, 0x06, 0xF0, 0x0A, 0xFB, 0x02, 0xFE, 0x02,
  0x0E, 0xFB, 0x08, 0xFB, 0x07, 0xF0, 0x06, 0xF3,
  0xFB, 0x00, 0xFB, 0x08, 0xFD, 0xFF, 0x04, 0x03
 },
 {
  0x01, 0xFE, 0xFF, 0x00, 0x06, 0x05, 0x02, 0xFC,
  0xFD, 0xFF, 0x00, 0x01, 0x04, 0x02, 0x2B, 0x1C,
  0xF4, 0xDD, 0xFE, 0xFE, 0xF9, 0xFF, 0x00, 0x02,
  0xFF, 0xFE, 0xFE, 0x01, 0xFC, 0x00, 0xFE, 0x03
 },
 {
  0x02, 0xF7, 0xEA, 0x0C, 0x03, 0x03, 0xF9, 0xFC,
  0xED, 0xEA, 0xF2, 0xFC, 0xFF, 0x15, 0x09, 0xFD,
  0xF1, 0xF0, 0xF3, 0x01, 0xF5, 0x04, 0xF7, 0x01,
  0xF9, 0xFF, 0xFF, 0x00, 0xFE, 0x09, 0xF3, 0xFD
 },
 {
  0xFF, 0xFD, 0xE9, 0x00, 0x02, 0x0C, 0x03, 0xF7,
  0xFC, 0x07, 0x03, 0x09, 0xF6, 0x01, 0x1B, 0x1C,
  0x00, 0x09, 0xF1, 0xFE, 0xFE, 0x01, 0x06, 0x08,
  0xF8, 0x07, 0xFD, 0x14, 0x00, 0x00, 0xFF, 0xFA
 },
 {
  0xFF, 0x0B, 0x08, 0xFE, 0x01, 0x05, 0xFA, 0xFF,
  0x04, 0x02, 0xFC, 0x00, 0xFF, 0xFB, 0x04, 0xFA,
  0xF6, 0xF4, 0x13, 0x01, 0xF9, 0x09, 0xF8, 0xF7,
  0xF0, 0xF5, 0xFE, 0x0C, 0x0E, 0x04, 0x04, 0x22
 },
 {
  0x11, 0x07, 0xFA, 0x01, 0x04, 0xF6, 0xFB, 0x04,
  0xF5, 0x03, 0xEE, 0x04, 0x0E, 0xF3, 0xFD, 0x01,
  0x00, 0x00, 0xF5, 0x00, 0x07, 0xEF, 0xFC, 0x04,
  0xF5, 0xFA, 0xF8, 0x12, 0x00, 0x00, 0x00, 0x1A
 },
 {
  0xFA, 0xF9, 0xFF, 0xFF, 0x0B, 0xF8, 0x01, 0x03,
  0x02, 0x0B, 0xFA, 0xFA, 0x0A, 0xFD, 0x01, 0xFD,
  0x07, 0x04, 0xF4, 0xF8, 0x00, 0xF7, 0x08, 0xEA,
  0xFB, 0x00, 0xFA, 0x16, 0xFE, 0x0B, 0xF3, 0x18
 },
 {
  0xFD, 0x04, 0x00, 0x03, 0x09, 0x0A, 0xFF, 0x03,
  0xF7, 0xF4, 0x01, 0xFB, 0x12, 0x00, 0xFD, 0x08,
  0x19, 0x0F, 0xF8, 0x02, 0x02, 0xFE, 0x04, 0x08,
  0x09, 0xFF, 0xFB, 0x0A, 0xFD, 0x01, 0xFF, 0x17
 },
 {
  0xFB, 0x02, 0xF7, 0xFF, 0xFD, 0x00, 0x03, 0xFF,
  0xF6, 0xFC, 0x00, 0xF3, 0x10, 0x09, 0xFF, 0xF2,
  0x02, 0x06, 0xFE, 0xFA, 0xFB, 0xFE, 0xF9, 0x07,
  0x05, 0x03, 0x0B, 0xFE, 0xF2, 0x00, 0xF7, 0x1E
 },
 {
  0x04, 0x06, 0x06, 0x05, 0xFD, 0xFF, 0x04, 0x05,
  0x0A, 0x00, 0x05, 0xFC, 0x07, 0xF5, 0x0E, 0x0E,
  0x07, 0x22, 0xF7, 0x00, 0xF6, 0x16, 0xF9, 0xFF,
  0x07, 0xF7, 0x02, 0xF8, 0x00, 0xF9, 0xFB, 0x1D
 },
 {
  0xFC, 0x03, 0xFF, 0xFC, 0xFD, 0x05, 0x01, 0xFC,
  0x00, 0x02, 0x04, 0x02, 0x01, 0xFF, 0xF6, 0x01,
  0x06, 0xFA, 0xFC, 0x01, 0x04, 0xFD, 0xFD, 0xFB,
  0x00, 0x03, 0x07, 0xF4, 0x00, 0xFE, 0xF6, 0x37
 },
 {
  0x05, 0x09, 0xFF, 0x00, 0x04, 0x09, 0xEB, 0xF7,
  0x04, 0x02, 0x06, 0xF9, 0x0B, 0xF9, 0x01, 0xFB,
  0x00, 0xFC, 0x02, 0xFD, 0xF3, 0xF8, 0x00, 0xF7,
  0xFC, 0x02, 0x10, 0xFE, 0xF1, 0xF9, 0xF5, 0x1F
 },
 {
  0x08, 0x02, 0xFF, 0x00, 0x03, 0xFB, 0xFB, 0x05,
  0x01, 0xFF, 0xF7, 0x01, 0x00, 0xFA, 0xFE, 0xFF,
  0x05, 0x02, 0x00, 0x00, 0x0C, 0x14, 0xED, 0x01,
  0x08, 0xF4, 0xF5, 0x00, 0x06, 0xFB, 0x02, 0x1F
 },
 {
  0xFF, 0xFF, 0xFE, 0x01, 0xFF, 0x03, 0xF7, 0xFB,
  0x08, 0xFE, 0x05, 0xFF, 0x00, 0xFE, 0x04, 0xFE,
  0xFD, 0xF4, 0x00, 0xFE, 0x03, 0x00, 0x09, 0x04,
  0xFF, 0x15, 0xF8, 0x03, 0xFC, 0x09, 0xFA, 0x1E
 },
 {
  0xFC, 0x00, 0xF9, 0x11, 0x0A, 0xF4, 0xFE, 0xF6,
  0xF4, 0xFD, 0x0A, 0x00, 0x0B, 0xFC, 0xF3, 0xFD,
  0x05, 0x06, 0x0A, 0x07, 0xF8, 0x00, 0xF9, 0xF3,
  0x01, 0x00, 0xFE, 0x07, 0xF4, 0x04, 0xFD, 0x18
 },
 {
  0xF3, 0x09, 0x04, 0xFE, 0x02, 0xFC, 0xF2, 0xFF,
  0xFD, 0xFB, 0xF6, 0x04, 0x0D, 0xFE, 0x05, 0x0D,
  0x08, 0x03, 0xFE, 0x01, 0x05, 0xFA, 0x07, 0xEE,
  0xF6, 0x01, 0xFF, 0x05, 0x04, 0x01, 0x00, 0x19
 },
 {
  0xFB, 0xFF, 0x12, 0x0C, 0x08, 0x08, 0xF0, 0xFF,
  0x01, 0x01, 0x01, 0xFC, 0xFB, 0x03, 0x03, 0x04,
  0x04, 0xF5, 0xF4, 0xF0, 0xFA, 0x02, 0x0C, 0xF3,
  0x00, 0x09, 0x07, 0x09, 0xF7, 0x00, 0xF6, 0x18
 },
 {
  0xFC, 0x01, 0xFD, 0x00, 0x02, 0xFC, 0x04, 0x01,
  0x05, 0x00, 0xFD, 0x02, 0xFD, 0xFE, 0x02, 0xFF,
  0x01, 0x04, 0xFF, 0xFE, 0xFE, 0x01, 0xFF, 0xFF,
  0xFC, 0xFF, 0xFC, 0xFE, 0xFA, 0x06, 0x0C, 0x45
 },
 {
  0x08, 0x05, 0x0B, 0x00, 0xF1, 0xFC, 0x0D, 0x06,
  0x00, 0xFC, 0x09, 0x01, 0xFB, 0xFD, 0x0F, 0x00,
  0x01, 0x06, 0xFB, 0x00, 0x01, 0x06, 0x05, 0x08,
  0x00, 0x07, 0x01, 0xFF, 0xFC, 0xF5, 0xF7, 0x29
 },
 {
  0xFC, 0xF7, 0x20, 0xFA, 0x00, 0x07, 0xFC, 0x06,
  0xFA, 0x01, 0xFA, 0xFE, 0x04, 0xF8, 0xFB, 0xFD,
  0xF0, 0xFF, 0xFE, 0xFA, 0x01, 0x0F, 0x00, 0x15,
  0x03, 0xFD, 0xFC, 0x03, 0xF4, 0x10, 0x02, 0x1B
 },
 {
  0xFA, 0xFB, 0x01, 0xF7, 0xFB, 0x03, 0x07, 0xFD,
  0x05, 0x05, 0x0E, 0x0D, 0x14, 0xF9, 0xFF, 0x0C,
  0xFF, 0x0A, 0xF5, 0xF5, 0xF9, 0xFC, 0xF2, 0x07,
  0xF2, 0x0D, 0x16, 0x12, 0xFF, 0x00, 0x0E, 0x1C
 },
 {
  0xF8, 0x03, 0xFE, 0x00, 0x05, 0x06, 0xFF, 0xFC,
  0x01, 0x03, 0xF9, 0x03, 0x01, 0xF1, 0x04, 0xF7,
  0x16, 0xF6, 0xF7, 0xFC, 0x01, 0x08, 0xFC, 0x09,
  0xF1, 0x02, 0xFA, 0xFC, 0xF0, 0x0C, 0xF6, 0x17
 },
 {
  0x00, 0x00, 0x02, 0x00, 0xFF, 0x03, 0xFD, 0xFF,
  0x03, 0xFB, 0x07, 0x01, 0x05, 0xFB, 0xF8, 0x01,
  0x0D, 0xF1, 0xFB, 0xF9, 0x0C, 0xFA, 0xFE, 0x03,
  0x0A, 0xFB, 0xF8, 0x11, 0xFB, 0xF5, 0xF2, 0x17
 },
 {
  0xF9, 0xFC, 0x06, 0xFC, 0x05, 0xFA, 0xFB, 0x02,
  0xFC, 0x0B, 0x09, 0xFC, 0x02, 0xFE, 0xFC, 0x06,
  0x0F, 0x03, 0xFD, 0x12, 0xF1, 0xFE, 0xFA, 0x03,
  0x03, 0xEC, 0x11, 0x0B, 0xFC, 0x02, 0x03, 0x1D
 },
 {
  0x06, 0x01, 0xFA, 0x02, 0x03, 0x00, 0x00, 0xFD,
  0x03, 0x03, 0xFF, 0x03, 0xFC, 0xFA, 0xFA, 0xF9,
  0xFD, 0xFE, 0xF9, 0xFE, 0xFC, 0x05, 0x03, 0xFB,
  0xEC, 0xF3, 0xFC, 0x0A, 0xF2, 0xE3, 0x0E, 0x25
 },
 {
  0x03, 0x04, 0x03, 0xFA, 0xFC, 0x05, 0x00, 0x03,
  0x02, 0x03, 0x00, 0xFE, 0x04, 0x00, 0xFD, 0xFB,
  0xFC, 0x04, 0xFC, 0x04, 0x04, 0x03, 0x01, 0xFC,
  0xFC, 0xF7, 0xF2, 0x14, 0xE2, 0x03, 0xEE, 0x21
 },
 {
  0x00, 0x02, 0x05, 0xFE, 0xFC, 0xFE, 0xFF, 0x02,
  0xFA, 0xFD, 0xFE, 0xFE, 0x02, 0xFB, 0xFF, 0x04,
  0x03, 0x02, 0xFD, 0x00, 0xFF, 0xFF, 0xF6, 0xF9,
  0x02, 0xFC, 0xEE, 0x02, 0xDB, 0xFF, 0x0C, 0x28
 },
 {
  0xF9, 0x02, 0xFF, 0x00, 0xFE, 0x04, 0xF8, 0x01,
  0xFC, 0x0C, 0x07, 0x04, 0x0F, 0xF9, 0x01, 0xF7,
  0x12, 0x00, 0x0C, 0xEF, 0xFD, 0xFF, 0x00, 0x00,
  0x00, 0x02, 0xFA, 0x00, 0xFC, 0xFD, 0xFF, 0x1A
 },
 {
  0xFA, 0x04, 0x08, 0xFB, 0xFA, 0xFE, 0x02, 0xFF,
  0x01, 0xFF, 0xF1, 0x08, 0x07, 0xFF, 0xEF, 0xFC,
  0x01, 0x05, 0x06, 0xF5, 0xFA, 0x0E, 0x11, 0xFB,
  0xF1, 0x0B, 0x08, 0x00, 0xFD, 0xF1, 0xFA, 0x1C
 },
 {
  0xFF, 0x00, 0x00, 0x00, 0x01, 0x00, 0xFF, 0x00,
  0x01, 0x03, 0x02, 0xFE, 0x03, 0xFF, 0xFF, 0x02,
  0x02, 0xFF, 0xFF, 0xF9, 0x01, 0x02, 0xF7, 0x00,
  0xFF, 0xFC, 0xEE, 0x07, 0xF6, 0x31, 0xF3, 0x20
 },
 {
  0xFF, 0xFD, 0x04, 0x01, 0x02, 0xFB, 0x01, 0xF9,
  0xFF, 0x05, 0xF7, 0x04, 0x04, 0x19, 0x01, 0xFF,
  0x02, 0xFB, 0x02, 0xF9, 0x11, 0xFE, 0x0A, 0xFB,
  0x00, 0x02, 0xF1, 0x03, 0xF7, 0x07, 0xF7, 0x1E
 },
 {
  0xFB, 0xFF, 0x00, 0x02, 0x01, 0xFF, 0x02, 0x05,
  0xDF, 0x03, 0xFB, 0x0E, 0x0B, 0x07, 0x05, 0xFD,
  0x02, 0xF8, 0xFC, 0xFE, 0xF9, 0xFA, 0x04, 0xF8,
  0xFF, 0xF8, 0x02, 0xFE, 0xF8, 0xFF, 0xFC, 0x1B
 },
 {
  0xFF, 0x00, 0xFF, 0xFE, 0x01, 0xFF, 0xFE, 0xFF,
  0x02, 0x00, 0x01, 0x02, 0x02, 0x04, 0x01, 0x03,
  0x04, 0x02, 0x01, 0xF9, 0xFC, 0x01, 0xFD, 0xFC,
  0xDD, 0xE7, 0x11, 0x0A, 0xFD, 0xE6, 0xF9, 0x20
 },
 {
  0xFB, 0x01, 0x06, 0xFE, 0x06, 0x06, 0xF7, 0x03,
  0xFF, 0xFC, 0x05, 0xFC, 0xFE, 0xFE, 0xF7, 0x02,
  0xFB, 0x02, 0x02, 0x04, 0x03, 0x05, 0xFB, 0xF0,
  0xE1, 0xF4, 0xF5, 0x02, 0xED, 0x14, 0xFE, 0x15
 },
 {
  0xFB, 0x02, 0x07, 0xF9, 0xF9, 0x05, 0xF9, 0x02,
  0x00, 0x00, 0xFC, 0x03, 0xFF, 0x00, 0xFF, 0xFE,
  0x00, 0xFD, 0x05, 0xF5, 0xF8, 0xFD, 0xF9, 0xF9,
  0x1C, 0xF5, 0xF9, 0x00, 0xF0, 0xF5, 0xFC, 0x1D
 },
 {
  0x02, 0x01, 0xFD, 0xFE, 0xFF, 0x03, 0x04, 0x00,
  0x01, 0x00, 0xFF, 0xFB, 0x04, 0xFB, 0xF4, 0x02,
  0xFE, 0xFB, 0xEA, 0xFE, 0xFF, 0x0B, 0x08, 0xF9,
  0xF4, 0x00, 0xDE, 0x06, 0xFB, 0x0B, 0xF8, 0x13
 },
 {
  0xFF, 0xFD, 0x05, 0x0B, 0x12, 0xFE, 0xFE, 0xFB,
  0xFE, 0x04, 0xFF, 0x08, 0x05, 0xFA, 0x01, 0xFF,
  0x02, 0x08, 0x04, 0xFB, 0xF8, 0xFE, 0x05, 0xEE,
  0x07, 0x0C, 0x07, 0x13, 0xEE, 0x02, 0xFA, 0xF3
 },
 {
  0x09, 0x00, 0x00, 0x05, 0x04, 0x03, 0xFA, 0x04,
  0x01, 0xFC, 0x05, 0xFF, 0xFC, 0x08, 0x08, 0x06,
  0xF8, 0xFA, 0x00, 0x06, 0xFD, 0x03, 0x05, 0xFD,
  0x11, 0x1F, 0x10, 0x0A, 0xF3, 0x00, 0xF7, 0xED
 },
 {
  0x0C, 0xF6, 0x02, 0xFE, 0xFE, 0xFF, 0xFD, 0x06,
  0xF4, 0xFB, 0xFE, 0x0E, 0xF0, 0x04, 0x0C, 0x0C,
  0x11, 0x04, 0x07, 0xF0, 0x07, 0xFA, 0x0B, 0x07,
  0x07, 0x02, 0xE7, 0x17, 0xE8, 0x05, 0xF9, 0xF7
 },
 {
  0x0A, 0x04, 0x0D, 0x0A, 0x0A, 0x03, 0xFA, 0x03,
  0x03, 0x02, 0xFF, 0xFA, 0x08, 0x04, 0x0A, 0x00,
  0x01, 0x02, 0xFC, 0x02, 0xFD, 0xF8, 0x00, 0xFF,
  0x09, 0x09, 0xF6, 0xFD, 0xE3, 0x01, 0xFF, 0xE5
 },
 {
  0x02, 0x02, 0x00, 0x07, 0x09, 0xFE, 0xF6, 0xFF,
  0xFF, 0x01, 0xF7, 0xFB, 0x08, 0x04, 0x01, 0x02,
  0xF6, 0x01, 0x0D, 0x0C, 0xFD, 0x0F, 0xF7, 0x02,
  0xF9, 0x01, 0xF6, 0x17, 0xEC, 0xEE, 0xF7, 0xF1
 },
 {
  0xFD, 0xFB, 0xFF, 0x08, 0x00, 0xFB, 0xFF, 0x04,
  0x07, 0xFF, 0xF9, 0x02, 0xF8, 0xFB, 0x0B, 0x07,
  0xFA, 0x03, 0xFD, 0xF7, 0x07, 0x09, 0xEA, 0x01,
  0x06, 0xFC, 0x0E, 0x1B, 0xE7, 0xF2, 0x03, 0xFB
 },
 {
  0x01, 0x03, 0x08, 0x04, 0x07, 0x06, 0x0C, 0xEF,
  0xF1, 0x01, 0xF8, 0xF6, 0x07, 0xF2, 0xF8, 0x06,
  0xFE, 0xFE, 0xF5, 0xF5, 0xF9, 0x0D, 0xFE, 0xFE,
  0x04, 0x05, 0xFB, 0x0D, 0xE9, 0xFA, 0xEF, 0xF8
 },
 {
  0xFB, 0x04, 0xF2, 0xFB, 0xFC, 0xFB, 0x06, 0x05,
  0xF8, 0xFB, 0xFE, 0xF5, 0xF9, 0xF4, 0x03, 0xF5,
  0x02, 0xFA, 0x04, 0xF6, 0xFB, 0xF9, 0x0E, 0x05,
  0x17, 0x0B, 0x07, 0x0C, 0xF0, 0xFA, 0xFC, 0xF0
 },
 {
  0x05, 0x06, 0x02, 0x05, 0xFE, 0xFB, 0xFB, 0xFA,
  0xFB, 0xED, 0xF3, 0xFF, 0xFD, 0xF3, 0x05, 0x00,
  0x06, 0xFE, 0xFE, 0xFA, 0xF9, 0xF9, 0xFF, 0xF7,
  0x04, 0x0E, 0x11, 0xF4, 0xE5, 0x03, 0x00, 0xFF
 },
 {
  0x07, 0xFF, 0x09, 0xF6, 0x08, 0x02, 0xF9, 0xFE,
  0x05, 0x02, 0xFD, 0xF9, 0x03, 0x00, 0x06, 0x04,
  0x0C, 0x05, 0x0B, 0x0E, 0xF3, 0xFF, 0x08, 0x01,
  0x0D, 0x09, 0x0C, 0x0C, 0xEE, 0xF2, 0xF5, 0xF0
 },
 {
  0xF9, 0xFB, 0xFA, 0xFB, 0x00, 0xFF, 0xFD, 0x02,
  0x02, 0x01, 0x04, 0x09, 0x02, 0x03, 0x05, 0xFE,
  0x02, 0x01, 0x08, 0x00, 0x03, 0x00, 0xFE, 0x02,
  0x01, 0x07, 0x1D, 0x00, 0xDC, 0xFB, 0xF7, 0xEB
 },
 {
  0x0E, 0xFA, 0xF7, 0x00, 0xFF, 0xF8, 0xF8, 0xF5,
  0x02, 0x02, 0xF7, 0xF4, 0x0C, 0xFC, 0x05, 0x03,
  0xFB, 0xF7, 0x0B, 0xFF, 0xFD, 0x0C, 0xEB, 0xFD,
  0x0C, 0x05, 0x03, 0x0B, 0xEE, 0xF1, 0x01, 0xFE
 },
 {
  0xFF, 0x03, 0xF7, 0xFD, 0x07, 0xF9, 0xEE, 0x02,
  0x04, 0x0C, 0xF6, 0x02, 0x08, 0xFD, 0xF2, 0x0D,
  0x11, 0xFB, 0x05, 0xF7, 0x0D, 0xFD, 0xF9, 0xEE,
  0x11, 0xFE, 0x05, 0x07, 0xEC, 0xFD, 0xFA, 0xF5
 },
 {
  0xFD, 0x03, 0x03, 0xFF, 0x01, 0xFA, 0xFB, 0x01,
  0x05, 0xFD, 0xF2, 0xFA, 0xFB, 0xF8, 0x0E, 0xFA,
  0x07, 0xFF, 0x05, 0x01, 0x0F, 0xFF, 0xF9, 0xFC,
  0x06, 0xF5, 0x09, 0xFE, 0xDB, 0x10, 0xF9, 0xFD
 },
 {
  0xFF, 0x00, 0x06, 0x01, 0xFD, 0xF7, 0x00, 0x0B,
  0xF8, 0x02, 0xFE, 0x00, 0x05, 0x02, 0x0C, 0xF6,
  0x0A, 0x0D, 0x02, 0x07, 0xFA, 0x02, 0xF6, 0xF6,
  0x15, 0xFB, 0x05, 0x05, 0xF4, 0xE9, 0x03, 0xF2
 },
 {
  0x06, 0x00, 0xFE, 0x01, 0x00, 0x01, 0x00, 0xFC,
  0x01, 0x01, 0x08, 0xFE, 0x02, 0xFB, 0xFE, 0x01,
  0x08, 0xFC, 0xFF, 0xFF, 0x04, 0xFF, 0x02, 0x06,
  0x20, 0x01, 0xFB, 0xEC, 0xD8, 0xFC, 0xEE, 0xF2
 },
 {
  0x02, 0x02, 0xF9, 0xFE, 0x04, 0x04, 0xFF, 0x02,
  0x00, 0xFE, 0xFC, 0xF9, 0x03, 0x05, 0x00, 0xFB,
  0x01, 0x02, 0xFA, 0x04, 0xFF, 0xFE, 0xFF, 0xF1,
  0x08, 0x03, 0x09, 0x2E, 0xF9, 0xEE, 0x06, 0xF5
 },
 {
  0x05, 0x05, 0x10, 0x15, 0x03, 0xF5, 0xFC, 0x0B,
  0xF4, 0x02, 0x04, 0xF4, 0xFF, 0x0B, 0x08, 0x01,
  0xFC, 0x0B, 0xF5, 0xEB, 0x01, 0x01, 0xF5, 0x03,
  0x0D, 0x01, 0x05, 0x0C, 0xE7, 0x01, 0xFD, 0xFE
 },
 {
  0x01, 0x06, 0xF9, 0x04, 0x02, 0x03, 0x01, 0xFB,
  0x08, 0x09, 0xF1, 0x03, 0xFD, 0xF2, 0x11, 0x04,
  0xF8, 0x0E, 0xFE, 0xF8, 0xFC, 0x05, 0x08, 0xF9,
  0x08, 0x09, 0x07, 0x06, 0xE3, 0xEF, 0x08, 0x04
 },
 {
  0xF9, 0xF9, 0x04, 0x00, 0x0D, 0x01, 0x00, 0x04,
  0x04, 0xF0, 0xF6, 0xF9, 0x05, 0x09, 0xF1, 0xF6,
  0xF6, 0x08, 0xFC, 0xFF, 0xF5, 0xFF, 0xF6, 0xF1,
  0x03, 0x03, 0x0E, 0x0A, 0xED, 0x02, 0xEE, 0xF4
 },
 {
  0xFC, 0x00, 0x02, 0x00, 0x05, 0xFE, 0xF7, 0x00,
  0x04, 0xFC, 0x02, 0xFF, 0xFE, 0x02, 0xFC, 0x09,
  0x02, 0xFA, 0xFC, 0xFE, 0xFF, 0xFD, 0xFD, 0xFF,
  0x02, 0x05, 0xFF, 0x0B, 0xE8, 0xD4, 0xF7, 0xF1
 },
 {
  0xFF, 0xF6, 0x06, 0x15, 0x0B, 0x0F, 0xF9, 0x0A,
  0xF2, 0xF7, 0xF8, 0xF8, 0x04, 0x06, 0x13, 0x01,
  0xFA, 0x01, 0xFB, 0xEF, 0xF8, 0xF6, 0x09, 0x05,
  0x0B, 0x12, 0xFF, 0x0A, 0xF0, 0xF9, 0xF7, 0xF8
 },
 {
  0x03, 0xFB, 0x00, 0x00, 0xFE, 0xFE, 0xFA, 0x04,
  0xFC, 0x01, 0xFF, 0x00, 0x07, 0xFD, 0x04, 0xFC,
  0xF9, 0x07, 0x11, 0xEC, 0x06, 0x04, 0x01, 0xFA,
  0xF4, 0x1F, 0x0D, 0x13, 0xF2, 0xF6, 0xF9, 0xFE
 },
 {
  0xFE, 0x06, 0xF6, 0x03, 0x09, 0x06, 0xF2, 0x0F,
  0x02, 0xFB, 0x02, 0xF5, 0x09, 0xF8, 0x04, 0x06,
  0x14, 0xF1, 0xFD, 0xFD, 0xFF, 0x20, 0xEB, 0x06,
  0x01, 0x09, 0x0B, 0x11, 0xED, 0x06, 0xFF, 0xFD
 },
 {
  0x08, 0x0A, 0xFE, 0x00, 0xF8, 0xF0, 0x07, 0x07,
  0x06, 0x0A, 0x04, 0xF2, 0x07, 0xFA, 0x15, 0xF9,
  0x0A, 0x05, 0x05, 0x00, 0xF9, 0x02, 0xFA, 0x00,
  0xF9, 0x0B, 0xF7, 0x0F, 0xEC, 0xF9, 0xF5, 0x02
 },
 {
  0x00, 0xF9, 0x05, 0x02, 0x00, 0xFD, 0xFA, 0xFC,
  0xFE, 0xFF, 0xFC, 0xFB, 0xF3, 0xFF, 0x1B, 0xF7,
  0xFA, 0xF5, 0xF9, 0x01, 0x0B, 0xFC, 0xFC, 0xF2,
  0xFE, 0x0B, 0x06, 0x0A, 0xED, 0xFA, 0xF1, 0x02
 },
 {
  0x00, 0x07, 0xFF, 0x02, 0xF9, 0xF1, 0xFE, 0xFD,
  0x0D, 0xFB, 0xFB, 0x0C, 0x03, 0x00, 0x05, 0xFB,
  0xEA, 0x02, 0x07, 0x16, 0x0D, 0x00, 0xFF, 0x02,
  0x03, 0x02, 0xF9, 0x07, 0xE5, 0xFC, 0xFC, 0xF4
 },
 {
  0x0B, 0x01, 0xF0, 0x06, 0xF1, 0x01, 0x03, 0x02,
  0x00, 0x02, 0xFD, 0x02, 0x05, 0xFE, 0xFB, 0x09,
  0x05, 0xFD, 0x03, 0xFE, 0xF5, 0x03, 0x09, 0x06,
  0x09, 0x03, 0xFF, 0x0C, 0xD7, 0x08, 0xFA, 0x09
 },
 {
  0x03, 0xF9, 0x03, 0x02, 0x05, 0x05, 0x00, 0xFF,
  0x01, 0x03, 0xFB, 0xFE, 0xF3, 0x07, 0xFF, 0xFE,
  0xFE, 0xFA, 0x04, 0xFA, 0x00, 0x02, 0xFE, 0x02,
  0x04, 0x01, 0xFC, 0x01, 0xD1, 0xEB, 0x07, 0xFA
 },
 {
  0x03, 0x10, 0xF9, 0x0D, 0xFC, 0xFE, 0x0A, 0xFD,
  0xFF, 0x12, 0xF3, 0x07, 0xF3, 0xFC, 0x08, 0x04,
  0x08, 0x09, 0xFB, 0x0D, 0x08, 0xFB, 0x03, 0xFA,
  0x07, 0x12, 0xF8, 0x0A, 0xE7, 0xFD, 0xF4, 0xF4
 },
 {
  0x01, 0xFF, 0xFF, 0x00, 0x02, 0x05, 0xFB, 0xFD,
  0x00, 0xFB, 0xFF, 0x00, 0xFC, 0xF8, 0xFE, 0x03,
  0x02, 0xFE, 0xEF, 0xFA, 0xFC, 0x01, 0x21, 0xFA,
  0xEC, 0xFA, 0x08, 0x1F, 0xE6, 0xF8, 0xFF, 0xFC
 },
 {
  0x03, 0xFD, 0xFD, 0x05, 0xFD, 0xFE, 0x01, 0x07,
  0x00, 0x03, 0x06, 0x03, 0x06, 0xFE, 0x09, 0x0F,
  0xF6, 0xFD, 0xF1, 0xFB, 0xFD, 0xFC, 0xFA, 0xE2,
  0x11, 0xF8, 0xFE, 0x02, 0xEC, 0x00, 0xF8, 0xFE
 },
 {
  0xFE, 0xFF, 0xFF, 0xFF, 0x03, 0xFB, 0xFE, 0xFD,
  0x04, 0xFE, 0x00, 0x05, 0x08, 0xFD, 0x01, 0xFC,
  0x01, 0x01, 0xFD, 0x04, 0x04, 0xF2, 0x03, 0x0B,
  0xFB, 0x03, 0xFD, 0x07, 0xFD, 0x0D, 0x17, 0xF0
 },
 {
  0x02, 0xFA, 0x01, 0xFD, 0x05, 0x00, 0xFA, 0xF5,
  0xF9, 0xFC, 0xFF, 0x02, 0xF9, 0xFF, 0xFF, 0x07,
  0x01, 0xFE, 0x06, 0x0C, 0xFA, 0x08, 0xF3, 0x11,
  0x19, 0xE9, 0xED, 0xF9, 0xF4, 0x09, 0x10, 0xEF
 },
 {
  0x09, 0x04, 0x04, 0x04, 0xFD, 0xFF, 0x06, 0xFE,
  0xFD, 0x00, 0x0D, 0xFC, 0xF9, 0x0E, 0x01, 0xF9,
  0x00, 0xFB, 0x03, 0xED, 0xFD, 0x05, 0x03, 0x09,
  0xFF, 0x09, 0xF3, 0x0D, 0xEF, 0x04, 0x15, 0xE6
 },
 {
  0x00, 0xFB, 0x00, 0x00, 0xFC, 0xFB, 0x02, 0xFA,
  0xFC, 0x05, 0xF9, 0x0A, 0x00, 0x02, 0x00, 0xFE,
  0xFE, 0x00, 0x04, 0xFA, 0x07, 0xFE, 0x06, 0x05,
  0xFB, 0x02, 0xF4, 0x01, 0xE3, 0x1D, 0x1B, 0x0C
 },
 {
  0x09, 0xF6, 0xEA, 0x06, 0xFF, 0xFF, 0x09, 0xF2,
  0xF4, 0xFE, 0x01, 0xFF, 0x0A, 0xF5, 0xF0, 0x00,
  0x03, 0x0B, 0x0D, 0xF2, 0xF7, 0xFE, 0xFF, 0x06,
  0x04, 0xF2, 0x00, 0xF6, 0xFE, 0x10, 0x11, 0xF5
 },
 {
  0x02, 0x00, 0xFF, 0xFE, 0x04, 0x03, 0xFA, 0xFE,
  0x01, 0xFF, 0x01, 0x03, 0xFC, 0x01, 0x03, 0xFC,
  0xFF, 0xFF, 0x04, 0xFF, 0x01, 0x00, 0x01, 0x06,
  0xFB, 0xF9, 0x02, 0x01, 0xD1, 0xFD, 0x32, 0xEF
 },
 {
  0x08, 0xFC, 0xF5, 0xF9, 0x0B, 0x0B, 0x0E, 0xF9,
  0x0C, 0xF9, 0x06, 0x02, 0x0D, 0xFA, 0xFD, 0xFE,
  0xF2, 0x06, 0x06, 0x06, 0x00, 0x02, 0xFF, 0x05,
  0xEC, 0x02, 0xFF, 0x04, 0xFB, 0x06, 0x15, 0xF5
 },
 {
  0xFE, 0xF7, 0x03, 0x00, 0xFA, 0x07, 0x08, 0xF8,
  0x01, 0xFD, 0x04, 0x01, 0x05, 0xFE, 0xFD, 0xF9,
  0x04, 0x07, 0xF4, 0xF7, 0xFE, 0x0A, 0xFA, 0x0D,
  0x06, 0x05, 0x14, 0x02, 0xF1, 0x09, 0x1C, 0xF9
 },
 {
  0x00, 0xFB, 0xFA, 0xFA, 0xFA, 0x01, 0xFA, 0x06,
  0xFE, 0x04, 0x08, 0xFD, 0x0C, 0xFF, 0xFC, 0xFE,
  0x06, 0x10, 0xF2, 0x09, 0xF2, 0xFE, 0xF8, 0xE5,
  0xFD, 0x12, 0xFF, 0xF9, 0xFD, 0x08, 0x17, 0xE9
 },
 {
  0x01, 0x04, 0xF7, 0xFF, 0xFB, 0x0A, 0xFE, 0x01,
  0xF5, 0x01, 0xF7, 0x04, 0x07, 0x0E, 0xF7, 0xFE,
  0xFD, 0x02, 0xFB, 0xFF, 0xFA, 0xF6, 0xF9, 0x0B,
  0x14, 0x02, 0x03, 0xED, 0x03, 0x0F, 0x1E, 0xF7
 },
 {
  0x07, 0x02, 0xF2, 0xFC, 0x00, 0xFE, 0x05, 0x02,
  0x05, 0xFE, 0x08, 0xFD, 0xF9, 0x06, 0x06, 0xF5,
  0xF2, 0x01, 0x0A, 0xFF, 0xF9, 0xF8, 0x01, 0x0A,
  0x03, 0xFA, 0xF1, 0xF4, 0xEF, 0x04, 0x1E, 0xFA
 },
 {
  0x04, 0x02, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x00,
  0x02, 0x00, 0x01, 0x06, 0xF9, 0x00, 0x03, 0x04,
  0x04, 0xFC, 0xFE, 0xFB, 0xFE, 0x02, 0xFF, 0xFE,
  0x00, 0xFE, 0xF5, 0xF9, 0xFD, 0x2A, 0x18, 0xF2
 },
 {
  0x04, 0x01, 0x03, 0x02, 0x00, 0xFE, 0xFD, 0xFE,
  0x02, 0xFF, 0x04, 0x0B, 0xFE, 0x02, 0x03, 0xFC,
  0xFB, 0x09, 0x02, 0xFC, 0xF7, 0x05, 0x08, 0xFF,
  0xF9, 0x01, 0x18, 0xF3, 0xE4, 0x14, 0x0F, 0xEA
 },
 {
  0xFD, 0x07, 0x06, 0x03, 0xFE, 0xFB, 0xF6, 0xFE,
  0xFE, 0xFF, 0xFA, 0xFA, 0xFE, 0xF2, 0xF0, 0xFA,
  0xFB, 0x00, 0x12, 0x00, 0x09, 0x01, 0x07, 0xF3,
  0xFB, 0xFA, 0xF7, 0x0B, 0xF1, 0x09, 0x16, 0xF5
 },
 {
  0x09, 0xFE, 0x06, 0x05, 0x02, 0x09, 0xF6, 0x01,
  0x01, 0x05, 0xFC, 0x0C, 0x02, 0x02, 0xF6, 0xF9,
  0xFC, 0xFA, 0x07, 0x09, 0x06, 0x0F, 0x06, 0x06,
  0xF6, 0x0A, 0x05, 0xF3, 0xFB, 0x06, 0x18, 0xF4
 },
 {
  0x01, 0x03, 0xFD, 0xFD, 0x08, 0x01, 0xFA, 0x02,
  0xFB, 0xFD, 0x07, 0x02, 0x0E, 0x06, 0x09, 0xFA,
  0xFB, 0xFC, 0x1B, 0x07, 0xFD, 0x08, 0xFA, 0x03,
  0xF8, 0x08, 0x16, 0xFB, 0xFA, 0xFE, 0x16, 0xEF
 },
 {
  0xFE, 0xFE, 0x03, 0x0A, 0x09, 0x09, 0x0C, 0xF1,
  0xFF, 0xF5, 0xF3, 0x03, 0xFE, 0x01, 0xFD, 0xF5,
  0x07, 0x09, 0x10, 0xFD, 0xF6, 0xFB, 0xFB, 0x01,
  0x08, 0xFD, 0x09, 0x09, 0xFB, 0x03, 0x1F, 0xF4
 },
 {
  0x07, 0xFB, 0x0A, 0xFC, 0xF8, 0x02, 0x10, 0xFE,
  0x0A, 0x0A, 0xFD, 0xFE, 0x03, 0xF8, 0xFD, 0x03,
  0xF3, 0xFA, 0x0F, 0x14, 0xF7, 0xFD, 0xF4, 0x01,
  0xFE, 0xF0, 0x08, 0x08, 0xFF, 0x10, 0x16, 0xFB
 },
 {
  0x05, 0xFD, 0xF1, 0xFE, 0x0C, 0xF8, 0x08, 0xFB,
  0x02, 0xF8, 0x14, 0xEE, 0x0E, 0xFC, 0x03, 0x03,
  0x07, 0xF3, 0xF0, 0x01, 0xF6, 0x07, 0x10, 0x07,
  0x04, 0xF2, 0xFC, 0xFB, 0xF7, 0x08, 0x17, 0xFA
 },
 {
  0x05, 0xFC, 0xFB, 0xFC, 0x01, 0x08, 0x04, 0xF9,
  0xFB, 0x08, 0x0A, 0x06, 0xFA, 0xF6, 0xFE, 0x06,
  0x09, 0xEF, 0xF2, 0x0B, 0x0C, 0xFD, 0xF3, 0xF9,
  0x02, 0x12, 0x03, 0xE7, 0xF0, 0x12, 0x16, 0xFB
 },
 {
  0x05, 0x06, 0xF9, 0xEC, 0xFC, 0x02, 0x08, 0x04,
  0xE8, 0xFC, 0x01, 0x04, 0xFB, 0xFE, 0x01, 0xF6,
  0xFE, 0x09, 0x03, 0xFC, 0xFD, 0xFC, 0xFC, 0xFC,
  0x0A, 0x0A, 0x03, 0x00, 0xFA, 0x19, 0x15, 0xF5
 },
 {
  0x00, 0x07, 0xFF, 0x0E, 0xFA, 0xFC, 0xF6, 0x05,
  0x04, 0x04, 0x04, 0xFB, 0x03, 0x04, 0xFF, 0xF9,
  0x08, 0xED, 0x00, 0x06, 0x02, 0x03, 0xEE, 0xFD,
  0xFA, 0x02, 0x08, 0x0E, 0xE6, 0x16, 0x1B, 0xF3
 },
 {
  0xFE, 0xFA, 0x07, 0xFB, 0x0C, 0xF9, 0x08, 0xFF,
  0x03, 0xFE, 0x04, 0x01, 0x08, 0xFE, 0x00, 0x0E,
  0x06, 0xFB, 0x06, 0xFC, 0xF9, 0x07, 0xEB, 0x08,
  0x01, 0x08, 0xF7, 0xFC, 0xFD, 0x0B, 0x19, 0xF3
 },
 {
  0x04, 0x04, 0xFF, 0xFA, 0x04, 0x09, 0xF8, 0x01,
  0xFD, 0xF6, 0xFE, 0x00, 0x0F, 0xF7, 0xF0, 0x0B,
  0x01, 0x01, 0x06, 0x03, 0xF7, 0xFB, 0x10, 0x1A,
  0x01, 0xF2, 0x01, 0xFD, 0xF2, 0x07, 0x0F, 0xF7
 },
 {
  0xF4, 0xFE, 0xF7, 0xF3, 0x02, 0x06, 0x0E, 0x00,
  0x01, 0x00, 0xFF, 0xF3, 0x00, 0x0A, 0xFF, 0x06,
  0x09, 0xF9, 0x08, 0x08, 0x13, 0x06, 0xFF, 0x09,
  0x0A, 0xFC, 0x01, 0xF9, 0xEA, 0xFE, 0x1D, 0xF9
 },
 {
  0x02, 0x04, 0x0D, 0xF4, 0xF8, 0xFC, 0xFB, 0x0D,
  0x0C, 0xFB, 0xFD, 0xFD, 0xFC, 0x01, 0xFF, 0x0A,
  0x0F, 0xFA, 0xFF, 0xF5, 0xE2, 0x04, 0x0F, 0xFF,
  0x09, 0xF9, 0x00, 0xFE, 0xF9, 0x0A, 0x19, 0xF0
 },
 {
  0x07, 0xF1, 0xF9, 0xF9, 0xFF, 0xFB, 0xFB, 0xF5,
  0xEC, 0x0A, 0x03, 0xF6, 0xFD, 0x05, 0x14, 0xFC,
  0x00, 0xFE, 0xFE, 0x11, 0x02, 0x00, 0xFD, 0x03,
  0x06, 0x05, 0xFF, 0xF4, 0xFD, 0x0F, 0x16, 0xF0
 },
 {
  0x04, 0xFF, 0x03, 0x04, 0xFB, 0x00, 0xFF, 0xFB,
  0xE8, 0xE3, 0x04, 0xF7, 0x01, 0xFD, 0x00, 0x00,
  0x00, 0xFC, 0x07, 0xFC, 0xFC, 0xFC, 0x03, 0x01,
  0xFA, 0x05, 0xFD, 0xFB, 0xF6, 0x03, 0x19, 0xF6
 },
 {
  0xFE, 0xFF, 0xFF, 0x04, 0x04, 0xFF, 0x02, 0x00,
  0xFC, 0xFC, 0x02, 0xFF, 0xFD, 0xFF, 0xFE, 0xFE,
  0x01, 0xFD, 0xFB, 0xFF, 0x02, 0xFD, 0xFC, 0xFC,
  0xFD, 0x05, 0xF7, 0x01, 0xF5, 0x07, 0x2E, 0xD2
 },
 {
  0x00, 0xF7, 0x03, 0x04, 0x04, 0x03, 0xFB, 0xFA,
  0x05, 0xFC, 0x04, 0xFE, 0x01, 0x07, 0xFC, 0xF6,
  0x0D, 0x01, 0x03, 0xFA, 0x04, 0xFC, 0x07, 0x02,
  0xED, 0xE7, 0xFD, 0xF0, 0xF4, 0x10, 0x14, 0xFF
 },
 {
  0x12, 0x06, 0x04, 0xF4, 0x00, 0xF2, 0x09, 0xFA,
  0xFF, 0xFC, 0xFB, 0x02, 0x01, 0x0C, 0x04, 0x02,
  0x07, 0x00, 0x02, 0x05, 0xF5, 0xFB, 0xFE, 0x02,
  0xFC, 0x0A, 0x00, 0xF7, 0xF9, 0x09, 0x19, 0xF8
 },
 {
  0x05, 0x00, 0xFA, 0x05, 0x06, 0x03, 0x03, 0xF6,
  0xFB, 0x01, 0xFF, 0x04, 0x03, 0xF5, 0xF8, 0x05,
  0x04, 0xFB, 0x05, 0xFB, 0xF9, 0xFB, 0x0B, 0x05,
  0x14, 0xF8, 0xF0, 0x15, 0xFC, 0x1B, 0x17, 0xFB
 }
};

static const unsigned int s_CosMod[ 544 ] __attribute__(   (  section( ".data" ), aligned( 16 )  )   ) = {
 0x3F7FB10F, 0x3F7D3AAC, 0x3F7853F8, 0x3F710908, 0x3F7D3AAC, 0x3F676BD7, 0x3F3DAEF8, 0x3F039C3B, 0x3F7853F8, 0x3F3DAEF8, 0x3EAC7CD0, 0xBE16408F, 0x3F710908, 0x3F039C3B, 0xBE16408F, 0xBF3DAEFC,
 0x3F676BD7, 0x3E78CFC3, 0xBF187FC3, 0xBF7FB10F, 0x3F5B941A, 0xBD48FB5D, 0xBF676BDA, 0xBF4D9EFE, 0x3F4D9F02, 0xBEAC7CDA, 0xBF7FB10F, 0xBE78CFAE, 0x3F3DAEF8, 0xBF187FC3, 0xBF5B9417, 0x3EDAE891,
 0x3F2BEB49, 0xBF4D9F05, 0xBF039C37, 0x3F676BDC, 0x3F187FBF, 0xBF71090A, 0xBD48FAAE, 0x3F7853F5, 0x3F039C3B, 0xBF7FB10F, 0x3EDAE891, 0x3F187FB6, 0x3EDAE87D, 0xBF7853F6, 0x3F4D9F08, 0xBD48FC0B,
 0x3EAC7CD0, 0xBF5B9417, 0x3F7D3AAE, 0xBF2BEB55, 0x3E78CFC3, 0xBF2BEB45, 0x3F710904, 0xBF7D3AAE, 0x3E16407A, 0xBEDAE873, 0x3F2BEB40, 0xBF5B9411, 0x3D48FB05, 0xBE164064, 0x3E78CF98, 0xBEAC7CB1,
 0x3F800000, 0x3F800000, 0x3F800000, 0x3F800000, 0x3F7EC46D, 0x3F74FA0B, 0x3F61C597, 0x3F45E403, 0x3F7B14BE, 0x3F54DB31, 0x3F0E39D8, 0x3E47C5B9, 0x3F74FA0B, 0x3F226798, 0x3DC8BD21, 0xBEF15AF0,
 0x3F6C835E, 0x3EC3EF11, 0xBEC3EF1C, 0xBF6C8360, 0x3F61C597, 0x3DC8BD21, 0xBF45E406, 0xBF74FA09, 0x3F54DB31, 0xBE47C5CE, 0xBF7B14BF, 0xBF0E39D4, 0x3F45E403, 0xBEF15AF0, 0xBF74FA09, 0x3DC8BD79,
 0x3F3504F2, 0xBF3504F6, 0xBF3504EE, 0x3F3504FA, 0x3F226798, 0xBF61C59A, 0xBE94A023, 0x3F7EC46E, 0x3F0E39D8, 0xBF7B14BF, 0x3E47C5E3, 0x3F54DB2B, 0x3EF15AE6, 0xBF7EC46D, 0x3F2267A0, 0x3E94A018,
 0x3EC3EF11, 0xBF6C835C, 0x3F6C8362, 0xBEC3EF30, 0x3E94A02D, 0xBF45E3FF, 0x3F7EC46C, 0xBF61C59F, 0x3E47C5B9, 0xBF0E39D4, 0x3F54DB2B, 0xBF7B14BB, 0x3DC8BD21, 0xBE94A023, 0x3EF15AD3, 0xBF22678B,
 0x3E0009DF, 0x3E005907, 0x3E00F84C, 0x3E01E9A1, 0xC0A2FDB3, 0xBFD97EFA, 0xBF82B521, 0xBF3B2D1B, 0x3F676BD7, 0x3F5B941A, 0x3F4D9F02, 0x3F3DAEF8, 0x3E78CFC3, 0xBD48FB5D, 0xBEAC7CDA, 0xBF187FC3,
 0xBF187FC3, 0xBF676BDA, 0xBF7FB10F, 0xBF5B9417, 0xBF7FB10F, 0xBF4D9EFE, 0xBE78CFAE, 0x3EDAE891, 0xBF2BEB45, 0x3E1640A5, 0x3F5B941F, 0x3F710904, 0x3E1640A5, 0x3F71090C, 0x3F3DAEF1, 0xBE78D003,
 0x3F5B941F, 0x3F3DAEF1, 0xBEDAE89A, 0xBF7D3AAA, 0x3F710904, 0xBE78D003, 0xBF7D3AAA, 0x3D48FC63, 0x3EAC7CBB, 0xBF7853FC, 0xBE164039, 0x3F7FB110, 0xBF039C49, 0xBF2BEB3C, 0x3F676BE1, 0x3E164023,
 0xBF7D3AAE, 0x3EAC7CF9, 0x3F2BEB38, 0xBF7853FE, 0xBF3DAEED, 0x3F7D3AAF, 0xBF039C53, 0xBEAC7C9C, 0x3D48FC63, 0x3F187FAD, 0xBF7853F1, 0x3F676BE5, 0x3F4D9F0F, 0xBEDAE8AE, 0xBD48F950, 0x3F039C1F,
 0x3F7853F2, 0xBF7FB110, 0x3F710913, 0xBF4D9F18, 0x3EDAE855, 0xBF039C24, 0x3F187FA4, 0xBF2BEB2C, 0x3F800000, 0x3F800000, 0x3F800000, 0x3F800000, 0x3F226798, 0x3EF15AE6, 0x3E94A02D, 0x3DC8BD21,
 0xBE47C5CE, 0xBF0E39DD, 0xBF54DB34, 0xBF7B14BF, 0xBF61C59A, 0xBF7EC46D, 0xBF45E3FF, 0xBE94A023, 0xBF6C835C, 0xBEC3EF07, 0x3EC3EF26, 0x3F6C8362, 0xBE94A023, 0x3F2267A0, 0x3F7EC46C, 0x3EF15AD3,
 0x3F0E39E1, 0x3F7B14BC, 0x3E47C58E, 0xBF54DB3A, 0x3F7EC46E, 0x3E94A018, 0xBF61C59F, 0xBF22678B, 0x3F3504EB, 0xBF3504FE, 0xBF3504E7, 0x3F350502, 0xBDC8BDA4, 0xBF74FA06, 0x3EF15B0D, 0x3F45E3F5,
 0xBF54DB3A, 0xBE47C578, 0x3F7B14BA, 0xBF0E39EF, 0xBF74FA06, 0x3F45E410, 0x3DC8BC73, 0xBF61C58A, 0xBEC3EEF3, 0x3F6C8356, 0xBF6C8369, 0x3EC3EF4E, 0x3EF15B0D, 0x3DC8BC73, 0xBF226783, 0x3F74FA01,
 0x3F7B14C3, 0xBF54DB40, 0x3F0E39F4, 0xBE47C64F, 0x3F45E3F5, 0xBF61C58A, 0x3F74FA01, 0xBF7EC469, 0x3E033005, 0x3E04CF99, 0x3E06CDC5, 0x3E093163, 0xBF120D1B, 0xBEEFF560, 0xBECC0747, 0xBEB1D461,
 0x3F2BEB49, 0x3F187FBF, 0x3F039C3B, 0x3EDAE87D, 0xBF4D9F05, 0xBF71090A, 0xBF7FB10F, 0xBF7853F6, 0xBF039C37, 0xBD48FAAE, 0x3EDAE891, 0x3F4D9F08, 0x3F676BDC, 0x3F7853F5, 0x3F187FB6, 0xBD48FC0B,
 0x3EAC7CBB, 0xBF039C49, 0xBF7D3AAE, 0xBF3DAEED, 0xBF7853FC, 0xBF2BEB3C, 0x3EAC7CF9, 0x3F7D3AAF, 0xBE164039, 0x3F676BE1, 0x3F2BEB38, 0xBF039C53, 0x3F7FB110, 0x3E164023, 0xBF7853FE, 0xBEAC7C9C,
 0xBD48FCBA, 0xBF7D3AA8, 0x3E78D042, 0x3F7108FD, 0xBF7D3AA8, 0x3EDAE8B8, 0x3F3DAEE2, 0xBF5B942D, 0x3E78D042, 0x3F3DAEE2, 0xBF710915, 0x3E164127, 0x3F7108FD, 0xBF5B942D, 0x3E164127, 0x3F2BEB28,
 0xBEDAE8C2, 0xBE78CF2E, 0x3F4D9EE8, 0xBF7FB112, 0xBF5B9406, 0x3F7FB10D, 0xBF676BEC, 0x3F187FEB, 0x3F187FE2, 0xBEAC7D2C, 0x3D48FE6F, 0x3E78CEEF, 0x3F3DAEDB, 0xBF4D9EE4, 0x3F5B93FE, 0xBF676BBE,
 0x3F800000, 0x3F800000, 0x3F800000, 0x3F800000, 0xBDC8BD4D, 0xBE94A038, 0xBEF15AF0, 0xBF22679C, 0xBF7B14BD, 0xBF54DB2E, 0xBF0E39D4, 0xBE47C5A3, 0x3E94A042, 0x3F45E40A, 0x3F7EC46E, 0x3F61C592,
 0x3F6C835A, 0x3EC3EEFD, 0xBEC3EF30, 0xBF6C8364, 0xBEF15B03, 0xBF7EC46F, 0xBF22678B, 0x3E94A057, 0xBF54DB28, 0x3E47C60E, 0x3F7B14C3, 0x3F0E39C6, 0x3F2267A9, 0x3F61C58D, 0xBE94A062, 0xBF7EC46A,
 0x3F3504E3, 0xBF350506, 0xBF3504DF, 0x3F350509, 0xBF45E414, 0xBEF15AB6, 0x3F74FA14, 0x3DC8BC1C, 0xBF0E39C2, 0x3F7B14C5, 0xBE47C64F, 0xBF54DB1B, 0x3F61C5A7, 0xBDC8BE52, 0xBF45E3EA, 0x3F74FA17,
 0x3EC3EED5, 0xBF6C8350, 0x3F6C836F, 0xBEC3EF6C, 0xBF74FA16, 0x3F2267BA, 0xBDC8BEA9, 0xBEF15A90, 0xBE47C522, 0x3F0E39B4, 0xBF54DB15, 0x3F7B14B4, 0x3F7EC471, 0xBF74FA19, 0x3F61C5B1, 0xBF45E429,
 0x3E0C02FA, 0x3E0F4D13, 0x3E131C9A, 0x3E17816C, 0xBE9DEE3A, 0xBE8E585C, 0xBE81D820, 0xBE6F40DD, 0x3EAC7CD0, 0x3E78CFC3, 0x3E16407A, 0x3D48FB05, 0xBF5B9417, 0xBF2BEB45, 0xBEDAE873, 0xBE164064,
 0x3F7D3AAE, 0x3F710904, 0x3F2BEB40, 0x3E78CF98, 0xBF2BEB55, 0xBF7D3AAE, 0xBF5B9411, 0xBEAC7CB1, 0x3D48FC63, 0x3F4D9F0F, 0x3F7853F2, 0x3EDAE855, 0x3F187FAD, 0xBEDAE8AE, 0xBF7FB110, 0xBF039C24,
 0xBF7853F1, 0xBD48F950, 0x3F710913, 0x3F187FA4, 0x3F676BE5, 0x3F039C1F, 0xBF4D9F18, 0xBF2BEB2C, 0xBEDAE8C2, 0xBF5B9406, 0x3F187FE2, 0x3F3DAEDB, 0xBE78CF2E, 0x3F7FB10D, 0xBEAC7D2C, 0xBF4D9EE4,
 0x3F4D9EE8, 0xBF676BEC, 0x3D48FE6F, 0x3F5B93FE, 0xBF7FB112, 0x3F187FEB, 0x3E78CEEF, 0xBF676BBE, 0x3F3DAF1D, 0xBE164168, 0xBF039C08, 0x3F7108F2, 0xBE164168, 0xBEAC7C5E, 0x3F3DAECC, 0xBF7853E6,
 0xBF039C08, 0x3F3DAECC, 0xBF676BB9, 0x3F7D3AA1, 0x3F7108F2, 0xBF7853E6, 0x3F7D3AA1, 0xBF7FB10B, 0x3F800000, 0x3F800000, 0x3F800000, 0x3F800000, 0xBF45E406, 0xBF61C59A, 0xBF74FA0C, 0xBF7EC46E,
 0x3E47C5E3, 0x3F0E39E1, 0x3F54DB37, 0x3F7B14C1, 0x3EF15AD3, 0xBDC8BDA4, 0xBF2267A5, 0xBF74FA0F, 0xBF6C8358, 0xBEC3EEF3, 0x3EC3EF3A, 0x3F6C8367, 0x3F74FA11, 0x3F45E3F5, 0xBDC8BDFB, 0xBF61C5A4,
 0xBF0E39EF, 0xBF7B14B9, 0xBE47C54D, 0x3F54DB43, 0xBDC8BC48, 0x3F74FA14, 0x3EF15AAD, 0xBF45E41B, 0x3F3504DB, 0xBF35050D, 0xBF3504D7, 0x3F350511, 0xBF7EC469, 0x3E94A081, 0x3F61C583, 0xBF2267BE,
 0x3F54DB49, 0x3E47C50D, 0xBF7B14B5, 0x3F0E3A06, 0xBE94A08B, 0xBF226772, 0x3F7EC472, 0xBEF15B51, 0xBEC3EEB7, 0x3F6C8349, 0xBF6C8375, 0x3EC3EF8B, 0x3F61C57D, 0xBF7EC473, 0x3F45E42C, 0xBE94A0B5,
 0xBF7B14CA, 0x3F54DB55, 0xBF0E3A13, 0x3E47C6E5, 0x3F2267CB, 0xBEF15B64, 0x3E94A0C0, 0xBDC8BFAE, 0x3E1C8F06, 0x3E225D7C, 0x3E290AB9, 0x3E30BC3B, 0xBE5E4BD6, 0xBE500D3D, 0xBE43F76C, 0xBE39A17F
};

static dts_state_t s_DTSCtx __attribute__(   (  aligned( 64 )  )   );

static int ( *DecodeFrame ) ( SMS_RingBuffer*, int, int );

static int _dts_decode ( SMS_RingBuffer*, int, int );
static int _dts_spdif  ( SMS_RingBuffer*, int, int );

static int32_t DTS_Init    ( SMS_CodecContext*                                   );
static int32_t DTS_Decode  ( SMS_CodecContext*, SMS_RingBuffer*, SMS_RingBuffer* );
static void    DTS_Destroy ( SMS_CodecContext*                                   );

void SMS_Codec_DTS_Open ( SMS_CodecContext* apCtx ) {

 apCtx -> m_pCodec = calloc (  1, sizeof ( SMS_Codec )  );

 apCtx -> m_pCodec -> m_pName = "dts";
 apCtx -> m_pCodec -> m_pCtx  = &s_DTSCtx;
 apCtx -> m_pCodec -> Init    = DTS_Init;
 apCtx -> m_pCodec -> Decode  = DTS_Decode;
 apCtx -> m_pCodec -> Destroy = DTS_Destroy;

 if (  !( g_Config.m_PlayerFlags & SMS_PF_SPDIF )  )
  DecodeFrame = _dts_decode;
 else DecodeFrame = _dts_spdif;

}  /* end SMS_Codec_DTS_Open */

static int32_t DTS_Init ( SMS_CodecContext* apCtx ) {

 memset (  &s_DTSCtx, 0, sizeof ( s_DTSCtx )  );

 s_DTSCtx.m_pInBuf = s_DTSCtx.m_InBuf;

 return 0;

}  /* end DTS_Init */

static void DTS_Destroy ( SMS_CodecContext* apCtx ) {

}  /* end DTS_Destroy */

static unsigned int inline swable32 ( unsigned int aX ) {
 return ( aX << 16 ) | ( aX >> 16 );
}  /* end swable32 */

static inline unsigned int bitstream_fill_current ( dts_state_t* state ) {

 unsigned int lTmp = *state -> buffer_start++;

 if ( state -> bigendian_mode )
  lTmp = SMS_bswap32 ( lTmp );
 else lTmp = swable32 ( lTmp );

 if ( !state -> word_mode ) {
  lTmp = ( lTmp & 0x00003FFF ) | (  ( lTmp & 0x3FFF0000 ) >> 2  );
 }  /* end if */

 return state -> current_word = lTmp;

}  /* end bitstream_fill_current */

static unsigned int _dts_bitstream_get ( dts_state_t* state, unsigned int num_bits ) {

 unsigned int retVal, lWord;

 num_bits -= state -> bits_left;
 retVal    = ( state -> current_word << ( 32 - state -> bits_left )  ) >> ( 32 - state -> bits_left );

 if ( !state -> word_mode && num_bits > 28 ) {
  retVal    = ( retVal << 28 ) | bitstream_fill_current ( state );
  num_bits -= 28;
 }  /* end if */

 lWord = bitstream_fill_current ( state );

 if ( state -> word_mode ) {
  if ( num_bits != 0 )
   retVal = ( retVal << num_bits ) | (  lWord >> ( 32 - num_bits )  );
  state -> bits_left = 32 - num_bits;
 } else {
  if ( num_bits != 0 )
   retVal = ( retVal << num_bits ) | (  lWord >> ( 28 - num_bits )  );
  state -> bits_left = 28 - num_bits;
 }  /* end else */

 return retVal;

}  /* end _dts_bitstream_get */

static inline unsigned int bitstream_get ( dts_state_t* state, unsigned int num_bits ) {

 unsigned int result;

 if ( num_bits < state -> bits_left ) {
  result = (  state -> current_word << ( 32 - state -> bits_left )  ) >> ( 32 - num_bits );
  state -> bits_left -= num_bits;
  return result;
 }  /* end if */

 return _dts_bitstream_get ( state, num_bits );

}  /* end bitstream_get */

static void _dts_bitstream_init (
             unsigned char* buf, int word_mode, int bigendian_mode
            ) {

 unsigned int align;
 dts_state_t* state = &s_DTSCtx;

 align = ( unsigned int )buf & 3;
 state -> buffer_start   = ( unsigned int* )( buf - align );
 state -> bits_left      = 0;
 state -> current_word   = 0;
 state -> word_mode      = word_mode;
 state -> bigendian_mode = bigendian_mode;

 bitstream_get ( state, align * 8 );

}  /* end _dts_bitstream_init */

static int _dts_inverseq ( dts_state_t* state, const huff_entry_t* const huff ) {

 int j;
 int value  = 0;
 int length = 0;

 while( 1 ) {
  ++length;
  value <<= 1;
  value |= bitstream_get ( state, 1 );
  for ( j = 0; huff[ j ].length && huff[ j ].length < length; ++j );
  if ( !huff[ j ].length ) break;
  for ( ; huff[ j ].length == length; ++j )
   if ( huff[ j ].code == value ) return ( int )( char )huff[ j ].value;
 }  /* end while */

 return 0;

}  /* end _dts_inverseq */

static int _dts_syncinfo ( int* flags, int* sample_rate, int* bit_rate, int* frame_len ) {

 static const int sl_SampleRate[ 16 ] __attribute__(   (  section( ".data" )  )   ) = {
  0x00000000, 0x00001F40, 0x00003E80, 0x00007D00,
  0x00000000, 0x00000000, 0x00002B11, 0x00005622,
  0x0000AC44, 0x00000000, 0x00000000, 0x00002EE0,
  0x00005DC0, 0x0000BB80, 0x00017700, 0x0002EE00
 };

 static const int sl_BitRate[ 32 ] __attribute__(   (  section( ".data" )  )   ) = {
  0x00007D00, 0x0000DAC0, 0x0000FA00, 0x00017700,
  0x0001B580, 0x0001F400, 0x0002EE00, 0x00036B00,
  0x0003E800, 0x0004E200, 0x0005DC00, 0x0006D600,
  0x0007D000, 0x0008CA00, 0x0009C400, 0x000BB800,
  0x000DAC00, 0x000FA000, 0x00119400, 0x00138800,
  0x00148200, 0x00157C00, 0x00158880, 0x00167600,
  0x00177000, 0x001D4C00, 0x001F4000, 0x002EE000,
  0x003A9800, 0x00000001, 0x00000002, 0x00000003
 };

 dts_state_t* state = &s_DTSCtx;
 int          frame_size;

 bitstream_get ( state, 32 );
 bitstream_get ( state,  7 );

 *frame_len = (  bitstream_get ( state,  7 ) + 1  ) * 32;
 frame_size = bitstream_get ( state, 14 ) + 1;

 if ( !state -> word_mode ) frame_size = frame_size * 8 / 14 * 2;

 *flags = bitstream_get ( state, 6 );

 if ( *flags > 63 ) return 0;

 *sample_rate = bitstream_get ( state, 4 );

 if (  *sample_rate >= sizeof ( sl_SampleRate ) / sizeof ( sl_SampleRate[ 0 ] )  ) return 0;

 *sample_rate = sl_SampleRate[ *sample_rate ];

 if ( !*sample_rate ) return 0;

 *bit_rate = bitstream_get ( state, 5 );

 if (  *bit_rate >= sizeof ( sl_BitRate ) / sizeof ( sl_BitRate[ 0 ] )  ) return 0;

 *bit_rate = sl_BitRate[ *bit_rate ];

 if ( !*bit_rate ) return 0;

 bitstream_get ( state, 10 );

 if (  bitstream_get ( state, 2 )  ) *flags |= DTS_LFE;

 return frame_size;

}  /* end _dts_syncinfo */

int DTS_SyncInfo (
     unsigned char* buf, int* flags, int* sample_rate, int* bit_rate, int* frame_len
    ) {

 int lWM, lBM;

 if ( buf[ 0 ] == 0xFF && buf[ 1 ] == 0x1F &&
      buf[ 2 ] == 0x00 && buf[ 3 ] == 0xE8 &&
      ( buf[ 4 ] & 0xF0 ) == 0xF0          &&
      buf[ 5 ] == 0x07
 ) {
  lWM = 0;
  lBM = 0;
 } else if ( buf[ 0 ] == 0x1F && buf[ 1 ] == 0xFF &&
             buf[ 2 ] == 0xE8 && buf[ 3 ] == 0x00 &&
             buf[ 4 ] == 0x07 && ( buf[ 5 ] & 0xF0 ) == 0xF0
 ) {
  lWM = 0;
  lBM = 1;
 } else if ( buf[ 0 ] == 0xFE && buf[ 1 ] == 0x7F &&
             buf[ 2 ] == 0x01 && buf[ 3 ] == 0x80
 ) {
  lWM = 1;
  lBM = 0;
 } else if ( buf[ 0 ] == 0x7F && buf[ 1 ] == 0xFE &&
             buf[ 2 ] == 0x80 && buf[ 3 ] == 0x01
 ) {
  lWM = 1;
  lBM = 1;
 } else return 0;

 _dts_bitstream_init ( buf, lWM, lBM );

 return _dts_syncinfo ( flags, sample_rate, bit_rate, frame_len );

}  /* end DTS_SyncInfo */

static int _dts_downmix_init (
            int input, int flags, float* level, float clev, float slev
           ) {

 static const unsigned char table[ 11 ][ 10 ] __attribute__(   (  section( ".data" )  )   )= {
/* DTS_MONO */
  { DTS_MONO,   DTS_MONO,    DTS_MONO,   DTS_MONO,
    DTS_MONO,   DTS_MONO,    DTS_MONO,   DTS_MONO,
    DTS_MONO,   DTS_MONO
  },
/* DTS_CHANNEL */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO,  DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO
  },
/* DTS_STEREO */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO,  DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO
  },
/* DTS_STEREO_SUMDIFF */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO,  DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO
  },
/* DTS_STEREO_TOTAL */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO,  DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO
  },
/* DTS_3F */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_3F,      DTS_3F,     DTS_3F,
    DTS_3F,     DTS_3F
  },
/* DTS_2F1R */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_2F1R,    DTS_2F1R,   DTS_2F1R,
    DTS_2F1R,   DTS_2F1R
  },
/* DTS_3F1R */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_3F,      DTS_3F1R,   DTS_3F1R,
    DTS_3F1R,   DTS_3F1R
  },
/* DTS_2F2R */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_STEREO,  DTS_2F2R,   DTS_2F2R,
    DTS_2F2R,   DTS_2F2R
  },
/* DTS_3F2R */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_3F,      DTS_3F2R,   DTS_3F2R,
    DTS_3F2R,   DTS_3F2R
  },
/* DTS_4F2R */
  { DTS_MONO,   DTS_CHANNEL, DTS_STEREO, DTS_STEREO,
    DTS_STEREO, DTS_4F2R,    DTS_4F2R,   DTS_4F2R,
    DTS_4F2R,   DTS_4F2R
  },
 };

 int output = table[ flags & DTS_CHANNEL_MASK ][ input ];

 if (  output == DTS_STEREO && (
        input == DTS_DOLBY || (  input == DTS_3F && clev == LEVEL( LEVEL_3DB )  )
       )
 ) output = DTS_DOLBY;

 if ( flags & DTS_ADJUST_LEVEL ) {

  float adjust;

  switch (  CONVERT( input & 7, output )  ) {

   case CONVERT( DTS_3F, DTS_MONO ):
    adjust = DIV(  LEVEL_3DB, LEVEL( 1 ) + clev  );
   break;

   case CONVERT( DTS_STEREO, DTS_MONO ):
   case CONVERT( DTS_2F2R,   DTS_2F1R ):
   case CONVERT( DTS_3F2R,   DTS_3F1R ):
level_3db:
    adjust = LEVEL( LEVEL_3DB );
   break;

   case CONVERT( DTS_3F2R, DTS_2F1R ):
    if (  clev < LEVEL( LEVEL_PLUS3DB - 1 )  ) goto level_3db;
   case CONVERT( DTS_3F, DTS_STEREO ):
   case CONVERT( DTS_3F1R, DTS_2F1R ):
   case CONVERT( DTS_3F1R, DTS_2F2R ):
   case CONVERT( DTS_3F2R, DTS_2F2R ):
    adjust = DIV(  1, LEVEL( 1 ) + clev  );
   break;

   case CONVERT( DTS_2F1R, DTS_MONO ):
    adjust = DIV(  LEVEL_PLUS3DB, LEVEL( 2 ) + slev  );
   break;

   case CONVERT( DTS_2F1R, DTS_STEREO ):
   case CONVERT( DTS_3F1R, DTS_3F     ):
    adjust = DIV(  1, LEVEL( 1 ) + MUL_C( slev, LEVEL_3DB )  );
   break;

   case CONVERT( DTS_3F1R, DTS_MONO ):
    adjust = DIV(  LEVEL_3DB, LEVEL( 1 ) + clev + MUL_C( slev, 0.5F )  );
   break;

   case CONVERT( DTS_3F1R, DTS_STEREO ):
    adjust = DIV(  1, LEVEL( 1 ) + clev + MUL_C( slev, LEVEL_3DB )  );
   break;

   case CONVERT( DTS_2F2R, DTS_MONO ):
    adjust = DIV(  LEVEL_3DB, LEVEL( 1 ) + slev  );
   break;

   case CONVERT( DTS_2F2R, DTS_STEREO ):
   case CONVERT( DTS_3F2R, DTS_3F     ):
    adjust = DIV(  1, LEVEL( 1 ) + slev  );
   break;

   case CONVERT( DTS_3F2R, DTS_MONO ):
    adjust = DIV(  LEVEL_3DB, LEVEL( 1 ) + clev + slev  );
   break;

   case CONVERT( DTS_3F2R, DTS_STEREO ):
    adjust = DIV(  1, LEVEL( 1 ) + clev + slev  );
   break;

   case CONVERT( DTS_MONO, DTS_DOLBY ):
    adjust = LEVEL( LEVEL_PLUS3DB );
   break;

   case CONVERT( DTS_3F, DTS_DOLBY   ):
   case CONVERT( DTS_2F1R, DTS_DOLBY ):
    adjust = LEVEL(  1 / ( 1 + LEVEL_3DB )  );
   break;

   case CONVERT( DTS_3F1R, DTS_DOLBY ):
   case CONVERT( DTS_2F2R, DTS_DOLBY ):
    adjust = LEVEL(  1 / ( 1 + 2 * LEVEL_3DB )  );
   break;

   case CONVERT( DTS_3F2R, DTS_DOLBY ):
    adjust = LEVEL(  1 / ( 1 + 3 * LEVEL_3DB )  );
   break;

   default: return output;

  }  /* end switch */

  *level = MUL_L( *level, adjust );

 }  /* end if */

 return output;

}  /* end _dts_downmix_init */

static void mix2to1 ( float* apDst, float* apSrc, const float* apBias ) {
 int i;
 for ( i = 0; i < 256; ++i ) apDst[ i ] += apSrc[ i ] + apBias[ 0 ];
}  /* end mix2to1 */

static void mix3to1 ( float* apSamples, const float* apBias ) {
 int i;
 for ( i = 0; i < 256; ++i )
  apSamples[ i ] += (
   apSamples[ i + 256 ] +
   apSamples[ i + 512 ] + apBias[ 0 ]
  );
}  /* end mix3to1 */

static void mix4to1 ( float* apSamples, const float* apBias ) {
 int i;
 for ( i = 0; i < 256; ++i )
  apSamples[ i ] += (
   apSamples[ i + 256 ] +
   apSamples[ i + 512 ] +
   apSamples[ i + 768 ] + apBias[ 0 ]
  );
}  /* end mix4to1 */

static void mix5to1 ( float* apSamples, const float* apBias ) {
 int i;
 for ( i = 0; i < 256; ++i )
  apSamples[ i ] += (
   apSamples[ i +  256 ] +
   apSamples[ i +  512 ] +
   apSamples[ i +  768 ] +
   apSamples[ i + 1024 ] + apBias[ 0 ]
  );
}  /* end mix5to1 */

static void mix3to2 ( float* apSamples, const float* apBias ) {
 int   i;
 float lCommon;
 for ( i = 0; i < 256; ++i ) {
  lCommon = apSamples[ i ] + apBias[ 0 ];
  apSamples[ i +   0 ] = apSamples[ i + 256 ] + lCommon;
  apSamples[ i + 256 ] = apSamples[ i + 512 ] + lCommon;
 }  /* end for */
}  /* end mix3to2 */

static void mix21to2 ( float* apLeft, float* apRight, const float* apBias ) {
 int   i;
 float lCommon;
 for ( i = 0; i < 256; ++i ) {
  lCommon = apRight[ i + 256 ] + apBias[ 0 ];
  apLeft [ i ] += lCommon;
  apRight[ i ] += lCommon;
 }  /* end for */
}  /* end mix21to2 */

static void mix21toS ( float* apSamples, const float* apBias ) {
 int   i;
 float lSurround;
 for ( i = 0; i < 256; ++i ) {
  lSurround = apSamples[ i + 512 ];
  apSamples[ i +   0 ] += apBias[ 0 ] - lSurround;
  apSamples[ i + 256 ] += apBias[ 0 ] + lSurround;
 }  /* end for */
}  /* end mix21toS */

static void mix31to2 ( float* apSamples, const float* apBias ) {
 int   i;
 float lCommon;
 for ( i = 0; i < 256; ++i ) {
  lCommon = (
   apSamples[ i +   0 ] +
   apSamples[ i + 768 ] + apBias[ 0 ]
  );
  apSamples[ i +   0 ] = apSamples[ i + 256 ] + lCommon;
  apSamples[ i + 256 ] = apSamples[ i + 512 ] + lCommon;
 }  /* end for */
}  /* end mix31to2 */

static void mix31toS ( float* apSamples, const float* apBias ) {
 int   i;
 float lCommon, lSurround;
 for ( i = 0; i < 256; ++i ) {
  lCommon   = apSamples[ i +   0 ] + apBias[ 0 ];
  lSurround = apSamples[ i + 768 ];
  apSamples[ i +   0 ] = apSamples[ i + 256 ] + lCommon - lSurround;
  apSamples[ i + 256 ] = apSamples[ i + 512 ] + lCommon + lSurround;
 }  /* end for */
}  /* end mix31toS */

static void mix22toS ( float* apSamples, const float* apBias ) {
 int   i;
 float lSurround;
 for ( i = 0; i < 256; ++i ) {
  lSurround = apSamples[ i + 512 ] + apSamples[ i + 768 ];
  apSamples[ i +   0 ] += apBias[ 0 ] - lSurround;
  apSamples[ i + 256 ] += apBias[ 0 ] + lSurround;
 }  /* end for */
}  /* end mix22toS */

void mix32to2 ( float*, const float* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "mix32to2:\n\t"
 "lw        $at, 0($a1)\n\t"
 "addiu     $a2, $a0, 1024\n\t"
 "pextlw    $at, $at, $at\n\t"
 "pextlw    $at, $at, $at\n\t"
 "qmtc2     $at, $vf10\n\t"
 "1:\n\t"
 "lqc2      $vf01,    0($a0)\n\t"
 "lqc2      $vf02, 1024($a0)\n\t"
 "lqc2      $vf03, 2048($a0)\n\t"
 "vadda.xyzw    ACC, $vf01, $vf10\n\t"
 "vmaddaw.xyzw  ACC, $vf02, $vf00\n\t"
 "lqc2      $vf04, 3072($a0)\n\t"
 "lqc2      $vf05, 4096($a0)\n\t"
 "vmaddw.xyzw   $vf06, $vf04, $vf00\n\t"
 "vadda.xyzw    ACC, $vf01, $vf10\n\t"
 "vmaddaw.xyzw  ACC, $vf03, $vf00\n\t"
 "vmaddw.xyzw   $vf07, $vf05, $vf00\n\t"
 "addiu     $a0, $a0, 16\n\t"
 "sqc2      $vf06,   -16($a0)\n\t"
 "bne       $a2, $a0, 1b\n\t"
 "sqc2      $vf07,  1008($a0)\n\t"
 "jr        $ra\n\t"
 "nop\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

static void mix32toS ( float* apSamples, const float* apBias ) {
 int   i;
 float lCommon, lSurround;
 for ( i = 0; i < 256; ++i ) {
  lCommon   = apSamples[ i +   0 ] + apBias[ 0 ];
  lSurround = apSamples[ i + 768 ] + apSamples[ i + 1024 ];
  apSamples[ i +   0 ] = apSamples[ i + 256 ] + lCommon - lSurround;
  apSamples[ i + 256 ] = apSamples[ i + 512 ] + lCommon + lSurround;
 }  /* end for */
}  /* end mix32toS */

static void move2to1 ( float* apSrc, float* apDst, const float* apBias ) {
 int i;
 for ( i = 0; i < 256; ++i )
  apDst[ i ] = apSrc[ i ] + apSrc[ i + 256 ] + apBias[ 0 ];
}  /* end move2to1 */

static void inline zero ( float* apSamples ) {
 memset (  apSamples, 0, 256 * sizeof ( float )  );
}  /* end zero */

static void dts_downmix (
             float* samples, const float* apBias, float slev, int aMode
            ) {

 switch ( aMode ) {
  case CONVERT( DTS_CHANNEL, DTS_MONO ):
  case CONVERT( DTS_STEREO, DTS_MONO  ):
mix_2to1:
   mix2to1 ( samples, samples + 256, apBias );
  break;

  case CONVERT( DTS_2F1R, DTS_MONO ):
   if ( slev == 0.0F ) goto mix_2to1;
  case CONVERT( DTS_3F, DTS_MONO   ):
mix_3to1:
   mix3to1 ( samples, apBias );
  break;

  case CONVERT( DTS_3F1R, DTS_MONO ):
   if ( slev == 0 ) goto mix_3to1;
  case CONVERT( DTS_2F2R, DTS_MONO ):
   if ( slev == 0 ) goto mix_2to1;
   mix4to1 ( samples, apBias );
  break;

  case CONVERT( DTS_3F2R, DTS_MONO ):
   if ( slev == 0 ) goto mix_3to1;
   mix5to1 ( samples, apBias );
  break;

  case CONVERT( DTS_MONO, DTS_DOLBY ):
   memcpy (  samples + 256, samples, 256 * sizeof ( float )  );
  break;

  case CONVERT( DTS_3F, DTS_STEREO ):
  case CONVERT( DTS_3F, DTS_DOLBY  ):
mix_3to2:
   mix3to2 ( samples, apBias );
  break;

  case CONVERT( DTS_2F1R, DTS_STEREO ):
   if ( slev == 0 ) break;
   mix21to2 ( samples, samples + 256, apBias );
  break;

  case CONVERT( DTS_2F1R, DTS_DOLBY ):
   mix21toS ( samples, apBias );
  break;

  case CONVERT( DTS_3F1R, DTS_STEREO ):
   if ( slev == 0 ) goto mix_3to2;
   mix31to2 ( samples, apBias );
  break;

  case CONVERT( DTS_3F1R, DTS_DOLBY ):
   mix31toS ( samples, apBias );
  break;

  case CONVERT( DTS_2F2R, DTS_STEREO ):
   if ( slev == 0 ) break;
   mix2to1 ( samples +   0, samples + 512, apBias );
   mix2to1 ( samples + 256, samples + 768, apBias );
  break;

  case CONVERT( DTS_2F2R, DTS_DOLBY ):
   mix22toS ( samples, apBias );
  break;

  case CONVERT( DTS_3F2R, DTS_STEREO ):
   if ( slev == 0 ) goto mix_3to2;
   mix32to2 ( samples, apBias );
  break;

  case CONVERT( DTS_3F2R, DTS_DOLBY ):
   mix32toS ( samples, apBias );
  break;

  case CONVERT( DTS_3F1R, DTS_3F ):
   if ( slev == 0 ) break;
   mix21to2 ( samples, samples + 512, apBias );
  break;

  case CONVERT( DTS_3F2R, DTS_3F ):
   if ( slev == 0 ) break;
   mix2to1 ( samples +   0, samples +  768, apBias );
   mix2to1 ( samples + 512, samples + 1024, apBias );
  break;

  case CONVERT( DTS_3F1R, DTS_2F1R ):
   mix3to2 ( samples, apBias );
   memcpy (  samples + 512, samples + 768, 256 * sizeof ( float )  );
  break;

  case CONVERT( DTS_2F2R, DTS_2F1R ):
   mix2to1 ( samples + 512, samples + 768, apBias );
  break;

  case CONVERT( DTS_3F2R, DTS_2F1R ):
   mix3to2 ( samples, apBias );
   move2to1 ( samples + 768, samples + 512, apBias );
  break;

  case CONVERT( DTS_3F2R, DTS_3F1R ):
   mix2to1 ( samples + 768, samples + 1024, apBias );
  break;

  case CONVERT( DTS_2F1R, DTS_2F2R ):
   memcpy (  samples + 768, samples + 512, 256 * sizeof ( float )  );
  break;

  case CONVERT( DTS_3F1R, DTS_2F2R ):
   mix3to2 ( samples, apBias );
   memcpy (  samples + 512, samples + 768, 256 * sizeof ( float )  );
  break;

  case CONVERT( DTS_3F2R, DTS_2F2R ):
   mix3to2 ( samples, apBias );
   memcpy (  samples + 512, samples +  768, 256 * sizeof ( float )  );
   memcpy (  samples + 768, samples + 1024, 256 * sizeof ( float )  );
  break;

  case CONVERT( DTS_3F1R, DTS_3F2R ):
   memcpy (  samples + 1024, samples + 768, 256 * sizeof ( float )  );
  break;

 }  /* end switch */

}  /* end dts_downmix */

static void dts_upmix ( float* samples, int aMode ) {

 switch ( aMode ) {

  case CONVERT( DTS_3F2R, DTS_MONO ):
   zero ( samples + 1024 );
  case CONVERT( DTS_3F1R, DTS_MONO ):
  case CONVERT( DTS_2F2R, DTS_MONO ):
   zero ( samples +  768 );
  case CONVERT( DTS_3F, DTS_MONO   ):
  case CONVERT( DTS_2F1R, DTS_MONO ):
   zero ( samples + 512 );
  case CONVERT( DTS_CHANNEL, DTS_MONO ):
  case CONVERT( DTS_STEREO,  DTS_MONO ):
   zero ( samples + 256 );
  break;

  case CONVERT( DTS_3F2R, DTS_STEREO ):
  case CONVERT( DTS_3F2R, DTS_DOLBY  ):
   zero ( samples + 1024 );
  case CONVERT( DTS_3F1R, DTS_STEREO ):
  case CONVERT( DTS_3F1R, DTS_DOLBY  ):
   zero ( samples + 768 );
  case CONVERT( DTS_3F, DTS_STEREO ):
  case CONVERT( DTS_3F, DTS_DOLBY  ):
mix_3to2:
   memcpy (  samples + 512, samples + 256, 256 * sizeof ( float )  );
   zero ( samples + 256 );
  break;

  case CONVERT( DTS_2F2R, DTS_STEREO ):
  case CONVERT( DTS_2F2R, DTS_DOLBY  ):
   zero ( samples + 768 );
  case CONVERT( DTS_2F1R, DTS_STEREO ):
  case CONVERT( DTS_2F1R, DTS_DOLBY  ):
   zero ( samples + 512 );
  break;

  case CONVERT( DTS_3F2R, DTS_3F ):
   zero ( samples + 1024 );
  case CONVERT( DTS_3F1R, DTS_3F   ):
  case CONVERT( DTS_2F2R, DTS_2F1R ):
   zero ( samples + 768 );
  break;

  case CONVERT( DTS_3F2R, DTS_3F1R ):
   zero ( samples + 1024 );
  break;

  case CONVERT( DTS_3F2R, DTS_2F1R ):
   zero ( samples + 1024 );
  case CONVERT( DTS_3F1R, DTS_2F1R ):
mix_31to21:
   memcpy (  samples + 768, samples + 512, 256 * sizeof ( float )  );
  goto mix_3to2;

  case CONVERT( DTS_3F2R, DTS_2F2R ):
   memcpy (  samples + 1024, samples + 768, 256 * sizeof ( float )  );
  goto mix_31to21;

 }  /* end switch */

}  /* end dts_upmix */

static int _dts_frame (
            unsigned char* buf, int* flags, float* level, float bias
           ) {

 static float adj_table[ 4 ] = { 1.0F, 1.125F, 1.25F, 1.4375F };

 int          i, j;
 dts_state_t* state = &s_DTSCtx;

 _dts_bitstream_init ( buf, state -> word_mode, state -> bigendian_mode );

 bitstream_get ( state, 32 );
 bitstream_get ( state,  6 );
 state -> crc_present       = bitstream_get ( state,  1 );
 state -> sample_blocks     = (  bitstream_get ( state,  7 ) + 1  ) >> 3;
 bitstream_get ( state, 14 );
 state -> amode             = bitstream_get ( state,  6 );
 bitstream_get ( state,  4 );
 state -> bit_rate          = bitstream_get ( state,  5 );
 state -> downmix           = bitstream_get ( state,  1 );
 state -> dynrange          = bitstream_get ( state,  1 );
 state -> timestamp         = bitstream_get ( state,  1 );
 state -> aux_data          = bitstream_get ( state,  1 );
 bitstream_get ( state, 5 );
 state -> aspf              = bitstream_get ( state,  1 );
 state -> lfe               = bitstream_get ( state,  2 );
 state -> predictor_history = bitstream_get ( state,  1 );

 if ( state -> crc_present ) bitstream_get ( state, 16 );

 state -> multirate_inter = bitstream_get ( state, 1 );

 bitstream_get ( state, 15 );

 state -> clev   = state -> slev = 1;
 state -> output = _dts_downmix_init (
  state -> amode, *flags, level, state -> clev, state -> slev
 );

 if ( state -> output < 0 ) return 1;

 if (  state -> lfe && ( *flags & DTS_LFE )  ) state -> output |= DTS_LFE;

 *flags = state -> output;

 state -> dynrng        = state -> level = MUL_C( *level, 2 );
 state -> bias          = bias;
 state -> dynrnge       = 1;
 state -> dynrngcall    = ( void* )0;
 state -> subframes     = bitstream_get ( state, 4 ) + 1;
 state -> prim_channels = bitstream_get ( state, 3 ) + 1;

 for ( i = 0; i < state -> prim_channels; ++i ) {
  state -> subband_activity[ i ] = bitstream_get ( state, 5 ) + 2;
  if ( state -> subband_activity[ i ] > DTS_SUBBANDS )
   state -> subband_activity[ i ] = DTS_SUBBANDS;
 }  /* end for */

 for ( i = 0; i < state -> prim_channels; ++i ) {
  state -> vq_start_subband[ i ] = bitstream_get ( state, 5 ) + 1;
  if ( state -> vq_start_subband[ i ] > DTS_SUBBANDS )
   state -> vq_start_subband[ i ] = DTS_SUBBANDS;
 }  /* end for */

 for ( i = 0; i < state -> prim_channels; ++i )
  state -> joint_intensity[ i ] = bitstream_get ( state, 3 );

 for ( i = 0; i < state -> prim_channels; ++i )
  state -> transient_huffman[ i ] = bitstream_get ( state, 2 );

 for ( i = 0; i < state -> prim_channels; ++i )
  state -> scalefactor_huffman[ i ] = bitstream_get ( state, 3 );

 for ( i = 0; i < state -> prim_channels; ++i )
  state -> bitalloc_huffman[ i ] = bitstream_get ( state, 3 );

 for ( i = 0; i < state -> prim_channels; ++i ) {
  state -> quant_index_huffman[ i ][ 0 ] = 0;
  state -> quant_index_huffman[ i ][ 1 ] = bitstream_get ( state, 1 );
 }  /* end for */

 for ( j = 2; j < 6; ++j )
  for ( i = 0; i < state -> prim_channels; ++i )
   state -> quant_index_huffman[ i ][ j ] = bitstream_get ( state, 2 );

 for ( j = 6; j < 11; ++j )
  for ( i = 0; i < state -> prim_channels; ++i )
   state -> quant_index_huffman[ i ][ j ] = bitstream_get ( state, 3 );

 for ( j = 11; j < 27; ++j )
  for ( i = 0; i < state -> prim_channels; ++i )
   state -> quant_index_huffman[ i ][ j ] = 0;

 for ( j = 0; j < 11; ++j )
  for ( i = 0; i < state -> prim_channels; ++i )
    state -> scalefactor_adj[ i ][ j ] = 1;

 for ( i = 0; i < state -> prim_channels; ++i )
  if ( state -> quant_index_huffman[ i ][ 1 ] == 0 )
   state -> scalefactor_adj[ i ][ 1 ] = adj_table[ bitstream_get ( state, 2 ) ];

 for ( j = 2; j < 6; ++j )
  for ( i = 0; i < state -> prim_channels; ++i )
   if ( state -> quant_index_huffman[ i ][ j ] < 3 )
    state -> scalefactor_adj[ i ][ j ] = adj_table[ bitstream_get ( state, 2 ) ];

 for ( j = 6; j < 11; ++j )
  for ( i = 0; i < state -> prim_channels; ++i )
   if ( state -> quant_index_huffman[ i ][ j ] < 7 )
    state -> scalefactor_adj[ i ][ j ] = adj_table[ bitstream_get ( state, 2 ) ];

 if ( state -> crc_present ) bitstream_get ( state, 16 );

 state -> current_subframe    = 0;
 state -> current_subsubframe = 0;

 return 0;

}  /* end _dts_frame */

static int _dts_decode_blockcode ( int code, int levels, int* values ) { 

 int i;
 int offset = ( levels - 1 ) >> 1;

 for ( i = 0; i < 4; ++i ) {
  values[ i ] = ( code % levels ) - offset;
  code       /= levels;
 }  /* end for */

 return !code;

}  /* end  _dts_decode_blockcode */

float* _dts_synth ( float*, float*, const float*, float*, const float*, const float* );
// a0 = subband_fir_hist2
// a1 = subband_fir_hist
// a2 = prCoeff
// a3 = samples_out
// t0 = raXin
// t1 = cos_mod
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "_dts_synth:\n\t"
 "mtsah     $zero, -2\n\t"
 "addu      $v0, $zero, $a1\n\t"
 "lq        $t2,   0($t0)\n\t"
 "lq        $t3,  16($t0)\n\t"
 "lq        $t4,  32($t0)\n\t"
 "lq        $t5,  48($t0)\n\t"
 "lq        $t6,  64($t0)\n\t"
 "lq        $t7,  80($t0)\n\t"
 "lq        $t8,  96($t0)\n\t"
 "lq        $t9, 112($t0)\n\t"
 "ppacw     $at, $t3, $t2\n\t"
 "pextlw    $v1, $t3, $t2\n\t"
 "pextuw    $t2, $t3, $t2\n\t"
 "pextuw    $t2, $t2, $v1\n\t"
 "ppacw     $t3, $t5, $t4\n\t"
 "pextlw    $v1, $t5, $t4\n\t"
 "pextuw    $t4, $t5, $t4\n\t"
 "pextuw    $t4, $t4, $v1\n\t"
 "ppacw     $t5, $t7, $t6\n\t"
 "pextlw    $v1, $t7, $t6\n\t"
 "pextuw    $t6, $t7, $t6\n\t"
 "pextuw    $t6, $t6, $v1\n\t"
 "ppacw     $t7, $t9, $t8\n\t"
 "pextlw    $v1, $t9, $t8\n\t"
 "pextuw    $t8, $t9, $t8\n\t"
 "pextuw    $t8, $t8, $v1\n\t"
 "qmtc2     $at, $vf05\n\t"
 "qmtc2     $t2, $vf06\n\t"
 "qmtc2     $t3, $vf07\n\t"
 "qmtc2     $t4, $vf08\n\t"
 "qmtc2     $t5, $vf09\n\t"
 "qmtc2     $t6, $vf10\n\t"
 "qmtc2     $t7, $vf11\n\t"
 "qmtc2     $t8, $vf12\n\t"
 "qfsrv     $t8, $t8, $t6\n\t"
 "qfsrv     $t7, $t6, $t4\n\t"
 "qfsrv     $t6, $t4, $t2\n\t"
 "qfsrv     $t5, $t2, $zero\n\t"
 "qmtc2     $t8, $vf13\n\t"
 "qmtc2     $t7, $vf14\n\t"
 "qmtc2     $t6, $vf15\n\t"
 "qmtc2     $t5, $vf16\n\t"
 "addiu     $at, $t1, 2176\n\t"
 "addiu     $t2, $v0,  112\n\t"
 "vadd.xyzw $vf01, $vf05, $vf06\n\t"
 "vadd.xyzw $vf02, $vf07, $vf08\n\t"
 "vadd.xyzw $vf03, $vf09, $vf10\n\t"
 "vadd.xyzw $vf04, $vf11, $vf12\n\t"
 "vadd.xyzw $vf05, $vf05, $vf16\n\t"
 "vadd.xyzw $vf06, $vf07, $vf15\n\t"
 "vadd.xyzw $vf07, $vf09, $vf14\n\t"
 "vadd.xyzw $vf08, $vf11, $vf13\n\t"
 "1:\n\t"
 "lqc2      $vf09,   0($t1)\n\t"
 "lqc2      $vf10,  16($t1)\n\t"
 "lqc2      $vf11,  32($t1)\n\t"
 "lqc2      $vf12,  48($t1)\n\t"
 "lqc2      $vf13,  64($t1)\n\t"
 "lqc2      $vf14,  80($t1)\n\t"
 "lqc2      $vf15,  96($t1)\n\t"
 "lqc2      $vf16, 112($t1)\n\t"
 "lqc2      $vf17, 128($t1)\n\t"
 "lqc2      $vf18, 144($t1)\n\t"
 "lqc2      $vf19, 160($t1)\n\t"
 "lqc2      $vf20, 176($t1)\n\t"
 "lqc2      $vf21, 192($t1)\n\t"
 "lqc2      $vf22, 208($t1)\n\t"
 "lqc2      $vf23, 224($t1)\n\t"
 "lqc2      $vf24, 240($t1)\n\t"
 "vmulax.xyzw   ACC, $vf09, $vf01\n\t"
 "vmadday.xyzw  ACC, $vf10, $vf01\n\t"
 "vmaddaz.xyzw  ACC, $vf11, $vf01\n\t"
 "vmaddaw.xyzw  ACC, $vf12, $vf01\n\t"
 "vmaddax.xyzw  ACC, $vf13, $vf02\n\t"
 "vmadday.xyzw  ACC, $vf14, $vf02\n\t"
 "vmaddaz.xyzw  ACC, $vf15, $vf02\n\t"
 "vmaddaw.xyzw  ACC, $vf16, $vf02\n\t"
 "vmaddax.xyzw  ACC, $vf17, $vf03\n\t"
 "vmadday.xyzw  ACC, $vf18, $vf03\n\t"
 "vmaddaz.xyzw  ACC, $vf19, $vf03\n\t"
 "vmaddaw.xyzw  ACC, $vf20, $vf03\n\t"
 "vmaddax.xyzw  ACC, $vf21, $vf04\n\t"
 "vmadday.xyzw  ACC, $vf22, $vf04\n\t"
 "vmaddaz.xyzw  ACC, $vf23, $vf04\n\t"
 "vmaddw.xyzw   $vf09, $vf24, $vf04\n\t"
 "lqc2      $vf10, 256($t1)\n\t"
 "lqc2      $vf11, 272($t1)\n\t"
 "lqc2      $vf12, 288($t1)\n\t"
 "lqc2      $vf13, 304($t1)\n\t"
 "lqc2      $vf14, 320($t1)\n\t"
 "lqc2      $vf15, 336($t1)\n\t"
 "lqc2      $vf16, 352($t1)\n\t"
 "lqc2      $vf17, 368($t1)\n\t"
 "lqc2      $vf18, 384($t1)\n\t"
 "lqc2      $vf19, 400($t1)\n\t"
 "lqc2      $vf20, 416($t1)\n\t"
 "lqc2      $vf21, 432($t1)\n\t"
 "lqc2      $vf22, 448($t1)\n\t"
 "lqc2      $vf23, 464($t1)\n\t"
 "lqc2      $vf24, 480($t1)\n\t"
 "lqc2      $vf25, 496($t1)\n\t"
 "vmulax.xyzw   ACC, $vf10, $vf05\n\t"
 "vmadday.xyzw  ACC, $vf11, $vf05\n\t"
 "vmaddaz.xyzw  ACC, $vf12, $vf05\n\t"
 "vmaddaw.xyzw  ACC, $vf13, $vf05\n\t"
 "lqc2      $vf11, 512($t1)\n\t"
 "lqc2      $vf12, 528($t1)\n\t"
 "vmaddax.xyzw  ACC, $vf14, $vf06\n\t"
 "vmadday.xyzw  ACC, $vf15, $vf06\n\t"
 "vmaddaz.xyzw  ACC, $vf16, $vf06\n\t"
 "vmaddaw.xyzw  ACC, $vf17, $vf06\n\t"
 "vmaddax.xyzw  ACC, $vf18, $vf07\n\t"
 "vmadday.xyzw  ACC, $vf19, $vf07\n\t"
 "vmaddaz.xyzw  ACC, $vf20, $vf07\n\t"
 "vmaddaw.xyzw  ACC, $vf21, $vf07\n\t"
 "vmaddax.xyzw  ACC, $vf22, $vf08\n\t"
 "vmadday.xyzw  ACC, $vf23, $vf08\n\t"
 "vmaddaz.xyzw  ACC, $vf24, $vf08\n\t"
 "vmaddw.xyzw   $vf10, $vf25, $vf08\n\t"
 "vmula.xyzw    ACC, $vf12, $vf09\n\t"
 "vmsub.xyzw    $vf12, $vf12, $vf10\n\t"
 "vmula.xyzw    ACC, $vf11, $vf09\n\t"
 "vmadd.xyzw    $vf11, $vf11, $vf10\n\t"
 "addiu     $t1, $t1, 544\n\t"
 "qmfc2     $v1, $vf12\n\t"
 "pexew     $v1, $v1\n\t"
 "qfsrv     $v1, $v1, $v1\n\t"
 "sqc2      $vf11, 0($v0)\n\t"
 "sq        $v1, 0($t2)\n\t"
 "addiu     $v0, $v0,  16\n\t"
 "bne       $at, $t1, 1b\n\t"
 "addiu     $t2, $t2, -16\n\t"
 "pxor      $at, $at, $at\n\t"
 "qmtc2     $at, $vf01\n\t"
 "addiu     $t3, $a1, 2048\n\t"
 "1:\n\t"
 "pref      0, 128($a2)\n\t"
 "addiu     $t2, $a0, 0\n\t"
 "addiu     $at, $a1, 128\n\t"
 "addiu     $v1, $a1, 112\n\t"
 "2:\n\t"
 "lqc2      $vf02,   0($t2)\n\t"
 "lqc2      $vf03, 128($t2)\n\t"
 "lqc2      $vf04,   0($a2)\n\t"
 "lqc2      $vf05, 128($a2)\n\t"
 "lqc2      $vf06,   0($a1)\n\t"
 "lq        $v0, 0($v1)\n\t"
 "vadda.xyzw    ACC, $vf01, $vf02\n\t"
 "vmadda.xyzw   ACC, $vf04, $vf06\n\t"
 "pexew     $v0, $v0\n\t"
 "qfsrv     $v0, $v0, $v0\n\t"
 "qmtc2     $v0, $vf07\n\t"
 "vmsub.xyzw    $vf02, $vf04, $vf07\n\t"
 "vadda.xyzw    ACC, $vf01, $vf03\n\t"
 "vmsuba.xyzw   ACC, $vf05, $vf06\n\t"
 "vmsub.xyzw    $vf03, $vf05, $vf07\n\t"
 "addiu     $a1, $a1,  16\n\t"
 "addiu     $a2, $a2,  16\n\t"
 "addiu     $t2, $t2,  16\n\t"
 "addiu     $v1, $v1, -16\n\t"
 "sqc2      $vf02, -16($t2)\n\t"
 "bne       $at, $a1, 2b\n\t"
 "sqc2      $vf03, 112($t2)\n\t"
 "addiu     $a1, $a1, 128\n\t"
 "bne       $t3, $a1, 1b\n\t"
 "addiu     $a2, $a2, 128\n\t"
 "pref      0,  0($a0)\n\t"
 "pref      0, 64($a0)\n\t"
 "lq        $t0, 128($a0)\n\t"
 "lq        $t1, 144($a0)\n\t"
 "lq        $t2, 160($a0)\n\t"
 "lq        $t3, 176($a0)\n\t"
 "lq        $t4, 192($a0)\n\t"
 "lq        $t5, 208($a0)\n\t"
 "lq        $t6, 224($a0)\n\t"
 "lq        $t7, 240($a0)\n\t"
 "lqc2      $vf01,   0($a0)\n\t"
 "lqc2      $vf02,  16($a0)\n\t"
 "lqc2      $vf03,  32($a0)\n\t"
 "lqc2      $vf04,  48($a0)\n\t"
 "lqc2      $vf05,  64($a0)\n\t"
 "lqc2      $vf06,  80($a0)\n\t"
 "lqc2      $vf07,  96($a0)\n\t"
 "lqc2      $vf08, 112($a0)\n\t"
 "vmul.xyzw     $vf01, $vf01, $vf26\n\t"
 "vmul.xyzw     $vf02, $vf02, $vf26\n\t"
 "vmul.xyzw     $vf03, $vf03, $vf26\n\t"
 "vmul.xyzw     $vf04, $vf04, $vf26\n\t"
 "vmul.xyzw     $vf05, $vf05, $vf26\n\t"
 "vmul.xyzw     $vf06, $vf06, $vf26\n\t"
 "vmul.xyzw     $vf07, $vf07, $vf26\n\t"
 "vmul.xyzw     $vf08, $vf08, $vf26\n\t"
 "sq        $zero, 128($a0)\n\t"
 "sq        $zero, 144($a0)\n\t"
 "sq        $zero, 160($a0)\n\t"
 "sq        $zero, 176($a0)\n\t"
 "sq        $zero, 192($a0)\n\t"
 "sq        $zero, 208($a0)\n\t"
 "sq        $zero, 224($a0)\n\t"
 "sq        $zero, 240($a0)\n\t"
 "sqc2      $vf01,   0($a3)\n\t"
 "sqc2      $vf02,  16($a3)\n\t"
 "sqc2      $vf03,  32($a3)\n\t"
 "sqc2      $vf04,  48($a3)\n\t"
 "sqc2      $vf05,  64($a3)\n\t"
 "sqc2      $vf06,  80($a3)\n\t"
 "sqc2      $vf07,  96($a3)\n\t"
 "sqc2      $vf08, 112($a3)\n\t"
 "sq        $t0,   0($a0)\n\t"
 "sq        $t1,  16($a0)\n\t"
 "sq        $t2,  32($a0)\n\t"
 "sq        $t3,  48($a0)\n\t"
 "sq        $t4,  64($a0)\n\t"
 "sq        $t5,  80($a0)\n\t"
 "sq        $t6,  96($a0)\n\t"
 "sq        $t7, 112($a0)\n\t"
 "addiu     $at, $a1, -2048\n\t"
 "1:\n\t"
 "lq        $t0, -192($a1)\n\t"
 "lq        $t1, -176($a1)\n\t"
 "lq        $t2, -160($a1)\n\t"
 "lq        $t3, -144($a1)\n\t"
 "addiu     $a1, $a1, -64\n\t"
 "sq        $t0,   0($a1)\n\t"
 "sq        $t1,  16($a1)\n\t"
 "sq        $t2,  32($a1)\n\t"
 "bne       $at, $a1, 1b\n\t"
 "sq        $t3,  48($a1)\n\t"
 "jr        $ra\n\t"
 "addiu     $v0, $a3, 128\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

static void qmf_32_subbands ( dts_state_t* apState, float aSS[][ 8 ][ 32 ] ) {

 int    lCh;
 float* lpIn;
 float* lpCoef;

 __asm__ __volatile__(
  ".set noat\n\t"
  "lui      $at, 0x37AA\n\t"
  "ori      $at, $at, 0xAAAB\n\t"
  "pextlw   $at, $at, $at\n\t"
  "pextlw   $at, $at, $at\n\t"
  "qmtc2    $at, $vf26\n\t"
  ".set at\n\t"
 );

 lpCoef = ( float* )s_FIR32Bands;

 if ( !apState -> multirate_inter ) lpCoef += 512;

 for ( lCh = 0; lCh < apState -> prim_channels; ++lCh ) {

  int    lActivity           = apState -> subband_activity  [ lCh ];
  float* lpSFIRHist          = apState -> subband_fir_hist  [ lCh ];
  float* lpSFIRHist2         = apState -> subband_fir_noidea[ lCh ];
  float  ( *lpSampIn )[ 32 ] = aSS[ lCh ];
  float* lpSampOut           = &apState -> samples[ 256 * lCh ];

  for ( lpIn = lpSampIn[ 0 ]; lpIn != lpSampIn[ 8 ]; lpIn += 32 ) {

   int* lpIt  = ( int* )lpIn + lActivity;
   int* lpEnd = ( int* )lpIn + 32;

   while ( lpIt != lpEnd ) *lpIt++ = 0;

   lpSampOut = _dts_synth (
    lpSFIRHist2, lpSFIRHist, lpCoef, lpSampOut, lpIn, ( float* )s_CosMod
   );

  }  /* end for */

 }  /* end for */

}  /* end qmf_32_subbands */

static void lfe_interpolation_fir (
             int nDecimationSelect, int nNumDeciSample,
             float* samples_in, float* samples_out, float bias
            ) {

 const float lScale = 1.0F / 8388608.0F;

 int    i, j, k, l, lDeciFactor;
 float* prCoeff;

 if ( nDecimationSelect == 1 ) {
  lDeciFactor = 4;
  prCoeff     = ( float* )lfe_fir_128;
 } else {
  lDeciFactor = 8;
  prCoeff     = ( float* )lfe_fir_64;
 }  /* end else */

 for ( i = 0, l = 0; i < nNumDeciSample; ++i ) {
  for ( k = 0; k < lDeciFactor; ++k ) {
   float rTmp = 0.0F;
   for ( j = 0; j < lDeciFactor; ++j )
    rTmp += samples_in[ i - j ] * prCoeff[ k + j * lDeciFactor ];
   samples_out[ l++ ] = rTmp * lScale + bias;
  }  /* end for */
 }  /* end for */

}  /* end lfe_interpolation_fir */

static int _dts_subsubframe ( void ) {

 dts_state_t* state       = &s_DTSCtx;
 int          subsubframe = state -> current_subsubframe;
 int          k, l;
 float*       quant_step_table;
 float        subband_samples[ DTS_PRIM_CHANNELS_MAX ][ 8 ][ 32 ];

 if ( state -> bit_rate == 0x1F )
  quant_step_table = ( float* )lossless_quant_d;
 else quant_step_table = ( float* )lossy_quant_d;

 for ( k = 0; k < state -> prim_channels; ++k ) {
  for ( l = 0; l < state -> vq_start_subband[ k ]; ++l ) {
   int   m;
   int   abits           = state -> bitalloc[ k ][ l ];
   int   sel             = state -> quant_index_huffman[ k ][ abits ]; 
   int   q_type          = 1;
   float quant_step_size = quant_step_table[ abits ];
   float rscale;
   if ( abits >= 11 || !bitalloc_select[ abits ][ sel ] ) {
    if ( abits <= 7 )
     q_type = 3;
    else q_type = 2;
   }  /* end if */
   if ( abits == 0 ) q_type = 0;
   switch ( q_type ) {
    case 0:
     for ( m = 0; m < 8; ++m )
      subband_samples[ k ][ m ][ l ] = 0;
    break;
    case 1:
     for ( m = 0; m < 8; ++m )
      subband_samples[ k ][ m ][ l ] = ( float )_dts_inverseq (
       state, bitalloc_select[ abits ][ sel ]
      );
    break;
    case 2:
     for ( m = 0; m < 8; ++m ) {
      int q_index = bitstream_get ( state, abits - 3 );
      if (   q_index & (  1 << ( abits - 4 )  )   ) {
       q_index = (  1 << ( abits - 3 )  ) - q_index;
       q_index = -q_index;
      }  /* end if */
      subband_samples[ k ][ m ][ l ] = ( float )q_index;
     }  /* end for */
    break;
    case 3: {
     int block_code1, block_code2, size, levels;
     int block[ 8 ];
     switch ( abits ) {
      case 1:
       size   = 7;
       levels = 3;
      break;
      case 2:
       size   = 10;
       levels =  5;
      break;
      case 3:
       size   = 12;
       levels =  7;
      break;
      case 4:
       size   = 13;
       levels =  9;
      break;
      case 5:
       size   = 15;
       levels = 13;
      break;
      case 6:
       size   = 17;
       levels = 17;
      break;
      case 7 :
      default:
       size   = 19;
       levels = 25;
      break;
     }  /* end switch */
     block_code1 = bitstream_get ( state, size );
     _dts_decode_blockcode ( block_code1, levels, block );
     block_code2 = bitstream_get ( state, size );
     _dts_decode_blockcode ( block_code2, levels, &block[ 4 ] );
     for ( m = 0; m < 8; ++m )
      subband_samples[ k ][ m ][ l ] = ( float )block[ m ];
    } break;
    default: return -1;
   }  /* end switch */
   if ( state -> transition_mode[ k ][ l ] &&
        subsubframe >= state -> transition_mode[ k ][ l ]
   )
    rscale = quant_step_size * state->scale_factor[ k ][ l ][ 1 ];
   else rscale = quant_step_size * state -> scale_factor[ k ][ l ][ 0 ];
   rscale *= state -> scalefactor_adj[ k ][ sel ];
   for ( m = 0; m < 8; ++m ) subband_samples[ k ][ m ][ l ] *= rscale;
   if ( state -> prediction_mode[ k ][ l ] ) {
    int n;
    for ( m = 0; m < 8; ++m )
     for ( n = 1; n <= 4; ++n )
      if ( m - n >= 0 )
       subband_samples[ k ][ m ][ l ] +=
        (  ( short )adpcm_vb[  state -> prediction_vq[ k ][ l ]  ][ n - 1 ]  ) *
        subband_samples[ k ][ m - n ][ l ] / 8192;
      else if ( state -> predictor_history )
       subband_samples[ k ][ m ][ l ] +=
        (  ( short )adpcm_vb[  state -> prediction_vq[ k ][ l ]  ][ n - 1 ]  ) *
        state -> subband_samples_hist[ k ][ m - n + 4 ][ l ] / 8192;
   }  /* end if */
  }  /* end for */
  for ( l = state -> vq_start_subband[ k ];
        l < state -> subband_activity[ k ];
      ++l
  ) {
   int m;
   for ( m = 0; m < 8; ++m )
    subband_samples[ k ][ m ][ l ] = 
     high_freq_vq[  state -> high_freq_vq[ k ][ l ]  ][ subsubframe * 8 + m ] *
     ( float )state -> scale_factor[ k ][ l ][ 0 ] / 16.0F;
  }  /* end for */
 }  /* end for */

 if ( state -> aspf || subsubframe == state -> subsubframes - 1 )
  bitstream_get ( state, 16 );

 for ( k = 0; k < state -> prim_channels; ++k ) {
  int m;
  for ( m = 0; m < 4; ++m )
   for ( l = 0; l < state -> vq_start_subband[ k ]; ++l )
    state -> subband_samples_hist[ k ][ m ][ l ] = subband_samples[ k ][ 4 + m ][ l ];
 }  /* end for */

 qmf_32_subbands ( state, subband_samples );

 k = CONVERT( state -> amode, state -> output & DTS_CHANNEL_MASK );

 if ( state -> prim_channels < dts_channels[ state -> output & DTS_CHANNEL_MASK ] )
  dts_upmix ( state -> samples, k );
 else if ( state -> prim_channels > dts_channels[ state -> output & DTS_CHANNEL_MASK ] )
  dts_downmix (
   state -> samples, &state -> bias, state -> slev, k
  );
 else for ( k = 0; k < 256 * state -> prim_channels; ++k  ) state -> samples[ k ] += state -> bias;

 if ( state -> output & DTS_LFE ) {
  int lfe_samples = 2 * state -> lfe * state -> subsubframes;
  int i_channels  = dts_channels[ state -> output & DTS_CHANNEL_MASK ];
  lfe_interpolation_fir (
   state -> lfe, 2 * state -> lfe, state -> lfe_data + lfe_samples + 2 * state -> lfe * subsubframe,
   &state -> samples[ 256 * i_channels ], state -> bias
  );
 }  /* end if */

 return 0;

}  /* end _dts_subsubframe */

static int dts_subframe_header ( void ) {

 int          j, k;
 dts_state_t* state = &s_DTSCtx;
 int          joint_huff[ DTS_PRIM_CHANNELS_MAX ];

 state -> subsubframes = bitstream_get ( state, 2 ) + 1;
 bitstream_get ( state, 3 );

 for ( j = 0; j < state -> prim_channels; ++j )
  for ( k = 0; k < state -> subband_activity[ j ]; ++k )
   state -> prediction_mode[ j ][ k ] = bitstream_get ( state, 1 );

 for ( j = 0; j < state -> prim_channels; ++j )
  for ( k = 0; k < state -> subband_activity[ j ]; ++k )
   if ( state -> prediction_mode[ j ][ k ] > 0 )
    state -> prediction_vq[ j ][ k ] = bitstream_get ( state, 12 );

 for ( j = 0; j < state -> prim_channels; ++j )
  for ( k = 0; k < state -> vq_start_subband[ j ]; ++k ) {
   if ( state -> bitalloc_huffman[ j ] == 6 )
    state -> bitalloc[ j ][ k ] = bitstream_get ( state, 5 );
   else if ( state -> bitalloc_huffman[ j ] == 5 )
    state -> bitalloc[ j ][ k ] = bitstream_get ( state, 4 );
   else state -> bitalloc[ j ][ k ] = _dts_inverseq (
         state, bitalloc_12[  state -> bitalloc_huffman[ j ]  ]
        );
   if ( state -> bitalloc[ j ][ k ] > 26 ) return -1;
  }  /* end for */

 for ( j = 0; j < state -> prim_channels; ++j )
  for ( k = 0; k < state -> subband_activity[ j ]; ++k ) {
   state -> transition_mode[ j ][ k ] = 0;
   if ( state -> subsubframes > 1          &&
        k < state -> vq_start_subband[ j ] &&
        state -> bitalloc[ j ][ k ] > 0
   ) state -> transition_mode[ j ][ k ] = _dts_inverseq (
      state, tmode[  state -> transient_huffman[ j ]  ]
     );
  }  /* end for */

 for ( j = 0; j < state -> prim_channels; ++j ) {
  const int* scale_table;
  int        scale_sum;
  for ( k = 0; k < state -> subband_activity[ j ]; ++k ) {
   state -> scale_factor[ j ][ k ][ 0 ] = 0;
   state -> scale_factor[ j ][ k ][ 1 ] = 0;
  }  /* end for */
  if ( state -> scalefactor_huffman[ j ] == 6 )
   scale_table = scale_factor_quant7;
  else scale_table = scale_factor_quant6;
  scale_sum = 0;
  for ( k = 0; k < state -> subband_activity[ j ]; ++k ) {
   if ( k >= state -> vq_start_subband[ j ] || state -> bitalloc[ j ][ k ] > 0 ) {
    if ( state -> scalefactor_huffman[ j ] < 5 )
     scale_sum += _dts_inverseq (
      state, scales_129[  state -> scalefactor_huffman[ j ]  ]
     );
    else if ( state -> scalefactor_huffman[ j ] == 5 )
     scale_sum = bitstream_get ( state, 6 );
    else if ( state -> scalefactor_huffman[ j ] == 6 )
     scale_sum = bitstream_get ( state, 7 );
    state -> scale_factor[ j ][ k ][ 0 ] = scale_table[ scale_sum ];
   }  /* end if */
   if ( k < state -> vq_start_subband[ j ] && state -> transition_mode[ j ][ k ] ) {
    if ( state -> scalefactor_huffman[ j ] < 5 )
     scale_sum += _dts_inverseq (
      state, scales_129[  state -> scalefactor_huffman[ j ]  ]
     );
    else if ( state -> scalefactor_huffman[ j ] == 5 )
     scale_sum = bitstream_get ( state, 6 );
    else if ( state -> scalefactor_huffman[ j ] == 6 )
     scale_sum = bitstream_get ( state, 7 );
    state -> scale_factor[ j ][ k ][ 1 ] = scale_table[ scale_sum ];
   }  /* end if */
  }  /* end for */
 }  /* end for */

 for ( j = 0; j < state -> prim_channels; ++j )
  if ( state -> joint_intensity[ j ] > 0 )
   joint_huff[ j ] = bitstream_get ( state, 3 );

 for ( j = 0; j < state -> prim_channels; ++j ) {
  int source_channel;
  if ( state -> joint_intensity[ j ] > 0 ) {
   source_channel = state -> joint_intensity[ j ] - 1;
   for ( k = state -> subband_activity[ j ];
         k < state -> subband_activity[ source_channel ];
       ++k
   ) {
    if ( joint_huff[ j ] < 5 )
     _dts_inverseq (
      state, scales_129[  joint_huff[ j ]  ]
     );
    else if ( joint_huff[ j ] == 5 )
     bitstream_get ( state, 6 );
    else if ( joint_huff[ j ] == 6 )
     bitstream_get ( state, 7 );
   }  /* end for */
  }  /* end if */
 }  /* end for */

 if ( state -> prim_channels > 2 && state -> downmix )
  for ( j = 0; j < state -> prim_channels; ++j ) bitstream_get ( state, 14 );

 if ( state -> dynrange    ) bitstream_get ( state,  8 );
 if ( state -> crc_present ) bitstream_get ( state, 16 );

 for ( j = 0; j < state -> prim_channels; ++j )
  for ( k = state -> vq_start_subband[ j ];
        k < state -> subband_activity[ j ];
      ++k
  ) state -> high_freq_vq[ j ][ k ] = bitstream_get ( state, 10 );

 if ( state -> lfe ) {
  int   lfe_scale_factor;
  int   lfe_samples = 2 * state -> lfe * state -> subsubframes;
  float lfe_scale;
  for ( j = lfe_samples; j < lfe_samples * 2; ++j )
   state -> lfe_data[ j ] = ( float )( signed int )( signed char )bitstream_get ( state, 8 );
  lfe_scale_factor = scale_factor_quant7[ bitstream_get ( state, 8 ) ];
  lfe_scale = 0.035F * lfe_scale_factor;
  for ( j = lfe_samples; j < lfe_samples * 2; ++j ) state -> lfe_data[ j ] *= lfe_scale;
 }  /* end if */

 return 0;

}  /* end dts_subframe_header */

static int dts_subframe_footer ( void ) {

 dts_state_t* state = &s_DTSCtx;
 int          i, aux_data_count = 0;
 int          lfe_samples;

 if ( state -> timestamp ) bitstream_get ( state, 32 );
 if ( state -> aux_data  ) aux_data_count = bitstream_get ( state, 6 );

 for ( i = 0; i < aux_data_count; ++i ) bitstream_get ( state, 8 );

 if (  state -> crc_present && ( state -> downmix || state -> dynrange )  )
  bitstream_get ( state, 16 );

 lfe_samples = 2 * state -> lfe * state -> subsubframes;

 for ( i = 0; i < lfe_samples; ++i )
  state -> lfe_data[ i ] = state -> lfe_data[ i + lfe_samples ];

 return 0;

}  /* end dts_subframe_footer */

static int _dts_block ( void ) {

 dts_state_t* state = &s_DTSCtx;

 if (  state -> current_subframe >= state -> subframes          ) return -1;
 if (  !state -> current_subsubframe && dts_subframe_header ()  ) return -1;
 if (  _dts_subsubframe ()                                      ) return -1;

 ++state -> current_subsubframe;

 if ( state -> current_subsubframe >= state -> subsubframes ) {
    state -> current_subsubframe = 0;
  ++state -> current_subframe;
 }  /* end if */

 if (  state -> current_subframe >= state -> subframes && dts_subframe_footer ()  ) return -1;

 return 0;

}  /* end _dts_block */

int DTS_Channels ( int aFlags ) {

 if ( aFlags & DTS_LFE )
  return 6;
 else if ( aFlags & 1 )
  return 5;
 else if (  ( aFlags & DTS_CHANNEL_MASK ) == DTS_2F2R  )
  return 4;
 else return 2;

}  /* end DTS_Channels */

void _dts_float_to_int_1 ( short*, float* );
void _dts_float_to_int_2 ( short*, float* );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 "_dts_float_to_int_1:\n\t"
 "jr        $ra\n\t"
 "nop\n\t"
 "_dts_float_to_int_2:\n\t"
 "lui       $at, 0x43C0\n\t"
 "addiu     $a2, $a1, 1024\n\t"
 "pextlw    $at, $at, $at\n\t"
 "pextlw    $at, $at, $at\n\t"
 "pnor      $v1, $zero, $zero\n\t"
 "psllw     $v0, $v1, 31\n\t"
 "psrlw     $v1, $v1, 17\n\t"
 "psraw     $v0, $v0, 16\n\t"
 "1:\n\t"
 "lq        $t0,    0($a1)\n\t"
 "lq        $t1,   16($a1)\n\t"
 "lq        $t2, 1024($a1)\n\t"
 "lq        $t3, 1040($a1)\n\t"
 "addiu     $a1, $a1, 32\n\t"
 "addiu     $a0, $a0, 32\n\t"
 "psubw     $t0, $t0, $at\n\t"
 "psubw     $t1, $t1, $at\n\t"
 "psubw     $t2, $t2, $at\n\t"
 "psubw     $t3, $t3, $at\n\t"
 "pmaxw     $t0, $t0, $v0\n\t"
 "pmaxw     $t1, $t1, $v0\n\t"
 "pmaxw     $t2, $t2, $v0\n\t"
 "pmaxw     $t3, $t3, $v0\n\t"
 "pminw     $t0, $t0, $v1\n\t"
 "pminw     $t1, $t1, $v1\n\t"
 "pminw     $t2, $t2, $v1\n\t"
 "pminw     $t3, $t3, $v1\n\t"
 "pinteh    $t0, $t2, $t0\n\t"
 "pinteh    $t1, $t3, $t1\n\t"
 "sq        $t0, -32($a0)\n\t"
 "bne       $a1, $a2, 1b\n\t"
 "sq        $t1, -16($a0)\n\t"
 "jr    $ra\n\t"
 "nop\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

static int _dts_decode ( SMS_RingBuffer* apRB, int anChannels, int aLen ) {

 static void ( *s_FloatToInt[ 2 ] ) ( short*, float* ) = {
  _dts_float_to_int_1, _dts_float_to_int_2
 };

 int    lFlags = s_DTSCtx.m_Flags;
 float  lLevel = 1.0F;
 int    i, lnBlocks, retVal;
 short* lpOutBuf;

 void ( *_dts_float_to_int ) ( short*, float* ) = s_FloatToInt[ anChannels - 1 ];

 if ( anChannels == 1 )
  lFlags = DTS_MONO;
 else if ( anChannels == 2 )
  lFlags = DTS_STEREO;
 else lFlags |= DTS_ADJUST_LEVEL;

 if (  _dts_frame ( s_DTSCtx.m_InBuf, &lFlags, &lLevel, 384.0F )  ) {

  s_DTSCtx.m_pInBuf    = s_DTSCtx.m_InBuf;
  s_DTSCtx.m_FrameSize = 0;

  return 0;

 }  /* end if */

 lnBlocks    = s_DTSCtx.sample_blocks;
 anChannels += 7;
 retVal      = lnBlocks << ( anChannels + 1 );
 lpOutBuf    = ( short* )SMS_RingBufferAlloc ( apRB, retVal + 80 );
 lpOutBuf   += 32;
 *( int* )lpOutBuf = retVal;
 lpOutBuf   += 8;

 for ( i = 0; i < lnBlocks; ++i ) {

  _dts_block ();
  _dts_float_to_int (  lpOutBuf + ( i << anChannels ), s_DTSCtx.samples  );

 }  /* end for */

 return retVal;

}  /* end _dts_decode */

void SMS_swab ( void*, const void*, int );
__asm__(
 ".set noreorder\n\t"
 ".set nomacro\n\t"
 ".set noat\n\t"
 ".text\n\t"
 "SMS_swab:\n\t"
 "mtsab     $a1, 0\n\t"
 "srl       $t6, $a2, 5\n\t"
 "1:\n\t"
 "lq        $v1,  0($a1)\n\t"
 "lq        $t9, 16($a1)\n\t"
 "lq        $at, 32($a1)\n\t"
 "qfsrv     $v1, $t9, $v1\n\t"
 "qfsrv     $t9, $at, $t9\n\t"
 "psllh     $t8, $v1, 8\n\t"
 "psllh     $t7, $t9, 8\n\t"
 "psrlh     $v1, $v1, 8\n\t"
 "psrlh     $t9, $t9, 8\n\t"
 "por       $t8, $v1, $t8\n\t"
 "por       $t7, $t9, $t7\n\t"
 "pcpyud    $v1, $t8, $zero\n\t"
 "pcpyud    $t9, $t7, $zero\n\t"
 "sd        $t8,  0($a0)\n\t"
 "sd        $v1,  8($a0)\n\t"
 "sd        $t7, 16($a0)\n\t"
 "sd        $t9, 24($a0)\n\t"
 "addiu     $t6, $t6, -1\n\t"
 "addiu     $a1, $a1, 32\n\t"
 "bgtz      $t6, 1b\n\t"
 "addiu     $a0, $a0, 32\n\t"
 "jr        $ra\n\t"
 "nop\n\t"
 ".set at\n\t"
 ".set macro\n\t"
 ".set reorder\n\t"
);

static int _dts_spdif ( SMS_RingBuffer* apRB, int anChannels, int aLen ) {

 int            retVal, lFlags, lSampleRate, lBitRate, lnSamples, lBurstLen;
 unsigned char* lpOutBuf;

 aLen              = DTS_SyncInfo ( s_DTSCtx.m_InBuf, &lFlags, &lSampleRate, &lBitRate, &lnSamples );
 retVal            = lnSamples  << 2;
 lBurstLen         = aLen       << 3;
 lpOutBuf          = SMS_RingBufferAlloc ( apRB, retVal + 80 );
 lpOutBuf         += 64;
 *( int* )lpOutBuf = retVal;
 lpOutBuf         += 16;

 (  ( uint16_t* )lpOutBuf  )[ 0 ] = 0xF872;
 (  ( uint16_t* )lpOutBuf  )[ 1 ] = 0x4E1F;

 switch ( lnSamples ) {
  case  512: lpOutBuf[ 4 ] = 0x0B; break;
  case 1024: lpOutBuf[ 4 ] = 0x0C; break;
  case 2048: lpOutBuf[ 4 ] = 0x0D; break;
  default  : lpOutBuf[ 4 ] = 0x00; break;
 }  /* end switch */

 lpOutBuf[ 5 ] = 0;
 lpOutBuf[ 6 ] = ( lBurstLen      ) & 0xFF;   
 lpOutBuf[ 7 ] = ( lBurstLen >> 8 ) & 0xFF;

 __asm__ __volatile__(
  ".set noreorder\n\t"
  "srl      $t6, %2, 5\n\t"
  "1:\n\t"
  "lq       $v1,  0(%1)\n\t"
  "lq       $t9, 16(%1)\n\t"
  "psllh    $t8, $v1, 8\n\t"
  "psllh    $t7, $t9, 8\n\t"
  "psrlh    $v1, $v1, 8\n\t"
  "psrlh    $t9, $t9, 8\n\t"
  "por      $t8, $v1, $t8\n\t"
  "por      $t7, $t9, $t7\n\t"
  "pcpyud   $v1, $t8, $zero\n\t"
  "pcpyud   $t9, $t7, $zero\n\t"
  "sd       $t8,  0(%0)\n\t"
  "sd       $v1,  8(%0)\n\t"
  "sd       $t7, 16(%0)\n\t"
  "sd       $t9, 24(%0)\n\t"
  "addiu    $t6, $t6, -1\n\t"
  "addiu    %1, %1, 32\n\t"
  "bgtz     $t6, 1b\n\t"
  "addiu    %0, %0, 32\n\t"
  ".set reorder\n\t"
  :: "r"( lpOutBuf + 8 ), "r"( s_DTSCtx.m_InBuf ), "r"( aLen + 31 )
   : "v1", "t6", "t7", "t8", "t9", "at"
 );

 memset ( lpOutBuf + 8 + aLen, 0, retVal - 8 - aLen );

 return retVal;

}  /* end _dts_spdif */

static int32_t DTS_Decode ( SMS_CodecContext* apCtx, SMS_RingBuffer* apOutput, SMS_RingBuffer* apInput ) {

 SMS_AVPacket* lpPkt = ( SMS_AVPacket* )apInput -> m_pOut;
 int           lLen;
 int           lSampleRate, lBitRate, lFrameLen;
 uint8_t*      lpBuf    = lpPkt -> m_pData;
 int32_t       lBufSize = lpPkt -> m_Size;
 int           retVal   = 0;

 if ( s_DTSCtx.m_Len ) {

  lpBuf    = s_DTSCtx.m_pPos;
  lBufSize = s_DTSCtx.m_Len;

 } else {

  s_DTSCtx.m_pPos = lpBuf;
  s_DTSCtx.m_Len  = lBufSize;

 }  /* end else */

 while ( lBufSize > 0 ) {

  lLen = s_DTSCtx.m_pInBuf - s_DTSCtx.m_InBuf;

  if ( s_DTSCtx.m_FrameSize == 0 ) {

   lLen = HEADER_SIZE - lLen;

   if ( lLen > lBufSize ) lLen = lBufSize;

   memcpy ( s_DTSCtx.m_pInBuf, lpBuf, lLen );

   lpBuf             += lLen;
   s_DTSCtx.m_pInBuf += lLen;
   lBufSize          -= lLen;

   if ( s_DTSCtx.m_pInBuf - s_DTSCtx.m_InBuf == HEADER_SIZE ) {

    lLen = DTS_SyncInfo (
     s_DTSCtx.m_InBuf, &s_DTSCtx.m_Flags, &lSampleRate, &lBitRate, &lFrameLen
    );

    if ( lLen == 0 ) {

     memcpy ( s_DTSCtx.m_InBuf, s_DTSCtx.m_InBuf + 1, HEADER_SIZE - 1 );
     --s_DTSCtx.m_pInBuf;

    } else {

     s_DTSCtx.m_FrameSize  = lLen;
     apCtx -> m_SampleRate = lSampleRate;
     s_DTSCtx.m_nChannels  = DTS_Channels ( s_DTSCtx.m_Flags );

     if ( apCtx -> m_Channels == 0 )

      apCtx -> m_Channels = s_DTSCtx.m_nChannels;

     else if ( s_DTSCtx.m_nChannels < apCtx -> m_Channels )

      apCtx -> m_Channels = s_DTSCtx.m_nChannels;

    }  /* end else */

    apCtx -> m_BitRate = lBitRate;

   }  /* end if */

  } else if ( lLen < s_DTSCtx.m_FrameSize ) {

   lLen = s_DTSCtx.m_FrameSize - lLen;

   if ( lLen > lBufSize ) lLen = lBufSize;

   memcpy ( s_DTSCtx.m_pInBuf, lpBuf, lLen );

   lpBuf             += lLen;
   s_DTSCtx.m_pInBuf += lLen;
   lBufSize          -= lLen;

  } else {

   if (   !(  retVal = DecodeFrame ( apOutput, apCtx -> m_Channels, lLen )  )   ) continue;

   s_DTSCtx.m_pInBuf    = s_DTSCtx.m_InBuf;
   s_DTSCtx.m_FrameSize = 0;
   apOutput -> UserCB ( apOutput );

   break;

  }  /* end else */

 }  /* end while */

 lLen = lpBuf - s_DTSCtx.m_pPos;

 s_DTSCtx.m_Len  -= lLen;
 s_DTSCtx.m_pPos += lLen;

 return s_DTSCtx.m_Len;

}  /* end DTS_Decode */

