﻿using System.Linq;
using System.Numerics;
using Algorithms.Sequences;
using FluentAssertions;
using NUnit.Framework;

namespace Algorithms.Tests.Sequences;

public class LucasNumbersBeginningAt2SequenceTests
{
    [Test]
    public void FirstElementsCorrect()
    {
        //  Initial test of 38 values from http://oeis.org/A000032/list which passed.
        //  Testing 200 Lucas numbers, with values from https://r-knott.surrey.ac.uk/Fibonacci/lucas200.html and
        //  compared to initial 38, which passed.
        //  Assigning numeric values to BigInteger types performed by string parsing dues to length of value.
        var bigNumbers = new[] {
                                   "2", "1", "3", "4", "7", "11", "18", "29", "47", "76", "123", "199", "322",
                                   "521", "843", "1364", "2207", "3571", "5778", "9349", "15127", "24476",
                                   "39603", "64079", "103682", "167761", "271443", "439204", "710647", "1149851",
                                   "1860498", "3010349", "4870847", "7881196", "12752043", "20633239", "33385282",
                                   "54018521", "87403803", "141422324", "228826127", "370248451", "599074578",
                                   "969323029", "1568397607", "2537720636", "4106118243", "6643838879",
                                   "10749957122", "17393796001", "28143753123", "45537549124", "73681302247",
                                   "119218851371", "192900153618", "312119004989", "505019158607", "817138163596",
                                   "1322157322203", "2139295485799", "3461452808002", "5600748293801",
                                   "9062201101803", "14662949395604", "23725150497407", "38388099893011",
                                   "62113250390418", "100501350283429", "162614600673847", "263115950957276",
                                   "425730551631123", "688846502588399", "1114577054219522", "1803423556807921",
                                   "2918000611027443", "4721424167835364", "7639424778862807",
                                   "12360848946698171", "20000273725560978", "32361122672259149",
                                   "52361396397820127", "84722519070079276", "137083915467899403",
                                   "221806434537978679", "358890350005878082", "580696784543856761",
                                   "939587134549734843", "1520283919093591604", "2459871053643326447",
                                   "3980154972736918051", "6440026026380244498", "10420180999117162549",
                                   "16860207025497407047", "27280388024614569596", "44140595050111976643",
                                   "71420983074726546239", "115561578124838522882", "186982561199565069121",
                                   "302544139324403592003", "489526700523968661124", "792070839848372253127",
                                   "1281597540372340914251", "2073668380220713167378", "3355265920593054081629",
                                   "5428934300813767249007", "8784200221406821330636", "14213134522220588579643",
                                   "22997334743627409910279", "37210469265847998489922",
                                   "60207804009475408400201", "97418273275323406890123",
                                   "157626077284798815290324", "255044350560122222180447",
                                   "412670427844921037470771", "667714778405043259651218",
                                   "1080385206249964297121989", "1748099984655007556773207",
                                   "2828485190904971853895196", "4576585175559979410668403",
                                   "7405070366464951264563599", "11981655542024930675232002",
                                   "19386725908489881939795601", "31368381450514812615027603",
                                   "50755107359004694554823204", "82123488809519507169850807",
                                   "132878596168524201724674011", "215002084978043708894524818"
                                 , "347880681146567910619198829", "562882766124611619513723647",
                                   "910763447271179530132922476", "1473646213395791149646646123",
                                   "2384409660666970679779568599", "3858055874062761829426214722",
                                   "6242465534729732509205783321", "10100521408792494338631998043",
                                   "16342986943522226847837781364", "26443508352314721186469779407",
                                   "42786495295836948034307560771", "69230003648151669220777340178",
                                   "112016498943988617255084900949", "181246502592140286475862241127",
                                   "293263001536128903730947142076", "474509504128269190206809383203",
                                   "767772505664398093937756525279", "1242282009792667284144565908482",
                                   "2010054515457065378082322433761", "3252336525249732662226888342243",
                                   "5262391040706798040309210776004", "8514727565956530702536099118247",
                                   "13777118606663328742845309894251", "22291846172619859445381409012498",
                                   "36068964779283188188226718906749", "58360810951903047633608127919247",
                                   "94429775731186235821834846825996", "152790586683089283455442974745243",
                                   "247220362414275519277277821571239", "400010949097364802732720796316482",
                                   "647231311511640322009998617887721", "1047242260609005124742719414204203",
                                   "1694473572120645446752718032091924", "2741715832729650571495437446296127",
                                   "4436189404850296018248155478388051", "7177905237579946589743592924684178",
                                   "11614094642430242607991748403072229", "18791999880010189197735341327756407",
                                   "30406094522440431805727089730828636", "49198094402450621003462431058585043",
                                   "79604188924891052809189520789413679", "128802283327341673812651951847998722",
                                   "208406472252232726621841472637412401", "337208755579574400434493424485411123",
                                   "545615227831807127056334897122823524", "882823983411381527490828321608234647",
                                   "1428439211243188654547163218731058171",
                                   "2311263194654570182037991540339292818",
                                   "3739702405897758836585154759070350989",
                                   "6050965600552329018623146299409643807",
                                   "9790668006450087855208301058479994796",
                                   "15841633607002416873831447357889638603",
                                   "25632301613452504729039748416369633399",
                                   "41473935220454921602871195774259272002",
                                   "67106236833907426331910944190628905401",
                                   "108580172054362347934782139964888177403",
                                   "175686408888269774266693084155517082804",
                                   "284266580942632122201475224120405260207",
                                   "459952989830901896468168308275922343011",
                                   "744219570773534018669643532396327603218",
                                   "1204172560604435915137811840672249946229",
                                   "1948392131377969933807455373068577549447",
                                   "3152564691982405848945267213740827495676",
                                   "5100956823360375782752722586809405045123",
                                   "8253521515342781631697989800550232540799",
                                   "13354478338703157414450712387359637585922",
                                   "21607999854045939046148702187909870126721",
                                   "34962478192749096460599414575269507712643",
                                   "56570478046795035506748116763179377839364",
                                   "91532956239544131967347531338448885552007",
                                   "148103434286339167474095648101628263391371",
                                   "239636390525883299441443179440077148943378",
                                   "387739824812222466915538827541705412334749",
                                   "627376215338105766356982006981782561278127",
                               };

        var check    = bigNumbers.Select(BigInteger.Parse).ToArray();
        var sequence = new LucasNumbersBeginningAt2Sequence().Sequence.Take(check.Length);
        sequence.SequenceEqual(check).Should().BeTrue();
    }
}
