import type { App } from 'vue'
import type { RouteRecordRaw } from 'vue-router'
import { createRouter, createWebHashHistory } from 'vue-router'
import { ChatLayout } from '@/views/chat/layout'

const routes: RouteRecordRaw[] = [
  {
    path: '/',
    name: 'Root',
    component: ChatLayout,
    redirect: '/chat',
    children: [
      {
        path: '/chat/:uuid?',
        name: 'Chat',
        component: () => import('@/views/chat/index.vue'),
      },
    ],
  },

  {
    path: '/404',
    name: '404',
    component: () => import('@/views/exception/404/index.vue'),
  },

  {
    path: '/500',
    name: '500',
    component: () => import('@/views/exception/500/index.vue'),
  },
  {
    path: '/balance',
    name: 'balance',
    component: () => import('@/views/other/balance/index.vue'),
  },
  {
    path: '/image',
    name: 'image',
    component: () => import('@/views/chat/layout/image/index.vue'),
  },
  {
    path: '/login',
    name: 'login',
    component: () => import('@/views/chat/layout/Login.vue'),
  },
  {
    path: '/register',
    name: 'register',
    component: () => import('@/views/chat/layout/Register.vue'),
  },
  {
    path: '/changePassword',
    name: 'changePassword',
    component: () => import('@/views/chat/layout/ChangePassword.vue'),
  },
  {
    path: '/:pathMatch(.*)*',
    name: 'notFound',
    redirect: '/404',
  },
]

export const router = createRouter({
  history: createWebHashHistory(),
  routes,
  scrollBehavior: () => ({ left: 0, top: 0 }),
})
// 未登录用户有预览权限，在此注释路由
// setupPageGuard(router)

export async function setupRouter(app: App) {
  app.use(router)
  await router.isReady()
}
