#coding=utf-8
"""
Tencent is pleased to support the open source community by making HaboMalHunter available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the MIT License (the "License"); you may not use this file except in 
compliance with the License. You may obtain a copy of the License at

http://opensource.org/licenses/MIT

Unless required by applicable law or agreed to in writing, software distributed under the 
License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
either express or implied. See the License for the specific language governing permissions 
and limitations under the License.
"""
"""
Author: 
Date:	November 05, 2016
Description: Linux Malware Analysis System, Syscall Name to Int
data from: /usr/include/asm-generic/unistd.h
"""

syscall_table={}

def Add_SysCall(id, name):
	global syscall_table
	syscall_table[name]=id

Add_SysCall(0, "io_setup")
Add_SysCall(1, "io_destroy")
Add_SysCall(2, "io_submit")
Add_SysCall(3, "io_cancel")
Add_SysCall(4, "io_getevents")
Add_SysCall(5, "setxattr")
Add_SysCall(6, "lsetxattr")
Add_SysCall(7, "fsetxattr")
Add_SysCall(8, "getxattr")
Add_SysCall(9, "lgetxattr")
Add_SysCall(10, "fgetxattr")
Add_SysCall(11, "listxattr")
Add_SysCall(12, "llistxattr")
Add_SysCall(13, "flistxattr")
Add_SysCall(14, "removexattr")
Add_SysCall(15, "lremovexattr")
Add_SysCall(16, "fremovexattr")
Add_SysCall(17, "getcwd")
Add_SysCall(18, "lookup_dcookie")
Add_SysCall(19, "eventfd2")
Add_SysCall(20, "epoll_create1")
Add_SysCall(21, "epoll_ctl")
Add_SysCall(22, "epoll_pwait")
Add_SysCall(23, "dup")
Add_SysCall(24, "dup3")
Add_SysCall(26, "inotify_init1")
Add_SysCall(27, "inotify_add_watch")
Add_SysCall(28, "inotify_rm_watch")
Add_SysCall(29, "ioctl")
Add_SysCall(30, "ioprio_set")
Add_SysCall(31, "ioprio_get")
Add_SysCall(32, "flock")
Add_SysCall(33, "mknodat")
Add_SysCall(34, "mkdirat")
Add_SysCall(35, "unlinkat")
Add_SysCall(36, "symlinkat")
Add_SysCall(37, "linkat")
Add_SysCall(38, "renameat")
Add_SysCall(39, "umount2")
Add_SysCall(40, "mount")
Add_SysCall(41, "pivot_root")
Add_SysCall(42, "nfsservctl")
Add_SysCall(47, "fallocate")
Add_SysCall(48, "faccessat")
Add_SysCall(49, "chdir")
Add_SysCall(50, "fchdir")
Add_SysCall(51, "chroot")
Add_SysCall(52, "fchmod")
Add_SysCall(53, "fchmodat")
Add_SysCall(54, "fchownat")
Add_SysCall(55, "fchown")
Add_SysCall(56, "openat")
Add_SysCall(57, "close")
Add_SysCall(58, "vhangup")
Add_SysCall(59, "pipe2")
Add_SysCall(60, "quotactl")
Add_SysCall(61, "getdents64")
Add_SysCall(63, "read")
Add_SysCall(64, "write")
Add_SysCall(65, "readv")
Add_SysCall(66, "writev")
Add_SysCall(67, "pread64")
Add_SysCall(68, "pwrite64")
Add_SysCall(69, "preadv")
Add_SysCall(70, "pwritev")
Add_SysCall(72, "pselect6")
Add_SysCall(73, "ppoll")
Add_SysCall(74, "signalfd4")
Add_SysCall(75, "vmsplice")
Add_SysCall(76, "splice")
Add_SysCall(77, "tee")
Add_SysCall(78, "readlinkat")
Add_SysCall(81, "sync")
Add_SysCall(82, "fsync")
Add_SysCall(83, "fdatasync")
Add_SysCall(84, "sync_file_range")
Add_SysCall(85, "timerfd_create")
Add_SysCall(86, "timerfd_settime")
Add_SysCall(87, "timerfd_gettime")
Add_SysCall(88, "utimensat")
Add_SysCall(89, "acct")
Add_SysCall(90, "capget")
Add_SysCall(91, "capset")
Add_SysCall(92, "personality")
Add_SysCall(93, "exit")
Add_SysCall(94, "exit_group")
Add_SysCall(95, "waitid")
Add_SysCall(96, "set_tid_address")
Add_SysCall(97, "unshare")
Add_SysCall(98, "futex")
Add_SysCall(99, "set_robust_list")
Add_SysCall(100, "get_robust_list")
Add_SysCall(101, "nanosleep")
Add_SysCall(102, "getitimer")
Add_SysCall(103, "setitimer")
Add_SysCall(104, "kexec_load")
Add_SysCall(105, "init_module")
Add_SysCall(106, "delete_module")
Add_SysCall(107, "timer_create")
Add_SysCall(108, "timer_gettime")
Add_SysCall(109, "timer_getoverrun")
Add_SysCall(110, "timer_settime")
Add_SysCall(111, "timer_delete")
Add_SysCall(112, "clock_settime")
Add_SysCall(113, "clock_gettime")
Add_SysCall(114, "clock_getres")
Add_SysCall(115, "clock_nanosleep")
Add_SysCall(116, "syslog")
Add_SysCall(117, "ptrace")
Add_SysCall(118, "sched_setparam")
Add_SysCall(119, "sched_setscheduler")
Add_SysCall(120, "sched_getscheduler")
Add_SysCall(121, "sched_getparam")
Add_SysCall(122, "sched_setaffinity")
Add_SysCall(123, "sched_getaffinity")
Add_SysCall(124, "sched_yield")
Add_SysCall(125, "sched_get_priority_max")
Add_SysCall(126, "sched_get_priority_min")
Add_SysCall(127, "sched_rr_get_interval")
Add_SysCall(128, "restart_syscall")
Add_SysCall(129, "kill")
Add_SysCall(130, "tkill")
Add_SysCall(131, "tgkill")
Add_SysCall(132, "sigaltstack")
Add_SysCall(133, "rt_sigsuspend")
Add_SysCall(134, "rt_sigaction")
Add_SysCall(135, "rt_sigprocmask")
Add_SysCall(136, "rt_sigpending")
Add_SysCall(137, "rt_sigtimedwait")
Add_SysCall(138, "rt_sigqueueinfo")
Add_SysCall(139, "rt_sigreturn")
Add_SysCall(140, "setpriority")
Add_SysCall(141, "getpriority")
Add_SysCall(142, "reboot")
Add_SysCall(143, "setregid")
Add_SysCall(144, "setgid")
Add_SysCall(145, "setreuid")
Add_SysCall(146, "setuid")
Add_SysCall(147, "setresuid")
Add_SysCall(148, "getresuid")
Add_SysCall(149, "setresgid")
Add_SysCall(150, "getresgid")
Add_SysCall(151, "setfsuid")
Add_SysCall(152, "setfsgid")
Add_SysCall(153, "times")
Add_SysCall(154, "setpgid")
Add_SysCall(155, "getpgid")
Add_SysCall(156, "getsid")
Add_SysCall(157, "setsid")
Add_SysCall(158, "getgroups")
Add_SysCall(159, "setgroups")
Add_SysCall(160, "uname")
Add_SysCall(161, "sethostname")
Add_SysCall(162, "setdomainname")
Add_SysCall(163, "getrlimit")
Add_SysCall(164, "setrlimit")
Add_SysCall(165, "getrusage")
Add_SysCall(166, "umask")
Add_SysCall(167, "prctl")
Add_SysCall(168, "getcpu")
Add_SysCall(169, "gettimeofday")
Add_SysCall(170, "settimeofday")
Add_SysCall(171, "adjtimex")
Add_SysCall(172, "getpid")
Add_SysCall(173, "getppid")
Add_SysCall(174, "getuid")
Add_SysCall(175, "geteuid")
Add_SysCall(176, "getgid")
Add_SysCall(177, "getegid")
Add_SysCall(178, "gettid")
Add_SysCall(179, "sysinfo")
Add_SysCall(180, "mq_open")
Add_SysCall(181, "mq_unlink")
Add_SysCall(182, "mq_timedsend")
Add_SysCall(183, "mq_timedreceive")
Add_SysCall(184, "mq_notify")
Add_SysCall(185, "mq_getsetattr")
Add_SysCall(186, "msgget")
Add_SysCall(187, "msgctl")
Add_SysCall(188, "msgrcv")
Add_SysCall(189, "msgsnd")
Add_SysCall(190, "semget")
Add_SysCall(191, "semctl")
Add_SysCall(192, "semtimedop")
Add_SysCall(193, "semop")
Add_SysCall(194, "shmget")
Add_SysCall(195, "shmctl")
Add_SysCall(196, "shmat")
Add_SysCall(197, "shmdt")
Add_SysCall(198, "socket")
Add_SysCall(199, "socketpair")
Add_SysCall(200, "bind")
Add_SysCall(201, "listen")
Add_SysCall(202, "accept")
Add_SysCall(203, "connect")
Add_SysCall(204, "getsockname")
Add_SysCall(205, "getpeername")
Add_SysCall(206, "sendto")
Add_SysCall(207, "recvfrom")
Add_SysCall(208, "setsockopt")
Add_SysCall(209, "getsockopt")
Add_SysCall(210, "shutdown")
Add_SysCall(211, "sendmsg")
Add_SysCall(212, "recvmsg")
Add_SysCall(213, "readahead")
Add_SysCall(214, "brk")
Add_SysCall(215, "munmap")
Add_SysCall(216, "mremap")
Add_SysCall(217, "add_key")
Add_SysCall(218, "request_key")
Add_SysCall(219, "keyctl")
Add_SysCall(220, "clone")
Add_SysCall(221, "execve")
# add Nov 7
Add_SysCall(222, "mmap2")
# add end
Add_SysCall(224, "swapon")
Add_SysCall(225, "swapoff")
Add_SysCall(226, "mprotect")
Add_SysCall(227, "msync")
Add_SysCall(228, "mlock")
Add_SysCall(229, "munlock")
Add_SysCall(230, "mlockall")
Add_SysCall(231, "munlockall")
Add_SysCall(232, "mincore")
Add_SysCall(233, "madvise")
Add_SysCall(234, "remap_file_pages")
Add_SysCall(235, "mbind")
Add_SysCall(236, "get_mempolicy")
Add_SysCall(237, "set_mempolicy")
Add_SysCall(238, "migrate_pages")
Add_SysCall(239, "move_pages")
Add_SysCall(240, "rt_tgsigqueueinfo")
Add_SysCall(241, "perf_event_open")
Add_SysCall(242, "accept4")
Add_SysCall(243, "recvmmsg")
Add_SysCall(260, "wait4")
Add_SysCall(261, "prlimit64")
Add_SysCall(262, "fanotify_init")
Add_SysCall(263, "fanotify_mark")
Add_SysCall(264, "name_to_handle_at")
Add_SysCall(265, "open_by_handle_at")
Add_SysCall(266, "clock_adjtime")
Add_SysCall(267, "syncfs")
Add_SysCall(268, "setns")
Add_SysCall(269, "sendmmsg")
Add_SysCall(270, "process_vm_readv")
Add_SysCall(271, "process_vm_writev")
Add_SysCall(272, "kcmp")
Add_SysCall(273, "finit_module")
# add Nov 7
Add_SysCall(1024, "open")
Add_SysCall(1025, "link")
Add_SysCall(1026, "unlink")
Add_SysCall(1027, "mknod")
Add_SysCall(1028, "chmod")
Add_SysCall(1029, "chown")
Add_SysCall(1030, "mkdir")
Add_SysCall(1031, "rmdir")
Add_SysCall(1032, "lchown")
Add_SysCall(1033, "access")
Add_SysCall(1034, "rename")
Add_SysCall(1035, "readlink")
Add_SysCall(1036, "symlink")
Add_SysCall(1037, "utimes")
Add_SysCall(1038, "stat")
Add_SysCall(1039, "lstat")
Add_SysCall(1040, "pipe")
Add_SysCall(1041, "dup2")
Add_SysCall(1042, "epoll_create")
Add_SysCall(1043, "inotify_init")
Add_SysCall(1044, "eventfd")
Add_SysCall(1045, "signalfd")
Add_SysCall(1046, "sendfile")
Add_SysCall(1047, "ftruncate")
Add_SysCall(1048, "truncate")
Add_SysCall(1049, "stat")
Add_SysCall(1050, "lstat")
Add_SysCall(1051, "fstat")
Add_SysCall(1052, "fcntl")
Add_SysCall(1053, "fadvise64")
Add_SysCall(1054, "newfstatat")
Add_SysCall(1055, "fstatfs")
Add_SysCall(1056, "statfs")
Add_SysCall(1057, "lseek")
Add_SysCall(1058, "mmap")
Add_SysCall(1059, "alarm")
Add_SysCall(1060, "getpgrp")
Add_SysCall(1061, "pause")
Add_SysCall(1062, "time")
Add_SysCall(1063, "utime")
Add_SysCall(1064, "creat")
Add_SysCall(1065, "getdents")
Add_SysCall(1066, "futimesat")
Add_SysCall(1067, "select")
Add_SysCall(1068, "poll")
Add_SysCall(1069, "epoll_wait")
Add_SysCall(1070, "ustat")
Add_SysCall(1071, "vfork")
Add_SysCall(1072, "oldwait4")
Add_SysCall(1073, "recv")
Add_SysCall(1074, "send")
Add_SysCall(1075, "bdflush")
Add_SysCall(1076, "umount")
Add_SysCall(1077, "uselib")
Add_SysCall(1078, "_sysctl")
Add_SysCall(1079, "fork")
Add_SysCall(1080, "fcntl64")
Add_SysCall(1081, "statfs64")
Add_SysCall(1082, "fstatfs64")
Add_SysCall(1083, "truncate64")
Add_SysCall(1084, "ftruncate64")
Add_SysCall(1085, "llseek")
Add_SysCall(1086, "sendfile64")
Add_SysCall(1087, "dvise64_64")
Add_SysCall(1088, "tat64")
Add_SysCall(1089, "stat64")
Add_SysCall(1090, "fstat64")
Add_SysCall(1091, "set_thread_area")
# add missing
Add_SysCall(1092, "arch_prctl")
Add_SysCall(1093, "waitpid")
# add end