# Computer Networking In Python (COS332)

Welcome to the Project Repository! This repository contains a collection of projects focusing on different server and client implementations, including CGI scripts, FTP, LDAP, POP3, SMTP servers, and more. Below is an overview of each project contained in this repository.

## Table of Contents

- [Projects](#projects)
  - [CGI Script on the Web](#cgi-script-on-the-web)
  - [CGI Scripts](#cgi-scripts)
  - [FTP Server](#ftp-server)
  - [LDAP Client](#ldap-client)
  - [POP3 Client+Proxy](#pop3-clientproxy)
  - [POP3 Server](#pop3-server)
  - [Quiz Server](#quiz-server)
  - [Quiz Web Server](#quiz-web-server)
  - [SMTP Server](#smtp-server)
- [Documentation](#documentation)
- [License](#license)
- [Contributing](#contributing)
- [Contact](#contact)

## Projects

#### CGI Script on the Web

This project demonstrates how to deploy CGI scripts on the web. It includes examples and guidelines for creating and executing CGI scripts to generate dynamic web content.

- **Location**: `CGI Script on the Web/`
- **Languages**: Python, Perl
- **Key Features**: 
  - Basic CGI script examples
  - Deployment instructions
  - Security best practices

#### CGI Scripts

A collection of CGI scripts designed for various purposes. This folder contains scripts that can be used to handle form data, generate web content dynamically, and more.

- **Location**: `CGI Scripts/`
- **Languages**: Python, Perl
- **Key Features**: 
  - Multiple script examples
  - Form handling
  - Data processing

#### FTP Server

An implementation of an FTP server that allows file transfers over the network. This project includes the setup and configuration of the server.

- **Location**: `FTP Server/`
- **Languages**: Python
- **Key Features**: 
  - FTP protocol implementation
  - User authentication
  - File upload/download

#### LDAP Client

This project provides an LDAP client implementation that can connect to LDAP servers, perform searches, and retrieve directory information.

- **Location**: `LDAP Client/`
- **Languages**: Python
- **Key Features**: 
  - LDAP server connection
  - Search and retrieval operations
  - Example usage scripts

#### POP3 Client+Proxy

A combined project that includes both a POP3 client and a proxy server. The client connects to POP3 email servers, and the proxy server can be used to relay email traffic.

- **Location**: `POP3 Client+Proxy/`
- **Languages**: Python
- **Key Features**: 
  - POP3 protocol implementation
  - Proxy functionality
  - Email retrieval and forwarding

#### POP3 Server

An implementation of a POP3 server that allows clients to connect and retrieve emails from the server.

- **Location**: `POP3 Server/`
- **Languages**: Python
- **Key Features**: 
  - POP3 protocol support
  - User authentication
  - Email storage and retrieval

#### Quiz Server

A server application that hosts quizzes, allowing users to connect, take quizzes, and receive scores.

- **Location**: `Quiz Server/`
- **Languages**: Python
- **Key Features**: 
  - Quiz hosting
  - User interaction
  - Scoring system

#### Quiz Web Server

A web-based quiz server that presents quizzes to users through a web interface. Users can take quizzes and view their results online.

- **Location**: `Quiz Web Server/`
- **Languages**: Python, HTML, JavaScript
- **Key Features**: 
  - Web-based interface
  - Interactive quizzes
  - Real-time scoring

#### SMTP Server

An implementation of an SMTP server that can send and receive email messages.

- **Location**: `SMTP Server/`
- **Languages**: Python
- **Key Features**: 
  - SMTP protocol support
  - Email sending/receiving
  - User authentication

## Documentation

The `_docs` folder contains detailed summaies for each layer in the OSI ISO Reference Model, It also contains the specification for these projects, basically the practical specification.

- **Location**: `_docs/`

## License

This repository is licensed under the MIT License. See the [LICENSE](LICENSE) file for more information.

## Contributing

Contributions are welcome! Please fork this repository and submit pull requests for any improvements or bug fixes.