# Sorting-Algorithms
-----

Sorting is arranging a collection of elements or data in a specific order, typically in ascending or descending order
based on the elements' values. Sorting is a fundamental operation in programming used to organize data for various
purposes, such as searching, reporting, and data analysis. Sorting can be applied to various data structures, including
arrays and lists, and can be performed using built-in methods or custom sorting logic. Sorting ensures that data is
ordered and accessible in a structured manner, making it easier to work with and process.

-----

## 👉🏻 Features:

a) **Ordering**: Sorting organizes items in a structured way, facilitating quick access and retrieval.

b) **Stability**: Some sorting methods maintain the original order of items with the same value, ensuring consistency.

c) **Customization**: You can sort items based on various criteria, allowing customization to suit specific needs.

d) **Applicability**: Sorting is used in various real-life scenarios, from managing phone contacts to organizing tasks in
a to-do list.

-----

## 👉🏻 Daily Life Examples:

a) ***Phone Contacts***: Arranging your contacts in alphabetical order by their last names for easy access.

b) ***Library Catalog***: Sorting books on library shelves by title or author's last name for efficient book retrieval.

c) ***To-Do List***: Ordering tasks by priority or due date to ensure the most critical tasks are addressed first.

d) ***Spreadsheets***: Sorting data in columns for effective data analysis and comparison.

e) ***Online Shopping***: Displaying search results based on price, rating, or relevance to aid decision-making.

f) ***Music Playlist***: Rearranging songs in a playlist by an artist or album to create a personalized listening
experience.

-----


## 👉🏻 Sorting Algorithms:

Below are the top 30 sorting algorithms that can be used to efficiently organize and arrange data. These algorithms are
valuable tools for developers and data scientists, offering a diverse range of approaches to sorting, each with its
unique characteristics and performance advantages. Whether it's a simple list of names or complex data structures, these
sorting methods empower us to streamline data and access it with ease.

1) **[Selection Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/SelectionSort)**

2) **[Bubble Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/BubbleSort)**

3) **[Insertion Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/InsertionSort)**

4) **[Merge Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/MergeSort)**

5) **[Quick Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/QuickSort)**

6) **[Heap Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/HeapSort)**

7) **[Counting Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/CountingSort)**

8) **[Radix Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/RadixSort)**

9) **[Bucket Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/BucketSort)**

10) **[Shell Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/ShellSort)**

11) **[Cycle Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/CycleSort)**

12) **[Bogo Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/BogoSort)**

13) **[Gnome Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/GnomeSort)**

14) **[Strand Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/StrandSort)**

15) **[Bitonic Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/BitonicSort)**

16) **[Pancake Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/PancakeSort)**

17) **[Sleep Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/SleepSort)**

18) **[Tree Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/TreeSort)**

19) **[Odd-Even Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/OddEvenSort)**

20) **[3-Way Merge Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/ThreeWayMergeSort)**

21) **[Stooge Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/StoogeSort)**

22) **[Tim Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/TimSort)**

23) **[Comb Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/CombSort)**

24) **[Pigeonhole Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/PigeonholeSort)**

25) **[Cocktail Shaker Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/CocktailShakerSort)**

26) **[Selection Tree Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/SelectionTreeSort)**

27) **[Smooth Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/SmoothSort)**

28) **[Funnel Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/FunnelSort)**

29) **[Flash Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/FlashSort)**

30) **[Block Sort](https://github.com/Tanay-Dwivedi/Sorting-Algorithms/tree/master/src/BlockSort)**

-----