# Vue.js UI Components for Tailwind CSS - TailGrids Vue

Welcome to the Vue.js version of TailGrids. TailGrids Vue.js free core version offers a wide range of high-quality Vue.js UI components and blocks, perfect for building modern websites, landing pages, and web apps using the power of Tailwind CSS and Vue.js. With its consistent design and extensive collection of essential UI elements, TailGrids Vue provides everything you need to create stunning user interfaces in your Vue.js projects.

[![sneak-peek](https://github.com/TailGrids/tailgrids-vue/blob/main/tailgrids-vue.png)](https://tailgrids.com/components)

TailGrids Vue comes with all the necessary integration features for seamless usage of these components within your Vue.js application. Whether you're developing single-page applications, progressive web apps, or server-side rendered apps using Vue.js, feel free to use TailGrids Vue for your personal or commercial projects.

## Getting Started

To start using TailGrids Vue, follow these steps to properly set it up in your Vue.js project.

1. Install Tailgrids by running the following command:

```sh
npm install tailgrids
```

2. Add Tailgrids to your `tailwind.config.js` file:

```javascript
module.exports = {
  content: ["./*.html", "./ecommerce/*.html", "./assets/**/*.js"],
  theme: {},
  variants: {
    extend: {},
  },
  plugins: [require("tailgrids/plugin")],
};
```

3. Browse through the available components and choose the desired Vue codebase snippets that you want to use in your projects. Simply copy and paste them!

4. To view the changes locally, run the development server with this command:

```sh
npm run dev
```

### [🚀 Explore All Components](https://tailgrids.com/components)

### [🌏 Visit Website](https://tailgrids.com)

### [📃 Documentation](https://tailgrids.com/docs)

## 🎁 License

TailGrids Vue Core is 100% Free! and open-source you can use it with your personal or commercial projects.
