<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@ page import="java.sql.*, java.util.*" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirm Appointment Cancellation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
        }
        .button {
            display: block;
            width: 100%;
            padding: 10px;
            text-align: center;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            margin-bottom: 10px;
        }
        .button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Confirm Appointment Cancellation</h2>
        <%
            String channelNumber = request.getParameter("id");

            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
                String dbURL = "jdbc:mysql://localhost:3306/e-channeling_system";
                String dbUser = "root";
                String dbPassword = "";
                Connection conn = DriverManager.getConnection(dbURL, dbUser, dbPassword);

                // Begin transaction for atomicity
                conn.setAutoCommit(false);

                // Delete the appointment
                String deleteSQL = "DELETE FROM appointments WHERE channeling_schedule_id = ? AND patient_nic = ?";
                PreparedStatement deleteStatement = conn.prepareStatement(deleteSQL);
                deleteStatement.setInt(1, Integer.parseInt(channelNumber));
                deleteStatement.setString(2, (String) session.getAttribute("loggedInPatientNIC"));
                deleteStatement.executeUpdate();

                // Commit transaction
                conn.commit();
                deleteStatement.close();
                response.sendRedirect("Patient.jsp");

                //out.println("<p>Your appointment has been successfully cancelled.</p>");
                //out.println("<a href='Patient.jsp' class='button'>Go Back</a>");

                conn.close();
            } catch (SQLException | ClassNotFoundException e) {
                out.println("Database connection error: " + e.getMessage());
            }
        %>
    </div>
</body>
</html>
