# Ability

Ability is a Chrome extension designed to enhance web accessibility for users with different needs. It is a comprehensive collection of assistive tools, providing a range of features including text-to-speech, speech-to-text, image hiding, high contrast mode, dyslexia-friendly font injection, etc. This collection of tools was designed keeping in mind individuals with sensory sensitivities, dyslexia, epilepsy, visual & mobility impairments, and intellectual disabilities. The features will continue to grow as more needs are discovered. See the list of upcoming features for a look at what's coming down the pipeline.

## Features

- **Text-to-Speech (TTS):** Customize TTS in the pop-up, access via context menu.
- **Image Hiding:** Toggle to hide all images on the page.
- **High Contrast:** Enhance the page's contrast for easier reading.
- **Dyslexia-Friendly Font:** Replace the page's font with a dyslexia-friendly one.
- **Highlight Links:** Make all links on the page more visible.
- **Disable Animations:** Stop all CSS animations, autoplaying videos, and animated gifs. Refresh the page to resume.
- **Focus Line:** Create a horizontal line that follows the cursor to assist with reading.
- **Letter Spacing:** Increase the spacing between letters.
- **Dimmer Overlay:** Apply an overlay to dim unfocused content, with a "flashlight" effect around the cursor.
- **Large Cursor:** Enlarge the cursor for better visibility.
- **Autocomplete:** Enables autocomplete on all text inputs on the page.

## Context Menu Options

Right-click to access the following options:

- **Speak:** Read aloud the selected text.
- **Speech-To-Text:** Convert speech into text in text inputs.
- **Define:** Look up definitions for the selected word.
- **Image Magnifier:** Get a closer look at an image.
- **Focused Reading:** Bolds parts of selected text for an experience similar to Bionic Reading.

## Installation

1. Download the extension from the Chrome Web Store.
2. Click 'Add to Chrome' to install the extension.
3. Once installed, click on the extension icon in the toolbar to access and toggle features.

## Usage

After opening the extension menu, adjust the TTS settings or toggle any of the accessibility features according to your preference. Select text and use the context menu by right-clicking to access TTS, Speech-to-Text, or the Define feature.

## Context Menu Usage

- To use the **Speak** feature, select any text on the page, right-click, and select "Speak".
- To convert speech to text, right-click on any text input field and select "Speech-To-Text".
- To get the definition of a word, select it, right-click, and choose "Define".

## Possible Upcoming Features

- **~~Image Magnifier🔎~~**
- ~~**~~Focus~~**~~ed~~ **~~Read~~**ing~~
- **User Profiles**
- **Webgazer👀Tracking?**

## Feedback

If you have any feedback or suggestions for new features, please contact us at [timb63701@gmail.com].

## License

This project is licensed under the MIT License - see the LICENSE.md file for details.
