# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import json
import subprocess
sys.path.insert(0, os.path.abspath('..'))

# noinspection PyProtectedMember
from dazzler._version import __version__ as version

# -- Project information -----------------------------------------------------

project = 'Dazzler'
copyright = '2021, Philippe Duval'
author = 'Philippe Duval'

# The short X.Y version
# The full version, including alpha/beta/rc tags
release = ".".join(version.split(".")[:2])


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.ifconfig',
    'sphinx.ext.viewcode',
    'sphinx_autodoc_typehints',
    'm2r2',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = ['.rst', '.md']

# The master toctree document.
master_doc = 'contents'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'friendly'

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_material'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#

html_title = project
html_theme_options = {
    'nav_title': project,
    'color_primary': 'blue',
    'color_accent': 'light-blue',

    'repo_url': 'https://github.com/T4rk1n/dazzler',
    'repo_name': project,

    'logo_icon': '&#xe869',

    # Visible levels of the global TOC; -1 means unlimited
    'globaltoc_depth': 2,
    # If False, expand all TOC entries
    'globaltoc_collapse': True,
    'master_doc': False,
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.

html_sidebars = {
    "**": [
        "logo-text.html", "globaltoc.html", "localtoc.html", "searchbox.html"
    ]
}

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'dazzler-docs'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'dazzler.tex', 'Dazzler Documentation',
     author, 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'dazzler', 'Dazzler Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'dazzler', 'dazzler Documentation',
     author, 'dazzler', 'Interactive async web framework',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

def skip(app, what, name, obj, skip, options):
    if name == "__init__":
        return False
    return skip


def setup(app):
    app.connect("autodoc-skip-member", skip)
    app.add_css_file('styles.css')

    # Generate components for docstrings.
    from dazzler import Dazzler

    dazz = Dazzler('dazzler')

    if os.getenv('READTHEDOCS'):
        proc = subprocess.Popen(['npm', 'install', 'ramda', 'typescript'])
        proc.communicate()

    for args in (
            ('../src/core/js/components', '../dazzler/components/core', '--ts'),
            ('../src/extra/js/components', '../dazzler/components/extra', '--ts'),
            ('../src/calendar/js/components', '../dazzler/components/calendar', '--ts'),
            ('../src/markdown/js/components', '../dazzler/components/markdown'),
            ('../src/auth/js/components', '../dazzler/components/auth', '--ts'),
            ('../src/icons/ts/components', '../dazzler/components/icons', '--ts'),
            ('../src/electron/renderer/components', '../dazzler/components/electron', '--ts')
    ):
        dazz.start(('generate',) + args)

    dazz.start(['dump-configs', 'dazzler.toml'])

    results = '.. component_list:\n\nOfficial Components' \
              '\n===================\n\n'

    # Generate a component list
    for package in [
        'core', 'extra', 'electron', 'calendar', 'markdown', 'auth', 'icons'
    ]:
        results += f'- :py:mod:`~.dazzler.components.{package}`\n\n'

        with open(
            os.path.join('../dazzler/components/', package, 'components.json')
        ) as f:
            components = json.load(f)
            results += '\n'.join(
                f'    - :py:class:`~.dazzler.components.{package}.{c}`'
                for c in components
            )
        results += '\n\n'

    with open('component_list.rst', 'w') as f:
        f.write(results)
