create table "public"."feedback" (
    "id" bigint generated by default as identity not null,
    "created_at" timestamp with time zone default now(),
    "feedback_positive" boolean not null,
    "conversation_id" bigint not null,
    "system_prompt" text,
    "conversation_length_at_feedback" bigint not null,
    "negative_feedback_text" text
);
alter table "public"."feedback" enable row level security;
CREATE UNIQUE INDEX feedback_pkey ON public.feedback USING btree (id);
alter table "public"."feedback"
add constraint "feedback_pkey" PRIMARY KEY using index "feedback_pkey";
alter table "public"."feedback"
add constraint "feedback_conversation_id_fkey" FOREIGN KEY (conversation_id) REFERENCES conversations(id) not valid;
alter table "public"."feedback" validate constraint "feedback_conversation_id_fkey";
CREATE POLICY "enable all operations based on org_id" ON "public"."feedback" AS PERMISSIVE FOR ALL TO AUTHENTICATED USING (
    auth.uid() IN (
        SELECT profiles.id
        FROM profiles
            JOIN conversations ON conversations.org_id = profiles.org_id
        WHERE conversations.id = feedback.conversation_id
    )
) WITH CHECK (
    auth.uid() IN (
        SELECT profiles.id
        FROM profiles
            JOIN conversations ON conversations.org_id = profiles.org_id
        WHERE conversations.id = feedback.conversation_id
    )
);