create table "public"."usage" (
    "id" bigint generated by default as identity not null,
    "org_id" bigint not null,
    "date" date not null default CURRENT_DATE,
    "usage" double precision not null
);

alter table "public"."usage" enable row level security;

CREATE UNIQUE INDEX usage_id_key ON public.usage USING btree (id);

CREATE UNIQUE INDEX usage_pkey ON public.usage USING btree (id);

alter table "public"."usage" add constraint "usage_pkey" PRIMARY KEY using index "usage_pkey";

alter table "public"."usage" add constraint "usage_id_key" UNIQUE using index "usage_id_key";

alter table "public"."usage" add constraint "usage_org_id_fkey" FOREIGN KEY (org_id) REFERENCES organizations(id) not valid;

alter table "public"."usage" validate constraint "usage_org_id_fkey";

create policy "enable all based on organisation id"
on "public"."usage"
as permissive
for all
to public
using ((auth.uid() IN ( SELECT profiles.id
   FROM profiles
  WHERE (profiles.org_id = usage.org_id))));
