import { describe, it, expect } from "@jest/globals";
import { chunkString } from "../../lib/utils";

// Roughly 2200 tokens
const longTestStr = `REGISTERED NUMBER: 05816749 (England and Wales) \\n\\nFINANCIAL STATEMENTS FOR THE YEAR ENDED 30 SEPTEMBER 2022\\n\\nFOR\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD (REGISTERED NUMBER: 05816749)\\n\\nCONTENTS OF THE FINANCIAL STATEMENTS\\n\\nFOR THE YEAR ENDED 30 SEPTEMBER 2022\\n\\nPage\\n\\nBalance Sheet \\n1\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD (REGISTERED NUMBER: 05816749)\\n\\nBALANCE SHEET \\n\\n30 SEPTEMBER 2022\\n\\n2022\\n2021\\n\\n£   \\n£   \\n£   \\n£   \\n\\nFIXED ASSETS\\n2,340\\n\\n2,863\\n\\nCURRENT ASSETS\\n152,936\\n\\n156,084\\n\\nCREDITORS\\n\\nAmounts falling due within one year \\n(106,224\\n)\\n(80,784\\n)\\n\\nNET CURRENT ASSETS\\n46,712\\n\\n75,300\\n\\nTOTAL ASSETS LESS CURRENT LIABILITIES \\n49,052\\n\\n78,163\\n\\nCREDITORS\\n\\nAmounts falling due after more than one year \\n27,418\\n\\n46,451\\n\\nNET ASSETS\\n21,634\\n\\n31,712\\n\\nCAPITAL AND RESERVES\\n21,634\\n\\n31,712\\n\\nNOTES TO THE FINANCIAL STATEMENTS\\n\\n1.\\nSTATUTORY INFORMATION\\n\\nMendip Heating & Plumbing Services Ltd is a private company, limited by shares , registered in England and Wales. The company's registered number and registered office address are as below: \\n\\nRegistered number:\\n05816749\\n\\nRegistered office:\\n124 High Street\\n\\nMidsomer Norton\\n\\nRadstock\\n\\nBATH\\n\\nBA3 2DA\\n\\n2.\\nAVERAGE NUMBER OF EMPLOYEES\\n\\nThe average number of employees during the year was 2 (2021 - 2 ) . \\n\\n3.\\nDIRECTORS' ADVANCES, CREDITS AND GUARANTEES\\n\\nThe following advances and credits to directors subsisted during the years ended 30 September 2022 and 30 September 2021: \\n\\n2022\\n2021\\n\\n£   \\n£   \\n\\nS M Smith \\n\\nBalance outstanding at start of year\\n(23,091\\n)\\n(7,165\\n)\\n\\nAmounts advanced\\n45,264\\n\\n34,907\\n\\nAmounts repaid\\n(48,489\\n)\\n(50,833\\n)\\n\\nAmounts written off\\n-\\n\\n-\\n\\nAmounts waived\\n-\\n\\n-\\n\\nBalance outstanding at end of year\\n(26,316\\n)\\n(23,091\\n)\\n\\nPage 1\\ncontinued...\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD (REGISTERED NUMBER: 05816749)\\n\\nBALANCE SHEET - continued \\n\\n30 SEPTEMBER 2022\\n\\nNOTES TO THE FINANCIAL STATEMENTS\\n\\n3.\\nDIRECTORS' ADVANCES, CREDITS AND GUARANTEES - continued\\n\\nMrs J B Smith \\n\\nBalance outstanding at start of year\\n(17,937\\n)\\n3,799\\n\\nAmounts advanced\\n35,960\\n\\n27,097\\n\\nAmounts repaid\\n(48,489\\n)\\n(48,833\\n)\\n\\nAmounts written off\\n-\\n\\n-\\n\\nAmounts waived\\n-\\n\\n-\\n\\nBalance outstanding at end of year\\n(30,466\\n)\\n(17,937\\n)\\n\\nAny overdrawn directors' loan balances were repaid in the following year.\\n\\nThe company is entitled to exemption from audit under Section 477 of the Companies Act 2006 for the year ended 30 September 2022. \\n\\nThe members have not required the company to obtain an audit of its financial statements for the year ended 30 September 2022 in accordance with Section 476 of the Companies Act 2006. \\n\\nThe directors acknowledge their responsibilities for:(a)ensuring that the company keeps accounting records which comply with Sections 386 and 387 of the Companies Act 2006 and (b)preparing financial statements which give a true and fair view of the state of affairs of the company as at the end of each financial year and of its profit or loss for each financial year in accordance with the requirements of Sections 394 and 395 and which otherwise comply with the requirements of the Companies Act 2006 relating to financial statements, so far as applicable to the company. \\n\\nThe financial statements have been prepared in accordance with the micro-entity provisions and delivered in accordance with the provisions applicable to companies subject to the small companies regime. \\n\\nThe financial statements were approved by the Board of Directors and authorised for issue on 17 May 2023 and were signed on its behalf by: \\n\\nS M Smith - Director \\n\\nMrs J B Smith - Director \\n\\nPage 2

REGISTERED NUMBER: 05816749 (England and Wales) \\n\\nFINANCIAL STATEMENTS FOR THE YEAR ENDED 30 SEPTEMBER 2022\\n\\nFOR\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD (REGISTERED NUMBER: 05816749)\\n\\nCONTENTS OF THE FINANCIAL STATEMENTS\\n\\nFOR THE YEAR ENDED 30 SEPTEMBER 2022\\n\\nPage\\n\\nBalance Sheet \\n1\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD (REGISTERED NUMBER: 05816749)\\n\\nBALANCE SHEET \\n\\n30 SEPTEMBER 2022\\n\\n2022\\n2021\\n\\n£   \\n£   \\n£   \\n£   \\n\\nFIXED ASSETS\\n2,340\\n\\n2,863\\n\\nCURRENT ASSETS\\n152,936\\n\\n156,084\\n\\nCREDITORS\\n\\nAmounts falling due within one year \\n(106,224\\n)\\n(80,784\\n)\\n\\nNET CURRENT ASSETS\\n46,712\\n\\n75,300\\n\\nTOTAL ASSETS LESS CURRENT LIABILITIES \\n49,052\\n\\n78,163\\n\\nCREDITORS\\n\\nAmounts falling due after more than one year \\n27,418\\n\\n46,451\\n\\nNET ASSETS\\n21,634\\n\\n31,712\\n\\nCAPITAL AND RESERVES\\n21,634\\n\\n31,712\\n\\nNOTES TO THE FINANCIAL STATEMENTS\\n\\n1.\\nSTATUTORY INFORMATION\\n\\nMendip Heating & Plumbing Services Ltd is a private company, limited by shares , registered in England and Wales. The company's registered number and registered office address are as below: \\n\\nRegistered number:\\n05816749\\n\\nRegistered office:\\n124 High Street\\n\\nMidsomer Norton\\n\\nRadstock\\n\\nBATH\\n\\nBA3 2DA\\n\\n2.\\nAVERAGE NUMBER OF EMPLOYEES\\n\\nThe average number of employees during the year was 2 (2021 - 2 ) . \\n\\n3.\\nDIRECTORS' ADVANCES, CREDITS AND GUARANTEES\\n\\nThe following advances and credits to directors subsisted during the years ended 30 September 2022 and 30 September 2021: \\n\\n2022\\n2021\\n\\n£   \\n£   \\n\\nS M Smith \\n\\nBalance outstanding at start of year\\n(23,091\\n)\\n(7,165\\n)\\n\\nAmounts advanced\\n45,264\\n\\n34,907\\n\\nAmounts repaid\\n(48,489\\n)\\n(50,833\\n)\\n\\nAmounts written off\\n-\\n\\n-\\n\\nAmounts waived\\n-\\n\\n-\\n\\nBalance outstanding at end of year\\n(26,316\\n)\\n(23,091\\n)\\n\\nPage 1\\ncontinued...\\n\\nMENDIP HEATING & PLUMBING SERVICES LTD (REGISTERED NUMBER: 05816749)\\n\\nBALANCE SHEET - continued \\n\\n30 SEPTEMBER 2022\\n\\nNOTES TO THE FINANCIAL STATEMENTS\\n\\n3.\\nDIRECTORS' ADVANCES, CREDITS AND GUARANTEES - continued\\n\\nMrs J B Smith \\n\\nBalance outstanding at start of year\\n(17,937\\n)\\n3,799\\n\\nAmounts advanced\\n35,960\\n\\n27,097\\n\\nAmounts repaid\\n(48,489\\n)\\n(48,833\\n)\\n\\nAmounts written off\\n-\\n\\n-\\n\\nAmounts waived\\n-\\n\\n-\\n\\nBalance outstanding at end of year\\n(30,466\\n)\\n(17,937\\n)\\n\\nAny overdrawn directors' loan balances were repaid in the following year.\\n\\nThe company is entitled to exemption from audit under Section 477 of the Companies Act 2006 for the year ended 30 September 2022. \\n\\nThe members have not required the company to obtain an audit of its financial statements for the year ended 30 September 2022 in accordance with Section 476 of the Companies Act 2006. \\n\\nThe directors acknowledge their responsibilities for:(a)ensuring that the company keeps accounting records which comply with Sections 386 and 387 of the Companies Act 2006 and (b)preparing financial statements which give a true and fair view of the state of affairs of the company as at the end of each financial year and of its profit or loss for each financial year in accordance with the requirements of Sections 394 and 395 and which otherwise comply with the requirements of the Companies Act 2006 relating to financial statements, so far as applicable to the company. \\n\\nThe financial statements have been prepared in accordance with the micro-entity provisions and delivered in accordance with the provisions applicable to companies subject to the small companies regime. \\n\\nThe financial statements were approved by the Board of Directors and authorised for issue on 17 May 2023 and were signed on its behalf by: \\n\\nS M Smith - Director \\n\\nMrs J B Smith - Director \\n\\nPage 2`;
const shortTestStr = "this is a string which should be 10 tokens";

describe("chunkString", () => {
  it("simple: chunkSize=10", () => {
    const chunks = chunkString(shortTestStr, 10, 2);
    expect(chunks.length).toBe(1);
    expect(chunks[0]).toBe(shortTestStr);
  });
  it("simple: chunkSize=5, overlap=2", () => {
    const chunks = chunkString(shortTestStr, 5, 2);
    expect(chunks.length).toBe(3);
    expect(chunks[0]).toBe("this is a string which");
    expect(chunks[1]).toBe(" string which should be ");
    expect(chunks[2]).toBe(" be 10 tokens");
  });
  it("simple: chunkSize=3, overlap=0", () => {
    const chunks = chunkString(shortTestStr, 3, 0);
    expect(chunks.length).toBe(4);
    expect(chunks[0]).toBe("this is a");
    expect(chunks[1]).toBe(" string which should");
    expect(chunks[2]).toBe(" be 10");
    expect(chunks[3]).toBe(" tokens");
  });
  it("realistic: split a string into chunks", () => {
    const chunks = chunkString(longTestStr, 2000, 50);
    expect(chunks.length).toBe(2);
  });
  it("realistic: split a string into chunks", () => {
    const chunks = chunkString(longTestStr, 1000, 50);
    expect(chunks.length).toBe(3);
  });
});
