# Awesome-Diffusion-Models-For-NLP

[![Awesome](https://awesome.re/badge.svg)](https://github.com/StevenYuan666/Awesome-Diffusion-based-Language-Models)
![](https://img.shields.io/github/last-commit/StevenYuan666/Awesome-Diffusion-based-Language-Models?color=green)
![](https://img.shields.io/badge/PRs-Welcome-red)

## 🔍 Table of Contents
- [🌟 What is Diffusion Model For NLP?](#-what-is-diffusion-model-for-nlp)
- [🔗 Surveys](#-surveys)
- [📝 Papers](#-papers)
- [📍 Resources](#-resources)
- [🤗 Contribution](#-contribution)
  - [Contributors](#contributors)
  - [Acknowledgement](#acknowledgement)

## 🌟 What is the Diffusion Model For NLP?

## 🔗 Surveys
- [**Diffusion models in text generation: a survey**](https://peerj.com/articles/cs-1905/) *Qiuhua Yi, Xiangfan Chen, Chenwei Zhang, Zehai Zhou, Linan Zhu, Xiangjie Kong.* **PeerJ Computer Science** 2024 Feb
 
- [**An Overview of Diffusion Models for Text Generation**](https://ieeexplore.ieee.org/document/10159911) *Helena Čeović, Marin Šilić, Goran Delač, Klemo Vladimir.* **MIPRO** 2023 Jun
 
- [**A Survey of Diffusion Models in Natural Language Processing**](https://arxiv.org/abs/2305.14671) *Hao Zou, Zae Myung Kim, Dongyeop Kang.* **Arxiv** 2023 May
 
- [**Diffusion Models in NLP: A Survey**](https://arxiv.org/abs/2303.07576) *Yuansong Zhu, Yu Zhao.* **Arxiv** 2023 Mar
 
- [**Diffusion Models for Non-autoregressive Text Generation: A Survey**](https://arxiv.org/abs/2303.06574) *Yifan Li, Kun Zhou, Wayne Xin Zhao, Ji-Rong Wen.* **IJCAI** 2023 Mar
 



## 📝 Papers
- [**Empowering Diffusion Models on the Embedding Space for Text Generation**](https://aclanthology.org/2024.naacl-long.261/) *Zhujin Gao, Junliang Guo, Xu Tan, Yongxin Zhu, Fang Zhang, Jiang Bian, Linli Xu.* **NAACL** 2024 June 

-  [**Simple and Effective Masked Diffusion Language Models**](https://arxiv.org/abs/2406.07524) *Subham Sekhar Sahoo, Marianne Arriola, Yair Schiff, Aaron Gokaslan, Edgar Marroquin, Justin T Chiu, Alexander Rush, Volodymyr Kuleshov.* **Arxiv** 2024 June

- [**Effective Integration of Text Diffusion and Pre-Trained Language Models with Linguistic Easy-First Schedule**](https://aclanthology.org/2024.lrec-main.493/) *Yimin Ou, Ping Jian.* **LREC | COLING** 2024 May
 
- [**Few-shot Temporal Pruning Accelerates Diffusion Models for Text Generation**](https://aclanthology.org/2024.lrec-main.637/) *Bocheng Li, Zhujin Gao, Yongxin Zhu, Kun Yin, Haoyu Cao, Deqiang Jiang, Linli Xu.* **LREC | COLING** 2024 May
 
- [**LaDiC: Are Diffusion Models Really Inferior to Autoregressive Counterparts for Image-to-Text Generation?**](https://arxiv.org/abs/2404.10763) *Yuchi Wang, Shuhuai Ren, Rundong Gao, Linli Yao, Qingyan Guo, Kaikai An, Jianhong Bai, Xu Sun.* **NAACL** 2024 Apr
 
- [**Enforcing Paraphrase Generation via Controllable Latent Diffusion**](https://arxiv.org/abs/2404.08938) *Wei Zou, Ziyuan Zhuang, Shujian Huang, Jia Liu, Jiajun Chen.* **Arxiv** 2024 Apr
 
- [**Diffuwords: A Contrastive Diffusion Model for Lexically Constrained Text Generation**](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4790017) *Jinqiao Dai, Pengsen Cheng, Jiamiao Liu, Jiayong Liu.* **SSRN** 2024 Apr
 
- [**DiffusionDialog: A Diffusion Model for Diverse Dialog Generation with Latent Space**](https://arxiv.org/abs/2404.06760) *Jianxiang Xiang, Zhenhua Liu, Haodong Liu, Yin Bai, Jia Cheng, Wenliang Chen.* **LREC | COLING** 2024 Apr
 
- [**Improving Iteration-based Non-Autoregressive Language Model With Time Step Awareness**](https://www.researchgate.net/publication/379326543_Improving_Iteration-based_Non-Autoregressive_Language_Model_With_Time_Step_Awareness) *Hang Jiang, Guoyong Cai, Xiaolu Tang.* **ICPADS** 2024 Mar
 
- [**Language Rectified Flow: Advancing Diffusion Language Generation with Probabilistic Flows**](https://arxiv.org/abs/2403.16995) *Shujian Zhang, Lemeng Wu, Chengyue Gong, Xingchao Liu.* **NAACL** 2024 Mar
 
- [**Flow Matching for Conditional Text Generation in a Few Sampling Steps**](https://aclanthology.org/2024.eacl-short.33/) *Vincent Hu, Di Wu, Yuki Asano, Pascal Mettes, Basura Fernando, Björn Ommer, Cees Snoek.* **EACL** 2024 Mar
 
- [**Utilizing Latent Diffusion Model to Accelerate Sampling Speed and Enhance Text Generation Quality**](https://www.mdpi.com/2079-9292/13/6/1093) *Chenyang Li, Long Zhang, Qiusheng Zheng.* **Special Issue Advances in Artificial Intelligence Engineering** 2024 Mar
 
- [**LDSeq: Latent Diffusion Models for Sequence to Sequence Text Generation**](https://dl.acm.org/doi/10.1145/3638584.3638617) *Yizhou Ding, Jidong Tian, Shanxing Mei, Yifan Zhou, Yuwu Dong, Hao He, Weisheng Hu.* **CSAI** 2024 Mar
 
- [**Benchmarking Diffusion Models for Machine Translation**](https://aclanthology.org/2024.eacl-srw.25/) *Yunus Demirag, Danni Liu, Jan Niehues.* **EACL** 2024 Mar
 
- [**Generating, Reconstructing, and Representing Discrete and Continuous Data: Generalized Diffusion with Learnable Encoding-Decoding**](https://arxiv.org/abs/2402.19009) *Guangyi Liu, Yu Wang, Zeyu Feng, Qiyu Wu, Liping Tang, Yuan Gao, Zhen Li, Shuguang Cui, Julian McAuley, Eric P. Xing, Zichao Yang, Zhiting Hu.* **Arxiv** 2024 Feb
 
- [**TEncDM: Understanding the Properties of Diffusion Model in the Space of Language Model Encodings**](https://arxiv.org/abs/2402.19097) *Alexander Shabalin, Viacheslav Meshchaninov, Tingir Badmaev, Dmitry Molchanov, Grigory Bartosh, Sergey Markov, Dmitry Vetrov.* **Arxiv** 2024 Feb
 
- [**DiffuCOMET: Contextual Commonsense Knowledge Diffusion**](https://arxiv.org/abs/2402.17011) *Silin Gao, Mete Ismayilzada, Mengjie Zhao, Hiromi Wakaki, Yuki Mitsufuji, Antoine Bosselut.* **Arxiv** 2024 Feb
 
- [**IPED: An Implicit Perspective for Relational Triple Extraction based on Diffusion Model**](https://arxiv.org/abs/2403.00808) *Jianli Zhao, Changhao Xu, Bin Jiang.* **NAACL** 2024 Feb
 
- [**Let's Rectify Step by Step: Improving Aspect-based Sentiment Analysis with Diffusion Models**](https://arxiv.org/abs/2402.15289) *Shunyu Liu, Jie Zhou, Qunxi Zhu, Qin Chen, Qingchun Bai, Jun Xiao, Liang He.* **LREC | COLING** 2024 Feb
 
- [**Text Diffusion with Reinforced Conditioning**](https://arxiv.org/abs/2402.14843) *Yuxuan Liu, Tianchi Yang, Shaohan Huang, Zihan Zhang, Haizhen Huang, Furu Wei, Weiwei Deng, Feng Sun, Qi Zhang.* **Arxiv** 2024 Feb
 
- [**Quantized Embedding Vectors for Controllable Diffusion Language Models**](https://arxiv.org/abs/2402.10107) *Cheng Kang, Xinye Chen, Yong Hu, Daniel Novak.* **Arxiv** 2024 Feb
 
- [**Diffusion of Thoughts: Chain-of-Thought Reasoning in Diffusion Language Models**](https://arxiv.org/abs/2402.07754) *Jiacheng Ye, Shansan Gong, Liheng Chen, Lin Zheng, Jiahui Gao, Han Shi, Chuan Wu, Zhenguo Li, Wei Bi, Lingpeng Kong.* **Arxiv** 2024 Feb
 
- [**Transfer Learning for Text Diffusion Models**](https://arxiv.org/abs/2401.17181) *Kehang Han, Kathleen Kenealy, Aditya Barua, Noah Fiedel, Noah Constant.* **Arxiv** 2024 Jan
 
- [**MDM: Meta diffusion model for hard-constrained text generation**](https://www.sciencedirect.com/science/article/abs/pii/S0950705123008973) *Wenjun Ke, Yikai Guo, Qi Liu, Wanyi Chen, Peng Wang, Haoran Luo, Zhizhao Luo.* **Knowledge-Based Systems** 2024 Jan
 
- [**ROIC-DM: Robust Text Inference and Classification via Diffusion Model**](https://arxiv.org/abs/2401.03514) *Shilong Yuan, Wei Yuan, Hongzhi Yin, Tieke He.* **Arxiv** 2024 Jan
 
- [**Diffusion-EXR: Controllable Review Generation for Explainable Recommendation via Diffusion Models**](https://arxiv.org/abs/2312.15490) *Ling Li, Shaohua Li, Winda Marantika, Alex C. Kot, Huijing Zhan.* **Arxiv** 2023 Dec
 
- [**IPAD: Iterative, Parallel, and Diffusion-based Network for Scene Text Recognition**](https://arxiv.org/abs/2312.11923) *Xiaomeng Yang, Zhi Qiao, Yu Zhou, Weiping Wang.* **Arxiv** 2023 Dec
 
- [**DiffuVST: Narrating Fictional Scenes with Global-History-Guided Denoising Models**](https://arxiv.org/abs/2312.07066) *Shengguang Wu, Mei Yuan, Qi Su.* **EMNLP** 2023 Dec
 
- [**DiffusionSL: Sequence Labeling via Tag Diffusion Process**](https://aclanthology.org/2023.findings-emnlp.860/) *Ziyang Huang, Pengfei Cao, Jun Zhao, Kang Liu.* **EMNLP** 2023 Dec
 
- [**CodeFusion: A Pre-trained Diffusion Model for Code Generation**](https://aclanthology.org/2023.emnlp-main.716/) *Mukul Singh, José Cambronero, Sumit Gulwani, Vu Le, Carina Negreanu, Gust Verbruggen.* **EMNLP** 2023 Oct
 
- [**Discrete Diffusion Modeling by Estimating the Ratios of the Data Distribution**](https://arxiv.org/abs/2310.16834) *Aaron Lou, Chenlin Meng, Stefano Ermon.* **Arxiv** 2023 Oct
 
- [**A Diffusion Weighted Graph Framework for New Intent Discovery**](https://arxiv.org/abs/2310.15836) *Wenkai Shi, Wenbin An, Feng Tian, Qinghua Zheng, QianYing Wang, Ping Chen.* **EMNLP** 2023 Oct
 
- [**ScanDL: A Diffusion Model for Generating Synthetic Scanpaths on Texts**](https://arxiv.org/abs/2310.15587) *Lena Bolliger, David Reich, Patrick Haller, Deborah Jakobi, Paul Prasse, Lena Jäger.* **EMNLP** 2023 Oct
 
- [**DeTiME: Diffusion-Enhanced Topic Modeling using Encoder-decoder based LLM**](https://arxiv.org/abs/2310.15296) *Weijie Xu, Wenxiang Hu, Fanyou Wu, Srinivasan Sengamedu.* **EMNLP** 2023 Oct
 
- [**Context-Aware Prompt for Generation-based Event Argument Extraction with Diffusion Models**](https://dl.acm.org/doi/abs/10.1145/3583780.3614820) *Lei Luo, Yajing Xu.* **CIKM** 2023 Oct
 
- [**DiffuCom: A novel diffusion model for comment generation**](https://www.sciencedirect.com/science/article/abs/pii/S0950705123008195) *Jiamiao Liu, Pengsen Cheng, Jinqiao Dai, Jiayong Liu.* **Knowledge-Based Systems** 2023 Oct
 
- [**InfoDiffusion: Information Entropy Aware Diffusion Process for Non-Autoregressive Text Generation**](https://arxiv.org/abs/2310.11976) *Renzhi Wang, Jing Li, Piji Li.* **EMNLP** 2023 Oct
 
- [**LADIDA: Latent Diffusion for Document Generation with Sequential Decoding**](https://neurips.cc/virtual/2023/74876) *Zihuiwen Ye, Elle Michelle Yang, Phil Blunsom.* **NeurIPS Workshop on Diffusion Models** 2023 Oct
 
- [**DiffuSeq-v2: Bridging Discrete and Continuous Text Spaces for Accelerated Seq2Seq Diffusion Models**](https://arxiv.org/abs/2310.05793) *Shansan Gong, Mukai Li, Jiangtao Feng, Zhiyong Wu, Lingpeng Kong.* **EMNLP** 2023 Oct
 
- [**DiffusionRet: Diffusion-Enhanced Generative Retriever using Constrained Decoding**](https://aclanthology.org/2023.findings-emnlp.638/) *Shanbao Qiao, Xuebing Liu, Seung-Hoon Na.* **EMNLP** 2023 Oct
 
- [**ParaGuide: Guided Diffusion Paraphrasers for Plug-and-Play Textual Style Transfer**](https://arxiv.org/abs/2308.15459) *Zachary Horvitz, Ajay Patel, Chris Callison-Burch, Zhou Yu, Kathleen McKeown.* **AAAI** 2023 Aug
 
- [**Diffusion Language Models Can Perform Many Tasks with Scaling and Instruction-Finetuning**](https://arxiv.org/abs/2308.12219) *Jiasheng Ye, Zaixiang Zheng, Yu Bao, Lihua Qian, Quanquan Gu.* **Arxiv** 2023 Aug
 
- [**Enhancing Phrase Representation by Information Bottleneck Guided Text Diffusion Process for Keyphrase Extraction**](https://arxiv.org/abs/2308.08739) *Yuanzhen Luo, Qingyu Zhou, Feng Zhou.* **LREC | COLING** 2023 Aug
 
- [**How Does Diffusion Influence Pretrained Language Models on Out-of-Distribution Data?**](https://arxiv.org/abs/2307.13949) *Huazheng Wang, Daixuan Cheng, Haifeng Sun, Jingyu Wang, Qi Qi, Jianxin Liao, Jing Wang, Cong Liu.* **ECAI** 2023 Jul
 
- [**XDLM: Cross-lingual Diffusion Language Model for Machine Translation**](https://arxiv.org/abs/2307.13560) *Linyao Chen, Aosong Feng, Boming Yang, Zihui Li.* **Arxiv** 2023 Jul
 
- [**Controllable Conversation Generation with Conversation Structures via Diffusion Models**](https://aclanthology.org/2023.findings-acl.454/) *Jiaao Chen, Diyi Yang.* **ACL** 2023 Jul
 
- [**PoetryDiffusion: Towards Joint Semantic and Metrical Manipulation in Poetry Generation**](https://arxiv.org/abs/2306.08456) *Zhiyuan Hu, Chumin Liu, Yue Feng, Anh Tuan Luu, Bryan Hooi.* **AAAI** 2023 Jun
 
- [**DiffuDetox: A Mixed Diffusion Model for Text Detoxification**](https://arxiv.org/abs/2306.08505) *Griffin Floto, Mohammad Mahdi Abdollah Pour, Parsa Farinneya, Zhenwei Tang, Ali Pesaranghader, Manasa Bharadwaj, Scott Sanner.* **ACL** 2023 Jun
 
- [**PLANNER: Generating Diversified Paragraph via Latent Language Diffusion Model**](https://arxiv.org/abs/2306.02531) *Yizhe Zhang, Jiatao Gu, Zhuofeng Wu, Shuangfei Zhai, Josh Susskind, Navdeep Jaitly.* **NeurIPS** 2023 Jun
 
- [**DiffusEmp: A Diffusion Model-Based Framework with Multi-Grained Control for Empathetic Response Generation**](https://arxiv.org/abs/2306.01657) *Guanqun Bi, Lei Shen, Yanan Cao, Meng Chen, Yuqiang Xie, Zheng Lin, Xiaodong He.* **ACL** 2023 Jun
 
- [**Likelihood-Based Diffusion Language Models**](https://arxiv.org/abs/2305.18619) *Ishaan Gulrajani, Tatsunori B. Hashimoto.* **NeurIPS** 2023 May
 
- [**Dior-CVAE: Pre-trained Language Models and Diffusion Priors for Variational Dialog Generation**](https://arxiv.org/abs/2305.15025) *Tianyu Yang, Thy Thy Tran, Iryna Gurevych.* **EMNLP** 2023 May
 
- [**David helps Goliath: Inference-Time Collaboration Between Small Specialized and Large General Diffusion LMs**](https://arxiv.org/abs/2305.14771) *Xiaochuang Han, Sachin Kumar, Yulia Tsvetkov, Marjan Ghazvininejad.* **Arxiv** 2023 May
 
- [**Diffusionner: Boundary diffusion for named entity recognition**](https://arxiv.org/abs/2305.13298) *Yongliang Shen, Kaitao Song, Xu Tan, Dongsheng Li, Weiming Lu, Yueting Zhuang.* **ACL** 2023 May
 
- [**Fine-grained Text Style Transfer with Diffusion-Based Language Models**](https://arxiv.org/abs/2305.19512) *Yiwei Lyu, Tiange Luo, Jiacheng Shi, Todd Hollon, Honglak Lee.* **RepL4NLP** 2023 May
 
- [**DiffuSIA: A Spiral Interaction Architecture for Encoder-Decoder Text Diffusion**](https://arxiv.org/abs/2305.11517#:~:text=Concretely%2C%20the%20conditional%20information%20from,for%20deep%20fusion%20and%20understanding.) *Chao-Hong Tan, Jia-Chen Gu, Zhen-Hua Ling.* **Arxiv** 2023 May
 
- [**Diffusion Language Models Generation Can Be Halted Early**](https://arxiv.org/abs/2305.10818) *Sofia Maria Lo Cicero Vaina, Nikita Balagansky, Daniil Gavrilov.* **Arxiv** 2023 May
 
- [**AR-Diffusion: Auto-Regressive Diffusion Model for Text Generation**](https://arxiv.org/abs/2305.09515) *Tong Wu, Zhihao Fan, Xiao Liu, Yeyun Gong, Yelong Shen, Jian Jiao, Hai-Tao Zheng, Juntao Li, Zhongyu Wei, Jian Guo, Nan Duan, Weizhu Chen.* **NeurIPS** 2023 May
 
- [**TESS: Text-to-Text Self-Conditioned Simplex Diffusion**](https://arxiv.org/abs/2305.08379) *Rabeeh Karimi Mahabadi, Hamish Ivison, Jaesung Tae, James Henderson, Iz Beltagy, Matthew Peters, Arman Cohan.* **EACL** 2023 May
 
- [**Can Diffusion Model Achieve Better Performance in Text Generation? Bridging the Gap between Training and Inference!**](https://arxiv.org/abs/2305.04465) *Zecheng Tang, Pinzheng Wang, Keyan Zhou, Juntao Li, Ziqiang Cao, Min Zhang.* **ACL** 2023 May
 
- [**Diffusion-NAT: Self-Prompting Discrete Diffusion for Non-Autoregressive Text Generation**](https://arxiv.org/abs/2305.04044) *Kun Zhou, Yifan Li, Xin Zhao, Ji-Rong Wen.* **EACL** 2023 May
 
- [**DiffuSum: Generation Enhanced Extractive Summarization with Diffusion**](https://arxiv.org/abs/2305.01735) *Haopeng Zhang, Xiao Liu, Jiawei Zhang.* **ACL** 2023 May
 
- [**GlyphDiffusion: Text Generation as Image Generation**](https://arxiv.org/abs/2304.12519) *Junyi Li, Wayne Xin Zhao, Jian-Yun Nie, Ji-Rong Wen.* **Arxiv** 2023 Apr
 
- [**A Cheaper and Better Diffusion Language Model with Soft-Masked Noise**](https://arxiv.org/abs/2304.04746) *Jiaao Chen, Aston Zhang, Mu Li, Alex Smola, Diyi Yang.* **EMNLP** 2023 Apr
 
- [**DINOISER: Diffused Conditional Sequence Learning by Manipulating Noises**](https://arxiv.org/abs/2302.10025) Jiasheng Ye, Zaixiang Zheng, Yu Bao, Lihua Qian, Mingxuan Wang.* **TACL** 2023 Feb
 
- [**A Reparameterized Discrete Diffusion Model for Text Generation**](https://arxiv.org/abs/2302.05737) *Lin Zheng, Jianbo Yuan, Lei Yu, Lingpeng Kong.* **Arxiv** 2023 Feb
 
- [**Text Generation with Diffusion Language Models: A Pre-training Approach with Continuous Paragraph Denoise**](https://arxiv.org/abs/2212.11685) *Zhenghao Lin, Yeyun Gong, Yelong Shen, Tong Wu, Zhihao Fan, Chen Lin, Nan Duan, Weizhu Chen.* **ICML** 2022 Dec
 
- [**SeqDiffuSeq: Text Diffusion with Encoder-Decoder Transformers**](https://arxiv.org/abs/2212.10325) *Hongyi Yuan, Zheng Yuan, Chuanqi Tan, Fei Huang, Songfang Huang.* **Arxiv** 2022 Dec
 
- [**Latent Diffusion for Language Generation**](https://arxiv.org/abs/2212.09462) *Justin Lovelace, Varsha Kishore, Chao Wan, Eliot Shekhtman, Kilian Q. Weinberger.* **NeurIPS** 2022 Dec
 
- [**Empowering Diffusion Models on the Embedding Space for Text Generation**](https://arxiv.org/abs/2212.09412) *Zhujin Gao, Junliang Guo, Xu Tan, Yongxin Zhu, Fang Zhang, Jiang Bian, Linli Xu.* **NAACL** 2022 Dec
 
- [**DiffusionBERT: Improving Generative Masked Language Models with Diffusion Models**](https://arxiv.org/abs/2211.15029) *Zhengfu He, Tianxiang Sun, Qiong Tang, Kuanning Wang, Xuanjing Huang, Xipeng Qiu.* **ACL** 2022 Nov
 
- [**Continuous diffusion for categorical data**](https://arxiv.org/abs/2211.15089) *Sander Dieleman, Laurent Sartran, Arman Roshannai, Nikolay Savinov, Yaroslav Ganin, Pierre H. Richemond, Arnaud Doucet, Robin Strudel, Chris Dyer, Conor Durkan, Curtis Hawthorne, Rémi Leblond, Will Grathwohl, Jonas Adler.* **Arxiv** 2022 Nov
 
- [**Self-conditioned Embedding Diffusion for Text Generation**](https://arxiv.org/abs/2211.04236) *Robin Strudel, Corentin Tallec, Florent Altché, Yilun Du, Yaroslav Ganin, Arthur Mensch, Will Grathwohl, Nikolay Savinov, Sander Dieleman, Laurent Sifre, Rémi Leblond.* **Arxiv** 2022 Nov
 
- [**SSD-LM: Semi-autoregressive Simplex-based Diffusion Language Model for Text Generation and Modular Control**](https://arxiv.org/abs/2210.17432) *Xiaochuang Han, Sachin Kumar, Yulia Tsvetkov.* **ACL** 2022 Oct
 
- [**DiffusER: Discrete Diffusion via Edit-based Reconstruction**](https://arxiv.org/abs/2210.16886) *Machel Reid, Vincent J. Hellendoorn, Graham Neubig.* **Arxiv** 2022 Oct
 
- [**DiffuSeq: Sequence to Sequence Text Generation with Diffusion Models**](https://arxiv.org/abs/2210.08933) *Shansan Gong, Mukai Li, Jiangtao Feng, Zhiyong Wu, Lingpeng Kong.* **ICLR** 2022 Oct
 
- [**Analog Bits: Generating Discrete Data using Diffusion Models with Self-Conditioning**](https://arxiv.org/abs/2208.04202) *Ting Chen, Ruixiang Zhang, Geoffrey Hinton.* **ICLR** 2022 Aug
 
- [**Composable Text Controls in Latent Space with ODEs**](https://arxiv.org/abs/2208.00638) *Guangyi Liu, Zeyu Feng, Yuan Gao, Zichao Yang, Xiaodan Liang, Junwei Bao, Xiaodong He, Shuguang Cui, Zhen Li, Zhiting Hu.* **EMNLP** 2022 Aug
 
- [**Latent Diffusion Energy-Based Model for Interpretable Text Modelling**](https://arxiv.org/abs/2206.05895) *Peiyu Yu, Sirui Xie, Xiaojian Ma, Baoxiong Jia, Bo Pang, Ruiqi Gao, Yixin Zhu, Song-Chun Zhu, Ying Nian Wu.* **ICML** 2022 Jun
 
- [**Diffusion-LM Improves Controllable Text Generation**](https://arxiv.org/abs/2205.14217) *Xiang Lisa Li, John Thickstun, Ishaan Gulrajani, Percy Liang, Tatsunori B. Hashimoto.* **NeurIPS** 2022 May
 
- [**Step-unrolled Denoising Autoencoders for Text Generation**](https://arxiv.org/abs/2112.06749) *Nikolay Savinov, Junyoung Chung, Mikolaj Binkowski, Erich Elsen, Aaron van den Oord.* **ICLR** 2021 Dec
 
- [**Autoregressive Diffusion Models**](https://arxiv.org/abs/2110.02037) *Emiel Hoogeboom, Alexey A. Gritsenko, Jasmijn Bastings, Ben Poole, Rianne van den Berg, Tim Salimans.* **ICLR** 2021 Oct
 
- [**Structured Denoising Diffusion Models in Discrete State-Spaces**](https://arxiv.org/abs/2107.03006) *Jacob Austin, Daniel D. Johnson, Jonathan Ho, Daniel Tarlow, Rianne van den Berg.* **NeurIPS** 2021 Jul
 
- [**Argmax Flows and Multinomial Diffusion: Learning Categorical Distributions**](https://arxiv.org/abs/2102.05379) *Emiel Hoogeboom, Didrik Nielsen, Priyank Jaini, Patrick Forré, Max Welling.* **NeurIPS** 2021 Feb

## 📍 Resources

## 🤗 Contribution

### Contributors
Zecheng Tang, Youyuan Zhang, Haolun Wu, Ye Yuan

### Contributing to this project
Please feel free to file a PR for contributing to this project! Thanks so much for your help!

### Acknowledgement
