#ifndef PCI_VENDORS_H
#define PCI_VENDORS_H

//PCIHDR.H: PCI Vendors, Devices, and Class Type information

//Created automatically from the web using the following URL:
//http://pcidatabase.com/
//Software to create and maintain the PCICODE List written by:
//Jim Boemler (jboemler@halcyon.com)

//  This header created on Tue Jun  6 11:41:17 EDT 2017

//Too many people have contributed to this list to acknowledge them all, but
//a few have provided the majority of the input and deserve special mention:
//   Frederic Potter, who maintains a list for Linux.
//   Chris Aston at Madge Networks.
//   Thomas Dippon of Hewlett-Packard GmbH.
//   Jurgen ("Josh") Thelen
//   William H. Avery III at Altitech
//   Sergei Shtylyov of Brain-dead Software in Russia

//   that the 0xFFFF of 0xFF entries at the end of some tables below are
//  not properly list terminators, but are actually the printable definitions
//  of values that are legitimately found on the PCI bus.  The size
//  definitions should be used for loop control when the table is searched.

typedef struct _PCI_VENTABLE
{
    unsigned short	VenId ;
    const char *	VenShort ;
    const char *	VenFull ;
}  PCI_VENTABLE, *PPCI_VENTABLE ;

PCI_VENTABLE	PciVenTable [] =
{
    { 0x0033, "<", "Paradyne Corp." } ,
    { 0x003D, "well", "master" } ,
    { 0x0070, "Hauppauge1", "Hauppauge Computer Works Inc." } ,
    { 0x0100, "ncipher", "USBPDO-8" } ,
    { 0x0123, "General Dynamics", "General Dynamics" } ,
    { 0x0315, "", "SK - Electronics Co., Ltd." } ,
    { 0x0402, "PCI\\VEN_10EC&DEV_AA01&SUBSYS_00AA0100&REV_1003", " Acer aspire one" } ,
    { 0x046D, " ", "Logitech Inc." } ,
    { 0x0483, "UPEK", "UPEK" } ,
    { 0x04A9, "Canon Scanner Elite", "Canon" } ,
    { 0x04B3, " Satrio", "IBM" } ,
    { 0x04D9, " ", "Filco" } ,
    { 0x04F2, "Chicony Electronics", "Chicony Electronics Co. " } ,
    { 0x051D, "INT33A0   ", "ACPI\\VEN_INT&DEV_33A0" } ,
    { 0x0529, " ", "Aladdin E-Token" } ,
    { 0x0553, "Aiptek", " Aiptek USA" } ,
    { 0x058f, "Alcor", "Alcor Micro Corp." } ,
    { 0x0590, " ", "Omron Corp" } ,
    { 0x05ac, "Apple", "Apple Inc." } ,
    { 0x05E1, "D-MAX", "D-MAX" } ,
    { 0x064e, " Suyin", "SUYIN Corporation" } ,
    { 0x067B, "Prolific", "Prolific Technology Inc." } ,
    { 0x06FE, "Acresso Software", "Acresso Software Inc." } ,
    { 0x0711, "SIIG, Inc.", "SIIG, Inc." } ,
    { 0x093a, "Genius", "KYE Systems Corp. / Pixart Imaging" } ,
    { 0x096E, " ", "USB Rockey dongle from Feitain " } ,
    { 0x0A5C, " sd vid_02d0&pid_4330&fn_1", "Broadcom Corporation" } ,
    { 0x0A89, "BREA", "BREA Technologies Inc." } ,
    { 0x0A92, "Egosys", "Egosys, Inc." } ,
    { 0x0AC8, "ASUS ", "ASUS " } ,
    { 0x0b05, "Toshiba BT-183 bluetooth 2.0", "Toshiba Bluetooth RFBUS, RFCOM, RFHID" } ,
    { 0x0c45, "Microdia p", "Microdia Ltd." } ,
    { 0x0cf3, " ", "TP-Link" } ,
    { 0x0D2E, "Feedback Group ", "Feedback Instruments Ltd." } ,
    { 0x0D8C, "C-Media Electronics", "C-Media Electronics, Inc." } ,
    { 0x0DF6, "Sitecom", "Sitecom" } ,
    { 0x0E11, "Compaq", "Compaq Computer Corp." } ,
    { 0x0E8D, "MediaTek Inc.", "MediaTek Inc." } ,
    { 0x1000, "LSI", "LSI Logic" } ,
    { 0x1001, "KOLTER", "Kolter Electronic - Germany" } ,
    { 0x1002, "AMD", "Advanced Micro Devices, Inc." } ,
    { 0x1003, "ULSI", "ULSI" } ,
    { 0x1004, "VLSI", "VLSI Technology" } ,
    { 0x1006, "Reply", "Reply Group" } ,
    { 0x1007, "NetFrame", "Netframe Systems Inc." } ,
    { 0x1008, "Epson", "Epson" } ,
    { 0x100A, "Phoenix", "Âas Ltd. de Phoenix del  de TecnologÃ" } ,
    { 0x100B, "NSC", "National Semiconductors" } ,
    { 0x100C, "Tseng", "Tseng Labs" } ,
    { 0x100D, "AST", "AST Research" } ,
    { 0x100E, "Weitek", "Weitek" } ,
    { 0x1010, "VLogic", "Video Logic Ltd." } ,
    { 0x1011, "DEC", "Digital Equipment Corporation" } ,
    { 0x1012, "Micronics", "Micronics Computers Inc." } ,
    { 0x1013, "Cirrus", "Cirrus Logic" } ,
    { 0x1014, "IBM", "International Business Machines Corp." } ,
    { 0x1016, "Fujitsu ICL", "Fujitsu ICL Computers" } ,
    { 0x1017, "Spea", "Spea Software AG" } ,
    { 0x1018, "Unisys", "Unisys Systems" } ,
    { 0x1019, "ECS", "Elitegroup Computer System" } ,
    { 0x101A, "NCR", "NCR Corporation" } ,
    { 0x101B, "Vitesse", "Vitesse Semiconductor" } ,
    { 0x101E, "AMI", "American Megatrends Inc." } ,
    { 0x101F, "PictureTel", "PictureTel Corp." } ,
    { 0x1020, "Hitachi", "Hitachi Computer Electronics" } ,
    { 0x1021, "OKI", "Oki Electric Industry" } ,
    { 0x1022, "AMD", "Advanced Micro Devices" } ,
    { 0x1023, "machdo", "TRIDENT MICRO" } ,
    { 0x1025, "Acer", "Acer Incorporated" } ,
    { 0x1028, "Dell755", "Dell Inc." } ,
    { 0x102A, "LSI", "LSI Logic Headland Division" } ,
    { 0x102B, "Matrox", "Matrox Electronic Systems Ltd." } ,
    { 0x102C, "C&T", "Asiliant (Chips And Technologies)" } ,
    { 0x102D, "Wyse", "Wyse Technology" } ,
    { 0x102E, "Olivetti", "Olivetti Advanced Technology" } ,
    { 0x102F, "U305-S7446", "Toshiba America" } ,
    { 0x1030, "TMC", "TMC Research" } ,
    { 0x1031, "miro dc30d", "miro Computer Products AG" } ,
    { 0x1033, "NEC", "NEC Electronics" } ,
    { 0x1034, "Burndy", "Burndy Corporation" } ,
    { 0x1036, "FDomain", "Future Domain" } ,
    { 0x1037, "Hitachi", "Hitachi Micro Systems Inc" } ,
    { 0x1038, "AMP", "AMP Incorporated" } ,
    { 0x1039, "SiS", "Silicon Integrated Systems" } ,
    { 0x103A, "Seiko", "Seiko Epson Corporation" } ,
    { 0x103B, "Tatung", "Tatung Corp. Of America" } ,
    { 0x103C, "HP", "Hewlett-Packard" } ,
    { 0x103E, "Solliday", "Solliday Engineering" } ,
    { 0x103F, "Logic Mod.", "Logic Modeling" } ,
    { 0x1041, "Computrend", "Computrend" } ,
    { 0x1043, "Asustek", "Asustek Computer Inc." } ,
    { 0x1044, "DPT", "Distributed Processing Tech" } ,
    { 0x1045, "OPTi", "OPTi Inc." } ,
    { 0x1046, "IPC", "IPC Corporation LTD" } ,
    { 0x1047, "Genoa", "Genoa Systems Corp." } ,
    { 0x1048, "ELSA", "ELSA GmbH" } ,
    { 0x1049, "Fountain", "Fountain Technology" } ,
    { 0x104A, "STM", "STMicroelectronics" } ,
    { 0x104B, "", "Mylex / Buslogic" } ,
    { 0x104C, "TSIK", "Texas Instruments" } ,
    { 0x104D, "Sony", "Sony Corporation" } ,
    { 0x104E, "Oak", "Oak Technology" } ,
    { 0x104F, "Co-Time", "Co-Time Computer Ltd." } ,
    { 0x1050, "Winbond", "Winbond Electronics Corp." } ,
    { 0x1051, "Anigma", "Anigma Corp." } ,
    { 0x1053, "Young", "Young Micro Systems" } ,
    { 0x1054, "Hitachi", "Hitachi Ltd" } ,
    { 0x1055, "SMSC", "Standard Microsystems Corp." } ,
    { 0x1056, "ICL", "ICL" } ,
    { 0x1057, "Motorola", "Motorola" } ,
    { 0x1058, "ETRI", "Electronics & Telecommunication Res" } ,
    { 0x1059, "Kontron", "Kontron Canada" } ,
    { 0x105A, "Promise", "Promise Technology" } ,
    { 0x105B, "Mobham", "Mobham chip" } ,
    { 0x105C, "Wipro", "Wipro Infotech Limited" } ,
    { 0x105D, "Number-Nine", "Number Nine Visual Technology" } ,
    { 0x105E, "Vtech", "Vtech Engineering Canada Ltd." } ,
    { 0x105F, "Infotronic", "Infotronic America Inc." } ,
    { 0x1060, "UMC", "United Microelectronics" } ,
    { 0x1061, "8x8", "8x8 Inc." } ,
    { 0x1062, "Maspar", "Maspar Computer Corp." } ,
    { 0x1063, "OOA", "Ocean Office Automation" } ,
    { 0x1064, "Alcatel", "Alcatel Cit" } ,
    { 0x1065, "TM", "Texas Microsystems" } ,
    { 0x1066, "Picopower", "Picopower Technology" } ,
    { 0x1067, "Mitsubishi", "Mitsubishi Electronics" } ,
    { 0x1068, "Div. Tech.", "Diversified Technology" } ,
    { 0x106A, "Aten", "Aten Research Inc." } ,
    { 0x106B, "Apple", "Apple Inc." } ,
    { 0x106C, "Hyundai", "Hyundai Electronics America" } ,
    { 0x106D, "Sequent", "Sequent Computer Systems" } ,
    { 0x106E, "DFI", "DFI Inc." } ,
    { 0x106F, "CityGate", "City Gate Development LTD" } ,
    { 0x1070, "Daewoo", "Daewoo Telecom Ltd." } ,
    { 0x1071, "Mitac", "Mitac" } ,
    { 0x1072, "GIT", "GIT Co. Ltd." } ,
    { 0x1073, "Yamaha", "Yamaha Corporation" } ,
    { 0x1074, "Nexgen", "Nexgen Microsystems" } ,
    { 0x1075, "AIR", "Advanced Integration Research" } ,
    { 0x1077, "QLogic", "QLogic Corporation" } ,
    { 0x1078, "Cyrix", "Cyrix Corporation" } ,
    { 0x1079, "I-Bus", "I-Bus" } ,
    { 0x107A, "Networth", "Networth controls" } ,
    { 0x107B, "Gateway", "Gateway 2000" } ,
    { 0x107C, "Goldstar", "Goldstar Co. Ltd." } ,
    { 0x107D, "Leadtek", "Leadtek Research" } ,
    { 0x107E, "Interphase", "Testernec" } ,
    { 0x107F, "DTC", "Data Technology Corporation" } ,
    { 0x1080, "Cypress", "Cypress Semiconductor" } ,
    { 0x1081, "Radius Inc.", "Radius Inc." } ,
    { 0x1082, "EFA", "EFA Corporation Of America" } ,
    { 0x1083, "Forex", "Forex Computer Corporation" } ,
    { 0x1084, "Parador", "Parador" } ,
    { 0x1085, "Tulip", "Tulip Computers Int'l BV" } ,
    { 0x1086, "J. Bond", "J. Bond Computer Systems" } ,
    { 0x1087, "Cache", "Cache Computer" } ,
    { 0x1088, "MS Son.", "Microcomputer Systems (M) Son" } ,
    { 0x1089, "DG", "Data General Corporation" } ,
    { 0x108A, "Bit3", "SBS  Operations" } ,
    { 0x108C, "Oakleigh", "Oakleigh Systems Inc." } ,
    { 0x108D, "Olicom", "Olicom" } ,
    { 0x108E, "Sun", "Sun Microsystems" } ,
    { 0x108F, "Systemsoft", "Systemsoft Corporation" } ,
    { 0x1090, "Encore", "Encore Computer Corporation" } ,
    { 0x1091, "Intergraph", "Intergraph Corporation" } ,
    { 0x1092, "Diamond", "Diamond Computer Systems" } ,
    { 0x1093, "NI", "National Instruments" } ,
    { 0x1094, "Apostolos", "Apostolos" } ,
    { 0x1095, "Silicon Image", "Silicon Image, Inc." } ,
    { 0x1096, "Alacron", "Alacron" } ,
    { 0x1097, "Appian", "Appian Graphics" } ,
    { 0x1098, "Quantum", "Quantum Designs Ltd." } ,
    { 0x1099, "Samsung", "Samsung Electronics Co. Ltd." } ,
    { 0x109A, "Packard-Bell", "Packard Bell" } ,
    { 0x109B, "Gemlight", "Gemlight Computer Ltd." } ,
    { 0x109C, "Megachips", "Megachips Corporation" } ,
    { 0x109D, "Zida", "Zida Technologies Ltd." } ,
    { 0x109E, "Brooktree", "Brooktree Corporation" } ,
    { 0x109F, "Trigem", "Trigem Computer Inc." } ,
    { 0x10A0, "Meidensha", "Meidensha Corporation" } ,
    { 0x10A1, "Juko", "Juko Electronics Inc. Ltd." } ,
    { 0x10A2, "Quantum", "Quantum Corporation" } ,
    { 0x10A3, "Everex", "Everex Systems Inc." } ,
    { 0x10A4, "Globe", "Globe Manufacturing Sales" } ,
    { 0x10A5, "Racal", "Racal Interlan" } ,
    { 0x10A8, "Sierra", "Sierra Semiconductor" } ,
    { 0x10A9, "SG", "Silicon Graphics" } ,
    { 0x10AB, "Digicom", "Digicom" } ,
    { 0x10AC, "Honeywell", "Honeywell IASD" } ,
    { 0x10AD, "Winbond", "Winbond Systems Labs" } ,
    { 0x10AE, "Cornerstone", "Cornerstone Technology" } ,
    { 0x10AF, "MCS", "Micro Computer Systems Inc." } ,
    { 0x10B0, "Gainward GmbH ", "Gainward GmbH " } ,
    { 0x10B1, "Cabletron", "Cabletron Systems Inc." } ,
    { 0x10B2, "Raytheon", "Raytheon Company" } ,
    { 0x10B3, "Databook", "Databook Inc." } ,
    { 0x10B4, "STB", "STB Systems" } ,
    { 0x10B5, "PLX", "PLX Technology Inc." } ,
    { 0x10B6, "Madge", "Madge Networks" } ,
    { 0x10B7, "3Com", "3Com Corporation" } ,
    { 0x10B8, "SMC", "Standard Microsystems Corporation" } ,
    { 0x10B9, "Ali", "Ali Corporation" } ,
    { 0x10BA, "Mitsubishi", "Mitsubishi Electronics Corp." } ,
    { 0x10BB, "Dapha", "Dapha Electronics Corporation" } ,
    { 0x10BC, "ALR", "Advanced Logic Research Inc." } ,
    { 0x10BD, "Surecom", "Surecom Technology" } ,
    { 0x10BE, "Tseng", "Tsenglabs International Corp." } ,
    { 0x10BF, "MOST", "MOST Corp." } ,
    { 0x10C0, "Boca", "Boca Research Inc." } ,
    { 0x10C1, "ICM", "ICM Corp. Ltd." } ,
    { 0x10C2, "Auspex", "Auspex Systems Inc." } ,
    { 0x10C3, "Samsung", "Samsung Semiconductors" } ,
    { 0x10C4, "wim", "Award Software Int'l Inc." } ,
    { 0x10C5, "Xerox Workcentre XD103", "Xerox Corporation" } ,
    { 0x10C6, "Rambus", "Rambus Inc." } ,
    { 0x10C8, "Neomagic", "Neomagic Corporation" } ,
    { 0x10C9, "Dataexpert", "Dataexpert Corporation" } ,
    { 0x10CA, "Fujitsu", "Fujitsu Siemens" } ,
    { 0x10CB, "Omron", "Omron Corporation" } ,
    { 0x10CD, "AdvanSys", "Advanced System Products" } ,
    { 0x10CF, "Fujitsu", "Fujitsu Ltd." } ,
    { 0x10D1, "Future+", "Future+ Systems" } ,
    { 0x10D2, "Molex", "Molex Incorporated" } ,
    { 0x10D3, "Jabil", "Jabil Circuit Inc." } ,
    { 0x10D4, "Hualon", "Hualon Microelectronics" } ,
    { 0x10D5, "Autologic", "Autologic Inc." } ,
    { 0x10D6, "Wilson .co .ltd", "Wilson .co .ltd" } ,
    { 0x10D7, "BCM", "BCM Advanced Research" } ,
    { 0x10D8, "APL", "Advanced Peripherals Labs" } ,
    { 0x10D9, "Macronix", "Macronix International Co. Ltd." } ,
    { 0x10DB, "Rohm", "Rohm Research" } ,
    { 0x10DC, "CERN", "CERN-European Lab. for Particle Physics" } ,
    { 0x10DD, "E&S", "Evans & Sutherland" } ,
    { 0x10DE, "NVIDIA", "NVIDIA" } ,
    { 0x10DF, "Emulex", "Emulex Corporation" } ,
    { 0x10E1, "Tekram", "Tekram Technology Corp. Ltd." } ,
    { 0x10E2, "Aptix", "Aptix Corporation" } ,
    { 0x10E3, "Tundra", "Tundra Semiconductor Corp." } ,
    { 0x10E4, "Tandem", "Tandem Computers" } ,
    { 0x10E5, "MIC", "Micro Industries Corporation" } ,
    { 0x10E6, "Gainbery", "Gainbery Computer Products Inc." } ,
    { 0x10E7, "Vadem", "Vadem" } ,
    { 0x10E8, "AMCC", "Applied Micro Circuits Corp." } ,
    { 0x10E9, "Alps", "Alps Electronic Corp. Ltd." } ,
    { 0x10EA, "Tvia", "Tvia, Inc." } ,
    { 0x10EB, "Artist", "Artist Graphics" } ,
    { 0x10EC, "Realtek", "Realtek Semiconductor Corp." } ,
    { 0x10ED, "Ascii", "Ascii Corporation" } ,
    { 0x10EE, "Xilinx", "Xilinx Corporation" } ,
    { 0x10EF, "Racore", "Racore Computer Products" } ,
    { 0x10F0, "Real-Time Graphics & Video", "Curtiss-Wright Controls Embedded Computing" } ,
    { 0x10F1, "Tyan", "Tyan Computer" } ,
    { 0x10F2, "Achme", "Achme Computer Inc. - GONE !!!!" } ,
    { 0x10F3, "Alaris", "Alaris Inc." } ,
    { 0x10F4, "S-Mos", "S-Mos Systems" } ,
    { 0x10F5, "NKK", "NKK Corporation" } ,
    { 0x10F6, "CES", "Creative Electronic Systems SA" } ,
    { 0x10F7, "Matsushita", "Matsushita Electric Industrial Corp." } ,
    { 0x10F8, "Altos", "Altos India Ltd." } ,
    { 0x10F9, "PC-Direct", "PC Direct" } ,
    { 0x10FA, "Truevision", "Truevision" } ,
    { 0x10FB, "Thesys", "Thesys Microelectronic's" } ,
    { 0x10FC, "I-O", "I-O Data Device Inc." } ,
    { 0x10FD, "Soyo", "Soyo Technology Corp. Ltd." } ,
    { 0x10FE, "Fast", "Fast Electronic GmbH" } ,
    { 0x10FF, "Ncube", "Ncube" } ,
    { 0x1100, "Jazz", "Jazz Multimedia" } ,
    { 0x1101, "Initio", "Initio Corporation" } ,
    { 0x1102, "Creative Labs", "Creative Technology LTD." } ,
    { 0x1103, "HighPoint", " HighPoint Technologies, Inc." } ,
    { 0x1104, "Rasterops", "Rasterops" } ,
    { 0x1105, "Sigma", "Sigma Designs Inc." } ,
    { 0x1106, "VIA", "VIA Technologies, Inc." } ,
    { 0x1107, "Stratus", "Stratus Computer" } ,
    { 0x1108, "Proteon", "Proteon Inc." } ,
    { 0x1109, "Cogent", "Adaptec/Cogent Data Technologies" } ,
    { 0x110A, "Siemens", "Siemens AG" } ,
    { 0x110B, "Chromatic", "Chromatic Research Inc" } ,
    { 0x110C, "Mini-Max", "Mini-Max Technology Inc." } ,
    { 0x110D, "ZNYX", "ZNYX Corporation" } ,
    { 0x110E, "CPU Tech.", "CPU Technology" } ,
    { 0x110F, "Ross", "Ross Technology" } ,
    { 0x1112, "Osicom", "Osicom Technologies Inc." } ,
    { 0x1113, "Accton", "Accton Technology Corporation" } ,
    { 0x1114, "Atmel", "Atmel Corp." } ,
    { 0x1116, "Data Translation", "Data Translation, Inc." } ,
    { 0x1117, "Datacube", "Datacube Inc." } ,
    { 0x1118, "Berg", "Berg Electronics" } ,
    { 0x1119, "Vortex", "ICP vortex Computersysteme GmbH" } ,
    { 0x111A, "Eff. Net.", "Efficent Networks" } ,
    { 0x111C, "Tricord", "Tricord Systems Inc." } ,
    { 0x111D, "IDT", "Integrated Device Technology Inc." } ,
    { 0x111F, "PDI", "Precision Digital Images" } ,
    { 0x1120, "EMC", "EMC Corp." } ,
    { 0x1121, "Zilog", "Zilog" } ,
    { 0x1123, "EDI", "Excellent Design Inc." } ,
    { 0x1124, "Leutron", "Leutron Vision AG" } ,
    { 0x1125, "Eurocore", "Eurocore/Vigra" } ,
    { 0x1127, "FORE RUNNER LE", "FORE Systems" } ,
    { 0x1129, "Firmworks", "Firmworks" } ,
    { 0x112A, "Hermes", "Hermes Electronics Co. Ltd." } ,
    { 0x112C, "Zenith", "Zenith Data Systems" } ,
    { 0x112D, "Ravicad", "Ravicad" } ,
    { 0x112E, "Infomedia", "Infomedia" } ,
    { 0x1130, "Computervision", "Computervision" } ,
    { 0x1131, "NXP", "NXP Semiconductors N.V." } ,
    { 0x1132, "Mitel", "Mitel Corp." } ,
    { 0x1133, "EIC", "Eicon Networks Corporation" } ,
    { 0x1134, "MCS", "Mercury Computer Systems Inc." } ,
    { 0x1135, "Fuji", "Fuji Xerox Co Ltd" } ,
    { 0x1136, "Momentum", "Momentum Data Systems" } ,
    { 0x1137, "Cisco", "Cisco Systems Inc" } ,
    { 0x1138, "Ziatech", "Ziatech Corporation" } ,
    { 0x1139, "Dyn. Pict.", "Dynamic Pictures Inc" } ,
    { 0x113A, "FWB", "FWB  Inc" } ,
    { 0x113B, "NCD", "Network Computing Devices" } ,
    { 0x113C, "Cyclone", "Cyclone Microsystems Inc." } ,
    { 0x113D, "Leading Edge", "Leading Edge Products Inc" } ,
    { 0x113E, "Sanyo", "Sanyo Electric Co" } ,
    { 0x113F, "Equinox", "Equinox Systems" } ,
    { 0x1140, "Intervoice", "Intervoice Inc" } ,
    { 0x1141, "Crest", "Crest Microsystem Inc" } ,
    { 0x1142, "Alliance", "Alliance Semiconductor" } ,
    { 0x1143, "Netpower", "Netpower Inc" } ,
    { 0x1144, "Cinn. Mil.", "Cincinnati Milacron" } ,
    { 0x1145, "Workbit", "Workbit Corp" } ,
    { 0x1146, "Force", "Force Computers" } ,
    { 0x1147, "Interface", "Interface Corp" } ,
    { 0x1148, "Marvell", "Marvell Semiconductor Germany GmbH" } ,
    { 0x1149, "Win System", "Win System Corporation" } ,
    { 0x114A, "VMIC", "VMIC" } ,
    { 0x114B, "Canopus", "Canopus corporation" } ,
    { 0x114C, "Annabooks", "Annabooks" } ,
    { 0x114D, "IC Corp.", "IC Corporation" } ,
    { 0x114E, "Nikon", "Nikon Systems Inc" } ,
    { 0x114F, "Digi", "Digi International" } ,
    { 0x1150, "TMC", "Thinking Machines Corporation" } ,
    { 0x1151, "JAE", "JAE Electronics Inc." } ,
    { 0x1153, "Land Win", "Land Win Electronic Corp" } ,
    { 0x1154, "Melco", "Melco Inc" } ,
    { 0x1155, "Pine", "Pine Technology Ltd" } ,
    { 0x1156, "Periscope", "Periscope Engineering" } ,
    { 0x1157, "Avsys", "Avsys Corporation" } ,
    { 0x1158, "Voarx", "Voarx R&D Inc" } ,
    { 0x1159, "Mutech", "Mutech" } ,
    { 0x115A, "Harlequin", "Harlequin Ltd" } ,
    { 0x115B, "Parallax", "Parallax Graphics" } ,
    { 0x115C, "Photron", "Photron Ltd." } ,
    { 0x115D, "Xircom", "Xircom" } ,
    { 0x115E, "Peer", "Peer Protocols Inc" } ,
    { 0x115F, "Maxtorr", "Maxtor Corporation" } ,
    { 0x1160, "Megasoft", "Megasoft Inc" } ,
    { 0x1161, "PFU", "PFU Ltd" } ,
    { 0x1162, "OA Lab", "OA Laboratory Co Ltd" } ,
    { 0x1163, "mohamed", "mohamed alsherif" } ,
    { 0x1164, "APT", "Advanced Peripherals Tech" } ,
    { 0x1165, "Imagraph", "Imagraph Corporation" } ,
    { 0x1166, "BRCM/ServerWorks", "Broadcom / ServerWorks" } ,
    { 0x1167, "Mutoh", "Mutoh Industries Inc" } ,
    { 0x1168, "Thine", "Thine Electronics Inc" } ,
    { 0x1169, "CDAC", "Centre f/Dev. of Adv. Computing" } ,
    { 0x116A, "Luminex", "Luminex Software, Inc" } ,
    { 0x116B, "Connectware", "Connectware Inc" } ,
    { 0x116C, "Int Res.", "Intelligent Resources" } ,
    { 0x116E, "EFI", "Electronics for Imaging" } ,
    { 0x1170, "Inventec", "Inventec Corporation" } ,
    { 0x1172, "Altera", "Altera Corporation" } ,
    { 0x1173, "Adobe", "Adobe Systems" } ,
    { 0x1174, "Bridgeport", "Bridgeport Machines" } ,
    { 0x1175, "Mitron", "Mitron Computer Inc." } ,
    { 0x1176, "SBE", "SBE" } ,
    { 0x1177, "Silicon Eng.", "Silicon Engineering" } ,
    { 0x1178, "Alfa", "Alfa Inc" } ,
    { 0x1179, "Toshiba", "Toshiba corporation" } ,
    { 0x117A, "A-Trend", "A-Trend Technology" } ,
    { 0x117B, "LG", "LG (Lucky Goldstar) Electronics Inc." } ,
    { 0x117C, "Atto", "Atto Technology" } ,
    { 0x117D, "B&D", "Becton & Dickinson" } ,
    { 0x117E, "T/R", "T/R Systems" } ,
    { 0x117F, "ICS", "Integrated Circuit Systems" } ,
    { 0x1180, "Ricoh", "RicohCompany,Ltd." } ,
    { 0x1183, "Fujikura", "Fujikura Ltd" } ,
    { 0x1184, "Forks", "Forks Inc" } ,
    { 0x1185, "Dataworld", "Dataworld" } ,
    { 0x1186, "D-Link", "D-Link System Inc" } ,
    { 0x1187, "Philips Healthcare", "Philips Healthcare" } ,
    { 0x1188, "Shima", "Shima Seiki Manufacturing Ltd." } ,
    { 0x1189, "Matsushita", "Matsushita Electronics" } ,
    { 0x118A, "Hilevel", "Hilevel Technology" } ,
    { 0x118B, "Hypertec", "Hypertec Pty Ltd" } ,
    { 0x118C, "Corollary", "Corollary Inc" } ,
    { 0x118D, "BitFlow", "BitFlow Inc" } ,
    { 0x118E, "Hermstedt", "Hermstedt AG" } ,
    { 0x118F, "Green", "Green Logic" } ,
    { 0x1190, "Tripace", "Tripace" } ,
    { 0x1191, "Acard", "Acard Technology Corp." } ,
    { 0x1192, "Densan", "Densan Co. Ltd" } ,
    { 0x1194, "Toucan", "Toucan Technology" } ,
    { 0x1195, "Ratoc", "Ratoc System Inc" } ,
    { 0x1196, "Hytec", "Hytec Electronics Ltd" } ,
    { 0x1197, "Gage", "Gage Applied Technologies" } ,
    { 0x1198, "Lambda", "Lambda Systems Inc" } ,
    { 0x1199, "Attachmate", "Attachmate Corp." } ,
    { 0x119A, "Mind Share", "Mind/Share Inc." } ,
    { 0x119B, "Omega", "Omega Micro Inc." } ,
    { 0x119C, "ITI", "Information Technology Inst." } ,
    { 0x119D, "Bug", "Bug Sapporo Japan" } ,
    { 0x119E, "Fujitsu", "Fujitsu Microelectronics Ltd." } ,
    { 0x119F, "Bull", "Bull Hn Information Systems" } ,
    { 0x11A1, "Hamamatsu", "Hamamatsu Photonics K.K." } ,
    { 0x11A2, "Sierra", "Sierra Research and Technology" } ,
    { 0x11A3, "Deuretzbacher", "Deuretzbacher GmbH & Co. Eng. KG" } ,
    { 0x11A4, "Barco", "Barco" } ,
    { 0x11A5, "MicroUnity", "MicroUnity Systems Engineering Inc." } ,
    { 0x11A6, "Pure Data", "Pure Data" } ,
    { 0x11A7, "Power Comp.", "Power Computing Corp." } ,
    { 0x11A8, "Systech", "Systech Corp." } ,
    { 0x11A9, "InnoSys", "InnoSys Inc." } ,
    { 0x11AA, "Actel", "Actel" } ,
    { 0x11AB, "Marvell", "Marvell Semiconductor" } ,
    { 0x11AC, "Canon", "Canon Information Systems" } ,
    { 0x11AD, "Lite-On", "Lite-On Technology Corp." } ,
    { 0x11AE, "Scitex", "Scitex Corporation Ltd" } ,
    { 0x11AF, "Avid", "Avid Technology, Inc." } ,
    { 0x11B0, "QuickLogic", "Quicklogic Corp" } ,
    { 0x11B1, "Apricot", "Apricot Computers" } ,
    { 0x11B2, "Kodak", "Eastman Kodak" } ,
    { 0x11B3, "Barr", "Barr Systems Inc." } ,
    { 0x11B4, "Leitch", "Leitch Technology International" } ,
    { 0x11B5, "Radstone", "Radstone Technology Ltd." } ,
    { 0x11B6, "United Video", "United Video Corp" } ,
    { 0x11B7, "Motorola", "Motorola" } ,
    { 0x11B8, "Xpoint", "Xpoint Technologies Inc" } ,
    { 0x11B9, "Pathlight", "Pathlight Technology Inc." } ,
    { 0x11BA, "Videotron", "Videotron Corp" } ,
    { 0x11BB, "Pyramid", "Pyramid Technology" } ,
    { 0x11BC, "Net. Periph.", "Network Peripherals Inc" } ,
    { 0x11BD, "Pinnacle", "Pinnacle system" } ,
    { 0x11BE, "IMI", "International Microcircuits Inc" } ,
    { 0x11BF, "Astrodesign", "Astrodesign Inc." } ,
    { 0x11C1, "LSI", "LSI Corporation" } ,
    { 0x11C2, "Sand", "Sand Microelectronics" } ,
    { 0x11C4, "Doc. Tech.", "Document Technologies Ind." } ,
    { 0x11C5, "Shiva", "Shiva Corporatin" } ,
    { 0x11C6, "Dainippon", "Dainippon Screen Mfg. Co" } ,
    { 0x11C7, "D.C.M.", "D.C.M. Data Systems" } ,
    { 0x11C8, "Dolphin", "Dolphin Interconnect Solutions" } ,
    { 0x11C9, "MAGMA", "MAGMA" } ,
    { 0x11CA, "LSI Sys.", "LSI Systems Inc" } ,
    { 0x11CB, "Specialix", "Specialix International Ltd." } ,
    { 0x11CC, "M&K", "Michels & Kleberhoff Computer GmbH" } ,
    { 0x11CD, "HAL", "HAL Computer Systems Inc." } ,
    { 0x11CE, "PRI", "Primary Rate Inc" } ,
    { 0x11CF, "PEC", "Pioneer Electronic Corporation" } ,
    { 0x11D0, "BAE", "BAE SYSTEMS - Manassas" } ,
    { 0x11D1, "AuraVision", "AuraVision Corporation" } ,
    { 0x11D2, "Intercom", "Intercom Inc." } ,
    { 0x11D3, "Trancell", "Trancell Systems Inc" } ,
    { 0x11D4, "ADI", "Analog Devices, Inc." } ,
    { 0x11D5, "Tahoma", "Tahoma Technology" } ,
    { 0x11D6, "Tekelec", "Tekelec Technologies" } ,
    { 0x11D7, "Trenton", "TRENTON Technology, Inc." } ,
    { 0x11D8, "ITD", "Image Technologies Development" } ,
    { 0x11D9, "Tec", "Tec Corporation" } ,
    { 0x11DA, "Novell", "Novell" } ,
    { 0x11DB, "Sega", "Sega Enterprises Ltd" } ,
    { 0x11DC, "Questra", "Questra Corp" } ,
    { 0x11DD, "Crosfield", "Crosfield Electronics Ltd" } ,
    { 0x11DE, "Zoran", "Zoran Corporation" } ,
    { 0x11E1, "Gec Plessey", "Gec Plessey Semi Inc" } ,
    { 0x11E2, "Samsung", "Samsung Information Systems America" } ,
    { 0x11E3, "QuickLogic", "Quicklogic Corp" } ,
    { 0x11E4, "Second Wave", "Second Wave Inc" } ,
    { 0x11E5, "IIX", "IIX Consulting" } ,
    { 0x11E6, "Mitsui", "Mitsui-Zosen System Research" } ,
    { 0x11E8, "DPSI", "Digital Processing Systems Inc" } ,
    { 0x11E9, "Highwater", "Highwater Designs Ltd" } ,
    { 0x11EA, "Elsag", "Elsag Bailey" } ,
    { 0x11EB, "Formation", "Formation, Inc" } ,
    { 0x11EC, "Coreco", "Coreco Inc" } ,
    { 0x11ED, "Mediamatics", "Mediamatics" } ,
    { 0x11EE, "Dome", "Dome Imaging Systems Inc" } ,
    { 0x11EF, "Nicolet", "Nicolet Technologies BV" } ,
    { 0x11F0, "Triyabosa", "Triya" } ,
    { 0x11F2, "Pic-Tel", "Picture Tel Japan KK" } ,
    { 0x11F3, "Keithley", "Keithley Instruments, Inc" } ,
    { 0x11F4, "Kinetic", "Kinetic Systems Corporation" } ,
    { 0x11F5, "Comp Dev", "Computing Devices Intl" } ,
    { 0x11F6, "Powermatic", "Powermatic Data Systems Ltd" } ,
    { 0x11F7, "S-A", "Scientific Atlanta" } ,
    { 0x11F8, "PMC-Sierra", "PMC-Sierra Inc." } ,
    { 0x11F9, "I-Cube", "I-Cube Inc" } ,
    { 0x11FA, "Kasan", "Kasan Electronics Co Ltd" } ,
    { 0x11FB, "Datel", "Datel Inc" } ,
    { 0x11FD, "High Street", "High Street Consultants" } ,
    { 0x11FE, "Comtrol", "Comtrol Corp" } ,
    { 0x11FF, "Scion", "Scion Corp" } ,
    { 0x1200, "CSS", "CSS Corp" } ,
    { 0x1201, "Vista", "Vista Controls Corp" } ,
    { 0x1202, "Network Gen", "Network General Corp" } ,
    { 0x1203, "Agfa", "Bayer Corporation Agfa Div" } ,
    { 0x1204, "Lattice", "Lattice Semiconductor Corp" } ,
    { 0x1205, "Array", "Array Corp" } ,
    { 0x1206, "Amdahl", "Amdahl Corp" } ,
    { 0x1208, "Parsytec", "Parsytec GmbH" } ,
    { 0x1209, "Sci Sys", "Sci Systems Inc" } ,
    { 0x120A, "Synaptel", "Synaptel" } ,
    { 0x120B, "Adaptive", "Adaptive Solutions" } ,
    { 0x120D, "Comp Labs", "Compression Labs Inc." } ,
    { 0x120E, "Cyclades", "Cyclades Corporation" } ,
    { 0x120F, "Essential", "Essential Communications" } ,
    { 0x1210, "Hyperparallel", "Hyperparallel Technologies" } ,
    { 0x1211, "Braintech", "Braintech Inc" } ,
    { 0x1213, "AISI", "Applied Intelligent Systems Inc" } ,
    { 0x1214, "Perf Tech", "Performance Technologies Inc" } ,
    { 0x1215, "Interware", "Interware Co Ltd" } ,
    { 0x1216, "Purup Eskofot", "Purup-Eskofot A/S" } ,
    { 0x1217, "O2Micro", "O2Micro Inc" } ,
    { 0x1218, "Hybricon", "Hybricon Corp" } ,
    { 0x1219, "First Virtual", "First Virtual Corp" } ,
    { 0x121A, "3dfx", "3dfx Interactive Inc" } ,
    { 0x121B, "ATM", "Advanced Telecommunications Modules" } ,
    { 0x121C, "Nippon Texa", "Nippon Texa Co Ltd" } ,
    { 0x121D, "LiPPERT", "LiPPERT Embedded Computers GmbH" } ,
    { 0x121E, "CSPI", "CSPI" } ,
    { 0x121F, "Arcus", "Arcus Technology Inc" } ,
    { 0x1220, "Ariel", "Ariel Corporation" } ,
    { 0x1221, "Contec", "Contec Microelectronics Europe BV" } ,
    { 0x1222, "Ancor", "Ancor Communications Inc" } ,
    { 0x1223, "Artesyn Embedded", "Artesyn Embedded Technologies" } ,
    { 0x1224, "Int. Img.", "Interactive Images" } ,
    { 0x1225, "Power IO", "Power I/O Inc." } ,
    { 0x1227, "Tech-Source", "Tech-Source" } ,
    { 0x1228, "Norsk", "Norsk Elektro Optikk A/S" } ,
    { 0x1229, "Data Kin", "Data Kinesis Inc." } ,
    { 0x122A, "Int. Telecom", "Integrated Telecom" } ,
    { 0x122B, "LG Ind.", "LG Industrial Systems Co. Ltd." } ,
    { 0x122C, "sci-worx", "sci-worx GmbH" } ,
    { 0x122D, "Aztech", "Aztech System Ltd" } ,
    { 0x122E, "Absolute Analysis", "Absolute Analysis" } ,
    { 0x122F, "Andrew", "Andrew Corp." } ,
    { 0x1230, "Fishcamp", "Fishcamp Engineering" } ,
    { 0x1231, "WMI", "Woodward McCoach Inc." } ,
    { 0x1233, "Bus-Tech", "Bus-Tech Inc." } ,
    { 0x1234, "Technical", "Technical Corp" } ,
    { 0x1236, "Sigma Designs", "Sigma Designs, Inc" } ,
    { 0x1237, "Alta Tech", "Alta Technology Corp." } ,
    { 0x1238, "Adtran", "Adtran" } ,
    { 0x1239, "3DO", "The 3DO Company" } ,
    { 0x123A, "Visicom", "Visicom Laboratories Inc." } ,
    { 0x123B, "Seeq", "Seeq Technology Inc." } ,
    { 0x123C, "Century Sys", "Century Systems Inc." } ,
    { 0x123D, "EDT", "Engineering Design Team Inc." } ,
    { 0x123F, "C-Cube", "C-Cube Microsystems" } ,
    { 0x1240, "Marathon", "Marathon Technologies Corp." } ,
    { 0x1241, "DSC", "DSC Communications" } ,
    { 0x1242, "JNI", "JNI Corporation" } ,
    { 0x1243, "Delphax", "Delphax" } ,
    { 0x1244, "AVM", "AVM AUDIOVISUELLES MKTG & Computer GmbH" } ,
    { 0x1245, "APD", "APD S.A." } ,
    { 0x1246, "Dipix", "Dipix Technologies Inc" } ,
    { 0x1247, "Xylon", "Xylon Research Inc." } ,
    { 0x1248, "Central Data", "Central Data Corp." } ,
    { 0x1249, "Samsung", "Samsung Electronics Co. Ltd." } ,
    { 0x124A, "AEG", "AEG Electrocom GmbH" } ,
    { 0x124C, "Solitron", "Solitron Technologies Inc." } ,
    { 0x124D, "Stallion", "Stallion Technologies" } ,
    { 0x124E, "Cylink", "Cylink" } ,
    { 0x124F, "Infortrend", "Infortrend Technology Inc" } ,
    { 0x1250, "Hitachi", "Hitachi Microcomputer System Ltd." } ,
    { 0x1251, "VLSI Sol.", "VLSI Solution OY" } ,
    { 0x1253, "Guzik", "Guzik Technical Enterprises" } ,
    { 0x1254, "Linear Systems", "Linear Systems Ltd." } ,
    { 0x1255, "Optibase", "Optibase Ltd." } ,
    { 0x1256, "Perceptive", "Perceptive Solutions Inc." } ,
    { 0x1257, "Vertex", "Vertex Networks Inc." } ,
    { 0x1258, "Gilbarco", "Gilbarco Inc." } ,
    { 0x1259, "Allied Tsyn", "Allied Telesyn International" } ,
    { 0x125A, "ABB Pwr", "ABB Power Systems" } ,
    { 0x125B, "Asix", "Asix Electronics Corp." } ,
    { 0x125C, "Aurora", "Aurora Technologies Inc." } ,
    { 0x125D, "ESS", "ESS Technology" } ,
    { 0x125E, "Specvideo", "Specialvideo Engineering SRL" } ,
    { 0x125F, "CCT", "Concurrent Technologies Inc." } ,
    { 0x1260, "Intersil", "Intersil Corporation" } ,
    { 0x1261, "Matsushita", "Matsushita-Kotobuki Electronics Indu" } ,
    { 0x1262, "ES Comp.", "ES Computer Co. Ltd." } ,
    { 0x1263, "Sonic Sol.", "Sonic Solutions" } ,
    { 0x1264, "Aval Nag.", "Aval Nagasaki Corp." } ,
    { 0x1265, "Casio", "Casio Computer Co. Ltd." } ,
    { 0x1266, "Microdyne", "Microdyne Corp." } ,
    { 0x1267, "SA Telecom", "S.A. Telecommunications" } ,
    { 0x1268, "Tektronix", "Tektronix" } ,
    { 0x1269, "SGS Thomson", "Thomson-CSF/TTM" } ,
    { 0x126A, "Lexmark", "Lexmark International Inc." } ,
    { 0x126B, "Adax", "Adax Inc." } ,
    { 0x126C, "Nortel", "Nortel Networks Corp." } ,
    { 0x126D, "Splash", "Splash Technology Inc." } ,
    { 0x126E, "Sumitomo", "Sumitomo Metal Industries Ltd." } ,
    { 0x126F, "Sil Motion", "Silicon Motion" } ,
    { 0x1270, "Olympus", "Olympus Optical Co. Ltd." } ,
    { 0x1271, "GW Instr.", "GW Instruments" } ,
    { 0x1272, "taish", "themrtaish" } ,
    { 0x1273, "Hughes", "Hughes Network Systems" } ,
    { 0x1274, "Ensoniq", "Ensoniq" } ,
    { 0x1275, "NetApp", "Network Appliance" } ,
    { 0x1276, "Sw Net Tech", "Switched Network Technologies Inc." } ,
    { 0x1277, "Comstream", "Comstream" } ,
    { 0x1278, "Transtech", "Transtech Parallel Systems" } ,
    { 0x1279, "Transmeta", "Transmeta Corp." } ,
    { 0x127B, "Pixera", "Pixera Corp" } ,
    { 0x127C, "Crosspoint", "Crosspoint Solutions Inc." } ,
    { 0x127D, "Vela", "Vela Research LP" } ,
    { 0x127E, "Winnow", "Winnov L.P." } ,
    { 0x127F, "Fujifilm", "Fujifilm" } ,
    { 0x1280, "Photoscript", "Photoscript Group Ltd." } ,
    { 0x1281, "Yokogawa", "Yokogawa Electronic Corp." } ,
    { 0x1282, "Davicom", "Davicom Semiconductor Inc." } ,
    { 0x1283, " Zamora", "Waldo" } ,
    { 0x1285, "Plat Tech", "Platform Technologies Inc." } ,
    { 0x1286, "MAZeT", "MAZeT GmbH" } ,
    { 0x1287, "LuxSonor", "LuxSonor Inc." } ,
    { 0x1288, "Timestep", "Timestep Corp." } ,
    { 0x1289, "AVC Tech", "AVC Technology Inc." } ,
    { 0x128A, "Asante", "Asante Technologies Inc." } ,
    { 0x128B, "Transwitch", "Transwitch Corp." } ,
    { 0x128C, "Retix", "Retix Corp." } ,
    { 0x128D, "G2 Net", "G2 Networks Inc." } ,
    { 0x128F, "Tateno", "Tateno Dennou Inc." } ,
    { 0x1290, "Sord", "Sord Computer Corp." } ,
    { 0x1291, "NCS Comp", "NCS Computer Italia" } ,
    { 0x1292, "Tritech", "Tritech Microelectronics Intl PTE" } ,
    { 0x1293, "M Reality", "Media Reality Technology" } ,
    { 0x1294, "Rhetorex", "Rhetorex Inc." } ,
    { 0x1295, "Imagenation", "Imagenation Corp." } ,
    { 0x1296, "Kofax", "Kofax Image Products" } ,
    { 0x1297, "Shuttle Computer", "Shuttle Computer" } ,
    { 0x1298, "Spellcaster", "Spellcaster Telecommunications Inc." } ,
    { 0x1299, "Know Tech", "Knowledge Technology Laboratories" } ,
    { 0x129A, "CWCEL", "Curtiss Wright Controls Electronic Systems" } ,
    { 0x129B, "Img Access", "Image Access" } ,
    { 0x129D, "CompCore", "CompCore Multimedia Inc." } ,
    { 0x129E, "Victor Jpn", "Victor Co. of Japan Ltd." } ,
    { 0x129F, "OEC Med", "OEC Medical Systems Inc." } ,
    { 0x12A0, "A-B", "Allen Bradley Co." } ,
    { 0x12A1, "Simpact", "Simpact Inc" } ,
    { 0x12A2, "NewGen", "NewGen Systems Corp." } ,
    { 0x12A3, "Lucent", "Lucent Technologies AMR" } ,
    { 0x12A4, "NTT Elect", "NTT Electronics  Corp." } ,
    { 0x12A5, "Vision Dyn", "Vision Dynamics Ltd." } ,
    { 0x12A6, "Scalable", "Scalable Networks Inc." } ,
    { 0x12A7, "AMO", "AMO GmbH" } ,
    { 0x12A8, "News Datacom", "News Datacom" } ,
    { 0x12A9, "Xiotech", "Xiotech Corp." } ,
    { 0x12AA, "SDL", "SDL Communications Inc." } ,
    { 0x12AB, "Yuan Yuan", "Yuan Yuan Enterprise Co. Ltd." } ,
    { 0x12AC, "MeasureX", "MeasureX Corp." } ,
    { 0x12AD, "MULTIDATA", "MULTIDATA GmbH" } ,
    { 0x12AE, "Alteon", "Alteon Networks Inc." } ,
    { 0x12AF, "TDK USA", "TDK USA Corp." } ,
    { 0x12B0, "Jorge Sci", "Jorge Scientific Corp." } ,
    { 0x12B1, "GammaLink", "GammaLink" } ,
    { 0x12B2, "Gen Signal", "General Signal Networks" } ,
    { 0x12B3, "Interface", "Interface Corp. Ltd." } ,
    { 0x12B4, "Future Tel", "Future Tel Inc." } ,
    { 0x12B5, "Granite", "Granite Systems Inc." } ,
    { 0x12B7, "Acumen", "Acumen" } ,
    { 0x12B8, "Korg", "Korg" } ,
    { 0x12B9, "3Com", "3Com Corporation" } ,
    { 0x12BA, "Bittware", "Bittware, Inc" } ,
    { 0x12BB, "Nippon Uni", "Nippon Unisoft Corp." } ,
    { 0x12BC, "Array Micro", "Array Microsystems" } ,
    { 0x12BD, "Computerm", "Computerm Corp." } ,
    { 0x12BF, "Fujifilm", "Fujifilm Microdevices" } ,
    { 0x12C0, "Infimed", "Infimed" } ,
    { 0x12C1, "GMM Res", "GMM Research Corp." } ,
    { 0x12C2, "Mentec", "Mentec Ltd." } ,
    { 0x12C3, "Holtek", "Holtek Microelectronics Inc." } ,
    { 0x12C4, "Connect Tech", "Connect Tech Inc." } ,
    { 0x12C5, "PicturEl", "Picture Elements Inc." } ,
    { 0x12C6, "Mitani", "Mitani Corp." } ,
    { 0x12C7, "Dialogic", "Dialogic Corp." } ,
    { 0x12C8, "G Force", "G Force Co. Ltd." } ,
    { 0x12C9, "Gigi Ops", "Gigi Operations" } ,
    { 0x12CA, "ICE", "Integrated Computing Engines, Inc." } ,
    { 0x12CB, "Antex", "Antex Electronics Corp." } ,
    { 0x12CC, "Pluto", "Pluto Technologies International" } ,
    { 0x12CD, "Aims Lab", "Aims Lab" } ,
    { 0x12CE, "Netspeed", "Netspeed Inc." } ,
    { 0x12CF, "Prophet", "Prophet Systems Inc." } ,
    { 0x12D0, "GDE Sys", "GDE Systems Inc." } ,
    { 0x12D1, "Huawei Inc.", "Huawei Technologies Co., Ltd." } ,
    { 0x12D3, "Vingmed", "Vingmed Sound A/S" } ,
    { 0x12D4, "Ulticom", "Ulticom, Inc." } ,
    { 0x12D5, "Equator", "Equator Technologies" } ,
    { 0x12D6, "Analogic", "Analogic Corp." } ,
    { 0x12D7, "Biotronic", "Biotronic SRL" } ,
    { 0x12D8, "Pericom", "Pericom Semiconductor" } ,
    { 0x12D9, "Aculab", "Aculab Plc." } ,
    { 0x12DA, "TrueTime", "TrueTime" } ,
    { 0x12DB, "Annapolis", "Annapolis Micro Systems Inc." } ,
    { 0x12DC, "Symicron", "Symicron Computer Communication Ltd." } ,
    { 0x12DD, "MGI", "Management Graphics Inc." } ,
    { 0x12DE, "Rainbow", "Rainbow Technologies" } ,
    { 0x12DF, "SBS Tech", "SBS Technologies Inc." } ,
    { 0x12E0, "Chase", "Chase Research PLC" } ,
    { 0x12E1, "Nintendo", "Nintendo Co. Ltd." } ,
    { 0x12E2, "Datum", "Datum Inc. Bancomm-Timing Division" } ,
    { 0x12E3, "Imation", "Imation Corp. - Medical Imaging Syst" } ,
    { 0x12E4, "Brooktrout", "Brooktrout Technology Inc." } ,
    { 0x12E6, "Cirel", "Cirel Systems" } ,
    { 0x12E7, "Sebring", "Sebring Systems Inc" } ,
    { 0x12E8, "CRISC", "CRISC Corp." } ,
    { 0x12E9, "GE Spacenet", "GE Spacenet" } ,
    { 0x12EB, "Aureal", "Aureal Semiconductor" } ,
    { 0x12EC, "3A Intl", "3A International Inc." } ,
    { 0x12ED, "Optivision", "Optivision Inc." } ,
    { 0x12EE, "Orange Micro", "Orange Micro, Inc." } ,
    { 0x12EF, "Vienna", "Vienna Systems" } ,
    { 0x12F0, "Pentek", "Pentek" } ,
    { 0x12F1, "Sorenson", "Sorenson Vision Inc." } ,
    { 0x12F2, "Gammagraphx", "Gammagraphx Inc." } ,
    { 0x12F4, "Megatel", "Megatel" } ,
    { 0x12F5, "Forks", "Forks" } ,
    { 0x12F7, "Cognex", "Cognex" } ,
    { 0x12F8, "Electronic-Design", "Electronic-Design GmbH" } ,
    { 0x12F9, "FFT", "FourFold Technologies" } ,
    { 0x12FB, "SSP", "Spectrum Signal Processing" } ,
    { 0x12FC, "CEC", "Capital Equipment Corp" } ,
    { 0x12FE, "esd", "esd Electronic System Design GmbH" } ,
    { 0x1303, "II", "Innovative Integration" } ,
    { 0x1304, "", "Juniper Networks Inc." } ,
    { 0x1307, "ComputerBoards", "ComputerBoards" } ,
    { 0x1308, "Jato", "Jato Technologies Inc." } ,
    { 0x130A, "Mitsubishi", "Mitsubishi Electric Microcomputer" } ,
    { 0x130B, "Colorgraphic", "Colorgraphic Communications Corp" } ,
    { 0x130F, "", "Advanet Inc." } ,
    { 0x1310, "", "Gespac" } ,
    { 0x1312, "Microscan", "Microscan Systems Inc" } ,
    { 0x1313, "", "Yaskawa Electric Co." } ,
    { 0x1316, "", "Teradyne Inc." } ,
    { 0x1317, "ADMtek", "ADMtek Inc" } ,
    { 0x1318, "Packet Engines", "Packet Engines, Inc." } ,
    { 0x1319, "Forte Media2", "Forte Media" } ,
    { 0x131F, "", "SIIG" } ,
    { 0x1325, "", "austriamicrosystems" } ,
    { 0x1326, "", "Seachange International" } ,
    { 0x1328, "CIFELLI", "CIFELLI SYSTEMS CORPORATION" } ,
    { 0x1331, "RadiSys", "RadiSys Corporation" } ,
    { 0x1332, "CWCEC", "Curtiss-Wright Controls Embedded Computing" } ,
    { 0x1335, "Videomail", "Videomail Inc." } ,
    { 0x133D, "", "Prisa Networks" } ,
    { 0x133F, "", "SCM Microsystems" } ,
    { 0x1342, "", "Promax Systems Inc" } ,
    { 0x1344, "Micron", "Micron Technology, Inc." } ,
    { 0x1347, "Spectracom", "Spectracom Corporation" } ,
    { 0x134A, "DTC", "DTC Technology Corp." } ,
    { 0x134B, "", "ARK Research Corp." } ,
    { 0x134C, "", "Chori Joho System Co. Ltd" } ,
    { 0x134D, "PCTEL", "PCTEL Inc." } ,
    { 0x135A, "constantin", "Brain Boxes Limited" } ,
    { 0x135B, "", "Giganet Inc." } ,
    { 0x135C, "", "Quatech Inc" } ,
    { 0x135D, "ABB Network Partn", "ABB Network Partner AB" } ,
    { 0x135E, "Sealevel", "Sealevel Systems Inc." } ,
    { 0x135F, "", "I-Data International A-S" } ,
    { 0x1360, "Meinberg Funkuhren", "Meinberg Funkuhren GmbH & Co. KG" } ,
    { 0x1361, "", "Soliton Systems K.K." } ,
    { 0x1363, "", "Phoenix Technologies Ltd" } ,
    { 0x1365, "Hypercope", "Hypercope Corp." } ,
    { 0x1366, "Teijin", "Teijin Seiki Co. Ltd." } ,
    { 0x1367, "", "Hitachi Zosen Corporation" } ,
    { 0x1368, "", "Skyware Corporation" } ,
    { 0x1369, "Digigram", "Digigram" } ,
    { 0x136B, "", "Kawasaki Steel Corporation" } ,
    { 0x136C, "", "Adtek System Science Co Ltd" } ,
    { 0x1375, "", "Boeing - Sunnyvale" } ,
    { 0x137A, "MOTU", "Mark Of The Unicorn Inc" } ,
    { 0x137B, "", "PPT Vision" } ,
    { 0x137C, "", "Iwatsu Electric Co Ltd" } ,
    { 0x137D, "", "Dynachip Corporation" } ,
    { 0x137E, "PTSC", "Patriot Scientific Corp." } ,
    { 0x1380, "SANRITZ", "Sanritz Automation Co LTC" } ,
    { 0x1381, "", "Brains Co. Ltd" } ,
    { 0x1382, "Marian", "Marian - Electronic & Software" } ,
    { 0x1384, "", "Stellar Semiconductor Inc" } ,
    { 0x1385, "Netgear", "Netgear" } ,
    { 0x1387, "CWCEL", "Curtiss-Wright Controls Electronic Systems" } ,
    { 0x1388, "", "Hitachi Information Technology Co Ltd" } ,
    { 0x1389, "Applicom", "Applicom International" } ,
    { 0x138A, " ", "Validity Sensors, Inc." } ,
    { 0x138B, "", "Tokimec Inc" } ,
    { 0x138E, "", "Basler GMBH" } ,
    { 0x138F, "", "Patapsco Designs Inc" } ,
    { 0x1390, "CDI", "Concept Development Inc." } ,
    { 0x1393, "", "Moxa Technologies Co Ltd" } ,
    { 0x1394, "Level One", "Level One Communications" } ,
    { 0x1395, "", "Ambicom Inc" } ,
    { 0x1396, "", "Cipher Systems Inc" } ,
    { 0x1397, "Cologne", "Cologne Chip Designs GmbH" } ,
    { 0x1398, "", "Clarion Co. Ltd" } ,
    { 0x139A, "", "Alacritech Inc" } ,
    { 0x139D, "", "Xstreams PLC/ EPL Limited" } ,
    { 0x139E, "", "Echostar Data Networks" } ,
    { 0x13A0, "", "Crystal Group Inc" } ,
    { 0x13A1, "", "Kawasaki Heavy Industries Ltd" } ,
    { 0x13A3, "HI-FN", "HI-FN Inc." } ,
    { 0x13A4, "", "Rascom Inc" } ,
    { 0x13A7, "", "amc330" } ,
    { 0x13A8, "XR", "Exar Corp." } ,
    { 0x13A9, "", "Siemens Healthcare" } ,
    { 0x13AA, "", "Nortel Networks - BWA Division" } ,
    { 0x13AF, "", "T.Sqware" } ,
    { 0x13B1, "", "Tamura Corporation" } ,
    { 0x13B4, "", "Wellbean Co Inc" } ,
    { 0x13B5, "", "ARM Ltd" } ,
    { 0x13B6, "pci\\ven_13b6", "DLoG Gesellschaft f�r elektronische Datentechnik mbH" } ,
    { 0x13B8, "", "Nokia Telecommunications OY" } ,
    { 0x13BD, "SHARP", "Sharp Corporation" } ,
    { 0x13BF, "", "Sharewave Inc" } ,
    { 0x13C0, "Microgate", "Microgate Corp." } ,
    { 0x13C1, "3ware", "LSI" } ,
    { 0x13C2, "", "Technotrend Systemtechnik GMBH" } ,
    { 0x13C3, "", "Janz Computer AG" } ,
    { 0x13C7, "", "Blue Chip Technology Ltd" } ,
    { 0x13CC, "", "Metheus Corporation" } ,
    { 0x13CF, "", "Studio Audio & Video Ltd" } ,
    { 0x13D0, "A", "B2C2 Inc" } ,
    { 0x13D1, "AboCom", "AboCom Systems, Inc" } ,
    { 0x13D4, "", "Graphics Microsystems Inc" } ,
    { 0x13D6, "", "K.I. Technology Co Ltd" } ,
    { 0x13D7, "tos6205", "Toshiba Engineering Corporation" } ,
    { 0x13D8, "", "Phobos Corporation" } ,
    { 0x13D9, "", "Apex Inc" } ,
    { 0x13DC, "", "Netboost Corporation" } ,
    { 0x13DE, "", "ABB Robotics Products AB" } ,
    { 0x13DF, "E-Tech", "E-Tech Inc." } ,
    { 0x13E0, "GVC", "GVC Corporation" } ,
    { 0x13E3, "", "Nest Inc" } ,
    { 0x13E4, "", "Calculex Inc" } ,
    { 0x13E5, "", "Telesoft Design Ltd" } ,
    { 0x13E9, "", "Intraserver Technology Inc" } ,
    { 0x13EA, "", "Dallas Semiconductor" } ,
    { 0x13F0, "harrys", "IC Plus Corporation" } ,
    { 0x13F1, "", "OCE - Industries S.A." } ,
    { 0x13F4, "", "Troika Networks Inc" } ,
    { 0x13F6, "C-Media", "C-Media Electronics Inc." } ,
    { 0x13F9, "", "NTT Advanced Technology Corp." } ,
    { 0x13FA, "Pentland", "Pentland Systems Ltd." } ,
    { 0x13FB, "", "Aydin Corp" } ,
    { 0x13FD, "", "Micro Science Inc" } ,
    { 0x13FE, "Advantech", "Advantech Co., Ltd." } ,
    { 0x13FF, "", "Silicon Spice Inc." } ,
    { 0x1400, "ArtX", "ArtX Inc" } ,
    { 0x1402, "Meilhaus Electronic", "Meilhaus Electronic GmbH Germany" } ,
    { 0x1404, "", "Fundamental Software Inc" } ,
    { 0x1406, "Oc", "Oce Print Logics Technologies S.A." } ,
    { 0x1407, "LAVA", "Lava Computer MFG Inc." } ,
    { 0x1408, "", "Aloka Co. Ltd" } ,
    { 0x1409, "SUNIX", "SUNIX Co., Ltd." } ,
    { 0x140A, "", "DSP Research Inc" } ,
    { 0x140B, "", "Ramix Inc" } ,
    { 0x140D, "", "Matsushita Electric Works Ltd" } ,
    { 0x140F, "", "Salient Systems Corp" } ,
    { 0x1412, "IC Ensemble", "IC Ensemble, Inc." } ,
    { 0x1413, "", "Addonics" } ,
    { 0x1415, "Oxford", "Oxford Semiconductor Ltd - now part of PLX Technology " } ,
    { 0x1418, "KES Inc.", "Kyushu Electronics Systems Inc" } ,
    { 0x1419, "", "Excel Switching Corp" } ,
    { 0x141B, "Gerd Mokwinski", "Zoom Telephonics Inc" } ,
    { 0x141E, "", "Fanuc Co. Ltd" } ,
    { 0x141F, "", "Visiontech Ltd" } ,
    { 0x1420, "", "Psion Dacom PLC" } ,
    { 0x1425, "", "Chelsio Communications" } ,
    { 0x1428, "", "Edec Co Ltd" } ,
    { 0x1429, "", "Unex Technology Corp." } ,
    { 0x142A, "", "Kingmax Technology Inc" } ,
    { 0x142B, "", "Radiolan" } ,
    { 0x142C, "", "Minton Optic Industry Co Ltd" } ,
    { 0x142D, "", "Pixstream Inc" } ,
    { 0x1430, "", "ITT Aerospace/Communications Division" } ,
    { 0x1433, "", "Eltec Elektronik AG" } ,
    { 0x1435, "RTD", "RTD Embedded Technologies, Inc." } ,
    { 0x1436, "", "CIS Technology Inc" } ,
    { 0x1437, "", "Nissin Inc Co" } ,
    { 0x1438, "", "Atmel-Dream" } ,
    { 0x143F, "", "Lightwell Co Ltd - Zax Division" } ,
    { 0x1441, "", "Agie SA." } ,
    { 0x1443, "Unibrain", "Unibrain S.A." } ,
    { 0x1445, "", "Logical Co Ltd" } ,
    { 0x1446, "", "Graphin Co., LTD" } ,
    { 0x1447, "", "Aim GMBH" } ,
    { 0x1448, "Alesis", "Alesis Studio" } ,
    { 0x144A, "ADLINK", "ADLINK Technology Inc" } ,
    { 0x144B, "Loronix", "Loronix Information Systems, Inc." } ,
    { 0x144D, "", "sanyo" } ,
    { 0x1450, "", "Octave Communications Ind." } ,
    { 0x1451, "", "SP3D Chip Design GMBH" } ,
    { 0x1453, "", "Mycom Inc" } ,
    { 0x1458, "Giga-Byte", "Giga-Byte Technologies" } ,
    { 0x145C, "", "Cryptek" } ,
    { 0x145F, "Baldor", "Baldor Electric Company" } ,
    { 0x1460, "", "Dynarc Inc" } ,
    { 0x1462, "MSI", "Micro-Star International Co Ltd" } ,
    { 0x1463, "", "Fast Corporation" } ,
    { 0x1464, "ICS", "Interactive Circuits & Systems Ltd" } ,
    { 0x1468, "", "Ambit Microsystems Corp." } ,
    { 0x1469, "", "Cleveland Motion Controls" } ,
    { 0x146C, "", "Ruby Tech Corp." } ,
    { 0x146D, "SDF", "Tachyon Inc." } ,
    { 0x146E, "", "WMS Gaming" } ,
    { 0x1471, "ITex", "Integrated Telecom Express Inc" } ,
    { 0x1473, "", "Zapex Technologies Inc" } ,
    { 0x1474, "", "Doug Carson & Associates" } ,
    { 0x1477, "", "Net Insight" } ,
    { 0x1478, "", "Diatrend Corporation" } ,
    { 0x147B, "", "Abit Computer Corp." } ,
    { 0x147F, "", "Nihon Unisys Ltd." } ,
    { 0x1482, "", "Isytec - Integrierte Systemtechnik Gmbh" } ,
    { 0x1483, "", "Labway Coporation" } ,
    { 0x1485, "Edward", "Erma - Electronic GMBH" } ,
    { 0x1489, "", "KYE Systems Corporation" } ,
    { 0x148A, "", "Opto 22" } ,
    { 0x148B, "", "Innomedialogic Inc." } ,
    { 0x148C, "CP (PowerColor)", "C.P. Technology Co. Ltd" } ,
    { 0x148D, "Digicom", "Digicom Systems Inc." } ,
    { 0x148E, "", "OSI Plus Corporation" } ,
    { 0x148F, "Giggs", "Plant Equipment Inc." } ,
    { 0x1490, "", "TC Labs Pty Ltd." } ,
    { 0x1491, "Futronic ", "Futronic " } ,
    { 0x1493, "", "Maker Communications" } ,
    { 0x1495, "", "Tokai Communications Industry Co. Ltd" } ,
    { 0x1496, "", "Joytech Computer Co. Ltd." } ,
    { 0x1497, "SMA", "SMA Technologie AG" } ,
    { 0x1498, "Tews", "Tews Technologies" } ,
    { 0x1499, "", "Micro-Technology Co Ltd" } ,
    { 0x149A, "Andor Tech", "Andor Technology Ltd" } ,
    { 0x149B, "", "Seiko Instruments Inc" } ,
    { 0x149E, "", "Mapletree Networks Inc." } ,
    { 0x149F, "", "Lectron Co Ltd" } ,
    { 0x14A0, "Vetronix Corporation Engenharia Ltda", "Softing AG" } ,
    { 0x14A2, "", "Millennium Engineering Inc" } ,
    { 0x14A4, "sebastien", "GVC/BCM Advanced Research" } ,
    { 0x14A9, "Hivertec Inc.", "Hivertec Inc." } ,
    { 0x14AB, "", "Mentor Graphics Corp." } ,
    { 0x14B1, "", "Nextcom K.K." } ,
    { 0x14B3, "Xpeed", "Xpeed Inc." } ,
    { 0x14B4, "", "Philips Business Electronics B.V." } ,
    { 0x14B5, "Creamware", "Creamware GmbH" } ,
    { 0x14B6, "", "Quantum Data Corp." } ,
    { 0x14B7, "Proxim", "Proxim Inc." } ,
    { 0x14B9, "Aironet", "Aironet Wireless Communication" } ,
    { 0x14BA, "", "Internix Inc." } ,
    { 0x14BB, "", "Semtech Corporation" } ,
    { 0x14BE, "", "L3 Communications" } ,
    { 0x14C0, "Compal", "Compal Electronics, Inc." } ,
    { 0x14C1, "", "Myricom Inc." } ,
    { 0x14C2, "", "DTK Computer" } ,
    { 0x14C4, "", "Iwasaki Information Systems Co Ltd" } ,
    { 0x14C5, "ABB", "ABB AB (Sweden)" } ,
    { 0x14C6, "", "Data Race Inc" } ,
    { 0x14C7, "Modtech", "Modular Technology Ltd." } ,
    { 0x14C8, "Turbocomm", "Turbocomm Tech Inc" } ,
    { 0x14C9, "", "Odin Telesystems Inc" } ,
    { 0x14CB, "", "Billionton Systems Inc./Cadmus Micro Inc" } ,
    { 0x14CD, "USI", "Universal Scientific Ind." } ,
    { 0x14CF, "Tekmicro", "TEK Microsystems Inc." } ,
    { 0x14D4, "PANACOM", "Panacom Technology Corporation" } ,
    { 0x14D5, "", "Nitsuko Corporation" } ,
    { 0x14D6, "", "Accusys Inc" } ,
    { 0x14D7, "", "Hirakawa Hewtech Corp" } ,
    { 0x14D8, "", "Hopf Elektronik GMBH" } ,
    { 0x14D9, "", "Alpha Processor Inc" } ,
    { 0x14DB, "Avlab", "Avlab Technology Inc." } ,
    { 0x14DC, "Amplicon", "Amplicon Liveline Limited" } ,
    { 0x14DD, "", "Imodl Inc." } ,
    { 0x14DE, "", "Applied Integration Corporation" } ,
    { 0x14E3, "", "Amtelco" } ,
    { 0x14E4, "samuel", "Broadcom" } ,
    { 0x14EA, "Planex", "Planex Communications, Inc." } ,
    { 0x14EB, "", "Seiko Epson Corporation" } ,
    { 0x14EC, "", "Acqiris" } ,
    { 0x14ED, "", "Datakinetics Ltd" } ,
    { 0x14EF, "", "Carry Computer Eng. Co Ltd" } ,
    { 0x14F1, "Conexant", "Conexant" } ,
    { 0x14F2, "Mobility", "Mobility Electronics, Inc." } ,
    { 0x14F4, "", "Tokyo Electronic Industry Co. Ltd." } ,
    { 0x14F5, "dule", "Sopac Ltd" } ,
    { 0x14F6, "", "Coyote Technologies LLC" } ,
    { 0x14F7, "", "Wolf Technology Inc" } ,
    { 0x14F8, "", "Audiocodes Inc" } ,
    { 0x14F9, "", "AG Communications" } ,
    { 0x14FB, "", "Transas Marine (UK) Ltd" } ,
    { 0x14FC, "", "Quadrics Ltd" } ,
    { 0x14FD, "Silex", "Silex Technology Inc." } ,
    { 0x14FE, "", "Archtek Telecom Corp." } ,
    { 0x14FF, "", "Twinhead International Corp." } ,
    { 0x1501, "", "Banksoft Canada Ltd" } ,
    { 0x1502, "", "Mitsubishi Electric Logistics Support Co" } ,
    { 0x1503, "", "Kawasaki LSI USA Inc" } ,
    { 0x1504, "", "Kaiser Electronics" } ,
    { 0x1506, "", "Chameleon Systems Inc" } ,
    { 0x1507, "Htec", "Htec Ltd." } ,
    { 0x1509, "FIC", "First International Computer Inc" } ,
    { 0x150B, "", "Yamashita Systems Corp" } ,
    { 0x150C, "", "Kyopal Co Ltd" } ,
    { 0x150D, "", "Warpspped Inc" } ,
    { 0x150E, "", "C-Port Corporation" } ,
    { 0x150F, "", "Intec GMBH" } ,
    { 0x1510, "", "Behavior Tech Computer Corp" } ,
    { 0x1511, "", "Centillium Technology Corp" } ,
    { 0x1512, "Rosen", "Rosun Technologies Inc" } ,
    { 0x1513, "", "Raychem" } ,
    { 0x1514, "", "TFL LAN Inc" } ,
    { 0x1515, "", "ICS Advent" } ,
    { 0x1516, "", "Myson Technology Inc" } ,
    { 0x1517, "", "Echotek Corporation" } ,
    { 0x1518, "", "Kontron Modular Computers GmbH (PEP Modular Computers GMBH)" } ,
    { 0x1519, "", "Telefon Aktiebolaget LM Ericsson" } ,
    { 0x151A, "Globetek", "Globetek Inc." } ,
    { 0x151B, "wesam", "Combox Ltd" } ,
    { 0x151C, "", "Digital Audio Labs Inc" } ,
    { 0x151D, "", "Fujitsu Computer Products Of America" } ,
    { 0x151E, "", "Matrix Corp." } ,
    { 0x151F, "", "Topic Semiconductor Corp" } ,
    { 0x1520, "", "Chaplet System Inc" } ,
    { 0x1521, "", "Bell Corporation" } ,
    { 0x1522, "Mainpine", "Mainpine Limited" } ,
    { 0x1523, "", "Music Semiconductors" } ,
    { 0x1524, "mayer ", "ENE Technology Inc" } ,
    { 0x1525, "", "Impact Technologies" } ,
    { 0x1526, "", "ISS Inc" } ,
    { 0x1527, "", "Solectron" } ,
    { 0x1528, "", "Acksys" } ,
    { 0x1529, "", "American Microsystems Inc" } ,
    { 0x152A, "", "Quickturn Design Systems" } ,
    { 0x152B, "", "Flytech Technology Co Ltd" } ,
    { 0x152C, "", "Macraigor Systems LLC" } ,
    { 0x152D, "", "Quanta Computer Inc" } ,
    { 0x152E, "", "Melec Inc" } ,
    { 0x152F, "", "Philips - Crypto" } ,
    { 0x1532, "Echelon Corp", "Echelon Corporation" } ,
    { 0x1533, "", "Baltimore" } ,
    { 0x1534, "", "Road Corporation" } ,
    { 0x1535, "", "Evergreen Technologies Inc" } ,
    { 0x1537, "", "Datalex Communcations" } ,
    { 0x1538, "Aralion", "Aralion Inc." } ,
    { 0x1539, "", "Atelier Informatiques et Electronique Et" } ,
    { 0x153A, "", "ONO Sokki" } ,
    { 0x153B, "cami", "Terratec Electronic GMBH" } ,
    { 0x153C, "", "Antal Electronic" } ,
    { 0x153D, "", "Filanet Corporation" } ,
    { 0x153E, "Techwell", "Techwell Inc" } ,
    { 0x153F, "MIPS", "MIPS Technologies, Inc" } ,
    { 0x1540, "", "Provideo Multimedia Co Ltd" } ,
    { 0x1541, "", "Telocity Inc." } ,
    { 0x1542, "", "Vivid Technology Inc" } ,
    { 0x1543, "", "Silicon Laboratories" } ,
    { 0x1544, "DCM", "DCM Technologies Ltd." } ,
    { 0x1545, "Visiontek", "VisionTek" } ,
    { 0x1546, "", "IOI Technology Corp." } ,
    { 0x1547, "", "Mitutoyo Corporation" } ,
    { 0x1548, "", "Jet Propulsion Laboratory" } ,
    { 0x1549, "ISS", "Interconnect Systems Solutions" } ,
    { 0x154A, "", "Max Technologies Inc." } ,
    { 0x154B, "", "Computex Co Ltd" } ,
    { 0x154C, "", "Visual Technology Inc." } ,
    { 0x154D, "", "PAN International Industrial Corp" } ,
    { 0x154E, "", "Servotest Ltd" } ,
    { 0x154F, "", "Stratabeam Technology" } ,
    { 0x1550, "", "Open Network Co Ltd" } ,
    { 0x1551, "", "Smart Electronic Development GMBH" } ,
    { 0x1553, "", "Chicony Electronics Co Ltd" } ,
    { 0x1554, "PMC", "Prolink Microsystems Corp." } ,
    { 0x1555, "Gesytec", "Gesytec GmbH" } ,
    { 0x1556, "", "PLDA" } ,
    { 0x1557, "", "Mediastar Co. Ltd" } ,
    { 0x1558, "dwi", "Clevo/Kapok Computer" } ,
    { 0x1559, "", "SI Logic Ltd" } ,
    { 0x155A, "", "Innomedia Inc" } ,
    { 0x155B, "", "Protac International Corp" } ,
    { 0x155C, "", "s" } ,
    { 0x155D, "", "MAC System Co Ltd" } ,
    { 0x155E, "KR", "KUKA Roboter GmbH" } ,
    { 0x155F, "", "Perle Systems Limited" } ,
    { 0x1560, "", "Terayon Communications Systems" } ,
    { 0x1561, "", "Viewgraphics Inc" } ,
    { 0x1562, "", "Symbol Technologies, Inc." } ,
    { 0x1563, "", "A-Trend Technology Co Ltd" } ,
    { 0x1564, "", "Yamakatsu Electronics Industry Co Ltd" } ,
    { 0x1565, "xyz", "Biostar Microtech Intl Corp" } ,
    { 0x1566, "", "Ardent Technologies Inc" } ,
    { 0x1567, "", "Jungsoft" } ,
    { 0x1568, "", "DDK Electronics Inc" } ,
    { 0x1569, "AleksSPb", "Palit Microsystems Inc" } ,
    { 0x156A, "Avtec", "Avtec Systems Inc" } ,
    { 0x156B, "", "S2io Inc" } ,
    { 0x156C, "", "Vidac Electronics GMBH" } ,
    { 0x156D, "", "Alpha-Top Corp" } ,
    { 0x156E, "", "Alfa Inc." } ,
    { 0x156F, "", "M-Systems Flash Disk Pioneers Ltd" } ,
    { 0x1570, "", "Lecroy Corporation" } ,
    { 0x1571, "", "Contemporary Controls" } ,
    { 0x1572, "", "Otis Elevator Company" } ,
    { 0x1573, "", "Lattice - Vantis" } ,
    { 0x1574, "", "Fairchild Semiconductor" } ,
    { 0x1575, "", "Voltaire Advanced Data Security Ltd" } ,
    { 0x1576, "ViewCast", "Viewcast Com" } ,
    { 0x1578, "", "Hitt" } ,
    { 0x1579, "", "Dual Technology Corporation" } ,
    { 0x157A, "", "Japan Elecronics Ind. Inc" } ,
    { 0x157B, "", "Star Multimedia Corp." } ,
    { 0x157C, "Eurosoft", "Eurosoft (UK)" } ,
    { 0x157D, "", "Gemflex Networks" } ,
    { 0x157E, "", "Transition Networks" } ,
    { 0x157F, "", "PX Instruments Technology Ltd" } ,
    { 0x1580, "", "Primex Aerospace Co." } ,
    { 0x1581, "", "SEH Computertechnik GMBH" } ,
    { 0x1582, "", "Cytec Corporation" } ,
    { 0x1583, "", "Inet Technologies Inc" } ,
    { 0x1584, "Vetronix", "Vetronix Corporation Engenharia Ltda" } ,
    { 0x1585, "", "Marconi Commerce Systems SRL" } ,
    { 0x1586, "", "Lancast Inc" } ,
    { 0x1587, "", "Konica Corporation" } ,
    { 0x1588, "Solidum", "Solidum Systems Corp" } ,
    { 0x1589, "", "Atlantek Microsystems Pty Ltd" } ,
    { 0x158A, "", "Digalog Systems Inc" } ,
    { 0x158B, "Standard USB Host Controller", "Allied Data Technologies" } ,
    { 0x158C, "", "Hitachi Semiconductor & Devices Sales Co" } ,
    { 0x158D, "", "Point Multimedia Systems" } ,
    { 0x158E, "", "Lara Technology Inc" } ,
    { 0x158F, "", "Ditect Coop" } ,
    { 0x1590, "", "3pardata Inc." } ,
    { 0x1591, "", "ARN" } ,
    { 0x1592, "Syba", "Syba Tech Ltd." } ,
    { 0x1593, "", "Bops Inc" } ,
    { 0x1594, "", "Netgame Ltd" } ,
    { 0x1595, "", "Diva Systems Corp." } ,
    { 0x1596, "", "Folsom Research Inc" } ,
    { 0x1597, "", "Memec Design Services" } ,
    { 0x1598, "", "Granite Microsystems" } ,
    { 0x1599, "", "Delta Electronics Inc" } ,
    { 0x159A, "", "General Instrument" } ,
    { 0x159B, "", "Faraday Technology Corp" } ,
    { 0x159C, "", "Stratus Computer Systems" } ,
    { 0x159D, "", "Ningbo Harrison Electronics Co Ltd" } ,
    { 0x159E, "", "A-Max Technology Co Ltd" } ,
    { 0x159F, "", "Galea Network Security" } ,
    { 0x15A0, "", "Compumaster SRL" } ,
    { 0x15A1, "", "Geocast Network Systems Inc" } ,
    { 0x15A2, "", "Catalyst Enterprises Inc" } ,
    { 0x15A3, "", "Italtel" } ,
    { 0x15A4, "Rafa", "X-Net OY" } ,
    { 0x15A5, "", "Toyota MACS Inc" } ,
    { 0x15A6, "", "Sunlight Ultrasound Technologies Ltd" } ,
    { 0x15A7, "", "SSE Telecom Inc" } ,
    { 0x15A8, "", "Shanghai Communications Technologies Cen" } ,
    { 0x15AA, "", "Moreton Bay" } ,
    { 0x15AB, "", "Bluesteel Networks Inc" } ,
    { 0x15AC, "", "North Atlantic Instruments" } ,
    { 0x15AD, "VMware", "VMware Inc." } ,
    { 0x15AE, "", "Amersham Pharmacia Biotech" } ,
    { 0x15B0, "", "Zoltrix International Limited" } ,
    { 0x15B1, "", "Source Technology Inc" } ,
    { 0x15B2, "", "Mosaid Technologies Inc." } ,
    { 0x15B3, "", "Mellanox Technology" } ,
    { 0x15B4, "", "CCI/Triad" } ,
    { 0x15B5, "", "Cimetrics Inc" } ,
    { 0x15B6, "", "Texas Memory Systems Inc" } ,
    { 0x15B7, "", "Sandisk Corp." } ,
    { 0x15B8, "", "Addi-Data GMBH" } ,
    { 0x15B9, "", "Maestro Digital Communications" } ,
    { 0x15BA, "", "Impacct Technology Corp" } ,
    { 0x15BB, "", "Portwell Inc" } ,
    { 0x15BC, "Agilent", "Agilent Technologies" } ,
    { 0x15BD, "", "DFI Inc." } ,
    { 0x15BE, "", "Sola Electronics" } ,
    { 0x15BF, "", "High Tech Computer Corp (HTC)" } ,
    { 0x15C0, "BVM", "BVM Limited" } ,
    { 0x15C1, "", "Quantel" } ,
    { 0x15C2, "", "Newer Technology Inc" } ,
    { 0x15C3, "", "Taiwan Mycomp Co Ltd" } ,
    { 0x15C4, "", "EVSX Inc" } ,
    { 0x15C5, "", "Procomp Informatics Ltd" } ,
    { 0x15C6, "", "Technical University Of Budapest" } ,
    { 0x15C7, "", "Tateyama System Laboratory Co Ltd" } ,
    { 0x15C8, "", "Penta Media Co. Ltd" } ,
    { 0x15C9, "", "Serome Technology Inc" } ,
    { 0x15CA, "", "Bitboys OY" } ,
    { 0x15CB, "", "AG Electronics Ltd" } ,
    { 0x15CC, "", "Hotrail Inc." } ,
    { 0x15CD, "", "Dreamtech Co Ltd" } ,
    { 0x15CE, "", "Genrad Inc." } ,
    { 0x15CF, "", "Hilscher GMBH" } ,
    { 0x15D1, "Infineon", "Infineon Technologies AG" } ,
    { 0x15D2, "", "FIC (First International Computer Inc)" } ,
    { 0x15D3, "", "NDS Technologies Israel Ltd" } ,
    { 0x15D4, "", "Iwill Corporation" } ,
    { 0x15D5, "", "Tatung Co." } ,
    { 0x15D6, "", "Entridia Corporation" } ,
    { 0x15D7, "", "Rockwell-Collins Inc" } ,
    { 0x15D8, "", "Cybernetics Technology Co Ltd" } ,
    { 0x15D9, "uttank", "Super Micro Computer Inc" } ,
    { 0x15DA, "", "Cyberfirm Inc." } ,
    { 0x15DB, "", "Applied Computing Systems Inc." } ,
    { 0x15DC, "Litronic", "Litronic Inc." } ,
    { 0x15DD, " ", "Sigmatel Inc." } ,
    { 0x15DE, "", "Malleable Technologies Inc" } ,
    { 0x15E0, "", "Cacheflow Inc" } ,
    { 0x15E1, "VTG", "Voice Technologies Group" } ,
    { 0x15E2, "", "Quicknet Technologies Inc" } ,
    { 0x15E3, "", "Networth Technologies Inc" } ,
    { 0x15E4, "", "VSN Systemen BV" } ,
    { 0x15E5, "", "Valley Technologies Inc" } ,
    { 0x15E6, "", "Agere Inc." } ,
    { 0x15E7, "", "GET Engineering Corp." } ,
    { 0x15E8, "akmal", "National Datacomm Corp." } ,
    { 0x15E9, "", "Pacific Digital Corp." } ,
    { 0x15EA, "", "Tokyo Denshi Sekei K.K." } ,
    { 0x15EB, "", "Drsearch GMBH" } ,
    { 0x15EC, "", "Beckhoff Automation GmbH" } ,
    { 0x15ED, "", "Macrolink Inc" } ,
    { 0x15EE, "", "IN Win Development Inc." } ,
    { 0x15EF, "", "Intelligent Paradigm Inc" } ,
    { 0x15F0, "", "B-Tree Systems Inc" } ,
    { 0x15F1, "", "Times N Systems Inc" } ,
    { 0x15F2, "SPOT Imaging", "SPOT Imaging Solutions a division of Diagnostic Instruments, Inc" } ,
    { 0x15F3, "", "Digitmedia Corp." } ,
    { 0x15F4, "", "Valuesoft" } ,
    { 0x15F5, "", "Power Micro Research" } ,
    { 0x15F6, "", "Extreme Packet Device Inc" } ,
    { 0x15F7, "", "Banctec" } ,
    { 0x15F8, "", "Koga Electronics Co" } ,
    { 0x15F9, "", "Zenith Electronics Co" } ,
    { 0x15FA, "Axzam", "Axzam Corporation" } ,
    { 0x15FB, "", "Zilog Inc." } ,
    { 0x15FC, "", "Techsan Electronics Co Ltd" } ,
    { 0x15FD, "", "N-Cubed.Net" } ,
    { 0x15FE, "", "Kinpo Electronics Inc" } ,
    { 0x15FF, "", "Fastpoint Technologies Inc." } ,
    { 0x1600, "", "Northrop Grumman - Canada Ltd" } ,
    { 0x1601, "", "Tenta Technology" } ,
    { 0x1602, "", "Prosys-TEC Inc." } ,
    { 0x1603, "", "Nokia Wireless Business Communications" } ,
    { 0x1604, "", "Central System Research Co Ltd" } ,
    { 0x1605, "", "Pairgain Technologies" } ,
    { 0x1606, "", "Europop AG" } ,
    { 0x1607, "", "Lava Semiconductor Manufacturing Inc." } ,
    { 0x1608, "nuri", "Automated Wagering International" } ,
    { 0x1609, "", "Sciemetric Instruments Inc" } ,
    { 0x160A, "", "Kollmorgen Servotronix" } ,
    { 0x160B, "", "Onkyo Corp." } ,
    { 0x160C, "", "Oregon Micro Systems Inc." } ,
    { 0x160D, "", "Aaeon Electronics Inc" } ,
    { 0x160E, "", "CML Emergency Services" } ,
    { 0x160F, "", "ITEC Co Ltd" } ,
    { 0x1610, "", "Tottori Sanyo Electric Co Ltd" } ,
    { 0x1611, "", "Bel Fuse Inc." } ,
    { 0x1612, "", "Telesynergy Research Inc." } ,
    { 0x1613, "", "System Craft Inc." } ,
    { 0x1614, "", "Jace Tech Inc." } ,
    { 0x1615, "", "Equus Computer Systems Inc" } ,
    { 0x1616, "", "Iotech Inc." } ,
    { 0x1617, "", "Rapidstream Inc" } ,
    { 0x1618, "", "Esec SA" } ,
    { 0x1619, "FarSite", "FarSite Communications Limited" } ,
    { 0x161B, "", "Mobilian Israel Ltd" } ,
    { 0x161C, "", "Berkshire Products" } ,
    { 0x161D, "", "Gatec" } ,
    { 0x161E, "", "Kyoei Sangyo Co Ltd" } ,
    { 0x161F, "Arima", "Arima Computer Corporation" } ,
    { 0x1620, "", "Sigmacom Co Ltd" } ,
    { 0x1621, "", "Lynx Studio Technology Inc" } ,
    { 0x1622, "NHC", "Nokia Home Communications" } ,
    { 0x1623, "", "KRF Tech Ltd" } ,
    { 0x1624, "", "CE Infosys GMBH" } ,
    { 0x1625, "", "Warp Nine Engineering" } ,
    { 0x1626, "", "TDK Semiconductor Corp." } ,
    { 0x1627, "", "BCom Electronics Inc" } ,
    { 0x1629, "", "Kongsberg Spacetec a.s." } ,
    { 0x162A, "", "Sejin Computerland Co Ltd" } ,
    { 0x162B, "", "Shanghai Bell Company Limited" } ,
    { 0x162C, "", "C&H Technologies Inc" } ,
    { 0x162D, "", "Reprosoft Co Ltd" } ,
    { 0x162E, "", "Margi Systems Inc" } ,
    { 0x162F, "", "Rohde & Schwarz GMBH & Co KG" } ,
    { 0x1630, "", "Sky Computers Inc" } ,
    { 0x1631, "", "NEC Computer International" } ,
    { 0x1632, "", "Verisys Inc" } ,
    { 0x1633, "", "Adac Corporation" } ,
    { 0x1634, "", "Visionglobal Network Corp." } ,
    { 0x1635, "", "Decros / S.ICZ a.s." } ,
    { 0x1636, "", "Jean Company Ltd" } ,
    { 0x1637, "", "NSI" } ,
    { 0x1638, " Eumitcom Technology Inc", "Eumitcom Technology Inc" } ,
    { 0x163A, "", "Air Prime Inc" } ,
    { 0x163B, "", "Glotrex Co Ltd" } ,
    { 0x163C, "", "intel" } ,
    { 0x163D, "", "Heidelberg Digital LLC" } ,
    { 0x163E, "&#1074;&#1083;&#1072;&#1076;&#1080;&#1084;&#1080;&", "3dpower" } ,
    { 0x163F, "", "Renishaw PLC" } ,
    { 0x1640, "", "Intelliworxx Inc" } ,
    { 0x1641, "", "MKNet Corporation" } ,
    { 0x1642, "", "Bitland" } ,
    { 0x1643, "", "Hajime Industries Ltd" } ,
    { 0x1644, "", "Western Avionics Ltd" } ,
    { 0x1645, "", "Quick-Serv. Computer Co. Ltd" } ,
    { 0x1646, "", "Nippon Systemware Co Ltd" } ,
    { 0x1647, "", "Hertz Systemtechnik GMBH" } ,
    { 0x1648, "", "MeltDown Systems LLC" } ,
    { 0x1649, "", "Jupiter Systems" } ,
    { 0x164A, "", "Aiwa Co. Ltd" } ,
    { 0x164C, "", "Department Of Defense" } ,
    { 0x164D, "", "Ishoni Networks" } ,
    { 0x164E, "", "Micrel Inc." } ,
    { 0x164F, "DataVoice", "Datavoice (Pty) Ltd." } ,
    { 0x1650, "", "Admore Technology Inc." } ,
    { 0x1651, "", "Chaparral Network Storage" } ,
    { 0x1652, "", "Spectrum Digital Inc." } ,
    { 0x1653, "Naturetech", "Nature Worldwide Technology Corp" } ,
    { 0x1654, "", "Sonicwall Inc" } ,
    { 0x1655, "", "Dazzle Multimedia Inc." } ,
    { 0x1656, "", "Insyde Software Corp" } ,
    { 0x1657, "", "Brocade Communications Systems" } ,
    { 0x1658, "Med Associates, Inc.", "Med Associates Inc." } ,
    { 0x1659, "", "Shiba Denshi Systems Inc." } ,
    { 0x165A, "", "Epix Inc." } ,
    { 0x165B, "", "Real-Time Digital Inc." } ,
    { 0x165C, "", "Kondo Kagaku" } ,
    { 0x165D, "salva", "Hsing Tech. Enterprise Co. Ltd." } ,
    { 0x165E, "", "Hyunju Computer Co. Ltd." } ,
    { 0x165F, "Comart", "Comartsystem Korea" } ,
    { 0x1660, "NETSEC", "Network Security Technologies Inc. (NetSec)" } ,
    { 0x1661, "", "Worldspace Corp." } ,
    { 0x1662, "", "Int Labs" } ,
    { 0x1663, "", "Elmec Inc. Ltd." } ,
    { 0x1664, "", "Fastfame Technology Co. Ltd." } ,
    { 0x1665, "", "Edax Inc." } ,
    { 0x1666, "", "Norpak Corporation" } ,
    { 0x1667, "", "CoSystems Inc." } ,
    { 0x1668, "Actiontec", "Actiontec Electronics Inc." } ,
    { 0x166A, "", "Komatsu Ltd." } ,
    { 0x166B, "", "Supernet Inc." } ,
    { 0x166C, "", "Shade Ltd." } ,
    { 0x166D, "", "Sibyte Inc." } ,
    { 0x166E, "", "Schneider Automation Inc." } ,
    { 0x166F, "", "Televox Software Inc." } ,
    { 0x1670, "", "Rearden Steel" } ,
    { 0x1671, "", "Atan Technology Inc." } ,
    { 0x1672, "", "Unitec Co. Ltd." } ,
    { 0x1673, "", "pctel" } ,
    { 0x1675, "", "Square Wave Technology" } ,
    { 0x1676, "Gateway", "Emachines Inc." } ,
    { 0x1677, "", "Bernecker + Rainer" } ,
    { 0x1678, "", "INH Semiconductor" } ,
    { 0x1679, "", "Tokyo Electron Device Ltd." } ,
    { 0x167F, "iba", "iba AG" } ,
    { 0x1680, "Dunti", "Dunti Corp." } ,
    { 0x1681, "Hercules", "Hercules" } ,
    { 0x1682, "PINE", "PINE Technology, Ltd." } ,
    { 0x1688, "CastleNet", "CastleNet Technology Inc." } ,
    { 0x168A, "USA", "Utimaco Safeware AG" } ,
    { 0x168B, "", "Circut Assembly Corp." } ,
    { 0x168C, "Atherosef", "Atheros Communications Inc." } ,
    { 0x168D, "NMI", "NMI Electronics Ltd." } ,
    { 0x168E, "Hyundai MultiCAV", "Hyundai MultiCAV Computer Co. Ltd." } ,
    { 0x168F, "qsb", "KDS Innotech Corp." } ,
    { 0x1690, "NetContinuum", "NetContinuum, Inc." } ,
    { 0x1693, "FERMA", "FERMA" } ,
    { 0x1695, "EPoX", "EPoX Computer Co., Ltd." } ,
    { 0x16AE, "SFNT", "SafeNet Inc." } ,
    { 0x16B3, "", "CNF Mobile Solutions" } ,
    { 0x16B8, "Sonnet Technologies", "Sonnet Technologies, Inc." } ,
    { 0x16CA, "Cenatek", "Cenatek Inc." } ,
    { 0x16CB, "Minolta", "Minolta Co. Ltd." } ,
    { 0x16CC, "Inari", "Inari Inc." } ,
    { 0x16D0, "", "Systemax" } ,
    { 0x16E0, "3MTS", "Third Millenium Test Solutions, Inc." } ,
    { 0x16E5, "", "Intellon Corporation" } ,
    { 0x16EC, "USR", "U.S. Robotics" } ,
    { 0x16F0, "", "LaserLinc Inc." } ,
    { 0x16F1, "Adicti", "Adicti Corp." } ,
    { 0x16F3, "Jetway", "Jetway Information Co., Ltd" } ,
    { 0x16F6, "VideoTele.com", "VideoTele.com Inc." } ,
    { 0x1700, "Antara", "Antara LLC" } ,
    { 0x1701, "", "Interactive Computer Products Inc." } ,
    { 0x1702, "IMC", "Internet Machines Corp." } ,
    { 0x1703, "Desana", "Desana Systems" } ,
    { 0x1704, "Clearwater", "Clearwater Networks" } ,
    { 0x1705, "Digital First", "Digital First" } ,
    { 0x1706, "PBC", "Pacific Broadband Communications" } ,
    { 0x1707, "Cogency", "Cogency Semiconductor Inc." } ,
    { 0x1708, "Harris", "Harris Corp." } ,
    { 0x1709, "Zarlink", "Zarlink Semiconductor" } ,
    { 0x170A, "Alpine", "Alpine Electronics Inc." } ,
    { 0x170B, "NetOctave", "NetOctave Inc." } ,
    { 0x170C, "YottaYotta", "YottaYotta Inc." } ,
    { 0x170D, "SMI", "SensoMotoric Instruments GmbH" } ,
    { 0x170E, "San Valley", "San Valley Systems, Inc." } ,
    { 0x170F, "Cyberdyne", "Cyberdyne Inc." } ,
    { 0x1710, "Pelago", "Pelago Networks" } ,
    { 0x1711, "NetScreen", "MyName Technologies, Inc." } ,
    { 0x1712, "NICE", "NICE Systems Inc." } ,
    { 0x1713, "TOPCON", "TOPCON Corp." } ,
    { 0x1725, "Vitesse", "Vitesse Semiconductor" } ,
    { 0x1734, "Fujitsu-Siemens", "Fujitsu-Siemens Computers GmbH" } ,
    { 0x1737, "LinkSys", "LinkSys" } ,
    { 0x173B, "Altima", "Altima Communications Inc." } ,
    { 0x1743, "Peppercon", "Peppercon AG" } ,
    { 0x174B, "PC Partner (Sapphire)", "PC Partner Limited" } ,
    { 0x1752, "AMW Europe GmbH", "Global Brands Manufacture Ltd." } ,
    { 0x1753, "TeraRecon", "TeraRecon, Inc." } ,
    { 0x1755, "Alchemy", "Alchemy Semiconductor Inc." } ,
    { 0x176A, "GDC", "General Dynamics Canada" } ,
    { 0x1775, " ", "General Electric" } ,
    { 0x1789, "Ennyah", "Ennyah Technologies Corp" } ,
    { 0x1793, "Unitech", "Unitech Electronics Co., Ltd" } ,
    { 0x17A1, "  ", "Tascorp" } ,
    { 0x17A7, "Start Network", "Start Network Technology Co., Ltd." } ,
    { 0x17AA, "lenovo", "Legend Ltd. (Beijing)" } ,
    { 0x17AB, "Philips170C", "Phillips Components" } ,
    { 0x17AF, "Hightech", "Hightech Information Systems, Ltd." } ,
    { 0x17BE, "Philips", "Philips Semiconductors" } ,
    { 0x17C0, "Wistron", "Wistron Corp." } ,
    { 0x17C4, "", "Movita" } ,
    { 0x17CC, "NetChip", "NetChip" } ,
    { 0x17cd, "Cadence", "Cadence Design Systems" } ,
    { 0x17D5, "Neterion", "Neterion Inc." } ,
    { 0x17db, " Cray", "Cray, Inc." } ,
    { 0x17E9, "", "DH electronics GmbH / Sabrent" } ,
    { 0x17EE, "Connect3D", "Connect Components, Ltd." } ,
    { 0x17F3, "RDC", "RDC Semiconductor Co., Ltd." } ,
    { 0x17FE, "INPROCOMM", "INPROCOMM" } ,
    { 0x1813, "Ambient", "Ambient Technologies Inc" } ,
    { 0x1814, "Ralink Technology", "Ralink Technology, Corp." } ,
    { 0x1815, "devolo", "devolo AG" } ,
    { 0x1820, "InfiniCon", "InfiniCon Systems, Inc." } ,
    { 0x1824, "Avocent", "Avocent" } ,
    { 0x1841, "D-link AirPlus G DWL-G510 rev.C", "Panda Platinum" } ,
    { 0x1860, "Primagraphics", "Primagraphics Ltd." } ,
    { 0x186C, "Humusoft", "Humusoft S.R.O" } ,
    { 0x1887, "Elan", "Elan Digital Systems Ltd" } ,
    { 0x1888, "", "Varisys Limited" } ,
    { 0x188D, "Millogic", "Millogic Ltd." } ,
    { 0x1890, "", "Egenera, Inc." } ,
    { 0x18BC, "", "Info-Tek Corp." } ,
    { 0x18C9, "ARVOO", "ARVOO Engineering BV" } ,
    { 0x18CA, "XGI", "XGI Technology Inc" } ,
    { 0x18F1, "Spc", "Spectrum Systementwicklung Microelectronic GmbH" } ,
    { 0x18F4, "Napatech", "Napatech A/S" } ,
    { 0x18F7, "Commtech", "Commtech, Inc." } ,
    { 0x18FB, "", "Resilience Corporation" } ,
    { 0x1904, "Ritmo", "Ritmo" } ,
    { 0x1905, "WIS Computers", "WIS Technology, Inc." } ,
    { 0x1910, "Seaway Networks", "Seaway Networks" } ,
    { 0x1912, "Renesas", "Renesas Electronics" } ,
    { 0x1931, " ", "Option NV" } ,
    { 0x1941, " ", "Stelar" } ,
    { 0x1954 , " ", "One Stop Systems, Inc." } ,
    { 0x1969, "ATHR", "Atheros Communications" } ,
    { 0x1971, "dreser", "AGEIA Technologies, Inc." } ,
    { 0x197B, "santosh", "JMicron Technology Corp." } ,
    { 0x198a, " ", "Nallatech" } ,
    { 0x1991, " tps", "Topstar Digital Technologies Co., Ltd." } ,
    { 0x19a2, " Emulex", "ServerEngines" } ,
    { 0x19A8, "DAQDATA", "DAQDATA GmbH" } ,
    { 0x19AC, "Kasten Chase", "Kasten Chase Applied Research" } ,
    { 0x19B6, " ", "Mikrotik" } ,
    { 0x19E2, "Vector", "Vector Informatik GmbH" } ,
    { 0x19E3, " ", "DDRdrive LLC" } ,
    { 0x1A08, "", "Linux Networx" } ,
    { 0x1a41, "Tilera", "Tilera Corporation" } ,
    { 0x1A42, "", "Imaginant" } ,
    { 0x1B13, "Jaton Corp", "Jaton Corporation USA" } ,
    { 0x1B21, "Asustek - ASMedia", "Asustek - ASMedia Technology Inc." } ,
    { 0x1B6F, " ", "Etron" } ,
    { 0x1B73, "Fresco Logic Inc.", "Fresco Logic Inc." } ,
    { 0x1B91, "", "Averna" } ,
    { 0x1BAD, " ", "ReFLEX CES" } ,
    { 0x1C0F, "Monarch Innovative Technologies ", "Monarch Innovative Technologies Pvt Ltd's " } ,
    { 0x1C32, "Highland Technology", "Highland Technology, Inc." } ,
    { 0x1c39, "TH-VN", "Thomson Video Networks" } ,
    { 0x1DE1, "Tekram", "Tekram" } ,
    { 0x1FCF, "Miranda", "Miranda Technologies Ltd." } ,
    { 0x2001, "", "Temporal Research Ltd" } ,
    { 0x2646, "Kingston", "Kingston Technology Co." } ,
    { 0x270F, "ChainTek", "ChainTek Computer Co. Ltd." } ,
    { 0x2EC1, "", "Zenic Inc" } ,
    { 0x3388, "Hint", "Hint Corp." } ,
    { 0x3411, "", "Quantum Designs (H.K.) Inc." } ,
    { 0x3513, "ARCOM", "ARCOM Control Systems Ltd." } ,
    { 0x38EF, "", "4links" } ,
    { 0x3D3D, "3DLabs", "3Dlabs, Inc. Ltd" } ,
    { 0x4005, "Avance", "Avance Logic Inc." } ,
    { 0x4144, "Alpha Data", "Alpha Data" } ,
    { 0x416C, "", "Aladdin Knowledge Systems" } ,
    { 0x4348, "Nanjing Qin Heng Electronics Co., Ltd", "wch.cn" } ,
    { 0x4680, "UMAX Comp", "UMAX Computer Corp." } ,
    { 0x4843, "Hercules", "Hercules Computer Technology" } ,
    { 0x4943, "", "Growth Networks" } ,
    { 0x4954, "Integral", "Integral Technologies" } ,
    { 0x4978, "Axil", "Axil Computer Inc." } ,
    { 0x4C48, "Lung Hwa", "Lung Hwa Electronics" } ,
    { 0x4C53, "SBS", "SBS-OR Industrial Computers" } ,
    { 0x4CA1, "", "Seanix Technology Inc" } ,
    { 0x4D51, "Mediaq", "Mediaq Inc." } ,
    { 0x4D54, "", "Microtechnica Co Ltd" } ,
    { 0x4DDC, "ILC", "ILC Data Device Corp." } ,
    { 0x4E8, " samsung YP-R1JEB", "Samsung Windows Portable Devices" } ,
    { 0x5053, "TBS/Voyetra", "TBS/Voyetra Technologies" } ,
    { 0x508A, " ", "Samsung T10 MP3 Player" } ,
    { 0x5136, "", "S S Technologies" } ,
    { 0x5143, "Qualcomm", "Qualcomm Inc. USA" } ,
    { 0x5333, "S3G", "S3 Graphics Co., Ltd" } ,
    { 0x544C, "", "Teralogic Inc" } ,
    { 0x5555, "Genroco", "Genroco Inc." } ,
    { 0x5853, " Citrix", "Citrix Systems, Inc." } ,
    { 0x6409, "", "Logitec Corp." } ,
    { 0x6666, "Decision", "Decision Computer International Co." } ,
    { 0x6945, "ASMedia ", "ASMedia Technology Inc." } ,
    { 0x7604, "O.N.", "O.N. Electric Co. Ltd." } ,
    { 0x7d1, "D-Link", "D-Link Corporation" } ,
    { 0x8080, "Xirlink", "Xirlink, Inc" } ,
    { 0x8086, "Intel", "Intel Corporation" } ,
    { 0x8087, "Intel", "Intel" } ,
    { 0x80EE, "VirtualBox", "Oracle Corporation - InnoTek Systemberatung GmbH" } ,
    { 0x8866, "T-Square", "T-Square Design Inc." } ,
    { 0x8888, "Sil Magic", "Silicon Magic" } ,
    { 0x8E0E, "Computone", "Computone Corporation" } ,
    { 0x9004, "Adaptec", "Adaptec Inc" } ,
    { 0x9005, "Adaptec", "Adaptec Inc" } ,
    { 0x919A, "", "Gigapixel Corp" } ,
    { 0x9412, "Holtek", "Holtek" } ,
    { 0x9699, "", "Omni Media Technology Inc." } ,
    { 0x9710, "MosChip", "MosChip Semiconductor Technology" } ,
    { 0x9902, "StarGen", "StarGen, Inc." } ,
    { 0xA0A0, "Aopen", "Aopen Inc." } ,
    { 0xA0F1, "", "Unisys Corporation" } ,
    { 0xA200, "NEC", "NEC Corp." } ,
    { 0xA259, "HP", "Hewlett Packard" } ,
    { 0xA304, "Sony", "Sony" } ,
    { 0xA727, "", "3com Corporation" } ,
    { 0xAA42, "Abekas", "Abekas, Inc" } ,
    { 0xAC1E, "", "Digital Receiver Technology Inc" } ,
    { 0xB1B3, "Shiva", "Shiva Europe Ltd." } ,
    { 0xB894, "", "Brown & Sharpe Mfg. Co." } ,
    { 0xBEEF, "Mindstream Computing", "Mindstream Computing" } ,
    { 0xC001, "TSI", "TSI Telsys" } ,
    { 0xC0A9, "Micron/Crucial", "Micron/Crucial Technology" } ,
    { 0xC0DE, "", "Motorola" } ,
    { 0xC0FE, "Mot Engrg", "Motion Engineering Inc." } ,
    { 0xC622, "", "Hudson Soft Co Ltd" } ,
    { 0xCA50, "Varian", "Varian, Inc" } ,
    { 0xCAFE, "", "Chrysalis-ITS" } ,
    { 0xCCCC, "", "Catapult Communications" } ,
    { 0xD4D4, "Processing", "Curtiss-Wright Controls Embedded Computing" } ,
    { 0xDC93, "", "Dawicontrol" } ,
    { 0xDEAD, "Indigita", "Indigita Corporation" } ,
    { 0xDEAF, "", "Middle Digital, Inc" } ,
    { 0xE159, "Tiger Jet", "Tiger Jet Network Inc" } ,
    { 0xE4BF, "", "EKF Elektronik GMBH" } ,
    { 0xEA01, "", "Eagle Technology" } ,
    { 0xEABB, "Aashima", "Aashima Technology B.V." } ,
    { 0xEACE, "Endace", "Endace Measurement Systems Ltd." } ,
    { 0xECC0, "Echo", "Echo Digital Audio Corporation" } ,
    { 0xEDD8, "ARK Logic", "ARK Logic, Inc" } ,
    { 0xF5F5, "", "F5 Networks Inc." } ,
    { 0xFA57, "Interagon", "Interagon AS" } ,
} ;


// Use this value for loop control during searching:
#define	PCI_VENTABLE_LEN	(sizeof(PciVenTable)/sizeof(PCI_VENTABLE))

typedef struct _PCI_DEVTABLE
{
    unsigned short	VenId ;
    unsigned short	DevId ;
    const char *	Chip ;
    const char *	ChipDesc ;
}  PCI_DEVTABLE, *PPCI_DEVTABLE ;

PCI_DEVTABLE	PciDevTable [] =
{
    { 0x165C, 0x0002, "FT232BL", "FT232BL" } ,
    { 0x16AE, 0x000A, "SafeXcel-1841", "Crypto Accelerator" } ,
    { 0x16AE, 0x1141, "SafeXcel-1141", "Crypto Accelerator" } ,
    { 0x11DA, 0x2000, "2", "Virtual-Bus / AlacrityVM bridge" } ,
    { 0x11DB, 0x1234, "", "Dreamcast Broadband Adapter" } ,
    { 0x11DE, 0x6057, "59568", "Mc3aDo  <a href=" } ,
    { 0x11DE, 0x6067, "zr36067pqc", "zoran" } ,
    { 0x11DE, 0x6120, "ZR36120PQC", "MPEG VideoBVPSXI Capture Card" } ,
    { 0x11DE, 0x6057, "ZR36057PQC", "ZORAN PCI Bridge (interface for transferring video across the PCI bus)" } ,
    { 0x11DE, 0x9876, "", "" } ,
    { 0x11EC, 0x0028, "NV05", "MCP67 High Definition Audio" } ,
    { 0x11EC, 0x2064, "", "" } ,
    { 0x11F0, 0x2772, "FASTline UTP Quattr", "PCI\\VEN_8086&DEV_2772&SUBSYS_0CCB105B&REV_02\\3&2411E6FE&0&10" } ,
    { 0x11F0, 0x4, "FASTline UTP Quattr", "PCI\\VEN_8086&DEV_2772&SUBSYS_0CCB105B&REV_02\\3&2411E6FE&0&10" } ,
    { 0x11F0, 0x4231, "1", "2" } ,
    { 0x11F0, 0x4232, "FASTline UTP Quattr", "PCI\\VEN_8086&DEV_2772&SUBSYS_0CCB105B&REV_02\\3&2411E6FE&0&10" } ,
    { 0x11F0, 0x4233, "FASTline FO", "" } ,
    { 0x11F0, 0x4234, "FASTline UTP", "" } ,
    { 0x11F0, 0x4235, "FASTline-II UTP", "" } ,
    { 0x11F0, 0x4236, "FASTline-II FO", "" } ,
    { 0x11F0, 0x4731, "GIGAline", "Gigabit Ethernet Adapter" } ,
    { 0x11F0, 0x9876, "1", "2" } ,
    { 0x11F4, 0x2915, "2915", "" } ,
    { 0x11F6, 0x0112, "ATT2MD11", "ReadyLink ENET100-VG4" } ,
    { 0x11F6, 0x0113, "", "FreedomLine 100" } ,
    { 0x11F6, 0x1401, "832AE28030680", "ReadyLink RL2000" } ,
    { 0x11F6, 0x2011, "TXA9882", "ReadyLink  RL100ATX/PCI Fast Ethernet Adapter" } ,
    { 0x11F6, 0x2201, "TXA9883", "ReadyLink 100TX (Winbond W89C840)" } ,
    { 0x11F6, 0x9881, "TXA9881?", "ReadyLink RL100TX Fast Ethernet Adapter" } ,
    { 0x11F8, 0x7364, "PM7364", "FREEDM-32 Frame Engine & Datalink Mgr" } ,
    { 0x11F8, 0x7366, "PM7364", "FREEDM-8 Frame Engine & Datalink Manager" } ,
    { 0x11F8, 0x7367, "PM7367", "FREEDM-32P32 Frame Engine & Datalink Mgr" } ,
    { 0x11F8, 0x7375, "PM7375", "LASAR-155 ATM SAR" } ,
    { 0x11F8, 0x7380, "PM7380", "FREEDM-32P672 Frm Engine & Datalink Mgr" } ,
    { 0x11F8, 0x7382, "PM7382", "FREEDM-32P256 Frm Engine & Datalink Mgr" } ,
    { 0x11F8, 0x7384, "PM7384", "FREEDM-84P672 Frm Engine & Datalink Mgr" } ,
    { 0x11F8, 0x8000, "PM8000 SPC", "6G SAS/SATA Controller" } ,
    { 0x11F8, 0x8010, "PM8010 SRC", "6G SAS/SATA RAID Controller" } ,
    { 0x11FB, 0x0417, "417", "PCI-417 High Speed A/D Board" } ,
    { 0x11FE, 0x0001, "RocketPort", "" } ,
    { 0x11FE, 0x0002, "RocketPort", "" } ,
    { 0x11FE, 0x0003, "RocketPort", "" } ,
    { 0x11FE, 0x0004, "RocketPort", "" } ,
    { 0x11FE, 0x0005, "RocketPort", "" } ,
    { 0x11FE, 0x0006, "RocketPort", "" } ,
    { 0x11FE, 0x0007, "RocketPort", "" } ,
    { 0x11FE, 0x0008, "RocketPort", "" } ,
    { 0x11FE, 0x0009, "RocketPort", "" } ,
    { 0x11FE, 0x000A, "RocketPort", "" } ,
    { 0x11FE, 0x000B, "RocketPort", "" } ,
    { 0x11FE, 0x000C, "RocketPort", "" } ,
    { 0x11FE, 0x000D, "RocketPort", "" } ,
    { 0x11FE, 0x8015, "RocketPort", "4-port UART 16954" } ,
    { 0x1202, 0x0001, "NAIATMPCI", "PCI ATM Adapter" } ,
    { 0x1203, 0x0001, "Unknown", "Unknown" } ,
    { 0x1204, 0x9876, "12", "wwDW" } ,
    { 0x1208, 0x4853, "", "HS-Link Device" } ,
    { 0x1365, 0x9050, "HYSDN", "" } ,
    { 0x1209, 0x0100, "PCI 9054", "PLX PCI BRIDGE" } ,
    { 0x120E, 0x0100, "Cyclom-Y", "Multiport Serial Card" } ,
    { 0x120E, 0x0101, "Cyclom-Y", "Multiport Serial Card" } ,
    { 0x120E, 0x0102, "Cyclom-4Y", "Multiport Serial Card" } ,
    { 0x120E, 0x0103, "Cyclom-4Y", "Multiport Serial Card" } ,
    { 0x120E, 0x0104, "Cyclom-8Y", "Multiport Serial Card" } ,
    { 0x120E, 0x0105, "Cyclom-8Y", "Multiport Serial Card" } ,
    { 0x120E, 0x0200, "Cyclom-Z", "Intelligent Multiport Serial" } ,
    { 0x120E, 0x0201, "Cyclom-Z", "Intelligent Serial Card" } ,
    { 0x120E, 0x0300, "PC300 RX 2", "1105" } ,
    { 0x120E, 0x0301, "PC300 RX 1", "" } ,
    { 0x120E, 0x0302, "PC300 TE 2", "" } ,
    { 0x120E, 0x0303, "PC300 TE 1", "teclado" } ,
    { 0x120F, 0x0001, "Roadrunner", "" } ,
    { 0x1210, 0x25f4, "No data", "No data" } ,
    { 0x1216, 0x0003, "188A2L432B", "PTM400 PCI Taxi Module" } ,
    { 0x1217, 0x00f7, "0x00f71217", "1394 Open Host Controller Interface" } ,
    { 0x1217, 0x1217, "EN-2242", "111111111" } ,
    { 0x1217, 0x6729, "OZ6729", "PCI to PCMCIA Bridge" } ,
    { 0x1217, 0x673A, "OZ6730", "PCI to PCMCIA Bridge" } ,
    { 0x1217, 0x6832, "OZ6832/3", "CardBus Controller" } ,
    { 0x1217, 0x6836, "OZ6836/6860", "CardBus Controller" } ,
    { 0x1217, 0x6872, "OZ6812", "CardBus Controller" } ,
    { 0x1217, 0x6925, "OZ6922", "CardBus Controller" } ,
    { 0x1217, 0x6933, "OZ6933", "CardBus Controller" } ,
    { 0x1217, 0x6972, "OZ6912", "CardBus Controller" } ,
    { 0x1217, 0x7110, "OZ711Mx", "MemoryCardBus Accelerator" } ,
    { 0x1217, 0x7112, "", "" } ,
    { 0x1217, 0x7113, "0Z711EC1", "PCMCIA/SmartCardBus Contoller" } ,
    { 0x1217, 0x7114, "OZ711M1", "CardBus Controller" } ,
    { 0x1217, 0x7120, "Unknown device", "O2Micro Integrated MMC/SD controller" } ,
    { 0x1217, 0x7130, "501179", "O2Micro Integrated MMC/SD/MS/xD/SM Controller" } ,
    { 0x1217, 0x7134, "OZ711MP1/MS1", "MemoryCardBus Controller 6-in-1" } ,
    { 0x1217, 0x7135, "OZ711EZ1", "MemoryCardBus Contoller" } ,
    { 0x1217, 0x7136, "OZ711SP1", "O2Micro CardBus Controller" } ,
    { 0x1217, 0x71E2, "", "" } ,
    { 0x1217, 0x7212, "", "" } ,
    { 0x1217, 0x7213, "", "" } ,
    { 0x1217, 0x7222, "unknow", "pci to pcmcia bridge" } ,
    { 0x1217, 0x7223, "OZ711M3/MC3", "MemoryCardBus Controller" } ,
    { 0x1217, 0x8130, "0x8130", "o2 sd card reader" } ,
    { 0x1217, 0x8231, "OZ600XXX", "O2Micro OZ600XXX Memory Card " } ,
    { 0x1217, 0x8330, " PCI\\VEN_1217&DEV_8331&SUBSYS_049A1028&REV_05\\4&34", "Mass storage controller [0180]" } ,
    { 0x1217, 0x8331, "OZ600xxx", "O2Micro Integrated MS/PRO controller" } ,
    { 0x121A, 0003, "", "" } ,
    { 0x121A, 003, "", "" } ,
    { 0x121A, 0x0001, "Voodoo", "Voodoo 3D Acceleration Chip" } ,
    { 0x121A, 0x0002, "Voodoo2", "Voodoo 2 3D Accelerator" } ,
    { 0x121A, 0x0003, "Voodoo Banshee", "Voodoo Banshee" } ,
    { 0x121A, 0x0005, "Voodoo3", "All Voodoo3 chips, 3000" } ,
    { 0x121A, 0x0007, "Voodoo4", "" } ,
    { 0x121A, 0x0009, "Voodoo5", "AGP X2, or PCI. Chip: 2x VSA100 with 32Mo" } ,
    { 0x121A, 0x0010, "Rampage", "Rev.A AGPx4, 0.25�, 200/2x200 core/RAM" } ,
    { 0x121A, 0x0057, "Voodoo 3/3000", "Avenger" } ,
    { 0x1220, 0x1220, "9622qac", "AMCC 5933 TMS320C80 DSP/Imaging Board" } ,
    { 0x1220, 0x4242, " ", "controller audio multimediale" } ,
    { 0x1223, 0x0001, "KatanaQp", "Real-Time Processing Blade in a standard single-slot AdvancedTCA� formfactor" } ,
    { 0x1223, 0x0002, "KosaiPM", "Intel� Pentium-M� based AMC Module" } ,
    { 0x1223, 0x0016, "PCIe-8120", "PCIe-8120 MGW Octasic DSP card " } ,
    { 0x1223, 0x003, "Katana3752", "Advanced Tri-Processor Blade" } ,
    { 0x1223, 0x004, "Katana3750", "Advanced Tri-Processor Blade" } ,
    { 0x1223, 0x0044, "Memory controller", "Memory controller" } ,
    { 0x1223, 0x005, "Katana752i", "Real-time Processing Blade" } ,
    { 0x1223, 0x006, "Katana750i", "Real-time Processing Blade" } ,
    { 0x1223, 0x007, "CC1000dm", "Processor PMC Carrier Card" } ,
    { 0x1223, 0x008, "Pm3Gv", "Up to 8 E1/T1/J1 interfaces for PMC-compatible baseboards" } ,
    { 0x1223, 0x009, "Pm3GE1T1", "Third Generation E1 and T1/J1 interfaces for PMC-compatible baseboards" } ,
    { 0x1223, 0x010, "SpiderwareSG", "SIGTRAN Signalling Gateway Blade" } ,
    { 0x1223, 0x011, "SpiderwareSS7", "64 SS7 signaling channels on a single blade" } ,
    { 0x1223, 0x012, "SpiderSS7", "Portable, STREAMS-Based Implementation of the ITU SS7 Protocol Stack" } ,
    { 0x1223, 0x013, "Spider FRAME RELAY", "STREAMS-Based Frame Relay Implementation" } ,
    { 0x1223, 0x014, "Spider STREAMS", "Implementation of the UNIX STREAMS Environment" } ,
    { 0x1223, 0x015, "Spider DSF", "Transparent STREAMS Interface for High Speed LAN or Shared Memory Systems" } ,
    { 0x1223, 0x7207, "pcie7207", "PCIe7207 Server Accelerator" } ,
    { 0x1224, 0x1000, "CL560?", "Plum Audio, Video and VTR Controller" } ,
    { 0x122D, 0x1206, "ICH2", "Asus" } ,
    { 0x122D, 0x4201, "MR2800W", "AMR 56K modem" } ,
    { 0x122D, 0x50DC, "pci 120", "Audio" } ,
    { 0x122D, 0x80DA, "3328", "Audio" } ,
    { 0x122F, 0x37AF, "0x9030", "Reflectometer using PLX 9030" } ,
    { 0x1668, 0x0100, "0304", "PCI to PCI Bridge" } ,
    { 0x1236, 0x0000, "RealMagic64/GX", "SD6425" } ,
    { 0x1236, 0x0531, "MX98715/25", "Single Chip Fast Ethernet NIC Controller" } ,
    { 0x1236, 0x3d01, "000", "RealMagic/2D" } ,
    { 0x1236, 0x6401, "REALmagic64/GX", "GUI" } ,
    { 0x1236, 0x9708, "realmagic64/gx", "sd6425" } ,
    { 0x123D, 0x0010, "PCI-DV", "PCI-DV Digital Video Interface" } ,
    { 0x123F, 0x00E4, "cl 480", "MPEG" } ,
    { 0x123F, 0x6120, "12.03", "DVD device" } ,
    { 0x123F, 0x8120, "176", "i440B" } ,
    { 0x123F, 0x8888, "12.03", "cPEG C 3.0 DVD/MPEG2 Decoder" } ,
    { 0x1241, 0x1603, "1", "keyboard" } ,
    { 0x1244, 0x0700, "B1", "ISDN controller" } ,
    { 0x1244, 0x0800, "C4", "ISDN Controller" } ,
    { 0x1244, 0x0A00, "A1", "ISDN Controller" } ,
    { 0x1244, 0x0E00, "0x1244", "Fritz!PCI 2.0 ISDN Controller" } ,
    { 0x1244, 0x1100, "C2", "ISDN Controller" } ,
    { 0x1244, 0x1200, "T1", "ISDN Controller" } ,
    { 0x1244, 0x2700, "E13 32A5KYW / 2CAKRCT", "DSP TNETD5100GHK / TNETD5015" } ,
    { 0x1244, 0x2900, "-", "AVM Fritz!Card DSL v2.0 PCI" } ,
    { 0x124A, 0x10BD, "82566DM-2", "Intel Gigabit network connection" } ,
    { 0x124A, 0x4023, "BWU713 v2.0", "Blitzz Wireless G" } ,
    { 0x124C, 0x0220, ".", "." } ,
    { 0x124D, 0x0000, "EasyConnect 8/32", "" } ,
    { 0x124D, 0x0002, "EasyConnect 8/64", "" } ,
    { 0x124D, 0x0003, "EasyIO PCI", "" } ,
    { 0x124F, 0x0041, "IFT-2000", "PCI RAID Controller" } ,
    { 0x1250, 0x1978, "", "" } ,
    { 0x1250, 0x2898, "", "" } ,
    { 0x1255, 0x1110, "MPEG Forge", "" } ,
    { 0x1255, 0x1210, "MPEG Fusion", "" } ,
    { 0x1255, 0x2110, "VideoPlex-pci", "VideoPlex pci bpc1825 rev a" } ,
    { 0x1255, 0x2120, "VideoPlex plus", "VideoPlex BPC 1851 A" } ,
    { 0x1255, 0x2130, "VideoQuest", "" } ,
    { 0x1256, 0x4201, "PCI-2240i", "EIDE Adapter" } ,
    { 0x1256, 0x4401, "PCI-2220i", "Dale EIDE Adapter" } ,
    { 0x1256, 0x5201, "PCI-2000", "IntelliCache SCSI Adapter" } ,
    { 0x1258, 0x1988, "0001", "" } ,
    { 0x1259, 0x2503, "Realtek 8139b", "" } ,
    { 0x1259, 0x2560, "82845G", "AT-2560 Fast Ethernet Adapter (i82557B)" } ,
    { 0x1259, 0xc107, "Realtek 8110S", "" } ,
    { 0x125B, 0x0B95, "AX88772A", "USB2.0 to 10/100M Fast Ethernet Controller" } ,
    { 0x125B, 0x1400, "AX88140A", "ASIX AX88140 Based PCI Fast Ethernet Adapter" } ,
    { 0x125B, 0x1720, "AX88172", "USB2 to Fast Ethernet Adapter" } ,
    { 0x125D, 0x0000, "ESS336H", "PCI Fax Modem (early model)" } ,
    { 0x125D, 0x1961, "Multimedia Device", "ESS Solo-1 Soundcard" } ,
    { 0x125D, 0x1968, "ES2839", "Maestro-2 PCI audio accelerator" } ,
    { 0x125D, 0x1969, "ES1969", "Solo-1 PCI AudioDrive family" } ,
    { 0x125D, 0x1978, "ES1978", "ESS Maestro-2E PCI Audiodrive" } ,
    { 0x125D, 0x1980, "0x0401", "subsys_0012103c_rev_12" } ,
    { 0x125D, 0x1988, "ES1999", "ESS Allegro PCI Audio (WDM)" } ,
    { 0x125D, 0x1989, "ES1980", "ESS Maestro 3 PCI Audio Accelerator" } ,
    { 0x125D, 0x1990, "ES2898S", "" } ,
    { 0x125D, 0x1992, "", "" } ,
    { 0x125D, 0x1998, "Maestro 3i", "Maestro 3i" } ,
    { 0x125D, 0x1999, "ES1980S", "TAWE0548S" } ,
    { 0x125D, 0x199B, "ES1938/41/46 solo audio", "Maestro-3.COMM PCI Voice+audio" } ,
    { 0x125D, 0x2808, "ES336H", "PCI Fax Modem (later model)" } ,
    { 0x125D, 0x2828, "ES2828S", "TeleDrive" } ,
    { 0x125D, 0x2838, "PCI\\VEN_125D&DEV_2838&SUBSYS_2838125D&REV_01", "PCI Data Fax Modem" } ,
    { 0x125D, 0x2839, "2838", "Superlink Modem/V.92 chipset 56K" } ,
    { 0x125D, 0x2898, "2898", "TelDrive ES56T-PI family V.90 PCI modem" } ,
    { 0x125F, 0x2084, "AMCC S5933", "AMCC Bridge + 2 x Super I/O (National PC97338)" } ,
    { 0x1260, 0x3860, "PRISM 2.5 ", "PRISM 2.5 802.11b 11Mbps Wireless Controller" } ,
    { 0x1260, 0x3872, "PRISM 3", "LAN-Express IEEE 802.11b PCI Adapter" } ,
    { 0x1260, 0x3873, "ISL3886A", "PRISMII.5 IEE802.11g Wireless LAN" } ,
    { 0x1260, 0x3886, "200206BE", "Creatix CTX405 WLAN Controller / ZyAir G100 - WLAN" } ,
    { 0x1260, 0x3890, "ISL3890", "PRISM GT 802.11g 54Mbps Wireless Controller" } ,
    { 0x1260, 0x8130, "HMP8130", "NTSC/PAL Video Decoder" } ,
    { 0x1260, 0x8131, "HMP8131", "NTSC/PAL Video Decoder" } ,
    { 0x1266, 0x0001, "023132", "NE10/100 Adapter (i82557B)" } ,
    { 0x1266, 0x1910, "", "NE2000Plus (RT8029) Ethernet Adapter" } ,
    { 0x1267, 0x1016, "", "NICCY PCI card" } ,
    { 0x1267, 0x4243, "", "Satellite receiver board / MPEG2 decoder" } ,
    { 0x1267, 0x5352, "PCR2101", "" } ,
    { 0x1267, 0x5A4B, "telsatturbo", "" } ,
    { 0x1382, 0x0001, "f97260118", "Sek'D ARC88 professional soundcard" } ,
    { 0x1382, 0x2009, "PLX TECHNOLOGY \\n PCI9052 \\n 0435 \\n BX9497.1 MALA", "SEK'D Prodif 96 Pro - professional audio card" } ,
    { 0x1382, 0x2048, "2048", "Prodif Plus sound card" } ,
    { 0x1382, 0x2088, "Marc 8 Midi", "8-in, 8-out sound card" } ,
    { 0x1268, 0x0204, "Unknown", "Tektronix IO Processor / Tektronix PCI Acquisition Interface Rev 204" } ,
    { 0x126A, 0x2698, "631xesb/6321esb/3100", "sm bus controller" } ,
    { 0x126A, 0x269B, "631xESB/6321ESB/3100", "SM Bus Controller" } ,
    { 0x126C, 0x1F1F, "", "e-mobility 802.11b Wireless LAN PCI Card" } ,
    { 0x126F, 0x0501, "SM501/SM502", "Mobile Multimedia Companion Chip (MMCC)" } ,
    { 0x126F, 0x0710, "SM710", "LynxEM" } ,
    { 0x126F, 0x0712, "SM712", "LynxEM+" } ,
    { 0x126F, 0x0720, "SM720 / SM722", "Lynx3DM" } ,
    { 0x126F, 0x0810, "SM810", "LynxE" } ,
    { 0x126F, 0x0811, "SM811", "LynxE" } ,
    { 0x126F, 0x0820, "SM820", "Lynx3D" } ,
    { 0x126F, 0x0910, "SM910", "SILICON MOTION" } ,
    { 0x126F, 0x2260, "SM2260", "PCIe SSD (NVMe/AHCI)" } ,
    { 0x1272, 0x0780, "PCI\\VEN_8086&DEV_1C3A&SUBSYS_307c17aa &7rev_04", "PCI\\VEN_8086&DEV_1C3A" } ,
    { 0x1272, 0x1272, "PCI\\VEN_8086&DEV_1C3A&CC_078000", "PCI\\VEN_8086&DEV_1C3A&SUBSYS_1C3A1458" } ,
    { 0x1272, 0x1c3A, "0X78000", "0X78000" } ,
    { 0x1272, 0x9876, "PCI\\VEN_1272&DEV_0780&SUBSYS_00000008&REV_7A\\3&61A", "PCI\\VEN_1272&DEV_0780&SUBSYS_00000008&REV_7A\\3&61AAA01&0&58" } ,
    { 0x1273, 0x0002, "DirecPC", "t9p17af-01" } ,
    { 0x1274, 0X1005, "", "Serial PCI Port" } ,
    { 0x1274, 0x1274, "1880x1274", "multimedia audio device" } ,
    { 0x1274, 0x1371, "ES 1371", "Creative AudioPCI (ES1371,ES1373)" } ,
    { 0x1274, 0x1373, "ES1373", "Sound Blaster Audio(PCI)" } ,
    { 0x1274, 0x5000, "ES1371", "AudioPCI" } ,
    { 0x1274, 0x5880, "5880x", "Soundblaster (CT4750)" } ,
    { 0x1274, 0x9876, "", "" } ,
    { 0x1278, 0x0701, "TPE3/TM3", "PowerPC Node" } ,
    { 0x1278, 0x1001, "TMB17", "TMB17 Motherboard" } ,
    { 0x1279, 0x0060, "TM8000", "Efficeon Virtual Northbridge" } ,
    { 0x1279, 0x0061, "TMTM8000", "Efficeon AGP Bridge" } ,
    { 0x1279, 0x0295, "", "Virtual Northbridge" } ,
    { 0x1279, 0x0395, "LongRun", "Northbridge" } ,
    { 0x1279, 0x0396, "", "SDRAM Controller" } ,
    { 0x1279, 0x0397, "18490397", "BIOS scratchpad" } ,
    { 0x127E, 0x0010, "Unknown", "Videum 1000 AV Plus" } ,
    { 0x1282, 0x1282, "DM9102AF", "DEV" } ,
    { 0x1282, 0x9009, "DM9009", "Ethernet Adapter" } ,
    { 0x1282, 0x9100, "", "" } ,
    { 0x1282, 0x9102, "DM9102/A/AF", "10/100 Mbps Fast Ethernet Controller" } ,
    { 0x1283, 0x0801, "Audio Digital Controller", "Audio Digital Controller" } ,
    { 0x1283, 0x673A, "IT8330G", "IDE Controller" } ,
    { 0x1283, 0x8152, "IT8152F/G", "Advanced RISC-to-PCI Companion Chip" } ,
    { 0x1283, 0x8172, "IT8172G", "Ultra RISC (MIPS, SH4) Companion Chip" } ,
    { 0x1283, 0x8211, "IT8211F", "ATA/ATAPI Controller" } ,
    { 0x1283, 0x8212, "ITE8212", "ATA 133 IDE RAID Controller" } ,
    { 0x1283, 0x8213, "IT8213F", "IDE Controller" } ,
    { 0x1283, 0x8330, "IT8330G", "Host Bridge" } ,
    { 0x1283, 0x8872, "IT8871/72", "PCI-ISA I/O chip with SMB & Parallel Port" } ,
    { 0x1283, 0x8875, "IT8875F", "PCI Parallel Port" } ,
    { 0x1283, 0x8888, "IT8888F", "PCI to ISA Bridge" } ,
    { 0x1283, 0x8889, "IT8889F", "sound" } ,
    { 0x1283, 0x9876, "IT8875F", "PCI I/O CARD" } ,
    { 0x1283, 0xE886, "IT8330G", "PCI to ISA Bridge" } ,
    { 0x1285, 0x0100, "ES1849", "Maestro-1 AudioDrive" } ,
    { 0x1287, 0x001E, "LS220D", "DVD Decoder" } ,
    { 0x1287, 0x001F, "LS220C", "DVD Decoder" } ,
    { 0x1287, 0x0020, "LS242", "MPEG/DVD video decoder" } ,
    { 0x1289, 0x1006, "1106", "1708" } ,
    { 0x128A, 0xF001, "Ethernet 10/100", "controller ethernet" } ,
    { 0x128D, 0x0021, "", "ATM Adapter" } ,
    { 0x1290, 0x0010, "?", "?" } ,
    { 0x13FE, 0x1011, "13FE", "Advantech SRamDisk Device" } ,
    { 0x13FE, 0x1240, "PS2134CE-0", "4-Axis Stepping/Servo Motor Card" } ,
    { 0x13FE, 0x1600, "PCI-1610CU/9-AE", "4-port RS-232 UNI PCI COMM card w/S&I&D" } ,
    { 0x13FE, 0x1680, "PCI-1680U-A", "2-port CAN UniversalPCI Communication Card with Isolation" } ,
    { 0x13FE, 0x16FF, "PCI-1610CU/9-AE", "4-port RS-232 UNI PCI COMM card w/S&I&D" } ,
    { 0x13FE, 0x1713, "PCI-1713", "32-channel Isolated Analog Input Card" } ,
    { 0x13FE, 0x1723, "PCI-1723", "16-bit, 8-ch Analog Output PCI Card with 16-ch Digital I/O" } ,
    { 0x13FE, 0x1724, "PCI-1723", "14-bit, 32-channel Isolated Analog Output Card" } ,
    { 0x13FE, 0x1755, "PCI-1755", "80 MB/s, 32-ch Digital I/O PCI Card" } ,
    { 0x13FE, 0x1760, "amcc pci matchmaker s5920q", "pci" } ,
    { 0x13FE, 0x1761, "PCI-1751", "48 Digital IO + Counter " } ,
    { 0x13FE, 0x1762, "PCI-1762", "16-ch Relay and 16-ch Isolated Digital Input PCI Card" } ,
    { 0x13FE, 0x1a00, "0x03", "0x0200" } ,
    { 0x13FE, 0x3730, "PCM-3730I", "16Bit dig. I/O Board" } ,
    { 0x129A, 0x0415, "PBT-415", "PCI 66MHz Analyzer and 33MHz Exerciser" } ,
    { 0x129A, 0x0515, "PBT-515", "PCI 66MHz Analyzer and Exerciser" } ,
    { 0x129A, 0x0615, "PBT-615", "PCI 66MHz and PCI-X 100MHz Bus Analyzer and Exerciser" } ,
    { 0x129A, 0x0715, "Vanguard PCI/PMC/cPCI", "PCI 66MHz and PCI-X 133MHz Bus Analyzer and Exerciser" } ,
    { 0x129A, 0xDD10, "DPIO", "Digital Parallel Input Output Device 32bit, 33MHz PCI bus" } ,
    { 0x129A, 0xDD11, "DPIO2", "Digital Parallel Input Output Device 64bit, 33MHz PCI bus" } ,
    { 0x129A, 0xDD12, "DPIO2-66", "Digital Parallel Input Output Device 64bit, 66MHz PCI bus" } ,
    { 0x12A0, 0x0008, "1784-PKTX", "Allen-Bradley 1784-PKTX" } ,
    { 0x12A3, 0xECB8, "1646T00", "V.92 Lucent Modem" } ,
    { 0x12AA, 0x5568, "Wan405", "WANic 400 series X.21 controller" } ,
    { 0x12AA, 0x556C, "", "NAI HSSI Sniffer PCI Adapter" } ,
    { 0x12AB, 0x3000, "JRS-3DS100", "PCI" } ,
    { 0x12AD, 0x0010, "1", "HERMES-S0" } ,
    { 0x12AD, 0x0020, "1", "HERMES-PRI" } ,
    { 0x12AD, 0x0080, "1", "HERMES-PRI/PCIX" } ,
    { 0x12AE, 0x0001, "3C986", "ACEnic 1000 BASE-SX Ethernet adapter" } ,
    { 0x12AE, 0x0002, "3C986-T", "Copper Gigabit Ethernet Adapter" } ,
    { 0x12BA, 0x0032, "Hammerhead-Lite-PCI", "DSP Prototyping & Development Card" } ,
    { 0x12BA, 0x0041, "Stratix5 Family FPGA", "Altera FPGA" } ,
    { 0x12C1, 0x9080, "Sync4hs/CCP/PCI/MP", "Communications Processor" } ,
    { 0x13A3, 0x0005, "7751", "Security Processor" } ,
    { 0x13A3, 0x0006, "6500", "Public Key Processor" } ,
    { 0x13A3, 0x0007, "7811", "Security Processor" } ,
    { 0x13A3, 0x0012, "7951", "Security Processor" } ,
    { 0x13A3, 0x0014, "7814", "Security Processor" } ,
    { 0x13A3, 0x0015, "8065", "Security Processor" } ,
    { 0x13A3, 0x0017, "8165", "Security Processor" } ,
    { 0x13A3, 0x0018, "8154", "Security Processor" } ,
    { 0x13A3, 0x001d, "7956", "Cryptographic Processor" } ,
    { 0x13A3, 0x0020, "7954/7955", "Cryptographic Processor" } ,
    { 0x13A3, 0x0026, "8155", "Security Processor" } ,
    { 0x13A3, 0x16, "8065", "Security Processor" } ,
    { 0x12C3, 0x0058, "HT80232", "LAN Adapter (NE2000-compatible)" } ,
    { 0x12C3, 0x5598, "HT80229", "Ethernet Adapter (NE2000-compatible)" } ,
    { 0x12C4, 0x0001, "", "" } ,
    { 0x12C4, 0x0002, "", "" } ,
    { 0x12C4, 0x0003, "", "" } ,
    { 0x12C4, 0x0004, "", "" } ,
    { 0x12C4, 0x0005, "Blue Heat-8 RS232", "BlueHeat 8 Port RS232 Serial Board" } ,
    { 0x12C4, 0x0006, "", "" } ,
    { 0x12C4, 0x0007, "", "" } ,
    { 0x12C4, 0x0008, "", "" } ,
    { 0x12C4, 0x0009, "", "" } ,
    { 0x12C4, 0x000A, "", "" } ,
    { 0x12C4, 0x000B, "", "" } ,
    { 0x12C4, 0x000C, "", "" } ,
    { 0x12C4, 0x000D, "", "" } ,
    { 0x12C4, 0x000E, "", "" } ,
    { 0x12C4, 0x000F, "", "" } ,
    { 0x12C4, 0x0300, "", "" } ,
    { 0x12C4, 0x0301, "", "" } ,
    { 0x12C4, 0x0302, "", "" } ,
    { 0x12C4, 0x0303, "", "" } ,
    { 0x12C4, 0x0304, "", "" } ,
    { 0x12C4, 0x0305, "", "" } ,
    { 0x12C4, 0x0306, "", "" } ,
    { 0x12C4, 0x0307, "", "" } ,
    { 0x12C4, 0x0308, " 32", "Starcom UM100 Wireless modem for WiMax " } ,
    { 0x12C4, 0x0309, "", "" } ,
    { 0x12C4, 0x030A, "", "" } ,
    { 0x12C4, 0x030B, "", "" } ,
    { 0x12C5, 0x007F, "ISE", "PEI Imaging Subsystem Engine" } ,
    { 0x12C5, 0x0081, "PCIVST", "PCI Thresholding Engine" } ,
    { 0x12C5, 0x0085, "", "Video Simulator/Sender" } ,
    { 0x12C5, 0x0086, "THR2", "Multi-scale Thresholder" } ,
    { 0x12C7, 0x0546, "kssjsjj", "D120JCT-LS Card" } ,
    { 0x12C7, 0x0561, "", "BRI/2 Type Card (Voice Driver)" } ,
    { 0x12C7, 0x0647, "", "D/240JCT-T1 Card" } ,
    { 0x12C7, 0x0648, "064812C7", "D/300JCT-E1 Card" } ,
    { 0x12C7, 0x0649, "030000", "D/300JCT-E1 Card" } ,
    { 0x12C7, 0x0651, "", "MSI PCI Card" } ,
    { 0x12C7, 0x0673, "", "BRI/160-PCI Card" } ,
    { 0x12C7, 0x0674, "", "BRI/120-PCI Card" } ,
    { 0x12C7, 0x0675, "", "BRI/80-PCI Card" } ,
    { 0x12C7, 0x0676, "067612C7", "D/41JCT Card" } ,
    { 0x12C7, 0x0685, "", "D/480JCT-2T1 Card" } ,
    { 0x12C7, 0x0687, "", "D/600JCT-2E1 (75 Ohm) Card" } ,
    { 0x12C7, 0x0689, "D/600JCT-2E1", "Dialogic 2E1 - JCT series" } ,
    { 0x12C7, 0x0707, "", "D/320JCT (Resource Only) Card" } ,
    { 0x12C7, 0x0708, "", "D/160JCT (Resource Only) Card" } ,
    { 0x12CB, 0x0027, "StudioCard", "studiocard" } ,
    { 0x12CB, 0x002D, "BX-12", "agp" } ,
    { 0x12CB, 0x002E, "SC-2000", "" } ,
    { 0x12CB, 0x002F, "LX-44", "" } ,
    { 0x12CB, 0x0030, "SC-22", "" } ,
    { 0x12CB, 0x0031, "BX-44", "" } ,
    { 0x12CB, 0x0032, "LX-24M", "20-bit 2-in, 4-out audio card w/MPEG-2" } ,
    { 0x12CB, 0x0033, "LX-22M", "" } ,
    { 0x12CB, 0x0034, "BX-8", "" } ,
    { 0x12CB, 0x0035, "BX-12e", "" } ,
    { 0x12D1, 0x1001, "MSM6246", "Huawei E1750 3G modem (labled T-Mobile" } ,
    { 0x12D1, 0x1003, "173", "HUAWEI Mobile Connect - 3G Modem" } ,
    { 0x12D1, 0x140B, "EC159", "HUAWEI MOBILE BROADBAND MODEM" } ,
    { 0x12D1, 0x1412, "09HT1407", "MW6208E" } ,
    { 0x12D1, 0x1446, "E1800", "3G Modem" } ,
    { 0x12D1, 0x14c5, "K4204", "HSPA+ USB Stick" } ,
    { 0x12D1, 0x1506, "E5776", "Huawei Technologies Co., Ltd. E398 LTE/UMTS/GSM Modem/Networkcard" } ,
    { 0x12D1, 0x1520, "-e620", "-vodacom mobile connect" } ,
    { 0x12D1, 0x1802, "unknown", "unknown" } ,
    { 0x12D1, 0x3609, "N/A", "M88++" } ,
    { 0x12D4, 0x0301, "EP1S", "SS7 Telecommunications Interface Adapter" } ,
    { 0x12D5, 0x1000, "MAP-CA", "Broadband Signal Processor" } ,
    { 0x12D5, 0x1002, "MAP-1000", "Digital Signal Processor" } ,
    { 0x1755, 0x000, "", "" } ,
    { 0x1755, 0x0000, "Au1500", "Au1500 Processor" } ,
    { 0x12D8, 0x2304, "PI7C9X2G304SL", "GENII PCI Express Packet Switch" } ,
    { 0x12D8, 0x71E2, "PI7C7300", "3 Port PCI to PCI bridge" } ,
    { 0x12D8, 0x8140, "PI7C8140", "4 Port PCI to PCI bridge" } ,
    { 0x12D8, 0x8150, "PI7C8150", "2-Port PCI to PCI Bridge" } ,
    { 0x12D8, 0x8152, "PI7C8152", "2-Port PCI-To-PCI Bridge" } ,
    { 0x12D8, 0xA404, "PI7C9X20404SL", "PCIe Packet Switch" } ,
    { 0x12D8, 0xE111, "P17C9X", "PCI to PCIe Bridge" } ,
    { 0x12D8, 0xe130, "PI7C9X130", "PCI-X Bridge" } ,
    { 0x12DB, 0x0003, "", "FoxFire II" } ,
    { 0x12DE, 0x0200, "2005063294", "Cryptoswift 200" } ,
    { 0x12DF, 0x2102, "Infineon PEB 20534", "Communications Controller" } ,
    { 0x12DF, 0x8236, "Unknown", "PCI Controller" } ,
    { 0x12E0, 0x0010, "ST16C654", "Quad UART" } ,
    { 0x12E0, 0x0020, "ST16C654", "Quad UART" } ,
    { 0x12E0, 0x0030, "ST16C654", "Quad UART" } ,
    { 0x12E4, 0x1000, "TR1000 PRI", "PRI Controller" } ,
    { 0x12E4, 0x1140, "NV34", "ISDN Controller" } ,
    { 0x12E4, 0xB005, "TR1000 BRI", "BRI Controller" } ,
    { 0x12E4, 0xB006, "TR1000 BRI", "BRI Controller" } ,
    { 0x12EB, 0x0001, "AU8820", "Vortex 1 Digital Audio Processor" } ,
    { 0x12EB, 0x0002, "AU8830A2", "Vortex 2 Audio Processor" } ,
    { 0x12EB, 0x0003, "312EB&REV3", "Aureal Soundcard" } ,
    { 0x12EC, 0x8139, "0xxxx", "0xxxx" } ,
    { 0x12EC, 0x8140, "10", "asf" } ,
    { 0x12F2, 0x1002, "215RAAGCGA11F", "Grapics Radeon X850" } ,
    { 0x12F2, 0x3059, "VT8235", "AC97 Enhanced Audio Controller - the 8251 controller is different" } ,
    { 0x14C8, 0x0003, "0000066779", "0" } ,
    { 0x12F8, 0x0002, "VideoMaker", "s3 trio" } ,
    { 0x1DE1, 0x0045, "RaidCore5000 Series", "Tekram SAS860 Embedded 8xSAS/SATAII RAID" } ,
    { 0x1DE1, 0x0058, "RC5000Series", "Tekram Elrond 8xSAS/SATAII RAID" } ,
    { 0x1DE1, 0x0391, "TRM-S1040", "SCSI ASIC" } ,
    { 0x1DE1, 0x2020, "DC-390", "SCSI Controller" } ,
    { 0x1DE1, 0x690C, "DC-690C", "IDE Cache Controller" } ,
    { 0x1DE1, 0xDC29, "DC290M", "Bus Master IDE PCI 2 controllers" } ,
    { 0x3D3D, 0x0001, "GLint 300SX", "3D Accelerator" } ,
    { 0x3D3D, 0x0002, "GLint 500TX", "Sapphire 3D Accelerator" } ,
    { 0x3D3D, 0x0003, "GLint", "Delta Geometry processor" } ,
    { 0x3D3D, 0x0004, "3C0SX", "2D+3D Accelerator" } ,
    { 0x3D3D, 0x0005, "Permedia", "2D+3D Accelerator" } ,
    { 0x3D3D, 0x0006, "GLint MX", "3D Accelerator" } ,
    { 0x3D3D, 0x0007, "3D Extreme", "Permedia II 2D+3D Accelerator" } ,
    { 0x3D3D, 0x0008, "GLint Gamma G1", "" } ,
    { 0x3D3D, 0x0009, "Permedia2v", "2d+3d chipset, integrated ramdac" } ,
    { 0x3D3D, 0x000A, "8086", "Driver Ethernet Pci Ven 1969" } ,
    { 0x3D3D, 0x000C, "Permedia 3", "video card" } ,
    { 0x3D3D, 0x000D, "GLINT R4", "3D Accelerator" } ,
    { 0x3D3D, 0x000E, "GLINT Gamma G2", "" } ,
    { 0x3D3D, 0x0020, "0x0024", "3Dlabs Wildcat VP 880 Pro" } ,
    { 0x3D3D, 0x0030, "0x030000", "3Dlabs Wildcat Realizm 800" } ,
    { 0x3D3D, 0x0100, "Permedia II", "2D+3D Accelerator" } ,
    { 0x3D3D, 0x1004, "Permedia", "3D+3D Accelerator" } ,
    { 0x3D3D, 0x3D04, "Permedia", "2D+3D Accelerator" } ,
    { 0x3D3D, 0x3D07, "same as above?  I have no idea", "?" } ,
    { 0x3D3D, 0xFFFF, "GLint VGA", "" } ,
    { 0x4005, 0x0300, "3220", "PCI Audio Device" } ,
    { 0x4005, 0x0308, "3220", "PCI Audio Device + modem" } ,
    { 0x4005, 0x0309, "ALS300 ", "PCI Input Controller" } ,
    { 0x4005, 0x1064, "ALG2064", "GUI Accelerator" } ,
    { 0x4005, 0x2064, "<DELETE>", "GUI Accelerator" } ,
    { 0x4005, 0x2128, "ALG2364A", "GUI Accelerator" } ,
    { 0x4005, 0x2301, "ALG2301", "GUI Accelerator" } ,
    { 0x4005, 0x2302, "ALG2302", "GUI Accelerator" } ,
    { 0x4005, 0x2303, "AVG2302", "GUI Accelerator" } ,
    { 0x4005, 0x2364, "ALG2364", "GUI Accelerator" } ,
    { 0x4005, 0x2464, "ALG2464", "GUI Accelerator" } ,
    { 0x4005, 0x2501, "ALG2564A/25128A", "GUI Accelerator" } ,
    { 0x4005, 0x4000, "ALS4000", "Audio Chipset" } ,
    { 0x5333, 0x0551, "86C551", "Plato/PX" } ,
    { 0x5333, 0x5333, "S3 86c765", "via" } ,
    { 0x5333, 0x5631, "86C325", "Virge 3D " } ,
    { 0x5333, 0x8800, "86C866", "Vision 866 GUI Accelerator" } ,
    { 0x5333, 0x8801, "86C964", "Vision 964 GUI Accelerator" } ,
    { 0x5333, 0x8810, "86C732-P", "S3 TRIO32  IACB2  86C732-P" } ,
    { 0x5333, 0x8811, "8622mcq04", "Trio 64/64V" } ,
    { 0x5333, 0x8812, "86CM65?", "Aurora 64V+" } ,
    { 0x5333, 0x8813, "86C764", "Trio 32/64 GUI Accelerator v3" } ,
    { 0x5333, 0x8814, "86C767", "Trio 64UV+" } ,
    { 0x5333, 0x8815, "86CM66", "Aurora128" } ,
    { 0x5333, 0x883D, "86C988", "ViRGE/VX 3D GUI Accelerator" } ,
    { 0x5333, 0x8870, "Fire GL", "" } ,
    { 0x5333, 0x8880, "86C868", "Vision 868 GUI Accelerator VRAM rev. 0" } ,
    { 0x5333, 0x8881, "86C868", "Vision 868 GUI Accelerator VRAM rev. 1" } ,
    { 0x5333, 0x8882, "86C868", "Vision 868 GUI Accelerator VRAM rev. 2" } ,
    { 0x5333, 0x8883, "86C868", "Vision 868 GUI Accelerator VRAM rev. 3" } ,
    { 0x5333, 0x88B0, "86C928", "Vision 928 GUI Accelerator VRAM rev. 0" } ,
    { 0x5333, 0x88B1, "86C928", "Vision 928 GUI Accelerator VRAM rev. 1" } ,
    { 0x5333, 0x88B2, "86C928", "Vision 928 GUI Accelerator VRAM rev. 2" } ,
    { 0x5333, 0x88B3, "86C928", "Vision 928 GUI Accelerator VRAM rev. 3" } ,
    { 0x5333, 0x88C0, "86C864", "Vision 864 GUI Accelerator DRAM rev. 0" } ,
    { 0x5333, 0x88C1, "86C864", "Vision 864 GUI Accelerator DRAM rev. 1" } ,
    { 0x5333, 0x88C2, "86C864", "Vision 864 GUI Accelerator DRAM rev. 2" } ,
    { 0x5333, 0x88C3, "86C864", "Vision 864 GUI Accelerator DRAM rev. 3" } ,
    { 0x5333, 0x88D0, "86C964", "Vision 964 GUI Accelerator VRAM rev. 0" } ,
    { 0x5333, 0x88D1, "86C964", "Vision 964-P GUI Accelerator VRAM rev. 1" } ,
    { 0x5333, 0x88D2, "86C964", "Vision 964-P GUI Accelerator DRAM rev 2" } ,
    { 0x5333, 0x88D3, "86C964", "Vision 964-P GUI Accelerator VRAM rev. 3" } ,
    { 0x5333, 0x88F0, "86C968", "Vision 968 GUI Accelerator VRAM rev. 0" } ,
    { 0x5333, 0x88F1, "86C968", "Vision 968 GUI Accelerator VRAM rev. 1" } ,
    { 0x5333, 0x88F2, "86C968", "Vision 968 GUI Accelerator VRAM rev. 2" } ,
    { 0x5333, 0x88F3, "86C968", "Vision 968 GUI Accelerator VRAM rev. 3" } ,
    { 0x5333, 0x8900, "86C775", "Trio64V2/DX" } ,
    { 0x5333, 0x8901, "pci\\ven_5333dev_8C2E&SUBSYS_00011179&REV_05\\4&74C6", "S3 trio64uv+ for windows 7" } ,
    { 0x5333, 0x8902, "86C551", "SMA Family" } ,
    { 0x5333, 0x8903, "", "TrioV Family" } ,
    { 0x5333, 0x8904, "86C365/366", "Trio3D QFP/BGA" } ,
    { 0x5333, 0x8905, "86c765", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x8906, "86c765", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x8907, "86c765", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x8908, "9711 MCN74", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x8909, "7699688", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x890A, "0x00091011", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x890B, "9726 c19394.00", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x890C, "86C765", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x890D, "86C765 Trio64V+ compatible", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x890E, "9711 MCN74", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x890F, "86c765", "86C765 Trio64V+ compatible" } ,
    { 0x5333, 0x8A01, "86C375/86C385", "ViRGE /DX & /GX" } ,
    { 0x5333, 0x8A10, "86C357", "ViRGE /GX2" } ,
    { 0x5333, 0x8A11, "86C359", "ViRGE /GX2+ Macrovision" } ,
    { 0x5333, 0x8A12, "86C359", "ViRGE /GX2+" } ,
    { 0x5333, 0x8A13, "86C368", "Trio3D2x & Trio3D2x+ AGP / Trio3D2x & Trio3D2x+ 8MB" } ,
    { 0x5333, 0x8A20, "86C391", "S3savage3D" } ,
    { 0x5333, 0x8A21, "86C390", "Savage3D/MV" } ,
    { 0x5333, 0x8A22, "86c398", "Savage 4" } ,
    { 0x5333, 0x8A23, "86C394-397", "Savage 4" } ,
    { 0x5333, 0x8A25, "86C370", "Savage4" } ,
    { 0x5333, 0x8A26, "86C395B", "ProSavage" } ,
    { 0x5333, 0x8C00, "85C260", "ViRGE/M3 (ViRGE/MX)" } ,
    { 0x5333, 0x8C01, "86C260", "ViRGE/M5 (ViRGE/MX)" } ,
    { 0x5333, 0x8C02, "86C240", "ViRGE/MXC" } ,
    { 0x5333, 0x8C03, "86C280", "ViRGE /MX+mv" } ,
    { 0x5333, 0x8C10, "86C270/274/290/294", "Savage MX/IX/MX+MV/IX+MV" } ,
    { 0x5333, 0x8C12, "86C270/274/290/294", "Savage MX/IX/MX+MV/IX+MV" } ,
    { 0x5333, 0x8C13, "82C294", "SAVAGE IX" } ,
    { 0x5333, 0x8C22, "86C508", "SuperSavage 128/MX" } ,
    { 0x5333, 0x8C2A, "86C544", "SuperSavage 128/IX" } ,
    { 0x5333, 0x8C2B, "86C553", "SuperSavage 128/IX DDR" } ,
    { 0x5333, 0x8C2C, "86C564", "SuperSavage/IX" } ,
    { 0x5333, 0x8C2D, "86C573", "SuperSavage/IX DDR" } ,
    { 0x5333, 0x8C2E, "86C584", "SuperSavage/IXC SDRAM" } ,
    { 0x5333, 0x8C2F, "86C594", "SuperSavage/IXC DDR" } ,
    { 0x5333, 0x8D01, "86C380/381", "Twister/Twister T" } ,
    { 0x5333, 0x8D02, "86c387", "Twister K" } ,
    { 0x5333, 0x8D04, "86C410", "ProSavage DDR P4X333" } ,
    { 0x5333, 0x8E00, "86C777/787", "DeltaChrome S8/F1" } ,
    { 0x5333, 0x8E01, "86C732", "DeltaChromeX9m" } ,
    { 0x5333, 0x9102, "86c410", "Inno Savage 2000" } ,
    { 0x5333, 0x9876, "86C390", "Savage3D/MV" } ,
    { 0x5333, 0xCA00, "86C617", "SonicVibes PCI Audio Accelerator" } ,
    { 0x165F, 0x2000, "XILINX SPARTAN", "16 Channel Audio Capture Card" } ,
    { 0x8086, 0x27B8, "82801GB/GR", "Intel(R) 82801GB/GR (ICH7 Family) LPC Interface Controller" } ,
    { 0x8086, 0x0004, "0x05971028", "IUSB3\\ROOT" } ,
    { 0x8086, 0x0008, "", "Extended Express System Support Ctrlr" } ,
    { 0x8086, 0x0011, "0x108D", "Ethernet Controller" } ,
    { 0x8086, 0x0042, "Intel graphics", "Intel Q57/H55 Clarkdale (Onboard on D2912-A1x)" } ,
    { 0x8086, 0x0044, "0044", "Intel(R) Processor DRAM Controller" } ,
    { 0x8086, 0x0046, "Intel(R) HD Graphics (Core i3)", "Intel(R) HD Graphics" } ,
    { 0x8086, 0x0054, "not known", "Audio" } ,
    { 0x8086, 0x0082, "6205", "Centrino Advanced-N 6205 " } ,
    { 0x8086, 0x0083, "Mobile Intel� 5 Series Chipset", "Intel Centrino Wireless-N 1000" } ,
    { 0x8086, 0x0084, "Intel PROSet WiFi 1000", "Intel Wireless Link WiFi 1000, download -> http://downloadmirror.intel.com/20791/eng/Wireless_14.3.0" } ,
    { 0x8086, 0x0085, "0x0280", "Intel Centrino(R) Advanced-N 6205" } ,
    { 0x8086, 0x0087, "1306", "00E1" } ,
    { 0x8086, 0x008A, "???", "Intel Centrino Wireless-N1030" } ,
    { 0x8086, 0x008B, "Intel Wireless-N 1030", "Intel(R) Centrino(R) Wireless-N 1030 " } ,
    { 0x8086, 0x0091, "622ANHW", "Intel� Centrino� Advanced-N 6230" } ,
    { 0x8086, 0x0100, "0100", "2nd Generation Intel(R) Core(TM) Processor Family DRAM Controller" } ,
    { 0x8086, 0x0102, "0001", "Intel HD Graphics 3000" } ,
    { 0x8086, 0x0104, "2nd Gen Intel(R) Core(TM) Processor Family", "DRAM Controller (Host Bus Controller)" } ,
    { 0x8086, 0x0106, "HD Graphics 3000/2000", "asus x501a" } ,
    { 0x8086, 0x010A, "010A", "Lenovo TS130 Intel Video Adapter HD" } ,
    { 0x8086, 0x0111, "82915", "Intel Graphics Conroller" } ,
    { 0x8086, 0x0116, "intel core i3", "Intel HD Graphics 3000" } ,
    { 0x8086, 0x0123, "0300", "hardwareids" } ,
    { 0x8086, 0x0152, "Intel HD Graphics 2500", "3rd Generation Intel Core Processors with Intel HD Graphics 2500" } ,
    { 0x8086, 0x0153, "Intel� Dynamic Platform and Thermal Framework Driv", "Use the Link, choose Win7 64Bit -> Others -> Intel DPTF Driver -> Global. Then download, install and" } ,
    { 0x8086, 0x0154, "0x01548086", " 3rd Gen Core processor DRAM Controller (rev 09)" } ,
    { 0x8086, 0x0162, "Core I5, Core I7, Ivy Bridge", "Graphics embedded" } ,
    { 0x8086, 0x0166, "I3", "Intel(R) HD Graphics 4000" } ,
    { 0x8086, 0x0189, "Intel Centrino Wireless-N 1030 Bluetooth Adapter", "Intel Centrino Wireless Bluetooth 3.0 + High Speed Adapter" } ,
    { 0x8086, 0x027AE, "82945GM", "Mobile Intel(R) 945 Express Chipset Family" } ,
    { 0x8086, 0x027D8, "293esd", "High Definition Audio Controller" } ,
    { 0x8086, 0x0283E, "AA01211025", "Intel(R) ICH8 Family SMBus Controller" } ,
    { 0x8086, 0x0308, "3220", "PCI Audio Device + modem" } ,
    { 0x8086, 0x0309, "80303", "I/O Processor PCI-to-PCI Bridge Unit" } ,
    { 0x8086, 0x030D, "80312", "I/O Companion Unit PCI-to-PCI Bridge" } ,
    { 0x8086, 0x0318, "80219", "General Purpose PCI Processor Address Translation Unit" } ,
    { 0x8086, 0x0319, "80219", "General Purpose PCI Processor Address Translation Unit" } ,
    { 0x8086, 0x0326, "670xPXH", "I/OxAPIC Interrupt Controller" } ,
    { 0x8086, 0x0327, "6700PXH", "I/OxAPIC Interrupt Controller B" } ,
    { 0x8086, 0x0329, "6700PXH", "PCI Express-to-PCI Express Bridge A" } ,
    { 0x8086, 0x032A, "6700PXH", "PCI Express-to-PCI Express Bridge B" } ,
    { 0x8086, 0x032C, "6702PXH", "PCI Express-to-PCI Express Bridge" } ,
    { 0x8086, 0x0330, "80332", "A-Segment Bridge" } ,
    { 0x8086, 0x0331, "80332", "A-Segment IOAPIC" } ,
    { 0x8086, 0x0332, "80332", "B-Segment Bridge" } ,
    { 0x8086, 0x0333, "80332", "B-Segment IOAPIC" } ,
    { 0x8086, 0x0334, "80332", "Address Translation Unit" } ,
    { 0x8086, 0x0335, "80331", "PCI-X Bridge" } ,
    { 0x8086, 0x0336, "80331", "Address Translation Unit (ATU)" } ,
    { 0x8086, 0x0340, "41210", "Serial to Parallel PCI Bridge A" } ,
    { 0x8086, 0x0341, "41210", "Serial to Parallel PCI Bridge B" } ,
    { 0x8086, 0x0370, "80333", "Segment-A PCI Express-to-PCI Express Bridge" } ,
    { 0x8086, 0x0371, "80333", "A-Bus IOAPIC" } ,
    { 0x8086, 0x0372, "0893", "network controller" } ,
    { 0x8086, 0x0373, "80333", "B-Bus IOAPIC" } ,
    { 0x8086, 0x0374, "80333", "Address Translation Unit" } ,
    { 0x8086, 0x0401, "266E", "P040100" } ,
    { 0x8086, 0x0402, "ACPI x86-based PC", "HD Graphics 4200" } ,
    { 0x8086, 0x0412, "Intel HD Graphics 4600", "ven_8086&dev_0412" } ,
    { 0x8086, 0x0416, "SUBSYS_197A103C", "Intel(R) HD Graphics 4600" } ,
    { 0x8086, 0x0482, "82375MB", "PCI\\VEN_8086&DEV_3B64&SUBSYS_20391B0A&REV_06" } ,
    { 0x8086, 0x0483, "82424TX/ZX", "CPU (i486) Bridge (Saturn)" } ,
    { 0x8086, 0x0484, "82378ZB/IB", "SIO ISA Bridge" } ,
    { 0x8086, 0x0486, "PCI\\VEN_8086&DEV_1C22&SUBSYS_2AC2103C&REV_04", "HP Pro 3400  XPx32/7x32 drivers" } ,
    { 0x8086, 0x0493, "0x1502", "Intel 82579 Gigabit Network Card" } ,
    { 0x8086, 0x04A3, "82434bX/zX", "Mercury/Neptune Cache/DRAM Controller" } ,
    { 0x8086, 0x0500, "E8870", "Processor Bus Controller" } ,
    { 0x8086, 0x0501, "E8870", "Memory Controller" } ,
    { 0x8086, 0x0502, "E8870", "Scalability Port 0" } ,
    { 0x8086, 0x0503, "E8870", "Scalability Port 1 / Glob. Perf. Monitor" } ,
    { 0x8086, 0x0510, "E8870IO", "Hub Interface Port 0 (8-bit compatible)" } ,
    { 0x8086, 0x0511, "E8870IO", "Hub Interface Port 2" } ,
    { 0x8086, 0x0512, "E8870IO", "Hub Interface Port 2" } ,
    { 0x8086, 0x0513, "E8870IO", "Hub Interface Port 3" } ,
    { 0x8086, 0x0514, "E8870IO", "Hub Interface Port 4" } ,
    { 0x8086, 0x0515, "E8870IO", "Server I/O Hub (SIOH)" } ,
    { 0x8086, 0x0516, "E8870IO", "Reliabilty, Availability, Serviceability" } ,
    { 0x8086, 0x0530, "E8870SP", "Scalability Port 0" } ,
    { 0x8086, 0x0531, "E8870SP", "Scalability Port 1" } ,
    { 0x8086, 0x0532, "E8870SP", "Scalability Port 2" } ,
    { 0x8086, 0x0533, "E8870SP", "Scalability Port 3" } ,
    { 0x8086, 0x0534, "E8870SP", "Scalability Port 4" } ,
    { 0x8086, 0x0535, "E8870SP", "Scalability Port 5" } ,
    { 0x8086, 0x0536, "E8870SP", "Scalability Port Switch Global Registers" } ,
    { 0x8086, 0x0537, "E8870SP", "Interleave Configuration Registers" } ,
    { 0x8086, 0x0600, "1043", "Storage RAID Controller" } ,
    { 0x8086, 0x0780, "3.0/2.0", "Intel B75 Express Chipset" } ,
    { 0x8086, 0x0800, "10B01734", "pci/ven_8086&dev_27da&subsys_30b2103c&rev_02\\3&b1bfb68&0&fb" } ,
    { 0x8086, 0x0885, "612BNXHMW", "Intel Centrino Wireless-N + WiMAX 6150" } ,
    { 0x8086, 0x0887, "Intel Centrino Chipset", "Intel Centrino Wireless-N 2230" } ,
    { 0x8086, 0x0888, "0", "Intel Centrino Wireless-N 2230" } ,
    { 0x8086, 0x088E, "40608086", "Intel Centrino Advanced N 6235" } ,
    { 0x8086, 0x0890, "Intel", "Network Controller" } ,
    { 0x8086, 0x0894, "86881", "Centrino Wireless-N 105" } ,
    { 0x8086, 0x0896, "Wireless-N 130", "Intel Centrino Wireless-N 130" } ,
    { 0x8086, 0x08AE, "802.11n", "Intel Centrino Wireless-N 100" } ,
    { 0x8086, 0x08B1, "PCI\\VEN_8086&DEV_08B1", "Intel(R) Dual Band Wireless-AC 7260" } ,
    { 0x8086, 0x08B3, "?", "Intel Dual Band Wireless-AC 3160" } ,
    { 0x8086, 0x0960, "80960RP", "i960 RP Microprocessor/Bridge" } ,
    { 0x8086, 0x0962, "80960RM/RN", "i960RM/RN Microprocessor/Bridge" } ,
    { 0x8086, 0x0964, "80960RP", "i960 RP Microprocessor Bridge" } ,
    { 0x8086, 0x0A03, "0A03", "Intel(R) Dynamic Platform and Thermal Framework Processor Participant" } ,
    { 0x8086, 0x0A04, "0A04", "PCI standard host CPU bridge" } ,
    { 0x8086, 0x0A0C, "0A0C", "High Definition Audio Controller" } ,
    { 0x8086, 0x0A16, "3000", "Intel HD Graphics Controller" } ,
    { 0x8086, 0x0A1E, "0A1", "Intel(R) HD Graphics" } ,
    { 0x8086, 0x0BE1, "0000000", "Intel Graphics Media Accelerator 3600 Series" } ,
    { 0x8086, 0x0C00, "0C00", "Intel(R) 4th Gen Core processor DRAM Controller" } ,
    { 0x8086, 0x0C05, "V9201015", "Intel(R) 6 Series/C200 Series Chipset Family SMBus Controller" } ,
    { 0x8086, 0x0F00, "0F00", "Intel(R) Pentium(R)/Celeron(R) processor N-/J- series SoC Transaction Router" } ,
    { 0x8086, 0x0F04, "0F04", "High Definition Audio Controller" } ,
    { 0x8086, 0x0F12, "0F12", "Intel(R) Pentium(R)/Celeron(R) processor N-/J- series Platform Control Unit - SMBus Port" } ,
    { 0x8086, 0x0F18, "0F18", "Intel(R) Trusted Execution Engine Interface" } ,
    { 0x8086, 0x0F1C, "0F1C", "Intel(R) Pentium(R)/Celeron(R) processor N-/J- series Platform Conrol Unit LPC: Bridge to Intel Lega" } ,
    { 0x8086, 0x0F23, "0F23", "Intel(R) Pentium(R)/Celeron(R) processor N-/J- series AHCI" } ,
    { 0x8086, 0x0f31, "5200", "Iris pro 5200" } ,
    { 0x8086, 0x0F35, "0F35", "Intel(R) USB 3.0 eXtensible Host Controller" } ,
    { 0x8086, 0x0F48, "0F48", "Intel(R) Pentium(R)/Celeron(R) processor N-/J- series PCI Express Root Port" } ,
    { 0x8086, 0x0F4A, "0F4A", "Intel(R) Pentium(R)/Celeron(R) processor N-/J- series PCI Express Root Port" } ,
    { 0x8086, 0x100, "0100", "2nd Generation Intel(R) Core(TM) Processor Family DRAM Controller" } ,
    { 0x8086, 0x1000, "82542", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1001, "2572", "10/100/1000 Ethernet Controller (Fiber)" } ,
    { 0x8086, 0x1002, "", "Pro 100 LAN+Modem 56 CardBus II" } ,
    { 0x8086, 0x1004, "82543GC", "Gigabit Ethernet Controller (Copper)" } ,
    { 0x8086, 0x1008, "82544EI/GC", "Gigabit Ethernet Controller (Copper)" } ,
    { 0x8086, 0x1009, "82845G/GL/GV/GE/PE Integrated Graphics Device", "Intel" } ,
    { 0x8086, 0x100C, "82543EI/GC", "Gigabit Ethernet Controller (Copper)" } ,
    { 0x8086, 0x100D, "82544GC", "Gigabit Ethernet Controller (LOM)" } ,
    { 0x8086, 0x100E, "02000", "Intel Pro 1000/MT" } ,
    { 0x8086, 0x100F, "82545EM", "Intel(R) PRO/1000 MT Network Connection" } ,
    { 0x8086, 0x1010, "82546EB", "Dual Port Gigabit Ethernet Controller (Copper)" } ,
    { 0x8086, 0x1011, "82545EM", "Gigabit Ethernet Controller (Fiber)" } ,
    { 0x8086, 0x1012, "82546EB", "Dual Port Gigabit Ethernet Controller (Fiber)" } ,
    { 0x8086, 0x1013, "82541EI", "Gigabit Ethernet Controller (Copper)" } ,
    { 0x8086, 0x1014, "82541ER", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1015, "82540EM", "Gigabit Ethernet Controller (LOM)" } ,
    { 0x8086, 0x1016, "82540EP", "Gigabit Ethernet Controller (LOM)" } ,
    { 0x8086, 0x1017, "82540EP", "Gigabit Ethernet Controller (LOM)" } ,
    { 0x8086, 0x1018, "82541EI", "PRO/1000 MT Mobile connection" } ,
    { 0x8086, 0x1019, "82547EI", "Gigabit Ethernet Controller (LOM)" } ,
    { 0x8086, 0x101A, "82547EI", "Gigabit Ethernet Controller (LOM)" } ,
    { 0x8086, 0x101d, "82546EB", "Dual Port Gigabit Ethernet Controller" } ,
    { 0x8086, 0x101E, "82540EP", "Gigabit Ethernet Controller (Mobile)" } ,
    { 0x8086, 0x1026, "82545ep", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1027, "82545GM", "Gigabit Ethernet Controller (Fiber)" } ,
    { 0x8086, 0x1028, "82545GM", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1029, "82559", "Fast Ethernet PCI/CardBus Controller" } ,
    { 0x8086, 0x1030, "82801", "PCI Networking device" } ,
    { 0x8086, 0x1031, "82801CAM", "PRO/100 VE Network Connection" } ,
    { 0x8086, 0x1032, "82801CAM", "PRO/100 VE Network Connection" } ,
    { 0x8086, 0x1033, "PB 642365-003", "multimedia video controller" } ,
    { 0x8086, 0x1034, "82801CAM", "PRO/100 VM Network Connection" } ,
    { 0x8086, 0x1035, "82562EH", "Phoneline Network Connection" } ,
    { 0x8086, 0x1036, "82562EH", "Phoneline Network Connection" } ,
    { 0x8086, 0x1037, "82801CAM", "LAN Controller" } ,
    { 0x8086, 0x1038, "82801CAM", "PRO/100 VM/KM Network Connection" } ,
    { 0x8086, 0x1039, "10011734", " 82562" } ,
    { 0x8086, 0x103A, "82801DB", "LAN Controller with 82562ET/EZ (CNR) PHY" } ,
    { 0x8086, 0x103B, "82801DB", "LAN Controller with 82562EM/EX PHY" } ,
    { 0x8086, 0x103C, "82801DB", "LAN Controller with 82562EM/EX (CNR) PHY" } ,
    { 0x8086, 0x103D, "05221014", "PRO/100 VE Network Connection" } ,
    { 0x8086, 0x103E, "82801DB", "PRO/100 VM Network Connection" } ,
    { 0x8086, 0x1040, "536EP", "V.92 PCI (DSP) Data Fax Modema" } ,
    { 0x8086, 0x1042, "8086", "PRO/Wireless 2011 LAN PCI Card" } ,
    { 0x8086, 0x1043, "82801", "Intel(R) PRO/Wireless 2100 LAN Card Driver" } ,
    { 0x8086, 0x1048, "82597EX", "10 Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1049, "82566MM NIC", "Gigabit Network Connection Interface Controller" } ,
    { 0x8086, 0x104A, "Intel 82566DM Gigabit Ethernet", "gigabit ethernet" } ,
    { 0x8086, 0x104B, "82566DC", "Gigabit Ethernet" } ,
    { 0x8086, 0x104D, "82566MC", "Intel Gigabit 82566MC" } ,
    { 0x8086, 0x1050, "82562EZ", "PRO/100 VE Network Connection" } ,
    { 0x8086, 0x1051, "82801EB/ER", "PRO/100 VE Network Connection" } ,
    { 0x8086, 0x1052, "82801EB/ER", "PRO/100 VM Network Connection" } ,
    { 0x8086, 0x1053, "82801EB/ER", "PRO/100 VM ork NetConnectionw" } ,
    { 0x8086, 0x1054, "82801EB/ER", "PRO/100 VE Network Connection (mobile)" } ,
    { 0x8086, 0x1055, "82801EB/ER", "PRO/100 VM Network Connection (mobile)" } ,
    { 0x8086, 0x1059, "82551QM", "Fast Ethernet PCI/CardBus Controller" } ,
    { 0x8086, 0x105E, "82579V", "Intel(R) PRO/1000 PT Dual Port Server Adapter" } ,
    { 0x8086, 0x1064, "Intel Pro VE", "82562EZ PLC" } ,
    { 0x8086, 0x1065, "82801FB/FR/FW/FRW", "LAN Controller Intel Corporation 82562ET/EZ/GT/GZ - PRO/100 VE Ethernet Controller" } ,
    { 0x8086, 0x1068, "82562", "1068h 82562ET/EZ/GT/GZ PRO/100 VE Ethernet Controller" } ,
    { 0x8086, 0x1075, "82547EI", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1076, "82541EI", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1077, "82547EI", "Gigabit Ethernet Controller (Mobile)" } ,
    { 0x8086, 0x1078, "82541ER", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x1079, "82546EB", "Dual Port Gigabit Ethernet Controller" } ,
    { 0x8086, 0x107A, "82546EB", "Dual Port Gigabit Ethernet Controller (Fiber)" } ,
    { 0x8086, 0x107B, "82546EB", "Dual Port Gigabit Ethernet Controller (Copper)" } ,
    { 0x8086, 0x107C, "82541PI", "Gigabit Ethernet Controller (Copper) rev 5" } ,
    { 0x8086, 0x1080, "0321CGEA04", "FA82537EP - Intel 537EP V.92 (PCI)  modem" } ,
    { 0x8086, 0x108B, "PC82573V", "Intel network controller (PCIE Gigabit Ethernet)" } ,
    { 0x8086, 0x108c, "82573E", "Intel Corporation 82573E Gigabit Ethernet Controller (Copper)" } ,
    { 0x8086, 0x108E, "ICH7R", "Intel(R) Active Management Technology - KCS" } ,
    { 0x8086, 0x108F, "ICH7R", "Intel(R) Active Management Technology - SOL" } ,
    { 0x8086, 0x1092, "27DA", "PRO/100 VE Network Controller" } ,
    { 0x8086, 0x1094, "Onboard - Intel PRO 100/VE nic", "get PRO2KXP.exe from Intel" } ,
    { 0x8086, 0x1096, "Intel PRO/1000 EB", "Intel PRO/1000 EB" } ,
    { 0x8086, 0x109A, "82573L", "Intel PRO/1000 PL Network Adaptor" } ,
    { 0x8086, 0x109c, "e1qexpress", "HP E1Q Express" } ,
    { 0x8086, 0x10a7, "82575 ?", "82575EB Gigabit Network Connection" } ,
    { 0x8086, 0x10a9, "82575 ?", "82575EB Gigabit Backplane Connection" } ,
    { 0x8086, 0x10b5, "82546GB", "Quad Port Gigabit Ethernet Controller" } ,
    { 0x8086, 0x10b9, "82572GI", "Intel PRO/1000 PT Desktop" } ,
    { 0x8086, 0x10BD, "82566DM", "Intel 82566DM Gigabit Ethernet Adapter" } ,
    { 0x8086, 0x10C0, "8082", "Intel(R) 82562V-2 10/100 Network Connection" } ,
    { 0x8086, 0x10c4	, "82562GT", "Intel 82562GT 10/100 Network Controller" } ,
    { 0x8086, 0x10c4, "82562EZ PLC", "Intel 82562GT 10/100 Network Controller" } ,
    { 0x8086, 0x10c9, "82576?", "82576 Gigabit ET Dual Port Server Adapter" } ,
    { 0x8086, 0x10cd, "82567", "Intel(R) 82567LF-2 Gigabit Network Connection" } ,
    { 0x8086, 0x10CE, "82567V-2", "Intel 82567V-2 Gigabit Network Connection" } ,
    { 0x8086, 0x10d3, "82574L", "Intel� 82574L Gigabit Ethernet Controller" } ,
    { 0x8086, 0x10d6, "82575", "82566 DM-2-gigabyte" } ,
    { 0x8086, 0x10DE, "02761028", "Intel Gigabit network connection" } ,
    { 0x8086, 0x10e6, "82576 ?", "82576 Gigabit Network Connection" } ,
    { 0x8086, 0x10e7, "82576 ?", "82576 Gigabit Network Connection" } ,
    { 0x8086, 0x10E8, "82576", "E64750-xxx Intel Gigabit ET Quad Port Server Adapter" } ,
    { 0x8086, 0x10EA, "82577LM", "Intel 82577LM Gigabit LAN Controller" } ,
    { 0x8086, 0x10EC, "Realtek AC97Audio", "Realtek 171 High Definition Audio" } ,
    { 0x8086, 0x10EF, "Intel� 82578DM Gigabit Ethernet Controller", "Intel� 82578DM Gigabit Ethernet Controller" } ,
    { 0x8086, 0x10F0, "82578", "Intel(R) 82578DC Gigabit NIC" } ,
    { 0x8086, 0x10F5, "82567LM", "Intel�  82567LM-2 Gigabit Network Connection" } ,
    { 0x8086, 0x10fb, "82599", "10 Gb Ethernet controller" } ,
    { 0x8086, 0x1100, "82815/EP/P", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x1101, "82815/EP/P", "AGP Bridge" } ,
    { 0x8086, 0x1102, "82915GV", "Internal Graphics Device" } ,
    { 0x8086, 0x1110, "82815", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x1112, "82815", "Internal Graphics Device" } ,
    { 0x8086, 0x1120, "82815", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x1121, "82815", "AGP Bridge" } ,
    { 0x8086, 0x112D, "2200", "pci simple controller " } ,
    { 0x8086, 0x1130, "82815/82815EM/EP", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x1131, "82815/82815EM/EP", "AGP Bridge" } ,
    { 0x8086, 0x1132, "65416http://www.pcidatabase.com/update_device.php?", "Internal Graphics Device [810/815 chipset AGP]" } ,
    { 0x8086, 0x1161, "82806AA", "I/O APIC Device" } ,
    { 0x8086, 0x1162, "BECC", "XScale 80200 Companion Chip (FPGA)" } ,
    { 0x8086, 0x1179, "82546EB", "Dual Port Gigabit Ethernet Controller" } ,
    { 0x8086, 0x12 , "03491025", "00" } ,
    { 0x8086, 0x1200, "IXP1200", "Network Processor" } ,
    { 0x8086, 0x1209, "8255xER/IT", "Fast Ethernet Controller for xp pc" } ,
    { 0x8086, 0x1221, "82092AA", "PCMCIA Bridge" } ,
    { 0x8086, 0x1222, "2792", "IDE Ctrlr" } ,
    { 0x8086, 0x1223, "Conexant Cx20468 @ Intel 82801FB ICH6 - AC'97 Audi", "Audio Controller" } ,
    { 0x8086, 0x1225, "82452KX/GX", "Orion Extended Express CPU to PCI Bridge" } ,
    { 0x8086, 0x1226, "82596", "EtherExpress PRO/10" } ,
    { 0x8086, 0x1227, "82801db ich4", "LAN Controller with 82562EM" } ,
    { 0x8086, 0x1228, "EE PRO/100 Smart", "Intelligent 10/100 Fast Ethernet Adapter" } ,
    { 0x8086, 0x1229, "1e22", "Intel(R) PRO/100 http://ftp.dell.com/network/R56484.EXE" } ,
    { 0x8086, 0x122D, "82437FX", "System Controller (TSC)" } ,
    { 0x8086, 0x122E, "82371AB/EB PCI", "PCI to ISA Bridge (Triton)" } ,
    { 0x8086, 0x1230, "FW82371AB", "IDE Interface (Triton)" } ,
    { 0x8086, 0x1231, "16345", "DSVD Modem" } ,
    { 0x8086, 0x1234, "82371MX", "PCI to ISA Bridge" } ,
    { 0x8086, 0x1235, "82439TX", "Mobile System Controller (MTSC)" } ,
    { 0x8086, 0x1237, "82440LX/EX", "PCI & Memory" } ,
    { 0x8086, 0x1239, "82371FB", "IDE Interface (Triton)" } ,
    { 0x8086, 0x123B, "82380PB", "PCI to PCI Docking Bridge" } ,
    { 0x8086, 0x123C, "82380AB", "Mobile PCI-to-ISA Bridge (MISA)" } ,
    { 0x8086, 0x123D, "683053", "Programmable Interrupt Device" } ,
    { 0x8086, 0x123E, "82466GX", "Integrated Hot-Plug Controller (IHPC)" } ,
    { 0x8086, 0x123F, "82466GX", "Integrated Hot-Plug Controller (IHPC)" } ,
    { 0x8086, 0x124, "PCI\\VEN_8086&DEV_9C22", "24c6" } ,
    { 0x8086, 0x1240, "82752", "AGP Graphics Accelerator" } ,
    { 0x8086, 0x124B	, "293esd", "Mobile PCI-to-PCIsdsdsdI2)" } ,
    { 0x8086, 0x124B, "PCI\\VEN_8086&DEV_2E17&CC_070002", "24c6" } ,
    { 0x8086, 0x124C, "9776", "Mobile PCI-to-PCI Bridge (MPCI2)" } ,
    { 0x8086, 0x1250, "82430HX", "System Controller (TXC)" } ,
    { 0x8086, 0x12D8, "92XX", "SIGMATEL STAC 92XX C-Major HD Audio" } ,
    { 0x8086, 0x1360, "82806AA", "Hub Interface to PCI Bridge" } ,
    { 0x8086, 0x1361, "82806AA", "Advanced Interrupt Controller" } ,
    { 0x8086, 0x13ca, "VVVV", "VVVVVV" } ,
    { 0x8086, 0x1460, "82870P2", "Hub Interface-to-PCI Bridge" } ,
    { 0x8086, 0x1461, "14611014", "I/OxAPIC Interrupt Controller" } ,
    { 0x8086, 0x1462, "82870P2", "Hot Plug Controller" } ,
    { 0x8086, 0x1502, "0x04931028", "Intel 82579LM Gigabit Network Card" } ,
    { 0x8086, 0x1503, "Intel 82579v", "Gigabit Network Connection" } ,
    { 0x8086, 0x150a, "82576 ?", "82576NS Gigabit Ethernet Controller" } ,
    { 0x8086, 0x150C, "82583V", "Intel� 82583V Gigabit Ethernet  Controller" } ,
    { 0x8086, 0x150d, "82576 ?", "82576 Gigabit Backplane Connection" } ,
    { 0x8086, 0x150e, "82580 ?", "82580 Gigabit Network Connection" } ,
    { 0x8086, 0x150f, "82580 ?", "82580 Gigabit Fiber Network Connection" } ,
    { 0x8086, 0x1510, "82580 ?", "82580 Gigabit Backplane Connection" } ,
    { 0x8086, 0x1511, "82580 ?", "82580 Gigabit SFP Connection" } ,
    { 0x8086, 0x1516, "82580 ?", "82580 Gigabit Network Connection" } ,
    { 0x8086, 0x1518, "82576 ?", "82576NS SerDes Gigabit Network Connection" } ,
    { 0x8086, 0x1521, "I350", "i350 Gigabit Network Connection" } ,
    { 0x8086, 0x1525, "82567V-4", "Intel 82567V-4 Gigabit Network Connection" } ,
    { 0x8086, 0x1526, "82576", "Intel Gigabit ET2 Quad Port Server Adapter" } ,
    { 0x8086, 0x1533, "210", "Intel I210 Gigabit Network Connection" } ,
    { 0x8086, 0x153A, "USB\\VID_0424&PID_2504&REV_0001", "Intel I217-LM Ethernet Connection" } ,
    { 0x8086, 0x153B, "I217-V", "Intel Gigabit Ethernet Controller I217-V" } ,
    { 0x8086, 0x1559, "0x8CBA", "Intel Ethernet I218-V" } ,
    { 0x8086, 0x155a, "I218LM", "Gigabit Ethernet" } ,
    { 0x8086, 0x15A1, "0x8CBA", "Intel� Ethernet Connection I218-V" } ,
    { 0x8086, 0x15A2, "I218LM", "Gigabit Ethernet" } ,
    { 0x8086, 0x167D, "2200bg", "PCI Simple Communications Controller" } ,
    { 0x8086, 0x1960, "80960RP", "i960RP Microprocessor" } ,
    { 0x8086, 0x1962, "???", "Promise SuperTrak SX6000 IDE RAID Controller" } ,
    { 0x8086, 0x1A12, "???", "Eicon DIVA Server Voice PRI 2.0 (PCI)" } ,
    { 0x8086, 0x1A13, "???", "Eicon DIVA Server Voice PRI 2.0 (PCI)" } ,
    { 0x8086, 0x1A20, "82840", "" } ,
    { 0x8086, 0x1A21, "82840", "Host-Hub Interface A Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x1A22, "82840", "Host to I/O Hub Bridge (Quad PCI)" } ,
    { 0x8086, 0x1A23, "82840", "AGP Bridge" } ,
    { 0x8086, 0x1A24, "82840", "Hub Interface B Bridge" } ,
    { 0x8086, 0x1A30, "82845G[GL/GV/GE/PE]", "Host-Hub Interface Bridge" } ,
    { 0x8086, 0x1A31, "82845[MP/MZ]", "AGP Bridge" } ,
    { 0x8086, 0x1A38, "5000P", "5000 Series Chipset DMA Engine" } ,
    { 0x8086, 0x1A3E, "Z77", "C216 Chipset - Platform controller hub" } ,
    { 0x8086, 0x1c02, "1C02", "Intel(R) 6/C200 Series Chipset Family 6 Port SATA AHCI Controller" } ,
    { 0x8086, 0x1c02, "8086&dev_1c02", "Intel(R) Desktop/Workstation/Server Express Chipset SATA AHCI Controller" } ,
    { 0x8086, 0x1C03, "Intel(R) Mobile Express Chipset SATA AHCI Controll", "Intel(R) CPT Chipset Family 6 Port SATA AHCI Controller " } ,
    { 0x8086, 0x1C10, "1C10", "Intel(R) 6/C200 Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x1C18, "1C18", "Intel(R) 6/C200 Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x1C1A, "1C3Afsfsdf", "1C3Asfsfsdf" } ,
    { 0x8086, 0x1C1C, "1C1C", "Intel(R) 6/C200 Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x1C1E, "1C1E", "Intel(R) 6/C200 Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x1C20, "1C20", "High Definition Audio Controller" } ,
    { 0x8086, 0x1C22, "win7 64-bit ", "Intel(R) 6 Series/C200 Series Chipset Family SMBus Controller" } ,
    { 0x8086, 0x1C26, "HM65", "Intel(R) 6/C200 Series Chipset Family USB Enhanced Host Controller" } ,
    { 0x8086, 0x1C2D, "1C2D", "Intel(R) 6/C200 Series Chipset Family USB Enhanced Host Controller" } ,
    { 0x8086, 0x1c34, "0780", "pci simple communications controller" } ,
    { 0x8086, 0x1c3a, "161C103C", "Intel Management Engine Interface" } ,
    { 0x8086, 0x1c3a, "161C103C", "Intel Management Engine Interface" } ,
    { 0x8086, 0x1C3b, "111", "Series Chipset Family HECI Controller #2" } ,
    { 0x8086, 0x1C3D, "Intel(R) 6 Series Series Chipset Family", "Intel(R) Active Management Technology - SOL" } ,
    { 0x8086, 0x1C49, "FCD01179", "04" } ,
    { 0x8086, 0x1C4C, "Q65", "Intel(R) Q65 Express Chipset Family LPC Interface Controller" } ,
    { 0x8086, 0x1D3A, "X79 series chipset HECI Controller", "X79/C600 series chipset Management Engine Interface" } ,
    { 0x8086, 0x1D3D, "CC0700", "Intel Active Management Technology AMT" } ,
    { 0x8086, 0x1e00, "Intel H77 Express Chipset", "2 ports IDE Controller" } ,
    { 0x8086, 0x1e02, "SUBSYS_102E17AA&REV_04", "Intel 7 Series/C216 Chipset Family SATA AHCI Controller" } ,
    { 0x8086, 0x1E03, "PCI\\CC_010601", "Intel(R) 7 Series Chipset Family SATA AHCI Controller" } ,
    { 0x8086, 0x1e08, "Intel H77 Express Chipset", "2 ports IDE Controller" } ,
    { 0x8086, 0x1E10, "C216", "Intel(R) 7 Series/C216 Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x1E12, "1E12", "Intel(R) 7 Series/C216 Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x1E16, "C216", "Intel(R) 7 Series/C216 Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x1E20, "1E20", "High Definition Audio Controller" } ,
    { 0x8086, 0x1E22, "Intel(R) 7 SeriesC216 Chipset Family SMBus Host Co", "SM-Bus Controller of the Intel Z77 Chipset" } ,
    { 0x8086, 0x1E26, "C216", "Intel(R) 7 Series/C216 Chipset Family USB Enhanced Host Controller" } ,
    { 0x8086, 0x1E2D, "C216", "Intel(R) 7 Series/C216 Chipset Family USB Enhanced Host Controller" } ,
    { 0x8086, 0x1e31, "Intel USB 3.0 eXtensible Host Controller 1E31", "Intel USB 3.0" } ,
    { 0x8086, 0x1E3A, "PCI\\VEN_8086&DEV_1E3A&SUBSYS", "Intel Management Engine Interface (MEI)" } ,
    { 0x8086, 0x1E3A, "C216", "8555555555555999999999999999999999999999999999999999999999999999999900000000000000000001222222222222" } ,
    { 0x8086, 0x1E3A, "Z77", "C216 Chipset - Platform controller hub" } ,
    { 0x8086, 0x1E3D, "602317", "Intel(R) AMT LMS_SOL for AMT 8.xx" } ,
    { 0x8086, 0x1E59, "140889", "Intel(R) HM76 Express Chipset LPC Controller" } ,
    { 0x8086, 0x1f41, "Avoton SoC", "Intel Corporation Ethernet Connection I354" } ,
    { 0x8086, 0x2000, "CA 95054", "505943621" } ,
    { 0x8086, 0x2014, "0x18C9", "Framegrabber" } ,
    { 0x8086, 0x2048, "Atheros L2", "Fast Ethernet 10/100 Base-T Controller" } ,
    { 0x8086, 0x2124, "27DA", "PRO/100 VE Network Connection" } ,
    { 0x8086, 0x2125, "82801G ", "AC97 Audio Controller. website to download - http://www.intel.com/design/chipsets/manuals/29802801.p" } ,
    { 0x8086, 0x2222, "82801", "Intel Management Interface" } ,
    { 0x8086, 0x2250, "5110P", "Intel(R) Xeon Phi(TM) Coprocessor" } ,
    { 0x8086, 0x2255, "810D1043", "02\\3" } ,
    { 0x8086, 0x225C, "SE10", "Intel(R) Xeon Phi(TM) Coprocessor" } ,
    { 0x8086, 0x225D, "3120", "Intel(R) Xeon Phi(TM) Coprocessor" } ,
    { 0x8086, 0x225E, "31S1P", "Intel(R) Xeon Phi(TM) Coprocessor" } ,
    { 0x8086, 0x2406, "82801 / ?", "AC97 Modem Controller / PCI Modem" } ,
    { 0x8086, 0x2410, "82801AA", "LPC Interface" } ,
    { 0x8086, 0x2411, "82801AA", "IDE Controller (UltraATA/66)" } ,
    { 0x8086, 0x2412, "82801AA", "USB Controller" } ,
    { 0x8086, 0x2413, "82801AA", "SMBus Controller" } ,
    { 0x8086, 0x2415, "Intel 82801DBM SM/BUS Controller 24C3", "Aureal (AD1881 SOUNDMAX) Placa M�e Asaki P3-141" } ,
    { 0x8086, 0x2416, "82801ER", "AC'97 Modem Controller" } ,
    { 0x8086, 0x2418, "82801AA", "Hub Interface-to-PCI Bridge    82801 PCI-2448 0x2448" } ,
    { 0x8086, 0x2420, "82801AB", "LPC Interface" } ,
    { 0x8086, 0x2421, "82801AB", "IDE Controller (UltraATA/33)" } ,
    { 0x8086, 0x2422, "82801AB", "USB Controller" } ,
    { 0x8086, 0x2423, "82801AB", "SMBus Controller" } ,
    { 0x8086, 0x2425, "82801BA", "Audio controler" } ,
    { 0x8086, 0x2426, "82801AB", "AC97 Modem Controller" } ,
    { 0x8086, 0x2428, "82801AB", "Hub Interface-to-PCI Bridge" } ,
    { 0x8086, 0x2431, "82810", "pci bus" } ,
    { 0x8086, 0x2440, "82801BA/BAM AC'97", "LPC Interface Bridge, ICH2" } ,
    { 0x8086, 0x2441, "82801BA", "IDE Controller (UltraATA/66)" } ,
    { 0x8086, 0x2442, "82801BA/BAM", "USB Controller, USB-A" } ,
    { 0x8086, 0x2443, "82801BA/BAM", "SMBus Controller" } ,
    { 0x8086, 0x2444, "82801BA/BAM", "USB Controller, USB-B" } ,
    { 0x8086, 0x2445, "Intel i945G/GZ", "AC97 Audio Controller" } ,
    { 0x8086, 0x2446, "82801BA/BAM", "AC97 Modem Controller" } ,
    { 0x8086, 0x2448, "82801BAM/CAM/DBM", "Hub Interface to PCI Bridge" } ,
    { 0x8086, 0x2449, "82559ER", "82559ER Integrated 10Base-T/100Base-TX Ethernet Controller" } ,
    { 0x8086, 0x244A, "82801BAM", "IDE Controller" } ,
    { 0x8086, 0x244B, "82801BA", "IDE Controller" } ,
    { 0x8086, 0x244C, "82801BAM", "LPC Interface Bridge" } ,
    { 0x8086, 0x244E, "82801DB", "Intel(R) 82801 PCI Bridge" } ,
    { 0x8086, 0x2450, "82801E", "LPC Interface Bridge" } ,
    { 0x8086, 0x2452, "82801E", "USB Controller" } ,
    { 0x8086, 0x2453, "82801E", "SMBus Controller" } ,
    { 0x8086, 0x2459, "82801E", "LAN0 Controller" } ,
    { 0x8086, 0x245B, "82801E", "IDE Controller" } ,
    { 0x8086, 0x245D, "82801E", "Multimedia Audio Controller" } ,
    { 0x8086, 0x245E, "82801E", "Hub Interface to PCI Bridge" } ,
    { 0x8086, 0x2480, "82801CA", "LPC Interface Bridge" } ,
    { 0x8086, 0x2481, "82801CA", "IDE Controller (UltraATA/66)" } ,
    { 0x8086, 0x2482, "82801CA/CAM", "USB Controller" } ,
    { 0x8086, 0x2483, "82801CA/CAM", "SMBus Controller" } ,
    { 0x8086, 0x2484, "82801CA/CAM", "USB Controller" } ,
    { 0x8086, 0x2485, "82801CA/CAM", "AC97 Audio Controller" } ,
    { 0x8086, 0x2486, "82801CA/CAM", "AC 97 Modem Controller" } ,
    { 0x8086, 0x2487, "82801CA/CAM", "USB Controller" } ,
    { 0x8086, 0x248A, "82801CAM", "UltraATA IDE Controller" } ,
    { 0x8086, 0x248B, "82801CA", "UltraATA/100 IDE Controller" } ,
    { 0x8086, 0x248C, "82801CAM", "LPC Interface or ISA bridge: see Notes" } ,
    { 0x8086, 0x248D, "82801??", "USB 2.0 EHCI Contoroller" } ,
    { 0x8086, 0x24C0, "82801DB/DBL", "LPC Interface Bridge" } ,
    { 0x8086, 0x24C2, "82801DB/DBL/DBM", "USB UHCI Controller #1" } ,
    { 0x8086, 0x24C3, "82801DB/DBL/DBM", "modem" } ,
    { 0x8086, 0x24C4, "82801DB/DBL/DBM", "USB UHCI Controller" } ,
    { 0x8086, 0x24C5, "82801DBM SoundMAXController (ICH4-M B0 step)", "Realtek AC97" } ,
    { 0x8086, 0x24C5, "2200bg", "PCI Simple Communications Controller" } ,
    { 0x8086, 0x24C5, "82801DBM SoundMAXController (ICH4-M B0 step)", "Intel 82801 DB DBM/DA AC 97 Audio Controller" } ,
    { 0x8086, 0x24C6, "82801 /8086", "AC97 Modem Controller / PCI Modem" } ,
    { 0x8086, 0x24C7, "82801DB/DBL/DBM", "USB UHCI Controller #3" } ,
    { 0x8086, 0x24CA, "82801DBM", "IDE Controller (UltraATA/100)" } ,
    { 0x8086, 0x24CB, "82801DB/DBL", "IDE Controller (UltraATA/100)" } ,
    { 0x8086, 0x24CC, "82801DBM", "LPC Interface Bridge" } ,
    { 0x8086, 0x24CD, "82801DB/DBL/DBM", "USB EHCI Controller" } ,
    { 0x8086, 0x24D0, "82801EB/ER", "LPC Interface Bridge" } ,
    { 0x8086, 0x24D1, "82801EB/ER", "SATA Controller" } ,
    { 0x8086, 0x24D2, "82801EB/ER", "USB UHCI Controller 1" } ,
    { 0x8086, 0x24D3, "82801EB/ER", "SMBus Controller" } ,
    { 0x8086, 0x24D4, "82801EB/ER", "USB UHCI Controller #2" } ,
    { 0x8086, 0x24D5, "AD1888/AD1980", "Analog Devices AD1888/AD1980 @ Intel 82801EB ICH5 - AC'97 Audio Controller [A-2/A-3]" } ,
    { 0x8086, 0x24D6, "82801EB/ER", "Motorola SM56 Data Fax Modem" } ,
    { 0x8086, 0x24D7, "82801EB/ER", "USB UHCI Controller #3" } ,
    { 0x8086, 0x24DB, "82801EB/ER", "EIDE Controller" } ,
    { 0x8086, 0x24DC, "82801EB", "LPC Interface Controller" } ,
    { 0x8086, 0x24DD, "82801EB/ER", "USB EHCI Controller" } ,
    { 0x8086, 0x24DE, "82801EB/ER", "USB UHCI Controller #4" } ,
    { 0x8086, 0x24DF, "82801ER", "SATA Controller (RAID)" } ,
    { 0x8086, 0x24E4, "24e4", "intel " } ,
    { 0x8086, 0x2500, "82820", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x2501, "82820", "Host Bridge (MCH)" } ,
    { 0x8086, 0x2502, "82820", "" } ,
    { 0x8086, 0x2503, "82820", "" } ,
    { 0x8086, 0x2504, "82820", "" } ,
    { 0x8086, 0x250B, "82820", "Host Bridge (MCH)" } ,
    { 0x8086, 0x250F, "82820", "AGP Bridge" } ,
    { 0x8086, 0x2520, "82805AA", "Memory Translator Hub (MTH)" } ,
    { 0x8086, 0x2521, "8280", "Audio Device on High Definition Audio Bus" } ,
    { 0x8086, 0x2530, "82850/E", "Host-Hub Interface Bridge(A2 step)" } ,
    { 0x8086, 0x2531, "82860", "Host-Hub Interface_A Bridge (DP mode)" } ,
    { 0x8086, 0x2532, "82850/850E/860", "AGP Bridge" } ,
    { 0x8086, 0x2533, "82860", "Hub Interface_B Bridge" } ,
    { 0x8086, 0x2534, "82860", "Hub Interface_C Bridge" } ,
    { 0x8086, 0x2535, "82860", "PCI Bridge" } ,
    { 0x8086, 0x2536, "82860", "PCI Bridge" } ,
    { 0x8086, 0x2539, "82860", "(Quad Processor mode)" } ,
    { 0x8086, 0x2540, "E7500", "Host-HI Bridge & DRAM Controller" } ,
    { 0x8086, 0x2541, "E7500/E7501", "DRAM Controller Error Reporting" } ,
    { 0x8086, 0x2543, "E7500/E7501", "HI_B Virtual PCI-to-PCI Bridge" } ,
    { 0x8086, 0x2544, "E7500/E7501", "HI_B PCI-to-PCI Bridge Error Reporting" } ,
    { 0x8086, 0x2545, "E7500/E7501", "HI_C Virtual PCI-to-PCI Bridge" } ,
    { 0x8086, 0x2546, "E7500/E7501", "HI_C PCI-to-PCI Bridge Error Reporting" } ,
    { 0x8086, 0x2547, "E7500/E7501", "HI_D Virtual PCI-to-PCI Bridge" } ,
    { 0x8086, 0x2548, "E7500/E7501", "HI_D PCI-to-PCI Bridge Error Reporting" } ,
    { 0x8086, 0x254C, "E7501", "Host Controller" } ,
    { 0x8086, 0x2550, "E7505", "Host Controller" } ,
    { 0x8086, 0x2551, "25511014", "Host RAS Controller" } ,
    { 0x8086, 0x2552, "E7205/E7505", "PCI-to-AGP Bridge" } ,
    { 0x8086, 0x2553, "E7505", "Hub Interface_B PCI-to-PCI Bridge" } ,
    { 0x8086, 0x2554, "E7505", "Hub I/F_B PCI-to-PCI Bridge Error Report" } ,
    { 0x8086, 0x255d, "E7205", "Host Controller" } ,
    { 0x8086, 0x2560, "82845G/GL/GV/GE/PE", "DRAM Controller / Host-Hub I/F Bridge" } ,
    { 0x8086, 0x2561, "82845G/GL/GV/GE/PE", "Host-to-AGP Bridge" } ,
    { 0x8086, 0x2562, "82845G", "Integrated Graphics Device" } ,
    { 0x8086, 0x2562, "82801FR", "SATA RAID CONTROLLER" } ,
    { 0x8086, 0x2570, "82865G/PE/P, 82848P", "DRAM Controller / Host-Hub Interface" } ,
    { 0x8086, 0x2571, "82865G/PE/P, 82848P", "PCI-to-AGP Bridge" } ,
    { 0x8086, 0x2572, "intel d865glc", "Integrated Graphics Device" } ,
    { 0x8086, 0x2573, "82865G/PE/P, 82848P", "PCI-to-CSA Bridge" } ,
    { 0x8086, 0x2576, "82865G/PE/P, 82848P", "Overflow Configuration" } ,
    { 0x8086, 0x2578, "82875P/E7210", "DRAM Controller / Host-Hub Interface" } ,
    { 0x8086, 0x2579, "82875P", "PCI-to-AGP Bridge" } ,
    { 0x8086, 0x257A, "", "" } ,
    { 0x8086, 0x257B, "82875P/E7210", "PCI to CSA Bridge" } ,
    { 0x8086, 0x257E, "82875P/E7210", "Overflow Configuration" } ,
    { 0x8086, 0x2580, "915G/P/GV", "Host Bridge / DRAM Controller" } ,
    { 0x8086, 0x2581, "915G/P/GV, 925X/XE?", "Host-PCI Express Bridge" } ,
    { 0x8086, 0x2582, "142550", "82915g/gv/910gl Express Chipset Family" } ,
    { 0x8086, 0x2582, "82915g/gv/910gl Express Chipset Family", "82915g/gv/910gl Express Chipset Family" } ,
    { 0x8086, 0x2584, "82925X/XE", "Host Bridge / DRAM Controller" } ,
    { 0x8086, 0x2585, "", "" } ,
    { 0x8086, 0x2588, "E7221", "Host Bridge/DRAM Controller" } ,
    { 0x8086, 0x2589, "E7221", "PCI Express Bridge" } ,
    { 0x8086, 0x258A, "E7221", "Internal Graphics" } ,
    { 0x8086, 0x2590, "915GM", "Mobile Intel(R) 915GM/PM/GMS/910GML Express Processor to DRAM Controller" } ,
    { 0x8086, 0x2592, "Intel 82852/82855 ", "Graphic controller family" } ,
    { 0x8086, 0x25A1, "6300ESB", "LPC Interface Bridge" } ,
    { 0x8086, 0x25A2, "6300ESB", "PATA100 IDE Controller" } ,
    { 0x8086, 0x25A3, "6300ESB", "SATA Controller(IDE Mode)" } ,
    { 0x8086, 0x25A4, "6300ESB", "SMBus Controller" } ,
    { 0x8086, 0x25A6, "6300ESB", "AC'97 Audio Controller" } ,
    { 0x8086, 0x25A7, "6300ESB", "AC'97 Modem Controller" } ,
    { 0x8086, 0x25A9, "6300ESB", "USB 1.1 UHCI Controller #1" } ,
    { 0x8086, 0x25AA, "6300ESB", "USB 1.1 UHCI Controller #2" } ,
    { 0x8086, 0x25AB, "6300ESB", "Watchdog Timer" } ,
    { 0x8086, 0x25AC, "6300ESB", "APIC1" } ,
    { 0x8086, 0x25AD, "6300ESB", "USB 2.0 EHCI Controller" } ,
    { 0x8086, 0x25AE, "6300ESB", "Hub Interface to PCI-X Bridge" } ,
    { 0x8086, 0x25B0, "6300ESB", "Serial ATA Controller (RAID mode)" } ,
    { 0x8086, 0x2600, "E8500", "Hub Interface 1.5" } ,
    { 0x8086, 0x2601, "E8500", "PCI Express Port D" } ,
    { 0x8086, 0x2602, "E8500", "PCI Express Port C0" } ,
    { 0x8086, 0x2603, "E8500", "PCI Express Port C1" } ,
    { 0x8086, 0x2604, "E8500", "PCI Express Port B0" } ,
    { 0x8086, 0x2605, "E8500", "PCI Express Port B1" } ,
    { 0x8086, 0x2606, "E8500", "PCI Express Port A0" } ,
    { 0x8086, 0x2607, "E8500", "PCI Express Port A1" } ,
    { 0x8086, 0x2640, "82801FB/FR", "LPC Interface Bridge" } ,
    { 0x8086, 0x2641, "82801FBM", "LPC Interface Bridge (ICH6-M)" } ,
    { 0x8086, 0x2651, "82801Fb", "SATA Controller" } ,
    { 0x8086, 0x2652, "82801FR", "SATA RAID Controller" } ,
    { 0x8086, 0x2652, "82801FR/FRW", "SATA Controller" } ,
    { 0x8086, 0x2652, "82801FR/FRW", "SATA Raid Controller" } ,
    { 0x8086, 0x2652, "82801FR/FRW", "AHCI Controller" } ,
    { 0x8086, 0x2653, "82801FBM", "SATA AHCI Controller" } ,
    { 0x8086, 0x2653, "82801FBM", "SATA IDE Controller" } ,
    { 0x8086, 0x2653, "82801FBM", "AHCI Controller" } ,
    { 0x8086, 0x2658, "82801FB/FR/FW/FRW", "USB UHCI Controller #1" } ,
    { 0x8086, 0x2659, "82801FB/FR/FW/FRW", "USB UHCI Controller #2" } ,
    { 0x8086, 0x265A, "82801FB/FR/FW/FRW", "USB UHCI Controller #3" } ,
    { 0x8086, 0x265B, "82801FB/FR/FW/FRW", "USB UHCI Controller #4" } ,
    { 0x8086, 0x265C, "82801FB/FR/FW/FRW", "USB 2.0 EHCI Controller" } ,
    { 0x8086, 0x266, "VIA Technologies Vinyl AC'97 Codec Combo Driver (W", "VIA AC97 codec incorporated into VT82C686VT8251 SouthbridA/B, VT8231, VT8233/A/C, VT8235, VT8237/R" } ,
    { 0x8086, 0x2660, "82801FB/FR/FW/FRW", "PCI Express Port 1" } ,
    { 0x8086, 0x2662, "82801FB/FR/FW/FRW", "PCI Express Port 2" } ,
    { 0x8086, 0x2664, "82801FB", "PCI Express Port 3" } ,
    { 0x8086, 0x2666, "82801FB/FR/FW/FRW", "PCI Express Port 4" } ,
    { 0x8086, 0x2668, "11511583659", "82801FB (ICH6) High Definition Audio Controller" } ,
    { 0x8086, 0x2669, "2028026", "jkn " } ,
    { 0x8086, 0x266A, "82801BA/CA", "SMBus Controller" } ,
    { 0x8086, 0x266C, "82801FB/FR/FW/FRW", "LAN Controller" } ,
    { 0x8086, 0x266D, "czc82809kr", "http://www.dell.com/support/drivers/us/en/19/DriverDetails/DriverFileFormats?DriverId=R104087&FileId" } ,
    { 0x8086, 0x266E, "Driver audio digitale integrato ADI SoundMAX", "Driver audio digitale integrato ADI SoundMAX - HP DV4000" } ,
    { 0x8086, 0x266F, "82801FB/FBM/FW/FR/FRW", "PATA100 Controller - 266F" } ,
    { 0x8086, 0x2670, "631xESB/6321ESB/3100 ", "LPC Interface Controller" } ,
    { 0x8086, 0x2678, "8280", "8280 (ICH6) High Defininition Audio Controller" } ,
    { 0x8086, 0x2680, "631x/632x ESB2&3100", "SATA Controller(IDE Mode)" } ,
    { 0x8086, 0x2681, "62089A2", "631xESB/632xESB SATA AHCI Controller" } ,
    { 0x8086, 0x2682, "ESB2", "Intel(R) ESB2 SATA RAID Controller" } ,
    { 0x8086, 0x269B, "631xESB/6321ESB/3100", "SMBus Controller" } ,
    { 0x8086, 0x269E, "631x/632x ESB2", "PATA100 IDE Controller" } ,
    { 0x8086, 0x27, "82801G ", "ICH7 Family" } ,
    { 0x8086, 0x2770, "82945G/GZ/P/PL", "Intel(R) 945G/GZ/GC/P/PL Processor to I/O Controller" } ,
    { 0x8086, 0x2771, "82945G/GZ/P/PL", "Host to PCI Express Bridge" } ,
    { 0x8086, 0x2772, "82945G/GZ", "PCI\\VEN_8086&DEV_2772&SUBSYS_2A57103C&REV_02\\3&11583659&0&10" } ,
    { 0x8086, 0x2776, "82945G", "INTEL(R) 82945G EXPRESS FAMILY" } ,
    { 0x8086, 0x277C, "82975X", "Intel 975X Express Chipset" } ,
    { 0x8086, 0x2780, "82915G", "Graphics device" } ,
    { 0x8086, 0x2782, "82915G", "Graphics device: 82915G/GV/910GL Express Chipset Family" } ,
    { 0x8086, 0x2792, "038000", "Mobile Intel(R) 915GM/GMS/, 910GML Express Chipset Family" } ,
    { 0x8086, 0x2794, "945", "Mobile chipset" } ,
    { 0x8086, 0x27A0, "874079", "Mobile Intel(R) 945GM/GU/PM/GMS/940GML/943GML and Intel(R) 945GT Express Processor to DRAM Controlle" } ,
    { 0x8086, 0x27A1, "Intel 82945PM Memory Controller", "Intel Corporation Mobile 945PM Express PCI Express Root Port" } ,
    { 0x8086, 0x27A2, "HPQ0006", "Mobile Intel(R) 945 Express Chipset Family" } ,
    { 0x8086, 0x27A6, "945GM", "Intel 945GM/950" } ,
    { 0x8086, 0x27B8, "945GL", "Intel(R) ICH7 Family LPC Interface Controller" } ,
    { 0x8086, 0x27B9, "ICH7", "Intel(R) ICH7M/U LPC Interface Controller" } ,
    { 0x8086, 0x27BC, "NM10", "NM10 Family LPC Interface Controller" } ,
    { 0x8086, 0x27c0, "82801GB/GR/GH", "Intel(R) N10/ICH7 Family Serial ATA Storage Controller" } ,
    { 0x8086, 0x27C1, "82801GB/GR/GH", "AHCI Controller" } ,
    { 0x8086, 0x27c3, "82801GR/GH", "Raid Controller" } ,
    { 0x8086, 0x27c4, "82801GBM/GHM", "SATA IDE Controller" } ,
    { 0x8086, 0x27C5, "82801GBM/GHM", "Intel(R) ICH7/M/MDH SATA AHCI Controller" } ,
    { 0x8086, 0x27C6, "82801GHM", "Raid Controller" } ,
    { 0x8086, 0x27c8, "946", "Intel(R) N10/ICH7 Family USB Universal Host Controller" } ,
    { 0x8086, 0x27c9, "USB UHCI Controller", "Intel(R) N10/ICH7 Family USB Universal Host Controller" } ,
    { 0x8086, 0x27CA, "ICH7", "Intel(R) N10/ICH7 Family USB Universal Host Controller" } ,
    { 0x8086, 0x27CB, "ICH7", "Intel(R) N10/ICH7 Family USB Universal Host Controller" } ,
    { 0x8086, 0x27CC, "82801G", "Intel(R) N10/ICH7 Family USB2 Enhanced Host Controller" } ,
    { 0x8086, 0x27D0, "82801G", "Intel(R) 82801G (ICH7 Family) PCI Express Root Port" } ,
    { 0x8086, 0x27D2, "82801G", "Intel(R) 82801G (ICH7 Family) PCI Express Root Port" } ,
    { 0x8086, 0x27D4, "ICH7", "Intel(R) N10/ICH7 Family PCI Express Root Port" } ,
    { 0x8086, 0x27d8, "27D8", "UAA Bus Driver for HD Audio" } ,
    { 0x8086, 0x27d8, "PCI\\VEN_8086&DEV_2485&SUBSYS_AD021458&REV_02", "Microsoft UAA Bus HD Audio" } ,
    { 0x8086, 0x27D9, "A62516F3", "IDT High Definition Audio Driver	" } ,
    { 0x8086, 0x27DA, "82801G", "Intel(R) N10/ICH7 Family SMBus Controller" } ,
    { 0x8086, 0x27DC, "336C1462", "Intel� PRO/100 VE Desktop Adapter" } ,
    { 0x8086, 0x27DC, "336C1462", "Intel� PRO/100 VE Desktop Adapter" } ,
    { 0x8086, 0x27DE, "RTL8100C", "AUDIO (ALC850) << Realtek " } ,
    { 0x8086, 0x27df, "82801GB/GBM", "Intel(R) ICH7 Family Ultra ATA Storage Controller" } ,
    { 0x8086, 0x2802, "8086", "INTEL(R) HIGH DEFINITION AUDIO HDMI" } ,
    { 0x8086, 0x2803, "0111", "Intel(R) High Definition Audio HDMI Service" } ,
    { 0x8086, 0x2804, "80860101", "IntcDAudModel" } ,
    { 0x8086, 0x2807, "Intel HD Audio", "Intel HDMI Audio Chip" } ,
    { 0x8086, 0x2812, "2812", "Intel(R) ICH8DH LPC Interface Controller" } ,
    { 0x8086, 0x2815, "902D104D", "Intel(R) ICH8M LPC Interface Controller - 2815 Driver" } ,
    { 0x8086, 0x2820, "82801HB/HR/HH/HO", "SATA IDE Controller:4 port" } ,
    { 0x8086, 0x2821, "82821HR/HH/HO", "AHCI Controller" } ,
    { 0x8086, 0x2822, "82801HR/HH/HO&82801IR/IH/IO(AIE=0)/ICH10R", "Raid Controller" } ,
    { 0x8086, 0x2824, "82801HB", "ICH8 AHCI Controller" } ,
    { 0x8086, 0x2825, "82801IIH", "Intel Q35" } ,
    { 0x8086, 0x2828, "82801HBM/HEM", "SATA IDE Controller" } ,
    { 0x8086, 0x2829, "82801HBM", "Intel(R) ICH8M SATA AHCI Controller" } ,
    { 0x8086, 0x282A, "ICH8M/9M/ICH10M/i5M", "Raid Controller" } ,
    { 0x8086, 0x2830, "2830", "Intel(R) ICH8 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2831, "2831", "Intel(R) ICH8 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2832, "2832", "Intel(R) ICH8 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2834, "2834", "Intel(R) ICH8 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2835, "2835", "Intel(R) ICH8 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2836, "2836", "Intel(R) ICH8 Family USB2 Enhanced Host Controller" } ,
    { 0x8086, 0x283A, "81EC1043 (?)", "ICH8 Family USB2 Enhanced Host Controller" } ,
    { 0x8086, 0x283E, "PCI\\VEN_8086&DEV_283E&SUBSYS_20A917AA&REV_03\\3&B1B", "Intel(R) ICH8 Family SMBus Controller" } ,
    { 0x8086, 0x283F, "283F", "Intel(R) ICH8 Family PCI Express Root Port" } ,
    { 0x8086, 0x284, "888", "Microsoft UAA bus for HD audio" } ,
    { 0x8086, 0x2841, "ICH8", "Intel(R) ICH8 Family PCI Express Root Port" } ,
    { 0x8086, 0x2843, "ICH8", "Intel(R) ICH8 Family PCI Express Root Port" } ,
    { 0x8086, 0x2845, "ICH8", "Intel(R) ICH8 Family PCI Express Root Port" } ,
    { 0x8086, 0x2847, "2847", "Intel(R) ICH8 Family PCI Express Root Port" } ,
    { 0x8086, 0x284B, "888", "Microsoft UAA bus for HD audio" } ,
    { 0x8086, 0x2850, "82801HBM/HEM", "Intel(R) ICH8M Ultra ATA Storage Controller" } ,
    { 0x8086, 0x2880, "0000000", "Intel Display Audio" } ,
    { 0x8086, 0x2888, "Q945", "Q945" } ,
    { 0x8086, 0x2914, "ICH9D0", "LPC bridge of ICH9" } ,
    { 0x8086, 0x2916, "3", "PCI Simple Communications-Controller " } ,
    { 0x8086, 0x2918, "ATK0110 driver for WindowsXP/Vista/Win7 32&64-bit", "http://dlcdnet.asus.com/pub/ASUS/misc/utils/MB_WIN7_ATK.ZIP" } ,
    { 0x8086, 0x2919, "ICH9M", "Intel(R) ICH9M/M-E Family 4 Port SATA AHCI Controller" } ,
    { 0x8086, 0x2920, "82801(IB)/IR/IH/IO", "SATA IDE Controller:4 port" } ,
    { 0x8086, 0x2921, "82801IR/IH/IO", "SATA IDE Controller:2 port1" } ,
    { 0x8086, 0x2922, "82801IR/IH/IO", "AHCI Controller" } ,
    { 0x8086, 0x2923, "82801IB", "ICH9 AHCI Controller" } ,
    { 0x8086, 0x2925, "82801IR/IH/IO(AIE=1)", "Raid Controller" } ,
    { 0x8086, 0x2926, "82801IR/IH/IO", "SATA IDE Controller:2 port2" } ,
    { 0x8086, 0x2928, "?(ICH9M Family)", "SATA IDE Controller:2port1" } ,
    { 0x8086, 0x2929, "ICH9M/ME", "ICH9M/ME AHCI Controller" } ,
    { 0x8086, 0x292D, "?(ICH9M Family)", "SATA IDE Controller:2port2" } ,
    { 0x8086, 0x292E, "?(ICH9M Family)", "SATA IDE Controller:1port2" } ,
    { 0x8086, 0x2930	, "8086", "2930" } ,
    { 0x8086, 0x2930, "Intel ICH9 Family SMBus Controller", "Intel ICH9 Family SMBus Controller" } ,
    { 0x8086, 0x2932, "ICH9", "Intel(R) ICH9 Family Thermal Subsystem" } ,
    { 0x8086, 0x2934, "ICH9", "Intel(R) ICH9 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2935, "ICH9", "Intel(R) ICH9 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2936, "0x02141028", "Intel(R) ICH9 Family USB Univeral Host Controller" } ,
    { 0x8086, 0x2937, "ICH9", "Intel(R) ICH9 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2938, "ICH9", "Intel(R) ICH9 Family USB Universal Host Controller" } ,
    { 0x8086, 0x2939, "ICH9", "Intel(R) ICH9 Family USB Universal Host Controller" } ,
    { 0x8086, 0x293A, "ICH9", "Intel(R) ICH9 Family USB2 Enhanced Host Controller" } ,
    { 0x8086, 0x293C, "ICH9", "Intel(R) ICH9 Family USB2 Enhanced Host Controller" } ,
    { 0x8086, 0x293E	, "486486 ", "82801IB/IR/IH (ICH9 Family) HD Audio Controller" } ,
    { 0x8086, 0x293E, "486486", "82801IB/IR/IH (ICH9 Family) HD Audio Controller" } ,
    { 0x8086, 0x2940, "ICH9", "Intel(R) ICH9 Family PCI Express Root Port" } ,
    { 0x8086, 0x2942, "ICH9", "Intel(R) ICH9 Family PCI Express Root Port" } ,
    { 0x8086, 0x2944, "ICH9", "Intel(R) ICH9 Family PCI Express Root Port" } ,
    { 0x8086, 0x2948, "ICH9", "Intel(R) ICH9 Family PCI Express Root Port" } ,
    { 0x8086, 0x294C, "82566DC-2", "Intel(R) 82566DC-2 Gigabit Network Connection" } ,
    { 0x8086, 0x2972, "82946GZ ", "Onboard Video Device for 82946GZ chips" } ,
    { 0x8086, 0x2986, "265452", "Intel" } ,
    { 0x8086, 0x2987, "Q965/Q963", "Intel PCI Serial Port" } ,
    { 0x8086, 0x2992, "Q965/Q963", "Intel(R) Express Chipset video" } ,
    { 0x8086, 0x2993, "G965", "Intel(R) Express Chipset Dell Version" } ,
    { 0x8086, 0x2994, "2802103C", "Intel Management Engine Interface (HECI)" } ,
    { 0x8086, 0x2996, "Q963/Q965", "IDE Controller" } ,
    { 0x8086, 0x2997, "Q965/Q963", "PCI Serial Port" } ,
    { 0x8086, 0x29a0, "?(82P965)", "Intel P965/G965 Processor to I/O Controller" } ,
    { 0x8086, 0x29a1, "?(82Q965, 82G965, 82P965)", "Intel P965/G965 PCI Express Root Port" } ,
    { 0x8086, 0x29A2, "Intel 82G965 Graphics and Memory Controller Hub (G", "Intel 82G965 Graphics and Memory Controller Hub (GMCH)" } ,
    { 0x8086, 0x29A4, "86881", "" } ,
    { 0x8086, 0x29A6, "G965", "IDE Controller" } ,
    { 0x8086, 0x29B2, "Q35", "Intel(R) Q35 Express Chipset Family" } ,
    { 0x8086, 0x29B3, "Q35", "Intel Graphics" } ,
    { 0x8086, 0x29B4, "Q35-Chipset", "Intel� ME: Management Engine" } ,
    { 0x8086, 0x29B4, "4F4A8086&rev_02", "Management Engine Driver" } ,
    { 0x8086, 0x29B6, "Q35", "IDE Controller" } ,
    { 0x8086, 0x29B7, "Q35-Chipset", "Serial Over LAN" } ,
    { 0x8086, 0x29C2, "8086", "Intel(R) G33 chipset GMA3100 video Driver" } ,
    { 0x8086, 0x29C2, "Intel G33", "Intel(R) G33 chipset GMA3100 video Driver" } ,
    { 0x8086, 0x29C4, "Intel DG33BU", "Intel ME: Management Engine Interface" } ,
    { 0x8086, 0x29C6, "G3x", "IDE Controller" } ,
    { 0x8086, 0x29D4, "281e103c", "Intel Management Interface" } ,
    { 0x8086, 0x29D6, "Q33", "IDE Controller" } ,
    { 0x8086, 0x29E6, "x48", "IDE Controller" } ,
    { 0x8086, 0x29F6, "32xx", "IDE Controller" } ,
    { 0x8086, 0x2A00, "PM965", "Mobile Intel(R) PM965/GM965/GL960/GS965 Express Processor to DRAM Controller" } ,
    { 0x8086, 0x2A02, "88B31033", "Intel GM965, Intel X3100" } ,
    { 0x8086, 0x2A03, "82Q965", "Mobile Intel(R) 965 Express Chipset Family" } ,
    { 0x8086, 0x2A04, "Q965/Q96", "Intel PCI communication controller-Intel Management Engine Interface update" } ,
    { 0x8086, 0x2A06, "965PM", "IDE Controller" } ,
    { 0x8086, 0x2A07, "Q965/Q963", "Intel PCI Serial Port" } ,
    { 0x8086, 0x2A08, "Q965 Chipset", "Intel(R) Extended Thermal Model MCH" } ,
    { 0x8086, 0x2A12, "965", "Mobile Intel(R) 965 Express Chipset Family" } ,
    { 0x8086, 0x2A16, "96xMG", "IDE Controller" } ,
    { 0x8086, 0x2A40, "2A40", "Mobile Intel(R) 4 Series Chipset Processor to DRAM Controller" } ,
    { 0x8086, 0x2A42, "Mobile Intel 4 Series Chipset Family", "Intel Mobile Graphic" } ,
    { 0x8086, 0x2A43, "Mobile Intel 4 Series Chipset Family", "Intel Mobile Graphic" } ,
    { 0x8086, 0x2A44, "Mobile 4 Series Chipset", "IC658" } ,
    { 0x8086, 0x2A46, "M4x", "IDE Controller" } ,
    { 0x8086, 0x2a47, "20EC17AA", "Active Management Technology - SOL" } ,
    { 0x8086, 0x2A52, "Cantiga", "IDE Controller" } ,
    { 0x8086, 0x2C62, "2C62", "QuickPath Architecture Generic Non-core Registers" } ,
    { 0x8086, 0x2D01, "2D01", "QuickPath Architecture System Address Decoder" } ,
    { 0x8086, 0x2D10, "2D10", "QPI Link" } ,
    { 0x8086, 0x2D11, "2D11", "QPI Physical" } ,
    { 0x8086, 0x2E06, "4x", "IDE Controller" } ,
    { 0x8086, 0x2E12, "-", "Intel Q45/Q43 Express Chipset" } ,
    { 0x8086, 0x2e13, "Intel Q43/Q45/G43/G45 (Eaglelake) Graphics Control", "Intel(R) 4 Series Internal Chipset" } ,
    { 0x8086, 0x2E14, "PCI\\VEN_8086&DEV_2E14", "Intel Management Engine Interface (HECI)" } ,
    { 0x8086, 0x2E15, "PCI\\VEN_8086&DEV_29C2&SUBSYS_29C28086&REV_10\\3&115", "Intel AMT LMS_SOL for AMT 5.xx" } ,
    { 0x8086, 0x2E16, "4x", "IDE Controller" } ,
    { 0x8086, 0x2E17, "3646103C", "Intel AMT LMS_SOL for AMT 5.xx" } ,
    { 0x8086, 0x2E24, "pci\\VEN 8086&DEV_3B64&subsys _ 76361462&rev _06", "pci simple communications controller" } ,
    { 0x8086, 0x2E24, "PCI\\VEN_8086", "Intel Management Engine Interface" } ,
    { 0x8086, 0x2E26, "4x", "IDE Controller" } ,
    { 0x8086, 0x2e29, "2e29", "Intel(R) 4 Series Chipset PCI Express Root Port - 2E29" } ,
    { 0x8086, 0x2E30, "2E30", "Intel(R) 4 Series Chipset Processor to I/O Controller" } ,
    { 0x8086, 0x2E32, "PCI\\VEN_8086&DEV_2E32&SUBSYS_31031565&REV_03", "Intel G41 express graphics" } ,
    { 0x8086, 0x2E33, "G41TY EXPRESS CHIPSET", "ghaphics chipset g41TY" } ,
    { 0x8086, 0x2E33, "G41 EXPRESS CHIPSET", "ghaphics chipset g41 ghaphics chipset g41 " } ,
    { 0x8086, 0x2E46, "4x", "IDE Controller" } ,
    { 0x8086, 0x2E96, "4x", "IDE Controller" } ,
    { 0x8086, 0x2f00, "815B104D", "multimedia audio device (codec AC97) SoundMAX or VIA" } ,
    { 0x8086, 0x3092, "SRCU32", "I2O 1.5 RAID Controller" } ,
    { 0x8086, 0x3200, "31244", "PCI-X to Serial ATA Controller" } ,
    { 0x8086, 0x3340, "82855PM", "Host-Hub Interface Bridge" } ,
    { 0x8086, 0x3341, "82855PM", "AGP Bridge" } ,
    { 0x8086, 0x3342, "82855PM", "Power Management" } ,
    { 0x8086, 0x3400, "3400", "Intel(R) 5520/5500/X58 I/O Hub to ESI Port" } ,
    { 0x8086, 0x3408, "7500", "Intel(R) 7500/5520/5500/X58 I/O Hub PCI Express Root Port" } ,
    { 0x8086, 0x3409, "7500", "Intel 7500 Chipset PCIe Root Port" } ,
    { 0x8086, 0x340A, "7500", "Intel(R) 7500/5520/5500/X58 I/O Hub PCI Express Root Port" } ,
    { 0x8086, 0x340B, "7500", "Intel 7500 Chipset PCIe Root Port" } ,
    { 0x8086, 0x340C, "7500", "Intel 7500 Chipset PCIe Root Port" } ,
    { 0x8086, 0x340E, "7500", "Intel(R) 7500/5520/5500/X58 I/O Hub PCI Express Root Port" } ,
    { 0x8086, 0x3410, "7500", "Intel 7500 Chipset PCIe Root Port" } ,
    { 0x8086, 0x3422, "3422", "Intel(R) 7500/5520/5500/X58 I/O Hub GPIO and Scratch Pad Registers" } ,
    { 0x8086, 0x3423, "The Intel� Server RAID Controller U2-1 (SRCU21) an", "SRCU21/SRCU31 Microsoft Windows* 2000 Memory Management Files" } ,
    { 0x8086, 0x342E, "7500", "Intel(R) 7500/5520/5500/X58 I/O Hub System Management Registers" } ,
    { 0x8086, 0x3438, "7500", "Intel(R) 7500/5520/5500/X58 I/O Hub Throttle Registers" } ,
    { 0x8086, 0x3463, "PCI\\VEN_14E4&DEV_1692&SUBSYS_04831025&REV_01", "NTPNP_PCI0002" } ,
    { 0x8086, 0x3464, "22", "NTPNP_PCI0002" } ,
    { 0x8086, 0x3465, "PCI\\VEN_14E4&DEV_1692&SUBSYS_04831025&REV_01", "NTPNP_PCI0002" } ,
    { 0x8086, 0x348D, "82541EI", "Gigabit Ethernet Controller" } ,
    { 0x8086, 0x34c5, "82801DBM SoundMAXController (ICH4-M B0 step)", "Realtek AC97 (NOT an intel)" } ,
    { 0x8086, 0x3575, "82830[MP]", "Host-Hub I/F Bridge / SDRAM Controller" } ,
    { 0x8086, 0x3576, "82830M/MP", "Host-AGP Bridge" } ,
    { 0x8086, 0x3577, "82830vm", "Integrated Graphics Device" } ,
    { 0x8086, 0x3578, "82830[MP]", "CPU to I/O Bridge" } ,
    { 0x8086, 0x3579, "82835", "SDRAM Controller / Host-hub Interface" } ,
    { 0x8086, 0x357B, "82835", "Integrated Graphics Device" } ,
    { 0x8086, 0x3580, "852GM/GMV", "Host-Hub Interface Bridge" } ,
    { 0x8086, 0x3581, "82852GME/PM", "Virtual PCI to AGP Bridge" } ,
    { 0x8086, 0x3582, "852GM/GMV or 82852/82855 GM/GME", "Integrated Graphics Device" } ,
    { 0x8086, 0x3584, "852GM/GMV", "System Memory Controller" } ,
    { 0x8086, 0x3585, "852GM", "Configuration Process" } ,
    { 0x8086, 0x3590, "E7520", "Memory Controller Hub" } ,
    { 0x8086, 0x3591, "E7520", "Memory Controller Hub" } ,
    { 0x8086, 0x3592, "E7320", "Memory Controller Hub" } ,
    { 0x8086, 0x3593, "E7320", "MCH Error Reporting Registers" } ,
    { 0x8086, 0x3594, "E7520", "DMA Controller Registers" } ,
    { 0x8086, 0x3595, "E7525", "PCI Express Port A" } ,
    { 0x8086, 0x3596, "E7525", "PCI Express Port B" } ,
    { 0x8086, 0x3597, "E7525", "PCI Express Port B" } ,
    { 0x8086, 0x3598, "E7520", "PCI Express Port B1" } ,
    { 0x8086, 0x3599, "E7520", "PCI Express Port C" } ,
    { 0x8086, 0x359A, "E7520", "PCI Express Port C1" } ,
    { 0x8086, 0x359B, "E7525", "Extended Configuration Registers" } ,
    { 0x8086, 0x359E, "E7525", "MCH Control Registers" } ,
    { 0x8086, 0x360B, "PCI\\VEN_8086&DEV_2994&SUBSYS_13E910", "intel simple communication controller" } ,
    { 0x8086, 0x3A00, "ICH10 Family", "ICH10 4 port SATA IDE Controller" } ,
    { 0x8086, 0x3A02, "82801JD", "ICH10D SATA Controller" } ,
    { 0x8086, 0x3A03, "ICH10", "ICH10 AHCI" } ,
    { 0x8086, 0x3A05, "82801JD", "ICH10D SATA Controller" } ,
    { 0x8086, 0x3A06, "ICH10 Family", "SATA2(2Port1)" } ,
    { 0x8086, 0x3A14, "82801JDO", "82801JDO ICH10DO" } ,
    { 0x8086, 0x3A16, "ICH10R", "Intel(R) ICH10R LPC Interface Controller" } ,
    { 0x8086, 0x3A1A, "82801JD", "82801JD ICH10D" } ,
    { 0x8086, 0x3A20, "ICH10 Family", "Intel(R) ICH10 Family 4 port Serial ATA Storage Controller" } ,
    { 0x8086, 0x3A22, "ICH10R", "AHCI Controller" } ,
    { 0x8086, 0x3A23, "ICH10", "ICH10 AHCI" } ,
    { 0x8086, 0x3A26, "ICH10 Family", "Intel(R) ICH10 Family 2 port Serial ATA Storage Controller" } ,
    { 0x8086, 0x3A30, "50011458", "INTEL(R) ICH10 Family SMB controller " } ,
    { 0x8086, 0x3A34, "ICH10", "Intel(R) ICH10 Family USB Universal Host Controller" } ,
    { 0x8086, 0x3A35, "ICH10", "Intel(R) ICH10 Family USB Universal Host Controller" } ,
    { 0x8086, 0x3A36, "ICH10", "Intel(R) ICH10 Family USB Universal Host Controller" } ,
    { 0x8086, 0x3A37, "ICH10", "Intel(R) ICH10 Family USB Universal Host Controller" } ,
    { 0x8086, 0x3A38, "ICH10", "Intel(R) ICH10 Family USB Universal Host Controller" } ,
    { 0x8086, 0x3A39, "ICH10", "Intel(R) ICH10 Family USB Universal Host Controller" } ,
    { 0x8086, 0x3A3A, "ICH10", "Intel(R) ICH10 Family USB Universal Host Controller" } ,
    { 0x8086, 0x3A3C, "ICH10", "Intel(R) ICH10 Family USB Enhanced Host Controller" } ,
    { 0x8086, 0x3A3E, "Microsoft UAA Bus Driver for High Definition Audio", "Microsoft UAA Bus Driver for High Definition Audio" } ,
    { 0x8086, 0x3A40, "ICH10", "Intel(R) ICH10 Family PCI Express Root Port" } ,
    { 0x8086, 0x3A42, "ICH10", "Intel(R) ICH10 Family PCI Express Root Port" } ,
    { 0x8086, 0x3a60, "ICH10", "SM-Bus Controller" } ,
    { 0x8086, 0x3B00, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B01, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B02, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B03, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B06, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B07, "3B07", "Intel(R) 5/3400 Series Chipset LPC Interface Controller" } ,
    { 0x8086, 0x3B08, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B09, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B0A, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B0B, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B0D, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B0F, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B12, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B14, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B16, "Intel(R) 5 Series/3400 Series Chipset Family", "LPC Interface Controller" } ,
    { 0x8086, 0x3B20, "PCH (Ibex P", "SATA IDE 4-Port Desktop" } ,
    { 0x8086, 0x3B21, "PCH (Ibex Peak)", "SATA IDE 2-Port Desktop" } ,
    { 0x8086, 0x3B22, "PCH (Ibex Peak)", "SATA AHCI 6-Port Desktop" } ,
    { 0x8086, 0x3B23, "PCH (Ibex Peak)", "SATA AHCI 4-Port Desktop" } ,
    { 0x8086, 0x3B24, "PCH", "SATA Enhanced RAID" } ,
    { 0x8086, 0x3B25, "PCH", "SATA Raid Controller" } ,
    { 0x8086, 0x3B26, "PCH (Ibex Peak)", "SATA IDE 2-Port Secondary Desktop" } ,
    { 0x8086, 0x3B28, "PCH (Ibex Peak)", "SATA IDE 4-Port Mobile" } ,
    { 0x8086, 0x3B29, "PCH (Ibex Peak)", "SATA AHCI 4-Port Mobile" } ,
    { 0x8086, 0x3B2B, "PCHM", "SATA Enhanced RAID" } ,
    { 0x8086, 0x3B2C, "PCHM", "SATA Raid Controller" } ,
    { 0x8086, 0x3B2D, "PCHM", "SATA IDE Controller:2 port" } ,
    { 0x8086, 0x3B2E, "PCH (Ibex Peak)", "SATA IDE 4-Port Mobile" } ,
    { 0x8086, 0x3B2F, "PCH (Ibex Peak)", "Intel(R) 5/3400 Series Chipset Family 6 Port SATA AHCI Controller" } ,
    { 0x8086, 0x3B30, "3B30", "Intel(R) 5/3400 Series Chipset Family SMBus Controller" } ,
    { 0x8086, 0x3B32, "3B64", "Intel(R) 5/3400 Series Chipset Family Thermal Subsystem" } ,
    { 0x8086, 0x3B34, "3B34", "Standard Enhanced PCI to USB Host Controller" } ,
    { 0x8086, 0x3B3C, "3B3C", "Standard Enhanced PCI to USB Host Controller" } ,
    { 0x8086, 0x3B42, "3B42", "Intel(R) 5/3400 Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x3B44, "3B44", "Intel(R) 5/3400 Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x3B46, "3B46", "Intel(R) 5/3400 Series Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x3B48, "3B48", "Intel(R) 5/3400 Series Chipset Family PCI Express Root Port" } ,
    { 0x8086, 0x3B56, "3B56", "High Definition Audio Controller" } ,
    { 0x8086, 0x3b63, "ff1e1179", "06" } ,
    { 0x8086, 0x3B64, "3B64", "Management Engine Driver" } ,
    { 0x8086, 0x3B64, "REV_06", "Intel Management Engine Interface" } ,
    { 0x8086, 0x3B64, "Intel 3B09", "Management Engine Driver" } ,
    { 0x8086, 0x3B64, "REV_06", "Intel Management Engine Interface" } ,
    { 0x8086, 0x3B64, "REV_06", "Intel Management Engine Interface" } ,
    { 0x8086, 0x3B64, "REV_06", "intel" } ,
    { 0x8086, 0x3b64, "ven_8086&dev_3b64&subsys_fd3c1179&rev_06", "ven_8086&dev_3b64&subsys_fd3c1179&rev_06 [Toshiba C660-1CN]" } ,
    { 0x8086, 0x3b65, "ff1e1179", "06" } ,
    { 0x8086, 0x3B67, "Vendor ID 0x8086 ", "Intel(R) Active Management Technology - Serial Over LAN (SOL) " } ,
    { 0x8086, 0x4000, "Creatix", "V.90 HaM Modem" } ,
    { 0x8086, 0x402f, "-", "Intel (R) 5400 Chipset QuickData Technology device - 402F" } ,
    { 0x8086, 0x4220, "Intel Pro/Wireless 2200BG", "Intel 54 MBit/s Notebook WLAN Card" } ,
    { 0x8086, 0x4222, "10208086", "Intel 3945ABG Wireless LAN controller" } ,
    { 0x8086, 0x4223, "2915ABG", "Intel (R) PRO/Wireless 2200BG Network Connection, (R) PRO/Wireless 2915ABG Network Connection" } ,
    { 0x8086, 0x4223, "2915ABG", "Intel (R) PRO/Wireless 2200BG Network Connection, (R) PRO/Wireless 2915ABG Network Connection" } ,
    { 0x8086, 0x4224, "Intel Pro Wireless 2915ABG", "802.11a/b/g WLan adapter" } ,
    { 0x8086, 0x4227, "3945ABG", "Intel(R) PRO/Wireless 3945ABG" } ,
    { 0x8086, 0x4229, "Intel 4965AGN", "Intel� Wireless WiFi Link 4965AGN(supporting 802.11a/b/g/Draft-N)" } ,
    { 0x8086, 0x422B, " ", "Intel(R) Centrino(R) Ultimate-N 6300 AGN" } ,
    { 0x8086, 0x422C, "BCM4311KFBG", "Intel(R) Centrino(R) Advanced-N 6200 AGN" } ,
    { 0x8086, 0x422D, "Intel 4965AGN", "Intel� Wireless WiFi Link 4965AGN" } ,
    { 0x8086, 0x4230, "Intel 4965AGN", "Intel� Wireless WiFi Link 4965AGN" } ,
    { 0x8086, 0x4232, "Intel� WiFi Link 5100", "Carte Intel� WiFi Link 5100 AGN" } ,
    { 0x8086, 0x4233, "Intel 4965AGN", "Intel� Wireless WiFi Link 4965AGN" } ,
    { 0x8086, 0x4235, "5300AGN", "Intel� WiFi Link 5300 AGN" } ,
    { 0x8086, 0x4236, "5300AGN", "Intel(R) WiFi Link 5300 AGN" } ,
    { 0x8086, 0x4237, "27DA", "Intel (R) WiFi Link 5100 AGN" } ,
    { 0x8086, 0x4238, "6300", "Intel Centrino Ultimate-N 6300 AGN" } ,
    { 0x8086, 0x4239, "0x4239", "Intel(R) Centrino(R) Advanced-N 6200 AGN" } ,
    { 0x8086, 0x423A, "5350AGN", "PRO/Wireless 5350 AGN [Echo Peak]" } ,
    { 0x8086, 0x423C, "5150AGN", "WiMAX/WiFi Link 5150" } ,
    { 0x8086, 0x4318, "1370 (0280)", "Dell Wireless 1370 WLAN Mini-PCI Card" } ,
    { 0x8086, 0x444E, "TurboMemory", "Intel TurboMemory" } ,
    { 0x8086, 0x4813, "1370 (0280)", "Dell Wireless 1370 WLAN Mini-PCI Card" } ,
    { 0x8086, 0x482, "82375MB", "PCI\\VEN8086" } ,
    { 0x8086, 0x4836, "242121", "2425678" } ,
    { 0x8086, 0x4888, "3945", "intel 3945abg wireless lan controller" } ,
    { 0x8086, 0x5001, "\\Device\\0000004c", "Modem - PPP" } ,
    { 0x8086, 0x5005, "PRO/DSL 2200", "Modem - PPPoA" } ,
    { 0x8086, 0x5029, "?(EP80579)", "AHCI Controller" } ,
    { 0x8086, 0x502A, "Tolaoai", "SATA Controller" } ,
    { 0x8086, 0x502B, "Tolapai", "SATA Controller" } ,
    { 0x8086, 0x5200, "NH82801GR", "PCI to PCI Bridge" } ,
    { 0x8086, 0x5201, "i960", "Network Controller" } ,
    { 0x8086, 0x5309, "80303", "I/O Processor Address Translation Unit" } ,
    { 0x8086, 0x530D, "80312", "I/O Companion Unit Address Translation" } ,
    { 0x8086, 0x6741, "0x8086", "Intel USB 3.0" } ,
    { 0x8086, 0x6960, "", "EHCI 960 emulator" } ,
    { 0x8086, 0x7000, "82371SB", "PIIX3 PCI-to-ISA Bridge (Triton II)" } ,
    { 0x8086, 0x7010, "82371SB", "PIIX3 IDE Interface (Triton II)" } ,
    { 0x8086, 0x7020, "82371SB", "PIIX3 USB Host Controller (Triton II)" } ,
    { 0x8086, 0x7030, "82437VX", "System Controller" } ,
    { 0x8086, 0x7051, "PB 642365-003", "Intel Business Video Conferencing Card" } ,
    { 0x8086, 0x7100, "82439TX", "System Controller (MTXC), part of 430TX chipset" } ,
    { 0x8086, 0x7110, "82371AB/EB/MB", "Intel 82371AB/EB PCI to ISA bridge (ISA mode)" } ,
    { 0x8086, 0x7111, "82371AB/EB/MB", "Intel(R) 82371AB/EB PCI Bus Master IDE Controller" } ,
    { 0x8086, 0x7112, "82371AB/EB/MB", "PIIX4/4E/4M USB Interface" } ,
    { 0x8086, 0x7113, "82371AB/EB/MB", "PIIX4/4E/4M Power Management Controller" } ,
    { 0x8086, 0x7120, "Intel(R) 82801IMB", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x7121, "801F104", "Graphics Controller" } ,
    { 0x8086, 0x7122, "82810-DC100", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x7123	, "82810-DC100", "Intel® 82810 Graphics Controller" } ,
    { 0x8086, 0x7123, "82810-DC100", "Intel� 82810 Graphics Controller" } ,
    { 0x8086, 0x7124, "82810E", "Host-Hub Interface Bridge / DRAM Ctrlr" } ,
    { 0x8086, 0x7125, "82810E", "Intel Direct AGP 810Chipset " } ,
    { 0x8086, 0x7126, "82810-DC133", "Host Bridge and Memory Controller Hub" } ,
    { 0x8086, 0x7127, "82810-DC133", "Graphics Device (FSB 133 MHz)" } ,
    { 0x8086, 0x7128, "82810-M DC-100", "Host Bridge and Memory Controller Hub" } ,
    { 0x8086, 0x712A, "82810-M DC-133", "Host Bridge and Memory Controller Hub" } ,
    { 0x8086, 0x7180, "rmc", "Host/PCI bridge in 440LX/EX AGP chipset" } ,
    { 0x8086, 0x7181, "82443 ex/lx", "AGP device in 440LX/EX AGP chipset" } ,
    { 0x8086, 0x7182, "440LX/EX", "intel" } ,
    { 0x8086, 0x7190, "82443BX/ZX", "Intel 82443BX Pentium(R) II Processor to PCI Bridge" } ,
    { 0x8086, 0x7191, "82443BX/ZX", "Intel 82443BX Pentium(R) II Processor to AGP Controller" } ,
    { 0x8086, 0x7192, "82443BX/ZX", "440BX/ZX chipset Host-to-PCI Bridge" } ,
    { 0x8086, 0x7194, "82443MX", "AC'97 Audio device" } ,
    { 0x8086, 0x7195, "82443MX", "AC97 Audio Controller" } ,
    { 0x8086, 0x7196, "82440 - 443MX", "AC97 Modem Controller (Winmodem)" } ,
    { 0x8086, 0x7198, "82443MX", "PCI to ISA Bridge" } ,
    { 0x8086, 0x7199, "82443MX", "EIDE Controller" } ,
    { 0x8086, 0x719A, "82443MX", "USB Universal Host Controller" } ,
    { 0x8086, 0x719B, "82443MX", "Power Management Controller" } ,
    { 0x8086, 0x71A0, "82443GX", "Host-to-PCI Bridge" } ,
    { 0x8086, 0x71A1, "intel 82801 IB ICH9 ", "fabricated by Intel " } ,
    { 0x8086, 0x71A2, "82443GX", "Host-to-PCI Bridge" } ,
    { 0x8086, 0x7221, "82810", "graphics device" } ,
    { 0x8086, 0x7600, "82372FB/82468GX", "LPC/FWH Interface" } ,
    { 0x8086, 0x7601, "82372FB/82468GX", "EIDE Controller" } ,
    { 0x8086, 0x7602, "82372FB/82468GX", "USB Host Controller" } ,
    { 0x8086, 0x7603, "82372FB/82468GX", "SM Bus Controller" } ,
    { 0x8086, 0x7605, "82372FB", "IEEE1394 OpenHCI Host Controller" } ,
    { 0x8086, 0x7800, "82740", "AGP Graphics Accelerator" } ,
    { 0x8086, 0x7800, "PCI\\VEN_8086&DEV_3B64&CC_0780", "PCI\\VEN_8086&DEV_3B64&CC_0780" } ,
    { 0x8086, 0x803b, "0x104d", "0x81ef" } ,
    { 0x8086, 0x8083, "Intel PM45", "Intel Wireless WiFi Link 5100 ABGN 10/100/1000 Base T" } ,
    { 0x8086, 0x8086, "http://dlcdnet.asus.com/pub/ASUS/nb/Drivers/MEI/ME", "0x8086&DEV_3B64&CC_0780" } ,
    { 0x8086, 0x8086, "9.3.0.1019", "intel" } ,
    { 0x8086, 0x8086, "VIA vynil v700b", "VIA vynil v700b" } ,
    { 0x8086, 0x8086, "SUBSYS_148A103C", "REV_00\\3&61AAA01&0&50 " } ,
    { 0x8086, 0x8086, "82801DBM SoundMax Controller", "VIA vynil v700b" } ,
    { 0x8086, 0x8086, "SUBSYS_03701025", "pci simple communications controller" } ,
    { 0x8086, 0x8086, "SUBSYS_144A103C", "pci simple communications controller" } ,
    { 0x8086, 0x8086, "Intel 3B69Management Engine Driver", "Management Engine Driver" } ,
    { 0x8086, 0x8086, "(0x2994)", "Intel(R) Management Engine Interface" } ,
    { 0x8086, 0x8108, "SCH US15WP", "Intel(R) Graphics Media Accelerator 500  https://downloadcenter.intel.com/confirm.aspx?httpDown=http" } ,
    { 0x8086, 0x811A, "Atom SCH", "Atom SCH PATA" } ,
    { 0x8086, 0x8186, "i dont know", "i dont know" } ,
    { 0x8086, 0x8280, "24D5", "Realtek AC97" } ,
    { 0x8086, 0x84C4, "82454KX/GX", "450KX/GX PCI Bridge (Orion)" } ,
    { 0x8086, 0x84C5, "82453KX/GX", "450KX/GX Memory Controller (Orion)" } ,
    { 0x8086, 0x84CA, "82451NX", "450NX PCIset Memory & I/O Controller" } ,
    { 0x8086, 0x84CB, "82454NX/82467GX", "PCI Expander Bridge" } ,
    { 0x8086, 0x84E0, "82461GX", "System Address controller" } ,
    { 0x8086, 0x84E1, "82462GX", "System Data Controller" } ,
    { 0x8086, 0x84E2, "82465GX", "Graphics Expander Bridge" } ,
    { 0x8086, 0x84E3, "82463GX", "Memory Address Controller" } ,
    { 0x8086, 0x84E4, "82464GX", "Memory Data Controller" } ,
    { 0x8086, 0x84E6, "82466GX", "Wide and fast PCI eXpander Bridge" } ,
    { 0x8086, 0x84EA, "82460GX", "AGP Bridge (GXB function 1)" } ,
    { 0x8086, 0x85A1, "6300ESB", "LPC Bridge" } ,
    { 0x8086, 0x85A2, "6300ESB", "IDE Controller" } ,
    { 0x8086, 0x85A3, "6300ESB", "Serial ATA Controller" } ,
    { 0x8086, 0x85A4, "6300ESB", "SMBus Controller" } ,
    { 0x8086, 0x85A6, "6300ESB", "AC'97 Audio Controller" } ,
    { 0x8086, 0x85A7, "6300ESB", "AC'97 Modem Controller" } ,
    { 0x8086, 0x85A9, "6300ESB", "USB 1.1 UHCI Controller #1" } ,
    { 0x8086, 0x85AA, "6300ESB", "USB 1.1 UHCI Controller #2" } ,
    { 0x8086, 0x8C02, "C220", "Intel(R) 8 Series/C220 Series SATA AHCI Controller" } ,
    { 0x8086, 0x8C22, "8C22", "Intel(R) 8 Series/C220 Series SMBus Controller" } ,
    { 0x8086, 0x8c31, "PCI\\VEN_8086&DEV_8C3A&SUBSYS_85341043&REV_04", "Intel USB 3.0 eXtensible" } ,
    { 0x8086, 0x8C3A, "0x8C31", "Intel(R) Management Engine Interface" } ,
    { 0x8086, 0x8C5C, "8C5C", "Intel(R) H81 LPC Controller" } ,
    { 0x8086, 0x8CBA, "PCI\\VEN_8086&DEV_8CBA&SUBSYS_8CBA1849&REV_00", "PCI Simple Communications Controller" } ,
    { 0x8086, 0x8d3a, "PCI\\VEN_8086&DEV_8D3A&SUBSYS_86001043", "Intel Management Engine Interface (MEI)" } ,
    { 0x8086, 0x9620, "", "I2O RAID PCI to PCI Bridge" } ,
    { 0x8086, 0x9621, "SRCU21", "I2O 1.5 RAID Controller" } ,
    { 0x8086, 0x9622, "SRCUxx", "I2O 1.5 RAID Controller" } ,
    { 0x8086, 0x9641, "SRCU31", "I2O 1.5 RAID Controller" } ,
    { 0x8086, 0x96A1, "SRCU31L", "I2O 1.5 RAID Controller" } ,
    { 0x8086, 0x9779, "0x2992", "0x2992" } ,
    { 0x8086, 0x9874, "AC97", "AUDIO CONTROLLER" } ,
    { 0x8086, 0x9876, "i845", "intel brokdale" } ,
    { 0x8086, 0x9876, "80860101", "IntcDAudModel" } ,
    { 0x8086, 0x9877, "1", "1" } ,
    { 0x8086, 0x9888, "HDAUDIO\\FUNC_01&VEN_8086&DEV_27d8&SUBSYS_80860101&", "HDAUDIO\\FUNC_01&VEN_8086&DEV_27d8&REV_1000" } ,
    { 0x8086, 0x9998, "42468068", " 02" } ,
    { 0x8086, 0x9999, "pci30b2103c", "Interface chip" } ,
    { 0x8086, 0x9C03, "9C03", "Intel(R) 8 Series SATA Controller" } ,
    { 0x8086, 0x9C14, "9C14", "Intel(R) 9 Series PCI Express Root Port" } ,
    { 0x8086, 0x9C20, "9C20", "High Definition Audio Controller" } ,
    { 0x8086, 0x9C22, "9C22", "Intel(R) 8 Series SMBus Controller" } ,
    { 0x8086, 0x9C24, "9C24", "Intel(R) 8 Series Thermal" } ,
    { 0x8086, 0x9C26, "9C26", "Intel(R) 8 Series USB Enhanced Host Controller" } ,
    { 0x8086, 0x9C31, "Unknown", "Intel USB 3.0 eXtensible Host Controller" } ,
    { 0x8086, 0x9C3A, "PCI\\VEN_8086", "Intel Management Engine Interface driver" } ,
    { 0x8086, 0x9c3a,  "Subsys_05eb1", "PCI Simple Communication Controller" } ,
    { 0x8086, 0x9C43, "9C43", "Intel(R) 8 Series LPC Controller" } ,
    { 0x8086, 0x9CB1, "PCI\\VEN_8086&DEV_9CB1", "Intel USB 3.0 Driver for Intel 8 and U/Y Series " } ,
    { 0x8086, 0xA001, "3150", "Intel Media Accelerator 3150" } ,
    { 0x8086, 0xA002, "GMA 3150", "Intel� Grafik-Media-Accelerator 3150 (Intel� GMA 3150)" } ,
    { 0x8086, 0xA011, "02\\3", "Intel(R) Graphics Media Accelerator 3150" } ,
    { 0x8086, 0xA012, "GMA3150", "Intel� Graphics Media Accelerator 3150" } ,
    { 0x8086, 0xA011, "02\\3", "3&33FD14CA&0&10" } ,
    { 0x8086, 0xA012, "0x0283E", "Intel(R) ICH8 Family SMBus Controller" } ,
    { 0x8086, 0xB152, "S21152BB", "PCI to PCI Bridge" } ,
    { 0x8086, 0xB154, "1C20", "PCI to PCI Bridge" } ,
    { 0x8086, 0xB555, "21555", "Non-Transparent PCI-to-PCI Bridge" } ,
    { 0x8086, 0xC50, "fd", "sdf" } ,
    { 0x8086, 0xE13A, "7600", "NXMOQSN00430812D49" } ,
    { 0x8086, 0xF4E, "0F4E", "Intel(R) Pentium(R)/Celeron(R) processor N-/J- series PCI Express Root Port" } ,
    { 0x8086, 0x27DA, "11583659", "PCI\\VEN_8086&DEV_27DA&SUBSYS_31031565" } ,
    { 0x8086, 0x8C22, "11583659", "PCI\\VEN_8086&DEV_8C22&SUBSYS_FA301179&REV_04\\3&11583659&0&FB" } ,
    { 0x8086, 0x3B64, "11583658", "PCI\\VEN_8086&DEV_3B64&SUBSYS_04821025&REV_06" } ,
    { 0x8086, 0x27c8, "PCI\\VEN_8086&DEV_27D8&SUBSYS_02D61028&REV_01\\3&61A", "Microsoft UAA Bus HD Audio" } ,
    { 0x8086, 0x27d8, "A62516F3", "INTEL IDT Audio" } ,
    { 0x8086, 0x999, "2930", "PCI\\VEN_8086&DEV_2930&SUBSYS_037E1014&REV_02\\3&61AAA01&0&FB" } ,
    { 0x8086, 0x1E3A, "0c05", "i5-3210" } ,
    { 0x8086, 0x3B64, "3b69", "Chip Description:Management Engine Driver" } ,
    { 0x8086, 0x1C3A, "8086", "Intel(R) Management Engine Interface" } ,
    { 0x8086, 0x8671, "", "" } ,
    { 0x9004, 0x0078, "aic-7880x", "AHA-2940UW/CN" } ,
    { 0x9004, 0x1078, "AIC-7810C", "RAID Coprocessor" } ,
    { 0x9004, 0x1135, "0x0035", "Texas Instruments" } ,
    { 0x9004, 0x1160, "AIC-1160", "Fibre Channel Adapter" } ,
    { 0x9004, 0x2178, "AIC-7821", "SCSI Controller" } ,
    { 0x9004, 0x3860, "", "AIC-2930U Ultra SCSI Ctrlr" } ,
    { 0x9004, 0x3B78, "AHA-4944W/4944UW", "QuadChannel Fast-Wide/Ultra-Wide Diff. SCSI Ctrlr" } ,
    { 0x9004, 0x5075, "AIC-755x", "SCSI Ctrlr" } ,
    { 0x9004, 0x5078, "AIC-7850P", "Fast/Wide SCSI Controller" } ,
    { 0x9004, 0x5175, "AIC-755x", "SCSI Ctrlr" } ,
    { 0x9004, 0x5178, "AIC-7850", "FAST-SCSI Ctrlr" } ,
    { 0x9004, 0x5275, "AIC-755x", "SCSI Ctrlr" } ,
    { 0x9004, 0x5278, "AIC-7850", "Fast SCSI Ctrlr" } ,
    { 0x9004, 0x5375, "AIC-755x", "SCSI Ctrlr" } ,
    { 0x9004, 0x5378, "AIC-7850", "Fast SCSI Ctrlr" } ,
    { 0x9004, 0x5475, "AIC-755x", "SCSI Ctrlr" } ,
    { 0x9004, 0x5478, "AIC-7850", "Fast SCSI Ctrlr" } ,
    { 0x9004, 0x5575, "AVA-2930", "SCSI Ctrlr" } ,
    { 0x9004, 0x5578, "AIC-7855", "Fast SCSI Ctrlr" } ,
    { 0x9004, 0x5675, "AIC-755x", "SCSI Ctrlr" } ,
    { 0x9004, 0x5678, "AIC-7856", "Fast SCSI Ctrlr" } ,
    { 0x9004, 0x5775, "AIC-755x", "SCSI Ctrlr" } ,
    { 0x9004, 0x5778, "AIC-7850", "Fast SCSI Ctrlr" } ,
    { 0x9004, 0x5800, "AIC-5800", "PCI-to-1394 Ctrlr" } ,
    { 0x9004, 0x5900, "ANA-5910/30/40", "ATM155 & 25 LAN Controller" } ,
    { 0x9004, 0x5905, "ANA-5910A/30A/40A", "ATM Adpater" } ,
    { 0x9004, 0x6038, "AHA-2930C", "Ultra SCSI Adpater (VAR)" } ,
    { 0x9004, 0x6075, "AIC-7560?", "CardBus Ultra SCSI Controller" } ,
    { 0x9004, 0x6078, "AIC-7860", "PCI SCSI Controller" } ,
    { 0x9004, 0x6178, "AIC-7861", "PCI SCSI Controller" } ,
    { 0x9004, 0x6278, "AIC-7860", "SCSI Ctrlr" } ,
    { 0x9004, 0x6378, "AIC-7860", "SCSI Ctrlr" } ,
    { 0x9004, 0x6478, "AIC-786x", "SCSI Ctrlr" } ,
    { 0x9004, 0x6578, "AIC-786x", "SCSI Ctrlr" } ,
    { 0x9004, 0x6678, "AIC-786x", "SCSI Ctrlr" } ,
    { 0x9004, 0x6778, "AIC-786x", "SCSI Ctrlr" } ,
    { 0x9004, 0x6915, "ANA620xx/69011A", "Fast Ethernet" } ,
    { 0x9004, 0x7078, "AIC-7870", "Fast and Wide SCSI Ctrlr" } ,
    { 0x9004, 0x7178, "AHA-2940/2940W", "Fast/Fast-Wide SCSI Ctrlr" } ,
    { 0x9004, 0x7278, "AHA-3940/3940W", "Multichannel Fast/Fast-Wide SCSI Ctrlr" } ,
    { 0x9004, 0x7378, "AHA-3985", "4-chan RAID SCSI Ctrlr" } ,
    { 0x9004, 0x7478, "AHA-2944", "SCSI Ctrlr" } ,
    { 0x9004, 0x7578, "AHA-3944/3944W", "Multichannel Fast/Fast-Wide Diff. SCSI Ctrlr" } ,
    { 0x9004, 0x7678, "AHA-4944W/4944UW", "QuadChannel Fast-Wide/Ultra-Wide Diff. SCSI Ctrlr" } ,
    { 0x9004, 0x7778, "AIC-787x", "SCSI Ctrlr" } ,
    { 0x9004, 0x7810, "aic 7810", "Memory control IC" } ,
    { 0x9004, 0x7815, "AIC-7515", "RAID + Memory Controller IC" } ,
    { 0x9004, 0x7850, "aic-7850P", "Fast/Wide SCSI-2 Controller" } ,
    { 0x9004, 0x7855, "AHA-2930", "Single channel SCSI Host Adapter" } ,
    { 0x9004, 0x7860, "AIC-7860", "PCI SCSI Controller" } ,
    { 0x9004, 0x7870, "AIC-7870", "Fast/Wide SCSI-2 Controller" } ,
    { 0x9004, 0x7871, "aha 2940", "SCSI" } ,
    { 0x9004, 0x7872, "aha 3940", "Multiple SCSI channels" } ,
    { 0x9004, 0x7873, "aha 3985", "Multiple SCSI channels" } ,
    { 0x9004, 0x7874, "aha 2944", "Differential SCSI" } ,
    { 0x9004, 0x7880, "aic7880p", "Fast 20 SCSI" } ,
    { 0x9004, 0x7890, "AIC-7890", "SCSI controller" } ,
    { 0x9004, 0x7891, "AIC-789x", "SCSI controller" } ,
    { 0x9004, 0x7892, "AIC-789x", "SCSI controller" } ,
    { 0x9004, 0x7893, "AIC-789x", "SCSI controller" } ,
    { 0x9004, 0x7894, "AIC-789x", "SCSI controller" } ,
    { 0x9004, 0x7895, "AIC-7895", "Ultra-Wide SCSI Ctrlr on AHA-2940 AHA-394x" } ,
    { 0x9004, 0x7896, "AIC-789x", "SCSI controller" } ,
    { 0x9004, 0x7897, "AIC-789x", "SCSI controller" } ,
    { 0x9004, 0x8078, "AIC-7880P", "Ultra Wide SCSI" } ,
    { 0x9004, 0x8178, "AHA-2940U/2940UW", "Ultra/Ultra-Wide SCSI Ctrlr" } ,
    { 0x9004, 0x8278, "AHA-3940Uxx", "AHA-3940U/3940UW/3940UWD SCSI Ctrlr" } ,
    { 0x9004, 0x8378, "AIC-7883U", "SCSI Controller" } ,
    { 0x9004, 0x8478, "ADAPTEC 2940UW CN SCSI", "Ultra-Wide Diff. SCSI Ctrlr" } ,
    { 0x9004, 0x8578, "AHA-3944U/3944UWD", "Fast-Wide/Ultra-Wide Diff. SCSI Ctrlr" } ,
    { 0x9004, 0x8678, "AHA-4944UW", "QuadChannel Ultra-Wide Diff. SCSI Ctrlr" } ,
    { 0x9004, 0x8778, "AIC-788x", "Ultra-Wide SCSI Ctrlr" } ,
    { 0x9004, 0x8878, "AIC-7888?", "Ultra Wide SCSI Controller" } ,
    { 0x9004, 0x8B78, "ABA-1030", "AIC-7880P" } ,
    { 0x9004, 0xEC78, "AHA-4944W/4944UW", "QuadChannel Fast-Wide/Ultra-Wide Diff. SCSI Ctrlr" } ,
    { 0xD4D4, 0x010F, "PMC-211", "PMC-211" } ,
    { 0xD4D4, 0x0601, "", "PCI Mezzanine Card" } ,
    { 0xDEAF, 0x9050, "", "PC Weasel PCI VGA Device" } ,
    { 0xDEAF, 0x9051, "", "PC Weasel PCI Serial Comm. Device" } ,
    { 0xDEAF, 0x9052, "", "PC Weasel PCI" } ,
    { 0xE159, 0x0001, "Ambient MD3200 A", "Yeastar TDM400" } ,
    { 0xE159, 0x0002, "", "Sedlbauer Speed PCI" } ,
    { 0xE159, 0x0600, "Tiger 600", "PCI-to-PCI Bridge" } ,
    { 0xEDD8, 0xA091, "ARK1000PV", "Stingray GUI Accelerator" } ,
    { 0xEDD8, 0xA099, "ARK2000PV", "Stingray GUI Accelerator" } ,
    { 0xEDD8, 0xA0A1, "ARK2000MT", "Stingray 64" } ,
    { 0xEDD8, 0xA0A9, "ARK2000MI", "Quadro645 GUI Accelerator" } ,
    { 0xEDD8, 0xA0B1, "ARK2000MI+", "GUI Accelerator" } ,
    { 0x1519, 0x0020, "0123456789", "HSIC Device" } ,
    { 0x1519, 0x2004, "1", "PCI Interface bus" } ,
    { 0x151B, 0x9080, "me594v02100 combox", "combox cb 300a" } ,
    { 0x151D, 0x9876, "?", "?" } ,
    { 0x151F, 0x0001, "TOPIC FM-56PCI-TP", "TOPIC FM-56PCI-TP" } ,
    { 0x151F, 0x0568, "1.0.1.8", "56k Internal Data Fax Voice Modem" } ,
    { 0x1435, 0x0531, "DELETE", "DELETE" } ,
    { 0x1435, 0x6020, "SPM6020", "PCI-104 dspModule" } ,
    { 0x1435, 0x6030, "SPM6030", "PC/104-Plus dspModule" } ,
    { 0x1435, 0x6420, "SPM186420", "PC/104-Plus dspModule" } ,
    { 0x1435, 0x6430, "SPM176430", "PC/104-Plus dspModule" } ,
    { 0x1435, 0x7520, "DM7520", "PC/104-Plus dataModule" } ,
    { 0x1435, 0x7540, "SDM7540", "PC/104-Plus dataModule with SmartCal" } ,
    { 0x1524, 0x0751, "08011558", "pci" } ,
    { 0x1524, 0x0100, "ACPI\\ENE0100 ", "ENE CIR Receiver " } ,
    { 0x1524, 0x0510, "1.4.5.0", "PCI Memory Card Reader Controller" } ,
    { 0x1524, 0x0530, "CB-712/714/810", "Memory Stick Card Reader" } ,
    { 0x1524, 0x0550, "CB-712/714/810", "Secure Digital Card Reader" } ,
    { 0x1524, 0x0551, "10C11734", "ven1524&dev_0551&SUBSYS_009F1025&REV_01" } ,
    { 0x1524, 0x0555, "10c11734", "ven1524&dev_0551&SUBSYS_009F1025&REV_01" } ,
    { 0x1524, 0x0610, "???", "PCI Smart Card Reader Controller" } ,
    { 0x1524, 0x0730, "0x0751", "CardBus Controller" } ,
    { 0x1524, 0x100, "ACPI/ENE0100/3&21436425&0", "ENE CIR Receiver" } ,
    { 0x1524, 0x1025, "1025123", "PCI\\VEN_127a&DEV_1025&SUBSYS_1025123A&REV_01\\4&1351887D&0&58F0" } ,
    { 0x1524, 0x1211, "CB-1211", "CardBus Controller" } ,
    { 0x1524, 0x1225, "CB-1225", "CardBus Controller" } ,
    { 0x1524, 0x1410, "CB-1420", "CardBus Controller" } ,
    { 0x1524, 0x1411, "CB-710/2/4/810", "pci device" } ,
    { 0x1524, 0x1412, "CB-712/714/810", "Cardbus Controller" } ,
    { 0x1524, 0x1420, "CB-1420", "CardBus Controller" } ,
    { 0x1524, 0x1421, "CB-720/2/4", "CardBus Controller" } ,
    { 0x1524, 0x1422, "CB-722/4", "CardBus Controller" } ,
    { 0x1524, 0x510, "1.4.5.0", "PCI Memory Card Reader Controller" } ,
    { 0x1524, 0x551, "10C11734", "ven1524&dev_0551&SUBSYS_009F1025&REV_01" } ,
    { 0x1524, 0x9876, "1941", "1941" } ,
    { 0x1524, 0xFC10, "card bus", "pci device" } ,
    { 0x152D, 0x2329, "2338", "J micron JM20329" } ,
    { 0x152D, 0x2519, "n/a", "JMicron Technology Corp. / JMicron USA Technology Corp" } ,
    { 0x152E, 0x2507, "0", "0" } ,
    { 0x1538, 0x0301, "ARS106S", "Tekram DC200 PATA100 RAID Controller" } ,
    { 0x1538, 0x0303, "ARS0304S", "ARS0304S PATA133 RAID5" } ,
    { 0x153B, 0x1115, "ICE1712 Envy24", "IC Ensemble Inc ICE1712 Envy24 Multichannel Audio Controller" } ,
    { 0x153B, 0x1143, "SAA7134HL", "Philips Semiconductors SAA7134HL Multimedia Capture Device" } ,
    { 0x153B, 0x6003, "CS4614/22/24", "CrystalClear SoundFusion PCI Audio Accel" } ,
    { 0x153F, 0xdead, "xx12345", "Not a chip ..." } ,
    { 0x1540, 0x9524, "saa7130", "PAL/SECAM TV card w/ FM1216ME MK3 tuner (+FM radio)" } ,
    { 0x1693, 0x0212, "PLX PCI9054", "EPONINE ESR-PCI Board" } ,
    { 0x1693, 0x0213, "Motorola MPC8245", "EPONINE MTM120 PCI Board" } ,
    { 0x170B, 0x0100, "NSP2000-SSL", "Crypto Aceletator" } ,
    { 0x1743, 0x8139, "ROL/F-100", "Fast Ethernet Adapter with ROL" } ,
    { 0x1522, 0x0100, "PBridge+", "PCI Interface Chip" } ,
    { 0x1543, 0x1052, "30201543", "Modem Intel 537EP (Chipset KAIOMY)" } ,
    { 0x1543, 0x3052, "30201543", "Modem Intel 537EP (Chipset KAIOMY)" } ,
    { 0x1543, 0x3155, "InfineonTPMProfessional", "ModemDeviceonHighDefinitionAudioBus" } ,
    { 0x1555, 0x0002, "PLX PCI 9050", "Easylon PCI Bus Interface" } ,
    { 0x1549, 0x80FF, "PCI-ISA-001", "PCI/ISA Bus Bridge" } ,
    { 0x154A, 0x9016, "AF9016", "USB DVB-T Device AF9015" } ,
    { 0x154A, 0x9876, "AF9015", "USB DVB-T Device  CE950081" } ,
    { 0x154B, 0x3038, "VT6212L", "USB" } ,
    { 0x1556, 0x5555, "001", "an cpci application" } ,
    { 0x1558, 0x1558, "0x1558", "gtx 670mx GPU" } ,
    { 0x155E, 0x0020, "MFC3", "Multi Function Card Version 3" } ,
    { 0x1562, 0x0001, "LA-41x3", "Spectrum24 Wireless LAN PCI Card" } ,
    { 0x1562, 0x0002, "LA-5030", "Symbol Wireless Networker 802.11a/g CardBus" } ,
    { 0x1562, 0x0003, "LA-5033", "Symbol Wireless Networker 802.11a/g PCI" } ,
    { 0x156A, 0x5000, "NA", "Wideband Advanced Signal Processor" } ,
    { 0x156A, 0x5100, "NA", "High Data Rate Radio" } ,
    { 0x16CA, 0x0001, "Rocket Drive", "Solid State Disk" } ,
    { 0x1571, 0xA001, "TFF", "GHB" } ,
    { 0x1571, 0xA002, "CCSI PCI20-485D", "ARCnet" } ,
    { 0x1571, 0xA003, "CCSI PCI20-485X", "ARCnet" } ,
    { 0x1571, 0xA004, "CCSI PCI20-CXB", "ARCnet" } ,
    { 0x1571, 0xA005, "CCSI PCI20-CXS", "ARCnet" } ,
    { 0x1571, 0xA006, "CCSI PCI20-FOG-SMA", "ARCnet" } ,
    { 0x1571, 0xA007, "CCSI PCI20-FOG-ST", "ARCnet" } ,
    { 0x1571, 0xA008, "CCSI PCI20-TB5", "SONY" } ,
    { 0x1571, 0xA009, "CCSI PCI20-5-485", "5 Mbit ARCnet" } ,
    { 0x1571, 0xA00A, "CCSI PCI20-5-485D", "5 Mbit ARCnet" } ,
    { 0x1571, 0xA00B, "CCSI PCI20-5-485X", "5 Mbit ARCnet" } ,
    { 0x1571, 0xA00C, "CCSI PIC20-5-FOG-ST", "5 Mbit ARCnet" } ,
    { 0x1571, 0xA00D, "CCSI PCI20-5-FOG-SMA", "5 Mbit ARCnet" } ,
    { 0x1571, 0xA00E, "COM200C22", "ARCNET" } ,
    { 0x1571, 0xA201, "CCSI PCI22-485", "10 Mbit ARCnet" } ,
    { 0x1571, 0xA202, "CCSI PCI22-485D", "10 Mbit ARCnet" } ,
    { 0x1571, 0xA203, "CCSI PCI22-485X", "10 Mbit ARCnet" } ,
    { 0x1571, 0xA204, "CCSI PCI22-CHB", "10 Mbit ARCnet" } ,
    { 0x1571, 0xA205, "CCSI PCI22-FOG-ST", "10 Mbit ARCnet" } ,
    { 0x1571, 0xA206, "CCSI PCI22-THB", "10 Mbit ARCnet" } ,
    { 0x173B, 0x03E8, "AC1000", "Gigabit Ethernet Adapter" } ,
    { 0x173B, 0x03EA, "AC1002", "Gigabit Ethernet Adapter" } ,
    { 0x1584, 0x5054, "VAS5055", "VAS Vetronix Automotive Service" } ,
    { 0x1584, 4003, "VAS5052", "VAS Vetronix Automotive Service" } ,
    { 0x1586, 0x0803, "", "" } ,
    { 0x1588, 0x1100, "PAX.port 1100", "PAX.ware 1100 dual Gb classifier engine" } ,
    { 0x1588, 0x2000, "AMD '971", "SNP 8023 packet classifier - AMD component" } ,
    { 0x1588, 0x8023, "SNP8023", "PAX.ware 100 packet classifier" } ,
    { 0x158B, 0x0005, "HLF-VMPEU560-C", "Standar HSP Modem" } ,
    { 0x158B, 0x0015, "HLF-VMPEU560-C", "Standar HSP Modem Series" } ,
    { 0x17AA, 0x0106, "Intel HD Graphics 2000", "Intel Sandy Bridge-MB GT1 - Integrated Graphics Controller [D2/J1/Q0] [Lenovo" } ,
    { 0x17AA, 0x7145, "138A", "Mobility ATI Radeon X1400" } ,
    { 0x15A2, 0x0001, "TA700", "PCI Bus Analyzer/Exerciser" } ,
    { 0x17AF, 0x4150, "200", "HIS Excalibur Radeon 6870" } ,
    { 0x17AF, 0x7291, "RV560", "HIS  Radeon X1650 XT" } ,
    { 0x15B0, 0x0001, "FM-3986", "Pctel" } ,
    { 0x15B0, 0x0003, "FM-3986", "Pctel" } ,
    { 0x15B0, 0x2BD0, "2BD0", "soft56k voice,data,fax CARP" } ,
    { 0x15B3, 0x5274, "MT21108", "InfiniBridge" } ,
    { 0x15B3, 0x5A44, "MT23108", "InfiniHost I" } ,
    { 0x15B3, 0x6274, "MT25204", "InfiniHost III Lx" } ,
    { 0x15B3, 0x6278, "MT25208A0-FCC", "InfiniHost TM III Ex" } ,
    { 0x15B3, 0x6282, "MT25218", "MT25218 [InfiniHost III Ex]" } ,
    { 0x15B3, 0x634A, "MT2518", "Mellanox ConnectX VPI (MT2548) - PCIe 2.0 2.5GT/s, IB DDR /10GigE Network Adaptor" } ,
    { 0x15B3, 0x6732, "MT26418", "ConnectX VPI (MT26418) - PCIe 2.0 5GT/s, IB DDR / 10GigE" } ,
    { 0x15B8, 0x3009, "xPCI-3504", "Analog output board" } ,
    { 0x15BC, 0x0101, "n2530a", "DX2+ FC-AL Adapter" } ,
    { 0x15BC, 0x0103, "QX4", "4 Port Fibre Channel Controller" } ,
    { 0x15BC, 0x0B01, "SUBSYS_000015BC&REV_00", "Agilen PCI-GPIB" } ,
    { 0x15BC, 0x1200, "0x15bc", "Agilent QX4 Fibre Channel Controller" } ,
    { 0x15BC, 0x2530, "???", "HP Communications Port" } ,
    { 0x15BC, 0x2531, "???", "HP Toptools Remote Control Adapter" } ,
    { 0x15BC, 0x2532, "???", "HP Toptools Remote Control Adapter" } ,
    { 0x15BC, 0x2929, "E2929A", "PCI/PCI-X Bus Analyzer" } ,
    { 0x15C2, 0x0038, "2.4G", "part of the iMon-IR-RC-Display-Kit" } ,
    { 0x1394, 0x0001, "0x1394", "Gigabit Ethernet Adapter" } ,
    { 0x1394, 0x1394, "INTEL", "1394 Net adapter " } ,
    { 0x15D1, 0x0001, "TC11IB", "TriCore 32-bit Single-chip Microctrlr" } ,
    { 0x15D1, 0x0003, "PEB 20544 E v1.1", "6 Port Optimized Comm Ctrlr (SPOCC)" } ,
    { 0x15D1, 0x0004, "PNPA000", "Infineon Technologies AG" } ,
    { 0x15D1, 0x000B, "SLB9635", "TPM" } ,
    { 0x15D8, 0x9001, "", "" } ,
    { 0x15D9, 0x9876, "1234", "4567" } ,
    { 0x15DD, 0x7664, "vgn-ar51j", "idt high audio" } ,
    { 0x15DD, 0x7680, "2772", "SIGMATEL STAC 92XX C-Major HD Audio" } ,
    { 0x15DD, 0x769, "7690", "9200 HD Аудио КОДЕК" } ,
    { 0x15DD, 0x7690, "10F70000", "You'll Love me 4 this/ visit http://wendhelofopportunity.info Support Me!" } ,
    { 0x15DD, 0x8384, "HDAUDIO\\FUNC_01&VEN_8384&DEV_7616&SUBSYS_1028020A&", "Intel Audio Studio" } ,
    { 0x15DD, 0x9876, "1", "1" } ,
    { 0x15E0, 0x7134, "01385168", "01" } ,
    { 0x15E2, 0x0500, "", "Internet PhoneJack PCI Card" } ,
    { 0xEACE, 0x24C5, "1", "VIA Vynil v700b" } ,
    { 0xEACE, 0x3100, "DAG 3.10", "OC-3/OC-12" } ,
    { 0xEACE, 0x3200, "DAG 3.2x", "OC-3/OC-12" } ,
    { 0xEACE, 0x320E, "DAG 3.2E", "Fast Ethernet" } ,
    { 0xEACE, 0x340E, "DAG 3.4E", "Fast Ethernet" } ,
    { 0xEACE, 0x341E, "DAG 3.41E", "Fast Ethernet" } ,
    { 0xEACE, 0x3500, "DAG 3.5", "OC-3/OC-12" } ,
    { 0xEACE, 0x351C, "DAG 3.5ECM", "Fast Ethernet" } ,
    { 0xEACE, 0x4100, "DAG 4.10", "OC-48" } ,
    { 0xEACE, 0x4110, "DAG 4.11", "OC-48" } ,
    { 0xEACE, 0x4200, "DAG 4.2", "OC-48" } ,
    { 0xEACE, 0x420E, "DAG 4.2E", "Dual Gigabit Ethernet" } ,
    { 0xEACE, 0x430e, "DAG 4.3E", "Dual Gigabit Ethernet" } ,
    { 0x15E6, 0x00000002, "1646t00", "v.90 Lucent Modem" } ,
    { 0x15E7, 0x755, "QUAD-P", "NTDS Parallel Adapter" } ,
    { 0x15E8, 0x0130, "NCP130", "Wireless NIC" } ,
    { 0x15E8, 0x0131, "Prism II", "InstantWave HR PCI card" } ,
    { 0x15E9, 0x1841, "NetStaQ ADMA-100", "ATA controller" } ,
    { 0x15EF, 0x0028, "8280BDM SoundMAX Controller (ICH7-M B0 Setup)", "SigmaTelHigh Definition Audio CODEC" } ,
    { 0x15EF, 0x24c5, "8280BDM SoundMAX Controller (ICH4-M B0 Setup)", "VIA-Vynil v700b" } ,
    { 0x15EF, 0x7616, "102801F7", "SigmaTelHigh Definition Audio CODEC" } ,
    { 0x15F1, 0x2F30, "CX11252-15", "Conexant HSFi" } ,
    { 0x15F2, 0x0001, "Spot RT", "Spot RT Interface Board" } ,
    { 0x15F2, 0x0002, "Spot RT #2", "Spot RT Interface Board" } ,
    { 0x15F2, 0x0003, "Spot Insight", "Spot Insight Interface Board" } ,
    { 0x160A, 0x3184, "6656", "Via VT6656 Wireless Lan Adapter" } ,
    { 0x1616, 0x0409, "DaqBoard/2000", "16-Bit, 200-kHz PCI Data Acquisition DaqBoards with DBK Signal Conditioning Support " } ,
    { 0x1619, 0x0400, "FarSync T2P", "Two Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x0440, "FarSync T4P", "Four Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x0610, "FarSync T1U", "One Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x0620, "FarSync T2U", "Two Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x0640, "FarSync T4U", "Four Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x1610, "FarSync TE1", "One Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x1612, "FarSync TE1e (PCI Express)", "One Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x2610, "FarSync DSL-S1", "G.SHDSL Intelligent Sync Comms Card" } ,
    { 0x1619, 0x3640, "FarSync T4E", "Four Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x4620, "FarSync T2Ue (PCI Express)", "Two Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x4640, "FarSync T4Ue (PCI Express)", "Four Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x5621, "FarSync T2Ee (PCI Express)", "Two Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x5641, "FarSync T4Ee (PCI Express)", "Four Port Intelligent Sync Comms Card" } ,
    { 0x1619, 0x6620, "FarSync-T2U-PMC", "Two Port Intelligent Sync Comms Card" } ,
    { 0x1621, 0x0020, "LynxTWO-A", "4 in/4 out Professional Digital Audio Card" } ,
    { 0x1621, 0x0021, "LynxTWO-B", "2 in/6 out Professional Digital Audio Card" } ,
    { 0x1621, 0x0022, "LynxTWO-C", "6 in/2 out Professional Digital Audio Card" } ,
    { 0x1621, 0x0023, "Lynx L22", "2 in/2 out Professional Digital Audio Card" } ,
    { 0x1621, 0x0024, "Lynx AES16", "16 in/16 out AES/EBU Audio Card" } ,
    { 0x1621, 0x0025, "Lynx AES16-SRC", "16 in/16 out AES/EBU Audio Card w/SRC" } ,
    { 0x1629, 0x1003, "", "Format Synchronizer v3.0" } ,
    { 0x1629, 0x2002, "", "Fast Universal Data Output" } ,
    { 0x162D, 0x0100, "driver", "Repeographics controller" } ,
    { 0x162D, 0x0101, "", "Reprographics Controller" } ,
    { 0x162D, 0x0102, "", "Reprographics Controller" } ,
    { 0x162D, 0x0103, "", "Reprographics Controller" } ,
    { 0x162F, 0x1111, "TS-PRL1", "General Purpose Relay Card" } ,
    { 0x162F, 0x1112, "TS-PMA", "Matrix Card" } ,
    { 0x1638, 0x1100, "WL11000P", " WL11000P" } ,
    { 0x163B, 0x2416, "Techwell - TW2804  Model - JSA-2416Drivers on this", "DVR Video Capture Card 16CH" } ,
    { 0x163C, 0x3052, "R6793-11", "RS56/HSP-PCI" } ,
    { 0x163C, 0xFF02, "82801 GB", "PCI Bridge - 244E" } ,
    { 0x1734, 0x007a, "Rage XL", "ATI Rage XL (rev 27)" } ,
    { 0x1734, 0x1011, "AIC-7902W", "Adaptec AIC-7902 Dual Channel U320 SCSI" } ,
    { 0x1734, 0x1012, "CSB6", "Serverworks Southbridge with RAID/IDE (rev a0), OHCI USB (rev 05), GCLE-2 Host Bridge" } ,
    { 0x1734, 0x1013, "BCM5703", "Broadcom Corp. NetXtreme Gigabyte Ethernet" } ,
    { 0x1734, 0x10b9, "0x00541000", "SAS 3000 series, 8-port with 1068 -StorPort" } ,
    { 0x164F, 0x0001, "PLX 9054", "PCI interface chip" } ,
    { 0x164F, 0x0002, "PLX 9054", "PCI interaface chip" } ,
    { 0x1813, 0x3059, "VT8237", "AC97 Enhanced Audio Controller - the 8251 controller is different" } ,
    { 0x1813, 0x4000, "MD5628D-L-A", "intel V.92 HaM Modem" } ,
    { 0x1813, 0x4100, "Ambient MD8820", "Intel HaM V.92 Modem" } ,
    { 0x17D5, 0x5831, "X1", "Xframe 10GbE PCI-X Adapter" } ,
    { 0x17D5, 0x5832, "X2", "Xframe II 10GbE PCI-X 2.0 Adapter" } ,
    { 0x17D5, 0x5833, "X3", "E3100 PCI-Express 10Gb Ethernet Interface" } ,
    { 0xFA57, 0x0001, "PMC", "Pattern Matching Chip" } ,
    { 0x18CA, 0x0020, "Volari Z9s", "Volari Z series (Select GPU Graphic Drivers" } ,
    { 0x18CA, 0x0040, "Silicon Intgrated System", "Volari Family Z Series" } ,
    { 0x18C9, 0x1011, "Leonardo CL", "Video processor" } ,
    { 0x18C9, 0x1012, "Leonardo CL-P", "Video processor" } ,
    { 0x18C9, 0x1013, "Leonardo CL-DB", "Video processor" } ,
    { 0x18C9, 0x1014, "Leonardo CL-P-DB", "Video processor" } ,
    { 0x18C9, 0x1015, "Leonardo CL-DVR", "Video processor" } ,
    { 0x18C9, 0x1016, "Leonardo CL-DVR-DB", "Video processor" } ,
    { 0x18C9, 0x2011, "Picasso 2SQ", "Framegrabber" } ,
    { 0x18C9, 0x2012, "Picasso 3C/3Cpro", "Framegrabber" } ,
    { 0x18C9, 0x2013, "Picasso LS", "Framegrabber" } ,
    { 0x18C9, 0x2014, "Picasso CL", "Framegrabber" } ,
    { 0x18C9, 0x2015, "Picasso FI", "Framegrabber" } ,
    { 0x18C9, 0x2016, "Picasso SDI", "Framegrabber" } ,
    { 0x18C9, 0x2017, "Picasso DUO", "Framegrabber" } ,
    { 0x18C9, 0x2021, "Colory", "Framegrabber" } ,
    { 0x18C9, 0x3011, "Valentino", "Video Output Board" } ,
    { 0x1910, 0x0001, "SW5000-NCA", "Seaway Network Content Accelerator" } ,
    { 0x1360, 0x0101, "PCI32", "DCF77 Radio Clock" } ,
    { 0x1360, 0x0102, "PCI509", "DCF77 Radio Clock" } ,
    { 0x1360, 0x0103, "PCI510", "DCF77 Radio Clock" } ,
    { 0x1360, 0x0104, "PCI511", "DCF77 Radio Clock" } ,
    { 0x1360, 0x0105, "PEX511", "DCF77 Receiver" } ,
    { 0x1360, 0x0106, "PZF180PEX", "High Precision DCF77 Radio Clock" } ,
    { 0x1360, 0x0201, "GPS167PCI", "GPS Receiver" } ,
    { 0x1360, 0x0202, "GPS168PCI", "GPS Receiver" } ,
    { 0x1360, 0x0203, "GPS169PCI", "GPS Receiver" } ,
    { 0x1360, 0x0204, "GPS170PCI", "GPS Receiver" } ,
    { 0x1360, 0x0205, "GPS170PEX", "GPS Receiver" } ,
    { 0x1360, 0x0206, "GPS180PEX", "GPS receiver" } ,
    { 0x1360, 0x0207, "GLN180PEX", "GPS/GLONASS receiver" } ,
    { 0x1360, 0x0208, "GPS180AMC", "GPS Receiver" } ,
    { 0x1360, 0x0301, "TCR510PCI", "IRIG Timecode Reader" } ,
    { 0x1360, 0x0302, "TCR167PCI", "IRIG Timecode Reader" } ,
    { 0x1360, 0x0303, "TCR511PCI", "IRIG Timecode Reader" } ,
    { 0x1360, 0x0304, "TCR511PEX", "IRIG Timecode Receiver" } ,
    { 0x1360, 0x0305, "TCR170PEX", "IRIG Timecode Reader" } ,
    { 0x1360, 0x0306, "TCR180PEX", "IRIG Timecode Reader" } ,
    { 0x1360, 0x0501, "PTP270PEX", "PTP/IEEE1588 Slave Card" } ,
    { 0x1360, 0x0601, "FRC511PEX", "Free Running Clock" } ,
    { 0x1725, 0x7174, "VSC7174", "VSC7174 PCI/PCI-X SATA Controller" } ,
    { 0x1753, 0x1001, "VP500", "VolumePro 500" } ,
    { 0x1753, 0x1004, "VP1000", "VolumePro 1000" } ,
    { 0x17CC, 0x1978, "net 2280", "usb 2.0 device controller" } ,
    { 0x17CC, 0x2280, "Net 2280", "USB 2.0 Device Controller" } ,
    { 0x14EA, 0xAB06, "XFNW-3603-T", "10/100 Fast Ethernet CardBus (RTL8139)" } ,
    { 0x12B9, 0x00c2, "00000005", "pci simple communication controller" } ,
    { 0x12B9, 0x1006, "5610", "5610 56K FaxModem WinModem" } ,
    { 0x12B9, 0x1007, "AD1807JS", "US Robotics 56K DATA FAX WINMODEM" } ,
    { 0x12B9, 0x1008, "USR5610B", "USR5610B (0005610-02) 56K Performance Pro Modem (PCI Internal)" } ,
    { 0x12B9, 0x12b9, "00000005", "pci simple communication controller" } ,
    { 0x12B9, 0x3F0, "3CP2977", "US Robotics 56K Fax PCI aka Model 0726, V.90 56K Internal Faxmodem" } ,
    { 0x1814, 0x0001, "...B742000", "...I don't know" } ,
    { 0x1814, 0x0101, "2460  802.11b", "RT2460  802.11b Baseband/MAC integrated chip" } ,
    { 0x1814, 0x0201, "PCI\\VEN_1814&DEV_3298&SUBSYS_1451033", "Ralink Chipset 802.11b/g WLAN Card" } ,
    { 0x1814, 0x0201, "WiFiSKY", "Ralink RT2500 802.11b/g WLAN Card" } ,
    { 0x1814, 0x0201, "001167F044E5", "W-LAN 802.11b/g" } ,
    { 0x1814, 0x0201, "RT2560F", "RaLink" } ,
    { 0x1814, 0x0201, "WMP54G", "Wireless-G PCI adapter" } ,
    { 0x1814, 0x0301, "RT2561", "Ralink RT2561 Wireless-G PCI" } ,
    { 0x1814, 0x0301, "RT2561", "Ralink RT2561 Wireless-G PCI" } ,
    { 0x1814, 0x0302, "RT2525 2.4GHz transceiver + RT2560 MAC/BBP", "wireless p/n same Chipset in D-Link DWL-G510" } ,
    { 0x1814, 0x0401, "RT 2661", "Ralink MIMO RT 2661 Wireless 54 Mbps" } ,
    { 0x1814, 0x0601, "RT2860T", "b/g/n  Wlan" } ,
    { 0x1814, 0x0701, "RT2860T", "802.11 bgn" } ,
    { 0x1814, 0x0781, "RT2790T/RT2860/RT2890/RT2700E", "Wireless 802.11 bgn PCI-e" } ,
    { 0x1814, 0x1418, "0x14FI", "802.11b/g Wireless LAN" } ,
    { 0x1814, 0x14F1, "0x1814", "PCI\\VEN_168C&DEV_001A&SUBSYS_04181468&REV_01\\4&FCF0450&0&10A4" } ,
    { 0x1814, 0x201, "25601814&REV_01", "Ralink RT2500 Wireless Lan Card" } ,
    { 0x1814, 0x3060, "RT3060", "Ralink corp. RT3060 Wireless 802.11n PCI adapter" } ,
    { 0x1814, 0x3090, "Ralink RT3090", "Ralink RT3090 Wireless Lan Card with Bluetooth" } ,
    { 0x1814, 0x3290, "1010", "802.11n   Bluetooth 4.0" } ,
    { 0x1814, 0x3298, "-3290", "Ralink Bluetooth" } ,
    { 0x1814, 0x3592, "RT3592", "Wireless LAN a/b/g/n plus Bluetooth 3.0 combo" } ,
    { 0x1814, 0x5360, "RT5360 ", "http://www.wikidevi.com/wiki/D-Link_DWA-525_rev_A2" } ,
    { 0x1814, 0x5390, "ASUS X55VD VEN_1814&DEV_5390&SUBSYS_E054105B&REV00", "802.11n Wireless Lan Card - Asus X55V - Win 7 64bit - Foxconn Wireless" } ,
    { 0x1814, 0x539B, "RT5390R", "Ralink RT5390R 802.11b/g/n WiFi" } ,
    { 0x1814, 0x9876, "b8341462", "Edimax 54 MBit WLan 802.11g rt 2500" } ,
    { 0x1103, 0x0003, "HPT 343/345/363", "EIDE Controller" } ,
    { 0x1103, 0x0004, "HPT366/368/370/370A/372", "ATA Raid Controller/ATA 100" } ,
    { 0x1103, 0x0005, "HPT372/372N", "PATA133 Raid Controller" } ,
    { 0x1103, 0x0006, "HPT302", "ATA Raid Controller" } ,
    { 0x1103, 0x0007, "HPT371", "ATA133 Controller" } ,
    { 0x1103, 0x0008, "HPT-374", "ATA Raid Controller" } ,
    { 0x1103, 0x1720, "RR172x", "RR172x SATA Controller" } ,
    { 0x1103, 0x1740, "RR174x", "RR174x SATA Controller" } ,
    { 0x1103, 0x1742, "RR174x", "RR174x SATA Controller" } ,
    { 0x1103, 0x2210, "RR2210", "RR2210 SATA Controller" } ,
    { 0x1103, 0x2300, "RR2300", "RR2300 SATA Controller" } ,
    { 0x1103, 0x2310, "RR231x", "RR231x SATA Controller" } ,
    { 0x1103, 0x2340, "RR2340", "RR2340 SATA Controller" } ,
    { 0x1103, 0x2522, "RR252x", "RR252x SATA Controller" } ,
    { 0x1103, 0x3120, "RR312x", "RR312x SATA Controller" } ,
    { 0x1103, 0x3220, "RR322x", "RR322x SATA Controller" } ,
    { 0x1103, 0x3320, "RR332x", "RR332x SATA Controller" } ,
    { 0x1103, 0x3410, "RR341x", "RR341x SATA Controller" } ,
    { 0x1103, 0x3510, "RR35xx", "RR35xx SATA Controller" } ,
    { 0x1103, 0x3511, "RR35xx", "RR35xx SATA Controller" } ,
    { 0x1103, 0x3520, "RR35xx", "RR35xx SATA Controller" } ,
    { 0x1103, 0x3521, "RR35xx", "RR35xx SATA Controller" } ,
    { 0x1103, 0x3522, "RR35xx", "RR35xx SATA Controller" } ,
    { 0x1103, 0x3530, "RR3530", "RR3530 SATA RAID Controller" } ,
    { 0x1103, 0x3540, "RR35xx", "RR35xx SATA Controller" } ,
    { 0x1103, 0x4320, "RR432x", "RR432x SATA Controller" } ,
    { 0x1103, 0x5081, "RR18xx", "RR18xx SATA Controller" } ,
    { 0x1103, 0x6081, "RR222x/224x", "RR222x/224x SATA Controller" } ,
    { 0x1103, 0x7042, "RR231x", "RR231x SATA Controller" } ,
    { 0x1681, 0x0050, "HWGPCI-54", "Hercules WiFi PCI 802.11G" } ,
    { 0x18F7, 0x0001, "ESCC-PCI-335", "Fastcom:ESCC-PCI-335 Syncronous RS422/485 serial communication adapter" } ,
    { 0x18F7, 0x0002, "422/4-PCI-335", "Fastcom:422/4-PCI-335 Asyncronous RS422/485 serial adapter" } ,
    { 0x18F7, 0x0004, "422/2-PCI-335", "Fastcom:422/2-PCI-335 Asyncronous RS422/485 serial adapter" } ,
    { 0x18F7, 0x000a, "232/4-PCI-335", "Fastcom:232/4-PCI-335 Asyncronous RS232 serial adapter" } ,
    { 0x1737, 0x0071, "RT2870", "Dual Band Wireless N USB Network Adapter" } ,
    { 0x1737, 0x1032, "EG1032 v3", "Linksys Instant Gigabit Desktop Network Interface" } ,
    { 0x19AC, 0x0001, "ACA2400", "Crypto Accelerator" } ,
    { 0x110A, 0x2101, "PEB 20321", "Multichannel Network Interface Controller for HDLC" } ,
    { 0x110A, 0x2102, "PEB 20534", "DMA supported serial communication controller with 4 channels" } ,
    { 0x110A, 0x2104, "PSB4610", "PCI Interface for Telephony/Data Applications PITA-2" } ,
    { 0x110A, 0x3141, "01", "PROFIBUS Communication Processor CP5611 A2" } ,
    { 0x110A, 0x4033, "ERTEC400", "EB400 ProfiNet Device-Kit" } ,
    { 0x110A, 0x4036, "Industrial Ethernet CP 1616", "Siemens I/O Control" } ,
    { 0x104B, 0x1040, "BA81C15", "BT958 SCSI Host Adaptor" } ,
    { 0x104B, 0x8130, "-", "Flashpoint LT" } ,
    { 0x1180, 0x0475, "RL5c592", "Cardbus Controller" } ,
    { 0x1180, 0x0476, "RL5c476 II", "RICOH SmartCard Reader" } ,
    { 0x1180, 0x0478, "RB5c478", "Cardbus Controller" } ,
    { 0x1180, 0x0552, "R5C552", "FireWire (IEEE 1394) Controller" } ,
    { 0x1180, 0x0575, "44192", "I11fXI  <a href=" } ,
    { 0x1180, 0x059, "1", "1" } ,
    { 0x1180, 0x0592, "0880", "Ricoh R5C833 R5C8xx Memory Stick Controller" } ,
    { 0x1180, 0x0822, "R5C832", "SDA Standard Compliant SD Host Controller" } ,
    { 0x1180, 0x0832, "ACPI\\ENE0100\\4&15458EF3&0", "ACPI\\ENE0100\\4&15458EF3&0" } ,
    { 0x1180, 0x0843, "022E1028", "Ricoh SD Host Controller" } ,
    { 0x1180, 0x0847, "delete", "delete" } ,
    { 0x1180, 0x0852, "R5C852", "Ricoh xD-Picture Card Controller" } ,
    { 0x1180, 0x1108, "30CF", "Ricoh Memory Stick Host Controller" } ,
    { 0x1180, 0x2792, "0x8086", "PCI\\VEN_1180&DEV_0852&SUBSYS_022F1028&REV_12 " } ,
    { 0x1180, 0x5551, "Unknown", "IEEE 1394 Controller" } ,
    { 0x1180, 0x852, "01cf1028 ", "Ricoh xD-Picture Card Host Controller;0852h xd picture card controller" } ,
    { 0x1180, 0x9876, "CC_088000", "Ricoh Memory Stick Host Controlle" } ,
    { 0x1180, 0x0843, "R5C853", "Ricoh SD/Host Controller" } ,
    { 0x1180, 0xE203, "0592", "Ricoh PCIe Memory Stick Host Controller" } ,
    { 0x1180, 0xE230, "9086104D", "Ricoh PCIe Memory Stick &#1061;&#1086;&#1089;&#1090;-&#1050;&#1086;&#1085;&#1090;&#1088;&#1086;&#108" } ,
    { 0x1180, 0xe476, "Ricoh R5C843", "Multipurpose chip, this e476 seems to be the CardBus controller part" } ,
    { 0x1180, 0xe822 , "R5U822", "Ricoh PCIe SD/MMC Host Controller" } ,
    { 0x1180, 0xe823, "R5U822", "Ricoh PCIe SDXC/MMC Host Controller" } ,
    { 0x1180, 0xe832, "R5U832", "Ricoh PCIe IEEE1394 Fireware Host Controller" } ,
    { 0x1180, 0xE852, "Uknown", "Ricoh PCIe xD-Picture Card Controller" } ,
    { 0x14F1, 0x0F00, "cx11252-11", "HSF Generic Modem" } ,
    { 0x14F1, 0x0F30, "0x14F1", "0x14F1" } ,
    { 0x14F1, 0x1031, "332", "dfd" } ,
    { 0x14F1, 0x1033, "RH56D", "RH56D-PCI" } ,
    { 0x14F1, 0x1033, "RH56D", "RH56D-PCI" } ,
    { 0x14F1, 0x1035, "R6795-11", "RH56D/SP-PCI, R6795-11, E416921/1, 0336 Mexico" } ,
    { 0x14F1, 0x1036, "Conexant RH56D/SP-PCI", "" } ,
    { 0x14F1, 0x1056, "105614f1", "subsys" } ,
    { 0x14F1, 0x1059, "DI15630-5, DI5631, DI5633", "SmartHCF" } ,
    { 0x14F1, 0x10B4, "Conextant HFC", "All Conextant HFC Modems (PCI)" } ,
    { 0x14F1, 0x10B6, "unknown", "Conexant HCF PCI Soft modem" } ,
    { 0x14F1, 0x1416, "", "Contexant" } ,
    { 0x14F1, 0x1456, "1456", "HCFp Modem" } ,
    { 0x14F1, 0x14F1, "0x14F1", "0x14F1" } ,
    { 0x14F1, 0x1611, "?", "AccessRunner ADSL Modem" } ,
    { 0x14F1, 0x1612, "8", "8" } ,
    { 0x14F1, 0x2013, "RS56-PCI", "in-Build CX11235 modem" } ,
    { 0x14F1, 0x2400, "unknown", "unknown" } ,
    { 0x14F1, 0x2702, "cx11252-11", "HSFi or Soft V92 PCI Modem" } ,
    { 0x14F1, 0x2710, "", "PCI modem card Conexant" } ,
    { 0x14F1, 0x2740 , "CC_0780", "Pci Simple Communtications Controller" } ,
    { 0x14F1, 0x2B10, "0x14F1", "0x14F1" } ,
    { 0x14F1, 0x2BFA, "0x0000ffff", "Conexant HDA D110 MDC v.92 Modem" } ,
    { 0x14F1, 0x2C06, "136", "Conexant HD Audio SoftV92 Data Fax Modem with SmartCP" } ,
    { 0x14F1, 0x2F00, "00101767", "HSF 56k HSFi Modem" } ,
    { 0x14F1, 0x2f01, "0x0780", "missing driver for pci simple communications controller" } ,
    { 0x14F1, 0x2F10, "USR90-12", "CXT / USR 56K Fax Host int" } ,
    { 0x14F1, 0x2F20, "CX11256", "SoftV92 Data Fax Modem with SmartCP" } ,
    { 0x14F1, 0x2F30, "CX11252-41z", "PCI SoftV92 Modem" } ,
    { 0x14F1, 0x2F30, "01", "hp/compaq alhena 5-gl6" } ,
    { 0x14F1, 0x2F40, "200014F1", "PCI Soft Data Fax Modem with SmartCP" } ,
    { 0x14F1, 0x2F50, "99269", "SmartLink 2801" } ,
    { 0x14F1, 0x2F52, "C0220001", "01\\3&61AAA01&0&50" } ,
    { 0x14F1, 0x2F81, " ", " " } ,
    { 0x14F1, 0x2F82, "cx9510-11z", "Conexant PCI-E Soft Data/Fax Modem with SmartCP" } ,
    { 0x14F1, 0x5045, "4.0.3.1", "http://h10025.www1.hp.com/ewfrf/wc/softwareDownloadIndex?softwareitem=ob-43284-1&lc=en&dlc=en&cc=us&" } ,
    { 0x14F1, 0x5045, "14f12f30", "Conextant High Definition" } ,
    { 0x14F1, 0x5045	, "14e4", "Conextant High Definition SmartAudio 221" } ,
    { 0x14F1, 0x5045, "PCI\\VEN_14F1&DEV_5051", "Conextant High Definition Audio-Venice 5051" } ,
    { 0x14F1, 0x5047, "Not sure", "HDAUDIO Soft Data Fax Modm- Conexant Sound Card Audio Driver" } ,
    { 0x14F1, 0x5051, "4.0.1.6", "Conexant HD-Audio SmartAudio 221" } ,
    { 0x14F1, 0x5051, "DG31PR", "Conexant HD-Audio SmartAudio 221" } ,
    { 0x14F1, 0x5051, "CX20561", "Conexant HD-Audio SmartAudio 221" } ,
    { 0x14F1, 0x5066, "Cx20561", "HDAUDIO\\Func_01&VEN_14F1&DEV_5069&SUBSYS_17AA214C&REV_1003" } ,
    { 0x14F1, 0x5069, "20585", "conexant 20585 smartAudio HD" } ,
    { 0x14F1, 0x506C, "0x506C", "Conexant High Definition Audio" } ,
    { 0x14F1, 0x506E, "001", "Conexant 20672 SmartAudio HD" } ,
    { 0x14F1, 0x50A1, "CX20641/CX20651", "Conexant HD Audio" } ,
    { 0x14F1, 0x50A2, "Conexant CX20642", "Conexant HD Audio" } ,
    { 0x14F1, 0x5B7A, "Belived to be a CX23416", "Single-Chip MPEG-2 Encoder with Integrated Analog Video/Broadcast Audio Decoder" } ,
    { 0x14F1, 0x8800, "Conexant CX23881", "PAL audio/video decoder" } ,
    { 0x14F1, 0x8800, "0x14F1", "0x14F1" } ,
    { 0x14F1, 0x8801, "CX23880", "PCI Broadcast Audio/Video Decoder" } ,
    { 0x14F1, 0x8802, "CX2388x", "MPEG Encoder " } ,
    { 0x14F1, 0x8811, "CX2388x", "Audio Capture ike" } ,
    { 0x14F1, 0x8852, "cx23885", "Leadtek Winfast PxDVR3200 H (XC3028)" } ,
    { 0x14F1, 0x8880, "CX23888", "PCI Express Video and Broadcast Audio Decoder" } ,
    { 0x14F1, 0x9876, "PCI\\VEN_14F1&DEV_2F20&SUBSYS_200C14F1&REV_00\\4&CF8", "Communication controller" } ,
    { 0x14F1, 0x27d8, "A62516F3", "INTEL IDT Audio" } ,
    { 0x186C, 0x1014, "AR5BXB6", "Atheros 802.11abg" } ,
    { 0x1971, 0x0001, "PCI\\VEN_1971&DEV_0000&SUBSYS_0003105B&REV_00", "AGEIA PhysX 100 Series PCI Express Card" } ,
    { 0x1971, 0x1011, "PCI\\\\VEN_1971&DEV_1011&CC_FF00", "AGEIA PhysX 100 Series PCI Card" } ,
    { 0x1971, 0x1021, "", "AGEIA PhysX 200 Series PCI Express Card" } ,
    { 0x1969, 0x1026, "AR8121/AR8113 ", "PCI-E ETHERNET CONTROLLER " } ,
    { 0x1969, 0x1048, "Atheros L1", "Gigabit Ethernet 10/100/1000 Base-T Controller" } ,
    { 0x1969, 0x1060, "AR8162", "PCI-E Fast Ethernet Controller" } ,
    { 0x1969, 0x1062, "AR8132", "Atheros AR8132 PCI-E&#1050;&#1086;&#1085;&#1090;&#1088;&#1086;&#1083;&#1083;&#1077;&#1088; &#1041;&#" } ,
    { 0x1969, 0x1062, "Atheros L1 ", "Gigabit Ethernet 10/100/1000 Base-T Controller" } ,
    { 0x1969, 0x1063, "AR8131", "Atheros AR8131 PCI-E Gigabit Ethernet Controller" } ,
    { 0x1969, 0x1073, "AR8151", "Atheros AR8151" } ,
    { 0x1969, 0x1083, "78161462", "Atheros AR8151 PCI-E Gigabit Ethernet Controller (NDIS 6.20)" } ,
    { 0x1969, 0x1090, "AR8162+", "Fast Ethernet" } ,
    { 0x1969, 0x1091, "AR8161/8165", "PCI-E Gigabit Ethernet Controller" } ,
    { 0x1969, 0x10a0, "Atheros AR8172/8176/8178", "Controller Ethernet Qualcomm Atheros AR8172/8176/8178 PCI-E Fast (NDIS 6.30)" } ,
    { 0x1969, 0x168c, "Atheros L1 ", "Gigabit Ethernet 10/100/1000 Base-T Controller " } ,
    { 0x1969, 0x1969, "Atheros L3", "Atheros AR815x/816x Ethernet Controller Driver " } ,
    { 0x1969, 0x2048, "Atheros L2", "Fast Ethernet 10/100 Base-T Controller" } ,
    { 0x1969, 0x2049, "234543", "der" } ,
    { 0x1969, 0x2060, "fd501179&rev-c1", "AR8152 v1.1 Fast Ethernet" } ,
    { 0x1969, 0x2061, "1", "Ethernet Controller" } ,
    { 0x1969, 0x2062, "FB501179", "Qualcomm Atheros AR8152/8158" } ,
    { 0x1969, 0x4747, "1969", "VEN_1969" } ,
    { 0x1969, 0x9876, "Atheros L2", "Fast Ethernet 10/100 Base-T Controller " } ,
    { 0x1969, 0xE091, "Killer E2200", "Killer E2200 Network Card" } ,
    { 0x17C0, 0x12ab, "", "intel" } ,
    { 0x9710, 0x7705, "MCS7705", "USB 1.1 to Single Parallel Controller " } ,
    { 0x9710, 0x7830, "MCS7830", "USB 2.0 to 10/100M Fast Ethernet Controller" } ,
    { 0x9710, 0x8729, "mcs7830", "usb 2.0 10/100M ethernet adaptor" } ,
    { 0x9710, 0x9805, "mcs9805cv", "MosChip PCI Parallel Port" } ,
    { 0x9710, 0x9815, "9815", "MCS9815 / M-CAB Parallel Adapter" } ,
    { 0x9710, 0x9835, "9835", "2 serial, 1 LPT port PCI Card" } ,
    { 0x9710, 0x9845, "NM9845CV", "2 serial" } ,
    { 0x9710, 0x9865, "MCS9865", "PCI Porta Paralela" } ,
    { 0x9710, 0x9900, "MCS9900CV-AA", "NetMOS Single Parallel Port Card" } ,
    { 0x9710, 0x9904, "MCS9900", "PCIe to Multi IO Controller" } ,
    { 0x9710, 0x9912, "MCS9901CV-CC", "PCIe to Dual Serial and Single Parallel" } ,
    { 0x9710, 0x9922, "MCS9922", "PCIe to Dual Serial Port Controller" } ,
    { 0x067B, 0x2303, "2303 HXA", "Prolific USB 2 Serial Comm Port &#1082;&#1086;&#1085;&#1090;&#1088;&#1086;&#1083;&#1083;&#1077;&#108" } ,
    { 0x067B, 0x2305, "PL-2303", "USB-to-Printer Bridge Controller" } ,
    { 0x067B, 0x2393, "prolific", "prolificz" } ,
    { 0x067B, 0x2506, "PL-2506", "Hi-Speed USB to IDE Bridge Controller" } ,
    { 0x067B, 0x25a1, "PL-2501", "Prolific PCLinq3 USB Transfer Cable Driver" } ,
    { 0x067B, 0x9876, "067B", "TES" } ,
    { 0x8080, 0x1040, "VIA 82C259 rev 0", "PCI\\VEN_8086&DEV_0084&SUBSYS_13158086&REV_00" } ,
    { 0x0c45, 0x0C45, "USB\\VID_041&PID_6143&REV_0101", "USB2.0" } ,
    { 0x0c45, 0x1111, "USB\\VID_0C45&PID_612A\\5&B0F4C74&0&2", "USB webcam" } ,
    { 0x0c45, 0x5243, "USB", "xda exec Uknown device" } ,
    { 0x0c45, 0x6007, "USB\\VID_0C45&PID_6007&REV_0101", "Genius WebCam Eye" } ,
    { 0x0c45, 0x600D, "USB\\VID_0C45&PID_600D&REV_0101", "USB(v1.1) webcam" } ,
    { 0x0c45, 0x602C, "SN9C102C", "home made" } ,
    { 0x0c45, 0x602D, "VID_0C45&PID_6480&MI_00", "USB Webcam" } ,
    { 0x0c45, 0x6030, "USB\\VID_0C45&PID_6029\\5&18D8BE1C&0&1", "USB WebCam " } ,
    { 0x0c45, 0x610C, "USB\\VID_0C45&PID_610B\\7&3211544E$0$2", "usb web camera " } ,
    { 0x0c45, 0x6128, "USB\\VID_0C45&PID_613C&REV_0101", "USB &#1074;&#1077;&#1073;-&#1082;&#1072;&#1084;&#1077;&#1088;&#1072;" } ,
    { 0x0c45, 0x6128, "USB\\VID_0C45&PID_6148&REV_0101", "USB PC Camera Plus" } ,
    { 0x0c45, 0x6129, "USB\\VID_0C45&PID_6128\\5&3875c171&0&1", "USB WebCam" } ,
    { 0x0c45, 0x6130, "USB\\VID_0000&PID_0000\\5&1AAEDD8&0&2", "USB HUB" } ,
    { 0x0c45, 0x613A, "USB\\VID_0C45&PID_613A\\5&2F621EE5&0&5", "USB WEBCAM" } ,
    { 0x0c45, 0x613c, "USB\\VID_0C45&PID_613C\\5&377B3285&0&1 ", "USB Webcam" } ,
    { 0x0c45, 0x613E, "5&29957435&0&1", "USB Camera" } ,
    { 0x0c45, 0x624f, "Sonix SN9C201", "Integrated Webcam in Compal HEL81 series barebones." } ,
    { 0x0c45, 0x6270, "USB\\VID_0C45&PID_6270", "USB Microscopr" } ,
    { 0x0c45, 0x6270, "USB\\VID_0C45&PID_6270&REV_0100", "webcam with mic link works for win 7" } ,
    { 0x0c45, 0x6270, "usb\\vid_oc45&pid_627b\\5&138897&#1044;1&0&5", "webcam" } ,
    { 0x0c45, 0x627F, "USB\\VID_17A1&PID_0118&REV_0100", "USB\\VID_17A1&PID_0118&REV_0100" } ,
    { 0x0c45, 0x62B3, "USB\\Vid_0c45&Pid_62b3&Rev_0100&MI_00", "USB 2.0 PC Camera" } ,
    { 0x0c45, 0x62BF, "USB\\Vid_0c45&Pid_62bf", "USB\\Vid_0c45&Pid_62bf&Rev_0100" } ,
    { 0x0c45, 0x62c0, "SNP2UVC", "Sonix Webcam" } ,
    { 0x0c45, 0x6353, "USB\\VID_0000&PID_0000\\5&1FFD6427&0&2", "USB Microscope" } ,
    { 0x0c45, 0x641D, "USB\\VID_0C45&PID_643d", "1.3 MPixel Integrated Webcam used in Dell N5010 series" } ,
    { 0x0c45, 0x6421, "USB\\VID_0C45&PID_6421&REV_0224&MI_00", "USB 2.0 Webcam slim 32" } ,
    { 0x0c45, 0x642F, "USB\\VID_0C45&PID_642F&REV_1224", "Webcam" } ,
    { 0x0c45, 0x644b, "oc45&oid 641d& 9:07&mi oo", "oc45&oid 641d& 9:07&mi oo" } ,
    { 0x0c45, 0x6489, "0x6489", "Integrated Webcam Universal Serial Bus controllers" } ,
    { 0x0c45, 0x6840, "USB\\VID_0C45&PID_6480&MI_00 ", "sonix 1.3 mp laptop integrated webcam" } ,
    { 0x0c45, 0x7401, "n.a.", "RDing TEMPer1V1.4" } ,
    { 0x0c45, 0x9876, "USB\\VID_090C&PID_B371&MI_00\\6&462987E&0&0000", "webcam" } ,
    { 0x0A5C, 0x0201, "Blutonium BCM2035 Bluetooth 2.4 GHz Single Chip Tr", "Broadcom USB iLine10(tm) Network Adapter" } ,
    { 0x0A5C, 0x10DE, "0264", "Controlador sm" } ,
    { 0x0A5C, 0x2000, " 0578A97", "Broadcom Bluetooth Firmware Upgrade Device" } ,
    { 0x0A5C, 0x2009, " ", "Broadcom Bluetooth Controller" } ,
    { 0x0A5C, 0x200a, " ", "Broadcom Bluetooth Controller" } ,
    { 0x0A5C, 0x200f, " PCI\\VEN_14E4&DEV_43B1&SUBSYS_2B231A3B&REV_03", "Broadcom 802.11ac Network Adapter " } ,
    { 0x0A5C, 0x201d, " n450", "BROADCOM Bluetooth Device" } ,
    { 0x0A5C, 0x201e, " ", "IBM Integrated Bluetooth IV" } ,
    { 0x0A5C, 0x2020, " ", "Broadcom Bluetooth Dongle" } ,
    { 0x0A5C, 0x2021, " 0A5C", "BCM2035B3 ROM Adapter Generic" } ,
    { 0x0A5C, 0x2033, "  1ujy100539f", "Broadcom Blutonium Device Firmware Downloader" } ,
    { 0x0A5C, 0x2035, "5&263C7E89&0&1", "BCM92035NMD Bluetooth" } ,
    { 0x0A5C, 0x2038, " ", "Broadcom Blutonium Device Firmware Downloader (BCM2038)" } ,
    { 0x0A5C, 0x2039, " BCM92045B3 ROM", "BROADCOM Bluetooth Device" } ,
    { 0x0A5C, 0x2045, "BCM2045A", "Broadcom Bluetooth Controller" } ,
    { 0x0A5C, 0x2046, " 5738z", "Broadcom USB Bluetooth Device" } ,
    { 0x0A5C, 0x2047, " ", "Broadcom USB Bluetooth Device" } ,
    { 0x0A5C, 0x205e, " USB\\VID_0A5C&PID_5801&MI_00", "Broadcom Bluetooth Firmware Upgrade Device" } ,
    { 0x0A5C, 0x2100, "BT 50", "Broadcom Bluetooth 2.0+eDR USB dongle" } ,
    { 0x0A5C, 0x2101, "USB\\VID_0A5C&PID_2101", "Broadcom Bluetooth 2.0+EDR USB dongle" } ,
    { 0x0A5C, 0x2102, " USB\\VID_04B4&PID_2102\\5&38CD4C16&0&6", "ANYCOM Blue USB-200/250" } ,
    { 0x0A5C, 0x2110, " 39A18BDD", "Broadcom Bluetooth Controller" } ,
    { 0x0A5C, 0x2111, " ", "ANYCOM Blue USB-UHE 200/250" } ,
    { 0x0A5C, 0x2120, " 2045", "Broadcom 2045 Bluetooth 2.0 USB-UHE Device with trace filter" } ,
    { 0x0A5C, 0x2121, " ", "Broadcom 2045 Bluetooth 2.0 USB Device with trace filter" } ,
    { 0x0A5C, 0x2122, " BCM92045B3", "Broadcom Bluetooth 2.0+EDR USB dongle" } ,
    { 0x0A5C, 0x2124, " ", "2045B3ROM Bluetooth Dongle" } ,
    { 0x0A5C, 0x2130, " ", "Broadcom 2045 Bluetooth 2.0 USB-UHE Device with trace filter" } ,
    { 0x0A5C, 0x2131, " ", "Broadcom 2045 Bluetooth 2.0 USB Device with trace filter" } ,
    { 0x0A5C, 0x2140, " ", "2046 Flash UHE Class 2" } ,
    { 0x0A5C, 0x2141, " ", "2046 Flash non UHE Class 2" } ,
    { 0x0A5C, 0x2142, " ", "2046 Flash non UHE Class 1" } ,
    { 0x0A5C, 0x2143, " ", "2046 Flash non UHE Class 1" } ,
    { 0x0A5C, 0x2144, " ", "2046 Flash non UHE module Class 2" } ,
    { 0x0A5C, 0x2145, "bcm9204md ", "Broadcom BCM9204MD LENO Module" } ,
    { 0x0A5C, 0x2146, " ", "Broadcom 2045 Bluetooth 2.1 USB UHE Dongle" } ,
    { 0x0A5C, 0x2147, " 0A5C&PID_5800", "Broadcom 2046 Bluetooth 2.1 USB Dongle" } ,
    { 0x0A5C, 0x2148, "GBU421", "Broadcom 2046 Bluetooth 2.1 USB UHE Dongle" } ,
    { 0x0A5C, 0x2149, " ", "Broadcom 2046 Bluetooth 2.1 USB Dongle" } ,
    { 0x0A5C, 0x214a, " ", "Broadcom 2046 Bluetooth 2.1 USB Module" } ,
    { 0x0A5C, 0x214b, " 52AF1AB24D", "Broadcom 2046 Bluetooth 2.1 USB Module" } ,
    { 0x0A5C, 0x214c, " ", "Broadcom 2046 Bluetooth 2.1 USB Module" } ,
    { 0x0A5C, 0x214d, " ", "Broadcom Bluetooth 2.1 UHE Module" } ,
    { 0x0A5C, 0x214e, " ", "Thinkpad Bluetooth with Enhanced Data Rate II" } ,
    { 0x0A5C, 0x214f, " ", "Broadcom 2046 Bluetooth 2.1 USB UHE Dongle" } ,
    { 0x0A5C, 0x2150, " ", "Broadcom 2046 Bluetooth 2.1 USB Dongle" } ,
    { 0x0A5C, 0x2151, " 2151", "Broadcom Bluetooth 2.1 USB Dongle" } ,
    { 0x0A5C, 0x2152, " ", "Broadcom 2046 Bluetooth 2.1 USB UHE Dongle" } ,
    { 0x0A5C, 0x2153, " ", "Broadcom 2046 Bluetooth 2.1 USB UHE Dongle" } ,
    { 0x0A5C, 0x2154, " ", "Broadcom 2046 Bluetooth 2.1 USB UHE Dongle" } ,
    { 0x0A5C, 0x2155, " ", "Broadcom Bluetooth USB Dongle" } ,
    { 0x0A5C, 0x2157, " ", "BCM2046 B1 USB 500" } ,
    { 0x0A5C, 0x2158, " ", "Broadcom 2046 Bluetooth 2.1 Device" } ,
    { 0x0A5C, 0x219C, "BCM2070", "Broadcom BCM2070 Bluetooth 3.0+HS USB Device " } ,
    { 0x0A5C, 0x21E1, "Broadcom 20702 Bluetooth 4.0", ".0112" } ,
    { 0x0A5C, 0x21E3, "BCM43142A0", "Broadcom Bluetooth 4.0" } ,
    { 0x0A5C, 0x4500, "BCM2046B1", "Broadcom 2046 Bluetooth 2.1 USB Dongle" } ,
    { 0x0A5C, 0x4502, "BCM2046B1", "Broadcom 2046 Bluetooth 2.1 USB Dongle" } ,
    { 0x0A5C, 0x4503, " BCM2046B1", "Broadcom 2046 Bluetooth 2.1 USB Dongle" } ,
    { 0x0A5C, 0x5800, " 1ujy100539f", "Unified Security Hub" } ,
    { 0x0A5C, 0x5801, "0x5801", "Unified Security Hub " } ,
    { 0x0A5C, 0x6300, " 965", "Pirelli ISB Remote NDIS Device" } ,
    { 0x0A5C, 0x6688, "PCI", "NVIDIA GeForce GT 240M" } ,
    { 0x0A5C, 0x8613, "USB\\VID_04B4&PID_8613&REV_:001", "TD 3104 USB vedio grabber " } ,
    { 0x0A5C, 0x9876, "0x9876", "0x9876" } ,
    { 0x197B, 0x0250, "JMC25", "JMC250 PCI Express, Gigabit Ethernet" } ,
    { 0x197B, 0x0256, "JMC2XX", "JMC260 PCI Express Fast Ethernet" } ,
    { 0x197B, 0x0260, "ethernet", "JMC260 PCI Express Fast Ethernet" } ,
    { 0x197B, 0x0261, "0261", "JMB38X MS Host Controller" } ,
    { 0x197B, 0x1234, "12345678", "1234567" } ,
    { 0x197B, 0x197b, "JMB38X", "JMB38X SD/MMC " } ,
    { 0x197B, 0x2360, "JMicron JMB36X", "JMB36X" } ,
    { 0x197B, 0x2361, "JMB363", "PCI Express to SATA II and PATA Host Controller" } ,
    { 0x197B, 0x2363, "JMB36X", "JMicron JMB362/JMB363 AHCI Controller" } ,
    { 0x197B, 0x2366, "JMB36X", "JMicron JMB366 AHCI/IDE Controller" } ,
    { 0x197B, 0x2368, "JMB368", "IDE Comtroller" } ,
    { 0x197B, 0x2380, "JMB38X", "IEEE 1394 Host Controller" } ,
    { 0x197B, 0x2381, "JMB38X", "JMB38X SD Host Controller" } ,
    { 0x197B, 0x2382, "JMB38X", "JMB38X SD/MMC Host Controller" } ,
    { 0x197B, 0x2383, "0261", "JMB38X MS Host Controller" } ,
    { 0x197B, 0x2384, "JMB38X", "JMB38X xD Host Controller" } ,
    { 0x197B, 0x2391, "JMB38X", "JMB38X SD/MMC - JMicron PCIe SD Host Controller" } ,
    { 0x197B, 0x2392, "721179", " JMB38X SD/MMC - JMicron PCIe SD Host Controller" } ,
    { 0x197B, 0x2393, " Chip Number: 	JMB38X", "Chip Description: 	JMB38X SD/MMC Host Controller" } ,
    { 0x197B, 0x7002, "JMB38Xam5", "JMB38X SD/MMC Host Controller" } ,
    { 0x4E8, 0x618c, "rev_0400", "usb lan adapter4" } ,
    { 0x4E8, 0x618d, "rev_0400", "usb lan adapter4" } ,
    { 0x058f, 0x0001, "6387", "AM usb storage" } ,
    { 0x058f, 0x0107, "0x03", "0x01 " } ,
    { 0x058f, 0x1234, "9380", "6387" } ,
    { 0x058f, 0x1600, "00000000", "http://www.alldatasheet.com/datasheet-pdf/pdf/91600/ETC/AU9254A21.html" } ,
    { 0x058f, 0x6362, "UNKNOWN", "Unknown 4-in-1 card reader (istar)" } ,
    { 0x058f, 0x6366, "Unknown", "Multi Flash Reader USB Device" } ,
    { 0x058f, 0x6387, "intel g620", "USB Mass Storage Device(USB1005B Flash Disk)" } ,
    { 0x058f, 0x8CBA, "PCI\\VEN_8086&DEV_8CBA&SUBSYS_78211462&REV_00\\3&115", "PCI Simple Communications Controller" } ,
    { 0x058f, 0x9254, "AU9254A21-HAS", "http://www.alldatasheet.com/datasheet-pdf/pdf/91600/ETC/AU9254A21.html" } ,
    { 0x058f, 0x9380, "FC8708-3", "Micron=MT29F32G08CBABA" } ,
    { 0x058f, 0x9540, "Unknown", "SmartCard Reader" } ,
    { 0x064e, 0x064e, "VID_0000&PID_0000\\5&2B3B5BA1&0&1", "Suyin" } ,
    { 0x064e, 0xa101, "suYin", "Acer Crystal Eye Webcam" } ,
    { 0x064e, 0xa103, "SuYin", "WebCam" } ,
    { 0x064e, 0xa116, "Suiyn Optronics", "USB 2.0 UVC 0.3M WebCam" } ,
    { 0x064e, 0xA219, "SUYIN", "SUYIN 1.3M WebCam" } ,
    { 0x064e, 0xB250, "SuYin", "1.3M HD WebCam" } ,
    { 0x064e, 0xc108, "dont know", "its a webcam software" } ,
    { 0x064e, 0xd101, "SuYin", "Web Cam" } ,
    { 0x064e, 0xD217, "SUYIN", "HP TrueVision HD" } ,
    { 0x198a, 0x0210, " ", "XMC-210" } ,
    { 0x198a, 0x0220, " ", "XMC-220" } ,
    { 0x198a, 0x0230, " ", "XMC-230" } ,
    { 0x198a, 0x0240, " ", "XMC-240" } ,
    { 0x198a, 0x1180, " pm 965", "PCIe-180" } ,
    { 0x198a, 0x1280, " ", "PCIe-280" } ,
    { 0x198a, 0x1395, "STRATIX V", "PCIe-395 standard" } ,
    { 0x198a, 0x198a, "pm 965", "PCIe-180" } ,
    { 0x198a, 0x3395, "STRATIX V", "PCIe-395 BSP" } ,
    { 0x198a, 0x402F, " ", " BenNUEY PCIX" } ,
    { 0x198a, 0x4030, " ", "H100-PCIX" } ,
    { 0x198a, 0x4031, " ", "BenNUEY PCI-104-V4" } ,
    { 0x198a, 0x4032, " ", "BenONE-PCIe" } ,
    { 0x198a, 0x4033, " PCI\\VEN_198A&DEV_4033&SUBSYS_00000000&REV_00", "BenONE-Xilinx-Kit-ROHS" } ,
    { 0x198a, 0x4034, " ", "BenNUEY PCIX RoHS" } ,
    { 0x17F3, 0x1010, "D1010", "IDE Controller " } ,
    { 0x17F3, 0x1011, "D1011", "Standard IDE Controller" } ,
    { 0x17F3, 0x1030, "M1030", "PCI to PCI-E Bridge" } ,
    { 0x17F3, 0x2010, "M2010", "GPU (VGA )" } ,
    { 0x17F3, 0x3010, "M3010", "HD Audio" } ,
    { 0x17F3, 0x6021, " ", "Host Bridge" } ,
    { 0x17F3, 0x6036, " ", "PCI to ISA Bridge" } ,
    { 0x17F3, 0x6040, "R6040x", "Ethernet MACx" } ,
    { 0x17F3, 0x6060, " modem", "USB Controller (OHCI)" } ,
    { 0x17F3, 0x6061, " V90479. 1", "USB 2.0 Controller (EHCI)" } ,
    { 0x19E3, 0x5801, "NA", "DDRdrive X1" } ,
    { 0x19E3, 0x5808, "NA", "DDRdrive X8" } ,
    { 0x19E3, 0xDD52, " ", "DDRdrive X1-30" } ,
    { 0x17db, 0x0101, "NA", "Seastar Network" } ,
    { 0x17db, 0x0201, "NA", "Gemini Network" } ,
    { 0x17db, 0x0301, "NA", "Aries Network" } ,
    { 0x04B3, 0x24D5, "PCI\\VEN_8086&DEV_24D5&SUBSYS_B026144D&REV_02", "Audio Controller" } ,
    { 0x04B3, 0x401	, "8086", "PCI\\VEN_8086&DEV_293E&SUBSYS_20F217AA&REV_03\\3&B1BFB68&0&D8	" } ,
    { 0x04B3, 0x401, "24C5", "PCI\\VEN_8086&DEV_24C6&REV_03\\3 267A616A" } ,
    { 0x04B3, 0x4010, "cc020000", "PCI\\VEN_10EC&DEV_5227&SUBSYS_220C17AA&REV_01" } ,
    { 0x04B3, 0x9876, "CC_040100", "PCI\\VEN_8086&DEV_1C3A&SUBSYS_1C3A1458&REV_04" } ,
    { 0x051D, 0x0002, "USB\\VID_0B05&PID_580F\\E6AZCY495152", "Inter (R) Core [TM] 2 Duo cpu" } ,
    { 0x051D, 0x051D, "USB\\VID_0B05&PID_580F\\E6AZCY495152", "0x051d" } ,
    { 0x051D, 0x9876, "USB\\VID_0B05&PID_580F\\E6AZCY495152", "USB\\VID_0B05&PID_580F\\E6AZCY495152" } ,
    { 0x7d1, 0x3304, "graphic card", "802.11N usb wifi device" } ,
    { 0x7d1, 0x3c03, "DWL-G122 Wifi PCI", "Same chipset of RALINK  RT2500" } ,
    { 0x7d1, 0x3C07, "D-Link Wireless G DWA-110 USB Adapter", "PCI\\VEN_1799&DEV_700F&SUBSYS_700F1799&REV_20\\3&61AAA01&0&48" } ,
    { 0x05ac, 0x021e, "Keyboard IT USB", "Alluminium Keyboard IT USB" } ,
    { 0x05ac, 0x1293, "Apple iPod 5", "Apple iPod 5" } ,
    { 0x05ac, 0x1297, "Apple iPhone ", "Apple iPhone 4" } ,
    { 0x05ac, 0x21e, "phone 3g", "Allumium keyboard it USB " } ,
    { 0x05ac, 0x8215, "BCM2046", "Broadcom BCM2046 Bluetooth chipset iMac" } ,
    { 0x19a2, 0x0710, "", "Emulex OneConnect 10Gb NIC (be3) (rev01)" } ,
    { 0x19a2, 0x0712, "", "Emulex OneConnect 10Gb iSCSI Initiator (be3) (rev 01)" } ,
    { 0x19a2, 0x0714, "Emulex OneConnect 10Gb FCoE", "Emulex OneConnect 10Gb FCoE &#1048;&#1085;&#1080;&#1094;&#1080;&#1072;&#1090;&#1086;&#1088; (be3) (&" } ,
    { 0x138A, 0x0001, "0001", "REV_0372" } ,
    { 0x138A, 0x0005, "0008", "VFS301 Fingerprint Scanner" } ,
    { 0x138A, 0x0006, "0006", "VFS351 Fingerprint Scanner" } ,
    { 0x138A, 0x0007, "0007", "VFS451 Fingerprint Scanner" } ,
    { 0x138A, 0x0009, "0008", "VFS421 Fingerprint Scanner" } ,
    { 0x138A, 0x0011, "11", "Validity Fingerprint Reader" } ,
    { 0x138A, 0x0018, "Biometric Devices", "Validity Sensors, Inc. (WBF) (PID=0018)" } ,
    { 0x138A, 0x003C, "0086", "VFS431 Validity-Fingerprint Driver" } ,
    { 0x138A, 0x003D, "0104", "Validity Fingerprint Sensor" } ,
    { 0x138A, 0x11, "VFS5011", "Fingerprint Reader" } ,
    { 0x5853, 0x0001, "n/a", "Citrix XenServer PV SCSI Host Adapter" } ,
    { 0x5853, 0x0002, "n/a", "Citrix PV Bus Device" } ,
    { 0x5853, 0xC000, "N/A", "XenServer Device of Windows Update" } ,
    { 0x046D, 0x0805, "atom &#305;ntel &#305;ns&#305;de", "n.a." } ,
    { 0x046D, 0x0808, "n/a", "Logitech Webcam C600" } ,
    { 0x046D, 0x0809, "Unknown", "Webcam Pro 9000" } ,
    { 0x046D, 0x082B, "n/a", "n/a" } ,
    { 0x046D, 0x0896, "5&34B666AE&0&7", "Camera" } ,
    { 0x046D, 0x08AD, "N/A", "Quickcam Communicate STX" } ,
    { 0x046D, 0x08AF, "-", "-" } ,
    { 0x046D, 0x08b2, "123abc", "logitech QuickCam� Pro 4000" } ,
    { 0x046D, 0x08C6, "0x08C1", "Logitech OEM Webcam" } ,
    { 0x046D, 0x08f0, "n/a", "n/a" } ,
    { 0x046D, 0x08F6, "0100", "QuickCam Communicate" } ,
    { 0x046D, 0x092F, "QuickCam Express", "model number: V-UAP9" } ,
    { 0x046D, 0x0A0B, "A-00008", "Logitech ClearChat Pro USB" } ,
    { 0x046D, 0x0A1F, "USB _ phone toush", "Logitech G930 Headset" } ,
    { 0x046D, 0x5a61, "356254", "" } ,
    { 0x046D, 0xC018, "?", "Baesline 3 Button Corded Optical Mouse, 2 button + scroll wheel" } ,
    { 0x046D, 0xC045, "M/N: M-BJ96C. P/N: 830667-0000. PID: c00e", "Epoxy Hidden" } ,
    { 0x046D, 0xC046, "n/a", "n/a" } ,
    { 0x046D, 0xc05b, "ee", "ftht" } ,
    { 0x046D, 0xC063, "k251d", "DELL 6-Button mouse" } ,
    { 0x046D, 0xC226, "n/a", "n/a" } ,
    { 0x046D, 0xC227, "n/a", "n/a" } ,
    { 0x046D, 0xC22D, "n/a", "n/a" } ,
    { 0x046D, 0xC281, "J-UA9", "Wingman Force J-UA9" } ,
    { 0x046D, 0xC312, "n/a", "n/a" } ,
    { 0x046D, 0xC404, "n/a", "Logitech TrackMan Wheel" } ,
    { 0x046D, 0xC50E, "M-RAM99, C-BS35", "MediaPlay Cordless Mouse" } ,
    { 0x046D, 0xC512, "n/a", "n/a" } ,
    { 0x046D, 0xC51B, "n/a", "n/a" } ,
    { 0x046D, 0xc51e, "Unknown", "Unknown" } ,
    { 0x046D, 0xC526, "n/a", "n/a" } ,
    { 0x046D, 0xC52A, "Dell Wireless Keyboard w/ mouse", "HID Keyboard Device" } ,
    { 0x046D, 0xC52B, "FC8708A607198-10F1043TA3", "USB Receiver for Wireless Mouse" } ,
    { 0x046D, 0xC52E, "n/a", "USB3 receiver" } ,
    { 0x046D, 0xC52F, "Logitech Wireless Mouse USB Controller", "Logitech Wireless Mouse USB Controller" } ,
    { 0x04D9, 0x1603, "n\\a", "Samsung" } ,
    { 0x04D9, 0x2011, "n/a", "n/a" } ,
    { 0x0590, 0x0028, "HEM-790IT", "hid device class blood pressure monitor" } ,
    { 0x80EE, 0x7145, "VBoxVideo 0x8168", "VirtualBox Graphics Adapter" } ,
    { 0x80EE, 0xBEEF, "VBoxVideo 0x8168", "VirtualBox Graphics Adapter" } ,
    { 0x80EE, 0xCAFE, "N/A - Virtual Device", "VirtualBox Device" } ,
    { 0x19B6, 0x110c, "AR5413", "Atheros chipset for 802.11a/b/g" } ,
    { 0x10EC, 0x8136, "Realtek AC97Audio drivers", "Realtek 171 High Definition Audio" } ,
    { 0x10EC, 0x0062, "LSISAS1078", "PCI-Express Fusion-MPT SAS" } ,
    { 0x10EC, 0x0129, "unknown", "Realtek USB 2.0 Card Reader" } ,
    { 0x10EC, 0x0185, "802.11b", "Realtek 8180 Extensible 802.11b Wireless Device" } ,
    { 0x10EC, 0x0200, "RTL8102E", "Realtek 10/100/1000 PCI-E NIC Family" } ,
    { 0x10EC, 0x0260, "Realtek ALC260 High Definition Audio", "HDAUDIO\\FUNC_01&VEN_10EC&DEV_0262&SUBSYS_144DC034&REV_1002" } ,
    { 0x10EC, 0x0262, "Realtek ALC 262", "Realtek ALC 262 &#1040;&#1091;&#1076;&#1080;&#1086;" } ,
    { 0x10EC, 0x0268, "ALC268", "High Definition Audio Codecs" } ,
    { 0x10EC, 0x0269, "ALC269", "Realtek High Definition audio" } ,
    { 0x10EC, 0x0270, "0270", "Realtek High Definition Audio " } ,
    { 0x10EC, 0x0272, "ALC272X", "Realtek High Definition audio" } ,
    { 0x10EC, 0x0532, "RTL8723AE", "BT combo mini pcie card" } ,
    { 0x10EC, 0x0660, "HDAUDIO\\FUNC_01&VEN_10EC&DEV_0660&SUBSYS_10191386&", "HD Audio" } ,
    { 0x10EC, 0x0662, "ALC662", "5.1 Channel Audio Codec" } ,
    { 0x10EC, 0x06652, "ALC662", "5.1 channel audio codec" } ,
    { 0x10EC, 0x0861, "ALC862", "Realtek ALC861 High Defintion Audio" } ,
    { 0x10EC, 0x0880, "1631F603", "Realtek 880 High Definition Audio" } ,
    { 0x10EC, 0x0882, "Realtek ALC882/D/M", "Intel 82801GB ICH7 - High Definition Audio Controller" } ,
    { 0x10EC, 0x0883, "ALC883", "Realtek High definition Audio" } ,
    { 0x10EC, 0x0885, "ALC889A", "REALTEK - 8 channel audio card ALC889A" } ,
    { 0x10EC, 0x0887, "FUNC_01&VEN_10EC&DEV_0887&SUBSYS_1458A002&REV_1002", "xHDAUDIO\\FUNC_01&VEN_10EC&DEV_0887&SUBSYS_104383BC&REV_1002\\4&159EE542&0&0001" } ,
    { 0x10EC, 0x0888	, "ALC260", "Realtek High Definition Audio" } ,
    { 0x10EC, 0x0888, "ALC888", "Realtek High Definition Audio" } ,
    { 0x10EC, 0x0889, "1Device Ses GigabyteTeh", "HDAUDIO\\FUNC_01&VEN_10EC&DEV_0662" } ,
    { 0x10EC, 0x0892, "ALC892", "7.1+2 Channel HD Audio Codec with Content Protection" } ,
    { 0x10EC, 0x0900, "ALC1150", "HDAUDIO\\FUNC_01&VEN_10EC&DEV_0900" } ,
    { 0x10EC, 0x0C139, "5229", "PCIE RTS5229 Card Reader" } ,
    { 0x10EC, 0x10B9, "M5288 SATA/Raid controller", "cpi" } ,
    { 0x10EC, 0x10EC, "Realtek AC97Audio", "Realtek 171 High Definition Audio" } ,
    { 0x10EC, 0x10EC, "Realtek AC97Audio", "Realtek 171 High Definition Audio" } ,
    { 0x10EC, 0x12ec, "naum tem", "naum tem " } ,
    { 0x10EC, 0x1626, "PCI\\VEN_10EC&DEV_8039&SUBSYS_803910EC", "Realtek 10/100/1000 PCI-E NIC Family" } ,
    { 0x10EC, 0x5109, "012659873654", "cuenta" } ,
    { 0x10EC, 0x5208, "8185", "Realtek RTS5208 Card Reader" } ,
    { 0x10EC, 0x5209, "Realtek", "Realtek PCIE CardReader" } ,
    { 0x10EC, 0x5227, "123", "Realtek PCIE Card Reader" } ,
    { 0x10EC, 0x5229, "Rts5229", "Realtek PCIE CardReader" } ,
    { 0x10EC, 0x5286, "Realtek RTS528x", "Realtek RTS528x PCIe Card Reader" } ,
    { 0x10EC, 0x5287, "5287", "Realtek PCIE CardReader (PCI Device)" } ,
    { 0x10EC, 0x5288, "Realtek USB 2.0 Card Reader", "card reader" } ,
    { 0x10EC, 0x5289, "RTL8411", "Realtek PCIE Card Reader" } ,
    { 0x10EC, 0x5289 , "RTL8411", " PCIE Card Reader" } ,
    { 0x10EC, 0x5461, "M5461", "High Definition Audio Controller" } ,
    { 0x10EC, 0x5591, "MTC ms9377c", "PCI /ven_1039" } ,
    { 0x10EC, 0x662, "Realtek AC97Audio", "Realtek 171 High Definition Audio" } ,
    { 0x10EC, 0x7305, "Realtek UWB Radio Driver", "PCI\\VEN_10EC&DEV_7305" } ,
    { 0x10EC, 0x8029, "8172", "Realtek RTL8191SE Wireless LAN 802.11n PCI-E NIC" } ,
    { 0x10EC, 0x8039, "10EC", "10EC" } ,
    { 0x10EC, 0x8136, "PCI\\VEN_8086&DEV_1C3A&SUBSYS_1C3A1849&REV_04", "Realtek 10/100/1000 PCI-E NIC Family" } ,
    { 0x10EC, 0x8137, "RTL8102E", "Realtek 10/100/1000 PCI-E NIC Family" } ,
    { 0x10EC, 0x8139, "RTL8139", "RTL8139 Fast Ethernet NIC" } ,
    { 0x10EC, 0x8167, "RTL8167", "Realtek RTL8169/8110" } ,
    { 0x10EC, 0x8168, "RTL8168E/RTL8111F/RTL", "PCIe GBE" } ,
    { 0x10EC, 0x8169, "8169S", "Realtek RTL8169\\8110 &#1057;&#1077;&#1084;&#1100;&#1080; Gigabit Ethernet" } ,
    { 0x10EC, 0x816C, "Realtek virtual IPMI", "\\10EC\\" } ,
    { 0x10EC, 0x8171, "8172", "Realtek RTL8191SE &#1041;&#1077;&#1089;&#1087;&#1088;&#1086;&#1074;&#1086;&#1076;&#1085;&#1086;&#108" } ,
    { 0x10EC, 0x8172, "RTL8191SE-VA2", "Single-Chip IEEE 802.11b/g/n 1T2R WLAN Controller with PCI Express Interface" } ,
    { 0x10EC, 0x8174, "RTL8188RU", "Realtek RTL8188RU" } ,
    { 0x10EC, 0x8176, "RTL8188CE", "Realtek RTL8188CE Wireless LAN 802.11n PCI-E NIC" } ,
    { 0x10EC, 0x8178, "PCE-N15", "ASUS PCE-N15 Wireless LAN PCI-E Card" } ,
    { 0x10EC, 0x8179, "RTL8188E", "IEEE 802.11b/g/n Single-Chip WiFi Chip" } ,
    { 0x10EC, 0x8180, "RTL8180L 802.11b MAC", "Network controller" } ,
    { 0x10EC, 0x8185, "RTL8188ce", "RTL8185L " } ,
    { 0x10EC, 0x8191, "RTL8192CE", "Single-Chip IEEE 802.11b/g/n 2T2R WLAN Controller with PCI Express Interface" } ,
    { 0x10EC, 0x8199, "RTL8187SE", "http://www.realtek.com/downloads/downloadsView.aspx?Langid=1&PNid=21&PFid=40&Level=5&Conn=4&DownType" } ,
    { 0x10EC, 0x8339, "RTL8139", "Realtek 10/100M Fast Ethernet Controller" } ,
    { 0x10EC, 0x8609, "Realtek AC97Audio", "Realtek 171 High Definition Audio" } ,
    { 0x10EC, 0x8723, "8723AE", "Realtek 8191SE Wireless LAN" } ,
    { 0x10EC, 0x8979, "RTL8168", "PCIe Gigabit Ethernet Family Controller" } ,
    { 0x10EC, 0x9876, "Realtek AC97Audio drivers", "Realtek 171 High Definition Audio" } ,
    { 0x10EC, 0xA167, "Realtek RTL8110SC-&#1043;&#1056;.", "Realtek RTL8110SC-&#1043;&#1056;." } ,
    { 0x10EC, 0xB723, "unkown", "Realtek RTL8723BE Wireless LAN 802.11n PCI-NIC #4" } ,
    { 0x10EC, 0xC139, "5229", "PCIE RTS5229 card reader" } ,
    { 0x05E1, 0x0408, "00000000000", "USB 2.0 Video Capture Controller" } ,
    { 0x05E1, 0x0501, "120315000000621", "web cam" } ,
    { 0x0553, 0x0200, "DS38xx", "Oregon Scientific" } ,
    { 0x093a, 0x2468, "Genius iLook 300", "http://genius.ru/products.aspx?pnum=24948&archive=1" } ,
    { 0x093a, 0x2600, "PAC7311", "http://www.speedlink.com/support/bin/24-02-2012/SETUP.rar" } ,
    { 0x093a, 0x2608, "PAC7311 - Toshiba PX1342E-1 CAM", "USB\\VID_093A&PID_2608&REV_0100&MI_00" } ,
    { 0x093a, 0x2620, "CNR-WCAM53G", "WEBCAM http://www.canyon-tech.com/archive/voip/webcams/CNR-WCAM53#pr-switcher" } ,
    { 0x1904, 0x2031, "n /a", "silan sc92031 Network adapter" } ,
    { 0x1904, 0x8139	, "8129", "Realtek RTL8139 PCI Fast Ethernet Adapter" } ,
    { 0x1904, 0x8139, "8139", "Realtek RTL8139 PCI Fast Ethernet Adapter" } ,
    { 0x0b05, 0x170C, "6205", "WIFI USB Card" } ,
    { 0x1B73, 0x1000, "1", "PCI\\VEN_1000&DEV_0020&SUBSYS_10301000&REV_01PCI\\VEN" } ,
    { 0x1B73, 0x1009, "Unknown", "USB3.0 host controller" } ,
    { 0x1B73, 0x1100, "n/a", "USB 3.0 eXtensibile Host controller" } ,
    { 0x17FE, 0x2220, "2120", "Generic IEEE 802.11b/g Wireless LAN Card" } ,
    { 0x0DF6, 0x9071, "   \\t9071\\t WL-113 - Wireless Network USB dongle 5", "\\t9071\\t   WL-113 - Wireless Network USB dongle 54g  " } ,
    { 0x1682, 0x2931, "unknown", "HD-467X-DDF2 video card " } ,
    { 0x1682, 0x9875, "779A", "HD 7700 Series" } ,
    { 0x1B6F, 0x7023, "DEV_7023&REV_010", "Etron USB 3.0 Extensible Host Controller" } ,
    { 0x0E8D, 0x0002, "2200", "PCI Simple Communications Controller / Mobiles China" } ,
    { 0x0E8D, 0x0003, "VT6212L", "usb" } ,
    { 0x0cf3, 0x1002, "Wireless USB 2.0 adapter TL-WN821N", "Wireless USB 2.0 adapter TL-WN821N" } ,
    { 0x0cf3, 0x3000, "USB\\VID_0000&PID_0000\\6&F763642&0&4", "USB\\VID_0000&PID_0000\\6&F763642&0&4" } ,
    { 0x0cf3, 0x3002, "USB\\VID_0CF3&PID_3002&REV_0001", "USB\\VID_0CF3&PID_3002&REV_0001" } ,
    { 0x0cf3, 0x3002, "unknown", "unknown" } ,
    { 0x0cf3, 0x3005, "AR3011", "Atheros Bluetooth Module" } ,
    { 0x0cf3, 0x9271, "0x0108", "TP-LINK 150 Mbps Wireless Lite N Adapter TL-WN721N" } ,
    { 0x1491, 0x0020, "USB Fingerprint Scanner Model FS80", "USB Fingerprint Scanner Model FS80" } ,
    { 0x1491, 0x0021, "USB Fingerprint Scanner Model FS80", "USB Fingerprint Scanner Model FS80" } ,
    { 0x0483, 0x2016, "UPEK fingerprint sensors ", "Driver Windows xp" } ,
    { 0x0AC8, 0x1234, "1", "1" } ,
    { 0x0AC8, 0x6719, "3330", "8086&DEV_0F18&SUBSYS_16DD1043&REV_0E" } ,
    { 0x0AC8, 0x9876, "1", "1" } ,
    { 0x1688, 0x0013, "AR5213", "" } ,
    { 0x0402, 0x1050, "0x1050", "ethernet controller" } ,
    { 0x0402, 0x5606, "0x0436", "0x4752" } ,
    { 0x0402, 0x8086, "0x8086", "video controller" } ,
    { 0x0402, 0x9665, "PCI\\VEN_10DE&DEV_0059&SUBSYS_2052161F&REV_A2", "ZCT8YBT'" } ,
    { 0x17A1, 0x0128 , " 17A1", "USB2.0 JPEG WebCam " } ,
    { 0x096E, 0x0201, "Rockey4", " " } ,
    { 0x04F2, 0xb008, "USB\\VID_138A&PID_0001", ".oem44.inf" } ,
    { 0x04F2, 0xB044, ".", "Webcam" } ,
    { 0x04F2, 0xB175, "0001", "SN" } ,
    { 0x04F2, 0xB217, "01A000166", "Integrated Camera" } ,
    { 0x04F2, 0xB307, "6030", "Webcam" } ,
    { 0x1912, 0x0014, "YET-D720201-0014", "usb3.0 renesas" } ,
    { 0x1912, 0x0015, " upd720202", " nec" } ,
    { 0x1912, 0x0015, "EC01-P", "Renesas Electronics USB 3.0 Host Controller" } ,
    { 0x4348, 0x1453, "202204073", "WCH353L" } ,
    { 0x4348, 0x3253, "32534348", "SIE9835 PCI=>DUAL SERIAL" } ,
    { 0x4348, 0x5053, "4348", "4980" } ,
    { 0x4348, 0x7053, "35255", "PCI Serial Port" } ,
    { 0x4348, 0x7173, "ch350L", " CH35X" } ,
    { 0x0A92, 0x1010, "1010&REV_0101&MI_00", " RoMI/o by Egosys - Midi USB Cable" } ,
    { 0x1B21, 0x0612, "Asmedia 106x SATA Controler", "Link Below to Mainboard Driver inside" } ,
    { 0x1B21, 0x1041, "SUBSYS_2104174C", "USB 3.0 Host Controller Driver for Windows 7" } ,
    { 0x1B21, 0x1042, "pci\\ven_14f1&dev_2f50&subsys_205f14f1&rev_01\\4&cf8", "Asmedia ASM104x USB 3.0 Host Controller" } ,
    { 0x8087, 0x0028, "NV05", "MCP67 High Definition Audio" } ,
    { 0x8087, 0x07D6, "612BNXHMW", "Intel Centrino Wireless-N + WiMAX 6150" } ,
    { 0x06FE, 0x9700, "i don't know", "a netcard used usb interface" } ,
    { 0x0D8C, 0x000E, "00", "Generic USB Audio Device" } ,
    { 0x0D8C, 0x0102, "6206lc", "USB 5.1CH audio codec" } ,
    { 0x0D8C, 0x5200, "0x5200", "C-Media USB 2.0 Mass Storage Controller" } ,
    { 0x04A9, 0x314D, "unknown", "uhknown" } ,
    { 0x1c39, 0x0300, "PEGAVIO", "Pegasus Board PCI-e interface" } ,
    { 0x168C, 0x001c, "AR5005GS", "pci\\ven_10ac&dev_ooo" } ,
    { 0x168C, 0x00027, "E017105B", "Atheros AR5B95 Wireless LAN 802.11 a/b/g/n Controller" } ,
    { 0x168C, 0x00030, "PCI\\VEN_168C&DEV_0030&SUBSYS_16A810CF&REV_01", "TP-LINK 450Mbps Wireless N Adapter" } ,
    { 0x168C, 0x0007, "AR5007UG", "ROOT\\MS_SSTPMINIPORT\\0000" } ,
    { 0x168C, 0x0011, "11L/b/g Wireless LAN Mini PCI Adapter", "11L/b/g Wireless LAN Mini PCI Adapter" } ,
    { 0x168C, 0x0012, "AR5211", " PCI\\VEN_1217&DEV_7130&SUBSYS_FF501179&REV_01 DELL Latitude C510 as mini-PCI board behind the larg" } ,
    { 0x168C, 0x0013, "Netgear WPN311", "Netgear RangeMax WPN311 PCI Wireless NIC" } ,
    { 0x168C, 0x0019, "AR5bmb5", "802.11a Wireless Adapter" } ,
    { 0x168C, 0x001A, "Atheros AR5005GS", "http://support1.toshiba-tro.de/tools/updates/atheros-wlan/atheros-wlan-xp-7702331.zip" } ,
    { 0x168C, 0x001B, "AR5006X", "802.11abg NIC" } ,
    { 0x168C, 0x001c, "AR5007EG", "Atheros AR5007EG Wireless Network Adapter" } ,
    { 0x168C, 0x001C, "AR5BXB63", "Atheros AR5BXB63 WWAN Chip" } ,
    { 0x168C, 0x001c, "AR5BXB61", "AR5006EX AR5423a" } ,
    { 0x168C, 0x001D, "TP-Link TL-WN350GD", "PCI\\VEN_168C&DEV_002B&SUBSYS_E034105B&REV_01\\4&124A40C8&0&00E1" } ,
    { 0x168C, 0x002, "c660", "PCI/VEN_168C&DEV_002B&SUBSYS_7173144F&REV_01\\4&200004B7&0&00E1" } ,
    { 0x168C, 0x0023, "AR5416", "802.11a/b/g/n&#1041;&#1077;&#1089;&#1087;&#1088;&#1086;&#1074;&#1086;&#1076;&#1085;&#1086;&#1081; PC" } ,
    { 0x168C, 0x0024, "AR5B97", "Atheros 802.11a/b/g/n" } ,
    { 0x168C, 0x0027, "E017105B", "Atheros AR5B95 Wireless LAN 802.11 a/b/g/n Controller" } ,
    { 0x168C, 0x002A, "AR9283-ALIA or DW1525", "Wireless Network Adapter" } ,
    { 0x168C, 0x002B, "66318898888811ad", "Atheros AR5B95 " } ,
    { 0x168C, 0x002C, "AR5006", "Wireless 802.11 a/b/g/n WiFi Adapter (PCI-Express)" } ,
    { 0x168C, 0x002D, "AR9287 rev01", "802.11b/g/n" } ,
    { 0x168C, 0x002E, "AR9287", "Atheros ar9287 PCI &#1052;&#1086;&#1078;&#1083;&#1080;&#1074;&#1086;&#1089;&#1090;&#1110;: &#1047;&#" } ,
    { 0x168C, 0x0030, "1102 - 1103", "Killer Wireless - N" } ,
    { 0x168C, 0x0032, "168Cx0032", "Atheros AR9485" } ,
    { 0x168C, 0x0034, "DW1901", "802.11a/b/g/n, BT4.0+HS " } ,
    { 0x168C, 0x0036, "AR956x", "Qualcomm Atheros AR956x Wireless Network Adapter" } ,
    { 0x168C, 0x0037, "AR1111", "Atheros AR1111 WB-EG Wireless Network Adapter" } ,
    { 0x168C, 0x003e, "QCA61x4", "Wireless Network Adapter" } ,
    { 0x168C, 0x007, "AR5007UG", "Wireless Network Adapter" } ,
    { 0x168C, 0x0280, "0x002b", "PCI\\VEN_168C&DEV_002B&SUBSYS_30AF185F" } ,
    { 0x168C, 0x032, "0x0280", "Dell Wireless DW1703 802.11b/g/n, BT4.0 + HS " } ,
    { 0x168C, 0x1014, "AR9285", "Atheros AR5212 802.11abg wireless Drivers" } ,
    { 0x168C, 0x14F1, "nForce6100-430  ", "PCI\\VEN_168C&DEV_001A&SUBSYS_04181468&REV_01\\4&FCF0450&0&10A4" } ,
    { 0x168C, 0x168C, "AREG9485WB-0036", "Qualcomm Atheros AR9485WB-EG Wireless Network Adapter" } ,
    { 0x168C, 0x1a3b, "ar8132", "802.11a/b/g/n Wireless PCI Adapte" } ,
    { 0x168C, 0x3002, "AR3011", "Bluetooth 3.0" } ,
    { 0x168C, 0x6666, "AR5007UG", "Atheros AR5B95 Wireless LAN 802.11 a/b/g/n Controller" } ,
    { 0x168C, 0x9876, "AR5419", "Atheros AR5B95 Wireless LAN 802.11 a/b/g/n Controller" } ,
    { 0x168C, 0xFF1B, "AR 5001", "Wireless LAN G" } ,
    { 0x168C, 0xFF96, "AR5212", "LAN-Express AS IEEE 802.11g miniPCI adapter" } ,
    { 0x1690, 0x0742, "BCM2070", "BRCM Bluetooth Controller BCM2070" } ,
    { 0x1710, 0x5812, "5812", "itech numeric small keyboard" } ,
    { 0x1710, 0x9835, "9825", "2 serial, 1 LPT port PCI Card" } ,
    { 0x1712, 0x3038 , "VT6212L", "usb" } ,
    { 0x1712, 0x7130, "0x1712", "unknown" } ,
    { 0x1303, 0x0001, "0239", "cM67 CompactPCI DSP Card" } ,
    { 0x1303, 0x0002, "1", "M44/cM44 DSP board" } ,
    { 0x1303, 0x0003, "1", "Quattro6x DSP board" } ,
    { 0x1303, 0x0004, "1", "Chico/ChicoPlus Data Acquisition Board" } ,
    { 0x1303, 0x0005, "1", "Code Hammer Jtag Debugger board" } ,
    { 0x1303, 0x0006, "1", "Matador DSP board" } ,
    { 0x1303, 0x0007, "1", "Quixote DSP board" } ,
    { 0x1303, 0x0008, "1", "Quadia C64x DSP" } ,
    { 0x1303, 0x0009, "1", "Quadia DSP Baseboard" } ,
    { 0x4144, 0x0040, "ADM-XRC", "Virtex-E Bridge" } ,
    { 0x4144, 0x0041, "ADM-XRC-II Lite", "Virtex-II Bridge" } ,
    { 0x4144, 0x0042, "ADM-XRC-II", "Virtex-II Bridge" } ,
    { 0x4144, 0x0043, "ADM-XPL", "Virtex-II Pro Bridge" } ,
    { 0x4144, 0x0044, "ADM-XP", "Virtex-II Pro PCI/PCI-X Bridge" } ,
    { 0x4144, 0x0045, "ADP-WRC-II", "Virtex-II Bridge" } ,
    { 0x4144, 0x0046, "ADP-DRC-II", "Virtex-II Bridge" } ,
    { 0x4144, 0x0049, "ADP-XPI", "Virtex-II Pro PCI" } ,
    { 0x4144, 0x004A, "ADP-XPI (PCI-X)", "Virtex-II Pro PCI-X Bridge" } ,
    { 0x4144, 0x004F, "ADM-XRC-4FX", "Virtex-II Pro PCI-X Bridge" } ,
    { 0x4144, 0x0050, "ADM-XRC-5LX", "Virtex-4LX Bridge" } ,
    { 0x4144, 0x0051, "ADM-XRC-5T1", "ADM-XRC-5T1" } ,
    { 0x4144, 0x0052, "ADM-XRC-5T2", "Xilinx Virtex 5 PMC" } ,
    { 0x4144, 0x0056, "ADM-AMC-5A2", "Virtex 5 AMC FPGA board" } ,
    { 0x4144, 0x0057, "ADM-XRC-5TZ", "Xilinx Virtex 5 FPGA PMC " } ,
    { 0x4144, 0x0058, "ADC-VXS", "VXS FPGA and PMC Carrier Board" } ,
    { 0x4144, 0x005B, "ADM-XRC-5T2-ADV", "ADM-XRC-5T2 with JPEG 2000 devices" } ,
    { 0x4144, 0x005C, "ADM-XRC-5T-DA1", "FPGA PMC with Analog I/O Interface" } ,
    { 0x4144, 0x005F, "ADM-XRC-5T2-ADV6", "As per XRC-5T2 but with 6 JPEG2000 devices" } ,
    { 0x4144, 0x0300, "ADM-XRC-6T1", "Xilinx Virtex 6 FPGA XMC" } ,
    { 0x4144, 0x0301, "ADM-XRC-6TGE", "Xilinx Virtex 6 FPGA XMC" } ,
    { 0x4144, 0x0303, "ADPe-XRC-6T-L", "Full lenght PCI Express Xilinx Virtex-6 FPGA platform" } ,
    { 0x4144, 0x0305, "ADPe-XRC-6T", "Full length PC Card Xilinx Virtex-6 FPGA platform" } ,
    { 0x17E9, 0x02a7, "0000", "USB VGA/DVI Adapter UV-D4A1-B" } ,
    { 0x17E9, 0x4318, "n/a", "Dell GigabitEthernet (USB-G1000)" } ,
    { 0x1332, 0x5410, "MM-5410D", "PCI 32bit Bulk Memory w/DMA" } ,
    { 0x1332, 0x5415, "MM-5415CN", "PCI Battery Backed SDRAM Adapter" } ,
    { 0x1332, 0x5425, "MM-5425CN", "PCI Memory Module with Battery Backup" } ,
    { 0x1332, 0x6140, "MM-6140D", "Memory Module" } ,
    { 0x1888, 0x0301, "", "" } ,
    { 0x1888, 0x0601, "", "" } ,
    { 0x1888, 0x0710, "", "" } ,
    { 0x1888, 0x0720, "", "" } ,
    { 0x1888, 0x2503, "Bt881", "Video Capture (10 bit High qualtiy cap)" } ,
    { 0x1888, 0x2504, "Bt878", "Video Capture" } ,
    { 0x1888, 0x3503, "nVidia NV28", "VGA Geforce4 MX440" } ,
    { 0x1888, 0x3505, "nVidia NV28", "VGA Geforce4 Ti4200" } ,
    { 0x167F, 0x4634, "", "FOB-IO Card" } ,
    { 0x167F, 0x4C32, "", "L2B PCI Board" } ,
    { 0x167F, 0x5344, "SD \\ VID_03 Ð¸ OID_5344 Ð¸ PID_SU01G Ð¸ REV_", "FOB-SD Card" } ,
    { 0x167F, 0x5443, "", "FOB-TDC Card" } ,
    { 0x167F, 0xF0B1, "ibaFOB-io-D", "ibaFOB-io-D" } ,
    { 0x167F, 0xF0B2, "ibaFOB-2io-D", "ibaFOB-2io-D" } ,
    { 0x167F, 0xF0B4, "ibaFOB-4io-D", "ibaFOB-4io-D" } ,
    { 0x167F, 0xF1B2, "ibaFOB-2i-D", "ibaFOB-2i-D" } ,
    { 0x167F, 0xF5DE, "ibaFOB-SDexp", "ibaFOB-SDexp" } ,
    { 0x167F, 0xFDCE, "ibaFOB-TDCexp", "ibaFOB-TDCexp" } ,
    { 0x167F, 0xFEC1, "ibaFOB-io-ExpressCard", "ibaFOB-io-ExpressCard" } ,
    { 0x14B5, 0x0200, "Scope", "" } ,
    { 0x14B5, 0x0300, "Pulsar", "" } ,
    { 0x14B5, 0x0400, "Pulsar SRB", "" } ,
    { 0x14B5, 0x0600, "Pulsar 2", "" } ,
    { 0x14B5, 0x0800, "", "DSP-Board" } ,
    { 0x14B5, 0x0900, "1039", "DSP-Board" } ,
    { 0x14B5, 0x0A00, "", "DSP-Board" } ,
    { 0x14B5, 0x0B00, "", "DSP-Board" } ,
    { 0x148C, 0x4011, "RV250", "RADEON 9000 PRO EVIL COMMANDO" } ,
    { 0x148C, 0x4152, "0x1002", "0x2079" } ,
    { 0x174B, 0x0260, "RV280", "Saphire Radeon 9250" } ,
    { 0x174B, 0x0261, "RV280", "Sapphire Radeon 9250 - Secondary" } ,
    { 0x174B, 0x7176, "RV250", "RADEON 9000 ATLANTIS PRO" } ,
    { 0x174B, 0x7177, "RV280", "RADEON 9000 ATLANTIS PRO - Secondary" } ,
    { 0x174B, 0x71C6, "RV530", "ATI RADEON X1650 Series" } ,
    { 0x174B, 0x7244, "RV580", "Sapphire ATI  X1950 XT" } ,
    { 0x174B, 0x7C12, "RV280", "RADEON 9200 ATLANTIS - Secondary" } ,
    { 0x174B, 0x7C13, "RV280", "RADEON 9200 ATLANTIS" } ,
    { 0x174B, 0x9501, "RV620 ", "ATI Radeon HD 3450" } ,
    { 0x174B, 0xE106, "0x954F", "Graphics Chipset	ATI Radeon HD 4300/4500 Series       	" } ,
    { 0x174B, 0xe131, "RV770", "ATI 4870" } ,
    { 0x174B, 0xE140, "5870", "Sapphire HD 5870 1GB GDDR5" } ,
    { 0x17EE, 0x4153, "RV350", "Radeon 9550" } ,
    { 0x1328, 0x2048, "", "" } ,
    { 0x1328, 0x8888, "rev 1.5", "cPEG� C 3.0 DVD/MPEG2 decoder" } ,
    { 0x16EC, 0x0116, "RTL8169S", "RealTek 8169S chip" } ,
    { 0x16EC, 0x0303, "Rev_0200", "U.S. Robotics 56K FAX USB V1.1.0 /  V.92 USB modem" } ,
    { 0x16EC, 0x1007, "0637", "U.S. Robotics 56K Win INT" } ,
    { 0x16EC, 0x2013, "11323A", "U.S. Robotics 56K Voice Host Int" } ,
    { 0x16EC, 0x2F00, "USRobotics 5660A - Internal Soft Modem", "http://www.usr.com/support/product-template.asp?prod=5660a" } ,
    { 0x16EC, 0x2f12, "E129336-1", "U.S.Robotic (A- Modem/PCI)" } ,
    { 0x16EC, 0x3685, "1518", "Wireless Access Adapter Model 022415" } ,
    { 0x16EC, 0x5685, "E129336-1", "U.S. Robotics 56K Voice Host Int (A-Modem/ PCI)" } ,
    { 0x003D, 0x003a, "mx98715/25", "i740pci" } ,
    { 0x003D, 0x003d, "mx98715/25", "1740pci" } ,
    { 0x003D, 0x00D1, "mx98715/25", "i740 PCI" } ,
    { 0x0E11, 0x0001, "2", "PCI to EISA Bridge" } ,
    { 0x0E11, 0x0002, "64320", "D2ufG0  <a href=" } ,
    { 0x0E11, 0x000F, "CPQB1A9", "StorageWorks Library Adapter (HVD)" } ,
    { 0x0E11, 0x0012, "686P7", "686P7" } ,
    { 0x0E11, 0x0046, "Intel Exteme Graphics", "Smart Array 6400 Controller" } ,
    { 0x0E11, 0x0049, "NC7132", "Gigabit Upgrade Module" } ,
    { 0x0E11, 0x004A, "NC6136", "Gigabit Server Adapter" } ,
    { 0x0E11, 0x005A, "PowerPC 405GP processor at 200MHz [3305103C]", "HP Remote Insight Lights-Out II Board" } ,
    { 0x0E11, 0x00B1, "3305103C", "HP Remote Insight Lights-Out II PCI Device" } ,
    { 0x0E11, 0x00C0, "Adaptec AIC-7899G", "64Bit,66MHz,Dual Channel WideUltra3 SCSI" } ,
    { 0x0E11, 0x0508, "Neteligent 4/16 TR", "PCI UTP/STP Controller" } ,
    { 0x0E11, 0x1000, "Triflex Model 1000", "Pentium Bridge" } ,
    { 0x0E11, 0x2000, "Triflex Model 2000", "Pentium Bridge" } ,
    { 0x0E11, 0x3032, "95479", "n9XQeH  <a href=" } ,
    { 0x0E11, 0x3033, "23505", "HTdOCe  <a href=" } ,
    { 0x0E11, 0x3034, "QVision 1280/p v2", "GUI Accelerator" } ,
    { 0x0E11, 0x4000, "Triflex Model 4000", "Pentium Bridge" } ,
    { 0x0E11, 0x6010, "Model 6010", "HotPlug PCI Bridge" } ,
    { 0x0E11, 0x7020, "camara web", "USB Controller" } ,
    { 0x0E11, 0xA0EC, "", "Original Compaq fibre Channel HBA" } ,
    { 0x0E11, 0xA0F0, "", "Advanced System Management Controller" } ,
    { 0x0E11, 0xA0F3, "", "Triflex PCI to ISA PnP Bridge" } ,
    { 0x0E11, 0xA0F7, "PCI bus 6, device 4, function 4", "PCI Hotplug Controller" } ,
    { 0x0E11, 0xA0F8, "ZFMicro", "USB Open Host Controller" } ,
    { 0x0E11, 0xA0FC, "HPFC-5166A", "Tachyon TL 64-bit/66-Mhz FC HBA" } ,
    { 0x0E11, 0xAe10, "", "Smart-2 Array Controller" } ,
    { 0x0E11, 0xAE29, "MIS-L", "PCI to ISA Bridge" } ,
    { 0x0E11, 0xAE2A, "MPC", "CPU to PCI Bridge" } ,
    { 0x0E11, 0xAE2B, "MIS-E", "PCI to ISA PnP Bridge" } ,
    { 0x0E11, 0xAE31, "1002&DEV-5653&SUBSYS", "System Management Controller" } ,
    { 0x0E11, 0xAE32, "950", "Netelligent 10/100 TX PCI UTP TLAN 2.3" } ,
    { 0x0E11, 0xAE33, "Triflex", "Dual EIDE Controller" } ,
    { 0x0E11, 0xAE34, "", "Netelligent 10 T PCI UTP TLAN 2.3" } ,
    { 0x0E11, 0xAE35, "", "Integrated NetFlex 3/P TLAN 2.3" } ,
    { 0x0E11, 0xAE40, "", "Dual Port Netelligent 10/100 TX PCI TLAN" } ,
    { 0x0E11, 0xAE43, "", "Integrated Netelligent 10/100 TX PCI" } ,
    { 0x0E11, 0xAE69, "CETUS-L", "PCI to ISA Bridge" } ,
    { 0x0E11, 0xAE6C, "DRACO", "PCI Bridge" } ,
    { 0x0E11, 0xAE6D, "NorthStar", "CPU to PCI Bridge" } ,
    { 0x0E11, 0xB011, "", "Dual Port Netelligent 10/100 TX" } ,
    { 0x0E11, 0xB012, "Netelligent 10 T/2", "UTP/Coax PCI" } ,
    { 0x0E11, 0xB01E, "NC3120", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB01F, "NC3122", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB02F, "NC1120", "Ethernet NIC" } ,
    { 0x0E11, 0xB030, "Netelligent WS 1500", "10/100TX Embedded UTP/Coax Controller" } ,
    { 0x0E11, 0xB04A, "699209-003", "10/100TX WOL UTP Controller" } ,
    { 0x0E11, 0XB060, "CISS", "SMART2 Array Controller" } ,
    { 0x0E11, 0xB0C6, "NC3161", "Fast Ethernet Embedded Controller w/ WOL" } ,
    { 0x0E11, 0xB0C7, "NC3160", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB0D7, "NC3121 rev. A & B", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB0DD, "NC3131", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB0DE, "NC3132", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB0DF, "NC6132", "Gigabit Module" } ,
    { 0x0E11, 0xB0E0, "NC6133", "Gigabit Module" } ,
    { 0x0E11, 0xB0E1, "NC3133", "Fast Ethernet Module" } ,
    { 0x0E11, 0xB123, "NC6134", "Gigabit NIC" } ,
    { 0x0E11, 0xB134, "NC3163", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB13C, "NC3162", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB144, "NC3123", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB163, "NC3134", "Fast Ethernet NIC" } ,
    { 0x0E11, 0xB164, "NC3135", "Fast Ethernet Upgrade Module" } ,
    { 0x0E11, 0xB178, "CISSB", "SMART2 Array Controller" } ,
    { 0x0E11, 0xB196, "0230", "Conexant SoftK56 Modem" } ,
    { 0x0E11, 0xB1A4, "NC7131", "Gigabit Server Adapter" } ,
    { 0x0E11, 0xB203, "iLo", "Integrated Lights Out Processor" } ,
    { 0x0E11, 0xB204, "iLo", "Integrated Lights Out Processor" } ,
    { 0x0E11, 0xF095, "FCA2101", "HP StorageWorks 2 Gb, 64-Bit/66-MHz PCI-to-Fibre Channel Host Bus Adapter for Windows 2000, Windows" } ,
    { 0x0E11, 0xF130, "", "ThunderLAN 1.0 NetFlex-3/P" } ,
    { 0x0E11, 0xF150, "PCI\\VEN_14E4&DEV_1698&REV_10", "ThunderLAN 2.3 NetFlex-3/P with BNC" } ,
    { 0x0E11, 0xF700, "", "LP7000 Compaq/Emulex Fibre Channel HBA" } ,
    { 0x0E11, 0xF800, "", "LP8000 Compaq/Emulex Fibre Channel HBA" } ,
    { 0x1000, 0x0001, "LSI53C810", "PCI-SCSI I/O Processor" } ,
    { 0x1000, 0x0002, "53C820", "Fast-wide SCSI gg" } ,
    { 0x1000, 0x0003, "LSI53C1010-33", "PCI to SCSI I/O Processor" } ,
    { 0x1000, 0x0004, "53C815", "SCSI raid controllers" } ,
    { 0x1000, 0x0005, "53C810AP", "Fast SCSI" } ,
    { 0x1000, 0x0006, "LSI53C860/860E", "PCI to Ultra SCSI I/O Processor" } ,
    { 0x1000, 0x000A, "LSI53C1510", "PCI Dual Channel Wide Ultra2 SCSI Ctrlr" } ,
    { 0x1000, 0x000B, "LSI53C896/897", "PCI Dual Channel Wide Ultra2 SCSI Ctrlr" } ,
    { 0x1000, 0x000C, "LSI53C895", "PCI to Ultra2 SCSI I/O Processor" } ,
    { 0x1000, 0x000D, "53C885", "Ultra Wide SCSI, Ethernet" } ,
    { 0x1000, 0x000F, "53C875/875E/876/876E", "PCI to Ultra SCSI I/O Processor" } ,
    { 0x1000, 0x0010, "LSI53C1510", "I2O-Ready PCI RAID Ultra2 SCSI Ctrlr" } ,
    { 0x1000, 0x0012, "LSI53C895A", "PCI to Ultra2 SCSI Controller" } ,
    { 0x1000, 0x0013, "LSI53C875A", "PCI to Ultra SCSI Controller" } ,
    { 0x1000, 0x0020, "LSI53C1010-33", "PCI to Dual Channel Ultra3 SCSI Ctrlr" } ,
    { 0x1000, 0x0021, "LSI53C1000/1000R/1010R/1010-66", "PCI to Ultra160 SCSI Controller" } ,
    { 0x1000, 0x0030, "LSI53C1020/1030", "PCI-X to Ultra320 SCSI Controller" } ,
    { 0x1000, 0x0031, "LSI53C1030ZC", "PCI-X SCSI Controller" } ,
    { 0x1000, 0x0032, "LSI53C1035", "PCI-X to Ultra320 SCSI Controller" } ,
    { 0x1000, 0x0035, "LSI53C1035", "PCI-X SCSI Controller" } ,
    { 0x1000, 0x0040, "LSI53C1035", "PCI-X to Ultra320 SCSI Controller" } ,
    { 0x1000, 0x0050, "LSISAS1068E", "LSISAS1068E / LSI SAS 6i RAID Controller" } ,
    { 0x1000, 0x0054, "LSISAS1068", "LSI Adapter SAS 3000 series 8-port with 1068" } ,
    { 0x1000, 0x0056, "LSISAS1064ET", "PCI-Express Fusion-MPT SAS" } ,
    { 0x1000, 0x0058, "LSISAS1068E", "PCI-Express Fusion-MPT SAS" } ,
    { 0x1000, 0x005B, "LSISAS2108/2208", "LSI Logic / Symbios Logic MegaRAID SAS 2208 [Thunderbolt] [1000:005b] (rev 05)" } ,
    { 0x1000, 0x005e, "LSISAS1066", "PCI-X Fusion-MPT SAS" } ,
    { 0x1000, 0x0060, "0x1734", "0x10f9" } ,
    { 0x1000, 0x0062, "LSISAS1078", "PCI-Express Fusion-MPT SAS" } ,
    { 0x1000, 0x0064, "LSISAS2116", "PCI-Express Fusion-MPT SAS 2.0" } ,
    { 0x1000, 0x0072, "SAS2008", "Dell PERC H200" } ,
    { 0x1000, 0x0073, "LSISAS2008", "IBM ServeRAID M1015, Dell Perc H310" } ,
    { 0x1000, 0x0080, "LSI Logic SAS2208", "PCI-Express Fusion-MPT SAS 2.0/2.5" } ,
    { 0x1000, 0x008F, "53C810", "LSI 53C8xx SCSI host adapter chip" } ,
    { 0x1000, 0x0097, "LSISAS3008", "SAS3008 PCI-Express Fusion-MPT SAS-3" } ,
    { 0x1000, 0x0408 , "L3-01037-03D", "U320-2E Raid Controller" } ,
    { 0x1000, 0x0621, "LSIFC909", "Fibre Channel I/O Processor" } ,
    { 0x1000, 0x0622, "53c885", "Dial Channel Fibre Channel I/O Processor" } ,
    { 0x1000, 0x0623, "LSIFC929", "Dual Channel Fibre Channel I/O Processor" } ,
    { 0x1000, 0x0624, "LSIFC919", "Fibre Channel I/O Processor" } ,
    { 0x1000, 0x0625, "LSIFC919", "Fibre Channel I/O Processor" } ,
    { 0x1000, 0x0626, "LSIFC929X", "Fibre Channel Adapter" } ,
    { 0x1000, 0x0628, "LSIFC919X", "Fibre Channel Adapter" } ,
    { 0x1000, 0x0630, "LSIFC920", "Fibre Channel I/O Processor" } ,
    { 0x1000, 0x0640, "LSIFC949X", "Fibre Channel Adapter" } ,
    { 0x1000, 0x0642, "LSIFC939X", "Fibre Channel Adapter" } ,
    { 0x1000, 0x0646, "LSIFC949ES", "Fibre Channel Adapter" } ,
    { 0x1000, 0x0701, "53C885", "10/100 MBit Ethernet" } ,
    { 0x1000, 0x0702, "Yellowfin G-NIC", "Gigabit Ethernet Controller" } ,
    { 0x1000, 0x0901, "61C102", "USB Controller" } ,
    { 0x1000, 0x1000, "63C815", "Fast SCSI Controller" } ,
    { 0x1000, 0x1001, "53C895", "Symbios Ultra2 SCSI controller" } ,
    { 0x1000, 0x1010, "LSI 53C102000", "Single channel SCSI controller" } ,
    { 0x1000, 0x1020, "LSI53C1020", "LSI Logic MegaRAID 320-1 Dell PowerEdge PERC 4/SC" } ,
    { 0x1000, 0x1960, "6002432", "RAID Controller" } ,
    { 0x1000, 0x3050, "LSISAS2008", "PCI-Express Fusion-MPT SAS 2.0" } ,
    { 0x1000, 0x9876, "7DB82C.YF.F.3.25", "5946504E44383243" } ,
    { 0x1002, 0x4370, "RV370", "ATI RADEON X300/X550/X1050 Series Secondary" } ,
    { 0x1002, 0x6760, "6470M", "AMD Radeon HD 6470M" } ,
    { 0x1002, 0x0002, "EMU10K1", "Audio Cipset (SB) Livel" } ,
    { 0x1002, 0x000D, "bhjkh", "ATI RADEON X1200 &#1089;&#1077;&#1088;&#1080;&#1080;" } ,
    { 0x1002, 0x0180 , "LXPAY0Y001926158A92000        ", "AMD Athlon(tm) X2 Dual-Core QL-62" } ,
    { 0x1002, 0x0300, "1002", "PCI" } ,
    { 0x1002, 0x0B12, "R580", "ATI Radeon X1900" } ,
    { 0x1002, 0x1002, "RV360", "ATI RADEON 9250 Series" } ,
    { 0x1002, 0x1028, "R9 200", "Radeon R9 200 Series" } ,
    { 0x1002, 0x1043, "RV410", "ATI MOBILITY/ATI RADEON X700" } ,
    { 0x1002, 0x11, "0x215r2qzua21", "0xbcg62" } ,
    { 0x1002, 0x1111, "ATI Technologies Inc. / Advanced Micro Devices, In", "ATI Technologies Inc. " } ,
    { 0x1002, 0x1202, "1202", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1313, "Q770", "AMD Radeon R7 Series" } ,
    { 0x1002, 0x1314, "1314", "High Definition Audio Controller" } ,
    { 0x1002, 0x1400, "1400", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1401, "1401", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1402, "1402", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1403, "1403", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1404, "1404", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1405, "1405", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1410, "1410", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x1417, "1417", "PCI Express standard Root Port" } ,
    { 0x1002, 0x1419, "1419", "IOMMU Device" } ,
    { 0x1002, 0x1631, "0000", "bus" } ,
    { 0x1002, 0x1714, "A4-3400", "AMD Radeon� HD 6410D Audio" } ,
    { 0x1002, 0x1ab8, "2", "ati radeon " } ,
    { 0x1002, 0x3150, "M24", "ATI MOBILITY /ATI RADEON X600" } ,
    { 0x1002, 0x3151, "RV380", "ATI FireMV 2400" } ,
    { 0x1002, 0x3152, "M24", "ATI MOBILITY /ATI RADEON X300" } ,
    { 0x1002, 0x3154, "M24GL", "ATI MOBILITY FireGL V3200" } ,
    { 0x1002, 0x3171, "RV380", "ATI FireMV 2400 Secondary" } ,
    { 0x1002, 0x3E50, "PCI\\VEN_1002&DEV_68A8&SUBSYS_159B103C&REV_00", "ATI RADEON 6870" } ,
    { 0x1002, 0x3E54, "RV380GL", "ATI FireGL V3200" } ,
    { 0x1002, 0x3E70, "RV380", "ATI RADEON X600/X550 Series Secondary" } ,
    { 0x1002, 0x3E74, "RV380GL", "ATI FireGL V3200 Secondary" } ,
    { 0x1002, 0x4136, "A3", "Radeon IGP 320" } ,
    { 0x1002, 0x4137, "RS200", "Radeon IGP 340m" } ,
    { 0x1002, 0x4143, "9550", "X1050" } ,
    { 0x1002, 0x4144, "R300", "ATI RADEON 9500" } ,
    { 0x1002, 0x4145, "R300", "Radeon 9200 (M+X)" } ,
    { 0x1002, 0x4146, "R300", "ATI RADEON 9600TX" } ,
    { 0x1002, 0x4147, "R300GL", "ATI FireGL Z1" } ,
    { 0x1002, 0x4148, "R350", "ATI RADEON 9800 SE" } ,
    { 0x1002, 0x4149, "R350", "ATI RADEON 9500" } ,
    { 0x1002, 0x4150, "RV_00", "ATI RADEON 9600 Pro Family (Microsoft Driver)" } ,
    { 0x1002, 0x4151, "RV350", "ATI RADEON 9600 Series" } ,
    { 0x1002, 0x4152, "RV360", "ATI RADEON 9600 Series" } ,
    { 0x1002, 0x4153, "RV350", "ATI RADEON 9550/X1050 Series" } ,
    { 0x1002, 0x4154, "RV350GL", "ATI FireGL T2" } ,
    { 0x1002, 0x4155, "RV350", "ATI RADEON 9600 Series" } ,
    { 0x1002, 0x4158, "AA01", "PCI\\VEN_1002&DEV_AAC8&SUBSYS_AAC8174B&REV_00" } ,
    { 0x1002, 0x4164, "R300", "ATI RADEON 9500 Secondary" } ,
    { 0x1002, 0x4166, "R300", "ATI RADEON 9600TX Secondary" } ,
    { 0x1002, 0x4167, "R300GL", "ATI FireGL Z1 Secondary" } ,
    { 0x1002, 0x4168, "R350", "ATI RADEON 9800 SE Secondary" } ,
    { 0x1002, 0x4169, "R350", "ATI RADEON 9500 Secondary" } ,
    { 0x1002, 0x4170, "RV_00", "ATI RADEON 9600/9550/x1050 Series Secondary (" } ,
    { 0x1002, 0x4171, "RV350", "ATI RADEON 9600 Series Secondary" } ,
    { 0x1002, 0x4172, "REV_00", "ATI RADEON 9600 Series Secondary" } ,
    { 0x1002, 0x4173, "4484", "ATI RADEON 9550/X1050 Series Secondary" } ,
    { 0x1002, 0x4174, "RV350GL", "ATI FireGL T2 Secondary" } ,
    { 0x1002, 0x4175, "RV350", "RADEON 9200 pro secundar" } ,
    { 0x1002, 0x4242, "R200AIW", "All-In-Wonder 8500DV" } ,
    { 0x1002, 0x4243, "", "Lucent OHCI IEEE1394 Host Controller" } ,
    { 0x1002, 0x4336, "rs200", "Radeon IGP 320M" } ,
    { 0x1002, 0x4337, "RS200M", "RADEON IGP 345M" } ,
    { 0x1002, 0x4341, "SB200", "AC'97 Audio Controller" } ,
    { 0x1002, 0x4342, "SB200", "PCI-PCI Bridge" } ,
    { 0x1002, 0x4345, "SB200", "EHCI USB Controller" } ,
    { 0x1002, 0x4347, "SB200", "USB Controller" } ,
    { 0x1002, 0x4348, "SB200", "USB Controller" } ,
    { 0x1002, 0x4349, "SB200", "PATA-100 IDE Controller" } ,
    { 0x1002, 0x434C, "SB200", "PCI-ISA Bridge" } ,
    { 0x1002, 0x434d, "SB200", "AC'97 Modem Controller" } ,
    { 0x1002, 0x4353, "SB200", "SMBus Controller" } ,
    { 0x1002, 0x4354, "215CT", "Mach64 CT" } ,
    { 0x1002, 0x4358, "113-A52021-104", "PCI\\VEN_1002&DEV_9553&SUBSYS_00821043&REV_00" } ,
    { 0x1002, 0x4361, "ALC665", "ATI AC97 REALTEK AUDIO DRIVER" } ,
    { 0x1002, 0x4363, "SB300", "ATI SOUTH BRIDGE SB300 DRIVER" } ,
    { 0x1002, 0x4369, "IXP 3xx", "PATA 133 Controller" } ,
    { 0x1002, 0x436E, "IXP 3xx", "ATI 436E Serial ATA Controller" } ,
    { 0x1002, 0x4370, "SB400", "AC-Link Audio" } ,
    { 0x1002, 0x4371, "IXP SB400", "PCI Standard PCI-to-PCI bridge" } ,
    { 0x1002, 0x4372, "SMBus Controller", "SMBus Controller" } ,
    { 0x1002, 0x4373, "IXP SB400", "Standard Enhanced PCI to USB Host Controller" } ,
    { 0x1002, 0x4374, "IXP SB400", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x4375, "IXP SB400", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x4376, "SB4xx", "PATA 133 Controller" } ,
    { 0x1002, 0x4377, "IXP SB400", "PCI Stanard ISA Bridge" } ,
    { 0x1002, 0x4378, "SB400", "AC'97 Modem Controller" } ,
    { 0x1002, 0x4379, "SB400 / SB450 (Sil3112)", "ATI 4379 Serial ATA Controller" } ,
    { 0x1002, 0x437A, "SB4xx", "ATI 437A Serial ATA Controller" } ,
    { 0x1002, 0x437B, "SB450", "High Definition Audio Controller " } ,
    { 0x1002, 0x4380, "ATI SB600", "SATA2" } ,
    { 0x1002, 0x4380, "ATI SB600", "RAID/AHCI Controller" } ,
    { 0x1002, 0x4380, "ATI RS690m", "AHCI Controller" } ,
    { 0x1002, 0x4381, "ATI ?", "AHCI/Raid Controller" } ,
    { 0x1002, 0x4383, "SB700", "High Definition Audio controller" } ,
    { 0x1002, 0x4384, "4384", "ATI I/O Communications Processor PCI Bus Controller" } ,
    { 0x1002, 0x4385, "ATI RD600/RS600", "ATI I/O Communications Processor SMBus Controller" } ,
    { 0x1002, 0x4386, "690G", "Northbridge" } ,
    { 0x1002, 0x4387, "4387", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x4388, "4388", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x4389, "4389", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x438A, "438A", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x438B, "438B", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x438C, "RD600/RS600", "ATI RD600/RS600 IDE Controller" } ,
    { 0x1002, 0x438D, "SB600", "PCI to LPC Bridge" } ,
    { 0x1002, 0x439, "rv360", "ATI Technologies SB700 LPCHost Controller" } ,
    { 0x1002, 0x4390, "SB750", "Integrated SATA II Controller" } ,
    { 0x1002, 0x4391, "ATI SB700", "AHCI Controller" } ,
    { 0x1002, 0x4391, "AMD SB850", "AMD Southbridge incorporating AHCI 1.2 with SATA FIS�based switching support" } ,
    { 0x1002, 0x4392, "ATI SB700", "Raid Controller" } ,
    { 0x1002, 0x4393, "ATI SB850", "RAID-Controller" } ,
    { 0x1002, 0x4394, "5100", "AMD SP5100 South Bridge" } ,
    { 0x1002, 0x4396, "210888CX", "Standard Enhanced PCI to USB Host Controller" } ,
    { 0x1002, 0x4397, "4397", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x4398, "SB700", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x439C, "SB7xx", "PATA 133 Controller" } ,
    { 0x1002, 0x439D, "SB700 LPC", "74A" } ,
    { 0x1002, 0x43A0, "43A0", "PCI Express standard Root Port" } ,
    { 0x1002, 0x43A3, "43A3", "PCI Express standard Root Port" } ,
    { 0x1002, 0x4437, "ATI Mobility Radeon 7000 IGP", "RS250M" } ,
    { 0x1002, 0x4554, "Mach64 ET", "" } ,
    { 0x1002, 0x4654, "Mach64 VT", "113--34004-104" } ,
    { 0x1002, 0x4742, "(GT-C2U2)", "3D Rage Pro AGP 1X" } ,
    { 0x1002, 0x4744, "Rage 3D Pro AGP 2x", "Rage 3D Pro AGP 2x" } ,
    { 0x1002, 0x4747, "GT-C2U2", "Rage 3D Pro" } ,
    { 0x1002, 0x4749, "RAGE PRO TURBO AGP 2X", "ATI ALL IN WONDER PRO (8MB)" } ,
    { 0x1002, 0x474C, "Rage XC PCI-66", "k7 som+" } ,
    { 0x1002, 0x474D, "Rage XL AGP 2x", "SLAT" } ,
    { 0x1002, 0x474E, "Rage XC AGP 2x", "" } ,
    { 0x1002, 0x474F, "Rage XL PCI-66", "I Need Driver for the Chip" } ,
    { 0x1002, 0x4750, "1039", "ATI 3D Rage Pro 215GP" } ,
    { 0x1002, 0x4751, "0x1002", "0x4752" } ,
    { 0x1002, 0x4752, "Rage XL PCI", "ATI On-Board VGA for HP Proliant 350 G3" } ,
    { 0x1002, 0x4753, "Rage XC PCI", "" } ,
    { 0x1002, 0x4754, "Mach 64 VT", "Rage 3D II Graphics Accelerator" } ,
    { 0x1002, 0x4755, "Rage 3D II+pci", "3d rage 2 + dvd" } ,
    { 0x1002, 0x4756, "Rage 3D IIC AGP", "Graphics Accelerator" } ,
    { 0x1002, 0x4757, "3D 11C AGP", "Rage 3D IIC AGP" } ,
    { 0x1002, 0x4758, "210888GX", "Mach64 GX" } ,
    { 0x1002, 0x4759, "215r2qzua21", "m3d agp card on agp slot" } ,
    { 0x1002, 0x475A, "215r2qua12", "Rage IIC AGP" } ,
    { 0x1002, 0x4966, "RV250", "Radeon 9000/9000 Pro" } ,
    { 0x1002, 0x4967, "RV250", "Radeon 9000" } ,
    { 0x1002, 0x496E, "RV250", "Radeon 9000/9000 Pro - Secondary" } ,
    { 0x1002, 0x496F, "RV250", "Radeon 9000 - Secondary" } ,
    { 0x1002, 0x4A48, "R420", "ATI RADEON X800 Series" } ,
    { 0x1002, 0x4a49, "R420", "ATI RADEON X800 PRO" } ,
    { 0x1002, 0x4A4A, "R420", "ATI RADEON X800 Series" } ,
    { 0x1002, 0x4a4b, "R420", "ATI RADEON X800 XT" } ,
    { 0x1002, 0x4A4C, "R420", "ATI RADEON X800 Series" } ,
    { 0x1002, 0x4A4D, "R420GL", "ATI FireGL X3-256" } ,
    { 0x1002, 0x4A4E, "M18", "ATI MOBILITY /ATI RADEON 9800" } ,
    { 0x1002, 0x4A4F, "R420", "ATI RADEON X800 SE" } ,
    { 0x1002, 0x4A50, "R420", "ATI RADEON X800 XT Platinum Edition" } ,
    { 0x1002, 0x4A54, "R420", "ATI RADEON X800 VE" } ,
    { 0x1002, 0x4A68, "R420", "ATI RADEON X800 Series Secondary" } ,
    { 0x1002, 0x4A69, "R420", "ATI RADEON X800 PRO Secondary" } ,
    { 0x1002, 0x4A6A, "R420", "ATI RADEON X800 Series Secondary" } ,
    { 0x1002, 0x4a6b, "R420", "ATI RADEON X800 XT Secondary" } ,
    { 0x1002, 0x4A6C, "R420", "ATI RADEON X800 Series Secondary" } ,
    { 0x1002, 0x4A6D, "R420GL", "ATI FireGL X3-256 Secondary" } ,
    { 0x1002, 0x4A6F, "R420", "ATI RADEON X800 SE Secondary" } ,
    { 0x1002, 0x4A70, "R420", "ATI RADEON X800 XT Platinum Edition Secondary" } ,
    { 0x1002, 0x4A74, "R420", "ATI RADEON X800 VE Secondary" } ,
    { 0x1002, 0x4B49, "R481", "ATI RADEON X850 XT" } ,
    { 0x1002, 0x4B4B, "R481", "ATI RADEON X850 PRO" } ,
    { 0x1002, 0x4B4C, "R481", "ATI RADEON X850 XT Platinum Edition" } ,
    { 0x1002, 0x4B69, "R481", "ATI RADEON X850 XT Secondary" } ,
    { 0x1002, 0x4B6A, "R481", "ATI RADEON X850 SE Secondary" } ,
    { 0x1002, 0x4B6B, "R481", "ATI RADEON X850 PRO Secondary" } ,
    { 0x1002, 0x4B6C, "R481", "ATI RADEON X850 XT Platinum Edition Secondary" } ,
    { 0x1002, 0x4C42, "B10E0E11", "3D Rage LT Pro AGP-133" } ,
    { 0x1002, 0x4C44, "Rage 3D LT Pro AGP", "Rage 3D LT Pro AGP 133 MHz" } ,
    { 0x1002, 0x4C45, "", "Rage Mobility M3 AGP" } ,
    { 0x1002, 0x4C46, "Mobility M3 AGP", "0x9495" } ,
    { 0x1002, 0x4C47, "ati rage pro", "Rage 3D LT-G" } ,
    { 0x1002, 0x4C49, "123", "Rage 3D LT Pro" } ,
    { 0x1002, 0x4C4D, "01541014", "Rage P/M Mobility AGP 2x" } ,
    { 0x1002, 0x4C4E, "216lo sasa25", "Rage Mobility l" } ,
    { 0x1002, 0x4C50, "unknown", "Rage 3D LT Pro PCI" } ,
    { 0x1002, 0x4C51, "113", "Rage 3D LT Pro PCI" } ,
    { 0x1002, 0x4C52, "1241243", "Rage P/M Mobility agp" } ,
    { 0x1002, 0x4C53, "216L0SASA25", "Rage L Mobility PCI" } ,
    { 0x1002, 0x4C54, "4372", "Mach 64 LT" } ,
    { 0x1002, 0x4C57, "M7 [LW]", "Mobility Radeon 7500" } ,
    { 0x1002, 0x4C58, "(0x71C1)          DAC type: Internal DAC(400MHz)  ", "FireGL Mobility" } ,
    { 0x1002, 0x4C59, "ATI Mobility Radeon 7000 with 16MB (7500 with 16 o", "ATI Mobility Radeon AGP (0x4C59), ATI Technologies Inc. -kompatible" } ,
    { 0x1002, 0x4C5A, "", "Radeon Mobility M6 LZ" } ,
    { 0x1002, 0x4C64, "", "Radeon Mobility M9-GL" } ,
    { 0x1002, 0x4C66, "RV250", "ATI MOBILITY RADEON 9000" } ,
    { 0x1002, 0x4C6E, "0x4C6E", "ATI FireMV 2400 PCI" } ,
    { 0x1002, 0x4D46, "ATI mobility128", "Rage Mobility 128 AGP 4x" } ,
    { 0x1002, 0x4D4C, "216l0sasa25", "Rage Mobility 128 AGP" } ,
    { 0x1002, 0x4D52, "ATI Theater 550 Pro", "ATI Theater 550 Pro" } ,
    { 0x1002, 0x4D53, "TVT2 Wonder Elite", "TVT2 Wonder Elite" } ,
    { 0x1002, 0x4E44, "R300", "ATI RADEON 9700 PRO" } ,
    { 0x1002, 0x4E45, "R300", "ATI RADEON 9500 PRO / 9700" } ,
    { 0x1002, 0x4e46, "R300", "ATI RADEON 9600 TX" } ,
    { 0x1002, 0x4E47, "R300GL", "ATI FireGL X1" } ,
    { 0x1002, 0x4E48, "R350", "ATI RADEON 9800 PRO" } ,
    { 0x1002, 0x4E49, "R350", "ATI RADEON 9800" } ,
    { 0x1002, 0x4E4A, "R360", "ATI RADEON 9800 XT" } ,
    { 0x1002, 0x4E4B, "R350GL", "ATI FireGL X2-256/X2-256t" } ,
    { 0x1002, 0x4E50, "M10", "ATI MOBILITY /ATI RADEON 9600/9700 Series" } ,
    { 0x1002, 0x4E51, "RV350", "ATI RADEON 9600 Series" } ,
    { 0x1002, 0x4E52, "M10", "ATI MOBILITY /ATI RADEON 9500" } ,
    { 0x1002, 0x4E54, "M10GL", "ATI MOBILITY FIRE GL T2/T2e" } ,
    { 0x1002, 0x4E56, "M12", "ATI MOBILITY /ATI RADEON 9400" } ,
    { 0x1002, 0x4E64, "R300", "ATI RADEON 9700" } ,
    { 0x1002, 0x4E65, "R300", "ATI RADEON 9500 PRO / 9700 Secondary" } ,
    { 0x1002, 0x4e66, "R300", "ATI RADEON 9600 TX Secondary" } ,
    { 0x1002, 0x4E67, "R300GL", "ATI FireGL X1 Secondary" } ,
    { 0x1002, 0x4E68, "R350", "ATI RADEON 9800 PRO Secondary" } ,
    { 0x1002, 0x4E69, "R350", "ATI RADEON 9800 Secondary" } ,
    { 0x1002, 0x4E6A, "R360", "ATI RADEON 9800 XT Secondary" } ,
    { 0x1002, 0x4E6B, "R350GL", "ATI FireGL X2-256/X2-256t Secondary" } ,
    { 0x1002, 0x4E71, "RV350", "ATI RADEON 9600 Series Secondary" } ,
    { 0x1002, 0x5041, "gt", "Rage 128 Pro PA PCI" } ,
    { 0x1002, 0x5042, "rage 128 pf pro agp ", "Rage 128 Pro PB AGP 2x" } ,
    { 0x1002, 0x5043, "1231324445", "Rage 128 Pro PC AGP 4x" } ,
    { 0x1002, 0x5044, "rv100", "Rage 128 Pro PD PCI" } ,
    { 0x1002, 0x5045, "", "Rage 128 Pro PE AGP 2x" } ,
    { 0x1002, 0x5046, "R128", "Rage 128 Pro PF AGP 4x" } ,
    { 0x1002, 0x5047, "215R3BUA22", " 3d Rage pro agp 2x" } ,
    { 0x1002, 0x5048, "8212104D", "Rage 128 Pro PH AGP 2x" } ,
    { 0x1002, 0x5049, "R128", "Rage 128 Pro PI AGP 4x" } ,
    { 0x1002, 0x504A, "Rage 128 Pro PJ PCI", "Rage 128 Pro PJ PCI (TMDS)" } ,
    { 0x1002, 0x504B, "Rage 128 Pro PK AGP", "Rage 128 Pro PK AGP 2x (TMDS)" } ,
    { 0x1002, 0x504C, "Rage 128 Pro PL AGP", "4x (TMDS)" } ,
    { 0x1002, 0x504D, "Rage 128 Pro PM PCI", "Rage 128 Pro PM PCI" } ,
    { 0x1002, 0x504E, "Rage 128 Pro PN AGP", "Rage 128 Pro PN AGP 2x" } ,
    { 0x1002, 0x504F, "Rage 128 Pro PO AGP", "Rage 128 Pro PO AGP 4x" } ,
    { 0x1002, 0x5050, "Scheda Grafica Standard PCI(VGA)", "Rage 128 Pro PP PCI (TMDS)" } ,
    { 0x1002, 0x5051, "Rage 128 Pro PQ AGP", "Rage 128 Pro PQ AGP 2x (TMDS)" } ,
    { 0x1002, 0x5052, "Rage 128 Pro PR AGP", "Rage 128 Pro PR AGP 4x (TMDS)" } ,
    { 0x1002, 0x5053, "Rage 128 Pro PS PCI", "Rage 128 Pro PS PCI" } ,
    { 0x1002, 0x5054, "Rage 128 Pro PT AGP", "Rage 128 Pro PT AGP 2x" } ,
    { 0x1002, 0x5055, "rage 128 pro agp 4x tmds", "rage 128 pro agp 4x tmds" } ,
    { 0x1002, 0x5056, "Rage 128 Pro PV PCI", "Rage 128 Pro PV PCI (TMDS)" } ,
    { 0x1002, 0x5057, "Rage 128 Pro PW AGP", "Rage 128 Pro PW AGP 2x (TMDS)" } ,
    { 0x1002, 0x5058, "Rage 128 Pro", "PX AGP 4x (TMDS)" } ,
    { 0x1002, 0x5144, "Radeon 7200 QD SDR/DDR", "Radeon 7200 QD SDR/DDR" } ,
    { 0x1002, 0x5145, "", "Radeon QE" } ,
    { 0x1002, 0x5146, "", "Radeon QF" } ,
    { 0x1002, 0x5147, "", "Radeon QG" } ,
    { 0x1002, 0x5148, "R200", "Radeon R200 QH" } ,
    { 0x1002, 0x5149, "", "Radeon R200 QI" } ,
    { 0x1002, 0x514A, "", "Radeon R200 QJ" } ,
    { 0x1002, 0x514B, "", "Radeon R200 QK" } ,
    { 0x1002, 0x514C, "R200", "Radeon 8500 / 8500LE" } ,
    { 0x1002, 0x514D, "R200", "Redeon 9100 Series" } ,
    { 0x1002, 0x514E, "", "Radeon R200 QM" } ,
    { 0x1002, 0x514F, "", "Radeon R200 QN" } ,
    { 0x1002, 0x5157, "RV200", "Radeon 7500" } ,
    { 0x1002, 0x5158, "radeon 9200", "Radeon 7500 QX" } ,
    { 0x1002, 0x5159, "RV100", "Radeon 7000 series AGP " } ,
    { 0x1002, 0x515A, "", "Radeon VE QZ" } ,
    { 0x1002, 0x515E, "Radeon ES1000", "Radeon ES1000" } ,
    { 0x1002, 0x5168, "ati", "Radeon R200 Qh" } ,
    { 0x1002, 0x5169, "", "Radeon R200 Qi" } ,
    { 0x1002, 0x516A, "", "Radeon R200 Qj" } ,
    { 0x1002, 0x516B, "", "Radeon R200 Qk" } ,
    { 0x1002, 0x516C, "E7505", "Radeon 8500 / 8500LE" } ,
    { 0x1002, 0x516D, "R200", "Redeon 9100 Series - Secondary" } ,
    { 0x1002, 0x5245, "215R2QZUA21", "Rage 128 GL PCI" } ,
    { 0x1002, 0x5246, "Rage 128", "Rage 32MB" } ,
    { 0x1002, 0x5247, "Rage 32MB", "Rage 128 RG" } ,
    { 0x1002, 0x524B, "g01080-108", "Rage 128 VR RK PCI" } ,
    { 0x1002, 0x524C, "", "Rage 128 VR RL AGP 2x" } ,
    { 0x1002, 0x5345, "", "Rage 128 4x SE PCI" } ,
    { 0x1002, 0x5346, "Rage 128 SF 4x AGP 2x", "Rage 128 SF 4x AGP 2x" } ,
    { 0x1002, 0x5347, "", "Rage 128 SG 4x AGP 4x" } ,
    { 0x1002, 0x5348, "", "Rage 128 4x SH" } ,
    { 0x1002, 0x534B, "Rage 128 SK PCI", "Rage 128 4x SK PCI" } ,
    { 0x1002, 0x534C, "Rage 128 SL AGP 2x", "Rage 128 4x SL AGP 2x" } ,
    { 0x1002, 0x534D, "Rage 128 SM AGP 4x", "Rage 128 4x SM AGP 4x" } ,
    { 0x1002, 0x534E, "Rage 128 4x", "" } ,
    { 0x1002, 0x5354, "", "Mach 64 ST" } ,
    { 0x1002, 0x5446, "unknown", "Rage 128 Pro Ultra TF" } ,
    { 0x1002, 0x544C, "", "Rage 128 Pro TL" } ,
    { 0x1002, 0x5452, "5452", "Rage 128 Pro TR" } ,
    { 0x1002, 0x5455, "", "Rage 128 Pro Ultra TU" } ,
    { 0x1002, 0x5457, "RS200M", "RADEON IGP 345M" } ,
    { 0x1002, 0x5460, "M22", "ATI MOBILITY /ATI RADEON X300" } ,
    { 0x1002, 0x5461, "M22", "ATI MOBILITY /ATI RADEON X300" } ,
    { 0x1002, 0x5462, "M24C", "ATI MOBILITY /ATI RADEON X600 SE" } ,
    { 0x1002, 0x5464, "M22GL", "ATI MOBILITY FireGL V3100" } ,
    { 0x1002, 0x5548, "R423", "ATI RADEON X800 Series" } ,
    { 0x1002, 0x5549, "R423", "ATI RADEON X800 GTO" } ,
    { 0x1002, 0x554A, "R423", "ATI RADEON X800 XT Platinum Edition" } ,
    { 0x1002, 0x554b, "R423", "ATI RADEON X800 GT" } ,
    { 0x1002, 0x554D, "R430", "ATI RADEON X800 CrossFire Edition" } ,
    { 0x1002, 0x554E, "R430", "ATI RADEON X800 GT" } ,
    { 0x1002, 0x554F, "R430", "ATI RADEON X800 GTO" } ,
    { 0x1002, 0x5550, "R423GL", "ATI FireGL V7100" } ,
    { 0x1002, 0x5551, "R423GL", "ATI FireGL V5100" } ,
    { 0x1002, 0x5568, "R423", "ATI RADEON X800 Series Secondary" } ,
    { 0x1002, 0x5569, "R423", "ATI RADEON X800 GTO Secondary" } ,
    { 0x1002, 0x556A, "R423", "ATI RADEON X800 XT Platinum Edition Secondary" } ,
    { 0x1002, 0x556B, "R423", "ATI RADEON X800 GT Secondary" } ,
    { 0x1002, 0x556D, "R430", "ATI RADEON X800 CrossFire Edition Secondary" } ,
    { 0x1002, 0x556E, "R430", "ATI RADEON X800 GT Secondary" } ,
    { 0x1002, 0x556F, "R430", "ATI RADEON X800 GTO Secondary" } ,
    { 0x1002, 0x5570, "R423GL", "ATI FireGL V7100 Secondary" } ,
    { 0x1002, 0x5571, "R423GL", "ATI FireGL V5100  Secondary" } ,
    { 0x1002, 0x564A, "M26GL", "ATI MOBILITY FireGL V5000" } ,
    { 0x1002, 0x564B, "M26GL", "ATI MOBILITY FireGL V5000" } ,
    { 0x1002, 0x564F, "M26", "ATI MOBILITY /ATI RADEON X700 XL" } ,
    { 0x1002, 0x5652, "M26", "ATI MOBILITY /ATI RADEON X700" } ,
    { 0x1002, 0x5653, "RV410", "ATI MOBILITY/ATI RADEON X700" } ,
    { 0x1002, 0x5654, "264VT", "Mach64 VT" } ,
    { 0x1002, 0x5655, "", "Mach 64 VT3" } ,
    { 0x1002, 0x5656, "Mach 64 VT4 PCI", "Mach 64 VT4 PCI" } ,
    { 0x1002, 0x5657, "RV410", "ATI RADEON X550/X700 Series" } ,
    { 0x1002, 0x5673, "M26", "ATI MOBILITY /ATI RADEON X700 Secondary" } ,
    { 0x1002, 0x5677, "RV410", "ATI RADEON X550/X700 Series Secondary" } ,
    { 0x1002, 0x5830, "RS300", "Host Bridge" } ,
    { 0x1002, 0x5831, "RS300", "Host Bridge" } ,
    { 0x1002, 0x5832, "RS300", "Host Bridge" } ,
    { 0x1002, 0x5833, "RS300M", "ATI Radeon 9000/9100 IGP Chipset - Host-PCI Bridge" } ,
    { 0x1002, 0x5834, "RS300", "Radeon 9100 IGP" } ,
    { 0x1002, 0x5835, "RS300M", "Mobilitiy Radeon 9000 IGP (RGP)" } ,
    { 0x1002, 0x5838, "RS330M", "ATI Radeon 9000/9100 IGP Chipset - AGP Controller" } ,
    { 0x1002, 0x5854, "RS480", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5874, "RS482", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5940, "RV280", "Radeon 9200 Pro Secondary" } ,
    { 0x1002, 0x5941, "RV280", "ATI Radeon 9200 - Secondary" } ,
    { 0x1002, 0x5950, "RS480", "PCI standard Host CPU Bridge" } ,
    { 0x1002, 0x5954, "RS482", "ATI RADEON Xpress 200" } ,
    { 0x1002, 0x5955, "RS480M", "ATI RADEON Xpress 200M" } ,
    { 0x1002, 0x5960, "RV280", "Radeon 9200 Pro" } ,
    { 0x1002, 0x5960, "A051400005470", "PN 1024-RC26-1F-SA" } ,
    { 0x1002, 0x5961, "RV280", "ATI RADEON 9200 se agp" } ,
    { 0x1002, 0x5962, "Rev_01", "Radeon 9200" } ,
    { 0x1002, 0x5964, "Radeon 9200", "Radeon 9200 SE Series" } ,
    { 0x1002, 0x5965, "unknown", "FireMV 2200" } ,
    { 0x1002, 0x5974, "RS482", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5974, "RS482", "ATI Radeon Xpress 200M (Mobile)" } ,
    { 0x1002, 0x5975, "RS482M (200M)", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5a23, "RD890", "AMD IOMMU" } ,
    { 0x1002, 0x5a31, "RS400/133", "Host Bridge" } ,
    { 0x1002, 0x5A33, "RC410", "Northbridge: Radeon Xpress 200" } ,
    { 0x1002, 0x5A3F, "5A3F", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1002, 0x5A41, "0x5A41	ATI RADEON Xpress 1200 Series	0x1002", "0x5A41	ATI RADEON Xpress 1200 Series	0x1002" } ,
    { 0x1002, 0x5A41, "RS400", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5A42, "RS400M", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5A43, "RS400", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5A60, "SUBSYS_FF311179", "Video Controller" } ,
    { 0x1002, 0x5A61, "RC410", "ATI Radeon Xpress 200" } ,
    { 0x1002, 0x5A61, "RC410", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5A62, "PCI\\VEN_1002&DEV_5A62&SUBSYS_2A051584&REV_00", "ATI Radeon X 200" } ,
    { 0x1002, 0x5A63, "RC410", "ATI RADEON Xpress Series" } ,
    { 0x1002, 0x5b60, "RV370", "ATI RADEON X300/X550/X1050 Series.." } ,
    { 0x1002, 0x5b62, "RV380x", "ATI RADEON X600 Series" } ,
    { 0x1002, 0x5B63, "REV_00\\4&178951BB&0&0008", "ATI RADEON X300/X550/X1050 Series" } ,
    { 0x1002, 0x5B64, "RV370GL", "ATI FireGL V3100" } ,
    { 0x1002, 0x5B65, "RV370", "ATI FireMV 2200" } ,
    { 0x1002, 0x5B60, "RV370", "ATI RADEON X300/X550/X1050 Series" } ,
    { 0x1002, 0x5B70, "RV380", "Radeon" } ,
    { 0x1002, 0x5B72, "RV380x", "ATI RADEON X600 Series Secondary" } ,
    { 0x1002, 0x5B73, "RV370", "0 SerieATI RADEON X300 Secondary" } ,
    { 0x1002, 0x5B74, "RV370GL", "ATI FireGL V3100 Secondary" } ,
    { 0x1002, 0x5B75, "RV370", "ATI FireMV 2200 Secondary" } ,
    { 0x1002, 0x5C61, "bk-ati ver008.016m.085.006", "Mobility Radeon 9200" } ,
    { 0x1002, 0x5C63, "RV280 (M9+)", "Mobility Radeon 9200" } ,
    { 0x1002, 0x5D44, "RV280", "Radeon 9200 SE Series - Secondary" } ,
    { 0x1002, 0x5D45, "RV280", "ATI FireMV 2200 PCI Secondary" } ,
    { 0x1002, 0x5D48, "M28", "ATI MOBILITY/ATI RADEON X800  XT" } ,
    { 0x1002, 0x5D49, "M28GL", "ATI MOBILITY FireGL V5100" } ,
    { 0x1002, 0x5d4a, "M28", "ATI MOBILITY /ATI RADEON X800" } ,
    { 0x1002, 0x5d4d, "R480", "ATI RADEON X850 XT Platinum Edition" } ,
    { 0x1002, 0x5d4f, "R480", "ATI RADEON X800 GTO" } ,
    { 0x1002, 0x5D50, "R480GL", "ATI FireGL V7200" } ,
    { 0x1002, 0x5d52, "R480", "ATI RADEON X850 XT" } ,
    { 0x1002, 0x5D57, "R423", "ATI RADEON X800 XT" } ,
    { 0x1002, 0x5d6d, "R480", "ATI RADEON X850 XT Platinum Edition Secondary" } ,
    { 0x1002, 0x5D6F, "R480", "ATI RADEON X800 GTO Secondary" } ,
    { 0x1002, 0x5D70, "R480GL", "ATI FireGL V7200 Secondary" } ,
    { 0x1002, 0x5D72, "R480", "ATI RADEON X850 XT Secondary" } ,
    { 0x1002, 0x5D77, "R423", "ATI RADEON X800 XT Secondary" } ,
    { 0x1002, 0x5E48, "RV410GL", "ATI FireGL V5000" } ,
    { 0x1002, 0x5E4A, "RV410", "ATI RADEON X700 XT" } ,
    { 0x1002, 0x5E4B, "RV410", "ATI RADEON X700 PRO" } ,
    { 0x1002, 0x5E4C, "RV410", "ATI RADEON X700 SE" } ,
    { 0x1002, 0x5E4D, "RV410", "ATI RADEON X700" } ,
    { 0x1002, 0x5E4F, "RV410", "ATI RADEON X700/X550 Series" } ,
    { 0x1002, 0x5E68, "RV410GL", "ATI FireGL V5000 Secondary" } ,
    { 0x1002, 0x5E6A, "RV410", "ATI RADEON X700 XT Secondary" } ,
    { 0x1002, 0x5E6B, "RV410", "ATI RADEON X700 PRO Secondary" } ,
    { 0x1002, 0x5E6C, "RV410", "ATI RADEON X700 SE Secondary" } ,
    { 0x1002, 0x5E6D, "RV410", "ATI RADEON X700 Secondary" } ,
    { 0x1002, 0x5E6F, "RV410", "ATI RADEON X700/X550 Series Secondary" } ,
    { 0x1002, 0x6076, "123123132", "11" } ,
    { 0x1002, 0x6600, "AMD", "Radeon HD 8600M/8700M/8750M" } ,
    { 0x1002, 0x6718, "CAYMAN XT", "AMD Radeon HD 6970" } ,
    { 0x1002, 0x6719, "Cayman", "AMD Radeon HD 6950" } ,
    { 0x1002, 0x6738, "HD6870", "MSI" } ,
    { 0x1002, 0x6739, "Barts (Pro)", "AMD Radeon HD 6850" } ,
    { 0x1002, 0x673E, "0x2310", "0x1787" } ,
    { 0x1002, 0x6740, "Powered by AMD", "ATI Radeon HD 6700M" } ,
    { 0x1002, 0x6741, "Whistler", "AMD Radeon� HD 6700M/HD 6600M Series " } ,
    { 0x1002, 0x6741, "AMD Radeon HD 7450M (6470M)&#12289;6630M&#12289;In", "PCI\\VEN_1002&DEV_6741&SUBSYS_21E317AA&REV_00" } ,
    { 0x1002, 0x6749, "unknown", "unknown" } ,
    { 0x1002, 0x674A, "V3900", "AMD FirePro V3900 graphics" } ,
    { 0x1002, 0x6750, "1996", "AMD Radeon HD 6570" } ,
    { 0x1002, 0x6758, "NI", "AMD Radeon HD 6670" } ,
    { 0x1002, 0x6759, "1996", "AMD Radeon HD 6570" } ,
    { 0x1002, 0x675D, "HD7570", "AMD Radeon HD7570" } ,
    { 0x1002, 0x6760, "3305M", "AMD/ATi Radeon 6760M" } ,
    { 0x1002, 0x6761, "AMD Radeon HD 6430M", "6430M" } ,
    { 0x1002, 0x6778, "7470", "AMD Radeon HD 7470" } ,
    { 0x1002, 0x6779, "AMD Radeon HD 6470m", "AMD Radeon HD 6470m" } ,
    { 0x1002, 0x677B, "Unknown", "Radeon HD 7450" } ,
    { 0x1002, 0x6798, "6798", "AMD Radeon 7970 Series" } ,
    { 0x1002, 0x6810, "R9 200", "Radeon R9 200 Series" } ,
    { 0x1002, 0x6819, "AMD Radeon HD 7800 Series", "PCI\\VEN_1002&DEV_6819&SUBSYS_32601682&REV_00" } ,
    { 0x1002, 0x6840, "SUBSY", "AMD Radeon HD 7600M Series" } ,
    { 0x1002, 0x6841, "subsys 1789103c", "AMD Radeon HD 7500M/7600M" } ,
    { 0x1002, 0x6898, "EG CYPRESS XT", "ATI Radeon HD 5800 Series" } ,
    { 0x1002, 0x6899, "EG CYPRESS PRO", "ATI Radeon HD 5800 Series" } ,
    { 0x1002, 0x689C, "EG Cypress XT HEMLOCK", "ATI Radeon HD 5970 Series" } ,
    { 0x1002, 0x68A0, "EG BROADWAY XT", "ATI Mobility Radeon HD 5800 Series" } ,
    { 0x1002, 0x68A1, "EG BROADWAY PRO/LP", "ATI Mobility Radeon HD 5800 Series" } ,
    { 0x1002, 0x68A8, "AMD Radeon HD6870M (at least the one from Dell)", "AMD Radeon HD6870M (at least the one from Dell)" } ,
    { 0x1002, 0x68B0, "EG BROADWAY XT", "ATI Mobility Radeon HD 5800 Series" } ,
    { 0x1002, 0x68B8, "EG JUNIPER XT", "ATI Radeon HD 5700 Series" } ,
    { 0x1002, 0x68BA, "1482174B", "ATI Radeon HD 6700 Series graphics card" } ,
    { 0x1002, 0x68BE, "EG JUNIPER LE", "ATI Radeon HD 5700 Series" } ,
    { 0x1002, 0x68C1, "DEV_68C1&SUBSYS_144A103C&REV_00", "ATI Mobility Radeon HD 5650M" } ,
    { 0x1002, 0x68C8, "RV830", "FirePro v4800" } ,
    { 0x1002, 0x68c9, "RV830", "FirePro 3D V3800" } ,
    { 0x1002, 0x68D8, "Redwood", "ATI Radeon HD 5670" } ,
    { 0x1002, 0x68D9, "RV830/Redwood", "HD 5570" } ,
    { 0x1002, 0x68E0, "HD 5470", "ATI Mobility Radeon HD 5470" } ,
    { 0x1002, 0x68E4, "RV810", "Ati Radeon HD 6370Mmobile" } ,
    { 0x1002, 0x68f9, "Cedar", "ATI Radeon HD 5450" } ,
    { 0x1002, 0x700F, "A3/U1", "PCI to AGP Bridge" } ,
    { 0x1002, 0x7010, "RS200", "PCI to AGP Bridge" } ,
    { 0x1002, 0x7100, "R520", "ATI RADEON X1800 Series" } ,
    { 0x1002, 0x7101, "M58", "ATI MOBILITY /ATI RADEON X1800 XT" } ,
    { 0x1002, 0x7102, "PCIE", "ATI MOBILITY /ATI RADEON X1800" } ,
    { 0x1002, 0x7103, "M58GL", "ATI MOBILITY FireGL V7200" } ,
    { 0x1002, 0x7104, "R520GL", "ATI FireGL V7200" } ,
    { 0x1002, 0x7105, "R520GL", "ATI FireGL V5300" } ,
    { 0x1002, 0x7106, "M58GL", "ATI MOBILITY FireGL V7100" } ,
    { 0x1002, 0x7108, "R520", "ATI RADEON X1800 Series" } ,
    { 0x1002, 0x7109, "R520", "ATI RADEON X1800 Series" } ,
    { 0x1002, 0x710A, "R520", "ATI RADEON X1800 Series" } ,
    { 0x1002, 0x710B, "R520", "ATI RADEON X1800 Series" } ,
    { 0x1002, 0x710C, "R520", "ATI RADEON X1800 Series" } ,
    { 0x1002, 0x710E, "R520GL", "ATI FireGL V7300" } ,
    { 0x1002, 0x710F, "R520GL", "ATI FireGL V7350" } ,
    { 0x1002, 0x7120, "R520", "ATI RADEON X1800 Series Secondary" } ,
    { 0x1002, 0x7124, "R520GL", "ATI FireGL V7200 Secondary" } ,
    { 0x1002, 0x7125, "R520GL", "ATI FireGL V5300 Secondary" } ,
    { 0x1002, 0x7128, "R520", "ATI RADEON X1800 Series Secondary" } ,
    { 0x1002, 0x7129, "R520", "ATI RADEON X1800 Series Secondary" } ,
    { 0x1002, 0x712A, "R520", "ATI RADEON X1800 Series Secondary" } ,
    { 0x1002, 0x712B, "R520", "ATI RADEON X1800 Series Secondary" } ,
    { 0x1002, 0x712C, "R520", "ATI RADEON X1800 Series Secondary" } ,
    { 0x1002, 0x712E, "R520GL", "ATI FireGL V7300 Secondary" } ,
    { 0x1002, 0x712F, "R520GL", "ATI FireGL V7350 Secondary" } ,
    { 0x1002, 0x7140, "RV515", "ATI RADEON X1600 Series" } ,
    { 0x1002, 0x7142, "RV515", "ATI RADEON X1300/X1550 Series" } ,
    { 0x1002, 0x7143, "RV515", "ATI RADEON X1300/ X1550 Series" } ,
    { 0x1002, 0x7145, "M54", "ATI MOBILITY /ATI RADEON X1400" } ,
    { 0x1002, 0x7146, "RV505", "ATI RADEON X1300 / X1550 Series" } ,
    { 0x1002, 0x7147, "RV515", "ATI RADEON X1550 64-bit" } ,
    { 0x1002, 0x7149, "M52", "ATI MOBILITY RADEON X1300" } ,
    { 0x1002, 0x714A, "M52", "ATI MOBILITY /ATI RADEON X1300" } ,
    { 0x1002, 0x714B, "M52", "ATI MOBILITY /ATI RADEON X1300" } ,
    { 0x1002, 0x714C, "M52", "ATI MOBILITY /ATI RADEON X1300" } ,
    { 0x1002, 0x714D, "RV515", "ATI RADEON X1300 Series" } ,
    { 0x1002, 0x714E, "RV515PCI", "ATI RADEON X1300 Series" } ,
    { 0x1002, 0x7152, "RV515GL", "ATI FireGL V3300" } ,
    { 0x1002, 0x7153, "RV515GL", "ATI FireGL V3350" } ,
    { 0x1002, 0x715E, "RV515", "ATI RADEON X1300 Series" } ,
    { 0x1002, 0x715F, "RV515", "ATI RADEON X1550 64-bit" } ,
    { 0x1002, 0x7160, "RV515", "ATI RADEON X1600 Series Secondary" } ,
    { 0x1002, 0x7162, "RV515", "ATI RADEON X1300/X1550 Series Secondary" } ,
    { 0x1002, 0x7163, "RV515", "ATI RADEON X1550 Series Secondary" } ,
    { 0x1002, 0x7166, "RV515", "ATI RADEON X1300 / X1550 Series Secondary" } ,
    { 0x1002, 0x7167, "RV515", "ATI RADEON X1550 64-bit Secondary" } ,
    { 0x1002, 0x716D, "RV515", "ATI RADEON X1300 Series Secondary" } ,
    { 0x1002, 0x716E, "RV515PCI", "ATI RADEON X1300 Series Secondary" } ,
    { 0x1002, 0x7172, "RV515GL", "ATI FireGL V3300 Secondary" } ,
    { 0x1002, 0x7173, "RV515GL", "ATI FireGL V3350 Secondary" } ,
    { 0x1002, 0x717E, "RV515", "ATI RADEON X1300 Series Secondary" } ,
    { 0x1002, 0x717F, "RV515", "ATI RADEON X1550 32-bit Secondary" } ,
    { 0x1002, 0x7180, "RV515", "ATI RADEON X1300/X1550 Series =x1400" } ,
    { 0x1002, 0x7181, "RV515", "ATI RADEON X1600 Series" } ,
    { 0x1002, 0x7183, "RV515", "ATI RADEON X1300/X1550 Series" } ,
    { 0x1002, 0x7186, "M54", "ATI MOBILITY /ATI RADEON X1450" } ,
    { 0x1002, 0x7187, "RV515", "ATI RADEON X1300/X1550 Series" } ,
    { 0x1002, 0x7188, "M64", "ATI MOBILITY /ATI RADEON X2300" } ,
    { 0x1002, 0x718A, "M54", "ATI MOBILITY /ATI RADEON X2300" } ,
    { 0x1002, 0x718B, "M52", "ATI MOBILITY /ATI RADEON X1350" } ,
    { 0x1002, 0x718C, "M52", "ATI MOBILITY /ATI RADEON X1350" } ,
    { 0x1002, 0x718D, "M54", "ATI MOBILITY /ATI RADEON X1450" } ,
    { 0x1002, 0x718F, "RV515PCI", "ATI RADEON X1300 Series" } ,
    { 0x1002, 0x7193, "RV515", "ATI RADEON X1550 Series" } ,
    { 0x1002, 0x7196, "M62", "ATI MOBILITY /ATI RADEON X1350" } ,
    { 0x1002, 0x719B, "RV515", "ATI FireMV 2250" } ,
    { 0x1002, 0x719F, "RV515", "ATI RADEON X1550 64-bit" } ,
    { 0x1002, 0x71A0, "RV515", "ATI RADEON X1300/X1550 Series Secondary" } ,
    { 0x1002, 0x71A1, "RV515", "ATI RADEON X1600 Series Secondary" } ,
    { 0x1002, 0x71A3, "RV515", "ATI RADEON X1300/X1550 Series Secondary" } ,
    { 0x1002, 0x71A7, "RV515", "ATI RADEON X1300/X1550 Series Secondary" } ,
    { 0x1002, 0x71AF, "RV515PCI", "ATI RADEON X1300 Series Secondary" } ,
    { 0x1002, 0x71B3, "RV515", "ATI RADEON X1550 Series Secondary" } ,
    { 0x1002, 0x71BB, "RV515", "ATI FireMV 2250 Secondary" } ,
    { 0x1002, 0x71C0, "RV530", "ATI RADEON X1600 Series" } ,
    { 0x1002, 0x71C1, "RV535", "ATI RADEON X1650 Series" } ,
    { 0x1002, 0x71c2, "RV530", "ATI RADEON X1600 Series" } ,
    { 0x1002, 0x71C3, "RV535", "ATI RADEON X1650 Series" } ,
    { 0x1002, 0x71C4, "M56GL", "ATI MOBILITY FireGL V5200" } ,
    { 0x1002, 0x71c5, "M56", "ATI MOBILITY / ATI RADEON X1600" } ,
    { 0x1002, 0x71C5, "M56", "ATI MOBILITY /ATI RADEON X1600" } ,
    { 0x1002, 0x71C6, "RV530", "ATI RADEON X1650 Series" } ,
    { 0x1002, 0x71C7, "RV535", "ATI RADEON X1650 Series" } ,
    { 0x1002, 0x71CD, "RV530", "ATI RADEON X1600 &#1057;&#1077;&#1088;&#1080;&#1080;" } ,
    { 0x1002, 0x71ce, "RV530", "ATI RADEON X1600 Pro / ATI RADEON X1300 XT" } ,
    { 0x1002, 0x71D2, "RV530GL", "ATI FireGL V3400" } ,
    { 0x1002, 0x71D4, "M56GL", "ATI MOBILITY FireGL V5250" } ,
    { 0x1002, 0x71D5, "M56", "ATI MOBILITY /ATI RADEON X1700" } ,
    { 0x1002, 0x71D6, "M56", "ATI MOBILITY /ATI RADEON X1700 XT" } ,
    { 0x1002, 0x71DA, "RV530GL", "ATI FireGL V5200" } ,
    { 0x1002, 0x71DE, "M56", "ATI MOBILITY /ATI RADEON X1700" } ,
    { 0x1002, 0x71E0, "RV530", "ATI RADEON X1600 Series Secondary" } ,
    { 0x1002, 0x71E1, "RV535", "ATI RADEON X1650 Series Secondary" } ,
    { 0x1002, 0x71e2, "RV530", "ATI RADEON X1600 Series Secondary" } ,
    { 0x1002, 0x71E3, "RV535", "ATI RADEON X1300 Series Secondary" } ,
    { 0x1002, 0x71E6, "RV530", "ATI RADEON X1600 Series Secondary" } ,
    { 0x1002, 0x71E7, "RV535", "ATI RADEON X1650 Series Secondary" } ,
    { 0x1002, 0x71ED, "RV530", "ATI RADEON X1600 Series Secondary" } ,
    { 0x1002, 0x71EE, "RV530", "ATI RADEON X1600 Pro / ATI RADEON X1300 XT Secondary" } ,
    { 0x1002, 0x71F2, "RV530GL", "ATI FireGL V3400 Secondary" } ,
    { 0x1002, 0x71FA, "RV530GL", "ATI FireGL V5200 Secondary" } ,
    { 0x1002, 0x7205, "1106", "S3G Unichrome IGP KM400/KN400" } ,
    { 0x1002, 0x7210, "M71", "ATI MOBILITY /ATI RADEON HD 2300" } ,
    { 0x1002, 0x7211, "M71", "ATI MOBILITY /ATI RADEON HD 2300" } ,
    { 0x1002, 0x7240, "R580", "ATI RADEON X1950 Series" } ,
    { 0x1002, 0x7243, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x7244, "R580", "ATI RADEON X1950 Series" } ,
    { 0x1002, 0x7245, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x7246, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x7247, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x7248, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x7249, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x724A, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x724B, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x724C, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x724D, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x724E, "R580", "ATI FireStream 2U" } ,
    { 0x1002, 0x724F, "R580", "ATI RADEON X1900 Series" } ,
    { 0x1002, 0x7260, "R580", "ATI RADEON X1950 Series Secondary" } ,
    { 0x1002, 0x7263, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x7264, "R580", "ATI RADEON X1950 Series Secondary" } ,
    { 0x1002, 0x7265, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x7266, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x7267, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x7268, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x7269, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x726A, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x726B, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x726C, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x726D, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x726E, "R580", "ATI FireStream 2U Secondary" } ,
    { 0x1002, 0x726F, "R580", "ATI RADEON X1900 Series Secondary" } ,
    { 0x1002, 0x7280, "R580", "ATI RADEON X1950 Series" } ,
    { 0x1002, 0x7284, "M58", "ATI MOBILITY /ATI RADEON X1900" } ,
    { 0x1002, 0x7286, "R580", "ATI RAEDON X1950 " } ,
    { 0x1002, 0x7288, "R580", "ATI RADEON X1950 GT" } ,
    { 0x1002, 0x7291, "R560", "ATI RADEON X1650 Series" } ,
    { 0x1002, 0x7293, "R580", "ATI RADEON X1650 Series" } ,
    { 0x1002, 0x72A0, "R580", "ATI RADEON X1950 Series Secondary" } ,
    { 0x1002, 0x72A8, "R580", "ATI RADEON X1950 GT Secondary" } ,
    { 0x1002, 0x72B1, "R580", "ATI RADEON X1650 Series Secondary" } ,
    { 0x1002, 0x72B3, "R580", "ATI RADEON X1650 Series Secondary" } ,
    { 0x1002, 0x7801, "7801", "SATA Controller" } ,
    { 0x1002, 0x7807, "7807", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x7808, "7808", "Standard Enhanced PCI to USB Host Controller" } ,
    { 0x1002, 0x7809, "7809", "Standard OpenHCD USB Host Controller" } ,
    { 0x1002, 0x780B, "780B", "SMBus" } ,
    { 0x1002, 0x780D, "780D", "HDMI Audio" } ,
    { 0x1002, 0x780E, "780E", "PCI standard ISA bridge" } ,
    { 0x1002, 0x780F, "780F", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1002, 0x7814, "7814", "AMD USB 3.0 Host Controller" } ,
    { 0x1002, 0x7833, "RS350", "Radeon 9100 Pro" } ,
    { 0x1002, 0x79, "unknown, 2200 mhz", "Campo	Valor Juego de instrucciones	x86, x86-64, MMX, 3DNow!, SSE, SSE2, SSE3" } ,
    { 0x1002, 0x791, "RS690M", "ATI Mobility Radeon x1200" } ,
    { 0x1002, 0x7910, "7910", "PCI standard host CPU bridge" } ,
    { 0x1002, 0x7912, "7912", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1002, 0x7914, "7914", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1002, 0x7915, "7915", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1002, 0x7916, "7916", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1002, 0x791a, "791A", "HDMI Audio" } ,
    { 0x1002, 0x791E, "RS690", "ATI RADEON X1200 Series" } ,
    { 0x1002, 0x791F, "RS690M", "ATI Radeon X1250" } ,
    { 0x1002, 0x7937, "Samsung R25P", "ATI Technoligies Inc" } ,
    { 0x1002, 0x793F, "RS600", "ATI RADEON Xpress 1200 Series" } ,
    { 0x1002, 0x7941, "RS690M", "ATI RADEON Xpress 1200 Series" } ,
    { 0x1002, 0x7942, "RS600M", "ATI RADEON Xpress 1250" } ,
    { 0x1002, 0x796E, "RS690", "ATI RADEON 2100" } ,
    { 0x1002, 0x8086, "1050", "PCI" } ,
    { 0x1002, 0x9000, "RV350", "ATI Radeon 9600" } ,
    { 0x1002, 0x9094, "RV730", "ATI Radeon HD 4600 Series" } ,
    { 0x1002, 0x9400, "R600", "ATI Radeon HD 2900 XT" } ,
    { 0x1002, 0x9401, "R600", "ATI RADEON HD 2900 XT" } ,
    { 0x1002, 0x9402, "R600", "ATI RADEON HD 2900 XT" } ,
    { 0x1002, 0x9403, "R600", "ATI RADEON HD 2900 PRO" } ,
    { 0x1002, 0x9405, "R600", "ATI RADEON HD 2900 GT" } ,
    { 0x1002, 0x940A, "R600GL", "ATI FireGL V8650" } ,
    { 0x1002, 0x940B, "R600GL", "ATI FireGL V8600" } ,
    { 0x1002, 0x940F, "R600GL", "ATI FireGL V7600" } ,
    { 0x1002, 0x9440, "RV770", "ATI Radeon HD 4870" } ,
    { 0x1002, 0x9441, "R700", "ATI Radeon HD 4870 X2" } ,
    { 0x1002, 0x9442, "RV770", "ATI Radeon HD 4800 Series" } ,
    { 0x1002, 0x9443, "R700", "ATI Radeon HD 4850 X2" } ,
    { 0x1002, 0x9444, "RV770", "ATI FirePro V8750 (FireGL)" } ,
    { 0x1002, 0x9446, "RV770", "ATI FirePro V7770 (FireGL)" } ,
    { 0x1002, 0x9447, "R700", "ATI FirePro V8700 Duo (FireGL)" } ,
    { 0x1002, 0x944A, "M98", "ATI Mobility Radeon HD 4850" } ,
    { 0x1002, 0x944B, "M98", "ATI Mobility Radeon HD 4850 X2" } ,
    { 0x1002, 0x944C, "RV770", "ATI Radeon HD 4800 Series" } ,
    { 0x1002, 0x944E, "RV770", "ATI Radeon HD 4700 Series" } ,
    { 0x1002, 0x9450, "RV770", "AMD FireStream 9270" } ,
    { 0x1002, 0x9452, "RV770", "AMD FireStream 9250" } ,
    { 0x1002, 0x9456, "RV770", "ATI FirePro V8700 (FireGL)" } ,
    { 0x1002, 0x945A, "M98", "ATI Mobility Radeon HD 4870" } ,
    { 0x1002, 0x9460, "RV790", "ATI Radeon HD 4800 Series" } ,
    { 0x1002, 0x9462, "RV790", "ATI Mobility Radeon HD 5650" } ,
    { 0x1002, 0x9480, "M96", "ATI Mobility Radeon HD 4650" } ,
    { 0x1002, 0x9487, "RV730", "ATI Radeon Graphics Processor" } ,
    { 0x1002, 0x9488, "M96", "ATI Mobility Radeon HD 4670" } ,
    { 0x1002, 0x948F, "RV730", "ATI Radeon Graphics Processor" } ,
    { 0x1002, 0x9490, "RV730", "ATI Radeon HD 4600 Series" } ,
    { 0x1002, 0x9491, "M96", "ATI Radeon E4600" } ,
    { 0x1002, 0x9495, "RV730", "ATI RADEON HD4650" } ,
    { 0x1002, 0x9498, "RV730", "ATI Radeon HD 4600" } ,
    { 0x1002, 0x949C, "RV730", "ATI FirePro V7750 (FireGL)" } ,
    { 0x1002, 0x949E, "RV730", "ATI FirePro V5700 (FireGL)" } ,
    { 0x1002, 0x949F, "RV730", "ATI FirePro V3750 (FireGL)" } ,
    { 0x1002, 0x94A0, "M97", "ATI Mobility Radeon HD 4830" } ,
    { 0x1002, 0x94A1, "M97", "ATI Mobility Radeon HD 4860" } ,
    { 0x1002, 0x94A3, "M97", "ATI FirePro M7740" } ,
    { 0x1002, 0x94B1, "RV740", "ATI Radeon Graphics Processor" } ,
    { 0x1002, 0x94B3, "RV740", "ATI Radeon HD 4770" } ,
    { 0x1002, 0x94B4, "RV740", "ATI Radeon HD 4700 Series" } ,
    { 0x1002, 0x94B5, "AA38", "ATI Radeon HD 4650" } ,
    { 0x1002, 0x94C1, "RV610-DT (Pro)", "ATI Radeon HD 2400 XT" } ,
    { 0x1002, 0x94C3, "RV610", "ATI Radeon HD 2400 PRO PCI-E" } ,
    { 0x1002, 0x94C4, "RV610LE", "ATI Radeon HD 2400 PRO AGP" } ,
    { 0x1002, 0x94C5, "RV610", "ATI RADEON HD 2400 LE" } ,
    { 0x1002, 0x94C7, "RV610", "ATI RADEON HD 2350" } ,
    { 0x1002, 0x94C8, "M72", "ATI MOBILITY /ATI RADEON HD 2400 XT" } ,
    { 0x1002, 0x94C9, "M72", "ATI MOBILITY /ATI RADEON HD 2400" } ,
    { 0x1002, 0x94CB, "M72", "ATI RADEON E2400" } ,
    { 0x1002, 0x94CC, "RV610", "ATI RADEON HD 2400" } ,
    { 0x1002, 0x9501, "RV670 XT", "ATI Radeon HD 3870" } ,
    { 0x1002, 0x9504, "M76", "ATI MOBILITY /ATI RADEON HD 3850" } ,
    { 0x1002, 0x9505, "RV630", "ATI RADEON HD 3850" } ,
    { 0x1002, 0x9506, "M76", "ATI MOBILITY /ATI RADEON HD 3850 X2" } ,
    { 0x1002, 0x9507, "RV670", "ATI Radeon HD 3830" } ,
    { 0x1002, 0x9508, "M76", "ATI MOBILITY /ATI RADEON HD 3870" } ,
    { 0x1002, 0x9509, "M76", "ATI MOBILITY /ATI RADEON HD 3870 X2" } ,
    { 0x1002, 0x950F, "R680", "ATI RADEON HD 3870 X2" } ,
    { 0x1002, 0x9511, "RV630GL", "ATI FireGL V7700" } ,
    { 0x1002, 0x9513, "R680", "ATI Radeon HD 3850 X2" } ,
    { 0x1002, 0x9515, "RV670 AGP", "ATI Radeon HD 3850 AGP" } ,
    { 0x1002, 0x9519, "RV670", "AMD FireStream 9170" } ,
    { 0x1002, 0x9540, "RV710", "ATI Radeon HD 4550" } ,
    { 0x1002, 0x9541, "RV710", "ATI Radeon Graphics Processor" } ,
    { 0x1002, 0x954E, "RV710", "ATI Radeon Graphics Processor" } ,
    { 0x1002, 0x954F, "RV710", "ATI Radeon HD 4350" } ,
    { 0x1002, 0x9552, "M92", "ATI Mobility Radeon HD 4330 Серии" } ,
    { 0x1002, 0x9553, "M92", "ATI Mobility Radeon HD 5145" } ,
    { 0x1002, 0x9555, "M93", "ATI Mobility Radeon HD 4500 Series" } ,
    { 0x1002, 0x9557, "M93", "ATI FirePro RG220" } ,
    { 0x1002, 0x9581, "M76M", "ATI Mobility Radeon HD 2600" } ,
    { 0x1002, 0x9583, "M76", "ATI MOBILITY /ATI RADEON HD 2600 XT" } ,
    { 0x1002, 0x9586, "RV630", "ATI RADEON HD 2600 XT AGP" } ,
    { 0x1002, 0x9587, "RV630 PRO", "ATI Radeon HD 2600 Pro AGP" } ,
    { 0x1002, 0x9588, "RV630 XT", "ATI Radeon HD 2600 XT" } ,
    { 0x1002, 0x9589, "&#1055;&#1056;&#1054; RV630", "ATI Radeon HD 2600 Pro" } ,
    { 0x1002, 0x958B, "M76", "ATI MOBILITY / ATI RADEON HD 2600 XT Gemini" } ,
    { 0x1002, 0x958C, "RV630GL", "ATI FireGL V5600" } ,
    { 0x1002, 0x958D, "RV630GL", "ATI FireGL V3600" } ,
    { 0x1002, 0x958E, "RV630", "ATI RADEON HD 2600 LE" } ,
    { 0x1002, 0x958F, "M76", "ATI Mobility FireGL Graphics Processor" } ,
    { 0x1002, 0x9590, "RV630", "ATI RADEON HD 3650 Serieshttp://www.pcidatabase.com/update_device.php?__ec_i=ec.1307313611.e071ed73c" } ,
    { 0x1002, 0x9591, "M86-M", "ATI Mobility Radeon HD 3650" } ,
    { 0x1002, 0x9593, "M86", "ATI Mobility Radeon HD 3670" } ,
    { 0x1002, 0x9595, "M86", "ATI Mobility FireGL V5700" } ,
    { 0x1002, 0x9596, "RV630", "ATI RADEON HD 3600 Series" } ,
    { 0x1002, 0x9597, "RV630", "ATI RADEON HD 3600 Series" } ,
    { 0x1002, 0x9598, "RV630", "ATI Radeon HD 3600 Series " } ,
    { 0x1002, 0x9599, "RV630", "ATI RADEON HD 3600 Series" } ,
    { 0x1002, 0x959B, "M86", "ATI Mobility FireGL Graphics Processor" } ,
    { 0x1002, 0x95C0, "RV610", "ATI RADEON HD 3470" } ,
    { 0x1002, 0x95C2, "M72", "ATI MOBILITY /ATI RADEON HD 3430" } ,
    { 0x1002, 0x95c4, "M82-S", "ATI Mobility Radeon HD 3450" } ,
    { 0x1002, 0x95C5, "RV620 LE", "ATI Radeon HD 3450" } ,
    { 0x1002, 0x95C6, "RV620", "ATI Radeon HD 3450" } ,
    { 0x1002, 0x95C7, "RV610", "ATI RADEON HD 3430" } ,
    { 0x1002, 0x95C9, "RV620", "ATI Radeon HD 3450" } ,
    { 0x1002, 0x95CC, "RV620", "ATI FirePRO V3700" } ,
    { 0x1002, 0x95CD, "RV610", "ATI FireMV 2450" } ,
    { 0x1002, 0x95CE, "RV610", "ATI FireMV 2260" } ,
    { 0x1002, 0x95CF, "RV610", "ATI FireMV 2260" } ,
    { 0x1002, 0x9610, "RS780", "ATI Radeon HD 3200 Graphics" } ,
    { 0x1002, 0x9611, "RS780", "ATI RADEON 3100 Graphics" } ,
    { 0x1002, 0x9612, "RS780M", "ATI RADEON HD 3200 Graphics" } ,
    { 0x1002, 0x9613, "RS780M", "ATI RADEON 3100 Graphics" } ,
    { 0x1002, 0x9614, "RS780", "ATI RADEON HD 3300 Graphics" } ,
    { 0x1002, 0x9615, "RS780", "AMD 780E" } ,
    { 0x1002, 0x9616, "RS780", "AMD 760G" } ,
    { 0x1002, 0x9644, "A4-3420", "AMD Radeon� HD 6410D" } ,
    { 0x1002, 0x9647, "AMD A6-3410MX APU With AMD Radeon HD 6520G", "&#1089;&#1090;&#1072;&#1085;&#1076;&#1072;&#1088;&#1090;&#1085;&#1099;&#1081; vga &#1075;&#1088;&#10" } ,
    { 0x1002, 0x9648, " 9648", "AMD Radeon(TM) HD 6480G" } ,
    { 0x1002, 0x9649, "HD 6480G", "AMD Radeon(TM) HD 6480G" } ,
    { 0x1002, 0x970F, "970F", "High Definition Audio Controller" } ,
    { 0x1002, 0x9710, "RS880", "ATI Radeon HD 4200" } ,
    { 0x1002, 0x9711, "RS880", "ATI Radeon 4100" } ,
    { 0x1002, 0x9712, "4250", "ATI Mobility Radeon HD 4200 Series (ATI Mobility Radeon HD 4250)" } ,
    { 0x1002, 0x9713, "RS880MC", "ATI Mobility Radeon 4100" } ,
    { 0x1002, 0x9715, "RS880", "ATI Radeon HD 4250 Graphics" } ,
    { 0x1002, 0x9802, "AMD E-350", "AMD Radeon HD 6310 series" } ,
    { 0x1002, 0x9803, "2411E6FE", "Display driver http://support1.toshiba-tro.de/tedd-files2/0/display-20110404110958.zip" } ,
    { 0x1002, 0x9804, "AMD Radeon HD 6310 Graphics  AMD Radeon HD 6310 Gr", "AMD Radeon HD 6310 Graphics" } ,
    { 0x1002, 0x9806, "AMD Radeon HD 6320", "E-450 APU" } ,
    { 0x1002, 0x9807, "unknow", "amd radeon hd 6290 graphic" } ,
    { 0x1002, 0x9808, "E2-1800", "E-Series APU (E2-1800, maybe more)" } ,
    { 0x1002, 0x9809, "7310M", "ATI Radeon 7310M" } ,
    { 0x1002, 0x9834, "AMD Radeon HD 8210", "PCI\\VEN_1002&DEV_9834&SUBSYS_380217AA&REV_00" } ,
    { 0x1002, 0x9851, "3801", "AMD Radeon(TM) R4 Graphics" } ,
    { 0x1002, 0x9876, "ATI GTC (GT-C2U2)", "ATI 3D Rage Pro AGP 2X" } ,
    { 0x1002, 0x9902, "9902", "HDMI Audio" } ,
    { 0x1002, 0x9998, "9998", "Radeon HD 8370D" } ,
    { 0x1002, 0x9999, "(0x9498", "ATI Radeon HD 4600" } ,
    { 0x1002, 0x999C, "999C", "Radeon HD 8550D" } ,
    { 0x1002, 0xAA01, "Ati Function driver for high definition audio1", "Ati Mobility Radeon HD HDMI Audio realtek" } ,
    { 0x1002, 0xAA08, "All with HDMI support", "High Definition Audio Device" } ,
    { 0x1002, 0xAA10, "677", "HDMI Audio Support" } ,
    { 0x1002, 0xAA20, "RV630", "ATI Radeon HD 3600 Series" } ,
    { 0x1002, 0xAA28, "3400", "Radeon HD 3400 Series" } ,
    { 0x1002, 0xAA58, "AA58", "High Definition Audio Controller" } ,
    { 0x1002, 0xaa68, " 0x040300", " 0x00" } ,
    { 0x1002, 0xAC12, "Theater HD T507", "(DVB-T) TV tuner/capture device" } ,
    { 0x1002, 0xCAB0, "A3/U1", "S2K CPU to PCI Bridge" } ,
    { 0x1002, 0xCAB1, "A3/U1", "Slot1 CPU to PCI Bridge" } ,
    { 0x1002, 0xcab2, "RS200", "CPU to PCI Bridge" } ,
    { 0x1002, 0xCBB2, "RS200", "CPU to PCI Bridge" } ,
    { 0x1002, 0x0876, "", "" } ,
    { 0x1002, 0x7800, "", "" } ,
    { 0x1003, 0x0201, "0x0201", "GUI Accelerator" } ,
    { 0x1004, 0x0005, "PCI\\VEN_13F0", "DEV_0200" } ,
    { 0x1004, 0x0006, "82C593", "ISA Bridge" } ,
    { 0x1004, 0x0007, "82C594", "Wildcat System Controller" } ,
    { 0x1004, 0x0008, "82C596/597", "Wildcat ISA Bridge" } ,
    { 0x1004, 0x0009, "82C597-AFC2", "" } ,
    { 0x1004, 0x000C, "82C541", "" } ,
    { 0x1004, 0x000D, "82C543", "" } ,
    { 0x1004, 0x0100, "dtdftdfz", "CPU to PCI Bridge for notebook" } ,
    { 0x1004, 0x0101, "82C532", "Peripheral Controller" } ,
    { 0x1004, 0x0102, "82C534", "PCI to PCI Bridge" } ,
    { 0x1004, 0x0103, "82C538", "PCI to ISA Bridge" } ,
    { 0x1004, 0x0104, "82C535", "Host Bridge" } ,
    { 0x1004, 0x0105, "82C147", "IrDA Controller" } ,
    { 0x1004, 0x0200, "82C975", "RISC GUI Accelerator" } ,
    { 0x1004, 0x0280, "82C925", "RISC GUI Accelerator" } ,
    { 0x1004, 0x0304, "SAA7785", "ThunderBird PCI Audio Accelerator" } ,
    { 0x1004, 0x0305, "SAA7785", "ThunderBird joystick port" } ,
    { 0x1004, 0x0306, "SAA7785", "ThunderBird 16650 UART" } ,
    { 0x1004, 0x0307, "KTX0208X", "Philips Seismic Edge 705" } ,
    { 0x1004, 0x0308, "1", "Philips PSC705 GamePort Enumerator" } ,
    { 0x1004, 0x0702, "VAS96011", "Golden Gate II" } ,
    { 0x1006, 0x3044, "n/a 1", "OHCI Compliant IEEE 1394 Host Controller" } ,
    { 0x1008, 0x9876, "23", "23" } ,
    { 0x100A, 0x8235, "VIA 82C3128", "U87088R06" } ,
    { 0x100B, 0x0001, "DP83810", "10/100 Ethernet MAC" } ,
    { 0x100B, 0x0002, "PC87415", "PCI-IDE DMA Master Mode Interface Ctrlr" } ,
    { 0x100B, 0x000E, "PC87560", "Legacy I/O Controller" } ,
    { 0x100B, 0x000F, "CS4210", "IEEE 1394 OHCI Controller" } ,
    { 0x100B, 0x0011, "PC87560", "PCI System I/O" } ,
    { 0x100B, 0x0012, "", "USB Controller" } ,
    { 0x100B, 0x001B, "LM4560", "Advanced PCI Audio Accelerator" } ,
    { 0x100B, 0x0020, "DP83815", "MacPhyter 10/100 Mb/s Ethernet MAC & PHY" } ,
    { 0x100B, 0x0020, "DP83815", "10/100 MacPhyter3v PCI Adapter" } ,
    { 0x100B, 0x0021, "PC82440", "PCI to ISA Bridge" } ,
    { 0x100B, 0x0022, "DP83820/1", "10/100/1000 Mb/s PCI Ethernet NIC" } ,
    { 0x100B, 0x0028, "Geode GX2", "PCI Host Bridge" } ,
    { 0x100B, 0x002A, "CS5535", "GeodeLink PCI South Bridge" } ,
    { 0x100B, 0x002D, "5535", "Geode IDE Controller" } ,
    { 0x100B, 0x002E, "Castle ()", "GEODE - GX3 Audio CS5535" } ,
    { 0x100B, 0x002F, "Geode", "USB Controller" } ,
    { 0x100B, 0x0030, "NSC", "Geode VGA Compatible Device" } ,
    { 0x100B, 0x0500, "SCx200", "LPC Bridge and GPIO" } ,
    { 0x100B, 0x0501, "SCx200", "SMI Status and ACPI" } ,
    { 0x100B, 0x0502, "SC1100/SCx200", "IDE Controller" } ,
    { 0x100B, 0x0503, "SC1100/SCx200", "XpressAUDIO" } ,
    { 0x100B, 0x0504, "SCx200", "Video Processor" } ,
    { 0x100B, 0x0505, "SCx200", "X-Bus Expansion Interface" } ,
    { 0x100B, 0x0510, "SC1100", "LPC Bridge and GPIO" } ,
    { 0x100B, 0x0511, "SC1100", "SMI Status and ACPI" } ,
    { 0x100B, 0x0515, "SC1100", "X-Bus Expansion Interface" } ,
    { 0x100B, 0x23, "", "" } ,
    { 0x100B, 0xD001, "M2764AFI", "PCI-IDE Interface" } ,
    { 0x100C, 0x3202, "ET4000W32P-A", "GUI Accelerator" } ,
    { 0x100C, 0x3205, "ET4000W32P-B", "GUI Accelerator" } ,
    { 0x100C, 0x3206, "ET4000W32P-C", "GUI Accelerator" } ,
    { 0x100C, 0x3207, "54005443", "GUI Accelerator" } ,
    { 0x100C, 0x3208, "ET6000", "Graphics/Multimedia Engine" } ,
    { 0x100C, 0x4702, "ET6300", "" } ,
    { 0x166D, 0x0001, "BCM1125/BCM1250 PCI Configuration Header", "" } ,
    { 0x166D, 0x0002, "BCM1125/BCM1250 HyperTransport Configuration Heade", "MIPS BCM1125/BCM1250 processors" } ,
    { 0x100E, 0x0564, "STPC Client", "Host Bridge" } ,
    { 0x100E, 0x55CC, "STPC Client", "South Bridge" } ,
    { 0x100E, 0x9000, "P9000", "WeitekPower GUI Accelerator" } ,
    { 0x100E, 0x9001, "P9000", "GUI Accelerator" } ,
    { 0x100E, 0x9100, "P9100", "GUI Accelerator" } ,
    { 0x1011, 0x0001, "DC21050", "PCI-PCI Bridge" } ,
    { 0x1011, 0x0002, "DC21040", "Tulip Ethernet Adapter" } ,
    { 0x1011, 0x0004, "DC21030", "PCI Graphics Accelerator" } ,
    { 0x1011, 0x0007, "Zephyr", "NV-RAM" } ,
    { 0x1011, 0x0008, "KZPSA", "SCSI to SCSI Adapter" } ,
    { 0x1011, 0x0009, "DC21140", "Fast Ethernet Ctrlr" } ,
    { 0x1011, 0x000A, "DC21230", "Video Codec" } ,
    { 0x1011, 0x000C, "1011", "6IfPpL  <a href=" } ,
    { 0x1011, 0x000D, "TGA2", "TGA2 PDXGB" } ,
    { 0x1011, 0x000F, "DEFPA", "FDDI" } ,
    { 0x1011, 0x0014, "DC21041", "Tulip Plus Ethernet Adapter" } ,
    { 0x1011, 0x0016, "DGLPB", "ATM" } ,
    { 0x1011, 0x0019, "DC21142/3", "Olicom RapidFire 2327 Fast Ethernet Adapter" } ,
    { 0x1011, 0x0021, "21052[-AB]", "PCI-PCI Bridge" } ,
    { 0x1011, 0x0022, "DC21150-AA", "PCI-PCI Bridge" } ,
    { 0x1011, 0x0023, "DC21150", "PCI to PCI Bridge" } ,
    { 0x1011, 0x0024, "DC21151/2", "PCI-PCI Bridge" } ,
    { 0x1011, 0x0025, "21153", "PCI-PCI Bridge" } ,
    { 0x1011, 0x0026, "21154", "PCI-PCI Bridge" } ,
    { 0x1011, 0x0034, "Modem56", "CardBus" } ,
    { 0x1011, 0x0045, "DC21553", "PCI to PCI Bridge" } ,
    { 0x1011, 0x0046, "21554", "PCI-to-PCI Bridge" } ,
    { 0x1011, 0x1011, "DC21050", "PCI-PCI Bridge" } ,
    { 0x1011, 0x1065, "DAC960", "Mylex DAC1164P Disk Array Controller" } ,
    { 0x1011, 0x2000, "3X-KPCON-AA", "Fault Mgr (3.3v/5v Universal PCI)" } ,
    { 0x1013, 0x0038, "FW82371EB", "pci" } ,
    { 0x1013, 0x0040, "CL-GD7555", "Flat Panel GUI Accelerator" } ,
    { 0x1013, 0x004C, "CL-GD7556", "64-bit Accelerated LCD/CRT Controller" } ,
    { 0x1013, 0x00A0, "CL-GD5440", "GUI Accelerator" } ,
    { 0x1013, 0x00A2, "CL-GD5432", "Alpine GUI Accelerator" } ,
    { 0x1013, 0x00A4, "CL-GD5434", "Alpine GUI Accelerator" } ,
    { 0x1013, 0x00A8, "CL-GD5434", "Alpine GUI Accelerator" } ,
    { 0x1013, 0x00AC, "CL-GD5426", "Video card (i guess?)" } ,
    { 0x1013, 0x00B8, "CL-GD5446", "64-bit VisualMedia Accelerator" } ,
    { 0x1013, 0x00BC, "CL-GD5480", "64-bit SGRAM GUI accelerator" } ,
    { 0x1013, 0x00D0, "CL-GD5462", "Laguna VisualMedia graphics accelerator" } ,
    { 0x1013, 0x00D4, "CL-GD5455", "Laguna 3D VisualMedia Graphics Accel" } ,
    { 0x1013, 0x00D5, "CL-GD5464", "Laguna BD" } ,
    { 0x1013, 0x00D6, "CL-GD5465", "Laguna 3D VisualMedia Graphics Accel" } ,
    { 0x1013, 0x00E8, "CL-GD5436U", "" } ,
    { 0x1013, 0x1013, "cs4630cm", "accelerator do audio do pci de sound fusion" } ,
    { 0x1013, 0x1100, "CL-PD6729", "PCI-to-PC Card host adapter" } ,
    { 0x1013, 0x1110, "CL-PD6832", "PCMCIA/CardBus Controller" } ,
    { 0x1013, 0x1112, "CL-PD6834", "PCMCIA/CardBus Controller" } ,
    { 0x1013, 0x1113, "CL-PD6833", "PCI-to-CardBus Host Adapter" } ,
    { 0x1013, 0x1200, "CL-GD7542", "Nordic GUI Accelerator" } ,
    { 0x1013, 0x1202, "GD7543", "Viking GUI Accelerator" } ,
    { 0x1013, 0x1204, "CL-GD7541", "Nordic-lite VGA Cntrlr" } ,
    { 0x1013, 0x4000, "1085", "Ambient CLM Data Fax Voice" } ,
    { 0x1013, 0x4400, "CL-CD4400", "Communications Controller" } ,
    { 0x1013, 0x6001, "CS4610/4611", "CrystalClear SoundFusion PCI Audio Accelerator" } ,
    { 0x1013, 0x6003, "CS4630-CM", "Crystal Sound Fusion a" } ,
    { 0x1013, 0x6004, "CS464", "CrystalClear SoundFusion PCI Audio Accel" } ,
    { 0x1013, 0x6005, "CS4010", "Crystal Soundfusion(tm) CS 40210" } ,
    { 0x1013, 0x9876, "cirrus logic crystal CS 4614", "SoundFusion PCI Audio Accelerator" } ,
    { 0x1014, 0x0002, "MCA Bridge", "MCA Bridge" } ,
    { 0x1014, 0x0005, "Alta Lite", "CPU Bridge" } ,
    { 0x1014, 0x0007, "Alta MP", "CPU Bridge" } ,
    { 0x1014, 0x000A, "Fire Coral", "ISA Bridge w/PnP" } ,
    { 0x1014, 0x0017, "", "CPU to PCI Bridge" } ,
    { 0x1014, 0x0018, "Auto LANStreamer", "TR Auto LANStreamer" } ,
    { 0x1014, 0x001B, "GXT-150P", "Graphics Adapter" } ,
    { 0x1014, 0x001D, "82G2675", "scsi-2 fast pci adapter" } ,
    { 0x1014, 0x0020, "82351/2", "MCA Bridge" } ,
    { 0x1014, 0x0022, "82351/2", "PCI to PCI Bridge " } ,
    { 0x1014, 0x002D, "Python", "" } ,
    { 0x1014, 0x002E, "ServeRAID I/II/3x/4H", "Coppertime RAID SCSI Adapter" } ,
    { 0x1014, 0x0036, "Miami/PCI", "32-bit LocalBus Bridge" } ,
    { 0x1014, 0x0037, "IBM27-82660", "PowerPC to PCI Bridge and Memory Ctrlr" } ,
    { 0x1014, 0x003A, "", "CPU to PCI Bridge" } ,
    { 0x1014, 0x003E, "85H9533", "IBM Token Ring PCI" } ,
    { 0x1014, 0x0045, "", "SSA Adapter" } ,
    { 0x1014, 0x0046, "MPIC", "Interrupt Controller" } ,
    { 0x1014, 0x0047, "", "PCI to PCI Bridge" } ,
    { 0x1014, 0x0048, "00003720", "PCI to PCI Bridge" } ,
    { 0x1014, 0x0049, "", "Warhead SCSI Controller" } ,
    { 0x1014, 0x004D, "IBM 3780IDSP", "MPEG-2 Decoder" } ,
    { 0x1014, 0x004E, "", "ATM Controller" } ,
    { 0x1014, 0x004F, "", "ATM Controller" } ,
    { 0x1014, 0x0050, "", "ATM Controller" } ,
    { 0x1014, 0x0053, "85h9533", "25 MBit ATM controller" } ,
    { 0x1014, 0x0057, "85g1897", "MPEG PCI Bridge" } ,
    { 0x1014, 0x005C, "i82557B", "10/100 PCI Ethernet Adapter" } ,
    { 0x1014, 0x005D, "05J3506", "TCP/IP networking device" } ,
    { 0x1014, 0x007C, "", "ATM Controller" } ,
    { 0x1014, 0x007D, "3780IDSP", "MPEG-2 Decoder" } ,
    { 0x1014, 0x0090, "GXT-3000P", "" } ,
    { 0x1014, 0x0095, "20H2999", "PCI Docking Bridge" } ,
    { 0x1014, 0x0096, "", "Chukar chipset SCSI Controller" } ,
    { 0x1014, 0x00A1, "PowerNP NPr2.7", "ATM support device" } ,
    { 0x1014, 0x00A5, "", "ATM Controller" } ,
    { 0x1014, 0x00A6, "", "ATM 155Mbps MM Controller" } ,
    { 0x1014, 0x00B7, "GXT2000", "256-bit Graphics Rasterizer" } ,
    { 0x1014, 0x00BE, "", "ATM 622Mbps Controller" } ,
    { 0x1014, 0x00CE, "02li537", "Adapter 2 Token Ring Card" } ,
    { 0x1014, 0x00F9, "CPC700", "Memory Controller and PCI Bridge" } ,
    { 0x1014, 0x00FC, "CPC710", "PCI-64 Bridge" } ,
    { 0x1014, 0x0105, "CPC710", "PCI-32 Bridge" } ,
    { 0x1014, 0x010F, "0680", "Remote Supervisor+Serial Port+Mouse/Keyb" } ,
    { 0x1014, 0x011B, "cbeh3w", "Raid controller" } ,
    { 0x1014, 0x0142, "Yotta", "Video Compositor Input" } ,
    { 0x1014, 0x0144, "Yotta", "Video Compositor Output" } ,
    { 0x1014, 0x0153, "", "" } ,
    { 0x1014, 0x0156, "405GP", "PLB to PCI Bridge" } ,
    { 0x1014, 0x0170, "RC1000", "Rasterizer/IBM GT1000 Geometr" } ,
    { 0x1014, 0x0188, "x", "PCI Bridge" } ,
    { 0x1014, 0x01a2, "82801", "Modem: Intel Corporation 82440MX AC'97 Modem Controller (prog-if 00 [Generic])" } ,
    { 0x1014, 0x01A7, "IBM 133", "PCI-X Bridge R1.1" } ,
    { 0x1014, 0x01BD, "ServeRAID 4/5", "Morpheus SCSI RAID Controller" } ,
    { 0x1014, 0x01ef, "440GP", "PLB to PCI-X Bridge" } ,
    { 0x1014, 0x01ff, "FC 4962 CCIN 4962 FRU 09P5023", "10/100 Mbps Ethernet PCI Adapter II" } ,
    { 0x1014, 0x0246, "", "" } ,
    { 0x1014, 0x027F, "440GX", "Embedded PowerPC CPU" } ,
    { 0x1014, 0x0289, "8086", "0890" } ,
    { 0x1014, 0x028c, "112", "SCSI Storage Controller" } ,
    { 0x1014, 0x0295, "NECSCE 11508082", "IBM SurePOS Riser Card Function 0" } ,
    { 0x1014, 0x0297, "NECSCE 11508082", "IBM SurePOS Riser Card Function 1 (UARTs)" } ,
    { 0x1014, 0x02A1, " ", "Calgary PCI-X Host Bridge" } ,
    { 0x1014, 0x0302, "b8331462", "PCI-X Host Bridge" } ,
    { 0x1014, 0x0308, "1", "IBM CalIOC2 (Calgary on PCI-E)" } ,
    { 0x1014, 0x0339, "n/a", "n/a" } ,
    { 0x1014, 0x10e5, "41U0441 / 41U0442", "IBM 4764-001 PCI-X Cryptographic Coprocessor (1410e501)" } ,
    { 0x1014, 0xFFFF, "MPIC 2", "Interrupt Controller" } ,
    { 0x1014, 0x37C0, "Unknown", "IBM Netfinity Advanced System Management Processor" } ,
    { 0x1014, 0x37D0, "n/a", "n/a" } ,
    { 0x1017, 0x5343, "v7-mpeg modul", "SPEA 3D Accelerator" } ,
    { 0x1018, 0x3330, "544469821", "5444469821" } ,
    { 0x1019, 0x1B10, "sis-648D", "VIA chipset" } ,
    { 0x1019, 0x9876, "5.03.2600.2180 32bit Unicode", "Intel(R) Celeron(R) CPU 2.80GHz" } ,
    { 0x101A, 0x0005, "8156", "100VG/AnyLAN Adapter" } ,
    { 0x101A, 0x0009, "Altera FLEX", "PCI-X dual port  " } ,
    { 0x101E, 0x9010, "MegaRAID 428", "Ultra Wide SCSI RAID Controller2" } ,
    { 0x101E, 0x9030, "", "EIDE Controller" } ,
    { 0x101E, 0x9031, "", "EIDE Controller" } ,
    { 0x101E, 0x9032, "", "IDE and SCSI Cntrlr" } ,
    { 0x101E, 0x9033, "I960", "SCSI Controller" } ,
    { 0x101E, 0x9040, "amd sempron(tm)2200+", "Multimedia card" } ,
    { 0x101E, 0x9060, "MegaRAID 434", "Ultra GT RAID Controller" } ,
    { 0x101E, 0x9063, "MegaRAC 780", "Remote Assistant" } ,
    { 0x101E, 0x9095, "9095", "SGPIO/SES/IPMI Initiator" } ,
    { 0x1022, 0x1100, "Athlon 64 / Opteron", "HyperTransport Technology Configuration" } ,
    { 0x1022, 0x1101, "Athlon 64 / Opteron", "Address Map" } ,
    { 0x1022, 0x1102, "Athlon 64 / Opteron", "AMD Hammer - DRAM Controller " } ,
    { 0x1022, 0x1103, "Athlon 64 / Opteron", "AMD Hammer - Miscellaneous Control " } ,
    { 0x1022, 0x1200, "1200", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1201, "1201", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1203, "1203", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1204, "1204", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1419, "PCI\\VEN_1022&DEV_1419&SUBSYS_14191022&REV_00", "AMD Input/Outpu Memory Management Unit" } ,
    { 0x1022, 0x1510, "1510", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1513, "1513", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x1514, "1514", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x1515, "1515", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x1700, "1700", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1701, "1701", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1702, "1702", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1703, "1703", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1704, "1704", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1716, "1716", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1718, "1718", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x1719, "1719", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x2000, "Am79C970/1/2/3/5/6", "PCnet LANCE PCI Ethernet Controller" } ,
    { 0x1022, 0x2001, "Am79C978", "PCnet-Home Networking Ctrlr (1/10 Mbps)" } ,
    { 0x1022, 0x2003, "Am1772", "Wireless LAN chipset SMC 2602W V3 http://www.smc.com/index.cfm?event=downloads.doSearchCriteria&loca" } ,
    { 0x1022, 0x2020, "Am53C974", "SCSI Controller" } ,
    { 0x1022, 0x2040, "Am79C974", "Ethernet Controller" } ,
    { 0x1022, 0x2081, "Unknown", "GeodeLX graphics adapter" } ,
    { 0x1022, 0x2082, "GX3", "Geode GX3 AES Crypto Driver" } ,
    { 0x1022, 0x208F, "CS5536", "GeodeLink PCI South Bridge" } ,
    { 0x1022, 0x2093, "CS5536", "CS5536 Audio Controller" } ,
    { 0x1022, 0x2094, "CS5536", "CS5536 OHCI USB Host Controller" } ,
    { 0x1022, 0x2095, "CS5536", "CS5536 EHCI USB Host Controller" } ,
    { 0x1022, 0x2096, "Number: CS5536", "CS5536 USB Device Controller" } ,
    { 0x1022, 0x2097, "CS5536", "CS5536 USB OTG Controller" } ,
    { 0x1022, 0x209A, "CS5536", "CS5536 IDE Controller" } ,
    { 0x1022, 0x2433, "690LC", "Chill Control Connector" } ,
    { 0x1022, 0x3000, "SC520", "ELAN Microcontroller PCI Host Bridge" } ,
    { 0x1022, 0x5e4b, "RV410", "Radeon X700 Pro" } ,
    { 0x1022, 0x7004, "AMD-751", "CPU to PCI Bridge" } ,
    { 0x1022, 0x7006, "AMD-751", "Processor-to-PCI Bridge / Memory Ctrlr" } ,
    { 0x1022, 0x7007, "AMD-751", "AGP and PCI-to-PCI Bridge (1x/2x AGP)" } ,
    { 0x1022, 0x700A, "AMD-IGR4", "AGP Host to PCI Bridge" } ,
    { 0x1022, 0x700B, "AMD-IGR4", "AGP PCI to PCI Bridge" } ,
    { 0x1022, 0x700C, "AMD-762", "CPU to PCI Bridge (SMP chipset)" } ,
    { 0x1022, 0x700D, "AMD-762", "CPU to PCI Bridge (AGP 4x)" } ,
    { 0x1022, 0x700E, "AMD-761", "North Bridge" } ,
    { 0x1022, 0x700F, "AMD-761", "CPU to AGP Bridge  (AGP 4x)" } ,
    { 0x1022, 0x7400, "AMD-755", "PCI to ISA Bridge" } ,
    { 0x1022, 0x7401, "AMD-755", "Bus Master IDE Controller" } ,
    { 0x1022, 0x7403, "AMD-755", "Power Management Controller" } ,
    { 0x1022, 0x7404, "AMD-755", "PCI to USB Open Host Controller" } ,
    { 0x1022, 0x7408, "AMD-756", "PCI-ISA Bridge" } ,
    { 0x1022, 0x7409, "AMD-756", "EIDE Controller" } ,
    { 0x1022, 0x740B, "AMD-756", "Power Management" } ,
    { 0x1022, 0x740C, "10", "USB Open Host Controller" } ,
    { 0x1022, 0x7410, "AMD-766", "PCI to ISA/LPC Bridge" } ,
    { 0x1022, 0x7411, "AMD-766", "Enhanced IDE Controller" } ,
    { 0x1022, 0x7412, "AMD-766", "USB Controller" } ,
    { 0x1022, 0x7413, "AMD-766", "Power Management Controller" } ,
    { 0x1022, 0x7414, "AMD-766", "USB OpenHCI Host Controller" } ,
    { 0x1022, 0x7440, "AMD-768", "LPC Bridge" } ,
    { 0x1022, 0x7441, "AMD-768", "EIDE Controller" } ,
    { 0x1022, 0x7443, "AMD-768", "System Management" } ,
    { 0x1022, 0x7445, "AMD-768", "AC97 Audio" } ,
    { 0x1022, 0x7446, "AMD-768", "AC97 Modem" } ,
    { 0x1022, 0x7448, "AMD-768", "PCI Bridge" } ,
    { 0x1022, 0x7449, "AMD-768", "USB Controller" } ,
    { 0x1022, 0x7450, "AMD-8131", "PCI-X Bridge" } ,
    { 0x1022, 0x7451, "AMD-8131", "PCI-X IOAPIC" } ,
    { 0x1022, 0x7454, "AMD-8151", "System Controller" } ,
    { 0x1022, 0x7455, "AMD-8151", "AGP Bridge" } ,
    { 0x1022, 0x7458, "AMD-8132", "PCI-X Bridge" } ,
    { 0x1022, 0x7459, "AMD-8132", "PCI-X IOAPIC" } ,
    { 0x1022, 0x7460, "AMD-8111", "PCI Bridge" } ,
    { 0x1022, 0x7461, "AMD-8111", "USB 2.0 Controller" } ,
    { 0x1022, 0x7462, "AMD-8111", "Ethernet Controller" } ,
    { 0x1022, 0x7463, "AMD-8111", "USB Enhanced Host Controller" } ,
    { 0x1022, 0x7464, "AMD-8111", "USB OpenHCI Host Controller" } ,
    { 0x1022, 0x7468, "AMD-8111", "LPC Bridge" } ,
    { 0x1022, 0x7469, "AMD-8111", "UltraATA/133 Controller" } ,
    { 0x1022, 0x746A, "AMD-8111", "SMBus 2.0 Controller" } ,
    { 0x1022, 0x746B, "AMD-8111", "System Management" } ,
    { 0x1022, 0x746D, "AMD-8111 (not sure but definitively not c-media cm", " Audio Controller" } ,
    { 0x1022, 0x746E, "AMD-8111", "AC'97 Modem" } ,
    { 0x1022, 0x756B, "AMD-8111", "ACPI Controller" } ,
    { 0x1022, 0x7801, "amd_sata", "AMD SATA Controller" } ,
    { 0x1022, 0x7801, "amd_sata", "AMD SATA Controller" } ,
    { 0x1022, 0x7804, "AMD SATA Controller", "AMD SATA Controller" } ,
    { 0x1022, 0x7807, "Standard OpenHCD USB Host Controller - Amd Usb Fil", "Standard OpenHCD USB Host Controller - Amd Usb Filter Driver" } ,
    { 0x1022, 0x7808, "Standard PCI-to-USB extended host controller ", "Standard PCI-to-USB extended host controller " } ,
    { 0x1022, 0x7809, "7809", "Standard OpenHCD USB Host Controller" } ,
    { 0x1022, 0x780b, "2128103C", "SM Bus controller" } ,
    { 0x1022, 0x780D, "780D", "High Definition Audio Controller" } ,
    { 0x1022, 0x780E, "780E", "PCI standard ISA bridge" } ,
    { 0x1022, 0x780F, "780F", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x7812, "amd_sata ", "AMD USB 3.0 Host Controller" } ,
    { 0x1022, 0x7814, "7814", "FCH USB XHCI Controller" } ,
    { 0x1022, 0x840, "4u", "Used to blow up the motherboard.  Highly explosive.  Use at ur own risk" } ,
    { 0x1022, 0x9601, "9601", "PCI standard host CPU bridge" } ,
    { 0x1022, 0x9602, "9602", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x9604, "9604", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x9605, "9605", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x9606, "9609", "PCI standard PCI-to-PCI bridge" } ,
    { 0x1022, 0x9642, "AMD-6370D", "AMD Radeon HD6370D" } ,
    { 0x1023, 0x0194, "82C194", "CardBus Controller" } ,
    { 0x1023, 0x2000, "4DWAVE-DX", "advanced PCI DirectSound accelerator" } ,
    { 0x1023, 0x2001, "4D WAVE DX SOUND ACCELERATOR", "PCI Audio" } ,
    { 0x1023, 0x2100, "Cyber-XP4", "Video Accelerator" } ,
    { 0x1023, 0x2200, "Volari V3", "Video adapter" } ,
    { 0x1023, 0x8400, "84001023", "sausgauos" } ,
    { 0x1023, 0x8420, "51331071", "Trident Cyber Blade i7 AGP (55)" } ,
    { 0x1023, 0x8500, "VT8361", "Via Tech VT8361/VT8601 Graphics Controller" } ,
    { 0x1023, 0x8520, "Trident Video Accelerator CyberBlade i1", "Windows xp" } ,
    { 0x1023, 0x8620, "CyberBlade-i1", "trident" } ,
    { 0x1023, 0x8820, "Ai1", "TRIDENT DISPLAY CONTROLER /CyberALADDiN-T Driver" } ,
    { 0x1023, 0x9320, "TGUI9320", "32-bit GUI Accelerator" } ,
    { 0x1023, 0x9350, "TGUI9350", "32-bit GUI Accelerator" } ,
    { 0x1023, 0x9360, "7tskbc", "Flat panel Cntrlr" } ,
    { 0x1023, 0x9382, "Cyber9382", "" } ,
    { 0x1023, 0x9383, "Cyber9383", "" } ,
    { 0x1023, 0x9385, "Cyber9385", "" } ,
    { 0x1023, 0x9386, "Cyber9386", "Video Accelerator" } ,
    { 0x1023, 0x9388, "Cyber9388", "Video Accelerator" } ,
    { 0x1023, 0x9397, "Cyber9397", "Video Accelerator 3D" } ,
    { 0x1023, 0x939A, "Cyber9397DVD", "Video Accelerator" } ,
    { 0x1023, 0x9420, "TGUI9420", "DGi GUI Accelerator" } ,
    { 0x1023, 0x9430, "TGUI9430", "GUI Accelerator" } ,
    { 0x1023, 0x9440, "TGUI9682", "DGi GUI Acclerator" } ,
    { 0x1023, 0x9460, "TGUI9460", "32-bit GUI Accelerator" } ,
    { 0x1023, 0x9470, "TGUI9470", "" } ,
    { 0x1023, 0x9520, "ox16", "Video Accelerator" } ,
    { 0x1023, 0x9525, "Cyber9525", "Video Accelerator" } ,
    { 0x1023, 0x9540, "Cyber9540", "Video Acclerator" } ,
    { 0x1023, 0x9660, "TGUI9660", "GUI Accelerator" } ,
    { 0x1023, 0x9680, "TGUI9680", "GUI Accelerator" } ,
    { 0x1023, 0x9682, "TGUI9680", "Trident A CAB01" } ,
    { 0x1023, 0x9683, "TGUI9683", "GUI Accelerator" } ,
    { 0x1023, 0x9685, "ProVIDIA 9685", "2MB VGA" } ,
    { 0x1023, 0x9750, "3DImage 9750 PCI/AGP", "trident dgi" } ,
    { 0x1023, 0x9753, "TGUI9753", "Video Accelerator" } ,
    { 0x1023, 0x9754, "TGUI9753", "Wave Video Accelerator" } ,
    { 0x1023, 0x9759, "TGUI975?", "Image GUI Accelerator" } ,
    { 0x1023, 0x9783, "TGUI9783", "" } ,
    { 0x1023, 0x9785, "TGUI9785", "" } ,
    { 0x1023, 0x9850, "3D Image 9850 AGP", "4mb" } ,
    { 0x1023, 0x9880, "Blade 3D 9880", "gggggg" } ,
    { 0x1023, 0x9910, "00011178", "CyberBlade XP" } ,
    { 0x1023, 0x9930, "CyberBlade XPm", "" } ,
    { 0x1023, 0x9960, "9960", "Trident Video Accelerator CyberBlade-1A31" } ,
    { 0x1025, 0x0028, "AC97", "Agere Systems soft modem chip" } ,
    { 0x1025, 0x1435, "M1435", "USB\\VID_0502&PID_3476&MI_01\\6&207B7CA8&0&0001" } ,
    { 0x1025, 0x1445, "M1445", "VL Bridge & EIDE" } ,
    { 0x1025, 0x1449, "M1449", "ISA Bridge" } ,
    { 0x1025, 0x1451, "M1451", "Pentium Chipset" } ,
    { 0x1025, 0x1461, "M1461", "P54C Chipset" } ,
    { 0x1025, 0x1489, "M1489", "" } ,
    { 0x1025, 0x1511, "M1511", "" } ,
    { 0x1025, 0x1512, "M1512", "" } ,
    { 0x1025, 0x1513, "M1513", "" } ,
    { 0x1025, 0x1521, "M1521", "CPU Bridge" } ,
    { 0x1025, 0x1523, "M1523", "ISA Bridge" } ,
    { 0x1025, 0x1531, "M1531", "North Bridge" } ,
    { 0x1025, 0x1533, "M1533", "ISA South Bridge" } ,
    { 0x1025, 0x1535, "M1535", "PCI South Bridge" } ,
    { 0x1025, 0x1541, "M1541", "AGP PCI North Bridge Aladdin V/V+" } ,
    { 0x1025, 0x1542, "M1542", "AGP+PCI North Bridge" } ,
    { 0x1025, 0x1543, "M1543C", "PCi South Bridge Aladdin IV+/V" } ,
    { 0x1025, 0x1561, "M1561", "driver video" } ,
    { 0x1025, 0x1621, "M1621", "PCI North Bridge Aladdin Pro II" } ,
    { 0x1025, 0x1631, "M1631", "PCI North Bridge Aladdin Pro III" } ,
    { 0x1025, 0x1641, "M1641", "PCI North Bridge Aladdin Pro IV" } ,
    { 0x1025, 0x3141, "M3141", "GUI Accelerator" } ,
    { 0x1025, 0x3143, "M3143", "GUI Accelerator" } ,
    { 0x1025, 0x3145, "M3145", "GUI Accelerator" } ,
    { 0x1025, 0x3147, "M3147", "GUI Accelerator" } ,
    { 0x1025, 0x3149, "M3149", "GUI Accelerator" } ,
    { 0x1025, 0x3151, "M3151", "GUI Accelerator" } ,
    { 0x1025, 0x3307, "M3307", "MPEG-1 Decoder" } ,
    { 0x1025, 0x3309, "M3309", "MPEG Decoder" } ,
    { 0x1025, 0x5212, "M4803", "" } ,
    { 0x1025, 0x5215, "M5217", "EIDE Controller" } ,
    { 0x1025, 0x5217, "M5217", "I/O Controller" } ,
    { 0x1025, 0x5219, "M5219", "I/O Controller" } ,
    { 0x1025, 0x5225, "M5225", "EIDE Controller" } ,
    { 0x1025, 0x5229, "M522", "EIDE Controlle" } ,
    { 0x1025, 0x5235, "1025", "I/O Controller" } ,
    { 0x1025, 0x5237, "M5237", "Intel(R) 5 Series/3400 Series Chipset Family 4 Port SATA AHCI Controller - 3B29" } ,
    { 0x1025, 0x5239, "", "" } ,
    { 0x1025, 0x5240, "", "EIDE Controller" } ,
    { 0x1025, 0x5241, "", "PCMCIA Bridge" } ,
    { 0x1025, 0x5242, "", "General Purpose Controller" } ,
    { 0x1025, 0x5243, "", "PCI to PCI Bridge" } ,
    { 0x1025, 0x5244, "", "Floppy Disk Controller" } ,
    { 0x1025, 0x5247, "M1541", "PCI-PCI Bridge" } ,
    { 0x1025, 0x5427, "", "PCI to AGP Bridge" } ,
    { 0x1025, 0x5451, "M5451", "PCI AC-Link Controller Audio Device" } ,
    { 0x1025, 0x5453, "M5453", "M5453 AC-Link Controller Modem Device" } ,
    { 0x1025, 0x7101, "M7101", "PCI PMU Power Management Controller" } ,
    { 0x1028, 0x0001, "PowerEdge 2 /Si", "Expandable RAID Controller (PERC) (SCSI)" } ,
    { 0x1028, 0x0002, "PowerEdge 3/Di", "Expandable RAID Controller" } ,
    { 0x1028, 0x0003, "PowerEdge 3/Si", "Expandable RAID Controller" } ,
    { 0x1028, 0x0004, "PowerEdge 3/Si", "Expandable RAID Controller" } ,
    { 0x1028, 0x0005, "PowerEdge 3/Di", "Expandable RAID Controller" } ,
    { 0x1028, 0x0006, "PowerEdge 3/Di", "Expandable RAID Controller" } ,
    { 0x1028, 0x0007, "270", "Remote Assistant Card" } ,
    { 0x1028, 0x0008, "PowerEdge 3/Di", "RAC Virtual UART Port" } ,
    { 0x1028, 0x000A, "PowerEdge 3/Di", "Expandable RAID Controller" } ,
    { 0x1028, 0x000C, "53C885 23800 SCSI Adapter", "Embedded Systems Management Device 4" } ,
    { 0x1028, 0x000D, "?", "LSI53C895 PCI to Ultra2 SCSI I/O Processor with LVD Link" } ,
    { 0x1028, 0x000E, "000E", "PERC 4/DI Raid Controller" } ,
    { 0x1028, 0x0010, "DRAC4", "HJ866 - ESM4 &#1059;&#1076;&#1072;&#1083;&#1077;&#1085;&#1085;&#1099;&#1081; &#1044;&#1086;&#1089;&#" } ,
    { 0x1028, 0x0011, "DRAC4", "Dell Remote Access Controller v4" } ,
    { 0x1028, 0x0012, "DRAC4-UART", "Dell RAC v4 Virtual UART" } ,
    { 0x1028, 0x0013, "PERC 4e/Si and PERC 4e/Di", "Expandable RAID Controller" } ,
    { 0x1028, 0x0014, "DRAC4-0", "Dell Remote Access Controller subsystem" } ,
    { 0x1028, 0x0015, "PERC 5/i RAID Controller", "Integrated RAID controller" } ,
    { 0x1028, 0x012c, "915gm/gms,910gml", "Intel Gigabit controller" } ,
    { 0x1028, 0x016d, "82541GI", "Dell PRO/1000 MT Network Connection" } ,
    { 0x1028, 0x0287, "DELL PERC 320/DC", "Adaptec 2200S SCSI RAID controller" } ,
    { 0x1028, 0x1000, "FA82537EP", "A Intel 537 epg v.92 modem repackaged by dell" } ,
    { 0x1028, 0x1050, "0200", "ethernet controller" } ,
    { 0x1028, 0x1f0c, "4050", "PCI Simple Communication Controller" } ,
    { 0x1028, 0x1f0c, "n4050", "pci simple communication controller" } ,
    { 0x1028, 0x2107, "0115", "HID Keyboard Device" } ,
    { 0x1028, 0x3002, "AR3011", "Dell Wireless 1702 Bluetooth v3.0+HS" } ,
    { 0x1028, 0x3582, "ispiron 4700", "video controller" } ,
    { 0x1028, 0x675d, "hd7570", "amd radeon hd7570" } ,
    { 0x1028, 0x6821, "3", "3" } ,
    { 0x1028, 0x8184, "Dell Wireless 5540", "Dell Wireless 5540 HSPA Mini Card" } ,
    { 0x1028, 0x9876, "PowerEdge 3/Si", "Expandable RAID Controller" } ,
    { 0x102A, 0x0000, "HYDRA", "4 port usb hub" } ,
    { 0x102A, 0x0003, "0x0000", "USB\\VID_0000&PID_0000\\6&76F8B18&0&2" } ,
    { 0x102A, 0x0010, "ASPEN", "i486 Chipset" } ,
    { 0x102A, 0x002A, "6.1.7601.18328", "4 port usb hub" } ,
    { 0x102A, 0x102A, "HYDRA", "P5 Chipset" } ,
    { 0x102A, 0x9876, "HYDRA", "P5 CHIPSET" } ,
    { 0x102B, 0x0010, "MGA-I", "Impression?" } ,
    { 0x102B, 0x0040, "chip=0x2539102b", "Matrox P650 very new model (20080724)" } ,
    { 0x102B, 0x051, "MGA-2164W", "matrox" } ,
    { 0x102B, 0x0518, "MGA-PX2085", "Atlas GUI Accelerator" } ,
    { 0x102B, 0x0519, "MGA-2064W", "Strorm GUI Accelerator" } ,
    { 0x102B, 0x051A, "mga-1164sg-a", "Hurricane/Cyclone 64-bit graphics chip" } ,
    { 0x102B, 0x051B, "MGA-2164W", "Matrox" } ,
    { 0x102B, 0x051E, "MGA-1164SG", "Chinook" } ,
    { 0x102B, 0x051F, "MGA-200B", "Mistral" } ,
    { 0x102B, 0x0520, "Matrox lnc MGA-G200B", "AGP" } ,
    { 0x102B, 0x0521, "Matrox lnc MGA-G200B", "102B" } ,
    { 0x102B, 0x0522, "G200e", "Matrox G200e (ServerEngines) - English" } ,
    { 0x102B, 0x0525, "i440B", "Intel Pentium III" } ,
    { 0x102B, 0x0527, "Parhelia AGP", "" } ,
    { 0x102B, 0x0528, "Parhelia", "Parhelia 128MB/256MB/PCI/HR256" } ,
    { 0x102B, 0x0530, "Matrox  G200eV", "Matrox G200eV" } ,
    { 0x102B, 0x0534, "?", "G200eR" } ,
    { 0x102B, 0x0540, "M9138", "M9138 LP PCIe x16" } ,
    { 0x102B, 0x0D10, "MGA-I", "Athena GUI accelerator" } ,
    { 0x102B, 0x1000, "MGA-G100", "Twister" } ,
    { 0x102B, 0x1001, "MGA-G100", "Twister AGP" } ,
    { 0x102B, 0x1525, "Fusion G450 AGP", "" } ,
    { 0x102B, 0x1527, "Fusion Plus G800 AGP", "" } ,
    { 0x102B, 0x2007, "Mistral", "GUI+3D Accelerator" } ,
    { 0x102B, 0x2527, "MGA-G550", "AGP Chipset" } ,
    { 0x102B, 0x2537, "Parhelia-LX", "Parhelia Chipset AGP" } ,
    { 0x102B, 0x2538, "Matrox Millennium P650 LP PCIe 64", "Matrox Millennium P650 LP PCIe 64" } ,
    { 0x102B, 0x2539, "G550/P650 Dual DVI", "Matrox Graphics Board dual DVI" } ,
    { 0x102B, 0x4536, "Meteor 2 STD/MC/Dig", "Video Capture Card" } ,
    { 0x102B, 0x522, "MGA-G200E", "Matrox G200e (ServerEngines)" } ,
    { 0x102B, 0x525, "G450", "G45+" } ,
    { 0x102B, 0x532, "G200eW", "Matrox G200eW 8 MB DDR2 " } ,
    { 0x102B, 0x6573, "Shark", "10/100 Multiport Switch NIC" } ,
    { 0x102B, 0x80A0, "RT.x10", "Multimedia Device" } ,
    { 0x102B, 0x9876, "RT 2000", "Multimedia device" } ,
    { 0x102C, 0x00B8, "64310", "Wingine DGX - DRAM Graphics Accelerator" } ,
    { 0x102C, 0x00C0, "69000", "AGP/PCI Flat Panel/CRT VGA Accelerator" } ,
    { 0x102C, 0x00D0, "65545", "Flat panel/crt VGA Cntrlr" } ,
    { 0x102C, 0x00D8, "65540", "Flat Panel/CRT VGA Controller" } ,
    { 0x102C, 0x00DC, "65548", "GUI Accelerator" } ,
    { 0x102C, 0x00E0, "65550", "LCD/CRT controller" } ,
    { 0x102C, 0x00E4, "65554", "Flat Panel/LCD CRT GUI Accelerator" } ,
    { 0x102C, 0x00E5, "65555", "VGA GUI Accelerator" } ,
    { 0x102C, 0x00F0, "68554", "vga Controller" } ,
    { 0x102C, 0x00F4, "68554", "graphic driver" } ,
    { 0x102C, 0x00F5, "68555", "GUI Controller" } ,
    { 0x102C, 0x01E0, "65560", "PCI Flat Panel/CRT VGA Accelerator" } ,
    { 0x102C, 0x0C30, "69030", "AGP/PCI Flat Panel/CRT VGA Accelerator" } ,
    { 0x102D, 0x50DC, "3328", "Audio" } ,
    { 0x102F, 0x0009, "r4x00", "CPU Bridge" } ,
    { 0x102F, 0x000A, "TX3927", "CPU Bridge?" } ,
    { 0x102F, 0x0020, "Meteor 155", "ATM PCI Adapter" } ,
    { 0x102F, 0x0030, "TC35815CF", "PCI\\VEN_8086" } ,
    { 0x102F, 0x0031, "TX4938", "Integrated 10/100 Mbit Ethernet Controller" } ,
    { 0x102F, 0x0100, "8185", "Realtek RTS5208 Card Reader" } ,
    { 0x102F, 0x0105, "TC86C001FG", "GOKU-S Bus Master IDE Controller" } ,
    { 0x102F, 0x0106, "TC86C001FG", "GOKU-S USB Host Controller" } ,
    { 0x102F, 0x0107, "TC86C001FG", "GOKU-S USB Device Controller" } ,
    { 0x102F, 0x0108, "TC86C001FG", "GOKU-S I2C Bus/SIO/GPIO Controller" } ,
    { 0x102F, 0x0180, "TX4927", "MIPS Processor" } ,
    { 0x102F, 0x0181, "TX4925", "MIPS RISC PCI Controller (PCIC)" } ,
    { 0x102F, 0x0182, "TX4937", "MIPS RISC PCI Controller (PCIC)" } ,
    { 0x102F, 0x01BA, "SE1000", "SpursEngine" } ,
    { 0x102F, 0x0805, "TC35815CF", "PCI\\VEN_1179&DEV_0805&CC_0880" } ,
    { 0x102F, 0x102F, "ACPI\\SMCFO30\\4&69EE968&0", "PCI\\VEN_1179&DEV_0805&SUBSYS_00011179&REV_05\\4&7562792&0&68F0" } ,
    { 0x1031, 0x5601, "MiroVIDEO DC20", "I/O & JPEG" } ,
    { 0x1031, 0x5607, "2IVDC-PCX1 1250400 033893932", "video in and out with motion jpeg compression and deco" } ,
    { 0x1031, 0x5631, "Media 3D", "" } ,
    { 0x1031, 0x6057, "MiroVIDEO DC30D", "DC30D-601601-4.0" } ,
    { 0x1033, 0x0001, "upD98409", "PCI to 486 like bus Bridge" } ,
    { 0x1033, 0x0002, "", "PCI to VL98 Bridge" } ,
    { 0x1033, 0x0003, "", "ATM Controller" } ,
    { 0x1033, 0x0004, "R4000", "PCI bus Bridge" } ,
    { 0x1033, 0x0005, "pci 7432", "PCI to 486 like peripheral bus Bridge" } ,
    { 0x1033, 0x0006, "", "GUI Accelerator" } ,
    { 0x1033, 0x0007, "unknown from Creative.com", "PCI to ux-bus Bridge" } ,
    { 0x1033, 0x0008, "", "GUI Accelerator (vga equivalent)" } ,
    { 0x1033, 0x0009, "", "graphic Cntrlr for 98" } ,
    { 0x1033, 0x001A, "Nile II", "" } ,
    { 0x1033, 0x001D, "uPD98405", "NEASCOT-S20 ATM Integrated SAR Ctrlr" } ,
    { 0x1033, 0x0021, "Vrc4373", "Nile I" } ,
    { 0x1033, 0x0029, "PoverVR PCX1", "3D Accelerator" } ,
    { 0x1033, 0x002A, "PoverVR", "3D Accelerator" } ,
    { 0x1033, 0x002f, "NEC D72874GC", "1394 Host Controller" } ,
    { 0x1033, 0x0034, "PCI\\VEN_1033&DEV_0034&SUBSYS_00341033&REV_43", "PCI\\VEN_1033&DEV_0034&SUBSYS_00341033" } ,
    { 0x1033, 0x0035, "udp9210", "Dual OHCI controllers plus Single EHCI controller" } ,
    { 0x1033, 0x0036, "uPD98409", "NEASCOT-S40C ATM Light SAR Controller" } ,
    { 0x1033, 0x003E, "uPD66369", "NAPCCARD CardBus Controller" } ,
    { 0x1033, 0x0046, "PoverVR PCX2", "3D Accelerator" } ,
    { 0x1033, 0x005A, "Vrc5074", "Nile 4" } ,
    { 0x1033, 0x0063, "uPD72862", "Firewarden IEEE1394 OHCI Host Controller" } ,
    { 0x1033, 0x0067, "PowerVR Neon 250", "PowerVR series II graphics processor" } ,
    { 0x1033, 0x0074, "NEC FMK 56 V90", "56k Voice Modem" } ,
    { 0x1033, 0x009B, "Vrc5476", "" } ,
    { 0x1033, 0x00A6, "", "" } ,
    { 0x1033, 0x00BE, "VR4122", "64-bit CPU with Northbridge" } ,
    { 0x1033, 0x00CD, "uPD72870", "IEEE1394 1-Chip OHCI Host Controller" } ,
    { 0x1033, 0x00CE, "uPD72871/2", "IEEE1394 1-Chip OHCI Host Controller" } ,
    { 0x1033, 0x00E0		, "0x1033	", "USB 2.0 Host Controller" } ,
    { 0x1033, 0x00E0, "uPD720100A uPD720102GC", "USB 2.0 Host Controller" } ,
    { 0x1033, 0x00E7, "uPD72874", "IEEE1394 OHCI 1.1 3-port PHY-Link Ctrlr" } ,
    { 0x1033, 0x00F2, "D72874GC", "IEEE1394+OHCI+1.1+3-port+PHY-Link+Ctrlr" } ,
    { 0x1033, 0x0165, "-", "AVerMedia A313 MiniCard Hybrid DVB-T" } ,
    { 0x1033, 0x0194, "0C0330", "Renesas Electronics USB 3.0 Host Controller" } ,
    { 0x1033, 0x0520, "NEC D72874GC", "1394 CARD" } ,
    { 0x1033, 0x1033, "0720101GJ", "NEC PCI to USB Open Host Controller" } ,
    { 0x1033, 0x9876, "uPD720100A uPD720102GC", "USB 2.0 Host Controller" } ,
    { 0x1033, 0x284b, "n/a", "n/a" } ,
    { 0x1036, 0x0000, "TMC-18C30", "Fast SCSI" } ,
    { 0x1039, 0x7012, "HDAUDIO\\FUNC_01&VEN_&DEV_504514F1&SUBSYS_1631C106&", "PCI Audio Accelerator" } ,
    { 0x1039, 0x0001, "HPSiS760", "Anthlon 64 cpu to PCI bridge" } ,
    { 0x1039, 0x0002, "520", "Virtual PCI to PCI Bridge (AGP)" } ,
    { 0x1039, 0x0003, "SiS760", "SiS AGP Controller / SiS Accelerated Graphics Port " } ,
    { 0x1039, 0x0005, "0900", "Pentium chipset" } ,
    { 0x1039, 0x0006, "SiS 85C501", "PCI/ISA Cache Memory Controller (PCMC)" } ,
    { 0x1039, 0x0008, "SiS 85C503", "PCI System I/O (PSIO)" } ,
    { 0x1039, 0x0009, "5595", "SIS PMU device" } ,
    { 0x1039, 0x0016, "SiS740", "SMBus ControllerP4kjc" } ,
    { 0x1039, 0x0018, "SiS950", "vga" } ,
    { 0x1039, 0x0160, "SiS160", "SiS160 811 Wireless LAN Adapter" } ,
    { 0x1039, 0x0180, "SiS180", "SiS 180/181 RAID Controller " } ,
    { 0x1039, 0x0181, "?", "Raid Controller(?Mode Raid1)" } ,
    { 0x1039, 0x0182, "?", "Raid Controller(?Mode Raid0+1)" } ,
    { 0x1039, 0x0183, "?SIS965", "?SATA" } ,
    { 0x1039, 0x0186, "1039", "0330" } ,
    { 0x1039, 0x0190, "SiS968, SiS965, SiS966, SiS965L, SiS966L", "SiS191 Gigabit LAN & SiS190 LAN" } ,
    { 0x1039, 0x0191, "SIS191", "SIS191" } ,
    { 0x1039, 0x0200, "SiS5597/98", "Onboard Graphics Controller" } ,
    { 0x1039, 0x0204, "SiS 6215", "PCI1" } ,
    { 0x1039, 0x0205, "SiS 6205", "PCI Graphics & Video Accelerator" } ,
    { 0x1039, 0x0300, "SiS330", "GUI Accelerator+3D" } ,
    { 0x1039, 0x0305, "SiS305", "2D/3D/Video/DVD Accelerator" } ,
    { 0x1039, 0x0315, "Geforce2 MX400", "2D/3D Accelerator" } ,
    { 0x1039, 0x0325, "SiS6330", "Silicon Integrated Systems (SiS)" } ,
    { 0x1039, 0x0330, "SiS330", "Xabre 2D/3D Accelerator (AG400T8-D64)" } ,
    { 0x1039, 0x0406, "85C501", "PCI/ISA Cache Memory Controller (PCMC)" } ,
    { 0x1039, 0x0496, "85C496", "CPU to PCI & PCI to ISA Bridge" } ,
    { 0x1039, 0x0530, "SiS530", "Host-to-PCI bridge" } ,
    { 0x1039, 0x0540, "SiS540", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0550, "SiS550/1/2", "North Bridge" } ,
    { 0x1039, 0x0596, "SiS596", "Pentium PCI chipset with IDE" } ,
    { 0x1039, 0x0597, "SiS620", "EIDE Controller (step C)" } ,
    { 0x1039, 0x0601, "SiS83C601", "PCI EIDE Controller" } ,
    { 0x1039, 0x0620, "SiS620", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0630, "SiS6330", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0635, "SiS 635", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0640, "SiS 640", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0645, "SiS 645", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0646, "SiS645DX", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0648, "SiS648MX", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0649, "sis649", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0650, "SiS961", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0651, "SiS651", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0655, "SiS655", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0656, "???", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0658, "SiS R658", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0659, "SiS R659", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0660, "vt8237a", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0661, "SiS 661FX", "SiS 661FX/GX Chipset - Host-PCI Bridge" } ,
    { 0x1039, 0x0662, "???", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0663, "???", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0730, "SiS 730", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0735, "SiS 735", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0740, "SiS 074", "LPC Bridge" } ,
    { 0x1039, 0x0741, "SIS741", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0745, "SiS745", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0746, "SiS746", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0748, "SiS748", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0755, "SiSM650?", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x0756, "SiS755FX", "CPU to PCI Bridge" } ,
    { 0x1039, 0x0760, "SiS760", "Athlon 64 CPU to PCI Bridge" } ,
    { 0x1039, 0x0761, "88e8056", "Athlon 64 CPU to PCI Bridge" } ,
    { 0x1039, 0x0762, "???", "Athlon 64 CPU to PCI Bridge" } ,
    { 0x1039, 0x0900, "SiS 900", "SiS 900 Fast Ethernet Adapter" } ,
    { 0x1039, 0x0901, "Device ID = 0900 SiS900", "SiS900 10/100 Ethernet Adapter" } ,
    { 0x1039, 0x0962, "SiS962", "LPC Bridge" } ,
    { 0x1039, 0x0963, "SiS963", "PCI to ISA Bridge" } ,
    { 0x1039, 0x0964, "SiS964", "SiS 964 MuTIOL Media I/O Bridge " } ,
    { 0x1039, 0x0999, "sis950", "pci\\ven_1039&subsys_200b163&rev_a0\\3&61aaa01\\0&17" } ,
    { 0x1039, 0x1039, "SiS5597a", "SiS5597 SVGAa" } ,
    { 0x1039, 0x1040, "", "" } ,
    { 0x1039, 0x10ec, "961/2", "bus controler" } ,
    { 0x1039, 0x1182, "?", "Raid Controller(?Mode Raid5)" } ,
    { 0x1039, 0x1183, "SIS966/968 ", "SATA IDE Controller" } ,
    { 0x1039, 0x1184, "SIS966(AHCI)&#12289;SIS968(RAID)", "Raid/AHCI Controller" } ,
    { 0x1039, 0x1185, "SIS968", "AHCI Controller" } ,
    { 0x1039, 0x1234, "SiS5597a", "SiS5597 SVGAa" } ,
    { 0x1039, 0x191, "MTC ms9377c", "PCI /ven_1039" } ,
    { 0x1039, 0x3602, "SiS83C602", "IDE Controller" } ,
    { 0x1039, 0x4321, "Video Controller", "Video Controller (VGA Compatible)" } ,
    { 0x1039, 0x5107, "SiS5107", "Hot Docking Controller" } ,
    { 0x1039, 0x5300, "SiS540", "AGP" } ,
    { 0x1039, 0x5315, "SiS530/1/2", "GUI Accelerator" } ,
    { 0x1039, 0x5401, "SiS5401", "486 PCI Chipset" } ,
    { 0x1039, 0x5511, "SiS5511/5512", "PCI/ISA System Memory Controller" } ,
    { 0x1039, 0x5513, "All SIS SouthBridge", "SiS 5513 IDE UDMA Controller / SiS 85C513 IDE Controller" } ,
    { 0x1039, 0x5517, "SiS5517", "CPU to PCI Bridge" } ,
    { 0x1039, 0x5518, "SiS5518", "UDMA IDE Controller" } ,
    { 0x1039, 0x5571, "SiS5571", "Memory/PCI bridge" } ,
    { 0x1039, 0x5581, "SiS 5581", "p5 chipset" } ,
    { 0x1039, 0x5582, "SiS5582", "PCI to ISA Bridge" } ,
    { 0x1039, 0x5591, "MTC ms9377c (SIS 741                      ", "PCI\\VEN_1039" } ,
    { 0x1039, 0x5596, "SiS661FX", " VGA Controller" } ,
    { 0x1039, 0x5597, "SiS5597", "Host to PCI bridge" } ,
    { 0x1039, 0x5600, "SiS600", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x5630, "SiS630", "Host-to-PCI Bridge" } ,
    { 0x1039, 0x5811, "", "" } ,
    { 0x1039, 0x6204, "SiS6204", "video decoder/mpeg interface" } ,
    { 0x1039, 0x6205, "SiS6215", "PCI VGA Controller" } ,
    { 0x1039, 0x6225, "SiS 950 m2284dxs", "PCI Graphics & Video Accelerator" } ,
    { 0x1039, 0x6236, "SG3730il", "Graphics" } ,
    { 0x1039, 0x6300, "SiS630/730", "GUI Accelerator+3D" } ,
    { 0x1039, 0x6306, "SiS530/620", "Integrated 3D  SVGA Controller" } ,
    { 0x1039, 0x6325, "pc&#305;\\VEN_1039&DEV_6325", "sis-651dx" } ,
    { 0x1039, 0x6326, "0x1039", "sis 6326 AGP" } ,
    { 0x1039, 0x6330, "SiS661FX/M661FX/760/741/M760/M741", "GUI 2D/3D Accelerator" } ,
    { 0x1039, 0x6331, " 04", "USB Host Controller" } ,
    { 0x1039, 0x6351, "SIS M672 FX", "SiS IGP Graphics family SIS66x/SIS76x & SIS67x" } ,
    { 0x1039, 0x6355, "962", "962lua" } ,
    { 0x1039, 0x6787, "SiS5597a", "Smart Link 56K Voice Modem (download from driverguide.com)" } ,
    { 0x1039, 0x6972, "", "" } ,
    { 0x1039, 0x7001, "SiS 7001", "SiS 7001 PCI to USB Open Host Controller " } ,
    { 0x1039, 0x7002, "SiS 7001 PCI to USB Open Host Controller", "USB 2.0 Enhanced Host Controller" } ,
    { 0x1039, 0x7005, "SiS551/2", "Memory Stick Controller" } ,
    { 0x1039, 0x7007, "1039", "OHCI Compliant FireWire Controller" } ,
    { 0x1039, 0x7012, "SiS 7012", "SiS 7012 Audio Device / Realtek AC'97 Audio" } ,
    { 0x1039, 0x7013	, "SiS5597a", "Smart Link 56K Voice Modem (download from driverguide.com)" } ,
    { 0x1039, 0x7013, "SiS7013", "Smart Link 56K Voice Modem" } ,
    { 0x1039, 0x7015, "SiS550 dd", "Software Audio dd" } ,
    { 0x1039, 0x7016, "SiS191", "10/100 Ethernet Adapter" } ,
    { 0x1039, 0x7018, "SiS7018", "Onboard audio" } ,
    { 0x1039, 0x7019, "SiS550/1/2", "Hardware Audio" } ,
    { 0x1039, 0x7300, "SiS7013", "GUI Accelerator+3D" } ,
    { 0x1039, 0x7502, "649", "Realtek HDA Audio Driver." } ,
    { 0x1039, 0x8139, "2012", "2012" } ,
    { 0x1039, 0x9632, "pc&#305;\\ven_1039&dev_6325", "sis 650 integrated gfx controller (IGP)" } ,
    { 0x1039, 0x964, "sis964", "LPC BRIDGE" } ,
    { 0x1039, 0x9876, "sis6215", "pci vga card for win95 & nt4 only" } ,
    { 0x1039, 0x9989, "SiS5597a", "Smart Link 56K Voice Modem (download from driverguide.com)" } ,
    { 0x1039, 0x7012, "HDAUDIO\\FUNC_01&VEN_&DEV_504514F1&SUBSYS_1631C106&", "PCI Audio Accelerator" } ,
    { 0x1039, 5811, "", "" } ,
    { 0x103B, 0x103b, "82801DB", "LAN Controller with 82562EM/EX PHY" } ,
    { 0x103C, 0x0024, "?", "Standard Vista USB Keyboard" } ,
    { 0x103C, 0x0180, "0x00000000", "HID Keyboard Device" } ,
    { 0x103C, 0x0A01, "HP2400", "HP Scanjet 2400" } ,
    { 0x103C, 0x1005, "A4977A", "Visialize EG" } ,
    { 0x103C, 0x1008, "Donner GFX", "001" } ,
    { 0x103C, 0x100A, "hpVisualizeFX", "Hewlett-Packard VisualizeFX Series Video" } ,
    { 0x103C, 0x1028, "ACPI/HPQ0004/3&b1bfb68&0", "HP ProtectSmart Hard Drive Protection - HP 3D DriveGuard" } ,
    { 0x103C, 0x1029, "HPFC-5200B", "Tachyon XL2 Fibre Channel Adapter" } ,
    { 0x103C, 0x102A, "Tach TS", "Tachyon TS Fibre Channel Host Adapter" } ,
    { 0x103C, 0x1030, "J2585B", "DeskDirect 10/100VG LAN Adapter" } ,
    { 0x103C, 0x1031, "J2585B222", "DeskDirect 10/100" } ,
    { 0x103C, 0x1040, "J2973A", "DeskDirect 10BaseT NIC" } ,
    { 0x103C, 0x1041, "J2585B", "DeskDirect 10/100VG NIC" } ,
    { 0x103C, 0x1042, "J2970A", "DeskDirect 10BaseT/2 NIC" } ,
    { 0x103C, 0x1048, "SAS", "" } ,
    { 0x103C, 0x1049, "DIVA1", "" } ,
    { 0x103C, 0x104A, "DIVA2", "intel" } ,
    { 0x103C, 0x104B, "SP2", "" } ,
    { 0x103C, 0x104D, "J3242A", "EL-10 Ethernet Adapter" } ,
    { 0x103C, 0x1064, "79C970", "PCnet Ethernet Controller" } ,
    { 0x103C, 0x10C1, "PCI\\VEN_10DE&DEV_0543&SUBSYS_30CF103C&REV_A2", "NetServer Smart IRQ Router" } ,
    { 0x103C, 0x10ED, "TopTools", "HP Communications Port" } ,
    { 0x103C, 0x1200, "82557B", "10/100 NIC" } ,
    { 0x103C, 0x1219, "", "NetServer PCI Hot-Plug Controller" } ,
    { 0x103C, 0x121A, "", "NetServer SMIC Controller" } ,
    { 0x103C, 0x121B, "", "NetServer Legacy COM Port Decoder" } ,
    { 0x103C, 0x121C, "", "NetServer PCI COM Port Decoder" } ,
    { 0x103C, 0x1229, "zx1", "System Bus Adapter" } ,
    { 0x103C, 0x122A, "zx1", "I/O Controller" } ,
    { 0x103C, 0x122B, "zx1", "Local Bus Adapter" } ,
    { 0x103C, 0x12FA, "Broadcom BCM4306", "Broadcom Wireless miniPCI in a HP laptop" } ,
    { 0x103C, 0x1302, "1302103C", "HP Management Shared Memory Device" } ,
    { 0x103C, 0x137a, "AR5007", "Atheros AR5007" } ,
    { 0x103C, 0x1411, "HPOJ750", "HP PSC 750" } ,
    { 0x103C, 0x171d, "HP Integrated Module with Bluetooth Wireless", "HP Integrated Module with Bluetooth Wireless" } ,
    { 0x103C, 0x1F1D, "USB\\VID_03F0&PID_241D&REV_0002", "3G Broadband device" } ,
    { 0x103C, 0x201D, "?", "3G Broadband device" } ,
    { 0x103C, 0x231D, "USB\\VID_03F0&PID_0a01\\6&23104BA&0&7", "HP Integrated Module with Bluetooth Wireless Technology" } ,
    { 0x103C, 0x241D, "USB\\VID_0000_PID_0000_0000\\5&25243b3b&0&1", "HP compaq nx6125" } ,
    { 0x103C, 0x2910, "E2910A", "PCI Bus Exerciser" } ,
    { 0x103C, 0x292, "E2924A", "PCI Host Interface Adapter" } ,
    { 0x103C, 0x2920, "", "Fast Host Interface" } ,
    { 0x103C, 0x2924, "QDS-BRCM1051", "PCI Host Interface Adapter" } ,
    { 0x103C, 0x2925, "E2925A", "32 bit PCI Bus Exerciser and Analyzer" } ,
    { 0x103C, 0x2926, "E2926A", "64 bit PCI Bus Exerciser and Analyzer" } ,
    { 0x103C, 0x2927, "E2927a", "64 Bit, 66/50MHz PCI Analyzer & Exerciser" } ,
    { 0x103C, 0x294, "qds brcm1051", "pci hostinterface" } ,
    { 0x103C, 0x2940, "E2940A", "64 bit, 66/50MHz CompactPCI Analyzer&Exerciser" } ,
    { 0x103C, 0x311d, "rev 001", "ATHEROS AR3011 bluetooth 3.0+HS adapter" } ,
    { 0x103C, 0x3206, "unknown", "Adaptec Embedded Serial ATA HostRAID" } ,
    { 0x103C, 0x3207, "not sure", "not sure" } ,
    { 0x103C, 0x3220, "P600", "P600 SmartArray Raid Controller" } ,
    { 0x103C, 0x3230, "Smart Array P400 Controller", "Smart Array P400 Controller" } ,
    { 0x103C, 0x323A, "Smart Array P410i Controller", "Smart Array P410i Controller" } ,
    { 0x103C, 0x3302, "3305103C", "Integrated Lights Out 2.0 Interfaz IPMI" } ,
    { 0x103C, 0x3A1D, "hs2340", "HP hs2340 HSPA+ MobileBroadband" } ,
    { 0x103C, 0x5461, "unknown", "HP integrated Module with Bluetooth 2.0 Wireless support" } ,
    { 0x103C, 0x6007, "ACPI\\VEN_HPQ&DEV_6007", "HP Mobile Data Protection Sensor" } ,
    { 0x103C, 0x9876, "rev 001", "ATHEROS AR3011 bluetooth 3.0+HS adapter" } ,
    { 0x1043, 0x0675, "p5g41c-mlx", "Crestline" } ,
    { 0x1043, 0x1969, "P5LD2 - EAYZ", "Attansic L1 Gigabit Ethernet 10/100/1000Base-T Adapter" } ,
    { 0x1043, 0x5653, "M5A78L-M LX V2", "ATI Radeon 3000 Graphics (Microsoft Corporation - WDDM v1.1)" } ,
    { 0x1043, 0x8103, "NV31", "NV31 [GeForce FX 5600 Ultra]" } ,
    { 0x1043, 0x82c6, "RTL8168", "Gigabit Ethernet(NDIS 6.0)" } ,
    { 0x1044, 0x1012, "Domino", "RAID Engine" } ,
    { 0x1044, 0x800A, "13D09B4F", "802.11 bg WLAN" } ,
    { 0x1044, 0xA400, "2124A/9X", "SmartCache III/RAID SCSI Controller" } ,
    { 0x1044, 0xA500, "unknown", "PCI Bridge" } ,
    { 0x1044, 0xA501, "c03c", "I2O SmartRAID V Controller" } ,
    { 0x1044, 0xA511, "Raptor", "SmartRAID Controller" } ,
    { 0x1045, 0x0005, "", "" } ,
    { 0x1045, 0xA0F8, "82C750", "PCI USB Controller" } ,
    { 0x1045, 0xC101, "82C264", "GUI Accelerator" } ,
    { 0x1045, 0xC178, "82C178", "pci usb card 2- port" } ,
    { 0x1045, 0xC556, "82C556", "Viper" } ,
    { 0x1045, 0xC557, "82C557", "CPU Bridge (Viper)" } ,
    { 0x1045, 0xC558, "82C558", "ISA Bridge w/PnP" } ,
    { 0x1045, 0xC567, "82C750", "Vendetta chipset: host bridge" } ,
    { 0x1045, 0xC568, "82C750", "Vendetta chipset: ISA bridge" } ,
    { 0x1045, 0xC569, "82C579", "Pentium to PCI Bridge" } ,
    { 0x1045, 0xC621, "82C621", "PCI IDE Controller (PIC)" } ,
    { 0x1045, 0xC700, "82C700", "82C700 FireStar PCI to ISA Bridge" } ,
    { 0x1045, 0xC701, "82C701", "FireStar mobile chipset: host bridge" } ,
    { 0x1045, 0xC814, "82C814", "FireBridge II Docking Station Controller" } ,
    { 0x1045, 0xC822, "82C822", "CPU to PCI & PCI to ISA PnP bridge" } ,
    { 0x1045, 0xC824, "82C824", "FireFox 32-Bit PC Card Controller" } ,
    { 0x1045, 0xC825, "82C825 function 0", "PCI-to-ISA Bridge" } ,
    { 0x1045, 0xC832, "82C832", "CPU-to-PCI and PCI-to-ISA Bridge" } ,
    { 0x1045, 0xC861, "82C861", "OPTi 82C861 PCI to USB Open Host Controller" } ,
    { 0x1045, 0xC881, "82C881", "FireLink 1394 OHCI Link Controller" } ,
    { 0x1045, 0xC895, "82C895", "" } ,
    { 0x1045, 0xC931, "82C931", "ISA Sound & Game Port controller." } ,
    { 0x1045, 0xC935, "82C935", "MachOne integrated PCI audio processor" } ,
    { 0x1045, 0xD568, "82C825", "PCI bus master IDE controller" } ,
    { 0x1045, 0xD768, "82C750", "Ultra DMA IDE controller" } ,
    { 0x1046, 0x5600, "03001426", "00/4&1a671" } ,
    { 0x1048, 0x0253, "0x0c92", "ELSA GLADIAC 528" } ,
    { 0x1048, 0x0C60, "Elsa Gladiac MX", "NVidia Geforce 2 MX" } ,
    { 0x1048, 0x0C71, "Elsa Gladiac 721", "NVidia GeForce3 Ti 200" } ,
    { 0x1048, 0x1000, "Quick Step 1000", "ISDN Controller" } ,
    { 0x1048, 0x3000, "QuickStep 3000", "" } ,
    { 0x1048, 0x8901, "", "ELSA GLoria XL" } ,
    { 0x104A, 0x0008, "STG 2000X", "diamond" } ,
    { 0x104A, 0x0009, "STG 1764X", "" } ,
    { 0x104A, 0x0010, "STG4000", "PowerVR KYRO series 3 graphics processor" } ,
    { 0x104A, 0x0123, "V65204", "SPEAr1300" } ,
    { 0x104A, 0x0209, "STPC Consmr/Indstrl", "North/South Bridges" } ,
    { 0x104A, 0x020A, "STPC Atlas/Elite", "North Bridge" } ,
    { 0x104A, 0x0210, "STPC Atlas", "ISA Bridge" } ,
    { 0x104A, 0x021A, "STPC Consmr-S/Elite", "ISA Bridge" } ,
    { 0x104A, 0x021B, "STPC Consumer-II", "ISA Bridge" } ,
    { 0x104A, 0x0228, "STPC Atlas", "IDE Controller" } ,
    { 0x104A, 0x0230, "STPC Atlas", "USB Controller" } ,
    { 0x104A, 0x0500, "ST70137", "ADSL" } ,
    { 0x104A, 0x0981, "jmc260", "10/100 Ethernet Adapter" } ,
    { 0x104A, 0x1746, "mp280", "mp280" } ,
    { 0x104A, 0x2774, "STE10/100A", "PCI 10/100 Ethernet Controller" } ,
    { 0x104A, 0x3520, "", "MPEG-II Video Decoder" } ,
    { 0x104A, 0x7108, "STi7108", "Advanced HD AVC decoder with 3D graphics acceleration" } ,
    { 0x104A, 0xCC00, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC01, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC02, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC03, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC04, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC05, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC06, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC07, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC08, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC09, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC0A, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC0B, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC0C, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC0D, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC0E, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC0F, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC10, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC11, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC12, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC13, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC14, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC15, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC16, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCC17, "STA2X11", "ConneXt I/O Hub multifunction device" } ,
    { 0x104A, 0xCD00, "V65204", "SPEAr1300" } ,
    { 0x104A, 0xCD80, "SPEAr1300", "Root Complex of SPEAr1300" } ,
    { 0x104A, 0x8800, "Unknown", "ST Microelectronics Free Fall Sensor" } ,
    { 0x104A, 0x8810, "Unknown", "STMicroelectronics Freefall Sensor" } ,
    { 0x104C, 0x803B, "0366107B", "Texas Instruments Card Reader" } ,
    { 0x104C, 0x014e, "4610,4515,4610fm", "device" } ,
    { 0x104C, 0x0500, "TNETE100A/110A/211", "ThunderLAN 100 Mbit LAN Controller" } ,
    { 0x104C, 0x0508, "TI380PCI", "PCI interface for TI380 compressors" } ,
    { 0x104C, 0x1000, "TI PCI Eagle i/f AS", "" } ,
    { 0x104C, 0x104C, "PCI\\VEN_104C&DEV_803B&SUBSYS_FF021179&REV_00", "PCI Simple Communications Controller" } ,
    { 0x104C, 0x3B04, "028000", "otros dispositivos" } ,
    { 0x104C, 0x3D04, "TVP4010", "Permedia" } ,
    { 0x104C, 0x3D07, "TVP4020", "AGP Permedia 2" } ,
    { 0x104C, 0x8000, "TSB12LV21", "LYNX IEEE1394 FireWire Host Controller" } ,
    { 0x104C, 0x8009, "TSB12LV22", "OHCI-Lynx PCI IEEE 1394 Host Controller" } ,
    { 0x104C, 0x8010, "TSB12LV26", "OHCI-Lynx IEEE 1394 Host Controller" } ,
    { 0x104C, 0x8011, "PCI4450", "OHCI-Lynx IEEE 1394 Controller" } ,
    { 0x104C, 0x8017, "PCI4410", "OHCI-Lynx IEEE 1394 Controller" } ,
    { 0x104C, 0x8019, "TSB12LV23", "OHCI-Lynx PCI IEEE 1394 Host Controller" } ,
    { 0x104C, 0x8020, "TSB12LV26", "OHCI Compliant FireWire Controller" } ,
    { 0x104C, 0x8021, "TSB43AB23", "1394a-2000 OHCI PHY/Link Layer CONTROLLER" } ,
    { 0x104C, 0x8023, "TSB43AB21/A", "IEEE1394a-2000 OHCI PHY/Link-Layer Ctrlr" } ,
    { 0x104C, 0x8024, "TSB43AB23", "1394a-2000 OHCI PHY/Link Layer Ctrl" } ,
    { 0x104C, 0x8025, "TSB82AA2", "1394b OHCI-Lynx IEEE 1394 Host Controller" } ,
    { 0x104C, 0x8026, "TSB43AB21A", "1394a-2000 OHCI PHY/Link Layer Ctrlr" } ,
    { 0x104C, 0x8027, "PCI4451", "OHCI-Lynx IEEE 1394 Controller" } ,
    { 0x104C, 0x8029, "040803-2158", "OHCI Compliant IEEE-1394 FireWire Controller " } ,
    { 0x104C, 0x802e, "PCI7420", "OHCI Compliant IEEE 1394 Host Controller" } ,
    { 0x104C, 0x8031, "8031", "Generic CardBus Controller" } ,
    { 0x104C, 0x8033, "PCI0021", "Integrated FlashMedia / Card Reader" } ,
    { 0x104C, 0x8034, "10981734", "SDA Standard Compliant SD Host Controller" } ,
    { 0x104C, 0x8035, "N/A", "PCI GemCore based SmartCard controller" } ,
    { 0x104C, 0x8036, "PCI6515", "Texas Instruments PCIxxx12 Cardbus Controller" } ,
    { 0x104C, 0x8038, "PCI\\VEN_104C&DEV_8038&SUBSYS_01861028&REV_00\\4&2FA", "Texas Instruments PCI GemCore based SmartCard Controller" } ,
    { 0x104C, 0x8039, "104C", "104C" } ,
    { 0x104C, 0x803a, "PCIxx12", "OHCI Compliant IEEE 1394 Host controller" } ,
    { 0x104C, 0x803B, "PCIxx12 Integrated FlashMed", "Texas Instruments Card Reader" } ,
    { 0x104C, 0x803c, "PCI0024", "SDA Standard Compliant SD Host Controller" } ,
    { 0x104C, 0x803D, "0780", "Texas Instruments PCI GemCore based SmartCard controller" } ,
    { 0x104C, 0x8119, "na", "iRDA Compatible Controller" } ,
    { 0x104C, 0x8201, "006B103C", "TI UltraMedia Firmware Loader Device" } ,
    { 0x104C, 0x8204, "4610, 4515, 4610FM, 7510", "PCI 7510/4510 Cardbus Controller" } ,
    { 0x104C, 0x8231, "XIO2000A", "PCI-Express to PCI/PCI-X bridge" } ,
    { 0x104C, 0x8232, "1", "Controladora de v�deo multimedia" } ,
    { 0x104C, 0x8241, "Texas Instruments USB 3.0 XHCI Host Controller", "Texas Instruments USB 3.0 XHCI Host Controller" } ,
    { 0x104C, 0x8400, "ACX100AGHK", "D-Link AirPlus DWL-520+, Uses a TI 802.11b 22 MBPS Chip" } ,
    { 0x104C, 0x8671, "bogus", "bogus" } ,
    { 0x104C, 0x9065, "TMX320C6412", "Fixed Point Digital Signal Processor" } ,
    { 0x104C, 0x9066, "USR5410", "U.S. Robotics 802.11g Wireless Turbo PC Card " } ,
    { 0x104C, 0xA001, "TDC1570", "64-bit PCI ATM SAR" } ,
    { 0x104C, 0xA100, "TDC1561", "32-bit PCI ATM SAR" } ,
    { 0x104C, 0xA102, "TNETA1575", "HyperSAR Plus w/PCI host & UTOPIA i/f" } ,
    { 0x104C, 0XA106, "TMS320C6205", "Fixed Point Digital Signal Processor" } ,
    { 0x104C, 0xA186, "TMS320C6416T", "TI C6416T DSP" } ,
    { 0x104C, 0xa828, "PCI2050BPDV", "PCI-to-PCI Bridge" } ,
    { 0x104C, 0xAC10, "PCI1050", "PC Card Controller" } ,
    { 0x104C, 0xAC11, "PCI1030/1053", "PC Card Controller" } ,
    { 0x104C, 0xAC12, "PCI1131", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC13, "PCI9066", "Texas Instrumentsâ�ž¢ PCIxx12 Integrated FlashMedia Controller" } ,
    { 0x104C, 0xAC15, "PCI-1131", "CardBus Controller" } ,
    { 0x104C, 0xAC16, "PCI1250", "PC Card CardBus Controller" } ,
    { 0x104C, 0xAC17, "PCI1220", "CardBus Controller" } ,
    { 0x104C, 0xAC18, "PCI1260", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC19, "PCI1221", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC1A, "PCI1210", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC1B, "PCI1450", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC1C, "PCI1225", "PC Card CardBus Controller" } ,
    { 0x104C, 0xac1e, "PCI1211", "PCI To PCMCIA  bridge" } ,
    { 0x104C, 0xAC1F, "PCI1251B", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC20, "PCI2030", "PCI to PCI Bridge" } ,
    { 0x104C, 0xAC21, "PCI2031", "PCI to PCI Bridge" } ,
    { 0x104C, 0xAC22, "PCI2032", "PCI Docking Bridge" } ,
    { 0x104C, 0xAC23, "PCI2250", "PCI-to-PCI Bridge" } ,
    { 0x104C, 0xAC28, "PCI2050/2050I", "PCI-to-PCI Bridge" } ,
    { 0x104C, 0xAC30, "PCI1260", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC40, "PCI4450", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC41, "PCI4410", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC42, "PCI4451", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC43, "PCI4550", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC44, "PCI4510SDFSDFSD", "PC Card Controller SDFSDAFSADFSDAFSDAF" } ,
    { 0x104C, 0xAC46, "PCI4520", "PCCard CardBus Controller" } ,
    { 0x104C, 0xac47, "7510/4510", "Cardbus" } ,
    { 0x104C, 0xAC50, "PCI1410", "PC card cardBus Controller" } ,
    { 0x104C, 0xAC51, "PCI-1420", "Texas Instruments 1420" } ,
    { 0x104C, 0xAC52, "PCI1451", "PC card CardBus Controller" } ,
    { 0x104C, 0xAC53, "PCI1421", "PC card CardBus Controller - 5-in-1 Media Card Reader" } ,
    { 0x104C, 0xAC54, "PCI-1510", "PCCard CardBus Controller w/UltraMedia" } ,
    { 0x104C, 0xAC55, "PCI1520", "PCCard CardBus Controller" } ,
    { 0x104C, 0xAC56, "PCI1510", "PCCard CardBus Controller" } ,
    { 0x104C, 0xAC57, "PCI1530", "PCCard CardBus Controller" } ,
    { 0x104C, 0xAC58, "PCI1515", "PCCard CardBus Controller" } ,
    { 0x104C, 0xAC59, "PCI1620", "PCCard CardBus Controller w/UltraMedia" } ,
    { 0x104C, 0xAC5A, "PCI1610", "PCCard CardBus Controller w/UltraMedia" } ,
    { 0x104C, 0xac60, " 09050844", "PCI2040 PCI to DSP Bridge" } ,
    { 0x104C, 0xac8e, "PCI7420", "Generic CardBus Controller " } ,
    { 0x104C, 0xAC8F, "7420/7620", "FlashMedia" } ,
    { 0x104C, 0xB000, "TMS320C645x", "Device ID: 0xB001 " } ,
    { 0x104C, 0xB001, "TMS320DM642", "DSP with a C64x+ core and M/S PCI interface" } ,
    { 0x104C, 0xFE00, "tsb12lv26", "FireWire Host Controller" } ,
    { 0x104C, 0xFE03, "12C01A", "FireWire Host Controller" } ,
    { 0x104D, 0x011B, "RT2571WF", "USB Ralink Wireless LAN" } ,
    { 0x104D, 0x5001, "SNY5001", "Sony Firmware Extension Parser listed as ACPI&#92;SNY5001 in device manager." } ,
    { 0x104D, 0x6001, "SNY6001", "Sony Programmable I/O Control Device" } ,
    { 0x104D, 0x8009, "CXD1947", "PCI bus 9" } ,
    { 0x104D, 0x8039, "CXD3222", "OHCI i.LINK (IEEE 1394) PCI Host Ctrlr" } ,
    { 0x104D, 0x8056, "0x127a", "Rockwell HCF 56K Modem" } ,
    { 0x104D, 0x8087, "PCI\\VEN_104D&DEV_8086", "SONY MPEG ENCODER" } ,
    { 0x104D, 0x808A, "Qc pass", "Memory Stick Controller" } ,
    { 0x104E, 0x0017, "OTI-64017", "" } ,
    { 0x104E, 0x0107, "OTI107", "Spitfire VGA Accelerator" } ,
    { 0x104E, 0x0109, "", "Video Adapter" } ,
    { 0x104E, 0x0217, "OTI-64217", "" } ,
    { 0x104E, 0x0317, "OTI-64317", "" } ,
    { 0x104E, 0x0611, "OTI-610", "T9732" } ,
    { 0x104E, 0x317, "OTI107", "Spitfire VGA Accelerator" } ,
    { 0x104F, 0x104F, "iatca8262", "Multi I/O" } ,
    { 0x1050, 0x6692, "W6692/92A/92CFyr6", "PCI BusISDN S/T-Controllerry" } ,
    { 0x1050, 0x0000, "004005-34c8c8", "Ethernet Controller (NE2000 compatible)" } ,
    { 0x1050, 0x0001, "W83769F", "PCI/IDE controller" } ,
    { 0x1050, 0x0033, "W89C33", "Winbond W89C33 mPCI 802.11 Wireless LAN Adapter" } ,
    { 0x1050, 0x0105, "W82C105", "Ethernet Adapter" } ,
    { 0x1050, 0x0628, "W83628F/629D", "PCI to ISA Bridge Set" } ,
    { 0x1050, 0x0840, "W89C840F", "100/10Mbps Ethernet Controller" } ,
    { 0x1050, 0x0940, "w89c940f", "winbond pci ethernet" } ,
    { 0x1050, 0x1050, "W99200aF", "Video capture card mpeg-1" } ,
    { 0x1050, 0x5A5A, "W89C940F", "ELANC-PCI Twisted-pair Ether-LAN Ctrlr" } ,
    { 0x1050, 0x6692, "W6692CF", "PCI BusISDN S/T-Controller" } ,
    { 0x1050, 0x8481, "Unknown", "SD Host Controller" } ,
    { 0x1050, 0x9921, "W99200AF", "MPEG1 capture card" } ,
    { 0x1050, 0x9922, "W9922PF", "MPEG-1/2 Decoder" } ,
    { 0x1050, 0x9960, "W9960CF", "Video Codec" } ,
    { 0x1050, 0x9961, "W9961CF", "H.263/H.261 Video Codec" } ,
    { 0x1050, 0x9970, "W9970CF", "VGA controller" } ,
    { 0x1050, 0x9971, "W9971CF", "W9971CF" } ,
    { 0x1050, 6692, "", "" } ,
    { 0x1051, 0x0100, "Motorola MC145575", "" } ,
    { 0x1054, 0003, "06A2", "0003" } ,
    { 0x1054, 0x0001, "", "PCI Bridge" } ,
    { 0x1054, 0x0002, "pci bus", "PCI bus Cntrlr" } ,
    { 0x1054, 0x0003, "06A2", "hts547575a9e384" } ,
    { 0x1054, 0x3505, "SH7751", "SuperH (SH) 32-Bit RISC MCU/MPU Series" } ,
    { 0x1055, 0x0810, "", "EFAR 486 host Bridge" } ,
    { 0x1055, 0x0922, "", "Pentium/p54c host Bridge" } ,
    { 0x1055, 0x0926, "I don�t know pentium 133 intel   everex setpnot mx", "ISA Bridge" } ,
    { 0x1055, 0x9130, "SLC90E66", "Ultra ATA/66 IDE Controller" } ,
    { 0x1055, 0x9460, "SLC90E66", "Victory66 PCI to ISA Bridge" } ,
    { 0x1055, 0x9461, "SLC90E66", "Victory66 UDMA EIDE Controller" } ,
    { 0x1055, 0x9462, "SLC90E66", "Victory66 USB Host Controller" } ,
    { 0x1055, 0x9463, "SLC90E66", "Victory66 Power Management Controller" } ,
    { 0x1055, 0xe420, "LAN9420/LAN9420i", "PCI 10/100 Ethernet controller" } ,
    { 0x1056, 0x2001, "Divio NW700LQ. 0243CDTAA. V90479. 1", "Philips P89C51RD271BA. 1D041700A0. AeD0217G" } ,
    { 0x1057, 0*5600, "52-6116-2A", "Motorola FM 56 PCI Speakerphone Modem" } ,
    { 0x1057, 0x0001, "MPC105", "PCI Bridge / Memory Controller (PCIB/MC)" } ,
    { 0x1057, 0x0002, "MPC106", "PCI Bridge/Memory Controller (PCIB/MC)" } ,
    { 0x1057, 0x0003, "MPC8240", "Integrated Processor" } ,
    { 0x1057, 0x0004, "MPC107", "PCI Bridge/Memory Controller for PPC" } ,
    { 0x1057, 0x0006, "MPC8245", "Integrated Processor" } ,
    { 0x1057, 0x0100, "MC145575", "HCF-PCI" } ,
    { 0x1057, 0x0431, "KTI829c", "100VG Ethernet Controller" } ,
    { 0x1057, 0x1801, "DSP56301", "24-bit Digital Signal Processor" } ,
    { 0x1057, 0x1802, "DSP56305", "24-Bit Digital Signal Processor" } ,
    { 0x1057, 0x18C0, "MPC8265A/66", "PowerQUICC II PCI Bridge" } ,
    { 0x1057, 0x3052, "0644dfea15", "MotorolaSM56Modem_PCI device" } ,
    { 0x1057, 0x3055, "SM56", "Motorola SM56 Data Fax Modem " } ,
    { 0x1057, 0x3057, "HDAUDIO\\FUNC_02om&VEN_1057&DEV_3057&SUBSYS_0001000", "Modem Device on High Definition Audio Bus" } ,
    { 0x1057, 0x3410, "DSP56361", "Digital Signal Processor" } ,
    { 0x1057, 0x3421, "56IVMR/Phoenix 56ISM", "Modem" } ,
    { 0x1057, 0x4801, "Raven", "PowerPC Chipset" } ,
    { 0x1057, 0x4802, "Falcon", "memory control chipset" } ,
    { 0x1057, 0x4803, "Hawk", "" } ,
    { 0x1057, 0x4806, "CPX8216", "" } ,
    { 0x1057, 0x4809, "CPX8216T", "HotSwap Controller" } ,
    { 0x1057, 0x5600, "WDM MOT8888", "SM 56 PCI Speakerphone/Data,Fax  Modem" } ,
    { 0x1057, 0x5602, "SM56", "PCI Modem" } ,
    { 0x1057, 0x5608, "52-6116-2A 21-864-4 OR 62802-51 QZ0024 M5T90-000", "Motorola SM56 Speakerphone Modem" } ,
    { 0x1057, 0x5803, "MPC5200", "32-Bit Embedded PowerPC Processor" } ,
    { 0x1057, 0x6400, "MPC190", "Security Co-Processor" } ,
    { 0x1057, 0x9876, "1543", "3052" } ,
    { 0x105A, 0x0262, "Promise Technology", "Ultra66/FastTrak66" } ,
    { 0x105A, 0x0D30, "PDC20265/R", "MBUltra100/MBFastTrack100 Lite" } ,
    { 0x105A, 0x0D38, "PDC20263", "FastTrak66 Lite EIDE Controller" } ,
    { 0x105A, 0x105A, "DC5300", "EIDE Controller" } ,
    { 0x105A, 0x1275, "PDC20275", "MBUltra133" } ,
    { 0x105A, 0x1960, "?", "SuperTrak 66/100 RAID" } ,
    { 0x105A, 0x1962, "?", "SuperTrak SX 6000" } ,
    { 0x105A, 0x3318, "PDC20318", "SATA150 TX4" } ,
    { 0x105A, 0x3319, "PDC20319", "FastTrak S150 TX4" } ,
    { 0x105A, 0x3371, "PDC20371?", "FastTrak S150 TX2+" } ,
    { 0x105A, 0x3373, "PDC20378", "FastTrak 378/SATA 378 RAID Controller" } ,
    { 0x105A, 0x3375, "PDC20375", "SATA150 TX2+" } ,
    { 0x105A, 0x3376, "PDC20376", "FastTrak 376 Controller" } ,
    { 0x105A, 0x3515, "PDC40719", "FastTrak TX43xx" } ,
    { 0x105A, 0x3519, "PDC40519", "FastTrak TX42xx" } ,
    { 0x105A, 0x3570, "PDC20771", "FastTrak TX2300 SATA300 Controller" } ,
    { 0x105A, 0x3571, "PDC20571", "Fasttrack TX2200" } ,
    { 0x105A, 0x3574, "PDC20579", "SATAII 150 579" } ,
    { 0x105A, 0x3d17, "PDC40718-GP", "SATA 300 TX4 Controller" } ,
    { 0x105A, 0x3D18, "PDC20518/40518", "SATAII 150TX2+/SATAII150 TX4" } ,
    { 0x105A, 0x3D73, "PDC40775", "SATAII 300 TX2+" } ,
    { 0x105A, 0x3F19, "scsi", "FastTrak TX2650/4650/4652" } ,
    { 0x105A, 0x3F20, "PDC42819", "FastTrak TX2650(3F21)/4650(3F22)/PDC42819(3716)" } ,
    { 0x105A, 0x4302, "?", "SuperTrak EX 43X0" } ,
    { 0x105A, 0x4303, "?", "SuperTrak EX 4350" } ,
    { 0x105A, 0x4D30, "PDC20267", "FastTrack100 on Intel MB SE7500CW2" } ,
    { 0x105A, 0x4D33, "PDC20246", "FastTrak/Ultra33 ATA RAID controller" } ,
    { 0x105A, 0x4D38, "PDC20262", "Ultra66/FastTrak66" } ,
    { 0x105A, 0x4D68, "PDC20268/R", "Ultra100TX2/FastTrak100TX/LP" } ,
    { 0x105A, 0x4D69, "PDC20269", "Ultra133TX2" } ,
    { 0x105A, 0x5275, "PDC20276", "MBUltra133/MBFastTrak133" } ,
    { 0x105A, 0x5300, "DC5300", "EIDE Controller" } ,
    { 0x105A, 0x6268, "PDC20270", "FastTrak100 TX2/TX4/LP" } ,
    { 0x105A, 0x6269, "PDC20271", "FastTrak TX2000 EIDE controller" } ,
    { 0x105A, 0x6300, "?", "FastTrak SX 8300" } ,
    { 0x105A, 0x6301, "?", "FastTrak SX8300-1" } ,
    { 0x105A, 0x6302, "6302", "FastTrak SX 4300" } ,
    { 0x105A, 0x6303, "?", "FastTrak SX 4" } ,
    { 0x105A, 0x6304, "?", "FastTrak SX8300-2" } ,
    { 0x105A, 0x6305, "?", "FastTrak SX8300-3" } ,
    { 0x105A, 0x6306, "?", "FastTrak SX 4300-2" } ,
    { 0x105A, 0x6307, "?", "FastTrak SX 4300-3" } ,
    { 0x105A, 0x6621, "PDC 20621(?)", "FastTrak SX4000" } ,
    { 0x105A, 0x6622, "PDC 20622 (?)", "FastTrak S150SX4" } ,
    { 0x105A, 0x6629, "PDC20619", "FastTrak TX4000" } ,
    { 0x105A, 0x7250, "7250", "Vitesse 7250 SAS RAID" } ,
    { 0x105A, 0x7275, "PDC 20277", "SBUltra133/SBFastTrak 133 Lite" } ,
    { 0x105A, 0x8000, "?", "SATAII150 SX8" } ,
    { 0x105A, 0x8002, "?", "SATAII150 SX8" } ,
    { 0x105A, 0x8003, "PDC 20621", "FastTrak SX4000" } ,
    { 0x105A, 0x8004, "?", "SATAII150 SX8" } ,
    { 0x105A, 0x8006, "?", "SATAII150 SX8" } ,
    { 0x105A, 0x8350, "?", "SuperTrak EX8350/16350/8300/16300" } ,
    { 0x105A, 0x8650, "?", "SuperTrak EX SAS RAID" } ,
    { 0x105A, 0xC350, "?", "SuperTrak EX 123X0" } ,
    { 0x105A, 0xE350, "?", "SuperTrak EX 243X0" } ,
    { 0x105D, 0x2309, "Imagine 128", "GUI Accelerator" } ,
    { 0x105D, 0x2339, "I128s2", "Imagine 128 Series 2" } ,
    { 0x105D, 0x493D, "T2R", "Revolution 3D" } ,
    { 0x105D, 0x5348, "Revolution IV", "Revolution IV" } ,
    { 0x1060, 0x0001, "UM82C881", "486 Chipset" } ,
    { 0x1060, 0x0002, "UM82C886", "ISA Bridge" } ,
    { 0x1060, 0x0101, "UM8673F", "EIDE Controller" } ,
    { 0x1060, 0x0881, "UM8881", "HB4 486 PCI Chipset" } ,
    { 0x1060, 0x0886, "UM8886F", "ISA Bridge" } ,
    { 0x1060, 0x0891, "UM82C891", "Pentium CPU to PCI bridge" } ,
    { 0x1060, 0x1001, "UM886A", "IDE Cntrlr (dual function)" } ,
    { 0x1060, 0x673A, "UM8886BF", "EIDE Controller" } ,
    { 0x1060, 0x673B, "", "EIDE Master/DMA" } ,
    { 0x1060, 0x8710, "UM8710", "VGA Cntrlr" } ,
    { 0x1060, 0x8821, "21611a3b", "CPU/PCI Bridge" } ,
    { 0x1060, 0x8822, "", "PCI/ISA Bridge" } ,
    { 0x1060, 0x8851, "", "Pentium CPU/PCI Bridge" } ,
    { 0x1060, 0x8852, "LG-772", "Pentium CPU/ISA Bridge" } ,
    { 0x1060, 0x886A, "UM8886A", "ISA Bridge with EIDE" } ,
    { 0x1060, 0x8881, "UM8881F", "HB4 486 PCI Chipset" } ,
    { 0x1060, 0x8886, "UM8886", "ISA Bridge (w/o IDE support)" } ,
    { 0x1060, 0x888A, "UM8886A", "" } ,
    { 0x1060, 0x8891, "UM8891", "586 Chipset" } ,
    { 0x1060, 0x9017, "UM9017F", "Ethernet" } ,
    { 0x1060, 0x9018, "UM9018", "Ethernet" } ,
    { 0x1060, 0x9026, "UM9026", "Fast Ethernet" } ,
    { 0x1060, 0xE881, "UM8881", "486 Chipset" } ,
    { 0x1060, 0xE886, "UM8886N", "ISA Bridge w/EIDE" } ,
    { 0x1060, 0xE88A, "UM8886N", "PCI / ISA Bridge" } ,
    { 0x1060, 0xE891, "UM8891N", "um8891n" } ,
    { 0x1061, 0x0001, "AGX013/016", "GUI Accelerator" } ,
    { 0x1061, 0x0002, "IIT3104", "MPEG Decoder" } ,
    { 0x1676, 0x1001, "5.10.00.5760", "Realtek AC' 97 Audio Driver" } ,
    { 0x1065, 0x8139, "nic", "Realtek 8139C Network Card" } ,
    { 0x1066, 0x0000, "PT80C826", "VL Bridge" } ,
    { 0x1066, 0x0001, "PT86C521", "Vesuvius V1-LS System Controller" } ,
    { 0x1066, 0x0002, "PT86C523", "Vesuvius V3-LS ISA Bridge" } ,
    { 0x1066, 0x0003, "PT80C524", "Nile PCI to PCI Bridge" } ,
    { 0x1066, 0x0004, "PT80C525", "Nile-II PCI to PCI Bridge" } ,
    { 0x1066, 0x0005, "PCI\\en_14E&DEV4318_REV|02", "System Controller" } ,
    { 0x1066, 0x8002, "PT86C523", "ISA Bridge" } ,
    { 0x1067, 0x1002, "G500", "VolumePro Volume Rendering Accelerator" } ,
    { 0x1001, 0x0010, "ispLSI1032E", "PCI 1616, 16 TTL-IN, 16 TTL-OUT" } ,
    { 0x1001, 0x0011, "ispLSI1032E", "OPTO-PCI, 16 IN / 16 OUT 24 VDC" } ,
    { 0x1001, 0x0012, "ispLSI1032E", "PCI-AD, PCI-ADDA analog I/O-card" } ,
    { 0x1001, 0x0013, "ispLSI1032E", "PCI-OptoRel, PCI-Relais 16 Relais & Opto" } ,
    { 0x1001, 0x0014, "ispLSI1032E", "Timer, Pulse & Counter-card 16..32 bit" } ,
    { 0x1001, 0x0015, "ispLSI1032E", "PCI-DAC416, 4 channel D/A16bit precision" } ,
    { 0x1001, 0x0016, "ispLSI1032E", "PCI-MFB high-speed analog I/O" } ,
    { 0x1001, 0x0017, "ispLSI1032E", "PROTO-3 PCI, digital I/O with chipselect" } ,
    { 0x1001, 0x0020, "ispLSI1032E", "Universal digital I/O PCI-Interface" } ,
    { 0x1677, 0x20ad, "5ACPCI.MFIO-K01", "Profibus DP / K-Feldbus / COM" } ,
    { 0x144B, 0x0601, "", "" } ,
    { 0x1402, 0x2E00, "ME-2000/2600", "Multifunction Data Aquistion card" } ,
    { 0x1402, 0x4610, "ME-4610", "Multi-IO board (16x 16bit ADC, 32x TTL I/O)" } ,
    { 0x1402, 0x4650, "ME-4650", "Multi-IO board (16x 16bit ADC, 32x TTL I/O)" } ,
    { 0x14D4, 0x0400, "Panacom 7", "Interface chip" } ,
    { 0x1307, 0x0001, "PCI-DAS1602/16", "" } ,
    { 0x1307, 0x0006, "PCI-GPIB", "PCI 488.2" } ,
    { 0x1307, 0x000B, "PCI-DIO48H", "" } ,
    { 0x1307, 0x000C, "PCI-PDISO8", "" } ,
    { 0x1307, 0x000D, "PCI-PDISO16", "" } ,
    { 0x1307, 0x000F, "PCI-DAS1200", "" } ,
    { 0x1307, 0x0010, "PCI-DAS1602/12", "" } ,
    { 0x1307, 0x0014, "PCI-DIO24H", "24 Bit Digital Input/Output Board" } ,
    { 0x1307, 0x0015, "PCI-DIO24H/CTR3", "" } ,
    { 0x1307, 0x0016, "PCI-DIO24H/CTR16", "" } ,
    { 0x1307, 0x0017, "PCI-DIO96H", "" } ,
    { 0x1307, 0x0018, "PCI-CTR05", "" } ,
    { 0x1307, 0x0019, "PCI-DAS1200/JR", "xkbhavu" } ,
    { 0x1307, 0x001A, "PCI-DAS1001", "" } ,
    { 0x1307, 0x001B, "PCI-DAS1002", "" } ,
    { 0x1307, 0x001C, "PCI-DAS1602JR/16", "AR2425" } ,
    { 0x1307, 0x001D, "PCI-DAS6402/16", "" } ,
    { 0x1307, 0x001E, "PCI-DAS6402/12", "" } ,
    { 0x1307, 0x001F, "PCI-DAS16/M1", "" } ,
    { 0x1307, 0x0020, "PCI-DDA02/12", "" } ,
    { 0x1307, 0x0021, "PCI-DDA04/12", "" } ,
    { 0x1307, 0x0022, "PCI-DDA08/12", "" } ,
    { 0x1307, 0x0023, "PCI-DDA02/16", "" } ,
    { 0x1307, 0x0024, "PCI-DDA04/16", "" } ,
    { 0x1307, 0x0025, "PCI-DDA08/16", "" } ,
    { 0x1307, 0x0026, "PCI-DAC04/12-HS", "" } ,
    { 0x1307, 0x0027, "PCI-DAC04/16-HS", "" } ,
    { 0x1307, 0x0028, "PCI-DIO24", "24 Bit Digital Input/Output Board" } ,
    { 0x1307, 0x0029, "PCI-DAS08", "" } ,
    { 0x1307, 0x002C, "PCI-INT32", "PCI-INT32" } ,
    { 0x1307, 0x0033, "PCI-DUAL-AC5", "" } ,
    { 0x1307, 0x0034, "PCI-DAS-TC", "" } ,
    { 0x1307, 0x0035, "PCI-DAS64/M1/16", "65+6" } ,
    { 0x1307, 0x0036, "PCI-DAS64/M2/16", "Dell" } ,
    { 0x1307, 0x0037, "PCI-DAS64/M3/16", "" } ,
    { 0x1307, 0x004C, "PCI-DAS1000", "" } ,
    { 0x1307, 0x004D, "PCI-QUAD04", "" } ,
    { 0x1307, 0x0064, "PCI-CTR10", "10 channels, 16 bit counter/timer with 32-Bits of Digital I/O" } ,
    { 0x1307, 0x0361, "?", "?" } ,
    { 0x1318, 0x0911, "G-NIC II", "1000BT Network Interface Card" } ,
    { 0x1458, 0x1458, "0x29e0", "microsoft" } ,
    { 0x1458, 0x5000, "0x29e0", "GA-X48T-DQ6" } ,
    { 0x1458, 0x67B1, "0x29e0", "GA-X48T-DQ6" } ,
    { 0x1319, 0x0801, "FM0801-as", "PCI Card MediaForte made in singapore (driver - ct" } ,
    { 0x1319, 0x0802, "FM801-as", "Xwave PCI Joystick" } ,
    { 0x1319, 0x1000, "FM801-as", "PCI Audio" } ,
    { 0x1319, 0x1001, "FM801", "Joystick" } ,
    { 0x1319, 0x1319, "FM0801-as", "Xwave PCI audio controller" } ,
    { 0x1319, 0x4901, "FM801-AU", "ForteMedia PCI Audio Card" } ,
    { 0x1319, 802, "fm801-au", "PCI Audio" } ,
    { 0x1412, 0x1712, "ICE1712", "M-audio Delta 44 (http://www.m-audio.com)" } ,
    { 0x1412, 0x1724, "VT1723", "Envy24PT/HT PCI Multi-Channel Audio Controller (&#1072;&#1091;&#1076;&#1080;&#1086;&#1082;&#1086;&#1" } ,
    { 0x131F, 0x2002, "72svec", "CyberSerial 16850" } ,
    { 0x131F, 0x2011, "1655", "Siig Inc Duet 1S(16550)+1P" } ,
    { 0x131F, 0x2012, "", "Duet 1S(16850)+1P" } ,
    { 0x131F, 0x2020, "SIIG cyber8000", "Communication controller" } ,
    { 0x131F, 0x2030, "SIIG CyberSerial PCI 16C550", "SIIG Cyber Serial Dual PCI Board" } ,
    { 0x131F, 0x2042, "", "Trio 1S(16850)+2P" } ,
    { 0x131F, 0x2050, "Siig Inc CyberSerial (4-port) 16550", "Siig Inc CyberSerial (4-port) 16550" } ,
    { 0x131F, 0x2051, "", "CyberSerial 16650" } ,
    { 0x131F, 0x2052, "", "CyberSerial 16850" } ,
    { 0x131F, 0x2060, "JJ_P21022-B", "Trio 2S(16550)+1P" } ,
    { 0x131F, 0x2061, "", "Trio 2S(16650)+1P" } ,
    { 0x131F, 0x2062, "1969", "Trio 2S(16850)+1P" } ,
    { 0x131F, 0x9876, "JJ_P21022-B", "Trio 2S(16550)+1P" } ,
    { 0x1407, 0x0100, "0439", "Lava Dual Serial 550 PCI" } ,
    { 0x1407, 0x0101, "", "Lava Quattro PCI A/B" } ,
    { 0x1407, 0x0102, "", "Lava Quattro PCI C/D" } ,
    { 0x1407, 0x0110, "0110", "Lava DSerial PCI Port A" } ,
    { 0x1407, 0x0111, "nep5p", "Lava DSerial PCI Port B" } ,
    { 0x1407, 0x0180, "Lava Octopus PCI Ports ", "Lava Octopus PCI Ports 1-4" } ,
    { 0x1407, 0x0181, "", "Lava Octopus PCI Ports 5-8" } ,
    { 0x1407, 0x0200, "9923", "LavaPort Dual-650 PCI" } ,
    { 0x1407, 0x0201, "", "LavaPort Quad-650 PCI A/B" } ,
    { 0x1407, 0x0202, "", "LavaPort Quad-650 PCI C/D" } ,
    { 0x1407, 0x0220, "", "LavaPort Quad-650 PCI A/B" } ,
    { 0x1407, 0x0221, "", "LavaPort Quad-650 PCI C/D" } ,
    { 0x1407, 0x0400, "", "Lava 8255 PIO PCI" } ,
    { 0x1407, 0x0500, "P4", "Lava Single Serial 550 PCI" } ,
    { 0x1407, 0x0510, "0510", "Lava SP Serial 550 PCI" } ,
    { 0x1407, 0x0511, "", "Lava SP BIDIR Parallel PCI" } ,
    { 0x1407, 0x0520, "s", "Lava RS422 SS-PCI" } ,
    { 0x1407, 0x0600, "4-0 9253", "LavaPort 650 PCI" } ,
    { 0x1407, 0x0A00, "LavaPort PCI", "COM Port Accelerator" } ,
    { 0x1407, 0x120, "", "Lava Quattro 550 PCI A/B" } ,
    { 0x1407, 0x121, "", "Lava Quattro 550 PCI C/D" } ,
    { 0x1407, 0x520, "s", "s" } ,
    { 0x1407, 0x8000, "197B&CC_0880", "Lava Parallel" } ,
    { 0x1407, 0x8001, "", "Lava Dual Parallel port A" } ,
    { 0x1407, 0x8002, "9923", "Lava Dual Parallel port A" } ,
    { 0x1407, 0x8003, "0x00010002030C2BB0", "Lava Dual Parallel port B" } ,
    { 0x1407, 0x8800, "2003", "BOCA Research IOPPAR" } ,
    { 0x9412, 0x6565, "HT6565", "IDE Controller?" } ,
    { 0x1190, 0x2550, "TC-2550", "Single Chip Ultra (Wide) SCSI Processor" } ,
    { 0x1190, 0xC721, "", "EIDE" } ,
    { 0x1190, 0xC731, "TP-910/920/940", "PCI Ultra (Wide) SCSI Adapter" } ,
    { 0x1242, 0x1460, "JNIC-1460", "2-Gb/s Fibre Channel-PCI 64-bit 66 MHz" } ,
    { 0x1242, 0x1560, "JNIC-1560", "Dual Channel 2 Gb/s Fibre Channel-PCI-X" } ,
    { 0x1242, 0x4643, "JNI PCI 64-bit Fibrechannel", "JNI PCI 64-bit Fibrechannel (needs clone)" } ,
    { 0x14F2, 0x0001, "", "Moselle Split Bridge" } ,
    { 0x14F2, 0x0002, "", "Capilano Split Bridge" } ,
    { 0x14F2, 0x0120, "win7_rtm.090713-1257", "Merlin Split Bridge" } ,
    { 0x14F2, 0x0121, "", "PCI Parallel Port" } ,
    { 0x14F2, 0x0122, "unknown", "PCI Serial Port" } ,
    { 0x14F2, 0x0123, "6.1.7600.16385", "PCI PS/2 Keyboard Port" } ,
    { 0x14F2, 0x0124, "3103", "PCI PS/2 Mouse Port" } ,
    { 0x1308, 0x0001, "", "NetCelerator Adapter" } ,
    { 0x134D, 0x2188, "fa82537ep", "intel" } ,
    { 0x134D, 0x2189, "HSP688T", "pctel HSP56 V92 PCI Modem" } ,
    { 0x134D, 0x2486, "82537", "V.92 MDC Modem" } ,
    { 0x134D, 0x7890, "8086", "HSP56 MicroModem" } ,
    { 0x134D, 0x7891, "PCT 789T-c1", "HSP MicroModem 56" } ,
    { 0x134D, 0x7892, "PCT 789T-A", "HSP56 MicroModem" } ,
    { 0x134D, 0x7893, "S911 K017", "HSP MicroModem 56" } ,
    { 0x134D, 0x7894, "688w", "HSP MicroModem 56" } ,
    { 0x134D, 0x7895, "PCT789T", "HSP MicroModem 56" } ,
    { 0x134D, 0x7896, "pct789t-c", "HSP MicroModem 56" } ,
    { 0x134D, 0x7897, "97860963", "HSP MicroModem 56/PCT789T" } ,
    { 0x134D, 0x9714, "PCT 288-1A", "PCTEL" } ,
    { 0x134D, 0xD800, "pct388p-a", "pctel 56k modem" } ,
    { 0x134D, 8086, "hfp56", "dev" } ,
    { 0x135E, 0x0EC3, "8012e", "PCIe 8 Relay Output/8 Isolated Input Board " } ,
    { 0x135E, 0x5101, "5101", "Route 56" } ,
    { 0x135E, 0x5102, "PCI-ACB", "RS-232 synchronous card" } ,
    { 0x135E, 0x7101, "", "Single Port RS-232/422/485/520" } ,
    { 0x135E, 0x7201, " ", "Dual Port RS-232/422/485 Interface" } ,
    { 0x135E, 0x7202, "", "Dual Port RS-232 Interface" } ,
    { 0x135E, 0x7401, "", "Four Port RS-232 Interface" } ,
    { 0x135E, 0x7402, "", "Four Port RS-422/485 Interface" } ,
    { 0x135E, 0x7801, "", "Eight Port RS-232 Interface" } ,
    { 0x135E, 0x8001, "8001", "Digital I/O Adapter" } ,
    { 0x1385, 0x4100, "MA401", "802.11b Wireless Adapter" } ,
    { 0x1385, 0x4105, "", "" } ,
    { 0x1385, 0x620A, "GA620", "Toshiba" } ,
    { 0x1385, 0x622A, "GA622", "" } ,
    { 0x1385, 0x630A, "GA630", "" } ,
    { 0x1385, 0x8169, "10ec", "Gigabit Ethernet Adapter" } ,
    { 0x1385, 0x8169, "GA630", "Fast Ethernet Adapter" } ,
    { 0x1385, 0xF311, "FA311", "Fast Ethernet Adapter" } ,
    { 0x1385, 0xF312, "", "" } ,
    { 0x1389, 0x0001, "PCI1500PFB", "Intelligent fieldbus Adapter" } ,
    { 0x1389, 0x0104, "PCI-CANIO", "PCI-CANIO adapter" } ,
    { 0x1397, 0x0B4D, "HFC-8S 16B8D8S0", "ISDN HDLC FIFO Controller" } ,
    { 0x1397, 0x2BD0, "HFC-PCI A ISDN 2BDS0", "ISDN HDLC FIFO Controller" } ,
    { 0x1397, 0x8B4D, "HFC-4S ISDN 8B4D4S0", "ISDN HDLC FIFO Controller" } ,
    { 0x1397, 0xB000, "B000", "HCF-PCI card" } ,
    { 0x1397, 0xB006, "B006", "HCF-PCI card" } ,
    { 0x1397, 0xB007, "B007", "HCF-PCI card" } ,
    { 0x1397, 0xB008, "n/a", "usb webcam" } ,
    { 0x1397, 0xB009, "B009", "HCF-PCI card" } ,
    { 0x1397, 0xB00A, "B00A", "HCF-PCI card" } ,
    { 0x1397, 0xB00B, "B00B", "HCF-PCI card" } ,
    { 0x1397, 0xB00C, "B00C", "HCF-PCI card" } ,
    { 0x1397, 0xB100, "B100", "HCF-PCI card" } ,
    { 0x13C0, 0x0010, "SyncLink Adapter", "single port multiprotocol serial adapter" } ,
    { 0x13C0, 0x0020, "SyncLink SCC", "low speed single port multiprotocol serial adapter" } ,
    { 0x13C0, 0x0030, "SyncLink 4 Port Adapter", "4 port multiprotocol serial adapter" } ,
    { 0x13C0, 0x0070, "SyncLink GT Adapter", "single port multiprotocol serial adapter" } ,
    { 0x13C0, 0x0080, "SyncLink GT4 Adapter", "4 port multiprotocol serial adapter" } ,
    { 0x13C0, 0x0090, "SyncLink AC Adapter", "one port asynchronous serial adapter" } ,
    { 0x13C0, 0x00a0, "SyncLink GT2 Adapter", "2 port multiprotocol serial adapter" } ,
    { 0x13C0, 0x0210, "SyncLink Serial Adapter version 2", "single port multiprotocol serial adapter" } ,
    { 0x13C1, 0x1000, "9548qad", "ATA-RAID Controller" } ,
    { 0x13C1, 0x1001, "7000/8000 series", "ATA-133 Storage Controller" } ,
    { 0x13C1, 0x1002, "9000 series", "SATA/PATA Storage Controller" } ,
    { 0x13C1, 0x1003, "9550SX/9590SE Series", "SATA2 Raid Controller" } ,
    { 0x13C1, 0x1004, "9650SE Series", "PCI-Express SATA2 Raid Controller" } ,
    { 0x13C1, 0x1005, "9690SA Series", "PCI-Express SATA2/SAS Raid Controller" } ,
    { 0x13C1, 0x1010, "9750 Series", "PCI-Express2 SAS2/SATA2 Raid Controller" } ,
    { 0x13DF, 0x0001, "PCI56RVP", "Modem" } ,
    { 0x13F6, 0211, "pcnet ht2001 9932", "serl" } ,
    { 0x13F6, 0x00111, "520098396000734", "sound card" } ,
    { 0x13F6, 0x0100, "CMI8338/PCI C3DX", "PCI" } ,
    { 0x13F6, 0x0101, "CMI8338-031", "PCI Audio Device" } ,
    { 0x13F6, 0x0111, "0434119232", "PCI-SCCME8738LX-2" } ,
    { 0x13F6, 0x0112, "CMI-8378B/PCI-6CH", "PCI Audio Chip" } ,
    { 0x13F6, 0x0191, "PCI\\VEN_13F6&DEV_0111&REV_10", "CMI 8738 8CH Sound Card" } ,
    { 0x13F6, 0x0211, "PCI_021113F6&rev_10\\2&EBB567F&0&79", " Driver controller pci simple comunications - PCtel HSP56 Micro Modem Driver  " } ,
    { 0x13F6, 0x0300, "0x4005", "pci audio driver" } ,
    { 0x13F6, 0x111, "PCI\\VEN_13F6&DEPCI\\VEN_13F6&DEV_0511&SUBSYS_051113", "C-Media Audio Controller" } ,
    { 0x13F6, 0x8788, "CMI8788/PCI-8CH", "C-Media Oxygen HD" } ,
    { 0x13F6, 0x9876, "CMI8738", "C-Media Audio Controller" } ,
    { 0x13F6, 0x9891, "CMI8738", "C-Media Audio Controller" } ,
    { 0x1448, 0x0001, "ADAT/EDIT", "Audio Editing" } ,
    { 0x134A, 0x0001, "F01 2ASV17184.1", "Domex DMX 3191D PCI SCSI Controller" } ,
    { 0x134A, 0x0002, "", "Domex DMX3192U/3194UP SCSI Adapter" } ,
    { 0x134A, 0x3510, "DTC50C18", "scsi" } ,
    { 0x144A, 0x348A, "LPCI-3488A", "Low-profile High-Performance IEEE488 GPIB Interface Card for PCI Bus" } ,
    { 0x144A, 0x7230, "PLX PCI-9052", "PLX PCI-9052" } ,
    { 0x144A, 0x7248, "PCI-9052", "PLX PCI9052" } ,
    { 0x144A, 0x7250, "PCI-7250", "PLX PCI-9050" } ,
    { 0x144A, 0x7256, "PCI-7256", "PCI-7256 16-CH Latching Relay & 16-CH Isolated Digital Input Card" } ,
    { 0x144A, 0x7296, "PCI-7296 (PLX PCI-9052)", "96-ch digital I/O card" } ,
    { 0x144A, 0x7432, "PCI-7432", "" } ,
    { 0x144A, 0x7433, "PCI-7433", "64-ch digital Input card" } ,
    { 0x144A, 0x7434, "PCI-7434", "" } ,
    { 0x144A, 0x7841, "PCI-7841", "SJA 1000- baseddual port  CAN bus card" } ,
    { 0x144A, 0x8133, "PCI-8133", "Dell Wireless 5720 VZW Mobile Broadband Card" } ,
    { 0x144A, 0x8554, "PCI-8554", "" } ,
    { 0x144A, 0x9111, "PCI-9111", "" } ,
    { 0x144A, 0x9113, "PCI-9113", "" } ,
    { 0x144A, 0x9114, "PCI-9114", "" } ,
    { 0x1B13, 0x0001, "GeForce4 MX 440", "nVidia Corporation NV17" } ,
    { 0x145F, 0x0001, "NextMove PCI", "Multi-axis Motion Controller" } ,
    { 0x145F, 0x0002, "NextMove PCI-2", "Multi-axis Motion Controller" } ,
    { 0x148D, 0x1003, "Rockwell HCF chipset", "Creative ModemBlaster V.90 PCI DI5655" } ,
    { 0x14B3, 0x0000, "9ff-usa-a99-99-0970", "DSL NIC" } ,
    { 0x14B7, 0x0001, "Symphony 4110", "pci9052" } ,
    { 0x14B9, 0x0001, "PC4800", "werwerwerwe" } ,
    { 0x14B9, 0x0340, "", "Cisco Systems 340 PCI Wireless LAN Adptr" } ,
    { 0x14B9, 0x2500, "PC2500 DS", "Wireless PCI LAN Adapter" } ,
    { 0x14B9, 0x3100, "PC3100 FH", "Wireless PCI LAN Adapter" } ,
    { 0x14B9, 0x3101, "PC3100 FH", "Wireless PCI LAN Adapter" } ,
    { 0x14B9, 0x3500, "PC3500 FH", "Wireless PCI LAN Adapter" } ,
    { 0x14B9, 0x4500, "PC4500 DS", "Wireless PCI LAN Adapter" } ,
    { 0x14B9, 0x4800, "PC4800 DS", "Wireless PCI LAN Adapter" } ,
    { 0x14B9, 0xA504, "A504 Cisco MAC", "Cisco Aironet 350 Series Mini-PCI (MPI350)" } ,
    { 0x14B9, 0xA506, "AIR-MP21G", "802.11b/g wireless adapter" } ,
    { 0x14DB, 0x2100, "PCI IO 1S", "download drivers" } ,
    { 0x14DB, 0x2101, "PCI IO 1S-650", "" } ,
    { 0x14DB, 0x2102, "PCI IO 1S-850", "" } ,
    { 0x14DB, 0x2110, "PCI IO 1S1P", "OX16PCI952" } ,
    { 0x14DB, 0x2111, "PCI IO 1S1P-650", "" } ,
    { 0x14DB, 0x2112, "PCI IO 1S1P-850", "" } ,
    { 0x14DB, 0x2120, "TK9902", "0701 Parallel Port device" } ,
    { 0x14DB, 0x2121, "PCI IO 2P", "Avlab Technology PCI IO 2P" } ,
    { 0x14DB, 0x2130, "PCI IO 2S", "2 Port PCI Serial Card" } ,
    { 0x14DB, 0x2131, "PCI IO 2S-650", "pci serial port" } ,
    { 0x14DB, 0x2132, "PCI IO 2S-850", "" } ,
    { 0x14DB, 0x2140, "PCI IO 2P1S", "" } ,
    { 0x14DB, 0x2141, "PCI IO 2P1S-650", "" } ,
    { 0x14DB, 0x2142, "PCI IO 2P1S-850", "" } ,
    { 0x14DB, 0x2144, "PCI IO 2P2S", "" } ,
    { 0x14DB, 0x2145, "PCI IO 2P2S-650", "" } ,
    { 0x14DB, 0x2146, "PCI IO 2P2S-850", "" } ,
    { 0x14DB, 0x2150, "PCI IO 4S", "" } ,
    { 0x14DB, 0x2151, "PCI IO 4S-654", "" } ,
    { 0x14DB, 0x2152, "PCI IO 4S-850", "" } ,
    { 0x14DB, 0x2160, "PCI IO 2S1P", "" } ,
    { 0x14DB, 0x2161, "PCI IO 2S1P-650", "" } ,
    { 0x14DB, 0x2162, "PCI IO 2S1P-850", "" } ,
    { 0x14DB, 0x2180, "PCI IO 8S", "VEN_14DB&DEV_2180&SUBSYS_218014DB&REV_00" } ,
    { 0x14DB, 0x2181, "PCI IO 8S-654", "Avlab Technology Inc" } ,
    { 0x14DB, 0x2182, "PCI IO 8S-850", "Avlab Technology Inc" } ,
    { 0x14DC, 0x0000, "PCI 230", "" } ,
    { 0x14DC, 0x0001, "PCI242H", "4-port high speed RS-232" } ,
    { 0x14DC, 0x0002, "PCI244H", "8-port high speed RS-232" } ,
    { 0x14DC, 0x0003, "PCI247H", "2-port high speed RS-232" } ,
    { 0x14DC, 0x0004, "PCI248H", "2-port high speed RS-422/485" } ,
    { 0x14DC, 0x0005, "PCI249H", "2-port high speed RS-232 and RS-422/485" } ,
    { 0x14DC, 0x0006, "PCI260", "16-channel analog input (with timers)" } ,
    { 0x14DC, 0x0007, "PCI224", "16-chan 12-bit analog output (w/ timers)" } ,
    { 0x14DC, 0x0008, "PCI234", "4-chan 16-bit analog output (w/ timers)" } ,
    { 0x14DC, 0x0009, "PCI236", "24-channel digital I/O" } ,
    { 0x14DC, 0x000A, "PCI272", "72-channel digital I/O" } ,
    { 0x14DC, 0x000B, "PCI215", "48-channel digital I/O (w/ 6 timers)" } ,
    { 0x14DC, 0x000C, "PCI263", "16-channel reed relay output" } ,
    { 0x1507, 0x0001, "MPC105 Eagle", "" } ,
    { 0x1507, 0x0002, "MPC106 Grackle", "" } ,
    { 0x1507, 0x0003, "MPC8240 Kahlua", "" } ,
    { 0x1507, 0x0100, "MPC145575 HFC-PCI", "" } ,
    { 0x1507, 0x0431, "KTI829c 100VG", "" } ,
    { 0x1507, 0x4801, "Raven", "" } ,
    { 0x1507, 0x4802, "Falcon", "" } ,
    { 0x1507, 0x4803, "Hawk", "" } ,
    { 0x1507, 0x4806, "CPX8216", "" } ,
    { 0x151A, 0x1002, "PCI-1002&DEV_4341&subsys_82441033&rev_01\\", "4341" } ,
    { 0x151A, 0x1004, "PCI-1004", "" } ,
    { 0x151A, 0x1008, "PCI-1008", "" } ,
    { 0x157C, 0x8001, "Fix2000", "PCI Y2K Compliance Card" } ,
    { 0x2001, 0x3C19, "Ralink RT5370", "USB <=> Wireless N 150 Adapter" } ,
    { 0x2001, 0xF103, ".7D01", ".driver" } ,
    { 0x1592, 0x0781, "W83787IF", "Multi-IO Card" } ,
    { 0x1592, 0x0782, "W837871F", "Parallel Port Card (EPP)" } ,
    { 0x1592, 0x0783, "TC32001 PCI I/O", "Multi-IO Card" } ,
    { 0x1592, 0x0785, "907ab184740802", "Multi-IO Card" } ,
    { 0x1592, 0x0786, "Winbond w83787if", "Multi-IO Card" } ,
    { 0x1592, 0x0787, "winbond w83787if", "Multi-IO Card 2 series" } ,
    { 0x1592, 0x0788, "w837871f", "Multi-IO Card" } ,
    { 0x1592, 0x078A, "007AB192367002ND", "Multi-IO Card" } ,
    { 0x15AD, 0x0405, "9500MGS", "VMWARE SVGA II" } ,
    { 0x15AD, 0x0710, "0740", "Virtual SVGA" } ,
    { 0x15AD, 0x0720, "VMXNET", "VMware PCI Ethernet Adapter" } ,
    { 0x15AD, 0x0740, "58", "VMW5858are VMCI Bus Device" } ,
    { 0x15AD, 0x0770, "n/a", "Standard Enhanced PCI to USB Host Controller" } ,
    { 0x15AD, 0x0778, "0778", "Sabrent USB-to-Parallel Adapter" } ,
    { 0x15AD, 0x07B0, "VMXNET 3", "VMware vSphere 4 PCI Ethernet Adapter" } ,
    { 0x15AD, 0x0801, "n/a", "PCI Memory Controller" } ,
    { 0x15AD, 0x1975, "N/A", "High Definition Audio Codec" } ,
    { 0x15AD, 0x1977, "N/A", "High Definition Audio Controller" } ,
    { 0x15DC, 0x0001, "Argus 300", "PCI Cryptography Module" } ,
    { 0x3388, 0x0020, "HB2/HB6", "Universal PCI-PCI Bridge (transparent mode)" } ,
    { 0x3388, 0x0021, "HB1 pci-pci 0304", "ZS095A0" } ,
    { 0x3388, 0x0022, "HB1  0304", "PCI-PCI Bridge" } ,
    { 0x3388, 0x0026, "PCI6154BB", "Universal PCI-PCI Bridge (transparent mode)" } ,
    { 0x3388, 0x0028, "HB8", "Dual Mode PCI-X-to-PCI-X Bridge (transparent mode)" } ,
    { 0x3388, 0x0029, "HB8", "Dual Mode PCI-X-to-PCI-X Bridge (non-transparent mode)" } ,
    { 0x3388, 0x0030, "HB7", "Transparent PCI-X-to-PCI-X Bridge" } ,
    { 0x3388, 0x0031, "PCI 6156", "Synchronous 32-Bit, 33 MHz PCI-to-PCI Bridge for Video Capture Applications" } ,
    { 0x3388, 0x8011, "II", "CPU to PCI Bridge" } ,
    { 0x3388, 0x8012, "cmi 8330", "PCI to ISA Bridge" } ,
    { 0x3388, 0x8013, "PLX Registration Record Management", "EIDE Controller" } ,
    { 0x4D51, 0x0200, "MQ-200", "" } ,
    { 0x5053, 0x2010, "14441", "Daytona Audio Adapter" } ,
    { 0x2646, 0x0001, "12333", "22323" } ,
    { 0x2646, 0x2646, "6.06324", "22323" } ,
    { 0x5555, 0x0003, "VPI General Digital Video Component", "Digital Video OEM computer module" } ,
    { 0x6666, 0x0001, "815", "PCCOM4" } ,
    { 0x6666, 0x0002, "", "PCCOM8" } ,
    { 0x0033, 0x002F, "MAIAM", "Spitfire VGA Accelerator" } ,
    { 0x0033, 0x00333, "OTI107", "Spitfire VGA Accelerator" } ,
    { 0x12FC, 0x5cec, "PCI-488 GPIB", "IEEE 488" } ,
    { 0x1304, 0x0004, "PTX SAm FPGA", "PTX SAM FPGA" } ,
    { 0x130B, 0x130b, "0x9876", "0x9876" } ,
    { 0x1310, 0x0003, "9060", "CompactPCI Interface" } ,
    { 0x1310, 0x000D, "", "FPGA PCI Bridge" } ,
    { 0x1317, 0x0531, "nm0403A03461H121S122P", "ADMtek AN986" } ,
    { 0x1317, 0x0981, "AN981", "FastNIC 10/100 Fast Ethernet Adapter" } ,
    { 0x1317, 0x0985, "an983B", "Linksys LNE 100TX Fast Ethernet Adapter(LNE100TX v4)" } ,
    { 0x1317, 0x1985, "AN985", "CardBus 10/100 Fast Ethernet&#1050;&#1086;&#1085;&#1090;&#1088;&#1086;&#1083;&#1083;&#1077;&#1088;" } ,
    { 0x1317, 0x2850, "016", "HSP56 MicroModem" } ,
    { 0x1317, 0x5120, "ADM5120", "ADMtek ADM5120 SOC (rev: 0)" } ,
    { 0x1317, 0x7892, "PCT 789T-A", "HSP56 MicroModem" } ,
    { 0x1317, 0x8201, "ADM8211", "802.11b Wireless PCI Card" } ,
    { 0x1317, 0x9511, "ADM9511", "PCI 10/100 Fast Ethernet Adapter" } ,
    { 0x1317, 0x9513, "ADM9513", "PCI 10/100 Fast Ethernet Adapter" } ,
    { 0x1317, 8201, "13d1", "1317" } ,
    { 0x133D, 0x1000, "SST-5136-PFB-PCI", "Industrial I/O Card" } ,
    { 0x1344, 0x3240, "", "CopperHead CopperTail SC1 AMC AC97" } ,
    { 0x1344, 0x3320, "MT8LLN21PADF", "North Bridge" } ,
    { 0x1344, 0x3321, "21PAD", "North Bridge" } ,
    { 0x1344, 0x3470, "MT7LLN22NCNE", "South Bridge" } ,
    { 0x1344, 0x4020, "123", "CopperHead CopperTail SC1 IDE Controller4" } ,
    { 0x1344, 0x4030, "", "CopperHead CopperTail SC1 USB Controller" } ,
    { 0x135A, 0x0042, "16550", "4-port RS-232" } ,
    { 0x135A, 0x0181, "16550", "PCI LPT and RS-232" } ,
    { 0x135A, 0x0224, "PLX9050", "PLX PCI Bus Logic" } ,
    { 0x135A, 0x0228, "f97260118", "pq100akj9737" } ,
    { 0x1375, 0x2571, "NA", "NA" } ,
    { 0x416C, 0x0100, "AlladinCARD", "Puerto paralelo PCI" } ,
    { 0x416C, 0x0200, "CPC", "" } ,
    { 0x137A, 0x0001, "", "" } ,
    { 0x137A, 0x0003, "PCI-424 Original", "PCI-424 Original" } ,
    { 0x137A, 0x0004, "PCI-424 X", "PCI-424 X" } ,
    { 0x137A, 0x0005, "PCIe-424", "PCIe-424" } ,
    { 0x1387, 0x4640, "-none-", "sl240" } ,
    { 0x1387, 0x5310, "N/A", "SCRAMNet GT200" } ,
    { 0x1393, 0x1010, "", "" } ,
    { 0x1393, 0x1020, "", "" } ,
    { 0x1393, 0x1022, "unknown", "unknown" } ,
    { 0x1393, 0x1040, "C104H/PCI", "SmartIo" } ,
    { 0x1393, 0x1041, "CP104U series", "" } ,
    { 0x1393, 0x1042, "", "" } ,
    { 0x1393, 0x1140, "", "" } ,
    { 0x1393, 0x1141, "", "" } ,
    { 0x1393, 0x1320, "CP-132", "Industio" } ,
    { 0x1393, 0x1321, "", "" } ,
    { 0x1393, 0x1340, "CP--134U-I-DB9 V2.3 UPCI Board", "UniversalPCI board, 4 ports RS-422/485 with Isolation DB9M" } ,
    { 0x1393, 0x1401, "", "" } ,
    { 0x1393, 0x1680, "C168H/PCI", "Smartio" } ,
    { 0x1393, 0x1681, "CP-168U", "CP-168U Smart Serial Board" } ,
    { 0x1393, 0x2040, "CP-204J", "Intellio" } ,
    { 0x1393, 0x2180, "C218", "Intellio Turbo PCI" } ,
    { 0x1393, 0x2210, "---", "---" } ,
    { 0x1393, 0x2240, "---", "---" } ,
    { 0x1393, 0x3200, "C320", "Intellio Turbo PCI" } ,
    { 0x1393, 0x5020, "e400", "" } ,
    { 0x1393, 0x6800, "0x0000", "dvr capture card" } ,
    { 0x139A, 0x0007, "SES2000", "Alacritech iSCSI Controller" } ,
    { 0x13A7, 0x6240, "Network Controller", "BSRV2-301A" } ,
    { 0x13A8, 0x0152, "XR17C152", "Dual UART" } ,
    { 0x13A8, 0x0154, "XR17C154", "Four Channel PCI Bus UART" } ,
    { 0x13A8, 0x0158, "XR17C158", "Eight Channel PCI Bus UART (5V)" } ,
    { 0x13A8, 0x0354, "XR17V354", "High Performance Quad PCI Express UART" } ,
    { 0x13A8, 0x0358, "XR17V358", "High Performance Octal PCI Express UART" } ,
    { 0x4C53, 0x0000, "PLUSTEST", "Diagnostics Device" } ,
    { 0x4C53, 0x0001, "pustest", "Diagnostics Device" } ,
    { 0x13B6, 0x13b6, "S/N 26296347", "sguiu" } ,
    { 0x13C7, 0x0ADC, "", "Multi-Function Analogue/Digital IO card" } ,
    { 0x13C7, 0x0B10, ".", "Parallel I/O Card" } ,
    { 0x13C7, 0x0D10, ".", "Digital I/O Card" } ,
    { 0x13C7, 0x5744, ".", "Watchdog Card" } ,
    { 0x13D0, 0x2103, "T228502", "B2C2 Sky2PC Core Chip sky star 2 <technisat>" } ,
    { 0x13D0, 0x2200, "", "" } ,
    { 0x13D1, 0xAB02, "", "PCMCIA 10/100 mbps Ethernet Adapter" } ,
    { 0x13D1, 0xAB03, "", "" } ,
    { 0x13D1, 0xAB06, "FE2000VX", "CardBus /Atelco Fibreline Ethernet Adptr" } ,
    { 0x13D1, 0xAB08, "SMC8035TX", "EZ Card� 10/100 Fast Ethernet CardBus Adapter" } ,
    { 0x13D7, 0x0205, "6208", "toshiba" } ,
    { 0x13D7, 0x8086, "6205", "toshiba" } ,
    { 0x13D8, 0x1000, "XQ11800FP", "XaQti 1000Mbit/sec Gbit Ethernet Controller" } ,
    { 0x106B, 0x0001, "Bandit", "PowerPC Host-PCI Bridge" } ,
    { 0x106B, 0x0002, "Grand Central", "I/O Controller" } ,
    { 0x106B, 0x0003, "Control Video", "" } ,
    { 0x106B, 0x0004, "PlanB", "Video-in" } ,
    { 0x106B, 0x0007, "OHare", "I/O Controller" } ,
    { 0x106B, 0x0009, "BCM5703X", "BCM5703X" } ,
    { 0x106B, 0x000C, "", "" } ,
    { 0x106B, 0x000E, "Hydra", "Mac I/O Controller" } ,
    { 0x106B, 0x0010, "Heathrow", "Mac I/O Controller" } ,
    { 0x106B, 0x0017, "Paddington", "Mac I/O Controller" } ,
    { 0x106B, 0x0018, "UniNorth", "FireWire Controller" } ,
    { 0x106B, 0x001F, "UniNorth", "Host-PCI bridge" } ,
    { 0x106B, 0x0020, "UniNorth", "AGP interface" } ,
    { 0x106B, 0x0026, "Pangea", "USB Interface" } ,
    { 0x106B, 0x0027, "Pangea", "AGP interface" } ,
    { 0x106B, 0x002D, "UniNorth 1.5", "AGP Bridge" } ,
    { 0x106B, 0x002E, "UniNorth 1.5", "PCI Bridge" } ,
    { 0x106B, 0x002F, "UniNorth 1.5", "Internal PCI" } ,
    { 0x106B, 0x0030, "UniNorth/Pangea", "FireWire Controller" } ,
    { 0x106B, 0x003B, "Intrepid", "Integrated ATA Controller" } ,
    { 0x106B, 0x004f, "Shasta", "Mac I/O controler" } ,
    { 0x106B, 0x0050, "Shasta", "IDE controler" } ,
    { 0x106B, 0x0051, "Shasta", "Sungem ethernet controler" } ,
    { 0x106B, 0x0052, "Shasta", "Firewire controler" } ,
    { 0x106B, 0x0053, "Shasta", "PCI Bridge" } ,
    { 0x106B, 0x0054, "Shasta", "PCI Bridge" } ,
    { 0x106B, 0x0055, "Shasta", "PCI Bridge" } ,
    { 0x106B, 0x0058, "U3L", "AGP Bridge" } ,
    { 0x106B, 0x008A, "Apple RAID Controller", "Mac Pro RAID Card" } ,
    { 0x106B, 0x008C, "BCM4321 802.11a/b/g/n", "AirPort Extreme" } ,
    { 0x106C, 0x8801, "", "Dual Pentium ISA/PCI Motherboard" } ,
    { 0x106C, 0x8802, "P54C Tr8", "PowerPC ISA/PCI Motherboard" } ,
    { 0x106C, 0x8803, "", "Dual Window Graphics Accelerator" } ,
    { 0x106C, 0x8804, "ht019a", "PCI LAN Controller" } ,
    { 0x106C, 0x8805, "00b", "100-BaseT LAN Controller" } ,
    { 0x106E, 0x4362, "88E8053", "Yukon PCI-E Gigabit Ethernet Controller (copper)" } ,
    { 0x1657, 0x0646, "BRE040", "Brocade 400 series PCIe HBA" } ,
    { 0x5136, 0x4678, "12363383", "S S Technologies" } ,
    { 0x1073, 0x0001, "", "3D graphics Cntrlr" } ,
    { 0x1073, 0x0002, "YGV615", "RPA3 3D-Graphics Controller" } ,
    { 0x1073, 0x0003, "00011179", "" } ,
    { 0x1073, 0x0004, "YMF754B DS-1S Audio", "PCI Audio Controller" } ,
    { 0x1073, 0x0005, "DS1", "DS1 Audio" } ,
    { 0x1073, 0x0006, "DS1", "DS1 Audio" } ,
    { 0x1073, 0x0008, "DS1", "DS1 Audio" } ,
    { 0x1073, 0x000A, "YMF740", "DS-1L PCI Audio Controller" } ,
    { 0x1073, 0x000C, "YMF740C", "DS-1L PCI audio controller" } ,
    { 0x1073, 0x000D, "YMF724F", "YamahaDS1 native audio " } ,
    { 0x1073, 0x0010, "YMF744B-V", "DS-1 PCI audio controller" } ,
    { 0x1073, 0x0012, "YMF754B", "DS-1E PCI Audio Controller" } ,
    { 0x1073, 0x0020, "744", "DS-1 Audio" } ,
    { 0x1073, 0x1000, "SW1000XG", "Sound system" } ,
    { 0x1073, 0x2000, "DS2416", "Digital Mixing Card" } ,
    { 0x1073, 0x9876, "ymf724b-v9941", "yamaha" } ,
    { 0x1074, 0x4E78, "82C500/1", "Nx586 Chipset" } ,
    { 0x1077, 0x1016, "ISP10160", "Single Channel Ultra3 SCSI Processor" } ,
    { 0x1077, 0x1020, "ISP093a/2460", "Fast-wide SCSI - Sparc PCI" } ,
    { 0x1077, 0x1022, "ISP1022A", "Fast-wide SCSI" } ,
    { 0x1077, 0x1080, "ISP1080", "SCSI Host Adapter" } ,
    { 0x1077, 0x1216, "ISP12160", "Dual Channel Ultra3 SCSI Processor" } ,
    { 0x1077, 0x1240, "ISP1240", "SCSI Host Adapter" } ,
    { 0x1077, 0x1280, "ISP1280", "SCSI Host Adapter" } ,
    { 0x1077, 0x2020, "ISP2020A", "Fast!SCSI Basic Adapter" } ,
    { 0x1077, 0x2100, "ISP2100", "64-bit Fibre Channel Adapter" } ,
    { 0x1077, 0x2200, "ISP2200", "PCI Fibre Channel Adapter" } ,
    { 0x1077, 0x2300, "ISP 2300", "64-bit PCI FC-AL Adapter" } ,
    { 0x1077, 0x2312, "ISP 2312", "Fibre Channel Adapter" } ,
    { 0x1077, 0x2422, "ISP2422", "QLogic PCI to Fibre Channel Host Adapter for QLA2460" } ,
    { 0x1077, 0x2432, "ISP2432", "4Gb PCI Single/Dual Fibre Channel HBA" } ,
    { 0x1077, 0x2532, "ISP2532", "8Gb PCIe x8 Single/Dual Fibre Channel HBA" } ,
    { 0x1077, 0x3010, "n/a", "n/a" } ,
    { 0x1077, 0x3032, "ISP4032", "QLOGIC Dual Port 1GBPS PCI-E HBA" } ,
    { 0x1077, 0x4000, "", "" } ,
    { 0x1077, 0x4010, "", "" } ,
    { 0x1077, 0x6312, "SP202", "Qlogic FC-HBA QLA200" } ,
    { 0x1077, 0x6422, "EP2422", "4-Gbps Fibre Channel to PCI-X 2.0 266MHz controller for Embedded Applications" } ,
    { 0x1077, 0x6432, "EP2432", "4-Gbps Fibre Channel to PCIe controller for Embedded Applications" } ,
    { 0x1077, 0x8000, "8142", "QLE8142 QLogic PCI Express to 10 GbE Dual Channel CNA" } ,
    { 0x1077, 0x8001, "8142", "QLE8142 QLogic PCI Express to 10 GbE Dual Channel CNA (FCoE)" } ,
    { 0x1077, 0x8020, "8242", "QLogic Dual Port 10 Gigabit Ethernet CNA" } ,
    { 0x1077, 0x8021, "8242", "QLogic [FCoE] Adapter" } ,
    { 0x1077, 0x8022, "ISP8242", "QLE8142 QLogic PCI Express to 10 GbE Dual Channel CNA (iSCSI)" } ,
    { 0x1078, 0x0000, "Cx5520", "ISA Bridge" } ,
    { 0x1078, 0x0001, "MediaGXm", "Cyrix Integrated CPU" } ,
    { 0x1078, 0x0002, "Cx5520", "ISA Bridge" } ,
    { 0x1078, 0x0100, "Cx5530", "ISA bridge" } ,
    { 0x1078, 0x0101, "Cx5530", "SMI status and ACPI timer" } ,
    { 0x1078, 0x0102, "Cx5530", "IDE Controller" } ,
    { 0x1078, 0x0103, "Cx5530", "XpressAUDIO" } ,
    { 0x1078, 0x0104, "Cx5530", "Video Controller" } ,
    { 0x1078, 0x0400, "ZFMicro", "CPU to PCI Bridge" } ,
    { 0x1078, 0x0401, "ZFMicro", "Power Management Controller" } ,
    { 0x1078, 0x0402, "ZFMicro", "IDE Controller" } ,
    { 0x1078, 0x0403, "ZFMicro", "Expansion Bus" } ,
    { 0x1079, 0x0d01, "", "" } ,
    { 0x544C, 0x0350, "00212673158479", "IAM" } ,
    { 0x107D, 0x0000, "P86C850", "Graphic GLU-Logic" } ,
    { 0x107E, 0x0001, "FLIPPER", "FRED Local Bus I/F to PCI Peripheral" } ,
    { 0x107E, 0x0002, "", "100 vg anylan Cntrlr" } ,
    { 0x107E, 0x0004, "5526", "Fibre Channel Host Adapter" } ,
    { 0x107E, 0x0005, "x526", "Fibre Channel Host Adapter" } ,
    { 0x107E, 0x0008, "4575/5525/5575/6575", "(i)chipSAR+ 155 MBit ATM controller" } ,
    { 0x107E, 0x9003, "5535-4P-BRI-ST", "" } ,
    { 0x107E, 0x9007, "5535-4P-BRI-U", "" } ,
    { 0x107E, 0x9008, "5535-1P-SR", "" } ,
    { 0x107E, 0x900C, "5535-1P-SR-ST", "" } ,
    { 0x107E, 0x900E, "5535-1P-SR-U", "" } ,
    { 0x107E, 0x9011, "5535-1P-PRI", "" } ,
    { 0x107E, 0x9013, "5535-2P-PRI", "" } ,
    { 0x107E, 0x9023, "5535-4P-BRI-ST", "" } ,
    { 0x107E, 0x9027, "5536-4P-BRI-U", "" } ,
    { 0x107E, 0x9031, "5535-1P-PRI", "" } ,
    { 0x107E, 0x9033, "5536-2P-PRI", "Adapter" } ,
    { 0x107E, 0x9060, "6535", "CompactPCI T1/E1/J1Communications Ctrlr" } ,
    { 0x107E, 0x9070, "4538", "PMC T1/E1/J1 Communications Controller" } ,
    { 0x107E, 0x9080, "4532-002/005", "PMC ATM Over OC-3/STM-1 Comm Controller" } ,
    { 0x107E, 0x9081, "4532-001/004", "PMC ATM Over OC-3/STM-1 Comm Controller" } ,
    { 0x107E, 0x9082, "4532-000/003", "PMC ATM Over OC-3/STM-1 Comm Controller" } ,
    { 0x107E, 0x9090, "107", "PMC ATM Over T3/E3 Communications Ctrlr" } ,
    { 0x107E, 0x90A0, "4539", "PMC Quad T1/E1/J1 Communications Ctrlr" } ,
    { 0x107F, 0x0802, "mb87j3560", "pinacale capture card" } ,
    { 0x107F, 0x0803, "", "EIDE Bus Master Controller" } ,
    { 0x107F, 0x0806, "", "EIDE Controller" } ,
    { 0x107F, 0x2015, "", "EIDE Controller" } ,
    { 0x1080, 0x0600, "82C596/9", "CPU to PCI & PCI to ISA Bridge" } ,
    { 0x1080, 0xC691, "Cypress CY7c68001", "AN2131QC 0230" } ,
    { 0x1080, 0xC693, "82C693", "PCI to ISA Bridge" } ,
    { 0x1081, 0x0D47, "2330", "Radius PCI to NuBUS Bridge" } ,
    { 0x1083, 0x0001, "FR710", "PCI Enhanced IDE Adapter" } ,
    { 0x1083, 0x0613, "", "PCI" } ,
    { 0x1085, 0x0001, "UsbDgn", "Datalaster Interface for OBD automotive" } ,
    { 0x1087, 0x9200, "", "" } ,
    { 0x1089, 0x5555, "3059", "3249" } ,
    { 0x108A, 0x0001, "Model 617", "PCI-VME Bus Adapter" } ,
    { 0x108A, 0x0003, "Model 616", "PCI to VME Bridge" } ,
    { 0x108A, 0x0010, "Model 618", "VME Bridge" } ,
    { 0x108A, 0x0040, "dataBLIZZARD", "" } ,
    { 0x108A, 0x3000, "Model 2106", "VME Bridge" } ,
    { 0x108D, 0x0001, "OC-3136/37", "Token-Ring 16/4 PCI Adapter" } ,
    { 0x108D, 0x0002, "OC-3139f", "Fastload 16/4 PCI/III Token Ring Adapter" } ,
    { 0x108D, 0x0004, "OC-3139/40", "RapidFire Token Ring 16/4 Adapter" } ,
    { 0x108D, 0x0005, "OC-3250", "GoCard Token Ring 16/4 Adapter" } ,
    { 0x108D, 0x0006, "OC-3530", "RapidFire Token Ring 100 Adapter" } ,
    { 0x108D, 0x0007, "OC-3141", "RapidFire Token Ring 16/4 Adapter" } ,
    { 0x108D, 0x0008, "OC-3540", "RapidFire HSTR 100/16/4 Adapter" } ,
    { 0x108D, 0x000A, "OC-3150", "RapidFire Token-Ring 16/4 PCI Adapter" } ,
    { 0x108D, 0x0011, "OC-2805", "Ethernet Controller" } ,
    { 0x108D, 0x0012, "OC-2325", "Ethernet PCI/II 10/100 Controller" } ,
    { 0x108D, 0x0013, "OC-2183/85", "PCI/II Ethernet Controller" } ,
    { 0x108D, 0x0014, "OC-2326", "Ethernet PCI/II 10/100 Controller" } ,
    { 0x108D, 0x0019, "PCI/VEN_8086&DEV_1039&SUBSYS_02671014&REV_81\\4&252", "10/100 Ethernet Controller" } ,
    { 0x108D, 0x0021, "OC-6151/52", "155 Mbit ATM Adapter" } ,
    { 0x108D, 0x0022, "", "ATM Adapter" } ,
    { 0x108E, 0x0001, "SPARC EBUS", "" } ,
    { 0x108E, 0x1000, "PCIO", "PCI Input/Output Controller" } ,
    { 0x108E, 0x1001, "PCIO", "Happy Meal Ethernet" } ,
    { 0x108E, 0x1100, "RIO EBUS", "" } ,
    { 0x108E, 0x1101, "RIO GEM", "" } ,
    { 0x108E, 0x1102, "RIO 1394", "" } ,
    { 0x108E, 0x1103, "RIO USB", "" } ,
    { 0x108E, 0x2BAD, "GEM", "Sun Gigabit Ethernet Card" } ,
    { 0x108E, 0x5000, "SME2411", "UltraSPARC-IIi Advanced PCI Bridge" } ,
    { 0x108E, 0x5043, "SunPCI", "Co-processor" } ,
    { 0x108E, 0x7063, "SunPCi", "PCI card with Intel or AMD processor" } ,
    { 0x108E, 0x8000, "STP2223BGA", "UPA to PCI Interface (UPA)" } ,
    { 0x108E, 0x8001, "Schizo", "PCI Bus Module" } ,
    { 0x108E, 0xA000, "UltraSPARC IIi", "Sabre" } ,
    { 0x108E, 0xA001, "UltraSPARC IIe", "Hummingbird" } ,
    { 0x108E, 0xabba, "CE (Cassini Ethernet)", "10/100/1000 Ethernet adapter" } ,
    { 0x1091, 0x0020, "1091", "3D Graphics Processor" } ,
    { 0x1091, 0x0021, "", "3D graphics processor w/texturing" } ,
    { 0x1091, 0x0040, "", "3D graphics frame buffer" } ,
    { 0x1091, 0x0041, "", "3D graphics frame buffer" } ,
    { 0x1091, 0x0060, "", "Proprietary bus Bridge" } ,
    { 0x1091, 0x00E4, "Powerstorm 4D50T", "" } ,
    { 0x1091, 0x0720, "", "Motion JPEG Codec" } ,
    { 0x1092, 0x00A0, "SpeedStar Pro SE", "GUI Accelerator" } ,
    { 0x1092, 0x00A8, "SpeedStar 64", "GUI Accelerator" } ,
    { 0x1092, 0x0550, "Viper V550", "" } ,
    { 0x1092, 0x08D4, "Supra 2260", "WinModem" } ,
    { 0x1092, 0x094C, "SupraExpress 56i Pro", "SupraExpress 56i Pro" } ,
    { 0x1092, 0x09C8, "SUP2761", "SupraExpress 56i Pro VCC" } ,
    { 0x1092, 0x1002, "R6793-12", "RS56-pci" } ,
    { 0x1092, 0x1092, "Viper V330", "2710a" } ,
    { 0x1092, 0x6120, "Maximum", "DVD" } ,
    { 0x1092, 0x8810, "Stealth SE", "GUI Accelerator" } ,
    { 0x1092, 0x8811, "Stealth 64/SE", "GUI Accelerator" } ,
    { 0x1092, 0x8880, "Stealth Video", "" } ,
    { 0x1092, 0x8881, "Stealth Video", "GUI Accelerator" } ,
    { 0x1092, 0x88B0, "Stealth 64 Video", "GUI Accelerator" } ,
    { 0x1092, 0x88B1, "Stealth 64 Video", "GUI Accelerator" } ,
    { 0x1092, 0x88C0, "Stealth 64", "GUI Accelerator" } ,
    { 0x1092, 0x88C1, "Stealth 64", "GUI Accelerator" } ,
    { 0x1092, 0x88D0, "Stealth 64", "GUI Accelerator" } ,
    { 0x1092, 0x88D1, "Stealth 64", "GUI Accelerator" } ,
    { 0x1092, 0x88F0, "Stealth 64 Video", "GUI Accelerator" } ,
    { 0x1092, 0x88F1, "Stealth 64 Video", "GUI Accelerator" } ,
    { 0x1092, 0x9876, "", "Supra Express 56i Pro CW #2" } ,
    { 0x1092, 0x9999, "Monster Sound", "Diamand Technology DT0398" } ,
    { 0x1093, 0x0160, "PCI-DIO-96", "data adquisition input and output" } ,
    { 0x1093, 0x0161, "PCI-1200", "Multifunction data acquisition board" } ,
    { 0x1093, 0x0162, "PCI-MIO-16XE-50", "24MIO  6-03-2" } ,
    { 0x1093, 0x1150, "PCI-DIO-32HS", "High Speed Digital I/O Board" } ,
    { 0x1093, 0x1170, "PCI-MIO-16XE-10", "" } ,
    { 0x1093, 0x1180, "PCI-VEN-1180 ", "base system device" } ,
    { 0x1093, 0x1190, "PCI-MIO-16E-4", "" } ,
    { 0x1093, 0x11B0, "", "" } ,
    { 0x1093, 0x11C0, "", "" } ,
    { 0x1093, 0x11D0, "", "" } ,
    { 0x1093, 0x11E0, "", "" } ,
    { 0x1093, 0x1270, "PCI-6032E", "Multifunction Data Acquisition Card" } ,
    { 0x1093, 0x12b0, "PCI-6534", "High Speed DIO" } ,
    { 0x1093, 0x1310, "PCI-6602", "Data Acquisition Device" } ,
    { 0x1093, 0x1320, "", "" } ,
    { 0x1093, 0x1330, "PCI-6031E", "" } ,
    { 0x1093, 0x1340, "PCI-6033E", "Multifunction Data Acquisition Card" } ,
    { 0x1093, 0x1350, "PCI-6071E", " NI PCI-6071E Multifunction I/O & NI-DAQ" } ,
    { 0x1093, 0x1360, "", "" } ,
    { 0x1093, 0x14e0, "PCI611X", "PCI611X" } ,
    { 0x1093, 0x17D0, "PCI-6503", "" } ,
    { 0x1093, 0x18B0, "", "" } ,
    { 0x1093, 0x28b0, "NI 6014", "I/O Terminal NI-DAQ (Legacy) and NI-DAQmx" } ,
    { 0x1093, 0x2A60, "PCI-6023E", "" } ,
    { 0x1093, 0x2A70, "PCI-6024E", "Multifunction Data Acquisition Card" } ,
    { 0x1093, 0x2A80, "PCI-6025E", "Multifunction Data Acquisition Card" } ,
    { 0x1093, 0x2B20, "PCI-6527", "" } ,
    { 0x1093, 0x2C80, "PCI-6035E", "" } ,
    { 0x1093, 0x2CA0, "", "PCI-6034E" } ,
    { 0x1093, 0x702C, "NI PXI-7831R", "NI FPGA Modul" } ,
    { 0x1093, 0x70af, "PCI-6221", "16-Bit, 250 kS/s, 16 Analog Inputs" } ,
    { 0x1093, 0x70b8, "NI PCI-6251", "Multifunction DAQ Device" } ,
    { 0x1093, 0x70E3, "1", "NI PXI-8431/8 (RS485/RS422)" } ,
    { 0x1093, 0x70E4, "70E41093", "NI PCI-8430/8 (RS-232) Interface" } ,
    { 0x1093, 0x710e, "PCIe-GPIB", "GPIB Controller Interface Board" } ,
    { 0x1093, 0x7146, "NI-PCI-6132", "NI-PCI-6132" } ,
    { 0x1093, 0x71BC, "PCI-6221 ", "16-Bit, 250 kS/s, 16 Analog Inputs  (DSUB37)" } ,
    { 0x1093, 0x7414, "PCIe-GPIB+", "NI PCIe-GPIB+ GPIB with analyzer" } ,
    { 0x1093, 0xB001, "IMAQ-PCI-1408", "" } ,
    { 0x1093, 0xB011, "IMAQ-PXI-1408", "" } ,
    { 0x1093, 0xB021, "IMAQ-PCI-1424", "" } ,
    { 0x1093, 0xB031, "IMAQ-PCI-1413", "" } ,
    { 0x1093, 0xB041, "IMAQ-PCI-1407", "1pcs" } ,
    { 0x1093, 0xB051, "IMAQ-PXI-1407", "" } ,
    { 0x1093, 0xB061, "IMAQ-PCI-1411", "" } ,
    { 0x1093, 0xB071, "IMAQ-PCI-1422", "IMAQ-PCI-1422" } ,
    { 0x1093, 0xB081, "IMAQ-PXI-1422", "" } ,
    { 0x1093, 0xB091, "IMAQ-PXI-1411", "bluethooth" } ,
    { 0x1093, 0xC4C4, "NI PCIe-1433", "NI PCIe-1433 extended (deca) Camera Link frame grabber" } ,
    { 0x1093, 0xC801, "PCI-GPIB", "GPIB Controller Interface Board" } ,
    { 0x1093, 0xC811, "", "" } ,
    { 0x1093, 0xC821, "", "" } ,
    { 0x1093, 0xC831, "TNT5002", "PCI-GPIB" } ,
    { 0x1093, 0xC840, "", "" } ,
    { 0x1093, 0xd130, "PCI-232/2", "2-port RS-232 Serial Interface Board" } ,
    { 0x1095, 0x0240, "SIL3112", "SATA/Raid controller(2XSATA150)" } ,
    { 0x1095, 0x0242, "SIL3132", "SATAII/Raid controller" } ,
    { 0x1095, 0x0244, "SIL3132", "eSATA/Raid controller" } ,
    { 0x1095, 0x0640, "PCI0640A/B", "EIDE Ctrlr" } ,
    { 0x1095, 0x0641, "pci0640", "pci eide adapter with raid 1" } ,
    { 0x1095, 0x0642, "PCI0642", "IDE Cntrlr w/RAID 1" } ,
    { 0x1095, 0x0643, "PCI0643", "PCI EIDE controller" } ,
    { 0x1095, 0x0646, "CMD646", "EIDE/UDMA Controller" } ,
    { 0x1095, 0x0647, "PCI0647", "9738" } ,
    { 0x1095, 0x0648, "PCI-648", "Bus Master Ultra DMA PCI-IDE/ATA Chip" } ,
    { 0x1095, 0x0649, "PCI-649", "PATA100 ATAPI/RAID Controller" } ,
    { 0x1095, 0x0650, "PBC0650A", "Fast SCSI-II Ctrlr" } ,
    { 0x1095, 0x0670, "USB0670", "PCI-USB" } ,
    { 0x1095, 0x0673, "USB0673", "PCI-USB ASIC" } ,
    { 0x1095, 0x0680, "SiI 0680/680A", "PATA133 ATAPI/RAID Controller" } ,
    { 0x1095, 0x1025, "PCI0647", "9738" } ,
    { 0x1095, 0x1392, "1390/1392", "High Definition Audio HDMI output" } ,
    { 0x1095, 0x2455, "SI3124", "SATALink 4-Port PCI-X Host Controller" } ,
    { 0x1095, 0x3112, "SIL3112", "SATA/Raid controller(2XSATA150)" } ,
    { 0x1095, 0x3114, "Sil 3114", "SATALink/SATARaid Controller" } ,
    { 0x1095, 0x3124, "SiI 3124", "PCI-X to Serial ATA Controller" } ,
    { 0x1095, 0x3132, "SiI 3132", "RR252x SATA Controller" } ,
    { 0x1095, 0x3512, "Sil 3512", "SATALink/SATARaid Controllerhttp://www.pcidatabase.com/update_device.php?__ec_i=ec.1378825283.616786" } ,
    { 0x1095, 0x3531, "3531", "SiI 3531 SATA Controller" } ,
    { 0x1095, 0x9876, "0x9876", "0x9876" } ,
    { 0x1096, 0x1106, "0x3059", "Realtek AC97 Audio for VIA (R) Audio Controller" } ,
    { 0x1096, 0x3059, "VT8233", "South Bridge" } ,
    { 0x1097, 0x0038, "", "EIDE Controller (single FIFO)" } ,
    { 0x1098, 0x0001, "QD8500", "EIDE Controller" } ,
    { 0x1098, 0x0002, "QD8580", "EIDE Controller" } ,
    { 0x109A, 0x8280, "0x036en", "4 channel video digitizer cardm" } ,
    { 0x109E, 0x0350, "036E", "rb8701.1" } ,
    { 0x109E, 0x0350, "Bt848h", "tv tuner driverhj" } ,
    { 0x109E, 0x0351, "Bt848", "BrookTree Bt848 Video Capture Device - Audio Section	PCI" } ,
    { 0x109E, 0x0369, "Bt878fusion 878a", "Video Capture" } ,
    { 0x109E, 0x036C, "th&#305;k", "" } ,
    { 0x109E, 0x036E, "A8FEFC28", "AVerMediaAverTV WDM AudioCapture (878)" } ,
    { 0x109E, 0x036E, "Conextant Fucion 878A 25878-123", "Video Capture" } ,
    { 0x109E, 0x036E, "Conextant Fucion 878A 25878-123", "Video Capture" } ,
    { 0x109E, 0x036F, "bx878", "Video Capture" } ,
    { 0x109E, 0x0370, "Bt880B", "Video Capture (10 bit High qualtiy cap)" } ,
    { 0x109E, 0x0878, "Conexant Fusion 878A 25878-13 0549Y1JF", "Multimedia Controller Conexant Fusion 878A 25878-13 0549Y1JF" } ,
    { 0x109E, 0x0879, "Bt879khf", "Video Capture (Audio Section)" } ,
    { 0x109E, 0x0880, "Bt880", "Video Capture (Audio Section)" } ,
    { 0x109E, 0x109E, "Brooktree Corp BT848 SVR-2000 V1.02m", "Multimedia Video Controllerm" } ,
    { 0x109E, 0x109E - 0x036E, "1822-0001", "0400 video devce" } ,
    { 0x109E, 0x2115, "BtV 2115", "BtV Mediastream Controller 9x" } ,
    { 0x109E, 0x2125, "109E", "BtV Mediastream Controller" } ,
    { 0x109E, 0x2164, "BtV 2164", "Display Adapter" } ,
    { 0x109E, 0x2165, "BtV 2165", "MediaStream Controller" } ,
    { 0x109E, 0x36e, "878a", "25878-13" } ,
    { 0x109E, 0x36E, "Bt360 MediaStream &#1050;&#1086;&#1085;&#1090;&#10", "Brooktree Corp" } ,
    { 0x109E, 0x36E, "CONEXANT FUSION 878A 25878-13 E153498.1", "conexant 878a" } ,
    { 0x109E, 0x8230, "BtV 8230", "ATM Segment/Reassembly Controller (SRC)" } ,
    { 0x109E, 0x8472, "Bt8471/72", "32/64-channel HDLC Controllers" } ,
    { 0x109E, 0x8474, "Bt8474", "128-channel HDLC Controller" } ,
    { 0x109F, 0x036F, "20020001", "Video Capturee" } ,
    { 0x10A4, 0X5969, "", "" } ,
    { 0x9902, 0x0001, "SG2010", "PCI-to-PCI Bridge" } ,
    { 0x9902, 0x0002, "SG2010", "PCI to high speed serial bridge" } ,
    { 0x9902, 0x0003, "SG1010", "6 port serial switch /PCI-to-PCI bridge" } ,
    { 0x10A8, 0x0000, "0100", "ethernet controller" } ,
    { 0x10A9, 0x0004, "O2 MACE", "" } ,
    { 0x10A9, 0x0005, "RAD Audio", "" } ,
    { 0x10A9, 0x0006, "HPCEX", "" } ,
    { 0x10A9, 0x0007, "RPCEX", "" } ,
    { 0x10A9, 0x0008, "DiVO VIP", "" } ,
    { 0x10A9, 0x0009, "Alteon", "Gigabit Ethernet" } ,
    { 0x10A9, 0x0010, "AMP", "Video I/O" } ,
    { 0x10A9, 0x0011, "GRIP", "" } ,
    { 0x10A9, 0x0012, "SGH PSHAC GSN", "" } ,
    { 0x10A9, 0x1001, "Magic Carpet", "" } ,
    { 0x10A9, 0x1002, "Lithium", "" } ,
    { 0x10A9, 0x1003, "Dual JPEG 1", "" } ,
    { 0x10A9, 0x1004, "Dual JPEG 2", "" } ,
    { 0x10A9, 0x1005, "Dual JPEG 3", "" } ,
    { 0x10A9, 0x1006, "Dual JPEG 4", "" } ,
    { 0x10A9, 0x1007, "Dual JPEG 5", "" } ,
    { 0x10A9, 0x1008, "Cesium", "" } ,
    { 0x10A9, 0x2001, "", "Fibre Channel" } ,
    { 0x10A9, 0x2002, "ASDE", "" } ,
    { 0x10A9, 0x8001, "O2 1394", "" } ,
    { 0x10A9, 0x8002, "G-net NT", "" } ,
    { 0x10AB, 0x1005, "USB\\VID_0000@PID_0000\\6@390392D@0@1", "USB Pendrive" } ,
    { 0x10AB, 0x1007, "USB\\VID_0000@PID_0000\\6@390392D@0@1", "usb pendrive" } ,
    { 0x10AB, 0x8086, "2200", "PCI Simple Communications Controller " } ,
    { 0x10AD, 0x0001, "W83769F", "EIDE Ctrlr" } ,
    { 0x10AD, 0x0103, "sl82c103", "PCI-ide mode 4.5 Cntrlr" } ,
    { 0x10AD, 0x0105, "W83789F", "Sonata bus master PCI-IDE controller" } ,
    { 0x10AD, 0x0565, "W83C553F", "PCI/ISA bridge" } ,
    { 0xA0F1, 0x9876, "0x9876", "0x9876" } ,
    { 0x10B5, 0x0324, "", "" } ,
    { 0x10B5, 0x0480, "IOP 480", "Integrated PowerPC I/O Processor" } ,
    { 0x10B5, 0x0960, "PCI 9080RDK-960", "PCI Reference Design Kit for PCI 9080" } ,
    { 0x10B5, 0x1030, "Gazel R685", "ISDN card" } ,
    { 0x10B5, 0x1054, "Gazel R697", "dual channel ISDN card" } ,
    { 0x10B5, 0x1078, "PCI 9050", "Vision Systems VScom PCI-210" } ,
    { 0x10B5, 0x1103, "PCI 9050", "Vision Systems VScom PCI-200" } ,
    { 0x10B5, 0x1146, "PCI 9050", "Vision Systems VScom PCI-010S" } ,
    { 0x10B5, 0x1147, "PCI 9050", "Vision Systems VScom PCI-020S" } ,
    { 0x10B5, 0x1151, "Gazel R753", "ISDN card" } ,
    { 0x10B5, 0x1152, "Gazel R753", "ISDN card" } ,
    { 0x10B5, 0x2724, "", "Thales PCSM Security Card" } ,
    { 0x10B5, 0x2748, "9054", "TPCX Transientrecorder Card" } ,
    { 0x10B5, 0x3001, "plx9030", "gpscard" } ,
    { 0x10B5, 0x5406, "PCI RDK9054-LITE", "PCI Reference Design Kit for PLX PCI 9054" } ,
    { 0x10B5, 0x5601, "PCI 9056", "32-bit; 66MHz PCI Bus Master I/O Accelerator, 17 x 17mm FPBGA" } ,
    { 0x10B5, 0x6520, "PCI6520 G", "PCI-X to PCI-X Bridge" } ,
    { 0x10B5, 0x6ACC, "PCI 9030", "General Mechatronics 6 Axis Motion Control Card for EMC2" } ,
    { 0x10B5, 0x8111, "PEX 8311", "1 Lane PCI Express to PCI bridge (PEX8111); 1 Lane PCI Express to Generic Local Bus bridge (PEX8311)" } ,
    { 0x10B5, 0x8112, "PEX8112", "1 Lane PCI Express to PCI bridge" } ,
    { 0x10B5, 0x8508, "PEX8508", "8 Lane, 5 Port PCI Express Switch" } ,
    { 0x10B5, 0x8509, "PEX8509", "8-lane PCI-Express Switch" } ,
    { 0x10B5, 0x8516, "PEX 8516", "Versatile PCI Express Switch" } ,
    { 0x10B5, 0x8518, "PEX8518-AB25BI", "PLX PCI-e switch" } ,
    { 0x10B5, 0x8532, "PEX 8532", "Versatile PCI Express Switch" } ,
    { 0x10B5, 0x8548, "8548", "48-lane PCIe switch" } ,
    { 0x10B5, 0x8609, "PEX 8609", "8 Lane, 8 Port PCI Express Switch" } ,
    { 0x10B5, 0x8664, "PEX 8664", "64-Lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch, 35 x 35mm FCBGA" } ,
    { 0x10B5, 0x8748, "PEX 8748", "48-Lane, 12-Port PCI Express Gen 3  Multi-Root Switch" } ,
    { 0x10B5, 0x9030, "PCI 9030", "PCI SMARTarget I/O Accelerator" } ,
    { 0x10B5, 0x9036, "PCI9036", "Interface chip - value 1k" } ,
    { 0x10B5, 0x9050, "PCI 9050", "Target PCI Interface Chip - value 1k" } ,
    { 0x10B5, 0x9052, "PCI 9052", "PCI 9052 Target PLX PCI Interface Chip" } ,
    { 0x10B5, 0x9054, "PCI 9054", "PCI I/O Accelerator" } ,
    { 0x10B5, 0x9056, "PCI9056", "32-bit, 66 MHz PCI Bus-Mastering I/O Accelerator for PowerQUICC and Generic 32-bit, 66 MHz Local Bus" } ,
    { 0x10B5, 0x9060, "PCI9060", "PCI Bus Master Interface Chip" } ,
    { 0x10B5, 0x906D, "PCI 9060SD", "PCI Bus Master Interface Chip" } ,
    { 0x10B5, 0x906E, "PCI 9060ES", "PCI Bus Master Interface Chip" } ,
    { 0x10B5, 0x9080, "PCI 9080", "High performance PCI to Local Bus chip" } ,
    { 0x10B6, 0x0001, "Smart 16/4", "Ringnode (PCI1b)" } ,
    { 0x10B6, 0x0002, "Smart 16/4", "Ringnode (PCIBM2/CardBus)" } ,
    { 0x10B6, 0x0003, "Smart 16/4", "Ringnode" } ,
    { 0x10B6, 0x0004, "", "Smart 16/4 Ringnode Mk1 (PCIBM1)" } ,
    { 0x10B6, 0x0006, "", "16/4 CardBus Adapter (Eric 2)" } ,
    { 0x10B6, 0x0007, "Presto PCI 1716", "" } ,
    { 0x10B6, 0x0009, "", "Smart 100/16/4 PCi-HS Ringnode" } ,
    { 0x10B6, 0x000A, "", "Smart 100/16/4 PCI Ringnode" } ,
    { 0x10B6, 0x000B, "", "16/4 CardBus  Adapter Mk2" } ,
    { 0x10B6, 0x1000, "Horizon", "ATM adapter" } ,
    { 0x10B6, 0x1001, "Ambassador", "ATM adapter" } ,
    { 0x10B6, 0x1002, "Ambassador", "ATM Adapter" } ,
    { 0x10B7, 0x0001, "3C985", "1000BaseSX Gigabit Etherlink" } ,
    { 0x10B7, 0x0013, "3com p/n: 3CRDAG675", "3Com11a/b/g Wireless PCI Adapter " } ,
    { 0x10B7, 0x1000, "3C905CX-TXNM", "3COM 3C905CX-TXNM with 40-0664-003 ASIC" } ,
    { 0x10B7, 0x1006, "14e4:1645", "Broadcom Corporation NetXtreme BCM5701 Gigabit Ethernet" } ,
    { 0x10B7, 0x1007, "3C556", "V.90 Mini-PCI Modem" } ,
    { 0x10B7, 0x1700, "3C940", "Gigabit Ethernet PCI CODEC" } ,
    { 0x10B7, 0x1F1F, "3CRWE777A", "AirConnect Wireless LAN PCI Card" } ,
    { 0x10B7, 0x3390, "3C339", "Token Link Velocity" } ,
    { 0x10B7, 0x3590, "3C359", "TokenLink Velocity XL Adapter" } ,
    { 0x10B7, 0x4500, "3C450", "Cyclone" } ,
    { 0x10B7, 0x5055, "3C555", "Laptop Hurricane" } ,
    { 0x10B7, 0x5057, "3C575", "Megahertz 10/100 LAN CardBus PC Card" } ,
    { 0x10B7, 0x5157, "3C575B", "Megahertz 10/100 LAN CardBus PC Card" } ,
    { 0x10B7, 0x5257, "3CCFE575CT", "Cyclone Fast Ethernet CardBus PC Card" } ,
    { 0x10B7, 0x5900, "3C590", "Ethernet III Bus Fast PCI" } ,
    { 0x10B7, 0x5920, "3C592", "PCI/EISA 10Mbps Demon/Vortex" } ,
    { 0x10B7, 0x5950, "3COM 3C595-TX", "100MB PCI Ethernet Adapter" } ,
    { 0x10B7, 0x5951, "3C595", "Fast EtherLink PCI T4" } ,
    { 0x10B7, 0x5952, "3C595", "Fast EtherLink PCI MII" } ,
    { 0x10B7, 0x5970, "3C597", "PCI/EISA Fast Demon/Vortex" } ,
    { 0x10B7, 0x5B57, "3C595", "Megahertz 10/100 LAN CardBus" } ,
    { 0x10B7, 0x6055, "3C556", "10/100 Fast Ethernet MiniPCI Adapter" } ,
    { 0x10B7, 0x6056, "3CN3AC1556B", "MiniPCI 10/100 Ethernet+Modem56k (see devid:1007)" } ,
    { 0x10B7, 0x6560, "3CCFE656", "Cyclone CardBus PC Card" } ,
    { 0x10B7, 0x6561, "FEM656", "10/100 LAN+56K Modem CardBus PC Card" } ,
    { 0x10B7, 0x6562, "3CCFEM656", "Cyclone CardBus PC Card" } ,
    { 0x10B7, 0x6563, "FEM656B", "10/100 LAN+56K Modem CardBus PC Card" } ,
    { 0x10B7, 0x6564, "3CCFEM656", "Cyclone CardBus PC Card" } ,
    { 0x10B7, 0x6565, "3CCFEM656C", "Global 10/100 Fast Ethernet+56K Modem" } ,
    { 0x10B7, 0x7646, "3CSOHO100B-TX", "3com" } ,
    { 0x10B7, 0x7770, "???", "AirConnect Wireless PCI" } ,
    { 0x10B7, 0x8811, "", "Token Ring" } ,
    { 0x10B7, 0x9000, "3C900-TPO", "Fast Etherlink PCI TPO NIC" } ,
    { 0x10B7, 0x9001, "3C900-COMBO", "Fast Etherlink XL PCI Combo NIC" } ,
    { 0x10B7, 0x9004, "3C900-TPO", "EtherLink XL TPO 10Mb" } ,
    { 0x10B7, 0x9005, "3C900B-COMBO", "Fast Etherlink 10Mbps Combo NIC" } ,
    { 0x10B7, 0x9006, "3C900B-TPC", "EtherLink XL TPC" } ,
    { 0x10B7, 0x900A, "3C900B-FL", "EtherLink PCI Fiber NIC" } ,
    { 0x10B7, 0x9041, "3C905-T4", "Fast Etherlink XL 10/100" } ,
    { 0x10B7, 0x9050, "3C905B - Combo", "Fast Etherlink XL PCI 10/100" } ,
    { 0x10B7, 0x9051, "3C905-T4", "Fast Etherlink XL 10/100" } ,
    { 0x10B7, 0x9055, "APCI/pnpb006", "Fast Etherlink 10/100 PCI TX NIC" } ,
    { 0x10B7, 0x9056, "3C905B-T4", "Fast EtherLink XL 10/100" } ,
    { 0x10B7, 0x9058, "3C905B-COMBO", "Deluxe EtherLink 10/100 PCI Combo NIC" } ,
    { 0x10B7, 0x905A, "3C905B-FX", "Fast EtherLink 100 Fiber NIC" } ,
    { 0x10B7, 0x9200, "3C905 CX-TXM", "3Com 10/100 Managed NIC 3C905CX-TX-M" } ,
    { 0x10B7, 0x9201, "3C920B-EMB", "Integrated Fast Ethernet Controller" } ,
    { 0x10B7, 0x9202, "3C920B-EMB", "3C920B-EMB 3Com + Realtek 8201L" } ,
    { 0x10B7, 0x9210, "3C920B-EMB-WNM", "Integrated Fast Ethernet Controller" } ,
    { 0x10B7, 0x9300, "3csoho100b-tx", "3ComSOHO100B-TX" } ,
    { 0x10B7, 0x9800, "3C980-TX", "Fast EtherLink XL Server Adapter2" } ,
    { 0x10B7, 0x9805, "3C980-TX", "Python-T 10/100baseTX NIC" } ,
    { 0x10B7, 0x9876, "3C920B-EMB", "3C920B-EMB 3Com + Realtek 8201L" } ,
    { 0x10B7, 0x9902, "3CR990-TX-95", "EtherLink 10/100 PCI with 3XP Processor" } ,
    { 0x10B7, 0x9903, "3CR990-TX-97", "EtherLink 10/100 PCI with 3XP Processor" } ,
    { 0x10B7, 0x9905, "3C990B-FX", "100FX PCI Server NIC w/3XP" } ,
    { 0x10B7, 0x9908, "3CR990SVR95", "EtherLink 10/100 Server PCI with 3XP" } ,
    { 0x10B7, 0x9909, "3CR990SVR97", "EtherLink 10/100 Server PCI with 3XP" } ,
    { 0x10B7, 0xD004, "3C900B-TPO", "EtherLink XL PCI" } ,
    { 0x10B8, 0x0005, "LAN83C170QF/171", "EPIC/XF 10/100 Mbps Fast Ethernet Ctrlr" } ,
    { 0x10B8, 0x0006, "LAN83C175", "EPIC/C Ethernet CardBus Integrated Ctrlr" } ,
    { 0x10B8, 0x1000, "37C665", "FDC" } ,
    { 0x10B8, 0x1001, "37C922", "FDC" } ,
    { 0x10B8, 0xA011, "83C170QF", "Fast ethernet controller" } ,
    { 0x10B8, 0xB106, "SMC34C90", "CardBus Controller" } ,
    { 0x10B9, 0x0101, "CMI8338/C3DX", "PCI Audio Device (OEM)" } ,
    { 0x10B9, 0x0102, "CMI8338/C3DX", "PCI Audio Device (OEM)" } ,
    { 0x10B9, 0x0111, "CMI8738/C3DX", "C-Media Audio Device (OEM)" } ,
    { 0x10B9, 0x0780, "???", "Multi-IO Card" } ,
    { 0x10B9, 0x0782, "???", "Multi-IO Card" } ,
    { 0x10B9, 0x10b9, "ALI M5273 A1", "0402t505 CK46828100B" } ,
    { 0x10B9, 0x10CE, "5288", "cpi" } ,
    { 0x10B9, 0x1435, "M1435", "VL Bridge" } ,
    { 0x10B9, 0x1445, "M1445", "CPU to PCI & PCI to ISA Bridge w/EIDE" } ,
    { 0x10B9, 0x1449, "M1449", "ISA Bridge" } ,
    { 0x10B9, 0x1451, "M1451", "Pentium CPU to PCI Bridge" } ,
    { 0x10B9, 0x1461, "M1461", "P54C Chipset" } ,
    { 0x10B9, 0x1489, "M1489", "486 PCI Chipset" } ,
    { 0x10B9, 0x1511, "M1575", "Aladdin 2 Host Bridge" } ,
    { 0x10B9, 0x1513, "M1513", "Aladdin 2 South Bridge" } ,
    { 0x10B9, 0x1521, "M1521", "Bios" } ,
    { 0x10B9, 0x1523, "M1523", "ISA Bridge" } ,
    { 0x10B9, 0x1533, "M1535+", "PCI South Bridge" } ,
    { 0x10B9, 0x1535, "M1535x", "ISA Bridge" } ,
    { 0x10B9, 0x1541, "M1541", "Aladdin V AGPset Host Bridge" } ,
    { 0x10B9, 0x1543, "M1543 a1", "Aladdin V chipset South Bridge" } ,
    { 0x10B9, 0x1561, "M1561", "North Bridge" } ,
    { 0x10B9, 0x1563, "M1563", "South Bridge with Hypertransport Support" } ,
    { 0x10B9, 0x1632, "M1632", "North Bridge" } ,
    { 0x10B9, 0x1641, "M1641", "CPU to PCI Bridge" } ,
    { 0x10B9, 0x1644, "M1644", "AGP System Controller" } ,
    { 0x10B9, 0x1646, "M1646", "AGP System Controller" } ,
    { 0x10B9, 0x1647, "M1647", "CPU to PCI Bridge" } ,
    { 0x10B9, 0x1651, "M1651", "CPU to PCI Bridge" } ,
    { 0x10B9, 0x1661, "M1661", "AGP System Controller" } ,
    { 0x10B9, 0x1667, "M1667", "AGP System Controller" } ,
    { 0x10B9, 0x1671, "M1671", "Super P4 Nouth Bridge" } ,
    { 0x10B9, 0x1672, "M1672", "AGP System Controller" } ,
    { 0x10B9, 0x1681, "M1681", "P4 Nouth Bridge with HyperTransport" } ,
    { 0x10B9, 0x1687, "M1687", "K8 North Bridge with HyperTransport" } ,
    { 0x10B9, 0x1849, "52871849", "02\\3&267A616A" } ,
    { 0x10B9, 0x3141, "M3141", "GUI Accelerator" } ,
    { 0x10B9, 0x3143, "M3143", "GUI Accelerator" } ,
    { 0x10B9, 0x3145, "M3145", "GUI Accelerator" } ,
    { 0x10B9, 0x3147, "M3147", "GUI Accelerator" } ,
    { 0x10B9, 0x3149, "M3149", "GUI Accelerator" } ,
    { 0x10B9, 0x3151, "M3151", "GUI Accelerator" } ,
    { 0x10B9, 0x3307, "M3307", "MPEG-1 Decoder" } ,
    { 0x10B9, 0x3309, "M3309", "MPEG Decoder" } ,
    { 0x10B9, 0x5212, "M4803", "" } ,
    { 0x10B9, 0x5215, "MS4803", "EIDE Ctrlr" } ,
    { 0x10B9, 0x5217, "m5217h", "I/O (?)" } ,
    { 0x10B9, 0x5219, "PCI\\VEN_10B9&DEV_5451&CC_040100", "Ali M5219 PCI BUS MASTER IDE Controller" } ,
    { 0x10B9, 0x5225, "M5225", "IDE Controller" } ,
    { 0x10B9, 0x5228, "M1563", "M5228 PATA/RAID Controller" } ,
    { 0x10B9, 0x5229, "M5229 Southbridge", "EIDE Controller" } ,
    { 0x10B9, 0x5229, "?", "Ali EIDE" } ,
    { 0x10B9, 0x5229, "?", "PATA 33" } ,
    { 0x10B9, 0x5229, "?", "PATA 66" } ,
    { 0x10B9, 0x5229, "?", "PATA 100" } ,
    { 0x10B9, 0x5229, "chipset", "PATA 133" } ,
    { 0x10B9, 0x5235, "M1621", "ALI M6503c" } ,
    { 0x10B9, 0x5236, "M5273", "EHCI USB 2.0" } ,
    { 0x10B9, 0x5237, "M5273 A1 for windows 2000", "OpenHCI 1.1 USB to  2.0" } ,
    { 0x10B9, 0x5239, "523910A9", "USB EHCI2.0 Controller" } ,
    { 0x10B9, 0x5249, "M5249", "HyperTransport to PCI Bridge" } ,
    { 0x10B9, 0x5251, "M5251", "IEEE P1394 OpenHCI 1.0 Controller" } ,
    { 0x10B9, 0x5253, "M5253", "IEEE P1394 OpenHCI 1.0 Controller" } ,
    { 0x10B9, 0x5261, "M5261", "Ethernet Controller" } ,
    { 0x10B9, 0x5263, "Albatron K8ULTRA-U Pro", "ULi PCI Fast Ethernet Controller" } ,
    { 0x10B9, 0x528, "52871849", "02\\3&267A616A" } ,
    { 0x10B9, 0x5281, "M1565/1566", "ALI M5281/5283  SATA/RAID Controller" } ,
    { 0x10B9, 0x5286, "52291849", "Realtek PCIE CardReader" } ,
    { 0x10B9, 0x5287, "ULI M1573", "SATA/Raid controller" } ,
    { 0x10B9, 0x5288, "ULI M1575/M1697 ", "M5288 SATA/Raid controller (Asrock 939SLI32-eSata2)" } ,
    { 0x10B9, 0x5289, "ULI M1567/M1689 ", "M5289 SATA/Raid controller" } ,
    { 0x10B9, 0x5450, "65525", "Agere Systems AC97 Modem" } ,
    { 0x10B9, 0x5451, "M5451", "Ali Audio Accelerator" } ,
    { 0x10B9, 0x5455, "M1563M Southbridge", "AC'97 Audio Controller" } ,
    { 0x10B9, 0x5457, "M1563M", "AC97 Modem controller" } ,
    { 0x10B9, 0X5459, "MDV92XP NetoDragon", "PCI Soft Modem V92 NetoDragon" } ,
    { 0x10B9, 0x5461, "M5461", "High Definition Audio Controller" } ,
    { 0x10B9, 0x5471, "M1563M Southbridge", "Memory Stick Host" } ,
    { 0x10B9, 0x5473, "M1563M Southbridge", "MMC/SD controller" } ,
    { 0x10B9, 0x7101, "M7101", "Power Management Controller" } ,
    { 0x10B9, 0x7471, "M1563M Southbridge", "Memory Stick Host" } ,
    { 0x10B9, 0x9876, "mdv92xp", "xhcth700000b" } ,
    { 0xA259, 0x3038, "82945G", "PCI\\VEN_103C&DEV_3302&SUBSYS_3305103C&REV_00" } ,
    { 0x10BA, 0x0304, "", "GUI Accelerator" } ,
    { 0x10BD, 0x0803, " MYSON Technology Inc SURECOM EP-320X-S 100/10M Et", "Ethernet PCI Adapter" } ,
    { 0x10BD, 0x0E34, "NE34", "Ethernet Adapter (NE2000 PCI clone)" } ,
    { 0x10BD, 0x5240, "0055", "IDE Cntrlr" } ,
    { 0x10BD, 0x5241, "8086", "PCMCIA Bridge" } ,
    { 0x10BD, 0x5242, "", "General Purpose Cntrlr" } ,
    { 0x10BD, 0x5243, "00000000", "Bus Cntrlr" } ,
    { 0x10BD, 0x5244, "", "FCD Cntrlr" } ,
    { 0x10BD, 0x8136, "Unkown", "Unkown" } ,
    { 0x10BD, 0x8139, "surecom EP-320X-R adapter with realtek 8139c chip", "realtek 8139c" } ,
    { 0x10C3, 0x8920, "5335fn800829", "MCP67 High Definition Audio " } ,
    { 0x10C3, 0x8925, "", "" } ,
    { 0xA727, 0x0013, "3com p/n: 3CRDAG675", "3com 11 a/b/g wireless PCI Adapter" } ,
    { 0x10C4, 0x8363, "s/n124102160", "10C4" } ,
    { 0x10C4, 0xEA60, "CP210x", "Silicon Labs CP210x USB to UART Bridge" } ,
    { 0x10C8, 0004, "831610F7", "MagicGraph 128XD" } ,
    { 0x10C8, 0x0000, "NM2097", "Graphics Cntrlr" } ,
    { 0x10C8, 0x0003, "NM2093", "MagicGraph 128ZV Video Controller" } ,
    { 0x10C8, 0x0004, "NM2160", "MagicGraph 128XD" } ,
    { 0x10C8, 0x0005, "NM2200", "MagicMedia 256AV" } ,
    { 0x10C8, 0x0006, "NM2360", "MagicMedia 256ZX/256M6D" } ,
    { 0x10C8, 0x0016, "NM2380", "MagicMedia 256XL+" } ,
    { 0x10C8, 0x0025, "NM2230", "MagicMedia 256AV+" } ,
    { 0x10C8, 0x0083, "NM2097", "Graphic Controller NeoMagic MagicGraph128ZV+" } ,
    { 0x10C8, 0x8005, "NM2200", "MagicMedia 256AV Audio Device" } ,
    { 0x10C8, 0x8006, "NM2360", "MagicMedia 256ZX Audio Device" } ,
    { 0x10C8, 0x8016, "NM2380", "MagicMedia 256XL+ Audio Device" } ,
    { 0x10CA, 0x9876, "ROOT\\MEDIA\\0000", "PCI\\VEN_1217&DEV_7110&SUBSYS_106A1734&REV_00" } ,
    { 0x10CD, 0x1100, "ASC1100", "PCI SCSI Host Adapter" } ,
    { 0x10CD, 0x1200, "ASC1200", "Fast SCSI-II" } ,
    { 0x10CD, 0x1300, "ABP-3925", "ABP-3925" } ,
    { 0x10CD, 0x2300, "F914C536", "PCI Ultra Wide SCSI Host Adapter" } ,
    { 0x10CD, 0x2500, "ASC38C0800/1600", "PCI Ultra 80/160 SCSI Controllers" } ,
    { 0x10CD, 0x4000, "ASC30C0400", "IEEE-1394 OHCI PCI Controller" } ,
    { 0x10CF, 0x10C5, "FMV-103", "Serial Parallel Card" } ,
    { 0x10CF, 0x2001, "MB86605", "PCI SCSI Host Adapter (Fast Wide SCSI-2)" } ,
    { 0x10CF, 0x2002, "MB86606", "Fast Wide SCSI Controller" } ,
    { 0x10CF, 0x2005, "MB86974", "10/100 Fast Ethernet Adapter" } ,
    { 0x10CF, 0x200C, "MB86974", "IEEE1394 OpenHCI Controller" } ,
    { 0x10CF, 0x2010, "", "OHCI FireWire Controller" } ,
    { 0x10CF, 0x2011, "12711718", "MPEG2 R-Engine (MPEG2 Hardware Encoder)" } ,
    { 0x10CF, 0x2019, "MB86295", "Coral-P Graphics Chip" } ,
    { 0x10CF, 0x201E, "MB86296", "Coral-PA Graphics Chip" } ,
    { 0x10CF, 0x202A, "u/k", "u/k" } ,
    { 0x10CF, 0x202B, "mb86297", "Carmine Graphisc adapter" } ,
    { 0x10D6, 0xFF51, "0x0100", "ATJ2091N" } ,
    { 0x10D6, 0xff66, "0x0100", "ATJ2091N" } ,
    { 0x1658, 0x0704, "905410B5", "DIG 704 PCI - Interface with Millisecond Timer and Interrupts" } ,
    { 0x10D9, 0x0066, "MX86101P", "sdas" } ,
    { 0x10D9, 0x0512, "MX98713", "Fast Ethernet Adapter" } ,
    { 0x10D9, 0x0531, "MX98715/25", "Single Chip Fast Ethernet NIC Controller" } ,
    { 0x10D9, 0x0532, "MX98723/727", "PCI/CardBus Fast Ethernet Controller" } ,
    { 0x10D9, 0x0553, "MX987x5", "Ethernet Adapter" } ,
    { 0x10D9, 0x8625, "MX86250", "xiankasqudong" } ,
    { 0x10D9, 0x8626, "MX86251", "PCI\\VEN_10D9&DEV_8626&SUBSYS_00000000&REV_00\\4&1F7DBC9F&0&08F0 " } ,
    { 0x10D9, 0x8627, "MX86251FC", "Voodoo Rush MX86251" } ,
    { 0x10D9, 0x8888, "MX86250", "9619E" } ,
    { 0x10D9, 0xC115, "lc82c115", " Linksys LNE100TX " } ,
    { 0x10DC, 0x0001, "STAR/RD24", "PCI-SCI  PMC  mezzanine" } ,
    { 0x10DC, 0x0002, "ATT 2C15-3 (FPGA)", "SCI bridge  on PCI 5 Volt card" } ,
    { 0x10DC, 0x0004, "EP20S780", "ALTERA STRATIX" } ,
    { 0x10DC, 0x0010, "680-1110-150/400", "Simple PMC/PCI to S-LINK interface" } ,
    { 0x10DC, 0x0011, "680-1110-200/450", "Simple S-LINK to PMC/PCI interface" } ,
    { 0x10DC, 0x0012, "S32PCI64", "32-bit S-LINK to 64-bit PCI interface" } ,
    { 0x10DC, 0x0021, "", "HIPPI destination" } ,
    { 0x10DC, 0x0022, "", "HIPPI source" } ,
    { 0x10DC, 0x0033, "EP20KE (APEX-FPGA)", "ALICE DDL to  PCI interface (RORC)" } ,
    { 0x10DC, 0x0101, "SL651 7057 C200", "Acquisition card for the SPS Orbit System (MACI)" } ,
    { 0x10DC, 0x016A, "XC4VFX100", "CALICE ODR" } ,
    { 0x10DC, 0x10DC, "ATT 2C15-3 (FPGA)", "TTC sr   first TTC chip receiver PMC" } ,
    { 0x10DC, 0x301, "PLX PCI 9030", "based on the PLX PCI 9030 to build a MIL1553 bus interface" } ,
    { 0x10DC, 0x324, "PLX PCI96556", "64 Bit/66MHz PCI to Local Bus Bridge" } ,
    { 0x10DC, 0x8086, "a002", "geodelink pci south" } ,
    { 0x10DD, 0x0001, "", "3D graphics processor" } ,
    { 0x10DE, 0x04EF, "NV3", "Riva 128" } ,
    { 0x10DE, 0x0001, "Lucent 0x00da", "SoundMAX Integrated Digital Audio" } ,
    { 0x10DE, 0x0002, "0x0002", "HDMI Audio Driver Driver" } ,
    { 0x10DE, 0x0003, "It seems to be Realtek ALC888/9", "nVIDIA High Definition Audio/HDMI " } ,
    { 0x10DE, 0x0006, "Realtek", "realtek based HD Audio" } ,
    { 0x10DE, 0x0008, "NV1", "Edge 3D" } ,
    { 0x10DE, 0x0009, "NV1", "Edge 3D" } ,
    { 0x10DE, 0x000B, "7025", "HDMI Audio Driver Driver 1.00.00.59" } ,
    { 0x10DE, 0x0010, "NV2", "Mutara V08" } ,
    { 0x10DE, 0x0011, "Various - see list on site", "NVIDIA High Def Audio" } ,
    { 0x10DE, 0x0018, "NV3", "Riva 128" } ,
    { 0x10DE, 0x0019, "NV3", "Riva 128ZX" } ,
    { 0x10DE, 0x001D, "NV35", "nVidia GeForce FX 5900XT" } ,
    { 0x10DE, 0x0020, "GTX680M", "NVIDIA RIVA TNT" } ,
    { 0x10DE, 0x0028, "NVIDIA GeForce 635M", "ACPI\\NSC1200" } ,
    { 0x10DE, 0x0029, "NV05", "NVIDIA RIVA TNT 2 Ultra" } ,
    { 0x10DE, 0x002A, "0df4", "TNT2" } ,
    { 0x10DE, 0x002B, "NV5", "Riva TNT2" } ,
    { 0x10DE, 0x002C, "NV05", "NVIDIA Vanta/Vanta LT" } ,
    { 0x10DE, 0x002D, "NV05", "NVIDIA RIVA TNT2 Model 64/Model 64 AGP 32M" } ,
    { 0x10DE, 0x002E, "NV6", "VANTA" } ,
    { 0x10DE, 0x002F, "NV6", "VANTA" } ,
    { 0x10DE, 0x0035, "MCP04", "MCP04 PATA Controller" } ,
    { 0x10DE, 0x0036, "MCP04", "MCP04 SATA/RAID Controller" } ,
    { 0x10DE, 0x003E, "MCP04", "MCP04 SATA/RAID Controller" } ,
    { 0x10DE, 0x0040, "NV40", "NVIDIA GeForce 6800 Ultra" } ,
    { 0x10DE, 0x0041, "NV40", "NVIDIA GeForce 6800" } ,
    { 0x10DE, 0x0042, "NV40", "NVIDIA GeForce 6800 LE" } ,
    { 0x10DE, 0x0043, "NV40", "NVIDIA GeForce 6800 XE" } ,
    { 0x10DE, 0x0044, "NV40", "NVIDIA GeForce 6800 XT" } ,
    { 0x10DE, 0x0045, "NV40", "NVIDIA GeForce 6800 GT" } ,
    { 0x10DE, 0x0046, "NV45", "NVIDIA GeForce 6800 GT" } ,
    { 0x10DE, 0x0047, "NV40", "NVIDIA GeForce 6800 GS" } ,
    { 0x10DE, 0x0048, "NV40", "NVIDIA GeForce 6800 XT" } ,
    { 0x10DE, 0x0049, "NV40", "NVIDIA NV40GL" } ,
    { 0x10DE, 0x004D, "NV40", "NVIDIA Quadro FX 3400" } ,
    { 0x10DE, 0x004E, "NV40", "NVIDIA Quadro FX 4000" } ,
    { 0x10DE, 0x0052, "NV06", "NVIDIA nForce PCI System Management" } ,
    { 0x10DE, 0x0053, "CK804", "CK804 PATA Controller" } ,
    { 0x10DE, 0x0054, "CK804", "CK804 SATA/RAID Controller" } ,
    { 0x10DE, 0x0055, "CK804", "CK804 SATA/RAID Controller" } ,
    { 0x10DE, 0x0057, "CK804", "NVIDIA Network Bus Enumerator" } ,
    { 0x10DE, 0x0059, "sdsd", "nForce Audio Controller" } ,
    { 0x10DE, 0x005E, "nForce4", "nForce4 HyperTransport Bridge" } ,
    { 0x10DE, 0x0060, "MCP68", "PCI to ISA Bridge" } ,
    { 0x10DE, 0x0064, "MCP", "SMBus Controller" } ,
    { 0x10DE, 0x0065, "nForce MCP2/MCP2-T/MCP2-U", "PATA Controller" } ,
    { 0x10DE, 0x0066, "nForce MCP2", "nForce 2 Networking Controller" } ,
    { 0x10DE, 0x0067, "MCP2", "Nvidia 7050 chipset HDMI Audio" } ,
    { 0x10DE, 0x0068, "MCP2", "EHCI USB 2.0 Controller" } ,
    { 0x10DE, 0x006A, "MCP2s", "nForce AC97s" } ,
    { 0x10DE, 0x006B, "nForce MCP-T?", "Audio Processing Unit (Dolby Digital)" } ,
    { 0x10DE, 0x006C, "nForce", "PCI to PCI Bridge" } ,
    { 0x10DE, 0x006D, "nForce MCP-T", "Audio Codec Interface" } ,
    { 0x10DE, 0x006E, "nForce MCP2", "OHCI Compliant IEEE 1394 Controller" } ,
    { 0x10DE, 0x0085, "MCP2S", "MCP2S PATA Controller" } ,
    { 0x10DE, 0x008C, "RLT8201BL", "Single-Port 10/100M Fast Ethernet PHYceiver" } ,
    { 0x10DE, 0x008E, "MCP2S", "MCP2S SATA/RAID Controller" } ,
    { 0x10DE, 0x0090, "G70", "NVIDIA GeForce 7800 GTX" } ,
    { 0x10DE, 0x0091, "G70", "NVIDIA GeForce 7800 GTX" } ,
    { 0x10DE, 0x0092, "G70", "NVIDIA GeForce 7800 GT" } ,
    { 0x10DE, 0x0093, "G70", "NVIDIA GeForce 7800 GS" } ,
    { 0x10DE, 0x0094, "G70", "NVIDIA GeForce 7800SE/XT/LE/LT/ZT" } ,
    { 0x10DE, 0x0095, "G70", "NVIDIA GeForce 7800 SLI" } ,
    { 0x10DE, 0x0098, "G70", "NVIDIA GeForce Go 7800" } ,
    { 0x10DE, 0x0099, "G70", "NVIDIA GeForce Go 7800 GTX" } ,
    { 0x10DE, 0x009C, "G70", "NVIDIA Quadro FX 350M" } ,
    { 0x10DE, 0x009D, "G70", "NVIDIA Quadro FX 4500" } ,
    { 0x10DE, 0x009E, "G70", "NVIDIA G70GL" } ,
    { 0x10DE, 0x00A0, "NV10de", "Aladdin TNT2" } ,
    { 0x10DE, 0x00C0, "NV41", "NVIDIA GeForce 6800 GS" } ,
    { 0x10DE, 0x00C1, "NV41", "NVIDIA GeForce 6800" } ,
    { 0x10DE, 0x00C2, "NV41", "NVIDIA GeForce GTX670M" } ,
    { 0x10DE, 0x00C3, "NV41", "NVIDIA GeForce 6800 XT" } ,
    { 0x10DE, 0x00C8, "NV41.8", "NVIDIA GeForce Go 6800" } ,
    { 0x10DE, 0x00C9, "NV41", "NVIDIA GeForce Go 6800 Ultra" } ,
    { 0x10DE, 0x00CC, "NV41", "NVIDIA Quadro FX Go 1400" } ,
    { 0x10DE, 0x00CD, "NV41", "NVIDIA Quadro FX 3450/4000 SDI" } ,
    { 0x10DE, 0x00CE, "NV41", "NVIDIA Quadro FX 1400" } ,
    { 0x10DE, 0x00D0, "nForce 3", "LPC Bridge" } ,
    { 0x10DE, 0x00D1, "nForce 3", "Host Bridge" } ,
    { 0x10DE, 0x00D2, "nForce 3?", "PCI-to-PCI Bridge" } ,
    { 0x10DE, 0x00D4, "MCP2", "SMBus Controller" } ,
    { 0x10DE, 0x00D5, "nForce3-150", "CK8 PATA 133/PATA to SATA Bridge" } ,
    { 0x10DE, 0x00D6, "MCP3", "nForce 3 Networking Controller" } ,
    { 0x10DE, 0x00D7, "nForce MCP3?", "OpenHCD USB Host Controller" } ,
    { 0x10DE, 0x00D8, "nForce MCP3?", "Enhanced PCI to USB Host Controller" } ,
    { 0x10DE, 0x00D9, "nForce 3", "Agere System PCI Soft Modem" } ,
    { 0x10DE, 0x00DA, "MCP3", "AC97 Audio Controller" } ,
    { 0x10DE, 0x00DD, "nForce MCP3?", "PCI-to-PCI Bridge" } ,
    { 0x10DE, 0x00DF, "MCP73", "nForce3 Networking Controller" } ,
    { 0x10DE, 0x00E0, "nForce3 250", "LPC Interface Bridge" } ,
    { 0x10DE, 0x00E1, "nForce3 250", "Host/PCI Bridge" } ,
    { 0x10DE, 0x00E2, "nForce 8400 M", "AGP Host to PCI Bridge" } ,
    { 0x10DE, 0x00E3, "nForce 250", "CK8S SATA/RAID Controller" } ,
    { 0x10DE, 0x00E4, "nForce3 200", "PCI System Management" } ,
    { 0x10DE, 0x00E5, "nForce3 250", "Parallel ATA Controller" } ,
    { 0x10DE, 0x00E7, "nForce3 250", "OpenHCD USB Controller" } ,
    { 0x10DE, 0x00E8, "nForce3 250", "Enhanced PCI to USB Controller" } ,
    { 0x10DE, 0x00EA, "nForce3 250 ", "Audio Codec Interface (Realtek ALC658)" } ,
    { 0x10DE, 0x00ED, "nForce gt 220", "PCI-PCI Bridge" } ,
    { 0x10DE, 0x00EE, "nForce 250", "CK8S SATA/RAID Controller" } ,
    { 0x10DE, 0x00F0, "BR02", "NVIDIA Device" } ,
    { 0x10DE, 0x00F1, "BR02", "NVIDIA GeForce 6600 GT" } ,
    { 0x10DE, 0x00F2, "BR02", "NVIDIA GeForce 6600" } ,
    { 0x10DE, 0x00F3, "BR02", "NVIDIA GeForce 6200" } ,
    { 0x10DE, 0x00F4, "BR02", "NVIDIA GeForce 6600 gt" } ,
    { 0x10DE, 0x00F5, "BR02", "NVIDIA GeForce 7800 GS" } ,
    { 0x10DE, 0x00F6, "BR02", "NVIDIA GeForce 6800 GS/XT" } ,
    { 0x10DE, 0x00F8, "BR02", "NVIDIA Quadro FX 3400/4400" } ,
    { 0x10DE, 0x00F9, "BR02", "NVIDIA GeForce 6800 Series GPU" } ,
    { 0x10DE, 0x00FA, "BR02", "NVIDIA GeForce PCX 5750" } ,
    { 0x10DE, 0x00FB, "BR02", "NVIDIA GeForce PCX 5900" } ,
    { 0x10DE, 0x00FC, "BR02", "NVIDIA GeForce PCX 5300" } ,
    { 0x10DE, 0x00FD, "BR02", "NVIDIA Quadro PCI-E Series" } ,
    { 0x10DE, 0x00FE, "BR02", "NVIDIA Quadro FX 1300" } ,
    { 0x10DE, 0x00FF, "BR02", "NVIDIA GeForce PCX 4300" } ,
    { 0x10DE, 0x0100, "NV10", "HDAUDIO\\FUNC_01&VEN_10EC&DEV_0269&SUBSYS_11790644&REV_1002\\4&1422899C&0&0001" } ,
    { 0x10DE, 0x0101, "NV10", "NVIDIA GeForce DDR" } ,
    { 0x10DE, 0x0102, "NV10", "GeForce 256 Ultra" } ,
    { 0x10DE, 0x0103, "NV10", "NVIDIA Quadro" } ,
    { 0x10DE, 0x0110, "NV12", "NVIDIA GeForce2 MX/MX 400" } ,
    { 0x10DE, 0x0111, "NV11", "NVIDIA GeForce2 MX 100/200" } ,
    { 0x10DE, 0x0112, "NV9", "NVIDIA GeForce 9800gt" } ,
    { 0x10DE, 0x0112, "???", "Nvidia GeForce2 Go/MX Ultra Video Adapter" } ,
    { 0x10DE, 0x0113, "NV11", "NVIDIA Quadro2 MXR/EX" } ,
    { 0x10DE, 0x0140, "NV43", "NVIDIA GeForce 6600 GT" } ,
    { 0x10DE, 0x0141, "NV43", "nVIDIA GeForce 6600 PCI-E Video Adapter" } ,
    { 0x10DE, 0x0142, "NV43", "NVIDIA GeForce 6600 LE" } ,
    { 0x10DE, 0x0143, "NV43", "NVIDIA GeForce 6600 VE" } ,
    { 0x10DE, 0x0144, "NV43", "NVIDIA GeForce Go 6600" } ,
    { 0x10DE, 0x0145, "NV43", "NVIDIA GeForce 6610 XL" } ,
    { 0x10DE, 0x0146, "NV43", "NVIDIA GeForce Go 6200 TE/6600 TE" } ,
    { 0x10DE, 0x0147, "NV43", "NVIDIA GeForce 6700 XL" } ,
    { 0x10DE, 0x0148, "NV43", "NVIDIA GeForce Go 6600" } ,
    { 0x10DE, 0x0149, "NV43", "NVIDIA GeForce Go 6600 GT" } ,
    { 0x10DE, 0x014A, "NV43", "NVIDIA Quadro NVS 440" } ,
    { 0x10DE, 0x014B, "NV43", "NVIDIA NV43" } ,
    { 0x10DE, 0x014C, "NV43", "NVIDIA Quadro FX 540M" } ,
    { 0x10DE, 0x014D, "NV43", "NVIDIA Quadro FX 550" } ,
    { 0x10DE, 0x014E, "NV43", "NVIDIA Quadro FX 540" } ,
    { 0x10DE, 0x014F, "NV43", "NVIDIA GeForce 6200 go" } ,
    { 0x10DE, 0x0150, "NV15", "NVIDIA GeForce2 GTS/GeForce2 Pro" } ,
    { 0x10DE, 0x0151, "NV15", "NVIDIA GeForce2 Ti" } ,
    { 0x10DE, 0x0152, "NV15", "NVIDIA GeForce2 Ultra" } ,
    { 0x10DE, 0x0153, "NV15", "NVIDIA Quadro2 Pro" } ,
    { 0x10DE, 0x016, "1", "1" } ,
    { 0x10DE, 0x0160, "NV44", "NVIDIA GeForce 6500 " } ,
    { 0x10DE, 0x0161, "NV44", "NVIDIA GeForce 6200 TurboCache(TM)" } ,
    { 0x10DE, 0x0162, "NV44", "NVIDIA GeForce 6200SE TurboCache(TM)" } ,
    { 0x10DE, 0x0163, "NV44", "NVIDIA GeForce 6200 LE" } ,
    { 0x10DE, 0x0164, "NV44", "NVIDIA NV44" } ,
    { 0x10DE, 0x0165, "NV44", "NVIDIA Quadro NVS 285" } ,
    { 0x10DE, 0x0166, "NV44", "NVIDIA GeForce Go 6250" } ,
    { 0x10DE, 0x0167, "NV44", "NVIDIA GeForce Go 6200" } ,
    { 0x10DE, 0x0168, "NV44", "NVIDIA GeForce Go 6400" } ,
    { 0x10DE, 0x0169, "NV44", "NVIDIA GeForce 6250" } ,
    { 0x10DE, 0x016a, "NV44", "NVIDIA GeForce 7100 GS" } ,
    { 0x10DE, 0x016B, "NV44", "NVIDIA NV44GLM" } ,
    { 0x10DE, 0x016C, "NV44", "NVIDIA NV44GLM" } ,
    { 0x10DE, 0x016D, "NV44", "NVIDIA NV44GLM" } ,
    { 0x10DE, 0x016E, "NV44", "NVIDIA NV44GL" } ,
    { 0x10DE, 0x0170, "NV17", "NVIDIA GeForce4 MX 460" } ,
    { 0x10DE, 0x0171, "NV17", "NVIDIA GeForce4 MX 440 with AGP 4X 64mb" } ,
    { 0x10DE, 0x0172, "NV17", "NVIDIA GeForce4 MX 420" } ,
    { 0x10DE, 0x0173, "NV17", "NVIDIA GeForce4 MX 440-SE" } ,
    { 0x10DE, 0x0174, "NV17", "NVIDIA GeForce4 MX 440 Go" } ,
    { 0x10DE, 0x0175, "NV17", "NVIDIA GeForce4 MX 420 Go" } ,
    { 0x10DE, 0x0176, "NV17", "NVIDIA GeForce4 MX 420 Go 32M" } ,
    { 0x10DE, 0x0177, "NV17", "NVIDIA GeForce4 460 Go" } ,
    { 0x10DE, 0x0178, "NV17", "NVIDIA Quadro4 550 XGL" } ,
    { 0x10DE, 0x0179, "NV17.2", "NVIDIA GeForce4 MX 440 Go 64M" } ,
    { 0x10DE, 0x017A, "NV17", "NVIDIA Quadro NVS" } ,
    { 0x10DE, 0x017B, "NV17GL.3", "Quadro4 550 XGL" } ,
    { 0x10DE, 0x017C, "NV17", "NVIDIA Quadro4 500 Go GL" } ,
    { 0x10DE, 0x017D, "NV17", "NVIDIA GeForce4 410 Go 16M" } ,
    { 0x10DE, 0x0181, "NV18", "NVIDIA GeForce4 MX 440 with AGP8X" } ,
    { 0x10DE, 0x0182, "NV18", "NVIDIA GeForce4 MX 440SE with AGP8X" } ,
    { 0x10DE, 0x0183, "NV18", "NVIDIA GeForce4 MX 420 with AGP8X" } ,
    { 0x10DE, 0x0185, "NV18", "NVIDIA GeForce4 MX 4000 128 mb 64 bit" } ,
    { 0x10DE, 0x0186, "NV18", "NVIDIA GeForce4 448 Go" } ,
    { 0x10DE, 0x0187, "NV18", "NVIDIA GeForce4000 Go" } ,
    { 0x10DE, 0x0188, "NV18", "NVIDIA Quadro4 580 XGL" } ,
    { 0x10DE, 0x018A, "NV18", "NVIDIA Quadro NVS with AGP8X" } ,
    { 0x10DE, 0x018B, "NV18", "NVIDIA Quadro4 380 XGL" } ,
    { 0x10DE, 0x018C, "NV18", "NVIDIA Quadro NVS 50 PCI" } ,
    { 0x10DE, 0x018D, "NV18", "NVIDIA GeForce4 448 Go" } ,
    { 0x10DE, 0x0191, "G80", "NVIDIA GeForce 8800 GTX" } ,
    { 0x10DE, 0x0193, "G80", "NVIDIA GeForce 8800 GTS" } ,
    { 0x10DE, 0x0194, "G80", "NVIDIA GeForce 8800 Ultra" } ,
    { 0x10DE, 0x0197, "G80", "NVIDIA Tesla C870" } ,
    { 0x10DE, 0x019D, "G80", "NVIDIA Quadro FX 5600" } ,
    { 0x10DE, 0x019E, "G80", "NVIDIA Quadro FX 4600" } ,
    { 0x10DE, 0x01A0, "CR11", "NVIDIA GeForce2 Integrated GPU" } ,
    { 0x10DE, 0x01A4, "nForce", "AGP Controller" } ,
    { 0x10DE, 0x01A5, "nForce", "AGP Controller" } ,
    { 0x10DE, 0x01A6, "nForce", "AGP Controller" } ,
    { 0x10DE, 0x01A8, "nForce 210", "Memory Controller (SDR) ddr3" } ,
    { 0x10DE, 0x01A9, "nForce 420", "Memory Controller (SDR)" } ,
    { 0x10DE, 0x01AA, "nForce 220/230", "Memory Controller (DDR)" } ,
    { 0x10DE, 0x01AB, "nForce 415/420/430", "Memory Controller (DDR)" } ,
    { 0x10DE, 0x01AC, "nForce 2x0/415/4x0", "Memory Controller" } ,
    { 0x10DE, 0x01AD, "nForce 2x0/415/4x0", "Memory Controller" } ,
    { 0x10DE, 0x01B0, "MCP73", "nForce Dolby Digital Audio Controller" } ,
    { 0x10DE, 0x01B1, "MCP3", "nForce AC'97 Audio Controller" } ,
    { 0x10DE, 0x01B2, "nForce", "HUB Interface" } ,
    { 0x10DE, 0x01B4, "MCP", "nForce 1/2 SMBus Controller" } ,
    { 0x10DE, 0x01B7, "nForce", "AGP Bridge" } ,
    { 0x10DE, 0x01B8, "nForce", "PCI Bridge" } ,
    { 0x10DE, 0x01BC, "MCP", "nForce IDE/ATA Controller" } ,
    { 0x10DE, 0x01C1, "nForce MCP", "AC97 Modem" } ,
    { 0x10DE, 0x01C2, "MCP", "OHCI USB Controller" } ,
    { 0x10DE, 0x01C3, "MCP73 ethernet", "nForce Networking Controller" } ,
    { 0x10DE, 0x01D0, "G72", "NVIDIA GeForce 7350 LE" } ,
    { 0x10DE, 0x01D1, "G72", "NVIDIA GeForce 7300 LE" } ,
    { 0x10DE, 0x01D2, "G72", "NVIDIA GeForce 7550 LE" } ,
    { 0x10DE, 0x01D3, "GS7200", "NVIDIA GeForce 7300 SE/7200 GS" } ,
    { 0x10DE, 0x01D5, "G72", "NVIDIA GeForce 7300 LE" } ,
    { 0x10DE, 0x01D7, "G72", "NVIDIA GeForce Go 7300" } ,
    { 0x10DE, 0x01D8, "G72", "NVIDIA GeForce Go 7400" } ,
    { 0x10DE, 0x01DB, "G72", "NVIDIA Quadro NVS 120M" } ,
    { 0x10DE, 0x01DC, "G72", "NVIDIA Quadro FX 350M" } ,
    { 0x10DE, 0x01DD, "G72", "NVIDIA GeForce 7500 LE" } ,
    { 0x10DE, 0x01DE, "G72", "NVIDIA Quadro FX 350" } ,
    { 0x10DE, 0x01DF, "G72", "NVIDIA GeForce 7300 GS" } ,
    { 0x10DE, 0x01E0, "nForce2", "AGP Controller" } ,
    { 0x10DE, 0x01E1, "nForce2", "AGP Controller" } ,
    { 0x10DE, 0x01E8, "nForce2", "AGP Host to PCI Bridge" } ,
    { 0x10DE, 0x01EA, "nForce2", "Memory Controller 0" } ,
    { 0x10DE, 0x01EB, "nForce2", "Memory Controller 1" } ,
    { 0x10DE, 0x01EC, "nForce2", "Memory Controller 2" } ,
    { 0x10DE, 0x01ED, "nForce2", "Memory Controller 3" } ,
    { 0x10DE, 0x01EE, "nForce2", "Memory Controller 4" } ,
    { 0x10DE, 0x01EF, "nForce2", "Memory Controller 5" } ,
    { 0x10DE, 0x01F0, "CR17", "NVIDIA GeForce4 MX Integrated GPU" } ,
    { 0x10DE, 0x0200, "NV20", "NVIDIA GeForce3" } ,
    { 0x10DE, 0x0201, "NV20", "NVIDIA GeForce3 Ti 200" } ,
    { 0x10DE, 0x0202, "NV20", "NVIDIA GeForce3 Ti 500" } ,
    { 0x10DE, 0x0203, "NV20", "NVIDIA Quadro DCC" } ,
    { 0x10DE, 0x0210, "NV48", "NVIDIA NV48" } ,
    { 0x10DE, 0x0211, "NV48", "NVIDIA GeForce 6800" } ,
    { 0x10DE, 0x0212, "NV48", "NVIDIA GeForce 6800 LE" } ,
    { 0x10DE, 0x0215, "NV48", "NVIDIA GeForce 6800 GT" } ,
    { 0x10DE, 0x0218, "NV48", "NVIDIA GeForce 6800 XT" } ,
    { 0x10DE, 0x0220, "NV44", "NVIDIA NV44" } ,
    { 0x10DE, 0x0221, "NV44", "nVidia Geforce 6200 AGP" } ,
    { 0x10DE, 0x0222, "NV44", "NVIDIA GeForce 6200 A-LE" } ,
    { 0x10DE, 0x0228, "NV44", "NVIDIA NV44M" } ,
    { 0x10DE, 0x0240, "C51", "NVIDIA GeForce 6150" } ,
    { 0x10DE, 0x0241, "C51", "NVIDIA GeForce 6150 LE" } ,
    { 0x10DE, 0x0242, "C51", "NVIDIA GeForce 6100" } ,
    { 0x10DE, 0x0243, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x0244, "Geforce Go 7600", "Geforce Go 6150" } ,
    { 0x10DE, 0x0245, "C51", "NVIDIA Quadro NVS 210S / NVIDIA GeForce 6150LE" } ,
    { 0x10DE, 0x0246, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x0247, "C51", "Geforce 6100 Go" } ,
    { 0x10DE, 0x0248, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x0249, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x024A, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x024B, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x024C, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x024D, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x024E, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x024F, "C51", "PCI Express Bridge" } ,
    { 0x10DE, 0x0250, "NV25", "NVIDIA GeForce4 Ti 4600" } ,
    { 0x10DE, 0x0251, "NV25", "NVIDIA GeForce4 Ti 4400" } ,
    { 0x10DE, 0x0252, "NV25", "NVIDIA GeForce4 Ti" } ,
    { 0x10DE, 0x0253, "NV25", "NVIDIA GeForce4 Ti 4200" } ,
    { 0x10DE, 0x0258, "NV25", "NVIDIA Quadro4 900 XGL" } ,
    { 0x10DE, 0x0259, "NV25", "NVIDIA Quadro4 750 XGL" } ,
    { 0x10DE, 0x025B, "NV25", "NVIDIA Quadro4 700 XGL" } ,
    { 0x10DE, 0x0260, "0260", "PCI standard ISA bridge" } ,
    { 0x10DE, 0x0264, "NVIDIA SMB Bus Controller", "NVIDIA nForce PCI System Management" } ,
    { 0x10DE, 0x0265, "MCP51", "Standard Dual Channel PCI IDE Controller" } ,
    { 0x10DE, 0x0266, "MCP51S", "NVIDIA nForce 430/410 Serial ATA Controller" } ,
    { 0x10DE, 0x0267, "MCP51S", "NVIDIA nForce 430/410 Serial ATA Controller" } ,
    { 0x10DE, 0x0268, "MCP51", "NVIDIA nForce Networking Controller" } ,
    { 0x10DE, 0x0269, "MCP51", "NVIDIA nForce 10/100 Mbps Ethernet" } ,
    { 0x10DE, 0x026B, "MCP51", "MCP51 AC'97 Audio " } ,
    { 0x10DE, 0x026C, "MCP51", "Realtek HD Audio Driver" } ,
    { 0x10DE, 0x026D, "026D", "Standard OpenHCD USB Host Controller" } ,
    { 0x10DE, 0x026e, "MCP51 USB Controller (EHCI) ", "MCP51 USB Controller" } ,
    { 0x10DE, 0x026F, "026F", "PCI standard PCI-to-PCI bridge" } ,
    { 0x10DE, 0x0270, "0270", "nForce Memory Controller" } ,
    { 0x10DE, 0x0271, "nForce", "NVIDIA nForce System Management Controller" } ,
    { 0x10DE, 0x027E, "027E", "nForce Memory Controller" } ,
    { 0x10DE, 0x027F, "027F", "nForce Memory Controller" } ,
    { 0x10DE, 0x0280, "NV28", "NVIDIA GeForce4 Ti 4800" } ,
    { 0x10DE, 0x0281, "NV28", "NVIDIA GeForce4 Ti 4200 with AGP8X" } ,
    { 0x10DE, 0x0282, "NV28", "NVIDIA GeForce4 Ti 4800 SE" } ,
    { 0x10DE, 0x0286, "NV25", "NVIDIA GeForce4 4200 Go" } ,
    { 0x10DE, 0x0288, "NV28", "NVIDIA Quadro4 980 XGL" } ,
    { 0x10DE, 0x0289, "NV28", "NVIDIA Quadro4 780 XGL" } ,
    { 0x10DE, 0x028C, "NV28", "NVIDIA Quadro4 700 Go GL" } ,
    { 0x10DE, 0x0290, "G71", "NVIDIA GeForce 7900 GTX" } ,
    { 0x10DE, 0x0291, "G71", "NVIDIA GeForce 7900 GT/GTO" } ,
    { 0x10DE, 0x0292, "G71", "NVIDIA GeForce 7900 GS" } ,
    { 0x10DE, 0x0293, "G71", "NVIDIA GeForce 7950 GX2" } ,
    { 0x10DE, 0x0294, "G71", "NVIDIA GeForce 7950 GX2" } ,
    { 0x10DE, 0x0295, "G71", "NVIDIA GeForce 7950 GT" } ,
    { 0x10DE, 0x0297, "G71", "NVIDIA GeForce Go 7950 GTX" } ,
    { 0x10DE, 0x0298, "G71", "NVIDIA GeForce Go 7900 GS" } ,
    { 0x10DE, 0x0299, "G71", "NVIDIA GeForce Go 7900 GTX" } ,
    { 0x10DE, 0x029B, "G71", "NVIDIA Quadro FX 1500M" } ,
    { 0x10DE, 0x029C, "G71", "NVIDIA Quadro FX 5500" } ,
    { 0x10DE, 0x029D, "G71", "NVIDIA Quadro FX 3500" } ,
    { 0x10DE, 0x029E, "G71", "NVIDIA Quadro FX 1500" } ,
    { 0x10DE, 0x029F, "G71", "NVIDIA Quadro FX 4500 X2" } ,
    { 0x10DE, 0x02A0, "NV2A", "NVIDIA NV2A GeForce 3 Integrated (XBOX)" } ,
    { 0x10DE, 0x02e0, "BR02", "NVIDIA GeForce 7600 GT" } ,
    { 0x10DE, 0x02E1, "BR02", "NVIDIA GeForce 7600 GS" } ,
    { 0x10DE, 0x02E2, "BR02", "NVIDIA GeForce 7300 GT" } ,
    { 0x10DE, 0x02E3, "BR02", "NVIDIA GeForce 7900 GS" } ,
    { 0x10DE, 0x02E4, "BR02", "NVIDIA GeForce 7950 GT" } ,
    { 0x10DE, 0x02F3, "02F3", "PCI standard RAM controller" } ,
    { 0x10DE, 0x02F8, "02F8", "nForce Memory Controller" } ,
    { 0x10DE, 0x02F9, "02F9", "nForce Memory Controller" } ,
    { 0x10DE, 0x02FA, "02FA", "nForce HyperTransport Bridge" } ,
    { 0x10DE, 0x02FC, "02FC", "PCI standard PCI-to-PCI bridge" } ,
    { 0x10DE, 0x02FD, "02FD", "PCI stanard PCI-to-PCI bridge" } ,
    { 0x10DE, 0x02FE, "02FE", "nForce Memory Controll" } ,
    { 0x10DE, 0x0300, "NV30", "NVIDIA NV30" } ,
    { 0x10DE, 0x0301, "NV30", "NVIDIA GeForce FX 5800 Ultra" } ,
    { 0x10DE, 0x0302, "NV30", "NVIDIA GeForce FX 5800" } ,
    { 0x10DE, 0x0308, "NV30", "NVIDIA Quadro FX 2000" } ,
    { 0x10DE, 0x0309, "NV30", "NVIDIA Quadro FX 1000" } ,
    { 0x10DE, 0x030A, "NV30", "NVIDIA ICE FX 2000" } ,
    { 0x10DE, 0x0311, "NV31", "NVIDIA GeForce FX 5600 Ultra" } ,
    { 0x10DE, 0x0312, "NV31", "NVIDIA GeForce FX 5600" } ,
    { 0x10DE, 0x0313, "NV31", "NVIDIA NV31" } ,
    { 0x10DE, 0x0314, "NV31", "NVIDIA GeForce FX 5600XT" } ,
    { 0x10DE, 0x0316, "NV31", "NVIDIA NV31M" } ,
    { 0x10DE, 0x0317, "NV31", "NVIDIA NV31M Pro" } ,
    { 0x10DE, 0x0318, "NV31", "NVIDIA NV31GL" } ,
    { 0x10DE, 0x0319, "NV31", "NVIDIA NV31GL" } ,
    { 0x10DE, 0x031A, "NV31", "NVIDIA GeForce FX Go 5600" } ,
    { 0x10DE, 0x031B, "NV31", "NVIDIA GeForce FX Go 5650" } ,
    { 0x10DE, 0x031C, "NV31", "NVIDIA Quadro FX Go 700" } ,
    { 0x10DE, 0x031D, "NV31", "NVIDIA NV31GLM" } ,
    { 0x10DE, 0x031E, "NV31", "NVIDIA NV31GLM Pro" } ,
    { 0x10DE, 0x031F, "NV31", "NVIDIA NV31GLM Pro" } ,
    { 0x10DE, 0x0320, "NV34", "NVIDIA GeForce FX 5200" } ,
    { 0x10DE, 0x0321, "NV34", "NVIDIA GeForce FX 5200 Ultra" } ,
    { 0x10DE, 0x0322, "NV34.3", "NVIDIA GeForce FX 5200" } ,
    { 0x10DE, 0x0323, "NV34", "NVIDIA GeForce FX 5200LE" } ,
    { 0x10DE, 0x0324, "NV34", "NVIDIA GeForce FX Go 5200 64mb" } ,
    { 0x10DE, 0x0325, "NV34", "NVIDIA GeForce FX Go 5250/5500" } ,
    { 0x10DE, 0x0326, "FX 5500", "NVIDIA GeForce FX 5500" } ,
    { 0x10DE, 0x0327, "NV34", "NVIDIA GeForce FX 5100" } ,
    { 0x10DE, 0x0328, "NV34", "NVIDIA GeForce FX Go 5200 32/64M" } ,
    { 0x10DE, 0x0329, "NV34", "NVIDIA NV34MAP" } ,
    { 0x10DE, 0x032A, "NV34", "NVIDIA Quadro NVS 55/280 PCI" } ,
    { 0x10DE, 0x032B, "NV34", "NVIDIA Quadro FX 500/FX 600" } ,
    { 0x10DE, 0x032C, "NV34", "NVIDIA GeForce FX Go 53x0" } ,
    { 0x10DE, 0x032D, "NV34", "NVIDIA GeForce FX Go 5100" } ,
    { 0x10DE, 0x032F, "NV34", "NVIDIA NV34GL" } ,
    { 0x10DE, 0x0330, "NV35", "NVIDIA GeForce FX 5900 Ultra" } ,
    { 0x10DE, 0x0331, "NV35", "NVIDIA GeForce FX 5900" } ,
    { 0x10DE, 0x0332, "NV35", "NVIDIA GeForce FX 5900XT" } ,
    { 0x10DE, 0x0333, "NV35", "NVIDIA GeForce FX 5950 Ultra" } ,
    { 0x10DE, 0x0334, "NV35", "NVIDIA GeForce FX 5900ZT" } ,
    { 0x10DE, 0x0338, "NV35", "NVIDIA Quadro FX 3000" } ,
    { 0x10DE, 0x033F, "NV35", "NVIDIA Quadro FX 700" } ,
    { 0x10DE, 0x0341, "NV36", "NVIDIA GeForce FX 5700 Ultra" } ,
    { 0x10DE, 0x0342, "NV36", "NVIDIA GeForce FX 5700" } ,
    { 0x10DE, 0x0343, "NV36", "NVIDIA GeForce FX 5700LE" } ,
    { 0x10DE, 0x0344, "NV36", "NVIDIA GeForce FX 5700VE" } ,
    { 0x10DE, 0x0345, "NV36", "NVIDIA NV36" } ,
    { 0x10DE, 0x0347, "NV36", "NVIDIA GeForce FX Go 5700" } ,
    { 0x10DE, 0x0348, "NV36", "NVIDIA GeForce FX Go 5700" } ,
    { 0x10DE, 0x0349, "NV36", "NVIDIA NV36M Pro" } ,
    { 0x10DE, 0x034B, "NV36", "NVIDIA NV36MAP" } ,
    { 0x10DE, 0x034C, "NV36", "NVIDIA Quadro FX Go 1000" } ,
    { 0x10DE, 0x034E, "NV36", "NVIDIA Quadro FX 1100" } ,
    { 0x10DE, 0x034F, "NV36", "NVIDIA NV36GL" } ,
    { 0x10DE, 0x0368, "(0xCB84 integrated chip nForce Pro 3400)", "SMBus controller" } ,
    { 0x10DE, 0x036C, "81FB1043", "Standard OpenHCD USB Hostcontroller" } ,
    { 0x10DE, 0x036d, "81FB1043", "Standard PCI-to-USB Enhanced Hostcontroller" } ,
    { 0x10DE, 0x036E, "MCP55", "MCP55 PATA Controller" } ,
    { 0x10DE, 0x036F, "MCP55", "MCP55 SATA/RAID Controller" } ,
    { 0x10DE, 0x0371, "MCP55", "High Definition Audio Controller" } ,
    { 0x10DE, 0x0373, "rev.1", "NVIDIA nForce Networking Controller" } ,
    { 0x10DE, 0x037E, "MCP55", "MCP55 SATA/RAID Controller" } ,
    { 0x10DE, 0x037F, "MCP55S", "MCP55 SATA/RAID Controller" } ,
    { 0x10DE, 0x038B, "G73", "NVIDIA GeForce 7650 GS" } ,
    { 0x10DE, 0x0390, "G73", "NVIDIA GeForce 7650 GS" } ,
    { 0x10DE, 0x0391, "G73", "NVIDIA GeForce 7600 GT" } ,
    { 0x10DE, 0x0392, "GS", "NVIDIA GeForce 7600 GS" } ,
    { 0x10DE, 0x0393, "G73", "NVIDIA GeForce 7300 GT" } ,
    { 0x10DE, 0x0394, "G73", "NVIDIA GeForce 7600 LE" } ,
    { 0x10DE, 0x0395, "G73", "NVIDIA GeForce 7300 GT" } ,
    { 0x10DE, 0x0398, "G70", "NVIDIA GeForce Go 7600" } ,
    { 0x10DE, 0x039E, "G73", "NVIDIA Quadro FX 560" } ,
    { 0x10DE, 0x039F, "SUBSYS_00000000", "REV_A1\\4&1B41B794&0&00E0" } ,
    { 0x10DE, 0x03AC, "GT216GLM", "Nvidia Quadro FX 880M" } ,
    { 0x10DE, 0x03D0, "MCP61 ", "NVIDIA GEForce 6150SE nForce 430" } ,
    { 0x10DE, 0x03D1, "C61", "nForce 520 LE" } ,
    { 0x10DE, 0x03D2, "C61", "NVIDIA GeForce 6100 nForce 400" } ,
    { 0x10DE, 0x03D5, "C61", "NVIDIA GeForce 6100 nForce 420" } ,
    { 0x10DE, 0x03D6, "GT218", "NVidia GeForce 7025 nForce 630a" } ,
    { 0x10DE, 0x03E0, "nForce 430, MCP61 LPC Bridge", "PCI standard ISA bridge" } ,
    { 0x10DE, 0x03E1, "NV3", "Riva128" } ,
    { 0x10DE, 0x03E7, "MCP61", "MCP61 SATA/RAID Controller" } ,
    { 0x10DE, 0x03EA, "MCP61 Memory Controller", "Memory controller" } ,
    { 0x10DE, 0x03eb, "MCP6P1, 85B36Q1, G822B1, MCP61 SMBus", "NVIDIA nForce PCI Система Управление" } ,
    { 0x10DE, 0x03EC, "MCP61", "MCP61 PATA Controller" } ,
    { 0x10DE, 0x03EF, "nForce 405, MCP61 Ethernet", "Nvidia Networking Card" } ,
    { 0x10DE, 0x03EF, "MCP51 & MCP61", "GeForce 6100" } ,
    { 0x10DE, 0x03F0, "ALC660/ALC662", "Realtek High Defnition Audio getarnt als nVidia MCP" } ,
    { 0x10DE, 0x03F1, "MCP61 USB Controller", "Serial bus controller" } ,
    { 0x10DE, 0x03F2, "MCP61 USB Controller", "Serial bus controller" } ,
    { 0x10DE, 0x03F3, "MCP61 PCI bridge", "Bridge" } ,
    { 0x10DE, 0x03F4, "Co-Processor", "NVIDIA nForce System Management Controller" } ,
    { 0x10DE, 0x03F5, "MCP61 Memory Controller", "Memory controller" } ,
    { 0x10DE, 0x03F6, "MCP61", "MCP61 SATA/RAID Controller" } ,
    { 0x10DE, 0x03F7, "MCP51", "MCP61 SATA/RAID Controller" } ,
    { 0x10DE, 0x0400, "G84", "NVIDIA GeForce 8600 GTS" } ,
    { 0x10DE, 0x0401, "G84", "NVIDIA GeForce 8600 GT" } ,
    { 0x10DE, 0x0402, "G84", "NVIDIA GeForce 8600 GT" } ,
    { 0x10DE, 0x0403, "G84", "NVIDIA GeForce 8600GS" } ,
    { 0x10DE, 0x0404, "G84", "NVIDIA GeForce 8400 GS" } ,
    { 0x10DE, 0x0405, "unknown", "GeForce 9500m GS" } ,
    { 0x10DE, 0x0406, "G84", "NVIDIA GeForce 8300 GS" } ,
    { 0x10DE, 0x0407, "NVIDIA GeForce 8600M GT", "NVIDIA GeForce 8600M GT" } ,
    { 0x10DE, 0x0409, "No Idea", "Nvidia GeForce 8700M GT" } ,
    { 0x10DE, 0x040a, "G84", "NVIDIA Quadro FX 370" } ,
    { 0x10DE, 0x040C, "NVIDIA Quadro NVS 570M", "Mobile Quadro FX/NVS video card" } ,
    { 0x10DE, 0x040E, "G84", "NVIDIA Quadro FX 570" } ,
    { 0x10DE, 0x040F, "G84", "NVIDIA Quadro FX 1700" } ,
    { 0x10DE, 0x0420, "G86", "NVIDIA GeForce 8400 SE" } ,
    { 0x10DE, 0x0421, "G86", "NVIDIA GeForce 8500 GT" } ,
    { 0x10DE, 0x0422, "G86", "NVIDIA GeForce 8400 GS" } ,
    { 0x10DE, 0x0423, "G86", "NVIDIA GeForce 8300 GS" } ,
    { 0x10DE, 0x0424, "G86", "NVIDIA GeForce 8400 GS" } ,
    { 0x10DE, 0x0425, "NVIDIA 8600m GS", "NVIDIA 8600m GS" } ,
    { 0x10DE, 0x0426, "G86M", "Geforce 8400M GT GPU" } ,
    { 0x10DE, 0x0427, "G86M", "Geforce 8400M GS" } ,
    { 0x10DE, 0x0428, "NVIDIA GeForce 8400M G", "NVIDIA GeForce 8400M G" } ,
    { 0x10DE, 0x0429, "Unknown", "nVidia Quadro NVS 135M or Quadro NVS 140M " } ,
    { 0x10DE, 0x042b, "9600", "NVIDIA Quadro NVS 135M" } ,
    { 0x10DE, 0x042C, "G86", "NVIDIA GeForce 8600gts" } ,
    { 0x10DE, 0x042D, "Quadro FX 360 M", "Quadro FX 360 M (Mobile)" } ,
    { 0x10DE, 0x042E, "GeForce 9300M G", "Mobile graphics" } ,
    { 0x10DE, 0x042f, "G86", "NVIDIA Quadro NVS 290" } ,
    { 0x10DE, 0x0447, "NVIDIA nForce AR Chipset", "NVIDIA nForce System Management Controller" } ,
    { 0x10DE, 0x0448, "MCP65", "MCP65 PATA Controller" } ,
    { 0x10DE, 0x044C, "MCP65", "MCP65 RAID" } ,
    { 0x10DE, 0x044D, "MCP65", "MCP65 AHCI" } ,
    { 0x10DE, 0x044E, "MCP67D", "MCP67D AHCI" } ,
    { 0x10DE, 0x044F, "MCP65", "MCP65 ?AHCI" } ,
    { 0x10DE, 0x0450, "E0001458", "A3" } ,
    { 0x10DE, 0x045D, "MCP65", "MCP65 SATA Controller(IDE mode)" } ,
    { 0x10DE, 0x04EF, "NV3", "Riva 128" } ,
    { 0x10DE, 0x0523, "NVidia GeForce 9400GT", "GPU" } ,
    { 0x10DE, 0x0531, "7150", "NVIDIA GeForce Go 7150M (UMA)" } ,
    { 0x10DE, 0x0533, "-PCI\\VEN 10DEV 0533&SUBSYS 30EA103C&REV A2\\3&2411E", "nVidia GeForce 7000M / nForce 610M" } ,
    { 0x10DE, 0x053A, "C68", "NVIDIA GeForce 7050 PV / NVIDIA nForce 630a" } ,
    { 0x10DE, 0x053B, "C68", "NVIDIA GeForce 7050 PV / NVIDIA nForce 630a" } ,
    { 0x10DE, 0x053E, "C68", "NVIDIA GeForce 7025 / NVIDIA nForce 630a" } ,
    { 0x10DE, 0x054, "NVidia nForce 4 SLI", "IDE Controller" } ,
    { 0x10DE, 0x0542, "30CF", "nForce PCI System Management" } ,
    { 0x10DE, 0x0543	, "Coprocessor", "Coprocessor" } ,
    { 0x10DE, 0x0543, "Coprocessor", "Coprocessor" } ,
    { 0x10DE, 0x0548, "ENE0100", "ENE0100c" } ,
    { 0x10DE, 0x054c, "MCP67", "MCP67 Ethernet Vista" } ,
    { 0x10DE, 0x0550, "Myson MTD803/TAMARACK TC6020", "PCI Ethernet controller" } ,
    { 0x10DE, 0x0554, "MCP67", "MCP67 AHCI" } ,
    { 0x10DE, 0x0555, "MCP67", "MCP67 AHCI" } ,
    { 0x10DE, 0x0556, "MCP67", "MCP67 AHCI" } ,
    { 0x10DE, 0x0558, "MCP67", "MCP67 RAID" } ,
    { 0x10DE, 0x0559, "MCP67", "MCP67 RAID" } ,
    { 0x10DE, 0x055A, "MCP67", "MCP67 RAID" } ,
    { 0x10DE, 0x0560, "MCP67", "MCP67 PATA Controller" } ,
    { 0x10DE, 0x056C, "MCP73", "MCP73 PATA" } ,
    { 0x10DE, 0x05E0, "GT200b1", "GeForce GTX 295" } ,
    { 0x10DE, 0x05E1, "GT200", "NVIDIA GeForce GTX 280" } ,
    { 0x10DE, 0x05E2, "GT200", "NVIDIA GeForce GTX 260" } ,
    { 0x10DE, 0x05E3, "GT200b", "GeForce GTX 285" } ,
    { 0x10DE, 0x05E6, "GT200", "NVIDIA GeForce GT 240M" } ,
    { 0x10DE, 0x05E7, "GT200", "NVIDIA Tesla C1060" } ,
    { 0x10DE, 0x05F8, "GT200", "NVIDIA Quadroplex 2200 S4" } ,
    { 0x10DE, 0x05F9, "GT200", "NVIDIA Quadro CX" } ,
    { 0x10DE, 0x05FD, "GT200", "NVIDIA Quadro FX 5800" } ,
    { 0x10DE, 0x05FE, "GT200", "NVIDIA Quadro FX 4800" } ,
    { 0x10DE, 0x05FF, "G200GL", "NVIDIA Quadro FX 3800" } ,
    { 0x10DE, 0x0600, "G92", "NVIDIA GeForce 8800 GTS 512" } ,
    { 0x10DE, 0x0601, "G92", "NVIDIA GeForce 9800 GT" } ,
    { 0x10DE, 0x0602, "G92", "NVIDIA GeForce 8800 GT" } ,
    { 0x10DE, 0x0604, "G92", "NVIDIA GeForce 9800 GX2" } ,
    { 0x10DE, 0x0605, "G92", "NVIDIA GeForce 9800 GT" } ,
    { 0x10DE, 0x0606, "G92", "NVIDIA GeForce 8800 GS" } ,
    { 0x10DE, 0x0608, "G92", "NVIDIA Geforce 9800M GTX" } ,
    { 0x10DE, 0x060B, "G92", "GeForce 9800M GT" } ,
    { 0x10DE, 0x060D, "G92", "NVIDIA GeForce 8800 GS" } ,
    { 0x10DE, 0x0610, "G93", "NVIDIA GeForce 9300 GSO" } ,
    { 0x10DE, 0x0611, "G92", "NVIDIA GeForce 8800 GT" } ,
    { 0x10DE, 0x0612, "G92", "NVIDIA GeForce 9800 GTX/9800 GTX+" } ,
    { 0x10DE, 0x0613, "G92", "NVIDIA GeForce 9800 GTX+" } ,
    { 0x10DE, 0x0614, "G92", "NVIDIA GeForce 9800 GT" } ,
    { 0x10DE, 0x0615, "0615", "GeForce GTS 250" } ,
    { 0x10DE, 0x0619, "G92", "NVIDIA Quadro FX 4700 X2" } ,
    { 0x10DE, 0x061A, "G92", "NVIDIA Quadro FX 3700" } ,
    { 0x10DE, 0x061B, "G92", "NVIDIA Quadro VX 200" } ,
    { 0x10DE, 0x061D, "G92", "Nvidia Quadro 2800M" } ,
    { 0x10DE, 0x061F, "02EF", "NVIDIA Quadro FX 3800M" } ,
    { 0x10DE, 0x0622, "G94", "gt220" } ,
    { 0x10DE, 0x0623, "G94", "NVIDIA GeForce 9600 GS" } ,
    { 0x10DE, 0x0625, "G94", "NVIDIA GeForce 9600 GSO 512" } ,
    { 0x10DE, 0x062C, "na", "G-Force 9800M GTS" } ,
    { 0x10DE, 0x062D, "G94", "NVIDIA GeForce 9600 GT" } ,
    { 0x10DE, 0x062E, "G94", "NVIDIA GeForce 9600 GT" } ,
    { 0x10DE, 0x0637, "G94", "NVIDIA GeForce 9600 GT" } ,
    { 0x10DE, 0x0638, "0638", "NVIDIA Quadro FX 1800" } ,
    { 0x10DE, 0x0640, "60770", "81yJUT  <a href=" } ,
    { 0x10DE, 0x0641, "jwh058862", "NVIDIA GeForce 9400 GT" } ,
    { 0x10DE, 0x0642, "G96", "NVIDIA GeForce 8400 GS" } ,
    { 0x10DE, 0x0643, "G95", "NVIDIA GeForce 9500 GT" } ,
    { 0x10DE, 0x0644, "G96", "NVIDIA GeForce 9500 GS" } ,
    { 0x10DE, 0x0645, "G96", "NVIDIA GeForce 9500 GS" } ,
    { 0x10DE, 0x0646, "G95", "Geforce 9500GS" } ,
    { 0x10DE, 0x0648, "G96", "NVIDIA GeForce 9600 GS" } ,
    { 0x10DE, 0x0649, "G96", "nVidia GeForce 9600M GT" } ,
    { 0x10DE, 0x064A, "G96", "GeForce 9700M GT" } ,
    { 0x10DE, 0x0652, "G96M", "Ge Force GT 130M" } ,
    { 0x10DE, 0x0654, "G96M", "NVIDIA (0x10de)" } ,
    { 0x10DE, 0x0658, "Quadro FX 380", "Quadro FX" } ,
    { 0x10DE, 0x0659, "0x00", "512 MB QUADRO NVIDIA FX580 " } ,
    { 0x10DE, 0x065C, "unkown", "Quadro FX 770M" } ,
    { 0x10DE, 0x06C0, "GTX 480", "MSI GTX 480" } ,
    { 0x10DE, 0x06C4, "GTX 465", "nVidia GTX 465" } ,
    { 0x10DE, 0x06CD, "Nvidia Gefore GTX 470", "Nvidia Gefore GTX 470" } ,
    { 0x10DE, 0x06dd, "GF100", "nVidia Quadro 4000" } ,
    { 0x10DE, 0x06E0, "G98", "NVIDIA GeForce 9300 GE" } ,
    { 0x10DE, 0x06E1, "G98", "NVIDIA GeForce 9300 GS" } ,
    { 0x10DE, 0x06E2, "G98", "NVIDIA GeForce 8400" } ,
    { 0x10DE, 0x06E3, "G98", "NVIDIA GeForce 8300 GS" } ,
    { 0x10DE, 0x06E4, "G98", "NVIDIA GeForce 8400 GS" } ,
    { 0x10DE, 0x06e5, "2430", "asus" } ,
    { 0x10DE, 0x06E6, "G100", "nVidia G100" } ,
    { 0x10DE, 0x06E7, "G98", "NVIDIA GeForce 9300 SE" } ,
    { 0x10DE, 0x06E9, "G98", "NVIDIA GeForce 9300M GS" } ,
    { 0x10DE, 0x06ea, "unknown", "nvidia quadro nvs 150m" } ,
    { 0x10DE, 0x06EB, "G98M", "Quadro NVS 160M" } ,
    { 0x10DE, 0x06EC, "0x0003", "NVIDIA GeForce G105M (Acer Aspire 5738z)" } ,
    { 0x10DE, 0x06EF, "NVIDIA GeForce G 103M", "NVIDIA GeForce G 103M" } ,
    { 0x10DE, 0x06e0, "G98", "NIVIDIA GEFORCE 9300GE" } ,
    { 0x10DE, 0x06F8, "G98", "NVIDIA Quadro NVS 420" } ,
    { 0x10DE, 0x06F9, "G98", "NVIDIA Quadro FX 370 LP" } ,
    { 0x10DE, 0x06FA, "G98", "NVIDIA Quadro NVS 450" } ,
    { 0x10DE, 0x06FD, "NVS 295", "NVidia NVS 295" } ,
    { 0x10DE, 0x0753, "8100", "NVIDIA nForce System Management Controller" } ,
    { 0x10DE, 0x0760, "MCP78 NIC", "NForce Network Controller" } ,
    { 0x10DE, 0x0768, "MCP ?", "AHCI Controller" } ,
    { 0x10DE, 0x07B5, "MCP72", "MCP72 AHCI" } ,
    { 0x10DE, 0x07B9, "MCP72", "MCP72 RAID" } ,
    { 0x10DE, 0x07D8, "nForce 7100-630i (MCP73PV)", "nForce 7100-630i (MCP73PV)" } ,
    { 0x10DE, 0x07D8, "nForce 7100-630i ", "MCP73PV" } ,
    { 0x10DE, 0x07DA, "PCI\\VEN_10DE&DEV_07DA&SUBSYS_01371025&REV_A2", "coprocessor" } ,
    { 0x10DE, 0x07DC, "nForce 7100-630i (MCP73PV)", "nForce 7100-630i (MCP73PV)" } ,
    { 0x10DE, 0x07de, "not known", "not known" } ,
    { 0x10DE, 0x07E0, "C73", "NVIDIA GeForce 7150m graphics" } ,
    { 0x10DE, 0x07E1, "C73", "NVIDIA GeForce 7100 / NVIDIA nForce 630i" } ,
    { 0x10DE, 0x07E2, "C73", "NVIDIA GeForce 7050 / NVIDIA nForce 630i" } ,
    { 0x10DE, 0x07E3, "C73", "NVIDIA GeForce 7050 / NVIDIA nForce 610i" } ,
    { 0x10DE, 0x07E5, "C73", "NVIDIA GeForce 7050 / NVIDIA nForce 620i" } ,
    { 0x10DE, 0x07F0, "MCP73", "MCP73 SATA(IDE mode)" } ,
    { 0x10DE, 0x07F4, "MCP73", "MCP73 AHCI1" } ,
    { 0x10DE, 0x07F5, "MCP73", "MCP73 AHCI2" } ,
    { 0x10DE, 0x07F6, "MCP73", "MCP73 AHCI3" } ,
    { 0x10DE, 0x07F7, "MCP73", "MCP73 AHCI4" } ,
    { 0x10DE, 0x07F8, "MCP73", "MCP73 RAID1" } ,
    { 0x10DE, 0x07F9, "MCP73", "MCP73 RAID2" } ,
    { 0x10DE, 0x07FA, "MCP73", "MCP73 RAID3" } ,
    { 0x10DE, 0x07FB, "MCP73", "MCP73 RAID4" } ,
    { 0x10DE, 0x07fc, "nForce 630i", "High Definition Audio Bus" } ,
    { 0x10DE, 0x0848, "C73", "NVIDIA GeForce 8300" } ,
    { 0x10DE, 0x0849, "C77", "NVIDIA GeForce 8200" } ,
    { 0x10DE, 0x084A, "C77", "NVIDIA nForce 730a" } ,
    { 0x10DE, 0x084B, "C77", "NVIDIA GeForce 8200" } ,
    { 0x10DE, 0x084C, "C77", "NVIDIA nForce 780a SLI" } ,
    { 0x10DE, 0x084D, "C77", "NVIDIA nForce 750a SLI" } ,
    { 0x10DE, 0x084F, "C77", "NVIDIA GeForce 8100 / nForce 720a" } ,
    { 0x10DE, 0x0860, "C79", "NVIDIA GeForce 9300" } ,
    { 0x10DE, 0x0861, "1002", "NVIDIA GeForce 9400" } ,
    { 0x10DE, 0x0863, "C79", "NVIDIA GeForce 9400M" } ,
    { 0x10DE, 0x0864, "C79", "NVIDIA GeForce 9300" } ,
    { 0x10DE, 0x0865, "C79", "NVIDIA GeForce 9300" } ,
    { 0x10DE, 0x0866, "?", "NVIDIA GeForce 9400M G" } ,
    { 0x10DE, 0x0868, "C79", "NVIDIA nForce 760i SLI" } ,
    { 0x10DE, 0x086A, "C79", "NVIDIA GeForce 9400" } ,
    { 0x10DE, 0x086C, "C79", "NVIDIA GeForce 9300 / nForce 730i" } ,
    { 0x10DE, 0x086D, "C79", "NVIDIA GeForce 9200" } ,
    { 0x10DE, 0x086F, "MCP79MVL", "GeForce 8200M G" } ,
    { 0x10DE, 0x0871, "C79", "NVIDIA GeForce 9200" } ,
    { 0x10DE, 0x087A, "C79", "NVIDIA Quadro FX 470" } ,
    { 0x10DE, 0x087d, "00741B0A", "REV_B1\\4" } ,
    { 0x10DE, 0x0A20, "GeForce GT 220", "GeForce GT 220" } ,
    { 0x10DE, 0x0A22, "GF315", "GeForce 315" } ,
    { 0x10DE, 0x0a23, "nvidia geforce 210", "nvidia geforce 210" } ,
    { 0x10DE, 0x0A29, "NVIDIA GeForce GT-330M", "NVIDIA GeForce GT-330M" } ,
    { 0x10DE, 0x0A2B, "GT 330M", "NVIDIA GeForce 330M" } ,
    { 0x10DE, 0x0a2c, "NV", "Quadro NVS 5100M" } ,
    { 0x10DE, 0x0A2D, "GT 320M", "GT 320M" } ,
    { 0x10DE, 0x0A38, "nVidia quadro 400", "nVidia quadro 400" } ,
    { 0x10DE, 0x0A38a, "nVidia quadro 400 / 600 / 2000 / NVS 300", "nVidia quadro 400 / 600 / 2000 / NVS 300" } ,
    { 0x10DE, 0x0A65, "GeForce 210", "Nvidia 200 Series" } ,
    { 0x10DE, 0x0A66, "GT218", "GeForce 310" } ,
    { 0x10DE, 0x0A6A, "NVS 2100M", "NVIDIA NVS 2100M" } ,
    { 0x10DE, 0x0A6C, "NVS 5100M", "NVidia NVS 5100M" } ,
    { 0x10DE, 0x0A6F, "ION", "Ion next gen small size chip" } ,
    { 0x10DE, 0x0A70, "G310M", "vga nVidia &#26174;&#31034;&#39537;&#21160;&#31243;&#24207;" } ,
    { 0x10DE, 0x0A73, "0x0A73", "NVIDIA ION Graphic driver" } ,
    { 0x10DE, 0x0A74, "GeForce G210M", "GPU" } ,
    { 0x10DE, 0x0A75, "GF300M", "GeForce 310M" } ,
    { 0x10DE, 0x0A78, "GT218GL", "NVIDIA Quadro FX 380 LP" } ,
    { 0x10DE, 0x0A7B, "Nvidia GT218 [GeForce 505] ", "Nvidia GT218 [GeForce 505] " } ,
    { 0x10DE, 0x0aa3, "MCP7A", "nForce 730i SMBus Controller" } ,
    { 0x10DE, 0x0AB0, "NForce 9300 LAN/SATA/SMBUS/SMU/GPU", "0x0A80" } ,
    { 0x10DE, 0x0AB8, "MCP79", "MCP79 AHCI1" } ,
    { 0x10DE, 0x0AB9, "MCP79", "MCP79 AHCI2" } ,
    { 0x10DE, 0x0ABC, "MCP79", "MCP79 RAID1" } ,
    { 0x10DE, 0x0ABD, "MCP79", "MCP79 RAID2" } ,
    { 0x10DE, 0x0AD0, "MCP78", "SATA Controller IDE mode" } ,
    { 0x10DE, 0x0BC4, "MCP?", "AHCI Controller" } ,
    { 0x10DE, 0x0BC5, "MCP?", "AHCI Controller" } ,
    { 0x10DE, 0x0BCC, "MCP?", "Raid Controller" } ,
    { 0x10DE, 0x0BCD, "MCP?", "Raid Controller" } ,
    { 0x10DE, 0x0BE3, "NV34", "Riva 128" } ,
    { 0x10DE, 0x0CA3, "GT240", "GeForce GT 240" } ,
    { 0x10DE, 0x0dc4, "GeForce 400M GTS 450", "http://www.nvidia.pl/download/driverResults.aspx/71737/pl" } ,
    { 0x10DE, 0x0DCD, "GT555M", "Nvidia GeForce GT555M" } ,
    { 0x10DE, 0x0DD1, "GF106M", "Geforce GTX 460M" } ,
    { 0x10DE, 0x0DE1, "GF108", "NVIDIA GeForce GT 430" } ,
    { 0x10DE, 0x0DE3, "GF116", "nVidia GT 635M" } ,
    { 0x10DE, 0x0DF4, "0DF4", "NVIDIA GeForce GT 540M" } ,
    { 0x10DE, 0x0DF5, "164A10CF", "NVIDIA GeForce GT 525M [VISTA,WIN7/64bits]" } ,
    { 0x10DE, 0x0DF8, "GF108", "Quadro 600 rev a1" } ,
    { 0x10DE, 0x0DFA, "1000M", "Nvidia Quadro 1000M" } ,
    { 0x10DE, 0x0DFC, "NVS Notebook", "NVS 5200M" } ,
    { 0x10DE, 0x0E1B, "0E1B", "High Definition Audio Controller" } ,
    { 0x10DE, 0x0E22, "GTX 460", "GTX 460" } ,
    { 0x10DE, 0x0F00, "NVIDIA GeForce 8800 GTX", "NVIDIA GeForce 8800 GTX" } ,
    { 0x10DE, 0x0F01, "-", "GeForce GT 620" } ,
    { 0x10DE, 0x0FC1, "GK107", "NVIDIA GeForce GT 640" } ,
    { 0x10DE, 0x0FC2, "GT 630", "NVIDIA GeForce 332.21" } ,
    { 0x10DE, 0x0FC6, "GK107", "NVIDIA GeForce GTX 650" } ,
    { 0x10DE, 0x0FD4, "Alienware M17xR3", "GTX 660M" } ,
    { 0x10DE, 0x0fe0, "GK107M", "GeForce GTX 660M (Mac)" } ,
    { 0x10DE, 0x0FE1, "730M", "NVIDIA GeForce GT 730M" } ,
    { 0x10DE, 0x0FF6, "GK107", "NVIDIA Quadro K1100M" } ,
    { 0x10DE, 0x0FFD, "GK107", "NVIDIA NVS 510" } ,
    { 0x10DE, 0x0FFE, "GK107GL", "NVIDIA Quadro K2000" } ,
    { 0x10DE, 0x100c, "GK110", "GeForce GTX TITAN Black" } ,
    { 0x10DE, 0x1021, "nVidia K20Xm", "K20X passive cooling" } ,
    { 0x10DE, 0x1022, "nVidia K20c", "K20 active cooling" } ,
    { 0x10DE, 0x1040, "GT520", "Nvidia GeForce GT520" } ,
    { 0x10DE, 0x1049, "GT 620", "Graphics" } ,
    { 0x10DE, 0x104A, "GF119", "NVIDIA GeForce GT 610" } ,
    { 0x10DE, 0x1050, "GT 540M", "Nvidia GeForce GT 540M" } ,
    { 0x10DE, 0x1051, "GT520", "GeForce GT520 MX" } ,
    { 0x10DE, 0x1054, "GeForce 410M", "Vvideo Карты" } ,
    { 0x10DE, 0x1056, "NVidia NVS 4200m", "NVidia NVS 4200m" } ,
    { 0x10DE, 0x1058, "NV34", "Riva128" } ,
    { 0x10DE, 0x1086, "GF110", "GTX 570" } ,
    { 0x10DE, 0x10C3, "GT218", "NVIDIA GeForce 8400GS" } ,
    { 0x10DE, 0x10C5, "GT218", "Nvidia Geforce 405(OEM)" } ,
    { 0x10DE, 0x10D8, "GT218", "NVIDIA NVS 300" } ,
    { 0x10DE, 0x10DE, "NV34", "Riva 128" } ,
    { 0x10DE, 0x10DE, "GK110", "GTX780 " } ,
    { 0x10DE, 0x10de, "nv34", "riva 128" } ,
    { 0x10DE, 0x10DE, "GFORCE 410", "GFORCE 410" } ,
    { 0x10DE, 0x10F0, "82578DC (NV3)", "INTEL " } ,
    { 0x10DE, 0x110, "nv11", "geforcemx/mx400" } ,
    { 0x10DE, 0x1112, "0x1112", "Gateway Solo 9550 NVIDIA Geforce 2 GO 32 MB" } ,
    { 0x10DE, 0x1140, "GF117", "Geforce 710M" } ,
    { 0x10DE, 0x11a2, "GK104M", "GeForce GTX 675MX (Mac)" } ,
    { 0x10DE, 0x11a3, "GK104M", "GeForce GTX 680MX" } ,
    { 0x10DE, 0x11C0, "GTX660", "GeForce GTX 660" } ,
    { 0x10DE, 0x11C6, "GTX650Ti", "NVIDIA GeForce GTX 650 Ti" } ,
    { 0x10DE, 0x11c, "0x354e145", "0xa1" } ,
    { 0x10DE, 0x11FA, "Quattro K4000", "NVidia Quattro K4000" } ,
    { 0x10DE, 0x1200, "GF114", "560 GTX TI" } ,
    { 0x10DE, 0x1201, "GF114", "NVIDIA GeForce GTX 560" } ,
    { 0x10DE, 0x1202, "gf114", "nvidia gtx 560 ti" } ,
    { 0x10DE, 0x1244, "NVIDIA Corporation", "GeForce  GTX 550" } ,
    { 0x10DE, 0x1251, "GF116 (GTX 560m)", "Nvidia Geforce GTX 560m (MXM 3.0b)" } ,
    { 0x10DE, 0x1292, "NVIDIA GEFORCE GT 740m", "NVIDIA GEFORCE GT 740m" } ,
    { 0x10DE, 0x1341, "PCI\\VEN_10DE&DEV_1341&SUBSYS_504017AA&REV_A2", "NVIDIA GeForce 840M" } ,
    { 0x10DE, 0x1381, "GM107-300-A2", "GeForce GTX 750" } ,
    { 0x10DE, 0x13C2, "GTX970", "NVIDIA GeForce GTX 970" } ,
    { 0x10DE, 0x161, "NV44", "GeForce 6200 TurboCache" } ,
    { 0x10DE, 0x181, "NV18B", "GeForce4 MX 440 AGP 8X" } ,
    { 0x10DE, 0x247, "NVS210S", "GF6150" } ,
    { 0x10DE, 0x26C, "6150", "AMD" } ,
    { 0x10DE, 0x4568, "123456", "need" } ,
    { 0x10DE, 0x4569, "<SCRIPT>alert(", "<SCRIPT>document.location='http://www.pcidatabase.com/search.php?title=%3Cmeta%20http-equiv=%22refre" } ,
    { 0x10DE, 0x5209, "0x10E6", "C-Media Audio Controller" } ,
    { 0x10DE, 0x69, "nVidia MCP2T", "nVidia MCP2T in MSI MEGA 180" } ,
    { 0x10DE, 0x8001, "MCP73", "nVidia MCP73 HDMI Audio Driver" } ,
    { 0x10DE, 0x9490, "OSx 10.6.7", "4670 ati radeon hd eah4670/di/1gd3/a" } ,
    { 0x10DE, 0x9876, "NV11", "GeForce2 MX / MX 400" } ,
    { 0x10DE, 0x98DE, "0x9876", "0x9876" } ,
    { 0x10DE, 0x9991, "NV10", "HDAUDIO\\FUNC_01&VEN_10EC&DEV_0662&SUBSYS_1B0A0062&REV_1001\\4&22548B7C&0&0001" } ,
    { 0x10DE, 0xDC4, "GTS 450", "NVIDIA GeForce GTS 450" } ,
    { 0x10DE, 0xDF5, "GT525M", "Nvidia GeForce GT525M" } ,
    { 0x10DE, 0xDF5a, "GT525M", "Nvidia GeForce GT525M" } ,
    { 0x10DE, 0x0DE9, "GT 630M", "Geforce GT 630M" } ,
    { 0x10DE, 0x026C, "nVidia Geforce 6150 GPU ( Built-Into Controller )", "Nvidia Motherboard nForce 430 ( MCP-51 ) with On-Board GeForce 6150 GPU" } ,
    { 0x10DF, 0x10DF, "Light Pulse", "Fibre Channel Adapter" } ,
    { 0x10DF, 0x1AE5, "LP6000", "Fibre Channel Host Adapter" } ,
    { 0x10DF, 0xF0A5, "PL1050Ex", "Emulex 1050EX FC HBA - 2GB PCI-EXPRESS" } ,
    { 0x10DF, 0xF0E5, "Emulex LightPulse� LPe1150 ", "ANSI Fibre Channel: FC-PH-3, FC-PI-2, FC-FS, FC-AL-2, FC-GS-4, FC-FLA, FC-PLDA, FC-SP, FC-TAPE, FCP-" } ,
    { 0x10DF, 0xF100, "LPe12000 / LPe12002 / LPe1205", "8Gb PCIe Single / Dual port Fibre Channel Adapter" } ,
    { 0x10DF, 0xF700, "LP7000", "Fibre Channel Host Adapter" } ,
    { 0x10DF, 0xF800, "LP8000", "Fibre Channel Host Adapter" } ,
    { 0x10DF, 0xF900, "????", "Light Pulse LP9002 2Gb" } ,
    { 0x10DF, 0xf900, "1", "FC HBA" } ,
    { 0x10DF, 0xF980, "LP9802 / DC", "LP9802 & LP9802DC HBA adapter" } ,
    { 0x10DF, 0xFA00, "LP10000", "Fibre Channel Host Adapter" } ,
    { 0x10DF, 0xfd00, "L2A2860 HELIOS v1.11", "Emulex LP11002" } ,
    { 0x10DF, 0xfe00, "LPe11000 / LPe11002 / LPe1105", "4Gb PCIe Single / Dual port Fibre Channel Adapter" } ,
    { 0x10E1, 0x0391, "TRM-S1040", "0000" } ,
    { 0x10E1, 0x690C, "DC-690c", "" } ,
    { 0x10E1, 0xDC20, "DC-390F", "SCSI Controller" } ,
    { 0xC0DE, 0x5600, "62802", "" } ,
    { 0xC0DE, 0xC0DE, "ENF656", "oZ0030" } ,
    { 0x10E3, 0x0000, "CA91C042/142", "Universe/II VMEbus Bridge" } ,
    { 0x10E3, 0x0148, "Tundra Tsi148", "PCI/X-to-VME Bridge" } ,
    { 0x10E3, 0x0513, "Tsi320", "Dual-Mode PCI-to-PCI Bus Bridge" } ,
    { 0x10E3, 0x0850, "Tsi850", "Power PC Dual PCI Host Bridge" } ,
    { 0x10E3, 0x0854, "Tsi850", "Power PC Single PCI Host Bridge" } ,
    { 0x10E3, 0x0860, "CA91C860", "QSpan Motorola Processor Bridge" } ,
    { 0x10E3, 0x0862, "CA91L862A", "QSpan II PCI-to-Motorola CPU Bridge" } ,
    { 0x10E3, 0x8114, "Tsi384", "PCIe to PCI-X Bridge" } ,
    { 0x10E3, 0x8260, "CA91L8200/8260", "PowerSpan II PowerPC-to-PCI Bus Switch" } ,
    { 0x10E3, 0x8261, "CA91L8200/8260", "PowerSpan II PowerPC-to-PCI Bus Switch" } ,
    { 0x10E6, 0x5209, "0904UGG1EB", "C-Media Audio Controller" } ,
    { 0x10E8, 0x0002, "2BA57D2F", "PCI card" } ,
    { 0x10E8, 0x2011, "Q-Motion pci 264", "Video Capture/Edit board" } ,
    { 0x10E8, 0x4750, "S59200", "Amcc PCI MatchMaker" } ,
    { 0x10E8, 0x5920, "S5920", "amcc" } ,
    { 0x10E8, 0x8033, "BBK-PCI light", "Transputer Link Interface" } ,
    { 0x10E8, 0x8034, "bbk pci light", "transputer link interface" } ,
    { 0x10E8, 0x8043, "LANai4.x", "Myrinet LANai interface chip" } ,
    { 0x10E8, 0x8062, "S5933Qc", "Parastation" } ,
    { 0x10E8, 0x807D, "S5933QE", "PCI44" } ,
    { 0x10E8, 0x8088, "FS", "Kingsberg Spacetec Format Synchronizer" } ,
    { 0x10E8, 0x8089, "SOB", "Kingsberg Spacetec Serial Output Board" } ,
    { 0x10E8, 0x809C, "S5933", "Traquair HEPC3" } ,
    { 0x10E8, 0x80b1, "Data Fire Basic 4MB PCI", "Active ISDN Controller" } ,
    { 0x10E8, 0x80b9, "PCI MATCHMAKER S5935QF", "Driver" } ,
    { 0x10E8, 0x80D7, "PCI-9112", "Data Acquisition Card (ADLINK)" } ,
    { 0x10E8, 0x80D8, "PCI-7200", "40MB/s 32-channels Digital I/O card (ADLINK)" } ,
    { 0x10E8, 0x80D9, "PCI-9118", "Data Acquisition Card (ADLINK)" } ,
    { 0x10E8, 0x80DA, "", "" } ,
    { 0x10E8, 0x80e3, "S5933QC", "AMCC PCI Matchmaker" } ,
    { 0x10E8, 0x811A, "PCI-DSlink", "PCI-IEEE1355-DS-DE interface" } ,
    { 0x10E8, 0x8170, "S5933Qe", "AMCC Matchmaker PCI drivers" } ,
    { 0x10E8, 0x831C, "S5933 32b PCI MatchMaker", "KVD PCIDIS Interface" } ,
    { 0x10E9, 0x10E9, "VID_044E&PID_3001", "ALPS Integrated Bluetooth UGPZ = BTHUSB, USB \\ Vid_044e & Pid_3001 " } ,
    { 0x10E9, 0x3001, "Bluetooth USB Controller (ALPS/UGPZ6)", "http://esupport.sony.com/US/p/swu-matrix.pl?upd_id=2396" } ,
    { 0x10EA, 0x1680, "IGA-1680", "svga" } ,
    { 0x10EA, 0x1682, "IGA-1682", "video" } ,
    { 0x10EA, 0x1683, "IGA-1683", "" } ,
    { 0x10EA, 0x2000, "CyberPro 2010", "TV output ram 2MB  Cyberpro2010" } ,
    { 0x10EA, 0x2010, "CyberPro 20xx/2000A", "vbcvbcvbcvb" } ,
    { 0x10EA, 0x5000, "CyberPro 5000", "" } ,
    { 0x10EA, 0x5050, "CyberPro 5050", "" } ,
    { 0x10EB, 0x0101, "3GA", "64 bit graphics processor" } ,
    { 0x10EB, 0x8111, "Twist3", "Frame Grabber" } ,
    { 0x9005, 0x0010, "AIC-7890AB scsi controller", "AHA-2940U2W/U2B,2950U2W Ultra2 SCSI" } ,
    { 0x9005, 0x0011, "11111", "AHA-2930U2 Ultra2 SCSI Host Adapter" } ,
    { 0x9005, 0x0013, "AIC-7890/1", "SCSI Controller" } ,
    { 0x9005, 0x001F, "AIC-7890 AB for Windows  XP", "Ultra2-Wide SCSI controller" } ,
    { 0x9005, 0x0020, "AIC-789x", "SCSI Controller" } ,
    { 0x9005, 0x002F, "AIC-789x", "SCSI Controller" } ,
    { 0x9005, 0x0030, "AIC-789x", "SCSI Controller" } ,
    { 0x9005, 0x003F, "AIC-789x", "SCSI Controller" } ,
    { 0x9005, 0x0050, "", "AHA-3940U2x/3950U2x Ultra2 SCSI Adapter" } ,
    { 0x9005, 0x0051, "", "AHA-3950U2x Ultra2 SCSI Adapter" } ,
    { 0x9005, 0x0053, "AIC-7896", "SCSI Controller" } ,
    { 0x9005, 0x005F, "AIC-7896/7", "Ultra2 SCSI Controller" } ,
    { 0x9005, 0x0080, "AIC-7892Q", "Ultra160/m PCI SCSI Controller" } ,
    { 0x9005, 0x0081, "AIC-7892B", "Ultra160 SCSI Controller" } ,
    { 0x9005, 0x0083, "AIC-7892D", "Ultra160 SCSI Controller" } ,
    { 0x9005, 0x008F, "AIC-7892", "Ultra160 SCSI Controller" } ,
    { 0x9005, 0x00C0, "AIC-7899A", "Ultra160 SCSI Controller" } ,
    { 0x9005, 0x00C1, "AIC-7899B", "Ultra160 SCSI Controller" } ,
    { 0x9005, 0x00C3, "AIC-7899D", "Ultra160 SCSI Controller" } ,
    { 0x9005, 0x00C5, "", "RAID Subsystem HBA" } ,
    { 0x9005, 0x00CF, "AIC-7899G", "Ultra160 SCSI Controller" } ,
    { 0x9005, 0x0241, "1420", "Adaptec 1420SA Serial AHA HostRAID Controller" } ,
    { 0x9005, 0x0258, "AAC-RAID", "Adaptec AAR-2610SA SATA 6-Port Raid" } ,
    { 0x9005, 0x0285, "Adaptec 2410SA SATA RAID", "PCIX133 32/64bit" } ,
    { 0x9005, 0x0286, "SUBSYS_95801014REV_02", "SUBSYS_95801014REV_02" } ,
    { 0x9005, 0x041F, "AIC 9410", "SAS/SATA Controller" } ,
    { 0x9005, 0x043E, "AIC9450W", "SAS/SATA Controller" } ,
    { 0x9005, 0x41E, "AIC-9410W", "Razor ASIC" } ,
    { 0x9005, 0x564A, "AIC-7211W", "iSCSI Controller" } ,
    { 0x9005, 0x8000, "ASC-29320A", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x800F, "AIC-7901", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8010, "ASC-39320", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8011, "ASC-39320D", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8012, "ASC-29320", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8014, "ASC-29320LP", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8015, "ASC-39320", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8016, "ASC-39320A", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8017, "ASC-29320ALP", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x801C, "AIC-?????", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x801D, "AIC-7902B", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x801E, "AIC-7901", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x801F, "AIC-7902", "Ultra320 SCSI Controller" } ,
    { 0x9005, 0x8080, "ASC-29320A", "Ultra320 HostRAID Controller" } ,
    { 0x9005, 0x808F, "AIC-7901", "Ultra320 HostRAID Controller" } ,
    { 0x9005, 0x8090, "ASC-39320", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x8091, "ASC-39320D", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x8092, "ASC-29320", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x8093, "ASC-29320LPE", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x8094, "ASC-29320LP", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x8095, "ASC-39320", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x8096, "ASC-39320A", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x8097, "ASC-29320ALP", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x809C, "ASC-39320D", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x809D, "AIC-7902B", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x809E, "AIC-7901A", "HostRAID SCSI Controller" } ,
    { 0x9005, 0x809F, "AIC-7902B", "HostRAID SCSI Controller" } ,
    { 0x10ED, 0x10DE, "SN0730506616", "PT ICT FQC" } ,
    { 0x10ED, 0x7310, "V753", "VGA Video Overlay Adapter" } ,
    { 0x10EE, 0x0004, "Virtex 4", "Virtex 4 FPGA" } ,
    { 0x10EE, 0x0007, "Virtex V", "Virtex V FPGA" } ,
    { 0x10EE, 0x0105, "0", "Fibre Channel" } ,
    { 0x10EE, 0x0106, "Virtex 5", "data compression device" } ,
    { 0x10EE, 0x0314, "Spartan XC2S50E", "Communications Controller" } ,
    { 0x10EE, 0X1001, "8343176", "PCI to H.100 audio interface" } ,
    { 0x10EE, 0x3FC0, "RME Digi96", "" } ,
    { 0x10EE, 0x3FC1, "RME Digi96/8", "Xilinx Corp RME Digi96/8 Pad" } ,
    { 0x10EE, 0x3FC2, "RME Digi 96/8 Pro", "" } ,
    { 0x10EE, 0x3FC3, "RME Digi96/8 Pad", "RME Digi96/8 Pad" } ,
    { 0x10EE, 0x3FC4, "Digi9652", "Hammerfall" } ,
    { 0x10EE, 0x3FC5, "0", "HDSP 9632" } ,
    { 0x10EE, 0x4F01, "Jungo", "PCI Simple Communications Controller" } ,
    { 0x10EE, 0x5343, "Seamont SC100", "Security Adapter" } ,
    { 0x10EE, 0x8130, "Durango PMC", "Virtex-II Bridge, XC2V1000-4FG456C" } ,
    { 0x10EE, 0x8381, "Santos", "Frame Grabber" } ,
    { 0x10EE, 0xA123, "XA3S1600E", "Spartan 3E" } ,
    { 0x10EE, 0xA124, "Spartan 3E", "XA3S1600E" } ,
    { 0x10EE, 0xA125, "Spartan 6", "XC6SLX16" } ,
    { 0x10EF, 0x8154, "M815x", "Token Ring Adapter" } ,
    { 0x10F0, 0xA800, "VCL-P", "Graphics board" } ,
    { 0x10F0, 0xB300, "VCL-M", "graphics board" } ,
    { 0x10F1, 0x1566, "", "IDE/SCSI" } ,
    { 0x10F1, 0x1677, "http://www.broadcom.com/support/ethernet_nic/netxt", "Multimedia" } ,
    { 0x10F1, 0x1A2A, "Unknown", "web cam on toshiba satellite c6555" } ,
    { 0x10F1, 0x1a34, "Unknown", "Camera" } ,
    { 0x10F1, 0x2013, "RS-56 sp-pci", "Conexant RS-56 PCI Modem" } ,
    { 0x10F4, 0x1300, "rev1.1", "PCI to S5U13x06B0B Bridge Adapter" } ,
    { 0x10F5, 0xA001, "NDR4000", "NR4600 Bridge" } ,
    { 0x10F6, 0x0111, "PCI\\VEN_1102&DEV_000B&SUBSYS_00421102&REV_04", "CMI8" } ,
    { 0x10F6, 0x10F6, "pci\\ven", "CMI8738/C3DX Multimedia Audio Controller" } ,
    { 0x10FA, 0x0000, "BT848KPF", "GUI Accelerator" } ,
    { 0x10FA, 0x0001, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0002, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0003, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0004, "2189", "GUI Accelerator" } ,
    { 0x10FA, 0x0005, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0006, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0007, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0008, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0009, "", "GUI Accelerator" } ,
    { 0x10FA, 0x000A, "", "GUI Accelerator" } ,
    { 0x10FA, 0x000B, "", "GUI Accelerator" } ,
    { 0x10FA, 0x000C, "Targa 1000", "Video Capture & Editing card" } ,
    { 0x10FA, 0x000D, "", "GUI Accelerator" } ,
    { 0x10FA, 0x000E, "", "GUI Accelerator" } ,
    { 0x10FA, 0x000F, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0010, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0011, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0012, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0013, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0014, "", "GUI Accelerator" } ,
    { 0x10FA, 0x0015, "", "GUI Accelerator" } ,
    { 0x10FB, 0x186f, "TH6255", "" } ,
    { 0x10FC, 0x8139, "Chip Description", "10" } ,
    { 0x10FD, 0x7E50, "10FD", "1518" } ,
    { 0x1100, 0x3044, "VT6307", "IEEE1394 Firewire 3 Port PCI Card" } ,
    { 0x1101, 0x0002, "INI-920", "Ultra SCSI Adapter" } ,
    { 0x1101, 0x1060, "INI-A100U2W", "Orchid Ultra-2 SCSI Controller" } ,
    { 0x1101, 0x134A, "", "Ultra SCSI Adapter" } ,
    { 0x1101, 0x1622, "INIC1620", "PCI SATA Controller" } ,
    { 0x1101, 0x9100, "INI-9010/9010W", "Fast Wide SCSI Controller" } ,
    { 0x1101, 0x9400, "INIC-940", "Fast Wide SCSI Controller" } ,
    { 0x1101, 0x9401, "INIC-935", "Fast Wide SCSI Controller" } ,
    { 0x1101, 0x9500, "", "" } ,
    { 0x1101, 0x9502, "INIC-1620", "pci sata controller" } ,
    { 0x1101, 0x9700, "", "Fast Wide SCSI" } ,
    { 0x1102, 0x0002, "sb80611102", "Sound Blaster audigy! (Also Live! 5.1) - Drivers only 98SE/ME/2k/XP" } ,
    { 0x1102, 0x0003, "EMU8008", "AWE64D OEM (CT4600)" } ,
    { 0x1102, 0x0004, "Creative SB Audigy 2 ZS (WDM)", "Audigy Audio Processor" } ,
    { 0x1102, 0x0005, "EMU20K1, CA20K1", "Sound Blaster X-Fi XtremeMusic (SB0460), XtremeGamer OEM (SB0770)" } ,
    { 0x1102, 0x0006, "emu10k1x", "Soundblaster Live! 5.1 (SB0200)" } ,
    { 0x1102, 0x0007, "C6SB0410515017656A", "Sound Blaster 5.1 vhttp://files2.europe.creative.com/manualdn/Drivers/AVP/10599/0x48689B99/SB51_XPDR" } ,
    { 0x1102, 0x0008, "ca0108", "sound blaster Audigy 4" } ,
    { 0x1102, 0x000A, "SB24PCDRVLB1040090", "Creative Labs  Sound Blaster X-Fi Xtreme Audio" } ,
    { 0x1102, 0x000B, "SB1270", "Sound Blaster X-Fi Titanium HD" } ,
    { 0x1102, 0x000D, "SB0880", "PCIe SB X-Fi Titanium Fatal1ty Pro Series" } ,
    { 0x1102, 0x0011, "SB1500", "Sound Blaster Z" } ,
    { 0x1102, 0x0012, "SB1500", "Sound Blaster Z Audio Controller" } ,
    { 0x1102, 0x006, "emu10k1x", "Soundblaster Live! 5.1" } ,
    { 0x1102, 0x1017, "5803", "3D Blaster Banshee PCI CT6760" } ,
    { 0x1102, 0x1020, "NV5", "3D Blaster RIVA TNT2" } ,
    { 0x1102, 0x1047, "bV1938", "Creative bV1938 3D Blaster Annihilator 2" } ,
    { 0x1102, 0x1102, "10011102", "Phison" } ,
    { 0x1102, 0x1371, "ES1373", " ES1373 AudioPCI" } ,
    { 0x1102, 0x2898, "es2898", "es56t-p1" } ,
    { 0x1102, 0x4001, "EMU10K1", "Audigy IEEE1394a Firewire Controller" } ,
    { 0x1102, 0x7002, "EMU10K1", "GamePort" } ,
    { 0x1102, 0x7003, "EMU10KX", "SB Creative Labs Audigy MIDI/Game-&#1087;&#1086;&#1088;&#1090;" } ,
    { 0x1102, 0x7004, "ca0103-dbq", "Game port for SB Live! Series" } ,
    { 0x1102, 0x7005, "650", "Audigy LS Series Game Port" } ,
    { 0x1102, 0x7802, "EMU1OK1-NGF", "Environmental Audio (SB  Live)" } ,
    { 0x1102, 0x8938, "EV1938", "Sound" } ,
    { 0x1102, 0x9800, "EMU10KX", "Game Port" } ,
    { 0x1102, 1371, "PCI\\VEN_1274&DEV_1371&CC_040100", "" } ,
    { 0x1105, 0x5000, "", "Multimedia" } ,
    { 0x1105, 0x8300, "EM8220", "MPEG-2 Decoder" } ,
    { 0x1105, 0x8400, "EM8400", "MPEG-2 Decoder" } ,
    { 0x1105, 0x8470, "EM8470", "multimedia controller/A/V streaming processor" } ,
    { 0x1105, 0x8475, "EM8475", "MPEG-4 Decoder" } ,
    { 0x1105, 0xc623, "EM8623L", "Media Decoder SoC" } ,
    { 0x1106, 0x0130, "VT6305", "VIA Fire 1394.A OHCI Link Layer Ctrlr" } ,
    { 0x1106, 0x0198, "", "CPU to PCI Bridge" } ,
    { 0x1106, 0x0238, "K8T890", "CPU to PCI Bridge" } ,
    { 0x1106, 0x0259, "CN400/PM880", "Host Bridge" } ,
    { 0x1106, 0x0269, "KT880", "CPU to PCI Bridge" } ,
    { 0x1106, 0x0282, "K8T880Pro", "CPU to PCI Bridge" } ,
    { 0x1106, 0x0305, "VT8363A/8365", "Host Bridge" } ,
    { 0x1106, 0x0314, "VIA Technologies", "VT82xxxx EIDE Controller (All VIA Chipsets)" } ,
    { 0x1106, 0x0391, "VT8363/71", "Host Bridge" } ,
    { 0x1106, 0x0397, "VT1708S", "VIA High Definition Audio" } ,
    { 0x1106, 0x0440, "VIA VT1818S", "VIA VT1818S @ ATI SB800 - High Definition Audio Controller	PCI" } ,
    { 0x1106, 0x0441, "VT2020", "VIA HD Audio Controller" } ,
    { 0x1106, 0x0448, "0", "0" } ,
    { 0x1106, 0x0501, "VT8501", "Host Bridge" } ,
    { 0x1106, 0x0505, "VIA S3G UniChrome IGP", "3059" } ,
    { 0x1106, 0x0506, "1106", "0397" } ,
    { 0x1106, 0x0561, "82C570 MV", "IDE Controller" } ,
    { 0x1106, 0x0571, "VT8235 / VT8237a", "Bus Master IDE Controller" } ,
    { 0x1106, 0x0576, "82C576", "P54 Ctrlr" } ,
    { 0x1106, 0x0581, "CX700", "VIA/S3G Unichrome Pro II IGP" } ,
    { 0x1106, 0x0585, "VT82C585VP/VPX", "Host Bus-PCI Bridge" } ,
    { 0x1106, 0x0586, "VT82C586VP", "PCI-to-ISA Bridge" } ,
    { 0x1106, 0x0591, "VT8237S", "VIA VT8237A SATA RAID Controller" } ,
    { 0x1106, 0x0595, "VT82C595", "Apollo VP2 PCI North Bridge" } ,
    { 0x1106, 0x0596, "VT82C596", "PCI ISA Bridge" } ,
    { 0x1106, 0x0597, "VT82C597", "Host Bridge (Apollo VP3)" } ,
    { 0x1106, 0x0598, "VT82C598", "Host Bridge" } ,
    { 0x1106, 0x0601, "VIA8601", "System Controller" } ,
    { 0x1106, 0x0605, "VT82c686b", "PM133 System Control" } ,
    { 0x1106, 0x0680, "VT82C680", "Apollo P6" } ,
    { 0x1106, 0x0686, "VT82C686", "PCI-to-ISA bridge" } ,
    { 0x1106, 0x0689, "8906", "3249" } ,
    { 0x1106, 0x0691, "VIA VT KN133", "Mainboard" } ,
    { 0x1106, 0x0692, "", "North Bridge" } ,
    { 0x1106, 0x0693, "VT82C693", "Host Bridge" } ,
    { 0x1106, 0x0926, "VT86C926", "Amazon PCI Ethernet Controller" } ,
    { 0x1106, 0x1000, "82C570MV", "Host Bridge" } ,
    { 0x1106, 0x1006, "3059", "3249" } ,
    { 0x1106, 0x1089, "3059", "VIA Sound VIA AC97 in VT82C686A/B,VIA AC97 in VT8233/AC,VT8235" } ,
    { 0x1106, 0x1106, "1106", "management engine driver" } ,
    { 0x1106, 0x1107, "060000A", "ISA Bridge w/IDE" } ,
    { 0x1106, 0x1111, "060000A1106", "VIA Sound VIA AC97 in VT82C686A/B, VIA AC97 in VT8233/AC, VT8235 & VT8237/R, VIA Vinyl audio VT1612A" } ,
    { 0x1106, 0x1122, "1106", "management engine driver" } ,
    { 0x1106, 0x1204, "???", "CPU to PCI" } ,
    { 0x1106, 0x1238, "K8T890", "CPU to PCI Bridge" } ,
    { 0x1106, 0x1259, "CN400/PM880", "Host Bridge" } ,
    { 0x1106, 0x1269, "KT880", "CPU to PCI Bridge" } ,
    { 0x1106, 0x1282, "K8T880Pro", "CPU to PCI Bridge" } ,
    { 0x1106, 0x1289, "VT1708", "PCI\\VEN_1106&DEV_3059&SUBSYS_03011F6&REV_50\\3&13C0B0C5&0&8" } ,
    { 0x1106, 0x1289, "VT1708", "PCI\\VEN_1106&DEV_3059&SUBSYS_03011F6&REV_50\\3&13C0B0C5&0&8" } ,
    { 0x1106, 0x1401, "060000A", "ISA Bridge w/IDE" } ,
    { 0x1106, 0x1571, "VT82C416", "IDE Controller" } ,
    { 0x1106, 0x1595, "VT82C595/97", "Host Bridge" } ,
    { 0x1106, 0x1708, "VIA VT8237", "High Definition Audio controller" } ,
    { 0x1106, 0x1989, "VT1708", "PCI\\VEN_1106&DEV_3344&SUBSYS_12021565&REV_01\\4&8CA73A7&0&0008 " } ,
    { 0x1106, 0x2006, "VT6105M", "VIA Rhine III VT6105M Fast Ethernet controller" } ,
    { 0x1106, 0x2012, "1106", "7205" } ,
    { 0x1106, 0x2038, "Unknown", "PCI Device" } ,
    { 0x1106, 0x204, "K8M400 chipset", "CPU " } ,
    { 0x1106, 0x2204, "???", "CPU to PCI" } ,
    { 0x1106, 0x2238, "K8T890", "CPU to PCI Bridge" } ,
    { 0x1106, 0x2259, "CN400/PM880", "Host Bridge" } ,
    { 0x1106, 0x2269, "KT880", "CPU to PCI Bridge" } ,
    { 0x1106, 0x2282, "K8T880Pro", "CPU to PCI Bridge" } ,
    { 0x1106, 0x24c5, "8086 SoundController (ICH4-M B0 step)", "VIA Vynil v700b" } ,
    { 0x1106, 0x3009, "SB200", "AC'97 Audio Controller" } ,
    { 0x1106, 0x3038, "VT6212L", "USB" } ,
    { 0x1106, 0x3038, "VT8251", "4 x USB1.0 PCI controller" } ,
    { 0x1106, 0x3040, "VT82C586A/B", "APM(or ACPIAPIC?)" } ,
    { 0x1106, 0x3041, "82C570MV", "ISA Bridge w/IDE" } ,
    { 0x1106, 0x3043, "VT86C100A", "Rhine 10/100 Ethernet Adapter" } ,
    { 0x1106, 0x3044, "VT6306/VT6307/VT6308", "VIA Fire II 1394a OHCI Link Layer Ctrlr1" } ,
    { 0x1106, 0x305, "VIA Sound VIA AC 97 in VT82C686A/B", "VIA AC 97 in VT8233/AC" } ,
    { 0x1106, 0x3050, "VT82C596/596A/596", "Power Management and SMBus Controller" } ,
    { 0x1106, 0x3051, "", "Power Management Controller" } ,
    { 0x1106, 0x3053, "VT6105M", "Rhine III Management Adapter" } ,
    { 0x1106, 0x3057, "VT82C686A/B", "ACPI Power Management Controller" } ,
    { 0x1106, 0x3058, "VT1709", "PCI\\VEN_1106&DEV_3059&SUBSYS_73801462&REV_50" } ,
    { 0x1106, 0x3059, "3059", "VIA Sound VIA AC97 in VT82C686A/B&#8203;, VIA AC97 in VT8233/AC, VT8235" } ,
    { 0x1106, 0x3059, "9739", "C-Media Electronics Audio Controller" } ,
    { 0x1106, 0x3065, "VT6102", "Rhine II PCI Fast Ethernet Controller" } ,
    { 0x1106, 0x3068, "PCI\\VEN_1106&DEV_3068&SUBSYS_4C211543&REV_80\\3&13C", "VIA MC'97 Modem Controller - Agere Systems AC'97 Modem / AC-Link modems" } ,
    { 0x1106, 0x3068, "VT82C686A/B&VT8231", "APM(or ACPI?)" } ,
    { 0x1106, 0x3068, "VT82C686A/B&VT8231", "MC97 MODEM" } ,
    { 0x1106, 0x3074, "VT8233", "PCI to ISA Bridge" } ,
    { 0x1106, 0x3086, "VT82C686", "Power" } ,
    { 0x1106, 0x3091, "VT8633", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3099, "vt8233", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3101, "VT8653", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3102, "VT8362", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3103, "VT8615", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3104, "VT6202", "USB 2.0 Enhanced Host Controller" } ,
    { 0x1106, 0x3106, "VT6105M/LOM", "Rhine III PCI Fast Ethernet Controller" } ,
    { 0x1106, 0x3107, "VT8233/A AC97' Enhance Audio Controller", "PCI to ISA Bridge" } ,
    { 0x1106, 0x3108, "8237", "VIA/S3G UniChrome Pro IGP (Integrated Video Adapter)" } ,
    { 0x1106, 0x3109, "VT8233/A AC97' Enhance Audio Controller", "PCI to ISA Bridge" } ,
    { 0x1106, 0x3112, "VT8361", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3113, "", "PCI to PCI Bridge" } ,
    { 0x1106, 0x3116, "VT8375", "CPU-to-PCI Bridge" } ,
    { 0x1106, 0x3118, "CN400", "P4M800/CE/Pro UniChrome Pro,PM880, PM800, CN400 UniChrome,VN800 UniChrome Pro" } ,
    { 0x1106, 0x3119, "VT6120/VT6121/VT6122", "'Velocity' Gigabit Ethernet Controllers" } ,
    { 0x1106, 0x3122, "3122110", "CastleRock AGP 8X Controller" } ,
    { 0x1106, 0x3123, "VT8623", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3128, "vt8753", "CPU-to-PCI Bridge" } ,
    { 0x1106, 0x3133, "VT3133", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3147, "VT8233", "PCI to ISA Bridge" } ,
    { 0x1106, 0x3148, "VT8751", "CPU-to-PCI Bridge" } ,
    { 0x1106, 0x3149, "VT8237 Family/ VT6421a", "SATA RAID Controller" } ,
    { 0x1106, 0x3156, "VT8372", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3157, "VIA VT8237", "CX700 - SATA RAID " } ,
    { 0x1106, 0x3158, "", "CPU-to-PCI Bridge" } ,
    { 0x1106, 0x3164, "VT6410", "VIA RAID Controller - 3164 " } ,
    { 0x1106, 0x3168, "VT8374", "P4X400 Host Controller/AGP Bridge" } ,
    { 0x1106, 0x3177, "VT8235", "PCI to ISA Bridge" } ,
    { 0x1106, 0x3178, "", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3188, "K8HTB-8237", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3189, "VT8377", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3198, "VEN_1106&DEV_B198&SUBSYS_00000000&REV_00", "CPU-to-PCI Bridge" } ,
    { 0x1106, 0x3202, "", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3204, "1394 i2c", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3205, "PCI\\VEN_1106&DEV_3432", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3208, "PT890", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3209, "", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3213, "", "PCI to PCI Bridge" } ,
    { 0x1106, 0x3227, "VT8237R", "PCI-to-ISA Bridge" } ,
    { 0x1106, 0x3230, "K8M890CE & K8N890CE Display Driver", "Via Chrome9 HC IGP Integrated Graphics" } ,
    { 0x1106, 0x3238, "K8T890", "CPU-to-PCI Bridge" } ,
    { 0x1106, 0x3249, "VT6421", "VIA VT6421 RAID Controller - Windows XP 32.bit" } ,
    { 0x1106, 0x3253, "VT6655", "PCI-Cardbus Wireless LAN Adapter" } ,
    { 0x1106, 0x3258, "PT880", "CPU-to-PCI Bridge" } ,
    { 0x1106, 0x3259, "???", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3269, "KT880", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3282, "K8T880Pro", "CPU to PCI Bridge" } ,
    { 0x1106, 0x3288, "040300", "HDA Codec Realtek ALC660" } ,
    { 0x1106, 0x3343, "81CE1043", "VIA S3G UniChrome Family" } ,
    { 0x1106, 0x3344, "CN700", "VIA/S3G UniChrome Pro IGP CN700 in GA-8VM800M" } ,
    { 0x1106, 0x3349, "VT8251", "VIA VT8251 AHCI RAID Controller" } ,
    { 0x1106, 0x3365, "060000A1106", "VIA Sound VIA AC97 in VT82C686A/B, VIA AC97 in VT8233/AC, VT8235 & VT8237/R, VIA Vinyl audio VT1612A" } ,
    { 0x1106, 0x3371, "P4M900", "V&#304;A Chrome9 HC IGP" } ,
    { 0x1106, 0x3403, "VT6315/VT6330", "OHCI Compliant IEEE 1394 Host Controller " } ,
    { 0x1106, 0x3483, "VL805-q6", "Universal Serial Bus (USB) Controller" } ,
    { 0x1106, 0x3680, "pci\\ven_1106&dev_3108_&subsys_4c211543_rev_80\\3&13", "via mc97 controller for ac -link modems" } ,
    { 0x1106, 0x401A, "VT-6325", "Via Card Reader" } ,
    { 0x1106, 0x4149, "VT6420", "PATA" } ,
    { 0x1106, 0x4204, "???", "CPU to PCI Bridge" } ,
    { 0x1106, 0x4238, "K8T890", "CPU to PCI Bridge" } ,
    { 0x1106, 0x4258, "???", "CPU to PCI Bridge" } ,
    { 0x1106, 0x4259, "???", "CPU to PCI Bridge" } ,
    { 0x1106, 0x4269, "KT880", "CPU to PCI Bridge" } ,
    { 0x1106, 0x4282, "K8T880Pro", "CPU to PCI Bridge" } ,
    { 0x1106, 0x4397, "VT1708S", "VIA HD Audio Codecs" } ,
    { 0x1106, 0x5000, "3059", "VIA Sound VIA AC97 in VT82C686A/B, VIA AC97 in VT8233/AC, VT8235" } ,
    { 0x1106, 0x5030, "VT82C596", "ACPI Power Management Controller" } ,
    { 0x1106, 0x5308, "PT880 Pro / VT8237", "Via I/O APIC Interrupt Controller" } ,
    { 0x1106, 0x5372, "VT8237S", "IDE SATA Controller" } ,
    { 0x1106, 0x6100, "VIA VT86C100A", "Rhine II PCI Fast SATA and ethernet controller" } ,
    { 0x1106, 0x6287, "27611", "UT2DC2  <a href=" } ,
    { 0x1106, 0x7064, "SUBSYS_10020000", "REV_46\\3&61AAA01&0&80" } ,
    { 0x1106, 0x7204, "K8M400", "CPU to PCI Bridge" } ,
    { 0x1106, 0x7205, "KM400", "VIA Technologies, Inc. VT8378 [S3 UniChrome] Graphics Adapter" } ,
    { 0x1106, 0x7238, "K8T890", "CPU to PCI Bridge" } ,
    { 0x1106, 0x7258, "PT880", "CPU to PCI Bridge" } ,
    { 0x1106, 0x7259, "PM800", "CPU to PCI Bridge" } ,
    { 0x1106, 0x7269, "KT880", "CPU to PCI Bridge" } ,
    { 0x1106, 0x7282, "K8T880Pro", "CPU to PCI Bridge" } ,
    { 0x1106, 0x7353, "CX700", "SATA RAID" } ,
    { 0x1106, 0x7372, "VT8237", "SATA RAID" } ,
    { 0x1106, 0x7565, "473040005", "60" } ,
    { 0x1106, 0x8208, "PT890?", "PCI to AGP Bridge" } ,
    { 0x1106, 0x8231, "VT8231", "PCI to ISA Bridge" } ,
    { 0x1106, 0x8235, "VT8754", "vga" } ,
    { 0x1106, 0x8237, "VT8237", "AC97 Enhanced Audio Controller - the 8251 controller is different" } ,
    { 0x1106, 0x8305, "VT8363A/65", "PCI to AGP Bridge" } ,
    { 0x1106, 0x8391, "VT8363/71", "PCI to AGP Bridge" } ,
    { 0x1106, 0x8501, "VT8501", "PCI to AGP Bridge" } ,
    { 0x1106, 0x8596, "VT82C596", "PCI to AGP Bridge" } ,
    { 0x1106, 0x8597, "VT82C597", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0x8598, "VT82C598", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0x8601, "VT82C601", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0x8602, "", "CPU to AGP Bridge" } ,
    { 0x1106, 0x8605, "VT8605", "PCI-to-PCI Bridge(AGP)" } ,
    { 0x1106, 0x8691, "VT82C691/693A/694X", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0x8693, "VT82C693/A", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0x8920, "3059", "3249" } ,
    { 0x1106, 0x9238, "K8T890", "I/O APIC" } ,
    { 0x1106, 0x9398, "VT8601", "2D/3D Graphics Accelerator" } ,
    { 0x1106, 0x9530, "1106", "Via MSP Cardreader driver" } ,
    { 0x1106, 0x9875, "1", "pci" } ,
    { 0x1106, 0x9876, "VT8233/A AC97' Enhance Audio Controller", "PCI to ISA Bridge" } ,
    { 0x1106, 0xA208, "PT890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xA238, "K8T890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xb01f, "castle rock agp8x controll", "fast ethernet nic" } ,
    { 0x1106, 0xB091, "VT8633", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB099, "VT8366/A", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB101, "VT8653", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB102, "VT8362", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB103, "VT8615", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB112, "VT8361", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB113, "", "I/O APIC" } ,
    { 0x1106, 0xB115, "VT8363/65", "CPU to AGP Controller" } ,
    { 0x1106, 0xB116, "VT8375", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB133, "vt686b", "CPU to AGP Controller" } ,
    { 0x1106, 0xB148, "VT8751 Apollo", "PCI-to-Host" } ,
    { 0x1106, 0xB156, "VT8372", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB158, "VIA Technologies Inc", "PCI-to-PCI Bridge (AGP)" } ,
    { 0x1106, 0xB168, "VT8235", "PCI-to-PCI Bridge (AGP 2.0/3.0)" } ,
    { 0x1106, 0xB188, "K8M800/K8N800", "VIA CPU to AGP2.0/AGP3.0 Controller" } ,
    { 0x1106, 0xB198, "546546", "PCI-to-PCI Bridge (AGP 2.0/3.0)" } ,
    { 0x1106, 0xB213, "", "I/O APIC" } ,
    { 0x1106, 0xC208, "PT890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xC238, "K8T890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xD208, "PT890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xD213, "", "PCI to PCI Bridge" } ,
    { 0x1106, 0xD238, "K8T890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xE208, "PT890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xE238, "K8T890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xe721, "104382EA", "VIA HD Audio Deck VT1708B" } ,
    { 0x1106, 0xe724, "VT1705", "VT HD AUDIO DECK vt8235" } ,
    { 0x1106, 0xF208, "PT890", "PCI-to-PCI Bridge" } ,
    { 0x1106, 0xF238, "K8T890", "PCI-to-PCI Bridge" } ,
    { 0x1107, 0x8576, "", "PCI Host Bridge" } ,
    { 0x1108, 0x0100, "p1690plus-AA", "Token Ring Adapter" } ,
    { 0x1108, 0x0101, "p1690plus-AB", "2-Port Token Ring Adapter" } ,
    { 0x1108, 0x0105, "P1690Plus", "Token Ring Adapter" } ,
    { 0x1108, 0x0108, "P1690Plus", "Token Ring Adapter" } ,
    { 0x1108, 0x0138, "P1690Plus", "Token Ring Adapter" } ,
    { 0x1108, 0x0139, "P1690Plus", "Token Ring Adapter" } ,
    { 0x1108, 0x013C, "P1690Plus", "Token Ring Adapter" } ,
    { 0x1108, 0x013D, "P1690Plus", "Token Ring Adapter" } ,
    { 0x1109, 0x1400, "EM110TX", "EX110TX PCI Fast Ethernet Adapter" } ,
    { 0x110B, 0x0001, "Mpact", "Media Processor" } ,
    { 0x110B, 0x0002, "GM90C7110VX", "MPACT DVD decoder." } ,
    { 0x110B, 0x0004, "Mpact", "Integrated video card" } ,
    { 0x13EA, 0x3131, "DS3131", "BoSS Bit Synchronous HDLC Controller" } ,
    { 0x13EA, 0x3134, "DS3134", "Chateau Channelized T1/E1/HDLC Controller" } ,
    { 0x13F0, 0x0200, "0x0200", "IP100A Integrated 10/100 Ethernet MAC + PHY" } ,
    { 0x13F0, 0x0201, "ST201", "Fast Ehternet Adapter" } ,
    { 0x13F0, 0x0300, "NX1001", "Network Adapter" } ,
    { 0x13F0, 0x1021, "Tamarack 9021A", "Tamarack 9021A Gigabit Ethernet adapter" } ,
    { 0x13F0, 0x1023, "NX1101a", "Gigabit Ethernet Controller" } ,
    { 0x13F0, 0x13F0, "PCI\\VEN_13F0&DEV_0200&SUBSYS_82131043&REV_41\\4&19", "82131043" } ,
    { 0x13F1, 0x0028, "NV05", "MCP67 High Definition Audio" } ,
    { 0x13FD, 0x160E, "Initio1606l", "SATA/150 &#1091;&#1089;&#1090;&#1088;&#1086;&#1081;&#1089;&#1090;&#1074;&#1072; USB 2.0" } ,
    { 0x13FD, 0x161F, "1D59CB92", "s" } ,
    { 0x13FD, 0x1840, "INIC-1608L", "SATA/150 device to USB 2.0 Host interface (http://www.initio.com/Html/inic-1608.html)" } ,
    { 0x1400, 0x0001, "", "" } ,
    { 0x1400, 0x0003, "", "" } ,
    { 0x1400, 0x0004, "030000", "030000" } ,
    { 0x1400, 0x1401, "9432 TX", "hd 2600xt" } ,
    { 0x1409, 0x1409, "7168", "PCI Serial port" } ,
    { 0x1409, 0x7168, "1889", "PCI Serial Port (WinXP --> Win 8.1) (Win 2003 - 2008R2)" } ,
    { 0x1409, 0x7268, "PCI / ISA IEEE1284 ECP/EPP/SPP/BPP Signal Chips So", "PCI parallel port" } ,
    { 0x1409, 7268, "PCI / ISA IEEE1284 ECP/EPP/SPP/BPP PAR4008A", "PCI parallel port" } ,
    { 0x140B, 0x0610, "", "" } ,
    { 0x140B, 0x615, "NA", "Na" } ,
    { 0x140B, 0x682, "NA", "NA" } ,
    { 0x1415, 0x8401, "OX9162", "PCI Interface to local bus" } ,
    { 0x1415, 0x8403, "OX12PCI840", "PCI Parallel Card" } ,
    { 0x1415, 0x9500, "OX16PCI952", "Quad UART (disabled)" } ,
    { 0x1415, 0x9501, "OX16PCI954", "Quad UART" } ,
    { 0x1415, 0x9505, "OXuPCI952", "Dual UART" } ,
    { 0x1415, 0x950A, "OX16PCI954", "Dual PCI UARTS" } ,
    { 0x1415, 0x950B, "OXCF950", "Integrated High Performance UART" } ,
    { 0x1415, 0x9510, "OX16PCI954", "PCI Interface (disabled)" } ,
    { 0x1415, 0x9511, "OX9160", "PCI Interface to 8-bit local bus" } ,
    { 0x1415, 0x9512, "OX16PCI954", "PCI Interface to 32-bit bus" } ,
    { 0x1415, 0x9513, "OX16PCI954", "Parallel Port" } ,
    { 0x1415, 0x9521, "OX16PCI952", "Dual UART" } ,
    { 0x1415, 0x9523, "OX16PCI952", "Integrated Parallel Port" } ,
    { 0x1415, 0xc110, "OXPCIe952", "Parallel PCI Express Card (Manhattan 158176)" } ,
    { 0x1415, 0xc158, "OXPCIe952", "Scheda PCI Express Seriale Due porte, X1 linea " } ,
    { 0x1415, 0xc15d, "OXPCIe952", "2 native UARTs (function 1)" } ,
    { 0x1415, 0xc208, "OXPCIe954", "Quad UARTs" } ,
    { 0x1415, 0xc20d, "OXPCIe954", "Quad UARTs (function 1)" } ,
    { 0x1415, 0xc308, "OXPCIe958", "Octo UARTs" } ,
    { 0x1415, 0xc30d, "OXPCIe958", "Octo UARTs (function 1)" } ,
    { 0x1418, 0x0781, "RaLink RT2860 300Mbps", " 802.11n Wireless Card" } ,
    { 0x141F, 0x6181, "KFIR", "MPEG decoder" } ,
    { 0x1425, 0x0030, "N/A", "T310 10GbE Single Port Adapter" } ,
    { 0x1425, 0x31, "N/A", "T320 10GbE Dual Port Adapter" } ,
    { 0x1425, 0x32, "N/A", "T302 1GbE Dual Port Adapter" } ,
    { 0x1425, 0x33, "N/A", "T304 1GbE Quad Port Adapter" } ,
    { 0x1425, 0x34, "N/A", "B320 10GbE Dual Port Adapter" } ,
    { 0x1425, 0x35, "N/A", "S310-CR 10GbE Single Port Adapter" } ,
    { 0x1425, 0x36, "N/A", "S320-LP-CR 10GbE Dual Port Adapter" } ,
    { 0x1425, 0x37, "N/A", "N320-G2-CR 10GbE Dual Port Adapter" } ,
    { 0x1425, 0x4401, "N/A", "T420-CR Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4402, "N/A", "T422-CR Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4403, "N/A", "T440-CR Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4404, "N/A", "T420-BCH Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4405, "N/A", "T440-BCH Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4406, "N/A", "T440-CH Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4407, "N/A", "T420-SO Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4408, "N/A", "T420-CX Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x4409, "N/A", "T420-BT Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x440a, "N/A", "T404-BT Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x440d, "N/A", "T480 Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x440e, "N/A", "T440-LP-CR Unified Wire Ethernet Controller" } ,
    { 0x1425, 0x7145, "1002", "N/A" } ,
    { 0x1446, 0x6A73, "not known", "not known" } ,
    { 0x1462, 0x00C1, "NV41.1", "NX6800-TD256E" } ,
    { 0x1462, 0x4720, "883", "Audio controller" } ,
    { 0x1462, 0x5071, "883", "Audio controller" } ,
    { 0x1462, 0x5964, "PCI\\VEN_1002&DEV_7291&SUBSYS_08101462&REV_9A0PCI\\V", "RADEON 9250/9200 series AGP" } ,
    { 0x1462, 0x7120, "", "" } ,
    { 0x1462, 0x7960, "MCP2T", "MCP2T" } ,
    { 0x1471, 0x0188, "RoadRunner 10", "ADSL PCI" } ,
    { 0x148F, 0x1000, "unknown", "Ralink Motorola BC4 Bluetooth 3.0+HS Adapter" } ,
    { 0x148F, 0x148f, "5370", "TP-LINK 7200ND" } ,
    { 0x148F, 0x2000, "Unknown", "Ralink Motorola BC8 Bluetooth 3.0 + HS Adapter" } ,
    { 0x148F, 0x2070, "1.0", "802.11 g WLAN" } ,
    { 0x148F, 0x2573, "1192Af7b", "802.11 bg" } ,
    { 0x148F, 0x2870, "1.0", "802.11 n WLAN" } ,
    { 0x148F, 0x3000, "RT3290", "ralink rt3290_bluetooth_01" } ,
    { 0x148F, 0x3070, "RT3070L", "FreeWifiLink D3-10000N" } ,
    { 0x148F, 0x3572, "RT3572", "Ralink 3572" } ,
    { 0x148F, 0x5370, "Ralink RT2870", "802.11n USB Wireless LAN Card" } ,
    { 0x148F, 0x9021, "Unknown", "Netopia USB b/g Adapter (black)" } ,
    { 0x14A9, 0xad1f, "1", "1" } ,
    { 0x14B1, 0x0FEC, "i865P/PE/G/i848P rev. A2", "Intel 82801EB (ICH5) rev. 02" } ,
    { 0x14B1, 0x1033, "R6795-12", "RH56D-PCI" } ,
    { 0x14B1, 0x2F30, "01", "zyxel omni 56k CI lus rev." } ,
    { 0x14C1, 0x8043, "LANai 9.2 0129", "MyriNet" } ,
    { 0x14CD, 0x03, "0x02", "0x1212" } ,
    { 0x14CD, 0x1001, "BCM4356", "802.11 ac wireless module" } ,
    { 0x14CD, 0x168a, "NA", "Multi-Card reader" } ,
    { 0x14CF, 0x2920, "FPMC-FIO1-F100-1", "Serial I/O Controller aka FPMC-DFLEX64" } ,
    { 0x14D9, 0x0010, "AP1011/SP1011", "Sturgeon HyperTransport-PCI Bridge" } ,
    { 0x14E4, 0x0038, "BCM88038", "100G packet processor " } ,
    { 0x14E4, 0x0102, "T2500", "Intel (R)" } ,
    { 0x14E4, 0x0318, "n/a", "n/a" } ,
    { 0x14E4, 0x034F, "NV36GL?", "???" } ,
    { 0x14E4, 0x04B5, "BCM4312", "Broadcom 54bg Wireless" } ,
    { 0x14E4, 0x0732, "BCM88732", "2x40G/8x10G MAC Aggregation Switch with 80G Uplink" } ,
    { 0x14E4, 0x0800, "BCM33xx/47xx", "Sentry5 Chipcommon I/O Controller" } ,
    { 0x14E4, 0x0804, "BCM33xx/47xx", "Sentry5 PCI Bridge" } ,
    { 0x14E4, 0x0805, "BCM33xx/47xx", "Sentry5 MIPS32 CPU" } ,
    { 0x14E4, 0x0806, "BCM33xx/47xx", "Sentry5 Ethernet Controller" } ,
    { 0x14E4, 0x080B, "BCM33xx/47xx", "Sentry5 Crypto Accelerator" } ,
    { 0x14E4, 0x080F, "BCM33xx/47xx", "Sentry5 DDR/SDR RAM Controller" } ,
    { 0x14E4, 0x0811, "BCM33xx/47xx", "Sentry5 External Interface" } ,
    { 0x14E4, 0x0816, "BCM3302", "Sentry5 MIPS32 CPU" } ,
    { 0x14E4, 0x1234, "7175144F", "networkcontroller" } ,
    { 0x14E4, 0x1361, "BCM4313", "Ethernet" } ,
    { 0x14E4, 0x14E4, "BCM57780", "802.11b/g Wireless Lan Controller" } ,
    { 0x14E4, 0x1570, "720p FaceTime HD camera", "Webcam found on Macbook Pro with Retina Display, 2014 (aka. Macbook Pro /w Retina 11,3)" } ,
    { 0x14E4, 0x1600, "BCM5752", "NetXtreme BCM5752 Gigabit Ethernet PCI Express" } ,
    { 0x14E4, 0x1601, "BCM5752M", "NetXtreme Desktop/Mobile" } ,
    { 0x14E4, 0x1610, "BCM70010", "Broadcom BCN70010 Video Decoder" } ,
    { 0x14E4, 0x1612, "BCM70010/BCM70012", "Crystal HD Video Decoder" } ,
    { 0x14E4, 0x1615, "BCM70015", "Broadcom Crystal HD Video Decoder" } ,
    { 0x14E4, 0x161F, "BCM70010/BCM70012", "AVC/VC-1/MPEG PCI Express� HD Decoder Chipset for Netbooks/Nettops" } ,
    { 0x14E4, 0x1639, "BCM5709", "NetXtreme Gigabit Ethernet II" } ,
    { 0x14E4, 0x163B, "BCM5709", "Broadcom NetXtreme II BCM5706/5708/5709/5716 Driver" } ,
    { 0x14E4, 0x1644, " BCM5751F", "ven_1102dev_0004" } ,
    { 0x14E4, 0x1645, "BCM570123", "broadtcomBCM5701 Gigabit EthernetASD" } ,
    { 0x14E4, 0x1646, "BCM5702x1", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1647, "BCM57788", "NetLink tm Gigabit Ethernet pcie" } ,
    { 0x14E4, 0x1648, "BCM5704", "NetXtreme Dual Gigabit Adapter" } ,
    { 0x14E4, 0x164C, "BCM5708", "Broadcom NetXtreme II Gigabit Ethernet Adapter" } ,
    { 0x14E4, 0x164D, "83471043", "NetXtreme Fast Ethernet Controller" } ,
    { 0x14E4, 0x1650, "BCM57711", "Broadcom PCIe 10Gb Network Controller " } ,
    { 0x14E4, 0x1653, "BCM5788", "Broadcom NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1654, "BCM5705A2", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1658, "BM5750", "NtXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1659, "BCM5721", "NetXtreme Gigabit Ethernet PCI Express" } ,
    { 0x14E4, 0x165A, "94309", "Broadcom NetXtreme BCM5722 Gigabit" } ,
    { 0x14E4, 0x165D, "Aspire5733Z", "Broadcom NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x165E, "3C905B", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x165F, "BCM5720", "Broadcom NetXtreme 5720 Gigabit Ethernet" } ,
    { 0x14E4, 0x166a, "BCM5780", "Broadcom NetXtreme Gigabit Ethernet 5780" } ,
    { 0x14E4, 0x166B, "BCM5780S", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x166D, "BCM5705MFE", "NetXtreme Ethernet 100kB" } ,
    { 0x14E4, 0x166E, "BCM5705", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x167, "BCM5751F", "NetXtreme Fast Ethernet Controller" } ,
    { 0x14E4, 0x1672, "BCM5754M", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1673, "B5755M", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1674, "57XX", "57XX Series Broadcom Driver X86/X64" } ,
    { 0x14E4, 0x1676, "BCM5750A1", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1677, "BCM5751", "NetXtreme Desktop/Mobile" } ,
    { 0x14E4, 0x1677, "BCM5782", "Broadcom Netxtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x167A, "BCM5754", "Broadcom NetXtreme Gigabit Ethernet Controller" } ,
    { 0x14E4, 0x167B, "BCM5755/5780", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x167C, "BCM5750", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x167d, "BCM5751M", "Broadcom NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x167E, "BCM5751FKFB", "vierkant" } ,
    { 0x14E4, 0x1680, "BCM5761E", "NetXtreme Desktop/Mobile" } ,
    { 0x14E4, 0x1681, "BCM5761", "Broadcom 57XX Gigabit Integrated Controller " } ,
    { 0x14E4, 0x1684, "BCM5764", "Broadcom NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x1690, "BCM5776", "NexTreme Desktop/Mobile" } ,
    { 0x14E4, 0x1691, "BCM57788", "Broadcom BCM57788 LOM " } ,
    { 0x14E4, 0x1691, "BCM57788A", "Broadcom NetLink (TM) Gigabit Ethernet" } ,
    { 0x14E4, 0x1692, "BCM57780", "NetLink" } ,
    { 0x14E4, 0x1693, "BCM5787", "Ethernet Controller Broadcom Netlink Gigabit" } ,
    { 0x14E4, 0x1696, "BCM5782", "Broadcom NetXtreme Gigabit Ethernet " } ,
    { 0x14E4, 0x1698, "02941028", "NetLink Ethernet-FOR DELL LAPTOP AND MAYBE OTHERS" } ,
    { 0x14E4, 0x169A, "BCM5787", "Broadcom Netlink (TM) gigabit ethernet Driver" } ,
    { 0x14E4, 0x169B, "BCM5786", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x169C, "17351043", "Broadcom NetLink (TM) Gigabit Ethernet" } ,
    { 0x14E4, 0x169D, "BCM5782k, BCM5789", "Broadcom Ethernet Adapter" } ,
    { 0x14E4, 0x169E, "BCM5754", "NetXtreme Gigabit Ethernet PCI Express" } ,
    { 0x14E4, 0x16A6, "BCM5702X", "Gigabit Ethernet" } ,
    { 0x14E4, 0x16A7, "BCM5703X", "Gigabit Ethernet" } ,
    { 0x14E4, 0x16A8, "BLM5701", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x16AA, "B06BDRV", "BroadCom NetExtreme II Server" } ,
    { 0x14E4, 0x16B1, "BCM57781", "BCM57781" } ,
    { 0x14E4, 0x16B5, "BCM57785X", "Broadcom NetLink Gigabit Ethernet" } ,
    { 0x14E4, 0x16BE, "16BE8", "CardReader Broadcom 1.0.0.221" } ,
    { 0x14E4, 0x16BF, "0x16BF", "CardReader Broadcom 15.0.7.2" } ,
    { 0x14E4, 0x16C6, "BCM5702A3", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x16C7, "BCM 94311", "DELL Wireless 1390 WLAN MiniCard" } ,
    { 0x14E4, 0x16DD, "BCM5781", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x16f7, "BCM5753", "NetXtreme BCM5753 Gigabit PCI Express" } ,
    { 0x14E4, 0x16FD, "BCM5753M", "NetXtreme Gigabit Ethernet PciXpress" } ,
    { 0x14E4, 0x16FE, "BCM5753F", "NetXtreme Gigabit Ethernet" } ,
    { 0x14E4, 0x170C, "PCI\\VEN_14E4&DEV_1692&CC_020000", "Broadcom 440x 10/100 Integrated Controller" } ,
    { 0x14E4, 0x170D, "BCM5901", "NetXtreme" } ,
    { 0x14E4, 0x170E, "BCM5901", "NetXtreme 100Base-TX" } ,
    { 0x14E4, 0x1713, "BCM5906m", "Broadcom NetLink (TM) Fast Ethernet" } ,
    { 0x14E4, 0x21E3, "BCM43142A0", "Broadcom Bluetooth 4.0" } ,
    { 0x14E4, 0x333, "BCM53333", "16p 1G (PHY)" } ,
    { 0x14E4, 0x3352, "BCM3352", "BCM3352 QAMLink� Single-Chip 4-Line VoIP" } ,
    { 0x14E4, 0x3360, "BCM3360", "Advanced PHY Broadband Gateway Cable Modem" } ,
    { 0x14E4, 0x4211, "intel CORE I5", "10Mb/s NIC" } ,
    { 0x14E4, 0x4212, "BCM V.90", "56k Modem" } ,
    { 0x14E4, 0x4301, "Broadcom BCM4301 802.11g Wireless LAN Controller", "Dell Truemobile 1180 802.11g MiniPCI" } ,
    { 0x14E4, 0x4303, "BCM4303", "BCM4301 802.11b802.11b Wireless LAN Controller" } ,
    { 0x14E4, 0x4305, "BCM4307", "V.90 56k Modem" } ,
    { 0x14E4, 0x4306, "BCM4306", "Unknown device 4306 (rev 02)" } ,
    { 0x14E4, 0x4307, "BCM4306", "802.11b Wireless LAN Controller" } ,
    { 0x14E4, 0x4310, "BCM4310", "BCM4301USB Controller" } ,
    { 0x14E4, 0x4311, "BCM4311", "802.11b/g Wireless LAN" } ,
    { 0x14E4, 0x4312, "BCM4310", "broadcom wireless 1490 (dell)" } ,
    { 0x14E4, 0x4313, "BCM4310 UART", "wireless network card" } ,
    { 0x14E4, 0x4315, "BCM4315/BCM22062000", "Broadcom Wireless b/g (Tested Drivers)" } ,
    { 0x14E4, 0x4318, "BCM4318", "Broadcom 802.11b/g WLAN" } ,
    { 0x14E4, 0x4320, "BCM4306", "802.11B/G Wireless Lan Controller 3-&#1103; &#1056;&#1077;&#1076;&#1072;&#1082;&#1094;&#1080;&#1103;" } ,
    { 0x14E4, 0x4321, "BCM4306", "802.11a Wireless LAN Controller" } ,
    { 0x14E4, 0x4322, "BCM4306", "UART" } ,
    { 0x14E4, 0x4323, "BCM4306", "V.90 56k Modem" } ,
    { 0x14E4, 0x4324, "Broadcom 43225", "802.11a/b/g Wireless LAN" } ,
    { 0x14E4, 0x4325, "BCM4306", "802.11b/g Wireless LAN Controller" } ,
    { 0x14E4, 0x4326, "BCM4306", "Chipcommon I/O Controller?" } ,
    { 0x14E4, 0x4328, "BCM4321KFBG", "Broadcom BCM43xx 1.0 (5.10.91.27)" } ,
    { 0x14E4, 0x4329, "BCM43XX", "Broadcom 802.11n Network Adapter" } ,
    { 0x14E4, 0x432B, "4322", "Broadcom Wireless LAN Driver " } ,
    { 0x14E4, 0x4331, "BCM4331", "Broadcom BCM4331" } ,
    { 0x14E4, 0x4353, "BCM943224HMS", "Broadcom Half Mini PCI Express Wifi card / DL1520 (aka Dell Wireless 1520 802.11n Mini Card WLAN Dri" } ,
    { 0x14E4, 0x4357, "BCM94322c5HM", "Broadcom WiFi 802.11b/g/n" } ,
    { 0x14E4, 0x4358, "BCM943227HM4L", "Broadcom 802.11n WLAN module" } ,
    { 0x14E4, 0x4359, "BCM943228HM4L", "Half-mini wireless-N card DW1530" } ,
    { 0x14E4, 0x4365, "061117AA", "Broadcom 43142 Wireless LAN Adapter" } ,
    { 0x14E4, 0x43a1, "0x4360", "Broadcom BCM4708A0" } ,
    { 0x14E4, 0x4401, "BCM4401", "10/100 Integrated Ethernet Controller" } ,
    { 0x14E4, 0x4402, "BCM440", "10/100 Integrated Ethernet Controller" } ,
    { 0x14E4, 0x4403, "BCM4402", "V.90 56k Modem" } ,
    { 0x14E4, 0x4410, "BCM4413", "iLine32 HomePNA 2.0" } ,
    { 0x14E4, 0x4411, "BCM4212", "V.90 56k Modem" } ,
    { 0x14E4, 0x4412, "BCM4412", "10/100BaseT Ethernet" } ,
    { 0x14E4, 0x4430, "BCM44xx", "CardBus iLine32 HomePNA 2.0" } ,
    { 0x14E4, 0x4432, "BCM44xx", "CardBus 10/100BaseT Ethernet" } ,
    { 0x14E4, 0x4610, "BCM4610", "Sentry5 PCI to SB Bridge" } ,
    { 0x14E4, 0x4611, "BCM4610", "Sentry5 iLine32 HomePNA 1.0" } ,
    { 0x14E4, 0x4612, "BCM4610", "Sentry5 V.90 56k Modem" } ,
    { 0x14E4, 0x4613, "BCM4610", "Sentry5 Ethernet Controller" } ,
    { 0x14E4, 0x4614, "BCM4610", "Sentry5 External Interface" } ,
    { 0x14E4, 0x4615, "BCM4610", "Sentry5 USB Controller" } ,
    { 0x14E4, 0x4704, "BCM4704", "Sentry5 PCI to SB Bridge" } ,
    { 0x14E4, 0x4708, "BCM4704", "Crypto Accelerator" } ,
    { 0x14E4, 0x4710, "BCM4710", "Sentry5 PCI to SB Bridge" } ,
    { 0x14E4, 0x4711, "BCM47xx", "Sentry5 iLine32 HomePNA 2.0" } ,
    { 0x14E4, 0x4712, "BCM47xx", "Sentry5 V.92 56k modem" } ,
    { 0x14E4, 0x4713, "BCM47xx", "Sentry5 Ethernet Controller" } ,
    { 0x14E4, 0x4714, "BCM47xx", "Sentry5 External Interface" } ,
    { 0x14E4, 0x4715, "BCM47xx", "Sentry5 USB Controller" } ,
    { 0x14E4, 0x4716, "BCM47xx", "Sentry5 USB Host Controller" } ,
    { 0x14E4, 0x4717, "BCM47xx", "Sentry5 USB Device Controller" } ,
    { 0x14E4, 0x4718, "BCM47xx", "Sentry5 Crypto Accelerator" } ,
    { 0x14E4, 0x4720, "BCM4712", "MIPS CPU" } ,
    { 0x14E4, 0x4726, "7175144f", "01" } ,
    { 0x14E4, 0x4727, "BCM1503HMGIPAD_NT61", "Dell Wireless 1501/1503/1701 Half Mini Card Driver  (used google chrome to download file)" } ,
    { 0x14E4, 0x4728, "7175144f", "01" } ,
    { 0x14E4, 0x5334, "BCM53343", "16P 1G  (PHY)" } ,
    { 0x14E4, 0x5365, "BCM5365P", "Sentry5 PCI to SB Bridge" } ,
    { 0x14E4, 0x5600, "BCM5600", "StrataSwitch 24+2 Ethernet Switch Controller" } ,
    { 0x14E4, 0x5605, "BCM5605", "StrataSwitch 24+2 Ethernet Switch Controller" } ,
    { 0x14E4, 0x5615, "BCM5784", "StrataSwitch 24+2 Ethernet Switch Controller" } ,
    { 0x14E4, 0x5625, "BCM5625", "StrataSwitch 24+2 Ethernet Switch Controller" } ,
    { 0x14E4, 0x5645, "BCM5645", "StrataSwitch 24+2 Ethernet Switch Controller" } ,
    { 0x14E4, 0x5670, "BCM5670", "8-Port 10GE Ethernet Switch Fabric" } ,
    { 0x14E4, 0x5680, "BCM5680", "G-Switch 8-Port Gigabit Ethernet Switch Controller" } ,
    { 0x14E4, 0x5690, "BCM5690", "12-port Multi-Layer Gigabit Ethernet Switch" } ,
    { 0x14E4, 0x5691, "BCM5691", "GE/10GE 8+2 Gigabit Ethernet Switch Controller" } ,
    { 0x14E4, 0x5802, "BCM5802", "The BCM5802 Security Processor integrates Broadcom�s IPSec engine (DES, 3DES, HMAC-SHA-1, HMAC-MD5)," } ,
    { 0x14E4, 0x5805, "BCM5805", "The BCM5805 Security Processor integrates a high-performance IPSec engine (DES, 3DES, HMAC-SHA-1, HM" } ,
    { 0x14E4, 0x5820, "BCM5820", "Crypto Accelerator" } ,
    { 0x14E4, 0x5821, "BCM5821", "Crypto Accelerator" } ,
    { 0x14E4, 0x5822, "BCM5822", "Crypto Accelerator" } ,
    { 0x14E4, 0x5823, "BCM5823", "Crypto Accelerator" } ,
    { 0x14E4, 0x5824, "BCM5824", "Crypto Accelerator" } ,
    { 0x14E4, 0x5825, "BCM5825", "BCM5825" } ,
    { 0x14E4, 0x5840, "BCM5840", "Crypto Accelerator" } ,
    { 0x14E4, 0x5841, "BCM5841", "Crypto Accelerator" } ,
    { 0x14E4, 0x5850, "BCM5850", "Crypto Accelerator" } ,
    { 0x14E4, 0x7321, "BCM5751", "network card integrated" } ,
    { 0x14E4, 0x7411, "BCM7411", "High Definition Video/Audio Decoder" } ,
    { 0x14E4, 0x7865, "BCM5787M", "Wireless-N WLAN" } ,
    { 0x14E4, 0x8010, "BCM53010", "Next generation router SOC with gigabit switch" } ,
    { 0x14E4, 0x8011, "BCM53011", "Next generation router SOC with gigabit switch" } ,
    { 0x14E4, 0x8012, "BCM53012", "Next generation router SOC with gigabit switch" } ,
    { 0x14E4, 0x8016, "BCM53016", "Next generation router SOC with gigabit switch with RGMII/SDIO, but disable 3 GPHY" } ,
    { 0x14E4, 0x8018, "BCM53018", "Next generation router SOC with gigabit switch with RGMII/SDIO" } ,
    { 0x14E4, 0x8019, "BCM53019", "Next generation router SOC with gigabit switch without RGMII/SDIO" } ,
    { 0x14E4, 0x8022, "BCM53022", "Next generation router SOC with gigabit switch with RGMII/SDIO" } ,
    { 0x14E4, 0x8023, "BCM53023", "Next generation router SOC with gigabit switch with SATA instead of RGMII/SDIO" } ,
    { 0x14E4, 0x8025, "BCM53025", "Next generation router SOC with gigabit switch with RGMII/SDIO, GMII, SGMII and SATA" } ,
    { 0x14E4, 0x8202, "BCM8202", "Packet Processor ASIC" } ,
    { 0x14E4, 0x8334, "BCM53334", "24 1G" } ,
    { 0x14E4, 0x8342, "BCM53342", "8 1G (PHY)" } ,
    { 0x14E4, 0x8344, "BCM53344", " 24P 1G +4P 1G  (PHY)" } ,
    { 0x14E4, 0x8346, "BCM53346", "24P 1G +4P 1G/10G  (PHY)" } ,
    { 0x14E4, 0x8393, "BCM53393", "14P (1G,  (no PHY)" } ,
    { 0x14E4, 0x8394, "BCM53394", "10P 1G + 4x1/2.5/5/10G  (no PHY) " } ,
    { 0x14E4, 0x8401, "BCM53401", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8402, "BCM53402", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8405, "BCM53405", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8406, "BCM53406", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8408, "BCM53408", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8411, "BCM53411", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8412, "BCM53412", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8415, "BCM53415", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8416, "BCM53416", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8418, "BCM53418", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0x8433, "BCM53433", "L2+ Ethernet switch: 16P 1G" } ,
    { 0x14E4, 0x8434, "BCM53434", "L2+ Ethernet switch: 24P 1G" } ,
    { 0x14E4, 0x8442, "BCM53442", "L2+ Ethernet switch: 8P 1G + 4P 1G" } ,
    { 0x14E4, 0x8443, "BCM53443", "L2+ Ethernet switch: 16P 1G + 4P 1G" } ,
    { 0x14E4, 0x8444, "BCM53444", "L2+ Ethernet switch: 24P 1G + 4P 1G" } ,
    { 0x14E4, 0x8446, "BCM53446", "L2+ Ethernet switch: 24P 1G +2P 1G/10G +2P 1G/10G" } ,
    { 0x14E4, 0x8447, "BCM53447", "L2+ Ethernet switch: 24P 1G +2P 1G/10G +2P 1G/10G" } ,
    { 0x14E4, 0x8448, "BCM53448", "L2+ Ethernet switch: 8P 1G + 8P 1G/2.5G + 4P 10G" } ,
    { 0x14E4, 0x8449, "BCM53449", "L2+ Ethernet switch: 16P 1G + 8P 1G/2.5G + 4P 10G + 2P 20G" } ,
    { 0x14E4, 0x9867, "900000000", "900000000" } ,
    { 0x14E4, 0x9876, "Texas Instruments PCI GemCore based SmartCard cont", "0x14E4" } ,
    { 0x14E4, 0xA8D6, "BCM6368", "Broadcom 802.11n WLAN chip" } ,
    { 0x14E4, 0xB061, "BCM56061", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0xB062, "BCM56062", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0xB063, "BCM56063", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0xB064, "BCM56064", "160Gbps L2+ Ethernet Switch" } ,
    { 0x14E4, 0xB150, "BCM56150", "Hurricane2 (Lightly Managed) 24P 1G +4P 1G/10G  (PHY)" } ,
    { 0x14E4, 0xb152, "BCM56152", "24P  1G (PHY)" } ,
    { 0x14E4, 0xB160, "BCM56160", "L2+ switch: 24P 1G +2P 1G/10G +2P 1G/10G" } ,
    { 0x14E4, 0xB161, "BCM56161", "L2+ Ethernet switch: 24P 1G +2P 1G/10G +2P 1G/10G" } ,
    { 0x14E4, 0xB162, "BCM56162", "L2+ Ethernet switch: 24P 1G +4P 1G" } ,
    { 0x14E4, 0xB340, "BCM56340", "48-port multi-layer switch with embedded CPU" } ,
    { 0x14E4, 0xB450, "BCM56450", "100G Multi-layer Ethernet Switch" } ,
    { 0x14E4, 0xB640, "BCM56640", "260Gbps Extensible Switch with 100GE" } ,
    { 0x14E4, 0xB842, "BCM56842", "320Gbps Ethernet Multilayer Switch" } ,
    { 0x14E4, 0xB845, "BCM56845", "640G Multi-layer Ethernet Switch" } ,
    { 0x14E4, 0xB850, "BCM56850", "1.28T I/O Multi-layer Ethernet Switch" } ,
    { 0x14E4, 0xB960, "BCM56960", "3.2T I/O Multi-layer Ethernet Switch" } ,
    { 0x14E4, 0x4311, "1364103c", "subsys" } ,
    { 0x14EB, 0x0020, "BEMx.x", "PCI to S5U13xxxB00B Bridge Adapter" } ,
    { 0x14EB, 0x0C01, "S1D13808", "Embedded Memory Display Controller" } ,
    { 0x14EC, 0x16BE, "CardReader_Broadcom", "1.0.0.222_W7x86_A" } ,
    { 0x14F5, 0x2F00, "x", "x" } ,
    { 0xAA42, 0x03A3, "9400-0931", "CharKey" } ,
    { 0x14FD, 0x0001, "H260u", "H260u printer server for HP Printer" } ,
    { 0xA304, 0x3038, "10EC", "USB" } ,
    { 0x165A, 0xC100, "PIXCI CL1", "PCI camera link video capture board" } ,
    { 0x165A, 0xD200, "PIXCI D2X", "PCI digital video capture board" } ,
    { 0x165A, 0xD300, "PIXCI D3X", "PCI digital video capture board" } ,
    { 0x165A, 0xF001, "PIXCI EL1", "PCI-E camera link video capture board" } ,
    { 0x1516, 0x0800, "Myson MTD803/TAMARACK TC6020", "PCI Ethernet controller" } ,
    { 0x1516, 0x0803, "Myson MTD803/TAMARACK TC6020", "PCI Ethernet controller" } ,
    { 0x1516, 0x0891, "Myson MTD803/TAMARACK TC6020", "PCI Ethernet controller" } ,
    { 0x1112, 0x2200, "2200", "FDDI adapter" } ,
    { 0x1112, 0x2300, "2300", "Fast Ethernet adapter" } ,
    { 0x1112, 0X2340, "2340", "4 Port 10/100 UTP Fast Ethernet Adapter" } ,
    { 0x1112, 0x2400, "2400", "ATM adapter" } ,
    { 0x1113, 0x1211, "EN5030, EN5038,EN1207D-TX/ Realtek 8139C", "Ethernet Controller 10/100 MBit" } ,
    { 0x1113, 0x1216, "EN5251BE", "accton  EN5251BE" } ,
    { 0x1113, 0x1217, "EN-2242", "Ethernet Adapter" } ,
    { 0x1113, 0x5105, "EN-1660", "untuk install driver" } ,
    { 0x1113, 0x9211, "EN-1207F", "Fast Ethernet Adapter" } ,
    { 0x1113, 0x9511, "SMC en5251be", "0445tabgf16143.1" } ,
    { 0x1113, 0x9876, "EN5251BE / EN1207F-TX", "Ethernet Controller/ drivers" } ,
    { 0xA200, 0xa200, "saa1735hl", "tv" } ,
    { 0x1114, 0x0506, "AT76C506", "802.11b Wireless Network Adaptor" } ,
    { 0x1114, 0x3202, "1103", "TPM - Trusted Platform Module" } ,
    { 0x1116, 0x0022, "DT3001", "" } ,
    { 0x1116, 0x0023, "DT3002", "9PAEAN" } ,
    { 0x1116, 0x0024, "DT3003", "" } ,
    { 0x1116, 0x0025, "DT3004", "" } ,
    { 0x1116, 0x0026, "Dt3005", "" } ,
    { 0x1116, 0x0027, "DT3001-PGL", "" } ,
    { 0x1116, 0x0028, "DT3003-PGL", "" } ,
    { 0x1117, 0x9500, "", "max-lc SVGA card" } ,
    { 0x1117, 0x9501, "", "MaxPCI image processing board" } ,
    { 0x1119, 0x0000, "GDT6000/6020/6050", "PCI SCSI RAID Controller" } ,
    { 0x1119, 0x0001, "GDT6000/6010", "PCI 1-channel SCSI RAID Controller" } ,
    { 0x1119, 0x0002, "GDT6110/6510", "PCI 1-channel SCSI RAID Controller" } ,
    { 0x1119, 0x0003, "GDT6120/6520", "PCI 2-channel SCSI RAID Controller" } ,
    { 0x1119, 0x0004, "GDT6530", "PCI 3-channel SCSI RAID Controller" } ,
    { 0x1119, 0x0005, "GDT6550", "PCI 5-channel SCSI RAID Controller" } ,
    { 0x1119, 0x0006, "GDT6117/6517", "Wide Ultra SCSI Controller" } ,
    { 0x1119, 0x0007, "GDT6127/6527", "Wide Ultra SCSI Controller" } ,
    { 0x1119, 0x0008, "GDT6537", "Wide Ultra SCSI Controller" } ,
    { 0x1119, 0x0009, "GDT6557/6557-ECC", "Wide Ultra SCSI Controller" } ,
    { 0x1119, 0x000A, "GDT6115/6515", "Ultra SCSI Controller" } ,
    { 0x1119, 0x000B, "GDT6125/6525", "Wide SCSI Controller" } ,
    { 0x1119, 0x000C, "GDT6535", "Wide SCSI Controller" } ,
    { 0x1119, 0x000D, "GDT6555/6555-ECC", "Wide SCSI Controller" } ,
    { 0x1119, 0x0100, "GDT6117RP/6517RP", "2 Channel Wide Ultra SCSI" } ,
    { 0x1119, 0x0101, "GDT6127RP/6527RP", "Wide Ultra SCSI HBA" } ,
    { 0x1119, 0x0102, "GDT6537RP", "Wide Ultra SCSI HBA" } ,
    { 0x1119, 0x0103, "GDT6557RP", "Wide Ultra SCSI HBA" } ,
    { 0x1119, 0x0104, "GDT6111RP/6511RP", "Ultra SCSI HBA" } ,
    { 0x1119, 0x0105, "GDT6121RP/6521RP", "Ultra SCSI HBA" } ,
    { 0x1119, 0x0110, "GDT6117RD/6517RD", "Wide Ultra SCSI HBA" } ,
    { 0x1119, 0x0111, "GDT6127RD/6527RD", "Wide Ultra SCSI HBA" } ,
    { 0x1119, 0x0112, "GDT6537RD", "Wide Ultra SCSI HBA" } ,
    { 0x1119, 0x0113, "GDT6557RD", "Wide Ultra SCSI HBA" } ,
    { 0x1119, 0x0114, "GDT6111RD/6511RD", "Ultra SCSI HBA" } ,
    { 0x1119, 0x0115, "GDT6127RD/6527RD", "Ultra SCSI HBA" } ,
    { 0x1119, 0x0118, "GDT6x18RD", "Wide Ultra2 SCSI HBA" } ,
    { 0x1119, 0x0119, "GDT6x28RD", "Wide Ultra2 SCSI HBA" } ,
    { 0x1119, 0x011A, "GDT6538RD/6638RD", "Wide Ultra2 SCSI HBA" } ,
    { 0x1119, 0x011B, "GDT6558RD/6658RD", "Wide Ultra2 SCSI HBA" } ,
    { 0x1119, 0x0120, "GDT6117RP2/6517RP2", "" } ,
    { 0x1119, 0x0121, "GDT6127RP2/6527RP2", "" } ,
    { 0x1119, 0x0122, "GDT6537RP2", "" } ,
    { 0x1119, 0x0123, "GDT6557RP2", "" } ,
    { 0x1119, 0x0124, "GDT6111RP2/6511RP2", "" } ,
    { 0x1119, 0x0125, "GDT6127RP2/6527RP2", "" } ,
    { 0x1119, 0x0136, "GDT 6x13RS", "" } ,
    { 0x1119, 0x0137, "GDT 6x23RS", "Disk Array Controller" } ,
    { 0x1119, 0x0138, "GDT 6x18RS", "" } ,
    { 0x1119, 0x0139, "GDT 6x28RS", "0139" } ,
    { 0x1119, 0x013A, "GDT 6x38RS", "IBM IXA - Integrated xSeries Adapter" } ,
    { 0x1119, 0x013B, "GDT 6x58RS", "" } ,
    { 0x1119, 0x013C, "GDT 6x33RS", "" } ,
    { 0x1119, 0x013D, "GDT 6x43RS", "" } ,
    { 0x1119, 0x013E, "GDT 6x53RS", "" } ,
    { 0x1119, 0x013F, "GDT 6x63RS", "" } ,
    { 0x1119, 0x0166, "GDT 7x13RN", "" } ,
    { 0x1119, 0x0167, "GDT 7x23RN", "" } ,
    { 0x1119, 0x0168, "GDT7x18RN", "64-bit PCI Wide Untra2 SCSI HBA" } ,
    { 0x1119, 0x0169, "GDT7x28RN", "64-bit PCI Wide Ultra2 SCSI HBA" } ,
    { 0x1119, 0x016A, "GDT7538RN/7638RN", "64-bit PCI Wide Ultra2 SCSI HBA" } ,
    { 0x1119, 0x016B, "GDT7558RN/7658RN", "64-bit PCI Wide Ultra2 SCSI HBA" } ,
    { 0x1119, 0x016C, "GDT 7x33RN", "" } ,
    { 0x1119, 0x016D, "GDT 7x43RN", "" } ,
    { 0x1119, 0x016E, "GDT 7x53RN", "" } ,
    { 0x1119, 0x016F, "GDT 7x63RN", "" } ,
    { 0x1119, 0x01D6, "GDT 4x13RZ", "GDT 4513RZ" } ,
    { 0x1119, 0x01D7, "GDT 4x23RZ", "" } ,
    { 0x1119, 0x01db, "GDT8514RZ", "SCSI Ultra320  1-channel" } ,
    { 0x1119, 0x01F6, "GDT 8x13RZ", "" } ,
    { 0x1119, 0x01F7, "1119", "BtYVKixCnmzB" } ,
    { 0x1119, 0x01FC, "GDT 8x33RZ", "cfa-4k" } ,
    { 0x1119, 0x01FD, "GDT 8x43RZ", "" } ,
    { 0x1119, 0x01FE, "GDT 8x53RZ", "" } ,
    { 0x1119, 0x01FF, "GDT 8x63RZ", "" } ,
    { 0x1119, 0x0210, "GDT6519RD/6619RD", "Fibre Channel HBA" } ,
    { 0x1119, 0x0211, "GDT6529RD/6629RD", "Fibre Channel HBA" } ,
    { 0x1119, 0x0260, "GDT7519RN/7619RN", "64-bit PCI Fibre Channel HBA" } ,
    { 0x1119, 0x0261, "GDT7529RN/7629RN", "64-bit PCI Fibre Channel HBA" } ,
    { 0x1119, 0x0300, "GDT Rx", "" } ,
    { 0x1119, 0x6111, "1", "61xx raid" } ,
    { 0x111A, 0x0000, "155P-MF1", "" } ,
    { 0x111A, 0x0002, "166P-MF1", "" } ,
    { 0x111A, 0x0003, "ENI-25P", "ATM Adapter" } ,
    { 0x111C, 0x0001, "921014946", "Powerbus Bridge" } ,
    { 0x111D, 0x0001, "55383", "zqUh5f  <a href=" } ,
    { 0x111D, 0x0003, "IDT77222/252", "MICRO ABR SAR PCI ATM Controller" } ,
    { 0x111D, 0x0004, "IDT77V252", "MICRO ABR SAR PCI ATM Controller" } ,
    { 0x111D, 0x7603, "IDT Audio CODEC", "IDT High Definition Audio CODEC" } ,
    { 0x111D, 0x7605, "IDT", "IDT High Definition Audio CODEC" } ,
    { 0x111D, 0x7608, "IDT Audio CODEC", "IDT High Definition Audio CODEC" } ,
    { 0x111D, 0x7616, "5.10.5515.0", "SigmaTel High Definition Audio CODEC" } ,
    { 0x111D, 0x7618, "STAC9221", "SigmaTel High Definition Audio CODEC" } ,
    { 0x111D, 0x7621, "Sigmatel HD", "IDT High Definition Codec" } ,
    { 0x111D, 0x7634, "IDT_Audiov5939", "IDT/Sigmae HDl Audio Driver v6.10.5939.0 05/06/2008" } ,
    { 0x111D, 0x7662, "IDT_Audiov5939", "SigmaTel High Definition Audio CODEC" } ,
    { 0x111D, 0x7667, "92hdxxx", "High Definition (HD) Audio Codecs" } ,
    { 0x111D, 0x7675, "92HD73C1", "92HD73C1" } ,
    { 0x111D, 0x7680, "102801ab", "SIGMATEL STAC 92XX " } ,
    { 0x111D, 0x76A0, "102801FF", "STAC 92XX C-Major HD Audio (Dell Precision M4300 and LAT D630 & D830)" } ,
    { 0x111D, 0x76B2, "92HD75B3", "IDT Audio" } ,
    { 0x111D, 0x76D1, "IDT 92HD87B1", "IDT High Definition Audio CODEC" } ,
    { 0x111D, 0x76D5, "0x76D1", "IDT 92HD87B1/3" } ,
    { 0x111D, 0x76D9, "00000000", "hp IDT Audio Codec" } ,
    { 0x111D, 0x76E7, "92HDxxx", "HDAUDIO" } ,
    { 0x111D, 0x8018, "PES12N3A", "PCI Express Switch" } ,
    { 0x111D, 0x802d, "PES16T7", "PCI Express Switch PES16T7" } ,
    { 0x111D, 0x806e, "PES24T6G2 ", "PCI Express Gen2 Switch" } ,
    { 0x111D, 0x8086, "IDT77201/211", "NICStAR ATM Adapter" } ,
    { 0x111D, 0x9876, "IDT_Audiov5939", "IDT/Sigmatel HDl Audio Driver v6.10.5939.0 05/06/2008" } ,
    { 0x111F, 0x4A47, "Precision MX", "Video engine interface" } ,
    { 0x111F, 0x5243, "", "Frame Capture Bus Interface" } ,
    { 0x1127, 0x0200, "FireRunner PCA-200", "ATM" } ,
    { 0x1127, 0x0210, "PCA-200PC", "ATM" } ,
    { 0x1127, 0x0250, "", "ATM" } ,
    { 0x1127, 0x0300, "PCA-200E", "ATM adapter" } ,
    { 0x1127, 0x0310, "", "ATM" } ,
    { 0x1127, 0x0400, "ForeRunner HE", "ATM Adapter" } ,
    { 0x1127, 0x1603, "USB\\Vid_04d9&Pid_160&Rev_0310", "atm" } ,
    { 0x8866, 0x1685, "T2-Mp3-001", "MP3 player/FM radio/voice recorder 256 Mo flash" } ,
    { 0x8866, 0x1689, "T2-MP3-001", "MP3 player/FM radio/voice recorder 256 Mo flash" } ,
    { 0x112D, 0x8086, "2200", "pci simple controller " } ,
    { 0x112E, 0x0000, "", "EIDE/hdd and IDE/cd-rom Ctrlr" } ,
    { 0x112E, 0x000B, "", "EIDE/hdd and IDE/cd-rom Ctrlr" } ,
    { 0x1130, 0xF211, "0x010", "USB Audio Sound Card" } ,
    { 0x1131, 0x0011, "028", "Ethernet Controller" } ,
    { 0x1131, 0x1001, "bm05e ", "BlueTooth &#1040;&#1076;&#1072;&#1087;&#1090;&#1077;&#1088; ISSCBTA [Tripper USB Dongle]" } ,
    { 0x1131, 0x1131,	"Philips Semic", "VerTV Hybrid Super 007 M135RA" } ,
    { 0x1131, 0x1131, "7130", "01384E42y8" } ,
    { 0x1131, 0x1201, "PTD3000", "VPN IPSEC coprocessor" } ,
    { 0x1131, 0x1234, "5.1.2600.0", "EHCI USB 2.0 Controller" } ,
    { 0x1131, 0x1301, "PTD3210", "SSL Accelerator" } ,
    { 0x1131, 0x1562, "ISP1561", "EHCI USB 2.0 Controller" } ,
    { 0x1131, 0x1996, "7130", "01384E42y8" } ,
    { 0x1131, 0x2780, "TDA2780AQ", "Stream\\LVTVTune " } ,
    { 0x1131, 0x3400, "UCB1500", "Modem" } ,
    { 0x1131, 0x3401, "UCB1500", "Multimedia Audio Device" } ,
    { 0x1131, 0x5400	, "TriMedia TM1000/1100", "Multimedia processor" } ,
    { 0x1131, 0x5400, "TriMedia TM1000/1100", "Multimedia processorkk" } ,
    { 0x1131, 0x5402, "TriMedia TM-1300EH", "Media Processor" } ,
    { 0x1131, 0x5406, "", "TriMedia PNX1700" } ,
    { 0x1131, 0x7130, "SAA7130HL", "01384E42" } ,
    { 0x1131, 0x7133, "Behold TV 609 FM", "PCI audio and video broadcast decoder or only avertv dvb-t pci card" } ,
    { 0x1131, 0x7134, "0x7134", "SAA7134 TV Card Philips" } ,
    { 0x1131, 0x7145, "d145ah", "ddddf" } ,
    { 0x1131, 0x7146, "saa7146ah", " 0X7146" } ,
    { 0x1131, 0x7160, "Philips SAA7134E, TDA10046 and TDA8275A", "PCI\\VEN_1131&DEV_7160&SUBSYS_1F551461&REV_03" } ,
    { 0x1131, 0x7162, "idk", "idk" } ,
    { 0x1131, 0x7164, "PE9400", "ASUS My Cinnema PE9400 PCI-E 1x capture card." } ,
    { 0x1131, 0x7231, "Philips 7231/726x-&#1057;&#1077;&#1088;&#1080;&#10", "AVerMedia H339 &#1043;&#1080;&#1073;&#1088;&#1080;&#1076;&#1085;&#1099;&#1081; &#1040;&#1085;&#1072;" } ,
    { 0x1131, 0x9730, "SAA9730", "Ethernet controller" } ,
    { 0x1131, 0x9876, "tw9903 ", "saa7146ah" } ,
    { 0x1131, 0xFFFF, "FF", "device" } ,
    { 0x1133, 0x7711, "EiconCard C91", "" } ,
    { 0x1133, 0x7901, "EiconCard S90", "" } ,
    { 0x1133, 0x7902, "", "" } ,
    { 0x1133, 0x7911, "", "" } ,
    { 0x1133, 0x7912, "", "" } ,
    { 0x1133, 0x7941, "", "" } ,
    { 0x1133, 0x7942, "", "" } ,
    { 0x1133, 0x7943, "", "EiconCard S94" } ,
    { 0x1133, 0x7944, "", "EiconCard S94" } ,
    { 0x1133, 0xB921, "", "" } ,
    { 0x1133, 0xB922, "", "" } ,
    { 0x1133, 0xB923, "", "EiconCard P92" } ,
    { 0x1133, 0xE001, "DIVA Pro 2.0 S/T", "Pro 2." } ,
    { 0x1133, 0xE002, "DIVA 2.0 S/T", "" } ,
    { 0x1133, 0xE003, "DIVA Pro 2.0 U", "" } ,
    { 0x1133, 0xE004, "DIVA 2.0 U", "chip" } ,
    { 0x1133, 0xE005, "DIVA 2.01 S/T", "Eicon ISDN card using Siemens IPAC chip" } ,
    { 0x1133, 0xE00B, "DIVA ISDN 2.02 PCI", "Eicon ISDN card using Infineon chip" } ,
    { 0x1133, 0xE010, "Maestra", "DIVA Server BRI-2M" } ,
    { 0x1133, 0xE012, "MaestraQ", "DIVA Server BRI-8M" } ,
    { 0x1133, 0xE013, "MaestraQ-U", "DIVA Server 4BRI/PCI" } ,
    { 0x1133, 0xE014, "MaestraP", "DIVA Server PRI-30M" } ,
    { 0x1133, 0xE015, "", "Diva Server PRI-30M PCI v.2" } ,
    { 0x1133, 0xE018, "00", "DIVA Server BRI-2M/-2F" } ,
    { 0x1134, 0x0001, "1106", "audio driver" } ,
    { 0x1134, 0x0002, "DPRB", "Dual PCI to RapidIO Bridge" } ,
    { 0x1134, 0x9876, "3059", "audio driver" } ,
    { 0x1135, 0x0001, "", "Printer Cntrlr" } ,
    { 0x1138, 0x8905, "8905", "STD 32 Bridge" } ,
    { 0x113C, 0x0000, "PCI9060", "i960 Bridge" } ,
    { 0x113C, 0x0001, "PCI9060", "i960 Bridge / Evaluation Platform" } ,
    { 0x113C, 0x0911, "PCI911", "i960Jx I/O Controller" } ,
    { 0x113C, 0x0912, "PCI912", "i960Cx I/O Controller" } ,
    { 0x113C, 0x0913, "PCI913", "i960Hx I/O Controller" } ,
    { 0x113C, 0x0914, "PCI914", "I/O Controller with secondary PCI bus" } ,
    { 0x113F, 0x0808, "SST-64P", "Adapter" } ,
    { 0x113F, 0x1010, "SST-128P", "Adapter" } ,
    { 0x113F, 0x80C0, "", "" } ,
    { 0x113F, 0x80C4, "", "" } ,
    { 0x113F, 0x80C8, "", "" } ,
    { 0x113F, 0x8888, "", "" } ,
    { 0x113F, 0x9090, "", "" } ,
    { 0x1141, 0x0001, "", "EIDE/ATAPI super adapter" } ,
    { 0x1142, 0x3210, "ProMotion 3210", "VGA/AVI Playback Accelerator" } ,
    { 0x1142, 0x6410, "6410 6422", "GUI Accelerator" } ,
    { 0x1142, 0x6412, "", "GUI Accelerator" } ,
    { 0x1142, 0x6420, "", "GUI Accelerator" } ,
    { 0x1142, 0x6422, "ProMotion-6422", "ProMotion-6422" } ,
    { 0x1142, 0x6424, "ProVideo 6424", "ProMotion AT24 GUI Accelerator" } ,
    { 0x1142, 0x6425, "ProMotion AT25", "0752 20005" } ,
    { 0x1142, 0x6426, "aT25", "GUI Accelerator" } ,
    { 0x1142, 0x643D, "AT25", "ProMotion-AT3D" } ,
    { 0x1142, 0x9876, "ProMotion 6422", "139K76B 9808" } ,
    { 0x1142, 3210, "9809", "139K76B" } ,
    { 0x1144, 0x0001, "", "Noservo Cntrlr" } ,
    { 0x1145, 0xF020, "", "CardBus ATAPI Host Adapter" } ,
    { 0x1145, 0xF021, "NPATA32", "CardBus CompactFlash Adapter" } ,
    { 0x1145, 0xf024, "NPATA-32", "CardBus CompactFlash Adapter" } ,
    { 0x1147, 0x1123, "123", "131dq" } ,
    { 0x1148, 0x4000, "SK-NET", "FDDI adapter" } ,
    { 0x1148, 0x4200, "", "Token Ring Adapter" } ,
    { 0x1148, 0x4300, "SysKonnect Genesis", "SK-NET Gigabit Ethernet Adapter" } ,
    { 0x1148, 0x4320, "Marvell Yukon D-Link DGE530T", "SysKonnect Marvel RDK 8001" } ,
    { 0x1148, 0x4362, "88E8053", "Marvell Yukon 88E8053 based Ethernet Controller" } ,
    { 0x1148, 0x9000, "Marvell Yukon II PCI-X", "PCI-X 10/100/1000Base-T Server" } ,
    { 0x1148, 0x9E00, "Marvell Yukon EC", "PCI Express 10/100/1000Base-T Desktop" } ,
    { 0x114A, 0x5565, "VMIPCI-5565", "Ultrahigh-Speed Fiber-Optics Reflective Memory w/ Interrupts" } ,
    { 0x114A, 0x5579, "VMIPCI-5579", "Reflective Memory Card" } ,
    { 0x114A, 0x5588, "VMICPCI5588", "VMICPCI5588 Reflective Memory Card" } ,
    { 0x114A, 0x6504, "", "Timer/SRAM FPGA" } ,
    { 0x114A, 0x7587, "VMIVME-7587", "" } ,
    { 0x114D, 0x2189, "0x1002114D", "PCTel HSP56 PCI Modem" } ,
    { 0x114F, 0x0002, "AccelePort EPC", "ACPI\\NSC6001" } ,
    { 0x114F, 0x0003, "RightSwitch SE-6", "" } ,
    { 0x114F, 0x0004, "AccelePort Xem", "driver" } ,
    { 0x114F, 0x0005, "AccelePort Xr", "" } ,
    { 0x114F, 0x0006, "AccelePort C/X", "" } ,
    { 0x114F, 0x0007, "DataFire PCI 1 S/T", "Digi Data Fire PCI 1 S/T" } ,
    { 0x114F, 0x0009, "AccelePort Xr/J", "" } ,
    { 0x114F, 0x000A, "AccelePort EPC/J", "" } ,
    { 0x114F, 0x000C, "DataFirePRIme T1", "" } ,
    { 0x114F, 0x000D, "SyncPort", "X.25/FR 2-port" } ,
    { 0x114F, 0x0011, "AccelePort8r EIA-232", "" } ,
    { 0x114F, 0x0012, "AccelePort8r EIA-422", "" } ,
    { 0x114F, 0x0013, "AccelePort Xr", "" } ,
    { 0x114F, 0x0014, "AccelePort8r EIA-422", "" } ,
    { 0x114F, 0x0015, "AccelePort Xem", "" } ,
    { 0x114F, 0x0016, "AccelePort EPC/X", "" } ,
    { 0x114F, 0x0017, "AccelePort C/X", "" } ,
    { 0x114F, 0x0019, "DataFire PCI 1 U", "" } ,
    { 0x114F, 0x001A, "DataFirePRIme E1", "" } ,
    { 0x114F, 0x001B, "AccelePort C/X (IBM)", "" } ,
    { 0x114F, 0x001D, "DataFire RAS", "T1/E1/PRI" } ,
    { 0x114F, 0x001F, "", "ClydeNonCsu6034" } ,
    { 0x114F, 0x0020, "", "ClydeNonCsu6032" } ,
    { 0x114F, 0x0021, "", "ClydeNonCsu4" } ,
    { 0x114F, 0x0022, "", "ClydeNonCsu2" } ,
    { 0x114F, 0x0023, "AccelePort RAS", "" } ,
    { 0x114F, 0x0024, "DataFire RAS B4 ST/U", "" } ,
    { 0x114F, 0x0026, "AccelePort 4r 920", "" } ,
    { 0x114F, 0x0027, "AccelePort 8r 920", "" } ,
    { 0x114F, 0x0029, "DigiClassic PCI", "" } ,
    { 0x114F, 0x0034, "AccelePort 2r 920", "" } ,
    { 0x114F, 0x0035, "DataFire DSP", "T1/E1/PRI, Compact PCI" } ,
    { 0x114F, 0x0040, "AccelePort Xp", "" } ,
    { 0x114F, 0x0042, "AccelePort 2p PCI", "" } ,
    { 0x114F, 0x0070, "DataFire Micro V", "" } ,
    { 0x114F, 0x0071, "DataFire Micro V", "Descargar" } ,
    { 0x114F, 0x0072, "DataFire Micro V", "" } ,
    { 0x114F, 0x0073, "DataFire Micro V", "" } ,
    { 0x114F, 0x00c8, "20F0", "Digi Neo 2" } ,
    { 0x114F, 0x6001, "Avanstar", "ACPI\\VEN_HPQ&DEV_6001" } ,
    { 0x5143, 0x9204, "Unknown", "WAN Card Lenovo Notebook" } ,
    { 0x1155, 0x0810, "", "486 CPU/PCI Bridge" } ,
    { 0x1155, 0x0922, "2838", "Pentium CPU/PCI Bridge" } ,
    { 0x1155, 0x0926, "", "PCI/ISA Bridge" } ,
    { 0x1158, 0x3011, "3011", "Tokenet/vg 1001/10m anylan" } ,
    { 0x1158, 0x9050, "", "Lanfleet/Truevalue" } ,
    { 0x1158, 0x9051, "", "Lanfleet/Truevalue" } ,
    { 0x1159, 0x0001, "MV1000", "" } ,
    { 0x1159, 0x0002, "MV-1500", "Frame Grabber" } ,
    { 0x115D, 0x0003, "RBEM56G-100", "Cardbus Ethernet 10/100+Modem 56" } ,
    { 0x115D, 0x0005, "NEC VersaPro VA70j need to reinstall driver", "CardBus Ethernet 10/100" } ,
    { 0x115D, 0x0007, "", "CardBus Ethernet 10/100" } ,
    { 0x115D, 0x000B, "", "CardBus Ethernet 10/100" } ,
    { 0x115D, 0x000C, "MPCI 3A56GSP-100 PA", "Mini-PCI V.90 56k Modem" } ,
    { 0x115D, 0x000F, "", "CardBus Ethernet 10/100" } ,
    { 0x115D, 0x002b, "168c", "Winmodem built into NEC Versa VXi" } ,
    { 0x115D, 0x0076, "2U6MLA-35295-M5-E", "Xircom MPCI3B-56G (Lucent SCORPIO) Soft" } ,
    { 0x115D, 0x00d3, "2333333333333", "Xircom MPCI Modem 56" } ,
    { 0x115D, 0x00D4, "MPCI", "Modem 56k" } ,
    { 0x115D, 0x0101, "Ms0612006303", "CardBus 56k Modem" } ,
    { 0x115D, 0x0103, "", "CardBus Ehternet + 56k Modem" } ,
    { 0x1161, 0x0001, "921014946", "Host Bridge" } ,
    { 0x1163, 0x0001, "Verite 1000", "3D Blaster" } ,
    { 0x1163, 0x2000, "Rendition V2200 (1179-002)", "Rendition V2200 (BLITZ 2200 AGP)" } ,
    { 0x1165, 0x0001, "", "Motion JPEG rec/play w/audio" } ,
    { 0x1165, 0x0060, " ", "Foresight Imaging I-Color" } ,
    { 0x1165, 0x0088, "03200-150", "AccuStream 50a, 75a & 205a Frame Grabber & Video Streamer" } ,
    { 0x1166, 0x0005, "NB6536 (CNB20-LE)", "PCI to PCI Bridge, bus/dev/func 0/0/1" } ,
    { 0x1166, 0x0006, "NB6536 (CNB20-HE)", "Host Bridge, function 2 and function 3" } ,
    { 0x1166, 0x0007, "NB6635 (CNB20-LE/HE)", "CPU to PCI Bridge" } ,
    { 0x1166, 0x0008, "NB6536 (CNB20-HE)", "Hostbridge & MCH, bus/dev/func 0/0/0" } ,
    { 0x1166, 0x0009, "NB6536 (CNB20-LE)", "AGP interface" } ,
    { 0x1166, 0x0010, "CIOB30", "" } ,
    { 0x1166, 0x0011, "CMIC-HE", "" } ,
    { 0x1166, 0x0012, "CMIC-LE", "" } ,
    { 0x1166, 0x0013, "CNB20-HE", "Hostbridge and MCH" } ,
    { 0x1166, 0x0014, "CNB20-HE", "Host Bridge" } ,
    { 0x1166, 0x0015, "CMIC-GC", "Hostbridge and MCH" } ,
    { 0x1166, 0x0016, "CMIC-GC", "Host Bridge" } ,
    { 0x1166, 0x0017, "CMIC-SL", "" } ,
    { 0x1166, 0x0101, "CIOB-X2", "" } ,
    { 0x1166, 0x0103, "47553", " " } ,
    { 0x1166, 0x0110, "CIOB-E", "I/O Bridge with Gigabit Ethernet ServerWorks Grand Champion" } ,
    { 0x1166, 0x0200, "OSB4", "PCI to ISA Bridge" } ,
    { 0x1166, 0x0201, "CSB5", "ISA bridge" } ,
    { 0x1166, 0x0203, "CSB6", "PCI to ISA Bridge" } ,
    { 0x1166, 0x0211, "OSB4", "PATA33 Controller" } ,
    { 0x1166, 0x0212, "CSB5", "PATA66" } ,
    { 0x1166, 0x0213, "CSB6", "PATA100 RAID Controller" } ,
    { 0x1166, 0x0217, "CSB6", "PATA100 IDE Controller" } ,
    { 0x1166, 0x0220, "OSB4", "OpenHCI Compliant USB Controller" } ,
    { 0x1166, 0x0221, "OSB6", "OHCI Compliant USB Controller" } ,
    { 0x1166, 0x0223, "0x0223", "USB controller" } ,
    { 0x1166, 0x0225, "CSB5", "PCI Bridge" } ,
    { 0x1166, 0x0227, "CSB6", "PCI Bridge" } ,
    { 0x1166, 0x0230, "???", "PCI to ISA bridge" } ,
    { 0x1166, 0x0240, "RaidCore4000", "Apple K2 SATA AHCI&RAID Controller" } ,
    { 0x1166, 0x0241, "RC5000Series&BC48??(4850L&4852...)", "ServerWorks Frodo4 SATA RAID Controller" } ,
    { 0x1166, 0x0242, "RaidCore4000 Series", "ServerWorks Frodo8 8xSATA RAID" } ,
    { 0x1166, 0x024A, "BC5785", "Broadcom5785/Serverworks HT1000 AHCI Controller" } ,
    { 0x1166, 0x024B, "BC5785", "BC5785/ServerWorks HT1000 SATA(IDE MODE)" } ,
    { 0x1166, 0x0252, "RaidCore5000 Series", "ServerWorks Elrond 8xSAS/SATAII" } ,
    { 0x1168, 0x7145, "1002", "ATI Mobility Radeon X 1400" } ,
    { 0x1169, 0x0102, "QL5032", "32 Channel Digital Input Card Interface" } ,
    { 0x1169, 0x0202, "QL5032", "16 Channel Digital Output, 16 Channel Digital Input Interface" } ,
    { 0x1169, 0x0302, "QL5032", "32 Channel Analog Input Interface" } ,
    { 0x1169, 0x0402, "QL5032", "16 Channel Analog Output / Analog Input Interface" } ,
    { 0x1169, 0x0502, "QL5232", "8 Channel Timer Counter Interface" } ,
    { 0x1169, 0x0902, "QL5232", "PCI to TigerSHARC FPGA Interface" } ,
    { 0x1169, 0x2001, "Ql5032-33APQ208C", "PCI to C-DAC RTU bus interface FPGA" } ,
    { 0x116A, 0x6100, "", "Bus/Tag Channel" } ,
    { 0x116A, 0x6800, "", "Escon Channel" } ,
    { 0x116A, 0x7100, "", "Bus/Tag Channel" } ,
    { 0x116A, 0x7800, "nvidia harmony", "Escon Channel" } ,
    { 0x116E, 0x0015, "VX120", "Fiery EX2000D RIP Card Melbourne VX120" } ,
    { 0x116E, 0x0500, "Vx500", "Printer ASIC" } ,
    { 0x1172, 0x0001, "EPF6016ATC144-2", "S CCA5000243A" } ,
    { 0x1172, 0x0004, "-epf6016qc240-2", "Multi-serial card" } ,
    { 0x1172, 0x0007, "StratixIIGX", "Altera FPGA board" } ,
    { 0x1172, 0x1234, "5SGXEA7N", "Stratix V FPGA" } ,
    { 0x1172, 0xD4AA, "EP1AGX90EF1152C6N", "Arria GX" } ,
    { 0x1176, 0x8474, "42000133", "Conexant Multichannel Synchronous Communications Controller (MUSYCC)" } ,
    { 0x1178, 0xAFA1, "", "Fast Ethernet" } ,
    { 0x1179, 0x8136, "RTL8101E", "Realtek 10/100/1000 PCI-E NIC Family" } ,
    { 0x1179, 0x0102, "toshiba america info systems", "Trusted Platform Module" } ,
    { 0x1179, 0x0103, "833810", "Extended PCI IDE Controller Type-B" } ,
    { 0x1179, 0x01179, "0x8136", "PCI\\VEN_8086&DEV_3B03&SUBSYS_02FE1028&REV_05\\3&11583659&0&F8" } ,
    { 0x1179, 0x0201, "PCI\\VEN_1814&DEV_3298&SUBSYS_1451033", "Ralink Chipset 802.11b/g WLAN Card" } ,
    { 0x1179, 0x0404, "", "" } ,
    { 0x1179, 0x0406, "Tecra a2", "Video Capture device" } ,
    { 0x1179, 0x0407, "NVIDIA GeForce 8600M GT", "NVIDIA GeForce 8600M GT" } ,
    { 0x1179, 0x051D, "LEN0068", "ACPI" } ,
    { 0x1179, 0x0601, "0555873412", "Toshiba CPU to PCI bridge" } ,
    { 0x1179, 0x0602, "TOS6205", "PCI to ISA Bridge for Notebooks" } ,
    { 0x1179, 0x0603, "ToPIC95", "PCI to CardBus Bridge for Notebooks" } ,
    { 0x1179, 0x0604, "PCI\\VEN_104C&DEV_803B&SUBSYS_FF1E1179", "PCI to PCI Bridge for Notebooks" } ,
    { 0x1179, 0x0605, "ACPI\\IBM0068", "PCI to ISA Bridge for Notebooks" } ,
    { 0x1179, 0x0606, "", "PCI to ISA Bridge for Notebooks" } ,
    { 0x1179, 0x0609, "0322", "PCI to PCI Bridge for Notebooks" } ,
    { 0x1179, 0x060A, "ToPIC95B", "Toshiba ToPIC95 CardBus Controller" } ,
    { 0x1179, 0x060F, "ToPIC97", "CardBus Controller" } ,
    { 0x1179, 0x0611, "PNP0510", "PCI-ISA Bridge" } ,
    { 0x1179, 0x0617, "ToPIC100", "PCI to CardBus Bridge with ZV support" } ,
    { 0x1179, 0x0618, "", "CPU to PCI and PCI to ISA Bridge" } ,
    { 0x1179, 0x0701, "1E3D", "PCI Communication Device" } ,
    { 0x1179, 0x0804, "0x0804", "Toshiba Smart Media Host Controller" } ,
    { 0x1179, 0x0805, "ACPI\\TOS1901\\2&DABA3FF&er.com1", "ACPI\\ASD0001\\2&DABA3FF&1" } ,
    { 0x1179, 0x0D01, "0x0D01", "FIR Port Type-O" } ,
    { 0x1179, 0x1179, "32", "Dispositivo de comunicaciones pci" } ,
    { 0x1179, 0x13A8, "XR17C158/154/152", "Multi-channel PCI UART" } ,
    { 0x1179, 0x168, "AREG9485 WB", "Qualcomm Atheros AR9485WB-EG wireless Network Adapter" } ,
    { 0x1179, 0x3b64, "intel 3b64", "Management Engine Driver" } ,
    { 0x1179, 0x8136, "0x8136", "pci\\ven_10 EC" } ,
    { 0x1179, 0x9876, "ACPI\\TOS1901", "SD Card Controller" } ,
    { 0x117B, 0x8320, "NOFM12", "VGA" } ,
    { 0x117C, 0x0030, "ExpressPCI UL5D", "Dual-Channel Low-Profile Ultra320 SCSI PCIe Host Bus Adapter" } ,
    { 0x117C, 0x0042, "ExpressSAS H60F", "Low-Profile 16-Internal Port 6Gb/s SAS/SATA PCIe 2.0 Host Bus Adapter" } ,
    { 0x117E, 0x0001, "", "Printer Host" } ,
    { 0x1185, 0x8929, "", "EIDE Controller" } ,
    { 0x1186, 0x0100, "88e8003", "Ethernet Adapter" } ,
    { 0x1186, 0x1002, "DFE-550TX/580TX/DFE-550FX", "Fast Ethernet Adapter" } ,
    { 0x1186, 0x1100, "driv16c003206", "Fast Ethernet Adapter" } ,
    { 0x1186, 0x1300, "DL10038C or DL10038E", "Realtek RTL8139 Family PCI Fast Ethernet Adapter" } ,
    { 0x1186, 0x1301, "DGE-528T ", "Fast Ethernet Adapter" } ,
    { 0x1186, 0x1340, "DFE-690TXD", "Fast Ethernet CardBus PC Card" } ,
    { 0x1186, 0x1561, "DRP-32TXD", "CardBus PC Card" } ,
    { 0x1186, 0x3065, "14001186", "D-Link DFE-500Tx PCI fast Ethernet adapter Re v.A" } ,
    { 0x1186, 0x3106, "DFE 520TX/530TX+ rev E1", "Fast Ethernet Adapter" } ,
    { 0x1186, 0x3300, "D-Link Air Wireless Network (DWL-G510)", "IEEE 802.11g PCI card" } ,
    { 0x1186, 0x3b00, "0x3b001186", "D-LINK DWL-650+" } ,
    { 0x1186, 0x3c09, "DWL-G510 Version C1", "Ralink RT61" } ,
    { 0x1186, 0x4000, "DL2000", "Gigabit Ethernet Adapter" } ,
    { 0x1186, 0x4001, "DFE-650TX", "D Link Fast Ethernet PCMCIA Card" } ,
    { 0x1186, 0x4200, "DFE-520TX_C1", "-" } ,
    { 0x1186, 0x4300, "dlg10086", "Used on DGE-528T Gigabit adaptor" } ,
    { 0x1186, 0x4302, "dg530t", "DGE-530T" } ,
    { 0x1186, 0x4b00, "DGE-560T", "D-Link System Inc DGE-560T PCI Express Gigabit Ethernet Adapter (rev 13)" } ,
    { 0x1186, 0x4B01, "DGE-530T", "Gigabit Ethernet Adapter" } ,
    { 0x1186, 0x4C00, "DGE-530T", "Gigabit Ethernet Adapter" } ,
    { 0x1186, 0x9876, "876", "d" } ,
    { 0x1189, 0x1592, "", "VL/PCI Bridge" } ,
    { 0x118C, 0x0014, "PCIB", "C-bus II to PCI bus host bridge chip" } ,
    { 0x118C, 0x1117, "MAC-94C201B3", "Corollary/Intel Memory Controller Chip" } ,
    { 0x118D, 0x0001, "n/a", "Raptor-PCI framegrabber" } ,
    { 0x118D, 0x0012, "Model 12", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0014, "Model 14", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0024, "Model 24", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0044, "Model 44", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0112, "Model 12", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0114, "Model 14", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0124, "Model 24", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0144, "Model 44", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0212, "Model 12", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0214, "Model 14", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0224, "Model 24", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0244, "Model 44", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0312, "Model 12", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0314, "Model 14", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0324, "Model 24", "Road Runner Frame Grabber" } ,
    { 0x118D, 0x0344, "Model 44", "Road Runner Frame Grabber" } ,
    { 0x118E, 0x0042, "", "" } ,
    { 0x118E, 0x0142, "", "" } ,
    { 0x118E, 0x0242, "", "" } ,
    { 0x118E, 0x0342, "", "" } ,
    { 0x118E, 0x0440, "", "" } ,
    { 0x118E, 0x0442, "", "" } ,
    { 0x118E, 0x0842, "02321038", "red" } ,
    { 0x1191, 0x0001, "", "IDE Ctrlr" } ,
    { 0x1191, 0x0002, "ATP850UF", "UltraDMA33 EIDE Controller (AEC6210UF)" } ,
    { 0x1191, 0x0003, "", "SCSI-2 cache Cntrlr" } ,
    { 0x1191, 0x0004, "4111111111111111", "UltraDMA33 EIDE Controller" } ,
    { 0x1191, 0x0005, "ATP850UF", "UltraDMA33 EIDE Controller (AEC6210UF)" } ,
    { 0x1191, 0x0006, "ATP860A", "UltraDMA66 EDIE Controller (AEC6260)" } ,
    { 0x1191, 0x0007, "ATP860R", "UltraDMA66 EIDE Controller (AEC6260)" } ,
    { 0x1191, 0x0008, "ATP865", "2CH PCI UltraDMA133 IDE Controller" } ,
    { 0x1191, 0x0009, "ATP865", "AEC6280PATA133|AEC6880 PATA RAID|AEC6290 SATA|AEC6890 SATA RAID|AEC6891 SATA RAID" } ,
    { 0x1191, 0x000a, "aec6885", "ACARD AEC-6885/6895/6896 RAID Controller" } ,
    { 0x1191, 0x000B, "373953244361001", "ACARD AEC-6897/6898 RAID Controller" } ,
    { 0x1191, 0x000D, "ATP8620", "2S1P PCI-X SATA(3G)/UDMA Combo Controller" } ,
    { 0x1191, 0x8001, "ATP8600", "SCSI-2 RAID (cache?) Adapter (AEC6820U)" } ,
    { 0x1191, 0x8002, "ATP850S/5412751206270000", "AEC6710S/U/UW SCSI-2 Host Adapter " } ,
    { 0x1191, 0x8010, "ATP870", "Ultra Wide SCSI Controller" } ,
    { 0x1191, 0x8020, "ATP870", "AEC6712U/TU Ultra SCSI Controller" } ,
    { 0x1191, 0x8030, "ATP870", "AEC 6712S/TS Ultra SCSI Controller" } ,
    { 0x1191, 0x8040, "ATP870", "SCSI Controller" } ,
    { 0x1191, 0x8050, "", "AEC6715UW Ultra Wide SCSI Controller" } ,
    { 0x1191, 0x8060, "4116360015430005", "SCSI Host Adapter/PAYPAL.COM/X.COM" } ,
    { 0x1191, 0x8081, "5412751206270000", "PCI Ultra160 LVD/SE SCSI Adapter" } ,
    { 0x1191, 0x808A, "ATP885", "AEC6710S/U/UW SCSI-2 Host Adapter" } ,
    { 0x1197, 0x010C, "CompuScope 82G", "8-bit 2GS/s Analog Input Card" } ,
    { 0x1199, 0x0001, "IRMA 3270 PCI Adapter", "IRMA 3270 PCI Adapter" } ,
    { 0x1199, 0x0002, "", "Advanced ISCA PCI Adapter" } ,
    { 0x1199, 0x0201, "", "SDLC PCI Adapter" } ,
    { 0x119B, 0x1221, "82C092G", "PCI PCMCIA bridge" } ,
    { 0x119E, 0x0001, "MB86697", "FireStream 155 ATM adapter" } ,
    { 0x119E, 0x0003, "MB86695", "FireStream 50 ATM adapter" } ,
    { 0xECC0, 0x0050, "", "" } ,
    { 0xECC0, 0x0051, "", "" } ,
    { 0xECC0, 0x0060, "", "" } ,
    { 0xECC0, 0x0070, "", "" } ,
    { 0xECC0, 0x0071, "", "" } ,
    { 0xECC0, 0x0072, "", "" } ,
    { 0xECC0, 0x0080, "MiaMIDI", "4/2 channel (analog/digital) audio card" } ,
    { 0xECC0, 0x0100, "GINA3G", "6/8 channel (analog/digital) audio card" } ,
    { 0xECC0, 0x3410, "0x0001", "Motorola" } ,
    { 0x11A8, 0x7302, "", "NTX-8023-PCI 2MB Long Card" } ,
    { 0x11A8, 0x7308, "", "NTX-8023-PCI 8MB Long Card" } ,
    { 0x11A8, 0x7402, "", "NTX-8023-PCI 2MB Short Card" } ,
    { 0x11A8, 0x7408, "", "NTX-8023-PCI 8MB Short Card" } ,
    { 0x11A9, 0x4240, "AMCC S5933Q", "pci matchmaker 9622qac" } ,
    { 0x11AB, 0x0028, "NV05", "MCP67 High Definition Audio" } ,
    { 0x11AB, 0x0146, "GT-64010/A", "System Ctrlr for R4xxx/5000 Family CPUs" } ,
    { 0x11AB, 0x11AB, "88E8055 PCI-E", "Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x11AB, "88E8055", "Marvell Yukon 88E8055 PCI-E Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x11AB, "88E8055 PCI-E", "Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x13F8, "W8300", "802.11 Adapter" } ,
    { 0x11AB, 0x1fa6, "88W8310", "The Libertas WLAN 802.11b/g" } ,
    { 0x11AB, 0x1FA7, "88W8310", "Libertas WLAN 802.11b/g" } ,
    { 0x11AB, 0x1fa8, "WG311", "54M Wireless 802.11b PCI wifi Adapter Card" } ,
    { 0x11AB, 0x1FAA, "8335 (MRV8835)", "Marvell Libertas 802.11 b/g Wireless (8335)" } ,
    { 0x11AB, 0x2A30, "88W8687", "PCI-Express 802.11bg Wireless" } ,
    { 0x11AB, 0x4320, "88E8001", "Marvell Yukon PCI E Gigabit drivers for d" } ,
    { 0x11AB, 0x4350, "88E8036", "Yukon PCI-E Fast Ethernet Controller" } ,
    { 0x11AB, 0x4351, "88E8036", "Yukon PCI-E Fast Ethernet Controller" } ,
    { 0x11AB, 0x4352, "88E8038", "Marvell Yukon 88E8038 PCI-E Fasvt Ethernet Controller" } ,
    { 0x11AB, 0x4353, "88E8039", "88E8039 PCIe Fast Ethernet Controller" } ,
    { 0x11AB, 0x4354, "88E8040", "Marvell Yukon 88E8040 PCI-E Fast Ethernet Controller" } ,
    { 0x11AB, 0x4355, "88E8001", "Marvell Yukon 88E8040T PCI-E Fast Ethernet Controller" } ,
    { 0x11AB, 0x4357, "88E8042", "marvell ethernet lan No painel " } ,
    { 0x11AB, 0x4360, "88E8050", "Yukon PCI-E ASF Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x4361, "88E8036", "Marvell Yukon 88E8036 Network Card" } ,
    { 0x11AB, 0x4362, "88E8053", "Marvell Yukon 88E8053 PCI-E Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x4363, "88E8042", "Yukon PCI-E Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x4364, "81f81043", "Yukon PCI-E Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x4365, "88E8070", "Yukon Gigabit Controller DRIVER" } ,
    { 0x11AB, 0x436A, "88E8058", "Marvell Yukon 88E8058" } ,
    { 0x11AB, 0x436b, "88E8072", "Marvell Yukon 8072" } ,
    { 0x11AB, 0x436b-1, "88E8072", "Marvell Yukon PCI-E Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x436C, "88E8072", "Marvell 8072 Ethernet Nic" } ,
    { 0x11AB, 0x4380, "88e8071", "Marvell Yukon 88E8057 PCI-E Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x4381, "88E8059", "Marvell Yukon 88E8059 PCI-E Gigabit Ethernet Controller" } ,
    { 0x11AB, 0x4611, "GT-64115", "System Controller" } ,
    { 0x11AB, 0x4620, "GT-64120", "System Controller for R5000 & R7000 (64-bit PCI)" } ,
    { 0x11AB, 0x4801, "88w8335", "8 port switched ethernet ctrlr" } ,
    { 0x11AB, 0x4809, "EV-48300", "Evaluation board for the GT-48300" } ,
    { 0x11AB, 0x5005, "F5D5005", "Belkin Desktop Gigabit PCI card" } ,
    { 0x11AB, 0x5040, "88SX5040", "4-port SATA I PCI-X Controller" } ,
    { 0x11AB, 0x5041, "88SX504", "4-port SATA I PCI-X Controller" } ,
    { 0x11AB, 0x5080, "RocketRAID 62x", "SATA Controller" } ,
    { 0x11AB, 0x5081, "RocketRAID 182x", "SATA Controller" } ,
    { 0x11AB, 0x6041, "MV88SX6041", "Marvell Technology Group Ltd. MV88SX6041 4-port SATA II PCI-X Controller (rev 03)" } ,
    { 0x11AB, 0x6081, "0007", "PCI-X RocketRAID 222x SATA Controller" } ,
    { 0x11AB, 0x6101, "88SE6101", "PATA 133 One Channel" } ,
    { 0x11AB, 0x6111, "?", "61xx RAID" } ,
    { 0x11AB, 0x6120, "?", "61xx RAID" } ,
    { 0x11AB, 0x6121, "88SE6121", "61xx AHCI" } ,
    { 0x11AB, 0x6122, "?", "61xx RAID" } ,
    { 0x11AB, 0x6140, "4355", "61xx RAID" } ,
    { 0x11AB, 0x6145, "88SE6145", "Marvell 6145 SATA II PCI-E Controller 4 SATA2 300MB/s ports - Thor 4S/1P" } ,
    { 0x11AB, 0x6320, "GT-64130/131", "System Controller for PowerPC Processors" } ,
    { 0x11AB, 0x6440, "88SE6320", "64xx/63xx SAS" } ,
    { 0x11AB, 0x6480, "MV6446x", "PowerPC System Controller" } ,
    { 0x11AB, 0x6485, "MV6446x ", "Marvel 88SE6480 is the chip on the mainboard" } ,
    { 0x11AB, 0x9128, "SE9128", "SATA3  6 GB/s  SATA3/Raid Controller" } ,
    { 0x11AB, 0x91A2              , "91xx", "Sata 6G RAID Controller" } ,
    { 0x11AB, 0x9653, "GT-96100A", "Advanced Communication Controller" } ,
    { 0x11AB, 0x9876, "88E8038", "marvell yukon 88E8038 pci-e fast ethernet controller" } ,
    { 0x11AB, 0xF003, "GT-64010", "Primary Image Piranha Image Generator" } ,
    { 0x11AB, 0xF004, "GT64120", "Primary Image Barracuda Image Generator" } ,
    { 0x11AB, 0xF006, "GT-64120A", "Primary Image Cruncher Geometry Accelerator" } ,
    { 0x11AB, 0xFFFF, "88SA8040", "PATA2SATA/SATA2PATA Bridge" } ,
    { 0x11AD, 0x0001, "LC82C168", "Fast Ethernet Adapter" } ,
    { 0x11AD, 0x0002, "LC82C169", "NETGEAR FA310TX Fast Ethernet PCI Adapter" } ,
    { 0x11AD, 0xC115, "LC82C115", "PNIC II PCI MAC/PHY" } ,
    { 0x11AE, 0x4153, "", "Bridge Controller" } ,
    { 0x11AE, 0x5842, "", "Bridge Controller" } ,
    { 0x11AF, 0x0001, "9704", "Cinema" } ,
    { 0x11AF, 0x000A, " ", "Nitris" } ,
    { 0x11AF, 0x000B, " ", "Nitris DX / Mojo DX" } ,
    { 0x11B0, 0x0001, "V960PBC/PSC", "i960 Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0002, "V961PBC/PSC", "i960Jx Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0004, "V962PBC/PSC", "i960Cx/Hx Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0010, "V292PBC/PSC", "Am29K Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0021, "V363EPC", "i960Sx Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0022, "V363EPC", "i960Jx Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0024, "V363EPC", "i960Cx/Hx Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0030, "V363EPC", "Am29K Local Bus to PCI Bridge" } ,
    { 0x11B0, 0x0100, "V320USC", "PCI System Ctrlr for 32-bit MIPS CPU" } ,
    { 0x11B0, 0x0101, "V320USC", "PCI System Ctrlr for 32-bit MIPS CPU" } ,
    { 0x11B0, 0x0102, "V320USC", "PCI System Ctrlr for Super-H SH3 CPU" } ,
    { 0x11B0, 0x0103, "V320USC", "PCI System Ctrlr for Super-H SH4 CPU" } ,
    { 0x11B0, 0x0200, "V370PDC", "High Performance PCI SDRAM Controller" } ,
    { 0x11B0, 0x0292, "V292PBC", "Am29030/40 Bridge" } ,
    { 0x11B0, 0x0500, "V340HPC", "PCI System Ctrlr for 64-bit MIPS CPU" } ,
    { 0x11B0, 0x0960, "V96xPBC", "i960 Bridges for i960 Processors" } ,
    { 0x11B0, 0x4750, "V3 V962PBC-40LP / VLSI VP06597A", "SCRAMNet" } ,
    { 0x11B0, 0xC960, "V96DPC", "i960 Dual PCI Bridge" } ,
    { 0x11B5, 0x0001, "PMC/PMX1553", "1553 Bus Interface Card" } ,
    { 0x11B5, 0x0002, "PMCF1", "FLASH memory Card" } ,
    { 0x11B5, 0x0003, "PMCMMA", "Multi Media Adapter" } ,
    { 0x11B5, 0x0004, "PMCVGO", "Video Graphics Overlay" } ,
    { 0x11B5, 0x0005, "PMCPCIS", "PPzero Slave Interface Card" } ,
    { 0x11B5, 0x0006, "PMCPCIM", "PPzero Master Interface Card" } ,
    { 0x11B5, 0x0007, "PMCQ1", "Serial/1553 Interface Card" } ,
    { 0x11B5, 0x0008, "EPMCQ2", "Intelligent Serial/Ethernet Card" } ,
    { 0x11B5, 0x0009, "PMCPIO1", "Parallel I/O Module" } ,
    { 0x11B5, 0x000a, "PMCFA1C", "Fibre Channel Adapter" } ,
    { 0x11B5, 0x000b, "PMCHH1", "High Speed DSP Gateway Module" } ,
    { 0x11B5, 0x000c, "PMCMA2", "Memory Adaptor Module" } ,
    { 0x11B5, 0x0012, "PMCF1", "FLASH memory Card (V2)" } ,
    { 0x11B5, 0x0013, "PMC1553EX", "1553 Bus Interface Card" } ,
    { 0x11B5, 0x0014, "PMC1553E", "1553 Bus Interface Card" } ,
    { 0x11B5, 0x2200, "PMCFA2C", "Dual Fibre Channel Adapter" } ,
    { 0x0070, 0x6800, "PCI\\VEN_14F1&DEV_2F30&SUBSY5_205D14F1&REV_01\\3&130", "Hauppage Nova -TD-500 DVB-T Tuner Device" } ,
    { 0x0070, 0x6800, "PCI\\VEN_14F1&DEV_8810&REV_05", "Hauppage Nova -TD-500 DVB-T Tuner Device" } ,
    { 0x11B8, 0x0001, "Quad PeerMaster", "" } ,
    { 0x11B9, 0xC0ED, "SSA Ctrlr", "" } ,
    { 0x11BC, 0x0001, "NPI NuCard", "PCI FDDI" } ,
    { 0x11BD, 0x0015, "660806-2.0", "rob2d" } ,
    { 0x11BD, 0x1111, "1456", "www.unibobodioulasso.0fees.net" } ,
    { 0x11BD, 0x1158, "48", "Tunner Royal TS 1" } ,
    { 0x11BD, 0x11BD, "MB87J3560", "maintenance informatique" } ,
    { 0x11BD, 0x11FE, "49", "Tunner Royal TS 2" } ,
    { 0x11BD, 0x2020, "assistance en ligne", "70009823/76199706" } ,
    { 0x11BD, 0xBEBE, "51015777", "MAINTENANCE INFORMATIQUE VENTE DE CONSOMABLE" } ,
    { 0x11BD, 0xBEDE, "51014521", "Pinnacle Studio 700 PCI" } ,
    { 0x11C1, 0x0440, "LT Winmodem 56k", "Data+Fax+Voice+DSVD" } ,
    { 0x11C1, 0x0441, "5517158", "modem driver" } ,
    { 0x11C1, 0x0442, "1646T00", "LT WinModem 56K Data+Fax" } ,
    { 0x11C1, 0x0443, "LT Winmodem", "1646T00" } ,
    { 0x11C1, 0x0444, "LT Winmodem", "845G" } ,
    { 0x11C1, 0x0445, "LT Winmodem", "" } ,
    { 0x11C1, 0x0446, "NVidia SMBus", "PCI\\VEN_10DE&DEV_03d1&subsys_26011019&rev_a2\\3&2411e6fe&0&68" } ,
    { 0x11C1, 0x0447, "LT Winmodem", "windowsme" } ,
    { 0x11C1, 0x0448, "LT Winmodem 56k", "SV2P2" } ,
    { 0x11C1, 0x0449, "LT Winmodem 56k", "0449144F" } ,
    { 0x11C1, 0x044A, "LT Winmodem 56k", "pci ven_1904" } ,
    { 0x11C1, 0x044B, "LT Winmodem", "USB\\VID_13FD&PID_1650&REV_0446" } ,
    { 0x11C1, 0x044C, "LT Winmodem", "SV95PL-TOO" } ,
    { 0x11C1, 0x044D, "LT Winmodem", "" } ,
    { 0x11C1, 0x044E, "12232", "LT WinModem 56k Data+Fax or Agere F-1156IV/A3" } ,
    { 0x11C1, 0x044F, "90094-1", "LT V.90+DSL WildFire Modem" } ,
    { 0x11C1, 0x0450, "1468VQH19R-1(INT)", "LT Winmodem 56K" } ,
    { 0x11C1, 0x0451, "LT Winmodem", "LT WinModem 56k Data+Fax+Voice+DSVD" } ,
    { 0x11C1, 0x0452, "LT Winmodem", "1513144" } ,
    { 0x11C1, 0x0453, "LT Winmodem", "" } ,
    { 0x11C1, 0x0454, "LT Winmodem", "" } ,
    { 0x11C1, 0x0455, "LT Winmodem", "" } ,
    { 0x11C1, 0x0456, "LT Winmodem", "" } ,
    { 0x11C1, 0x0457, "LT Winmodem", "" } ,
    { 0x11C1, 0x0458, "1648C", "Mars 3 Mercury v.92 v.44" } ,
    { 0x11C1, 0x0459, "LT Winmodem", "" } ,
    { 0x11C1, 0x045A, "LT Winmodem", "" } ,
    { 0x11C1, 0x045D, "LT WinModem", "mars2" } ,
    { 0x11C1, 0x0461, "90094", "V90 Wildfire Modem" } ,
    { 0x11C1, 0x0462, "1690", "56K.V90/ADSL Wildwire Modem" } ,
    { 0x11C1, 0x0464, "This is NOT a Riptide! (as previously stated)", "Lucent Wildwire v.90 + DSL modem" } ,
    { 0x11C1, 0x0480, "Venus Winmodem ", "56k.V90/ADSL Wildfire Modem " } ,
    { 0x11C1, 0x048b, "1648T00", "creative modem blaster di5733-1" } ,
    { 0x11C1, 0x048C, "1648c-tv5", "net-comm modem" } ,
    { 0x11C1, 0x048d, "lt winmodem", "9m56pml-g" } ,
    { 0x11C1, 0x048E, "svp92pl-t00", "56k V.92modem" } ,
    { 0x11C1, 0x048F, "SV92P-T00", "Agere PCI Soft Modem. SV92PL" } ,
    { 0x11C1, 0x0540, "", "" } ,
    { 0x11C1, 0x0600, "sv5", "SV92P-T00 Agere PCI Soft Modem. SV92PL" } ,
    { 0x11C1, 0x0620, "SV92PP", "Agere PCI Soft Modem " } ,
    { 0x11C1, 0x0630, "11c1063011c1", "#1: 32 pins, 8 each on 4 sides #2: 20 pins, 10 ea on 2 sides. - hp / compaq - Modem_HP_sp45489" } ,
    { 0x11C1, 0x1040, "Prespa", "Agere Systems HDA Modem" } ,
    { 0x11C1, 0x11c1, "Преспа", "Agere Systems Модем HDA" } ,
    { 0x11C1, 0x3026, "0x11c11040", "Agere Modem" } ,
    { 0x11C1, 0x3055, "Modem on Audio Bus", "Agere Systems HDA Modem v6081" } ,
    { 0x11C1, 0x4758, "210888GX", "Mach64 GX" } ,
    { 0x11C1, 0x5400, "OR3TP12", "FPSC FPGA with 32/64bit, 33/66MHz core" } ,
    { 0x11C1, 0x5801, "", "USB Open Host Controller" } ,
    { 0x11C1, 0x5802, "USS-312MC", "2-port PCI-to-USB OpenHCI Host Ctrlr" } ,
    { 0x11C1, 0x5803, "USS-344", "QuadraBus 4-port USB OpenHCI Host Ctrlr" } ,
    { 0x11C1, 0x5805, "uss344", "USB Advanced Host Controller" } ,
    { 0x11C1, 0x5811, "FW322/323", "1394A PCI PHY/Link Open Host Ctrlr I/F" } ,
    { 0x11C1, 0x5901, "FW643", "firewire chip for macbook pro" } ,
    { 0x11C1, 0x9876, "lucent 1646T00", "LT WinModem 56K Data+Fax" } ,
    { 0x11C1, 0xAB20, "WaveLAN", "PCI Wireless LAN Adapter" } ,
    { 0x11C1, 0xAB30, "wlsam48d", "Mini-PCI WaveLAN a/b/g" } ,
    { 0x11C1, 0xED00, "ET-131x", "PCI-E Ethernet Controller" } ,
    { 0x11C1, 7121, "", "" } ,
    { 0x11C6, 0x3001, "1", "VM-1200 Opto Unit Controller" } ,
    { 0x11C8, 0x0658, "PSB 32", "32 bit , 33 Mhz PCI-SCI Bridge" } ,
    { 0x11C8, 0xD665, "PSB64", "64 bit , 33 Mhz PCI-SCI Bridge" } ,
    { 0x11C8, 0xD667, "PSB66", "64 bit , 66 Mhz PCI-SCI Bridge. (D33x)" } ,
    { 0x11C9, 0x0010, "1106", "16-line serial port w/DMA" } ,
    { 0x11C9, 0x0011, "", "4-line serial port w/DMA" } ,
    { 0x11CB, 0x2000, "PCI-9050-1100083-11", "port small IC" } ,
    { 0x11CB, 0x4000, "SUPI-1", "XIO/SIO Host" } ,
    { 0x11CB, 0x8000, "T225", "Bridge RIO Host" } ,
    { 0x11CE, 0x102B, "1001", "FF00102B" } ,
    { 0x11D1, 0x01F7, "VxP524", "PCI Video Processor" } ,
    { 0x11D1, 0x01F8, "VxP524", "PCI Video Processor" } ,
    { 0x11D1, 0x01f9, "rev_03", "tuner card" } ,
    { 0x11D4, 0x11D4, "1986", "AD1988B 8-channel High Definition Audio CODEC" } ,
    { 0x11D4, 0x1535, "ADSP-21535", "Blackfin DSP PCI Bus Interface" } ,
    { 0x11D4, 0x1805, "62412-51", "U52018.2-0.6" } ,
    { 0x11D4, 0x1884, "AD1884HD", "SoundMAX Integrated Digital HD Audio" } ,
    { 0x11D4, 0x1889, "AD1980", "Sound Chip" } ,
    { 0x11D4, 0x194A, "AD1984A", "SoundMAX Integrated Digital Audio" } ,
    { 0x11D4, 0x1981, "7037", "SoundMAX Integrated Digital Audio" } ,
    { 0x11D4, 0x1983, "AD1983HD", "SoundMAX Integrated Digital HD Audio" } ,
    { 0x11D4, 0x1984, "Analog Devices ADI 1984", "Analog Devices ADI 1984 Integrated HD Audio" } ,
    { 0x11D4, 0x1986, "ADI1986A", "SoundMAX Digital HD Audio" } ,
    { 0x11D4, 0x1988, "AD1981", "HD Audio Codec" } ,
    { 0x11D4, 0x198B, "AD1988B", "SoundMAX AD1988B 8channel CODEC" } ,
    { 0x11D4, 0x2192, "ADSP-2192", "DSP Microcomputer (function #0)" } ,
    { 0x11D4, 0x219A, "ADSP-2192", "DSP Microcomputer (function #1)" } ,
    { 0x11D4, 0x219E, "ADSP-2192", "DSP Microcomputer (function #2)" } ,
    { 0x11D4, 0x2F44, "ADSP-1882", "SafeNet Crypto Accelerator chip" } ,
    { 0x11D4, 0x989B, "AD1989B", "SoundMax Integrated Digital HD Audio" } ,
    { 0x11D5, 0x0115, "10115", "Versatec Parallel Interface (VPI) + Centronics" } ,
    { 0x11D5, 0x0116, "10118", "DR11-W emulator" } ,
    { 0x11D5, 0x0117, "10117", "Versatec Parallel Interface (VPI) + Centronics" } ,
    { 0x11D5, 0x0118, "10118", "DR11-W emulator" } ,
} ;


// Use this value for loop control during searching:
#define	PCI_DEVTABLE_LEN	(sizeof(PciDevTable)/sizeof(PCI_DEVTABLE))

typedef struct _PCI_CLASSCODETABLE
{
    unsigned char	BaseClass ;
    unsigned char	SubClass ;
    unsigned char	ProgIf ;
    const char *		BaseDesc ;
    const char *		SubDesc ;
    const char *		ProgDesc ;
}  PCI_CLASSCODETABLE, *PPCI_CLASSCODETABLE ;

PCI_CLASSCODETABLE PciClassCodeTable [] =
{
    { 0x00, 0x00, 0x00, "Pre-2.0 PCI Specification Device", "Non-VGA","" } ,
    { 0x00, 0x01, 0x00, "Pre-2.0 PCI Specification Device", "VGA Compatible", "" } ,

    { 0x01, 0x00, 0x00, "Mass Storage Controller", "SCSI", "" } ,
    { 0x01, 0x01, 0xFF, "Mass Storage Controller", "IDE", "" } ,
    { 0x01, 0x02, 0x00, "Mass Storage Controller", "Floppy", "" } ,
    { 0x01, 0x03, 0x00, "Mass Storage Controller", "IPI", "" } ,
    { 0x01, 0x04, 0x00, "Mass Storage Controller", "RAID", "" } ,
    { 0x01, 0x06, 0x00, "Mass Storage Controller", "SATA", "Vendor Specific Interface" } ,
    { 0x01, 0x06, 0x01, "Mass Storage Controller", "SATA", "AHCI 1.0" } ,
    { 0x01, 0x80, 0x00, "Mass Storage Controller", "Other", "" } ,

    { 0x02, 0x00, 0x00, "Network Controller", "Ethernet", "" } ,
    { 0x02, 0x01, 0x00, "Network Controller", "Token Ring", "" } ,
    { 0x02, 0x02, 0x00, "Network Controller", "FDDI", "" } ,
    { 0x02, 0x03, 0x00, "Network Controller", "ATM", "" } ,
    { 0x02, 0x80, 0x00, "Network Controller", "Other", "" } ,

    { 0x01, 0x05, 0x20, "Mass Storage Controller", "ATA controller with single DMA", "" } ,
    { 0x01, 0x05, 0x30, "Mass Storage Controller", "ATA controller with chained DMA", "" } ,

    { 0x03, 0x00, 0x00, "Display Controller", "PC Compatible", "VGA" } ,
    { 0x03, 0x00, 0x01, "Display Controller", "PC Compatible", "8514" } ,
    { 0x03, 0x01, 0x00, "Display Controller", "XGA", "" } ,
    { 0x03, 0x80, 0x00, "Display Controller", "Other", "" } ,

    { 0x04, 0x00, 0x00, "Multimedia Device", "Video", "" } ,
    { 0x04, 0x01, 0x00, "Multimedia Device", "Audio", "" } ,
    { 0x04, 0x80, 0x00, "Multimedia Device", "Other", "" } ,

    { 0x05, 0x00, 0x00, "Memory Controller", "RAM", "" } ,
    { 0x05, 0x01, 0x00, "Memory Controller", "Flash", "" } ,
    { 0x05, 0x80, 0x00, "Memory Controller", "Other", "" } ,

    { 0x06, 0x00, 0x00, "Bridge Device", "Host/PCI", "" } ,
    { 0x06, 0x01, 0x00, "Bridge Device", "PCI/ISA", "" } ,
    { 0x06, 0x02, 0x00, "Bridge Device", "PCI/EISA", "" } ,
    { 0x06, 0x03, 0x00, "Bridge Device", "PCI/Micro Channel", "" } ,
    { 0x06, 0x04, 0x00, "Bridge Device", "PCI/PCI", "" } ,
    { 0x06, 0x05, 0x00, "Bridge Device", "PCI/PCMCIA", "" } ,
    { 0x06, 0x06, 0x00, "Bridge Device", "PCI/NuBus", "" } ,
    { 0x06, 0x07, 0x00, "Bridge Device", "PCI/CardBus", "" } ,
    { 0x06, 0x80, 0x00, "Bridge Device", "Other", "" } ,

    { 0x07, 0x00, 0x00, "Simple Communications Controller", "Serial", "Generic XT Compatible" } ,
    { 0x07, 0x00, 0x01, "Simple Communications Controller", "Serial", "16450 Compatible" } ,
    { 0x07, 0x00, 0x02, "Simple Communications Controller", "Serial", "16550 Compatible" } ,
    { 0x07, 0x01, 0x00, "Simple Communications Controller", "Parallel", "Standard" } ,
    { 0x07, 0x01, 0x00, "Simple Communications Controller", "Parallel", "Bidirectional" } ,
    { 0x07, 0x01, 0x01, "Simple Communications Controller", "Parallel", "ECP 1.X Compliant" } ,
    { 0x07, 0x80, 0x02, "Simple Communications Controller", "Other", "" } ,

    { 0x08, 0x00, 0x00, "Base Systems Peripheral", "PIC (Programmable Interrupt Controller)", "Generic 8259" } ,
    { 0x08, 0x00, 0x01, "Base Systems Peripheral", "PIC (Programmable Interrupt Controller)", "ISA" } ,
    { 0x08, 0x00, 0x02, "Base Systems Peripheral", "PIC (Programmable Interrupt Controller)", "PCI" } ,
    { 0x08, 0x01, 0x00, "Base Systems Peripheral", "DMA (Direct Memory Access)", "Generic 8259" } ,
    { 0x08, 0x01, 0x01, "Base Systems Peripheral", "DMA (Direct Memory Access)", "ISA" } ,
    { 0x08, 0x01, 0x02, "Base Systems Peripheral", "DMA (Direct Memory Access)", "EISA" } ,
    { 0x08, 0x02, 0x00, "Base Systems Peripheral", "System Timer", "Generic 8259" } ,
    { 0x08, 0x02, 0x01, "Base Systems Peripheral", "System Timer", "ISA" } ,
    { 0x08, 0x02, 0x02, "Base Systems Peripheral", "System Timer", "EISA" } ,
    { 0x08, 0x03, 0x00, "Base Systems Peripheral", "RTC (Real Time Clock)", "Generic" } ,
    { 0x08, 0x03, 0x01, "Base Systems Peripheral", "RTC (Real Time Clock)", "ISA" } ,
    { 0x08, 0x80, 0x00, "Base Systems Peripheral", "Other", "" } ,

    { 0x09, 0x00, 0x00, "Input Device", "Keyboard", "" } ,
    { 0x09, 0x01, 0x00, "Input Device", "Digitizer (Pen)", "" } ,
    { 0x09, 0x02, 0x00, "Input Device", "Mouse", "" } ,
    { 0x09, 0x80, 0x00, "Input Device", "Other", "" } ,

    { 0x0A, 0x00, 0x00, "Docking Station", "Generic", "" } ,
    { 0x0A, 0x80, 0x00, "Docking Station", "Other", "" } ,

    { 0x0B, 0x00, 0x00, "Processor", "i386", "" } ,
    { 0x0B, 0x01, 0x00, "Processor", "i486", "" } ,
    { 0x0B, 0x02, 0x00, "Processor", "Pentium", "" } ,
    { 0x0B, 0x10, 0x00, "Processor", "Alpha", "" } ,
    { 0x0B, 0x20, 0x00, "Processor", "Power PC", "" } ,
    { 0x0B, 0x80, 0x00, "Processor", "Co-processor", "" } ,

    { 0x0C, 0x00, 0x00, "Serial Bus Controller", "Firewire (IEEE 1394)", "" } ,
    { 0x0C, 0x01, 0x00, "Serial Bus Controller", "ACCESS.bus", "" } ,
    { 0x0C, 0x02, 0x00, "Serial Bus Controller", "SSA (Serial Storage Archetecture)", "" } ,
    { 0x0C, 0x03, 0x00, "Serial Bus Controller", "USB (Universal Serial Bus)", "" } ,
    { 0x0C, 0x04, 0x00, "Serial Bus Controller", "Fibre Channel", "" } ,

    { 0xFF, 0x00, 0x00, "Unknown", "Device Does Not Fit In Class Codes", "UDF" } ,
} ;

// Use this value for loop control during searching:
#define	PCI_CLASSCODETABLE_LEN	(sizeof(PciClassCodeTable)/sizeof(PCI_CLASSCODETABLE))

const char *	PciCommandFlags [] =
{
    "I/O Access",
    "Memory Access",
    "Bus Mastering",
    "Special Cycles",
    "Memory Write & Invalidate",
    "Palette Snoop",
    "Parity Errors",
    "Wait Cycles",
    "System Errors",
    "Fast Back-To-Back",
    "Reserved 10",
    "Reserved 11",
    "Reserved 12",
    "Reserved 13",
    "Reserved 14",
    "Reserved 15"
} ;

// Use this value for loop control during searching:
#define	PCI_COMMANDFLAGS_LEN	(sizeof(PciCommandFlags)/sizeof(char *))


const char *	PciStatusFlags [] =
{
    "Reserved 0",
    "Reserved 1",
    "Reserved 2",
    "Reserved 3",
    "Reserved 4",
    "66 MHz Capable",
    "User-Defined Features",
    "Fast Back-To-Back",
    "Data Parity Reported",
    "",
    "",
    "Signalled Target Abort",
    "Received Target Abort",
    "Received Master Abort",
    "Signalled System Error",
    "Detected Parity Error"
} ;

// Use this value for loop control during searching:
#define	PCI_STATUSFLAGS_LEN	(sizeof(PciStatusFlags)/sizeof(char *))


const char *	PciDevSelFlags [] =
{
    "Fast Devsel Speed",     // TypeC
    "Medium Devsel Speed",   // TypeB
    "Slow Devsel Speed",     // TypeA
    "Reserved 9&10"
} ;

// Use this value for loop control during searching:
#define	PCI_DEVSELFLAGS_LEN	(sizeof(PciDevSelFlags)/sizeof(char *))

#endif
