## @package pypowerextender
# @file ADS1115_Registers.py
# @author Christoph Honal
# @brief Defines the needed registers for the ADS1115
# @version 0.0.1
# @date 2021-07-20

from enum import IntEnum

ADS1115_REG_POINTER_CONVERSION = 0x00
ADS1115_REG_POINTER_CONFIG = 0x01
ADS1115_REG_LOW_THRESHOLD = 0x02
ADS1115_REG_HIGH_THRESHOLD = 0x03

ADS1115_REG_CONFIG_HI_OS_MASK = 0x80
ADS1115_REG_CONFIG_HI_OS_BEGIN = 0x80
ADS1115_REG_CONFIG_HI_OS_BUSY = 0x00
ADS1115_REG_CONFIG_HI_OS_IDLE = 0x80

ADS1115_REG_CONFIG_HI_MUX_MASK = 0x70
ADS1115_REG_CONFIG_HI_MUX_AIN_N_GND = 0x40
ADS1115_REG_CONFIG_HI_MUX_AIN_P_MASK = 0x30
ADS1115_REG_CONFIG_HI_MUX_AIN_P_OFFSET = 4

ADS1115_REG_CONFIG_HI_PGA_MASK = 0x0E
ADS1115_REG_CONFIG_HI_PGA_OFFSET = 1

class ADS1115_PGA(IntEnum):
    PGA_6_144 = (0x00 << ADS1115_REG_CONFIG_HI_PGA_OFFSET)
    PGA_4_096 = (0x01 << ADS1115_REG_CONFIG_HI_PGA_OFFSET)
    PGA_2_048 = (0x02 << ADS1115_REG_CONFIG_HI_PGA_OFFSET)
    PGA_1_024 = (0x03 << ADS1115_REG_CONFIG_HI_PGA_OFFSET)
    PGA_0_512 = (0x04 << ADS1115_REG_CONFIG_HI_PGA_OFFSET)
    PGA_0_256 = (0x05 << ADS1115_REG_CONFIG_HI_PGA_OFFSET)

ADS1115_REG_CONFIG_HI_MODE_MASK = 0x01
ADS1115_REG_CONFIG_HI_MODE_CONTINUOUS = 0x00
ADS1115_REG_CONFIG_HI_MODE_SINGLESHOT = 0x01

ADS1115_REG_CONFIG_LO_DR_MASK = 0xE0
ADS1115_REG_CONFIG_LO_DR_OFFSET = 5

class ADS1115_DR(IntEnum):
    DR_8 = (0x00 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
    DR_16 = (0x01 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
    DR_32 = (0x02 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
    DR_64 = (0x03 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
    DR_128 = (0x04 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
    DR_250 = (0x05 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
    DR_475 = (0x06 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
    DR_860 = (0x07 << ADS1115_REG_CONFIG_LO_DR_OFFSET)

ADS1115_REG_CONFIG_LO_COMP_MODE_TRAD = 0x00
ADS1115_REG_CONFIG_LO_COMP_MODE_WINDOW = 0x10

ADS1115_REG_CONFIG_LO_COMP_POL_LOW = 0x00
ADS1115_REG_CONFIG_LO_COMP_POL_HIGH = 0x08

ADS1115_REG_CONFIG_LO_COMP_LAT_NON = 0x00
ADS1115_REG_CONFIG_LO_COMP_LAT_LATCH = 0x04

ADS1115_REG_CONFIG_LO_COMP_QUE_1 = 0x00
ADS1115_REG_CONFIG_LO_COMP_QUE_2 = 0x01
ADS1115_REG_CONFIG_LO_COMP_QUE_3 = 0x02
ADS1115_REG_CONFIG_LO_COMP_QUE_DISABLE = 0x03
