/**
 * @file ADS1115_Registers.h
 * @author Christoph Honal
 * @brief Defines the needed registers for the ADS1115
 * @version 0.0.1
 * @date 2021-07-15
 */

#ifndef ADS1115_REGISTERS_H
#define ADS1115_REGISTERS_H

#include <Arduino.h>

#define ADS1115_REG_POINTER_CONVERSION          0x00
#define ADS1115_REG_POINTER_CONFIG              0x01
#define ADS1115_REG_LOW_THRESHOLD               0x02
#define ADS1115_REG_HIGH_THRESHOLD              0x03

#define ADS1115_REG_CONFIG_HI_OS_MASK           0x80
#define ADS1115_REG_CONFIG_HI_OS_BEGIN          0x80
#define ADS1115_REG_CONFIG_HI_OS_BUSY           0x00
#define ADS1115_REG_CONFIG_HI_OS_IDLE           0x80

#define ADS1115_REG_CONFIG_HI_MUX_MASK          0x70
#define ADS1115_REG_CONFIG_HI_MUX_AIN_N_GND     0x40
#define ADS1115_REG_CONFIG_HI_MUX_AIN_P_MASK    0x30
#define ADS1115_REG_CONFIG_HI_MUX_AIN_P_OFFSET  4

#define ADS1115_REG_CONFIG_HI_PGA_MASK          0x0E
#define ADS1115_REG_CONFIG_HI_PGA_OFFSET        1

enum ADS1115_PGA : uint8_t
{
    ADS1115_PGA_6_144 = (0x00 << ADS1115_REG_CONFIG_HI_PGA_OFFSET),
    ADS1115_PGA_4_096 = (0x01 << ADS1115_REG_CONFIG_HI_PGA_OFFSET),
    ADS1115_PGA_2_048 = (0x02 << ADS1115_REG_CONFIG_HI_PGA_OFFSET),
    ADS1115_PGA_1_024 = (0x03 << ADS1115_REG_CONFIG_HI_PGA_OFFSET),
    ADS1115_PGA_0_512 = (0x04 << ADS1115_REG_CONFIG_HI_PGA_OFFSET),
    ADS1115_PGA_0_256 = (0x05 << ADS1115_REG_CONFIG_HI_PGA_OFFSET)
};


#define ADS1115_REG_CONFIG_HI_MODE_MASK         0x01
#define ADS1115_REG_CONFIG_HI_MODE_CONTINUOUS   0x00
#define ADS1115_REG_CONFIG_HI_MODE_SINGLESHOT   0x01

#define ADS1115_REG_CONFIG_LO_DR_MASK           0xE0
#define ADS1115_REG_CONFIG_LO_DR_OFFSET         5

enum ADS1115_DR : uint8_t
{
    ADS1115_DR_8 = (0x00 << ADS1115_REG_CONFIG_LO_DR_OFFSET),
    ADS1115_DR_16 = (0x01 << ADS1115_REG_CONFIG_LO_DR_OFFSET),
    ADS1115_DR_32 = (0x02 << ADS1115_REG_CONFIG_LO_DR_OFFSET),
    ADS1115_DR_64 = (0x03 << ADS1115_REG_CONFIG_LO_DR_OFFSET),
    ADS1115_DR_128 = (0x04 << ADS1115_REG_CONFIG_LO_DR_OFFSET),
    ADS1115_DR_250 = (0x05 << ADS1115_REG_CONFIG_LO_DR_OFFSET),
    ADS1115_DR_475 = (0x06 << ADS1115_REG_CONFIG_LO_DR_OFFSET),
    ADS1115_DR_860 = (0x07 << ADS1115_REG_CONFIG_LO_DR_OFFSET)
};


#define ADS1115_REG_CONFIG_LO_COMP_MODE_TRAD    0x00
#define ADS1115_REG_CONFIG_LO_COMP_MODE_WINDOW  0x10

#define ADS1115_REG_CONFIG_LO_COMP_POL_LOW      0x00
#define ADS1115_REG_CONFIG_LO_COMP_POL_HIGH     0x08

#define ADS1115_REG_CONFIG_LO_COMP_LAT_NON      0x00
#define ADS1115_REG_CONFIG_LO_COMP_LAT_LATCH    0x04

#define ADS1115_REG_CONFIG_LO_COMP_QUE_1        0x00
#define ADS1115_REG_CONFIG_LO_COMP_QUE_2        0x01
#define ADS1115_REG_CONFIG_LO_COMP_QUE_3        0x02
#define ADS1115_REG_CONFIG_LO_COMP_QUE_DISABLE  0x03

#endif