#include "VertexBufferBufFile.h"
#include "MMTFileUtils.h"
#include "MMTStringUtils.h"
#include <fstream>
#include "MMTFormatUtils.h"

VertexBufferBufFile::VertexBufferBufFile() {

}


VertexBufferBufFile::VertexBufferBufFile(std::wstring readVBBufFilePath, D3D11GameType d3d11GameType, std::vector<std::string> elementList) {

    int SplitStride = d3d11GameType.getElementListStride(elementList);
    std::vector<std::string> CategoryList = d3d11GameType.getCategoryList(elementList);
    std::unordered_map<std::string, int> CategoryStrideMap = d3d11GameType.getCategoryStrideMap(elementList);

    uint64_t VBFileSize = MMTFile_GetFileSize(readVBBufFilePath);
    uint64_t vbFileVertexNumber = VBFileSize / SplitStride;

    //ȡ
    std::vector<std::byte> buffer(VBFileSize);
    std::ifstream VBFile(MMTString_ToByteString(readVBBufFilePath), std::ios::binary);
    VBFile.read(reinterpret_cast<char*>(buffer.data()), VBFileSize);
    VBFile.close();

    //ͨͣȡȡȣﻹ
    std::vector<int> readLengths;
    for (const std::string& category : CategoryList) {
        readLengths.push_back(CategoryStrideMap[category]);
    }

    int offset = 0;
    while (offset < buffer.size()) {
        for (size_t i = 0; i < CategoryList.size(); ++i) {
            const std::string& category = CategoryList[i];
            // ָҪȡֽڳ
            int readLength = readLengths[i];
            std::vector<std::byte> categoryDataPatch;
            // Ԥ㹻ڴռ
            categoryDataPatch.reserve(readLength);
            // ʹstd::copyѭЧ
            std::copy(buffer.begin() + offset, buffer.begin() + offset + readLength, std::back_inserter(categoryDataPatch));

            // ҵtmp
            std::unordered_map<std::wstring, std::vector<std::byte>>& tmpVBCategoryDataMap = this->CategoryVBDataMap;

            // ҵtmpӦcategory
            std::vector<std::byte>& categoryData = tmpVBCategoryDataMap[MMTString_ToWideString(category)];


            // categoryDataPatchֱӲcategoryData
            categoryData.insert(categoryData.end(), categoryDataPatch.begin(), categoryDataPatch.end());

            offset += readLength;
        }

    }



};


void VertexBufferBufFile::SelfDivide(int MinNumber, int MaxNumber, int stride) {
    //MinNumber+1ԭǣ0ʼĻͻȡ0Ĳ
    //MaxNumberҪ+1ԭǣGetRangeģpython[i:i+1] ǲi+1ЧԲ+1Ǹ
    //+1ܱٶȡһ
    this->FinalVB0Buf = MMTFormat_GetRange_Byte(this->FinalVB0Buf, stride * (MinNumber), stride * (MaxNumber+1));
}


void VertexBufferBufFile::SaveToFile(std::wstring VB0OutputFilePath) {
    std::ofstream outputVBFile(VB0OutputFilePath, std::ofstream::binary);
    outputVBFile.write(reinterpret_cast<const char*>(this->FinalVB0Buf.data()), this->FinalVB0Buf.size());
    outputVBFile.close();
}

