#include "GlobalConfigs.h"
#include "MMTStringUtils.h"
#include "MMTFileUtils.h"
#include "ModFormatExtra.h"
#include "GlobalFunctions.h"
#include "IndexBufferBufFile.h"
#include "FmtData.h"

//This function is mainly designed to reverse merged compressed mod generated by outfit_compiler.py from LeoTorrez
//https://github.com/leotorrez/LeoTools/blob/main/outfit_compiler.py

void Reverse_Lv4_Merged_OutfitCompiler() {
    //ʼ
    LOG.Info("Start to reverse outfit_compiler.py format merged mod.");
    json reverseJsonObject = MMTJson_ReadJsonFromFile(G.Path_RunInputJson);
    std::wstring reverseFilePath = MMTString_ToWideString(reverseJsonObject["ReverseFilePath"]);
    std::wstring reverseFolderPath = MMTString_GetFolderPathFromFilePath(reverseFilePath) + L"-Reverse\\";
    std::filesystem::create_directories(reverseFolderPath);
    LOG.Info(L"ReverseFilePath: " + reverseFilePath);
    LOG.NewLine();

    //ʼͨini
    ModFormat_INI modFormatUnity(reverseFilePath);
    modFormatUnity.Parse_Self_Hash_SingleModDetect_Map();
    LOG.NewLine();

    for (const auto& singleModPair: modFormatUnity.Hash_SingleModDetect_Map) {
        std::wstring DrawIBHashValue = singleModPair.first;
        SingleModDetect singleModDetect = singleModPair.second;

        std::vector<M_Resource> ResourceVBList = singleModDetect.ResourceVBList;
        std::vector<M_TextureOverride> TextureOverrideIBList = singleModDetect.TextureOverrideIBList;
        LOG.Info(L"Mod Hash:" + DrawIBHashValue);
        LOG.Info("ResourceVBList Size: " + std::to_string(ResourceVBList.size()));
        LOG.Info("TextureOverrideIBList Size: " + std::to_string(TextureOverrideIBList.size()));
        LOG.NewLine();

        //ֱӿʼElementList,еD3D11
        int possibleModelNumber = 0;
        for (D3D11GameType d3d11GameType : G.CurrentD3d11GameTypeList) {
            //SingleModҪͼʶǰ͵ElementListƴӳһModƴӲĻValidModֵͻfalse
            ValidModDetect singleMod(d3d11GameType, ResourceVBList, TextureOverrideIBList);

            //ǺϷModֱٴռãɳҲûɶãͿ϶Ǵ
            if (!singleMod.ValidMod) {
                LOG.Info("Not a valid mod for this gametype: " + d3d11GameType.GameType + " so skip this.");
                LOG.NewLine();
                continue;
            }
            else {
                possibleModelNumber++;
            }

            //ƴӲõĶӦGameTypeĿ¼
            std::wstring OutputGameTypeFolderPath = reverseFolderPath + DrawIBHashValue+ L"_"+ MMTString_ToWideString(d3d11GameType.GameType) + L"\\";
            std::filesystem::create_directories(OutputGameTypeFolderPath);

            //ȻֱÿIBҪDrawIBListзָVBļ
            for (M_TextureOverride textureOverrideIB : TextureOverrideIBList) {
                for (M_DrawIndexed drawIndexed : textureOverrideIB.DrawIndexedList) {

                    //ƴļ·
                    std::wstring outputFileNamePrefix = drawIndexed.DrawNumber + L"_" + drawIndexed.DrawOffsetIndex;
                    std::wstring outputIBFilePath = OutputGameTypeFolderPath + outputFileNamePrefix + L".ib";
                    std::wstring outputFmtFilePath = OutputGameTypeFolderPath + outputFileNamePrefix + L".fmt";
                    std::wstring outputVBFilePath = OutputGameTypeFolderPath + outputFileNamePrefix + L".vb";
                    LOG.Info(L"Output IBFileName: " + outputIBFilePath);
                    LOG.Info(L"Output VBFileName: " + outputVBFilePath);
                    LOG.Info(L"Output FMTFileName: " + outputFmtFilePath);
                    LOG.NewLine();

                    //ȡǰDrawIndexedĻƶͻƫ
                    int drawNumber = std::stoi(drawIndexed.DrawNumber);
                    int drawOffset = std::stoi(drawIndexed.DrawOffsetIndex);

                    //ݵǰDrawIndexedĻƶͻƫƣIBļнȡDrawIndexedƵЩIBݣΪǰibBufFileIBݣ
                    IndexBufferBufFile ibBufFile = textureOverrideIB.IBBufFile;
                    ibBufFile.SelfDivide(drawOffset, drawOffset + drawNumber);
                    ibBufFile.SaveToFile_UINT32(outputIBFilePath, ibBufFile.MinNumber * -1);


                    //òFMTļ
                    FmtFileData fmtFile;
                    fmtFile.ElementNameList = singleMod.ElementList;
                    fmtFile.d3d11GameType = d3d11GameType;
                    fmtFile.Format = L"DXGI_FORMAT_R32_UINT";
                    fmtFile.OutputFmtFile(outputFmtFilePath);

                    //SizeΪ0򲻽ֱӵ˹ǲܴΪ0
                    if (singleMod.finalVB0Bytes.size() == 0) {
                        LOG.Error(L"Can't output because finalVB0Bytes size is 0,pleae check your mod ini.");
                    }

                    //Ҫע⣬MinNumberMaxNumber+1ԭVB0IndexNumberBytesڶȡʱǴ1ʼ
                    //ԵMinNumberСֵΪ0ʱӦһݣӦVB0IndexNumberBytes1Ҫ+1
                    uint32_t readNumberOffset = ibBufFile.MinNumber + 1;
                    //ÿVBļǵøݵǰIBBufferСֵȡһ֣ȷIBļжͬ
                    std::vector<byte> outputBytes;
                    for (readNumberOffset; readNumberOffset <= ibBufFile.MaxNumber + 1; readNumberOffset++) {
                        std::vector<byte> indexBytes = singleMod.VB0IndexNumberBytes[readNumberOffset];
                        outputBytes.insert(outputBytes.end(), indexBytes.begin(), indexBytes.end());
                    }

                    //սȡvb0ļ
                    std::ofstream outputVBFile(outputVBFilePath, std::ios::binary);
                    outputVBFile.write(reinterpret_cast<const char*>(outputBytes.data()), outputBytes.size());
                    outputVBFile.close();
                }
            }
        }

        //Ͷƥ䲻Ļ͵һʾ
        if (possibleModelNumber == 0) {
            LOG.Error(L"Can't match any D3D11Element type,please check if it's a valid mod,if it's valid then contact NicoMico for help or open a issue on github with your mod file in attachment.");
        }
    }
}