#include "GlobalConfigs.h"
#include "VertexBufferTxtFileDetect.h"
#include "IndexBufferTxtFile.h"
#include "FmtData.h"
#include "GlobalFunctions.h"
#include "FrameAnalysisData.h"
#include "ExtractUtil.h"
#include "IndexBufferBufFile.h"
#include "VertexBufferBufFile.h"


void ExtractFromBuffer_VS() {
    for (const auto& pair: G.DrawIB_ExtractConfig_Map) {
        std::wstring DrawIB = pair.first;
        ExtractConfig extractConfig = pair.second;
        //óʼ
        std::wstring OutputDrawIBFolder = G.OutputFolder + DrawIB + L"\\";
        std::filesystem::create_directories(OutputDrawIBFolder);

        if (extractConfig.GameType == L"Auto") {
            //TODO ֤ԶʶǷ
            extractConfig.GameType = UnityAutoDetectGameType(DrawIB);
        }

        D3D11GameType d3d11GameType = G.GameTypeName_D3d11GameType_Map[MMTString_ToByteString(extractConfig.GameType)];
        LOG.Info("GameType: " + d3d11GameType.GameType);

        extractConfig.WorkGameType = MMTString_ToByteString(extractConfig.GameType);

        //ͳеFrameAnalysisļ
        //ͨtxtļҵpointlisttrianglelist
        std::unordered_map<std::wstring, int> PointlistIndexVertexCountMap;
        std::unordered_map<std::wstring, int> TrianglelistIndexVertexCountMap;
        int TranglelistMaxVertexCount = 0;
        std::vector<std::wstring> TrianglelistIndices;
        FrameAnalysisData FAData(G.WorkFolder);
        std::vector<std::wstring> FrameAnalysisFileList = FAData.FrameAnalysisFileNameList;
        for (std::wstring FileName : FrameAnalysisFileList) {
            if (!FileName.ends_with(L".txt")) {
                continue;
            }
            std::wstring FilePath = G.WorkFolder + FileName;
            if (FileName.find(L"-vb0") != std::string::npos) {
                //LOG.Info(L"Try detect pointlist file: " + FileName);
                VertexBufferDetect vbDetect(FilePath);
                if (vbDetect.Topology == L"pointlist") {
                    LOG.Info(L"Processing pointlist: " + FilePath);
                    PointlistIndexVertexCountMap[vbDetect.Index] = vbDetect.fileBufferVertexCount;
                }
            }
            else if (FileName.find(L"-ib") != std::string::npos && FileName.find(DrawIB) != std::string::npos) {
                LOG.Info(L"Processing ib file: " + FileName);
                IndexBufferTxtFile indexBufferFileData = IndexBufferTxtFile(FilePath,false);
                //LOG.Info(L"IB File Topology: " + indexBufferFileData.Topology);
                if (indexBufferFileData.Topology == L"trianglelist") {
                    std::vector<std::wstring> tmpNameList = FAData.FindFrameAnalysisFileNameListWithCondition(indexBufferFileData.Index + L"-vb0", L".txt");
                    if (tmpNameList.size() == 0) {
                        LOG.Info(L"Special Type, Continue : Can't find vb0 for -ib:" + FileName);
                        continue;
                    }
                    std::wstring vb0FileName = tmpNameList[0];
                    LOG.Info(L"Processing trianglelist: " + vb0FileName);

                    VertexBufferDetect vertexBufferDetect(G.WorkFolder + vb0FileName);
                    //VertexBufferFileData vertexBufferFileData = VertexBufferFileData(wheelConfig.WorkFolder + vb0FileName, d3D11ElementAttribute, false, false);
                    //LOG.Info(L"VertexCount(Buffer) Str: " + std::to_wstring(vertexBufferDetect.fileBufferVertexCount));

                    int vertexCount = vertexBufferDetect.fileShowVertexCount;
                    LOG.Info(L"Show VertexCount: " + std::to_wstring(vertexCount));
                    if (vertexCount > TranglelistMaxVertexCount) {
                        //չʾVertexCountܳ
                        TranglelistMaxVertexCount = vertexCount;
                        LOG.Info(L"Set trianglelist max vertex count to: " + std::to_wstring(vertexCount));
                    }

                    TrianglelistIndices.push_back(vertexBufferDetect.Index);
                    TrianglelistIndexVertexCountMap[vertexBufferDetect.Index] = vertexCount;
                }
            }
        }

        LOG.NewLine();

        LOG.Info(L"PointlistIndexVertexNumberMap:");
        std::wstring PointlistExtractIndex = L"";
        for (const auto& pair : PointlistIndexVertexCountMap) {
            std::wstring index = pair.first;
            int vertexCount = pair.second;
            LOG.Info(L"Index: " + index + L", VertexCount: " + std::to_wstring(vertexCount));
            if (vertexCount == TranglelistMaxVertexCount) {
                PointlistExtractIndex = index;
            }
        }
        LOG.Info(L"max vertex count pointlist index: " + PointlistExtractIndex);
        LOG.NewLine();

        // trianglelistIndexVertexNumberMap
        LOG.Info(L"TrianglelistIndexVertexNumberMap:");
        for (const auto& pair : TrianglelistIndexVertexCountMap) {
            LOG.Info(L"Index:" + pair.first + L", VertexCount: " + std::to_wstring(pair.second));
        }
        LOG.NewLine();


        int MaxTrianglelistStride = 0;
        std::wstring TrianglelistExtractIndex = L"";
        std::wstring TexcoordExtractSlot = MMTString_ToWideString(d3d11GameType.ElementNameD3D11ElementMap["TEXCOORD"].ExtractSlot);
        LOG.Info(L"TexcoordExtractSlot: " + TexcoordExtractSlot);

        for (const auto& pair : TrianglelistIndexVertexCountMap) {
            std::wstring Index = pair.first;
            std::vector<std::wstring> filenames = FAData.FindFrameAnalysisFileNameListWithCondition( Index + L"-" + TexcoordExtractSlot, L".txt");
            if (filenames.size() == 0) {
                LOG.Info(Index + L"'s slot " + TexcoordExtractSlot + L" can't find. skip this.");
                continue;
            }
            std::wstring filename = filenames[0];
            VertexBufferDetect vbDetect(G.WorkFolder + filename);
            if (vbDetect.fileRealStride > MaxTrianglelistStride) {
                MaxTrianglelistStride = vbDetect.fileRealStride;
                //TODO жչʾĺBufferȲӣ±޷
                //ôȥɲأȡʱǴBufferȡչʾĶ޹
                //ҾӦBufferֵȲȡ
                if (vbDetect.fileBufferVertexCount == TranglelistMaxVertexCount) {
                    TrianglelistExtractIndex = Index;
                }
            }
        }
        LOG.Info(L"MaxTrianglelistStride: " + std::to_wstring(MaxTrianglelistStride));
        LOG.Info(L"TrianglelistExtractIndex: " + TrianglelistExtractIndex);
        if (TrianglelistExtractIndex == L"") {
            LOG.Error("Can't find TrianglelistExtract Index!");
        }

        std::string VertexLimitVB = MMTString_ToByteString(FAData.FindFrameAnalysisFileNameListWithCondition(TrianglelistExtractIndex + L"-vb0", L".txt")[0].substr(11, 8));
        extractConfig.VertexLimitVB = VertexLimitVB;
        LOG.NewLine();

        //CategoryֱӴӶӦȡӦBufferļ
        LOG.Info("Extract from Buffer file: ");
        std::vector<std::unordered_map<int, std::vector<std::byte>>> categoryFileBufList;
        std::vector<std::string> ElementList;
        std::unordered_map<std::string, std::string> CategoryHashMap;
        for (const auto& pair : d3d11GameType.CategorySlotMap) {
            std::string Category = pair.first;
            std::string CategorySlot = pair.second;
            std::string CategoryTopology = d3d11GameType.CategoryTopologyMap[Category];
            std::wstring ExtractIndex = PointlistExtractIndex;

            if (CategoryTopology == "trianglelist") {
                ExtractIndex = TrianglelistExtractIndex;
            }

            //ȡӦλRealStride
            std::vector<std::wstring> filenames = FAData.FindFrameAnalysisFileNameListWithCondition( ExtractIndex + L"-" + MMTString_ToWideString(CategorySlot), L".txt");
            if (filenames.size() == 0) {
                LOG.Error(ExtractIndex + L"'s extract slot " + TexcoordExtractSlot + L" can't find.");
            }
            std::wstring filename = filenames[0];
            CategoryHashMap[Category] = MMTString_ToByteString(filename.substr(11, 8));
            VertexBufferDetect vbDetect(G.WorkFolder + filename);

            //ʹfileRealStrideʱ޷֤txtʵݣԵȡʧ
            // TODO ҵӼݵİ취
            //int stride = vbDetect.fileRealStride;

            int stride = vbDetect.fileShowStride;

            //жǷҪĬϵBlendweights
            bool patchBlendWeights = false;
            std::vector<std::string> addElementList = vbDetect.realElementNameList;
            if (addElementList.size() == 1 && "blendindices" == boost::algorithm::to_lower_copy(addElementList[0])) {
                addElementList = {"blendweights","blendindices"};
                patchBlendWeights = true;
                LOG.Info("Detect only BLENDINDICES, auto patch BLENDWEIGHTS 1,0,0,0");
            }
            ElementList.insert(ElementList.end(), addElementList.begin(), addElementList.end());


            //ȡ
            std::wstring bufFileName = filename.substr(0, filename.length() - 4) + L".buf";
            int bufFileSize = MMTFile_GetFileSize(G.WorkFolder + bufFileName);
            int vertexNumber = bufFileSize / stride;

            std::unordered_map<int, std::vector<std::byte>> fileBuf = MMTFile_ReadBufMapFromFile(G.WorkFolder + bufFileName, vertexNumber);
            LOG.Info(L"Extract from: " + bufFileName + L" VertexNumber:" + std::to_wstring(vertexNumber));
            LOG.Info("Category:" + Category + " CategorySlot:" + CategorySlot + " CategoryTopology:" + CategoryTopology);

            //ԶȫBLENDWEIGHT 1,0,0,0  Ŀǰ֧R32G32B32A32_FLOATͲȫĿǰҲֻһ
            std::unordered_map<int, std::vector<std::byte>> patchedFileBuf;
            if (Category == "Blend" && patchBlendWeights) {
                
                for (const auto& pair: fileBuf) {
                    std::vector<std::byte> patchValue = {
                        std::byte{0x00}, std::byte{0x00}, std::byte{0x80}, std::byte{0x3f} , 
                        std::byte{0x00}, std::byte{0x00}, std::byte{0x00} , std::byte{0x00}, 
                        std::byte{0x00}, std::byte{0x00}, std::byte{0x00} , std::byte{0x00}, 
                        std::byte{0x00}, std::byte{0x00}, std::byte{0x00} , std::byte{0x00} };
                    int num = pair.first;
                    std::vector<std::byte> bufValue = pair.second;
                    patchValue.insert(patchValue.end(), bufValue.begin(), bufValue.end());
                    patchedFileBuf[num] = patchValue;
                }
                categoryFileBufList.push_back(patchedFileBuf);

            }
            else {
                categoryFileBufList.push_back(fileBuf);

            }


        }
        extractConfig.CategoryHashMap = CategoryHashMap;
        LOG.NewLine();
        //Bufferļϳһ
        std::vector<std::byte> finalVB0Buf;
        std::unordered_map<int, std::vector<std::byte>> tmpFileBuf;
        for (int i = 0; i < TranglelistMaxVertexCount; i++) {
            for (std::unordered_map<int, std::vector<std::byte>>& tmpFileBuf : categoryFileBufList) {
                finalVB0Buf.insert(finalVB0Buf.end(), tmpFileBuf[i].begin(), tmpFileBuf[i].end());
            }
        }

        LOG.Info("ElementList:");
        std::vector<std::string> TmpElementList;
        for (std::string ElementName : ElementList) {
            LOG.Info("ElementName: " + ElementName);
            TmpElementList.push_back(boost::algorithm::to_upper_copy(ElementName));
        }
        extractConfig.TmpElementList = TmpElementList;

        

        //FMTļ
        //TODO FMT
        FmtFileData fmtFileData;
        fmtFileData.ElementNameList = ElementList;
        fmtFileData.d3d11GameType = d3d11GameType;
        fmtFileData.Format = L"DXGI_FORMAT_R32_UINT";
        fmtFileData.Stride = d3d11GameType.getElementListStride(fmtFileData.ElementNameList);
        LOG.NewLine();


        //IBBufferļ
        LOG.Info(L"Start to read trianglelist IB file info");
        // ȷڲͬtrianglelist indicesibļfirst indexȷϡ
        std::map<int, std::wstring> firstIndexFileNameMap;
        for (std::wstring index : TrianglelistIndices) {
            std::vector<std::wstring> trianglelistIBFileNameList = FAData.FindFrameAnalysisFileNameListWithCondition(index + L"-ib", L".txt");
            std::wstring trianglelistIBFileName;
            if (trianglelistIBFileNameList.empty()) {
                continue;
            }
            trianglelistIBFileName = trianglelistIBFileNameList[0];
            //LOG.Info(L"trianglelistIBFileName: " + trianglelistIBFileName);
            IndexBufferTxtFile indexBufferFileData = IndexBufferTxtFile(G.WorkFolder + trianglelistIBFileName,false);
            std::wstring firstIndex = indexBufferFileData.FirstIndex;
            //LOG.Info(L"firstIndex: " + firstIndex);
            firstIndexFileNameMap[std::stoi(firstIndex)] = trianglelistIBFileName;
        }
        LOG.Info(L"Output and see the final first index and trianglelist file:");
        std::vector<std::string> firstIndexList;
        for (auto it = firstIndexFileNameMap.begin(); it != firstIndexFileNameMap.end(); ++it) {
            LOG.Info(L"firstIndex: " + std::to_wstring(it->first) + L", trianglelistIBFileName: " + it->second);
            firstIndexList.push_back(std::to_string(it->first));
        }

        LOG.NewLine();

        //ھͿˣÿMatchFirstIndexɡ
        int outputCount = 1;
        std::vector<std::string> MatchFirstIndexList;
        std::vector<std::string> PartNameList;
        for (const auto& pair : firstIndexFileNameMap) {
            std::wstring IBReadFileName = pair.second;
            std::wstring IBReadBufferFileName = IBReadFileName.substr(0, IBReadFileName.length() - 4) + L".buf";
            std::wstring IBReadBufferFilePath = G.WorkFolder + IBReadBufferFileName;

            std::wstring IBReadFilePath = G.WorkFolder + IBReadFileName;
            IndexBufferTxtFile ibFileData(IBReadFilePath,false);

            MatchFirstIndexList.push_back(MMTString_ToByteString(ibFileData.FirstIndex));
            PartNameList.push_back(std::to_string(outputCount));
            
            //ֱfmt,ib,vb
            std::wstring OutputIBBufFilePath = OutputDrawIBFolder + DrawIB + L"-" + std::to_wstring(outputCount) + L".ib";
            std::wstring OutputVBBufFilePath = OutputDrawIBFolder + DrawIB + L"-" + std::to_wstring(outputCount) + L".vb";
            std::wstring OutputFmtFilePath = OutputDrawIBFolder + DrawIB + L"-" + std::to_wstring(outputCount) + L".fmt";

            //FMTļ
            fmtFileData.OutputFmtFile(OutputFmtFilePath);

            //IBļ
            IndexBufferBufFile ibBufFile(IBReadBufferFilePath,ibFileData.Format);
            ibBufFile.SelfDivide(std::stoi(ibFileData.FirstIndex), std::stoi(ibFileData.IndexCount));
            ibBufFile.SaveToFile_UINT32(OutputIBBufFilePath, -1 * ibBufFile.MinNumber);
            
            //VBļ
            VertexBufferBufFile vbBufFile;
            vbBufFile.FinalVB0Buf = finalVB0Buf;
            vbBufFile.SelfDivide(ibBufFile.MinNumber,ibBufFile.MaxNumber,fmtFileData.Stride);
            vbBufFile.SaveToFile(OutputVBBufFilePath);

            //PartName
            outputCount++;
        }

        extractConfig.MatchFirstIndexList = MatchFirstIndexList;
        extractConfig.PartNameList = PartNameList;
        extractConfig.saveTmpConfigs(OutputDrawIBFolder);
        //tmp.json
        
        ExtractUtil_MoveAllTextures(G.WorkFolder,DrawIB,OutputDrawIBFolder);
    }
}