---
layout: document
title: "Select"
date: 2017-03-15 18:31:47
categories: Data
---

# The Select Class

The `Query` class is quick query builder to simplify the process of writing
queries.

## Select Queries

A basic select query.

```php?start_inline=1
$query = Query::select('customers');
```

This generates:

```sql
SELECT * FROM customers;
```

The `Query::select($table, array $columns, IConnection $connection, $order, $limit)` 
method also supports quick definitions of columns, db connection, order and limits.

### Specify Columns

To specify the columns to select, include the second method parameter as
an array of the column names.

```php?start_inline=1
$query = Query::select('customers', ['name','email']);
```

**Result:**

```sql
SELECT name, email FROM customers;
```

You can also specify column aliases by utilizing associative array keys:

```php?start_inline=1
$query = Query::select('customers', ['FirstName'=>'given_name','email']);
```

**Result:**

```sql
SELECT given_name AS FirstName, email FROM customers;
```

## Where Clauses

### Where Equal

The `whereEqual(string $column, mixed $value)` method allows you to specify a column and a value to select on.

```php?start_inline=1
$query = Query::select('customers')->whereEqual('last_name','Smith');
```

**Result:**

```sql
SELECT name, email FROM customers WHERE last_name = 'Smith';
```

### Where In

The `whereIn(string $column, array|Query $value)` method allows you to pass a column name and then an array
of values to filter by. You can also specify a subquery to pass to the `IN` clause.

```php?start_inline=1
$query = Query::select('customers')->whereIn('column',['array_value1','array_value2']);
```

```php?start_inline=1
$selectQuery = Query::select('referrals');
$query = Query::select('customers')->whereIn('referral_id',$selectQuery);
```

## Order By and Limits

The fourth and fifth parameters allow for specification of order by and
query limits.

```php?start_inline=1
$conn = Connection::getNamedConnection('myconn');
$query = Query::select('customers', ['name','email','city'], $conn, ['name', 'city'], 20);
```

**MySQL Connection**

```sql
SELECT name, email, city FROM customers ORDER BY name, city LIMIT 20;
```

**SQL Server Connection**

```sql
SELECT TOP 20 name, email, city FROM customers ORDER BY name, city;
```