---
layout: document
title: "Query"
date: 2017-03-15 18:31:47
categories: Data
---

## The Query Class

The `Query` class is quick query builder to simplify the process of writing
queries.

### Select Queries

A basic `SELECT` query.

```php?start_inline=1
$query = Query::select('customers', ['name','email']);
```

This generates:

```sql
SELECT name, email FROM customers;
```

The `Query::select()` method also supports quick definitions of columns,
db connection, order and limits.

For more examples see the [Select](/docs/Select) page of the documentation.

## Insert Queries

A basic `INSERT` query.

```php?start_inline=1
$query = Query::insert('customers', ['first_name' => 'John', 'last_name' => 'Smith']);
```

The above method returns an instance of the `Insert` object.

#### Result

```sql
INSERT INTO customers (`first_name`, `last_name`) VALUES ('John', 'Smith');
```

The `Query::insert($table, array $data, IConnection $connection, $priority)` 
method also supports specifying a connection to act upon and a priority for the insert.

For more examples see the [Insert](/docs/Insert) page of the documentation.

## Update Queries

## Delete Queries

## Stored Procedures

You can use the `Query` object to also quickly call stored procedures using the static 
`procedure($name, array $parameters)` method.

```php
$procedure = Query::procedure('MyProcedure', ['Param Value 1','Param Value 2']);
```

Depending on the procedure result, this method can return either a boolean success or failure
or a `PDOStatement` object.
