---
layout: document
title: "Insert"
date: 2017-03-15 18:41:47
categories: Data
---

# The Insert Class

The `Query` class is quick query builder to simplify the process of writing
queries.

## Basic Queries

A basic `INSERT` query.

```php?start_inline=1
//From the Query Base object.
$query = Query::insert('customers', ['first_name' => 'John', 'last_name' => 'Smith']);

//From the Insert object
$query = Insert::create()
    ->setTable('customers')
    ->setData([
        'first_name' => 'John', 
        'last_name' => 'Smith'
    ]);
```

Both of the above method return instances of the `Insert` object.

#### Result

```sql
INSERT INTO customers (`first_name`, `last_name`) VALUES ('John', 'Smith');
```

The `Query::insert($table, array $data, IConnection $connection, $priority)` 
method also supports specifying a connection to act upon and a priority for the insert.

## Specify Data

The data array needs to be an associative array of column names and their values.
These values can be set using the `Query` object constructor or by using the `setData(array $data)`
and `addData(array $data)` methods.

```php?start_inline=1
//Start with this object
$query = Query::insert('customers', ['name' => 'John Smith', 'email' => 'john.smith@gmail.com']);

//Or this object
$query = Insert::create()
    ->setData([
            'name' => 'John Smith', 
            'email' => 'Smith'
        ]);
        
//Append data to the query
$query->addData([
    'phone' =>  '(555) 555-5555'
]);
```

**Result:**

```sql
INSERT INTO customers (name, email, phone) VALUES ('John Smith', 'john.smith@gmail.com', '(555) 555-5555');
```

## Adding & Overriding Data

Two methods exist to add and overwrite data that is currently specified in the `Insert` object: `addData(array $data)`
and `addDataColumn(string $column, mixed $data)`. The main difference between these two methods is that the
latter will only add/edit a single column.

```php?start_inline=1
//Add/Edit multiple values
$query->addData([
    'name' => 'Larry Miller'
    'email' => 'larry.miller@hotmail.com'
])

//Add/Edit a single column
$query->addDataColumn('name', 'Larry Miller');
```

## Inserting with a `SELECT` statement

You can also supply a `Select` object as the data for your `Insert` object. This will allow you to 
select data from one table to insert into another.

```php?start_inline=1
//Create a select statement
$select = Query::select('leads', ['name','email']);

//Supply the insert with the select statement
$insert = Query::insert('customers', $select);
```

#### Result

```sql
INSERT INTO customers
SELECT name, email FROM leads;
```