# Contributing

Thank you for your interest in contributing to Stage Whisper!

There are many ways in which you can contribute to Stage Whisper, whether by
contributing a feature or by engaging in discussions; we value contributions in
all shapes and sizes! The following sections may give some ideas for how you can
get involved.

## Asking and Answering Questions

Have a question? This repository is a great place to ask questions about using
Stage Whisper. Your question will serve as resource to others
searching for help. Please check out the [forums](https://github.com/Stage-Whisper/Stage-Whisper/discussions)
for general questions and feature requests or [file an issue](https://github.com/Stage-Whisper/Stage-Whisper/issues/new/choose)
if you think you've found a bug.

## Reporting and Commenting on Issues

Have you identified an issue or modification that would benefit the community?
We want to hear about it! If you have feedback about the project or documentation,
please let us know by [starting a thread](https://github.com/Stage-Whisper/Stage-Whisper/discussions/new)!

As for any active effort, there are always many ways in which we hope to evolve
and improve Stage Whisper. We encourage you to look at the list of all
currently [open issues](https://github.com/Stage-Whisper/Stage-Whisper/issues) to share
your ideas and expertise. If you are new to open source, we recommend checking
out the [good first issues and contributing guide](https://github.com/Stage-Whisper/Stage-Whisper/contribute).

## Contributing Code

If you are interested in helping fix issues you or someone else encountered,
please make sure that the corresponding issue has been filed on the repository.
Check that nobody is currently working on it and that it has indeed been marked
as bug. If that's the case, indicate on the issue that you are working on it,
and link to the corresponding GitHub page where the fix is being developed. If
someone is already working on a fix, ask if you can help or see what other
things can be done. If an issue is labeled as feature, please follow the
guidelines related to contributing features. If an issue has not been labeled
yet, please indicate that you would like to work on it and be patient - we are a
small team and are doing our best to be quick with responding to your inquiry!

If you are interested in contributing a new feature, please first check if a
similar functionality has already been requested. If so, consider contributing
to the discussion around it rather than filing a separate issue. If no open or
closed issue with such a request already exists, [please file one](https://github.com/Stage-Whisper/Stage-Whisper/discussions/new?category=ideas).
We will respond to feature requests and follow up with a discussion around its
feasibility, how one might go about implementing it, and whether that is
something that makes sense to add. There are several reasons why we might not be
able to eventually merge even a great feature. Perhaps
most commonly, a contribution is a really good one, but this isn't the right
place to develop it or we simply aren't ready to maintain and develop it
further. It can be difficult to do everything, so we are careful to prioritize
the quality and reliability across the code base over new features. In such
cases, we strongly encourage you to pursue your passion project in your own
fork, and welcome sharing and discussing your thoughts and progress on the
corresponding issue regardless. We'll also ask for changes to a pull request if
it requires more documentation or unit tests to better make use of it.

If you are looking for a place to get started with contributing code, search for
example for the
[good-first-issue](https://github.com/Stage-Whisper/Stage-Whisper/labels/good%20first%20issue)
or [help-wanted](https://github.com/Stage-Whisper/Stage-Whisper/labels/help%20wanted)
labels. Also, look for issues that have already been discussed in more detail,
and check if you can help someone who has already started working on it.

And last but not least:

## 💖 Thank You! 💖

Your contributions to open source, large or small, make great projects like this
possible. Thank you for taking the time to contribute.
