###############################################################
####  Description of SonarQube's schema in H2 SQL syntax   ####
####                                                       ####
####   This file is autogenerated and stored in SCM to     ####
####   conveniently read the SonarQube's schema at any     ####
####   point in time.                                      ####
####                                                       ####
####          DO NOT MODIFY THIS FILE DIRECTLY             ####
####    use gradle task :server:sonar-db-dao:dumpSchema    ####
###############################################################

CREATE TABLE "SCHEMA_MIGRATIONS"(
    "VERSION" CHARACTER VARYING(255) NOT NULL
);

CREATE TABLE "ACTIVE_RULE_PARAMETERS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "VALUE" CHARACTER VARYING(4000),
    "RULES_PARAMETER_KEY" CHARACTER VARYING(128),
    "ACTIVE_RULE_UUID" CHARACTER VARYING(40) NOT NULL,
    "RULES_PARAMETER_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "ACTIVE_RULE_PARAMETERS" ADD CONSTRAINT "PK_ACTIVE_RULE_PARAMETERS" PRIMARY KEY("UUID");
CREATE INDEX "ARP_ACTIVE_RULE_UUID" ON "ACTIVE_RULE_PARAMETERS"("ACTIVE_RULE_UUID" NULLS FIRST);

CREATE TABLE "ACTIVE_RULES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "FAILURE_LEVEL" INTEGER NOT NULL,
    "INHERITANCE" CHARACTER VARYING(10),
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT,
    "PROFILE_UUID" CHARACTER VARYING(40) NOT NULL,
    "RULE_UUID" CHARACTER VARYING(40) NOT NULL,
    "PRIORITIZED_RULE" BOOLEAN,
    "IMPACTS" CHARACTER VARYING(500)
);
ALTER TABLE "ACTIVE_RULES" ADD CONSTRAINT "PK_ACTIVE_RULES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROFILE_RULE_UUIDS" ON "ACTIVE_RULES"("PROFILE_UUID" NULLS FIRST, "RULE_UUID" NULLS FIRST);

CREATE TABLE "ALM_PATS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PAT" CHARACTER VARYING(2000) NOT NULL,
    "USER_UUID" CHARACTER VARYING(256) NOT NULL,
    "ALM_SETTING_UUID" CHARACTER VARYING(40) NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "ALM_PATS" ADD CONSTRAINT "PK_ALM_PATS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_ALM_PATS" ON "ALM_PATS"("USER_UUID" NULLS FIRST, "ALM_SETTING_UUID" NULLS FIRST);

CREATE TABLE "ALM_SETTINGS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ALM_ID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(200) NOT NULL,
    "URL" CHARACTER VARYING(2000),
    "APP_ID" CHARACTER VARYING(80),
    "PRIVATE_KEY" CHARACTER VARYING(2500),
    "PAT" CHARACTER VARYING(2000),
    "UPDATED_AT" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "CLIENT_ID" CHARACTER VARYING(80),
    "CLIENT_SECRET" CHARACTER VARYING(160),
    "WEBHOOK_SECRET" CHARACTER VARYING(160)
);
ALTER TABLE "ALM_SETTINGS" ADD CONSTRAINT "PK_ALM_SETTINGS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_ALM_SETTINGS" ON "ALM_SETTINGS"("KEE" NULLS FIRST);

CREATE TABLE "ANALYSIS_PROPERTIES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ANALYSIS_UUID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(512) NOT NULL,
    "TEXT_VALUE" CHARACTER VARYING(4000),
    "CLOB_VALUE" CHARACTER LARGE OBJECT,
    "IS_EMPTY" BOOLEAN NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "ANALYSIS_PROPERTIES" ADD CONSTRAINT "PK_ANALYSIS_PROPERTIES" PRIMARY KEY("UUID");
CREATE INDEX "ANALYSIS_PROPERTIES_ANALYSIS" ON "ANALYSIS_PROPERTIES"("ANALYSIS_UUID" NULLS FIRST);

CREATE TABLE "ANTICIPATED_TRANSITIONS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL,
    "TRANSITION" CHARACTER VARYING(20) NOT NULL,
    "TRANSITION_COMMENT" CHARACTER VARYING(4000),
    "LINE" INTEGER,
    "MESSAGE" CHARACTER VARYING(4000),
    "LINE_HASH" CHARACTER VARYING(255),
    "RULE_KEY" CHARACTER VARYING(200) NOT NULL,
    "FILE_PATH" CHARACTER VARYING(1500) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "ANTICIPATED_TRANSITIONS" ADD CONSTRAINT "PK_ANTICIPATED_TRANSITIONS" PRIMARY KEY("UUID");

CREATE TABLE "APP_BRANCH_PROJECT_BRANCH"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "APPLICATION_UUID" CHARACTER VARYING(40) NOT NULL,
    "APPLICATION_BRANCH_UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_BRANCH_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "APP_BRANCH_PROJECT_BRANCH" ADD CONSTRAINT "PK_APP_BRANCH_PROJECT_BRANCH" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_APP_BRANCH_PROJ" ON "APP_BRANCH_PROJECT_BRANCH"("APPLICATION_BRANCH_UUID" NULLS FIRST, "PROJECT_BRANCH_UUID" NULLS FIRST);
CREATE INDEX "IDX_ABPB_APP_UUID" ON "APP_BRANCH_PROJECT_BRANCH"("APPLICATION_UUID" NULLS FIRST);
CREATE INDEX "IDX_ABPB_APP_BRANCH_UUID" ON "APP_BRANCH_PROJECT_BRANCH"("APPLICATION_BRANCH_UUID" NULLS FIRST);
CREATE INDEX "IDX_ABPB_PROJ_UUID" ON "APP_BRANCH_PROJECT_BRANCH"("PROJECT_UUID" NULLS FIRST);
CREATE INDEX "IDX_ABPB_PROJ_BRANCH_UUID" ON "APP_BRANCH_PROJECT_BRANCH"("PROJECT_BRANCH_UUID" NULLS FIRST);

CREATE TABLE "APP_PROJECTS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "APPLICATION_UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "APP_PROJECTS" ADD CONSTRAINT "PK_APP_PROJECTS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_APP_PROJECTS" ON "APP_PROJECTS"("APPLICATION_UUID" NULLS FIRST, "PROJECT_UUID" NULLS FIRST);
CREATE INDEX "IDX_APP_PROJ_APPLICATION_UUID" ON "APP_PROJECTS"("APPLICATION_UUID" NULLS FIRST);
CREATE INDEX "IDX_APP_PROJ_PROJECT_UUID" ON "APP_PROJECTS"("PROJECT_UUID" NULLS FIRST);

CREATE TABLE "AUDITS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL,
    "USER_LOGIN" CHARACTER VARYING(255) NOT NULL,
    "CATEGORY" CHARACTER VARYING(25) NOT NULL,
    "OPERATION" CHARACTER VARYING(50) NOT NULL,
    "NEW_VALUE" CHARACTER VARYING(4000),
    "CREATED_AT" BIGINT NOT NULL,
    "USER_TRIGGERED" BOOLEAN DEFAULT TRUE NOT NULL
);
ALTER TABLE "AUDITS" ADD CONSTRAINT "PK_AUDITS" PRIMARY KEY("UUID");
CREATE INDEX "AUDITS_CREATED_AT" ON "AUDITS"("CREATED_AT" NULLS FIRST);

CREATE TABLE "CE_ACTIVITY"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "TASK_TYPE" CHARACTER VARYING(40) NOT NULL,
    "ENTITY_UUID" CHARACTER VARYING(40),
    "COMPONENT_UUID" CHARACTER VARYING(40),
    "STATUS" CHARACTER VARYING(15) NOT NULL,
    "MAIN_IS_LAST" BOOLEAN NOT NULL,
    "MAIN_IS_LAST_KEY" CHARACTER VARYING(80) NOT NULL,
    "IS_LAST" BOOLEAN NOT NULL,
    "IS_LAST_KEY" CHARACTER VARYING(80) NOT NULL,
    "SUBMITTER_UUID" CHARACTER VARYING(255),
    "SUBMITTED_AT" BIGINT NOT NULL,
    "STARTED_AT" BIGINT,
    "EXECUTED_AT" BIGINT,
    "EXECUTION_COUNT" INTEGER NOT NULL,
    "EXECUTION_TIME_MS" BIGINT,
    "ANALYSIS_UUID" CHARACTER VARYING(50),
    "ERROR_MESSAGE" CHARACTER VARYING(1000),
    "ERROR_STACKTRACE" CHARACTER LARGE OBJECT,
    "ERROR_TYPE" CHARACTER VARYING(20),
    "WORKER_UUID" CHARACTER VARYING(40),
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL,
    "NODE_NAME" CHARACTER VARYING(100)
);
ALTER TABLE "CE_ACTIVITY" ADD CONSTRAINT "PK_CE_ACTIVITY" PRIMARY KEY("UUID");
CREATE INDEX "CE_ACTIVITY_COMPONENT" ON "CE_ACTIVITY"("COMPONENT_UUID" NULLS FIRST);
CREATE INDEX "CE_ACTIVITY_ISLAST" ON "CE_ACTIVITY"("IS_LAST" NULLS FIRST, "STATUS" NULLS FIRST);
CREATE INDEX "CE_ACTIVITY_ISLAST_KEY" ON "CE_ACTIVITY"("IS_LAST_KEY" NULLS FIRST);
CREATE INDEX "CE_ACTIVITY_MAIN_ISLAST" ON "CE_ACTIVITY"("MAIN_IS_LAST" NULLS FIRST, "STATUS" NULLS FIRST);
CREATE INDEX "CE_ACTIVITY_MAIN_ISLAST_KEY" ON "CE_ACTIVITY"("MAIN_IS_LAST_KEY" NULLS FIRST);
CREATE INDEX "CE_ACTIVITY_ENTITY_UUID" ON "CE_ACTIVITY"("ENTITY_UUID" NULLS FIRST);

CREATE TABLE "CE_QUEUE"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "TASK_TYPE" CHARACTER VARYING(40) NOT NULL,
    "ENTITY_UUID" CHARACTER VARYING(40),
    "COMPONENT_UUID" CHARACTER VARYING(40),
    "STATUS" CHARACTER VARYING(15),
    "SUBMITTER_UUID" CHARACTER VARYING(255),
    "STARTED_AT" BIGINT,
    "WORKER_UUID" CHARACTER VARYING(40),
    "EXECUTION_COUNT" INTEGER NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "CE_QUEUE" ADD CONSTRAINT "PK_CE_QUEUE" PRIMARY KEY("UUID");
CREATE INDEX "CE_QUEUE_COMPONENT" ON "CE_QUEUE"("COMPONENT_UUID" NULLS FIRST);
CREATE INDEX "CE_QUEUE_ENTITY_UUID" ON "CE_QUEUE"("ENTITY_UUID" NULLS FIRST);

CREATE TABLE "CE_SCANNER_CONTEXT"(
    "TASK_UUID" CHARACTER VARYING(40) NOT NULL,
    "CONTEXT_DATA" BINARY LARGE OBJECT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "CE_SCANNER_CONTEXT" ADD CONSTRAINT "PK_CE_SCANNER_CONTEXT" PRIMARY KEY("TASK_UUID");

CREATE TABLE "CE_TASK_CHARACTERISTICS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "TASK_UUID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(512) NOT NULL,
    "TEXT_VALUE" CHARACTER VARYING(512)
);
ALTER TABLE "CE_TASK_CHARACTERISTICS" ADD CONSTRAINT "PK_CE_TASK_CHARACTERISTICS" PRIMARY KEY("UUID");
CREATE INDEX "CE_CHARACTERISTICS_TASK_UUID" ON "CE_TASK_CHARACTERISTICS"("TASK_UUID" NULLS FIRST);

CREATE TABLE "CE_TASK_INPUT"(
    "TASK_UUID" CHARACTER VARYING(40) NOT NULL,
    "INPUT_DATA" BINARY LARGE OBJECT,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "CE_TASK_INPUT" ADD CONSTRAINT "PK_CE_TASK_INPUT" PRIMARY KEY("TASK_UUID");

CREATE TABLE "CE_TASK_MESSAGE"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "TASK_UUID" CHARACTER VARYING(40) NOT NULL,
    "MESSAGE" CHARACTER VARYING(4000) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "MESSAGE_TYPE" CHARACTER VARYING(255) NOT NULL
);
ALTER TABLE "CE_TASK_MESSAGE" ADD CONSTRAINT "PK_CE_TASK_MESSAGE" PRIMARY KEY("UUID");
CREATE INDEX "CE_TASK_MESSAGE_TASK" ON "CE_TASK_MESSAGE"("TASK_UUID" NULLS FIRST);
CREATE INDEX "CTM_MESSAGE_TYPE" ON "CE_TASK_MESSAGE"("MESSAGE_TYPE" NULLS FIRST);

CREATE TABLE "COMPONENTS"(
    "UUID" CHARACTER VARYING(50) NOT NULL,
    "KEE" CHARACTER VARYING(1000),
    "DEPRECATED_KEE" CHARACTER VARYING(400),
    "NAME" CHARACTER VARYING(2000),
    "LONG_NAME" CHARACTER VARYING(2000),
    "DESCRIPTION" CHARACTER VARYING(2000),
    "ENABLED" BOOLEAN DEFAULT TRUE NOT NULL,
    "SCOPE" CHARACTER VARYING(3),
    "QUALIFIER" CHARACTER VARYING(10),
    "PRIVATE" BOOLEAN NOT NULL,
    "LANGUAGE" CHARACTER VARYING(20),
    "COPY_COMPONENT_UUID" CHARACTER VARYING(50),
    "PATH" CHARACTER VARYING(2000),
    "UUID_PATH" CHARACTER VARYING(1500) NOT NULL,
    "BRANCH_UUID" CHARACTER VARYING(50) NOT NULL,
    "B_CHANGED" BOOLEAN,
    "B_NAME" CHARACTER VARYING(500),
    "B_LONG_NAME" CHARACTER VARYING(500),
    "B_DESCRIPTION" CHARACTER VARYING(2000),
    "B_ENABLED" BOOLEAN,
    "B_QUALIFIER" CHARACTER VARYING(10),
    "B_LANGUAGE" CHARACTER VARYING(20),
    "B_COPY_COMPONENT_UUID" CHARACTER VARYING(50),
    "B_PATH" CHARACTER VARYING(2000),
    "B_UUID_PATH" CHARACTER VARYING(1500),
    "CREATED_AT" TIMESTAMP
);
CREATE INDEX "PROJECTS_QUALIFIER" ON "COMPONENTS"("QUALIFIER" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "COMPONENTS_UUID" ON "COMPONENTS"("UUID" NULLS FIRST);
CREATE INDEX "COMPONENTS_BRANCH_UUID" ON "COMPONENTS"("BRANCH_UUID" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "COMPONENTS_KEE_BRANCH_UUID" ON "COMPONENTS"("KEE" NULLS FIRST, "BRANCH_UUID" NULLS FIRST);

CREATE TABLE "CVE_CWE"(
    "CVE_UUID" CHARACTER VARYING(40) NOT NULL,
    "CWE" CHARACTER VARYING(50) NOT NULL
);
ALTER TABLE "CVE_CWE" ADD CONSTRAINT "PK_CVE_CWE" PRIMARY KEY("CVE_UUID", "CWE");

CREATE TABLE "CVES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ID" CHARACTER VARYING(50) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(4000) NOT NULL,
    "CVSS_SCORE" DOUBLE PRECISION,
    "EPSS_SCORE" DOUBLE PRECISION,
    "EPSS_PERCENTILE" DOUBLE PRECISION,
    "PUBLISHED_AT" BIGINT,
    "LAST_MODIFIED_AT" BIGINT,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "CVES" ADD CONSTRAINT "PK_CVES" PRIMARY KEY("UUID");

CREATE TABLE "DEFAULT_QPROFILES"(
    "LANGUAGE" CHARACTER VARYING(20) NOT NULL,
    "QPROFILE_UUID" CHARACTER VARYING(255) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "DEFAULT_QPROFILES" ADD CONSTRAINT "PK_DEFAULT_QPROFILES" PRIMARY KEY("LANGUAGE");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_DEFAULT_QPROFILES_UUID" ON "DEFAULT_QPROFILES"("QPROFILE_UUID" NULLS FIRST);

CREATE TABLE "DEPRECATED_RULE_KEYS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "OLD_REPOSITORY_KEY" CHARACTER VARYING(255) NOT NULL,
    "OLD_RULE_KEY" CHARACTER VARYING(200) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "RULE_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "DEPRECATED_RULE_KEYS" ADD CONSTRAINT "PK_DEPRECATED_RULE_KEYS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_DEPRECATED_RULE_KEYS" ON "DEPRECATED_RULE_KEYS"("OLD_REPOSITORY_KEY" NULLS FIRST, "OLD_RULE_KEY" NULLS FIRST);
CREATE INDEX "RULE_UUID_DEPRECATED_RULE_KEYS" ON "DEPRECATED_RULE_KEYS"("RULE_UUID" NULLS FIRST);

CREATE TABLE "DEVOPS_PERMS_MAPPING"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "DEVOPS_PLATFORM_ROLE" CHARACTER VARYING(100) NOT NULL,
    "SONARQUBE_PERMISSION" CHARACTER VARYING(64) NOT NULL,
    "DEVOPS_PLATFORM" CHARACTER VARYING(40) DEFAULT 'github' NOT NULL
);
ALTER TABLE "DEVOPS_PERMS_MAPPING" ADD CONSTRAINT "PK_DEVOPS_PERMS_MAPPING" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_DEVOPS_PERMS_MAPPING" ON "DEVOPS_PERMS_MAPPING"("DEVOPS_PLATFORM" NULLS FIRST, "DEVOPS_PLATFORM_ROLE" NULLS FIRST, "SONARQUBE_PERMISSION" NULLS FIRST);

CREATE TABLE "DUPLICATIONS_INDEX"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ANALYSIS_UUID" CHARACTER VARYING(50) NOT NULL,
    "COMPONENT_UUID" CHARACTER VARYING(50) NOT NULL,
    "HASH" CHARACTER VARYING(50) NOT NULL,
    "INDEX_IN_FILE" INTEGER NOT NULL,
    "START_LINE" INTEGER NOT NULL,
    "END_LINE" INTEGER NOT NULL
);
ALTER TABLE "DUPLICATIONS_INDEX" ADD CONSTRAINT "PK_DUPLICATIONS_INDEX" PRIMARY KEY("UUID");
CREATE INDEX "DUPLICATIONS_INDEX_HASH" ON "DUPLICATIONS_INDEX"("HASH" NULLS FIRST);
CREATE INDEX "DUPLICATION_ANALYSIS_COMPONENT" ON "DUPLICATIONS_INDEX"("ANALYSIS_UUID" NULLS FIRST, "COMPONENT_UUID" NULLS FIRST);

CREATE TABLE "ES_QUEUE"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "DOC_TYPE" CHARACTER VARYING(40) NOT NULL,
    "DOC_ID" CHARACTER VARYING(4000) NOT NULL,
    "DOC_ID_TYPE" CHARACTER VARYING(20),
    "DOC_ROUTING" CHARACTER VARYING(4000),
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "ES_QUEUE" ADD CONSTRAINT "PK_ES_QUEUE" PRIMARY KEY("UUID");
CREATE INDEX "ES_QUEUE_CREATED_AT" ON "ES_QUEUE"("CREATED_AT" NULLS FIRST);

CREATE TABLE "EVENT_COMPONENT_CHANGES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "EVENT_UUID" CHARACTER VARYING(40) NOT NULL,
    "EVENT_COMPONENT_UUID" CHARACTER VARYING(50) NOT NULL,
    "EVENT_ANALYSIS_UUID" CHARACTER VARYING(50) NOT NULL,
    "CHANGE_CATEGORY" CHARACTER VARYING(12) NOT NULL,
    "COMPONENT_UUID" CHARACTER VARYING(50) NOT NULL,
    "COMPONENT_KEY" CHARACTER VARYING(400) NOT NULL,
    "COMPONENT_NAME" CHARACTER VARYING(2000) NOT NULL,
    "COMPONENT_BRANCH_KEY" CHARACTER VARYING(255),
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "EVENT_COMPONENT_CHANGES" ADD CONSTRAINT "PK_EVENT_COMPONENT_CHANGES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "EVENT_COMPONENT_CHANGES_UNIQUE" ON "EVENT_COMPONENT_CHANGES"("EVENT_UUID" NULLS FIRST, "CHANGE_CATEGORY" NULLS FIRST, "COMPONENT_UUID" NULLS FIRST);
CREATE INDEX "EVENT_CPNT_CHANGES_CPNT" ON "EVENT_COMPONENT_CHANGES"("EVENT_COMPONENT_UUID" NULLS FIRST);
CREATE INDEX "EVENT_CPNT_CHANGES_ANALYSIS" ON "EVENT_COMPONENT_CHANGES"("EVENT_ANALYSIS_UUID" NULLS FIRST);

CREATE TABLE "EVENTS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ANALYSIS_UUID" CHARACTER VARYING(50) NOT NULL,
    "NAME" CHARACTER VARYING(400),
    "CATEGORY" CHARACTER VARYING(50),
    "DESCRIPTION" CHARACTER VARYING(4000),
    "EVENT_DATA" CHARACTER VARYING(4000),
    "EVENT_DATE" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "COMPONENT_UUID" CHARACTER VARYING(50) NOT NULL
);
ALTER TABLE "EVENTS" ADD CONSTRAINT "PK_EVENTS" PRIMARY KEY("UUID");
CREATE INDEX "EVENTS_ANALYSIS" ON "EVENTS"("ANALYSIS_UUID" NULLS FIRST);
CREATE INDEX "EVENTS_COMPONENT_UUID" ON "EVENTS"("COMPONENT_UUID" NULLS FIRST);

CREATE TABLE "EXTERNAL_GROUPS"(
    "GROUP_UUID" CHARACTER VARYING(40) NOT NULL,
    "EXTERNAL_GROUP_ID" CHARACTER VARYING(255) NOT NULL,
    "EXTERNAL_IDENTITY_PROVIDER" CHARACTER VARYING(100) NOT NULL
);
ALTER TABLE "EXTERNAL_GROUPS" ADD CONSTRAINT "PK_EXTERNAL_GROUPS" PRIMARY KEY("GROUP_UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_EXT_GRP_EXT_ID_PROVIDER" ON "EXTERNAL_GROUPS"("EXTERNAL_IDENTITY_PROVIDER" NULLS FIRST, "EXTERNAL_GROUP_ID" NULLS FIRST);

CREATE TABLE "FILE_SOURCES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(50) NOT NULL,
    "FILE_UUID" CHARACTER VARYING(50) NOT NULL,
    "LINE_HASHES" CHARACTER LARGE OBJECT,
    "LINE_HASHES_VERSION" INTEGER,
    "DATA_HASH" CHARACTER VARYING(50),
    "SRC_HASH" CHARACTER VARYING(50),
    "REVISION" CHARACTER VARYING(100),
    "LINE_COUNT" INTEGER NOT NULL,
    "BINARY_DATA" BINARY LARGE OBJECT,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "FILE_SOURCES" ADD CONSTRAINT "PK_FILE_SOURCES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "FILE_SOURCES_FILE_UUID" ON "FILE_SOURCES"("FILE_UUID" NULLS FIRST);
CREATE INDEX "FILE_SOURCES_PROJECT_UUID" ON "FILE_SOURCES"("PROJECT_UUID" NULLS FIRST);
CREATE INDEX "FILE_SOURCES_UPDATED_AT" ON "FILE_SOURCES"("UPDATED_AT" NULLS FIRST);

CREATE TABLE "GITHUB_ORGS_GROUPS"(
    "GROUP_UUID" CHARACTER VARYING(40) NOT NULL,
    "ORGANIZATION_NAME" CHARACTER VARYING(100) NOT NULL
);
ALTER TABLE "GITHUB_ORGS_GROUPS" ADD CONSTRAINT "PK_GITHUB_ORGS_GROUPS" PRIMARY KEY("GROUP_UUID");

CREATE TABLE "GROUP_ROLES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ROLE" CHARACTER VARYING(64) NOT NULL,
    "ENTITY_UUID" CHARACTER VARYING(40),
    "GROUP_UUID" CHARACTER VARYING(40)
);
ALTER TABLE "GROUP_ROLES" ADD CONSTRAINT "PK_GROUP_ROLES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_GROUP_ROLES" ON "GROUP_ROLES"("GROUP_UUID" NULLS FIRST, "ENTITY_UUID" NULLS FIRST, "ROLE" NULLS FIRST);
CREATE INDEX "GROUP_ROLES_ENTITY_UUID" ON "GROUP_ROLES"("ENTITY_UUID" NULLS FIRST);

CREATE TABLE "GROUPS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(500) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(200),
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP
);
ALTER TABLE "GROUPS" ADD CONSTRAINT "PK_GROUPS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_GROUPS_NAME" ON "GROUPS"("NAME" NULLS FIRST);

CREATE TABLE "GROUPS_USERS"(
    "GROUP_UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL,
    "UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "GROUPS_USERS" ADD CONSTRAINT "PK_GROUPS_USERS" PRIMARY KEY("UUID");
CREATE INDEX "INDEX_GROUPS_USERS_GROUP_UUID" ON "GROUPS_USERS"("GROUP_UUID" NULLS FIRST);
CREATE INDEX "INDEX_GROUPS_USERS_USER_UUID" ON "GROUPS_USERS"("USER_UUID" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "GROUPS_USERS_UNIQUE" ON "GROUPS_USERS"("USER_UUID" NULLS FIRST, "GROUP_UUID" NULLS FIRST);

CREATE TABLE "INTERNAL_COMPONENT_PROPS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "COMPONENT_UUID" CHARACTER VARYING(50) NOT NULL,
    "KEE" CHARACTER VARYING(512) NOT NULL,
    "VALUE" CHARACTER VARYING(4000),
    "UPDATED_AT" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "INTERNAL_COMPONENT_PROPS" ADD CONSTRAINT "PK_INTERNAL_COMPONENT_PROPS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQUE_COMPONENT_UUID_KEE" ON "INTERNAL_COMPONENT_PROPS"("COMPONENT_UUID" NULLS FIRST, "KEE" NULLS FIRST);

CREATE TABLE "INTERNAL_PROPERTIES"(
    "KEE" CHARACTER VARYING(40) NOT NULL,
    "IS_EMPTY" BOOLEAN NOT NULL,
    "TEXT_VALUE" CHARACTER VARYING(4000),
    "CLOB_VALUE" CHARACTER LARGE OBJECT,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "INTERNAL_PROPERTIES" ADD CONSTRAINT "PK_INTERNAL_PROPERTIES" PRIMARY KEY("KEE");

CREATE TABLE "ISSUE_CHANGES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(50),
    "ISSUE_KEY" CHARACTER VARYING(50) NOT NULL,
    "USER_LOGIN" CHARACTER VARYING(255),
    "CHANGE_TYPE" CHARACTER VARYING(20),
    "CHANGE_DATA" CHARACTER LARGE OBJECT,
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT,
    "ISSUE_CHANGE_CREATION_DATE" BIGINT,
    "PROJECT_UUID" CHARACTER VARYING(50) NOT NULL
);
ALTER TABLE "ISSUE_CHANGES" ADD CONSTRAINT "PK_ISSUE_CHANGES" PRIMARY KEY("UUID");
CREATE INDEX "ISSUE_CHANGES_ISSUE_KEY" ON "ISSUE_CHANGES"("ISSUE_KEY" NULLS FIRST);
CREATE INDEX "ISSUE_CHANGES_KEE" ON "ISSUE_CHANGES"("KEE" NULLS FIRST);
CREATE INDEX "ISSUE_CHANGES_PROJECT_UUID" ON "ISSUE_CHANGES"("PROJECT_UUID" NULLS FIRST);
CREATE INDEX "ISSUE_CHANGES_ISSUE_KEY_TYPE" ON "ISSUE_CHANGES"("ISSUE_KEY" NULLS FIRST, "CHANGE_TYPE" NULLS FIRST);

CREATE TABLE "ISSUES"(
    "KEE" CHARACTER VARYING(50) NOT NULL,
    "RULE_UUID" CHARACTER VARYING(40),
    "SEVERITY" CHARACTER VARYING(10),
    "MANUAL_SEVERITY" BOOLEAN NOT NULL,
    "MESSAGE" CHARACTER VARYING(4000),
    "LINE" INTEGER,
    "GAP" DOUBLE PRECISION,
    "STATUS" CHARACTER VARYING(20),
    "RESOLUTION" CHARACTER VARYING(20),
    "CHECKSUM" CHARACTER VARYING(1000),
    "ASSIGNEE" CHARACTER VARYING(255),
    "AUTHOR_LOGIN" CHARACTER VARYING(255),
    "EFFORT" INTEGER,
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT,
    "ISSUE_CREATION_DATE" BIGINT,
    "ISSUE_UPDATE_DATE" BIGINT,
    "ISSUE_CLOSE_DATE" BIGINT,
    "TAGS" CHARACTER VARYING(4000),
    "COMPONENT_UUID" CHARACTER VARYING(50),
    "PROJECT_UUID" CHARACTER VARYING(50),
    "LOCATIONS" BINARY LARGE OBJECT,
    "ISSUE_TYPE" TINYINT,
    "QUICK_FIX_AVAILABLE" BOOLEAN,
    "RULE_DESCRIPTION_CONTEXT_KEY" CHARACTER VARYING(50),
    "MESSAGE_FORMATTINGS" BINARY LARGE OBJECT,
    "CODE_VARIANTS" CHARACTER VARYING(4000),
    "CLEAN_CODE_ATTRIBUTE" CHARACTER VARYING(40),
    "PRIORITIZED_RULE" BOOLEAN
);
ALTER TABLE "ISSUES" ADD CONSTRAINT "PK_ISSUES" PRIMARY KEY("KEE");
CREATE INDEX "ISSUES_ASSIGNEE" ON "ISSUES"("ASSIGNEE" NULLS FIRST);
CREATE INDEX "ISSUES_COMPONENT_UUID" ON "ISSUES"("COMPONENT_UUID" NULLS FIRST);
CREATE INDEX "ISSUES_CREATION_DATE" ON "ISSUES"("ISSUE_CREATION_DATE" NULLS FIRST);
CREATE INDEX "ISSUES_PROJECT_UUID" ON "ISSUES"("PROJECT_UUID" NULLS FIRST);
CREATE INDEX "ISSUES_RESOLUTION" ON "ISSUES"("RESOLUTION" NULLS FIRST);
CREATE INDEX "ISSUES_UPDATED_AT" ON "ISSUES"("UPDATED_AT" NULLS FIRST);
CREATE INDEX "ISSUES_RULE_UUID" ON "ISSUES"("RULE_UUID" NULLS FIRST);

CREATE TABLE "ISSUES_DEPENDENCY"(
    "ISSUE_UUID" CHARACTER VARYING(40) NOT NULL,
    "CVE_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "ISSUES_DEPENDENCY" ADD CONSTRAINT "PK_ISSUES_DEPENDENCY" PRIMARY KEY("ISSUE_UUID");

CREATE TABLE "ISSUES_FIXED"(
    "PULL_REQUEST_UUID" CHARACTER VARYING(40) NOT NULL,
    "ISSUE_KEY" CHARACTER VARYING(50) NOT NULL
);
ALTER TABLE "ISSUES_FIXED" ADD CONSTRAINT "PK_ISSUES_FIXED" PRIMARY KEY("PULL_REQUEST_UUID", "ISSUE_KEY");

CREATE TABLE "ISSUES_IMPACTS"(
    "ISSUE_KEY" CHARACTER VARYING(40) NOT NULL,
    "SOFTWARE_QUALITY" CHARACTER VARYING(40) NOT NULL,
    "SEVERITY" CHARACTER VARYING(40) NOT NULL,
    "MANUAL_SEVERITY" BOOLEAN DEFAULT FALSE NOT NULL
);
ALTER TABLE "ISSUES_IMPACTS" ADD CONSTRAINT "PK_ISSUES_IMPACTS" PRIMARY KEY("ISSUE_KEY", "SOFTWARE_QUALITY");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_ISS_KEY_SOF_QUAL" ON "ISSUES_IMPACTS"("ISSUE_KEY" NULLS FIRST, "SOFTWARE_QUALITY" NULLS FIRST);

CREATE TABLE "MEASURES"(
    "COMPONENT_UUID" CHARACTER VARYING(40) NOT NULL,
    "BRANCH_UUID" CHARACTER VARYING(40) NOT NULL,
    "JSON_VALUE" CHARACTER LARGE OBJECT NOT NULL,
    "JSON_VALUE_HASH" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "MEASURES" ADD CONSTRAINT "PK_MEASURES" PRIMARY KEY("COMPONENT_UUID");
CREATE INDEX "MEASURES_BRANCH_UUID" ON "MEASURES"("BRANCH_UUID" NULLS FIRST);

CREATE TABLE "METRICS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(64) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(255),
    "DIRECTION" INTEGER DEFAULT 0 NOT NULL,
    "DOMAIN" CHARACTER VARYING(64),
    "SHORT_NAME" CHARACTER VARYING(64),
    "QUALITATIVE" BOOLEAN DEFAULT FALSE NOT NULL,
    "VAL_TYPE" CHARACTER VARYING(8),
    "ENABLED" BOOLEAN DEFAULT TRUE,
    "WORST_VALUE" DOUBLE PRECISION,
    "BEST_VALUE" DOUBLE PRECISION,
    "OPTIMIZED_BEST_VALUE" BOOLEAN,
    "HIDDEN" BOOLEAN,
    "DELETE_HISTORICAL_DATA" BOOLEAN,
    "DECIMAL_SCALE" INTEGER
);
ALTER TABLE "METRICS" ADD CONSTRAINT "PK_METRICS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "METRICS_UNIQUE_NAME" ON "METRICS"("NAME" NULLS FIRST);

CREATE TABLE "NEW_CODE_PERIODS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40),
    "BRANCH_UUID" CHARACTER VARYING(40),
    "TYPE" CHARACTER VARYING(30) NOT NULL,
    "VALUE" CHARACTER VARYING(255),
    "UPDATED_AT" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "PREVIOUS_NON_COMPLIANT_VALUE" CHARACTER VARYING(255)
);
ALTER TABLE "NEW_CODE_PERIODS" ADD CONSTRAINT "PK_NEW_CODE_PERIODS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_NEW_CODE_PERIODS" ON "NEW_CODE_PERIODS"("PROJECT_UUID" NULLS FIRST, "BRANCH_UUID" NULLS FIRST);
CREATE INDEX "IDX_NCP_TYPE" ON "NEW_CODE_PERIODS"("TYPE" NULLS FIRST);
CREATE INDEX "IDX_NCP_VALUE" ON "NEW_CODE_PERIODS"("VALUE" NULLS FIRST);

CREATE TABLE "NEW_CODE_REFERENCE_ISSUES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ISSUE_KEY" CHARACTER VARYING(50) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "NEW_CODE_REFERENCE_ISSUES" ADD CONSTRAINT "PK_NEW_CODE_REFERENCE_ISSUES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_NEW_CODE_REFERENCE_ISSUES" ON "NEW_CODE_REFERENCE_ISSUES"("ISSUE_KEY" NULLS FIRST);

CREATE TABLE "NOTIFICATIONS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "DATA" BINARY LARGE OBJECT,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "NOTIFICATIONS" ADD CONSTRAINT "PK_NOTIFICATIONS" PRIMARY KEY("UUID");

CREATE TABLE "ORG_QPROFILES"(
    "UUID" CHARACTER VARYING(255) NOT NULL,
    "RULES_PROFILE_UUID" CHARACTER VARYING(255) NOT NULL,
    "PARENT_UUID" CHARACTER VARYING(255),
    "LAST_USED" BIGINT,
    "USER_UPDATED_AT" BIGINT,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "ORG_QPROFILES" ADD CONSTRAINT "PK_ORG_QPROFILES" PRIMARY KEY("UUID");
CREATE INDEX "QPROFILES_RP_UUID" ON "ORG_QPROFILES"("RULES_PROFILE_UUID" NULLS FIRST);
CREATE INDEX "ORG_QPROFILES_PARENT_UUID" ON "ORG_QPROFILES"("PARENT_UUID" NULLS FIRST);

CREATE TABLE "PERM_TEMPLATES_GROUPS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PERMISSION_REFERENCE" CHARACTER VARYING(64) NOT NULL,
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP,
    "TEMPLATE_UUID" CHARACTER VARYING(40) NOT NULL,
    "GROUP_UUID" CHARACTER VARYING(40)
);
ALTER TABLE "PERM_TEMPLATES_GROUPS" ADD CONSTRAINT "PK_PERM_TEMPLATES_GROUPS" PRIMARY KEY("UUID");

CREATE TABLE "PERM_TEMPLATES_USERS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PERMISSION_REFERENCE" CHARACTER VARYING(64) NOT NULL,
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP,
    "TEMPLATE_UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL
);
ALTER TABLE "PERM_TEMPLATES_USERS" ADD CONSTRAINT "PK_PERM_TEMPLATES_USERS" PRIMARY KEY("UUID");

CREATE TABLE "PERM_TPL_CHARACTERISTICS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PERMISSION_KEY" CHARACTER VARYING(64) NOT NULL,
    "WITH_PROJECT_CREATOR" BOOLEAN DEFAULT FALSE NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL,
    "TEMPLATE_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "PERM_TPL_CHARACTERISTICS" ADD CONSTRAINT "PK_PERM_TPL_CHARACTERISTICS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PERM_TPL_CHARAC" ON "PERM_TPL_CHARACTERISTICS"("TEMPLATE_UUID" NULLS FIRST, "PERMISSION_KEY" NULLS FIRST);

CREATE TABLE "PERMISSION_TEMPLATES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(100) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(4000),
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP,
    "KEY_PATTERN" CHARACTER VARYING(500)
);
ALTER TABLE "PERMISSION_TEMPLATES" ADD CONSTRAINT "PK_PERMISSION_TEMPLATES" PRIMARY KEY("UUID");

CREATE TABLE "PLUGINS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(200) NOT NULL,
    "BASE_PLUGIN_KEY" CHARACTER VARYING(200),
    "FILE_HASH" CHARACTER VARYING(200) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL,
    "TYPE" CHARACTER VARYING(10) NOT NULL,
    "REMOVED" BOOLEAN DEFAULT FALSE NOT NULL
);
ALTER TABLE "PLUGINS" ADD CONSTRAINT "PK_PLUGINS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "PLUGINS_KEY" ON "PLUGINS"("KEE" NULLS FIRST);

CREATE TABLE "PORTFOLIO_PROJ_BRANCHES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PORTFOLIO_PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "BRANCH_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "PORTFOLIO_PROJ_BRANCHES" ADD CONSTRAINT "PK_PORTFOLIO_PROJ_BRANCHES" PRIMARY KEY("UUID");

CREATE TABLE "PORTFOLIO_PROJECTS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PORTFOLIO_UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "PORTFOLIO_PROJECTS" ADD CONSTRAINT "PK_PORTFOLIO_PROJECTS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PORTFOLIO_PROJECTS" ON "PORTFOLIO_PROJECTS"("PORTFOLIO_UUID" NULLS FIRST, "PROJECT_UUID" NULLS FIRST);

CREATE TABLE "PORTFOLIO_REFERENCES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PORTFOLIO_UUID" CHARACTER VARYING(40) NOT NULL,
    "REFERENCE_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "BRANCH_UUID" CHARACTER VARYING(255)
);
ALTER TABLE "PORTFOLIO_REFERENCES" ADD CONSTRAINT "PK_PORTFOLIO_REFERENCES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PORTFOLIO_REFERENCES" ON "PORTFOLIO_REFERENCES"("PORTFOLIO_UUID" NULLS FIRST, "REFERENCE_UUID" NULLS FIRST, "BRANCH_UUID" NULLS FIRST);

CREATE TABLE "PORTFOLIOS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(400) NOT NULL,
    "NAME" CHARACTER VARYING(2000) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(2000),
    "ROOT_UUID" CHARACTER VARYING(40) NOT NULL,
    "PARENT_UUID" CHARACTER VARYING(40),
    "PRIVATE" BOOLEAN NOT NULL,
    "SELECTION_MODE" CHARACTER VARYING(50) NOT NULL,
    "SELECTION_EXPRESSION" CHARACTER VARYING(4000),
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL,
    "BRANCH_KEY" CHARACTER VARYING(255)
);
ALTER TABLE "PORTFOLIOS" ADD CONSTRAINT "PK_PORTFOLIOS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PORTFOLIOS_KEE" ON "PORTFOLIOS"("KEE" NULLS FIRST);

CREATE TABLE "PROJECT_ALM_SETTINGS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ALM_SETTING_UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(50) NOT NULL,
    "ALM_REPO" CHARACTER VARYING(256),
    "ALM_SLUG" CHARACTER VARYING(256),
    "UPDATED_AT" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "SUMMARY_COMMENT_ENABLED" BOOLEAN,
    "MONOREPO" BOOLEAN NOT NULL
);
ALTER TABLE "PROJECT_ALM_SETTINGS" ADD CONSTRAINT "PK_PROJECT_ALM_SETTINGS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROJECT_ALM_SETTINGS" ON "PROJECT_ALM_SETTINGS"("PROJECT_UUID" NULLS FIRST);
CREATE INDEX "PROJECT_ALM_SETTINGS_ALM" ON "PROJECT_ALM_SETTINGS"("ALM_SETTING_UUID" NULLS FIRST);
CREATE INDEX "PROJECT_ALM_SETTINGS_SLUG" ON "PROJECT_ALM_SETTINGS"("ALM_SLUG" NULLS FIRST);

CREATE TABLE "PROJECT_BADGE_TOKEN"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "TOKEN" CHARACTER VARYING(255) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "PROJECT_BADGE_TOKEN" ADD CONSTRAINT "PK_PROJECT_BADGE_TOKEN" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROJECT_BADGE_TOKEN" ON "PROJECT_BADGE_TOKEN"("PROJECT_UUID" NULLS FIRST);

CREATE TABLE "PROJECT_BRANCHES"(
    "UUID" CHARACTER VARYING(50) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(50) NOT NULL,
    "KEE" CHARACTER VARYING(255) NOT NULL,
    "BRANCH_TYPE" CHARACTER VARYING(12) NOT NULL,
    "MERGE_BRANCH_UUID" CHARACTER VARYING(50),
    "PULL_REQUEST_BINARY" BINARY LARGE OBJECT,
    "MANUAL_BASELINE_ANALYSIS_UUID" CHARACTER VARYING(40),
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL,
    "EXCLUDE_FROM_PURGE" BOOLEAN DEFAULT FALSE NOT NULL,
    "NEED_ISSUE_SYNC" BOOLEAN NOT NULL,
    "IS_MAIN" BOOLEAN NOT NULL
);
ALTER TABLE "PROJECT_BRANCHES" ADD CONSTRAINT "PK_PROJECT_BRANCHES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROJECT_BRANCHES" ON "PROJECT_BRANCHES"("BRANCH_TYPE" NULLS FIRST, "PROJECT_UUID" NULLS FIRST, "KEE" NULLS FIRST);
CREATE INDEX "PROJECT_BRANCHES_PROJECT_UUID" ON "PROJECT_BRANCHES"("PROJECT_UUID" NULLS FIRST);

CREATE TABLE "PROJECT_DEPENDENCIES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "VERSION" CHARACTER LARGE OBJECT,
    "INCLUDE_PATHS" CHARACTER LARGE OBJECT,
    "PACKAGE_MANAGER" CHARACTER VARYING(50),
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "PROJECT_DEPENDENCIES" ADD CONSTRAINT "PK_PROJECT_DEPENDENCIES" PRIMARY KEY("UUID");

CREATE TABLE "PROJECT_LINKS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "LINK_TYPE" CHARACTER VARYING(20) NOT NULL,
    "NAME" CHARACTER VARYING(128),
    "HREF" CHARACTER VARYING(2048) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "PROJECT_LINKS" ADD CONSTRAINT "PK_PROJECT_LINKS" PRIMARY KEY("UUID");
CREATE INDEX "PROJECT_LINKS_PROJECT" ON "PROJECT_LINKS"("PROJECT_UUID" NULLS FIRST);

CREATE TABLE "PROJECT_MEASURES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "VALUE" DOUBLE PRECISION,
    "ANALYSIS_UUID" CHARACTER VARYING(50) NOT NULL,
    "COMPONENT_UUID" CHARACTER VARYING(50) NOT NULL,
    "TEXT_VALUE" CHARACTER VARYING(4000),
    "ALERT_STATUS" CHARACTER VARYING(5),
    "ALERT_TEXT" CHARACTER VARYING(4000),
    "PERSON_ID" INTEGER,
    "MEASURE_DATA" BINARY LARGE OBJECT,
    "METRIC_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "PROJECT_MEASURES" ADD CONSTRAINT "PK_PROJECT_MEASURES" PRIMARY KEY("UUID");
CREATE INDEX "MEASURES_COMPONENT_UUID" ON "PROJECT_MEASURES"("COMPONENT_UUID" NULLS FIRST);
CREATE INDEX "MEASURES_ANALYSIS_METRIC" ON "PROJECT_MEASURES"("ANALYSIS_UUID" NULLS FIRST, "METRIC_UUID" NULLS FIRST);
CREATE INDEX "PROJECT_MEASURES_METRIC" ON "PROJECT_MEASURES"("METRIC_UUID" NULLS FIRST);

CREATE TABLE "PROJECT_QGATES"(
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "QUALITY_GATE_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "PROJECT_QGATES" ADD CONSTRAINT "PK_PROJECT_QGATES" PRIMARY KEY("PROJECT_UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROJECT_QGATES" ON "PROJECT_QGATES"("PROJECT_UUID" NULLS FIRST, "QUALITY_GATE_UUID" NULLS FIRST);

CREATE TABLE "PROJECT_QPROFILES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(50) NOT NULL,
    "PROFILE_KEY" CHARACTER VARYING(50) NOT NULL
);
ALTER TABLE "PROJECT_QPROFILES" ADD CONSTRAINT "PK_PROJECT_QPROFILES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROJECT_QPROFILES" ON "PROJECT_QPROFILES"("PROJECT_UUID" NULLS FIRST, "PROFILE_KEY" NULLS FIRST);

CREATE TABLE "PROJECTS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(400) NOT NULL,
    "QUALIFIER" CHARACTER VARYING(10) NOT NULL,
    "NAME" CHARACTER VARYING(2000),
    "DESCRIPTION" CHARACTER VARYING(2000),
    "PRIVATE" BOOLEAN NOT NULL,
    "TAGS" CHARACTER VARYING(500),
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT NOT NULL,
    "NCLOC" BIGINT,
    "CREATION_METHOD" CHARACTER VARYING(50) NOT NULL,
    "CONTAINS_AI_CODE" BOOLEAN DEFAULT FALSE NOT NULL,
    "AI_CODE_FIX_ENABLED" BOOLEAN DEFAULT FALSE NOT NULL,
    "DETECTED_AI_CODE" BOOLEAN DEFAULT FALSE NOT NULL
);
ALTER TABLE "PROJECTS" ADD CONSTRAINT "PK_NEW_PROJECTS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROJECTS_KEE" ON "PROJECTS"("KEE" NULLS FIRST);
CREATE INDEX "IDX_QUALIFIER" ON "PROJECTS"("QUALIFIER" NULLS FIRST);

CREATE TABLE "PROPERTIES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PROP_KEY" CHARACTER VARYING(512) NOT NULL,
    "IS_EMPTY" BOOLEAN NOT NULL,
    "TEXT_VALUE" CHARACTER VARYING(4000),
    "CLOB_VALUE" CHARACTER LARGE OBJECT,
    "CREATED_AT" BIGINT NOT NULL,
    "ENTITY_UUID" CHARACTER VARYING(40),
    "USER_UUID" CHARACTER VARYING(255)
);
ALTER TABLE "PROPERTIES" ADD CONSTRAINT "PK_PROPERTIES" PRIMARY KEY("UUID");
CREATE INDEX "PROPERTIES_KEY" ON "PROPERTIES"("PROP_KEY" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_PROPERTIES" ON "PROPERTIES"("PROP_KEY" NULLS FIRST, "ENTITY_UUID" NULLS FIRST, "USER_UUID" NULLS FIRST);

CREATE TABLE "PUSH_EVENTS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "PAYLOAD" BINARY LARGE OBJECT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "LANGUAGE" CHARACTER VARYING(20)
);
ALTER TABLE "PUSH_EVENTS" ADD CONSTRAINT "PK_PUSH_EVENTS" PRIMARY KEY("UUID");
CREATE INDEX "IDX_PUSH_EVEN_CREA_UUID_PROJ" ON "PUSH_EVENTS"("CREATED_AT" NULLS FIRST, "UUID" NULLS FIRST, "PROJECT_UUID" NULLS FIRST);

CREATE TABLE "QGATE_GROUP_PERMISSIONS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "QUALITY_GATE_UUID" CHARACTER VARYING(40) NOT NULL,
    "GROUP_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "QGATE_GROUP_PERMISSIONS" ADD CONSTRAINT "PK_QGATE_GROUP_PERMISSIONS" PRIMARY KEY("UUID");
CREATE INDEX "QG_GROUPS_UUID_IDX" ON "QGATE_GROUP_PERMISSIONS"("QUALITY_GATE_UUID" NULLS FIRST);

CREATE TABLE "QGATE_USER_PERMISSIONS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "QUALITY_GATE_UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(40) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "QGATE_USER_PERMISSIONS" ADD CONSTRAINT "PK_QGATE_USER_PERMISSIONS" PRIMARY KEY("UUID");
CREATE INDEX "QUALITY_GATE_UUID_IDX" ON "QGATE_USER_PERMISSIONS"("QUALITY_GATE_UUID" NULLS FIRST);

CREATE TABLE "QPROFILE_CHANGES"(
    "KEE" CHARACTER VARYING(40) NOT NULL,
    "RULES_PROFILE_UUID" CHARACTER VARYING(255) NOT NULL,
    "CHANGE_TYPE" CHARACTER VARYING(20) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255),
    "CHANGE_DATA" CHARACTER LARGE OBJECT,
    "CREATED_AT" BIGINT NOT NULL,
    "RULE_CHANGE_UUID" CHARACTER VARYING(40),
    "SQ_VERSION" CHARACTER VARYING(40)
);
ALTER TABLE "QPROFILE_CHANGES" ADD CONSTRAINT "PK_QPROFILE_CHANGES" PRIMARY KEY("KEE");
CREATE INDEX "QP_CHANGES_RULES_PROFILE_UUID" ON "QPROFILE_CHANGES"("RULES_PROFILE_UUID" NULLS FIRST);

CREATE TABLE "QPROFILE_EDIT_GROUPS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "QPROFILE_UUID" CHARACTER VARYING(255) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "GROUP_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "QPROFILE_EDIT_GROUPS" ADD CONSTRAINT "PK_QPROFILE_EDIT_GROUPS" PRIMARY KEY("UUID");
CREATE INDEX "QPROFILE_EDIT_GROUPS_QPROFILE" ON "QPROFILE_EDIT_GROUPS"("QPROFILE_UUID" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "QPROFILE_EDIT_GROUPS_UNIQUE" ON "QPROFILE_EDIT_GROUPS"("GROUP_UUID" NULLS FIRST, "QPROFILE_UUID" NULLS FIRST);

CREATE TABLE "QPROFILE_EDIT_USERS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "QPROFILE_UUID" CHARACTER VARYING(255) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL
);
ALTER TABLE "QPROFILE_EDIT_USERS" ADD CONSTRAINT "PK_QPROFILE_EDIT_USERS" PRIMARY KEY("UUID");
CREATE INDEX "QPROFILE_EDIT_USERS_QPROFILE" ON "QPROFILE_EDIT_USERS"("QPROFILE_UUID" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "QPROFILE_EDIT_USERS_UNIQUE" ON "QPROFILE_EDIT_USERS"("USER_UUID" NULLS FIRST, "QPROFILE_UUID" NULLS FIRST);

CREATE TABLE "QUALITY_GATE_CONDITIONS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "OPERATOR" CHARACTER VARYING(3),
    "VALUE_ERROR" CHARACTER VARYING(64),
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP,
    "METRIC_UUID" CHARACTER VARYING(40) NOT NULL,
    "QGATE_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "QUALITY_GATE_CONDITIONS" ADD CONSTRAINT "PK_QUALITY_GATE_CONDITIONS" PRIMARY KEY("UUID");

CREATE TABLE "QUALITY_GATES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(100) NOT NULL,
    "IS_BUILT_IN" BOOLEAN NOT NULL,
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP,
    "AI_CODE_SUPPORTED" BOOLEAN DEFAULT FALSE NOT NULL
);
ALTER TABLE "QUALITY_GATES" ADD CONSTRAINT "PK_QUALITY_GATES" PRIMARY KEY("UUID");

CREATE TABLE "REPORT_SCHEDULES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PORTFOLIO_UUID" CHARACTER VARYING(40),
    "BRANCH_UUID" CHARACTER VARYING(40),
    "LAST_SEND_TIME_IN_MS" BIGINT NOT NULL
);
ALTER TABLE "REPORT_SCHEDULES" ADD CONSTRAINT "PK_REPORT_SCHEDULES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_REPORT_SCHEDULES" ON "REPORT_SCHEDULES"("PORTFOLIO_UUID" NULLS FIRST, "BRANCH_UUID" NULLS FIRST);

CREATE TABLE "REPORT_SUBSCRIPTIONS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PORTFOLIO_UUID" CHARACTER VARYING(40),
    "BRANCH_UUID" CHARACTER VARYING(40),
    "USER_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "REPORT_SUBSCRIPTIONS" ADD CONSTRAINT "PK_REPORT_SUBSCRIPTIONS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_REPORT_SUBSCRIPTIONS" ON "REPORT_SUBSCRIPTIONS"("PORTFOLIO_UUID" NULLS FIRST, "BRANCH_UUID" NULLS FIRST, "USER_UUID" NULLS FIRST);

CREATE TABLE "RULE_CHANGES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NEW_CLEAN_CODE_ATTRIBUTE" CHARACTER VARYING(40),
    "OLD_CLEAN_CODE_ATTRIBUTE" CHARACTER VARYING(40),
    "RULE_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "RULE_CHANGES" ADD CONSTRAINT "PK_RULE_CHANGES" PRIMARY KEY("UUID");

CREATE TABLE "RULE_DESC_SECTIONS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "RULE_UUID" CHARACTER VARYING(40) NOT NULL,
    "KEE" CHARACTER VARYING(50) NOT NULL,
    "CONTENT" CHARACTER LARGE OBJECT NOT NULL,
    "CONTEXT_KEY" CHARACTER VARYING(50),
    "CONTEXT_DISPLAY_NAME" CHARACTER VARYING(50)
);
ALTER TABLE "RULE_DESC_SECTIONS" ADD CONSTRAINT "PK_RULE_DESC_SECTIONS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_RULE_DESC_SECTIONS" ON "RULE_DESC_SECTIONS"("RULE_UUID" NULLS FIRST, "KEE" NULLS FIRST, "CONTEXT_KEY" NULLS FIRST);

CREATE TABLE "RULE_IMPACT_CHANGES"(
    "NEW_SOFTWARE_QUALITY" CHARACTER VARYING(40),
    "OLD_SOFTWARE_QUALITY" CHARACTER VARYING(40),
    "NEW_SEVERITY" CHARACTER VARYING(40),
    "OLD_SEVERITY" CHARACTER VARYING(40),
    "RULE_CHANGE_UUID" CHARACTER VARYING(40) NOT NULL
);
CREATE INDEX "RULE_IMPACT_CHANGES_R_C_UUID" ON "RULE_IMPACT_CHANGES"("RULE_CHANGE_UUID" NULLS FIRST);

CREATE TABLE "RULE_REPOSITORIES"(
    "KEE" CHARACTER VARYING(200) NOT NULL,
    "LANGUAGE" CHARACTER VARYING(20) NOT NULL,
    "NAME" CHARACTER VARYING(4000) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "RULE_REPOSITORIES" ADD CONSTRAINT "PK_RULE_REPOSITORIES" PRIMARY KEY("KEE");

CREATE TABLE "RULE_TAGS"(
    "VALUE" CHARACTER VARYING(400) NOT NULL,
    "RULE_UUID" CHARACTER VARYING(40) NOT NULL,
    "IS_SYSTEM_TAG" BOOLEAN NOT NULL
);
ALTER TABLE "RULE_TAGS" ADD CONSTRAINT "PK_RULE_TAGS" PRIMARY KEY("VALUE", "RULE_UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "RULE_TAGS_RULE_UUID" ON "RULE_TAGS"("RULE_UUID" NULLS FIRST, "VALUE" NULLS FIRST, "IS_SYSTEM_TAG" NULLS FIRST);

CREATE TABLE "RULES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(200),
    "PLUGIN_RULE_KEY" CHARACTER VARYING(200) NOT NULL,
    "PLUGIN_KEY" CHARACTER VARYING(200),
    "PLUGIN_CONFIG_KEY" CHARACTER VARYING(200),
    "PLUGIN_NAME" CHARACTER VARYING(255) NOT NULL,
    "SCOPE" CHARACTER VARYING(20) NOT NULL,
    "PRIORITY" INTEGER,
    "STATUS" CHARACTER VARYING(40),
    "LANGUAGE" CHARACTER VARYING(20),
    "DEF_REMEDIATION_FUNCTION" CHARACTER VARYING(20),
    "DEF_REMEDIATION_GAP_MULT" CHARACTER VARYING(20),
    "DEF_REMEDIATION_BASE_EFFORT" CHARACTER VARYING(20),
    "GAP_DESCRIPTION" CHARACTER VARYING(4000),
    "IS_TEMPLATE" BOOLEAN DEFAULT FALSE NOT NULL,
    "DESCRIPTION_FORMAT" CHARACTER VARYING(20),
    "RULE_TYPE" TINYINT,
    "SECURITY_STANDARDS" CHARACTER VARYING(4000),
    "IS_AD_HOC" BOOLEAN NOT NULL,
    "IS_EXTERNAL" BOOLEAN NOT NULL,
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT,
    "TEMPLATE_UUID" CHARACTER VARYING(40),
    "NOTE_DATA" CHARACTER LARGE OBJECT,
    "NOTE_USER_UUID" CHARACTER VARYING(255),
    "NOTE_CREATED_AT" BIGINT,
    "NOTE_UPDATED_AT" BIGINT,
    "REMEDIATION_FUNCTION" CHARACTER VARYING(20),
    "REMEDIATION_GAP_MULT" CHARACTER VARYING(20),
    "REMEDIATION_BASE_EFFORT" CHARACTER VARYING(20),
    "AD_HOC_NAME" CHARACTER VARYING(200),
    "AD_HOC_DESCRIPTION" CHARACTER LARGE OBJECT,
    "AD_HOC_SEVERITY" CHARACTER VARYING(10),
    "AD_HOC_TYPE" TINYINT,
    "EDUCATION_PRINCIPLES" CHARACTER VARYING(255),
    "CLEAN_CODE_ATTRIBUTE" CHARACTER VARYING(40)
);
ALTER TABLE "RULES" ADD CONSTRAINT "PK_RULES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "RULES_REPO_KEY" ON "RULES"("PLUGIN_RULE_KEY" NULLS FIRST, "PLUGIN_NAME" NULLS FIRST);

CREATE TABLE "RULES_DEFAULT_IMPACTS"(
    "RULE_UUID" CHARACTER VARYING(40) NOT NULL,
    "SOFTWARE_QUALITY" CHARACTER VARYING(40) NOT NULL,
    "SEVERITY" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "RULES_DEFAULT_IMPACTS" ADD CONSTRAINT "PK_RULES_DEFAULT_IMPACTS" PRIMARY KEY("RULE_UUID", "SOFTWARE_QUALITY");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_RUL_UUID_SOF_QUAL" ON "RULES_DEFAULT_IMPACTS"("RULE_UUID" NULLS FIRST, "SOFTWARE_QUALITY" NULLS FIRST);

CREATE TABLE "RULES_PARAMETERS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(128) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(4000),
    "PARAM_TYPE" CHARACTER VARYING(512) NOT NULL,
    "DEFAULT_VALUE" CHARACTER VARYING(4000),
    "RULE_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "RULES_PARAMETERS" ADD CONSTRAINT "PK_RULES_PARAMETERS" PRIMARY KEY("UUID");
CREATE INDEX "RULES_PARAMETERS_RULE_UUID" ON "RULES_PARAMETERS"("RULE_UUID" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "RULES_PARAMETERS_UNIQUE" ON "RULES_PARAMETERS"("RULE_UUID" NULLS FIRST, "NAME" NULLS FIRST);

CREATE TABLE "RULES_PROFILES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "NAME" CHARACTER VARYING(100) NOT NULL,
    "LANGUAGE" CHARACTER VARYING(20),
    "IS_BUILT_IN" BOOLEAN NOT NULL,
    "RULES_UPDATED_AT" CHARACTER VARYING(100),
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP
);
ALTER TABLE "RULES_PROFILES" ADD CONSTRAINT "PK_RULES_PROFILES" PRIMARY KEY("UUID");

CREATE TABLE "SAML_MESSAGE_IDS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "MESSAGE_ID" CHARACTER VARYING(255) NOT NULL,
    "EXPIRATION_DATE" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "SAML_MESSAGE_IDS" ADD CONSTRAINT "PK_SAML_MESSAGE_IDS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "SAML_MESSAGE_IDS_UNIQUE" ON "SAML_MESSAGE_IDS"("MESSAGE_ID" NULLS FIRST);

CREATE TABLE "SCANNER_ANALYSIS_CACHE"(
    "BRANCH_UUID" CHARACTER VARYING(40) NOT NULL,
    "DATA" BINARY LARGE OBJECT NOT NULL
);
ALTER TABLE "SCANNER_ANALYSIS_CACHE" ADD CONSTRAINT "PK_SCANNER_ANALYSIS_CACHE" PRIMARY KEY("BRANCH_UUID");

CREATE TABLE "SCIM_GROUPS"(
    "SCIM_UUID" CHARACTER VARYING(40) NOT NULL,
    "GROUP_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "SCIM_GROUPS" ADD CONSTRAINT "PK_SCIM_GROUPS" PRIMARY KEY("SCIM_UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_SCIM_GROUP_UUID" ON "SCIM_GROUPS"("GROUP_UUID" NULLS FIRST);

CREATE TABLE "SCIM_USERS"(
    "SCIM_UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "SCIM_USERS" ADD CONSTRAINT "PK_SCIM_USERS" PRIMARY KEY("SCIM_UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_SCIM_USERS_USER_UUID" ON "SCIM_USERS"("USER_UUID" NULLS FIRST);

CREATE TABLE "SCM_ACCOUNTS"(
    "USER_UUID" CHARACTER VARYING(255) NOT NULL,
    "SCM_ACCOUNT" CHARACTER VARYING(255) NOT NULL
);
ALTER TABLE "SCM_ACCOUNTS" ADD CONSTRAINT "PK_SCM_ACCOUNTS" PRIMARY KEY("USER_UUID", "SCM_ACCOUNT");
CREATE INDEX "SCM_ACCOUNTS_SCM_ACCOUNT" ON "SCM_ACCOUNTS"("SCM_ACCOUNT" NULLS FIRST);

CREATE TABLE "SESSION_TOKENS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL,
    "EXPIRATION_DATE" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "SESSION_TOKENS" ADD CONSTRAINT "PK_SESSION_TOKENS" PRIMARY KEY("UUID");
CREATE INDEX "SESSION_TOKENS_USER_UUID" ON "SESSION_TOKENS"("USER_UUID" NULLS FIRST);

CREATE TABLE "SNAPSHOTS"(
    "UUID" CHARACTER VARYING(50) NOT NULL,
    "ROOT_COMPONENT_UUID" CHARACTER VARYING(50) NOT NULL,
    "STATUS" CHARACTER VARYING(4) DEFAULT 'U' NOT NULL,
    "ISLAST" BOOLEAN DEFAULT FALSE NOT NULL,
    "VERSION" CHARACTER VARYING(500),
    "BUILD_STRING" CHARACTER VARYING(100),
    "REVISION" CHARACTER VARYING(100),
    "ANALYSIS_DATE" BIGINT,
    "PERIOD1_MODE" CHARACTER VARYING(100),
    "PERIOD1_PARAM" CHARACTER VARYING(100),
    "PERIOD1_DATE" BIGINT,
    "CREATED_AT" BIGINT,
    "PURGED" BOOLEAN NOT NULL
);
ALTER TABLE "SNAPSHOTS" ADD CONSTRAINT "PK_SNAPSHOTS" PRIMARY KEY("UUID");
CREATE INDEX "SNAPSHOTS_ROOT_COMPONENT_UUID" ON "SNAPSHOTS"("ROOT_COMPONENT_UUID" NULLS FIRST);

CREATE TABLE "TELEMETRY_METRICS_SENT"(
    "METRIC_KEY" CHARACTER VARYING(40) NOT NULL,
    "DIMENSION" CHARACTER VARYING(40) NOT NULL,
    "LAST_SENT" BIGINT NOT NULL
);
ALTER TABLE "TELEMETRY_METRICS_SENT" ADD CONSTRAINT "PK_TELEMETRY_METRICS_SENT" PRIMARY KEY("METRIC_KEY", "DIMENSION");

CREATE TABLE "USER_AI_TOOL_USAGES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(40) NOT NULL,
    "ACTIVATED_AT" BIGINT NOT NULL,
    "LAST_ACTIVITY_AT" BIGINT
);
ALTER TABLE "USER_AI_TOOL_USAGES" ADD CONSTRAINT "PK_USER_AI_TOOL_USAGES" PRIMARY KEY("UUID");

CREATE TABLE "USER_DISMISSED_MESSAGES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40),
    "MESSAGE_TYPE" CHARACTER VARYING(255) NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "USER_DISMISSED_MESSAGES" ADD CONSTRAINT "PK_USER_DISMISSED_MESSAGES" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_USER_DISMISSED_MESSAGES" ON "USER_DISMISSED_MESSAGES"("USER_UUID" NULLS FIRST, "PROJECT_UUID" NULLS FIRST, "MESSAGE_TYPE" NULLS FIRST);
CREATE INDEX "UDM_PROJECT_UUID" ON "USER_DISMISSED_MESSAGES"("PROJECT_UUID" NULLS FIRST);
CREATE INDEX "UDM_MESSAGE_TYPE" ON "USER_DISMISSED_MESSAGES"("MESSAGE_TYPE" NULLS FIRST);

CREATE TABLE "USER_ROLES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "ROLE" CHARACTER VARYING(64) NOT NULL,
    "ENTITY_UUID" CHARACTER VARYING(40),
    "USER_UUID" CHARACTER VARYING(255)
);
ALTER TABLE "USER_ROLES" ADD CONSTRAINT "PK_USER_ROLES" PRIMARY KEY("UUID");
CREATE INDEX "USER_ROLES_USER" ON "USER_ROLES"("USER_UUID" NULLS FIRST);
CREATE INDEX "USER_ROLES_ENTITY_UUID" ON "USER_ROLES"("ENTITY_UUID" NULLS FIRST);

CREATE TABLE "USER_TOKENS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "USER_UUID" CHARACTER VARYING(255) NOT NULL,
    "NAME" CHARACTER VARYING(100) NOT NULL,
    "TOKEN_HASH" CHARACTER VARYING(255) NOT NULL,
    "LAST_CONNECTION_DATE" BIGINT,
    "CREATED_AT" BIGINT NOT NULL,
    "TYPE" CHARACTER VARYING(100) NOT NULL,
    "EXPIRATION_DATE" BIGINT,
    "PROJECT_UUID" CHARACTER VARYING(40)
);
ALTER TABLE "USER_TOKENS" ADD CONSTRAINT "PK_USER_TOKENS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "USER_TOKENS_USER_UUID_NAME" ON "USER_TOKENS"("USER_UUID" NULLS FIRST, "NAME" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "USER_TOKENS_TOKEN_HASH" ON "USER_TOKENS"("TOKEN_HASH" NULLS FIRST);

CREATE TABLE "USERS"(
    "UUID" CHARACTER VARYING(255) NOT NULL,
    "LOGIN" CHARACTER VARYING(255) NOT NULL,
    "NAME" CHARACTER VARYING(200),
    "EMAIL" CHARACTER VARYING(100),
    "CRYPTED_PASSWORD" CHARACTER VARYING(100),
    "SALT" CHARACTER VARYING(40),
    "HASH_METHOD" CHARACTER VARYING(10),
    "ACTIVE" BOOLEAN DEFAULT TRUE,
    "EXTERNAL_LOGIN" CHARACTER VARYING(255) NOT NULL,
    "EXTERNAL_IDENTITY_PROVIDER" CHARACTER VARYING(100) NOT NULL,
    "EXTERNAL_ID" CHARACTER VARYING(255) NOT NULL,
    "USER_LOCAL" BOOLEAN NOT NULL,
    "HOMEPAGE_TYPE" CHARACTER VARYING(40),
    "HOMEPAGE_PARAMETER" CHARACTER VARYING(40),
    "LAST_CONNECTION_DATE" BIGINT,
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT,
    "RESET_PASSWORD" BOOLEAN NOT NULL,
    "LAST_SONARLINT_CONNECTION" BIGINT
);
ALTER TABLE "USERS" ADD CONSTRAINT "PK_USERS" PRIMARY KEY("UUID");
CREATE UNIQUE NULLS NOT DISTINCT INDEX "USERS_LOGIN" ON "USERS"("LOGIN" NULLS FIRST);
CREATE INDEX "USERS_UPDATED_AT" ON "USERS"("UPDATED_AT" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_EXTERNAL_ID" ON "USERS"("EXTERNAL_IDENTITY_PROVIDER" NULLS FIRST, "EXTERNAL_ID" NULLS FIRST);
CREATE UNIQUE NULLS NOT DISTINCT INDEX "UNIQ_EXTERNAL_LOGIN" ON "USERS"("EXTERNAL_IDENTITY_PROVIDER" NULLS FIRST, "EXTERNAL_LOGIN" NULLS FIRST);
CREATE INDEX "USERS_EMAIL" ON "USERS"("EMAIL" NULLS FIRST);

CREATE TABLE "WEBHOOK_DELIVERIES"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "WEBHOOK_UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40) NOT NULL,
    "CE_TASK_UUID" CHARACTER VARYING(40),
    "ANALYSIS_UUID" CHARACTER VARYING(40),
    "NAME" CHARACTER VARYING(100) NOT NULL,
    "URL" CHARACTER VARYING(2000) NOT NULL,
    "SUCCESS" BOOLEAN NOT NULL,
    "HTTP_STATUS" INTEGER,
    "DURATION_MS" BIGINT NOT NULL,
    "PAYLOAD" CHARACTER LARGE OBJECT NOT NULL,
    "ERROR_STACKTRACE" CHARACTER LARGE OBJECT,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "WEBHOOK_DELIVERIES" ADD CONSTRAINT "PK_WEBHOOK_DELIVERIES" PRIMARY KEY("UUID");
CREATE INDEX "WD_WEBHOOK_UUID_CREATED_AT" ON "WEBHOOK_DELIVERIES"("WEBHOOK_UUID" NULLS FIRST, "CREATED_AT" NULLS FIRST);
CREATE INDEX "WD_PROJECT_UUID_CREATED_AT" ON "WEBHOOK_DELIVERIES"("PROJECT_UUID" NULLS FIRST, "CREATED_AT" NULLS FIRST);
CREATE INDEX "WD_CE_TASK_UUID_CREATED_AT" ON "WEBHOOK_DELIVERIES"("CE_TASK_UUID" NULLS FIRST, "CREATED_AT" NULLS FIRST);
CREATE INDEX "WD_CREATED_AT" ON "WEBHOOK_DELIVERIES"("CREATED_AT" NULLS FIRST);

CREATE TABLE "WEBHOOKS"(
    "UUID" CHARACTER VARYING(40) NOT NULL,
    "PROJECT_UUID" CHARACTER VARYING(40),
    "NAME" CHARACTER VARYING(100) NOT NULL,
    "URL" CHARACTER VARYING(2000) NOT NULL,
    "SECRET" CHARACTER VARYING(200),
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT
);
ALTER TABLE "WEBHOOKS" ADD CONSTRAINT "PK_WEBHOOKS" PRIMARY KEY("UUID");
