/*
 * SonarQube
 * Copyright (C) 2009-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.ce.task.projectanalysis.pushevent;

import org.junit.Test;

import static org.assertj.core.api.Assertions.assertThat;

public class TaintVulnerabilityClosedTest {

  @Test
  public void testConstructor_Getters_Setters() {
    TaintVulnerabilityClosed underTest = new TaintVulnerabilityClosed();
    assertThat(underTest.getKey()).isNull();
    assertThat(underTest.getProjectKey()).isNull();

    underTest = new TaintVulnerabilityClosed("issue-key", "project-key");
    assertThat(underTest.getKey()).isEqualTo("issue-key");
    assertThat(underTest.getProjectKey()).isEqualTo("project-key");

    underTest.setKey("another-issue-key");
    assertThat(underTest.getKey()).isEqualTo("another-issue-key");
    underTest.setProjectKey("another-project-key");
    assertThat(underTest.getProjectKey()).isEqualTo("another-project-key");

  }
}
