/*
 * SonarQube
 * Copyright (C) 2009-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.ce.task.projectanalysis.period;

import javax.annotation.Nullable;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class PeriodHolderRule implements TestRule, PeriodHolder, AfterEachCallback {
  private PeriodHolderImpl delegate = new PeriodHolderImpl();

  @Override
  public void afterEach(ExtensionContext extensionContext) {
    clear();
  }

  @Override
  public Statement apply(final Statement statement, Description description) {
    return new Statement() {
      @Override
      public void evaluate() throws Throwable {
        try {
          statement.evaluate();
        } finally {
          clear();
        }
      }
    };
  }

  private void clear() {
    this.delegate = new PeriodHolderImpl();
  }

  public PeriodHolderRule setPeriod(@Nullable Period period) {
    delegate = new PeriodHolderImpl();
    delegate.setPeriod(period);
    return this;
  }

  @Override
  public boolean hasPeriod() {
    return delegate.hasPeriod();
  }

  @Override
  public boolean hasPeriodDate() {
    return delegate.hasPeriodDate();
  }

  @Override
  public Period getPeriod() {
    return delegate.getPeriod();
  }

}
