/*
 * SonarQube
 * Copyright (C) 2009-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.ce.task.projectanalysis.pushevent;

import java.util.List;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.locations.flow.Flow;
import org.sonar.ce.task.projectanalysis.locations.flow.Location;

public class TaintVulnerabilityRaised extends IssueEvent {

  private static final String EVENT_NAME = "TaintVulnerabilityRaised";

  private String branch;
  private long creationDate;
  private String ruleKey;
  private String severity;
  private String type;
  private Location mainLocation;
  private List<Flow> flows;
  private String ruleDescriptionContextKey;
  private String cleanCodeAttribute;
  private String cleanCodeAttributeCategory;
  private List<Impact> impacts;

  public TaintVulnerabilityRaised() {
    // nothing to do
  }

  @Override
  public String getEventName() {
    return EVENT_NAME;
  }

  public String getBranch() {
    return branch;
  }

  public void setBranch(String branch) {
    this.branch = branch;
  }

  public long getCreationDate() {
    return creationDate;
  }

  public void setCreationDate(long creationDate) {
    this.creationDate = creationDate;
  }

  public String getRuleKey() {
    return ruleKey;
  }

  public void setRuleKey(String ruleKey) {
    this.ruleKey = ruleKey;
  }

  public String getSeverity() {
    return severity;
  }

  public void setSeverity(String severity) {
    this.severity = severity;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Location getMainLocation() {
    return mainLocation;
  }

  public void setMainLocation(Location mainLocation) {
    this.mainLocation = mainLocation;
  }

  public List<Flow> getFlows() {
    return flows;
  }

  public void setFlows(List<Flow> flows) {
    this.flows = flows;
  }

  public Optional<String> getRuleDescriptionContextKey() {
    return Optional.ofNullable(ruleDescriptionContextKey);
  }

  public void setRuleDescriptionContextKey(String ruleDescriptionContextKey) {
    this.ruleDescriptionContextKey = ruleDescriptionContextKey;
  }

  public String getCleanCodeAttribute() {
    return cleanCodeAttribute;
  }

  public void setCleanCodeAttribute(String cleanCodeAttribute) {
    this.cleanCodeAttribute = cleanCodeAttribute;
  }

  public String getCleanCodeAttributeCategory() {
    return cleanCodeAttributeCategory;
  }

  public void setCleanCodeAttributeCategory(String cleanCodeAttributeCategory) {
    this.cleanCodeAttributeCategory = cleanCodeAttributeCategory;
  }

  public List<Impact> getImpacts() {
    return impacts;
  }

  public void setImpacts(List<Impact> impacts) {
    this.impacts = impacts;
  }

  public static class Impact {
    String softwareQuality;
    String severity;

    public String getSoftwareQuality() {
      return softwareQuality;
    }

    public void setSoftwareQuality(String softwareQuality) {
      this.softwareQuality = softwareQuality;
    }

    public String getSeverity() {
      return severity;
    }

    public void setSeverity(String severity) {
      this.severity = severity;
    }
  }
}
