/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.checkstyle;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.checkstyle.CheckstyleSeverityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleProfileExporter
extends ProfileExporter {
    static final String DOCTYPE_DECLARATION = "<!DOCTYPE module PUBLIC \"-//Puppy Crawl//DTD Check Configuration 1.2//EN\" \"http://www.puppycrawl.com/dtds/configuration_1_2.dtd\">";
    private Configuration conf;

    public CheckstyleProfileExporter(Configuration conf) {
        super("checkstyle", "Checkstyle");
        this.conf = conf;
        this.setSupportedLanguages(new String[]{"java"});
        this.setMimeType("application/xml");
    }

    CheckstyleProfileExporter() {
        this((Configuration)new BaseConfiguration());
    }

    public void exportProfile(RulesProfile profile, Writer writer) {
        try {
            ListMultimap<String, ActiveRule> activeRulesByConfigKey = CheckstyleProfileExporter.arrangeByConfigKey(profile.getActiveRulesByRepository("checkstyle"));
            this.generateXML(writer, activeRulesByConfigKey);
        }
        catch (IOException e) {
            throw new SonarException("Fail to export the profile " + profile, (Throwable)e);
        }
    }

    private void generateXML(Writer writer, ListMultimap<String, ActiveRule> activeRulesByConfigKey) throws IOException {
        this.appendXmlHeader(writer);
        this.appendCustomFilters(writer);
        this.appendCheckerModules(writer, activeRulesByConfigKey);
        this.appendTreeWalker(writer, activeRulesByConfigKey);
        this.appendXmlFooter(writer);
    }

    private void appendXmlHeader(Writer writer) throws IOException {
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE module PUBLIC \"-//Puppy Crawl//DTD Check Configuration 1.2//EN\" \"http://www.puppycrawl.com/dtds/configuration_1_2.dtd\"><!-- Generated by Sonar --><module name=\"Checker\">");
    }

    private void appendCustomFilters(Writer writer) throws IOException {
        String filtersXML = this.conf.getString("sonar.checkstyle.filters", "<module name=\"SuppressionCommentFilter\"/>");
        if (StringUtils.isNotBlank((String)filtersXML)) {
            writer.append(filtersXML);
        }
    }

    private void appendCheckerModules(Writer writer, ListMultimap<String, ActiveRule> activeRulesByConfigKey) throws IOException {
        for (String configKey : activeRulesByConfigKey.keySet()) {
            if (CheckstyleProfileExporter.isInTreeWalker(configKey)) continue;
            List activeRules = activeRulesByConfigKey.get((Object)configKey);
            for (ActiveRule activeRule : activeRules) {
                this.appendModule(writer, activeRule);
            }
        }
    }

    private void appendTreeWalker(Writer writer, ListMultimap<String, ActiveRule> activeRulesByConfigKey) throws IOException {
        writer.append("<module name=\"TreeWalker\">");
        writer.append("<module name=\"FileContentsHolder\"/> ");
        for (String configKey : activeRulesByConfigKey.keySet()) {
            if (!CheckstyleProfileExporter.isInTreeWalker(configKey)) continue;
            List activeRules = activeRulesByConfigKey.get((Object)configKey);
            for (ActiveRule activeRule : activeRules) {
                this.appendModule(writer, activeRule);
            }
        }
        writer.append("</module>");
    }

    private void appendXmlFooter(Writer writer) throws IOException {
        writer.append("</module>");
    }

    static boolean isInTreeWalker(String configKey) {
        return StringUtils.startsWithIgnoreCase((String)configKey, (String)"Checker/TreeWalker/");
    }

    private static ListMultimap<String, ActiveRule> arrangeByConfigKey(List<ActiveRule> activeRules) {
        ArrayListMultimap result = ArrayListMultimap.create();
        if (activeRules != null) {
            for (ActiveRule activeRule : activeRules) {
                result.put((Object)activeRule.getConfigKey(), (Object)activeRule);
            }
        }
        return result;
    }

    private void appendModule(Writer writer, ActiveRule activeRule) throws IOException {
        String moduleName = StringUtils.substringAfterLast((String)activeRule.getConfigKey(), (String)"/");
        writer.append("<module name=\"");
        StringEscapeUtils.escapeXml((Writer)writer, (String)moduleName);
        writer.append("\">");
        if (activeRule.getRule().getParent() != null) {
            this.appendModuleProperty(writer, "id", activeRule.getRuleKey());
        }
        this.appendModuleProperty(writer, "severity", CheckstyleSeverityUtils.toSeverity(activeRule.getSeverity()));
        this.appendRuleParameters(writer, activeRule);
        writer.append("</module>");
    }

    private void appendRuleParameters(Writer writer, ActiveRule activeRule) throws IOException {
        for (RuleParam ruleParam : activeRule.getRule().getParams()) {
            String value = activeRule.getParameter(ruleParam.getKey());
            if (!StringUtils.isNotBlank((String)value)) continue;
            this.appendModuleProperty(writer, ruleParam.getKey(), value);
        }
    }

    private void appendModuleProperty(Writer writer, String propertyKey, String propertyValue) throws IOException {
        if (StringUtils.isNotBlank((String)propertyValue)) {
            writer.append("<property name=\"");
            StringEscapeUtils.escapeXml((Writer)writer, (String)propertyKey);
            writer.append("\" value=\"");
            StringEscapeUtils.escapeXml((Writer)writer, (String)propertyValue);
            writer.append("\"/>");
        }
    }
}

