/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.process.Terminable;

public class ProcessUtils {
    private ProcessUtils() {
    }

    public static boolean isAlive(@Nullable Process process) {
        if (process == null) {
            return false;
        }
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public static void destroyQuietly(@Nullable Process process) {
        if (process != null && ProcessUtils.isAlive(process)) {
            try {
                process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addSelfShutdownHook(final Terminable terminable) {
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                terminable.terminate();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void closeStreams(@Nullable Process process) {
        if (process != null) {
            IOUtils.closeQuietly(process.getInputStream());
            IOUtils.closeQuietly(process.getOutputStream());
            IOUtils.closeQuietly(process.getErrorStream());
        }
    }
}

