/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import javax.annotation.Nullable;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.process.Cipher;

final class AesCipher
extends Cipher {
    public static final int KEY_SIZE_IN_BITS = 128;
    private static final String CRYPTO_KEY = "AES";
    static final String ENCRYPTION_SECRET_KEY_PATH = "sonar.secretKeyPath";
    private String pathToSecretKey;

    AesCipher(@Nullable String pathToSecretKey) {
        this.pathToSecretKey = pathToSecretKey;
    }

    @Override
    String encrypt(String clearText) {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(CRYPTO_KEY);
            cipher.init(1, this.loadSecretFile());
            return new String(Base64.encodeBase64(cipher.doFinal(clearText.getBytes("UTF-8"))));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    String decrypt(String encryptedText) {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(CRYPTO_KEY);
            cipher.init(2, this.loadSecretFile());
            byte[] cipherData = cipher.doFinal(Base64.decodeBase64(StringUtils.trim(encryptedText)));
            return new String(cipherData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    boolean hasSecretKey() {
        String path = this.getPathToSecretKey();
        if (StringUtils.isNotBlank(path)) {
            File file = new File(path);
            return file.exists() && file.isFile();
        }
        return false;
    }

    private Key loadSecretFile() throws IOException {
        String path = this.getPathToSecretKey();
        return this.loadSecretFileFromFile(path);
    }

    Key loadSecretFileFromFile(@Nullable String path) throws IOException {
        if (StringUtils.isBlank(path)) {
            throw new IllegalStateException("Secret key not found. Please set the property sonar.secretKeyPath");
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalStateException("The property sonar.secretKeyPath does not link to a valid file: " + path);
        }
        String s = FileUtils.readFileToString(file);
        if (StringUtils.isBlank(s)) {
            throw new IllegalStateException("No secret key in the file: " + path);
        }
        return new SecretKeySpec(Base64.decodeBase64(StringUtils.trim(s)), CRYPTO_KEY);
    }

    String generateRandomSecretKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(CRYPTO_KEY);
            keyGen.init(128, new SecureRandom());
            SecretKey secretKey = keyGen.generateKey();
            return new String(Base64.encodeBase64(secretKey.getEncoded()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to generate secret key", e);
        }
    }

    String getPathToSecretKey() {
        if (StringUtils.isBlank(this.pathToSecretKey)) {
            this.pathToSecretKey = new File(FileUtils.getUserDirectoryPath(), ".sonar/sonar-secret.txt").getPath();
        }
        return this.pathToSecretKey;
    }

    public void setPathToSecretKey(@Nullable String pathToSecretKey) {
        this.pathToSecretKey = pathToSecretKey;
    }
}

